(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21759,        801]
NotebookOptionsPosition[     16750,        632]
NotebookOutlinePosition[     18327,        674]
CellTagsIndexPosition[     18242,        669]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Scaled" :> Documentation`HelpLookup["paclet:ref/Scaled"], 
          "ImageScaled" :> Documentation`HelpLookup["paclet:ref/ImageScaled"],
           "AbsolutePointSize" :> 
          Documentation`HelpLookup["paclet:ref/AbsolutePointSize"], 
          "AbsoluteThickness" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteThickness"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Scaled\"\>", 
       2->"\<\"ImageScaled\"\>", 3->"\<\"AbsolutePointSize\"\>", 
       4->"\<\"AbsoluteThickness\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Coordinates" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsCoordinates"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Coordinates\"\>", 
       2->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Offset", "ObjectName",
 CellID->9974],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Offset",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Offset"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["dx", "TI"], ",", 
          StyleBox["dy", "TI"]}], "}"}], ",", 
        StyleBox["position", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the position of a graphical object obtained by \
starting at the specified position and then moving by absolute offset ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["dx", "TI"], ",", 
        StyleBox["dy", "TI"]}], "}"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27296]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " can be used to specify offsets in any two\[Hyphen]dimensional graphics \
primitive. "
}], "Notes",
 CellID->3764],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["position", "TI"]], "InlineFormula"],
 " can be either ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageScaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageScaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18223],

Cell[TextData[{
 "The offset is measured in units of printer\[CloseCurlyQuote]s points, equal \
before magnification to ",
 Cell[BoxData[
  FractionBox["1", "72"]], "InlineFormula"],
 " of an inch. "
}], "Notes",
 CellID->6607],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Offset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Offset"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["dx", "TI"], ",", 
     StyleBox["dy", "TI"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " can be used to specify an absolute radius in a ",
 Cell[BoxData[
  ButtonBox["Circle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Circle"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Disk",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Disk"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->12074]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1129349],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->233680018],

Cell["Offset coordinates by printer's points:", "ExampleText",
 CellID->4392426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"Offset", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
     RowBox[{"Offset", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", 
         RowBox[{"-", "20"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93509806],

Cell[BoxData[
 GraphicsBox[
  RectangleBox[Offset[{10, 20}, {0, 0}], Offset[{-10, -20}, {1, 1}]],
  Frame->True]], "Output",
 ImageSize->{154, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->206714456]
}, Open  ]],

Cell["Set radii by printer's points:", "ExampleText",
 CellID->557836422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Offset", "[", 
      RowBox[{"{", 
       RowBox[{"10", ",", "40"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26768260],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}, Offset[{10., 40.}, {0., 0.}]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->121481068]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17862904],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Offset Positions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->162414536],

Cell["Offset the center by 10 printer's points:", "ExampleText",
 CellID->54476779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"Offset", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", ".5"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41958467],

Cell[BoxData[
 GraphicsBox[CircleBox[Offset[{10, 10}, {0, 0}], 0.5],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->276810082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->768636251],

Cell["Offset scaled coordinates by 10 printer's points:", "ExampleText",
 CellID->685310657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"Offset", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}], ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", ".5"}], "}"}], "]"}]}], "]"}], ",", ".5"}], "]"}], 
   ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316773887],

Cell[BoxData[
 GraphicsBox[CircleBox[Offset[{10, 10}, Scaled[{0, 0.5}]], 0.5],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->139275070]
}, Open  ]],

Cell["Offset image-scaled coordinates by 10 printer's points:", "ExampleText",
 CellID->12716965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"Offset", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", ".5"}], "}"}], "]"}]}], "]"}], ",", ".5"}], "]"}], 
   ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->335934519],

Cell[BoxData[
 GraphicsBox[CircleBox[Offset[{10, 10}, ImageScaled[{0, 0.5}]], 0.5],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->63520242]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Offset Sizes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->116795533],

Cell["Set radii by printer's points:", "ExampleText",
 CellID->38952147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Offset", "[", 
      RowBox[{"{", 
       RowBox[{"10", ",", "40"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10415067],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, Offset[{10., 40.}, {0., 0.}]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->288405874]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->571968431],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " can be used to specify offsets by scaled coordinates:"
}], "ExampleText",
 CellID->604099474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"Scaled", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".25"}], ",", ".25"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55503727],

Cell[BoxData[
 GraphicsBox[CircleBox[Scaled[{-0.25, 0.25}, {0, 0}]],
  Frame->True]], "Output",
 ImageSize->{184, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42547797]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191891932],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " can be used to specify offsets by image-scaled coordinates:"
}], "ExampleText",
 CellID->286310666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"ImageScaled", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".25"}], ",", ".25"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->510519007],

Cell[BoxData[
 GraphicsBox[CircleBox[ImageScaled[{-0.25, 0.25}, {0, 0}]],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->61028338]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17103],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageScaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageScaled"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsolutePointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsolutePointSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteThickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteThickness"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->24621471],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "MoreAbout",
 CellID->61595700],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->155099487]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Offset - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 29.7983362}", "context" -> "System`", 
    "keywords" -> {
     "drawing symbols", "icons in graphics", "matching size of text", 
      "moving graphics object", "plotting symbols", 
      "relative positions of graphics objects", "shifting graphics objects", 
      "tweaking graphics", "absolute sizes", "absolute coordinates", 
      "glyphs in graphics"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Offset[{dx, dy}, position] gives the position of a graphical object \
obtained by starting at the specified position and then moving by absolute \
offset {dx, dy}. ", "synonyms" -> {}, "title" -> "Offset", "type" -> "Symbol",
     "uri" -> "ref/Offset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5712, 200, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1129349]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18101, 662}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1700, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2323, 66, 43, 1, 70, "ObjectName",
 CellID->9974],
Cell[2369, 69, 874, 27, 70, "Usage",
 CellID->27296]
}, Open  ]],
Cell[CellGroupData[{
Cell[3280, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3758, 118, 247, 8, 70, "Notes",
 CellID->3764],
Cell[4008, 128, 824, 33, 70, "Notes",
 CellID->18223],
Cell[4835, 163, 227, 7, 70, "Notes",
 CellID->6607],
Cell[5065, 172, 610, 23, 70, "Notes",
 CellID->12074]
}, Closed]],
Cell[CellGroupData[{
Cell[5712, 200, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1129349],
Cell[CellGroupData[{
Cell[6095, 214, 148, 5, 70, "ExampleSection",
 CellID->233680018],
Cell[6246, 221, 80, 1, 70, "ExampleText",
 CellID->4392426],
Cell[CellGroupData[{
Cell[6351, 226, 633, 21, 47, "Input",
 CellID->93509806],
Cell[6987, 249, 308, 9, 169, "Output",
 CellID->206714456]
}, Open  ]],
Cell[7310, 261, 73, 1, 70, "ExampleText",
 CellID->557836422],
Cell[CellGroupData[{
Cell[7408, 266, 366, 12, 70, "Input",
 CellID->26768260],
Cell[7777, 280, 284, 8, 163, "Output",
 CellID->121481068]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8110, 294, 219, 7, 70, "ExampleSection",
 CellID->17862904],
Cell[CellGroupData[{
Cell[8354, 305, 237, 7, 70, "ExampleSubsection",
 CellID->162414536],
Cell[8594, 314, 83, 1, 70, "ExampleText",
 CellID->54476779],
Cell[CellGroupData[{
Cell[8702, 319, 402, 13, 70, "Input",
 CellID->41958467],
Cell[9107, 334, 279, 8, 163, "Output",
 CellID->276810082]
}, Open  ]],
Cell[9401, 345, 125, 3, 70, "ExampleDelimiter",
 CellID->768636251],
Cell[9529, 350, 92, 1, 70, "ExampleText",
 CellID->685310657],
Cell[CellGroupData[{
Cell[9646, 355, 448, 15, 70, "Input",
 CellID->316773887],
Cell[10097, 372, 289, 8, 162, "Output",
 CellID->139275070]
}, Open  ]],
Cell[10401, 383, 97, 1, 70, "ExampleText",
 CellID->12716965],
Cell[CellGroupData[{
Cell[10523, 388, 453, 15, 70, "Input",
 CellID->335934519],
Cell[10979, 405, 293, 8, 162, "Output",
 CellID->63520242]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11321, 419, 233, 7, 70, "ExampleSubsection",
 CellID->116795533],
Cell[11557, 428, 72, 1, 70, "ExampleText",
 CellID->38952147],
Cell[CellGroupData[{
Cell[11654, 433, 368, 12, 70, "Input",
 CellID->10415067],
Cell[12025, 447, 286, 8, 163, "Output",
 CellID->288405874]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[12372, 462, 237, 7, 70, "ExampleSection",
 CellID->571968431],
Cell[12612, 471, 227, 7, 70, "ExampleText",
 CellID->604099474],
Cell[CellGroupData[{
Cell[12864, 482, 428, 14, 70, "Input",
 CellID->55503727],
Cell[13295, 498, 226, 7, 212, "Output",
 CellID->42547797]
}, Open  ]],
Cell[13536, 508, 125, 3, 70, "ExampleDelimiter",
 CellID->191891932],
Cell[13664, 513, 243, 7, 70, "ExampleText",
 CellID->286310666],
Cell[CellGroupData[{
Cell[13932, 524, 434, 14, 70, "Input",
 CellID->510519007],
Cell[14369, 540, 283, 8, 162, "Output",
 CellID->61028338]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14713, 555, 311, 9, 70, "SeeAlsoSection",
 CellID->17103],
Cell[15027, 566, 978, 35, 70, "SeeAlso",
 CellID->7245]
}, Open  ]],
Cell[CellGroupData[{
Cell[16042, 606, 318, 9, 70, "MoreAboutSection",
 CellID->24621471],
Cell[16363, 617, 150, 3, 70, "MoreAbout",
 CellID->61595700],
Cell[16516, 622, 162, 3, 70, "MoreAbout",
 CellID->155099487]
}, Open  ]],
Cell[16693, 628, 27, 0, 70, "History"],
Cell[16723, 630, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

