(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14659,        519]
NotebookOptionsPosition[     11155,        405]
NotebookOutlinePosition[     12590,        444]
CellTagsIndexPosition[     12505,        439]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Warnings and Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/WarningsAndMessages"], 
          "Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/Messages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Warnings and Messages\"\>", 
       2->"\<\"Messages\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Off" :> Documentation`HelpLookup["paclet:ref/Off"], 
          "TracePrint" :> 
          Documentation`HelpLookup["paclet:ref/TracePrint"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Off\"\>", 
       2->"\<\"TracePrint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Messages" :> Documentation`HelpLookup["paclet:guide/Messages"],
           "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Messages\"\>", 
       2->"\<\"Session Customization\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["On", "ObjectName",
 CellID->3464],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["On",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/On"], "[", 
       RowBox[{
        StyleBox["symbol", "TI"], "::", 
        StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]switches on a message, so that it can be printed. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["On",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/On"], "[", 
       StyleBox["s", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]switches on tracing for the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["On",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/On"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]switches on several messages. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["On",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/On"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]switches on tracing for all symbols. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->31349]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Some messages for built-in functions are off by default, and must \
explicitly be switched on using ",
 Cell[BoxData[
  ButtonBox["On",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/On"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6311078],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   RowBox[{
    ButtonBox["General",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/General"], "::", 
    StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
 " switches on all messages derived from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["General",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/General"], "::", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->398666679],

Cell["\<\
When tracing is switched on, each evaluation of a symbol, on its own or as a \
function, is printed, together with the result. \
\>", "Notes",
 CellID->25569],

Cell[TextData[{
 "Note that the tracing information is printed when a function ",
 Cell[BoxData[
  StyleBox["returns", "TI"]], "InlineFormula"],
 ". As a result, traces of recursive functions appear in the opposite order \
from their calls. "
}], "Notes",
 CellID->2989],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   RowBox[{
    StyleBox["s", "TI"], "::", "trace"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18954],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   RowBox[{
    StyleBox["s", "TI"], "::", "trace"}], "]"}]], "InlineFormula"],
 " for all symbols. "
}], "Notes",
 CellID->2017]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->403126019],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->27345412],

Cell["\<\
Turn on a message that is issued whenever a new symbol is created:\
\>", "ExampleText",
 CellID->814871169],

Cell[BoxData[
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "newsym"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14903934],

Cell["Now when a new symbol is created the message is issued:", "ExampleText",
 CellID->290434310],

Cell[CellGroupData[{

Cell[BoxData["a"], "Input",
 CellLabel->"In[2]:=",
 CellID->281839185],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"newsym\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(a\\) is new. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/newsym\\\", ButtonNote -> \
\\\"General::newsym\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->507917771],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126319001]
}, Open  ]],

Cell["This turns the message back off:", "ExampleText",
 CellID->631392020],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "newsym"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->687305965]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29072],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TracePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TracePrint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26739]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21763],

Cell[TextData[ButtonBox["Warnings and Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WarningsAndMessages"]], "Tutorials",
 CellID->17753],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Messages"]], "Tutorials",
 CellID->27158]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->979980],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Messages"]], "MoreAbout",
 CellID->208125404],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->7607361],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->85631216]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"On - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 33.8921910}", "context" -> "System`", 
    "keywords" -> {
     "tracing functions", "message control", "toggle messages", 
      "message handling", "errors", "warnings", "diagnostics"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "On[symbol::tag] switches on a message, so that it can be printed. On[s] \
switches on tracing for the symbol s. On[m_1, m_2, ...] switches on several \
messages. On[] switches on tracing for all symbols. ", "synonyms" -> {}, 
    "title" -> "On", "type" -> "Symbol", "uri" -> "ref/On"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7123, 246, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->403126019]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12362, 432}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2188, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2811, 80, 39, 1, 70, "ObjectName",
 CellID->3464],
Cell[2853, 83, 1638, 53, 70, "Usage",
 CellID->31349]
}, Open  ]],
Cell[CellGroupData[{
Cell[4528, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5006, 158, 263, 9, 70, "Notes",
 CellID->6311078],
Cell[5272, 169, 536, 20, 70, "Notes",
 CellID->398666679],
Cell[5811, 191, 168, 4, 70, "Notes",
 CellID->25569],
Cell[5982, 197, 270, 7, 70, "Notes",
 CellID->2989],
Cell[6255, 206, 419, 17, 70, "Notes",
 CellID->18954],
Cell[6677, 225, 409, 16, 70, "Notes",
 CellID->2017]
}, Closed]],
Cell[CellGroupData[{
Cell[7123, 246, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->403126019],
Cell[CellGroupData[{
Cell[7508, 260, 147, 5, 70, "ExampleSection",
 CellID->27345412],
Cell[7658, 267, 117, 3, 70, "ExampleText",
 CellID->814871169],
Cell[7778, 272, 132, 4, 70, "Input",
 CellID->14903934],
Cell[7913, 278, 98, 1, 70, "ExampleText",
 CellID->290434310],
Cell[CellGroupData[{
Cell[8036, 283, 70, 2, 70, "Input",
 CellID->281839185],
Cell[8109, 287, 355, 7, 70, "Message",
 CellID->507917771],
Cell[8467, 296, 158, 5, 36, "Output",
 CellID->126319001]
}, Open  ]],
Cell[8640, 304, 75, 1, 70, "ExampleText",
 CellID->631392020],
Cell[8718, 307, 134, 4, 70, "Input",
 CellID->687305965]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8901, 317, 311, 9, 70, "SeeAlsoSection",
 CellID->29072],
Cell[9215, 328, 445, 17, 70, "SeeAlso",
 CellID->26739]
}, Open  ]],
Cell[CellGroupData[{
Cell[9697, 350, 314, 9, 70, "TutorialsSection",
 CellID->21763],
Cell[10014, 361, 151, 3, 70, "Tutorials",
 CellID->17753],
Cell[10168, 366, 127, 3, 70, "Tutorials",
 CellID->27158]
}, Open  ]],
Cell[CellGroupData[{
Cell[10332, 374, 316, 9, 70, "MoreAboutSection",
 CellID->979980],
Cell[10651, 385, 128, 3, 70, "MoreAbout",
 CellID->208125404],
Cell[10782, 390, 151, 3, 70, "MoreAbout",
 CellID->7607361],
Cell[10936, 395, 147, 3, 70, "MoreAbout",
 CellID->85631216]
}, Open  ]],
Cell[11098, 401, 27, 0, 70, "History"],
Cell[11128, 403, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

