(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17238,        635]
NotebookOptionsPosition[     13272,        500]
NotebookOutlinePosition[     14656,        538]
CellTagsIndexPosition[     14571,        533]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flat and Orderless Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FlatAndOrderlessFunctions"], "Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Flat and Orderless Functions\"\>", 
       2->"\<\"Attributes\"\>", 
       3->"\<\"Patterns and Transformation Rules\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flat" :> Documentation`HelpLookup["paclet:ref/Flat"], "Nest" :> 
          Documentation`HelpLookup["paclet:ref/Nest"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Flat\"\>", 
       2->"\<\"Nest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], "Patterns" :> 
          Documentation`HelpLookup["paclet:guide/Patterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OneIdentity", "ObjectName",
 CellID->22815],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["OneIdentity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
     "\[LineSeparator]is an attribute that can be assigned to a symbol ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to indicate that ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        StyleBox["f", "TI"], "[", 
        StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
     ", etc. are all equivalent to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " for the purpose of pattern matching. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->460]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 " has an effect only if ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7229],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " have the attribute ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4466],

Cell[TextData[{
 "The fact that ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 " allows a pattern like ",
 Cell[BoxData[
  RowBox[{"n_.", "x_"}]], "InlineFormula"],
 " to match ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7783]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->141682898],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->112703467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Times", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35087959],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
   "Orderless", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->362860654]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Times", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->366815654],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->518920044]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27543],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 " allows defaults to apply to expressions that do not involve ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " at all:"
}], "ExampleText",
 CellID->11210130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "Times", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56266636],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Times", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{
       "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", 
        ",", "Orderless", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Default", "[", "Times", "]"}], ":=", "1"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[Times],
  Editable->False]], "Output",
 ImageSize->{599, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164337202]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"2", "x"}], ",", 
    RowBox[{"-", "x"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"n_.", "x"}], ")"}], "\[RuleDelayed]", 
   RowBox[{"y", "^", "n"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->742163413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", ",", 
   SuperscriptBox["y", "2"], ",", 
   FractionBox["1", "y"]}], "}"}]], "Output",
 ImageSize->{71, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->93445406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14196747],

Cell[TextData[{
 "Pattern matching for flat functions requires the ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 " attribute as well:"
}], "ExampleText",
 CellID->15688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Attributes", "[", "g", "]"}], "=", 
  RowBox[{"{", 
   RowBox[{"Flat", ",", "OneIdentity"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270077799],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Flat", ",", "OneIdentity"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->418870304]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MatchQ", "[", 
    RowBox[{
     RowBox[{"g", "[", "1", "]"}], ",", 
     RowBox[{"g", "[", "_Integer", "]"}]}], "]"}], ",", 
   RowBox[{"MatchQ", "[", 
    RowBox[{
     RowBox[{"g", "[", "1", "]"}], ",", 
     RowBox[{"g", "[", "__Integer", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40086246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->471358796]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->689],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Flat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flat"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17208],

Cell[TextData[ButtonBox["Flat and Orderless Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FlatAndOrderlessFunctions"]], "Tutorials",
 CellID->32105],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->29150],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->34431378],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->103141924],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->120137009]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OneIdentity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 32.1265208}", "context" -> "System`", 
    "keywords" -> {
     "idempotence", "idempotent", "one-identity", "attribute", "defaults"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "OneIdentity is an attribute that can be assigned to a symbol f to \
indicate that f[x], f[f[x]], etc. are all equivalent to x for the purpose of \
pattern matching. ", "synonyms" -> {"one identity"}, "title" -> "OneIdentity",
     "type" -> "Symbol", "uri" -> "ref/OneIdentity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5747, 196, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->141682898]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14428, 526}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2213, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2836, 80, 49, 1, 70, "ObjectName",
 CellID->22815],
Cell[2888, 83, 992, 31, 70, "Usage",
 CellID->460]
}, Open  ]],
Cell[CellGroupData[{
Cell[3917, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4395, 136, 390, 15, 70, "Notes",
 CellID->7229],
Cell[4788, 153, 453, 18, 70, "Notes",
 CellID->4466],
Cell[5244, 173, 466, 18, 70, "Notes",
 CellID->7783]
}, Closed]],
Cell[CellGroupData[{
Cell[5747, 196, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->141682898],
Cell[CellGroupData[{
Cell[6132, 210, 148, 5, 70, "ExampleSection",
 CellID->112703467],
Cell[CellGroupData[{
Cell[6305, 219, 109, 3, 28, "Input",
 CellID->35087959],
Cell[6417, 224, 301, 9, 36, "Output",
 CellID->362860654]
}, Open  ]],
Cell[CellGroupData[{
Cell[6755, 238, 101, 3, 28, "Input",
 CellID->366815654],
Cell[6859, 243, 158, 5, 36, "Output",
 CellID->518920044]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7066, 254, 233, 7, 70, "ExampleSection",
 CellID->27543],
Cell[7302, 263, 369, 12, 70, "ExampleText",
 CellID->11210130],
Cell[CellGroupData[{
Cell[7696, 279, 109, 3, 70, "Input",
 CellID->56266636],
Cell[7808, 284, 1087, 33, 66, "Output",
 CellID->164337202]
}, Open  ]],
Cell[CellGroupData[{
Cell[8932, 322, 296, 11, 70, "Input",
 CellID->742163413],
Cell[9231, 335, 259, 9, 53, "Output",
 CellID->93445406]
}, Open  ]],
Cell[9505, 347, 124, 3, 70, "ExampleDelimiter",
 CellID->14196747],
Cell[9632, 352, 252, 8, 70, "ExampleText",
 CellID->15688],
Cell[CellGroupData[{
Cell[9909, 364, 189, 6, 70, "Input",
 CellID->270077799],
Cell[10101, 372, 217, 7, 36, "Output",
 CellID->418870304]
}, Open  ]],
Cell[CellGroupData[{
Cell[10355, 384, 371, 12, 70, "Input",
 CellID->40086246],
Cell[10729, 398, 209, 7, 36, "Output",
 CellID->471358796]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10999, 412, 309, 9, 70, "SeeAlsoSection",
 CellID->689],
Cell[11311, 423, 435, 17, 70, "SeeAlso",
 CellID->16869]
}, Open  ]],
Cell[CellGroupData[{
Cell[11783, 445, 314, 9, 70, "TutorialsSection",
 CellID->17208],
Cell[12100, 456, 164, 3, 70, "Tutorials",
 CellID->32105],
Cell[12267, 461, 131, 3, 70, "Tutorials",
 CellID->29150],
Cell[12401, 466, 178, 3, 70, "Tutorials",
 CellID->244552785]
}, Open  ]],
Cell[CellGroupData[{
Cell[12616, 474, 318, 9, 70, "MoreAboutSection",
 CellID->34431378],
Cell[12937, 485, 132, 3, 70, "MoreAbout",
 CellID->103141924],
Cell[13072, 490, 128, 3, 70, "MoreAbout",
 CellID->120137009]
}, Open  ]],
Cell[13215, 496, 27, 0, 70, "History"],
Cell[13245, 498, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

