(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    598608,      10903]
NotebookOptionsPosition[    588306,      10553]
NotebookOutlinePosition[    589682,      10590]
CellTagsIndexPosition[    589594,      10585]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RGBColor" :> Documentation`HelpLookup["paclet:ref/RGBColor"], 
          "GrayLevel" :> Documentation`HelpLookup["paclet:ref/GrayLevel"], 
          "Hue" :> Documentation`HelpLookup["paclet:ref/Hue"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "Specularity" :> 
          Documentation`HelpLookup["paclet:ref/Specularity"], "Glow" :> 
          Documentation`HelpLookup["paclet:ref/Glow"], "WindowOpacity" :> 
          Documentation`HelpLookup["paclet:ref/WindowOpacity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RGBColor\"\>", 
       2->"\<\"GrayLevel\"\>", 3->"\<\"Hue\"\>", 4->"\<\"Blend\"\>", 
       5->"\<\"Specularity\"\>", 6->"\<\"Glow\"\>", 
       7->"\<\"WindowOpacity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Colors\"\>", 
       2->"\<\"Graphics Directives\"\>", 
       3->"\<\"Graphics Options & Styling\"\>", 
       4->"\<\"Symbolic Graphics Language\"\>", 
       5->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       6->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Opacity", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Opacity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Opacity"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that graphical \
objects which follow are to be displayed, if possible, with opacity ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Opacity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Opacity"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["color", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses the specified color with opacity ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->32555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Opacity runs from 0 to 1, with 0 representing perfect transparency. \
\>", "Notes",
 CellID->32557],

Cell[TextData[{
 "If an opacity ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " object with color ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " is placed in front of an object with color ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ", the resulting color will be the blend ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], 
   SubscriptBox[
    StyleBox["c", "TI"], 
    StyleBox["1", "TR"]], "+", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     StyleBox["a", "TI"]}], ")"}], 
   SubscriptBox[
    StyleBox["c", "TI"], 
    StyleBox["2", "TR"]]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15334],

Cell[TextData[{
 "If red and blue with opacity 0.5 are combined, the result is purple\
\[LongDash]not black, as it would be with physical monochromatic filters. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->618362617]
}], "Notes",
 CellID->14317],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " works in both 2D and 3D graphics. "
}], "Notes",
 CellID->13300],

Cell["\<\
It may take significantly longer to render 3D graphics that involve \
transparent surfaces. \
\>", "Notes",
 CellID->7040],

Cell["\<\
Graphics that involve transparency may need to be printed as \
high\[Hyphen]resolution bitmaps. \
\>", "Notes",
 CellID->3623],

Cell[TextData[{
 "On many computer systems, objects with opacity ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " will appear completely transparent if ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is too small. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->22046]
}], "Notes",
 CellID->17853]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->763136768],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->852183444],

Cell["Make a 50% transparent sphere:", "ExampleText",
 CellID->25574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30161],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.5], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{170, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{166., Automatic}},
 CellLabel->"Out[1]=",
 CellID->29423,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26018],

Cell["Plot a see-through surface:", "ExampleText",
 CellID->1875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"Opacity", "[", "0.5", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19734],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{195, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{195., Automatic}},
 CellLabel->"Out[1]=",
 CellID->34444979]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97342231],

Cell["Overlapping translucent 2D disks:", "ExampleText",
 CellID->276525671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Red", ",", 
    RowBox[{"Disk", "[", "]"}], ",", "Green", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4531],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0, 0], Opacity[0.5], DiskBox[{0, 0}], 
   {RGBColor[0, 1, 0], DiskBox[{1, 0}]}}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->681735620]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->138890108],

Cell["Larger opacity makes surfaces more opaque:", "ExampleText",
 CellID->18483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", "a", "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1", ",", 
     RowBox[{"1", "/", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Opacity[0], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmWtv00oQhl1fcm+dJrRN29CGlrbQA0IIDgchISQ+wCd+RBUigQQCcfj3
kXXOvuPxJa8ntWkidZPxvvt4vZ7Zy/TTze8vi+83v7/Ob2Yff938/PJ1/u/s
w49f7lKw5XneZ/f3beK53/+5X/L3PkkSL1gsFol8vFMU3jtXRu7iTKy3rvSd
Feh3evWNK9EwKhFcqYTXqu2Yta+0tgcrzO/ufpxI/QtlD2BFeb0y7ovmuTLi
WzTPVDMyNVPRPNF73aOR8Mk+FPW1Eg8aqa+UfUi1AdkTUV8oe9pIfa7qE6oN
yZaeejPtyYxqI7L3RX2i7PNG6mNlX1Bti+w9UR8q+1Ej9YGqr6m2Tba8PSlx
8QnVdsgei3qk7GeN1ENVP6faLtnia9629uQF1fbI3hV1X9mvGqm7qn5NtX2y
h6LuqPpNDbtQl+P1ofvuLZdLZrMdF61X4hnxPnbt+e0OyN4p2lfiFP41cQz2
7FsYt0QmfPa+o0lYpZfTliXNtpDYx/j+8IuZkKhlLYnjCGN/lpHct9WngUni
cUWr8xIJP2Pr3VVIbON+D4nku4Kf0KbxW4DPXhItMGg9k8YxhvorooUGTdpV
xoh9F2/jEdEiV7B/2TRWwa0eE61l0DomjZ/A34jGPnRNpLZBapuk3Ie0Jfep
Y5BaJknmmWA+n2tLHvmuMdukJCtqfGm9noZ+YWwwKXXWUgKisG91dfbBJZ4F
IpOK8YqIyv4vVGeas8OdiPAMVEtolT2jlg5PaRP9wohXVCPSePVYT+0QlecU
VLUbExEfPSLm891cPl7f2TxjpDR+d+hfn2in+RgWffwz4oCIx0oM6Mn7xlOH
a6nbRD1QaouoA6Ov66k7RB0rtXtnKt7QkKixUgcbUXeJ2ldq3JjKO2mMwIio
baWONqKOiZrFzt5G1HslKlzUd8VkI+Ie9RM07BZ3DN8MGlNgQ+I38Pjm1JFS
2eN7a6m894sNaqzUHlG7G1HxpKGOI69Hd6d2tK/sm82pQ/Kipe51INknqjUr
N6f6Sj0iqrWz8uupC/l4cuIlYvhHxMyLeJccrKWUTwrY8++seHfxxGdE9BsT
+0oMiSh9DHPisrrDtXmZn/CKzmtvPU1O1OrLvO7m+wNtXf+s2fmcV53LGtJW
hbSrJLmmFKaif+wBvLPMyKszT7bP43XsbkTEULb/jI03wmsdx1yV2NY+bifV
FRxE3jXxelAlZrvboUGEF9ad75RYnP2TIqvGOxfEiXWiq/KAQ7aLd1QPjJnJ
JpSvHCXV3d7MiFGQtpwJwqrnLTQbwZGAPSOftVoVCq9xyIR1iYS5bUi6qELC
28JMiCfi/TVyGyMihBUCn8owyjxbTF0xriXxuOOp+JyCNWCfdEGFlGWqJJ9I
BOxLOIvqVwjsE0diL2WzlFGOb6EUmbhcpffHOiS566js4fCHtB3PpJKjXYkG
zCXnq1fzu7LvcHb55Zp2cWJno/8u2UUfd0nFGe8sK5+qs+woq/5ZGS+u5Xug
J0Gu3lMmq5BTDXXO9SpPz6PzNCmf5ydUy9H8OEn/l5Hmz7LsM6sulJlmWNlH
eLaaKTPNUU+VyaqpMsULPc7TWxEIdfofkFNlsmqsdz4T1QOq5RkmVuaVqM+o
1lrJoP5L1Nn/F1jV0h5I1lzGrexpoTLEY71LV7YWmqn2vK3/AdSYR4Y=\
\>"]], ",", 
   Graphics3DBox[
    {Opacity[
      NCache[
       Rational[1, 3], 0.3333333333333333]], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Opacity[
      NCache[
       Rational[2, 3], 0.6666666666666666]], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Opacity[1], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVewdYXNeZNrGdst5dJ7vZ/bPJJpvkzyb/JvsfIWTJKrZlRbZlO/YFgSTL
qla5IKoQXSCBhAQI0XtH9N577733PsDQhzIwDMPU+z7/P3NBXnlQHPt5huGe
e745533PV06596OuWxvqm123Nrp5/TcfWV6/Y2h00+o3p8wtlbde/Z6Ghoa+
8s/03zSU1/9PecX+nQTwir6+/m+V/zU0TuyWNF5VXij/q27+hq15V/n9qvLO
q7sSO3ff3i394Gt3j+6WfqQqvbrTjKrRX7O1b+229Lqq9NpO7Y7Af7D1B3d/
/Y9/pV5r9/c/VpW+/1X9bh+/YmU0d9v45xcQqC5fUSv/gpUmu9L/8q2k/7Tb
//9Sq31VrfxzVvq/dtv++beS/sOu9L+r1b6mVv43Vvp3u0h+pVb7fbXyz1jp
376oo78p/R+7bf9vtdofqJXZUdD45W7bf/gbbe9I/2JX+r/+Rtv/ykr/bBfJ
n9Rqf6hWZrXH/kbVNvlW0j/dldZUq/2RWvmnrPRPdpFofSvpN3bbPqhW+3dq
ZdZGNf5+t+231GpfVyv/Eyv9d7ttH/3W0i/ePaJW/nu18k++1sfv2YavEJom
tAmhLQhtS2h7Qt8n9ENCO7PX6v3+g1qZ9dWdcfqaR7MR4afahD5L6MuE1ie0
GaGtCH2X0E6EdiG0O6G9CO1L6EBChxA6jNDhhI4gdCShgwi9x2K+od89kYL1
sZ9ThD5N6HPPuzdlu3cg9AO2e4/nfYeyXT4jdDyhEwmdTOhUQqcTOoPQaey1
8v4en/5HtfIb/4PmG6IM6yO/VuLSYYflIqGvE9qI0HcIbfd8WJ4S2ofFpRyQ
KELHEjqB0CksnGxNOncfnU/oQkIXE7pEky7ZT5fso4uUVYTe5f7jb4VMnQ/r
LUpgGr/QZofsK5uwZI1AOWRuhPYktB+hg1ktxbyIi6hAFWnSpVp0+Zt05Zt0
zQG69gBdp0W/Un9AOXjK66p9tArdT142jnvQqcdEla2/qkL32zOsNukXtKk0
1CeE9iZ0wHNVKocsSak7TTpLi87Togu1VLgqtejqN+m6g3TDIbr5CN16hG47
Rre/TXccozuO0O1HVOgateiiffSeEfyHl2JUj39vPMf4n0rlvgjT+jlMN9bg
d2AqNRvH2ppy+HI06fwDdPFBuvwwXXWYrjtMNxyjm9+h247THe/R3Sfonj/T
fSfp/vfpAeXnpApp33t019t04yH6jZdiVY+I6uV/eK7t3yodRI9V+CVC33yu
cDW4Yfv0ozT14zQNkjUNMvbfytl/q+DArZJDtyoO36o5alD/jkHzcYO2E/od
J+nuD+i+j+iBj+mhT+jhv9Cjn9Jjn9Ear4wrv1SxYfQTeugU3XV8D+q/fylq
9RF//TnqPyptVJdFrfSgG6wHWeyaqb4rueVJDP2JcQgxidpnGrffLOnN2+mH
buccMi84ZF5yxLzibfOa4+YNJ243n7zd/qFZ10emPZ+Y9H9qPEQZjZ42HNc1
4OjRk2fo6bM09xzNPasabeX3lB49rq2itcfzX45dPS7/6Ll1/F4J/HN2uK8R
2pDQ5sTAlhg5EhMXYvaU3PYld4KJRSSxit1nnaRlk/6mTfYh24IjtqXH7Crf
tas5Ydfwvm3LKdv2T2y7P7Pp07YePG01rGcxdvYO57z51Bdm3Asms5eM5i7f
Wriiv3iF9bhXFi8rPXD+Is39nJ7Q3Yv/9ZfiV4/6P3iO/w/arHV/QegviYE+
MTIlJtbk9j1y5xGxdCfWPsQmaJ9duKZ9jKZDota91EP3sw475h9zLH7XqeLE
g5r3nepPOTV/4tT+mVO3jmOfnuPg2fsj5x3GL9hPXrrLvWI7+6XN/DXLxRt3
lm7eXqZNV/SNlBBeWdVX2s/KTZp3nV64Sk+dp9U5/N1LOajPfaqo8pqKAzmt
0oHBFWJ8k5gZE3MLYnmXWD8gdm7E3kvznr+WY+iBB1FvPow/+Cjl0OPMoy65
77oUnXAte9+1+pRb/SduzZ+5tem4dum59p1zHfzCZeTi4/Erjya/dOZefzB3
02lB//7SLYdlQ7tVYxu+idW66R0lhA1TY4HpLYEpvW5MrxnSy/o0V6kW9Tnt
5TzUpV55zkOTIgZ6xPgCMbtG7twiVreJrQ2xv0/uPyZOT4mzr+bjYC3XiINu
sW+5Jx15mn7MI+ddz4I/e5V+6FX1sXfdZ95NOt5tet6d57x7v/AavOQ1etVr
/Jrn5M2nXH33uVtPFo3ceCYuK2bOa7cfbNxx3LRw2LS0U6IQWd0RWZmJrEy2
LA2EFrTAnF41pudu7GXD+u+eeZz1/f9ZKTz36QMU0aeIIUVMzxDzS8TqJrEz
IfcsiZM9cX5AHrsRN2/yNFDTI+yAV/Qh74Qjvqlv+2W9559/MqD4VEDFXwJr
tIMadYNazgZ1nA/quRQ4cDVw+HrgOB04aeDPNfSbM/FdNPNZNvdetfBct3oq
sH4itHUR2T0S3X2gRCJ2uCt1sJbds5A4mG3fNdq2M9iypvnm9MxNWp3TD1/K
iZ0xjuyUlWTYjwFFjClyW5tYfk5srxIHA+JkTh7bErf7xP0x8Xyq6e233y/4
Tf/Iw4Gxx4KSjgdn/Dk094Owwo/Dyj4Lr9KJqDsT0Xw+sv1iZPeViL5rEUM3
I8YMwjlG4dMmYbO3QxfuhPAsg1dtgvh2ARt3/YQOPqL7XhJHD+mDJ0oYkocP
ZQ/vy53vKpyt5A/NpU4mEsdb2/b0hhU9cZ1W94uXc/rJc80cosgtiphQxFyH
WOsRh4vE6QZ5ZEzcLImHvab3g/2+rloBXgeCAt4MCTscFv12ePx7kanvR2Wd
is7/S0wJFVOhG1tzLrbxi7jWy3GdX8b13ogb1I8bMYydMImdvh07axGzYBXN
s4lavRu57hAhuB++6RS69SBI7Bwgfewnc/FRIpK7PZE/cVE8eah4ck/hZsu4
WShczKTOt8RONN+GZv38qz3pS3loHGFVoqRhqk0sThM7PXL/HHl0lbjpEw8z
4m1D/O9pBj46EOJ+MMznrcjgw9ERx57FHo9NOhmXfioh59PEQp2kMr2kqs+T
6y8mN19Jab+e0k2n9N9KGTZOGTNLnryTPGOVPG+btHQ3ceVeAt8xXvAgTugc
I3ocve0aKXELl7mHKp4GKzEpPH0YL0/G253xfqzwdmK87BlPK+apmczNUOJM
L9vQKl2owL+4S/8Gmzv6nJdSPZY6xF6PPDhLXC6Qp9eItyHxu0OC7Eiok2aE
i1aU58EY/8NxoccSoo4nxb+fnPJRSuanqXmn04vPZlScz6i5lNlwNbP1Rlan
QVavUdagadaIedaEZea0Tebc3cxFh4xlx/S1B2kbj1KFLilbbknb7gkSj3iZ
V6zC+xnjG6mi5h/MBAQwgb4I9GQC3ZgAZybgHvysGW8zuYeh6BHNxl8VAfXV
3Q/+Or9jz/3IkiL3dIizHnE7TzwvE7+bJMiEhFqSSAfyzHl/3JODCd5HkgLf
Tgl/L+3Z+xmJH2emfZaVfTq74GxO6Re5lZfz6q7lNd3Mb7+V321S0H+7YNii
YMw6f9Iuf8Yhf94xf+lB3sqjXL5LjsAte+tp1rZnhtg7TeKbIvNLVgQkIihe
CYsJiWJCw5mwYIT5I8wbYe5M2GOE3EeQDQLMZJ4G6w9pFXz16P1ydmwUfJvV
nhFFLCjiQJHHusT9HPG+QAKuklADEnGbPLPRjLu/P/HRwWT3I2m+72YEn8iK
/CAn9uPcpM/yM3QLcs8VFl0oKr9SXH29pIEuaTEs7TAt7TUvG7QsG7Epnbhb
On2vdNapdNG5ZNmleM2taONpodCzYNsnX+yXJ/HPkQZmyYMzmNB0hKWokEXG
IyqGiY5CdBiiAxHti2gPRLkgwhFhNggykXrpv3RdoLFnLczq7h3WMO/sUKOI
hx7xPU+CLpPw6/uiDTXjzLUS7Q6kOB1Mdzmc6fF2tt+J3NAPCqI/KYqnilN0
SzLPleZdKC++WlFxo7JWv7LRqKrVtKrrTlWfVfWQXfWoQzXHsYr7sGr+cdWS
W9WKeyXfs2LTu1zkVyYJKJUGlchCimRhBfKIPCYqF9FZKmSxqYhLQnw84p8h
IQIJIUjwR7wnYl0R44RIaybYkO+2Z7f7/ZfyY7X3Lqs9U4rYU+QRRZ5SxF+P
hJwnkVdIzM19Ccb7ky3eTLt7KOvh4Vy3Y/lexwsD3i8O+7j0GVWeoFuReq4q
62J1/tWa0hu1lQZ1dcZ1TWb1bRb13dYN/Xcbhu81jDs1TDo3zLjULzyp53nU
r3nVbfjWCv1rtoOqpSFV0rBKWUS5PKpM8ayEiS1CfIEKXGI2kjKQkoqURKTE
IjUKqWFICUCyFxJdEXcfUXckgXt1+M0clf5n85ygH0VC9UjUBRL7JUnSJ2mm
+zOtDuQ4HMp3PlrkfrzU52RZ4EcV4Z9VxejWJH1el36xPudqQ+GNxjKDpmrj
5vrbLc0WLR02LT13Wwfut448aJ141Drt2jrr3rro2bLi08L3bxYENm2FNIrD
GmSRDbLoOnlMjTyuWpFQySRVILlUBS6tAOl5yMhGZjoyk5EZj6xnyAxHRgDS
vZDiggR7RJt8F47HWSN1+oogRaLPkPiLJPk6ybhFcm7vz7c5WHT/aOmjd8uf
nqzy/agm+LO6iNP1secaky82Z1xtyb3RWmTQVm7cXmPe0WDZ2Wrb2Wnf1evY
Nfiwa/RxF8eti/u0a86ra8m3czWgcz24YzO0XRTRLolqk8e0yuOaFQlNiqQG
RUodk1aL9CoVuKxSZBcjtwC5ucjLRF4q8hKRF4PccOQEIssTac5ItNkOpdV3
GS9nya6W32OtVWmqrhTx3WFJkQQ9knqBZF4juYb7C80PltgeLXd8t8rlZI3H
qXq/TxtDTjdHnWuNv9iWcrUj80ZnnkFXsXF3xe2eWsveRtveVvu+Lse+vof9
Qy79Y0/6Jz36Z7z75/36eIF9qyF9G+G9wsie7Wfd0thuRUKXIqlDkdLOpLUy
GS3IakJ2PXJrVRALKlBYisIiFOWhOBvF6ShKRFEMCsOR748cd2Q4yWON9+yn
vpmp0imdKeJJkRCKRFEkniKpuiT7gmbeda0iozfL7hyutHunxunP9a6nmrw+
bfHXaQs92xF9oTP+Snfqjd4sg7584/6S2wOVloN1tkNNDkNtjsNdzsP9LsPD
7iPjniNTPiMz/sMLQcPLocNrEUMbUUNbMYPi+AFZYr8ipU+R1qvI6Gayupic
DuS1I78VhU0qiCW1KK1CaTnKSlBegPIclKejLAllMSgJQ6Evcl2Rav1XmKrP
mW/sMlW65hOKBFAkcocmRbL1NAsuHii+cbDc+K1qi6P1d483Pvigxe2TNi/t
zoAz3WFf9ERf7ku4PpBmMJhtPFRwe7jEcqTSdrTOYazZabzdebzbdWLAfWLE
a2LCd2IqYGI2eGIxbGIlcoL/bFwQO7aVMCZOGpWnjijSh5nMQSZ7gMnrZwp6
UdSN4k6UtqsgVjSjsh6VNaiqRHUpqgtRnYPqdFQloSIaZcEo8kK243dheoIi
jhTxoUgYReKUNLVJ9mlScGZf6SWtipuHakyONFi+02J/su3hRx1uVLe3Xm/g
+f6wy4PPrg0n6o+kGY9l3x4vsJwoteVUOUzWO001O091uE73uE8PeHFHfLkT
AdzpYO5cOHcxanolZno9bnozcUqUMilJ48gzOUz2BJM7xuSPMoXDTPEQSgdQ
3oeKHhXEmnbUtqCuEXV1qK9CfRnqC1Gfg/p01CagKhIVASh8zI/Rf+np0V/l
6kKRINZBk7VJ1mmSr0dKz5Kqy1p19KFGk2OtVic6HE51Pfy098npfu/PhwIv
jYR/ORZDjycacdLNJnMspgptpsvsuVWOM/XOsy2ucx3ucz1ecwO+86OB85yQ
+enw+bmo+aWY+ZX4ufWkuc2UWVH6jCRrRpHDZfKnmcIpppjDlE4w5WOoHEHV
EGoGVBDre9DQicY2NDWhuR7N1WguQ3MhmnLQmIr6ONSEosxjO81cXa+vfSNX
pZeGKyMRRTK0Sf5pUnKGVJ4jdZcPNNFH2kyPd1p90OPwSb+zzuCTsyM+F8aC
vpyIuDkZYziVZMpNt5jJsZkrtJ8vc1yodl5ocF1scV/q8Frq9eUNBvJGQ3ic
cB43ijcXw1uK560m89ZTlzYzFrezFqW5C4qCeaZojimZZcq4TMU0qqdQw0Hd
OBpGVRCbB9DSi9YutLWjvQXtDWivRnsZ2grRmoXmZDREodpflmf/3bgqp5dn
rJPmUKTkNKnU21d3Xqv5ylvt9Dtdpid7rT8avEeNOOuNuX8x4XNlMugGN8Jg
JsZkLsl8Pt16MffuUuF9XtnD5WqXlQb31Rav1U7ftd7AtcGQtdEIPieaz41d
m09YW0peW01b28hcFWavbuetSAuXFcU8pnSJqVhkqhaYmjnUzaKBi8YpNHNU
ENtG0D6Ijj50dqOrA10t6G5AdzW6StGRj/YMtMShPkRR/PDbcWVj8J8pYkeR
YFavmRQppEjFac3asweavjjUfuVot/57faYfDll/OnpPd8L580n3S9M+12aC
9OcijBdibi8lWfHS7VZy768WPVwrd+FXu683eG60+m50Bm70hggGwwVj0QJO
rICbIJhPFvDSBKuZgo2cDWH+xnbhurSEryjnM5WrTPUKU7vM1C+hcRHN82id
RTtXhbJrAt1j6BlG7wB6e9DXgb4W9DWgtwo9xejORUcymiOZCrc98WmHr/rJ
OatbLTY+RVAkhSJ5FCml9tXo7G86d6jt4tHuq+/0658cNv14zFqbc+/stPOF
Gfercz43F4IMlyLMlmMtV5Ns1zLurec+2Ch6LCh/slntudngK2wN2OoM2eoN
3xqMFo3GijgJIm6yaD5NxMsUreZsbeRvCYuE2yVCafmmokrA1GwwdetMA59p
XkPrCtp46FjUYJ/2voHeafRNon8cAyMYHMBgDwY7MNiMwToMVKCvEN3paI9l
ar2+HV92bU8oEqP0WIoUUfsqKc0G7f1tZw52fXG0/+p7w/ofjpl+yrHSnb53
ftb58oL79SWfW8tBpqsRd/ixNhtJ9oJ0p83cR1tFbqIyD1G1z3ZDgLg1WNwZ
LumNkgzGSkYTJJxkCTdNMp8pWcqRrBZI1ovEwlLxdsW2tGpbUSti6reYRiHT
vMm0bbDAlFv8Xh76F1UYB7kYmsLwBEZGMDqA0R6MtmOkCcM1GCxFXza6EpkG
v+/A9I/svJpNkTJqXy2l2Uxpdeoe7Dt/bOjqn8f0P5401eZanZ1zuLj46Nqy
u/6qjxE/6PZGhNVmzF1h0n1RuvN2jqu48KmkzFuqDBcNwbKWcHlnlLw3Rj6Y
oBhNVnDSFNwsxXyuYqlAsVosXy+VCyvk29Uyaa1M3iBlj8k0foruTfQK0LeO
gTUMrWB4SYVxbBZjUxifwMQIJgYw0Y3xVow1YKQCg/noTWaaA7+lBbM8/0CR
RIrkU6SS2tdIabZTWr2n3xo6/+7Y1Q8m9T+dMdWdtzq/5HBlxfnG2pNbG96m
gkALYbitKOaeOPGBJN1FluMuL/RSlPkx1UFMQxjTEomOGPTGYzAZo2ngZIKb
g7kCLBVjtQzrFdis3jnn+JmiVc60y5guKXok6NtG/xYGNzG8gVE+xlZVKDkL
4MxicgpTE5gaxlQ/JjvBacZ4NUaL0Z8mafTbs95/9a8z/R1FklSGS6op0kJp
dmm/OaBzdPTcCc6Vj7i09rzJWZ7lxRX7L/kP9QVPjIXe5qJAa3G4vTTGSZ74
SJHmxuR4MoW+TFkgUxXK1EcwLc+Yjnj0JGEgDaOZmMjBdD7mirBUutO1xi9E
DZA2Q97GKDoYRRfD9DLol2NQiiEJRrYxtoVxATjrmFxTIZ1eAHcWM1PgjoM7
BG4vptswWYfxMgxmbDb4fAemv2HjUSlF6ijSrq3Vp/PWsM47E2fe5176y/zN
0zyT86uWl9fv3hA8MNxyMxN7WUoD7ORh9xXPnBWJroq0p0y2N1MQwJSGMFXh
TF000xzHtCeiJxUDGRjJwUT+jgZ/uVINfh0EjRA1Q9IGWQcU3TssGQwqMKzA
qBzjMnDEmBRhehPcDcywXOcWMDeDuUnMjWJuADOdmG4EpwLD2epnlN/A8pfs
jFpGkUZqXxd1YFDn6Njp96Z0T81d+Gzp+pkVowvrFl9u3tUXPTAWu92RednI
AhzkoU6K6MeKBHcm1YvJ8mMKgpiSMKYyiqmLZZoTmfYUsJ7366lSzFZgsRrL
deA3QtCMrTaIOyHrhqKXYQYYDDEYYTCmwIQCk3JMycCVYGYbc0LMb2CeZbk4
j0UuFiewMIT5Hsy2YKqKGc3d83xih6P6M2P2/PLnbBQqVxns/h7q4LD2UY7O
iZkzHy1+ob1y7Rzf8NLmnRsiu1sSJzOpi6XM007uf18R6qyIcmPiPZgUHyYr
kMkPZUoimcqYXav8XVcW+vMwXIjxEkyVY6YaC3VYbsBaMzbasNWJ7W5I+yAf
AKMkOcpgnAGHwZQC0wrMyDEnw7wUC9tYFGJpAzzWVXlz4E1haRSLfZhvx3S1
fCT7W/Jk32f4V+VCgSKtlFYf9dYodWz69Mn5s5/wzuvyvzwvuHVVZE6LbY2l
981lj63lHg4KvweKkMdMpDsT582k+CMzeJfbH2qS0JiG1kx05qKvAEMlGCvH
ZBW4tZhvAK8Zq21Y74CwG9t9kAxAPgxmFM8ZMuAymFVgToEFORZl4EmwvI0V
IVbWVXhXF7Ayg+Vx8Aax0IGZWslw5nfg+M8qRe5ro/YPUIfGqbdndD5YPPvp
6gW9jasXt/SvbZsZSKxNZfcs5I/sFO73Fb7OTLAbIjx2fO2/cqNQFIuyRFSn
oEG5NMtBpzLYF2OwDKOV4NRguh5zTVhqxUoH+N3Y7INoAOJhyEahGAc4wDQw
A8wxmGewyGBJgWU5VqRYFWNNhLVN8FmrXZvF6iSWh7DYqZipUX8O8g38fkyR
4l1+BznUO7PUhzxdiv/5WeHlS9v0DYmJodTqttzBWvHQnnnitKux/47xR2II
0iKQ/QyF8ShNRlU66pVL7Tx0FKGnVLVUGanBRD2mmjDbisUOLHdjrReCAWwN
QTwK6Tjkk1+xAxaAJYDHYIXBqgJrcvClWBdjYwsbG9hYUaHmT2N1GLwuGbd6
z3PRV17KkH2j53WVie4fpA5OUu/OU6dWtHUEZz/funRFfIOWGhnL2dixz8sV
AR4I9VUdpSaEqQ7jsmKRn4iSVFRmojYXTQVoK0FXOfqrMVyHsUZMtmCmHfNd
4PVidQAbQxCOYnsckknIp8G8yGsZWAHWAD6DdQU2ZBBIIBBhcxOCNQjYtdDa
iILXKZ6u+A7MfkiRJmofy+z4AvXRqvbpTb3zoh0daZlbwNYOjo54/AgeT+Dn
hRB/RAUjLgIpz1QncXnJqvOb8mzU5KOxCK1l6KxEby0GGzDaDE4buJ2Y68Fi
P1aGwB+BYBxbHIinIZuB4kVqqyy1dWADEDDYVEAog1AMoRDCdWzysKFaysuW
OjTU3yTY4fbi0xP2bbDXKFJFkX7q4BT13iLL5uDn12RXDBT6ZjCzgrU97jnh
kQvcn8LHB0GBiAhFTBSSYpGeiJxUFGaiLBdVyr19CZor0FGNnnoMNGGkFeMd
mOrGbB8WBsEbweoYNjgQTkE0A8kc5AtgvuLEZzkJgE1ACGwxEMkhkkIkYkQb
EPIgmJHzR5To/jYr1btwLI/D1MfrOrpbuhckZ64rLhrixm0YW8PCAfYP8dAV
bp7w8kVAEMLCER2NhHikJiMrHfnZKMlHZTFqy9BUhbZadDWqNkJD7RjrwmQv
uAOYH8bSGFYmwJ+CgIutOWwvQLoE+TIUq2D4O+rZoQKIgG3lh8G2DNvbjEiA
rWW5gCtdG9rZhvwtRqrYwXqOlsoG3xynji9SH/MpXZHORZneDea8EfOlOW7Z
wPw+bJ3h+AQuXvDwh18IQiIRFYO4BNXJd2Ym8nJRVIjyUlRXoKEGLfXoaEZP
GwY6MdKDiX5MDWF2FAsT4E1ilYv1WWwuQLQE8TKkq5DxId+AQgDmBV4arzBi
1QNtiYIRi5ltgWJrWbIxLeD17OB/uYe9yO6NXX2x5z6a1P4R6p156iMVPeqi
Qpeld/kOaFuYOsL6MRzc4ewN9wD4hCIoChFxiElCYhrSspCdh4IilJahsgp1
tWhqRFuLat/e142hPowNgjOiWjrOcbA4jeVZrM1jYxHCZYhWIeZDsgGZAHIh
5FtglApT0nqVkUDj+4yEUXJTbAukW0tb65w9ay31dedejs/fc2R3HW9Rx2ao
D1ep00qCcu0bzFkj5pIFc/0ujBxx5zHsnsLJB65B8AyHfzRC4xGVjPgMpOQg
swB5JSiuQHk1aurR0IyWNnR0oqcXAwMYGcb4mGonoFwhz89gaQ4ri+ArI8IK
hGsQrUMsgEQI6RZk25CLoZCAkUIhhVz1rVBIxOLtdZFwkbcypH5yob5b2svw
R7sM2dnwEHVwlHp/mdIWUhdkOtcVp42ZcxbMlbvQd4KZC6w9cM8Pj4LhHgGf
ZwhKQEQqYjKRlIv0QuSUoqASpbWobERdC5ra0daNrj70DWJQuXMdx8QkprmY
ncXCAnhLWFlWTsvYUAY/AUSbEG9BvA2JGFIJZEpiMshkkEoZmVS+Ld4Wivgr
69N7njmq8/veLr+v7w9VPsiuOf8v9e4c9ZmAOi+lrst1jBhdC1y4i+tOMHKF
hSfu+uFBMFwj4BkD/0SEpiE6C/H5SClGZjnyqlBUh/ImVLeivhPNPWjvR/cQ
+kcxNKHauHJmMD2P2UUsLCvXjljhY005K29icwtCEURibEuwLcUrEhk0fiBW
hhSZYksiE2xvLW/yhma7vyW3r71noqpm3zv+o3LOps6JqasyypA5fQef2+GK
E/RdYeYJaz/cC8GjSLjHwicJQekIz0ZMPhJLkFaB7Brk16OkGRXtqO1CYy9a
B9Exgp5xDExieFq1K1duV6eXMLuChTUsrWNFgDUh+MpVxzYESm97RShVzrPK
+WxLOaXJGIFUwRdLl4TrYzzOnjfe1Ms7rFSk2LfE/0QdHqV0BNRlKWWg0DbH
GTtcdMJ1Vxh6wtwfdiFwioJLHDyS4ZeOkBxEFiCuBMmVyKhFbgMKW1Dagapu
1PWhaQhto+icQO8UBmYwPIexRXB4mF7FDF+1l1ncBG8LKyLVOpEvwbpSN+tK
3XyfL8OalFkWyxdEorG1hT1xQv15+A6Hr96E/xN1cpY6L6JuyrXNoGuDM464
5IKbHjDxg2UI7KPwMA5uyfDKQEAOwgoRXYr4SqTUIrMRea0o6kBZD6r6UTeE
pjG0cdA5hd4ZDMxjeAljy+CsYoqv2nLObmJ+C4vbWBKzK3oplmV4hafUxqsL
EmZGJBnhr+55h0ndznbRq91l3/An1Idz1BUJZQTKCjr3cO4xrjyFvh/MQmAd
iXtxeJQM9wz45CKoEOGleFaFhDqkNiGrFXmdKO5F+QCqh1E/hiYO2qbROYue
BfQvqQ59Rtcwvg6OAFNCcLcwq9xiijEnwbxEtQ2blYArBmdLPrgu2DPXqj8l
2+HwPNtjVws3ZJQ5qLs47Ywv3HHNF7eCYR4J21g4JuNxBp7mwrcQwWWIqEJM
HRKbkNaGrE7k96J4AOUjqB5H3SSauKqT1o4FdC+hb0V1YDW8jlEBxoWY2MLk
NibFmBKrvjlijG9jWMh0rm6qv3H7csTqd9lR/63ShZXjre2IM6644I3rgTAM
x50Y2CXBKR0uOfAohF8pgqsQUYeYJiS2Ia0TWb3IG0DRCMrGUTWJWi4aZ9Gy
gHYeOlfQs8aetglUJ1FDQmWnIyJlcBwWYWALPQI08Db/6SWIv6csqpDuoFW3
HBbt7yljhrKDjjPOPMUFf1wPhdEzWCTCLg1O2XApgEcp/CoRXIuIRsS0IrET
qb3IGkDeMIrGUToJ1cOKWdQtoGkJLctoW0UHH10b6BagZxO9QvQI0S1E5yaa
1hgN9byX1/bg/OGLdvAryp7RdoGuN74IwrVIGMXhTgrsMuGUD5diPK2Abw2C
GhHeimcdiO9BSj8yhpEzhnwOiqdRNoPKeVQvoo6HhhU0rqF5HS3ryqjXsqHE
0bSOej5KFxUaL8uw+Tou9YjOjt8vKFs55QodX5wLwZfPcCsRt9Nhk4P7RXhU
Bvdq+NQjsBmh7YjqRmwfEgeROorMCeRMIZ+LolmULKB8CRU8VK3g1apVZR/l
yyhUboSxm3ujtgL4OqrXXxytf6ecFZQP9EJxKQZ0MkwyYJUHh2I8qIBrDTwb
4deKoA6E9SC6H3HDSBxDygTSp5DFRc4scueQv4D8ReQtIncB6bPQUM8O2otA
PUKx4/JvO2UqCGef4WoSDDJhlgfrEtyrxMNauDbCoxW+HQjsQWg/IoYQPYrY
ccRzkDCJxCkkTCF+ChFjYPOwvv/irKlaku+shP4RL893Ymt/ovsMF1NAZ8O0
EJZlsKuGYz2cm+Hahqed8OqBbx/8B+A3AN8BuHaCzT76WsbITi/qsUDdUg7t
+d3OuKhnFvyrWvnF7BsVp51f/dMuJ3Xpw7v3d6R+qlarnnv2del/wcsz1J5n
x+1IqfNS563KRFIpYufM/me7bapLqXKhXnu+5tZQ14y6rfxxV3on6+IXarXq
Z1j/uYtgJ9Po33cRqEv9ZrfNnfyvX6nVqq9gfrkrvZNv9x/Ym02ouvzZbs87
WYF/K6vtp7tt/o6Vfp4Lpy71412p/8NK/U6tVn1Gf30XwX+z0v+Jl3nFj3Zb
3M/K/B578ytf3ZVg88Q0VD3/QFlic7Q0NL73/wFKrg2z\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->210253505]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->159117063],

Cell["Opacity is kept throughout the scope of graphics directives:", \
"ExampleText",
 CellID->758618147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Opacity", "[", ".5", "]"}], ",", "Red", ",", 
    RowBox[{"Sphere", "[", "]"}], ",", "Green", ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "/", "2"}], ",", "0", ",", "0"}], "}"}], "]"}], ",", 
    "Blue", ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"5", "/", "2"}], ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->384338528],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0, 0], Opacity[0.5], SphereBox[{0, 0, 0}], 
   {RGBColor[0, 1, 0], 
    SphereBox[NCache[{Rational[3, 2], 0, 0}, {1.5, 0, 0}]]}, 
   {RGBColor[0, 0, 1], 
    SphereBox[NCache[{Rational[5, 2], 0, 0}, {2.5, 0, 0}]]}}]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190947587,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->156514624],

Cell[TextData[{
 "Color primitives can be used with ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->70579336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Hue", "[", 
         RowBox[{"2", "/", "3"}], "]"}]}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1", ",", 
     RowBox[{"1", "/", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367089503],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Hue[
      NCache[
       Rational[2, 3], 0.6666666666666666]], Opacity[0], 
     SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmWtv00oQhl1fcm+dJrRN29CGlrbQA0IIDgchISQ+wCd+RBUigQQCcfj3
kXXOvuPxJa8ntWkidZPxvvt4vZ7Zy/TTze8vi+83v7/Ob2Yff938/PJ1/u/s
w49f7lKw5XneZ/f3beK53/+5X/L3PkkSL1gsFol8vFMU3jtXRu7iTKy3rvSd
Feh3evWNK9EwKhFcqYTXqu2Yta+0tgcrzO/ufpxI/QtlD2BFeb0y7ovmuTLi
WzTPVDMyNVPRPNF73aOR8Mk+FPW1Eg8aqa+UfUi1AdkTUV8oe9pIfa7qE6oN
yZaeejPtyYxqI7L3RX2i7PNG6mNlX1Bti+w9UR8q+1Ej9YGqr6m2Tba8PSlx
8QnVdsgei3qk7GeN1ENVP6faLtnia9629uQF1fbI3hV1X9mvGqm7qn5NtX2y
h6LuqPpNDbtQl+P1ofvuLZdLZrMdF61X4hnxPnbt+e0OyN4p2lfiFP41cQz2
7FsYt0QmfPa+o0lYpZfTliXNtpDYx/j+8IuZkKhlLYnjCGN/lpHct9WngUni
cUWr8xIJP2Pr3VVIbON+D4nku4Kf0KbxW4DPXhItMGg9k8YxhvorooUGTdpV
xoh9F2/jEdEiV7B/2TRWwa0eE61l0DomjZ/A34jGPnRNpLZBapuk3Ie0Jfep
Y5BaJknmmWA+n2tLHvmuMdukJCtqfGm9noZ+YWwwKXXWUgKisG91dfbBJZ4F
IpOK8YqIyv4vVGeas8OdiPAMVEtolT2jlg5PaRP9wohXVCPSePVYT+0QlecU
VLUbExEfPSLm891cPl7f2TxjpDR+d+hfn2in+RgWffwz4oCIx0oM6Mn7xlOH
a6nbRD1QaouoA6Ov66k7RB0rtXtnKt7QkKixUgcbUXeJ2ldq3JjKO2mMwIio
baWONqKOiZrFzt5G1HslKlzUd8VkI+Ie9RM07BZ3DN8MGlNgQ+I38Pjm1JFS
2eN7a6m894sNaqzUHlG7G1HxpKGOI69Hd6d2tK/sm82pQ/Kipe51INknqjUr
N6f6Sj0iqrWz8uupC/l4cuIlYvhHxMyLeJccrKWUTwrY8++seHfxxGdE9BsT
+0oMiSh9DHPisrrDtXmZn/CKzmtvPU1O1OrLvO7m+wNtXf+s2fmcV53LGtJW
hbSrJLmmFKaif+wBvLPMyKszT7bP43XsbkTEULb/jI03wmsdx1yV2NY+bifV
FRxE3jXxelAlZrvboUGEF9ad75RYnP2TIqvGOxfEiXWiq/KAQ7aLd1QPjJnJ
JpSvHCXV3d7MiFGQtpwJwqrnLTQbwZGAPSOftVoVCq9xyIR1iYS5bUi6qELC
28JMiCfi/TVyGyMihBUCn8owyjxbTF0xriXxuOOp+JyCNWCfdEGFlGWqJJ9I
BOxLOIvqVwjsE0diL2WzlFGOb6EUmbhcpffHOiS566js4fCHtB3PpJKjXYkG
zCXnq1fzu7LvcHb55Zp2cWJno/8u2UUfd0nFGe8sK5+qs+woq/5ZGS+u5Xug
J0Gu3lMmq5BTDXXO9SpPz6PzNCmf5ydUy9H8OEn/l5Hmz7LsM6sulJlmWNlH
eLaaKTPNUU+VyaqpMsULPc7TWxEIdfofkFNlsmqsdz4T1QOq5RkmVuaVqM+o
1lrJoP5L1Nn/F1jV0h5I1lzGrexpoTLEY71LV7YWmqn2vK3/AdSYR4Y=\
\>"]], ",", 
   Graphics3DBox[
    {Hue[
      NCache[
       Rational[2, 3], 0.6666666666666666]], Opacity[
      NCache[
       Rational[1, 3], 0.3333333333333333]], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Hue[
      NCache[
       Rational[2, 3], 0.6666666666666666]], Opacity[
      NCache[
       Rational[2, 3], 0.6666666666666666]], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Hue[
      NCache[
       Rational[2, 3], 0.6666666666666666]], Opacity[1], 
     SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->124058290]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->623038887],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 " can be used to combine colors with opacity:"
}], "ExampleText",
 CellID->675518163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", ".7", "]"}], ",", "Orange"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114361079],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169675412]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->97445566],

Cell["Half-transparent surface:", "ExampleText",
 CellID->204233308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", " ", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"Opacity", "[", "#", "]"}], ",", "Blue"}], "]"}], "&"}], 
     ")"}]}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "40"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186151104],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->542251816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448459237],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " to understand complicated surfaces: "
}], "ExampleText",
 CellID->137930274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "u", "]"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "u", "]"}], "+", 
      RowBox[{"Cos", "[", "v", "]"}]}], ",", 
     RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"u", ",", " ", "0", ",", " ", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"v", ",", " ", 
     RowBox[{"-", "\[Pi]"}], ",", " ", "\[Pi]"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.7", "]"}], ",", "Yellow", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "50"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60161043],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyNXWuQVtWVbVAUHR+gTmIiKBC1TDTKII4av8kiCuIDUxZDJQafxBeiIz5w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   "], {{
     {RGBColor[1, 1, 0], Opacity[0.7], EdgeForm[None], Specularity[
       GrayLevel[1], 50], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3QnYdlP1BvDzPs95/yJChMxzmUmGaDDPU4YMmRUyZZ7Th0imzGTmkzkk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        "]]]}, {}, {}, {}}, {}},
   VertexNormals->CompressedData["
1:eJyFXHu8zlX2Pu5NV8lULhW6TaPMTGoiX9aJipKELhQVlYhShqaGOGFcDhVN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    "]],
  Axes->True,
  PlotRange->{{-1., 1.}, {-2., 2.}, {-1., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 253},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->6170815,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", " ", 
    RowBox[{"Sec", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}], "^", "3"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
   RowBox[{"PlotPoints", " ", "->", " ", "40"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"Directive", "[", " ", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.9", "]"}], ",", "Yellow", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", " ", "50"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.3", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->631161667],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->120101363]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41614120],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " to visualize internal structure, in case two ellipsoidal shells:"
}], "ExampleText",
 CellID->66291749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"4", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"y", "^", "2"}], "+", 
    RowBox[{"z", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "4"}], ",", " ", "4"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", 
     RowBox[{"-", "4"}], ",", " ", "4"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", 
     RowBox[{"-", "4"}], ",", " ", "4"}], "}"}], ",", " ", 
   RowBox[{"Contours", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"4", ",", " ", "16"}], "}"}]}], ",", 
   RowBox[{"ContourStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.8", "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->646558465],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 264},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->171361551]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->268948481],

Cell["\<\
Overlapping of translucent red and blue disks results in purple:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->618362617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Opacity", "[", 
     RowBox[{"0.5", ",", "Red"}], "]"}], ",", 
    RowBox[{"Disk", "[", "]"}], ",", 
    RowBox[{"Opacity", "[", 
     RowBox[{"0.5", ",", "Blue"}], "]"}], ",", 
    RowBox[{"Disk", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9848823],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], Opacity[0.5], DiskBox[{0, 0}]}, 
   {RGBColor[0, 0, 1], Opacity[0.5], DiskBox[{1, 0}]}}]], "Output",
 ImageSize->{154, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->449453632]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->312663135],

Cell["Background color can be seen through a transparent object:", \
"ExampleText",
 CellID->103358547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Red", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Red", ",", 
       RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Yellow"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], Opacity[0.5], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0, 0], Opacity[0.5], DiskBox[{0, 0}]},
    Background->RGBColor[1, 1, 0]]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->282217152]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33159238],

Cell["\<\
Each color primitive supports an extended form which can be used to specify \
opacity:\
\>", "ExampleText",
 CellID->7182311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".5", "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0", ",", ".5"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->572328202],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0, 0], Opacity[0.5], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0, 0], Opacity[0.5], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->118625561]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".5", "]"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"1", "/", "4"}], ",", "1", ",", "1"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"1", "/", "4"}], ",", "1", ",", "1", ",", ".5"}], "]"}], ",", 
      
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->621098068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Hue[
      NCache[
       Rational[1, 4], 0.25], 1, 1], Opacity[0.5], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Hue[
      NCache[
       Rational[1, 4], 0.25], 1, 1], Opacity[0.5], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->276128277]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".5", "]"}], ",", 
      RowBox[{"CMYKColor", "[", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CMYKColor", "[", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", ".5"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->827815630],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {CMYKColor[1, 0, 0, 0], Opacity[0.5], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {CMYKColor[1, 0, 0, 0], Opacity[0.5], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->730004238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60788142],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " is used by default to show overlapping fillings:"
}], "ExampleText",
 CellID->253154528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"3", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->705326715],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90474982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188029544],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " is used for fillings to surface plots:"
}], "ExampleText",
 CellID->295686092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Filling", "->", "Bottom"}], ",", 
   RowBox[{"RegionFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#1", "^", "2"}], "+", 
        RowBox[{"#2", "^", "2"}]}], "<", "3"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->260745424],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9nQdcFFm2/2sbUMcwOuOME3Zmd3b27ey+Xfb/9r3ZCetkZ3SSRUZUzIoi
QUUwK+aACmIAMecAZkWU0E3ubrqhu8kZQcQcMCtwPv93zr3VTVvdMM78Z/9+
rtVVt29V3fOt3z333FvVhTg2zN8veGzY5PFj3/l2+thp/pPHh74zaOp0zHL4
jSAIifg/+nUB1/8vrrH/iQCAX9gsZ+PSEQt8zLbm0NIBN9mWOXeuVS6tfsRy
58lyP+wkl84iOLbnCkIv6bx/tpxXgVu9Zefn3y6VyjrKjv0e+3atLPdPneSO
xCVlvi0dsZtNvfgZR8n2fkMqLzjgip+fH62+INX5L3b3eE361lH6ZHtKhv23
3T1ekc7RleXjSSQG9ku/LB23x3OV7i3Z3YvZ215aEP5h4WLmT599KNeJl7Og
Ef6LfQZKx3q5kzKTpeMoZPXoY1VbWpV/78z2niid4TU7pemof2elxkul3qSt
rrJ6SLXhJb+W9ntL+nxbdly5rv7K9hpgo43XpTNaX8u3ZMdykh3rPzs4Vj+p
LvLyb9qpG5X7WwfH6WunTn+QHaOL7BzdpX1+28ExX5LO+WfZcbraOY5N3e0c
70U7dXzvJ45NRR3Nu9icw3xFe0mfznYsdrC0Dvnernbq8zfZEbrJ9nzB7pEG
S0f6b9ne8tLyo/G9/wrt3ois+OAnjtIF2nUsKULmo2jzIzssiCT3ln8E+77U
7K/kLVJeJ/k1/6Pdurwi1eVT2d7y6/Gu3b3Nvu33DELmelX2BlXORpV6k0od
o9JuVuniVPotqoKtKhsP0V3a8z/sHtfsBYmUIilCJfQ9v1qVskaVGqlSRqnS
16kyolWdnM2wTWXcrjLtUBXuUgmKkj0qwaF0r6rigIqO/aKsJj1l5/6D5Ypb
+1lWf6cjEcoTEcqTEcpTEcrTEUqhvW5r/x/rth+rh8erPKgUHKoOKasPK9t1
1V7XXrK6vsPq+rFEqx8T8KEI5eEIZXyEUlbZf0tdnXhdaxOUdUeUdUeVz/SJ
Hdf4A+sa99gTodwbodwXoeyg6ip7nKN/Lc5Yd0GBtRcc6o8pG44rL55QSm3u
WStIBVwb70u1f5XJaWtE2vaItJ0RSm7G/o7NkKxY86ta0YusOERW1B6hi2Ax
4uJJZeMp5aXTacADoZdkV+J3zJaXJS/zpvUV6RMTkbYlIu05LTvzK1pWbt+y
BPuWNZ1J69iyvla5glVMwCx8eX1E6saItH+3nfn27dzzjJ297drZYGNnU1Ja
U1KqxSMxn8u8l71ewuzX5b0yiwX7RkWkWgPYxgDseg4AUktM/mUEdnZA4KWf
QeB8atO5VFw+MwIBKQ6xeGreNq2+fUniwVSA5jMFbPopAAkdKODXtV+B5ivI
DXW3a/slbvvZNAVaLjgQgeRUe76VRQQ2sastC3OUx2Kbf0RFpCAPnjpisq9T
JojkXITqFzMp3q1CKBYk9ojUd0bEkRNpSklpSkthTJwstkptXx4rvWLxfbbx
r3wMKCkmhamme+eEFMhHeMc+odXthFT/nwk5tRNKJUjPRHcWPnaU01fi0VNS
DItnHaMikploUn5FKmn/diqNz1BBR9pFRqVJmdzThoN95fxe4kI9jQJx2NHH
VjOJ3XIS7/67SVRieh4WTYmEg7HoasuiSZX8TGzccTt6S1LH73lLsaKxwR6N
vb+URtavRePCT9DoZpdGU/r5F8Bqdkng/3h/Yx7T/UFqIedZI0mWaCiIRo91
EakbItI6ASL8ukQMz0ekq10iLPxlNF7oiEZTxnmbceLrjMZrEg02akQASRyI
oHiGx3ozj9h2HkpbHl3t8hC6Efxez2k+73cd7drvaG0/WS30pogjMQ0dBQs6
UjsB0JR5zoYBV0Q3iYG8zZjnkuT9zDsSq3OM1fmfZLXDitUBu6zwwMkTc1i7
TZmUq0j1VyvSJmsEh7QAjTJAy/Jp0b1zdBK5fXbIvYbk/Mz/2tuSDB4L1zqC
15SVxEa55thMsJlLcbDxydaxLl2uP3AvfA7/n38OantsqHVLYLD4P0SWMjEX
V+wwUwZqBYUqKE/okR6cZ9mjM8WVETdVOzemr34Xjj7b3E61Q0NixO0noJ2T
a4731wqwPxdny9DBJk6iiv2+vb2ekzTYEdHNnRLtikc+75eTjGkiplxkyfSG
PAWntMlqZGqlQlWwTnDkRDOm6DKm6tmcn5Ndog4WosxDCW/Wxkujhs6h4tiB
uHYKtSk7Sc711efUpHn0wcm3zxy89QzRcx0SjemMKNHoZoUzB3GmIElBSJ2s
Yfp0bNcn8kyfomdXgMPMnKbH9ayQ/KzpBfxYDnZUyhuxpFLhzRprqnzgjVRP
dkzVHIDbpWqex+73M2jalLCi+qZE9SwHS6vn7cSlvS1s4+yxJY1OyKYmT1xz
BQdSqVMqA8sFmoYCVRBUR5KoIKRPzSe+CFXomjFNnxlCm4g1OxSTISfMyPl2
RbIWv2hp/gIj+7IdspJk0/hA10IWnQDBZWQVFLZ3ZWSTiSwmRrYp56xN//PK
z9Ssk4zuG89Ht49lCiHOPIdiocvRcslyV4p6Za2/G0qW+KJYmV6VgXnIFhXL
+6KMaQWZ0/IpoV5DCjALwWaHEducGSYWk5BiX7f2q1WYDil/FldULKG1cOWi
lXGVzwz3tfTrVFfzHL985kVO8zXeOyUSwSRL924zarBLkmNUEESHZN4pIUIH
QtiNKZSaO0EMkiCiQLkCM0MMmSEFmdMLsqYbskINxBHVyfipZxcJv9XMKeKd
188BKc3EUOtnc1FSL5VMLAVGspucZBaRbMxJ7G5FzUEaUUr+QHbfxJpdv59m
18fuTB4Hx9t1yiQ1735S/TWpAVoHotaNK8+aGxbInG5QZIYipqxQI0LLCuXE
BIecmYW5swoJnINmbonwKpbVzi/F5S9DJ7BReVcLu2fGXAoKqx0ldtlnL+Uk
ynUoVxxr/6ynosxuMoasB0N+iZYGrZAz7GHL0Nx/53KAGEH6a9g5U0l2eYIi
LRCjII4Qc1XBeqI4TaKYGWoixxhm4vy6YtNFhJiVO6tIPbtYPbdEM69UUCBD
pta+uvBy/LAmabmp8DNIYnMmmB2QTEKS8hkzeT/DSXZ9pi8X2ke/dlq7/A7N
Kz9N28l6tgRp8z7jBQSdjEr116RM1qJMUydruZsk0A7KIJ3QFSHzPgidJONs
JM6McJfsGYXZDHLOrKLc2cVUW6QsdEHO2vll2gXleQyxbmGFQr+4kp2x988g
fVYi3ct6KESwrXt7K9A2c5P2SXex6ZO6PpsDts9OWDyxE6Oc1B6tPjP38Jo1
ZaZmwss8KCeclxqoI7YImVSsUwbrEbCKVEx0M0IMLFRi7T97JnlLWipycOGY
O6s4l2RMLkChmV8m/AUhI+G8hRUEeVElLvOXVucvqynAtLwGN2U3ymxJXzKT
Jq9qM+Yk1s8Om3gnJZ+hse8brOcr2LV3AvO4U/qCcbeZN+0l4/6yxP2smXuS
DfceFu4UWJGmETdR5tDTAnXoO4L06IGDKKJSMuSqKfnp0wwZ000ZoSYFGyFl
hpmyUNIzi7JnFefMIj3nEPOS3DkliB2RaxYQam14BTLPW0jAdYur9EuqcaVg
eV3BigsKw8o6wdG46gLmcPLsLt8bdifYfwH5+tzT/F6yfWrPrW05Y/7kzZYF
azlmGjGcs51RsmbNQKuTUdckavIRTNo6wqxQBucLTsop5JiRsmpqQXqI1KtR
vbNmFGHimFHbs0uE18hLzy1VzytXzyvTzC9HzlqGN29RFRLGFYSsX1qTv7wO
1w2r6g0RDUZMqxtMay4Wrr1YGNlouaP6QiesBTa39KLt1Arxfnb0gLAbcs+Y
78EqrLnZoWyeW5G3BLY/Hpzz3bog0oqvjY/utsFMNsVfmxKgSw3SpwWTW1Ck
MZ7B+copBQgTk8VLOGbOIJ1mzSqhctn40SV7dgkyzZlTmstchXp+uYMmvFJ4
W7uwKm8xSVW3hHyDfllt/or6/BUXClbWE9TVF41rGk1rMV0qjLxUFNVUtK4J
861v8P48pihgwmrD1Ha+u08nVOX3mojySzL18ufWtoVHWvo/B/mI94VoNiqT
XEIgss1Pm2JIm2pkJJVTDUI31VSDZfxEXiGsKHMmpzqnXOhBrnhOWQ6muWW5
mFCq88kZaMKrtItqtItrBEUeLrroltRyl6dffiF/VUPB6ksKw+pGwQHhYqYp
qklQFK67LPQuir5StP5q8cZrmFu66TouZYwbfzHjgh2RfezosD3GMH+aeb4s
48n9u4WnjVoV5vED4WTNH3WaNtWgnGZShhQqQ0ySOhXp003CyxQ1mFlmz63I
mV+ZM4/ads68ilxM8zFVqsOrECT51sU1eUvr8pZdUOiWXRD6IEQ9inRlQ0FE
o2HtZUPUFWPkZWPUFVPUFSxcGH21cP21og3XijdeL950oyT2Jh/PlW25jR8d
wSSWCrqZ29N2VoZgPkvSfOeb3fnlkZb8zrb8CSbH7Z0pkeZIUkiA+lSCZkRi
qtAiKaJKn16YHkoJ1ZcRVozQeJyWPa8yZ0FVTnh17gJMBAqX6vBqzSLUnXYJ
9jnaJbUITre8XrfyokK/8qLQhcKBCBKdIeqqMfq6cf0NhWn9dUXhhutCl6KN
N4o23SiOuVkSe6sk7nbp1mZOrnzHvYod9wheR+RQhR1PExI+MzvDjij5MxI9
Le1cHumy1i35T8rqK+PaXeIa9QxXFgTwyQHSKOfriE07NZi6HoTLqL6bPqM0
PYzklx5WjFQzZpRkzirNnF2WNbuMNElsq3MX1uYuqsWleiF5R/WiWs3iOu3S
C3nLG/JWXMSlDtPKRn1EU37EJerv1zQVRJIIjRtumjbdNsXcVhRuuoVkY25h
ZnHs7eK4OyVbmku3cLI9y3c9wI+K3Q8r9zyq3PsI123nrqU7hBJfy9xWigIB
83EFAeZ0t0e9LOPHoy4nGy/qaJMjJ/+KjDYbXzjuCI/aFb7OdjzBKDswviY2
BqdFD1VoMWLOmFVOaSZxzZhZmjmrLHN2edbcyuz51TwG/CdHrV58Qb2knpaL
6zRLLmiW1muXEWfdqibd6su6COp59Kub8tcS4YLIq4Z11w3rb5ADjW0ujLtX
GHe3MK65aHNzUdzd4i13S7beK9l+v3TnQyxQtvNh+e5H5Xsf43rl/qeVB55W
HXxafbgFN2W0redlrOa7nplNYIKWeJufe+31szjTHv1kfNlouct7/T58r99H
w50DhjkHDnUOeq9ff8V7/T4RnN7r96l5zoscLOf7NvJVTi+SKM+uyJhTmYlp
NnVBmXMqGOKq7HCSbs5CCpIIMhJedlGzrEGztEG7/CJ515WX8lZe0kVc1q25
qo+8ro+8Js3zFqy7XhB9w7D+pnHjbWPMHdPmu+Retz9QFG27L/Qp3na/eNuD
kh3Et3T3E6K870n5vkfl+59UHGjFzarDbVXxbdVH2qqPttUcb+M+qxPQ9udt
0E7TtvXG7ev6yvTZ/RcrW06exRgUg45z9h/nPPm9fh+/1+9fAnLvLziOdQ4e
4xw82nnKKOcpzG+8rQwtUc0sS59VkY5LEndF5tyqzHnVmfOqcCVrPgVT2Qtq
JODLGnOXEmT10gbCvuKSZkWjdlVTXsQV3Vrq33Vrr+kxRd0QFPnrb/EZM8Om
O8bYe8bYu0jcFHe/cNtDdsWLdj0WHIt3Pi7e9ahk9+PSPU9Z6X5lB1vLD7WU
H35aEd9SmdBWeYRMrj4G1Seg5iTUnIbaM1CXSJnPr3A+gEZzkbu8d3vhubmb
I4k3ZLydzLz9nP39nAMwMd5+zkHCyyh2S7yFmsdCqrBS1czy9DlVGfNqMuZW
ocZxmTm/JmtBbdb8muzwuuxF9fzJbIStXnlZs/IyjoRx0Vu76rI24nLe6qt5
a6/rom7ooykA0K+/nY9pw52CTc3UDcaQqI1bHgoK0/ZHgmPh9keF2x8X7XpK
9S/e2yI4lOx7WrL/aemhFgZBeLM8oa38aGvF0dbKY22VJ6DyJON9BmownYXa
JKg9Rzl1yQy5Pd7WXaRlZsi0dQPqHK02P+lClBwlis/PW/50t81vFoj7JOfJ
kwj6x5OcA3mM0WOSczDixjTJeQr1iShvJD6/NnNhfWb4Baa/rPA64dXshRey
FzfkLG3MXU7uWL3qqnrFZaK++pp27Q3tGtI04s5bd0MXfUsXfVu/oTk/5j5F
HZsfFGx+wD1Lb8OWh8Zt5IxNO5+a9jwp3Pu0cG9LEaZ9rcX724oPQMkhKIlv
K01oZWcuOwYscik/ARUn2ypOQeUZqEwERWUSCG8S/WSoSSECtWlQp4Q6FVxI
Z/Q7RW8Z21nQ63eslavdZuYNrKMV66iFPn8rI873fq/fP/2dJ7f3ikgdcfOE
xP0Z8Yy51SRwRhxZL2lkFmcvvpi9tDFn2SXEnbvyCqP3vibqtmbtTUzayJt5
6+7krbudF31bt/GOLuaObnOzfvOD/NgH+VsIb8F20rFhe4tx5xPj3hbTnjbT
3jZy4gdbCg+3FB1uKzoMxfFQnEC2lRyFkuO0UnoaSs9A2RlaL0+EiiSoOAcV
56EyGSpToTKN8qtUUJ0ONRlQkwk1WVCbDXU5PFpjs3P2RyWcuGnLRk7ctD0a
ecifCZR7698w4uZWwZ/7shDGf3zEi2L2J6yYghTIlXrSTySyCy5khtdnLmpg
VN/NXn45Z/mVnOWXyT1HXM9dfV29+oZ6zU1N1B3tBlJq3ob7eRvu5W28p9t4
XxdzX7eZMvXbH+h23cvf9bRg55OCnU8Nu9sMe8Cwp824r814sNUYD8b4NlN8
W2E8FB5pKzzWqihClA7FJ6H4tGXGVnih9CyUnoPSZEplzEGUpUGZCspVyK4C
NftWRaY0O1aVA1W5UKWGKg1Ua6Emj+lbx2TdsaBNcTEM70bTtg2IN39HpJVH
IbXST/2IaDtVa9ZvWXjiynv9PkDZ+jsHKMg990Gw/qRXpBrMwWYtoZg3e+W1
nFXXc1bRkniuuUl+Ifoub+ma9XeRal4sqVEX91QX90S35YluB6ZH+h0UNOTv
faI/8Dj/YGvBQV4VoSvRPALGY2A8CYZTbcZTbYxgIZJ0LEqEorNQdA6Kkvlo
tTgNFCVKEHqXqKAkA0ozoSQbSnKgNBdKc6Asl4lYQ8sKLVTkQYUOKvKRdmUB
P12VETDx6/Pi8zAtYEztqfZZtubZn47m7s2/KmG8qVO1iNoCHhXtj50iRSIK
pM4eNMpecTV7FXnZ3Mjm3Kjm3Mg76qhmhXr9fWbB69rYx9rNj/O2tWHSbSf3
qdvZpt8N+n2gPwjaQ491h1ryD0LBYcg/0lpwjMgajoHhJBSw5m48A8ZEMCSB
woDy7G5kGjWmgkEJRiWYVGyTSdSUBYrCbBC6FuaCKRcK1VCkpvyiPCjUSTy7
FOuhOB9KClgyQKkRFGUmpFFWCKWF7e2iT2Up0/Wz6E2bY2zRc06vSGxtZ4+5
f7btG7va5JjZs+vE5tYt3AWkHSi8jdj9KQT/hCJwDKGj7uauu5cbTe5AvfGR
OuahZkuLZmuLdstT7dY27fbWvJ2Qt6ct7wDo9mNq0x0E3SHQHQb9EdCdAO2p
1rxTrbpTZpXnn4X8c5CfAvo00KWDXgX5KGNFgQoUBRnArnV+juQM9LmQj0kN
BVr8Fl1Bt3wd5OtBn08pv4CKGQwsBjCgmLsYTGAspESXqxBMRXitikHoW1hi
nnvH0Wg5lJZDWQUjb8Zuit1sxr7Jgt2wI1KKLeRzw8/2ixa1d8RfNq7vJ5Fn
kTyOcD7kcQk6cQq90YsHCY7kylHriDv2qUId91Rw1Gxp02xr0ex8qt3Xylut
9gCdIe8Q5CVA3lHQHSXceSzk1Z4F3RnQJYE2BTSpfAzSRZcG2nTQZoIuA/Ky
QJsDCrUaFFrUbxetBtRa0DBvq9FDrh4UOeguuubmg7oAchljtRE0RlCjkBW5
iNhBXWS5o6FGyl00xaAtgTyWqGKloNChwF+hC1kOPNGFqQRTFRRWQVE1uwZp
KaaYzVYXIKb9AmyPkj93QvP91A12fW69vyLp3TLTOlGKvgMdKPJ+w4+RVu9q
0exq0+xp0+xlCA6B9jADeQS0J0DDoZ4BbSIgWu15hApqFWRlUH5uFqizuBrU
qNw+OcwhZOpAlQ8ZmPIA17PyWWYBpBtAaaT1VBOkMaUqlPjRQ1kEaUWQiqkY
khnZlGJIw8RgKnHppESajqoyyDAn3tdkV0AOT5WgrgRNFaNfBbpq0NdAQQ1z
WxLiWIz342IEx84Yd5cYy3+D5dgBc2uPb/5FNO3W21zSz3nyBDbYcZiAxF8g
3IdAHd+mSQD1MVAj31MM+llUlvo8GpqbBjkZkMuC2SyKr1TYnzlkqSFTA8o8
yZP0VOZDihHOGyDZSCvnTHDGBKdxaYSzhXCmEE4WckJdThXDiWI4VgTHiuF4
MRsbH8UPJ9osgWMlcJQtBUfcEl49UQInmWM+XQpnMJVBYhmcLYOkcjjHFJxc
DikVkFoBykpIr4SMKsisgqxqyK6G3Bqpdt0Id2wsKTqOKZpCv2gcV8qpdpFo
yZ8a6Iy2zW9OZPOKdBg2I0ax9Hv9PsIocbxz4DjnoPEYJVLtHHMTIfc85KRA
Tir/fW8PRJyWAyo1pGshLQ/S9HSyJCMBTdDD8XzJrpdOFMHRQkgoggMm2FMA
uwpgL1PxnkLYXQi7CmGnCbaZKGezATYbAZeCA37igm2zdhJr4Gd1jGMZW420
i2IH7tYFd8eD7GEtYB+epZhfwz7xJXCEXZXjpXCiDE6VwZlyOFsOSRVwvpLy
06pBVQ0ZNZBZC9l1PEqyaJ0F3khf/myQQqIlv7/N6ZuVLb9H0F3a61Xz1eGM
UeF89iQzAzKyqU6Ikz9fcV4PSfmQxPzoKRMcN8FhE+wvhO35sMtE1qLN2xlH
RLTRAJH5sFrPWS0nwS/VwmIWzfGr4DgjHUKVEJYOIco2nhOihOkqyglT8Sfk
u8/JgHmZMD8LwrNhUQ4sZjHhcjWs0MAqDS/z200FEFsAcQbAS7CdkefYDxbD
4RJI4MCRNtP92Uo4XwUp1ZBWA6payKhjnqVd3jiyWcd/Q41s5L/y5UTls+Bd
JZJszN53lHPASOeAEc6BI9FPCMJJE5xgSkK1HSqC/UVMW4UQYyI+y/JgIfO0
C3K40AWHUUtg2AJGiYb7QldxEogTQBxHWeKYNnF0qziqTVCII3mP6CSOaqW8
sTQhKk54ym5HCA7Dj1r6NVr0CjoH05IhLA1mq2BeBoRnwuJsWJ4Lq9SwRgtR
ebBeB5vM7aM7Xs69TLaHmKM5VgYnK+B0JZytgvPVXPVOVsCicfDNnxpGCvJ7
ee3MzDMj9CUbC5IXHeocMBQDNkFYz3SFQObnwoxMHkQJvVechkVshDtjB0zZ
BJOjwG8VbY4Mh2FzwDuM1l2CQQwA0Z9PkCCRka3iiBbRlxEZ3oqshrdwfYmj
Wd64FnFCC3+GVZzyROLEuDmOPArjTsDE0xCQyNXVK5z1jytyYDW7UMRJD3EF
sM1IV5K38cOlZo+ZWA3naiGFq8qM58DMiQo7fVEn6pK8JV9SEXquv/13ALKZ
574koIMwayftELwO/CNg/FIYvQB8Z8PQMPCeBu5BTD4TuZRQMC0EybdVGtsi
IHHYU3HoE9HnqejDlkNp9gEzBbPKWsQxLbgr5fq3cmsdxNkt1irrK24Cl210
Ju+9MPQgjEyAcWxWIigRQs7BjGSYkwoLVLCEjUIiciFSAxvyINasux6oOER5
pByOo9yqIKmWysWHBsaHBcTPmIwj4g5+GS5n6AAd/2rC/IYNuiL/aYcmu+q9
Jy6FceEwchZVwGcqeAaCuz/T2lgQR7chDU6HIXtibqlej0Xvx+IQUhQuCaQV
v1ZsvOwatIqTJe4OYmibOJeNkJnanYazaHjCMQg4BVMwXmOafJEQ6WErGylg
szyIPg0JVcKpajjLCFlGWHI6coVZRfg//Uwv7iZ/zwZTGxkbvFpyL2Nm8V2F
Xu5+TGIIx5eJCa0fgjweiV4PRU+aBcel6PFQerZZ9MQvMNHcAodm4egg+rWJ
/m1iQBvf7iIuAXEFiJHs+DEgbgEn7tNOwrQzEJYEc9hQd4kKVmbCmhyI1kCM
DrbkSz06r5/jWd4mGSd5nCJX0fNykrdou28VoUvrN5+KjwoB32AYOpnWPcZx
pXUThxAiMs3jgeh+X3Sju7W4VIiu94SebP0++5aXecjJ0Tq20mHo5lolohPa
xIlMYUEgTgMxDMRZkkfsI64Hlxhw3wLeO+jcYw/CpAQIPAZTT0LoGZjNJr2X
KGFFBqzJhmg19/DdkB1qDVvjiSo4Uwvn6tlQdUek/GnFnr+QnjyOsUuPntMY
EwIjAmHYpBaf8eR/PEa1uo1scR2B5qPGHkrRBCITXe+KYjOT0OBmdi5RvCu6
YP59iZHbAyIo4XuCTo76ByfuA83Y6Lu5IIYD6o7WV5t7Zr9DEJDQ3jP3XJsN
6zUQq4NtBRQA7S+G+DI4hu2yBs5eYKy2R3WX2SSP0Z6XVZfOWmQvLDDcr3Xo
uMfeo554+pL/cRv22HXoI9Gb7lGLrs2iyx3RpZm3PUfxx9viD3Q/RfzhloLW
+tD64GZKIt1SQWTtiuONk5ESR2D4QaEII/47whXKEM0BcQGIi6mZ0rmjwHMD
DImF4Vtpc/xemHQQghIg5DjMZDOqi5JhuRLWZMJ6NcTkwdZ8ybMdKoMjlXCy
hh3/1yInb+t/lUgyFb9I7n3kI69hDzx8CJWb931Xr3suHozC4Fvij7dwSes/
3mI29xO/uyl+fwvBUSat3BZ/vCPhY0Jjjo4cG6dGmyPbROw1xjNS/rzV95OQ
LQGXlcwbRIHXBhgWCyMZsol7IfAgTE2AsBMwh03uLUuF1emwLgditOTZdhql
scfJWkish+RGKiMnJCfIiZlHuOb7H/JS8lZoLid09fS+6+5BzcvV7bar620X
l1vcXX9/nbe172+I314XB11z4Lmore9uYs/3/S2JD7ZF5MMjTJQV5foyQY0H
kXcek0EMBHEqsPbWw2MNeK+DYRtg5GYYy8KKgH0w9TCEHYU5JyH8rDRT2TOK
TVxs0UsqwuXRKjhZB2cbILkJVFftsZH7MM7m9edgwfsklx+vu/xwXfzuKlV7
0BVx0FWF+O1VtHbgVfGbK+LXl1n+NYGzQA7dWHu7LQ6+I7Uxd8kV8fkPalpj
KDprxxBM/gg3XWaDy3xwWQSuS2lzyBrJqztMPWiO8TnTqEzYmAtxebDDAHt5
4F4Dp+shqRFSr1h+gd8ZBT4D+0YHvsbyXjG3H6+5fn/VHMMMbBK/aeKr+Mns
/LpJHHBJHEC5RGPQNfG766x0D/E7FMkNqf2wxsM9NnZyhANVwcr9XhwlBay0
NMNAbyPOBJe54BoO7ovBazl9OyIKxmyACZvBfztthuyHGfEw7zgsOgPLz1NO
dBbEqGGrnvlojJ0qpWjTIe0aZNxkCJ+Pi/wO4V9l26w/I+m6fXfZZRA3/pL4
dSOLNsWvLqL1X9HjW7gUv7wofsnWByC9y6Sa71BNN3is0oM8NAplMPMs2Klh
WIDB0xDWZJhQuAXvEJapIE6XZOI+HzwXwpBlLNaIhHEbYOJmCNgGU3dD6H6Y
FQ/zj8OSRFiZDJHsbsBmDY3dsZtHx4ubpy5A0iVIuQrKGxIYeVwk96Wci/yd
eHa5kGEuXzeIAxqYUr6s51S+qGejQPHzevGLBqTCkCC0y9iiuKa+5cp5kbUc
i1ruUbTkzfpxHLughx0HXCw4GOQRvOdc8MZB4lIYwTzshPXgHwtB22DaLtqc
mwDhJ2BZIkSkwLp0iacTyiO+Ek7UQWIjnL8i+RcH1Q1pIGbDQx5vcx5v/wQP
1meR1S5fXhC/qGPm1+GK+MUFvi6NJcXP6sTPLiAaykXBfHUJpcKofYuOhVrV
9zdYJ8A9CDG5T9E214lvK8XirNdxxdHLVHAPAXcW3XjPMbeAcWvMHoSNNHpu
yATUxI4Cch+HK+BYLZy+CEmX2czUDUi7Tiu9n4vB7yQfIvegzPbuVL/P6NEm
8dNq8bNaMpnWa8VPa8RPaljduqD17cLAFvNNkwNpwgkFQejEOy4uzS6uzeaW
4PUAA2kmh6c0tB0LLqxL8QgGrxDwCgXvmbTpGw6jl8H4CJjIRhPBmyFkO8zc
C/MPw+ITlLMmBaLTITYXtumpYVBfUgOnGqTf2SOE5CtsyCuf5ZD/5oxTeEeW
Kx9vWt4W6ij2r2Qsatj1/aRaIfbH/xILJ/HzC0RhAPMYg65gCSRBl8xl8C1X
12ZMLm7Uqbh43JOedGEY2nC06sYxBILXVPCZDkMZhlELYewy8FsNAesgeCOE
xMGMnTB3PyxMgGWnYPU5WKeETdmwNQ92G+FAqfT2xPPXIOU6nGt6YvN8ob0Z
ScHmvZRy6y2xmvhxufivckRAlvOcf1VS6l/lgAyEvigNLlNqD182MM/aRN3u
wCvid/TAtavLbTe3ZlczBBfP+6L3Q9HnMW8br3hOlsbxw6bDiFkwmo3GJiwH
/9UQtA6mbYKwrTBnD4QfgqXHYFUiRLEnUrZoYJdBuvInGyDxMpy71n73y0bV
Nva/+xz286f1CAAK4JMqBqNC/Ah5VEpKEBgC1jyk2WvUAXUsAy+TFND2wTfd
XO+4uZPtrmi7130X7weiDzUGt1GtHmPbvCZKMwlOkyMgKBKmbYSwOJizS4oj
um1hE1t4mROq4UQDnGmCJBYzyaMh+VXm98r/KLV0uZczzzOjtj8qZQZWMIs+
KsOcj2kdjUOTLdfc5fM6F9Q57xmEV5mJ1Im6/HjDzeWWu3uzOwvLXZl9bkMf
e4yg6NprbNsQPxgawEKBEBg9E8bNg4mLpDFb96VHIOI0rEuBTZnAr+cBNh98
4iKcuczqZ+8NrLZW/kmW+5eOrHVg1tLjsmjrh6W4bbm2Dqhn9GufVKOlrl9c
cPmSHLvLgItsvz+I35JvdxVvurvd9mCW4mDEbcgDj+E4qiNLfSbgEBh8A2Hk
VDasmg0TF8DkJRDMJkRnbILZWyF8Dyw9DKtOQOQ52JgOeGV3YQMug4QaONnI
vb68t5bfOeP2yt/XSvay+2ncN39EP0QRPyzBqyn+q4KZ3b+SxX6uX9S5fVnv
iumrBrTN5etGl4GXmG5/i1fRw/2Oh9c9D+/7nj4PvX2f+LD5WF9/GBEAo6YA
jvNx0z8cgpbBlFUQEgkzNsKcLbBwDyyLh4gTEJUEMRmwjbmlg+Xm/vn0ZTh5
8QnV8nf22qGNbfL33LJrKX+jsPjPQvGDIvOI+YNiLmJ2VdFSB65mN+y9FW4D
6oWubiyucf2m0XXgJbfvqFm6izcl7zNk2EOfEU+GjWkdwXzxmGAYNw0mzAD/
ebQ5LQLComHWJpi3hTaXH4Y1KNjzkqHc855sglNNrKuW9yj2LfyL1CaZZd1k
lrm8b3L5Z6HLB0XSSKZ/pUv/Ckyun9Ljr+4D6hXuXzew+MTtm0b3QU0e31/x
HEx9rpf7bW/P5iHe97hdL45i5oyfCn6h4D8HghbSZthamL0RFmyDRbth+SE2
Y35eGqvGV5ujDe41BCfrmrHHOFgN5Z5E3vaYzX9glhjRGFr5oMjlw2IXpkpX
bgymz8idegyo9/imwf0biizdBzZ6fNvk+cMVL5Hs8fG84+N9d6jP/eHDaaZj
tN+Tsf4t4wJgwhSq5+TZ0j2IbhtSIC6buY5ySKiD441w4hKVYPVqf54NV3j9
5THPf9irf2+q6vtGSv+k3zS7flDk+lGJ68fcBBKam7n+ngMvCgoPXLzl+e0l
z++avH684s0MGObdPNzn3vBhD0aOJG8/zr/Fb0rrpGlt/mxWZko4TF8BM1bD
nPVsBmEvrIqHdYkQi8Jit+EOVcLR+vY3P9tcDd6LyUeBf7TnP150/R8DmuL2
AZni9mGR24fFbswUt/7l7p9Wun9W5fEldeFeAy8qvAY1sic/fcRrPi7Xh7re
GOZBo8ERQ++P9H04egwFr34Brf4hbYEzIWgO09RymB0J8zbAoq2wkg16o8/C
5gzYoYd9xRBfC4qjF5+ZBfqzzZXhtvxdahd2bSBRu71vdGc2KNw/Kha6uH9M
PzJx71/u8Wml5+dVnl/Wck825FuKxIa5Xvf1vOXrdXuENw1KRvk+GDv68fjx
T/0mtU4KagucDlPmQEg4hLHx2IJNsHgbrNwPkeyOyNYcFlqxW5JH0TP/3apG
7ez/S1ZPeet3NCvJ44NCj4+KPT8u8cD0r1KP/tQBeX5W6fV5tfdXBN5n0EWf
7xqHft/E226f0cNppmrc6Md+E1smTW6bHAzBM2DqHAhdCDOXw/xoWLQZlu2E
NUchGhWjlPzQkYtwqOYunfT/SCR5Pf8hq9fv7dXTkdfT8yP2u3Kv/qVCL69P
qJ7eX1R5f1k9ZADF+0MHNQz7/tLwHy/7ulJcN9qnedyIBzxOcQyeLvmP2av4
DJHDrgI4UAEJ9bwn+MczdZK/o1veN1ieQfD6uMgbK6Pwxsq84v1p+ZAvqny+
qvEZUDt04IVh35Jb9/2haYTL1ZHu1ObGDr07YeTDieOeTppAfVfwNJg2E6bP
g1nLeP//wvIdsCYe1p+BWPawLQr0cC0cZvPB7J2/v8EqtD9p+D+yWr1tr5bv
EqSP6cfjPli9z8p9PqfOZ9jXtcO+rvP9tmHED/Qs5yiXq2M8b471vj1uaPOE
kQ8mjn3k79cSwALfkBkQNh9mL4MFa2FJDKzcBZEJsDEJtmZLY5yEBloSMUeL
F3tfoimvkWU+8G2fT8uGfl4x9Muq4QNqfAde8B1UP/KHxlEu1PmN9bwxYVjz
hGF3/UaSzgL9nwQHtU6fCTNYlzdvFSyNhRU7YDW737U1C3bqYH8ZHGZ3GJjq
25+Pkr+RXP5kvPkNacIbw7+q9v2GxD7y+4ujBzeNdb821uP6BJ/bk0Y+8B/9
MGD8oynBT6eFtIaEwuzFsIANfZfFQdQRiD4BMcmwgz04dqiW1eHvUh34b7A+
lJ1THhmb3+YivO47oNrSx40efGms65XxiGLIrUm+9wLGPgr0ezolsC00FGbO
g9kLIXwNLI+DFVshKh5izsFWdlv0YBUcboC/Sefnv1KUv+Nd/h50Nl9FIf6o
gXVjfrg45sfGsSKFzn7eUgziMDWQjj1rrjlmWhYDq3fD+uPm7X1lcLCeHcsc
6fH31HwsqcDem9fZ3anxLk3jXS9PcKfZmsm+dwNG3Q+e8DgkiO7TzJwF85dK
z3pGHoLoY2TkDi3guQRzr+NgPrbQX3YG+RiTXQn67elEr+v+Q2/juQJHP5ji
9yQksHVGKN33WrAUlkTCSryiLOzYjh7WAPurYP8F+JNkE38P/yeyI8t/m8jO
9BLZM/R20Oj70ya1hExuDZvWNmsmLFhMh14RA5H7YMMJ2JoOe9CL4znYzUU2
4qPz8HdHy9+Gb/dXucRwmt+T0GAyYe58WLgclkXD6u0QnQBxKYRrbwlj+I50
bP4O/c+k6yI/Zi9za+i2LBIitsC6gxCbBDu1bITHnNDvpOPwvw/whWx/+ewO
bXMF7Ss1R29vS9eN/92ML2V7yO85m1sz/9scX9mpr3zGnUrzv2syQLJSXurP
UinmG4Rv7GlTFrFQ6X+x0gPttR1ZH0ubn7HSg2TfymdA35KOzSgI30r1lZd6
XSrFaip8L/tWPq5+RSr9HSv9g+xb+fi0j1R6MCv9o+xb+eiup1TajZUeLPtW
Ppp4QWLhxUqLYNW/yupPx/RhpVytvjXH9PStL/uWzkuB5mi2JfzmfwEPoGMx
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->733744067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89183790],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " is used in ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " to visualize regions the get covered multiple times:"
}], "ExampleText",
 CellID->136989743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "@", 
    RowBox[{
     RowBox[{"RotationTransform", "[", "\[Theta]", "]"}], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"Sin", "[", "u", "]"}]}], "}"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9786337],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6914335]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->278753854],

Cell["\<\
If the opacity is too small, objects will typically render as completely \
transparent:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->22046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Opacity", "[", 
     RowBox[{"1", "/", "1000"}], "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5914],

Cell[BoxData[
 GraphicsBox[
  {Opacity[
    NCache[
     Rational[1, 1000], 0.001]], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->16906004]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->109041519],

Cell["\<\
Overlapping of multiple translucent objects can generate an opaque result:\
\>", "ExampleText",
 CellID->7838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Opacity", "[", 
     RowBox[{"1", "/", "5"}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"i", "/", "10"}], ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65002792],

Cell[BoxData[
 GraphicsBox[
  {Opacity[
    NCache[
     Rational[1, 5], 0.2]], DiskBox[NCache[{Rational[1, 10], 0}, {0.1, 0}]], 
   DiskBox[NCache[{Rational[1, 5], 0}, {0.2, 0}]], 
   DiskBox[NCache[{Rational[3, 10], 0}, {0.3, 0}]], 
   DiskBox[NCache[{Rational[2, 5], 0}, {0.4, 0}]], 
   DiskBox[NCache[{Rational[1, 2], 0}, {0.5, 0}]], 
   DiskBox[NCache[{Rational[3, 5], 0}, {0.6, 0}]], 
   DiskBox[NCache[{Rational[7, 10], 0}, {0.7, 0}]], 
   DiskBox[NCache[{Rational[4, 5], 0}, {0.8, 0}]], 
   DiskBox[NCache[{Rational[9, 10], 0}, {0.9, 0}]], 
   DiskBox[{1, 0}]}]], "Output",
 ImageSize->{154, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->942561153]
}, Open  ]],

Cell["\<\
If each opacity is too small, any number of elements together will still \
render as transparent:\
\>", "ExampleText",
 CellID->14143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Opacity", "[", 
     RowBox[{"1", "/", "100"}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"i", "/", "10"}], ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20581],

Cell[BoxData[
 GraphicsBox[
  {Opacity[
    NCache[
     Rational[1, 100], 0.01]], 
   DiskBox[NCache[{Rational[1, 10], 0}, {0.1, 0}]], 
   DiskBox[NCache[{Rational[1, 5], 0}, {0.2, 0}]], 
   DiskBox[NCache[{Rational[3, 10], 0}, {0.3, 0}]], 
   DiskBox[NCache[{Rational[2, 5], 0}, {0.4, 0}]], 
   DiskBox[NCache[{Rational[1, 2], 0}, {0.5, 0}]], 
   DiskBox[NCache[{Rational[3, 5], 0}, {0.6, 0}]], 
   DiskBox[NCache[{Rational[7, 10], 0}, {0.7, 0}]], 
   DiskBox[NCache[{Rational[4, 5], 0}, {0.8, 0}]], 
   DiskBox[NCache[{Rational[9, 10], 0}, {0.9, 0}]], 
   DiskBox[{1, 0}]}]], "Output",
 ImageSize->{184, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->191257907]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103934476],

Cell[TextData[{
 "Completely transparent objects are still counted for ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Disk", "[", "]"}], ",", 
       RowBox[{"Disk", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Disk", "[", "]"}], ",", 
       RowBox[{"Opacity", "[", "0", "]"}], ",", 
       RowBox[{"Disk", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300147972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{DiskBox[{0, 0}], DiskBox[{0, 1}]},
    Frame->True], ",", 
   GraphicsBox[{DiskBox[{0, 0}], 
     {Opacity[0], DiskBox[{0, 1}]}},
    Frame->True]}], "}"}]], "Output",
 ImageSize->{230, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->8352638]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18091],

Cell["Random collection of transparent cylinders:", "ExampleText",
 CellID->85318682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "]"}], ",", 
    RowBox[{"Opacity", "[", ".5", "]"}], ",", 
    RowBox[{"Cylinder", "/@", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"5", ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "2", ",", "3"}], "}"}]}], "]"}]}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->326090672],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.5], EdgeForm[None], 
   CylinderBox[{{0.6269910762381514, 4.013375376738876, 
    0.03071612254626266}, {2.5455444586000997`, 2.9692556261237932`, 
    2.8178920151873266`}}], 
   CylinderBox[{{2.75988439194365, 2.503185839700052, 2.1746340337097294`}, {
    0.816544433055898, 2.3326027514162115`, 1.8832849099502458`}}], 
   CylinderBox[{{0.3348847088289364, 3.762532636580013, 
    2.4944212704210966`}, {0.5122662272281198, 1.4000705025548688`, 
    3.033592385245586}}], 
   CylinderBox[{{0.5778040454469602, 3.125066038225185, 1.615817731790038}, {
    1.101930895022225, 0.666908545863375, 2.459170915255624}}], 
   CylinderBox[{{2.7398006102369865`, 3.941281636379921, 
    1.3830413846780687`}, {0.3311797753207568, 4.473933757056887, 
    1.296631492225232}}], 
   CylinderBox[{{2.3655890463545104`, 4.926393916245884, 4.986077080971036}, {
    1.3765627318590956`, 2.431195218494089, 1.0041002178469172`}}], 
   CylinderBox[{{1.110214961766568, 0.01274051632810691, 
    4.6772715766336805`}, {4.2499245119224565`, 1.084191461838434, 
    0.9418625800910518}}], 
   CylinderBox[{{4.846795621415373, 2.234649169964947, 3.1305993541548327`}, {
    2.418502622150105, 3.035911477825427, 4.0976283568693965`}}], 
   CylinderBox[{{4.861697629406809, 3.2095963554067772`, 4.733360772362798}, {
    1.995517550838125, 0.4091791139429546, 4.685963298610617}}], 
   CylinderBox[{{4.567627938935717, 0.894380524121674, 3.7375069533550276`}, {
    0.3184229937360772, 2.0848604596673317`, 3.6778769991916302`}}], 
   CylinderBox[{{2.052664813158167, 2.8387346159170255`, 2.786715604339677}, {
    2.9697658708388586`, 0.9911210797122105, 4.808787512008146}}], 
   CylinderBox[{{1.580433523563216, 1.9543064723130588`, 
    3.8998936266845474`}, {2.8405157174920315`, 4.922316050059052, 
    1.7946519842975694`}}], 
   CylinderBox[{{3.433034331959167, 3.793865835802541, 3.8826207424568993`}, {
    3.527991744423696, 3.6642984996461383`, 0.7505292825985277}}], 
   CylinderBox[{{2.3183967388825844`, 3.6524938077220295`, 
    2.8534716015390806`}, {0.7112777092519629, 1.071003335366283, 
    0.40931139740152167`}}], 
   CylinderBox[{{1.3109508886579146`, 3.5360551077307023`, 
    3.689074557178378}, {1.7569676119839661`, 3.2635860479148846`, 
    4.264793653372275}}], 
   CylinderBox[{{1.6678515313869335`, 3.4494318198401643`, 
    4.563114677353459}, {1.4380617615650815`, 0.4755162681901115, 
    2.2640838057477675`}}], 
   CylinderBox[{{2.523801882799738, 1.3873864866174745`, 
    1.6232410765250127`}, {4.870971859444727, 4.388840369134441, 
    0.7165104374975884}}], 
   CylinderBox[{{1.6529967463739548`, 0.7424759893768973, 
    3.953905473474435}, {0.232232115527079, 2.1584274469873357`, 
    0.5018591619784452}}], 
   CylinderBox[{{2.308085461317222, 4.54589319163434, 3.0303701955590903`}, {
    4.88020895059151, 3.7552716172030043`, 4.76682674839798}}], 
   CylinderBox[{{0.22397621949398094`, 4.101269114739429, 
    4.170916010088051}, {4.5786932415476915`, 2.9399788981149086`, 
    1.259704345246998}}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->735139497,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6316],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Glow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowOpacity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowOpacity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3592],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Opacity",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Opacity"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->496628656],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->155700968],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->871431778],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->437923878],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->136168285],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->590157475],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->376703215]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Opacity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 44.9705996}", "context" -> "System`", 
    "keywords" -> {"alpha channel", "opaque", "translucent", "transparent"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Opacity[a] is a graphics directive which specifies that graphical \
objects which follow are to be displayed, if possible, with opacity a. \
Opacity[a, color] uses the specified color with opacity a.", "synonyms" -> {},
     "title" -> "Opacity", "type" -> "Symbol", "uri" -> "ref/Opacity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9049, 275, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->763136768]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 589451, 10578}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3265, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3888, 98, 1572, 37, 70, "ObjectNameGrid"],
Cell[5463, 137, 1069, 33, 70, "Usage",
 CellID->32555]
}, Open  ]],
Cell[CellGroupData[{
Cell[6569, 175, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7047, 192, 109, 3, 70, "Notes",
 CellID->32557],
Cell[7159, 197, 736, 29, 70, "Notes",
 CellID->15334],
Cell[7898, 228, 278, 7, 70, "Notes",
 CellID->14317],
Cell[8179, 237, 200, 7, 70, "Notes",
 CellID->13300],
Cell[8382, 246, 132, 4, 70, "Notes",
 CellID->7040],
Cell[8517, 252, 136, 4, 70, "Notes",
 CellID->3623],
Cell[8656, 258, 356, 12, 70, "Notes",
 CellID->17853]
}, Closed]],
Cell[CellGroupData[{
Cell[9049, 275, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->763136768],
Cell[CellGroupData[{
Cell[9434, 289, 148, 5, 70, "ExampleSection",
 CellID->852183444],
Cell[9585, 296, 69, 1, 70, "ExampleText",
 CellID->25574],
Cell[CellGroupData[{
Cell[9679, 301, 217, 7, 28, "Input",
 CellID->30161],
Cell[9899, 310, 29688, 492, 201, 81, 2, "CachedBoxData", "BoxData", "Output",
 CellID->29423]
}, Open  ]],
Cell[39602, 805, 121, 3, 70, "ExampleDelimiter",
 CellID->26018],
Cell[39726, 810, 65, 1, 70, "ExampleText",
 CellID->1875],
Cell[CellGroupData[{
Cell[39816, 815, 454, 15, 28, "Input",
 CellID->19734],
Cell[40273, 832, 28904, 478, 172, "Output",
 Evaluatable->False,
 CellID->34444979]
}, Open  ]],
Cell[69192, 1313, 124, 3, 70, "ExampleDelimiter",
 CellID->97342231],
Cell[69319, 1318, 76, 1, 70, "ExampleText",
 CellID->276525671],
Cell[CellGroupData[{
Cell[69420, 1323, 334, 10, 70, "Input",
 CellID->4531],
Cell[69757, 1335, 267, 8, 143, "Output",
 CellID->681735620]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70073, 1349, 220, 7, 70, "ExampleSection",
 CellID->138890108],
Cell[70296, 1358, 81, 1, 70, "ExampleText",
 CellID->18483],
Cell[CellGroupData[{
Cell[70402, 1363, 373, 12, 70, "Input",
 CellID->7226],
Cell[70778, 1377, 40144, 673, 131, "Output",
 CellID->210253505]
}, Open  ]],
Cell[110937, 2053, 125, 3, 70, "ExampleDelimiter",
 CellID->159117063],
Cell[111065, 2058, 105, 2, 70, "ExampleText",
 CellID->758618147],
Cell[CellGroupData[{
Cell[111195, 2064, 539, 17, 70, "Input",
 CellID->384338528],
Cell[111737, 2083, 16506, 277, 160, 272, 6, "CachedBoxData", "BoxData", \
"Output",
 CellID->190947587]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[128292, 2366, 243, 7, 70, "ExampleSection",
 CellID->156514624],
Cell[128538, 2375, 214, 8, 70, "ExampleText",
 CellID->70579336],
Cell[CellGroupData[{
Cell[128777, 2387, 472, 15, 70, "Input",
 CellID->367089503],
Cell[129252, 2404, 18241, 320, 131, "Output",
 CellID->124058290]
}, Open  ]],
Cell[147508, 2727, 125, 3, 70, "ExampleDelimiter",
 CellID->623038887],
Cell[147636, 2732, 223, 7, 70, "ExampleText",
 CellID->675518163],
Cell[CellGroupData[{
Cell[147884, 2743, 468, 15, 70, "Input",
 CellID->114361079],
Cell[148355, 2760, 16683, 278, 70, "Output",
 Evaluatable->False,
 CellID->169675412]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[165087, 3044, 226, 7, 70, "ExampleSection",
 CellID->97445566],
Cell[165316, 3053, 68, 1, 70, "ExampleText",
 CellID->204233308],
Cell[CellGroupData[{
Cell[165409, 3058, 719, 23, 70, "Input",
 CellID->186151104],
Cell[166131, 3083, 43019, 709, 70, "Output",
 Evaluatable->False,
 CellID->542251816]
}, Open  ]],
Cell[209165, 3795, 125, 3, 70, "ExampleDelimiter",
 CellID->448459237],
Cell[209293, 3800, 223, 8, 70, "ExampleText",
 CellID->137930274],
Cell[CellGroupData[{
Cell[209541, 3812, 858, 24, 70, "Input",
 CellID->60161043],
Cell[210402, 3838, 101491, 1675, 274, 37097, 615, "CachedBoxData", "BoxData", \
"Output",
 CellID->6170815]
}, Open  ]],
Cell[CellGroupData[{
Cell[311930, 5518, 915, 26, 70, "Input",
 CellID->631161667],
Cell[312848, 5546, 76024, 1250, 70, "Output",
 Evaluatable->False,
 CellID->120101363]
}, Open  ]],
Cell[388887, 6799, 124, 3, 70, "ExampleDelimiter",
 CellID->41614120],
Cell[389014, 6804, 248, 8, 70, "ExampleText",
 CellID->66291749],
Cell[CellGroupData[{
Cell[389287, 6816, 811, 24, 70, "Input",
 CellID->646558465],
Cell[390101, 6842, 38095, 629, 70, "Output",
 Evaluatable->False,
 CellID->171361551]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[428245, 7477, 237, 7, 70, "ExampleSection",
 CellID->268948481],
Cell[428485, 7486, 163, 4, 70, "ExampleText",
 CellID->618362617],
Cell[CellGroupData[{
Cell[428673, 7494, 416, 13, 70, "Input",
 CellID->9848823],
Cell[429092, 7509, 336, 9, 123, "Output",
 CellID->449453632]
}, Open  ]],
Cell[429443, 7521, 125, 3, 70, "ExampleDelimiter",
 CellID->312663135],
Cell[429571, 7526, 103, 2, 70, "ExampleText",
 CellID->103358547],
Cell[CellGroupData[{
Cell[429699, 7532, 551, 17, 70, "Input",
 CellID->16585],
Cell[430253, 7551, 430, 13, 123, "Output",
 CellID->282217152]
}, Open  ]],
Cell[430698, 7567, 124, 3, 70, "ExampleDelimiter",
 CellID->33159238],
Cell[430825, 7572, 135, 4, 70, "ExampleText",
 CellID->7182311],
Cell[CellGroupData[{
Cell[430985, 7580, 571, 17, 70, "Input",
 CellID->572328202],
Cell[431559, 7599, 11595, 198, 131, "Output",
 CellID->118625561]
}, Open  ]],
Cell[CellGroupData[{
Cell[443191, 7802, 626, 20, 70, "Input",
 CellID->621098068],
Cell[443820, 7824, 18566, 315, 131, "Output",
 CellID->276128277]
}, Open  ]],
Cell[CellGroupData[{
Cell[462423, 8144, 593, 17, 70, "Input",
 CellID->827815630],
Cell[463019, 8163, 19705, 332, 131, "Output",
 CellID->730004238]
}, Open  ]],
Cell[482739, 8498, 124, 3, 70, "ExampleDelimiter",
 CellID->60788142],
Cell[482866, 8503, 224, 7, 70, "ExampleText",
 CellID->253154528],
Cell[CellGroupData[{
Cell[483115, 8514, 368, 12, 70, "Input",
 CellID->705326715],
Cell[483486, 8528, 5482, 94, 70, "Output",
 Evaluatable->False,
 CellID->90474982]
}, Open  ]],
Cell[488983, 8625, 125, 3, 70, "ExampleDelimiter",
 CellID->188029544],
Cell[489111, 8630, 214, 7, 70, "ExampleText",
 CellID->295686092],
Cell[CellGroupData[{
Cell[489350, 8641, 635, 22, 70, "Input",
 CellID->260745424],
Cell[489988, 8665, 16195, 270, 70, "Output",
 Evaluatable->False,
 CellID->733744067]
}, Open  ]],
Cell[506198, 8938, 124, 3, 70, "ExampleDelimiter",
 CellID->89183790],
Cell[506325, 8943, 376, 12, 70, "ExampleText",
 CellID->136989743],
Cell[CellGroupData[{
Cell[506726, 8959, 577, 18, 70, "Input",
 CellID->9786337],
Cell[507306, 8979, 29564, 489, 70, "Output",
 Evaluatable->False,
 CellID->6914335]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[536919, 9474, 230, 7, 70, "ExampleSection",
 CellID->278753854],
Cell[537152, 9483, 182, 5, 70, "ExampleText",
 CellID->22046],
Cell[CellGroupData[{
Cell[537359, 9492, 239, 8, 70, "Input",
 CellID->5914],
Cell[537601, 9502, 297, 10, 121, "Output",
 CellID->16906004]
}, Open  ]],
Cell[537913, 9515, 125, 3, 70, "ExampleDelimiter",
 CellID->109041519],
Cell[538041, 9520, 120, 3, 70, "ExampleText",
 CellID->7838],
Cell[CellGroupData[{
Cell[538186, 9527, 451, 15, 70, "Input",
 CellID->65002792],
Cell[538640, 9544, 765, 19, 126, "Output",
 CellID->942561153]
}, Open  ]],
Cell[539420, 9566, 144, 4, 70, "ExampleText",
 CellID->14143],
Cell[CellGroupData[{
Cell[539589, 9574, 450, 15, 70, "Input",
 CellID->20581],
Cell[540042, 9591, 720, 19, 147, "Output",
 CellID->191257907]
}, Open  ]],
Cell[540777, 9613, 125, 3, 70, "ExampleDelimiter",
 CellID->103934476],
Cell[540905, 9618, 232, 8, 70, "ExampleText",
 CellID->246],
Cell[CellGroupData[{
Cell[541162, 9630, 722, 23, 70, "Input",
 CellID->300147972],
Cell[541887, 9655, 405, 13, 149, "Output",
 CellID->8352638]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[542341, 9674, 224, 7, 70, "ExampleSection",
 CellID->18091],
Cell[542568, 9683, 85, 1, 70, "ExampleText",
 CellID->85318682],
Cell[CellGroupData[{
Cell[542678, 9688, 403, 13, 70, "Input",
 CellID->326090672],
Cell[543084, 9703, 40504, 671, 216, 3087, 53, "CachedBoxData", "BoxData", \
"Output",
 CellID->735139497]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[583649, 10381, 310, 9, 70, "SeeAlsoSection",
 CellID->6316],
Cell[583962, 10392, 1670, 62, 70, "SeeAlso",
 CellID->30723]
}, Open  ]],
Cell[CellGroupData[{
Cell[585669, 10459, 313, 9, 70, "TutorialsSection",
 CellID->3592],
Cell[585985, 10470, 197, 4, 70, "Tutorials",
 CellID->815154705]
}, Open  ]],
Cell[CellGroupData[{
Cell[586219, 10479, 305, 8, 70, "RelatedLinksSection"],
Cell[586527, 10489, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[586923, 10506, 319, 9, 70, "MoreAboutSection",
 CellID->496628656],
Cell[587245, 10517, 124, 3, 70, "MoreAbout",
 CellID->155700968],
Cell[587372, 10522, 149, 3, 70, "MoreAbout",
 CellID->871431778],
Cell[587524, 10527, 163, 3, 70, "MoreAbout",
 CellID->437923878],
Cell[587690, 10532, 162, 3, 70, "MoreAbout",
 CellID->136168285],
Cell[587855, 10537, 197, 4, 70, "MoreAbout",
 CellID->590157475],
Cell[588055, 10543, 179, 3, 70, "MoreAbout",
 CellID->376703215]
}, Open  ]],
Cell[588249, 10549, 27, 0, 70, "History"],
Cell[588279, 10551, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

