(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42634,       1553]
NotebookOptionsPosition[     35001,       1292]
NotebookOutlinePosition[     36719,       1335]
CellTagsIndexPosition[     36633,       1330]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Toggler" :> Documentation`HelpLookup["paclet:ref/Toggler"], 
          "Checkbox" :> Documentation`HelpLookup["paclet:ref/Checkbox"], 
          "OpenerView" :> Documentation`HelpLookup["paclet:ref/OpenerView"], 
          "ShowGroupOpener" :> 
          Documentation`HelpLookup["paclet:ref/ShowGroupOpener"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Toggler\"\>", 2->"\<\"Checkbox\"\>",
        3->"\<\"OpenerView\"\>", 
       4->"\<\"ShowGroupOpener\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Control Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Opener", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Opener",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Opener"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an opener with setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", displayed as ",
     Cell[BoxData[
      TagBox[
       OpenerBox[True],
       EventHandlerTag[{
        "MouseDown" -> Null, PassEventsDown -> Automatic, PassEventsUp -> 
         True}]]]],
     " when ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      TagBox[
       OpenerBox[False],
       EventHandlerTag[{
        "MouseDown" -> Null, PassEventsDown -> Automatic, PassEventsUp -> 
         True}]]]],
     " when ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Opener",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Opener"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being toggled if the opener is clicked. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->8684]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 " is effectively a special case of ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4823],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 " is often used with ",
 Cell[BoxData[
  ButtonBox["PaneSelector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaneSelector"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->761409386]
}], "Notes",
 CellID->16311],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5623],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Opener",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opener"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Opener",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opener"], "[", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22065]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->50107893],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->175789906],

Cell["Dynamically change a variable:", "ExampleText",
 CellID->40340557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Opener", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104760991],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OpenerBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{77, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283118547]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->84034620],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["PaneSelector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaneSelector"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->761409386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Opener", "[", 
     RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"PaneSelector", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"False", "\[Rule]", "\"\<Heading\>\""}], ",", 
        RowBox[{"True", "\[Rule]", "\"\<Actual content\>\""}]}], "}"}], ",", 
      RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168332755],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   OpenerBox[Dynamic[$CellContext`x]], "\[InvisibleSpace]", 
   PaneSelectorBox[{False->"\<\"Heading\"\>", True->"\<\"Actual content\"\>"},
     Dynamic[$CellContext`x]]}],
  Row[{
    Opener[
     Dynamic[$CellContext`x]], 
    PaneSelector[{False -> "Heading", True -> "Actual content"}, 
     Dynamic[$CellContext`x]]}]]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222390748]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->186177581],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->464933523],

Cell["Change the appearance:", "ExampleText",
 CellID->89339116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Opener", "[", 
    RowBox[{"False", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141448378],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OpenerBox[False,
    Appearance->Tiny], ",", 
   OpenerBox[False,
    Appearance->Small], ",", 
   OpenerBox[False,
    Appearance->Medium], ",", 
   OpenerBox[False,
    Appearance->Large]}], "}"}]], "Output",
 ImageSize->{99, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->399936161]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Opener", "[", 
    RowBox[{"True", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->93513674],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OpenerBox[True,
    Appearance->Tiny], ",", 
   OpenerBox[True,
    Appearance->Small], ",", 
   OpenerBox[True,
    Appearance->Medium], ",", 
   OpenerBox[True,
    Appearance->Large]}], "}"}]], "Output",
 ImageSize->{99, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->170983184]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->301785698],

Cell["By default the opener changes only when you click it:", "ExampleText",
 CellID->487046052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Opener", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "Large"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119939086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OpenerBox[Dynamic[$CellContext`x],
    Appearance->Large], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{82, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->809802547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->85169209],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", the opener toggles as the mouse moves over the opener area:"
}], "ExampleText",
 CellID->648410836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Opener", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "Large"}], ",", 
     RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289477877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OpenerBox[Dynamic[$CellContext`x],
    Appearance->Large,
    AutoAction->True], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{82, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2843090]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->340237004],

Cell["Change the background color:", "ExampleText",
 CellID->59225769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Opener", "[", 
    RowBox[{"False", ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Yellow", ",", "Purple", ",", "Black"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51473715],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OpenerBox[False,
    Background->RGBColor[1, 0.5, 0.5]], ",", 
   OpenerBox[False,
    Background->RGBColor[1, 1, 0]], ",", 
   OpenerBox[False,
    Background->RGBColor[0.5, 0, 0.5]], ",", 
   OpenerBox[False,
    Background->GrayLevel[0]]}], "}"}]], "Output",
 ImageSize->{100, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364834387]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12883043],

Cell["Align with surrounding text:", "ExampleText",
 CellID->106430421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Opener", "[", 
      RowBox[{"BaselinePosition", "\[Rule]", "p"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Bottom", ",", "Center", ",", "Top"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45522410],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   OpenerBox[False,
    BaselinePosition->Bottom], "xxx", 
   OpenerBox[False,
    BaselinePosition->Center], "xxx", 
   OpenerBox[False,
    BaselinePosition->Top]}],
  Row[{
    Opener[BaselinePosition -> Bottom], 
    Opener[BaselinePosition -> Center], 
    Opener[BaselinePosition -> Top]}, "xxx"]]], "Output",
 ImageSize->{94, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->590966538]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->505676316],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->23298786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Opener", "[", "False", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 OpenerBox[False]], "Output",
 ImageSize->{16, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132872562]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61836355],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], " ", "\[Rule]", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the opener is disabled but visible in its current state:"
}], "ExampleText",
 CellID->4733516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Opener", "[", 
  RowBox[{"True", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227336428],

Cell[BoxData[
 OpenerBox[True,
  Enabled->False]], "Output",
 ImageSize->{16, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->240477045]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->108832654],

Cell[TextData[{
 "Include margins around the ",
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3977836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Opener", "[", 
     RowBox[{"ImageMargins", "\[Rule]", "i"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "15", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->262736791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    OpenerBox[False,
     ImageMargins->0],
    StripOnInput->False], ",", 
   FrameBox[
    OpenerBox[False,
     ImageMargins->5],
    StripOnInput->False], ",", 
   FrameBox[
    OpenerBox[False,
     ImageMargins->15],
    StripOnInput->False], ",", 
   FrameBox[
    OpenerBox[False,
     ImageMargins->30],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{240, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->590868105]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->377414513],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["PaneSelector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaneSelector"]], "InlineFormula"],
 " for hiding and exposing additional controls:"
}], "ExampleText",
 CellID->431069108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opener", "[", 
        RowBox[{"Dynamic", "[", "y", "]"}], "]"}], ",", 
       RowBox[{"PaneSelector", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"False", "\[Rule]", "\"\<\>\""}], ",", 
           RowBox[{"True", "\[Rule]", 
            RowBox[{"Animator", "[", 
             RowBox[{
              RowBox[{"Dynamic", "[", "x", "]"}], ",", 
              RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
              RowBox[{"AppearanceElements", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                "\"\<StepLeftButton\>\"", ",", "\"\<PlayPauseButton\>\"", 
                 ",", "\"\<StepRightButton\>\"", ",", 
                 "\"\<FasterSlowerButtons\>\"", ",", 
                 "\"\<DirectionButton\>\""}], "}"}]}]}], "]"}]}]}], "}"}], 
         ",", 
         RowBox[{"Dynamic", "[", "y", "]"}]}], "]"}]}], "}"}], "]"}]}], "}"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->640085565],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SliderBox[Dynamic[$CellContext`x]]},
    {
     InterpretationBox[
      RowBox[{
       OpenerBox[Dynamic[$CellContext`y]], "\[InvisibleSpace]", 
       PaneSelectorBox[{False->"\<\"\"\>", True->
        AnimatorBox[Dynamic[$CellContext`x],
         AppearanceElements->{
          "StepLeftButton", "PlayPauseButton", "StepRightButton", 
           "FasterSlowerButtons", "DirectionButton"},
         PausedTime->0]}, Dynamic[$CellContext`y]]}],
      Row[{
        Opener[
         Dynamic[$CellContext`y]], 
        PaneSelector[{False -> "", True -> Animator[
            Dynamic[$CellContext`x], AnimationRunning -> False, 
            AppearanceElements -> {
             "StepLeftButton", "PlayPauseButton", "StepRightButton", 
              "FasterSlowerButtons", "DirectionButton"}]}, 
         Dynamic[$CellContext`y]]}]]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{204, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388464649]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->72240602],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->499252316],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"g1", ",", "g2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Gray", ",", 
         RowBox[{"Rotate", "[", 
          RowBox[{
           RowBox[{"Polygon", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
           RowBox[{"3", " ", 
            RowBox[{"\[Pi]", "/", "2"}]}]}], "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "10"}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Gray", ",", 
         RowBox[{"Rotate", "[", 
          RowBox[{
           RowBox[{"Polygon", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}], ",", "\[Pi]"}],
           "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "10"}]}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2242833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Toggler", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"False", "\[Rule]", "g1"}], ",", 
       RowBox[{"True", "\[Rule]", "g2"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->505999585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TogglerBox[Dynamic[$CellContext`x], {False->
    GraphicsBox[
     {GrayLevel[0.5], 
      GeometricTransformationBox[
       PolygonBox[{{-1, 0}, {1, 0}, {0, 2}}], {{{0, 1}, {-1, 0}}, Center}]},
     ImageSize->10], True->
    GraphicsBox[
     {GrayLevel[0.5], 
      GeometricTransformationBox[
       PolygonBox[{{-1, 0}, {1, 0}, {0, 2}}], {{{-1, 0}, {0, -1}}, Center}]},
     ImageSize->10]}, 
    DynamicBox[ToBoxes[$CellContext`x, StandardForm],
     ImageSizeCache->{35., {0., 8.}}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{102, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->755857007]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Opener", "[", 
    RowBox[{"Dynamic", "[", "y", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20201787],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OpenerBox[Dynamic[$CellContext`y]], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{77, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1322944644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->550616500],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " is a combination of ",
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PaneSelector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaneSelector"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->36865483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opener", "[", 
       RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
      RowBox[{"PaneSelector", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"False", "\[Rule]", "\"\<Heading\>\""}], ",", 
          RowBox[{"True", "\[Rule]", 
           RowBox[{"Column", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<Heading\>\"", ",", "\"\<Actual content\>\""}], 
             "}"}], "]"}]}]}], "}"}], ",", 
        RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}]}], "}"}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Top"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36327933],

Cell[BoxData[
 TagBox[GridBox[{
    {
     OpenerBox[Dynamic[$CellContext`x]], 
     PaneSelectorBox[{False->"\<\"Heading\"\>", True->
      TagBox[GridBox[{
         {"\<\"Heading\"\>"},
         {"\<\"Actual content\"\>"}
        },
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        RowsEqual->False],
       "Column"]}, Dynamic[$CellContext`x]]}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Rows" -> {{Top}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{122, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->398409667]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Heading\>\"", ",", "\"\<Actual content\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->234513465],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "\<\"Heading\"\>"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "\<\"Heading\"\>"},
         {"", 
          PaneBox["\<\"Actual content\"\>",
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{"Heading", "Actual content"}, False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->389809105]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27167],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Toggler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Toggler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Checkbox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Checkbox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenerView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenerView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowGroupOpener",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowGroupOpener"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3790]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15219],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->311850945],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->47893894]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Opener - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 0.5647488}", "context" -> "System`", 
    "keywords" -> {
     "opener", "opener triangle", "information hiding", 
      "information exposure", "information elision"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Opener[x] represents an opener with setting x, displayed as TagBox[ \
OpenerBox[True], EventHandlerTag[{ \"MouseDown\" -> Null, PassEventsDown -> \
Automatic, PassEventsUp -> True}]] when x is True and TagBox[ \
OpenerBox[False], EventHandlerTag[{ \"MouseDown\" -> Null, PassEventsDown -> \
Automatic, PassEventsUp -> True}]] when x is False. Opener[Dynamic[x]] takes \
the setting to be the dynamically updated current value of x, with the value \
of x being toggled if the opener is clicked. ", "synonyms" -> {}, "title" -> 
    "Opener", "type" -> "Symbol", "uri" -> "ref/Opener"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8486, 276, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->50107893]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36491, 1323}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2190, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2813, 79, 1571, 37, 70, "ObjectNameGrid"],
Cell[4387, 118, 2043, 68, 70, "Usage",
 CellID->8684]
}, Open  ]],
Cell[CellGroupData[{
Cell[6467, 191, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6945, 208, 320, 12, 70, "Notes",
 CellID->4823],
Cell[7268, 222, 403, 15, 70, "Notes",
 CellID->16311],
Cell[7674, 239, 311, 12, 70, "Notes",
 CellID->5623],
Cell[7988, 253, 461, 18, 70, "Notes",
 CellID->22065]
}, Closed]],
Cell[CellGroupData[{
Cell[8486, 276, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->50107893],
Cell[CellGroupData[{
Cell[8870, 290, 148, 5, 70, "ExampleSection",
 CellID->175789906],
Cell[9021, 297, 72, 1, 70, "ExampleText",
 CellID->40340557],
Cell[CellGroupData[{
Cell[9118, 302, 220, 7, 28, "Input",
 CellID->104760991],
Cell[9341, 311, 325, 10, 39, "Output",
 CellID->283118547]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9715, 327, 219, 7, 70, "ExampleSection",
 CellID->84034620],
Cell[9937, 336, 369, 14, 70, "ExampleText",
 CellID->761409386],
Cell[CellGroupData[{
Cell[10331, 354, 490, 14, 70, "Input",
 CellID->168332755],
Cell[10824, 370, 511, 15, 70, "Output",
 CellID->222390748]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11384, 391, 222, 7, 70, "ExampleSection",
 CellID->186177581],
Cell[CellGroupData[{
Cell[11631, 402, 231, 7, 70, "ExampleSubsection",
 CellID->464933523],
Cell[11865, 411, 64, 1, 70, "ExampleText",
 CellID->89339116],
Cell[CellGroupData[{
Cell[11954, 416, 371, 12, 70, "Input",
 CellID->141448378],
Cell[12328, 430, 383, 15, 70, "Output",
 CellID->399936161]
}, Open  ]],
Cell[CellGroupData[{
Cell[12748, 450, 369, 12, 70, "Input",
 CellID->93513674],
Cell[13120, 464, 379, 15, 70, "Output",
 CellID->170983184]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13548, 485, 231, 7, 70, "ExampleSubsection",
 CellID->301785698],
Cell[13782, 494, 96, 1, 70, "ExampleText",
 CellID->487046052],
Cell[CellGroupData[{
Cell[13903, 499, 291, 9, 70, "Input",
 CellID->119939086],
Cell[14197, 510, 348, 11, 70, "Output",
 CellID->809802547]
}, Open  ]],
Cell[14560, 524, 124, 3, 70, "ExampleDelimiter",
 CellID->85169209],
Cell[14687, 529, 258, 8, 70, "ExampleText",
 CellID->648410836],
Cell[CellGroupData[{
Cell[14970, 541, 345, 10, 70, "Input",
 CellID->289477877],
Cell[15318, 553, 368, 12, 70, "Output",
 CellID->2843090]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15735, 571, 231, 7, 70, "ExampleSubsection",
 CellID->340237004],
Cell[15969, 580, 70, 1, 70, "ExampleText",
 CellID->59225769],
Cell[CellGroupData[{
Cell[16064, 585, 371, 12, 70, "Input",
 CellID->51473715],
Cell[16438, 599, 435, 15, 70, "Output",
 CellID->364834387]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16922, 620, 236, 7, 70, "ExampleSubsection",
 CellID->12883043],
Cell[17161, 629, 71, 1, 70, "ExampleText",
 CellID->106430421],
Cell[CellGroupData[{
Cell[17257, 634, 410, 13, 70, "Input",
 CellID->45522410],
Cell[17670, 649, 490, 17, 70, "Output",
 CellID->590966538]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18209, 672, 228, 7, 70, "ExampleSubsection",
 CellID->505676316],
Cell[18440, 681, 201, 8, 70, "ExampleText",
 CellID->23298786],
Cell[CellGroupData[{
Cell[18666, 693, 105, 3, 70, "Input",
 CellID->94729581],
Cell[18774, 698, 173, 6, 70, "Output",
 CellID->132872562]
}, Open  ]],
Cell[18962, 707, 124, 3, 70, "ExampleDelimiter",
 CellID->61836355],
Cell[19089, 712, 367, 12, 70, "ExampleText",
 CellID->4733516],
Cell[CellGroupData[{
Cell[19481, 728, 168, 5, 70, "Input",
 CellID->227336428],
Cell[19652, 735, 190, 7, 70, "Output",
 CellID->240477045]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19891, 748, 233, 7, 70, "ExampleSubsection",
 CellID->108832654],
Cell[20127, 757, 204, 8, 70, "ExampleText",
 CellID->3977836],
Cell[CellGroupData[{
Cell[20356, 769, 358, 12, 70, "Input",
 CellID->262736791],
Cell[20717, 783, 542, 23, 70, "Output",
 CellID->590868105]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[21320, 813, 227, 7, 70, "ExampleSection",
 CellID->377414513],
Cell[21550, 822, 365, 13, 70, "ExampleText",
 CellID->431069108],
Cell[CellGroupData[{
Cell[21940, 839, 1202, 32, 70, "Input",
 CellID->640085565],
Cell[23145, 873, 1084, 30, 70, "Output",
 CellID->388464649]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24278, 909, 236, 7, 70, "ExampleSection",
 CellID->72240602],
Cell[24517, 918, 318, 12, 70, "ExampleText",
 CellID->499252316],
Cell[24838, 932, 1503, 46, 70, "Input",
 CellID->2242833],
Cell[CellGroupData[{
Cell[26366, 982, 377, 12, 70, "Input",
 CellID->505999585],
Cell[26746, 996, 783, 22, 70, "Output",
 CellID->755857007]
}, Open  ]],
Cell[CellGroupData[{
Cell[27566, 1023, 219, 7, 70, "Input",
 CellID->20201787],
Cell[27788, 1032, 326, 10, 70, "Output",
 CellID->1322944644]
}, Open  ]],
Cell[28129, 1045, 125, 3, 70, "ExampleDelimiter",
 CellID->550616500],
Cell[28257, 1050, 459, 17, 70, "ExampleText",
 CellID->36865483],
Cell[CellGroupData[{
Cell[28741, 1071, 736, 21, 70, "Input",
 CellID->36327933],
Cell[29480, 1094, 798, 25, 70, "Output",
 CellID->398409667]
}, Open  ]],
Cell[CellGroupData[{
Cell[30315, 1124, 191, 6, 70, "Input",
 CellID->234513465],
Cell[30509, 1132, 1926, 57, 70, "Output",
 CellID->389809105]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32496, 1196, 311, 9, 70, "SeeAlsoSection",
 CellID->27167],
Cell[32810, 1207, 956, 35, 70, "SeeAlso",
 CellID->3790]
}, Open  ]],
Cell[CellGroupData[{
Cell[33803, 1247, 314, 9, 70, "TutorialsSection",
 CellID->15219],
Cell[34120, 1258, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[34282, 1263, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[34467, 1271, 319, 9, 70, "MoreAboutSection",
 CellID->311850945],
Cell[34789, 1282, 140, 3, 70, "MoreAbout",
 CellID->47893894]
}, Open  ]],
Cell[34944, 1288, 27, 0, 70, "History"],
Cell[34974, 1290, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

