(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    184724,       5418]
NotebookOptionsPosition[    173446,       5029]
NotebookOutlinePosition[    174896,       5068]
CellTagsIndexPosition[    174809,       5063]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Views" :> 
          Documentation`HelpLookup["paclet:tutorial/Views"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Views\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SlideView" :> Documentation`HelpLookup["paclet:ref/SlideView"],
           "TabView" :> Documentation`HelpLookup["paclet:ref/TabView"], 
          "FlipView" :> Documentation`HelpLookup["paclet:ref/FlipView"], 
          "PaneSelector" :> 
          Documentation`HelpLookup["paclet:ref/PaneSelector"], "Opener" :> 
          Documentation`HelpLookup["paclet:ref/Opener"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SlideView\"\>", 2->"\<\"TabView\"\>", 
       3->"\<\"FlipView\"\>", 4->"\<\"PaneSelector\"\>", 
       5->"\<\"Opener\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Creating Inspectors\"\>", 
       2->"\<\"Document Generation\"\>", 3->"\<\"Dynamic Visualization\"\>", 
       4->"\<\"Layout & Tables\"\>", 5->"\<\"Palettes\"\>", 
       6->"\<\"Stand-Alone Interfaces\"\>", 
       7->"\<\"User Interface Structuring & Layout\"\>", 
       8->"\<\"Viewers and Annotation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["OpenerView", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OpenerView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OpenerView"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["2", "TR"]]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an object which displays as an opener, \
together with ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " if the opener is closed, and both ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " if it is open."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OpenerView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OpenerView"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["2", "TR"]]}], "}"}], ",", 
        StyleBox["state", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]specifies the state of the opener, with ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " being closed, and ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " being open."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->32556]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The opener displays as ",
 Cell[BoxData[
  OpenerBox[False]]],
 " when closed, and ",
 Cell[BoxData[
  OpenerBox[True]]],
 " when opened. "
}], "Notes",
 CellID->20016],

Cell[TextData[{
 "The opener is displayed at the top left, outside the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14433],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OpenerView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenerView"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Dynamic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dynamic"], "[", 
     StyleBox["state", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " takes the opener state to be specified by the dynamically updated current \
value of ",
 Cell[BoxData[
  StyleBox["state", "TI"]], "InlineFormula"],
 ", with the value of ",
 Cell[BoxData[
  StyleBox["state", "TI"]], "InlineFormula"],
 " being reset if the opener is clicked."
}], "Notes",
 CellID->16964],

Cell["The following options can be given: ", "Notes",
 CellID->8358],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align objects in the display area", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the opener view", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether controls are enabled", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameMargins"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "margins inside the overall frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the display area ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size for the display area", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->20748],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " leaves space only for the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " currently being displayed. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " leaves space for the largest of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", so that its overall size does not change."
}], "Notes",
 CellID->24105],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BaselinePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaselinePosition"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the baseline of the ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " is taken to be the baseline of the opener icon."
}], "Notes",
 CellID->6423],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<OpenerView\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->576660090],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->448455150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{"{", 
   RowBox[{"Plus", ",", 
    RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->292717771],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"},
         {"", 
          PaneBox[
           RowBox[{"x", "+", "y", "+", "z"}],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
     False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->971265788]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->433535640],

Cell["Start in the open setting:", "ExampleText",
 CellID->749766276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Plus", ",", 
     RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], ",", "True"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16683294],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = True}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"},
         {"", 
          PaneBox[
           RowBox[{"x", "+", "y", "+", "z"}],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
     True]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{65, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1040898069]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->365065168],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "OpenerView Content",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->328872546],

Cell[TextData[{
 "Use graphics as content in ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20643876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"TraditionalForm", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234501074],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          TagBox[
           FormBox[
            RowBox[{"sin", "(", "x", ")"}],
            TraditionalForm],
           TraditionalForm,
           Editable->True]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          TagBox[
           FormBox[
            RowBox[{"sin", "(", "x", ")"}],
            TraditionalForm],
           TraditionalForm,
           Editable->True]},
         {"", 
          PaneBox[
           GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJwtWHk8VN//tkS2YmYsZZkZFFLRqsjH+9AupRRJUiEpa6IoLUqEZIksFRGh
LC3KEo41JIUQkez7zLUz1t/9vl6/f+b8MXPvPee5z/tZRt7SyegCDxcXlwb5
8b/1xW1L/s3WAToX/3+N+xZ7ZYhRCaefR9z6MFUB6Rl+LfZqf8CzqrJCyK0Z
LkJt1LBLFzy9Duu493WCY8+6rsz0ARgxp+zdw9sHQvLeyv92joDAF48EuuoQ
PBarUo07Nw687V+SssZZYNlyAvN+n4KKtQ1tLckEXCnztnRSnoWjoZkSxwgC
3juLHF91cAEowuMBL1hsiLtpN7jpJBe6ixykGV7DcC92/tjEMDeKqn9Dfywx
AFy/2lHeDV40NZ68Xqy8G5RcbdxPqPKh3LaMxF2ubdA9GWEinM+PNMyffo1t
qwP9nsu3Qq8IoL5vl5yY/J/hSHfwejpdCLFNkmUWnDAeLLG8W5EmjD59dW/9
xV+P1SiNcrvPrkC8tdq7yze0YyGYPN86vhJJl2Xdjtzfg/ezzKYVjMXQi3He
SwttA7ip2JrbbAMFxSvrt0nvYuFPD0stmJMUpJcd8FBxO4Ft+Nzaf/ygogSW
7GzgEoGtXG5+Eommoc40/XthTgRWv7j+h8F5cfT7YVdvVAYL/6RuEHbTlEAO
6ZtjV/oM4i/p955t4JVELb1P/ivx6sU3uVWPfv8rifgn912U2tiBhVpvHHDM
lEIfnU/1nDvTiHtey4fFeq5C1LX3Le6GleIwldXLcoxXI+sy32D+1hQIjrYp
P8+URhu45ehGHj/BLOzMD5E+aVQjIezXYdMCM3sSObEFMsh2VWaR8JUu6OrR
cy/2lUWjPC+Ety3vh/j/NstUn5dDsVxP7GPHhyDtgRvl4kY6+vas3872Bht8
ja0O8U7SUdymQN113wjY3hqX4lvNQI5u41szmwmIXPcsrfoQE7lRKT4nXrLh
TmFg5KEcJmJmxEnWTA7BYRnjxG9r5JHHI5mNIN0Puo7lpyl+8khY4+mGpIAu
iJW1XPN9Uh75Td0o0X3YAmtKkp4eOa2AUt//0pnT/AnBG4tV6woUkHr8Z3+d
pDdgM76stlJVEVnPLb93679SbPl+jOkXpIgUWOmsqP2NuOKbwP28eUUUcHy/
YZZ2By4YV+IsLSkieatl0TG2HXh5S6cyi5ED4V2bVz2TyIHLobcKaoJ7wUJA
V706vxuKaKujNMVY4Hhh7OgnrQH4Hqm8rvD7KLhG2PlHfxiGmUlRNyPJSXgc
v9fVd44Nl2uGg3M8ZiAn+3mzJIcAyrOKP7uz58A4/ApnbTgBsx9HaflzizBy
yDXIppMFoSu2xVAVuJFsWqSmAmsQdHMcDzZ95EErX2lnrxbqA9nkHhy0biXa
T9wm3tZ24u+PjFUoP0VRmVrf8+Wf+7BY01nPgkIxlJl7JGN95hD+mii+KT+Y
gjxNGg+4nGHjleXPY6fPU1HSg2rb3RUE7t41881hGw1FWQZ3fv5H4Er7X0Wp
CzT082D745JMNl7Kezt8rlocBYYf0JDaPYzLzp38dTRGAvFGS73ziO/HMqaN
bp7OkujMSsu3XhNd2FFiYudmRVlE1Xq3gvK7B4opuZXlE7LoiNb7rwaKg5B8
/rhkdLkc+se34Mo0Z0G0g73a9hA6sjRTrNU/QEBb5L0be88zUJUMr+7bJQKa
hTWKDqxmolTN93nS1gSIuIm/enSPidbO8+isvcaCXodRujDBRP1uE/ShDYNQ
vucxF9tEHjHWmdg1sXpg9z8pHYtFRRRrkZj9zqgD/5qzDRthpEDKwMm603Ip
0G+rnNrG3QOCx+Pf1Pt2QaSnvM71s0MwkhHJeKHcD0Otxsk/eUaheCLmluj0
EOy+z/rpsWsCckT42KX32NDbwExui58GgcU0vc2tBOi+ex3TTMzC0j0nD04V
ASbUOx8vKyxCrMgxhVkXNkSXGpbG5XGhxrEykd94CCxTPx22OcqDVqi7la+S
6ofE1r+Ol0pXoFVHk8Pfe3fgoQtry66dF0Upg6/LKL69ONXyb86Ivxja0/Il
buWvQWyYmRcZYEFBHf260y4NLNyZtGkpYD0VvUrUKFjtT+DEl5+NY7hpyDx5
94tPHAI/dUr60lpFQ8GCF99GyBBYKtTur0mEOFr8l5CbwcvC33J0iU47CcTY
qya84/kAtruf+rBeUxKpunaWder14K1pBlH9IzJotdvmKcc33VB3c5G5t0AW
cYWX7DanD0CiYXHkxzA5dGdQ9fLYu2FI4IwwjpylozKpV0w8yIYt02OWa9Yz
0MqM0THjEZL/nryH+LmYqPeQDKeE9AujnydVNl5kounlz9fqSJK/j8Cn19cz
0ezfet5h6SEQejdq1PqfPLJnvEyRE+4DfuPgc4ELikjCQsT10/4OPPhGbGKu
kA3Ope7mFbsGIe0EJ+Xd0zEw09hBP0TyLc12i/T60UlIF/Ffen2GAPa3bI+w
oxz48n6lvjvJt44Hg5Lpd+dB7/YmtRl9AmKMrV1FG5YgKj9uQV+bBY3NxWXG
dDH09L7WyLNf/dj1cKfOoykx9Hl/o9cnr2GsE2Ffzi6mIDazeFNZHRtr9Qog
q0gq2iRZGnmVIPCa35rov4s0tKU/en38ewLPX1oq91QXR0cjjrqa7GLjvr6h
ucu8EihyhXHcKcchnHzrWZOHsSzScdC9tXOqFz4kubnor5dDVOrFEwckhuDN
1e4nd2fl0Io1E4fyJ1gQ3NGnLVtCRyvz3r+sCyXAX4saahPBQPt7H26jzxCQ
HW27I2ALE9kEFe3pEibgq3St3PALJpKO8WHdLhyGu5diZdRJPay5rSOTcqYD
2//n5jDNiIIGFLnTiFxVTszHX9Dqhr5baf+Z9XcC7/tEMUnfQQgOL+J5FNEH
s4vDF3+/GIENOm+peaFD0H/Q/NaKH+Owa9bzJrcOGxKacrde2TENR5ofvDYq
I+c7N/xuQsAsbHc7YyPZToB30d77RZ8WoOva2yLRj2ygvzxzcsCPCymVlnq/
UxiGsbXNhml0HlTyu8JdLbIfBqdO7WsMWYFSde2VV/xpxzeMAp+kqIoi3vzW
rScHevCs8vMmQWcxxLpynWp2ehCHfRGrdtlLQTUTNNNH/ixsEDmrZiJGRTo/
HhS6WhKY/5fEM41+KhJ784yuTPr3vHNI9sQHGropa+gysZ/ArzyrGo55iqMV
JoMv9MzJ63s1Ft4aSSDNB92tKrRBTIuSCr1Ll0QbmgS6j3X3YEmO+8HS3zLI
T+T704Oi3fDn3cvvvK9kkaqXfylPeD8kfOWcQjflkPDtFUY+J4YhGT5Gmu2j
o8CiY0oDmWwwV1r/mybGQN6y77auJvERt6tnfOtloG2H7th+KiHAzZNz+dYp
Jop88dBUzIINTW+Vbnz5ykR8Zttjq/yHIPWCoufxzfJIRLH91q2wPugL+j66
hpyXNqnQfA29DmzyL+xrdD8L8nik9wTkD0DeteBL2ZvHYP3s9FKmIAuM1OPK
C+5PQsYRcHdWJyC12ohPuWcG8OGy/FXkvHgEN8+4y85DyoXa79ddCPi+bP0e
G9sl0LubkcQTygJ6zdQGgkcMOZkXmwnv78fF1LgziS1iiK+346K93DC+F1M4
15BCQZ3v/1KuRbNxQmOd08ZbVBRz/0hzXhuBvQWjHjQcpiG7s6VFG6sIbGk3
UBomKY4eiuOq0zfY+GrdoYkL/eJoS3d0/9aWIRxQWf7QWFsWGSfvPn/Wthdy
W6XogmJy6HoLcs+MGYSUQRnjFR1y6JynmUn5GxaEK7/5pPKGjvrEog3HnAjI
vKTPb+LJQFHOPZSiRQIOHDecH1jLREbNkXEOWgQMlLuc0w5mIluf/+rm5Mi8
m9CS+pX0F2tFw30bTTtwTN5thd7kCTjFf9ZpsogNKr98ZA1WzoDiUcvUqywC
UhKz8laemIMftB9WCx8IULHK7qIFLcL+WltN241sEEqztU64TkF8Mi47SmTY
2D3L5mfRPiqS2rHppHAqgfc4nhTjl6GhmOevj2mRerLJMb+gtJuGGE8cerwH
2fh1k/9vpXQ5Ms+kSTUIsCD2o1qSrjsdBVVv2tApQ4BARS572z4GKjnLHdk6
S8DlUlmfJBEmsvZZt6r7IQHqCp97Wl2ZSGTEXWyoggUC8SX2ERZTcJXTGKng
Q8CmCjqbO48DgiWJDtvJ6w/enNvW1T0PWULVqml0Us+DVj1Z3kpBZiWceRN+
AtdM6ohFfaQiwxXf46xnCVya8Gc24S4NqeXfVlr1hMCPnq0tFW2lo9t0p+u9
7wg4J/xH7voHBvK6l91UMkTi0+nlsgFIvTq7rPdeExti1az8I0h9Oi+ouWON
VQd+URjI4GP6gURLQ20Lww8qKm3oKY1dIKKbxfUwohN2VvV59EgPwpBS6QnW
4T7gCc7ef9puBDyOhj2btBiCXWm0EycjxqFSNtH/0Wo28P7x9cjlnoZjob8W
KrMIWIsCR/1OzUIKDlI/2k+A9Op1Q/Z3FiBFXfOoQC0b2gO7mYHOXKhB6Yjc
NaNhyO0crKnh40HUUG0w+d0PIstWfXjkvgKpF3/4lHe/HRcfKJrVExVF2aPZ
vlORPfil/9zFp5ZiyKDHzAbLDWINrHWxdycFLfzR2mFtxcJ3g//t+8JDRQLs
HjUvAwJr2Jfl32uhIvGfbb1zpD69u8Kfdfc1DS27c9vN3JzAA1fmjv10FEe5
sZzkpz4s/Nhzs7fYPgn0lSZznn54EPcpVj9tFJNEweESqx9t7cXLGUHyW6pk
kKwPbcejwi6wqLqiYBUui6ytY92Tj/SD4r3wXB9HOdTnJXwgbs0wvLEUb2jX
pKPGhNUR/0WyYey//SEBPAxkEmhk+7uBgATFL90qfxioVkfV4vhPAviP6z9K
NGKiSxOCM9132LBBw8yPt5CJ3vt7ugwWDoEnyhMTXS+P4lLqL/z63QemaZdz
R8h8/kPWSu46dOBHnEb1y54s+FHXOfHecwBKl5sf1F4ahQd5925mtQ1DYqhp
jMDhSdAaN87cLEmA8E/GIeeMGSiJ+ij8fZ6AMonaSxaDc5Cv3Xj5kjcBVuYr
UylbliA07gx3ey4LvJ/KF10fFEVKn521JZf68CU3LtbmH2JocQ+95dLAEF4T
Pxh+8AUF+Wk2bPL3ZOPmH1m+oU5UpNDooL2znsCZ8QeS5XVpqOjDqWZqI4El
7S1KmELiSOnhk1HFSDbOKb/p3PVHHPEp6DwvEx3GnsTfcyXqsujZcM2Ntcxe
0Jnuv2rLI4c8rx7MiTo/CCqvsz4dr5dDGQVhSNCbBZH6wmPpL+jo8I7J1Vnm
5Lx52RRWOzJQ0OzCfhapv8EZxRZRDCbqmqrc3W5IwI2YEi9rPybKqlm79EWf
BXVFHm6hpD5Z9AVKOhl34BGGBkfdZQI2/0w/JPaK7G/1xy3Dm6bh5TabbT49
BEyqZmyckJ+DijC2tFQhATj32SFsughmbIeJf0fZkPoudFHKjoJObb0epsZh
4bSMQ31KmlT0ZPj12cpnBHZdvnyr0UoakiqhyayeJHCX45b8o000FLIlJTyB
l8BKYUo7HeLkUNQrVo3b32GIbwzqKrejI28rkbt9vAS8+NeYnLqTgYI9lzYc
nSLgAzO434SfiSzPLwRciSKgcIZ/OZ8jE+FqvpbdIyww47u5u0N5Cgb8Q14/
J/0nqHJo6yEfDlwPpDADFggI5xpPrPgwDxbpfe/sthPw/Inexps/KUjF4Noe
JRYb87EVVRYTqWglWuQkkPud+M9fbvQqDbUuvEqfjyfw4wIfrqc/6Uj7Qaft
tXgSH4Wp3+wEBkq6u7M5aYwAZ53J+padTHRERdKseowNYgbcx61Ifbq0zKLQ
5lwH3vubxVJ2mIafyheQWy0BgdtjRHH+LCyqlQslNBIg9VJCalSOirYf84CF
awRu1LRxH5ygIk+jTymiCwQuXykq91yOgf7d0VVjk/rj/YFlZjfOQN+ZJV//
fCaA6/vAiGvuJPwR/BWpt5+Aw98f4L/SHHLO+hrmSX44tbFOVvhT0W2h4rKa
PgKfcB6w9DOjIQ/jDEEBTODQZQc94j/T0RuPpc9zXgQwjNQM2vwYyMNhbaoS
OT+VtTmNPHtmACnoH+OME3CGWXhonc8cpJR616cmELAbe2WZn6CibWUF/W25
BBZvSGLlKNOQs7a65+p+Al99F7Mt/zgDdd7vX5ol38cnHZGnh8OnoB9oYzsi
Caj5eiw5e5QDPN7nTK9PEvBs4dTM1iIqqluvc+oDeX5/91Jfv346UtjeCwoF
BHwbz7dawgx0h7/Xy6WLADVKWVEViTe/XsWdjgsdeOlrwX0m0wNENdZvkiTX
yGWyrd8SusB4aWLqj2MnHG96qFbdPQB6dZTuHJU+8DGN2SFnNAJevy6Ipu4Z
gm4LJ5i/OQ46+zbOV/Oz4YOZo+y/3ilYzTUTeof0pyoewTeeaBb2xjwtmSb9
qbdUOlbPegGuDlxyuPOPDYXLkvn+WXGhbVatBuxLw0AvuhpiyeFGn/9FHgue
6ocXQtN9fXYr0Ki2rY2JaTvu3X06PYhbFI1kOY/bOPfgiV1vM1pPi6F167+t
vb84gJcXGW57uYWCVjmiKCtDFo4WqatjzVHQHq3qwCVE4B875X6qNFBRoefa
/+kBFhpDn/e9pKHmJ9E+dBvSX+1pYittxRGlXfWO3jMWTi9PLy8GCRR3wcsg
69IgPjagHMUtJIkMm7P3VZj1Yq4t0SsGSmUQP2OLWndkF7w0NasOfSyLJF5n
GVHW90Pn2a7BdbZyKLC1qGG3yDBsmNgz/morHcXUMBXd/diQd9DYsXyOjjqf
WzVtrCFg+I7a/qZfDOSZ9P3q23oCDAvGnmsaMtHHAjOPg8FsMJkbD07KY6Lz
aySCvVtI/NMEWoaV5REn0PezEqcPxPJyYhpJP6g3p2pL6XTg1/zu3cf2kT1H
7W3b79MDcKBGV3OxZxTaz5xu+F4xDEf2ZPqlbZ4E5eCcEUFBAnIN+dlhYTPw
287uLn2OALsmA4VjtXMwRo+2YD8i+SPAda5PcgkUEjN1fvxgQXLIF9fSVlH0
ZkdQ3/s/fThP6d0293IxlHL6G23sxxCefLVkyRtB5rOk5jeKDmw8of+GVmZL
ReePb6u1+0FgA6eXOeVaNFR4jsm/ooXAzsORxb28pB/s7umMfM3G5sVP1BTq
xVHAW8uQp+uGsRvPgMGNdbLoIWWD7ee5HrjrXUuPnCP7dHToqSi9Qei/z9c7
VS2HBFwCVmk5s2B16y4xlwg60ij8LpxkRPaBQNcXgrYMFDBnLDJLznvmmXnR
K7JMZHFbP3SNGQElgvahMw+YqKX6+vNn51jgX1Nxyp30g/dSFizREx04ujak
u95kAowudBhIPWGDhrEWX27+NFRWBSYIdJDzyFLt7RUg5337L231r2SftAlc
CvtvEWqLJhtWWbLh9oekqlprCurf4hDk1sfCFet1rp7aQkX84mU7GGS+E6m3
2DOznIaI2P3JQdME1ibs8yTryLxyJKa4RJTAvVdcbcWeyaEbnSkPTMuHQdG2
kDvgAh0F3MqZdp9mg+1Q94P+zQx0P3Sy7C6pP40/KqPUeJlIpWznRr04AgSt
M6SiLjPRDYEbw/a8bFiW1ajmIzIF8n45uYa2BOjo1zU62XGA/0lTeTqZ53eV
OFp8iZqHgXfyOqaIAIfwk7PbKinI/N3KzzLtbMy8LJm5KZaKNBLdPXPHyPkR
6lSLcKChoVlh0+tvCCx6NIt+qpKOvoYWj32LJv1Ibdkn1RgGUhesxcGkfoUN
q/l83M5E9/beG7m9xIYKs6M7DpL6xDZ/Or78bAeeOFkfbGA0DZ4FWgXBVQRs
nVld8T5hFr64mu/1biFgi6zAK0UpKvqnH3yl157AjvwFfsFsKuJNycrevUjq
tbTc7G9JBkp/XHbsfTfZt1aez5dmMdCf8cuJTvlkv7i1t3V17CSctSlU891F
wLyBvSUPFwdilcXbskh++Ju1d83ep6KrO/yHXbsIPKyt66p+goae+ziM6ZWR
+v3UI+LCOzqK/nLsgJwHAYNntNdJ32eggZ47r+JI/XY3eumhvG4G7vSp3+4a
IYC3a9cyWYc58J/JYM+9JcBil+vuoMNkf46om47/SODUuKXFs/I0tIWutaZu
iMA6eakUjgEDXYqefBxF+ovFyEWvMY8psLm2xeZ0EAF39+889LeRAxuP2djz
zhDw2cPA2yaXinTPmxZozhNYWGgy0aCTjvacxsNvyHwevlSFduUwUPL5h3UV
faQeM8RfvyfxJp7od9yz7sB3blE0I1xmQTY03NKMxCsm1iG1tYOKBPnXNOeQ
eqm8RTPTUJCB3p9X6lhL4m9+RDP50LcZSOf6co1B8qXAqGzu7DUq4uvIjEpu
JvBtN9OuEDdy3l4yJrxJPJuOO2Dn8WlYczC4J2WAgFatDPlUcRryrP47d4zk
T92viipnYKBWLj5mKXme9gN8IUpxHFh7njBeQZ5/8Mrm51WpVJTH7hHYOkNg
Van+2Q9vGehwOtXPiiD567Dy4p45Mh8YvZjwnyPwPA83OreGgf6r583/OUye
51CsbM52Djgpeyb0kfs5YTlXFR5CRa+/mpnWkHif2Md0ig9moB5z6qajZF+T
PvZra5vFDPx9tST7icxXyQnBJ73MGMjpZ28vF3k9c58dX5jILMw/L9oZQuab
u14X7bkrqMhCU9vxB8m/azzX/vaQ+Gqovqeiix249BfT4CTzEhj8VM06Qa5c
8VO5LQFdUNd8Mf6qWSe0WzQLFFUOgK5AxvHlkn1QoR2ifnvvCJgve1PrsGMI
cnbIfTriOA5SIv+VH15ggdCzDocrzVNwYj6vPTuVAHr3Pv6prbNACbm8PZ3s
z9+jaR5pJgsg+UQ8NqqXDZsKBWd8z3Ah9r9Hr4LchuHopuwr68e5UUrpzTJJ
/gHoDey9F35hBTJc693/RK8du+uqCHyeXYmuf38buNy8B8eI3/91x1QMyXw7
d6WSPYBHdP9I31KnIB5Hfe0De1k4Wb9qle8M2cf6QhtkdxFYmlH5e66Wiv60
os/lJH80trR9WveChiLgiUDXZQK3XWI4pVmLIy4Jz1L3RBbWcXAYeKYtgXgO
mG0cuj6I+Q2MpSP4JZG2EWPksGMv9vwSe7+0SAa9PrJ7ccG7C/Rif8SrBsgi
9VP19utX90PxEaH7c9Zy6Fv2Ws/ZpSEY1j5z78EmOmqofR3I8WJDvGGr+YUZ
OpImyoc1qgkQU7OdyahhoG095ljzNwET4/sS7x9mos3JOpvNyL42+LcwjJPL
RKpCPaqZ/UMQ2a1WeFpJHkUUbjDKFewH+90dwZWk336myu6/+F8H3hZYUbB3
PQsuFjW9NDw0AP6Z2zafbR4Fw2KRuLx8Uq/lLJeWFCchvktl+QkeAqjBHqDs
OwP1xxkja0m+FeT43/5WOgcS6y830UJIv2qb0TQSXIL5iW0qiU0s0Ap6+GOw
QRSFGKAbFyr6sM2Sr6lMqRj68fLmu8iiIdy2xv9g+xMKenl/3OjEBTbm9nt1
yuIC6S9tQTJWVQSONDYojt5BQ64Sa5bs/hL4+QaN4koucbRfPOt+Vhobp+PY
wKIacXTrhuPYOY1hPBbALjZWkkVVlntuXx7oAfmqvRPqM7LIWPdf8PyWQahw
2XC74pscUo0UfqJhw4I/a07EHg+joyFLD5d7hwnghM4FJFkzkNVE1Ko2cl6+
bovqb5VmIoHeUId1ZwmwhcJoPW8mki9K3WRnx4LekyOH7Ei//VjpcuLc8Q7s
+AbMlA9OwPa6O/s4/mx4HJ5mYvBuGmzuCG1MbiOA/cNW79z8LGxaeL+KXkn2
C22f5iX1RdBybL4SdpkNNlu3fEg/T0FDM7Mut9pYuOHSjpwxNVLP10V2JT0m
sGmu0OGqZTT0RkjlcyqpJ5fUhfI4P2gIiZ6Uz5Ig8Ndzz7g6I+RQ/Rm7x2p5
w9D9rinY3pKO5JplXNeOsuHwqJ2rjxoDiXDbVk6NEtCfaOMSzc1EFbJ8hEgi
AelRvMwuW7K/Bz7ybRdhQ1OQd0LT4iSMeTAb+K0IeOq/V4XHggO26j+r6SQ+
jxNSc7cFzoPP66tV7/cSYCLZ2U75SkFFptojHs1svDFZdLbyGRVJtNY9VRgl
cNNI4I7Ll2ko4HJmvmQ6gWsif6ZpfaUjR19+66anBCRuC3hVEc1AvMLd/Z2k
fr0uqbJgbGOini1/SnP5CFjTeX2dNqlPMjatD00tOrBB5P7Otj3ToCO92OVZ
QYBP88k16yNnIXFP+erffwkAM+6BPBoVvZIKHc++SODc4UuhVkNU5LRi6i4m
9e46M6HfjcZAzjXyb5w7CRjJi3YcG2Cg5qM2ds/JfnzbZPyYfcgkHLvXpuVL
9ssTgf8+ho3NwHuF3tCr5PkjIpvXhd2lomu5ppfWdBB4pyLLk+cYDf07pGmh
V0Hg+rYQpf1pdJT+tfF0iCsBP61KpLLvMJD5L6Hv2qT/1ITSqnJkZiDFz79e
g/QDk1KPc+Hn5uDp0LSFTwaZZz0c/FT0qUhelPG8M4PAM75vl2+l05CiWZ1+
MIvAisVbuSIOMpDvjrH7X8n8u7VSYnqP/RQ4rRT2+eZP+pfv2+dOlRyYxeUZ
yhwyL2bt/bb0mYpees1gM9Jvvhut2K72j47qbp4yNsok4AbfcfXmTwz0Ufwt
riX9Ti9pV2QCifezXZmBv6w6cJ2FYbiYzSxI74oWPdtL+tuD1Z8y2qio9eCb
yW5SL0V2Fsaz+Eh96osU8G8i8+rjVM7fvBngZXjxeZH54ntwgS7HhYoCI2pZ
c40Etr75r1bdhYHMxMeDSkk8N4W1i/H2TsPbsJCDr0i/V5E/rXqHQkMKhYdf
4HECZzcb5q7UZqBMTY/w8GkCdvq5d2Y/4YBr2Mo7v0m/nclQ7bROoSKb48VB
01MEFpNzGjiazEC5deVyFJLv/sdznaRmqMgx4KPVSTJvdAo8VFtkMpDRW8q5
wUECpgKojodUOLD37el7C+R+LF9OUNQfU5FbaNyq1gECaxkknUGBDESbsW7b
R+LtErLvgfOxGUhKCnW3JPPh4zdS+xgnGUh2R4u1H/l+3X3aTJSWOGB0zddP
dIL8Hp/7EF1KRSmVHycOkfyr83vxs4nE98qZjG/BNh34ntGVr8ZNVNTE+Ji6
SOJpKfrkOU/8DPAP1fpxkedT82Wl29kxUOgWRdklcn/3es5E6G9noH1Bd/vG
yfv3Cp598NedA5OlHjtVyOdTN8g5RsRTkZn34wO7JgiswKR65Y9SUYWX2teP
ZP9OEOGIOa/gQIwuI7aHvN8y009anj6k/iV+jCTI5zGpG1XCNWZg6PqaZA8y
L5h+Xqt4+igD3QpxzTYm36fK8jKOfjcHLp4wTKj4X97YdVynOp+KTjvrP+cm
72+UU/RKsIeKetQvhtwgz7Ns5VeTnN8zMPdq1CKJ3F+UU+3EuDsDWTDeu6qR
z2dV6/6t02Og1xe/VbWQfH0oEAph6RwoOKWXuIHE++/WnSZb3lHRhRlv65Mc
Ao/5WFpcWaQiO69x8zezBN4nvKFKaTcHvlBMtb/87/8RFHV3WRgDzYu1xen9
j/8xgpe6zjDQ2ppPD86T31/d7ahkW0VF/63xKNMk9yd988jQGPk+VAOqTxJk
/vk/AoLhhg==
             "], {{}, {}, {}}],
            AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
            Axes->True,
            AxesOrigin->{0, 0},
            PlotRange->{{0, 10}, {-0.9999993680039507, 0.9999995755730018}},
            PlotRangeClipping->True,
            PlotRangePadding->{
              Scaled[0.02], 
              Scaled[0.02]}],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{
      TraditionalForm[
       Sin[$CellContext`x]], 
      Graphics[
       GraphicsComplex[CompressedData["
1:eJwtWHk8VN//tkS2YmYsZZkZFFLRqsjH+9AupRRJUiEpa6IoLUqEZIksFRGh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        "], {{{}, {}, {}}}], {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.9999993680039507, 0.9999995755730018}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}]}, False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1721031128]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->554773711],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " can contain any expression, including ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12327381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Text", "@", "Manipulate"}], ",", 
    RowBox[{"Manipulate", "[", 
     RowBox[{
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "+", "j"}], ")"}], "^", "2"}], ",", "\"\< == \>\"", 
         ",", 
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "+", "j"}], ")"}], "^", "2"}], "]"}]}], "}"}], "]"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "5", ",", "1"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320019421],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          InterpretationBox[Cell[BoxData["Manipulate"], "Text", "TR"],
           Text[Manipulate]]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          InterpretationBox[Cell[BoxData["Manipulate"], "Text", "TR"],
           Text[Manipulate]]},
         {"", 
          PaneBox[
           TagBox[
            StyleBox[
             
             DynamicModuleBox[{$CellContext`j$$ = 1, Typeset`show$$ = True, 
              Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
              Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
              "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`j$$], 1, 5, 1}}, Typeset`size$$ = Automatic,
               Typeset`update$$ = 0, Typeset`initDone$$, 
              Typeset`skipInitDone$$ = True, $CellContext`j$52$$ = 0}, 
              
              DynamicBox[Manipulate`ManipulateBoxes[
               1, StandardForm, "Variables" :> {$CellContext`j$$ = 1}, 
                "ControllerVariables" :> {
                  Hold[$CellContext`j$$, $CellContext`j$52$$, 0]}, 
                "OtherVariables" :> {
                 Typeset`show$$, Typeset`bookmarkList$$, 
                  Typeset`bookmarkMode$$, Typeset`animator$$, 
                  Typeset`animvar$$, Typeset`name$$, Typeset`specs$$, 
                  Typeset`size$$, Typeset`update$$, Typeset`initDone$$, 
                  Typeset`skipInitDone$$}, "Body" :> 
                Row[{($CellContext`x + $CellContext`j$$)^2, " == ", 
                   Expand[($CellContext`x + $CellContext`j$$)^2]}], 
                "Specifications" :> {{$CellContext`j$$, 1, 5, 1}}, 
                "Options" :> {}, "DefaultOptions" :> {}],
               SingleEvaluation->True],
              Deinitialization:>None,
              DynamicModuleValues:>{},
              SynchronousInitialization->True,
              UnsavedVariables:>{Typeset`initDone$$},
              UntrackedVariables:>{Typeset`size$$}], "Manipulate",
             Deployed->True,
             StripOnInput->False],
            Manipulate`InterpretManipulate[1]],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{
      Text[Manipulate], 
      Manipulate[
       Row[{($CellContext`x + $CellContext`j)^2, " == ", 
         Expand[($CellContext`x + $CellContext`j)^2]}], {$CellContext`j, 1, 5,
         1}]}, False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1457610618]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->572283909],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " can be nested:"
}], "ExampleText",
 CellID->349325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"OpenerView", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
    RowBox[{"OpenerView", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10598875],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          TagBox[
           DynamicModuleBox[{Typeset`var$$ = False}, 
            InterpretationBox[
             StyleBox[
              PaneSelectorBox[{False->
               TagBox[GridBox[{
                  {
                   OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "a"}
                 },
                 BaselinePosition->{1, 1},
                 ColumnsEqual->False,
                 GridBoxAlignment->{"Columns" -> {{Left}}},
                 GridBoxBackground->{"Columns" -> {{Automatic}}},
                 
                 GridBoxItemSize->{
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                 GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                 RowsEqual->False],
                "Grid"], True->
               TagBox[GridBox[{
                  {
                   OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "a"},
                  {"", 
                   PaneBox["b",
                    ImageMargins->0]}
                 },
                 BaselinePosition->{1, 1},
                 ColumnsEqual->False,
                 GridBoxAlignment->{"Columns" -> {{Left}}},
                 GridBoxBackground->{"Columns" -> {{Automatic}}},
                 GridBoxItemSize->{
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                 GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                 RowsEqual->False],
                "Grid"]}, Dynamic[Typeset`var$$],
               Alignment->Automatic,
               BaselinePosition->Baseline,
               DefaultBaseStyle->"OpenerView",
               ImageMargins->0,
               ImageSize->Automatic],
              Deployed->False,
              StripOnInput->False],
             OpenerView[{$CellContext`a, $CellContext`b}, False]],
            DynamicModuleValues:>{}],
           Setting[#, {0}]& ]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          TagBox[
           DynamicModuleBox[{Typeset`var$$ = False}, 
            InterpretationBox[
             StyleBox[
              PaneSelectorBox[{False->
               TagBox[GridBox[{
                  {
                   OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "a"}
                 },
                 BaselinePosition->{1, 1},
                 ColumnsEqual->False,
                 GridBoxAlignment->{"Columns" -> {{Left}}},
                 GridBoxBackground->{"Columns" -> {{Automatic}}},
                 
                 GridBoxItemSize->{
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                 GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                 RowsEqual->False],
                "Grid"], True->
               TagBox[GridBox[{
                  {
                   OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "a"},
                  {"", 
                   PaneBox["b",
                    ImageMargins->0]}
                 },
                 BaselinePosition->{1, 1},
                 ColumnsEqual->False,
                 GridBoxAlignment->{"Columns" -> {{Left}}},
                 GridBoxBackground->{"Columns" -> {{Automatic}}},
                 
                 GridBoxItemSize->{
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                 GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                 RowsEqual->False],
                "Grid"]}, Dynamic[Typeset`var$$],
               Alignment->Automatic,
               BaselinePosition->Baseline,
               DefaultBaseStyle->"OpenerView",
               ImageMargins->0,
               ImageSize->Automatic],
              Deployed->False,
              StripOnInput->False],
             OpenerView[{$CellContext`a, $CellContext`b}, False]],
            DynamicModuleValues:>Automatic],
           Setting[#, {0}]& ]},
         {"", 
          PaneBox[
           TagBox[
            DynamicModuleBox[{Typeset`var$$ = False}, 
             InterpretationBox[
              StyleBox[
               PaneSelectorBox[{False->
                TagBox[GridBox[{
                   {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "x"}
                  },
                  BaselinePosition->{1, 1},
                  ColumnsEqual->False,
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxBackground->{"Columns" -> {{Automatic}}},
                  
                  GridBoxItemSize->{
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                  GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                  RowsEqual->False],
                 "Grid"], True->
                TagBox[GridBox[{
                   {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "x"},
                   {"", 
                    PaneBox["y",
                    ImageMargins->0]}
                  },
                  BaselinePosition->{1, 1},
                  ColumnsEqual->False,
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxBackground->{"Columns" -> {{Automatic}}},
                  
                  GridBoxItemSize->{
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                  GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                  RowsEqual->False],
                 "Grid"]}, Dynamic[Typeset`var$$],
                Alignment->Automatic,
                BaselinePosition->Baseline,
                DefaultBaseStyle->"OpenerView",
                ImageMargins->0,
                ImageSize->Automatic],
               Deployed->False,
               StripOnInput->False],
              OpenerView[{$CellContext`x, $CellContext`y}, False]],
             DynamicModuleValues:>Automatic],
            Setting[#, {0}]& ],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{
      OpenerView[{$CellContext`a, $CellContext`b}], 
      OpenerView[{$CellContext`x, $CellContext`y}]}, False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1715695397]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36266290],

Cell[TextData[{
 "By default, an ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " resizes according to its state:"
}], "ExampleText",
 CellID->30642317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"{", 
   RowBox[{"Circle", ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47389411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Circle", ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->50]}], "}"}]], "Output",
 ImageSize->{122, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1429609110]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"OpenerView", "[", "d", "]"}], ",", 
    RowBox[{"OpenerView", "[", 
     RowBox[{"d", ",", "True"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->650262231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    TagBox[
     DynamicModuleBox[{Typeset`var$$ = False}, 
      InterpretationBox[
       StyleBox[
        PaneSelectorBox[{False->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Circle"}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"], True->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Circle"},
            {"", 
             PaneBox[
              GraphicsBox[CircleBox[{0, 0}],
               ImageSize->50],
              ImageMargins->0]}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"]}, Dynamic[Typeset`var$$],
         Alignment->Automatic,
         BaselinePosition->Baseline,
         DefaultBaseStyle->"OpenerView",
         ImageMargins->0,
         ImageSize->Automatic],
        Deployed->False,
        StripOnInput->False],
       OpenerView[{Circle, 
         Graphics[
          Circle[{0, 0}], ImageSize -> 50]}, False]],
      DynamicModuleValues:>{}],
     Setting[#, {0}]& ],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     DynamicModuleBox[{Typeset`var$$ = True}, 
      InterpretationBox[
       StyleBox[
        PaneSelectorBox[{False->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Circle"}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"], True->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Circle"},
            {"", 
             PaneBox[
              GraphicsBox[CircleBox[{0, 0}],
               ImageSize->50],
              ImageMargins->0]}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"]}, Dynamic[Typeset`var$$],
         Alignment->Automatic,
         BaselinePosition->Baseline,
         DefaultBaseStyle->"OpenerView",
         ImageMargins->0,
         ImageSize->Automatic],
        Deployed->False,
        StripOnInput->False],
       OpenerView[{Circle, 
         Graphics[
          Circle[{0, 0}], ImageSize -> 50]}, True]],
      DynamicModuleValues:>{}],
     Setting[#, {0}]& ],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{170, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1393269134]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], " ", "\[Rule]", " ", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " leaves enough space to display without ever resizing:"
}], "ExampleText",
 CellID->322644372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"OpenerView", "[", 
     RowBox[{"d", ",", 
      RowBox[{"ImageSize", "\[Rule]", "All"}]}], "]"}], ",", 
    RowBox[{"OpenerView", "[", 
     RowBox[{"d", ",", "True", ",", 
      RowBox[{"ImageSize", "\[Rule]", "All"}]}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->908772701],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    TagBox[
     DynamicModuleBox[{Typeset`var$$ = False}, 
      InterpretationBox[
       StyleBox[
        PaneSelectorBox[{False->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Circle"}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"], True->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Circle"},
            {"", 
             PaneBox[
              GraphicsBox[CircleBox[{0, 0}],
               ImageSize->50],
              ImageMargins->0]}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"]}, Dynamic[Typeset`var$$],
         Alignment->Automatic,
         BaselinePosition->Baseline,
         DefaultBaseStyle->"OpenerView",
         ImageMargins->0,
         ImageSize->All],
        Deployed->False,
        StripOnInput->False],
       OpenerView[{Circle, 
         Graphics[
          Circle[{0, 0}], ImageSize -> 50]}, False, ImageSize -> All]],
      DynamicModuleValues:>{}],
     Setting[#, {0}]& ],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     DynamicModuleBox[{Typeset`var$$ = True}, 
      InterpretationBox[
       StyleBox[
        PaneSelectorBox[{False->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Circle"}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"], True->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Circle"},
            {"", 
             PaneBox[
              GraphicsBox[CircleBox[{0, 0}],
               ImageSize->50],
              ImageMargins->0]}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"]}, Dynamic[Typeset`var$$],
         Alignment->Automatic,
         BaselinePosition->Baseline,
         DefaultBaseStyle->"OpenerView",
         ImageMargins->0,
         ImageSize->All],
        Deployed->False,
        StripOnInput->False],
       OpenerView[{Circle, 
         Graphics[
          Circle[{0, 0}], ImageSize -> 50]}, True, ImageSize -> All]],
      DynamicModuleValues:>{}],
     Setting[#, {0}]& ],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{178, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->512648250]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "OpenerView Control",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->83413870],

Cell["Start by displaying the open expression:", "ExampleText",
 CellID->120984400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "True"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362698449],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = True}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "a"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "a"},
         {"", 
          PaneBox["b",
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{$CellContext`a, $CellContext`b}, True]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{25, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374745986]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->414888455],

Cell[TextData[{
 "Connect an ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " to a checkbox:"
}], "ExampleText",
 CellID->97075455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OpenerView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Plus", ",", 
       RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "s", "]"}]}], "]"}], ",", 
   RowBox[{"Checkbox", "[", 
    RowBox[{"Dynamic", "[", "s", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->252390421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[$CellContext`s],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[$CellContext`s],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"},
         {"", 
          PaneBox[
           RowBox[{"x", "+", "y", "+", "z"}],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[$CellContext`s],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
     Dynamic[$CellContext`s]]], ",", 
   CheckboxBox[Dynamic[$CellContext`s]]}], "}"}]], "Output",
 ImageSize->{43, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1933733698]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->382845738],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->13161724],

Cell["Different alignments within the view:", "ExampleText",
 CellID->774137167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<Circle Circle Circle\>\"", ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->689456358],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Circle Circle Circle\"\>", ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->50]}], "}"}]], "Output",
 ImageSize->{220, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244748588]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"OpenerView", "[", 
    RowBox[{"d", ",", "True", ",", 
     RowBox[{"Alignment", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->422891062],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = True}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "\<\"Circle Circle Circle\"\>"}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "\<\"Circle Circle Circle\"\>"},
           {"", 
            PaneBox[
             GraphicsBox[CircleBox[{0, 0}],
              ImageSize->50],
             ImageMargins->0]}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Left,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{"Circle Circle Circle", 
        Graphics[
         Circle[{0, 0}], ImageSize -> 50]}, True, Alignment -> Left]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = True}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "\<\"Circle Circle Circle\"\>"}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "\<\"Circle Circle Circle\"\>"},
           {"", 
            PaneBox[
             GraphicsBox[CircleBox[{0, 0}],
              ImageSize->50],
             ImageMargins->0]}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Center,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{"Circle Circle Circle", 
        Graphics[
         Circle[{0, 0}], ImageSize -> 50]}, True, Alignment -> Center]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = True}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "\<\"Circle Circle Circle\"\>"}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "\<\"Circle Circle Circle\"\>"},
           {"", 
            PaneBox[
             GraphicsBox[CircleBox[{0, 0}],
              ImageSize->50],
             ImageMargins->0]}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Right,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{"Circle Circle Circle", 
        Graphics[
         Circle[{0, 0}], ImageSize -> 50]}, True, Alignment -> Right]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{503, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1058334511]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5995980],

Cell["\<\
By default the opener will not change until you click the opener area:\
\>", "ExampleText",
 CellID->214704586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OpenerView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Plus", ",", 
       RowBox[{"y", "+", "z"}]}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119939086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[$CellContext`x],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[$CellContext`x],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"},
         {"", 
          PaneBox[
           RowBox[{"y", "+", "z"}],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[$CellContext`x],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{Plus, $CellContext`y + $CellContext`z}, 
     Dynamic[$CellContext`x]]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{65, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1968561923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46268288],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", the opener changes as the mouse moves over the opener area:"
}], "ExampleText",
 CellID->306328665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OpenerView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Plus", ",", 
       RowBox[{"y", "+", "z"}]}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->469113643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[$CellContext`x],
           Appearance->Automatic,
           AutoAction->True,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[$CellContext`x],
           Appearance->Automatic,
           AutoAction->True,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"},
         {"", 
          PaneBox[
           RowBox[{"y", "+", "z"}],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[$CellContext`x],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{Plus, $CellContext`y + $CellContext`z}, 
     Dynamic[$CellContext`x], AutoAction -> True]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{107, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1487174179]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->164080169],

Cell["Change the background color:", "ExampleText",
 CellID->15655354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"OpenerView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Plus", ",", 
       RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Gray", ",", "Yellow", ",", "Purple"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148727407],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{
               RGBColor[1, 0.5, 0.5]}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"},
           {"", 
            PaneBox[
             RowBox[{"x", "+", "y", "+", "z"}],
             ImageMargins->0]}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{
               RGBColor[1, 0.5, 0.5]}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Automatic,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
       False, Background -> RGBColor[1, 0.5, 0.5]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{
               GrayLevel[0.5]}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"},
           {"", 
            PaneBox[
             RowBox[{"x", "+", "y", "+", "z"}],
             ImageMargins->0]}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{
               GrayLevel[0.5]}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Automatic,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
       False, Background -> GrayLevel[0.5]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{
               RGBColor[1, 1, 0]}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"},
           {"", 
            PaneBox[
             RowBox[{"x", "+", "y", "+", "z"}],
             ImageMargins->0]}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{
               RGBColor[1, 1, 0]}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Automatic,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
       False, Background -> RGBColor[1, 1, 0]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{
               RGBColor[0.5, 0, 0.5]}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"},
           {"", 
            PaneBox[
             RowBox[{"x", "+", "y", "+", "z"}],
             ImageMargins->0]}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{
               RGBColor[0.5, 0, 0.5]}}},
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Automatic,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
       False, Background -> RGBColor[0.5, 0, 0.5]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{220, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374259020]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->440704510],

Cell["Change the background color dynamically:", "ExampleText",
 CellID->127519464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Plus", ",", 
     RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], ",", 
   RowBox[{"Dynamic", "[", "c", "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"If", "[", 
      RowBox[{"c", ",", "Pink", ",", "Gray"}], "]"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272888842],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   PaneSelectorBox[{False->
    TagBox[GridBox[{
       {
        OpenerBox[Dynamic[$CellContext`c],
         Appearance->Automatic,
         AutoAction->False,
         ContinuousAction->False,
         Enabled->Automatic], "Plus"}
      },
      BaselinePosition->{1, 1},
      ColumnsEqual->False,
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxBackground->{"Columns" -> Dynamic[
          GridDump`Restructure[Background, 
           Dynamic[
            If[$CellContext`c, Pink, Gray]], "Columns"]], "ColumnsIndexed" -> 
        Dynamic[
          GridDump`Restructure[Background, 
           Dynamic[
            If[$CellContext`c, Pink, Gray]], "ColumnsIndexed"]], "Rows" -> 
        Dynamic[
          GridDump`Restructure[Background, 
           Dynamic[
            If[$CellContext`c, Pink, Gray]], "Rows"]], "RowsIndexed" -> 
        Dynamic[
          GridDump`Restructure[Background, 
           Dynamic[
            If[$CellContext`c, Pink, Gray]], "RowsIndexed"]], "ItemsIndexed" -> 
        Dynamic[
          GridDump`Restructure[Background, 
           Dynamic[
            If[$CellContext`c, Pink, Gray]], "ItemsIndexed"]]},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
      GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
      RowsEqual->False],
     "Grid"], True->
    TagBox[GridBox[{
       {
        OpenerBox[Dynamic[$CellContext`c],
         Appearance->Automatic,
         AutoAction->False,
         ContinuousAction->False,
         Enabled->Automatic], "Plus"},
       {"", 
        PaneBox[
         RowBox[{"x", "+", "y", "+", "z"}],
         ImageMargins->0]}
      },
      BaselinePosition->{1, 1},
      ColumnsEqual->False,
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxBackground->{"Columns" -> Dynamic[
          GridDump`Restructure[Background, 
           Dynamic[
            If[$CellContext`c, Pink, Gray]], "Columns"]], "ColumnsIndexed" -> 
        Dynamic[
          GridDump`Restructure[Background, 
           Dynamic[
            If[$CellContext`c, Pink, Gray]], "ColumnsIndexed"]], "Rows" -> 
        Dynamic[
          GridDump`Restructure[Background, 
           Dynamic[
            If[$CellContext`c, Pink, Gray]], "Rows"]], "RowsIndexed" -> 
        Dynamic[
          GridDump`Restructure[Background, 
           Dynamic[
            If[$CellContext`c, Pink, Gray]], "RowsIndexed"]], "ItemsIndexed" -> 
        Dynamic[
          GridDump`Restructure[Background, 
           Dynamic[
            If[$CellContext`c, Pink, Gray]], "ItemsIndexed"]]},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
      GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
      RowsEqual->False],
     "Grid"]}, Dynamic[$CellContext`c],
    Alignment->Automatic,
    BaselinePosition->Baseline,
    DefaultBaseStyle->"OpenerView",
    ImageMargins->0,
    ImageSize->Automatic],
   Deployed->False,
   StripOnInput->False],
  OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
   Dynamic[$CellContext`c], Background -> Dynamic[
     If[$CellContext`c, Pink, Gray]]]]], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191747077]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->313224179],

Cell["Align with surrounding text:", "ExampleText",
 CellID->473627373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"OpenerView", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Plus", ",", 
         RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "c"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73270295],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"}
          },
          BaselinePosition->Top,
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"},
           {"", 
            PaneBox[
             RowBox[{"x", "+", "y", "+", "z"}],
             ImageMargins->0]}
          },
          BaselinePosition->Top,
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Automatic,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
       False, BaselinePosition -> Top]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], "xxx", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"}
          },
          BaselinePosition->Center,
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"},
           {"", 
            PaneBox[
             RowBox[{"x", "+", "y", "+", "z"}],
             ImageMargins->0]}
          },
          BaselinePosition->Center,
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Automatic,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
       False, BaselinePosition -> Center]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], "xxx", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"}
          },
          BaselinePosition->Bottom,
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"},
           {"", 
            PaneBox[
             RowBox[{"x", "+", "y", "+", "z"}],
             ImageMargins->0]}
          },
          BaselinePosition->Bottom,
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Automatic,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
       False, BaselinePosition -> Bottom]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}],
  Row[{
    OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
     BaselinePosition -> Top], 
    OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
     BaselinePosition -> Center], 
    OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
     BaselinePosition -> Bottom]}, "xxx"]]], "Output",
 ImageSize->{184, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1467652639]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->424391743],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " is enabled:"
}], "ExampleText",
 CellID->200884514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{"{", 
   RowBox[{"Plus", ",", 
    RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166164811],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Plus"},
         {"", 
          PaneBox[
           RowBox[{"x", "+", "y", "+", "z"}],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
     False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->840734231]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["Enabled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Enabled"]], "InlineFormula"],
 "->",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " is disabled, but visible in its current state:"
}], "ExampleText",
 CellID->487543105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Plus", ",", 
     RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->597916526],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->False], "Plus"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->False], "Plus"},
         {"", 
          PaneBox[
           RowBox[{"x", "+", "y", "+", "z"}],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
     False, Enabled -> False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1925306804]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->547926109],

Cell["Add margins within the view:", "ExampleText",
 CellID->265228531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"OpenerView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Plus", ",", 
       RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], ",", "True", ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->962979193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = True}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"},
           {"", 
            PaneBox[
             RowBox[{"x", "+", "y", "+", "z"}],
             ImageMargins->0]}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Automatic,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
       True, FrameMargins -> 0]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = True}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"},
           {"", 
            PaneBox[
             RowBox[{"x", "+", "y", "+", "z"}],
             ImageMargins->10]}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Automatic,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
       True, FrameMargins -> 10]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = True}, 
     InterpretationBox[
      StyleBox[
       PaneSelectorBox[{False->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"], True->
        TagBox[GridBox[{
           {
            OpenerBox[Dynamic[Typeset`var$$],
             Appearance->Automatic,
             AutoAction->False,
             ContinuousAction->False,
             Enabled->Automatic], "Plus"},
           {"", 
            PaneBox[
             RowBox[{"x", "+", "y", "+", "z"}],
             ImageMargins->20]}
          },
          BaselinePosition->{1, 1},
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxBackground->{"Columns" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
          RowsEqual->False],
         "Grid"]}, Dynamic[Typeset`var$$],
        Alignment->Automatic,
        BaselinePosition->Baseline,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0,
        ImageSize->Automatic],
       Deployed->False,
       StripOnInput->False],
      OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
       True, FrameMargins -> 20]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{284, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->347861832]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->877614663],

Cell["Add margins outside the view:", "ExampleText",
 CellID->690396223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"OpenerView", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Plus", ",", 
        RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], ",", "True", ",", 
      RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "15", ",", "40"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->730166182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    TagBox[
     DynamicModuleBox[{Typeset`var$$ = True}, 
      InterpretationBox[
       StyleBox[
        PaneSelectorBox[{False->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Plus"}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"], True->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Plus"},
            {"", 
             PaneBox[
              RowBox[{"x", "+", "y", "+", "z"}],
              ImageMargins->0]}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"]}, Dynamic[Typeset`var$$],
         Alignment->Automatic,
         BaselinePosition->Baseline,
         DefaultBaseStyle->"OpenerView",
         ImageMargins->0,
         ImageSize->Automatic],
        Deployed->False,
        StripOnInput->False],
       OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
        True, ImageMargins -> 0]],
      DynamicModuleValues:>{}],
     Setting[#, {0}]& ],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     DynamicModuleBox[{Typeset`var$$ = True}, 
      InterpretationBox[
       StyleBox[
        PaneSelectorBox[{False->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Plus"}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"], True->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Plus"},
            {"", 
             PaneBox[
              RowBox[{"x", "+", "y", "+", "z"}],
              ImageMargins->0]}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"]}, Dynamic[Typeset`var$$],
         Alignment->Automatic,
         BaselinePosition->Baseline,
         DefaultBaseStyle->"OpenerView",
         ImageMargins->15,
         ImageSize->Automatic],
        Deployed->False,
        StripOnInput->False],
       OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
        True, ImageMargins -> 15]],
      DynamicModuleValues:>{}],
     Setting[#, {0}]& ],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     DynamicModuleBox[{Typeset`var$$ = True}, 
      InterpretationBox[
       StyleBox[
        PaneSelectorBox[{False->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Plus"}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"], True->
         TagBox[GridBox[{
            {
             OpenerBox[Dynamic[Typeset`var$$],
              Appearance->Automatic,
              AutoAction->False,
              ContinuousAction->False,
              Enabled->Automatic], "Plus"},
            {"", 
             PaneBox[
              RowBox[{"x", "+", "y", "+", "z"}],
              ImageMargins->0]}
           },
           BaselinePosition->{1, 1},
           ColumnsEqual->False,
           GridBoxAlignment->{"Columns" -> {{Left}}},
           GridBoxBackground->{"Columns" -> {{Automatic}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
           RowsEqual->False],
          "Grid"]}, Dynamic[Typeset`var$$],
         Alignment->Automatic,
         BaselinePosition->Baseline,
         DefaultBaseStyle->"OpenerView",
         ImageMargins->40,
         ImageSize->Automatic],
        Deployed->False,
        StripOnInput->False],
       OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
        True, ImageMargins -> 40]],
      DynamicModuleValues:>{}],
     Setting[#, {0}]& ],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{364, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1063323290]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->137502306],

Cell[TextData[{
 "Control the overall size of ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->559398874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Framed", "[", 
     RowBox[{"OpenerView", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Plus", ",", 
         RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "70", ",", "100"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"60", ",", "80", ",", "100"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->828399965],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FrameBox[
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneSelectorBox[{False->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"], True->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"},
              {"", 
               PaneBox[
                RowBox[{"x", "+", "y", "+", "z"}],
                ImageMargins->0]}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"]}, Dynamic[Typeset`var$$],
           Alignment->Automatic,
           BaselinePosition->Baseline,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0,
           ImageSize->{60, 50}],
          Deployed->False,
          StripOnInput->False],
         OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
          False, ImageSize -> {60, 50}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      StripOnInput->False], 
     FrameBox[
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneSelectorBox[{False->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"], True->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"},
              {"", 
               PaneBox[
                RowBox[{"x", "+", "y", "+", "z"}],
                ImageMargins->0]}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"]}, Dynamic[Typeset`var$$],
           Alignment->Automatic,
           BaselinePosition->Baseline,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0,
           ImageSize->{80, 50}],
          Deployed->False,
          StripOnInput->False],
         OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
          False, ImageSize -> {80, 50}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      StripOnInput->False], 
     FrameBox[
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneSelectorBox[{False->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"], True->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"},
              {"", 
               PaneBox[
                RowBox[{"x", "+", "y", "+", "z"}],
                ImageMargins->0]}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"]}, Dynamic[Typeset`var$$],
           Alignment->Automatic,
           BaselinePosition->Baseline,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0,
           ImageSize->{100, 50}],
          Deployed->False,
          StripOnInput->False],
         OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
          False, ImageSize -> {100, 50}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      StripOnInput->False]},
    {
     FrameBox[
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneSelectorBox[{False->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"], True->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"},
              {"", 
               PaneBox[
                RowBox[{"x", "+", "y", "+", "z"}],
                ImageMargins->0]}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"]}, Dynamic[Typeset`var$$],
           Alignment->Automatic,
           BaselinePosition->Baseline,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0,
           ImageSize->{60, 70}],
          Deployed->False,
          StripOnInput->False],
         OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
          False, ImageSize -> {60, 70}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      StripOnInput->False], 
     FrameBox[
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneSelectorBox[{False->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"], True->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"},
              {"", 
               PaneBox[
                RowBox[{"x", "+", "y", "+", "z"}],
                ImageMargins->0]}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"]}, Dynamic[Typeset`var$$],
           Alignment->Automatic,
           BaselinePosition->Baseline,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0,
           ImageSize->{80, 70}],
          Deployed->False,
          StripOnInput->False],
         OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
          False, ImageSize -> {80, 70}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      StripOnInput->False], 
     FrameBox[
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneSelectorBox[{False->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"], True->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"},
              {"", 
               PaneBox[
                RowBox[{"x", "+", "y", "+", "z"}],
                ImageMargins->0]}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"]}, Dynamic[Typeset`var$$],
           Alignment->Automatic,
           BaselinePosition->Baseline,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0,
           ImageSize->{100, 70}],
          Deployed->False,
          StripOnInput->False],
         OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
          False, ImageSize -> {100, 70}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      StripOnInput->False]},
    {
     FrameBox[
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneSelectorBox[{False->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"], True->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"},
              {"", 
               PaneBox[
                RowBox[{"x", "+", "y", "+", "z"}],
                ImageMargins->0]}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"]}, Dynamic[Typeset`var$$],
           Alignment->Automatic,
           BaselinePosition->Baseline,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0,
           ImageSize->{60, 100}],
          Deployed->False,
          StripOnInput->False],
         OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
          False, ImageSize -> {60, 100}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      StripOnInput->False], 
     FrameBox[
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneSelectorBox[{False->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"], True->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"},
              {"", 
               PaneBox[
                RowBox[{"x", "+", "y", "+", "z"}],
                ImageMargins->0]}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"]}, Dynamic[Typeset`var$$],
           Alignment->Automatic,
           BaselinePosition->Baseline,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0,
           ImageSize->{80, 100}],
          Deployed->False,
          StripOnInput->False],
         OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
          False, ImageSize -> {80, 100}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      StripOnInput->False], 
     FrameBox[
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneSelectorBox[{False->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"], True->
           TagBox[GridBox[{
              {
               OpenerBox[Dynamic[Typeset`var$$],
                Appearance->Automatic,
                AutoAction->False,
                ContinuousAction->False,
                Enabled->Automatic], "Plus"},
              {"", 
               PaneBox[
                RowBox[{"x", "+", "y", "+", "z"}],
                ImageMargins->0]}
             },
             BaselinePosition->{1, 1},
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             GridBoxBackground->{"Columns" -> {{Automatic}}},
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
             RowsEqual->False],
            "Grid"]}, Dynamic[Typeset`var$$],
           Alignment->Automatic,
           BaselinePosition->Baseline,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0,
           ImageSize->{100, 100}],
          Deployed->False,
          StripOnInput->False],
         OpenerView[{Plus, $CellContext`x + $CellContext`y + $CellContext`z}, 
          False, ImageSize -> {100, 100}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      StripOnInput->False]}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{290, 263},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2063108343]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->197608003],

Cell["Show the graphical representation of a clock:", "ExampleText",
 CellID->598828168],

Cell[BoxData[{
 RowBox[{
  RowBox[{"hour", ":=", 
   RowBox[{
    RowBox[{"-", "2"}], "Pi", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Part", "[", 
        RowBox[{
         RowBox[{"DateList", "[", "]"}], ",", "4"}], "]"}], "/", "12"}], "+", 
      
      RowBox[{
       RowBox[{
        RowBox[{"Part", "[", 
         RowBox[{
          RowBox[{"DateList", "[", "]"}], ",", "5"}], "]"}], "/", "60"}], "/",
        "12"}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"min", ":=", 
   RowBox[{
    RowBox[{"-", "2"}], "Pi", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Part", "[", 
       RowBox[{
        RowBox[{"DateList", "[", "]"}], ",", "5"}], "]"}], "/", "60"}], 
     ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sec", ":=", 
   RowBox[{
    RowBox[{"-", "2"}], "Pi", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Floor", "[", 
       RowBox[{"Last", "[", 
        RowBox[{"DateList", "[", "]"}], "]"}], "]"}], "/", "60"}], ")"}]}]}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->286047821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dynamic", "[", 
     RowBox[{
      RowBox[{"DateString", "[", "]"}], ",", 
      RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Gray", ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "12"}], "]"}], ",", "Black", 
         ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Translate", "[", 
            RowBox[{
             RowBox[{"Disk", "[", "]"}], ",", 
             RowBox[{"10", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
                RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}]}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"\[Theta]", ",", "0", ",", 
             RowBox[{"2", "\[Pi]"}], ",", 
             RowBox[{"2", 
              RowBox[{"\[Pi]", "/", "12"}]}]}], "}"}]}], "]"}], ",", 
         RowBox[{"Rotate", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "10"}], "}"}]}], "}"}], "]"}], ",", "sec", 
           ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "Pink", ",", 
         RowBox[{"Rotate", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "7"}], "}"}]}], "}"}], "]"}], ",", "min", 
           ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "Red", ",", 
         RowBox[{"Rotate", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "5"}], "}"}]}], "}"}], "]"}], ",", "hour", 
           ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72682325],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          DynamicBox[ToBoxes[
            DateString[], StandardForm],
           ImageSizeCache->{168., {2., 8.}},
           UpdateInterval:>1]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          DynamicBox[ToBoxes[
            DateString[], StandardForm],
           ImageSizeCache->{172.5, {3., 8.}},
           UpdateInterval:>1]},
         {"", 
          PaneBox[
           DynamicBox[ToBoxes[
             Graphics[{Gray, 
               Disk[{0, 0}, 12], Black, 
               Table[
                Translate[
                 Disk[], 10 {
                   Cos[$CellContext`\[Theta]], 
                   Sin[$CellContext`\[Theta]]}], {$CellContext`\[Theta], 0, 2 
                 Pi, 2 (Pi/12)}], 
               Rotate[
                Line[{{0, 0}, {0, 10}}], $CellContext`sec, {0, 0}], Pink, 
               Rotate[
                Line[{{0, 0}, {0, 7}}], $CellContext`min, {0, 0}], Red, 
               Rotate[
                Line[{{0, 0}, {0, 5}}], $CellContext`hour, {0, 0}]}], 
             StandardForm],
            ImageSizeCache->{180., {88., 92.}},
            UpdateInterval:>1],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{
      Dynamic[
       DateString[], UpdateInterval -> 1], 
      Dynamic[
       Graphics[{Gray, 
         Disk[{0, 0}, 12], Black, 
         Table[
          Translate[
           Disk[], 10 {
             Cos[$CellContext`\[Theta]], 
             Sin[$CellContext`\[Theta]]}], {$CellContext`\[Theta], 0, 2 Pi, 
           2 (Pi/12)}], 
         Rotate[
          Line[{{0, 0}, {0, 10}}], $CellContext`sec, {0, 0}], Pink, 
         Rotate[
          Line[{{0, 0}, {0, 7}}], $CellContext`min, {0, 0}], Red, 
         Rotate[
          Line[{{0, 0}, {0, 5}}], $CellContext`hour, {0, 0}]}], 
       UpdateInterval -> 1]}, False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1680476085]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21193072],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " is a construction of ",
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PaneSelector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaneSelector"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->36865483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Heading\>\"", ",", "\"\<Actual content\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234513465],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "\<\"Heading\"\>"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "\<\"Heading\"\>"},
         {"", 
          PaneBox["\<\"Actual content\"\>",
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{"Heading", "Actual content"}, False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->296208331]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Opener", "[", 
     RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"PaneSelector", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"False", "\[Rule]", "\"\<Heading\>\""}], ",", 
        RowBox[{"True", "\[Rule]", 
         RowBox[{"Column", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<Heading\>\"", ",", "\"\<Actual content\>\""}], "}"}], 
          "]"}]}]}], "}"}], ",", 
      RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36327933],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   OpenerBox[Dynamic[$CellContext`x]], "\[InvisibleSpace]", 
   PaneSelectorBox[{False->"\<\"Heading\"\>", True->
    TagBox[GridBox[{
       {"\<\"Heading\"\>"},
       {"\<\"Actual content\"\>"}
      },
      ColumnsEqual->False,
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
      RowsEqual->False],
     "Column"]}, Dynamic[$CellContext`x]]}],
  Row[{
    Opener[
     Dynamic[$CellContext`x]], 
    PaneSelector[{
     False -> "Heading", True -> Column[{"Heading", "Actual content"}]}, 
     Dynamic[$CellContext`x]]}]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{114, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->506325371],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   OpenerBox[Dynamic[$CellContext`x]], "\[InvisibleSpace]", 
   PaneSelectorBox[{False->"\<\"Heading\"\>", True->
    TagBox[GridBox[{
       {"\<\"Heading\"\>"},
       {"\<\"Actual content\"\>"}
      },
      ColumnsEqual->False,
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
      RowsEqual->False],
     "Column"]}, Dynamic[$CellContext`x]]}],
  Row[{
    Opener[
     Dynamic[$CellContext`x]], 
    PaneSelector[{
     False -> "Heading", True -> Column[{"Heading", "Actual content"}]}, 
     Dynamic[$CellContext`x]]}]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{114, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1741224465]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->339191651],

Cell["Dynamic variables only update when visible: ", "ExampleText",
 CellID->430350985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{
       RowBox[{"x", "=", 
        RowBox[{"DateString", "[", "]"}]}], ",", 
       RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}]}], "}"}], ",", 
   "False"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263336560],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          DynamicBox[ToBoxes[$CellContext`x, StandardForm],
           ImageSizeCache->{35., {0., 8.}}]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          DynamicBox[ToBoxes[$CellContext`x, StandardForm]]},
         {"", 
          PaneBox[
           DynamicBox[ToBoxes[$CellContext`x = DateString[], StandardForm],
            UpdateInterval:>1],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{
      Dynamic[$CellContext`x], 
      Dynamic[$CellContext`x = DateString[], UpdateInterval -> 1]}, False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->820570786]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{
       RowBox[{"y", "=", 
        RowBox[{"DateString", "[", "]"}]}], ",", 
       RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}]}], "}"}], ",", 
   "True"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->691770116],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = True}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          DynamicBox[ToBoxes[$CellContext`y, StandardForm]]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], 
          DynamicBox[ToBoxes[$CellContext`y, StandardForm],
           ImageSizeCache->{7., {2., 6.}}]},
         {"", 
          PaneBox[
           DynamicBox[ToBoxes[$CellContext`y = DateString[], StandardForm],
            ImageSizeCache->{168., {2., 8.}},
            UpdateInterval:>1],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{
      Dynamic[$CellContext`y], 
      Dynamic[$CellContext`y = DateString[], UpdateInterval -> 1]}, True]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{186, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->193219268]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32213],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SlideView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlideView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TabView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TabView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FlipView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FlipView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaneSelector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaneSelector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Opener",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opener"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3062]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18919],

Cell[TextData[ButtonBox["Views",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Views"]], "Tutorials",
 CellID->14681]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->286551777],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->722167712],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->99296930],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->116399716],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->762128589],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->597221401],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->220581381],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->149853190],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->722143160]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OpenerView - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 2.3772952}", "context" -> "System`", 
    "keywords" -> {"open viewer"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "OpenerView[{expr_1, expr_2}] represents an object which displays as an \
opener, together with expr_1 if the opener is closed, and both expr_1 and \
expr_2 if it is open. OpenerView[{expr_1, expr_2}, state] specifies the state \
of the opener, with False being closed, and True being open.", 
    "synonyms" -> {"opener view"}, "title" -> "OpenerView", "type" -> 
    "Symbol", "uri" -> "ref/OpenerView"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13329, 407, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->576660090]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 174665, 5056}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3135, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3758, 95, 1575, 37, 70, "ObjectNameGrid"],
Cell[5336, 134, 2035, 66, 70, "Usage",
 CellID->32556]
}, Open  ]],
Cell[CellGroupData[{
Cell[7408, 205, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7886, 222, 186, 9, 70, "Notes",
 CellID->20016],
Cell[8075, 233, 210, 8, 70, "Notes",
 CellID->14433],
Cell[8288, 243, 670, 22, 70, "Notes",
 CellID->16964],
Cell[8961, 267, 68, 1, 70, "Notes",
 CellID->8358],
Cell[9032, 270, 2354, 63, 70, "3ColumnTableMod",
 CellID->20748],
Cell[11389, 335, 1027, 36, 70, "Notes",
 CellID->24105],
Cell[12419, 373, 523, 17, 70, "Notes",
 CellID->6423],
Cell[12945, 392, 347, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[13329, 407, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->576660090],
Cell[CellGroupData[{
Cell[13714, 421, 148, 5, 70, "ExampleSection",
 CellID->448455150],
Cell[CellGroupData[{
Cell[13887, 430, 191, 6, 28, "Input",
 CellID->292717771],
Cell[14081, 438, 1958, 59, 36, "Output",
 CellID->971265788]
}, Open  ]],
Cell[16054, 500, 125, 3, 70, "ExampleDelimiter",
 CellID->433535640],
Cell[16182, 505, 69, 1, 70, "ExampleText",
 CellID->749766276],
Cell[CellGroupData[{
Cell[16276, 510, 222, 8, 28, "Input",
 CellID->16683294],
Cell[16501, 520, 1957, 59, 52, "Output",
 CellID->1040898069]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18507, 585, 220, 7, 70, "ExampleSection",
 CellID->365065168],
Cell[CellGroupData[{
Cell[18752, 596, 239, 7, 70, "ExampleSubsection",
 CellID->328872546],
Cell[18994, 605, 213, 8, 70, "ExampleText",
 CellID->20643876],
Cell[CellGroupData[{
Cell[19232, 617, 392, 13, 70, "Input",
 CellID->234501074],
Cell[19627, 632, 26575, 477, 70, "Output",
 CellID->1721031128]
}, Open  ]],
Cell[46217, 1112, 125, 3, 70, "ExampleDelimiter",
 CellID->554773711],
Cell[46345, 1117, 348, 12, 70, "ExampleText",
 CellID->12327381],
Cell[CellGroupData[{
Cell[46718, 1133, 691, 23, 70, "Input",
 CellID->320019421],
Cell[47412, 1158, 4047, 100, 70, "Output",
 CellID->1457610618]
}, Open  ]],
Cell[51474, 1261, 125, 3, 70, "ExampleDelimiter",
 CellID->572283909],
Cell[51602, 1266, 193, 7, 70, "ExampleText",
 CellID->349325],
Cell[CellGroupData[{
Cell[51820, 1277, 336, 11, 70, "Input",
 CellID->10598875],
Cell[52159, 1290, 8674, 220, 70, "Output",
 CellID->1715695397]
}, Open  ]],
Cell[60848, 1513, 124, 3, 70, "ExampleDelimiter",
 CellID->36266290],
Cell[60975, 1518, 232, 8, 70, "ExampleText",
 CellID->30642317],
Cell[CellGroupData[{
Cell[61232, 1530, 280, 9, 70, "Input",
 CellID->47389411],
Cell[61515, 1541, 260, 9, 73, "Output",
 CellID->1429609110]
}, Open  ]],
Cell[CellGroupData[{
Cell[61812, 1555, 252, 8, 70, "Input",
 CellID->650262231],
Cell[62067, 1565, 4329, 127, 70, "Output",
 CellID->1393269134]
}, Open  ]],
Cell[66411, 1695, 489, 17, 70, "ExampleText",
 CellID->322644372],
Cell[CellGroupData[{
Cell[66925, 1716, 374, 11, 70, "Input",
 CellID->908772701],
Cell[67302, 1729, 4352, 127, 70, "Output",
 CellID->512648250]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[71703, 1862, 238, 7, 70, "ExampleSubsection",
 CellID->83413870],
Cell[71944, 1871, 83, 1, 70, "ExampleText",
 CellID->120984400],
Cell[CellGroupData[{
Cell[72052, 1876, 181, 6, 70, "Input",
 CellID->362698449],
Cell[72236, 1884, 1878, 57, 70, "Output",
 CellID->374745986]
}, Open  ]],
Cell[74129, 1944, 125, 3, 70, "ExampleDelimiter",
 CellID->414888455],
Cell[74257, 1949, 211, 8, 70, "ExampleText",
 CellID->97075455],
Cell[CellGroupData[{
Cell[74493, 1961, 381, 12, 70, "Input",
 CellID->252390421],
Cell[74877, 1975, 1957, 58, 70, "Output",
 CellID->1933733698]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[76895, 2040, 222, 7, 70, "ExampleSection",
 CellID->382845738],
Cell[CellGroupData[{
Cell[77142, 2051, 229, 7, 70, "ExampleSubsection",
 CellID->13161724],
Cell[77374, 2060, 80, 1, 70, "ExampleText",
 CellID->774137167],
Cell[CellGroupData[{
Cell[77479, 2065, 303, 9, 70, "Input",
 CellID->689456358],
Cell[77785, 2076, 281, 9, 73, "Output",
 CellID->244748588]
}, Open  ]],
Cell[CellGroupData[{
Cell[78103, 2090, 367, 12, 70, "Input",
 CellID->422891062],
Cell[78473, 2104, 6335, 181, 70, "Output",
 CellID->1058334511]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84857, 2291, 229, 7, 70, "ExampleSubsection",
 CellID->5995980],
Cell[85089, 2300, 121, 3, 70, "ExampleText",
 CellID->214704586],
Cell[CellGroupData[{
Cell[85235, 2307, 334, 11, 70, "Input",
 CellID->119939086],
Cell[85572, 2320, 1980, 59, 70, "Output",
 CellID->1968561923]
}, Open  ]],
Cell[87567, 2382, 124, 3, 70, "ExampleDelimiter",
 CellID->46268288],
Cell[87694, 2387, 258, 8, 70, "ExampleText",
 CellID->306328665],
Cell[CellGroupData[{
Cell[87977, 2399, 388, 12, 70, "Input",
 CellID->469113643],
Cell[88368, 2413, 1999, 59, 70, "Output",
 CellID->1487174179]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[90416, 2478, 231, 7, 70, "ExampleSubsection",
 CellID->164080169],
Cell[90650, 2487, 70, 1, 70, "ExampleText",
 CellID->15655354],
Cell[CellGroupData[{
Cell[90745, 2492, 465, 15, 70, "Input",
 CellID->148727407],
Cell[91213, 2509, 8272, 238, 70, "Output",
 CellID->374259020]
}, Open  ]],
Cell[99500, 2750, 125, 3, 70, "ExampleDelimiter",
 CellID->440704510],
Cell[99628, 2755, 83, 1, 70, "ExampleText",
 CellID->127519464],
Cell[CellGroupData[{
Cell[99736, 2760, 415, 13, 70, "Input",
 CellID->272888842],
Cell[100154, 2775, 3326, 92, 70, "Output",
 CellID->191747077]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[103529, 2873, 237, 7, 70, "ExampleSubsection",
 CellID->313224179],
Cell[103769, 2882, 71, 1, 70, "ExampleText",
 CellID->473627373],
Cell[CellGroupData[{
Cell[103865, 2887, 542, 17, 70, "Input",
 CellID->73270295],
Cell[104410, 2906, 6423, 182, 70, "Output",
 CellID->1467652639]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[110882, 3094, 228, 7, 70, "ExampleSubsection",
 CellID->424391743],
Cell[111113, 3103, 210, 8, 70, "ExampleText",
 CellID->200884514],
Cell[CellGroupData[{
Cell[111348, 3115, 191, 6, 70, "Input",
 CellID->166164811],
Cell[111542, 3123, 1958, 59, 70, "Output",
 CellID->840734231]
}, Open  ]],
Cell[113515, 3185, 488, 18, 70, "ExampleText",
 CellID->487543105],
Cell[CellGroupData[{
Cell[114028, 3207, 257, 8, 70, "Input",
 CellID->597916526],
Cell[114288, 3217, 1969, 59, 70, "Output",
 CellID->1925306804]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[116306, 3282, 233, 7, 70, "ExampleSubsection",
 CellID->547926109],
Cell[116542, 3291, 71, 1, 70, "ExampleText",
 CellID->265228531],
Cell[CellGroupData[{
Cell[116638, 3296, 451, 14, 70, "Input",
 CellID->962979193],
Cell[117092, 3312, 6059, 175, 70, "Output",
 CellID->347861832]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[123200, 3493, 233, 7, 70, "ExampleSubsection",
 CellID->877614663],
Cell[123436, 3502, 72, 1, 70, "ExampleText",
 CellID->690396223],
Cell[CellGroupData[{
Cell[123533, 3507, 491, 15, 70, "Input",
 CellID->730166182],
Cell[124027, 3524, 6346, 181, 70, "Output",
 CellID->1063323290]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[130422, 3711, 230, 7, 70, "ExampleSubsection",
 CellID->137502306],
Cell[130655, 3720, 215, 8, 70, "ExampleText",
 CellID->559398874],
Cell[CellGroupData[{
Cell[130895, 3732, 712, 23, 70, "Input",
 CellID->828399965],
Cell[131610, 3757, 19840, 535, 70, "Output",
 CellID->2063108343]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[151511, 4299, 227, 7, 70, "ExampleSection",
 CellID->197608003],
Cell[151741, 4308, 88, 1, 70, "ExampleText",
 CellID->598828168],
Cell[151832, 4311, 1037, 39, 70, "Input",
 CellID->286047821],
Cell[CellGroupData[{
Cell[152894, 4354, 2553, 73, 70, "Input",
 CellID->72682325],
Cell[155450, 4429, 3492, 101, 70, "Output",
 CellID->1680476085]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[158991, 4536, 236, 7, 70, "ExampleSection",
 CellID->21193072],
Cell[159230, 4545, 460, 17, 70, "ExampleText",
 CellID->36865483],
Cell[CellGroupData[{
Cell[159715, 4566, 191, 6, 70, "Input",
 CellID->234513465],
Cell[159909, 4574, 1926, 57, 70, "Output",
 CellID->296208331]
}, Open  ]],
Cell[CellGroupData[{
Cell[161872, 4636, 617, 18, 70, "Input",
 CellID->36327933],
Cell[162492, 4656, 845, 26, 70, "Output",
 CellID->506325371],
Cell[163340, 4684, 846, 26, 70, "Output",
 CellID->1741224465]
}, Open  ]],
Cell[164201, 4713, 125, 3, 70, "ExampleDelimiter",
 CellID->339191651],
Cell[164329, 4718, 87, 1, 70, "ExampleText",
 CellID->430350985],
Cell[CellGroupData[{
Cell[164441, 4723, 400, 13, 70, "Input",
 CellID->263336560],
Cell[164844, 4738, 2210, 64, 70, "Output",
 CellID->820570786]
}, Open  ]],
Cell[CellGroupData[{
Cell[167091, 4807, 399, 13, 70, "Input",
 CellID->691770116],
Cell[167493, 4822, 2254, 65, 70, "Output",
 CellID->193219268]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[169808, 4894, 311, 9, 70, "SeeAlsoSection",
 CellID->32213],
Cell[170122, 4905, 1189, 44, 70, "SeeAlso",
 CellID->3062]
}, Open  ]],
Cell[CellGroupData[{
Cell[171348, 4954, 314, 9, 70, "TutorialsSection",
 CellID->18919],
Cell[171665, 4965, 121, 3, 70, "Tutorials",
 CellID->14681]
}, Open  ]],
Cell[CellGroupData[{
Cell[171823, 4973, 319, 9, 70, "MoreAboutSection",
 CellID->286551777],
Cell[172145, 4984, 149, 3, 70, "MoreAbout",
 CellID->722167712],
Cell[172297, 4989, 148, 3, 70, "MoreAbout",
 CellID->99296930],
Cell[172448, 4994, 153, 3, 70, "MoreAbout",
 CellID->116399716],
Cell[172604, 4999, 142, 3, 70, "MoreAbout",
 CellID->762128589],
Cell[172749, 5004, 128, 3, 70, "MoreAbout",
 CellID->597221401],
Cell[172880, 5009, 154, 3, 70, "MoreAbout",
 CellID->220581381],
Cell[173037, 5014, 180, 3, 70, "MoreAbout",
 CellID->149853190],
Cell[173220, 5019, 154, 3, 70, "MoreAbout",
 CellID->722143160]
}, Open  ]],
Cell[173389, 5025, 27, 0, 70, "History"],
Cell[173419, 5027, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

