(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23229,        774]
NotebookOptionsPosition[     18687,        633]
NotebookOutlinePosition[     20553,        679]
CellTagsIndexPosition[     20468,        674]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Options" :> 
          Documentation`HelpLookup["paclet:tutorial/ManipulatingOptions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AbsoluteOptions" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteOptions"], 
          "SetOptions" :> Documentation`HelpLookup["paclet:ref/SetOptions"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], 
          "SystemInformation" :> 
          Documentation`HelpLookup["paclet:ref/SystemInformation"], 
          "NotebookInformation" :> 
          Documentation`HelpLookup["paclet:ref/NotebookInformation"], 
          "SystemOptions" :> 
          Documentation`HelpLookup["paclet:ref/SystemOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AbsoluteOptions\"\>", 
       2->"\<\"SetOptions\"\>", 3->"\<\"CurrentValue\"\>", 
       4->"\<\"SystemInformation\"\>", 5->"\<\"NotebookInformation\"\>", 
       6->"\<\"SystemOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"], 
          "Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Low-Level System Optimization" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelSystemOptimization"],
           "Low-Level System Spelunking" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelSystemSpelunking"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Options Management" :> 
          Documentation`HelpLookup["paclet:guide/OptionsManagement"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Global Computation Settings & Parameters\"\>", 
       2->"\<\"Low-Level Notebook Programming\"\>", 
       3->"\<\"Low-Level System Optimization\"\>", 
       4->"\<\"Low-Level System Spelunking\"\>", 
       5->"\<\"Mathematica Session Information\"\>", 
       6->"\<\"Options Management\"\>", 7->"\<\"Package Development\"\>", 
       8->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       9->"\<\"Symbol Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Options", "ObjectName",
 CellID->2634],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Options",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Options"], "[", 
       StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of default options assigned to a symbol. \
"
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Options",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Options"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the options explicitly specified in a particular \
expression such as a graphics object. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Options",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Options"], "[", 
       StyleBox["stream", "TI"], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Options",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Options"], "[", "\"\<\!\(\*
StyleBox[\"sname\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     "gives options associated with a particular stream. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Options",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Options"], "[", 
       StyleBox["object", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives options associated with an external object such \
as a ",
     Cell[BoxData[
      ButtonBox["NotebookObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Options",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Options"], "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the setting for the option ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Options",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Options"], "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["name", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["name", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the settings for the options ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["name", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->24272]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Many built\[Hyphen]in functions allow you to give additional arguments that \
specify options with rules of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], "->", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20055],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " gives the list of rules to be used for the options associated with a \
function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " if no explicit rules are given when the function is called. "
}], "Notes",
 CellID->20328],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 " always returns a list of transformation rules for option names. "
}], "Notes",
 CellID->22646],

Cell[TextData[{
 "You can assign a value to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
 " to redefine all the default option settings for a function. "
}], "Notes",
 CellID->26362],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"], "[", 
   RowBox[{
    StyleBox["symbol", "TI"], ",", 
    RowBox[{
     StyleBox["name", "TI"], "->", 
     StyleBox["value", "TI"]}]}], "]"}]], "InlineFormula"],
 " can be used to specify individual default options. "
}], "Notes",
 CellID->4886],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 " on ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " objects. If there is only one stream with a particular name, you can give \
the name as a string as the argument of ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18875],

Cell[TextData[{
 "If you ask for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["NotebookObject",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookObject"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
    StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
 " the kernel will send a request to the front end to find the result. "
}], "Notes",
 CellID->28433],

Cell["\<\
Explicit values are found for options associated with cells even if these \
options are only set at the style, notebook or global level. \
\>", "Notes",
 CellID->29869]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->107168755],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->261334184],

Cell[TextData[{
 "Get the list of options for the ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->724091063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "LinearSolve", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->581885138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Method", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "0"}], ",", 
   RowBox[{"ZeroTest", "\[Rule]", "Automatic"}]}], "}"}]], "Output",
 ImageSize->{369, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170154094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35111341],

Cell[TextData[{
 "Define the default options of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->313342089],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "1"}], ",", 
     RowBox[{"b", "\[Rule]", "2"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->878452687],

Cell[TextData[{
 "Define ",
 Cell[BoxData["f"], "InlineFormula"],
 " to use the options:"
}], "ExampleText",
 CellID->93281254],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"OptionsPattern", "[", "]"}], "]"}], ":=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"OptionValue", "[", "a", "]"}], ",", 
    RowBox[{"OptionValue", "[", "b", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43026318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", "\[Rule]", "17"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", "\[Rule]", "18"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "17"}], ",", 
     RowBox[{"b", "\[Rule]", "18"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->36198902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "18"}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->189930856]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10322],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18651]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20142],

Cell[TextData[ButtonBox["Manipulating Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingOptions"]], "Tutorials",
 CellID->23844]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->395406328],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->85294636],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->657741558],

Cell[TextData[ButtonBox["Low-Level System Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemOptimization"]], "MoreAbout",
 CellID->482141966],

Cell[TextData[ButtonBox["Low-Level System Spelunking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemSpelunking"]], "MoreAbout",
 CellID->244919379],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->75965626],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "MoreAbout",
 CellID->205743094],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->91354692],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->8075648],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->66145312]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Options - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 10.0962428}", "context" -> "System`", 
    "keywords" -> {
     "default options", "finding options for output", 
      "finding options for streams", "function options", "options for symbol",
       "option values", "pattern language", "named arguments", 
      "name value pairs"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Options[symbol] gives the list of default options assigned to a symbol. \
Options[expr] gives the options explicitly specified in a particular \
expression such as a graphics object. Options[stream] or Options[\"sname\"] \
gives options associated with a particular stream. Options[object] gives \
options associated with an external object such as a NotebookObject. \
Options[obj, name] gives the setting for the option name. Options[obj, \
{name_1, name_2, ...}] gives a list of the settings for the options name_i. ",
     "synonyms" -> {}, "title" -> "Options", "type" -> "Symbol", "uri" -> 
    "ref/Options"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11168, 347, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->107168755]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20324, 667}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3877, 84, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4500, 111, 44, 1, 70, "ObjectName",
 CellID->2634],
Cell[4547, 114, 3055, 96, 70, "Usage",
 CellID->24272]
}, Open  ]],
Cell[CellGroupData[{
Cell[7639, 215, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8117, 232, 281, 9, 70, "Notes",
 CellID->20055],
Cell[8401, 243, 420, 13, 70, "Notes",
 CellID->20328],
Cell[8824, 258, 230, 7, 70, "Notes",
 CellID->22646],
Cell[9057, 267, 313, 10, 70, "Notes",
 CellID->26362],
Cell[9373, 279, 380, 13, 70, "Notes",
 CellID->4886],
Cell[9756, 294, 694, 24, 70, "Notes",
 CellID->18875],
Cell[10453, 320, 497, 16, 70, "Notes",
 CellID->28433],
Cell[10953, 338, 178, 4, 70, "Notes",
 CellID->29869]
}, Closed]],
Cell[CellGroupData[{
Cell[11168, 347, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->107168755],
Cell[CellGroupData[{
Cell[11553, 361, 148, 5, 70, "ExampleSection",
 CellID->261334184],
Cell[11704, 368, 230, 8, 70, "ExampleText",
 CellID->724091063],
Cell[CellGroupData[{
Cell[11959, 380, 113, 3, 28, "Input",
 CellID->581885138],
Cell[12075, 385, 338, 10, 36, "Output",
 CellID->170154094]
}, Open  ]],
Cell[12428, 398, 124, 3, 70, "ExampleDelimiter",
 CellID->35111341],
Cell[12555, 403, 151, 6, 70, "ExampleText",
 CellID->313342089],
Cell[12709, 411, 258, 9, 70, "Input",
 CellID->878452687],
Cell[12970, 422, 127, 5, 70, "ExampleText",
 CellID->93281254],
Cell[13100, 429, 289, 9, 70, "Input",
 CellID->43026318],
Cell[CellGroupData[{
Cell[13414, 442, 439, 14, 70, "Input",
 CellID->36198902],
Cell[13856, 458, 463, 16, 36, "Output",
 CellID->189930856]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14380, 481, 311, 9, 70, "SeeAlsoSection",
 CellID->10322],
Cell[14694, 492, 1507, 53, 70, "SeeAlso",
 CellID->18651]
}, Open  ]],
Cell[CellGroupData[{
Cell[16238, 550, 314, 9, 70, "TutorialsSection",
 CellID->20142],
Cell[16555, 561, 150, 3, 70, "Tutorials",
 CellID->23844]
}, Open  ]],
Cell[CellGroupData[{
Cell[16742, 569, 319, 9, 70, "MoreAboutSection",
 CellID->395406328],
Cell[17064, 580, 192, 4, 70, "MoreAbout",
 CellID->85294636],
Cell[17259, 586, 169, 3, 70, "MoreAbout",
 CellID->657741558],
Cell[17431, 591, 167, 3, 70, "MoreAbout",
 CellID->482141966],
Cell[17601, 596, 163, 3, 70, "MoreAbout",
 CellID->244919379],
Cell[17767, 601, 171, 3, 70, "MoreAbout",
 CellID->75965626],
Cell[17941, 606, 147, 3, 70, "MoreAbout",
 CellID->205743094],
Cell[18091, 611, 148, 3, 70, "MoreAbout",
 CellID->91354692],
Cell[18242, 616, 207, 5, 70, "MoreAbout",
 CellID->8075648],
Cell[18452, 623, 140, 3, 70, "MoreAbout",
 CellID->66145312]
}, Open  ]],
Cell[18607, 629, 50, 0, 70, "History"],
Cell[18660, 631, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

