(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25613,        933]
NotebookOptionsPosition[     20335,        754]
NotebookOutlinePosition[     21867,        793]
CellTagsIndexPosition[     21782,        788]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"], 
          "Setting Up Functions with Optional Arguments" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpFunctionsWithOptionalArguments"], 
          "Manipulating Options" :> 
          Documentation`HelpLookup["paclet:tutorial/ManipulatingOptions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns and Transformation Rules\"\>", 
       2->"\<\"Setting Up Functions with Optional Arguments\"\>", 
       3->"\<\"Manipulating Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OptionValue" :> 
          Documentation`HelpLookup["paclet:ref/OptionValue"], "BlankSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankSequence"], "Repeated" :> 
          Documentation`HelpLookup["paclet:ref/Repeated"], "FilterRules" :> 
          Documentation`HelpLookup["paclet:ref/FilterRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OptionValue\"\>", 
       2->"\<\"BlankSequence\"\>", 3->"\<\"Repeated\"\>", 
       4->"\<\"FilterRules\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options Management" :> 
          Documentation`HelpLookup["paclet:guide/OptionsManagement"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Options Management\"\>", 
       2->"\<\"Package Development\"\>", 3->"\<\"Patterns\"\>", 
       4->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["OptionsPattern", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OptionsPattern",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OptionsPattern"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]is a pattern object that represents a collection of \
options given as rules, where the values of the options can be accessed using \
",
     Cell[BoxData[
      ButtonBox["OptionValue",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/OptionValue"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OptionsPattern",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OptionsPattern"], "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]takes default option values from ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Options",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Options"], "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OptionsPattern",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OptionsPattern"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["2", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses an explicit list of default option values."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->11173]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OptionsPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OptionsPattern"]], "InlineFormula"],
 " matches any sequence or nested list of rules, specified with ",
 Cell[BoxData["->"], "InlineFormula"],
 " or ",
 Cell[BoxData[":>"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10466],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionsPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionsPattern"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be either heads ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " or explicit rules ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["opt", "TI"], 
    StyleBox["i", "TI"]], "->", 
   SubscriptBox[
    StyleBox["val", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 ". Each head is treated as the list of rules obtained from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   SubscriptBox[
    StyleBox["f", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12044],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionsPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionsPattern"], "[", "]"}]], "InlineFormula"],
 " uses the default options of the nearest enclosing function. "
}], "Notes",
 CellID->21659],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionsPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionsPattern"], "[", 
   RowBox[{"{", "}"}], "]"}]], "InlineFormula"],
 " includes no default options."
}], "Notes",
 CellID->26292]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->87404977],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->65225873],

Cell[TextData[{
 "Define default option values for the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->28022],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "->", "a0"}], ",", 
     RowBox[{"b", "->", "b0"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2168],

Cell[TextData[{
 "Define ",
 Cell[BoxData["f"], "InlineFormula"],
 ", allowing options to be given:"
}], "ExampleText",
 CellID->14018],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"OptionValue", "[", "a", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18787],

Cell[TextData[{
 "Use ",
 Cell[BoxData["f"], "InlineFormula"],
 " with an explicit option setting:"
}], "ExampleText",
 CellID->9905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"7", ",", 
   RowBox[{"a", "->", "uuu"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "uuu"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7391]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["f"], "InlineFormula"],
 " with options taken to have their default values:"
}], "ExampleText",
 CellID->10202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "7", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3625],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "a0"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->26477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4414],

Cell[TextData[{
 "Define default option values for this assignment without explicitly setting \
up ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", "f", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9314],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", 
    RowBox[{"OptionsPattern", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "->", "a0"}], ",", 
       RowBox[{"b", "->", "b0"}]}], "}"}], "]"}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"OptionValue", "[", "a", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "7", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "a0"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25874]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24372],

Cell[TextData[{
 "Take default option values from ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20159],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", 
    RowBox[{"OptionsPattern", "[", "Plot", "]"}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"OptionValue", "[", "AspectRatio", "]"}], ",", 
    RowBox[{"OptionValue", "[", "ImageSize", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11833],

Cell[TextData[{
 "Use the defaults from ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->28070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "7", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "GoldenRatio"], ",", "Automatic"}], "}"}]], "Output",
 ImageSize->{174, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28297]
}, Open  ]],

Cell[TextData[{
 "Override one of the defaults from ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"7", ",", 
   RowBox[{"ImageSize", "->", "20"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8177],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "GoldenRatio"], ",", "20"}], "}"}]], "Output",
 ImageSize->{125, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17773]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"7", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "->", "x"}], ",", 
      RowBox[{"b", "->", "y"}]}], "}"}]}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"_", ",", 
     RowBox[{"OptionsPattern", "[", 
      RowBox[{"{", "}"}], "]"}]}], "]"}], ":>", 
   RowBox[{"OptionValue", "[", "a", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2668],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17192]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "->", "x"}], ",", 
    RowBox[{"b", "->", "y"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"OptionsPattern", "[", "]"}], ":>", 
   RowBox[{"OptionValue", "[", "a", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7627],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4802]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "->", "x"}], ",", 
    RowBox[{"b", "->", "y"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4099],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30527]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29510],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Repeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Repeated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FilterRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FilterRules"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4745]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26439],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785],

Cell[TextData[ButtonBox["Setting Up Functions with Optional Arguments",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SettingUpFunctionsWithOptionalArguments"]], "Tutorials",
 CellID->208660540],

Cell[TextData[ButtonBox["Manipulating Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingOptions"]], "Tutorials",
 CellID->2793]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->126943513],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "MoreAbout",
 CellID->541293631],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->665959792],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->160876106],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->70324913]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OptionsPattern - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 11.9712908}", "context" -> "System`", 
    "keywords" -> {"defining function", "function with options"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "OptionsPattern[] is a pattern object that represents a collection of \
options given as rules, where the values of the options can be accessed using \
OptionValue. OptionsPattern[f] takes default option values from Options[f]. \
OptionsPattern[{opt_1 -> val_1, opt_2 -> val_2, ...}] uses an explicit list \
of default option values.", "synonyms" -> {"options pattern"}, "title" -> 
    "OptionsPattern", "type" -> "Symbol", "uri" -> "ref/OptionsPattern"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9760, 300, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->87404977]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21640, 781}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2907, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3530, 91, 1579, 37, 70, "ObjectNameGrid"],
Cell[5112, 130, 2035, 63, 70, "Usage",
 CellID->11173]
}, Open  ]],
Cell[CellGroupData[{
Cell[7184, 198, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7662, 215, 335, 11, 70, "Notes",
 CellID->10466],
Cell[8000, 228, 1193, 46, 70, "Notes",
 CellID->12044],
Cell[9196, 276, 266, 8, 70, "Notes",
 CellID->21659],
Cell[9465, 286, 258, 9, 70, "Notes",
 CellID->26292]
}, Closed]],
Cell[CellGroupData[{
Cell[9760, 300, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->87404977],
Cell[CellGroupData[{
Cell[10144, 314, 147, 5, 70, "ExampleSection",
 CellID->65225873],
Cell[10294, 321, 144, 5, 70, "ExampleText",
 CellID->28022],
Cell[10441, 328, 245, 9, 70, "Input",
 CellID->2168],
Cell[10689, 339, 135, 5, 70, "ExampleText",
 CellID->14018],
Cell[10827, 346, 267, 9, 70, "Input",
 CellID->18787],
Cell[11097, 357, 133, 5, 70, "ExampleText",
 CellID->9905],
Cell[CellGroupData[{
Cell[11255, 366, 143, 5, 70, "Input",
 CellID->17958],
Cell[11401, 373, 200, 7, 36, "Output",
 CellID->7391]
}, Open  ]],
Cell[11616, 383, 150, 5, 70, "ExampleText",
 CellID->10202],
Cell[CellGroupData[{
Cell[11791, 392, 92, 3, 70, "Input",
 CellID->3625],
Cell[11886, 397, 200, 7, 36, "Output",
 CellID->26477]
}, Open  ]],
Cell[12101, 407, 120, 3, 70, "ExampleDelimiter",
 CellID->4414],
Cell[12224, 412, 288, 10, 70, "ExampleText",
 CellID->9314],
Cell[12515, 424, 385, 13, 70, "Input",
 CellID->25824],
Cell[CellGroupData[{
Cell[12925, 441, 93, 3, 70, "Input",
 CellID->29334],
Cell[13021, 446, 200, 7, 36, "Output",
 CellID->25874]
}, Open  ]],
Cell[13236, 456, 121, 3, 70, "ExampleDelimiter",
 CellID->24372],
Cell[13360, 461, 203, 8, 70, "ExampleText",
 CellID->20159],
Cell[13566, 471, 333, 10, 70, "Input",
 CellID->11833],
Cell[13902, 483, 193, 8, 70, "ExampleText",
 CellID->28070],
Cell[CellGroupData[{
Cell[14120, 495, 92, 3, 70, "Input",
 CellID->7487],
Cell[14215, 500, 240, 8, 51, "Output",
 CellID->28297]
}, Open  ]],
Cell[14470, 511, 204, 8, 70, "ExampleText",
 CellID->7518],
Cell[CellGroupData[{
Cell[14699, 523, 149, 5, 70, "Input",
 CellID->8177],
Cell[14851, 530, 233, 8, 51, "Output",
 CellID->17773]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15133, 544, 215, 7, 70, "ExampleSection",
 CellID->1763],
Cell[CellGroupData[{
Cell[15373, 555, 430, 15, 70, "Input",
 CellID->2668],
Cell[15806, 572, 154, 5, 36, "Output",
 CellID->17192]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16009, 583, 233, 7, 70, "ExampleSection",
 CellID->29213],
Cell[CellGroupData[{
Cell[16267, 594, 287, 10, 70, "Input",
 CellID->7627],
Cell[16557, 606, 153, 5, 36, "Output",
 CellID->4802]
}, Open  ]],
Cell[CellGroupData[{
Cell[16747, 616, 187, 7, 70, "Input",
 CellID->4099],
Cell[16937, 625, 154, 5, 36, "Output",
 CellID->30527]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17152, 637, 311, 9, 70, "SeeAlsoSection",
 CellID->29510],
Cell[17466, 648, 962, 35, 70, "SeeAlso",
 CellID->4745]
}, Open  ]],
Cell[CellGroupData[{
Cell[18465, 688, 314, 9, 70, "TutorialsSection",
 CellID->26439],
Cell[18782, 699, 178, 3, 70, "Tutorials",
 CellID->244552785],
Cell[18963, 704, 201, 4, 70, "Tutorials",
 CellID->208660540],
Cell[19167, 710, 149, 3, 70, "Tutorials",
 CellID->2793]
}, Open  ]],
Cell[CellGroupData[{
Cell[19353, 718, 319, 9, 70, "MoreAboutSection",
 CellID->126943513],
Cell[19675, 729, 147, 3, 70, "MoreAbout",
 CellID->541293631],
Cell[19825, 734, 149, 3, 70, "MoreAbout",
 CellID->665959792],
Cell[19977, 739, 128, 3, 70, "MoreAbout",
 CellID->160876106],
Cell[20108, 744, 155, 3, 70, "MoreAbout",
 CellID->70324913]
}, Open  ]],
Cell[20278, 750, 27, 0, 70, "History"],
Cell[20308, 752, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

