(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14513,        548]
NotebookOptionsPosition[     11165,        432]
NotebookOutlinePosition[     12562,        471]
CellTagsIndexPosition[     12477,        466]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Structural Operations\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OrderedQ" :> Documentation`HelpLookup["paclet:ref/OrderedQ"], 
          "Equal" :> Documentation`HelpLookup["paclet:ref/Equal"], "SameQ" :> 
          Documentation`HelpLookup["paclet:ref/SameQ"], "Sort" :> 
          Documentation`HelpLookup["paclet:ref/Sort"], "Signature" :> 
          Documentation`HelpLookup["paclet:ref/Signature"], "Ordering" :> 
          Documentation`HelpLookup["paclet:ref/Ordering"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OrderedQ\"\>", 2->"\<\"Equal\"\>", 
       3->"\<\"SameQ\"\>", 4->"\<\"Sort\"\>", 5->"\<\"Signature\"\>", 
       6->"\<\"Ordering\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Order", "ObjectName",
 CellID->21945],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Order",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Order"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData["1"], "InlineFormula"],
     " if ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " is before ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " in canonical order, and ",
     Cell[BoxData[
      RowBox[{"-", "1"}]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " is after ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " in canonical order. It gives ",
     Cell[BoxData["0"], "InlineFormula"],
     " if ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " is identical to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9781]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Order",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Order"]], "InlineFormula"],
 " uses canonical order as described in the notes for ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26504]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44632109],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->69927059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Order", "[", 
    RowBox[{"a", ",", "a"}], "]"}], ",", 
   RowBox[{"Order", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"Order", "[", 
    RowBox[{"b", ",", "a"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31461],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6234]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1515],

Cell["Find which tuples are in order:", "ExampleText",
 CellID->25269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24937],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28869]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Order", "@@@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "1", ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{194, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14700]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26264],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Order",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Order"]], "InlineFormula"],
 " operates structurally, not by numerical value:"
}], "ExampleText",
 CellID->15117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Order", "[", 
  RowBox[{"6", ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16215],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24555]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Order", "[", 
  RowBox[{"6", ",", 
   RowBox[{"N", "[", "Pi", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7815],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18330]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5589],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderedQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OrderedQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Equal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Equal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SameQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SameQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Signature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Signature"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12722]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12392],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->32685]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Order - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 19.7371146}", "context" -> "System`", 
    "keywords" -> {
     "character ordering", "compare expressions", "compare strings", 
      "ordering", "string ordering"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Order[expr_1, expr_2] gives 1 if expr_1 is before expr_2 in canonical \
order, and -1 if expr_1 is after expr_2 in canonical order. It gives 0 if \
expr_1 is identical to expr_2. ", "synonyms" -> {}, "title" -> "Order", 
    "type" -> "Symbol", "uri" -> "ref/Order"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4843, 164, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->44632109]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12335, 459}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1630, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2253, 64, 43, 1, 70, "ObjectName",
 CellID->21945],
Cell[2299, 67, 1661, 58, 70, "Usage",
 CellID->9781]
}, Open  ]],
Cell[CellGroupData[{
Cell[3997, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4475, 147, 331, 12, 70, "Notes",
 CellID->26504]
}, Closed]],
Cell[CellGroupData[{
Cell[4843, 164, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44632109],
Cell[CellGroupData[{
Cell[5227, 178, 147, 5, 70, "ExampleSection",
 CellID->69927059],
Cell[CellGroupData[{
Cell[5399, 187, 295, 10, 28, "Input",
 CellID->31461],
Cell[5697, 199, 227, 8, 36, "Output",
 CellID->6234]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5973, 213, 222, 7, 70, "ExampleSection",
 CellID->1515],
Cell[6198, 222, 70, 1, 70, "ExampleText",
 CellID->25269],
Cell[CellGroupData[{
Cell[6293, 227, 180, 6, 70, "Input",
 CellID->24937],
Cell[6476, 235, 711, 25, 36, "Output",
 CellID->28869]
}, Open  ]],
Cell[CellGroupData[{
Cell[7224, 265, 91, 3, 70, "Input",
 CellID->58],
Cell[7318, 270, 327, 10, 36, "Output",
 CellID->14700]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7694, 286, 226, 7, 70, "ExampleSection",
 CellID->26264],
Cell[7923, 295, 214, 7, 70, "ExampleText",
 CellID->15117],
Cell[CellGroupData[{
Cell[8162, 306, 121, 4, 70, "Input",
 CellID->16215],
Cell[8286, 312, 154, 5, 36, "Output",
 CellID->24555]
}, Open  ]],
Cell[CellGroupData[{
Cell[8477, 322, 149, 5, 70, "Input",
 CellID->7815],
Cell[8629, 329, 171, 6, 36, "Output",
 CellID->18330]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8861, 342, 310, 9, 70, "SeeAlsoSection",
 CellID->5589],
Cell[9174, 353, 1413, 53, 70, "SeeAlso",
 CellID->12722]
}, Open  ]],
Cell[CellGroupData[{
Cell[10624, 411, 314, 9, 70, "TutorialsSection",
 CellID->12392],
Cell[10941, 422, 152, 3, 70, "Tutorials",
 CellID->32685]
}, Open  ]],
Cell[11108, 428, 27, 0, 70, "History"],
Cell[11138, 430, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

