(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15946,        563]
NotebookOptionsPosition[     12325,        442]
NotebookOutlinePosition[     13773,        482]
CellTagsIndexPosition[     13688,        477]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using Previous Results" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingPreviousResults"], 
          "Using a Text\[Hyphen]Based Interface" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UsingATextBasedInterface"], 
          "Doing Computations in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DoingComputationsInNotebooks"], "The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Using Previous Results\"\>",
        2->"\<\"Using a Text\[Hyphen]Based Interface\"\>", 
       3->"\<\"Doing Computations in Notebooks\"\>", 
       4->"\<\"The Main Loop\"\>", 
       5->"\<\"Mathematica Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"In" :> Documentation`HelpLookup["paclet:ref/In"], "$Line" :> 
          Documentation`HelpLookup["paclet:ref/$Line"], "$HistoryLength" :> 
          Documentation`HelpLookup["paclet:ref/$HistoryLength"], 
          "MessageList" :> 
          Documentation`HelpLookup["paclet:ref/MessageList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"In\"\>", 2->"\<\"$Line\"\>", 
       3->"\<\"$HistoryLength\"\>", 
       4->"\<\"MessageList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Session History" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessionHistory"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematica Session History\"\>", 
       2->"\<\"Mathematica Sessions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Out ",
 StyleBox["(%)", "OperatorCharacter"]
}], "ObjectName",
 CellID->9166],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"%", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Out",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Out"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a global object that is assigned to be the value \
produced on the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineMath"],
     " output line. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData["%"], "InlineFormula"],
     "\[LineSeparator]gives the last result generated. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData["%%"], "InlineFormula"],
     "\[LineSeparator]gives the result before last. ",
     Cell[BoxData[
      RowBox[{"%%", 
       StyleBox["\[Ellipsis]", "TR"], "%"}]], "InlineFormula"],
     " (",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " times) gives the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineMath"],
     " previous result. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->16893]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData["%"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16074],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   RowBox[{"-", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"%%", 
   StyleBox["\[Ellipsis]", "TR"], "%"}]], "InlineFormula"],
 " (",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " times). "
}], "Notes",
 CellID->13509]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23729613],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->51562927],

Cell["Given a sequence of inputs:", "ExampleText",
 CellID->53198867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "^", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184575481],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  RowBox[{"2", " ", "x", " ", "y"}], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10851511]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", "100"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->380077062],

Cell[BoxData["3.\
141592653589793238462643383279502884197169399375105820974944592307816406286208\
9986280348253421170679821480865090363`100."], "Output",
 ImageSize->{585, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1041668]
}, Open  ]],

Cell["Recall the outputs:", "ExampleText",
 CellID->301613478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Out", "[", "1", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6143485],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  RowBox[{"2", " ", "x", " ", "y"}], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->303625743]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Out", "[", "2", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->635590916],

Cell[BoxData["3.\
141592653589793238462643383279502884197169399375105820974944592307816406286208\
9986280348253421170679821480865090363`100."], "Output",
 ImageSize->{585, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->408025295]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27358],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Line",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Line"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$HistoryLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$HistoryLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26031]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30300],

Cell[TextData[ButtonBox["Using Previous Results",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingPreviousResults"]], "Tutorials",
 CellID->19695],

Cell[TextData[ButtonBox["Using a Text\[Hyphen]Based Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingATextBasedInterface"]], "Tutorials",
 CellID->9573],

Cell[TextData[ButtonBox["Doing Computations in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DoingComputationsInNotebooks"]], "Tutorials",
 CellID->15589],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->13161],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->708668672],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessionHistory"],
  FontSlant->"Italic"],
 ButtonBox[" Session History",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessionHistory"]
}], "MoreAbout",
 CellID->564638514],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"]
}], "MoreAbout",
 CellID->5940043]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Out (%) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 30.1592564}", "context" -> "System`", 
    "keywords" -> {
     "out", "output lines", "percent sign", "previous output", 
      "previous result"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "% n or Out[n] is a global object that is assigned to be the value \
produced on the n\\[Null]^th output line. % gives the last result generated. \
%% gives the result before last. %% ... % (k times) gives the k\\[Null]^th \
previous result. ", "synonyms" -> {"%", "%%"}, "title" -> "Out", "type" -> 
    "Symbol", "uri" -> "ref/Out"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6308, 201, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->23729613]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13546, 470}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2888, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3511, 92, 95, 4, 70, "ObjectName",
 CellID->9166],
Cell[3609, 98, 1482, 47, 70, "Usage",
 CellID->16893]
}, Open  ]],
Cell[CellGroupData[{
Cell[5128, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5606, 167, 246, 10, 70, "Notes",
 CellID->16074],
Cell[5855, 179, 416, 17, 70, "Notes",
 CellID->13509]
}, Closed]],
Cell[CellGroupData[{
Cell[6308, 201, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23729613],
Cell[CellGroupData[{
Cell[6692, 215, 147, 5, 70, "ExampleSection",
 CellID->51562927],
Cell[6842, 222, 69, 1, 70, "ExampleText",
 CellID->53198867],
Cell[CellGroupData[{
Cell[6936, 227, 174, 6, 28, "Input",
 CellID->184575481],
Cell[7113, 235, 270, 9, 36, "Output",
 CellID->10851511]
}, Open  ]],
Cell[CellGroupData[{
Cell[7420, 249, 123, 4, 28, "Input",
 CellID->380077062],
Cell[7546, 255, 282, 7, 54, "Output",
 CellID->1041668]
}, Open  ]],
Cell[7843, 265, 62, 1, 70, "ExampleText",
 CellID->301613478],
Cell[CellGroupData[{
Cell[7930, 270, 97, 3, 70, "Input",
 CellID->6143485],
Cell[8030, 275, 271, 9, 36, "Output",
 CellID->303625743]
}, Open  ]],
Cell[CellGroupData[{
Cell[8338, 289, 99, 3, 70, "Input",
 CellID->635590916],
Cell[8440, 294, 284, 7, 54, "Output",
 CellID->408025295]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8785, 308, 311, 9, 70, "SeeAlsoSection",
 CellID->27358],
Cell[9099, 319, 941, 35, 70, "SeeAlso",
 CellID->26031]
}, Open  ]],
Cell[CellGroupData[{
Cell[10077, 359, 314, 9, 70, "TutorialsSection",
 CellID->30300],
Cell[10394, 370, 153, 3, 70, "Tutorials",
 CellID->19695],
Cell[10550, 375, 170, 3, 70, "Tutorials",
 CellID->9573],
Cell[10723, 380, 170, 3, 70, "Tutorials",
 CellID->15589],
Cell[10896, 385, 135, 3, 70, "Tutorials",
 CellID->13161],
Cell[11034, 390, 284, 9, 70, "Tutorials",
 CellID->522604605]
}, Open  ]],
Cell[CellGroupData[{
Cell[11355, 404, 319, 9, 70, "MoreAboutSection",
 CellID->708668672],
Cell[11677, 415, 297, 9, 70, "MoreAbout",
 CellID->564638514],
Cell[11977, 426, 276, 9, 70, "MoreAbout",
 CellID->5940043]
}, Open  ]],
Cell[12268, 438, 27, 0, 70, "History"],
Cell[12298, 440, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

