(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    301092,       6591]
NotebookOptionsPosition[    288467,       6153]
NotebookOutlinePosition[    290276,       6197]
CellTagsIndexPosition[    290189,       6192]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/StructuralOperations"], 
          "Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/NestedLists"], 
          "Multiplying Vectors and Matrices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MultiplyingVectorsAndMatrices"], "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Structural Operations\"\>", 
       2->"\<\"Nested Lists\"\>", 
       3->"\<\"Multiplying Vectors and Matrices\"\>", 
       4->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tuples" :> Documentation`HelpLookup["paclet:ref/Tuples"], 
          "Inner" :> Documentation`HelpLookup["paclet:ref/Inner"], 
          "Distribute" :> Documentation`HelpLookup["paclet:ref/Distribute"], 
          "KroneckerProduct" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerProduct"], "Cross" :> 
          Documentation`HelpLookup["paclet:ref/Cross"], "Dot" :> 
          Documentation`HelpLookup["paclet:ref/Dot"], "Norm" :> 
          Documentation`HelpLookup["paclet:ref/Norm"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Tuples\"\>", 2->"\<\"Inner\"\>", 
       3->"\<\"Distribute\"\>", 4->"\<\"KroneckerProduct\"\>", 
       5->"\<\"Cross\"\>", 6->"\<\"Dot\"\>", 
       7->"\<\"Norm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup["paclet:guide/ApplyingFunctionsToLists"], 
          "Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"], "Tensors" :> 
          Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Applying Functions to Lists\"\>", 
       2->"\<\"Constructing Lists\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Structural Operations on Expressions\"\>", 
       5->"\<\"Tensors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Outer", "ObjectName",
 CellID->29458],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Outer",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Outer"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized outer product of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", forming all possible combinations of the lowest\[Hyphen]level \
elements in each of them, and feeding them as arguments to ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Outer",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Outer"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]treats as separate elements only sublists at level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Outer",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Outer"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " ",
     "\[LineSeparator]",
     "treats as separate elements only sublists at level ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in the corresponding ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6602]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Outer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Outer"], "[", 
   RowBox[{
    ButtonBox["Times",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Times"], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " gives an outer product. "
}], "Notes",
 CellID->30807],

Cell[TextData[{
 "The result of applying ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " to the tensors ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["T", "TI"], 
   RowBox[{
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["1", "TR"]], 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["2", "TR"]], "...", 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["r", "TI"]]}]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["U", "TI"], 
   RowBox[{
    SubscriptBox[
     StyleBox["j", "TI"], 
     StyleBox["1", "TR"]], 
    SubscriptBox[
     StyleBox["j", "TI"], 
     StyleBox["2", "TR"]], "...", 
    SubscriptBox[
     StyleBox["j", "TI"], 
     StyleBox["s", "TI"]]}]]], "InlineFormula"],
 " is the tensor ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["V", "TI"], 
   RowBox[{
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["1", "TR"]], 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["2", "TR"]], "...", 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["r", "TI"]], 
    SubscriptBox[
     StyleBox["j", "TI"], 
     StyleBox["1", "TR"]], 
    SubscriptBox[
     StyleBox["j", "TI"], 
     StyleBox["2", "TR"]], "...", 
    SubscriptBox[
     StyleBox["j", "TI"], 
     StyleBox["s", "TI"]]}]]], "InlineFormula"],
 " with elements ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["T", "TI"], 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]], 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]], "...", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["r", "TI"]]}]], ",", 
    SubscriptBox[
     StyleBox["U", "TI"], 
     RowBox[{
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]], 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["2", "TR"]], "...", 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["s", "TI"]]}]]}], "]"}]], "InlineFormula"],
 ". Applying ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " to two tensors of ranks ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " gives a tensor of rank ",
 Cell[BoxData[
  RowBox[{
   StyleBox["r", "TI"], "+", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4098],

Cell[TextData[{
 "The heads of all ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " must be the same, but need not necessarily be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21188]
}], "Notes",
 CellID->27830],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " need not necessarily be cuboidal arrays. "
}], "Notes",
 CellID->29292],

Cell[TextData[{
 "The specifications ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " of levels must be positive integers, or ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14600],

Cell[TextData[{
 "If only a single level specification is given, it is assumed to apply to \
all the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". If there are several ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", but fewer than the number of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", the lowest\[Hyphen]level elements in the remaining ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " will be used. "
}], "Notes",
 CellID->7278],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, returning a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object when possible. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->288071693]
}], "Notes",
 CellID->20799]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->142858627],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->53636651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "x"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "y"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "z"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "x"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "y"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "z"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{380, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13851]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26816],

Cell["Outer product of vectors:", "ExampleText",
 CellID->24230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4449],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "a"}], ",", 
     RowBox[{"2", " ", "b"}], ",", 
     RowBox[{"2", " ", "c"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", " ", "a"}], ",", 
     RowBox[{"3", " ", "b"}], ",", 
     RowBox[{"3", " ", "c"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", "a"}], ",", 
     RowBox[{"4", " ", "b"}], ",", 
     RowBox[{"4", " ", "c"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{372, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16925]
}, Open  ]],

Cell["Outer product of matrices:", "ExampleText",
 CellID->658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->229],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWM1uEzEQdvYvDShJoRVt4VKuwAF4CMqlDxFVSO0BUZW+/7KzscPmy9gz
XjshREp2x/b8jyf2d7t6vv/xc/X8cLe6vnlaPd4/3P2+/vbrqRsqJ8ZMbowx
7y9N9952b/2XPt+77/p1/faSfks325pKoM+AvhLWv0jkl+Sl2of+p9qHdNlH
WbIa6fPup+jId4w0Gkd5vvWcNRx/rH6Mmla/RBejokVWETntnnX3LGF+audr
O18L8k4C8kuGfyrol+xHfThfg/0of2bnS6V/s4B8zr+ZoP8wWe656g3dy7C2
7owSb2EzEsOD+kkGRutf2KGxC9c1QJdBC3FH+1dztmAuD6U7vuqkqCE9Vdn2
SrUK99Vcoyvw36TTgh6hVq6bNi7eO9LnwVnUvQjJHowvo6TGZn7Sjuk3WMM0
X6lzzXko7pDoXEs+oFZdT22sp3N/NkRLTlWaMLPLBI2H+RdyPathbVoOZulZ
cDqF/Oikb0nNUAl9fVV/aV/UF+w6ja9YEWkaY/3fTzVwPYLI1wFfjfFW/oju
4yrGXjTMRltCLQxp1w+IPIXxWvQKc85Jrmxl43isV4c8dV6wo+g95hDjHiOb
PYVmzPEV0JIvUmZRXqz9umzGohfEVVrrykHvwpMX7jLkm1k+qSa53crt3rf2
uXVfGKzDfoJ8J0p7dGgFvSJOFP+W2pGxYqSKxp0dy/+/I00f+6inVgB5TZXE
nXK5m55v/bEjT07epyxRc8gLyklFnDikaR8IU2HlNh75brxS+sN1eyef86sR
9Mfm40OWrPL/z2FMJw1Fipet0XUsSBru/WNA0jg715009YTC39gDd+oBL2I0
WMmBe3LAIgn5YW83/H1MXCUhQdJNCs+XOi2SR5/bHH2B+P34iHQSZzGA7MgO
F1+8afWKVdpDp/2NlMC5N8/+/NLmyB7fdSiXYxAbv7StVRkyytb6jmYuU2PQ
mfHaYv3eT5bdCWqIHhnD9QyMu9vdizY/spIPL2L7I0jOhRftJ0PnggcYy0ug
UxGQnMiODu3Og+zw2Ui9bVMFapCQN20e5EOLxODOGIvEIP21jxq9arAMM/kD
VrIEJg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{327, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->91432056]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15147],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtO3DAQ9SabLre90Kc+0teCBF/RPvUjVqgSPCAQ5f/TJGtnnck49tgz
BpVE2otzOXPOeOzEOb/3bw9/nvZvj/f7q1+v+5eHx/u/Vz+fX5td5UKpovmo
799U879u/nUfs5XN59g8tM7b77I/Sy1B+6z5KtT4vC3Sbs+rwP5d4vWQD8Rx
8Vs1X8umCa+n8nTh7Bw4WP5y5HMXmU/YPlQFZB3aC4bdJYKK7fddh7HD1Lv4
QB0uHj5+LpyvgXzh9dz5uwzMn69d1CG9355VmTGxtGeYCqm4SnMr9C9EW+n9
uvRU/3eCwRdWBieJWTtNyo8vunx+fAygPmp+ID4tPwMtWfOyckROrZe4UQe1
QbYdSmVrUpp7m6XVULFW2x+xcRDFBgUq5+Jg4yqkJ1x8sHk5nt9pfbxn5s0M
jGyPOEo+4EhlqJnpo1myc+I/SsyVfzRS57wwRRvNeetUZGNskmLYT4RYXmAb
RotXaEfdCCu1Y1EVr9kV91qEFGOrBIpiXxUvOhyZO1HO2g+Lga3peHQO73Jr
YcXDaGH1h62L07VDFEnlsLfCYr3fs5lZgdj7u3VgRO+FZIwzHsdIcfIZReer
mvCY+UbNR6iDi8h4Gd4nwKs1S6VMZdgr+QvQhgjrJOSyT4HZfOtLOC5oysbx
zln1jfHjVMKqD1e50Wfy9dvWQqQrybgyt9o/QDvo/jdxPctzDCO/aw+/qGeN
jPzCqsLnnLSqSnVcp5pav66P72qnjkMV8F1zLP6NAx9758yJH+Y81HqTa1F7
e3bAPqMDRr1zzI7Y/+GIGdzDYwS1ClxPQqXej93pRL0xBg6i7lgAP3F/jIGD
qEMWwE/MIwuIndclo47I2TUb85ldsyGL2TWLc82KfmKBKyzq2P54DsLsns3u
mW9MdGOI/Y7UHl+yV3scauqbJTuqhCfmxs/zPt/El/G9DLqM09Xd9TI9T3WM
hfwNvmgs71ED3SxJZxTHfk9fOG//c80GPCNmai1XKj5Pawqv7OWajcvJsqOO
o8T6V9Oosq6ViZ3qVRkcXodKZta+BW3fuIPnp86c1Ph3nvjUWYs7Pt5r1PkG
OjC3Ne68mP1Ux8iFd+fA8zlEVDzUKeinaKqvoxb/AOFAtrA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{513, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380129348]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1655],

Cell["Treat nested lists as rank-1 vectors of sublists:", "ExampleText",
 CellID->20675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{522, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22361]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31754],

Cell["Arrays can be ragged:", "ExampleText",
 CellID->16398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23146],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWc1y0zAQVuzY+WntBAhDml7KOwAH4AwnHiLTYaY9MDCld/LmxutKqfp1
pZUUO9B2JrHW2n9tVtLXb9vbq+8/trfXl9uLrzfbX1fXl78vvvy8aV/lI6VG
f5RSb9eqHTftqPvQ36793A3vRif0nZvZRo0F+hXQZwKN8vNIfZI/qE/yd/OP
/UU671ZBigLpVfuVteRGP88ZrfQe9a4c/JxXnLzLj/OB/JDoLCl75BWRk/ZZ
tM8c5id6vtDzhWPe5vPZmybap+e4fcZmBe3hfAHxof25ns8d8c8s+ZT4Jfu2
/pT4+6mSTqrY050OHeujtySb6RUbWgZ9Jh2zYX23NJcBWeQ8Qj7Uk3t9O43i
xj3NzR3ieZynrO3I/Mm1LGUX6UlQDC/SuTy2qv588WjBiNEqtweUpgoeWa+9
s5U9GxG532ao1tiKGXX6Y7sfV6fj3moEtS+E+XArheOX7bMW1vlLnYGaneV7
a+XmjchGTDd3WwzJzDA7qemNJevbwpqlZwbSlVc6ZG330nYkYDlsf4ipoq5m
x/e0a8UWLB+XidNAjZKnDs8gO3WitePUFNefiHzpiVV1f8hhOpuUNc4i5Ulf
4ToDS4dX0glZqiWbNr0ohw647wkPol0ykiHRchYx2trhlRTtMc/rb9i36OGC
5ao5LtEins1OgnQfWhEboDFCrBQpNtSPUVWCvrQ1j0WjSIrIs+a+8jL9G88Z
r/DEYORnWq52yKFd1OPa8QwuYmiDe+DJkNNHfFP9XDrk0tAmGu4OHh3a97Gi
sAKlXwD2B0nfc0cS33ergiftWC3kpV1x3BmbQ/TmDv6ngiwafR96yaK5iaAe
CVFMQRJdCOIQyGGm7ZUeu+aewcVZWvIp8Ur2bf19IIfvmj6qgT8n+HE3eZbb
L8JwwAe6IXshu5qEPqWgj9MEmeeHnHIe3vV1vAsm7fyBaIGE2HG4VryWWMSO
vQHyt2mRC893uDZSxGG+xFqRIv7Y9NGNSH4cvPZp2BRp6QOJ4/JMvuM924Os
IFdEbGg93EoK1vap6WN13evBIUr83VRaJdSyv5n0jqGx5wMRBzadE/1kb3XR
0UtnFnN6jrd0nAox/3228T2lTCWHYEPmrGxjQVXTD9LlwvXwtvQ0cL1hVnAF
9DoyQpSPXSO+x6zZt/8/0sav0aE3B6pGqiK81bt61WtBn3SvNkjWpjkuEob0
5y57NNwFjNToL0gLtvg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{383, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->935730032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->389892422],

Cell[TextData[{
 "Outer product of ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->288071693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"s1", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "^", "i"}], "\[Rule]", "i"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", "1", "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{"{", "4", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->13989861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Times", ",", "s1", ",", "s2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->363854359],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "4"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1331049]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11521],

Cell[TextData[{
 "The head need not be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->21188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"g", ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19569],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"a", ",", "x"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"a", ",", "y"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"a", ",", "z"}], "]"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"b", ",", "x"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"b", ",", "y"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"b", ",", "z"}], "]"}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{401, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8638]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15615],

Cell["Word combinations: ", "ExampleText",
 CellID->147523217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"StringJoin", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<\>\"", ",", "\"\<re\>\"", ",", "\"\<un\>\""}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<cover\>\"", ",", "\"\<draw\>\"", ",", "\"\<wind\>\""}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<\>\"", ",", "\"\<ing\>\"", ",", "\"\<s\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12570],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"cover\"\>", ",", "\<\"covering\"\>", 
       ",", "\<\"covers\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"draw\"\>", ",", "\<\"drawing\"\>", ",", "\<\"draws\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"wind\"\>", ",", "\<\"winding\"\>", ",", "\<\"winds\"\>"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"recover\"\>", ",", "\<\"recovering\"\>", 
       ",", "\<\"recovers\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"redraw\"\>", ",", "\<\"redrawing\"\>", 
       ",", "\<\"redraws\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"rewind\"\>", ",", "\<\"rewinding\"\>", 
       ",", "\<\"rewinds\"\>"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"uncover\"\>", ",", "\<\"uncovering\"\>", 
       ",", "\<\"uncovers\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"undraw\"\>", ",", "\<\"undrawing\"\>", 
       ",", "\<\"undraws\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"unwind\"\>", ",", "\<\"unwinding\"\>", 
       ",", "\<\"unwinds\"\>"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{521, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->905]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->440473710],

Cell["Function combinations: ", "ExampleText",
 CellID->797162593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fm", "=", 
  RowBox[{"Outer", "[", 
   RowBox[{"Composition", ",", 
    RowBox[{"{", 
     RowBox[{"Sin", ",", "Cos", ",", "Exp"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ArcSin", ",", "ArcCos", ",", "Log"}], "}"}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->259130285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Composition", "[", 
      RowBox[{"Sin", ",", "ArcSin"}], "]"}], ",", 
     RowBox[{"Composition", "[", 
      RowBox[{"Sin", ",", "ArcCos"}], "]"}], ",", 
     RowBox[{"Composition", "[", 
      RowBox[{"Sin", ",", "Log"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Composition", "[", 
      RowBox[{"Cos", ",", "ArcSin"}], "]"}], ",", 
     RowBox[{"Composition", "[", 
      RowBox[{"Cos", ",", "ArcCos"}], "]"}], ",", 
     RowBox[{"Composition", "[", 
      RowBox[{"Cos", ",", "Log"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Composition", "[", 
      RowBox[{"Exp", ",", "ArcSin"}], "]"}], ",", 
     RowBox[{"Composition", "[", 
      RowBox[{"Exp", ",", "ArcCos"}], "]"}], ",", 
     RowBox[{"Composition", "[", 
      RowBox[{"Exp", ",", "Log"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{529, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144709200]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "@", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{"f", ",", 
      RowBox[{"Plot3D", "[", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{"f", "[", 
          RowBox[{"x", "+", 
           RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]}], "]"}], ",", "fm", ",",
     
    RowBox[{"{", "2", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7516772],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{481, 481},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->364195860]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14161],

Cell["Complete bipartite graph: ", "ExampleText",
 CellID->158010543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Line", "[", " ", 
      RowBox[{"{", "##", "}"}], "]"}], "&"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "4"}], "}"}]}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "4"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30524],

Cell[BoxData[
 GraphicsBox[{{LineBox[{{1, 1}, {1, 2}}], LineBox[{{1, 1}, {2, 2}}], 
    LineBox[{{1, 1}, {3, 2}}], LineBox[{{1, 1}, {4, 2}}]}, {
    LineBox[{{2, 1}, {1, 2}}], LineBox[{{2, 1}, {2, 2}}], 
    LineBox[{{2, 1}, {3, 2}}], LineBox[{{2, 1}, {4, 2}}]}, {
    LineBox[{{3, 1}, {1, 2}}], LineBox[{{3, 1}, {2, 2}}], 
    LineBox[{{3, 1}, {3, 2}}], LineBox[{{3, 1}, {4, 2}}]}, {
    LineBox[{{4, 1}, {1, 2}}], LineBox[{{4, 1}, {2, 2}}], 
    LineBox[{{4, 1}, {3, 2}}], LineBox[{{4, 1}, {4, 2}}]}},
  ImageMargins->0.]], "Output",
 ImageSize->{364, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{Automatic, Automatic}},
 CellLabel->"Out[1]=",
 CellID->47760599]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17469],

Cell["Lower-triangular matrix:", "ExampleText",
 CellID->330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Boole", "[", 
   RowBox[{"Outer", "[", 
    RowBox[{"Greater", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "]"}], 
   "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31923],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\:f3a2", GridBox[{
     {"0", "0", "0", "0", "0"},
     {"1", "0", "0", "0", "0"},
     {"1", "1", "0", "0", "0"},
     {"1", "1", "1", "0", "0"},
     {"1", "1", "1", "1", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
      "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->28350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14333],

Cell[TextData[{
 "Generate all possible binary trees with nodes from ",
 Cell[BoxData["f"], "InlineFormula"],
 " and leaves from ",
 Cell[BoxData["e"], "InlineFormula"],
 " to depth ",
 Cell[BoxData["n"], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->22925],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trees", "[", 
    RowBox[{"f_", ",", "e_", ",", "1"}], "]"}], "=", "e"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"trees", "[", 
   RowBox[{"f_", ",", "e_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"#", ",", 
         RowBox[{"trees", "[", 
          RowBox[{"f", ",", "e", ",", "r"}], "]"}], ",", 
         RowBox[{"trees", "[", 
          RowBox[{"f", ",", "e", ",", 
           RowBox[{"n", "-", "r"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", 
         RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "&"}], "/@", "f"}], 
   "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->10910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"trees", "[", 
  RowBox[{
   RowBox[{"{", "f", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19737],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmv9u0zAQx92mv9jWNsBg449Jexck+IuHqCak7Q8EGnsGeOwQp3Ebrnbu
zj7bgWbStvhy5/vmenGTj/xl9/L49dvu5elhd//5effj8enh5/2n78+1qZgo
NfmllPp4q+rjqj5qfvXP7/p3f7g/el3/ndYnr9r/l9paGO9KbVv7nGgvhecb
ir7SYS8OVexa4awXbTT0K5h2qXnfDFQv1DUD42lT7VX9d14bbWcP9tnB3lrh
J7ds7QWSk+q3SKpq7oh3qQ9Txc2WplZUVQui3767XlmynNzxPeebWeZd7aq9
It3hS+dZqIzvvfpnlY81l1C+Inun6vo1SRHNazN4hdvBK8xZww3JC2acVPG6
UyuaOZS67OlUDL/n0tZJssvirYF6HZ4C+yVJU7o7OEyjLRqOJbrSpZKSP38t
KSo3RL+AtyAY1T5Tq+ZHf0raAV7XxmFfR8u4PvG0aQrLvSHliHPdtNz9HhGf
2zrjWzB+b9MZMd8ajBdgLPJ91zMfzBf7+rH8MB88b+8KzVkKdXyPmIOxWbk+
tP9vqiOX4cSZFWxZHfkNJb4Ecdz8MH4LxnZKpw8h/+QfDYVIjsSUYj83Ymrs
zbrAfkYoKju/y8JKBXWJ0lKCriy8VFDXSEyHrnysuYRyOjGdmrtpJKUCCkdS
iuZGvZo+DO5GfV6/dqZmoVjeNH1kVOTlnXwVqbrj/77PUtJMu8ZhsUx/jVSS
ue9Kn7cSPYzNK7E88pTSZEzHJnkZ+z1k1pg7MJYmbnD+2ITxGplf+vqwfBhB
3H+KGDG8q3ikzvhzCeE18Kfmg3GQCDZcpblkOQIIWU3psHcJWR8pk5ovt74S
mc9OAF2ky2W3rWyceO68kLTl0ovtkewhgOiOOhdnCuVvvTxLXBWVcvXSP54q
sX2dgpUie3PrRKN+/ZwGo0BSlAeOw3PnVD7W3DvaWzmN+rn3dvm9dfH1+uVK
qRB7ss6vMGUN/Xaq0d65/HRiTC5NtXg0LGeP5a1Tnq6yUZ4rL6Xx7lBZjRSu
5dOFviptcbTdmylr6YrzqSZODU932/nwPRsflsnI393XRxJpuem7L+Wv256b
VwHGN11nXCL+kAZ6rdWMfBid8/r+YuTH9lvGvn7MH6uHnU6aFeZtZaeOhjxB
auiKg/TQxENa6YqH+yK5+acdf5sOSXoJK3zRzQE+qZFmUmkm5DrUfXwj3fzb
zqObsOrc/XBZeGcEXSLEk6srDfMUVxVGPWHusN1q50rkRgqaXrkEBcXe1M6b
6A2fWA2/hiH8irs2d3kn1U+C93Hzxukrqoq47DNcRapuOa/7MCb59NOYlnvK
aQyjnpw3nELFZ5/UPHLEE8sozzn9MvrQTe4a9A45H0o3sfmlaSaWT5pecvP5
0UpXP5ln6ZuKRy2hP5VWwjgqpXTFydBJNfkDxAdxkg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{390, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->668034374]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33932894],

Cell["Apply a function on a tensor product grid:", "ExampleText",
 CellID->214001783],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"{", 
    RowBox[{"0.", ",", ".1", ",", ".25", ",", ".5", ",", "1."}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1."}], ",", 
     RowBox[{"-", ".5"}], ",", "0.", ",", 
     RowBox[{"1", "/", "3."}], ",", 
     RowBox[{"2", "/", "3."}], ",", "1."}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->556697715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fxy", "=", 
  RowBox[{"Outer", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"Pi", " ", 
       RowBox[{"#1", "^", "2"}], "#2"}], "]"}], "&"}], ",", "x", ",", "y"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175643922],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.03141075907812829`"}], ",", 
     RowBox[{"-", "0.015707317311820675`"}], ",", "0.`", ",", 
     "0.010471784116245796`", ",", "0.020942419883356964`", ",", 
     "0.03141075907812829`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.19509032201612825`"}], ",", 
     RowBox[{"-", "0.0980171403295606`"}], ",", "0.`", ",", 
     "0.06540312923014306`", ",", "0.13052619222005157`", ",", 
     "0.19509032201612825`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7071067811865475`"}], ",", 
     RowBox[{"-", "0.3826834323650898`"}], ",", "0.`", ",", 
     "0.25881904510252074`", ",", "0.49999999999999994`", ",", 
     "0.7071067811865475`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2246467991473532`*^-16"}], ",", 
     RowBox[{"-", "1.`"}], ",", "0.`", ",", "0.8660254037844386`", ",", 
     "0.8660254037844387`", ",", "1.2246467991473532`*^-16"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{433, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->361211774]
}, Open  ]],

Cell["Show a contour plot of the values and the grid:", "ExampleText",
 CellID->2575323],

Cell[BoxData[
 RowBox[{
  RowBox[{"grid", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Line", ",", 
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "x", ",", "y"}], "]"}]}], "]"}], ",", 
     RowBox[{"Map", "[", 
      RowBox[{"Line", ",", 
       RowBox[{"Outer", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Reverse", "[", 
           RowBox[{"List", "[", "##", "]"}], "]"}], "&"}], ",", "y", ",", 
         "x"}], "]"}]}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->188609118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListContourPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", "fxy", "]"}], ",", 
     RowBox[{"DataRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "grid"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->576819646],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxl1AlIU3EcB/CXWh55gCsscXnMXBZZaHkQ+pSOgVcqkjntMPOcoNhhHqhQ
aCo5rEBNKzWaWOpKSTGJTcvNPOYO57U8QsOJ5fPK8ppl0u/Png/Gnw//3977
f/+//3uW1+IDIjQwDIv8+9sc1a9Z3tYoxtU9SzKGOfy7xqFe3RhWVLx5fYZ5
dY+RrCR5lmQMK90y/v9+6sawE1vPh3l1Qz6YJ+WCkctiKgxLeiHvwHgMy9Tx
C+RTYUIp24zYtj8puRbDtaoZyKc/59T4vHIM8nmlP4x8YiCF+vp4k4Mjz7qh
XvQ2iJJX0ICf6/6QGFs9RMqnxH91DoVnM/jwf02udWmmWMDjpCm++kllkLdA
1L6glSPZliukrYLf5EPgG5FJ6TlJsH78irNwlBMjgDxbbiDlE+NmCfRkRqCS
lytrfzUXLYD9mJHVWjwOk0G9SYuv+XlfKdi9doaqdwrWw4spyTdro28/X30X
vh9rphPguqdEpcALOX9i3lwaj8w6slQ4/AiZkbhsNNWIbN20lr2oIGD95Uba
BPP9COx3lqN+nOU6HzzFWU8LaHkDJkSM7KTJS7D/C/OGnffjhNBPX+97a0l4
G7jq5fLRKOOP8HxxpyePutAO1lGtTpR7I7sfr9Gz4QhhfdcNpuVSuy5cOF2Y
OiDi4+Tz7MrfHe2WPoGT+kPuH753xyEVbQz111bDb43BR3bVvLPCKkPW8hjN
ahIMQj8pvVWhgS/6wbSom/ZEhhzssOKmkxsqA59+oDti7SIBp+yaXex3R+9H
5M72pfqryAFaZb/Zmchu6uvhkdbLI+WB/uy5fYtZo4v6ac+1K7I/rAD7Kyfl
jZ4D4ATLcoorSw7OZzL9W/OkYCadfoB9sQf11yHDg+IkATtb6dvVpYjBZ63s
T1akoXpTzNtwTFMEJoYjJql5XeBPzRn8EONO6L+Hm3KweqUL3GOlWE6PRb6s
LdrvP4Tqf0zzXWieyKni+uCfTR1gvXecZKFtB6+k1UonnI6+jz43qEGlITLw
Bm0fR87uAwfbGHGz6eh72bgax+a2SsCk9xVGtnecblgfOkfU4gHj1mrk19/O
mNHuEvgfaYY3ww==
    "], {{
      {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
       GraphicsGroupBox[
        PolygonBox[{{65, 37, 18, 19}, {88, 82, 23, 24}, {82, 76, 22, 23}, {70,
          41, 21, 20}, {76, 65, 19, 22}},
         VertexColors->None]]}, 
      {RGBColor[
       0.37837462004524725`, 0.20512449590878326`, 0.6488316181735589], 
       EdgeForm[None], 
       GraphicsGroupBox[
        PolygonBox[{{66, 38, 37, 65}, {83, 77, 76, 82}, {89, 83, 82, 88}, {77,
          66, 65, 76}, {71, 42, 41, 70}},
         VertexColors->None]]}, 
      {RGBColor[0.45781941830129474`, 0.3432575448164413, 0.7605008927987811],
        EdgeForm[None], 
       GraphicsGroupBox[
        PolygonBox[{{67, 39, 38, 66}, {90, 84, 83, 89}, {72, 43, 42, 71}, {84,
          78, 77, 83}, {78, 67, 66, 77}},
         VertexColors->None]]}, 
      {RGBColor[0.5372642165573421, 0.4813905937240992, 0.8721701674240031], 
       EdgeForm[None], 
       GraphicsGroupBox[
        PolygonBox[{{91, 85, 84, 90}, {85, 79, 78, 84}, {73, 44, 43, 72}, {68,
          40, 39, 67}, {79, 68, 67, 78}},
         VertexColors->None]]}, 
      {RGBColor[0.6027058914350736, 0.5900428501709358, 0.9103852001007863], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[{{35, 33, 2}},
          VertexColors->None], 
         PolygonBox[{{80, 69, 68, 79}, {86, 80, 79, 85}, {92, 86, 85, 91}, {
          74, 45, 44, 73}},
          VertexColors->None], PolygonBox[{{69, 35, 2, 40, 68}},
          VertexColors->None]}]}, 
      {RGBColor[0.6611162010352003, 0.683891964856822, 0.9117167752534567], 
       EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[{{35, 69, 5}, {47, 36, 5}},
          VertexColors->None], 
         PolygonBox[{{75, 46, 45, 74}, {93, 87, 86, 92}, {87, 81, 80, 86}},
          VertexColors->None], 
         PolygonBox[{{81, 47, 5, 69, 80}, {36, 34, 33, 35, 5}},
          VertexColors->None]}]}, 
      {RGBColor[0.719526510635327, 0.7777410795427083, 0.9130483504061272], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[{{46, 75, 3}},
          VertexColors->None], 
         PolygonBox[{{81, 87, 9, 8}, {34, 36, 4, 1}, {87, 93, 10, 9}, {47, 81,
           8, 7}},
          VertexColors->None], PolygonBox[{{36, 47, 7, 6, 4}},
          VertexColors->None]}]}, 
      {RGBColor[0.7763766653937942, 0.8515818131426056, 0.9078729542215195], 
       EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[{{94, 57, 12}, {62, 100, 17}},
          VertexColors->None], 
         PolygonBox[{{51, 48, 8, 9}, {54, 51, 9, 10}, {6, 7, 12, 11}, {58, 60,
           15, 13}},
          VertexColors->None], 
         PolygonBox[{{57, 58, 13, 11, 12}, {48, 94, 12, 7, 8}},
          VertexColors->None]}]}, 
      {RGBColor[0.8288330877847677, 0.8690746322591227, 0.8843725239982749], 
       EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[{{97, 59, 14}, {58, 57, 14}},
          VertexColors->None], 
         PolygonBox[{{63, 101, 100, 62}, {49, 95, 94, 48}, {52, 49, 48, 51}, {
          55, 52, 51, 54}},
          VertexColors->None], 
         PolygonBox[{{95, 97, 14, 57, 94}, {59, 61, 60, 58, 14}},
          VertexColors->None]}]}, 
      {RGBColor[0.8812895101757412, 0.88656745137564, 0.8608720937750304], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[{{61, 59, 16}},
          VertexColors->None], 
         PolygonBox[{{56, 53, 52, 55}, {64, 102, 101, 63}, {50, 96, 95, 49}, {
          53, 50, 49, 52}, {96, 98, 97, 95}},
          VertexColors->None], PolygonBox[{{98, 99, 16, 59, 97}},
          VertexColors->None]}]}, 
      {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
       GraphicsGroupBox[
        PolygonBox[{{102, 64, 32, 31}, {98, 96, 26, 29}, {53, 56, 28, 27}, {
         99, 98, 29, 30}, {96, 50, 25, 26}, {50, 53, 27, 25}},
         VertexColors->None]]}}, {{}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{99, 98, 96, 50, 53, 56}],
         "0.033`"],
        Annotation[#, 0.033, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{102, 64}],
         "0.033`"],
        Annotation[#, 0.033, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{61, 59, 97, 95, 49, 52, 55}],
         "0.022`"],
        Annotation[#, 0.022, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{101, 63}],
         "0.022`"],
        Annotation[#, 0.022, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{54, 51, 48, 94, 57, 58, 60}],
         "0.011`"],
        Annotation[#, 0.011, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{62, 100}],
         "0.011`"],
        Annotation[#, 0.011, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{6, 7, 8, 9, 10}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{34, 36, 47, 81, 87, 93}],
         RowBox[{"-", "0.011`"}]],
        Annotation[#, -0.011, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{46, 75}],
         RowBox[{"-", "0.011`"}]],
        Annotation[#, -0.011, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{33, 35, 69, 80, 86, 92}],
         RowBox[{"-", "0.022`"}]],
        Annotation[#, -0.022, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{45, 74}],
         RowBox[{"-", "0.022`"}]],
        Annotation[#, -0.022, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{40, 68, 79, 85, 91}],
         RowBox[{"-", "0.033`"}]],
        Annotation[#, -0.033, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{44, 73}],
         RowBox[{"-", "0.033`"}]],
        Annotation[#, -0.033, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{39, 67, 78, 84, 90}],
         RowBox[{"-", "0.044`"}]],
        Annotation[#, -0.044, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{43, 72}],
         RowBox[{"-", "0.044`"}]],
        Annotation[#, -0.044, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{38, 66, 77, 83, 89}],
         RowBox[{"-", "0.05499999999999999`"}]],
        Annotation[#, -0.05499999999999999, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{42, 71}],
         RowBox[{"-", "0.05499999999999999`"}]],
        Annotation[#, -0.05499999999999999, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{41, 70}],
         RowBox[{"-", "0.066`"}]],
        Annotation[#, -0.066, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{88, 82, 76, 65, 37}],
         RowBox[{"-", "0.066`"}]],
        Annotation[#, -0.066, "Tooltip"]& ]}, {}, {}}}], 
   {RGBColor[
    1, 0, 0], {
     LineBox[{{0., -1.}, {0., -0.5}, {0., 0.}, {0., 0.3333333333333333}, {0., 
      0.6666666666666666}, {0., 1.}}], 
     LineBox[{{0.1, -1.}, {0.1, -0.5}, {0.1, 0.}, {0.1, 0.3333333333333333}, {
      0.1, 0.6666666666666666}, {0.1, 1.}}], 
     LineBox[{{0.25, -1.}, {0.25, -0.5}, {0.25, 0.}, {0.25, 
      0.3333333333333333}, {0.25, 0.6666666666666666}, {0.25, 1.}}], 
     LineBox[{{0.5, -1.}, {0.5, -0.5}, {0.5, 0.}, {0.5, 0.3333333333333333}, {
      0.5, 0.6666666666666666}, {0.5, 1.}}], 
     LineBox[{{1., -1.}, {1., -0.5}, {1., 0.}, {1., 0.3333333333333333}, {1., 
      0.6666666666666666}, {1., 1.}}]}, {
     LineBox[{{0., -1.}, {0.1, -1.}, {0.25, -1.}, {0.5, -1.}, {1., -1.}}], 
     LineBox[{{0., -0.5}, {0.1, -0.5}, {0.25, -0.5}, {0.5, -0.5}, {
      1., -0.5}}], 
     LineBox[{{0., 0.}, {0.1, 0.}, {0.25, 0.}, {0.5, 0.}, {1., 0.}}], 
     LineBox[{{0., 0.3333333333333333}, {0.1, 0.3333333333333333}, {0.25, 
      0.3333333333333333}, {0.5, 0.3333333333333333}, {1., 
      0.3333333333333333}}], 
     LineBox[{{0., 0.6666666666666666}, {0.1, 0.6666666666666666}, {0.25, 
      0.6666666666666666}, {0.5, 0.6666666666666666}, {1., 
      0.6666666666666666}}], 
     LineBox[{{0., 1.}, {0.1, 1.}, {0.25, 1.}, {0.5, 1.}, {1., 1.}}]}}},
  AspectRatio->1,
  Frame->True,
  PlotRange->{{0., 1.}, {-1., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->31760862]
}, Open  ]],

Cell["Include coordinates:", "ExampleText",
 CellID->38001672],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fxyc", "=", 
    RowBox[{"Outer", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "##", "}"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"Pi", " ", 
           RowBox[{"#1", "^", "2"}], "#2"}], "]"}]}], "}"}], "&"}], ",", "x", 
      ",", "y"}], "]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{"Short", "[", 
  RowBox[{"fxyc", ",", "3"}], "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->91629051],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.`", ",", 
          RowBox[{"-", "1.`"}]}], "}"}], ",", "0.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.`", ",", 
          RowBox[{"-", "0.5`"}]}], "}"}], ",", "0.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.`", ",", "0.`"}], "}"}], ",", "0.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.`", ",", "0.3333333333333333`"}], "}"}], ",", "0.`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.`", ",", "0.6666666666666666`"}], "}"}], ",", "0.`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], ",", "0.`"}], "}"}]}], "}"}], 
    ",", 
    RowBox[{"\[LeftSkeleton]", "3", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1.`", ",", 
          RowBox[{"-", "1.`"}]}], "}"}], ",", 
        RowBox[{"-", "1.2246467991473532`*^-16"}]}], "}"}], ",", 
      RowBox[{"\[LeftSkeleton]", "4", "\[RightSkeleton]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
        RowBox[{"\[LeftSkeleton]", "24", "\[RightSkeleton]"}]}], "}"}]}], 
     "}"}]}], "}"}],
  Short[#, 3]& ]], "Output",
 ImageSize->{440, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//Short=",
 CellID->181735548]
}, Open  ]],

Cell["Make a piecewise polynomial that interpolates the data:", "ExampleText",
 CellID->221253682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fun", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"Flatten", "[", 
    RowBox[{"fxyc", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->121706788],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}]}], "}"}], 
    ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{330, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->736623881]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"fun", "[", 
      RowBox[{"s", ",", "t"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "grid"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->8525817],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx0vQVcVMv7P47d3d3dXejDNbFbr4FdKGJcFb0WJnZgi4ktBiIm6FEEBVGQ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    "], {{
      {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlDtvU1EQhNcQWzfXNi3QkS62/0IkoAkQoKGiJbQRoYAGCRRLVBHQJBH8
ADCk5NUhwsNdIpOEBuRQ0KeDYApe87GDKFb3eHfO7uzsHk/Mzp+7tC8iLsr2
y5aLiCXZ90rE5bGIedmk7Hoj4obsbTV9xF4Ic6TI35z3yohnByL6SrRZJLYt
/7Tit6uJ+SHMQ+V5Wcl435itImtTd8lnMCP/5vxI967J1nRnu8g7D2oRt1Tv
jWqsqZHf4xE36xEd4V/r+6HM+LLxd3T+IkxXsV31e0F8P5bp/1d7Sv4n8n8W
ZljJ/ulx1/qsmM97xb+V2S+1F/XdqaRvwTpQf6aZHMgxV808bd1tydpjWf+n
Oay4d87v9B0UqUGnmjq2ZOtF1ls1X+JwPiFtTjZSa+JwAQOXPfPsVhMP/zPi
NatYr5b6LbqPDeW8J98nYZ4r/lg2Id8V4Q+V6Sd+t5a9MA/ykpM8C9XMhcZf
xxPDPtAPOPTkLtzuuzb6UJfeiI3Mnb466uloM7UjB7nYmcPiMlX/rwt58bMT
W94lck16duxFlLkb9AyOMxqDoR4zP1jm3I+r5rFm9sq+cYe5kBOe4Nuu3fZ7
afktjJx31fszMGdybbjHgTXB33Vv3CM3GHRmHus+U4s9oAZvZ9N6/n1D5sCs
nnpe4KbNp+ce6Jk3dL7MubETvGEwzPZVPWudbeZ+9Py+4IEfbU41Up+W/wfo
D52uWqvT+v4az9nONHJ+zA5O1Or7LXAe+u1ve+fn/P8y9Px3vANgJ4z/A+Bz
s+Y=
          "],
          VertexColors->None], 
         PolygonBox[{{3391, 2547, 236, 1388}, {3042, 2585, 1094, 1323}, {3133,
           3197, 1475, 1409}, {3145, 3146, 1388, 475}, {3144, 3026, 444, 
          1421}, {3198, 2657, 1476, 1475}, {3763, 3762, 475, 2081}, {2857, 
          3042, 1323, 1066}, {2876, 3143, 1421, 1094}, {3818, 2812, 446, 
          2197}, {2560, 3405, 1702, 299}, {3682, 3681, 910, 1702}, {2548, 
          3393, 1688, 236}, {3402, 3403, 1700, 908}, {2648, 3133, 1409, 
          1471}, {2946, 2557, 1408, 1218}, {2558, 2946, 1218, 1700}, {3239, 
          3240, 1471, 446}, {3026, 3027, 964, 444}, {2813, 3818, 2197, 910}, {
          2657, 2858, 1066, 1476}, {3445, 3444, 477, 1688}, {3008, 3009, 908, 
          477}, {3764, 3765, 2081, 964}},
          VertexColors->None]}]}, 
      {RGBColor[0.3409860620630027, 0.14011589091865034`, 0.596277476923128], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmWmM1tUVxv/vO777IigDwqA4i0NZ/CqitnYYka2IVgEHcBhs0ookbTAw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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwllF1olmUYx2+3ve+z93me91liMm2CzJa1stPAGn6QOnOzoMCPk7YZxkZQ
bGjW3Cw3T4R0Z5aCnixU3OZomyUK4UcHC6PWJKawgg52lDOHZVDm/P35H1zw
v+7r876+qnd98Ob7JSGE3VAZNJiFsCMJYTFMVXkI3xRDaI1DeCYKoQZ6JQ2h
DvokF8IIhi+DN6JzMh9CN2/vYNsIvbgghC/x8RX+LkBP42tlmX1vh6ZLHWMN
9oWKEE4UQliFTSf8Weguvrah8yF4DzRArMu8NYAboXXget6u46sc+6PYd+Cv
Dn4p+f6Gr+vYzxF7a2LZaXJogm+GniDfw8hHM+eo3FYgnwcvQn8n8mX4vMzf
DkI/EquW/9/Gdws6E+A059jXEueuHK6Al6Azju8E+Xn4ocS56s+HwPPo9SD7
jph3+cth3ngKLxHzX/AU8RaDN6DzMfLtsWv9FvYPUezi7VrOPahF/3noaon/
3IjtVugM9n3obwbXQ8PIx0vcq9XYd+Xcs0p8/y4f8H3Qa6nfhI/mLBvJXBvp
dCBvh4r4aoXfDK5PXesq+G5sfyDGHfhZdKrg98FP5W3zHLrPprZtg86AH6Iz
Ueqe74g9A+r9GPqT4KnYvarERw34vcR/aYI24XtI9Yr8xyZkX8NXw5+D34b+
RfiVkWfoBv5uQkvznoED4O7UsVRD1fY/atxf5hprNtem7oVm9C/ooOqN/Dj2
/yAb5S0Br4eGC34TXp33LP1B/Y6Ve6bayedb8lkVuQfKZSDzrimnp9A/Bb8Q
vjlvXJX473r7Av5z6Db1eJK3R8RrwF8/uJb+3wB3xa79G+TYC3+o6FxaePsZ
PEHMRfCvksMjfIUKz7reCsTqy2yrGPrrfWTH8v7zOPb78D+Dr9fh/4+9E9oF
9fBTbB/Az+H7z8i7sAebX/LeiSHk5zPfih74tcheUA8ix9gLvw46ENlmC/gW
Pn6K/MddmWdcs60dlOxq4l2TzgL+UgotL3iH7mSumWqlHrwNnowdewaKsP0s
819ulTr2+qJ7qxzGkP2N/r3IN+wj8PdF26oG95HvTX2bNAMlFe6heqccVIub
iXdDNZEv1Ui1kc8j4PLEsbUzvfA9mWdXO9NJrP3Qr+BpaLDoHdLuaObbYt9o
3WbNeBm2I7FvhW62arsl9S6rxrrNuom6hbrRmsXZ1LdHM6lYl4q+dYr5buwc
FFs71aNdij1Luokh9k3TLdPN0W2eLHq2dKMfA76d1E8=
          "],
          VertexColors->None]}]}, 
      {RGBColor[
       0.42644605050569795`, 0.28870773106853836`, 0.7164018290313442], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl2uQV3MYx8/+/3v+1/P/77iMyyYzIZrxvjbVZsZlL/GmYhUjNEMU3dYt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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1ol2UUxu9t//fn+T9LiSK0YIpJ9b0522ag+NIKorKx3mYGvRmGcy5H
FuhWS6flFtWHFkn0QdHNVhFq1of6YHvTNoLph14IWpA2S6ekrq3fxdWHC855
zst97nOfcz0V6198YGNpCOENkALDcQjrkhBOZkO4lg6hshDC8WIId6D3oC9E
741CmMS5G30odox81xBfg70B/SP0j8Eo8jjxq4kvKwvhArm38O1ALoT9oAn/
AexLsZ+mkBbkl8DpDHnxL8F+mPPOc147+Wpjf5PcBupi16RausCj6I+AVcE1
TCCvJP5B4neBVnyHyV/LeROctxR7HzXNp5YK7Auwb8f+G+evwN6PXob9Zfzr
0KfzIVQT8yq5F5XwHfs72AvEn8V+iNhe8CHx+9Efxt6M/zH8j4O3qaUE+73Y
K6mxBXsX8Vnif8V/O/r76OXol9HPE9uO/+/4LwGH8/4m+Wbi15HvSXCKXn2C
/3ziW/E/g70c/Sj+EXp9xj1px34F/+XUMgw+4KyexGfJZwb5e/L/gz6P2A7k
Kfx/RB/A/y70enJ8nXYP+vA5p54j30j+1tg9U6/k8y2xdaAKuZj22ddRT2PG
NZzQe+NfRX+XgEH0beg1yNXgTfWWmDL6UQJaYs+QZkc97UTOYQ/oM/hvIvZn
vm1EHy917ZfAsrTv0Ii8A/tFfPfx3rPIodx3vUAPm7BvBinkBkxzYu+AZr8B
NKEvjv22R9BvQ16L/Sjy86CUXGXgFvJdJcc1zTc+Iym/0Sj3Gyt6VtXjvZx1
Gfvd9GOx3ifxm+otp6hxFttc9Ij71OEzROwK9Mqce/Qc+Y8UPVsDxHyF/Acx
P5R6Z7eiXyk4l2ZiJfoqsC/jGV2N/Az2BVl/6yf3FnAPtf5FzU9j+6LoXp0g
525yXw9akUc48wV8b0ffgHwIn7bEO6zdVY+fSLzj2u3hrN+mKvau6Y36dDdQ
kTanfEfscvQ7c56JLHoOrKW2h8D92HaBQXw7wN+aB1CDrRrsSbzj2m3NxDS2
f8Ea3RXsKHrHtdsT6I/jP1ZwbYNgCt9y8ueIXZbx7n+KfVvWHPAUtvXgBs7e
nHKvmiPPinr2JfmPFd0rcYi465vIsy8O60Qe4Yw5esuU77Ko4N7pTurFpO6f
dk/OIO8EA9gWos+NPZOaRe2cduu+yLVoxxRbD/amnENvoxnVbOqNLiJ3RN5V
9ayfOR3UnTPekWZqeT32rmtmZ2LPqGZTPZTv58TsTDlGd9kUexd0p5Jyc764
XjuwB/mXvGflpM6nn5/lzV36B9RyXmdsLtJM9USOke9PnJEvmjPFlZqBdxNz
rrhWO9GdmEPFnXqzMWLnRd69adUUeQb09uLomyLPlGZJHBuK3jHtljj5UuwZ
0NtrJ8VVj8X+l4mzropLYv979E97pWDOElfpn7K1YE4Tl+mf9ppmv+i7iFNS
1PtswbuqmdLubSDnwZR3sA3fWwueTXH+vIJnRrOif+JowTOrWR0CjcjjBd9V
/+xsZE4UF85mzZ3vocc5c2gSeWe0K/rn5CNzrLi1FJxS7+P//x3aaWwHE//b
NVO9iWvQ2fpnioveShwrTtLu7k58tnb4HPLZxNyqGibJ/WdsbtZMd3Hf7qK5
Rv/o/wA7mCWo
          "],
          VertexColors->None]}]}, 
      {RGBColor[0.5119060389483931, 0.4372995712184264, 0.8365261811395603], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uIlVUUhj9n5pw5c873HXUIs8iJfqQlKGZeoDBQZ5R+eCma8hI2mvmn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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlWtolmUYx2/37n3b3ud+HmuGLoiNPmh+KaicfvAARlP8kJGSx4i21E+R
6BT0SyrOTXOYmxVYhi3xQ5I60aA0DTqYQR53aNmEMspDgsNSt3nA359/Hy74
/5/rcF/3dV/X9TxRv3TWWyUhhKVIKTKlGMKjMYSF+RB2IxvgW+CnwTMeCqEN
fLE8hB74L0hfij2yqBDCTOmTEO5gMw1eQ7zJ+L8KH5YLYRUHrYT/gP1xDvsD
foxYK/A5BJ9OvCb0DfCD8DPwd7Ddi805bPuJ2Yh+c3RuitmYhTDIt5PgdnwW
R+eo3PYhz6N7Hb4H/DlSD65D5gR/yzirlRhn8L1CjA/AFXzrB3fx7T34NmQl
59dy/gvEW4R/RL+Gbz3ofie/ecR7sSyEDnzbyPkutmvRN2PbhPSBp3DeI+jf
zxz7OjEq0I1QTcHLsZlE/Lnwndi2Iz3wo/h8in0zNo+BP8L/N/ht+G34LWSq
7qr3wrcROU+syfAiuSTIPPIZwL4N3+HYX835zqPAJehnok/J/0vuUoC/DK/l
Tg2c/w18KO+YreC/iP9UwXfswL4/+ixChxbinYJXoPtZNQVfRp6BP4v8A76K
PAceh5QTryz1XbqxL03dQ+qdl9D/je1seIb+afgd8jmh+oMzZAhel/jtU/gC
8Hzk7RK/0VaSGo/NMniB+3WDD+E/kPedviL/7dj3lbpGX6CbQQ7t4EH0G9F9
B6+ht09g8yZ8tHqKeJ8hyxP3sHpXPduR+c30VtWct5B486N7fxc2q4i1Gjlf
cM8+if9+fKqwXZ9zrWLiXFWzSviS6F5WP6n20xLXQm+wlrO2Z367/9C3RPek
elEzXMFZnfDaMtdkBfY/RddOPflh5hjyzbC5j+5edG+e5T77uFsz5/0Irim4
Nydi/0nePXo8dY1UmwnU6F/0N6JnST5D4MHo2dFOUC4j8OnKO6dOcA8yHd/7
5FCt/kYu4FuJ/a/4dhZdm2p4L3xMYlxV8O55I3q2tYNq4H+Scy+8Bb4tuoaq
nb7pbRVDvnpj1X5s4rfSG6g3uop+e/WIek09pt5SzzUl7mn1snbYAc66mXi2
q+jZjzPPnGbtYeK9m7pGqs0APnlwZeJaa8Y0+9eia6sdcBrcgFzKeYY026qJ
aqEZb0U3Mv6/e/LezdqZ2pXa0Y8XPYOaPfXYJs7bnHp3aga6U+8Y7RbVfAt8
a+rctOP0NhdS73K9URd4fdFvozc5kHjHqZ7a2TvAvan/DdqBATws9Sxrhw4H
Hy73LlHPrCPWjsy10Q7bif9A4t2lnfw99t+m/jdo5jSbR/B/reAZ1a7Kpd4N
2llHwV+n3p3aKbJdED1r8rkJvhXdy9p5qu0rRc+uavwAzT36Mw==
          "],
          VertexColors->None]}]}, 
      {RGBColor[0.5884843198692855, 0.5671927418590927, 0.9100609920721253], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lsVVUUhg9t7z3n3nPOxQEQEuc5JipYNc44tKU+4AAaIs4gFH3QBzW+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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlsVlUQx097+92vdzlfldBWHxSVgMZEHwCJwUQRbfXFaEoMouLSaik8
iInbi6jRtlq0tKTEBeOWuECMEau0RCGiYuKbQqmKqFh8B1cKVBJ///xJ7iQz
9z8zZ85s58LOdR0P1IcQHoUaoAMxhC1FCLfCt1dD6Id/MA9hAqWpJISD4Ieg
m8CqyG+A785C6EzBcfAy8qfIq5B/Qh4rQ/gc/cvQ3yn9WghP428Gf7Mazb+G
zUzif2/CD2OzvxLCEezXwLdgvxp/H/GvHf1W/q2C3w5diTwI/hu2D0N/Y/8H
+BL0L+fMEuz8wmfdwb9j6PcTwwmwcc7sg68Dn0Y+Du1BfyPyt5y9ADnCf4fO
1dgfxv8E+DO5c9MGjXHXfeBLwReSsybw2zj/dL1zMAK/mH+D8HcpfsWGz/nI
LyBfj6+WM/f5AFqA7hX8Owo+AJ2H7pPIPzY4R6vRHZd/dD+suFavQqcT12w2
/H7iWUY8fxHDNPKJwrWRjmK7Cn+P1TvGGbAB1RdfbdC18HeXru3j4EuQR/CX
4e8k8ewlvq+geZy1iPs/BN6L/jcV1/gw+VgYHftsdLZgew5nHFfvEMMmdBeB
P5/6zq1gr9SM/Zs416OZbZXz28E3cMYkupvQ+a9wzIq1Hboff92lc9sTnKsW
8H8S5+zX0jVXrZVz5WY8c62Uo73orizsu4aPAvxj9Feg3899HoH/Mvqui6HJ
3D2tXu6FLsb2M6iK7Vx8XJfbp3yNIu/hrByffdh2c+bZ+NrFv+Xw76ETo3tU
vXkndC6+b8jd67pTc7QP2XZrppCXgm+teAaXwXdhUxDLeuq1M/MMavY60G9A
P4nO7QT/ToHvBs+wn1PnWWrL3Uuqh3r1d3TWBPdsJ/g9pX2/Lx34a3LH/i50
EHk+/i7Cd4p8Cnmm9FlHOXMIvrl0L+0DHyYXZeFd8mfq3E3ktlUON6g3oGNg
fOFZ9BN0JtHfhs/6wjOrWdUMa3Z7CmOa4S6wQ/jbnHhGNJtnFd4NmtHNyCdL
x6aenhVdM9WqiwPXIz8BTaU+cwe6B3LXWnccAhuGplPPQBPY2uhZHiSfr6v2
0bVUjW/MXVPVchTagZwRQ2/VPfEzur9En60aXgC+Cx+NFccQsK0rz/Q6Yl/p
Hafdpplrhn8R+qHBPf82vt+puVdGEu/GL6J3mXbkLfA3R2NN2HfAL4/mlTPF
Npa79xWjZqFRO7vqmaigm0b3lmZ6O9glhXtfPfUc2DpsLq16h7Uiry19957U
b8nX0bOkN6WKfVrz3Z6qetbvK70LNfOfIFdqxhTDgGxz9456RLvkSObZ107R
Lnur8Nuhnaa3ZCpz7+lNGSq807XLteNfKrwztSuVw43RO0+7TjWeRP4+etdr
Z+ot6in99uhN0tt3b+nZ0Buo2s3BfrjiGmpWNTOaFc3s/xxo/kc=
          "],
          VertexColors->None]}]}, 
      {RGBColor[0.6513171861228177, 0.6681476744975239, 0.9114933878948328], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXlwltUVxt+sX77tRUBAQDDB7iCrKNCWJQJuLDFWizZRQqBVsYJVaRTK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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwllltsVVUQhld7bj1777MKQhEMYAvGSyxVaEDQSKEVKIItLVjBeAWUe1sU
ldhYA0Q4EBBNgIpiRYWYIggSAUVtvdAXUURMjGICRUjkBYkpJmKw+I3/w5/M
rLnumVmzdtHshtr6XOfcBhAHw71zt4OnoXeknCuDHgf2QjfG4EPnzkTOTUG5
EtyM7BawDfmTyPtCF4D18I/BT4C+x8t2P2eFgXPNGee6ks6NIfBG/L0MhhLv
PDoH0s79jf8K5CWctaN/DvtVec49jHw9tmM4+wt5NyhCNgS8hu+n0C+BHuaV
y3bORkCXen3LAs4O4v9V4p0g9wvwM4i1FnyTcO4f/L2EbH9auXSiU0O8X4l3
AvvdyKvgq8Eu6Lakcn0e+V0p5Wy+D2HfHVOMNcSex1kn33oZnbHwd4NnnGpa
iOxdcA7dHmw6sE0iX4HsKnwBsgvwW/n+cmwy0B5krR/wu9PK2XLtQn8DdDsI
+J5jnG2Gbia/cvR/gh+M7fVgE/wc9A8jO2vx8N+Av1uhi71q9/8MQJ9E5wf4
fui8wbdvA7nwS5CPgC4F6/j2Rr6xLlJNrZat5HAD9kO9YlmPhpHPH/Ct+Com
nyfwvQh8i+3X8KOR3QEWo9+GfiX0JPAssQ7Cx/OdG4iPWvhCvv1aZP3BK8iW
cjYSepSXrdX4I3znwV/G90x8LsV2HfkdJbcPOTuCrJyzs+Q7nJy+4Fu+BJeS
msmGUDW1Wu4DaWzfg29BVoWP89C/g6Yceos8F3o1Pgcg+5F49cRfAkbxfUfA
FeSn8D+N/IKYetuPs+5c9fg6s/W6O/ZNNluNoWLbjL2O7Vaw2KkHm6E3gUXw
PeRcm9HM2qzuAR+Q7x6wDPmf5PQIdBk+m4iXJMYa6HdC1SIBn8HW2/2EvwL/
CfLfyKeZ3B6En4f9BM5WYN8HfgH8JPiV8H1j6s2b4HRcPRqE7UCv3tjMjUe3
AJuHyKUNvEisIs6mxtWD0YHuuN1t64Hdnfmhaml36BS2d8JXxFXjVujPmIPH
k8p5UKgZsdmwmvbH1wBwMaEadGE/NtTuauJsL/y+SLWxmZtOrjNAO7kuhx8f
akZsNoqJMQf6UKRvt50wkXznR/p2q8lU5PeBw8ieI16W2CMD3Y3jYDKye71m
eVlMu6xXqF1kO+0762eou1qGTh90r/G667ZTK9FfSLyCmGp+Oq0dYHff7mA5
uhVeu9buzAH0A6/lPgudFnxvCbVLbEdth3471CzO5ewF4sdC7Srb0dPgO+FL
c7TzbBfYDrTdZzvhZ9NNq5ZDErrbxaF2g91xm/V/4WtSmvlf4LPWb+gpwEXa
ebbrJmN/Fd0e0DumnbgR+SV8duRpZnpnNMM2u9bzidALOTua1EzMQnemV+++
wn91qBwtt9XIt6DbktFdsTv0FrqDQ826zWxovQlUK9sZ1fBVXr2yntbat4DZ
1D7LWS2yGq9e28xYraZndPesZh2hbEzXdnIJ9EXbr3xPvRN9W6hdaGfZSDNg
vbc3qRfyfK+3z3a+1eJMWr2ymryP/q5Ib5vNuNU6J1ItreYroecG2j32Zmfs
PY00y7azbBfeH2lX2060u/5xoNzsztvb+3mgt8He4B343xnqrbKdU4f8Aa9a
L3d6a46R/7iU3pzj0N9n9JbbWQH0Tq+3xGbSZuHRSLvAZuKkvbcZzYbtqHxk
q0K9DXUJvVWfBtpF9mal4BNeu93ezJugb/T6F7B/kv8AjbMn3A==
          "],
          VertexColors->None]}]}, 
      {RGBColor[0.71415005237635, 0.7691026071359549, 0.9129257837175403], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmQlMUZxr/ZmdlhZnY/SOKB0SgggkZEQBS5D00FiEepgDeUZkEBWdCY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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmwj2UUx1/3976/3/W+v9+TViS5JMS1tSlyudoVlaTQ1FSkNJFWlaZF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          "],
          VertexColors->None]}]}, 
      {RGBColor[0.7755199970096708, 0.8512961370632379, 0.9082567408899183], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuQV2UZxw/sb3+X8zvnx2Z/WGAwgo2ayILQmEKNmY7K7oLCwuIl/0gg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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwllWlsVVUUhQ/te23fvfddEP9omYJgUAFBwQi2GoMmIlZQEhVE+WEoiogQ
USiCGmOoYDRIUygIGJHJAfjBJGU0ytAigxqgKqCIAhWcqCIkKvqtrB87Ofvs
tYcz7LU7PzZ+6NMFIYRaJIN0yofQEelSGMLEohD6sT6ZC2Es6zeRDWkIm5Br
SkLohcP8hP0ohM7gN6IvQG8GX8v6h2wIVWCfR04X4wumPfFuQWqINR6pwfc4
en3GOY+jPwG+CfzXyF7WBewtw15GzqvBdkWuB1vH3nTW7fKO1YyUsf4e/Kzg
HGPQ+8chXIvvHvQTsiOvc+gh1LeF+B8jPbAPIF4G32HY14CtaMU5OM8b7JWS
bz32z8DuS13Ls+hZYs9A/5ta/0GGgn0f/7asL0dexvYpMYqJ14J+BvxZZCy+
1dT4CPb9+LxI/Az13IHvAGQB+IVIGvkMqn0G9VQRazCykvq3gm9KXbNqHUZN
U1LnVC7d+QFs2dYhdOdNGtE/JNYHyFfBNW4GewnMF4W+o7msD7I3SGty/Io+
Fb0Z7BXk60vu+ti1TkJ2Y9uFzCR/H3y2Yt+S+GytqLkW/1PkG67c7O0Bexf+
D3D+Cvx3gP0EWVfoO2rAdjfSF9tlyEnwu4kxEXs18Y9g+wa5k3y9idEB3/bI
ldiHIOc55zrsf2KbgH8Xcp9BRhb7z7QDW4qM5mzVyF5in0bvRe4s+CLu6jw5
V2d8Z+9if4F4W9DHEeMie+vR/0J/Dvxi7BeI/xS2Bs63A70//ivRVymnYieu
5TxSmncNyq2euj3xGXW2Oup7B/ti5I+M76ge+7fEnIetBf0C+W9g7xliXSLf
TtYrsJ/FVkK8G9H7JK5tKj7L9VewDyw0JlD7L8hN2DshR7H9hn4z6zZZ/61u
7I0q8B9bi74GqSxwzslgT1Hvq9R7LzFf0/9j7zDrfznvtNQ9r17XnzlCvYfQ
K8BvJv0RYvWO/XZtiTdH/ys2dzwMvop1AuY+bLPBD4/8x/W35/Lmg9DHYb+q
0D08JbaPsPoD6sWi2LWoJ4eAX8p9pqxbI5XYR6d+m1eCueUj9G4l5pgHwT6E
VJN/PvF6kKtn4rvXHzzGeW7DPoe7bsL/JXLNTN37OerZnrpn1CvilIP4dgXT
DnwpshzfZXnfhWrSXU7CPj34TtWLTbHfRj35OfkmJ+71fMZv9x+Yjlm/oe5i
YWKu1Z3oL6tH1Zv609tSc5y4rXuJ33oEUpPxm29Mzenict1BjG+UmBv1BqvI
tSv237iH+EfBton8FqPA72M9InVt4rCy2BjZ7kc/HPuOdDeq+UBqDhV3loM5
iu1Y7N5TT/+U95vprdSzS9AHR+aivsSbBvYce5XF7sn61DNDs0IzaZz+J3c2
ocg9rLstSsw1umNxza7EvSLOmY3vW4lr1QzrkDeniEsUoyz1Hejsq4vNzeJU
cak4ekDiHldv688swv42MqvIPdSS9xlUu2reBnZ7Ym4UB2lWnYjcq5pZ4o6d
kXOJQzRLv8x5FmumikvVM+oVcep3rDcl/qviiEc570iknPUi4jeDnwemZ6Fn
bAPxG1NztXr2usgzVLNTM09cJs4T14nTngQ7JjXXaCYfJldT4r+smSiu3R2b
q8W56vUlkXOr5zVLmnLmfs0Ucfv+1G8vjtcsPIf0y3om1onLcp7tqvk96lmR
N7fWknOt5kPkWSyO3KBZkPeszPJ/Hif2schcqj++lPXFvGex7uRn8Ksjc1cf
cv6OPjD2WjWI2xtjc5M4/lDiHIqtHh5F/B9z5g698a3ELs+7NnHC/+qWRJE=

          "],
          VertexColors->None]}]}, 
      {RGBColor[0.8319481754390431, 0.8701134309873737, 0.8829769675206912], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2mIllUUxx/fdeZ5n+etDxXlkkRq0oJDqyAWpLRZOI1mm7ZBGWQzZJFb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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlsVmUQhj96/qX/+c85eoGJVhaJdV9AYlRi1AuIC+iFLVYuwIVEIAH+
GjCyRm/QahSMZSmCbUVKWVr1QtBEbCFRwXCnAiYCkaU/ChYjMQWjaHzevFy8
ycyZd+abb76ZOWNmNjdUakIIi0EOTIlDOJ6GMLUYQiuGW9CjJITJ+RDWgdHI
zWAX8irsdXAngHcLITzLt6+xfQWuGhZCgW/9WQh94Dixb60N4RzxZsHfj63K
GUuwLQWni5d9rgghD16NiAP/bfg/w2/EPgKfqeiLMvt2c/5G9HPYd5P8OHxq
sA0Dh4m1GM4hcqkvh3A19os536Uuca6604vIjcToItaD+C/HdxnYFTmn/sQ1
0N0jzj+cOCflMhJcx9kDoAnujfjcja0xcW7NYCLyKb7l4LYQ4y64V/JtGnIL
3+ZzVgUcwX8NNcpjK4DPyPVa4lXxnYu9Af6H6KOwtYMB9OfBB8TrBEX8a1VP
7voWPj9h+5wYi9A/Rh/KOeZ09HdUU+yr0buJvQPUUevh6EPE6sB+T+Sa/oO+
Awwn9gLwN3I39gew92OvJ5cKMT9BfoGYXdjuhLOCu1Xg/4m8RXdGngU6sV9I
7XsvMSr4d4Bq3j21Efl9sBO5k3rcAff21NwN+IxFfobz2pFf44wi3JrL/fkE
uBn7Tal7YT2cNs77BX06Z39EvOuR68EyfJeCbZlroLtfU+u36cVnMO83GpP6
jfW2L8PPsKfgybzfpAHuX6nvurnGs1At8bbBM5GDOwI8B3cK6EPeDTrVq9gv
wd9GjJfwXwjOcrfv8F9JPuPhN5PbAPZN8I9hn6dZiS2rZ1Rr1US1UM2P4PsK
Mfrwvx+fGcibY8uq2afom1L3yhvkewPybyXXRjU5j3wUvI7cAb8H/tbMtRlE
30vuq9T/kXv6DNwfSq7NWvUT9q3YH4pcwzJ6krgX6yPnpp5QLyjHQfRHQVPO
Pboldg46Wz22Bt/HYud6lHjtyL+X3Avq0ff0ViW/9Vj0A5lnSLNzHzn/mnqn
aZfNKHr3zAbfFryD/kX+L3XttQMuwk3Am5y1P7KsGuju+qbZOwH/qaJn8Azy
2dS91Ib/IPKG2Ll8oXqgd6W2aQY0m+oJ9YJmVL25PnZu6lG9/ZeJe0M9cJCz
D5Wdi3ZaK9xR+CwoeEdPjr0TtAs0MweRf0y8m7TzJsKdlHr3aad+g21f4t2s
N1JvHSh7t6jHTsF9PHbu2mnz4M4FD3N2W96zqjfXW2tmtUvW8u1Y3jtlD/Xf
m3nXa4eOJt73Jc+ycu6BHzLv5hZinsQeJ+4N1fQPcjlfdu+rJ7Zn3jHaLdpR
c+D3lu2rNxyJfpr4rcEzpl34SNlvr52o3XBb7Ny1IzS7q9GfLnqG9W9ZGbu3
9I/pQd+eepa189rgr0u8m3XHCO6kxLtcNdEsdJe9SzUTmu09if8VmvGq9nPi
f6XOnA93KPO/TTmPS/0P0r9HM/c/MisBEw==
          "],
          VertexColors->None]}]}, 
      {RGBColor[0.8883763538684155, 0.8889307249115095, 0.8576971941514643], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuMVdUVxs/MnTv33nPvuSmgDDUStLZB6INCwZqYJk2EkjZtCtpHkAFm
pgIDyPASkCp2aFLbYNIGWjBCK/IaUJtCHazhmUEeiUKtCqatAaaWhw4woLbV
xrbQ78e3jH/suXv2WWe917fWPje3zLmrrTZJkj/XJElOv0P1p7mUJN36/5dp
kmSVJBmss6e136T9aO2nZUnSq/87tX8rnySntG7V/ms5n12nd1t0dlcxSVaJ
+UadbdLZt7TO1yfJGj37ifarxO8X4jNQz8+Uk+QrWmPrkuQy8rU/kJjH8Jz5
9Ij2/mqSbEUH8disszdE0yx9NovXszrvU2ddkHdjIUlekLz9Wg3is03nn6ix
DOzExqV69rDWNvFpKfj/x2tNuz3oF+rsfq1f6XxG0XKOiv4dyf21dBqh/8+L
Z0/wnSsd52t1i99E0RwpW2f0wlfY+7L49ej5Hu37y969+v12jXlwNkRrkJ7v
E90inT8jHhXJWlxjHz+ft5+X6fmPtfZKn7v1fK788Ac9Oyk99+r8WdH8SLqk
etYh3p8Rn29oDdL+3zr/u+iHiu6y9Lyk9QPJfFXP/yn6/Tnbgy6rxH+nng/X
+WDRjKnY7/hiUdH+IUbYOLLO/l8tmscqtnmzzkdFbBrylo9/+5RMj+0bxKdF
/68vmnZk0K/Q/4dyjsksyVxaDd/VO+fwz8M6+0fo/KH2jdofr3cut0Q+ox96
rpctN6S2H9ufzFkmNs6U7V/V+nqdF89fyjnuMyP2T4rPfVqza+zvL2b2ea32
Ba0ZerabHNR6TDT9C/4l/6cX/B7xmqP3+qWOEfE6UbRNyEEeMqi5p1LXXY30
rdVaIh57a+2vlTX2LX4irzqoD60BRcf7Dq2unO1eGLZTD9QFNXi46BqjXvEv
fn5VNIdzljM2Zzkbi/YhvtwQ+63S67+y4c6oR3xwJPHz9aHbVmIoPo9oP062
fEHvzKq1T7EBmsXS9zupczoR/4ek2z5tn1ccthMn8Zii3y+V/c5gybw1c90i
hxgTu1Hif5tWe84+P6W1UedH9V693m+WrBt0tlvv7SKuOj+j836Su0A6vK39
m3repvNPi896yWqqsT7gw906GymatXljEn7bkNi/xI441pRsA3HmrCv82ap9
e71j/7ZkvZM6R74snrdr/a7WcpaGLLBwf9VY1a13T2kd0LPeOtc/eT89Mxbz
/0DJO6bnB+uNGXsDN7Bzd+xfkcyz4rtM9D+TDbtyzv1G8ZiUme54+OZ10Y8Q
7emyY70zzuGDTeQV+QIeg3FbQ6edQQOe9S25ri8VfQ5eLSj5fGvgBPXfEbR9
gh4ftQem8bss9uTH2sC92pKfgcM92j9RcW73Spe1qbF8vOSey7t/fbJgf1OH
O/Tec/WuR2pkWN72gMPXl4y/58Tjvqp7F7r1C527I6/Q+Rb55j2tvnW2ndol
1u9Lh3V6f2bBuQUPZB2K+FAL6JLWGyNeix71HPUFBmeuz++WLQP+6A0t+UYu
dOl5d+Lf/VHL9NWu2IOfm6OnnCi4L6IHZ9eHn/ntH3t+G6IP4bPxkdsNQYNP
toAneeM2cViT/zim8yN+Q0IGWLQnZHFGPu6J3Hij4BgMDh/05G1bZ73lct4V
cwI2QtsZ9J9SnMdXjI3oQR+hR382Nf6CveDB0OhZD4rfD4vO+fGiHad1e874
yExAjYPz4NGLWifF45aKMb5dvv9LyRjSJ2wk7pf0+5vUOTlZsZqb2T565+N1
xobFRffFEdEHhkfsqLlO2bVc/Kfovd9nrtdZ2FTxs1zJ+T2nYJkLIveWhL7Y
S763Rc5PKVpf6uaEzm7WWlPrvF0QcXmfXK7Y12AmdQ/23lM0bVNgxc6o/WlF
Y9K+6BddH+Vn3n0UuQul3/S88R9dmcfAf3wwImY24kbuYvs6nY/Jme5zsvvz
mWcXcKAjZrZzddaN2NE3DkW9UEvgwLpa48+2wNWbKu4r9BRybXPMK7PFu2/q
fH5dcTyudWPeMSf2zFFt8snsqutjReQD5/iYPX4Gmy+m9gWYWap3DMnBYanz
EHw+GP6hbzxVNY+rOr+iNUX8302N+9R9XvsPqs79OaIfVLFf/6OzSanxAKyn
zsl/+gI9hbn0Ir+pewR84b898RzxStk9iN4DPbHjtybeXS7aR6MWmgrWDx7M
BvBhvqW+G6LGmUWZU6ljMI+eSoyIz67In2FFz770KXy2IuZs+MMbPanR5eFP
anF56ECOTS06duRIZ2DyyuBDLBoKxm6en5aNd1YsH/wGW6Enzm2ZY00/n1P1
M/jtCJ70oMtF53Yh9UzAPIDdV8N2amFC0efY2hByG8J2cID7UDXuRPTqh+K+
wD2msWzcO1ZyT6JGZkmXs6kxD1rsJS4Twvfbo8dR7+T2gJB7DXPIr8wxuFBv
/bk/0cNHRR9vLTi+xPxlnf2t7PiV9O4ftW+jZrEp6pm5nlmZORkdsJnanxh7
bGf2bI35809l84Xn01XPlwNC9wnxbmP4DVvQD19fFzPDpfA5c9n51LMZtI0h
C5kTA4N41hh8mEW4/9Av0H1y+A2biqntwpf4FB0OSK8Xqs5HeEwK/viFd8FG
cmpl3CWwHxyhXsB98Hi1+HeI/89T4xAzL7MsMyc8pgQfcOz7eWPZlbj7oPOO
zHMq9Jsih8g9egG2QTOybIzGXmbbnrLn212hAzXVFLKwsSk1X3gyezfH/ahv
3E/QnffHR1+jZ56PWYu5ZkvcAcif8zEbcH+7EPvJkRvIAts6Yy4k1y5EL6An
U0tg+KNRv9Q0OjZF7yEfL6TOSfKsOeIFj4vBZ4xovle2rpMiTu2B1wMD89G/
N2YbcozYgiHwawk9qVfwhZqdlxk3X4saykUdMccy6++KurkUtTNCOv40s04L
Mt8VoSUes6IP3lb2HIBd9IzDcS9ifuoTd1v6HfKYP/vFTAv+3CSeN2e+az1Q
dOzphdQotQpWPCEd/iWaGTFLdke9k0eLIv/JhRcDY+mX5BrfOvgG8EF8Bzgc
8y1xQQbv0nMXhVz40D+5G9CfTld87+VOiz2Ho4fSv+nj8D+T2Qb0R+60uNP9
teTvMgcS5xlz1Oxa34e5m+IHZhx6PzoQD76/MDusk9yzmXXtZTbLTLc8ZrNr
32Ti/nDtrlSwb/BVR/QefM78g2zkTi+6fxAzbOuO+1GieD6Tmt+1/ll0X/6t
Ytqa+f7Evexk3NfWiPaizpsLnuE4Z07dUvU3l8WhW2/M+F3Rl+E5WnblUs8F
V8XjvZKxgdxsjvykL56P70JDo6cOCX9PC5+Pi/rFt8hGP/wwNWykjt6MPMEf
4FNXxRj1LjNP6hiB2WA3sWDm7Il76ryqZ1lyDH7ToxeA763Fj+9brfEumABu
IvdgzCKPBJ7jA7Blquy9N3N+gS9b4nsO8ZgafeGKnv8v85xI3bwV3wnB3o74
LsFM1x5zHXPgqPgW1JR5PmY2Hh0zI7pREy9FXZA7SyJ/ton2ntT9E1rq82jM
xpMDN6iJBwJz4EmsoKUOxkbuDcn8XY96mlswH3z7TfE+nTmm1OaMj/qFzj/U
+byCZz70IT8n63x+5jv5iZLjdCS+Z1K31Cz8czHn3xH+Y3bqG7i+OmqBWHDX
WBL1Qg0Ql2Mxc3L2YJxTY/BviXsEMvBtWfrcW3acNlR8HyA/pupsWtnfaaCd
F/Tca2fE3fP/S3MAnw==
          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwllWmI1lUUxq+O73b/7/8Ns9JCMQuXslJHW6AvgYoUUakt5BLjaI4zjjMu
hIVYGbRQ3ywNtXJscFwKK80kbCIVCxTKcgQ1c2l0pnFmzGzRQqvfw/PhwHnu
We65Z7uDKusn1fUMISyHekHVSQg10P2Aq6HaUgh10LFcCI1lIdyahnALVA6/
CvmhQgiPJdZdif3HyKZBO7Mh3IDNSPhj6OxH9lkmhPMxhAwUke/ERyV8BTpf
ggeiX1cMoR6qRHcdNlOQb0HeF1k/6BP4p6DmrG1mc3ctOsOQbSSGH4m1AK7r
gY98CNfB9+DsOeRfc98s9B+C7sX/Br0PX3OhDuTf4q8d/UXonwI3oT8I2cGC
Y3kG+c/EtgTap1yAP0D/Q/x142sCZwvRv4az7dx/EPkQ8FDoefil0DbFHy0b
wB2t4NOpfb9FIUr4nsv9R5ENxV8H/CX098Iv5z1HwDnwDPxPBw/H9jboJeyX
Qa/CX4v8EPIu8Cn0G8D3YL8E/bfxvwIaAD5ODmaiX4P8ZfR3oz89dU1UC9Vw
Kvxv0bW6PudYDvHe/hnHVIf+Ze7oQ46alS9836g38JbV0Bnkb0a/pQ2btdEx
K9aanGNdBG7JOuZ12P4KnolslHoMeSe4AvwRNbiPu1uLzr16tBV8GpoAfwL7
88RSnphvzLsWC7D/IeuajAK/Au4ED825d54G7826hzqjc6ZcLeP+9eC/kc/P
uYffBf8BngNuBg8hlsHQbN5WBbUk7jn1mnJ0M7KboFpy0QA9gqxbOcZ+FbgN
/SS6F0egP1K9y9k6ZPOg0YnfpLc0g3NXuUfVmwvJeQfy8dBE7C9BJ+EHQwPh
++JvIrp/pc71Wuzb8XUg+m1v4HMjeAO0mNz0A5+N7jH11ovoTMNXO/esCO6Z
YfjqKrgW6unHkR8B7wmOYTe2mzk7q/fgI4+/o5xV5D2Tmp2K6LdohtSbOxLH
rh69GN3z6nXFdAHfx6En1DvoxOicKVdN4DXRM6bZUk5vhz9XcG00E13gB6Nn
a0bOvf556tqr5w/rLal3SyM2LeAGYmzHf2/8n0PWXfCuU092Re8Y7ZYt+Hwg
cU6VS+U8i/wweGreM/pn6pqr1tXY/5O6JqrFAvAY+Enct5r71kAPww/nrBr5
69CT6E+BtvOWT6FHkU0uWndHxrVpIoa2Xq7R/sQ9ot7YqPpF72TtYs3YV9i2
ctZQZpvp8FuR9895RtYj38zZOORbobHgcdBrGdso1tHq4axj1m7WjtBu0I7W
bJVH7x7NWE9yEUrejdrB32g3QNuwLSC/gmxe6t3Rl5gvgt9H3pHxH6Hd0hH9
Fu2YM9E5US60I1WrlUXvMtXsQrRP+foCm27w4pJztQ28tGQdybTz5+OrHtra
w3+KZnly9F+lmZ5Xck+oF/QHblJ/lzwrmtGF8AtK7p0TyOvh26L/yj4Z/zXf
JZ5F/Tm1RddYtVUOdqG/p+RZ0Q7bhO1/qXtdNbgM/6/+B3yPLfNsbYI6ennG
DsB/D+0q8xsk6x39l0nnHfiT+H827z97BPg4uCbvnXQH+CdwVd47+0rqnaZd
pjvLomumWqkHfge/UPLs6c6ByNYWvdv1Z8vX3UXPhnyqd/clzoV6WLt8dfQs
aqdrN9yVeDdqRyi28UX3nmJsLPpP0F+gntBb7ix6N+lN2sXvRc+WdvIv8PNL
roX+cM3imMR/kWZyDvpVqXtBf/as1H+y/mL9Adr1TdGzqZ2v2ahM/TdqRv4H
hEROdQ==
          "],
          VertexColors->None]}]}, 
      {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmWmMleUVx997mblzl7nXgNikbdLUWgPDMpaZFlAW/WKa9IOBQSurMTDY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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlElIVWEUxz+H97zv3neFxoVBZCZlkaWmDRC0cdMiSigip3IImhyyGcoW
QYugWha1qiSyqIQorcBpWabulIpEKxwym8iGRf3+HBd/7jnfmaebXlFbVJPo
nNsJksEq37ltceeuRpy7AHz4xlTnPqU4dzSBL/w65KeQ3U9ybhTZV94e4+Sy
59yrwLlecA5nvehfR/YldK4K++PYbMV2EaiEvgJ2IX+APC/JfLzDdirm3DXs
lyGvQ1YGFmDfH7XYa8HJiOVQjmw36MK2DWT7FkO+pVMAnR+32CfAN3z/Q/8Y
/l5T73noXGzUhG7wgfh98MXEz45Y7lmgMWo1FEMfoeZh6FbeHik++p3oLuTt
IPws+CZq70Geh79y+AzR+PyMfAqMot/izNcY8r6o+SxFVgJaE62mPdCFcZtF
OzqV8BXgKbIXYAT/uYH5Xqn6oDPAUugN4A6+b2E/HrGaM6DfgkzVw9th9Red
5/jqAC2h9VS9VM/T0X0DlkRtZj/J9wb8ILMeABPY5hNvPfHvMcMo/Ev4eeo9
b2PQD3krQpajfvq2M9qVLQmWWzNvExHL8Sz69ciHiN2B/b7AalItzfA56LaF
VrtmNgrfgP5c5LeJUYVu4NuuagdnQx9Cv5f8m3nrQrcbZHs2oz7056DTjm2a
+oGsLtV8KYcdyAsDy/0S/s4g+4H+JLIJUBNaDPnWDJviNjPNSjXJd21ou6sY
6sWTwHqlngyj/wufHz3boVLkf+GnvZkZB7Zz2jXVWIL8j3LwbEcGYtYz9Uo3
lIZ8BJ8r0P9NTkPBzE1CZ2HfAx3z7Xbnw3fiayNvqz3ryXJiTcZsN7Xz2pUC
9T/Zdmbct5vSLd3Fh+ebT/mSjmpRDoqtmrQbuindknZkE/T+wGapHBX7fWC7
qxx0K7op3ZJuZhp/Ed92RTunXVwT2G5pJ9WLhtBuVz05DX8gtNvTzL/7NjPN
Sv8w7WaKb7lrRzXL/sBmr5nqdraDi8l2Q3uhq8Ez/PeAKnxXh0brZjSr+tBu
RzO7Gbcb0W3oxjdjmxlY7/VP0b9tMGa7pH+c/rWL43aL+uf+B++9yw0=
          "],
          VertexColors->None]}]}}, {{}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2517, 2901, 2851, 3058, 2921, 2922, 2880, 3299, 2586, 3832, 
          3298, 3195, 2656, 3508, 2655, 2867, 3824, 2866, 3043, 3044, 2877, 
          3777, 3779, 3778, 2986, 2985, 2577, 3436, 3435, 3709, 2802, 3837, 
          3437, 2578, 3438, 3836, 2793, 3700, 3419, 3019, 3847, 2791, 3699, 
          2792, 3696, 3698, 3697, 2944, 2520, 3503, 2650, 3502, 2651, 2801, 
          3816, 2800, 2565, 3831, 3234, 3830, 3235, 3233, 3567, 3566, 2541, 
          3370, 3369, 3568, 2716, 3808, 3125, 3126, 2794, 3801, 2567, 3020, 
          2566, 3800, 2868, 3292, 3105, 3104, 3152, 2606, 3805, 3127, 3128, 
          2796, 3803, 2569, 3021, 2568, 3802, 2870, 3293, 3107, 3106, 3153, 
          2607, 3806, 3141, 3425, 3237, 2730, 3236, 2729, 3583, 2546, 2526}],
         "0.8`"],
        Annotation[#, 0.8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2917, 2918, 2668, 3429, 3428, 3507, 2654, 3442, 2580, 3441, 
          3835, 2653, 3506, 3426, 3427, 2666, 3513, 2609, 3462, 2610, 3463, 
          2581, 3443, 3834, 2652, 3504, 3420, 3421, 2658, 3424, 3423, 3505, 
          3422, 3440, 3439, 2579, 3024, 3025, 2804, 3710, 2803, 3711, 2570, 
          3046, 2571, 2916, 2894, 3023, 3022, 3040, 2853, 2890, 3815, 2768, 
          3045, 2869, 2795, 3809, 2720, 2999, 2736, 3049, 2885, 2902, 2521, 
          2543, 3039}],
         "0.8`"],
        Annotation[#, 0.8, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2608, 2926, 3108, 3753, 3754, 3750, 3752, 3751, 2987, 2572, 
          2807, 3817, 2808, 3029, 3028, 2582, 3585, 3586, 3584, 2731, 2988, 
          3432, 3431, 3430, 2797, 3703, 2644, 3155, 2612, 3154, 2611}],
         "0.6`"],
        Annotation[#, 0.6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2728, 3580, 3582, 3581, 3110, 3109, 2643, 3184, 3376, 2524, 
          2545, 2725, 3577, 2726, 3578, 2641, 3574, 2719, 3371, 3372, 3373, 
          2542, 2717, 3572, 2718, 3573, 2640, 3565, 2715, 3366, 3367, 3368, 
          2540, 2713, 3563, 2714, 3564, 2636, 3555, 3556, 3360, 3361, 2515, 
          2537, 3230, 3182, 3183, 3103, 3231, 3557, 2707, 3085, 3086, 3691, 
          2789, 3417, 3418, 3018, 2788, 3695, 2790, 3692, 3694, 3693, 2516, 
          3232, 3222, 3223, 3221, 2703, 2908, 2535, 2982, 2702, 3264, 2787, 
          3139, 3140, 2563, 3271, 3179, 3180, 3151, 2603, 3074, 3079}],
         "0.6`"],
        Annotation[#, 0.6, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{3377, 3088, 2732, 3238, 2727, 3269, 3270, 3266, 3268, 3267, 
          3713, 3705, 3706, 3704, 3708, 3707, 2798, 3775, 3776, 3772, 3774, 
          3773}],
         "0.4`"],
        Annotation[#, 0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{3384, 2533, 3385, 3354, 3099, 3098, 3075, 2601, 3262, 3263, 
          3259, 3261, 3260, 2513, 3050, 3051, 3057, 3056, 2888, 3052, 2734, 
          2935, 3814, 2934, 3078, 3077, 3786, 2887, 3487, 3488, 3489, 2995, 
          2633, 3220, 2701, 3551, 2700, 3286, 3287, 3284, 2852, 3285, 2998, 
          3396, 3395, 3394, 2767, 3845, 3846, 3829, 2925, 2534, 3357, 3101, 
          3100, 3076, 2699, 2937, 2936, 3084, 3083, 3082, 3554, 3553, 3229, 
          3102, 2634, 3181, 3228, 3227, 2536, 2514, 3359, 3358, 2706, 3552, 
          2635, 3560, 2712, 3559, 2711, 2539, 3365, 3364, 3363, 3562, 3561, 
          2639, 3492, 3494, 3493, 3571, 2942, 2523, 3797, 2723, 2909, 2910, 
          3375, 3374, 2724, 3576, 2642, 3497, 3499, 3498, 3579}],
         "0.4`"],
        Annotation[#, 0.4, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2525, 3390, 3389, 3388, 3496, 3495, 2522, 2544, 2721, 3575, 
          2722, 2941, 2940, 3569, 3570, 3491, 2638, 3490, 2637, 2710, 3796, 
          2519, 2538, 2708, 3558, 2709, 2939, 2938, 3225, 2704, 3224, 2705, 
          3226, 2735, 2875, 3804, 2576, 3038, 2850, 2649, 3799, 2564, 3416, 
          3833, 2602, 3461, 3355, 3356, 3386, 3387, 2785, 2786, 2762, 3122, 
          3123, 2552, 2997, 3017, 3291, 2864, 3290, 2865, 3035, 3034, 3036, 
          3037, 3002, 2764, 3303, 3124, 3001, 2763, 3676, 2766, 3674, 2765, 
          3675, 2512, 3191, 3192, 3150, 2599, 3149, 2600, 3485, 3486, 3383, 
          3684, 2532, 3685, 3686, 3642, 2756, 3641, 2757, 3643, 2733, 3014, 
          2780, 3055, 2907, 3687, 2781, 3412, 3413, 3136, 3813, 2759, 3249, 
          3116, 3117, 2994, 3257, 2782, 3256, 2783, 3258, 3414, 3415, 3137, 
          3138, 3118, 3119, 2549, 2996, 3015, 3016, 2889, 3790, 3791, 3787, 
          3789, 3788, 2562, 3767, 3768, 3766, 3770, 3769, 2784, 3688, 3690, 
          3689, 2550, 3000, 2551, 3121, 3120, 3251, 3250, 2900}],
         "0.2`"],
        Annotation[#, 0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2574, 3433, 2873, 3771, 2814, 3031, 2816, 3053, 2815, 3030, 
          2943, 3721, 2821, 3720, 2822, 3722, 2820, 3784, 3785, 3781, 3783, 
          3782}],
         "0.2`"],
        Annotation[#, 0.2, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2485, 3320, 2682, 2928, 2927, 2957, 3006, 3007, 2898, 
          2897}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{2498, 3745, 3747, 3744}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2511, 3670, 3671, 3669, 3673, 3672, 2761, 3667, 3668, 3664, 
          3666, 3665, 2510, 3660, 3661, 3659, 3663, 3662, 2760, 3657, 3658, 
          3654, 3656, 3655, 2509, 3650, 3651, 3649, 3653, 3652, 2758, 3647, 
          3648, 3644, 3646, 3645, 2508, 3637, 3638, 3636, 3640, 3639, 2755, 
          3247, 3248, 3244, 3246, 3245, 2507, 3352, 3353, 3241, 3243, 3242, 
          2754, 3634, 3635, 3631, 3633, 3632, 2506, 3627, 3628, 3626, 3630, 
          3629, 2753, 3624, 3625, 3621, 3623, 3622, 2505, 3617, 3618, 3616, 
          3620, 3619, 2752, 3614, 3615, 3611, 3613, 3612, 2504, 3607, 3608, 
          3606, 3610, 3609, 2751, 3604, 3605, 3601, 3603, 3602, 2503, 3597, 
          3598, 3596, 3600, 3599, 2748, 2750, 3812, 2749, 2502, 2746, 3811, 
          2747, 2743, 2745, 3810, 2744, 2501, 2862, 3823, 2863, 2859, 2861, 
          3822, 2860, 2500, 3483, 3484, 3480, 3482, 3481, 2499, 3478, 3479, 
          3475, 3477, 3476, 2497, 2980, 2981, 2849, 3746, 2848, 2979, 3071, 
          3070}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{2518, 3362, 2605, 3702, 2604}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{2589, 3201, 3200, 3203, 3199}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{2590, 2667, 2661, 2947, 3087}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2593, 3455, 3456, 2882, 3780, 2881, 3300, 2573, 3047, 3048, 
          2872, 2871}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2669, 2670, 2659, 3509, 2660, 3202, 3452, 3297, 2879, 3295, 
          2878, 3296, 2553, 3032, 2895}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2695, 2978, 2929, 3210, 3157, 3158, 3156, 3209, 3208, 3533, 
          2964, 2965, 2686, 3534, 3536, 3535}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{3080, 3081, 2983, 2984, 3701, 3265}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2575, 3434, 3142, 2874, 3294, 2799, 3718, 2818, 3717, 2817, 
          2920, 2919, 3719, 2819, 3453, 3454, 2592, 3004, 2591}],
         RowBox[{"-", "0.2`"}]],
        Annotation[#, -0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2671, 3464, 2613, 3378, 3379, 2527, 2476, 2949, 2482, 3792, 
          2829, 2959, 2958, 3520, 3521, 3469, 2616, 3468, 2617, 2832, 3793, 
          2486, 2961, 2487, 3794, 2836, 2967, 2966, 2837, 3821, 2838, 2687, 
          2845, 3844, 2844, 2973, 2690, 3743, 2846, 3340, 3341, 3342, 2974, 
          2492, 3345, 3166, 2623, 3165, 2624, 3546, 3547, 3545, 2696, 3167, 
          2625, 3093, 3215, 3828, 2529, 3216, 2976, 2977, 2697, 3067, 3068, 
          3550, 3069, 3073, 3072, 2495, 3590, 3591, 3589, 2740, 3592, 2739, 
          3595, 2742, 3593, 2741, 3594, 2496, 3349, 3749, 3748, 2778, 3406, 
          3407, 3408, 3013, 3411, 3410, 3409, 2779, 3683, 3255, 3175, 2629, 
          3095, 2630, 3176, 3350, 3177, 2631, 3097, 2632, 3178, 3351}],
         RowBox[{"-", "0.2`"}]],
        Annotation[#, -0.2, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2477, 3466, 3467, 3465, 2614, 3728, 2828, 3304, 3305, 2950, 
          2672, 3525, 2677, 3522, 3524, 3523, 2952, 3526, 3471, 3472, 3470, 
          2618, 3731, 3732, 3321, 3322, 3323, 2962, 3332, 3331, 3330, 2839, 
          3737, 2688, 3738, 2840, 3333, 3334, 2488, 2968, 2490, 3343, 3160, 
          2619, 3159, 2620, 3541, 3542, 3539, 2691, 3540, 2970, 2971, 2847, 
          3062, 3063, 3064, 2975, 2493, 3169, 3170, 3168, 2626, 3171, 3348, 
          3548, 3549, 3347, 3795, 3346, 2627, 3012, 2905, 2906, 2698, 3172, 
          2628, 3094, 3217, 3380, 2530, 3218, 3173, 3174, 3096, 3219, 3382, 
          2531, 3381}],
         RowBox[{"-", "0.4`"}]],
        Annotation[#, -0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2480, 3312, 3059, 3205, 3204, 2675, 3519, 3254, 2773, 3252, 
          2772, 3253, 3401, 3288, 2854, 3289, 2771, 3003, 2855, 3759, 2856, 
          3760, 2774, 3005, 2554}],
         RowBox[{"-", "0.4`"}]],
        Annotation[#, -0.4, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2484, 3274, 2481, 3061, 3060, 3207, 3206, 2676, 3273, 2811, 
          3272, 2810, 2913, 2912, 3716, 2809, 3448, 3449, 2588, 2956, 3278, 
          3279, 3187, 2645, 3113, 3114, 2924, 2597, 2954, 2896}],
         RowBox[{"-", "0.6`"}]],
        Annotation[#, -0.6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2899, 3302, 2886, 3301, 3473, 3474, 2992, 2993, 2933, 2932, 
          2494, 2930, 2931, 2694, 3214, 2693, 3544, 2972, 3213, 2528, 3798, 
          3212, 3092, 2622, 3211, 2692, 3065, 3344, 3164, 2621, 3161, 3163, 
          3162, 2491, 2969, 2489, 3339, 3338, 3741, 3740, 2689, 3739, 2841, 
          3335, 3336, 3337, 2963, 3329, 3328, 3327, 2834, 3734, 2683, 3733, 
          2833, 3324, 3325, 3326, 2960, 3318, 3317, 3316, 2831, 3730, 2678, 
          3729, 2830, 3313, 3314, 3315, 2951, 2478, 3308, 3091, 3090, 3089, 
          2615, 3516, 3517, 3306, 3307}],
         RowBox[{"-", "0.6`"}]],
        Annotation[#, -0.6, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2555, 3196, 2556, 3132, 3131, 2647, 3193, 2737, 3587, 2738, 
          3588, 2664, 3511, 2665, 3512, 2646, 3188, 3190, 3826, 3189, 3827, 
          2483, 3319, 2479, 3311, 3460, 3459, 2598, 3458, 2594, 3457, 3515, 
          3514, 3451, 3450, 2662, 3510, 2911, 3714, 3715, 3446, 3447, 2587, 
          2955, 3277, 3185, 3186, 3111, 3112, 3500, 3501, 3398, 3399, 3400, 
          2663, 2923, 2596}],
         RowBox[{"-", "0.8`"}]],
        Annotation[#, -0.8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{2914, 2915, 2892, 3825, 2893, 2891, 3011, 3848, 3010, 2991, 
          2561, 3134, 3849, 3135, 3066, 3543, 3281, 3841, 3843, 3842, 2842, 
          3742, 2843, 3282, 2775, 3679, 3680, 3276, 3275, 3283, 3755, 3756, 
          2904, 2903, 3054, 2827, 2990, 2989, 2595, 3147, 3148, 3538, 3537, 
          3280, 3838, 3840, 3839, 2835, 3819, 3820, 3736, 3735, 2826, 3726, 
          2825, 3727, 2884, 3531, 2684, 3530, 2685, 3532, 2681, 3725, 2824, 
          3723, 2823, 3724, 2883, 3528, 2679, 3527, 2680, 3529, 2674, 3678, 
          2770, 3677, 2769, 3757, 3758, 3130, 3397, 3129, 3807, 2673, 3518, 
          3309, 3310, 2953, 3033}],
         RowBox[{"-", "0.8`"}]],
        Annotation[#, -0.8, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{2557, 2946, 2558, 3403, 3402, 2776, 3009, 3008, 2584, 3444, 
          3445, 3392, 3393, 2548, 2945, 2547, 3391, 3115, 3146, 3145, 2583, 
          3041, 3762, 3763, 3761, 3765, 3764, 2805, 3712, 2806, 3027, 3026, 
          3144, 3143, 2876, 2585, 3042, 2857, 2858, 2657, 3198, 3197, 3133, 
          2648, 3194, 3240, 3239, 2812, 3818, 2813, 2777, 3681, 3682, 3404, 
          3405, 2560, 2948, 2559}],
         RowBox[{"-", "1"}]],
        Annotation[#, -1, "Tooltip"]& ]}, {}, {}}}], 
   {RGBColor[
    1, 0, 0], {
     LineBox[{{0., -1.}, {0., -0.5}, {0., 0.}, {0., 0.3333333333333333}, {0., 
      0.6666666666666666}, {0., 1.}}], 
     LineBox[{{0.1, -1.}, {0.1, -0.5}, {0.1, 0.}, {0.1, 0.3333333333333333}, {
      0.1, 0.6666666666666666}, {0.1, 1.}}], 
     LineBox[{{0.25, -1.}, {0.25, -0.5}, {0.25, 0.}, {0.25, 
      0.3333333333333333}, {0.25, 0.6666666666666666}, {0.25, 1.}}], 
     LineBox[{{0.5, -1.}, {0.5, -0.5}, {0.5, 0.}, {0.5, 0.3333333333333333}, {
      0.5, 0.6666666666666666}, {0.5, 1.}}], 
     LineBox[{{1., -1.}, {1., -0.5}, {1., 0.}, {1., 0.3333333333333333}, {1., 
      0.6666666666666666}, {1., 1.}}]}, {
     LineBox[{{0., -1.}, {0.1, -1.}, {0.25, -1.}, {0.5, -1.}, {1., -1.}}], 
     LineBox[{{0., -0.5}, {0.1, -0.5}, {0.25, -0.5}, {0.5, -0.5}, {
      1., -0.5}}], 
     LineBox[{{0., 0.}, {0.1, 0.}, {0.25, 0.}, {0.5, 0.}, {1., 0.}}], 
     LineBox[{{0., 0.3333333333333333}, {0.1, 0.3333333333333333}, {0.25, 
      0.3333333333333333}, {0.5, 0.3333333333333333}, {1., 
      0.3333333333333333}}], 
     LineBox[{{0., 0.6666666666666666}, {0.1, 0.6666666666666666}, {0.25, 
      0.6666666666666666}, {0.5, 0.6666666666666666}, {1., 
      0.6666666666666666}}], 
     LineBox[{{0., 1.}, {0.1, 1.}, {0.25, 1.}, {0.5, 1.}, {1., 1.}}]}}},
  AspectRatio->1,
  Frame->True,
  PlotRange->{{0, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->60647026]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18337],

Cell["\<\
The dimensions of the result are a concatenation of the dimensions of the \
inputs:\
\>", "ExampleText",
 CellID->1278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12393],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWN1OgzAULjDY/GGMXXmzZb6MXvkQZDHZLoxm7qn1Wr1Qgy0wl3x0tgVa
SuMSWHt6en6+c1rac5ftN/cP2X67zla3u+xps10/r24ed5QUeIR4L4SQ6ytC
2zltFQ/7vdKnbJatC/YODqM5Oacvn9TpSUUPgT7TzJ8q8o84/ujwb6bI3xUe
6F9QRBG9PBXVlDObR++afy7Jz/OO8enyD+3SjQf6h32fG01GDWm34B790isd
fvWPskLBOPYjh7SMjWjB/mRAcYusjJsZLXKrLuBoqc062ljt1Uz/mDuCFjBO
zJih6jjTrENGp93xmlgVL906xKsNo8db07wv7eG8FMH4tOf5Scv5yB/3hE/a
cr4ufEVZ5rGX8h7uelYhSijPFD62ZpWpk8G0RsE5Ik9skSnKyCYy22apGWyS
XvDWIVPnLfQS+ig7tkjKtBMpouw1iVs8IPT17L0LTox18ov2Q+Rvu9ep2rs0
jIdcVLF+x7wOqhxhubLIj+cGFfr8BJ1XVW6if9nQLrkqLmtifV69JYqAaxX+
98JrXDfI5VpF/EPKa5srkHZq6ady/CYVTbsrXHbp6KMiWe5EvgT3X5a5XpNA
/s+8i9x3HTXE46sT1Gy5kQ61UiEXhf+bs9xXsZucHtoNsPRahI3pG9J3YRVr
ytw5iPcDXOj14Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{490, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178581365]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28164]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31591],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4", ",", "2", ",", "5"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19949]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", "x", "}"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->19135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "3", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2505]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143425523],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Distribute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Distribute"]], "InlineFormula"],
 " forms the same combinations of all elements, but in a flat structure:"
}], "ExampleText",
 CellID->515193634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "}"}], ",", "List"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->952047024],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "y"}], "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1818716061]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"List", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1501362825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "y"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "y"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "y"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1892721350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->222569284],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["KroneckerProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerProduct"]], "InlineFormula"],
 " is a flattened outer product of matrices:"
}], "ExampleText",
 CellID->203810006],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m2", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->353875149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"kp", "=", 
    RowBox[{"KroneckerProduct", "[", 
     RowBox[{"m1", ",", "m2"}], "]"}]}], ")"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214385227],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtPG0EQXnwPH9g8lGAeihJR5LckVerUFooERZSIUNBRUlI6HRJ/gNIl
JSUlJSUlJeVmX+Pbm5s7zz1sHAAJ383t7O7M7Ox8O3P3bXh88OPn8Phwf7j3
9Wj4++Bw/8/el19H6lGwJIS4VP/fd4S6l+rO/F9Kqa7+b6R/g4uLC2n+RGho
zWvpWP1osu+uXXftuWvirqtEv0iRK14/TS97/TRt5z89PXX9AiOVleLu7m48
HuvbCI1u6GhCmz52rvxTmhfLG5Jc/WeaN4ZVub29xVYZjUaejXNjeXS/WC6P
awPRAaLXWRJXscEaNWOBDZ6enk5OTlIbBPDUmsH4VXMb6FUJieft697zZ8q1
Wm3Ozs6Ugvq2M9G5c3Nzk7CkgZ0ZN5aV9FWP7uDZUFvJXIjT6q02u9ryWb2N
vz88POhbSv+wcJ6Y1Yp9UY+pJXLuph+bmEWPUJ/T2iuNcL7GaTSkV3iz8dNl
pHXSIpddX+XAFlRKNNNDDaT1ny13HbjnibMZ+NdyAW19Io2JS+RsfxH9erkA
vyNJ4zqm1zx+Cs8x3WVJgXcyjQBVYlX7+DOr2ROWhfT+iIXIxdxpaM3Du74/
+hzsw9e5+XmFb4Hn8xeePUzfMJ237ExRjvhhYWuPnqMiyocFbTw9/Z5CpNjc
QyN2pYfoCJdCkT2twzgYd3HfLsFD4R7m4cU5rNkAjbyF6G3EjyXBNNZmWnvM
khpsMnB2BWzelinmgleEHg3YkUgfmxcPAxeVCzAZzkBFuXfftb/3+OpjcZUz
ZnP0o3lnNVsF3CnYhVLm8+x6CIT3Ph2PeVhTT68dRLeDrDiGNcHQJucEvGrF
FZ2OKM2OEYaR4yKezKi1MFBbTcdSvEaQ41J5KmAkxiZKYsxD5fb1MO4jaUl6
R2Pt3pFc9fJOHrZ9ktl8c0emWDc9z1w8zFhULrwTuPVgfOaDOgFgYOTxwYk0
mnhDValeeh2Z57VkDXUOGTZPh/bnrWcViNDl9UQ4EwPdvo7lFeQ2V3y2lWQd
VTvoOUSDuKCdRoKogJuHCFRVOYBIRK7z9Fb83sDM6bJsIURh/6g2Hy/+zaqe
XKG6Uplrha1ZWT0ZPG5dpjhC0X3WbIuKus9bT+bUhwHHA0njOqZ5fv1WT65U
T56TBv9LhbnsXWDd94tvleRiXOagfFjSzsN1qqoM1TNcAZ4gOpJCk6tonDz2
4hHjHAdVya6D303rydR3D2WVrmntPGyeVk/2sTn06A3HB/Trwebz83MGV/rV
ls81Go0eHx+l2/WcOjHk3v5ZicJiG2vu7++vrq70rf9mfzweu2+VXnI92eZN
19fXxHcqyujOLrQF2qz/0jK3OYPVVPlh5ksk/AUaICSOO/UQtc1KMq5dpvJ3
lJ/OtoJMYRZem6IMeMUbnWo3/ZSfGdlcPE/XQ9tCM+8Svai8NJPrZvAIj5DP
YKfnuF1COpDZftKlbz+QdizJPjHetZRnJkguK+1nmc0nN9267MryPNK8S3Hf
2Iqlfxntyxg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->33512290]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"op", "=", 
    RowBox[{"Outer", "[", 
     RowBox[{"Times", ",", "m1", ",", "m2"}], "]"}]}], ")"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->197154692],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWztz20YQhvAiKVmWrcSKkzQuU2T8M+wUzg9IqfFkxi4y8Tgu1KlUqZKl
SpYqWSqdZtyoVMmSpUqVyD1xdx/2gMMjMuyBZkRi75a7e4t7fNiP/P3407s/
/zr+9P7t8YvXH48/vHv/9p8Xr/7+yJqSnSiKPrP/P55H7LpgV+L/c1Gwd/s1
46/JxcVFIf6imZCXy6WSfxPy/f29VImeNvTPhXx6eqr6E+ElFZe3t7fr9dp4
YcJ2u+WXMgoeofxUzl64+Ei9z9T7nnqfW+3Cm7JzEGA3Y+Ku9XkuLyy7XM7A
7kxn6ebmBkdlciG1zs/PlYzehZyVsrAhY6m20rr7YDEltXKhtdlsZGgqK+OL
S+aLzZ2TkxOT1US3Olos8VdXV0YGX5b8yB+3pfUE5ATkBeRsPySKXjl8TEVU
0cI5JuWzszOWMH4ZlzmMr6+v51pb9Q6TO56LlGinc9bgvVfO9uxIAnPFdge2
Ebm5EqvYWesso86nmqLWO1Pee0zS32q1UvHsh8RjyTFGA301sYAmRiJls4vb
+TM7PuZvTsSbeuPIg3qlD7YU2RynckT55CNSWwxvlrOV9NBdM4e4yh1OnY51
GTMyPcO+b9HKT+mYhfE4yPICsjUfUCtTkch2c1buBGeCu3hWyPl8pN4Pa8bH
9efq3uh1sPDIMyc6YycsujeeKN5MViervaxqvJsVNA5Gee6JwrZD4V6U815R
465LI5g2Z2Hbc5PKwTii6pZRvp/lUVQ545vQaxiOW3gy5njtiFMfNkf98X7/
jA2L8x8uf8JmauKpw9r1CDf19vrWpsd3SzSbevr65cW2GEUGe+6Bp1lhIVbA
R2nN2Cn7iCfR5ozQoXAZhUuHy8Qz8HgEsg+doR2MHGUcfVO/izW7nLmxGh2/
bxpr+rC01rexZmrJ+ozW8oQ1J6vjsWqelTXG5PNeY0AfxoySy8vLzWbDL/GZ
W2PM7yw7Poxp28GKcV3UppbT5hl5GBRnP72Wla1RRBOeQV4TxBP2B5DxJA2r
lLq5Kf1UYsezg8YLbWqhbfMgtQzjgeN5DnJbJCntb7dbOT1U9R38VcaCZ2gf
7JhDBGH7QpkXVa2lbeNsoWc+3zviyIcGZXwsOIe1Ac+A5Ui/oON4hT702SYn
LKzVaqW98jMe54hux/uj2zNtR26Xag65dhGzUSNGHYp3QZ0UfO8GjVzmRyaL
X/5M3kl6hzvQHu/u7vjlU7CF9+eQtNKt3liyR8p32Gh/Kdz64q+FwYJ19cPD
IOv/TlqqFc+Ktuxy2N2Uq3Z4FriJXdbVZ42cNCKyn1+z8twydtvsReNjccfK
LrdBw+PjdcfKN7dE6x7ml0fUzPLpJ2qX9Rsvv9wmN18Xv8zPuhja9W6Ze/rp
8zrzaGcQVbdcUrxvorJHz7PmXmkznGsWMaqaZhRFXvtZZz2MqE2ummrW/x/L
jOdCWMW9XV2+O4PQhWXWK+OgMOc9Je/1im78taTJ6tdptSs77GOZk4LGvyhr
tnpimYeOagCW+QH5ym+Rd9ZY1VcJav5e28Qv++Idil/uimbTmv5+3CPFBWsO
BvnfErFCdCXXGMC8VjElesorGhTvXcWl42OZqW8v1/EdTf39sGZXltnGmqkl
P1Gf1/KENSerrlVTnxjSquGzbKvL5VLV3SmWuQs7jE/bGmNqttpXc0W2WsbD
BNbEL+1vYq/Xa/W7noll9kcjZTYBiF9PsJuu8uqwzA/K/n453hmrnTIz9K/D
zLrRiBDPtSYEiezul+eXsf5kxh+zdTUuXpnCbjg3fBXPXcs71Z+Cf7EW2LoQ
7QqHmPkgo3U5YG7sR8JqEmlWtdpe2vFwy9V6JHqoaqCvqgZ6ncPoEmvMhvmd
gTwkq4x344i00q2+OAPf5Xc8nNG+LNz6IWeVY5XvuvrgT+LT8ve40c5/ifCD
FQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{202, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->265645445]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArrayFlatten", "[", "op", "]"}], "===", "kp"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->164191904],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->636372522]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157439562],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " effectively uses an outer product when given lists of parts at multiple \
levels:"
}], "ExampleText",
 CellID->203009253],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Range", "[", "36", "]"}], ",", "6"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"p1", ",", "p2"}], "}"}], "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->229683307],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145359427]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{"p1", ",", "p2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111872586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"36", ",", "36", ",", "36"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->216555559]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Part", "[", 
     RowBox[{"m", ",", "##"}], "]"}], "&"}], ",", "p1", ",", "p2"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->306287791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"36", ",", "36", ",", "36"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->128419421]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->565971575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " can also make a generalized outer product from lists:"
}], "ExampleText",
 CellID->349479004],

Cell[BoxData[{
 RowBox[{
  RowBox[{"l1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l2", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->544851947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x1", ",", "x2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "l1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x2", ",", "l2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35021123],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "c"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "c"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"3", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"3", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"3", ",", "c"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"4", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"4", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"4", ",", "c"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{380, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83286662]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", "l1", ",", "l2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->56843687],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "c"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "c"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"3", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"3", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"3", ",", "c"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"4", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"4", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"4", ",", "c"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{380, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23410000]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13337],

Cell["\<\
If backgrounds are inconsistent, a generalized outer product may not be \
sparse:\
\>", "ExampleText",
 CellID->284604082],

Cell[BoxData[{
 RowBox[{
  RowBox[{"s1", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "^", "i"}], "\[Rule]", "i"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", "1", "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{"{", "4", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->99569705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", "s1", ",", "s2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->196325987],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmt9u0zAUxt0maVe2tSsXaNxVSIingBskuNpDVBPSdoFAY68FrxjixKex
To7jNIu9pvkqtY6P4/j4O/4T/9S7/fPDj5/758f7/e770/73w+P9n923X0+F
KZkpNfurlPp6q4rrvLgqv/rzr/hWl9XVuvhNisLPRZoWaVak8yJ9r0sTqpWr
Nyy/YvmU5W/Mcy6ZfWPsmZXa5deB/Nn29CcpVdow6xdPa7fmadxL3npi7tsK
vZPsvB2qH9q/tz394/l5qeZFWVRZVfnR7WiDvj8jgzJlxXduleu0ChN9qBGp
VmbMlLZ5t2D5zDyj7Z4LXievxm+XtjLTI654IozDpcPuU3wBrUvtYmhdj+45
9SatS42fTUt2sBhJM9HK1UnFu3xayC2mubz6uey0LixMyldfHjnJd11Pimij
ntPbpbPUFzWqjTh1ixOvFytOzdl1JcemQ7RWjftoDe4XC7vWYTQwfw+9Z9pp
+1poZSHoct1L++temm8npy6/j7fDZ8hlL135U2d5p7GcVzuwpCDte1zhrjMr
bbbmqNm2rvD3P/c6cIzmUUf0mWrMTwRhxrW8Rq8s7TrtsOY+eaeU+yvFwz7H
HfMs37sp3xV5nkfIH/OYM4BO+IiGKxq+uUK9WffSv+UMLMx2+1xlr0G8jE5x
dIaxW1GOOnPHc+j8lhy6o6zSxiph5d+19FXSRo9g6SQ25Hjn70vTUHbtUDbk
Os/HsFbgE7PtAvQz1srJR1KM/vnWoiH759697bGsfz8a24e8pqgSlaWVko9u
TYNpLtF+oPMbZqf94iaAD9sjfZBJsL7kDP34K1B3UHe/f32pO9WvNhzQdtB2
0HZQXND2scTptWj74a0JlB2UfVB1Y57aSo3A1iMoDbYeXuNqNIOo+yINon5K
0Yg/Q8DTQ+kLnh535IKij4ui1zs0qLkhvWVlUPKu/oCSv8Q/UHJQ8vFp7aLk
c4cdlJzvVKDk044TKHn9PFDyc1DXdyrj3vf7PyL4+MmM4DPVuMv/aRurCsh4
rXBLHmR83NHwzQ2ev+oVBzBxMPF4THyY/5iDhofqH2j4OdBwFxECHW+j4zyC
vDXQ8j60nKtqv+cpRZNuWkQX9Dye1nHpuTTaQWkFpYTngqaPI04+mt6m8Us5
Ovdp2TteYyW/4Ooh1fWd74bkkVwJe7cW1c7PkwGDs4fXOCZn59rRWy1ILzUB
7n7K0XjNucK9nwYtBocPpayLw8ccw+Dy4bn8kPGUZuFUCD21JflwHKFXs/+n
ZThq\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{429, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->655540600]
}, Open  ]],

Cell[TextData[{
 "You can convert it into a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " by choosing a background:"
}], "ExampleText",
 CellID->625726906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"%", ",", "Automatic", ",", 
   RowBox[{"f", "[", 
    RowBox[{"0", ",", "0"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9950355],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "17", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 17, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "4"}], "}"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"0", ",", "0"}], "]"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->362056995]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9567],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tuples",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tuples"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inner",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inner"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Distribute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Distribute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KroneckerProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22336]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18352],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->20448],

Cell[TextData[ButtonBox["Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NestedLists"]], "Tutorials",
 CellID->13882],

Cell[TextData[ButtonBox["Multiplying Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MultiplyingVectorsAndMatrices"]], "Tutorials",
 CellID->540],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->28315]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->531358881],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->278869321],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->118273531],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->653255177],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->4829500],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->44961126]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Outer"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Outer - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 27.7060686}", "context" -> "System`", 
    "keywords" -> {
     "Cartesian products", "direct products", "direct products of tensors", 
      "dyadic products", "exterior products", "Kronecker products of tensors",
       "levels", "matrices", "outer products", "tensor products", "tensors", 
      "wedge product"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Outer[f, list_1, list_2, ...] gives the generalized outer product of the \
list_i, forming all possible combinations of the lowest-level elements in \
each of them, and feeding them as arguments to f. Outer[f, list_1, list_2, \
..., n] treats as separate elements only sublists at level n in the list_i. \
Outer[f, list_1, list_2, ..., n_1, n_2, ...] treats as separate elements only \
sublists at level n_i in the corresponding list_i. ", "synonyms" -> {}, 
    "title" -> "Outer", "type" -> "Symbol", "uri" -> "ref/Outer"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12770, 438, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->142858627]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 290045, 6185}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3356, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3979, 99, 43, 1, 70, "ObjectName",
 CellID->29458],
Cell[4025, 102, 2932, 94, 70, "Usage",
 CellID->6602]
}, Open  ]],
Cell[CellGroupData[{
Cell[6994, 201, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7472, 218, 474, 18, 70, "Notes",
 CellID->30807],
Cell[7949, 238, 2557, 104, 70, "Notes",
 CellID->4098],
Cell[10509, 344, 421, 16, 70, "Notes",
 CellID->27830],
Cell[10933, 362, 202, 8, 70, "Notes",
 CellID->29292],
Cell[11138, 372, 339, 13, 70, "Notes",
 CellID->14600],
Cell[11480, 387, 681, 24, 70, "Notes",
 CellID->7278],
Cell[12164, 413, 569, 20, 70, "Notes",
 CellID->20799]
}, Closed]],
Cell[CellGroupData[{
Cell[12770, 438, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->142858627],
Cell[CellGroupData[{
Cell[13155, 452, 147, 5, 70, "ExampleSection",
 CellID->53636651],
Cell[CellGroupData[{
Cell[13327, 461, 238, 8, 28, "Input",
 CellID->25828],
Cell[13568, 471, 666, 23, 36, "Output",
 CellID->13851]
}, Open  ]],
Cell[14249, 497, 121, 3, 70, "ExampleDelimiter",
 CellID->26816],
Cell[14373, 502, 64, 1, 70, "ExampleText",
 CellID->24230],
Cell[CellGroupData[{
Cell[14462, 507, 261, 8, 28, "Input",
 CellID->4449],
Cell[14726, 517, 690, 24, 36, "Output",
 CellID->16925]
}, Open  ]],
Cell[15431, 544, 63, 1, 70, "ExampleText",
 CellID->658],
Cell[CellGroupData[{
Cell[15519, 549, 442, 16, 28, "Input",
 CellID->229],
Cell[15964, 567, 1317, 26, 54, "Output",
 Evaluatable->False,
 CellID->91432056]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17330, 599, 216, 7, 70, "ExampleSection",
 CellID->29560],
Cell[CellGroupData[{
Cell[17571, 610, 297, 10, 70, "Input",
 CellID->15147],
Cell[17871, 622, 1358, 26, 70, "Output",
 Evaluatable->False,
 CellID->380129348]
}, Open  ]],
Cell[19244, 651, 120, 3, 70, "ExampleDelimiter",
 CellID->1655],
Cell[19367, 656, 88, 1, 70, "ExampleText",
 CellID->20675],
Cell[CellGroupData[{
Cell[19480, 661, 448, 16, 70, "Input",
 CellID->792],
Cell[19931, 679, 986, 35, 36, "Output",
 CellID->22361]
}, Open  ]],
Cell[20932, 717, 121, 3, 70, "ExampleDelimiter",
 CellID->31754],
Cell[21056, 722, 60, 1, 70, "ExampleText",
 CellID->16398],
Cell[CellGroupData[{
Cell[21141, 727, 454, 16, 70, "Input",
 CellID->23146],
Cell[21598, 745, 1452, 28, 70, "Output",
 Evaluatable->False,
 CellID->935730032]
}, Open  ]],
Cell[23065, 776, 125, 3, 70, "ExampleDelimiter",
 CellID->389892422],
Cell[23193, 781, 262, 9, 70, "ExampleText",
 CellID->288071693],
Cell[23458, 792, 548, 19, 70, "Input",
 CellID->13989861],
Cell[CellGroupData[{
Cell[24031, 815, 140, 4, 70, "Input",
 CellID->363854359],
Cell[24174, 821, 477, 17, 36, "Output",
 CellID->1331049]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24700, 844, 239, 7, 70, "ExampleSection",
 CellID->11521],
Cell[24942, 853, 240, 9, 70, "ExampleText",
 CellID->21188],
Cell[CellGroupData[{
Cell[25207, 866, 248, 8, 70, "Input",
 CellID->19569],
Cell[25458, 876, 680, 23, 36, "Output",
 CellID->8638]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26187, 905, 223, 7, 70, "ExampleSection",
 CellID->15615],
Cell[26413, 914, 62, 1, 70, "ExampleText",
 CellID->147523217],
Cell[CellGroupData[{
Cell[26500, 919, 418, 12, 70, "Input",
 CellID->12570],
Cell[26921, 933, 1400, 40, 88, "Output",
 CellID->905]
}, Open  ]],
Cell[28336, 976, 125, 3, 70, "ExampleDelimiter",
 CellID->440473710],
Cell[28464, 981, 66, 1, 70, "ExampleText",
 CellID->797162593],
Cell[CellGroupData[{
Cell[28555, 986, 311, 10, 70, "Input",
 CellID->259130285],
Cell[28869, 998, 1057, 31, 71, "Output",
 CellID->144709200]
}, Open  ]],
Cell[CellGroupData[{
Cell[29963, 1034, 708, 22, 70, "Input",
 CellID->7516772],
Cell[30674, 1058, 102741, 1688, 70, "Output",
 Evaluatable->False,
 CellID->364195860]
}, Open  ]],
Cell[133430, 2749, 121, 3, 70, "ExampleDelimiter",
 CellID->14161],
Cell[133554, 2754, 69, 1, 70, "ExampleText",
 CellID->158010543],
Cell[CellGroupData[{
Cell[133648, 2759, 606, 21, 70, "Input",
 CellID->30524],
Cell[134257, 2782, 724, 15, 151, "Output",
 CellID->47760599]
}, Open  ]],
Cell[134996, 2800, 121, 3, 70, "ExampleDelimiter",
 CellID->17469],
Cell[135120, 2805, 61, 1, 70, "ExampleText",
 CellID->330],
Cell[CellGroupData[{
Cell[135206, 2810, 374, 11, 70, "Input",
 CellID->31923],
Cell[135583, 2823, 716, 21, 108, "Output",
 CellID->28350]
}, Open  ]],
Cell[136314, 2847, 121, 3, 70, "ExampleDelimiter",
 CellID->14333],
Cell[136438, 2852, 263, 9, 70, "ExampleText",
 CellID->22925],
Cell[136704, 2863, 781, 25, 70, "Input",
 CellID->10910],
Cell[CellGroupData[{
Cell[137510, 2892, 203, 7, 70, "Input",
 CellID->19737],
Cell[137716, 2901, 1659, 31, 70, "Output",
 Evaluatable->False,
 CellID->668034374]
}, Open  ]],
Cell[139390, 2935, 124, 3, 70, "ExampleDelimiter",
 CellID->33932894],
Cell[139517, 2940, 85, 1, 70, "ExampleText",
 CellID->214001783],
Cell[139605, 2943, 457, 15, 70, "Input",
 CellID->556697715],
Cell[CellGroupData[{
Cell[140087, 2962, 280, 10, 70, "Input",
 CellID->175643922],
Cell[140370, 2974, 1290, 35, 109, "Output",
 CellID->361211774]
}, Open  ]],
Cell[141675, 3012, 88, 1, 70, "ExampleText",
 CellID->2575323],
Cell[141766, 3015, 571, 18, 70, "Input",
 CellID->188609118],
Cell[CellGroupData[{
Cell[142362, 3037, 563, 18, 70, "Input",
 CellID->576819646],
Cell[142928, 3057, 9589, 218, 70, "Output",
 CellID->31760862]
}, Open  ]],
Cell[152532, 3278, 62, 1, 70, "ExampleText",
 CellID->38001672],
Cell[CellGroupData[{
Cell[152619, 3283, 513, 17, 70, "Input",
 CellID->91629051],
Cell[153135, 3302, 1712, 56, 75, "Output",
 CellID->181735548]
}, Open  ]],
Cell[154862, 3361, 98, 1, 70, "ExampleText",
 CellID->221253682],
Cell[CellGroupData[{
Cell[154985, 3366, 197, 6, 70, "Input",
 CellID->121706788],
Cell[155185, 3374, 476, 18, 36, "Output",
 CellID->736623881]
}, Open  ]],
Cell[CellGroupData[{
Cell[155698, 3397, 496, 16, 70, "Input",
 CellID->8525817],
Cell[156197, 3415, 106361, 1820, 70, "Output",
 CellID->60647026]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[262607, 5241, 233, 7, 70, "ExampleSection",
 CellID->18337],
Cell[262843, 5250, 129, 4, 70, "ExampleText",
 CellID->1278],
Cell[CellGroupData[{
Cell[262997, 5258, 258, 8, 70, "Input",
 CellID->12393],
Cell[263258, 5268, 899, 19, 70, "Output",
 Evaluatable->False,
 CellID->178581365]
}, Open  ]],
Cell[CellGroupData[{
Cell[264194, 5292, 102, 3, 70, "Input",
 CellID->30714],
Cell[264299, 5297, 199, 7, 36, "Output",
 CellID->28164]
}, Open  ]],
Cell[CellGroupData[{
Cell[264535, 5309, 455, 14, 70, "Input",
 CellID->31591],
Cell[264993, 5325, 219, 7, 36, "Output",
 CellID->19949]
}, Open  ]],
Cell[CellGroupData[{
Cell[265249, 5337, 451, 15, 70, "Input",
 CellID->19135],
Cell[265703, 5354, 228, 7, 36, "Output",
 CellID->2505]
}, Open  ]],
Cell[265946, 5364, 125, 3, 70, "ExampleDelimiter",
 CellID->143425523],
Cell[266074, 5369, 251, 7, 70, "ExampleText",
 CellID->515193634],
Cell[CellGroupData[{
Cell[266350, 5380, 299, 11, 70, "Input",
 CellID->952047024],
Cell[266652, 5393, 539, 19, 36, "Output",
 CellID->1818716061]
}, Open  ]],
Cell[CellGroupData[{
Cell[267228, 5417, 246, 8, 70, "Input",
 CellID->1501362825],
Cell[267477, 5427, 680, 25, 36, "Output",
 CellID->1892721350]
}, Open  ]],
Cell[268172, 5455, 125, 3, 70, "ExampleDelimiter",
 CellID->222569284],
Cell[268300, 5460, 235, 7, 70, "ExampleText",
 CellID->203810006],
Cell[268538, 5469, 593, 21, 70, "Input",
 CellID->353875149],
Cell[CellGroupData[{
Cell[269156, 5494, 231, 8, 70, "Input",
 CellID->214385227],
Cell[269390, 5504, 1760, 33, 70, "Output",
 Evaluatable->False,
 CellID->33512290]
}, Open  ]],
Cell[CellGroupData[{
Cell[271187, 5542, 234, 8, 70, "Input",
 CellID->197154692],
Cell[271424, 5552, 2180, 40, 70, "Output",
 Evaluatable->False,
 CellID->265645445]
}, Open  ]],
Cell[CellGroupData[{
Cell[273641, 5597, 135, 4, 70, "Input",
 CellID->164191904],
Cell[273779, 5603, 161, 5, 36, "Output",
 CellID->636372522]
}, Open  ]],
Cell[273955, 5611, 125, 3, 70, "ExampleDelimiter",
 CellID->157439562],
Cell[274083, 5616, 251, 8, 70, "ExampleText",
 CellID->203009253],
Cell[CellGroupData[{
Cell[274359, 5628, 478, 17, 70, "Input",
 CellID->229683307],
Cell[274840, 5647, 322, 11, 36, "Output",
 CellID->145359427]
}, Open  ]],
Cell[CellGroupData[{
Cell[275199, 5663, 146, 5, 70, "Input",
 CellID->111872586],
Cell[275348, 5670, 394, 13, 36, "Output",
 CellID->216555559]
}, Open  ]],
Cell[CellGroupData[{
Cell[275779, 5688, 218, 8, 70, "Input",
 CellID->306287791],
Cell[276000, 5698, 394, 13, 36, "Output",
 CellID->128419421]
}, Open  ]],
Cell[276409, 5714, 125, 3, 70, "ExampleDelimiter",
 CellID->565971575],
Cell[276537, 5719, 225, 7, 70, "ExampleText",
 CellID->349479004],
Cell[276765, 5728, 313, 11, 70, "Input",
 CellID->544851947],
Cell[CellGroupData[{
Cell[277103, 5743, 291, 10, 70, "Input",
 CellID->35021123],
Cell[277397, 5755, 1155, 39, 54, "Output",
 CellID->83286662]
}, Open  ]],
Cell[CellGroupData[{
Cell[278589, 5799, 135, 4, 70, "Input",
 CellID->56843687],
Cell[278727, 5805, 1155, 39, 54, "Output",
 CellID->23410000]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[279931, 5850, 226, 7, 70, "ExampleSection",
 CellID->13337],
Cell[280160, 5859, 132, 4, 70, "ExampleText",
 CellID->284604082],
Cell[280295, 5865, 548, 19, 70, "Input",
 CellID->99569705],
Cell[CellGroupData[{
Cell[280868, 5888, 136, 4, 70, "Input",
 CellID->196325987],
Cell[281007, 5894, 1497, 29, 70, "Output",
 Evaluatable->False,
 CellID->655540600]
}, Open  ]],
Cell[282519, 5926, 240, 8, 70, "ExampleText",
 CellID->625726906],
Cell[CellGroupData[{
Cell[282784, 5938, 200, 6, 70, "Input",
 CellID->9950355],
Cell[282987, 5946, 547, 19, 36, "Output",
 CellID->362056995]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[283595, 5972, 310, 9, 70, "SeeAlsoSection",
 CellID->9567],
Cell[283908, 5983, 1662, 62, 70, "SeeAlso",
 CellID->22336]
}, Open  ]],
Cell[CellGroupData[{
Cell[285607, 6050, 314, 9, 70, "TutorialsSection",
 CellID->18352],
Cell[285924, 6061, 152, 3, 70, "Tutorials",
 CellID->20448],
Cell[286079, 6066, 134, 3, 70, "Tutorials",
 CellID->13882],
Cell[286216, 6071, 170, 3, 70, "Tutorials",
 CellID->540],
Cell[286389, 6076, 125, 3, 70, "Tutorials",
 CellID->28315]
}, Open  ]],
Cell[CellGroupData[{
Cell[286551, 6084, 319, 9, 70, "MoreAboutSection",
 CellID->531358881],
Cell[286873, 6095, 163, 3, 70, "MoreAbout",
 CellID->278869321],
Cell[287039, 6100, 147, 3, 70, "MoreAbout",
 CellID->118273531],
Cell[287189, 6105, 145, 3, 70, "MoreAbout",
 CellID->653255177],
Cell[287337, 6110, 179, 3, 70, "MoreAbout",
 CellID->4829500],
Cell[287519, 6115, 125, 3, 70, "MoreAbout",
 CellID->44961126]
}, Open  ]],
Cell[CellGroupData[{
Cell[287681, 6123, 305, 8, 70, "RelatedLinksSection"],
Cell[287989, 6133, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[288387, 6149, 50, 0, 70, "History"],
Cell[288440, 6151, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

