(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13448,        477]
NotebookOptionsPosition[     10251,        370]
NotebookOutlinePosition[     11525,        406]
CellTagsIndexPosition[     11440,        401]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup["paclet:tutorial/FilesAndStreams"], 
          "Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Files and Streams\"\>", 
       2->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Streams" :> Documentation`HelpLookup["paclet:ref/Streams"], 
          "InputStream" :> Documentation`HelpLookup["paclet:ref/InputStream"],
           "$Display" :> Documentation`HelpLookup["paclet:ref/$Display"], 
          "$Output" :> Documentation`HelpLookup["paclet:ref/$Output"], 
          "$Echo" :> Documentation`HelpLookup["paclet:ref/$Echo"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Streams\"\>", 
       2->"\<\"InputStream\"\>", 3->"\<\"$Display\"\>", 4->"\<\"$Output\"\>", 
       5->"\<\"$Echo\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OutputStream", "ObjectName",
 CellID->2144],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OutputStream",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OutputStream"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that represents an output stream for \
functions such as ",
     Cell[BoxData[
      ButtonBox["Write",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Write"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16446]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OpenAppend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenAppend"]], "InlineFormula"],
 " return ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->31577],

Cell[TextData[{
 "The serial number ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is unique across all streams, regardless of their name. "
}], "Notes",
 CellID->26517]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59789778],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->234985428],

Cell["List of open streams:", "ExampleText",
 CellID->583204299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Streams", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->799288385],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OutputStream", "[", 
    RowBox[{"\<\"stdout\"\>", ",", "1"}], "]"}], ",", 
   RowBox[{"OutputStream", "[", 
    RowBox[{"\<\"stderr\"\>", ",", "2"}], "]"}]}], "}"}]], "Output",
 ImageSize->{346, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->419492106]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->680798335],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 " opens a new file and returns an ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->384745129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenWrite", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->338121986],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\000002a11852\"\>", ",", "89"}], "]"}]], "Output",
 ImageSize->{576, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->503523544]
}, Open  ]],

Cell["Close the stream:", "ExampleText",
 CellID->1041784417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->836522528],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\000002a11852\"\>"], "Output",
 ImageSize->{452, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->222701210]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15469],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Streams",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Streams"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputStream"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Display",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Display"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Output",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Output"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Echo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Echo"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14629],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreams"]], "Tutorials",
 CellID->478647659],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->11451]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->204276281],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->9444994]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OutputStream - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 34.5343684}", "context" -> "System`", 
    "keywords" -> {"opened file", "stream"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "OutputStream[\"name\", n] is an object that represents an output stream \
for functions such as Write. ", "synonyms" -> {"output stream"}, "title" -> 
    "OutputStream", "type" -> "Symbol", "uri" -> "ref/OutputStream"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4942, 159, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->59789778]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11298, 394}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2344, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2967, 81, 49, 1, 70, "ObjectName",
 CellID->2144],
Cell[3019, 84, 731, 23, 70, "Usage",
 CellID->16446]
}, Open  ]],
Cell[CellGroupData[{
Cell[3787, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4265, 129, 452, 17, 70, "Notes",
 CellID->31577],
Cell[4720, 148, 185, 6, 70, "Notes",
 CellID->26517]
}, Closed]],
Cell[CellGroupData[{
Cell[4942, 159, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59789778],
Cell[CellGroupData[{
Cell[5326, 173, 148, 5, 70, "ExampleSection",
 CellID->234985428],
Cell[5477, 180, 64, 1, 70, "ExampleText",
 CellID->583204299],
Cell[CellGroupData[{
Cell[5566, 185, 98, 3, 28, "Input",
 CellID->799288385],
Cell[5667, 190, 360, 11, 36, "Output",
 CellID->419492106]
}, Open  ]],
Cell[6042, 204, 125, 3, 70, "ExampleDelimiter",
 CellID->680798335],
Cell[6170, 209, 352, 12, 70, "ExampleText",
 CellID->384745129],
Cell[CellGroupData[{
Cell[6547, 225, 100, 3, 70, "Input",
 CellID->338121986],
Cell[6650, 230, 309, 8, 36, "Output",
 CellID->503523544]
}, Open  ]],
Cell[6974, 241, 61, 1, 70, "ExampleText",
 CellID->1041784417],
Cell[CellGroupData[{
Cell[7060, 246, 101, 3, 70, "Input",
 CellID->836522528],
Cell[7164, 251, 247, 6, 36, "Output",
 CellID->222701210]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7472, 264, 311, 9, 70, "SeeAlsoSection",
 CellID->15469],
Cell[7786, 275, 1182, 44, 70, "SeeAlso",
 CellID->22912]
}, Open  ]],
Cell[CellGroupData[{
Cell[9005, 324, 314, 9, 70, "TutorialsSection",
 CellID->14629],
Cell[9322, 335, 147, 3, 70, "Tutorials",
 CellID->478647659],
Cell[9472, 340, 191, 4, 70, "Tutorials",
 CellID->11451]
}, Open  ]],
Cell[CellGroupData[{
Cell[9700, 349, 319, 9, 70, "MoreAboutSection",
 CellID->204276281],
Cell[10022, 360, 157, 3, 70, "MoreAbout",
 CellID->9444994]
}, Open  ]],
Cell[10194, 366, 27, 0, 70, "History"],
Cell[10224, 368, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

