(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12402,        484]
NotebookOptionsPosition[      8812,        360]
NotebookOutlinePosition[     10147,        398]
CellTagsIndexPosition[     10063,        393]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"$MaxNumber" :> 
         Documentation`HelpLookup["paclet:ref/$MaxNumber"], "Underflow" :> 
         Documentation`HelpLookup["paclet:ref/Underflow"], "Indeterminate" :> 
         Documentation`HelpLookup["paclet:ref/Indeterminate"], "Infinity" :> 
         Documentation`HelpLookup["paclet:ref/Infinity"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"$MaxNumber\"\>", 2->"\<\"Underflow\"\>", 
      3->"\<\"Indeterminate\"\>", 4->"\<\"Infinity\"\>"}, "\<\"see also\"\>", 
      
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Overflow", "ObjectName",
 CellID->8896],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Overflow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Overflow"], "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a number too large to represent explicitly \
on your computer system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16367]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->9435028],

Cell[CellGroupData[{

Cell[BoxData["$MaxNumber"], "Input",
 CellLabel->"In[1]:=",
 CellID->39994778],

Cell[BoxData["1.9202246726923565854204690606`15.954589770191005*^646456887"], \
"Output",
 ImageSize->{197, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163526869]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->380312811],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Overflow occurred in computation.\\\
\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/General/ovfl\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->352676844],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21099220]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19447],

Cell[TextData[{
 "Computations with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overflow"], "[", "]"}]], "InlineFormula"],
 " may still resolve to numbers:"
}], "ExampleText",
 CellID->500546591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1.", "/", 
   RowBox[{"(", 
    RowBox[{"2", "-", 
     RowBox[{"Overflow", "[", "]"}]}], ")"}]}], " ", "+", " ", 
  "3."}]], "Input",
 CellLabel->"In[1]:=",
 CellID->546253077],

Cell[BoxData["3.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29685735]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30422],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overflow"], "[", "]"}]], "InlineFormula"],
 " is considered a ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " number:"
}], "ExampleText",
 CellID->438599220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", 
  RowBox[{"Overflow", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251873961],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53009589]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{"Overflow", ",", "_Real"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69988388],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->209301725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119791429],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overflow"], "[", "]"}]], "InlineFormula"],
 " is greater than any explicit number:"
}], "ExampleText",
 CellID->26442867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Overflow", "[", "]"}], ">", " ", "$MaxNumber"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141175608],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179594932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->380479724],

Cell[TextData[{
 "The reciprocal of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overflow"], "[", "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Underflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underflow"], "[", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->81783961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Overflow", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373614905],

Cell[BoxData[
 RowBox[{"Underflow", "[", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90492397]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2187],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Underflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underflow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Indeterminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Indeterminate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6705]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Overflow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 35.4718924}", "context" -> "System`", 
    "keywords" -> {
     "overflow", "overflowing computation", "NaN", "not a number", 
      "representable numbers", "range of representable numbers"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Overflow[] represents a number too large to represent explicitly on your \
computer system.", "synonyms" -> {}, "title" -> "Overflow", "type" -> 
    "Symbol", "uri" -> "ref/Overflow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2086, 69, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9929, 386}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 884, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1507, 46, 45, 1, 70, "ObjectName",
 CellID->8896],
Cell[1555, 49, 494, 15, 70, "Usage",
 CellID->16367]
}, Open  ]],
Cell[CellGroupData[{
Cell[2086, 69, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2463, 83, 146, 5, 70, "ExampleSection",
 CellID->9435028],
Cell[CellGroupData[{
Cell[2634, 92, 78, 2, 28, "Input",
 CellID->39994778],
Cell[2715, 96, 220, 6, 36, "Output",
 CellID->163526869]
}, Open  ]],
Cell[CellGroupData[{
Cell[2972, 107, 87, 3, 70, "Input",
 CellID->380312811],
Cell[3062, 112, 380, 8, 19, "Message",
 CellID->352676844],
Cell[3445, 122, 186, 6, 36, "Output",
 CellID->21099220]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3680, 134, 216, 7, 70, "ExampleSection",
 CellID->19447],
Cell[3899, 143, 256, 9, 70, "ExampleText",
 CellID->500546591],
Cell[CellGroupData[{
Cell[4180, 156, 212, 8, 70, "Input",
 CellID->546253077],
Cell[4395, 166, 159, 5, 36, "Output",
 CellID->29685735]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[4603, 177, 233, 7, 70, "ExampleSection",
 CellID->30422],
Cell[4839, 186, 344, 13, 70, "ExampleText",
 CellID->438599220],
Cell[CellGroupData[{
Cell[5208, 203, 133, 4, 70, "Input",
 CellID->251873961],
Cell[5344, 209, 160, 5, 36, "Output",
 CellID->53009589]
}, Open  ]],
Cell[CellGroupData[{
Cell[5541, 219, 135, 4, 70, "Input",
 CellID->69988388],
Cell[5679, 225, 162, 5, 36, "Output",
 CellID->209301725]
}, Open  ]],
Cell[5856, 233, 125, 3, 70, "ExampleDelimiter",
 CellID->119791429],
Cell[5984, 238, 239, 8, 70, "ExampleText",
 CellID->26442867],
Cell[CellGroupData[{
Cell[6248, 250, 136, 4, 70, "Input",
 CellID->141175608],
Cell[6387, 256, 161, 5, 36, "Output",
 CellID->179594932]
}, Open  ]],
Cell[6563, 264, 125, 3, 70, "ExampleDelimiter",
 CellID->380479724],
Cell[6691, 269, 382, 15, 70, "ExampleText",
 CellID->81783961],
Cell[CellGroupData[{
Cell[7098, 288, 122, 4, 70, "Input",
 CellID->373614905],
Cell[7223, 294, 187, 6, 36, "Output",
 CellID->90492397]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7471, 307, 310, 9, 70, "SeeAlsoSection",
 CellID->2187],
Cell[7784, 318, 956, 35, 70, "SeeAlso",
 CellID->6705]
}, Open  ]],
Cell[8755, 356, 27, 0, 70, "History"],
Cell[8785, 358, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

