(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15536,        576]
NotebookOptionsPosition[     11089,        422]
NotebookOutlinePosition[     12949,        479]
CellTagsIndexPosition[     12839,        473]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Overlaps", "ObjectName",
 CellID->6922],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Overlaps",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Overlaps"]], "InlineFormula"],
     "\[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["StringCases",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["StringCount",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["StringPosition",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
     " that specifies how to treat overlapping substrings. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10635]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Overlaps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Overlaps"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->1643],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "allow no overlaps", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["allow all overlaps", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "allow overlaps starting at different positions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->307617683]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->500221951],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->169558391],

Cell["Allow no overlaps:", "ExampleText",
 CellID->92010693],

Cell[CellGroupData[{

Cell["StringCases[\"abcd\", __, Overlaps -> False]", "Input",
 CellTags->"S2.8.4",
 CellLabel->"In[1]:=",
 CellID->454269301],

Cell[BoxData[
 RowBox[{"{", "\<\"abcd\"\>", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S2.8.4",
 CellLabel->"Out[1]=",
 CellID->89072504]
}, Open  ]],

Cell["Allow all overlaps:", "ExampleText",
 CellID->399850096],

Cell[CellGroupData[{

Cell["StringCases[\"abcd\", __, Overlaps -> All]", "Input",
 CellTags->"S2.8.4",
 CellLabel->"In[2]:=",
 CellID->264059596],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abcd\"\>", ",", "\<\"abc\"\>", ",", "\<\"ab\"\>", 
   ",", "\<\"a\"\>", ",", "\<\"bcd\"\>", ",", "\<\"bc\"\>", ",", "\<\"b\"\>", 
   ",", "\<\"cd\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S2.8.4",
 CellLabel->"Out[2]=",
 CellID->11851096]
}, Open  ]],

Cell["Allow overlaps starting at different positions:", "ExampleText",
 CellID->223640167],

Cell[CellGroupData[{

Cell["StringCases[\"abcd\", __, Overlaps -> True]", "Input",
 CellTags->"S2.8.4",
 CellLabel->"In[3]:=",
 CellID->57027177],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abcd\"\>", ",", "\<\"bcd\"\>", ",", "\<\"cd\"\>", 
   ",", "\<\"d\"\>"}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S2.8.4",
 CellLabel->"Out[3]=",
 CellID->185101914]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24961],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Overlaps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Overlaps"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " by default in ",
 Cell[BoxData["StringCase"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->579753992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcd\>\"", ",", "__"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1973573369],

Cell[BoxData[
 RowBox[{"{", "\<\"abcd\"\>", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1962684868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68607011],

Cell[TextData[{
 "The result from ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " contains positions of overlapping substrings:"
}], "ExampleText",
 CellID->112648960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AABBBAABABBCCCBAAA\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1512908206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "18"}], "}"}]}], "}"}]], "Output",
 ImageSize->{531, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1241837762]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{"Overlaps", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " to obtain positions of nonoverlapping strings:"
}], "ExampleText",
 CellID->479750492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<AABBBAABABBCCCBAAA\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}], ",", 
   RowBox[{"Overlaps", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->173700741],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "17"}], "}"}]}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->958077714]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28888],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->40114543],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->477780072]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Overlaps - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 36.0187814}", "context" -> "System`", 
    "keywords" -> {
     "overlapping strings", "overlapping substrings", "overlaps"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Overlaps is an option to StringCases, StringCount and StringPosition \
that specifies how to treat overlapping substrings. ", "synonyms" -> {}, 
    "title" -> "Overlaps", "type" -> "Symbol", "uri" -> "ref/Overlaps"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4309, 147, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->500221951]},
 "S2.8.4"->{
  Cell[4930, 173, 125, 3, 28, "Input",
   CellTags->"S2.8.4",
   CellID->454269301],
  Cell[5058, 178, 211, 7, 36, "Output",
   CellTags->"S2.8.4",
   CellID->89072504],
  Cell[5371, 193, 123, 3, 28, "Input",
   CellTags->"S2.8.4",
   CellID->264059596],
  Cell[5497, 198, 402, 10, 36, "Output",
   CellTags->"S2.8.4",
   CellID->11851096],
  Cell[6029, 216, 123, 3, 70, "Input",
   CellTags->"S2.8.4",
   CellID->57027177],
  Cell[6155, 221, 287, 9, 36, "Output",
   CellTags->"S2.8.4",
   CellID->185101914]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12171, 447},
 {"S2.8.4", 12304, 451}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1172, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1795, 58, 45, 1, 70, "ObjectName",
 CellID->6922],
Cell[1843, 61, 915, 28, 70, "Usage",
 CellID->10635]
}, Open  ]],
Cell[CellGroupData[{
Cell[2795, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3273, 111, 199, 8, 70, "Notes",
 CellID->1643],
Cell[3475, 121, 797, 21, 70, "2ColumnTableMod",
 CellID->307617683]
}, Closed]],
Cell[CellGroupData[{
Cell[4309, 147, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->500221951],
Cell[CellGroupData[{
Cell[4694, 161, 148, 5, 70, "ExampleSection",
 CellID->169558391],
Cell[4845, 168, 60, 1, 70, "ExampleText",
 CellID->92010693],
Cell[CellGroupData[{
Cell[4930, 173, 125, 3, 28, "Input",
 CellTags->"S2.8.4",
 CellID->454269301],
Cell[5058, 178, 211, 7, 36, "Output",
 CellTags->"S2.8.4",
 CellID->89072504]
}, Open  ]],
Cell[5284, 188, 62, 1, 70, "ExampleText",
 CellID->399850096],
Cell[CellGroupData[{
Cell[5371, 193, 123, 3, 28, "Input",
 CellTags->"S2.8.4",
 CellID->264059596],
Cell[5497, 198, 402, 10, 36, "Output",
 CellTags->"S2.8.4",
 CellID->11851096]
}, Open  ]],
Cell[5914, 211, 90, 1, 70, "ExampleText",
 CellID->223640167],
Cell[CellGroupData[{
Cell[6029, 216, 123, 3, 70, "Input",
 CellTags->"S2.8.4",
 CellID->57027177],
Cell[6155, 221, 287, 9, 36, "Output",
 CellTags->"S2.8.4",
 CellID->185101914]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6491, 236, 216, 7, 70, "ExampleSection",
 CellID->24961],
Cell[6710, 245, 509, 19, 70, "ExampleText",
 CellID->579753992],
Cell[CellGroupData[{
Cell[7244, 268, 143, 4, 70, "Input",
 CellID->1973573369],
Cell[7390, 274, 192, 6, 36, "Output",
 CellID->1962684868]
}, Open  ]],
Cell[7597, 283, 124, 3, 70, "ExampleDelimiter",
 CellID->68607011],
Cell[7724, 288, 256, 8, 70, "ExampleText",
 CellID->112648960],
Cell[CellGroupData[{
Cell[8005, 300, 186, 5, 70, "Input",
 CellID->1512908206],
Cell[8194, 307, 726, 25, 36, "Output",
 CellID->1241837762]
}, Open  ]],
Cell[8935, 335, 261, 9, 70, "ExampleText",
 CellID->479750492],
Cell[CellGroupData[{
Cell[9221, 348, 231, 6, 70, "Input",
 CellID->173700741],
Cell[9455, 356, 544, 19, 36, "Output",
 CellID->958077714]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10060, 382, 314, 9, 70, "TutorialsSection",
 CellID->28888],
Cell[10377, 393, 139, 3, 70, "Tutorials",
 CellID->8153]
}, Open  ]],
Cell[CellGroupData[{
Cell[10553, 401, 318, 9, 70, "MoreAboutSection",
 CellID->40114543],
Cell[10874, 412, 141, 3, 70, "MoreAbout",
 CellID->477780072]
}, Open  ]],
Cell[11030, 418, 29, 0, 70, "History"],
Cell[11062, 420, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

