(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47525,       1668]
NotebookOptionsPosition[     40031,       1408]
NotebookOutlinePosition[     41637,       1449]
CellTagsIndexPosition[     41551,       1444]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rearranging Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/RearrangingLists"], 
          "Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/NestedLists"], 
          "Partitioning and Padding Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningAndPaddingLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rearranging Lists\"\>", 
       2->"\<\"Nested Lists\"\>", 
       3->"\<\"Partitioning and Padding Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PadLeft" :> Documentation`HelpLookup["paclet:ref/PadLeft"], 
          "Join" :> Documentation`HelpLookup["paclet:ref/Join"], "Partition" :> 
          Documentation`HelpLookup["paclet:ref/Partition"], "ListCorrelate" :> 
          Documentation`HelpLookup["paclet:ref/ListCorrelate"], "Riffle" :> 
          Documentation`HelpLookup["paclet:ref/Riffle"], "RotateRight" :> 
          Documentation`HelpLookup["paclet:ref/RotateRight"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PadLeft\"\>", 2->"\<\"Join\"\>", 
       3->"\<\"Partition\"\>", 4->"\<\"ListCorrelate\"\>", 
       5->"\<\"Riffle\"\>", 6->"\<\"RotateRight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ListManipulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Constructing Matrices\"\>", 
       2->"\<\"Rearranging & Restructuring Lists\"\>", 
       3->"\<\"New in 6.0: List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PadRight", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadRight",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadRight"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes a list of length ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " by padding ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with zeros on the right. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadRight",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadRight"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]pads by repeating the element ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadRight",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadRight"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]pads by cyclically repeating the elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadRight",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadRight"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["padding", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]leaves a margin of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " elements of padding on the left. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadRight",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadRight"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes a nested list with length ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at level ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadRight",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadRight"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]pads a ragged array ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with zeros to make it full. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->23188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " always returns a list of length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", except in some special cases where ",
 Cell[BoxData[
  StyleBox["padding", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20178],

Cell[TextData[{
 "With padding ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["s", "TI"]]}], "}"}]], "InlineFormula"],
 " cyclic repetitions of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are effectively laid down and then the list is superimposed on top of \
them, with the first element of the list lying on an occurrence of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->18470,
  ButtonNote->"18470"]
}], "Notes",
 CellID->4042],

Cell[TextData[{
 "A margin of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"], "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      StyleBox["n", "TI"], "-", 
      RowBox[{
       ButtonBox["Length",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Length"], "[", 
       StyleBox["list", "TI"], "]"}]}], ")"}], "/", "2"}], "]"}]], 
  "InlineFormula"],
 " effectively centers ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31357],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " effectively treats ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " as cyclic. "
}], "Notes",
 CellID->23941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    RowBox[{"{", 
     StyleBox["xlist", "TI"], "}"}]}], "]"}]], "InlineFormula"],
 " can be used to repeat an individual element that is itself a list. "
}], "Notes",
 CellID->1847],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"], "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    StyleBox["n", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " repeats the sequence of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as many times as fits in a list of length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7469],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " creates a full array with dimensions ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " even if ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " is ragged. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->27352,
  ButtonNote->"27352"]
}], "Notes",
 CellID->16345],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " pads with ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to make a full array. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->4380],

Cell[TextData[{
 "Negative ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " specify to pad on the left. "
}], "Notes",
 CellID->31913],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["11", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["12", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["21", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " pads by repeating the block of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14964],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " effectively treats ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " as cyclic in every dimension. "
}], "Notes",
 CellID->25710],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["padding", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " uses margin ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " at level ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20061],

Cell[TextData[{
 "The object ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " need not have head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25385],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PadRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadRight"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->20073]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4974299],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->3623344],

Cell[TextData[{
 "Pad with ",
 Cell[BoxData["0"], "InlineFormula"],
 " to make the list be of length 10:"
}], "ExampleText",
 CellID->2244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadRight", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10844],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13049]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14118],

Cell[TextData[{
 "Pad with ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadRight", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "10", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", 
   ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19552]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28773],

Cell[TextData[{
 "Pad by repeating ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->18470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadRight", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "10", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29731],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "x", ",", "y", ",", "z", ",", "x", ",", "y", 
   ",", "z", ",", "x"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7511],

Cell["Leave margin 2 on the left:", "ExampleText",
 CellID->5869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadRight", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "10", ",", "x", ",", "2"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14398],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "x", ",", "a", ",", "b", ",", "c", ",", "x", ",", "x", ",", "x", 
   ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10498]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7103],

Cell[TextData[{
 "Pad to make a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Cross]", "5"}], TraditionalForm]], "InlineMath"],
 " array:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->27352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadRight", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", "c", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25679],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwmACxtgQDkP0fyAJj
k///gTQmyQQkmYEKeHDQTGBVDMwQCkSCRZghHBCTA0SwwvkQhQxcJIgyjtox
Qu0gLvXhSrtDJTXzDhEzaRnLLCTqxGeeAJXMEfxPvVQHsoIDSg+OVDdUYpOQ
m5lgIUimX1BLGm4QjwVqHRhwk2yWAJpreEg2gR/qL/7/uFMeAyMAMnUOsg==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{52, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->191856187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13043],

Cell["Pad to make a full array:", "ExampleText",
 CellID->14522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadRight", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", "f", "}"}]}], "}"}], "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31088],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwqAKxtgQDkP0fyAJj
1f//gTQmycAMoUCAGYi5gVwQzQOlmcDSYBLE/Q8GYFUMrHA+1AgurKKMw8gE
9NDCrpa2bgA5AXdM4YpnTBKknhVqFwuSeUwoPgWR6G7mQOPzEBFitDaHlUCo
MbDA9QMBE9lxx8SA6hYupNjApY8Vzb3ieNSyQO2QojBWYWGCmjoIxgZZuYFE
05BUMcPdzII/RjD0ELKbiQEzr2F3EyJu4fHIAjUYDHigroOoE0AzUwgsyg+1
UQQpJhgYAQxw0js=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{37, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->316830368]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9850],

Cell["Negative length specifications pad on the left:", "ExampleText",
 CellID->17022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadRight", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"-", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "a", 
   ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9492],

Cell["\<\
Lay down repetitions of the padding, then superimpose the original array:\
\>", "ExampleText",
 CellID->5651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadRight", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"aa", ",", "bb"}], "}"}], ",", 
      RowBox[{"{", "cc", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"{", "z", "}"}]}], "}"}]}], "]"}], "//", "TableForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->28580],

Cell[BoxData[
 TagBox[GridBox[{
    {"aa", "bb", "x", "y"},
    {"cc", "z", "z", "z"},
    {"x", "y", "x", "y"},
    {"z", "z", "z", "z"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{70, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->15477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27616],

Cell["Use different margins for rows and columns:", "ExampleText",
 CellID->29876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadRight", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"aa", ",", "bb"}], "}"}], ",", 
      RowBox[{"{", "cc", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"{", "z", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19178],

Cell[BoxData[
 TagBox[GridBox[{
    {"z", "z", "z", "z", "z"},
    {"x", "y", "aa", "bb", "x"},
    {"z", "z", "cc", "z", "z"},
    {"x", "y", "x", "y", "x"},
    {"z", "z", "z", "z", "z"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{85, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->5220]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14615],

Cell[TextData[{
 "Use a head other than ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadRight", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "8", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26798],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}],
   "]"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32179]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16857],

Cell["Put a 1 at the center of a list of 0s:", "ExampleText",
 CellID->2883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadRight", "[", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", "19", ",", "0", ",", "9"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1662],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18902]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28262],

Cell["Lay out an array of tiles:", "ExampleText",
 CellID->19420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"PadRight", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19770],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnT9LI1EUxccMzKS0sNjSMo2wnYXVNtlqSWNjGcKCCy67ZMU0NhY2ptAi
EWxWBAdFsQhIBO20EYR0Nha2+QB+gOx5d82+P85kloUtJu888DnXe+9785vc
kOOdkHyqr69+/lpf/9Koz39s1r+vfmn8mK9+a+JP4UwQBPvq512A4xGO5Gd/
NMJvcw7VHCZJ8lNGMKum8PDwMMNeyPGn21h/JCOYMXZVrt8jUlNYq9UGg4Fy
xeI/Ozt7eXlRh5HYT09PjUZDhcYS7/qHw+HV1ZXOb7ValUpFrw/D8sNAis7H
Yjs7O3r9u7s7bGn5seU4v4TTLUscOF7pVFwJDOUxH6lJTWpSk5rU00BdkxFE
ago3Njb6/T6SglhN4fHx8f39vTqMxL65udna2lKhscS7/tvb2/Pzc53fbrdx
lfT6MCw/DKTofCzW6XT0+r1eD1tafmw5zi/hdMsSB46BDIkrgaEs8aS2qI3K
CEKEqlX+VBjKbW5uTlfo0tISik5XqOtHBaOodb5bwTAsv/sMwGJGBctVwpaW
33gGWJVsPFPTKp/UpCY1qUlN6qJSv3e6LpFjxzn+D5hC+xoae7/VtynXME/f
TrxGrr5NuYZ5+ta8hln6Nr9ySE1qUpOa1KQuFvXEHkWn01lZWdH+tbW1vB5F
u93W/rwehevHZnk9CsOf2aMw/05q33uPpCY1qUlNalIXi7olI4jUpBQoVsW5
BLGawqOjo8vLS3UYiX1xcbG3t6dCY4l3/VAVSZLo/G63C1Wj14dh+WEgRedj
sYODA73+6ekptrT82HKcX8LpliUOHFcyJK4EhrLEZ1IPZQSRmpS2wmOpHp5Y
TeHu7u7i4qI6jMReXl6+vr5WobHEu/5qtQownQ+kx8dHvT4Myw8DKTofi52c
nOj1m80mtrT82HKcX8LpliUOHBUZElcCQ1ni2XskNalJTWpSTwm1n6/XhqYR
hYlrqbURhNLm5qbWVtvb25BLWlu5flBAjul8V3vBsPyudsNihvYKQghBbGn5
De1maTBDY1qaLZ3aqAyPeqSkJjWpSU1qUheLemIHKUWl5HWQJqoQt4OUolLy
OkimSsnqIOWrFEPJie6FytOKEPLw+flZK8qHhweIRK0oXT8UJ8B1vqs4YVh+
V7FiMUNxBiHkL7a0/IZitZSnoawtpfoPFT61PVJSk5rUpCZ1can9fL328+6e
URke9UhJTWpSk5rUpC4WtZ/3uSYq0pR7mnmKdOI9S1eRptzTzFOk5j3NLEXa
yL2naVSGRz1SUpOa1KQmdXGp/Xy99vPu3sQKn9oeKalJTWpSk5rUxaL28z6X
oeQ8ele8URke9UhJTWpSk5rUpC4MNT/7kR1XUpOa1KQmtZfUNRm+fQqin9QT
K3xqe4+kJjWpSU1qUheG+j90Zoy9/ehukZrUpCY1qUldQGrjf/sg7Pf7+P9e
9whSehS9Xi+7h4GztHoU7jeD5vUwsJjxzaDy7hJsmdXDsL4h1Oi1/EWPwk9q
ozI86j2SmtSkJjWpSV0g6m63+9plmXW6Lq69kONPt5MksXbdfzMHM78AAZ7T
4Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->147078141]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25841],

Cell["Pad with an element that is itself a list:", "ExampleText",
 CellID->12686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadRight", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "7", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28888],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}]}], "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3917]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadRight", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "7", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31717],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "v", ",", "u", ",", "v", ",", "u"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1892]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3529],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Join",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Join"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListCorrelate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListCorrelate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Riffle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Riffle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotateRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotateRight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31552]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27504],

Cell[TextData[ButtonBox["Rearranging Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingLists"]], "Tutorials",
 CellID->9462],

Cell[TextData[ButtonBox["Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NestedLists"]], "Tutorials",
 CellID->32703],

Cell[TextData[ButtonBox["Partitioning and Padding Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningAndPaddingLists"]], "Tutorials",
 CellID->28102]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->107801],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->555835000],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->104711295],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->56920764]
}, Open  ]],

Cell["New in 4  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PadRight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 51.0816670}", "context" -> "System`", 
    "keywords" -> {"padding"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PadRight[list, n] makes a list of length n by padding list with zeros on \
the right. PadRight[list, n, x] pads by repeating the element x. \
PadRight[list, n, {x_1, x_2, ...}] pads by cyclically repeating the elements \
x_i. PadRight[list, n, padding, m] leaves a margin of m elements of padding \
on the left. PadRight[list, {n_1, n_2, ...}] makes a nested list with length \
n_i at level i. PadRight[list] pads a ragged array list with zeros to make it \
full. ", "synonyms" -> {"pad right"}, "title" -> "PadRight", "type" -> 
    "Symbol", "uri" -> "ref/PadRight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[20656, 669, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4974299]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 41409, 1437}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2929, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3552, 92, 4192, 83, 70, "ObjectNameGrid"],
Cell[7747, 177, 3655, 118, 70, "Usage",
 CellID->23188]
}, Open  ]],
Cell[CellGroupData[{
Cell[11439, 300, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11917, 317, 575, 21, 70, "Notes",
 CellID->20178],
Cell[12495, 340, 890, 32, 70, "Notes",
 CellID->4042],
Cell[13388, 374, 549, 22, 70, "Notes",
 CellID->31357],
Cell[13940, 398, 398, 15, 70, "Notes",
 CellID->23941],
Cell[14341, 415, 395, 13, 70, "Notes",
 CellID->1847],
Cell[14739, 430, 751, 28, 70, "Notes",
 CellID->7469],
Cell[15493, 460, 985, 37, 70, "Notes",
 CellID->16345],
Cell[16481, 499, 591, 20, 70, "Notes",
 CellID->4380],
Cell[17075, 521, 191, 8, 70, "Notes",
 CellID->31913],
Cell[17269, 531, 1122, 41, 70, "Notes",
 CellID->14964],
Cell[18394, 574, 638, 23, 70, "Notes",
 CellID->25710],
Cell[19035, 599, 993, 38, 70, "Notes",
 CellID->20061],
Cell[20031, 639, 262, 11, 70, "Notes",
 CellID->25385],
Cell[20296, 652, 323, 12, 70, "Notes",
 CellID->20073]
}, Closed]],
Cell[CellGroupData[{
Cell[20656, 669, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4974299],
Cell[CellGroupData[{
Cell[21039, 683, 146, 5, 70, "ExampleSection",
 CellID->3623344],
Cell[21188, 690, 139, 5, 70, "ExampleText",
 CellID->2244],
Cell[CellGroupData[{
Cell[21352, 699, 183, 6, 28, "Input",
 CellID->10844],
Cell[21538, 707, 287, 9, 36, "Output",
 CellID->13049]
}, Open  ]],
Cell[21840, 719, 121, 3, 70, "ExampleDelimiter",
 CellID->14118],
Cell[21964, 724, 107, 5, 70, "ExampleText",
 CellID->24065],
Cell[CellGroupData[{
Cell[22096, 733, 196, 7, 70, "Input",
 CellID->26363],
Cell[22295, 742, 287, 9, 36, "Output",
 CellID->19552]
}, Open  ]],
Cell[22597, 754, 121, 3, 70, "ExampleDelimiter",
 CellID->28773],
Cell[22721, 759, 220, 8, 70, "ExampleText",
 CellID->18470],
Cell[CellGroupData[{
Cell[22966, 771, 252, 8, 70, "Input",
 CellID->29731],
Cell[23221, 781, 286, 9, 36, "Output",
 CellID->6747]
}, Open  ]],
Cell[23522, 793, 120, 3, 70, "ExampleDelimiter",
 CellID->7511],
Cell[23645, 798, 65, 1, 70, "ExampleText",
 CellID->5869],
Cell[CellGroupData[{
Cell[23735, 803, 206, 7, 70, "Input",
 CellID->14398],
Cell[23944, 812, 287, 9, 36, "Output",
 CellID->10498]
}, Open  ]],
Cell[24246, 824, 120, 3, 70, "ExampleDelimiter",
 CellID->7103],
Cell[24369, 829, 223, 8, 70, "ExampleText",
 CellID->27352],
Cell[CellGroupData[{
Cell[24617, 841, 340, 12, 28, "Input",
 CellID->25679],
Cell[24960, 855, 466, 12, 78, "Output",
 Evaluatable->False,
 CellID->191856187]
}, Open  ]],
Cell[25441, 870, 121, 3, 70, "ExampleDelimiter",
 CellID->13043],
Cell[25565, 875, 64, 1, 70, "ExampleText",
 CellID->14522],
Cell[CellGroupData[{
Cell[25654, 880, 333, 11, 28, "Input",
 CellID->31088],
Cell[25990, 893, 543, 13, 78, "Output",
 Evaluatable->False,
 CellID->316830368]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26582, 912, 215, 7, 70, "ExampleSection",
 CellID->9850],
Cell[26800, 921, 86, 1, 70, "ExampleText",
 CellID->17022],
Cell[CellGroupData[{
Cell[26911, 926, 201, 7, 70, "Input",
 CellID->7240],
Cell[27115, 935, 287, 9, 36, "Output",
 CellID->21911]
}, Open  ]],
Cell[27417, 947, 120, 3, 70, "ExampleDelimiter",
 CellID->9492],
Cell[27540, 952, 119, 3, 70, "ExampleText",
 CellID->5651],
Cell[CellGroupData[{
Cell[27684, 959, 488, 18, 70, "Input",
 CellID->28580],
Cell[28175, 979, 612, 19, 92, "Output",
 CellID->15477]
}, Open  ]],
Cell[28802, 1001, 121, 3, 70, "ExampleDelimiter",
 CellID->27616],
Cell[28926, 1006, 82, 1, 70, "ExampleText",
 CellID->29876],
Cell[CellGroupData[{
Cell[29033, 1011, 547, 19, 70, "Input",
 CellID->19178],
Cell[29583, 1032, 662, 20, 108, "Output",
 CellID->5220]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30294, 1058, 239, 7, 70, "ExampleSection",
 CellID->14615],
Cell[30536, 1067, 193, 8, 70, "ExampleText",
 CellID->22348],
Cell[CellGroupData[{
Cell[30754, 1079, 200, 7, 70, "Input",
 CellID->26798],
Cell[30957, 1088, 271, 9, 36, "Output",
 CellID->32179]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31277, 1103, 223, 7, 70, "ExampleSection",
 CellID->16857],
Cell[31503, 1112, 76, 1, 70, "ExampleText",
 CellID->2883],
Cell[CellGroupData[{
Cell[31604, 1117, 167, 5, 70, "Input",
 CellID->1662],
Cell[31774, 1124, 381, 10, 36, "Output",
 CellID->18902]
}, Open  ]],
Cell[32170, 1137, 121, 3, 70, "ExampleDelimiter",
 CellID->28262],
Cell[32294, 1142, 65, 1, 70, "ExampleText",
 CellID->19420],
Cell[CellGroupData[{
Cell[32384, 1147, 593, 19, 70, "Input",
 CellID->19770],
Cell[32980, 1168, 1855, 35, 70, "Output",
 Evaluatable->False,
 CellID->147078141]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34884, 1209, 226, 7, 70, "ExampleSection",
 CellID->25841],
Cell[35113, 1218, 81, 1, 70, "ExampleText",
 CellID->12686],
Cell[CellGroupData[{
Cell[35219, 1223, 267, 9, 70, "Input",
 CellID->28888],
Cell[35489, 1234, 445, 15, 36, "Output",
 CellID->3917]
}, Open  ]],
Cell[CellGroupData[{
Cell[35971, 1254, 241, 8, 70, "Input",
 CellID->31717],
Cell[36215, 1264, 252, 8, 36, "Output",
 CellID->1892]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36528, 1279, 310, 9, 70, "SeeAlsoSection",
 CellID->3529],
Cell[36841, 1290, 1435, 53, 70, "SeeAlso",
 CellID->31552]
}, Open  ]],
Cell[CellGroupData[{
Cell[38313, 1348, 314, 9, 70, "TutorialsSection",
 CellID->27504],
Cell[38630, 1359, 143, 3, 70, "Tutorials",
 CellID->9462],
Cell[38776, 1364, 134, 3, 70, "Tutorials",
 CellID->32703],
Cell[38913, 1369, 168, 3, 70, "Tutorials",
 CellID->28102]
}, Open  ]],
Cell[CellGroupData[{
Cell[39118, 1377, 316, 9, 70, "MoreAboutSection",
 CellID->107801],
Cell[39437, 1388, 153, 3, 70, "MoreAbout",
 CellID->555835000],
Cell[39593, 1393, 177, 3, 70, "MoreAbout",
 CellID->104711295],
Cell[39773, 1398, 163, 3, 70, "MoreAbout",
 CellID->56920764]
}, Open  ]],
Cell[39951, 1404, 50, 0, 70, "History"],
Cell[40004, 1406, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

