(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15334,        536]
NotebookOptionsPosition[     11739,        420]
NotebookOutlinePosition[     13276,        461]
CellTagsIndexPosition[     13191,        456]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/OutputFormatsForNumbers"],
           "Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Output Formats for Numbers\"\>", 
       2->"\<\"Tables and Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TableForm" :> Documentation`HelpLookup["paclet:ref/TableForm"],
           "AccountingForm" :> 
          Documentation`HelpLookup["paclet:ref/AccountingForm"], "NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"], "ScientificForm" :> 
          Documentation`HelpLookup["paclet:ref/ScientificForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TableForm\"\>", 
       2->"\<\"AccountingForm\"\>", 3->"\<\"NumberForm\"\>", 
       4->"\<\"ScientificForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Display of Numbers\"\>", 
       2->"\<\"Mathematical Typesetting\"\>", 
       3->"\<\"Number Digits\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PaddedForm", "ObjectName",
 CellID->27372],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PaddedForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PaddedForm"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with all numbers in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " padded to leave room for a total of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " digits. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PaddedForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PaddedForm"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["n", "TI"], ",", 
          StyleBox["f", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with approximate real numbers having exactly ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " digits to the right of the decimal point. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10293]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 " pads with spaces on the left to leave room for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " digits. "
}], "Notes",
 CellID->3855],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 " pads with zeros on the right in approximate real numbers. "
}], "Notes",
 CellID->6734],

Cell[TextData[{
 "The length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " specified in ",
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 " counts only digits, and not signs, breaks between digits, and so on. "
}], "Notes",
 CellID->9561],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 " takes the same options as ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 ", but with some defaults different. "
}], "Notes",
 CellID->31056],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 " to align columns of numbers. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->298773812]
}], "Notes",
 CellID->27606],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
 CellID->8184]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->223523545],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->143930331],

Cell[TextData[{
 "Display the first 10 digits of a numeric approximation to ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->310837198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"N", "[", "Pi", "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182688219],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\" 3.141592654\"\>",
   3.141592653589793,
   AutoDelete->True],
  PaddedForm[#, 10]& ]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//PaddedForm=",
 CellID->725969321]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->629919901],

Cell["\<\
Display a number with 3 precise digits and 4 digits to the right of the \
decimal:\
\>", "ExampleText",
 CellID->114750236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{"1.23456", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145863617],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\" 1.2300\"\>",
   1.23456,
   AutoDelete->True],
  PaddedForm[#, {3, 4}]& ]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//PaddedForm=",
 CellID->81778073]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30432],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AccountingForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccountingForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScientificForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScientificForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24684]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7075],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->28382],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->603260772]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->160028322],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->327092202],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->134233137],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->136559681]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PaddedForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 44.1596148}", "context" -> "System`", 
    "keywords" -> {
     "alignment of decimal points", "alignment of numbers in columns", 
      "alignment of numbers in tables", "padded formatting", 
      "padded numeric formatting"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PaddedForm[expr, n] prints with all numbers in expr padded to leave room \
for a total of n digits. PaddedForm[expr, {n, f}] prints with approximate \
real numbers having exactly f digits to the right of the decimal point. ", 
    "synonyms" -> {"padded form"}, "title" -> "PaddedForm", "type" -> 
    "Symbol", "uri" -> "ref/PaddedForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6890, 225, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->223523545]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13048, 449}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2529, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3152, 85, 48, 1, 70, "ObjectName",
 CellID->27372],
Cell[3203, 88, 1303, 40, 70, "Usage",
 CellID->10293]
}, Open  ]],
Cell[CellGroupData[{
Cell[4543, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5021, 150, 306, 11, 70, "Notes",
 CellID->3855],
Cell[5330, 163, 229, 7, 70, "Notes",
 CellID->6734],
Cell[5562, 172, 332, 11, 70, "Notes",
 CellID->9561],
Cell[5897, 185, 362, 12, 70, "Notes",
 CellID->31056],
Cell[6262, 199, 305, 11, 70, "Notes",
 CellID->27606],
Cell[6570, 212, 283, 8, 70, "Notes",
 CellID->8184]
}, Closed]],
Cell[CellGroupData[{
Cell[6890, 225, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->223523545],
Cell[CellGroupData[{
Cell[7275, 239, 148, 5, 70, "ExampleSection",
 CellID->143930331],
Cell[7426, 246, 183, 6, 70, "ExampleText",
 CellID->310837198],
Cell[CellGroupData[{
Cell[7634, 256, 160, 5, 28, "Input",
 CellID->182688219],
Cell[7797, 263, 287, 10, 50, "Output",
 CellID->725969321]
}, Open  ]],
Cell[8099, 276, 125, 3, 70, "ExampleDelimiter",
 CellID->629919901],
Cell[8227, 281, 133, 4, 70, "ExampleText",
 CellID->114750236],
Cell[CellGroupData[{
Cell[8385, 289, 184, 6, 70, "Input",
 CellID->145863617],
Cell[8572, 297, 275, 10, 50, "Output",
 CellID->81778073]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8908, 314, 311, 9, 70, "SeeAlsoSection",
 CellID->30432],
Cell[9222, 325, 971, 35, 70, "SeeAlso",
 CellID->24684]
}, Open  ]],
Cell[CellGroupData[{
Cell[10230, 365, 313, 9, 70, "TutorialsSection",
 CellID->7075],
Cell[10546, 376, 160, 3, 70, "Tutorials",
 CellID->28382],
Cell[10709, 381, 151, 3, 70, "Tutorials",
 CellID->603260772]
}, Open  ]],
Cell[CellGroupData[{
Cell[10897, 389, 319, 9, 70, "MoreAboutSection",
 CellID->160028322],
Cell[11219, 400, 146, 3, 70, "MoreAbout",
 CellID->327092202],
Cell[11368, 405, 159, 3, 70, "MoreAbout",
 CellID->134233137],
Cell[11530, 410, 137, 3, 70, "MoreAbout",
 CellID->136559681]
}, Open  ]],
Cell[11682, 416, 27, 0, 70, "History"],
Cell[11712, 418, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

