(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24546,        622]
NotebookOptionsPosition[     21192,        515]
NotebookOutlinePosition[     22919,        563]
CellTagsIndexPosition[     22801,        557]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageBreakAbove" :> 
          Documentation`HelpLookup["paclet:ref/PageBreakAbove"], 
          "GroupPageBreakWithin" :> 
          Documentation`HelpLookup["paclet:ref/GroupPageBreakWithin"], 
          "ShowPageBreaks" :> 
          Documentation`HelpLookup["paclet:ref/ShowPageBreaks"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PageBreakAbove\"\>", 
       2->"\<\"GroupPageBreakWithin\"\>", 
       3->"\<\"ShowPageBreaks\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Page Layout & Printing Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PageLayoutAndPrintingControl"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Page Layout & Printing Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PageBreakWithin", "ObjectName",
 CellID->1443],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PageBreakWithin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PageBreakWithin"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether a page break should be allowed within the cell \
if the notebook that contains the cell is printed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1731]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->62958372],

Cell["\<\
Create a notebook in which page breaks are not allowed to split cells:\
\>", "ExampleText",
 CellID->729095373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{
         RowBox[{"Row", "[", 
          RowBox[{"Riffle", "[", 
           RowBox[{
            RowBox[{"Range", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"100", "n"}], "+", "1"}], ",", 
              RowBox[{
               RowBox[{"100", "n"}], "+", "30"}]}], "]"}], ",", 
            "\"\<\\n\>\""}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
         RowBox[{"PageBreakWithin", "\[Rule]", "False"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"ShowPageBreaks", "\[Rule]", "True"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->297182877],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3VtzVWcZB3AcL7xz+Ap+g1562VGvdcbplc7Y0JFDdToePoAXHdsqWEda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   "], {{0, 0}, {458, 263}}, {0, 255}],
  ImageSize->{458 0.75, 263 0.75},
  PlotRange->{{0, 458}, {0, 263}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->319718546]
}, Open  ]],

Cell[TextData[{
 "Select the second cell and set ",
 Cell[BoxData[
  ButtonBox["PageBreakWithin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageBreakWithin"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->377480554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->505949901],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3V2TFNd5B/BJ5T6lr5B8ilyqklzHVSlfJVUxqCKEk3Ll5QPkwhXZCYpT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   "], {{0, 0}, {458, 290}}, {0, 255}],
  ImageSize->{458 0.75, 290 0.75},
  PlotRange->{{0, 458}, {0, 290}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->109512170]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"NotebookSelection", "[", "nb", "]"}], ",", 
   RowBox[{"PageBreakWithin", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->58208299],

Cell["\<\
Now a page break will occur within the cell, as shown by the mark on the cell \
bracket:\
\>", "ExampleText",
 CellID->7932818],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3VuPVeUZB/Bpet/wEexdE2/8CKbtdU0avWmTAqZAtTFN+wFqYqpSqaSo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   "], {{0, 0}, {458, 296}}, {0, 255}],
  ImageSize->{458 0.75, 296 0.75},
  PlotRange->{{0, 458}, {0, 296}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->187008893]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23967],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageBreakAbove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageBreakAbove"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GroupPageBreakWithin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GroupPageBreakWithin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowPageBreaks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowPageBreaks"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10816]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18154],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->22861]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->267515902],

Cell[TextData[ButtonBox["Page Layout & Printing Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PageLayoutAndPrintingControl"]], "MoreAbout",
 CellID->536336689]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PageBreakWithin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 52.5348292}", "context" -> "System`", 
    "keywords" -> {"set page break", "page break", "pagination"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PageBreakWithin is an option for Cell which specifies whether a page \
break should be allowed within the cell if the notebook that contains the \
cell is printed. ", "synonyms" -> {"page break within"}, "title" -> 
    "PageBreakWithin", "type" -> "Symbol", "uri" -> "ref/PageBreakWithin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3451, 106, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "Notebook Image"->{
  Cell[4974, 161, 3979, 68, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->319718546],
  Cell[9503, 255, 4833, 82, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->109512170],
  Cell[14715, 354, 4272, 73, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->187008893]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22334, 540},
 {"Notebook Image", 22467, 544}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2062, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2685, 79, 52, 1, 70, "ObjectName",
 CellID->1443],
Cell[2740, 82, 674, 19, 70, "Usage",
 CellID->1731]
}, Open  ]],
Cell[CellGroupData[{
Cell[3451, 106, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3828, 120, 147, 5, 70, "ExampleSection",
 CellID->62958372],
Cell[3978, 127, 121, 3, 70, "ExampleText",
 CellID->729095373],
Cell[CellGroupData[{
Cell[4124, 134, 847, 25, 70, "Input",
 CellID->297182877],
Cell[4974, 161, 3979, 68, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->319718546]
}, Open  ]],
Cell[8968, 232, 348, 13, 70, "ExampleText",
 CellID->377480554],
Cell[CellGroupData[{
Cell[9341, 249, 159, 4, 70, "Input",
 CellID->505949901],
Cell[9503, 255, 4833, 82, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->109512170]
}, Open  ]],
Cell[14351, 340, 221, 6, 70, "Input",
 CellID->58208299],
Cell[14575, 348, 137, 4, 70, "ExampleText",
 CellID->7932818],
Cell[14715, 354, 4272, 73, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->187008893]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19036, 433, 311, 9, 70, "SeeAlsoSection",
 CellID->23967],
Cell[19350, 444, 744, 26, 70, "SeeAlso",
 CellID->10816]
}, Open  ]],
Cell[CellGroupData[{
Cell[20131, 475, 314, 9, 70, "TutorialsSection",
 CellID->18154],
Cell[20448, 486, 143, 3, 70, "Tutorials",
 CellID->22861]
}, Open  ]],
Cell[CellGroupData[{
Cell[20628, 494, 319, 9, 70, "MoreAboutSection",
 CellID->267515902],
Cell[20950, 505, 170, 3, 70, "MoreAbout",
 CellID->536336689]
}, Open  ]],
Cell[21135, 511, 27, 0, 70, "History"],
Cell[21165, 513, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

