(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58385,       1639]
NotebookOptionsPosition[     53011,       1456]
NotebookOutlinePosition[     54303,       1493]
CellTagsIndexPosition[     54217,       1488]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CreatePalette" :> 
          Documentation`HelpLookup["paclet:ref/CreatePalette"], 
          "DialogNotebook" :> 
          Documentation`HelpLookup["paclet:ref/DialogNotebook"], 
          "DocumentNotebook" :> 
          Documentation`HelpLookup["paclet:ref/DocumentNotebook"], 
          "NotebookPut" :> 
          Documentation`HelpLookup["paclet:ref/NotebookPut"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CreatePalette\"\>", 
       2->"\<\"DialogNotebook\"\>", 3->"\<\"DocumentNotebook\"\>", 
       4->"\<\"NotebookPut\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Custom Interface Construction\"\>", 2->"\<\"Palettes\"\>", 
       3->"\<\"Stand-Alone Interfaces\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PaletteNotebook", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PaletteNotebook",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PaletteNotebook"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a palette notebook that can be manipulated \
by the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " front end. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19942]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateWindow"]], "InlineFormula"],
 " takes a ",
 Cell[BoxData[
  ButtonBox["PaletteNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaletteNotebook"]], "InlineFormula"],
 " expression and displays it in a separate window."
}], "Notes",
 CellID->261149465],

Cell[TextData[{
 "If generated as output within a notebook, ",
 Cell[BoxData[
  ButtonBox["PaletteNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaletteNotebook"]], "InlineFormula"],
 " displays as an in-cell representation of a palette notebook."
}], "Notes",
 CellID->264608945],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PaletteNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaletteNotebook"]], "InlineFormula"],
 " can take any notebook option."
}], "Notes",
 CellID->208297439]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376247806],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->107669884],

Cell["\<\
Make a palette for applying a square root sign to the selection:\
\>", "ExampleText",
 CellID->391484396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaletteNotebook", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Square root\>\"", ",", 
    RowBox[{"Button", "[", 
     RowBox[{
      SqrtBox["\[Pi]"], ",", 
      RowBox[{"p", "=", 
       RowBox[{"N", "[", 
        SqrtBox["\[Pi]"], "]"}]}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56057613],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        StyleBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         DynamicUpdating->True],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookPut[
            Notebook[{
              Cell["Square root"], 
              Cell[
               BoxData[
                FormBox[
                 ButtonBox[
                  SqrtBox["\[Pi]"], 
                  ButtonFunction :> ($CellContext`p = N[Pi^Rational[1, 2]]), 
                  Appearance -> Automatic, ButtonFrame -> "DialogBox", 
                  Evaluator -> Automatic, Method -> "Preemptive"], 
                 StandardForm]]]}, Active -> True, 
             CellMargins -> {{0, 0}, {0, 0}}, CellOpen -> True, 
             ClosingAutoSave -> False, ImageMargins -> {{0, 0}, {0, 0}}, 
             Magnification -> 1., 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, 
             ShowCellBracket -> False, ShowCellLabel -> False, ShowCellTags -> 
             False, WindowClickSelect -> False, WindowElements -> {}, 
             WindowFloating -> True, WindowFrame -> "Palette", 
             WindowFrameElements -> "CloseBox", 
             WindowMargins -> {{Automatic, 0}, {Automatic, 0}}, WindowSize -> 
             All, WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {
      ItemBox[GridBox[{
         {Cell["Square root"]},
         {Cell[BoxData[
           ButtonBox[
            SqrtBox["\[Pi]"],
            Appearance->Automatic,
            ButtonFrame->"DialogBox",
            ButtonFunction:>($CellContext`p = N[Pi^Rational[1, 2]]),
            Evaluator->Automatic,
            Method->"Preemptive"]]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0, 0.2]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}],
   DefaultBaseStyle->{},
   FrameMargins->5],
  PaletteNotebook[{"Square root", 
    Button[
    Pi^Rational[1, 2], $CellContext`p = N[Pi^Rational[1, 2]]]}]]], "Output",
 ImageSize->{108, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59114834]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74590095],

Cell["Make a palette for listing files in the current directory:", \
"ExampleText",
 CellID->79623556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaletteNotebook", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<File Operations\>\"", ",", 
    RowBox[{"Button", "[", 
     RowBox[{"\"\<List files\>\"", ",", 
      RowBox[{"CreateDocument", "[", 
       RowBox[{"{", 
        RowBox[{"Column", "[", 
         RowBox[{"FileNames", "[", "]"}], "]"}], "}"}], "]"}]}], "]"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->641157802],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        StyleBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         DynamicUpdating->True],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookPut[
            Notebook[{
              Cell["File Operations"], 
              Cell[
               BoxData[
                FormBox[
                 ButtonBox[
                 "\"List files\"", ButtonFunction :> CreateDocument[{
                    Column[
                    FileNames[]]}], Appearance -> Automatic, ButtonFrame -> 
                  "DialogBox", Evaluator -> Automatic, Method -> "Preemptive",
                   ButtonData -> "paclet:ref/List files"], StandardForm]]]}, 
             Active -> True, CellMargins -> {{0, 0}, {0, 0}}, CellOpen -> 
             True, ClosingAutoSave -> False, ImageMargins -> {{0, 0}, {0, 0}},
              Magnification -> 1., 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, 
             ShowCellBracket -> False, ShowCellLabel -> False, ShowCellTags -> 
             False, WindowClickSelect -> False, WindowElements -> {}, 
             WindowFloating -> True, WindowFrame -> "Palette", 
             WindowFrameElements -> "CloseBox", 
             WindowMargins -> {{Automatic, 0}, {Automatic, 0}}, WindowSize -> 
             All, WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {
      ItemBox[GridBox[{
         {Cell["File Operations"]},
         {Cell[BoxData[
           ButtonBox["\<\"List files\"\>",
            Appearance->Automatic,
            ButtonData->"paclet:ref/List files",
            ButtonFrame->"DialogBox",
            ButtonFunction:>CreateDocument[{
               Column[
                FileNames[]]}],
            Evaluator->Automatic,
            Method->"Preemptive"]]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0, 0.2]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}],
   DefaultBaseStyle->{},
   FrameMargins->5],
  PaletteNotebook[{"File Operations", 
    Button["List files", 
     CreateDocument[{
       Column[
        FileNames[]]}]]}]]], "Output",
 ImageSize->{136, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364635814]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->491461611],

Cell["Make a palette with text and graphics:", "ExampleText",
 CellID->320320905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaletteNotebook", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Choose a direction:\>\"", ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Circle", "[", "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Button", "[", "\"\<N\>\"", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Button", "[", "\"\<E\>\"", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Button", "[", "\"\<S\>\"", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{
          RowBox[{"Button", "[", "\"\<W\>\"", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->231238666],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        StyleBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         DynamicUpdating->True],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookPut[
            Notebook[{
              Cell["Choose a direction:"], 
              Cell[
               BoxData[
                FormBox[
                 GraphicsBox[{
                   CircleBox[{0, 0}], 
                   InsetBox[
                    BoxData[
                    FormBox[
                    ButtonBox[
                    "\"N\"", ButtonFunction :> {}, Evaluator -> None, 
                    Appearance -> Automatic, ButtonFrame -> "DialogBox", 
                    Method -> "Preemptive", ButtonData -> "paclet:ref/N"], 
                    TraditionalForm]], {0, 1}], 
                   InsetBox[
                    BoxData[
                    FormBox[
                    ButtonBox[
                    "\"E\"", ButtonFunction :> {}, Evaluator -> None, 
                    Appearance -> Automatic, ButtonFrame -> "DialogBox", 
                    Method -> "Preemptive", ButtonData -> "paclet:ref/E"], 
                    TraditionalForm]], {1, 0}], 
                   InsetBox[
                    BoxData[
                    FormBox[
                    ButtonBox[
                    "\"S\"", ButtonFunction :> {}, Evaluator -> None, 
                    Appearance -> Automatic, ButtonFrame -> "DialogBox", 
                    Method -> "Preemptive", ButtonData -> "paclet:ref/S"], 
                    TraditionalForm]], {0, -1}], 
                   InsetBox[
                    BoxData[
                    FormBox[
                    ButtonBox[
                    "\"W\"", ButtonFunction :> {}, Evaluator -> None, 
                    Appearance -> Automatic, ButtonFrame -> "DialogBox", 
                    Method -> "Preemptive", ButtonData -> "paclet:ref/W"], 
                    TraditionalForm]], {-1, 0}]}, ImageSize -> Tiny], 
                 StandardForm]]]}, Active -> True, 
             CellMargins -> {{0, 0}, {0, 0}}, CellOpen -> True, 
             ClosingAutoSave -> False, ImageMargins -> {{0, 0}, {0, 0}}, 
             Magnification -> 1., 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, 
             ShowCellBracket -> False, ShowCellLabel -> False, ShowCellTags -> 
             False, WindowClickSelect -> False, WindowElements -> {}, 
             WindowFloating -> True, WindowFrame -> "Palette", 
             WindowFrameElements -> "CloseBox", 
             WindowMargins -> {{Automatic, 0}, {Automatic, 0}}, WindowSize -> 
             All, WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {
      ItemBox[GridBox[{
         {Cell["Choose a direction:"]},
         {Cell[BoxData[
           GraphicsBox[{CircleBox[{0, 0}], InsetBox[
              ButtonBox["\<\"N\"\>",
               Appearance->Automatic,
               ButtonData->"paclet:ref/N",
               ButtonFrame->"DialogBox",
               ButtonFunction:>{},
               Evaluator->None,
               Method->"Preemptive"], {0, 1}], InsetBox[
              ButtonBox["\<\"E\"\>",
               Appearance->Automatic,
               ButtonData->"paclet:ref/E",
               ButtonFrame->"DialogBox",
               ButtonFunction:>{},
               Evaluator->None,
               Method->"Preemptive"], {1, 0}], InsetBox[
              ButtonBox["\<\"S\"\>",
               Appearance->Automatic,
               ButtonData->"paclet:ref/S",
               ButtonFrame->"DialogBox",
               ButtonFunction:>{},
               Evaluator->None,
               Method->"Preemptive"], {0, -1}], InsetBox[
              ButtonBox["\<\"W\"\>",
               Appearance->Automatic,
               ButtonData->"paclet:ref/W",
               ButtonFrame->"DialogBox",
               ButtonFunction:>{},
               Evaluator->None,
               Method->"Preemptive"], {-1, 0}]},
            ImageSize->Tiny]]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0, 0.2]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}],
   DefaultBaseStyle->{},
   FrameMargins->5],
  PaletteNotebook[{"Choose a direction:", 
    Graphics[{
      Circle[{0, 0}], 
      Inset[
       Button["N"], {0, 1}], 
      Inset[
       Button["E"], {1, 0}], 
      Inset[
       Button["S"], {0, -1}], 
      Inset[
       Button["W"], {-1, 0}]}, ImageSize -> Tiny]}]]], "Output",
 ImageSize->{164, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41348073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->519075040],

Cell["Make a grid of buttons:", "ExampleText",
 CellID->528199746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaletteNotebook", "[", 
  RowBox[{"{", 
   RowBox[{"Grid", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Button", "[", 
        RowBox[{"#", ",", 
         RowBox[{"NotebookWrite", "[", 
          RowBox[{
           RowBox[{"InputNotebook", "[", "]"}], ",", "#"}], "]"}]}], "]"}], 
       "&"}], ",", 
      RowBox[{"Partition", "[", 
       RowBox[{
        RowBox[{
        "Characters", "[", 
         "\"\<\[UpArrow]\[DownArrow]\[RightArrow]\[LeftArrow]\[DoubleUpArrow]\
\[DoubleDownArrow]\[DoubleRightArrow]\[DoubleLeftArrow]\[UpDownArrow]\
\[LeftRightArrow]\[DoubleUpDownArrow]\[DoubleLeftRightArrow]\>\"", "]"}], ",",
         "4"}], "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}], "]"}], "}"}], "]"}]], "Input",
 ShowSpecialCharacters->True,
 CellLabel->"In[1]:=",
 CellID->361295427],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        StyleBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         DynamicUpdating->True],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookPut[
            Notebook[{
              Cell[
               BoxData[
                FormBox[
                 TagBox[
                  GridBox[{{
                    ButtonBox[
                    "\"\[UpArrow]\"", ButtonFunction :> NotebookWrite[
                    InputNotebook[], "\[UpArrow]"], Appearance -> Automatic, 
                    ButtonFrame -> "DialogBox", Evaluator -> Automatic, 
                    Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[UpArrow]"], 
                    ButtonBox[
                    "\"\[DownArrow]\"", ButtonFunction :> NotebookWrite[
                    InputNotebook[], "\[DownArrow]"], Appearance -> Automatic,
                     ButtonFrame -> "DialogBox", Evaluator -> Automatic, 
                    Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[DownArrow]"], 
                    ButtonBox[
                    "\"\[RightArrow]\"", ButtonFunction :> NotebookWrite[
                    InputNotebook[], "\[RightArrow]"], Appearance -> 
                    Automatic, ButtonFrame -> "DialogBox", Evaluator -> 
                    Automatic, Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[RightArrow]"], 
                    ButtonBox[
                    "\"\[LeftArrow]\"", ButtonFunction :> NotebookWrite[
                    InputNotebook[], "\[LeftArrow]"], Appearance -> Automatic,
                     ButtonFrame -> "DialogBox", Evaluator -> Automatic, 
                    Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[LeftArrow]"]}, {
                    ButtonBox[
                    "\"\[DoubleUpArrow]\"", ButtonFunction :> NotebookWrite[
                    InputNotebook[], "\[DoubleUpArrow]"], Appearance -> 
                    Automatic, ButtonFrame -> "DialogBox", Evaluator -> 
                    Automatic, Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[DoubleUpArrow]"], 
                    ButtonBox[
                    "\"\[DoubleDownArrow]\"", ButtonFunction :> 
                    NotebookWrite[
                    InputNotebook[], "\[DoubleDownArrow]"], Appearance -> 
                    Automatic, ButtonFrame -> "DialogBox", Evaluator -> 
                    Automatic, Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[DoubleDownArrow]"], 
                    ButtonBox[
                    "\"\[DoubleRightArrow]\"", ButtonFunction :> 
                    NotebookWrite[
                    InputNotebook[], "\[DoubleRightArrow]"], Appearance -> 
                    Automatic, ButtonFrame -> "DialogBox", Evaluator -> 
                    Automatic, Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[DoubleRightArrow]"], 
                    ButtonBox[
                    "\"\[DoubleLeftArrow]\"", ButtonFunction :> 
                    NotebookWrite[
                    InputNotebook[], "\[DoubleLeftArrow]"], Appearance -> 
                    Automatic, ButtonFrame -> "DialogBox", Evaluator -> 
                    Automatic, Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[DoubleLeftArrow]"]}, {
                    ButtonBox[
                    "\"\[UpDownArrow]\"", ButtonFunction :> NotebookWrite[
                    InputNotebook[], "\[UpDownArrow]"], Appearance -> 
                    Automatic, ButtonFrame -> "DialogBox", Evaluator -> 
                    Automatic, Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[UpDownArrow]"], 
                    ButtonBox[
                    "\"\[LeftRightArrow]\"", ButtonFunction :> NotebookWrite[
                    InputNotebook[], "\[LeftRightArrow]"], Appearance -> 
                    Automatic, ButtonFrame -> "DialogBox", Evaluator -> 
                    Automatic, Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[LeftRightArrow]"], 
                    ButtonBox[
                    "\"\[DoubleUpDownArrow]\"", ButtonFunction :> 
                    NotebookWrite[
                    InputNotebook[], "\[DoubleUpDownArrow]"], Appearance -> 
                    Automatic, ButtonFrame -> "DialogBox", Evaluator -> 
                    Automatic, Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[DoubleUpDownArrow]"], 
                    ButtonBox[
                    "\"\[DoubleLeftRightArrow]\"", ButtonFunction :> 
                    NotebookWrite[
                    InputNotebook[], "\[DoubleLeftRightArrow]"], Appearance -> 
                    Automatic, ButtonFrame -> "DialogBox", Evaluator -> 
                    Automatic, Method -> "Preemptive", ButtonData -> 
                    "paclet:ref/\[DoubleLeftRightArrow]"]}}], "Grid"], 
                 StandardForm]]]}, Active -> True, 
             CellMargins -> {{0, 0}, {0, 0}}, CellOpen -> True, 
             ClosingAutoSave -> False, ImageMargins -> {{0, 0}, {0, 0}}, 
             Magnification -> 1., 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, 
             ShowCellBracket -> False, ShowCellLabel -> False, ShowCellTags -> 
             False, WindowClickSelect -> False, WindowElements -> {}, 
             WindowFloating -> True, WindowFrame -> "Palette", 
             WindowFrameElements -> "CloseBox", 
             WindowMargins -> {{Automatic, 0}, {Automatic, 0}}, WindowSize -> 
             All, WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {
      ItemBox[GridBox[{
         {Cell[BoxData[
           TagBox[GridBox[{
              {
               ButtonBox["\<\"\[UpArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[UpArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[UpArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"], 
               ButtonBox["\<\"\[DownArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[DownArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[DownArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"], 
               ButtonBox["\<\"\[RightArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[RightArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[RightArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"], 
               ButtonBox["\<\"\[LeftArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[LeftArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[LeftArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"]},
              {
               ButtonBox["\<\"\[DoubleUpArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[DoubleUpArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[DoubleUpArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"], 
               ButtonBox["\<\"\[DoubleDownArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[DoubleDownArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[DoubleDownArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"], 
               ButtonBox["\<\"\[DoubleRightArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[DoubleRightArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[DoubleRightArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"], 
               ButtonBox["\<\"\[DoubleLeftArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[DoubleLeftArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[DoubleLeftArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"]},
              {
               ButtonBox["\<\"\[UpDownArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[UpDownArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[UpDownArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"], 
               ButtonBox["\<\"\[LeftRightArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[LeftRightArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[LeftRightArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"], 
               ButtonBox["\<\"\[DoubleUpDownArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[DoubleUpDownArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[DoubleUpDownArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"], 
               ButtonBox["\<\"\[DoubleLeftRightArrow]\"\>",
                Appearance->Automatic,
                ButtonData->"paclet:ref/\[DoubleLeftRightArrow]",
                ButtonFrame->"DialogBox",
                ButtonFunction:>NotebookWrite[
                  InputNotebook[], "\[DoubleLeftRightArrow]"],
                Evaluator->Automatic,
                Method->"Preemptive"]}
             }],
            "Grid"]]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0, 0.2]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}],
   DefaultBaseStyle->{},
   FrameMargins->5],
  PaletteNotebook[{
    Grid[{{
       Button["\[UpArrow]", 
        NotebookWrite[
         InputNotebook[], "\[UpArrow]"]], 
       Button["\[DownArrow]", 
        NotebookWrite[
         InputNotebook[], "\[DownArrow]"]], 
       Button["\[RightArrow]", 
        NotebookWrite[
         InputNotebook[], "\[RightArrow]"]], 
       Button["\[LeftArrow]", 
        NotebookWrite[
         InputNotebook[], "\[LeftArrow]"]]}, {
       Button["\[DoubleUpArrow]", 
        NotebookWrite[
         InputNotebook[], "\[DoubleUpArrow]"]], 
       Button["\[DoubleDownArrow]", 
        NotebookWrite[
         InputNotebook[], "\[DoubleDownArrow]"]], 
       Button["\[DoubleRightArrow]", 
        NotebookWrite[
         InputNotebook[], "\[DoubleRightArrow]"]], 
       Button["\[DoubleLeftArrow]", 
        NotebookWrite[
         InputNotebook[], "\[DoubleLeftArrow]"]]}, {
       Button["\[UpDownArrow]", 
        NotebookWrite[
         InputNotebook[], "\[UpDownArrow]"]], 
       Button["\[LeftRightArrow]", 
        NotebookWrite[
         InputNotebook[], "\[LeftRightArrow]"]], 
       Button["\[DoubleUpDownArrow]", 
        NotebookWrite[
         InputNotebook[], "\[DoubleUpDownArrow]"]], 
       Button["\[DoubleLeftRightArrow]", 
        NotebookWrite[
         InputNotebook[], "\[DoubleLeftRightArrow]"]]}}]}]]], "Output",
 ImageSize->{133, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337480299]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->98832956],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowElements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->535627080],

Cell["Make a scrolling palette:", "ExampleText",
 CellID->243534950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"PaletteNotebook", "[", 
    RowBox[{
     RowBox[{"Button", "/@", 
      RowBox[{"Range", "[", "40", "]"}]}], ",", 
     RowBox[{"WindowSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Fit", ",", "350"}], "}"}]}], ",", 
     RowBox[{"WindowElements", "\[Rule]", 
      RowBox[{"{", "\"\<VerticalScrollBar\>\"", "}"}]}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75302836],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztndlvG8cdx1X0vchT3/vQP6FvNQK0fSgKtAGKtA8t0FhGLMcN0iJFH1IU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   "], {{0, 0}, {53, 376}}, {0, 255}],
  ImageSize->{53 0.75, 376 0.75},
  PlotRange->{{0, 53}, {0, 376}}]], "NotebookImage",
 CellID->397084422]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowFloating",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4492907],

Cell[TextData[{
 "Set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " to make a palette that can be covered up by other windows:"
}], "ExampleText",
 CellID->44053675],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"PaletteNotebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", "\"\<Do not float\>\"", "]"}], ",", 
       RowBox[{"CancelButton", "[", "]"}]}], "}"}], ",", 
     RowBox[{"WindowFloating", "\[Rule]", "False"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160029109]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->341320068],

Cell[TextData[{
 "Set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " to position a palette in the center of your screen:"
}], "ExampleText",
 CellID->53238020],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"PaletteNotebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", "\"\<Center\>\"", "]"}], ",", 
       RowBox[{"CancelButton", "[", "]"}]}], "}"}], ",", 
     RowBox[{"WindowMargins", "\[Rule]", "Automatic"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269769918]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->931996222],

Cell["\<\
Set the height of a palette to a fixed value while letting the width fit the \
contents:\
\>", "ExampleText",
 CellID->866201194],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"PaletteNotebook", "[", 
    RowBox[{
     RowBox[{"Button", "/@", 
      RowBox[{"Range", "[", "40", "]"}]}], ",", 
     RowBox[{"WindowSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Fit", ",", "350"}], "}"}]}], ",", 
     RowBox[{"WindowElements", "\[Rule]", 
      RowBox[{"{", "\"\<VerticalScrollBar\>\"", "}"}]}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976264736]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowTitle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->217975582],

Cell["Set the title bar text for a palette:", "ExampleText",
 CellID->18901963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"PaletteNotebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", "\"\<Trivial example palette\>\"", "]"}], ",",
        
       RowBox[{"CancelButton", "[", "]"}]}], "}"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<Minipalette\>\""}]}], "]"}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520599730],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmdtTE1ccx5npe8envveh/0SnT20fOp1pnelYH9qZCk4BrWM7dnxop1Mf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   "], {{0, 0}, {116, 58}}, {0, 255}],
  ImageSize->{116 0.75, 58 0.75},
  PlotRange->{{0, 116}, {0, 58}}]], "NotebookImage",
 CellID->427453938]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->582035928],

Cell["\<\
Make a palette to change selected text to upper or lower case:\
\>", "ExampleText",
 CellID->7382880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaletteNotebook", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Button", "[", 
     RowBox[{"\"\<Shout!\>\"", ",", 
      RowBox[{"NotebookWrite", "[", 
       RowBox[{
        RowBox[{"InputNotebook", "[", "]"}], ",", 
        RowBox[{"ToUpperCase", "[", 
         RowBox[{"NotebookRead", "[", 
          RowBox[{"InputNotebook", "[", "]"}], "]"}], "]"}]}], "]"}]}], "]"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"Button", "[", 
     RowBox[{"\"\<Quiet\>\"", ",", 
      RowBox[{"NotebookWrite", "[", 
       RowBox[{
        RowBox[{"InputNotebook", "[", "]"}], ",", 
        RowBox[{"ToLowerCase", "[", 
         RowBox[{"NotebookRead", "[", 
          RowBox[{"InputNotebook", "[", "]"}], "]"}], "]"}]}], "]"}]}], 
     "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->701257175],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        StyleBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         DynamicUpdating->True],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookPut[
            Notebook[{
              Cell[
               BoxData[
                FormBox[
                 ButtonBox["\"Shout!\"", ButtonFunction :> NotebookWrite[
                    InputNotebook[], 
                    ToUpperCase[
                    NotebookRead[
                    InputNotebook[]]]], Appearance -> Automatic, ButtonFrame -> 
                  "DialogBox", Evaluator -> Automatic, Method -> "Preemptive",
                   ButtonData -> "paclet:ref/Shout!"], StandardForm]]], 
              Cell[
               BoxData[
                FormBox[
                 ButtonBox["\"Quiet\"", ButtonFunction :> NotebookWrite[
                    InputNotebook[], 
                    ToLowerCase[
                    NotebookRead[
                    InputNotebook[]]]], Appearance -> Automatic, ButtonFrame -> 
                  "DialogBox", Evaluator -> Automatic, Method -> "Preemptive",
                   ButtonData -> "paclet:ref/Quiet"], StandardForm]]]}, 
             Active -> True, CellMargins -> {{0, 0}, {0, 0}}, CellOpen -> 
             True, ClosingAutoSave -> False, ImageMargins -> {{0, 0}, {0, 0}},
              Magnification -> 1., 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, 
             ShowCellBracket -> False, ShowCellLabel -> False, ShowCellTags -> 
             False, WindowClickSelect -> False, WindowElements -> {}, 
             WindowFloating -> True, WindowFrame -> "Palette", 
             WindowFrameElements -> "CloseBox", 
             WindowMargins -> {{Automatic, 0}, {Automatic, 0}}, WindowSize -> 
             All, WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {
      ItemBox[GridBox[{
         {Cell[BoxData[
           ButtonBox["\<\"Shout!\"\>",
            Appearance->Automatic,
            ButtonData->"paclet:ref/Shout!",
            ButtonFrame->"DialogBox",
            ButtonFunction:>NotebookWrite[
              InputNotebook[], 
              ToUpperCase[
               NotebookRead[
                InputNotebook[]]]],
            Evaluator->Automatic,
            Method->"Preemptive"]]]},
         {Cell[BoxData[
           ButtonBox["\<\"Quiet\"\>",
            Appearance->Automatic,
            ButtonData->"paclet:ref/Quiet",
            ButtonFrame->"DialogBox",
            ButtonFunction:>NotebookWrite[
              InputNotebook[], 
              ToLowerCase[
               NotebookRead[
                InputNotebook[]]]],
            Evaluator->Automatic,
            Method->"Preemptive"]]]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0, 0.2]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}],
   DefaultBaseStyle->{},
   FrameMargins->5],
  PaletteNotebook[{
    Button["Shout!", 
     NotebookWrite[
      InputNotebook[], 
      ToUpperCase[
       NotebookRead[
        InputNotebook[]]]]], 
    Button["Quiet", 
     NotebookWrite[
      InputNotebook[], 
      ToLowerCase[
       NotebookRead[
        InputNotebook[]]]]]}]]], "Output",
 ImageSize->{72, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->500885980]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25367],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreatePalette",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreatePalette"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DocumentNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DocumentNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookPut",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPut"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5385]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->132071919],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->170965983],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->77573104],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->2499747]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PaletteNotebook - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 58.2068494}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PaletteNotebook[{cell_1, cell_2, ...}] represents a palette notebook \
that can be manipulated by the Mathematica front end. ", 
    "synonyms" -> {"palette notebook"}, "title" -> "PaletteNotebook", "type" -> 
    "Symbol", "uri" -> "ref/PaletteNotebook"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6348, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->376247806]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 54074, 1481}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1853, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2476, 70, 1580, 37, 70, "ObjectNameGrid"],
Cell[4059, 109, 848, 27, 70, "Usage",
 CellID->19942]
}, Open  ]],
Cell[CellGroupData[{
Cell[4944, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5422, 158, 375, 12, 70, "Notes",
 CellID->261149465],
Cell[5800, 172, 293, 8, 70, "Notes",
 CellID->264608945],
Cell[6096, 182, 215, 7, 70, "Notes",
 CellID->208297439]
}, Closed]],
Cell[CellGroupData[{
Cell[6348, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376247806],
Cell[CellGroupData[{
Cell[6733, 208, 148, 5, 70, "ExampleSection",
 CellID->107669884],
Cell[6884, 215, 115, 3, 70, "ExampleText",
 CellID->391484396],
Cell[CellGroupData[{
Cell[7024, 222, 338, 11, 36, "Input",
 CellID->56057613],
Cell[7365, 235, 2642, 70, 108, "Output",
 CellID->59114834]
}, Open  ]],
Cell[10022, 308, 124, 3, 70, "ExampleDelimiter",
 CellID->74590095],
Cell[10149, 313, 102, 2, 70, "ExampleText",
 CellID->79623556],
Cell[CellGroupData[{
Cell[10276, 319, 412, 12, 70, "Input",
 CellID->641157802],
Cell[10691, 333, 2780, 74, 70, "Output",
 CellID->364635814]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13520, 413, 220, 7, 70, "ExampleSection",
 CellID->491461611],
Cell[13743, 422, 81, 1, 70, "ExampleText",
 CellID->320320905],
Cell[CellGroupData[{
Cell[13849, 427, 1189, 34, 70, "Input",
 CellID->231238666],
Cell[15041, 463, 5131, 130, 70, "Output",
 CellID->41348073]
}, Open  ]],
Cell[20187, 596, 125, 3, 70, "ExampleDelimiter",
 CellID->519075040],
Cell[20315, 601, 66, 1, 70, "ExampleText",
 CellID->528199746],
Cell[CellGroupData[{
Cell[20406, 606, 852, 24, 70, "Input",
 CellID->361295427],
Cell[21261, 632, 12542, 272, 70, "Output",
 CellID->337480299]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33852, 910, 221, 7, 70, "ExampleSection",
 CellID->98832956],
Cell[CellGroupData[{
Cell[34098, 921, 235, 7, 70, "ExampleSubsection",
 CellID->535627080],
Cell[34336, 930, 68, 1, 70, "ExampleText",
 CellID->243534950],
Cell[CellGroupData[{
Cell[34429, 935, 471, 14, 70, "Input",
 CellID->75302836],
Cell[34903, 951, 4504, 76, 70, "NotebookImage",
 CellID->397084422]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[39456, 1033, 233, 7, 70, "ExampleSubsection",
 CellID->4492907],
Cell[39692, 1042, 241, 8, 70, "ExampleText",
 CellID->44053675],
Cell[39936, 1052, 397, 12, 70, "Input",
 CellID->160029109]
}, Closed]],
Cell[CellGroupData[{
Cell[40370, 1069, 234, 7, 70, "ExampleSubsection",
 CellID->341320068],
Cell[40607, 1078, 242, 8, 70, "ExampleText",
 CellID->53238020],
Cell[40852, 1088, 394, 12, 70, "Input",
 CellID->269769918]
}, Closed]],
Cell[CellGroupData[{
Cell[41283, 1105, 231, 7, 70, "ExampleSubsection",
 CellID->931996222],
Cell[41517, 1114, 139, 4, 70, "ExampleText",
 CellID->866201194],
Cell[41659, 1120, 472, 14, 70, "Input",
 CellID->976264736]
}, Closed]],
Cell[CellGroupData[{
Cell[42168, 1139, 232, 7, 70, "ExampleSubsection",
 CellID->217975582],
Cell[42403, 1148, 79, 1, 70, "ExampleText",
 CellID->18901963],
Cell[CellGroupData[{
Cell[42507, 1153, 428, 13, 70, "Input",
 CellID->520599730],
Cell[42938, 1168, 2694, 46, 70, "NotebookImage",
 CellID->427453938]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[45693, 1221, 227, 7, 70, "ExampleSection",
 CellID->582035928],
Cell[45923, 1230, 111, 3, 70, "ExampleText",
 CellID->7382880],
Cell[CellGroupData[{
Cell[46059, 1237, 831, 23, 70, "Input",
 CellID->701257175],
Cell[46893, 1262, 3875, 105, 70, "Output",
 CellID->500885980]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50829, 1374, 311, 9, 70, "SeeAlsoSection",
 CellID->25367],
Cell[51143, 1385, 984, 35, 70, "SeeAlso",
 CellID->5385]
}, Open  ]],
Cell[CellGroupData[{
Cell[52164, 1425, 319, 9, 70, "MoreAboutSection",
 CellID->132071919],
Cell[52486, 1436, 168, 3, 70, "MoreAbout",
 CellID->170965983],
Cell[52657, 1441, 127, 3, 70, "MoreAbout",
 CellID->77573104],
Cell[52787, 1446, 152, 3, 70, "MoreAbout",
 CellID->2499747]
}, Open  ]],
Cell[52954, 1452, 27, 0, 70, "History"],
Cell[52984, 1454, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

