(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46168,       1332]
NotebookOptionsPosition[     42296,       1203]
NotebookOutlinePosition[     43665,       1241]
CellTagsIndexPosition[     43579,       1236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inset" :> Documentation`HelpLookup["paclet:ref/Inset"], 
          "Panel" :> Documentation`HelpLookup["paclet:ref/Panel"], "Item" :> 
          Documentation`HelpLookup["paclet:ref/Item"], "Framed" :> 
          Documentation`HelpLookup["paclet:ref/Framed"], "InputField" :> 
          Documentation`HelpLookup["paclet:ref/InputField"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"], "PaneSelector" :> 
          Documentation`HelpLookup["paclet:ref/PaneSelector"], "LocatorPane" :> 
          Documentation`HelpLookup["paclet:ref/LocatorPane"], "ClickPane" :> 
          Documentation`HelpLookup["paclet:ref/ClickPane"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Inset\"\>", 2->"\<\"Panel\"\>", 
       3->"\<\"Item\"\>", 4->"\<\"Framed\"\>", 5->"\<\"InputField\"\>", 
       6->"\<\"Style\"\>", 7->"\<\"PaneSelector\"\>", 
       8->"\<\"LocatorPane\"\>", 9->"\<\"ClickPane\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       2->"\<\"New in 6.0: Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Pane", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Pane",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Pane"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays as a pane containing ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Pane",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Pane"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["w", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes the pane be ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " printer's points wide, line\[Hyphen]wrapping the contents if \
necessary."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Pane",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Pane"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["w", "TI"], ",", 
          StyleBox["h", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes the pane be ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " points wide, and ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " points high, shrinking the contents if necessary."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6231]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->31920],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[
    "how to align objects in the display area ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what to align with a surrounding text baseline", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the pane", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins to add outside the display area", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed pane ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSizeAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSizeAction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what to do if the content size does not match the image size", 
     "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->10106],

Cell[TextData[{
 "With a typical default stylesheet, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " with no additional options displays exactly like ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19271],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["w", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["ImageSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageSize"], "->", 
     StyleBox["w", "TI"]}], ",", 
    RowBox[{
     ButtonBox["ImageSizeAction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageSizeAction"], "->", "\"\<Clip\>\""}]}], 
   "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24319428],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["w", "TI"], ",", 
      StyleBox["h", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["ImageSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageSize"], "->", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["w", "TI"], ",", 
       StyleBox["h", "TI"]}], "}"}]}], ",", 
    RowBox[{
     ButtonBox["ImageSizeAction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageSizeAction"], "->", 
     "\"\<ResizeToFit\>\""}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3962866],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<Pane\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->342945741],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->266696795],

Cell["Wrap at a 200 point width:", "ExampleText",
 CellID->611405479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pane", "[", 
  RowBox[{
   RowBox[{"50", "!"}], ",", "200"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->619457709],

Cell[BoxData[
 PaneBox["30414093201713378043612608166064768844377641568960512000000000000",
  ImageSize->{200, Automatic}]], "Output",
 ImageSize->{204, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117508020]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pane", "[", 
  RowBox[{
   RowBox[{"Range", "[", "50", "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10189],

Cell[BoxData[
 PaneBox[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
    ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", 
    "15", ",", "16", ",", "17", ",", "18", ",", "19", ",", "20", ",", "21", 
    ",", "22", ",", "23", ",", "24", ",", "25", ",", "26", ",", "27", ",", 
    "28", ",", "29", ",", "30", ",", "31", ",", "32", ",", "33", ",", "34", 
    ",", "35", ",", "36", ",", "37", ",", "38", ",", "39", ",", "40", ",", 
    "41", ",", "42", ",", "43", ",", "44", ",", "45", ",", "46", ",", "47", 
    ",", "48", ",", "49", ",", "50"}], "}"}],
  ImageSize->{100, 100}]], "Output",
 ImageSize->{104, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11156]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2097],

Cell[TextData[{
 "Force fixed width lines in a ",
 Cell[BoxData[
  ButtonBox["SlideView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SlideView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->395622592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SlideView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Pane", "[", 
     RowBox[{
      RowBox[{"Factor", "[", 
       RowBox[{
        RowBox[{"x", "^", "n"}], "-", "1"}], "]"}], ",", "200"}], "]"}], ",", 
    
    RowBox[{"{", 
     RowBox[{"n", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->381829079],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = 1}, 
   InterpretationBox[
    StyleBox[
     PanelBox[
      TagBox[GridBox[{
         {
          TagBox[GridBox[{
             {
              TagBox[GridBox[{
                 {
                  TooltipBox[
                   ButtonBox[
                    StyleBox["\<\"\[FirstPage]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    
                    ButtonFunction:>If[
                    BoxForm`var$$ =!= 1, BoxForm`var$$ = 1],
                    Enabled->True,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                   "\"First Slide\""], 
                  TooltipBox[
                   ButtonBox[
                    StyleBox["\<\"\[LeftPointer]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    ButtonFunction:>If[BoxForm`var$$ > 1, 
                    PreDecrement[BoxForm`var$$]],
                    Enabled->True,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                   "\"Previous Slide\""], 
                  TooltipBox[
                   ButtonBox[
                    StyleBox["\<\"\[RightPointer]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    ButtonFunction:>If[BoxForm`var$$ < 20, 
                    PreIncrement[BoxForm`var$$]],
                    Enabled->True,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                   "\"Next Slide\""], 
                  TooltipBox[
                   ButtonBox[
                    StyleBox["\<\"\[LastPage]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    
                    ButtonFunction:>If[
                    BoxForm`var$$ =!= 20, BoxForm`var$$ = 20],
                    Enabled->True,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                   "\"Last Slide\""]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.]}, 
                    Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
               "Grid"]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}}],
           "Grid"]},
         {
          ItemBox[
           StyleBox[Cell[BoxData[
             PaneSelectorBox[{1->
              PaneBox[
               RowBox[{
                RowBox[{"-", "1"}], "+", "x"}],
               ImageSize->{200, Automatic}], 2->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x"}], ")"}]}],
               ImageSize->{200, Automatic}], 3->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"]}], ")"}]}],
               ImageSize->{200, Automatic}], 4->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"]}], ")"}]}],
               ImageSize->{200, Automatic}], 5->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"]}], ")"}]}],
               ImageSize->{200, Automatic}], 6->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "x", "+", 
                  SuperscriptBox["x", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"]}], ")"}]}],
               ImageSize->{200, Automatic}], 7->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"], "+", 
                  SuperscriptBox["x", "5"], "+", 
                  SuperscriptBox["x", "6"]}], ")"}]}],
               ImageSize->{200, Automatic}], 8->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "4"]}], ")"}]}],
               ImageSize->{200, Automatic}], 9->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "6"]}], ")"}]}],
               ImageSize->{200, Automatic}], 10->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "x", "+", 
                  SuperscriptBox["x", "2"], "-", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"]}], ")"}]}],
               ImageSize->{200, Automatic}], 11->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"], "+", 
                  SuperscriptBox["x", "5"], "+", 
                  SuperscriptBox["x", "6"], "+", 
                  SuperscriptBox["x", "7"], "+", 
                  SuperscriptBox["x", "8"], "+", 
                  SuperscriptBox["x", "9"], "+", 
                  SuperscriptBox["x", "10"]}], ")"}]}],
               ImageSize->{200, Automatic}], 12->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "x", "+", 
                  SuperscriptBox["x", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "4"]}], ")"}]}],
               ImageSize->{200, Automatic}], 13->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"], "+", 
                  SuperscriptBox["x", "5"], "+", 
                  SuperscriptBox["x", "6"], "+", 
                  SuperscriptBox["x", "7"], "+", 
                  SuperscriptBox["x", "8"], "+", 
                  SuperscriptBox["x", "9"], "+", 
                  SuperscriptBox["x", "10"], "+", 
                  SuperscriptBox["x", "11"], "+", 
                  SuperscriptBox["x", "12"]}], ")"}]}],
               ImageSize->{200, Automatic}], 14->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "x", "+", 
                  SuperscriptBox["x", "2"], "-", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"], "-", 
                  SuperscriptBox["x", "5"], "+", 
                  SuperscriptBox["x", "6"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"], "+", 
                  SuperscriptBox["x", "5"], "+", 
                  SuperscriptBox["x", "6"]}], ")"}]}],
               ImageSize->{200, Automatic}], 15->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "x", "+", 
                  SuperscriptBox["x", "3"], "-", 
                  SuperscriptBox["x", "4"], "+", 
                  SuperscriptBox["x", "5"], "-", 
                  SuperscriptBox["x", "7"], "+", 
                  SuperscriptBox["x", "8"]}], ")"}]}],
               ImageSize->{200, Automatic}], 16->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "4"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "8"]}], ")"}]}],
               ImageSize->{200, Automatic}], 17->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"], "+", 
                  SuperscriptBox["x", "5"], "+", 
                  SuperscriptBox["x", "6"], "+", 
                  SuperscriptBox["x", "7"], "+", 
                  SuperscriptBox["x", "8"], "+", 
                  SuperscriptBox["x", "9"], "+", 
                  SuperscriptBox["x", "10"], "+", 
                  SuperscriptBox["x", "11"], "+", 
                  SuperscriptBox["x", "12"], "+", 
                  SuperscriptBox["x", "13"], "+", 
                  SuperscriptBox["x", "14"], "+", 
                  SuperscriptBox["x", "15"], "+", 
                  SuperscriptBox["x", "16"]}], ")"}]}],
               ImageSize->{200, Automatic}], 18->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "x", "+", 
                  SuperscriptBox["x", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "6"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "6"]}], ")"}]}],
               ImageSize->{200, Automatic}], 19->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"], "+", 
                  SuperscriptBox["x", "5"], "+", 
                  SuperscriptBox["x", "6"], "+", 
                  SuperscriptBox["x", "7"], "+", 
                  SuperscriptBox["x", "8"], "+", 
                  SuperscriptBox["x", "9"], "+", 
                  SuperscriptBox["x", "10"], "+", 
                  SuperscriptBox["x", "11"], "+", 
                  SuperscriptBox["x", "12"], "+", 
                  SuperscriptBox["x", "13"], "+", 
                  SuperscriptBox["x", "14"], "+", 
                  SuperscriptBox["x", "15"], "+", 
                  SuperscriptBox["x", "16"], "+", 
                  SuperscriptBox["x", "17"], "+", 
                  SuperscriptBox["x", "18"]}], ")"}]}],
               ImageSize->{200, Automatic}], 20->
              PaneBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "x", "+", 
                  SuperscriptBox["x", "2"], "-", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "3"], "+", 
                  SuperscriptBox["x", "4"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["x", "4"], "-", 
                  SuperscriptBox["x", "6"], "+", 
                  SuperscriptBox["x", "8"]}], ")"}]}],
               ImageSize->{200, Automatic}]}, Dynamic[BoxForm`var$$],
              ImageSize->All]]],
            Deployed->True,
            StripOnInput->False],
           Background->Automatic,
           Frame->True,
           FrameStyle->GrayLevel[0.823529411764706],
           StripOnInput->False]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
           "RowsIndexed" -> {}}],
       "Grid"],
      BaseStyle->"SlideView",
      FrameMargins->Automatic,
      ImageMargins->Automatic],
     Deployed->True,
     StripOnInput->False],
    SlideView[{
      Pane[-1 + $CellContext`x, 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x), 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x + $CellContext`x^2), 
       200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x) (1 + $CellContext`x^2), 
       200], 
      Pane[(-1 + $CellContext`x) (
        1 + $CellContext`x + $CellContext`x^2 + $CellContext`x^3 + \
$CellContext`x^4), 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x) (
        1 - $CellContext`x + $CellContext`x^2) (
        1 + $CellContext`x + $CellContext`x^2), 200], 
      Pane[(-1 + $CellContext`x) (
        1 + $CellContext`x + $CellContext`x^2 + $CellContext`x^3 + \
$CellContext`x^4 + $CellContext`x^5 + $CellContext`x^6), 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x) (1 + $CellContext`x^2) (
        1 + $CellContext`x^4), 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x + $CellContext`x^2) (
        1 + $CellContext`x^3 + $CellContext`x^6), 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x) (
        1 - $CellContext`x + $CellContext`x^2 - $CellContext`x^3 + \
$CellContext`x^4) (
        1 + $CellContext`x + $CellContext`x^2 + $CellContext`x^3 + \
$CellContext`x^4), 200], 
      Pane[(-1 + $CellContext`x) (
        1 + $CellContext`x + $CellContext`x^2 + $CellContext`x^3 + \
$CellContext`x^4 + $CellContext`x^5 + $CellContext`x^6 + $CellContext`x^7 + \
$CellContext`x^8 + $CellContext`x^9 + $CellContext`x^10), 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x) (1 + $CellContext`x^2) (
        1 - $CellContext`x + $CellContext`x^2) (
        1 + $CellContext`x + $CellContext`x^2) (
        1 - $CellContext`x^2 + $CellContext`x^4), 200], 
      Pane[(-1 + $CellContext`x) (
        1 + $CellContext`x + $CellContext`x^2 + $CellContext`x^3 + \
$CellContext`x^4 + $CellContext`x^5 + $CellContext`x^6 + $CellContext`x^7 + \
$CellContext`x^8 + $CellContext`x^9 + $CellContext`x^10 + $CellContext`x^11 + \
$CellContext`x^12), 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x) (
        1 - $CellContext`x + $CellContext`x^2 - $CellContext`x^3 + \
$CellContext`x^4 - $CellContext`x^5 + $CellContext`x^6) (
        1 + $CellContext`x + $CellContext`x^2 + $CellContext`x^3 + \
$CellContext`x^4 + $CellContext`x^5 + $CellContext`x^6), 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x + $CellContext`x^2) (
        1 + $CellContext`x + $CellContext`x^2 + $CellContext`x^3 + \
$CellContext`x^4) (
        1 - $CellContext`x + $CellContext`x^3 - $CellContext`x^4 + \
$CellContext`x^5 - $CellContext`x^7 + $CellContext`x^8), 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x) (1 + $CellContext`x^2) (
        1 + $CellContext`x^4) (1 + $CellContext`x^8), 200], 
      Pane[(-1 + $CellContext`x) (
        1 + $CellContext`x + $CellContext`x^2 + $CellContext`x^3 + \
$CellContext`x^4 + $CellContext`x^5 + $CellContext`x^6 + $CellContext`x^7 + \
$CellContext`x^8 + $CellContext`x^9 + $CellContext`x^10 + $CellContext`x^11 + \
$CellContext`x^12 + $CellContext`x^13 + $CellContext`x^14 + $CellContext`x^15 + \
$CellContext`x^16), 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x) (
        1 - $CellContext`x + $CellContext`x^2) (
        1 + $CellContext`x + $CellContext`x^2) (
        1 - $CellContext`x^3 + $CellContext`x^6) (
        1 + $CellContext`x^3 + $CellContext`x^6), 200], 
      Pane[(-1 + $CellContext`x) (
        1 + $CellContext`x + $CellContext`x^2 + $CellContext`x^3 + \
$CellContext`x^4 + $CellContext`x^5 + $CellContext`x^6 + $CellContext`x^7 + \
$CellContext`x^8 + $CellContext`x^9 + $CellContext`x^10 + $CellContext`x^11 + \
$CellContext`x^12 + $CellContext`x^13 + $CellContext`x^14 + $CellContext`x^15 + \
$CellContext`x^16 + $CellContext`x^17 + $CellContext`x^18), 200], 
      Pane[(-1 + $CellContext`x) (1 + $CellContext`x) (1 + $CellContext`x^2) (
        1 - $CellContext`x + $CellContext`x^2 - $CellContext`x^3 + \
$CellContext`x^4) (
        1 + $CellContext`x + $CellContext`x^2 + $CellContext`x^3 + \
$CellContext`x^4) (
        1 - $CellContext`x^2 + $CellContext`x^4 - $CellContext`x^6 + \
$CellContext`x^8), 200]}]],
   DynamicModuleValues:>{}],
  Setting]], "Output",
 ImageSize->{236, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393437534]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11836],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Pane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pane"]], "InlineFormula"],
 " is treated as an unbroken rectangular region for purposes of line \
breaking:"
}], "ExampleText",
 CellID->10591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Pane", "[", 
    RowBox[{"100", "!"}], "]"}], ",", 
   RowBox[{"Pane", "[", 
    RowBox[{
     RowBox[{"100", "!"}], ",", "400"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13406],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PaneBox[
    "9332621544394415268169923885626670049071596826438162146859296389521759999\
322991560894146397615651828625369792082722375825118521091686400000000000000000\
0000000"], ",", 
   PaneBox[
    "9332621544394415268169923885626670049071596826438162146859296389521759999\
322991560894146397615651828625369792082722375825118521091686400000000000000000\
0000000",
    ImageSize->{400, Automatic}]}], "}"}]], "Output",
 ImageSize->{590, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3742844]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9647],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Panel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Panel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Item",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Item"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Framed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Framed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputField"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaneSelector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaneSelector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClickPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClickPane"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4982]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Pane",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Pane"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->88727962],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->74375756]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pane - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 6, 6.1133018}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Pane[expr] displays as a pane containing expr. Pane[expr, w] makes the \
pane be w printer's points wide, line-wrapping the contents if necessary. \
Pane[expr, {w, h}] makes the pane be w points wide, and h points high, \
shrinking the contents if necessary.", "synonyms" -> {}, "title" -> "Pane", 
    "type" -> "Symbol", "uri" -> "ref/Pane"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11371, 349, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->342945741]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 43435, 1229}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2218, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2841, 73, 1569, 37, 70, "ObjectNameGrid"],
Cell[4413, 112, 1647, 53, 70, "Usage",
 CellID->6231]
}, Open  ]],
Cell[CellGroupData[{
Cell[6097, 170, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6575, 187, 69, 1, 70, "Notes",
 CellID->31920],
Cell[6647, 190, 2260, 59, 70, "3ColumnTableMod",
 CellID->10106],
Cell[8910, 251, 369, 13, 70, "Notes",
 CellID->19271],
Cell[9282, 266, 771, 29, 70, "Notes",
 CellID->24319428],
Cell[10056, 297, 934, 35, 70, "Notes",
 CellID->3962866],
Cell[10993, 334, 341, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[11371, 349, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->342945741],
Cell[CellGroupData[{
Cell[11756, 363, 148, 5, 70, "ExampleSection",
 CellID->266696795],
Cell[11907, 370, 69, 1, 70, "ExampleText",
 CellID->611405479],
Cell[CellGroupData[{
Cell[12001, 375, 145, 5, 28, "Input",
 CellID->619457709],
Cell[12149, 382, 265, 7, 72, "Output",
 CellID->117508020]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12463, 395, 216, 7, 70, "ExampleSection",
 CellID->18706],
Cell[CellGroupData[{
Cell[12704, 406, 246, 8, 70, "Input",
 CellID->10189],
Cell[12953, 416, 799, 17, 124, "Output",
 CellID->11156]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13801, 439, 222, 7, 70, "ExampleSection",
 CellID->2097],
Cell[14026, 448, 214, 8, 70, "ExampleText",
 CellID->395622592],
Cell[CellGroupData[{
Cell[14265, 460, 373, 13, 70, "Input",
 CellID->381829079],
Cell[14641, 475, 22242, 518, 70, "Output",
 CellID->393437534]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36932, 999, 233, 7, 70, "ExampleSection",
 CellID->11836],
Cell[37168, 1008, 250, 9, 70, "ExampleText",
 CellID->10591],
Cell[CellGroupData[{
Cell[37443, 1021, 247, 9, 70, "Input",
 CellID->13406],
Cell[37693, 1032, 594, 16, 144, "Output",
 CellID->3742844]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38348, 1055, 310, 9, 70, "SeeAlsoSection",
 CellID->9647],
Cell[38661, 1066, 2155, 80, 70, "SeeAlso",
 CellID->4982]
}, Open  ]],
Cell[CellGroupData[{
Cell[40853, 1151, 305, 8, 70, "RelatedLinksSection"],
Cell[41161, 1161, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41546, 1177, 299, 8, 70, "MoreAboutSection"],
Cell[41848, 1187, 203, 4, 70, "MoreAbout",
 CellID->88727962],
Cell[42054, 1193, 170, 3, 70, "MoreAbout",
 CellID->74375756]
}, Open  ]],
Cell[42239, 1199, 27, 0, 70, "History"],
Cell[42269, 1201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

