(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   2047289,      39136]
NotebookOptionsPosition[   2002040,      37566]
NotebookOutlinePosition[   2003916,      37611]
CellTagsIndexPosition[   2003827,      37606]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Parametric Plots" :> 
          Documentation`HelpLookup["paclet:tutorial/ParametricPlots"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Parametric Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolarPlot" :> Documentation`HelpLookup["paclet:ref/PolarPlot"],
           "ContourPlot" :> 
          Documentation`HelpLookup["paclet:ref/ContourPlot"], "RegionPlot" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot"], "Plot" :> 
          Documentation`HelpLookup["paclet:ref/Plot"], "ParametricPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot3D"], "Graphics" :> 
          Documentation`HelpLookup["paclet:ref/Graphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolarPlot\"\>", 
       2->"\<\"ContourPlot\"\>", 3->"\<\"RegionPlot\"\>", 4->"\<\"Plot\"\>", 
       5->"\<\"ParametricPlot3D\"\>", 
       6->"\<\"Graphics\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Function Visualization\"\>", 
       2->"\<\"New in 6.0: Function Visualization\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ParametricPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParametricPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParametricPlot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a parametric plot of a curve with ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " coordinates ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["x", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["y", "TI"]]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParametricPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParametricPlot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["x", "TI"]], ",", 
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["y", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["g", "TI"], 
             StyleBox["x", "TI"]], ",", 
            SubscriptBox[
             StyleBox["g", "TI"], 
             StyleBox["y", "TI"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several parametric curves. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParametricPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParametricPlot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["v", "TI"], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots a parametric region. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParametricPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParametricPlot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["x", "TI"]], ",", 
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["y", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["g", "TI"], 
             StyleBox["x", "TI"]], ",", 
            SubscriptBox[
             StyleBox["g", "TI"], 
             StyleBox["y", "TI"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["v", "TI"], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several parametric regions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->32106]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " treats the variables ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " as local, effectively using ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24696],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and evaluates the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "i"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 " only after assigning specific numerical values to variables."
}], "Notes",
 CellID->8833],

Cell[TextData[{
 "In some cases it may be more efficient to use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to evaluate the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "i"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 " symbolically before specific numerical values are assigned to variables."
}], "Notes",
 CellID->7611],

Cell[TextData[{
 "No curve is drawn in any regions where the corresponding ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "i"], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 " evaluate to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->41],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->19067],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "ratio of height to width ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["BoundaryStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoundaryStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw boundaries of regions ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to apply coloring to curves or regions ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale arguments to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate at every function evaluation", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     Cell[BoxData[
      FormBox["u", TraditionalForm]], "InlineMath"],
     " points or ",
     Cell[BoxData[
      FormBox["u", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " curves to exclude"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ExclusionsStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExclusionsStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what to draw at excluded points or curves", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to put a frame around the plot ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MaxRecursion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxRecursion"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of recursive subdivisions allowed ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how many mesh divisions to draw ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshFunctions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine the placement of mesh divisions ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshShading",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshShading"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to shade regions between mesh points or lines ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for mesh divisions ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for refining curves or regions ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PerformanceGoal"], 
    ButtonBox["$PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$PerformanceGoal"], Cell[
    "aspects of performance to try to optimize", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "initial number of sample points in each parameter ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "range of values to include", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRangeClipping",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangeClipping"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to clip at the plot range ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives to specify the style for each object ", 
     "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["RegionFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionFunction"], 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], "&"}], ")"}], Cell[
    "how to determine whether a point should be included", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->415],

Cell[TextData[{
 "Interactive labeling can be specified for curves and regions using ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6645],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParametricPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot"], "[", 
   RowBox[{
    ButtonBox["Tooltip",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tooltip"], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["f", "TI"], 
          StyleBox["x", "TI"]], ",", 
         SubscriptBox[
          StyleBox["f", "TI"], 
          StyleBox["y", "TI"]]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["x", "TI"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["y", "TI"]]}], "}"}]], "InlineFormula"],
 " should be displayed as tooltip labels for the corresponding curves or \
regions. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->30175],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], ",", 
    StyleBox["label", "TI"]}], "]"}]], "InlineFormula"],
 " specifies an explicit tooltip label for a curve or region. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6354],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " initially evaluates each function at a number of equally spaced sample \
points specified by ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 ". Then it uses an adaptive algorithm to choose additional sample points, \
subdividing a given interval in each parameter at most ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " times. "
}], "Notes",
 CellID->23448],

Cell[TextData[{
 "You should realize that with the finite number of sample points used, it is \
possible for ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " to miss features in your functions. To check your results, you should try \
increasing the settings for ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24919],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   RowBox[{"ParametricPlot", "::", 
    StyleBox["accbend", "TI"]}], "]"}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " print a message if it is unable to reach a certain smoothness of curve."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->40938333],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " corresponds to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " for curves, and ",
 Cell[BoxData["15"], "InlineFormula"],
 " for regions. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->13079],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " will explicitly draw a point at each sample point on each curve, or will \
draw a line to indicate each region subdivision. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->27988],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MeshFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshFunctions"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " corresponds to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"#3", "&"}], "}"}]], "InlineFormula"],
 " for curves, and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"#3", "&"}], ",", 
    RowBox[{"#4", "&"}]}], "}"}]], "InlineFormula"],
 " for regions. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26321],

Cell[TextData[{
 "The arguments supplied to functions in ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ". Functions in ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " are by default supplied with scaled versions of these arguments. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->7592],

Cell["\<\
The functions are evaluated all along each curve, or all over each region. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->31597],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    ButtonBox["Line",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Line"], "[", 
    StyleBox["data", "TI"], "]"}], "]"}]], "InlineFormula"],
 " for curves and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    StyleBox["data", "TI"], "]"}], "]"}]], "InlineFormula"],
 " for regions. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->13509]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->65893694],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->84708305],

Cell["Plot a parametric curve:", "ExampleText",
 CellID->1320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "u", "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "u"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32036],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57356278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4912],

Cell["Plot a parametric region:", "ExampleText",
 CellID->1915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"r", "^", "2"}], 
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", "t", "]"}], 
       RowBox[{"Cos", "[", "t", "]"}]}], ",", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"3", 
      RowBox[{"Pi", "/", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23953],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVfXl0ldd177XupAFhPCQeMrlpkqZNmg6rSZoO76VJkyzX9Uvs1s9JsJM6
tlc9JHZiMITBAjFIICTQhNAAGpCEJBAakJAQIBCzmbEBYyUkLvWznb7WL6/1
yuryW+3i/c75nW+f8537XUl+q++PesmX+9373e/ss+e9zz773PvI/Cce/8Ej
85989JG7vvbcIz984slH59311Wefw0fxG2Kx2DX8f+D2GN5fxzv9/7Xr1/Gv
+/ppvObgq99UV3F1j/4v9jG8JHD56+b7T5jrOfpXn1KvCXt3LPZJ7/cfd67x
Gvtoxi8+4d3BJwfjxJL8WG6P3WW+yTH/fsT8m/BG/rWMkX7Du+PGLHPwIfJx
cte0s54tT46bb6NwO9PnfNr79DccWoR/n4ndj2d8Qvz+tnlGFL3U5x8z/wZj
3XTd55jMV4XPlxXCYrneU33aJL3r9DTX/vP+o+//zzZeHC83zAjTd3jXvgx8
YpqRPjjN/YUCiQaK72I5EdeK5ooRi9THyZ/+5J/On3uDf6Mjr8ZSLc1nYvEl
i8eefWYIf7Fc9TLFuPnmabFYyvnGv1Zvn1MvqXfeeZeDdXacx1ClJRNxNULy
K1/e/F//tIF/D83tjsUff6wvFl+0cE/5usP4iyXUS7yn66WhwVfwF0url3jH
1vNmwM/L/BXmciLGf1Jfv/XWv2DwI4dfi+WomSafnz+C8R98YBvGvefulliO
HhdgYTyNCj3OpYv/MPnqP+Iv9n71Ej9+7NqMx/2eRtO1a788feoaJt1QfxID
Pvq9Xgx4/zfaMRwuc/Ts+novYTT17F/POsp0fPaQepkFqmKKgB+EfPKJAQz1
1/e3/Ld7S0pWH6jacBSD7N979dNZx7jRe+aDegZ4Jhikpvo44CWR8AZwgyb4
PEc/be/eU6Mjx9XbD6iX5NkzPz/54iT/Dh44F8sd2/NiLD7Qf7C7ewR/sbh+
aWzonxaG+9VLXiYM4JC62hOKSHkago72XRhUvS3U1xcu/D3GPnH81ViOGjux
s3cfx8Zfor6+M5bEL+SToV2HDYwTBy8Q7Fhcv4yOXJgWxns1jOBw4D4axtka
JgCIQdXbhMbS+XN/hzHG95/FyAqCHIWVZGNDF+BrbdmJq+09ewz8x45eFoze
NmMK3q1ect99999Ovvj3YEBwH3gd8BGsW9RzZgGK7q6R5uZegIAhMTCGb986
gPfDw0cwOAiYo3Fx5ZVAGj4yYwi+qpUahwdHQtyfenIAvAhGjN2kxwelMDmM
AxIBPRy8p3t0XVnd6OgJDIwbfmvG431Jjwepg8iREBxP6bg56in5F19+A2yB
8TDBLZu3Y74YGJcAAgSK65FwA1Cv3mpcJ8lN/AOHxOKaV/r6xg0/503Jz0o7
fFFrQcAF4Xx4bg8UD3QNaHCjZgeBCaPmNDfviCXwBpcY7vKlN8nhGO3I4Yt6
CuolBWoQIDIQaEX+AfaAQ/5hcpS1JGQPN/EPj4kVeNz9OQNnJkb/REMOCQRr
A2z8QfgPTfxc83QeIMfjwDoYFoATbMwFnxuuxzt8h2nEtK5IUCxxFzSGhjiO
3wFW8D0lIE62w7Ri5DtwqOG7982YD76goYbKryg/ApAhjeB5/FBrh1wPaqAW
TI5hNEcWUC4BwuamnrVrasEkAI/SiA+h6wxceMp7lofPabhgjSAPX/6zkocf
bmtsOIkfztJwAUtgQ8wfguDCpTm3gLQGJbu27RYZBUTgSMB45PCl2G/OGI4/
0HIyvv8qDCHMESTk2NGf4XEgCvkrjdlhcMgGno1XjAzxiGl+zRNIKLBUFQDj
9KmfxpKB/gV84FFKecgiKMpqCUq6WhnDxPKVZo6vK2ueFv7fUy9JyBO48r6v
t8+ftxtWlHpVWSNgSHGghiUFWDAkhgBKQXNgmLyLzwFz5izUPAtwh9K86YCH
jVXIcSwZBonlZNgSPMPMztXZiv/zZ0ydz2gugd6G2oLWBAODe0+fel1Dkw8s
A7cQIlyBOTA3jA9Rx8gYqTCAmBwey9FKABCbmVELgjId7YMHxs/iLgDLCVEQ
8arkMMexh4qud8wYeh0vJWEPoetAG5hBpX0LNC1eunBtY+3W0tJqzADwAiBy
PuDJ5HwQSPNbIXUd6IobyCq1Na0riiuouQmjovdHZwzjb2kY3377V4CRKu38
uTcJYxqzBT7ILMNDR0BmAGKkgryEj6CurFRofpotUAJ6TA93UKBwEzkAd2EC
uFS4TGkdQlWoTbzGd3f3wWlh/2QAOzWygZ1WAaMAcRgdIAIvAIkeGuYEzCrb
ldL3eXyDr2cHkp05AfAI7o9RFvBIfKcworGVxE9pFanSYwnjYaW0LqfOnH5+
anqfCM8LLA//m/NKujRRsOhZpDFbfIo/uib4Qg2SA/i0FTEeITmMKh1AUdRl
WlpeCsTi8zFiVmnjgScj6UArrmlNlSVQ5uwmj+s+a+aTSbmPTTFDsD+GEbIZ
eu7Z82JFeUNTYzfmhCEB2qyARzE8QCaR6CtQO8+mtgL8mCPs1/qKBs+jw8Rx
A7DzwRnLi8o/xRJwquC8EGwNXwLA4smQBDyNEo6HAyywFZC0uWk7uDE/sLl4
T4gxS8AGnGOiGv+zPK8MhCa0mCQM25bNPSB19ujIh5a5J3idgBZ+FsRDoCVg
wGN+4NkBEmocHS3o+wAW+AwfYdSkYw3FhhB0clYCN5G5Ir032kMaGolPEmIP
gS5aC6o2/inLkjdjW/gRPVtwFaI+eLvwzbTHmASEYAJOWMlrXuA3Ahh6+sAu
JqZlKR+AYFiKjGg5zhZg6pnm0T+h3wQqkfGMt6epr+SdhomYNJYTPzKWkxZf
5CkhlhPIJh6oLfmn7E7ejKn+IY0HWE3qdASopDoIRy2HaWViRskNZe30qas1
1S0VFQ2iEwsybBOdIXplswNLikfs23t6TWkNwhb6ZuRf3MlZ0xNQlmLmsdsH
HR6GiofEadgT1OSgAVDL2YAqGIVAK0rQUmFAaszBgQliXfkg+hdpKkrfilET
SjxGZqd+0U/qRZyoKHLXjOdwZ0AR6DtwJn6SF8Q7dGMxrDcHvKo5kFfxDizK
WNi1ZpgbPSDj4eExmDvuo5YEkJpf8925uLEe3YWElzmY7dgzm7tgrMfgWJm0
1IxzF8z9wUdF3A2dafw/TAhQKkucOXOhkLIGkAjgH9pJyW4qiF2pWnAF8AAU
7sAEQEDcVBB4tQCbP3YnLM928hDxwGeIiiQTDHzwB0IxisSAEkXqvM6McyS3
6+uW5oP3faN2/75XCUmCdMQUgyg3QbEkKvgJ7SKmAQWVH/guAGrJ4tX4HFAA
KflBzEE1a3xeQIvfKG4qDOQYA25t6wcrUyLwGEwyOuqkv6Z+6Nv3zOj+Nh1N
gc8RbS5ZNNLfNwHkAxCJh5RFoY8N4F05xqiZMw2kIpe6GugHljBTWELcAOhy
Ax+AXE9FhjsVp8wKYljMHZgl51OK+/vGy9dt2r/vtJrgh2bstbzvusmgIhRB
tEquSRAw+iu+j5lFyjNnqHJg5GKDrXjwS7poQAB5FLLO+/A4h9vz3XliksAT
OB8iRoaPB9oC31oJd7M5iouTXjYnZ8YSfqu+/ulP/gkSrjJaKWNHjK/a0ty7
dWt/QPE44HYlP4E5ie8kUi/EVvKqPe5cxrMgG54KWkIDOFyvMjDkeqo/mb7y
TzguEIcfiE22mSN86uRhrLzjSczQirwbLUjHUcfBM5b8W/T1+XNvPP5Yn4pT
cgMYMI+mpm7gCCADZanALxKp0HcmQC3ciT+RHOEi/Ip2gl5c3catq1dV9muv
jfLj+ivkMQqJ1gdJpfHGz0EiYNc03cFAOc68babH6oIbZ2z7btbXsN8wfDJv
lcsC7CoDp2mRpNdFiiuKST6dYsNfKe0BeGjy8hxP1uGdPPG76dQBZHyLiain
ej6s68TQb7P+N57BNAB9svb2wZaWnWSnO2c8d71aCe549dlnhlSEkxvYHcxK
jZkMvBDKdN/O8a3aDChYcx3ZADz4KDfsu4N++pMkYA757vqp+ZgWMMycIf1Y
phTox9JLlanGXH+djmzC82NpW0RmNEeoWDY9Yy2hV3zjgwOXFy3cY7GBxwMb
Sso5mxPHr1RVbgYPY2jFH6lAE5L7g1kbu+HhgXaAlDcSBm+2csNmPJKOIZDP
OEwiR9DYnTc9Q8nb4Yq+u+ZV3EXJ4PKAytXqOF/hYcaa4EbjA5wpWrpPg6Lx
AAEFMwrl85iqY24VkIkXpGaWE/zCeH+5GXYmN9DwVIh4mDw5LU+DRwxPHaOK
jg1lOyU6pS3NA8aY3kB0UFpaLe49HkbMaAxgzGl1hFojVKum/vq7rjOI79j+
8oricYsZDOpiRuXwQEh1nQhgBiUBy86d+zs7dpn55Hq2xsOIyS6kw/41eU78
a2pYscdpT47wteQzC3AXMIdPGfngldkRIAW6ferMobvaHYvAS6GjQy1emHrW
gAWySc1uOB/QQoxqa1pFrSYzPC79SxW5g9LEiosnz+/OxTvMa3hIeYiSMxPN
K/GhYIAW12bDrcedDq6NZDHmlZVRExunssb+/qp+3MOYvy48K4hBHvlur7VC
9PJDGAT3CAbzwPsSFomWNpm3nOAJroWKMw+kLKZYbeE3sfh0GSFCVZVbAkum
1Adw7caiCm/MxOILCBlDOOJIMgdxZg6UDBKHsnJrIu1UVq7L83AUN55vgb54
55134c2p33FmZG6LK/AMxhXto2YO6VHyoKXSZmDbtw6CDQFbbuDZUDYgdOlo
HOV53jA1IF1+I/N4Ou7GrOnRA+EKW1oSZ7nRLsbfVNdR9MJaKAZJkQOEW7J6
/VFYca+Jnefnj/T1XrLYwFMxe9EoBjsKpkhZVUnvTXXtsPZirhKBh4OZU+mI
bNKqiWzSj7fesf5lPmMFpg2YYIQKx5jUZ/qXhfQDI/MAdBT4aKO5JQOgh4y2
bbraI1TX5euufH1dU30cob/FF2iESYrdUfiipEVLZiGtIf1Perl0giib1Gg6
EnekUMWwuYGnzIR1EDMqfxPCt2TJavhcwsNKg+ECD5cMl80Z0D5SwdLAMX6y
OT2gnOnEmK6siHNInTDI6iNlq5ohF47vvzp/3u6QzBnPUfQVBlXEEcvIpIj5
3mIx4egeTK6qqnnTpg48KJ1FJt3YIh3oftfLlNRT0rGMDD4BElha0ZKRGd4B
3bAay5aVNW/plaoOPN1gjs+TqH1GvnVuoKUenttz+tTrBgPWXyUGbMyXCjAG
+EXDmwhHvld6Bd/3ALid+631iweySdYQ2cQb4I3RRzqQTTf64C/z8VR8yiAE
t+Ip7VryuVKp9X8+/Qdmv4EiDANASMBt24ZnvuJPvFSUH2lsOGnxwPU2e42L
kOWzeEoHnBTCGy2/xGu5rscEhIOT8DU+EZ1FR0gwRcVCg5EOvJO21j5IIAQN
P8QTNEVC61N0IZgJT3r0TQQjSc6OvMQciA7knWiePsQfZsUaPbCf/uSfHprb
HfJPQv6KrYfxsSjche8Vd/F7VVOkU138HrHNq9D6mPPu3ceUrUgFlhWIVNqL
uMJdnAGmRa3jxrSUTEUJT/IYq5oVMMY4Rw5fWl/RAIwwzceANsj0JZjpY4Cv
V2ET1K/ksulwxVSPxYXNH6eCuZu4zsed4ApQKd0ruDYrzPQ16c1SxbtLnlyZ
4tPxCQZIBZ8wQsRMiG2ubti4mLJIDUBZFH9eZFHz4CxZyeICMDHb1NhVv6mT
Sxhg/zkzlsiUF9VES6CPP99C+pqMEqW+TwW2wfiu8UCTyQo4sGLimFRYkwEt
Lq7s2kkqsBcIEOE9NdR30tPXsNhcG5Ar619mdZy5Rsq+QGtq/GyuMTXjVX7t
T6TefvtXf/LHP+7sUBEpSCD5CbwB0Nbvsl6qYCVkMX2JJVeGsGi8WsEAUFhV
tWXLFqWl8HUikFGKYxBVKQxSI7oYTLue7KGJl4yXQskFKnCvm5KTrIWqE9rc
1CNFKToXy5V3LmDbes2pMSm+xazOjvOlJROsawCjcFUE/M1AA58ArVLlYyrV
xBbQ5zE4YqbCXlNyrT6jJyqxRyFpwKI9yVXRs2fhAiggGEvQ02eig7xDjWf9
3ZxAjmVtGneQGTEu5hP4Nfkix4CXclxRXl9b28ZIIEeqhGaS/adfe9/X2+Fs
6B9pSYCUKt9m+EhTY/eCBcspCQBH6bFEJPZsFj4ae/SERQ8ay2sjOXvt+nTN
W3bArEBYg5V2lQ3CrJkvJmbp+tFbkeoX2OBFP165ta2P7EeKyQoSWETkG7Ni
kKBrpnYFMqVjgxSYSlbEyIvZ7Qdj8yOHX3v2mSHRf0lyoJCLa1cJpvH3jp0E
DOLzmtHFjpg6HNcGa6Cy4dO1yWlmnk8cvwJuwpCh6J6WWXn4wpsSdiQDK+Wu
TJ0+dZXRKKNU8qW/MkWbDu4HzzAc46pqUEeno4UUJOA9YnTJ4rGerpcsZ4Gc
EAnxlQyv4rnwwysrNzO9Z3hVcXNQ52fr/azNSUbilv6RxS1kDwST/L1rg4ah
ztwsvF3PwBtqUNwt1QiSc8ujrQJnj4+fY7xPMyej2nhfcvbryjbVb+rg4izL
JwpmbK0Z77/11r/c/412a52t/8wxRYqZRgZIgFulIHv3AXoMfvnSW+IHAUdW
vkECTMNSyeqHpOc38Xsbw3GNHwNurN0KbDKtixulVkfWRgSfoXqIZCDzoENV
ZfOqlRtGtBuqPy90bbokBpgSx/d4Fh4tT0lKJajJ3828ai/u5QNEajGoej7x
bau8E4HHARrXVLcw687KD8BrZdVGBslA7g3EHMHuzZDvQ7xrY2f9/SwMJ/l3
3AUcihUHfbgiQ04GoFyjCXRvrrd+SYMIACgVEgGG7L6GQlUWgSgIEsjObjGq
2S3CqFDX971HnD/4wDYIgMW5rcUSfWF8qVTAEbzGFWDGXHA7K57gD26sbTOr
q8lIXWFjp2jd4d9vs/yJwJ/q7d1XVLQWpk1zmMY1nspsJ4BLBlaNq8cQDGpd
5eHvHC8rq4OQAAQGlxy1QOyLWLbKDU3dXbuZgZCqoRlpipxITeF5vg7fpYxu
JSSgNMjcr1fbXY4GrzGtkBEXJD3JSAY619UPajxDVX1dwCgGOMFTuezDHCHX
VnV2L7BtwCNrAgWPYtsGBw5u2dyjLKH+Lhcg4QFu1ElDItVuob0OUmmA33gV
70yKTWHbcjxvQfQFkGaxjmlRVC23GX3C+4lS9VZDlCf8jLuen1/U0tLLwFnx
Xzyw/SaS4BOt18trG88K3h06KDonAk25e/gonLMN65uOHX3F8LHrnQm/h6xf
TqAPcB+X4aTMCZdCt1yptgY7l5dvorrAY7gLxvUidKZyxquUOZF62vde/Ws/
NvC4VdUXw5RLjoelKpjxPg2/2BeHfr5VjKaG1d4amwWMnk/qPTbAMtcAydDG
oxPtIQaS/jTznGvW1KxcsX509ETweb7sJMBz3ZL2pqbuI0cuTu1fKLTmeFmT
QBtEx6XM/tj5ebo5Tm9Zv9XWCvjBVKqrWtZXNEgpNObOjA4gVTkeTz8lIjFr
9XIi0ON4mmRBVSTf33dg2bK1VZVbJAoJZZD1J3PIGZIJZYqevMAyRXfPET4h
9vGmftPOXQOXqjYcLV93eEXxOHekPvLdXm6OjcX1i+XTPwhHbCn5Bv+98867
d3+t2c8M+xgUjgMHWgz7/oKlAP0D4VAKIO01ngCnfvWqqv37Tgf2yLGziWAk
E7H4GtzHeCKwFMDtwQPnJZ/DNR1JRhsa4J3kDQNs/qympmVFcQVXQwJdkw8+
7dh6HsgFboHOv/yLqqef6m2oP9nSfGbH9pdzzp97Q/lHvwh5DxbjnwvrjBDG
Wd9EjAMZZD+DUXvtewhRPC+W0tfE+du374EOkXVm8vrhQy+THHy29dcTgZ4y
63O8ttk1uTZRNbkcuNy2bXjJ4tWtrTslj2/z2gGG57j5/j16LZgx8qWL/wAM
L1q4B74B/K7i5fuBWCBn9nvA5ejIq3iAn4lORV77XoDPzYCQhRnme+tV+Hk0
PVPjJ1VUNJSVbWRYwzwRpVetPotU4EJhiM+xXrXg1UTb5DzqiWPHXpG1JOpo
+sqSW5O1AuYy8auSVe1PPbUN0gxUAjHwukxl2cxwOThwuWjpvuhMtO8H+5rB
2jiZs4mro7/35HmW0IJBDBkXSrq4uHzH9jEWkcQDK2ZiwXhAReMzC3ZNNjMR
zMTobnItYhO4AMuXle0de9F6X6wL4oNYRXr+3JvQr2DNec/tGh56+d13/+19
7wGX0BJQzekI3Fl75vObz5++/fa1rfXnEp4OYDyImW9u6mbkzZVssBLiBXyY
Rata/S97m028IesC5HIGyHgiANoflA8Ftu9NzBx4g65UHHj7e8AaPaloa+/n
CKHVJllDlYzkSKvd/O/FgoRiL1/arVemOaSAmaF1ZXXwg7nshhF0ketPjFbg
7+hHWBxa3yEe8KdZ0yG+cN3QsG3ZsrKubcPa+9QgQDFCJYKLYJ7vfA8YLC2Z
wI/CGSo/e4KZAGKLSZ8Pfb/K2qRIPnOe5+tJ6n/B9KROBTEBtmrVhvLyemCC
FcjUmUzyxoOnmLUuV85Da1QsTJ3UlS9431C//bFH26D73n77V34vlKlwxpxg
ZA4rAxegJpg9O+7sdcK7X3xwQ4tov8fHreVC2hzi9qULr4NVuIoLXly6pBTG
3uT7GF1aDzXuXecE2KRAmO/h7XzzwbaR3RdiH34PmEO4OTT4SvQKiI85Pwry
5ddei94OxY4+Zn0fPMIuGOuemHRiTaUV21r7JLDV0eJg+bpNOujTv7TZx2jc
AVfw35Ru+8iUuMqRiMZWQkXrMp+LfOs7Ha4sF0V/7+s2O56/6yH6e6s7GXGD
C1ViqGu3lCD09x+o3LAZujAjM5Bj5ODNh+Z2K5zd5eHss9dD3SSyaLPpcebj
wPdArJZKehBG48xa17j3vBA/Oc8V/Q7c2GurAYg7HeQN1ta2MUsIOg8PHdlU
1/7ShWvmF3rzwxsKGT6uPFnMdXG1fNnu0pI+rtolNDMzhFQVXulIifT9Cx9D
4Ws14+j7LOYIv9e7JsOrsJTyO6jEXczOEgoDpbgHw9TWtgJlQBwot2bNrory
Ix99DxhqaT4x77l2LhbruhclFytXrl++fJ1eU+Jn+LJyQxOcTuaOU26t6N6x
k52dQymPzjPFVsL7nURdIdmzVHKxYfnN3zVrsc2qI9F7k7oed+/Y2S99seyf
//lfp8FUSO5YU8dKG9GG+CNfASPcJG4w5FYkwzlauKA4rlfhudbMv6VLSvT6
h86tJQ5NXKitaWVFZWJKbPnXVjf7mi06OvCvrS9D7FkvU6rZjUzwurHhJLhM
Iei94I81UtFRqe/F2ywtd1y5q0bl6+qhHOLBjopEV9fuhQuLWdjKzlSVlZvX
r2/olm4iXO/YNTihtXHQmQpYJNtl6Mpofe9jzcukORKf493Pa+tF8Rp+wpHD
r71XLDIzlfawFJ1D9XPbNoMX6T0kR3Yfa9V7lVgWZ/C2Z/T40qUl3dJ1jDtY
nn56fsyrK2lq6kYQyWryBD3Y+k0dB8bP5jg1YsSKL9WS/TfWJB4p1V70odal
rl375QwwmJGdDmdTM9dK/GjAtxL+GpRXXZgRRwFHTO+YjJtgXtWlGf1xfn1F
o6zOJejHIiBobOxydxcWFa1du6aWWrmkpAoq2a7ogVLUIHbXHQE3+PTx/ZUv
b0YEPzX+co0n4ldnR2f5/Ugh7I/YzFzYL7Gazvqn0fGpbzXD/mymhw9gBgcO
Wpnf2tbPFVerE6g7uGc1Dw9btGhlWdlG2aNECkgfufgffm6NwUB2nOk6x1Bt
u7+rJHptypdfP0a1a1HRPoefT7L0Tnh6PWxfwtY10xexz417z4l70kNrK1xA
tb2tcwhEAN2Iwbu/VgmX9z8Gg2BfaEO1J9D3P6Ix6meS/fgpzH8WQ773Zikx
td9rnxeP/N63Cb6ltZTIajO+8/DjM8HdyzPEK3P2zNRll2tfX06dpbNy72fn
vGoNP7J3VvMSHhzRnGjzTBLRY0ibZ/JitrTok0mdeb/v6+2wr8RtHnFSV9d4
5513JRKpG264IR5P3nbbh4qKVsd+9z1wKjF6+dIvHvlur8VgOPK3GPJWizLW
M/0ILmK9IuQ52zgiGoP/0RzrX68oHt+x/WWFgl+LkuD0v//7v//+7/1RIpF7
ww05OTckbrrp9gcf/J7u7jy1/UnMyI5bbEVn6KfLh/qZKs+OZ/iI9v5oe+Vj
P6Lbj7ua4mvWNK+5cDhx8PJ9X6/5x398JwOzGjd5b7/9q4fm1n3mM380Z877
k8m8eE7q5ps/8JWv/NXY2GHdyXuqikBbc+6vEkXj0c9L+ZbJj6p9f8nPudt4
ICr+c58Xj8Sb16GlUPA+qVOq+/ed5s5C1k82NmybN+8F2z+zZHXvqpX7r0fk
GjQXFsDqzJ/X/8wPVsMJ/va3Hv34xz5zy80fyMu7+eab7vriFx9oaxvQndim
wi+0zL33tFm75a+6+XbLz+v4+PftmP19ZPbZqbOJsmeZ+Pb4dg7czt3DR6QN
aXv7YFHRGjbe5bbSioqGjvZBVlEqHxf38UnWgn3Ew4yuNk8Ctz/4fvezP1hd
vHxd0QtrYjnf//6CWPqev3jwU5/6oztu/9Rtt/3u17725Mba/jff/F9aT09R
+x9npsxi0bdifnw03VqTz6XAp1n7DXsL/n1epHirl/s/qbpfnVpXVrdj+17u
0AUaG5Srv6Zr2zC32eAe+Kp4kGhpUwnAdU6h16S2Y08+MYBoOwPD2lbd+Itf
/O8///ILTz25YMWKig3rm4qLyxcsWD5/ftGPfrj46acX/uU9j3zhDx/8nd/5
m29+c+P4/qtaAqbCsd35FLW+HGXXfE0tuAzZOZ+DfU/AVnPr65vwDVB24vgV
bn2gYJesrl67tpbJWO562NY5DHfe7HCmzvUz237cbuvseW1XqoOuPa8D3yqL
668S6B11cwYHLj/26MYf/WjxvHlFG9Y3btjQVFZWt2rlhh8vXPHcj5YitF66
pOT7Ty9/4K9XvbB0FIrhw1kxnoq0eX5U72Pa+kTRXO3niP2owfNBb6ZTPzx0
tKa6hSWRrMfS5dN1mB4LTSn7IAiRFb0e4eOaEatUU2R4E1w3tLg/fuwaFIri
9Q95uNL7YOc8PLenqrIL+H72mUXLl68D+mtr2qqrmivK65cuKQXiFy1ataxo
7dNPls79djNctA9Ng3s/YrN6M2seK1RN6OttTwoSIj2qk4SKWGezxRCi0JaW
XmoGxqWwoMB/d9du7n2QzhOWG6JjN09zODpM/D23asvZf87YTr4nkLsGT337
W1Unjl/11xY1/m+CH7Hg+R1bNqua85UrNvzw2UWlJdV1G9thfRvqt1VVbgHH
LCsqg6KfP3/V1+8t72g/q/v2hSvg/H2DWeuwQrj2tbmXkzEdS9lJQiyZKA3x
BkzPtr1jJ+s3dZw+ddVa0FD9iq3Wn9mKt7+Sy9ot+70ndbn4/aZNHR0dQ/AT
IGCjo2cef6wP1u0DUXi/hbXFIHRnh2o50tLSt3LFeiicSt0gp6mxu35TJ/Qg
CLCmtGbZsrLvfnfNY492w2PUlQnR+5j8na4z26Xge+T0HE4GnaALWavOvMvG
2rZup0u4qz4yqj2ioxt/pTiidsNZVcnEunedCyoA4EMTL2FOqrFN1wjQB8bi
3QiRofmvXftlxiklundB4ktfXNXaMqRWBLtGclqae2OFYPoXXigFu0OOSYXm
5l58U1e3FaZ44YLy+++rU2ds3JFVD3GXtr9jZ5r4vGC/LhCmLmGfNu5qo5fR
2bnLrFqwmp07D8je0Zkn30b4685+Hs5qGZ9OkXi/Ufb04iNy1PqKxtLSmgPj
Z7mIw018bFxsbMHoyKtQEZ0d5zOqazQ1kg/8VXt5eQsoAEz09IzGcnq6R2Oz
cVFb0/r8/KLVqypBCIg9KLK1rX9zUw9e16yph3orX3cIbult09AE0gOZsz69
F8mrmhaJO1SfZ8k4suy6pKRqa9vAWNBc2O5PsRIVFWuFVolClYm2BsyPuXxN
H85hWVpwvyR3XgI9sDfMz3BPAMukRVtxU7Cp1AEW4HyDHCdf/Pv3R1Hj/fd9
vf3QxKsriivA+iO7j4HaJAuIAomDff7xwmLQHCQRemACeF2yuPWJv+2Hn/T+
rPRgD4yG+pNVG44K3goBbH/feIvexiAdN7itXQIW6ViXko51IgnROVk/g+BX
Sfsayq9z9CUjXMNrKzTwOcAd2X2UO3s0GOfxXndY1Y+XPi6BL2B2tnPPCz/Z
N/aTb32r9vHHtp4/98atUVi7nZaDeQwgv6pqC16Hhg7vGjyk+yMOKvXRtRvc
unjxKtgPGBihDt7U1SIu3gXqvG9q6qje/Pf+ZePO3kNsXAGc6NUkFcl0de2G
qGOGtruH77ukIiTBxa14BCZGEAlxzzXIsBbWRouNNzbarUmV6zzZISONAevr
O8rWbtyz54Tt/CF7jTmHMd0AS3Ypqq7RrbpfK2bKPUdDg6/wcCPIjl+pqnF3
R2nJyMaaY/SNuYVXDTp6nPW2Spq6lDT17Rzv7BxevWrDCy+sUaa1aySTTLoD
ZzSdqDWHh8995zv17KRhudS3+qwgt9f++phvP/y9AzbGyprV9KuwXUr4XqvS
Wb07xhDgNjV1s2/hpK6YwEOgy2TVnMJqaEWYuBOB0nL50lubm7qXLF4NlLIu
EbR56skBRBUI6hT2Ii3BB+AjffO/b+7pHqMTSFcOWg2x0ZYtO/bvOwMwdDu0
w4j4wdH9/QfaWvuKi9etXLm+tbUPn/hUuiUrldhVys90hPN1Ngr390D78Yqt
bY2OFf38KO8PVcO7dMmnTTp27BW3GzqsIP0TyfW5nrClQyAzBdIb7djRV/gG
JGKprdv1M3Vo4udFS/fdc3dL8fL9e0ZfgYqZFeXDpsb3X2Uv1aGhQ+vWbcLD
9Jr1rZBTxCO7dh2CSQCVeLAJLkEf7hREIIN4HcKmiNY37pLo5mkoBGC4jdLU
Hfm7Svwo3pcof/eeX6nle8ZXpEuKUNZYdXcfg+wXM+dZwBMEu2/d2o8vxEvQ
e0jO2Uyh6VEs2QEgQ3fi04O/dOFabW0bQoo9JuOnOgJyA5rbEylVXzcx99vr
v/Llzc/PH0GUCJHx+6fp/FI+Qst5z+2aP283yIUf4knV1c1UJ3jVXuutw0NH
lGipI3wuqm2KYy+CsKpT4dARvAGXgIBNjV2YWXn5JmAFUid0uykr3cg7/rqN
jftSAX7MOT1+/CM2KLR71c/G+LWvPt2sNyb+A3TFts5hntKRYveZK7o3DZtb
upaHwil7UKSDtv5E9azFr+h+cCsFy2XdRpfM+eC3bh/5s2deIxLwZV/vpRXF
44gJQUsYLXhd23sunD51DY6EXvnKF4xe1zVACG94pNTcuc3r1vZwXYO7DTE0
giJMb1LXicRyFJvdijnAz2hvH8QbRGIgsF7VnwA0e0ZPkNJ9O/fDi1+6pLSx
YZvOTO0EKKDunOt+7Sn30fjrm35tqZ9/j9gDbvZTROcipqFqvsQ3k3qPOFva
Q53ATOOnkkUO2TjbtZW5IjoM9PdIYUTLq1dVlZZWB/tfMrpxUvboCS9dUgLr
xn0L/BxeOwwcnOYf/bDzgb+uAY30nrlCoA3/fv6zq7/w+XU8vpBnbuFHgODw
oZe5SZ2a5APNW7Y3NqqqJC5K0BQdPHAeAe6WLdvxHhAdOHAO4gpq7ty5X/X/
GjvJNOL2ntG1azcWF5fDWWnZMkYi6i6m0TmJwkC34k51RlJ0vbq/euV7JzZy
SnrU8n1+l5qKOfX9KVCmckMTWJd7P4JeU3FmR0OrLMoaBnuhTW9ix9LNYi8G
PIa6nptM8er2fecKjEgk+4YxKqZykfZA3BPMNtU5Hp+SY4BJ/MtdvuQYdnOo
qmpes6ZWZ2nUp3nEgDLiXcNMJxKHCgc5SlRvQnwIGrPxFt5o03yeO5VhSlUx
dN84qAsRhfmsqx2F2tfUjNa9lFKoEPCgiqijbabf2crv5EAz4dNVurL4dFUd
cfAR1TNP+OBJSLsGJ0wvAfGK8LndP8ndK6SjbxUTAVYB3MoVFQigJMtheiUC
n3jD+wC+NNKAs2HiDHbVYRd2FpmqTnDDR3U5jSJSATBHqm/a1Cndxxgm4nPV
ECdHmawPU31P6sB25Yr1kDu84aI2vVQMhZCvra0f4snUMYWJcs7uv/DfqHuh
sF54oXTRwtbKDYdnZ6Ulr20PYvFETdzr0zbpfS/rSsYOurScCM7jigvhDC0x
I0Q7JaurAOSYPvdJup2IpXSjPKW/klG0S4iVVP5GoE+UGzp2yqwXy9Kb6UmP
azaKcHs5ps+c+XlVZTNkgJ1oeDwbx0wcGFfbwY0cqmemgT/8u1mXVHo90hJA
fUPDNpZq0nvDHeAHutpMctMz4jo8AF/045WnTl0FUYFH2nk2wx7bc1Jt8dUd
cjAeRHV9RePDD63buvVIYVaKsh+7XyNgfX+pxep2unllfG8pGplZUR0ImN8j
Z9PfUeXSiMa6dYMVsZNuV3zTx1FWBg392CqMvEG9ABPT2tLHbtZysibzz4E8
3nwh6F3K/t4ICLt1c95JnYHk0QjSv4dBvOplEeTkjH4lFeIBX/J0GXDBmtIa
PFGP/WFW4FPxQDKp/6mtpJiiob4Tegg8weAA5h4Dnz3zMzb04flK1E1wgft2
HvzOwx3Xrv1yVlY68pQBv4bT7yvGCMDvgzUlHd1csPI2Wpp7ETchuHC8DWMN
/R7fYlXjkhAxMsIeWo6/k8R3kKi6jW1UXDHRoZQ+NjkyULB3PTALD1FTkpra
9AdiUwnV0uP5ZcBvN8/x1FHhHOCLGVv8mHlD6mCejjMZHElItCmboZ5biPFq
a9rIXaAS2Zimk13DINdSVWrqU6gDXVVLzbtr4MKTTwzAy9Gx5FSnZfh7qny/
ln1FZ0zLAulyK0flMOXIg3SCyocMHWpO63EsoukcSUHVnxSKr8P+cOwqRj9m
wjlmzlDV7aRke3yBADt2jDHmgnKTFieSKUqyIpRVFgo+TdMUaYo/xPsHxtVC
NeGGR7pq1QaypabjhwQjA/qEBPqREnxzHQTPqalpQVTJZkJqn7qOH3gbQMNj
MR/SFu41YqRpKQlqI+5UZ+LIzt/QXnOfchGUNFKbDKSwflPnihUVCB15/o+7
CmDtKPBn+lq61lAiF3MGAE+cImVfuvA6In44dntGj/Me/obcrO8JdbtjQxmm
D5mtk55APNlQhwvn2B8MWNRwJalJBeWmHo77j6mE8cuG+m2yW/gj+KI76PwN
NYvonw6GeBqMT2gKBwYOFi8vZxkWbuZ2UrzHK11Z3MMUDAIgVW+Qn5V+twS+
6+OP9dl8j98rYBr6zaJEcBHP7VKp1/BOOvbPxPU0lZLrAZ5th6aLwRkobrd4
xpzqbHKNSaHr6VNXd+qDxKXXTVJa4bh945UlU/2JFq9uaOga1sVgqcC6gsFY
gLN8eRkCA66jS9dgJYH4T2u+G+s2tiNapFLlZnw6RtQ5ZGHAwxS68a9wsU/n
EF+6cE31N8tR4n4rt8IInivK67u6Rthyg5qU4QKpyNUqvaLyCnRrdmrKCVXm
9KUZU9Ptm5uaOHheHyTaSJ9VZRw9Gyj7ItwVC7OmQz3q0lZ6waaYCeWJ79Su
9BHBOSQjHkkquh1lZU9IHtHBOJ1ni+LVnCFByaOYnAyfPG01KDxRp3ey0g+g
+Ka6DrCPHuEOHkJKNt5U104NKgsCokoxzL69p6GP4btQfdIhIPPReJo9GLaG
MDcr3d73/0Q3+qzSrdz04WRHf523H1UYkEwgDX6oEsJqUl9zsgcMV01pm9jJ
s7Jyi9FppJO0rWbbYEqb6alGJwVSOjx0RPnE+ruCK/r0Aa+vDbdomh1u6bAO
JdJtv2c2F2GLIAqbrcdiNwKT2wGmSkurEQBOBhkA8X9EocI9BwcAIFZeM7rk
V5rXr+L9oYmfPjy3R3k0YQrKWYAzoZwbH6ZZ6Q8DQGLhdlvVAQBNd1H+lt6e
rAMab4X60dWYeE7wST79AHyCyVzWJ2tIyx4VhXlxoORS3J7FRmIBed/O/UVF
a9pa+7W+Neck0JFgira0pHr58nUcUMtbHtdCGeeDP3u691RVbuHaaSxHkTgu
TUiMliTi2fpJrOKtEpVJAEELKZkhUgrvt21TqZ7amlYm8JWl0MzOUIP0YHV/
cBZFphTOjJaUJIFReQvi0tGV37F9DB9Khj20hnVSzjIVn9ec3ESNxIjI6bit
PtlYu3VNaTUCaX5C9eJoy9SVcH/eIEbMl/y/2kasV64knA+6nCfYlu6kPuJD
Uy+fcQNjesxrcHACsZ8cay71IfDNVq+u5NG0xMWHpTPKpC5F2LC+qb//wKQO
P4V2gEDiC3wCS9Ovj6rgWiZv069v6ZzB30H03n77V+msuvP2bFRzpUhRCWSB
2SGhaEgCPJnVVatZqR11B/dAG6pd/joP4/oxrhRe1qdLkbiiq3gPKNca7k9r
9KaN+/Snzhl5Gr6urt3SFSlPQnjpzMfed7b2xlaIe16ou3NYeaF0LPBRf/94
fX2HrUoSI8brO3EvjCCwJkxOwlJZSowIAjY2drNt6qROs3N6IALVLUJ2BO7Z
aXhHJA3FJ7a6n2QF5NAnba19VktayFOBlpRaBsmr05yFJE9orPAiJ09SCnW+
WGPyinduAGnIKK9Vd9OW6DJNVG2sbYNwkIyy/ma6WLKkh+nR5i074MpzFy21
JqWMcblLwerqZgSyrIpjSRxHFvufIq7Jh2Rn/fls0aJUhhJSSLwtb7T8Fywr
KqP556lmNB0Yz+45S2Wl5J0BJREPSjxRSM/x7Jmfsf2te2QTDbx/OgFLHywf
uH5ngnkBx8803gplj/ccPvTysmVl5eX1MOHJMA1xp400L+ve3R1O431GeeRt
YXt2JGXgcMWcM6XOcevsHKJjqbMj3aFzVVXUoKuE8MmK4ormLduZoDD1coEe
eG3t2o0tzb1U+aHKclnvzsf3TXqVyvVkxBnV3KOOFIKdwFjj+8/QYFEf0F2j
7ctON1bm8uQ4FccLdkAxKPqFC4rbtw5CLER2QudN0LYInyfo7zBD4vuXQkOR
Nkq33DHhHP0ZE9qxSb3pH0VporYUbX5OB6FB1JhLfmeUwLbDDB38XS48p0ck
DX98XCqwrHI4d3VV86GJl6QGVGfGjKZUXi30EegEoFxr5+xADKgEguwZfbFN
16GJL0MDCMw/+r3e7FTSdeuFMIfQk0ydYbqcJWWKbfa26zOD7ek8xpbxGlxl
KCG0C0mXrPMFVYRpakog8NSpq7IEaLL7LrFodfz4m3hkdmTRopXUq5fNmYz5
7FAM/LK8kXINTEG/Yy65GbThoqHG+Y2AmdlQ8Wuk8arsSxgLulWa1WRaJTmX
F79hzYDUCAvB+AmetXjRKsyJi+qy9Q1icvnSL5JCKWXbVALd30+rd3qkoDMX
PL9rWVEb+IJKRNZmgVYVG6WjrVZCdGEgSQk3+5gKaCA+Iz9pbx8E1HC75Tmk
k3P2cijClrgvFx8dGD8DzDCS5EgnzeldSb2RU1lg6Fbtyyv9luCyIP/I5RJv
A3ZEjOsrGqkVGbHhc0Ch64HVERhxSZSbejh3/+OBA+dKS2uYWaLjQdqL/MpC
zObNPa2tOxHt0Sch+Vqaz5SWTMQsnXId+sQi6MVdUf/6r//nxwv7oTPtuYZG
v4lFMtV4vgzJdUjbiW8Y5BlyhYoXX/4fTCyP6c76vJ/PZwvcVOD9TeijJ3kn
YznaJvqH5qTf7uBsurGg0bdfE8LVI+4k4Z+mWVpoxugc+umynFbMlaXKDU3r
1zfKGqGJt3WSQ8sW3tVtbCc16GrosebIPmQpC+MqcmfnroryehFqcS8SQq3p
Tqm8K1jbC/mNvoajvyBdtCIkiL4fa4/FG2SRB9O9bhWsPXGCJDPetjSeN+uo
1Ht4zpg+rwLsyRZ19IiYBRkL2oPTQMlJ9sK/PNM9pAHpkSUDriC1OvThXhzZ
rHUE+/2CKg7mt4IayLeYj5CtF1ecnlNS3UcY8CHC+6Ghw1JnxJRWzNIp36NL
jtGGpM/5c288NLdbVgdC0ZR463RML5qTGeMsFxEamtMnXB03cfB8UdFa+NnB
yT+WLub8aH4qeQ3aB+uJb27azqJJ+oSYXeDZGavEtVk2u4Y67Q92CrJfDUMt
kagbXRrhO8RV1Jbi7Uu2UvavpejCkdfosdMXknrKSb0ei0luV3tAtKch+Qj8
SYcQ0YKqZ7HWqkkAjWtGXooMiayUcq8/GqwHwMDht1b/mVVq6S1s4qN02Gdw
7Zan8ZjFpyBleg2sEKI1kjqLpLhe4A6x4QUyWWKHJ3lnnsipft3U1E0SqAwi
8148OkAZLp4sjLm716kf/nCxeCEMr+VsxxXF5fDZgvX2OM9OkUy/sua1Na26
2lGPLz6Fib/py4vl4tcAD8YUOBkdefXJJwasTE3fq+PX9R3vvvtvoDBEEgpQ
9B9Nh5U3yVVIdsTEvnLqqWg7WVuRSj2XWungE6kF4jlP9EP1OciqB/veMY1x
Pv1EcNism7aQ9R/rIWtdFxc5Mli13QLkRE3pEI/wSyrk8RxTv0bZorHh013P
QbIWk0GmQmihvIimbvDMubOv33N3i8r4xkOeQ1Rvj4/ra+jDBx/YJlV9CucA
gBLhyozKTovMSIZdTsRcV1a3prTmxPEraQfz9Nrk5NWd+lg7UyNJnIBJe7pH
lixZzRGCU0ZnufkGHkLhpts5+/xIrHeHeyqoPW5cu5S8A036Ref0HPwANFF2
lqsAUj1MBHdtG9Z92vTzJIqdDDKCrhbDm5HdxwDf3G+1wc12qOBHRJ+4bnaz
QXaqNhwNnYxsrYfkRNyzgJmwDiLC9IngrMNQ/CnWR/wxYvyiczIsKxq5h0B2
9Zx1DsBlsgNf8Qx0nhLJ9Dk4+JlnFmrto7WTnGRiTqNmDl26pOWrnmDtg6Qo
d1h36CN0WTfJaBk8z2pqk0MI9mbRu8Y8Yc7PBWfcSaTqyEiu513jq8cfq2lt
OZqdDp+8bnaxPfXkgDqn2LULjuYxK/J099OBFgWW9B5DLbyiqiIizLTjaZFY
l4PzG201IrfQRPNxLtfQzQZZvSDG40PyAliCHfwa+3Lenznbmjnx7qADWxIe
cXNzLx+i7E5ewC1bddWjWApqA/GU09zZcmjiJVp5hsxmFU+Sca5+MmuJeLeu
bKJ5y6kpJOI3r5sKRvhcPV0vGYnwLbZbu0v80T5vrN1aWbnZ3peJfakyA54l
4jF5tG693a+hYVtP96jGhYpKxoIzQ3gGDpOK1P22JjZaC9n9CenAh6C/K8fd
klPdnIzUQqaFi+lmhWoxXB/C6SgaYNnEjdmx/Fva9kLvLFk8RpbPYmtDFZmy
Cq4kv2Nox/a9rfbEe4NrLqAQq8x7ybpO8Mz0kSMXQSh8LplUJQca4wWsjuUB
Hqz9YjSIm7g8FiuIxLXXeyGXaXCqTXFdg91macmxiBmz5zV4fTLyW1p2NtRv
42DRGmfmeP90wN3srR/ibmVdcgMtw1RDkAM3FkEy+gl34whjXEzWPULJaBV3
RUZ2MxTIutqkdu5EowRFKT8ljtWvGeV1den+ucrDZJZY9Lw6RTNS0yPggivA
qnwhJde35bzxttZ+Vk8Hp4rEGUlZTaN34PSDAqGMAevkpaxh0gnN+3ovqWr3
7BT4bc35CNNBKITdhyZ+LpzPZXnMmHk7avZdg4dg+d1sfSbuARw/GdOHtpGK
uTwPnN4/G4nRoKUCDnSXNBk7U48k3BiJ/VxFkyt/MVKX44vi4nLWeykK5gdW
BaiBnq+pbvF3DlpPR0pfuTPDZKmJZdcLksh6aPAVeOwelhVIv+NEzOLPhLLl
5MsDB86Vr9vEpjbWBgpmzaoiPwVGcRd5WGUCcgMtxCWx0tLqttY+oFPrD7PO
KCcTyCkZtn7SyrevSaiH7TpkOngitTbdJa778CbbOafDOeMp7WYA1Z7jVvU7
kx2Up7uam/i8nm3nze8GkRIcFC5wEK/UG6x7lU4njGTpjSTcRI/gmFPBq9Km
5GDmkj2/XJ2Q2dmxi7uo+QtmGTRvFchJGnTkuI+UeTuEIeopsyLx63XNMZpa
8uDU1JJLkP1ETCqE9vh4WUGlPcrK6nSsrHnEjZUc/zDesfV88fL9Qf4gWk/8
vsY5vPdHv9dbtHQfLGRuAA8ZdFLXv7m7xDIya+ngU/6IgZDlX3rgmDVVtt+7
Rqou8WtmCLr11i/FybMCDcj0AARg4YLlbr8i4wuw7EGrEE9Lx8P+OEthREsz
xy2eVW1N247tY13OSZRx7hgQKppdhVKxTyEzdHA7uJevOwzDl10//4HG++DA
ZVhIaJBLF/9BsNi7Y+8LS9fAGIRwG8I45cKNd8SP44pAUDnxFk0+/RHMihE+
bzAVeVo7pIT/2IpLOuuyHEgbQ08fx8O+NYNVo48vB2ctr1lTC/cpo6I7EVgO
qVXQPvRrDFKJTfEL8Td/HgLWq9mx+dnA2kFzAKFwqJnXZSpL7QkMyk9zw/gM
aQdGLECOqRSgJMjqMuKxxsYu6kV6cepETGYvpEqOp1hHdeeK1hJ2zzUpyL1y
TKcxfOdWDclluRrY2Vsv3mF5+SaJ3+OyUcBccz1sao3weY3Lt976F/rM8Byk
84fk42V1IhOvETrAW70P/ONclhkQuVLxhGE0R85icT3VNZWCLMwDJbQphZE4
9ToMqGiSlk02sJGIcccrmAwKZVigF+qcYqv+cAsYXglGjkc9Xt/9tWYw4dT4
/YJ6SdE3hnru7ztMkqYycCpxaljKQ96u7Px09thwXixDkkQQTRql3WScpEoF
EceCBcuZKySSMZb0e590T2vxcK1qypsau1lAyF2CFAU6ESwepA4DfLiTVWtW
v3rVQ7mSmZGUAKNr4lcciCk83z/W/NvacvSrXylHGH7+3Ju5YcyC7fIceaeZ
UzTPC7QSmY6RswAkOVjJZDMzwbWXWY5HxFU76Yxlcka24iThZbT1KR7puo1t
C55fxmI+UsD6t1I5WFS0du/YSVtjyjLUwC/KlV3GkzriAeD7tVEl9y5auGd0
5NWpsfcn6iUJJob1uv8b7TBjasUuN6BgqIpYVh3dUN+shbF9DSBevqyso30Q
+CgILJS3nMaFfkaINpPiSza5T3KQ5GNl0WR1nHUGalFF+skY79/vMyJ9H5cu
KVXd93gNE2yyyYms2PkvU2BHVrBM5RJ5TKIj43EyZlKuzs59XK+R5AAeoGdV
eNY535yeDn7M7SucvVmpuDESR7afNK0+IzCmlrnZw9bqCb6l5N/unRvw+mri
IXCjtM/teZdhfKns+59NgSepEgJB7Nqp+IncOSQ7aW2+g36ixPGh06e19BXS
dVHtjkwL5i5dvt1ZXdU8FvRAi8qs6JFmu/6GZATEX+RYXBHhWpjaPTVwkG6E
7J0wVXHSyyRXuhoJOmFTofwT17PVN38pA3cqU0tu4loWdZj1QjAt8fo4BdtR
xOUB4kQKi2Oz9a+VV9Y1zD5x3LErPczM6Sx0lLU7qF+kBoHX+brHzaba2lZ2
bJVcFl3C/EB3DA5MLHh++fCQWlC2u+lNPWgi0K7dTidQfNfWcgJ+SPZaqz8P
YwsqTq1g54X1lamVz3P8OdY3wj0d2X1MwaOhzFq9qyQm39NQEgtJhYbe3RSF
IWXDe3v3sUK3MOBjesis+gInWU3ld+kQE2Qk8czpv7vn7lVqx1h2vHxV4wXa
jC0MH3+sT2WZ8wJ/TOrQWYxAzOjt3oPEjJReU1ryr4QPlmaSmGGXu+vddMaP
1kw2T6xxmWI8wvwofV2/Y73soWZZp4wktbLmyRCS5i2ntGOVFSN3a4ycP/cG
+Amc0thwUnWBEI8qs/qgQPxIcmPmllBaKZPLZaREpSPrd2woGZsTiQ+vg1mu
aB1R1swiMpahAsGc6ULhjdv3zOIC/G929mav5L5H4wI+fkX5kXvvaSstmVBV
wLIeL+GH1LY6/UzcvJ5oFLNLRGuUWdTD1J6lpTWlJdVuu2wihmfn0JxFeZcJ
Ywlfq65ulgoN7pd1VQwVslnROXjg/OpVlVQo0nOnyz2j2J4omX2X173XTS1g
Z8d58AnUNSwdWIUyIn4NveqWll7x0nKpPaRPioTYGiu5skLOjcN0DzEj6liq
zijvUF+nQQ+46FLyAHyocWcF8ixr7dyuytnbtfbAIwrOhszLOvtvaM6AgYJt
B2cULd2HANDIK8Df3NRTVbmZcweWmZ/hjtnoKJh+ne2T7EsCedhWD8wKbBKL
GyUKngxKqmz3PrOKHUjBm6Ds1Lto7w8oOzhw+eG5PYi/oASCeox8yUbTxaee
k6YahYGllZiUvorNfPg9lqNnalc6c8M8A/zQh3a8H+ufSemH9c/gFdCVmGLf
9wOamteu/ZJyPn/ebmUFIrtLmz173PfMdKuyy5p387lZ0/WHOPua6pbeHWMq
UvQ1fqQPmScajpGY6A7Jtih/uUdXnXETv+wgfxWcC90dy9554kH1kge9N77/
KlQ8QnE4A5iutZ6yri8V55JyILUSnGfJ6qrBgYMqamPtkagu4//Qk4zKNupq
gALwTXNzL+2Bp68wJTVXbVNVXru/bxw+0Z5RcxZ3Xe0J6G7VMzvcKUV5inMD
7gUyML8//eOVz3y/C/ObFfZc5LRTCU1N5umkd4qPqCEzK/p+UZk+vaqeVJ0J
N7bT5CsunB3oQ7fCYv++06pOWjgU0XpN9XHdeyna231YvaRlVkI1ZZs5s8v6
UNLMoDHgGZWnvDmS++yMtfSmJBKScCza38DYcCigHo4cfm1OVn77mzDkf/6l
pke+21u14aiqLqLUSBwnJSD0pMkEfuXDTZFzsKf/CPfKvjCJSYxNlvUY+sI8
1DyWvRvhY3oGly/9oqH+JNgOuJc2bPTgVCTKNQvKKzl58aJVzILzmACl5WdH
wn5FzpKMZ9Ei0vIkqO1QUfSihQ1zv90Fn0TJQfYupX+rrzFDdv+L5WDKsTgM
FuatZqDxmed2QaIGZWWh3uPfbc6hNb46M96clazw+msJhUQI/kpKqru7RrqD
01V8e6C5NwlIMBOte3smX/2fsew9jJ9WL7mwzrBO+Almg1+BINAJYKnCSafn
auJicHYpxkpoqDk3WSf18/RpieHWVzTuGT3OPROksurRB5zBfILl4fQA7dn7
kj+rtSxuAdYh2WCb//qnDfgpIO7rvaTwnuvxtS+bfmcmyia8VkwUBg1ciGdB
1d8pMExXXz5fvczGTwD88/NHgDnCBE0COR4afIV9BSUZfksERAq39OLg7wAb
MJVAPyInTBI2FmblgzOGZ5F6yQc8oBseBRoSpLlzmx9+qBogQUvkACydczIw
+Pkuv8sgJQiwAct4AsCDtsEz4ccAXTB5IIk9VyfbPpdl6iVx9szrY3sUZJD7
HLXAnYTywrNgYom1WAJD6DN5AaUCNKGhxXPMtWpaHJuFaSwrGnj22UZAQ+4h
QKABHg6YoFo+HoLJ3dORNDCW6M/huRFhsYQqGIlDogGZAi6hl+Bxo7lOqpcU
QEfEV1tzAMPgh3BxPmmel70G1D9R4Te860+8x2tro7ON6F+np7nO/f98/3+2
8WyeOkrmeP7kNXUZeo3d8H8BBVlxMg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 190},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->232509026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1827310088],

Cell["Plot several parametric curves:", "ExampleText",
 CellID->487939343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"2", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "t", "]"}], ",", 
       RowBox[{"2", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "t", "]"}], ",", 
       RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1703973555],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3054247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->273553999],

Cell["Plot overlapping regions:", "ExampleText",
 CellID->80726426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "r", " ", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"r", " ", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", " ", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"2", "r", " ", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1028962131],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241719718]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10199],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sampling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22776660],

Cell["More points are sampled when the function changes quickly:", \
"ExampleText",
 CellID->5555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"12", "u"}], "]"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"12", "u"}], "]"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172764079],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30710799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217171996],

Cell["The plot range is selected automatically: ", "ExampleText",
 CellID->749339086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "/", "u"}], "]"}], ",", "u"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", "2"}], "}"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264370273],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16498164]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->492757155],

Cell["Ranges where the function becomes nonreal are excluded:", "ExampleText",
 CellID->436316029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "u"}], "]"}], "]"}], 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "u"}], "]"}], "]"}], 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Im", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", "u"}], "]"}], "]"}], 
         RowBox[{"Cos", "[", "u", "]"}]}], ",", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", "u"}], "]"}], "]"}], 
         RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453187265],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->168113065]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56800412],

Cell["\<\
The curve is split when there are discontinuities in the function:\
\>", "ExampleText",
 CellID->430742835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"Floor", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30552953],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WD1oFEEUnuzenQE5SHIxpjAQgjEWptAmTYIYMVeoRSxMoc0REhL8SYxn
CtPEJtqqEBBEG220FCJCBFEQBTEgCqKCRJBYGASDxYEwvnkzc7szOzu7697d
sjd7b+ebN9+8fd/szB4vlacmzpXK0+Ol7uJcaXZqevxi98jMHNxymwghy/C7
3kngP4V/+FumFK7BcjeULgA6xNWBqwPXgrBJBmHiaAMjo6EyAZSLRh8rmQuK
B2lnRcazuRc/olWzXc1uYUWW29XS6kVSY0FpYtc6MWuN9NBm8FBvVv4+TZEq
aLYT4NQrnvPOeFw8hGi3IymDavb0ajUd8Rhk/QyIyFCS87czt26J9I822eMb
mWQrleCIbHOEUvz17Vo99+ZXYl7rbynO3bt33sBJXCy2tioCtYio7VBeq0ZU
96RnpD5eHW+Mh89uTlmftH+TooKjXIyFMsea97ix8Xvt7Xc4iYuFF+WFaqtq
3rqPVz7OnH8EJ3Gx+PzpZwCd+CnHvMtY8CgD0YNDt+AkLhaQHgI93xAWvBYi
pcTi6tIzgb5g9MFtiJiIt4PxhvhbW6XnzjPp4YN3IWo6o4yNz1kvnn8VaAfR
0Fqgz1p6zlL+Vs0aa6MUEg+Fc7UlaydDvbhyprdkMW+dE7EwjyOn3c0YUduo
NyNGP6NdaFcqf0NGVVKeUReiX7/6powCRhVA11MFPVi7ufnnyOHbnhYXLj8R
6NMNYbEXa0F7IhYOxgJYQDBZ1ZjRB1+N6Fr88P6HqDe3Ss99HxXzV4gWR5Wx
9VNVixztzRijlp7VNatc0ZozGjUWvTqoQbv91J7nxxL4ZSb3F66EJP5qFxfx
GsZDrpDMkbfn9gC1K6wY4aM2ChvCWuhVV5hADxt9DFKTwryZ1twqPfdD1KQZ
L8MGlbENx0bXluUI2tBPiA4GFJZFyVLJcrAD6Lh8eDrKQ0Iss4NlH2bRTkQr
Zh7F+zCnKSs6by11IC2HwK7NMsrA/kp/1wf1LXc84e95VnuC2jXUb3xWOL9b
NGRulT47T1K7KvqUsY3FRteW5Sm0YXYM0VCPwhJXI+7T1S+KhqBJAF3PubQk
n6iS7TdvvBTorsSe/d+rzJnNk5irXJa1fP8xcwLvw3v9UnnFi+6VxVWB68Tm
ftWSGCwmZbSU/F9f/5XKq4yKf1xJovL/b3fcabHVSYhS2pRcwZ1WYCd2/96a
WNkWEudKvLuz1K6rvMISd60WXeVT84mjq3mZKSG6am4IC/wGYvkuYP46syC5
h3wXSPJNR2Ro0z8AasVj\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->953810]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->460783138],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " to control adaptive sampling:"
}], "ExampleText",
 CellID->596378793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "u", "]"}], ",", 
        RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "mr"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"mr", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pp", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389502305],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{1., 0.}, {0.05996308887680144, 
         0.9982005950571021}, {-0.9999749232327282, -0.007081871624039709}, \
{-0.034369644073556596`, -0.99940918925446}, {
         0.9944047760427348, -0.10563683724628652`}, {
         1., -2.4492935982947064`*^-16}}]}},
      Axes->True,
      AxesOrigin->{0, 0},
      Method->{"TransparentPolygonMesh" -> True},
      PlotRange->{{-0.9999749232327282, 1.}, {-0.99940918925446, 
       0.9982005950571021}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], 
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{1., 0.}, {0.7829108051944013, 0.6221339655651781}, {
         0.17054761579185446`, 0.9853494358590327}, {-0.4867106704313184, 
         0.8735632337090983}, {-0.9225714372486704, 
         0.3858263121832448}, {-0.947090689177945, -0.32096608305620894`}, \
{-0.5391554419054319, -0.842206274889803}, {
         0.16095581032789916`, -0.9869616138035406}, {
         0.770368495985692, -0.6375989181238804}, {
         0.9997611394248145, -0.021855527813271023`}, {
         1., -2.4492935982947064`*^-16}}]}},
      Axes->True,
      AxesOrigin->{0, 0},
      Method->{"TransparentPolygonMesh" -> True},
      PlotRange->{{-0.947090689177945, 1.}, {-0.9869616138035406, 
       0.9853494358590327}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}]},
    {
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{1., 0.}, {0.9295155494896142, 0.3687829215907652}, {
         0.7279983134859591, 0.6855789200096509}, {0.4238559552852132, 
         0.9057296115117687}, {0.05996308887680144, 
         0.9982005950571021}, {-0.34240013028368216`, 
         0.9395542298248236}, {-0.68815243343058, 
         0.725566143341578}, {-0.9201286711851919, 
         0.39161617492510836`}, {-0.9999749232327282, -0.007081871624039709}, \
{-0.9251307703373695, -0.37964859775190196`}, {-0.7166906915175492, \
-0.6973911762361904}, {-0.404755020934184, -0.9144251598838301}, \
{-0.034369644073556596`, -0.99940918925446}, {
         0.3339190235299524, -0.9426017641214147}, {
         0.6558384846571028, -0.7549012399265714}, {
         0.8866858355800292, -0.4623723921059144}, {
         0.9944047760427348, -0.10563683724628652`}, {
         0.9968514008178483, -0.07929239993526206}, {
         0.9986002143106957, -0.05289245672714173}, {
         0.9996499923249876, -0.02645548798741278}, {
         1., -2.4492935982947064`*^-16}}]}},
      Axes->True,
      AxesOrigin->{0, 0},
      Method->{"TransparentPolygonMesh" -> True},
      PlotRange->{{-0.9999749232327282, 1.}, {-0.99940918925446, 
       0.9982005950571021}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], 
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{1., 0.}, {0.9859434973537157, 0.16707908314903924`}, {
         0.9441691599481529, 0.32946107114923207`}, {0.8758513899518876, 
         0.4825809183125112}, {0.7829108051944013, 0.6221339655651781}, {
         0.6573859392496688, 0.7535540636721634}, {0.510149105264919, 
         0.8600859784913382}, {0.3460632022511028, 0.9382112022608301}, {
         0.17054761579185446`, 0.9853494358590327}, {0.0014589574669642224`, 
         0.9999989357209884}, {-0.16767172697719682`, 
         0.9858428840198038}, {-0.3319725297038937, 
         0.9432890540666723}, {-0.4867106704313184, 
         0.8735632337090983}, {-0.6248298061722743, 
         0.7807609834761968}, {-0.7456479336198936, 
         0.6663401226763872}, {-0.845819701121121, 
         0.5334688680657734}, {-0.9225714372486704, 
         0.3858263121832448}, {-0.9768930830807698, 
         0.2137285760700899}, {-0.9993988139079435, 
         0.03467002681561854}, {-0.9893556524663307, -0.1455176722357841}, \
{-0.947090689177945, -0.32096608305620894`}, {-0.87977738770628, \
-0.47538589385962426`}, {-0.7874990317046473, -0.6163158890246486}, \
{-0.6728741633425868, -0.7397569602957541}, {-0.5391554419054319, \
-0.842206274889803}, {-0.377097791740211, -0.9261734478296473}, \
{-0.20247781944537319`, -0.9792868490042368}, {-0.021112669513092312`, \
-0.9997771027514237}, {0.16095581032789916`, -0.9869616138035406}, {
         0.33452296255008146`, -0.9423875994126392}, {
         0.4973477798942735, -0.8675512583324615}, {
         0.6442015668442546, -0.7648557650141675}, {
         0.770368495985692, -0.6375989181238804}, {
         0.8658260267084721, -0.5003451723302826}, {
         0.9370830871472572, -0.34910641326473213`}, {
         0.9821479903805653, -0.18810987478443777`}, {
         0.9997611394248145, -0.021855527813271023`}, {
         0.9998656385862092, -0.016392216890709726`}, {
         0.999940283073148, -0.010928416518085453`}, {
         0.9999850706568444, -0.005464289837300488}, {
         1., -2.4492935982947064`*^-16}}]}},
      Axes->True,
      AxesOrigin->{0, 0},
      Method->{"TransparentPolygonMesh" -> True},
      PlotRange->{{-0.9993988139079435, 1.}, {-0.9997771027514237, 
       0.9999989357209884}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}]}
   }],
  "Grid"]], "Output",
 ImageSize->{212, 209},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->533917475]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"v", " ", 
         RowBox[{"Cos", "[", "u", "]"}]}], ",", 
        RowBox[{"v", " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "mr"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"mr", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pp", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->481924092],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->305156229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->765232106],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus in on areas of interest: "
}], "ExampleText",
 CellID->316263374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", "u", "]"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"Exp", "[", "u", "]"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "pr"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pr", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "50", ",", "250"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->41892276],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->786477684]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->131776661],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Exclusions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exclusions"]], "InlineFormula"],
 " to remove points or split the resulting curve:"
}], "ExampleText",
 CellID->24664850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tan", "[", "u", "]"}], ",", "u"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"Pi", "/", "2"}], ",", 
      RowBox[{"2", "Pi"}], ",", "Pi"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94618122],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9372469]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tan", "[", "u", "]"}], ",", 
     RowBox[{"u", "+", "v"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"u", "\[Equal]", 
       RowBox[{"Pi", "/", "2"}]}], ",", 
      RowBox[{"u", "\[Equal]", 
       RowBox[{"3", 
        RowBox[{"Pi", "/", "2"}]}]}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->341334922],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->608462312]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5373264],

Cell["\<\
Multiple curves and regions are automatically colored to be distinct:\
\>", "ExampleText",
 CellID->150311282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i", " ", 
           RowBox[{"Cos", "[", "u", "]"}]}], ",", 
          RowBox[{"i", " ", 
           RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"v", "+", "i"}], ")"}], " ", 
           RowBox[{"Cos", "[", "u", "]"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"v", "+", "i"}], ")"}], 
           RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "0.75"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74897845],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374707872]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->579237165],

Cell["Provide explicit styling to different curves and regions:", \
"ExampleText",
 CellID->238286887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"i", " ", 
         RowBox[{"Cos", "[", "u", "]"}]}], ",", 
        RowBox[{"i", " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", "Dashed"}], "]"}], ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Purple", ",", "Thick"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235628210],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225881386]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"v", "+", "i"}], ")"}], " ", 
         RowBox[{"Cos", "[", "u", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"v", "+", "i"}], ")"}], 
         RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "0.75"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Purple", ",", 
        RowBox[{"Opacity", "[", "1", "]"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37527117],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->692434417]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->472187084],

Cell["Add labels:", "ExampleText",
 CellID->797294755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"u", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"r", "\[Equal]", "u"}]}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"r", "==", 
       RowBox[{"u", "+", "v"}]}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575371355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268483375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->455181048],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for each curve or region:"
}], "ExampleText",
 CellID->213196035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Tooltip", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i", " ", 
             RowBox[{"Cos", "[", "u", "]"}]}], ",", 
            RowBox[{"i", " ", 
             RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", "i"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Tooltip", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"v", "+", "i"}], ")"}], " ", 
             RowBox[{"Cos", "[", "u", "]"}]}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"v", "+", "i"}], ")"}], 
             RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", "i"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "0.75"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162853632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJw123c81W/YB3CiFAmpVCo00FIo7S6hYWREaf2yUkJmJaKkpFDZeySyZe9x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         "]],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJw1m3c4lv/7/4lSJKRSqdBAS6G0OxUNIyNK652VkmQWZZSUVBTZu0S2zKxw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         "]],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {Hue[0.14213595499957954`, 0.6, 0.6], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJw1m3dYT2/cx7/7pPpRRghJhEIlUlr33ZAyQlJCIdJANJARSZSkXSKlKdJO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         "]],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}},
    Axes->True,
    AxesOrigin->{0, 0},
    Method->{"TransparentPolygonMesh" -> True},
    PlotRange->{{-2.9999996494055186`, 3.}, {-2.999999577843614, 
     2.9999996348234657`}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxcXQV4VUe3xd3dobS4O5RLNxQoFHd3dyva4i6F4u7unmAXNhIgQIAEd0iA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     "], {{
       {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], GraphicsGroupBox[
         TagBox[
          TooltipBox[PolygonBox[CompressedData["
1:eJw1nQXUFOUXxmd2d3Z3dsfCxEJQVBQRFAuxCEXFwAQRURABkTBRDFBERbFQ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            "]],
           "1"],
          Annotation[#, 1, "Tooltip"]& ]]}, 
       {Hue[0.9060679774997897, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         TagBox[
          TooltipBox[PolygonBox[CompressedData["
1:eJw1nXXAFFUXxl8bdGfemdnd2V0MRERURMRAwQZFERNFsfOzu7u7u1uxu7sL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            "]],
           "2"],
          Annotation[#, 2, "Tooltip"]& ]]}, 
       {Hue[0.14213595499957954`, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         TagBox[
          TooltipBox[PolygonBox[CompressedData["
1:eJxFnXXcVcXzxx+7xdZzznPiufce7O5O7O7uLuwuQuxCUOwCFVDsr2KgYIud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            "]],
           "3"],
          Annotation[#, 3, "Tooltip"]& ]]}, {}, {}, {}}, {
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{842, 1, 1265, 229, 845, 16, 1307, 271, 887, 31, 1336, 300, 
         916, 46, 1365, 329, 945, 61, 1394, 358, 974, 76, 1423, 387, 1003, 91,
          1452, 416, 1032, 106, 1481, 445, 1061, 121, 1510, 474, 1090, 136, 
         1539, 503, 1119, 151, 1568, 532, 1148, 166, 1597, 561, 1177, 181, 
         1626, 590, 1206, 196, 1655, 619, 1235, 211, 1654, 618, 1234, 212, 
         1657, 621, 1237, 213, 1659, 623, 1239, 214, 1661, 625, 1241, 215, 
         1663, 627, 1243, 216, 1665, 629, 1245, 217, 1667, 631, 1247, 218, 
         1669, 633, 1249, 219, 1671, 635, 1251, 220, 1673, 637, 1253, 221, 
         1675, 639, 1255, 222, 1677, 641, 1257, 223, 1679, 643, 1259, 224, 
         1681, 645, 1261, 225, 1680, 644, 1260, 210, 1651, 615, 1231, 195, 
         1622, 586, 1202, 180, 1593, 557, 1173, 165, 1564, 528, 1144, 150, 
         1535, 499, 1115, 135, 1506, 470, 1086, 120, 1477, 441, 1057, 105, 
         1448, 412, 1028, 90, 1419, 383, 999, 75, 1390, 354, 970, 60, 1361, 
         325, 941, 45, 1332, 296, 912, 30, 1303, 267, 883, 15, 1302, 266, 882,
          14, 1299, 263, 879, 13, 1296, 260, 876, 12, 1293, 257, 873, 11, 
         1290, 254, 870, 10, 1287, 251, 867, 9, 1284, 248, 864, 8, 1281, 245, 
         861, 7, 1278, 242, 858, 6, 1275, 239, 855, 5, 1272, 236, 852, 4, 
         1269, 233, 849, 3, 1266, 230, 846, 2, 1262, 226, 842}]}, 
       {Hue[0.9060679774997897, 0.6, 0.6], 
        LineBox[{4091, 3250, 4514, 3478, 4094, 3265, 4556, 3520, 4136, 3280, 
         4585, 3549, 4165, 3295, 4614, 3578, 4194, 3310, 4643, 3607, 4223, 
         3325, 4672, 3636, 4252, 3340, 4701, 3665, 4281, 3355, 4730, 3694, 
         4310, 3370, 4759, 3723, 4339, 3385, 4788, 3752, 4368, 3400, 4817, 
         3781, 4397, 3415, 4846, 3810, 4426, 3430, 4875, 3839, 4455, 3445, 
         4904, 3868, 4484, 3460, 4903, 3867, 4483, 3461, 4906, 3870, 4486, 
         3462, 4908, 3872, 4488, 3463, 4910, 3874, 4490, 3464, 4912, 3876, 
         4492, 3465, 4914, 3878, 4494, 3466, 4916, 3880, 4496, 3467, 4918, 
         3882, 4498, 3468, 4920, 3884, 4500, 3469, 4922, 3886, 4502, 3470, 
         4924, 3888, 4504, 3471, 4926, 3890, 4506, 3472, 4928, 3892, 4508, 
         3473, 4930, 3894, 4510, 3474, 4929, 3893, 4509, 3459, 4900, 3864, 
         4480, 3444, 4871, 3835, 4451, 3429, 4842, 3806, 4422, 3414, 4813, 
         3777, 4393, 3399, 4784, 3748, 4364, 3384, 4755, 3719, 4335, 3369, 
         4726, 3690, 4306, 3354, 4697, 3661, 4277, 3339, 4668, 3632, 4248, 
         3324, 4639, 3603, 4219, 3309, 4610, 3574, 4190, 3294, 4581, 3545, 
         4161, 3279, 4552, 3516, 4132, 3264, 4551, 3515, 4131, 3263, 4548, 
         3512, 4128, 3262, 4545, 3509, 4125, 3261, 4542, 3506, 4122, 3260, 
         4539, 3503, 4119, 3259, 4536, 3500, 4116, 3258, 4533, 3497, 4113, 
         3257, 4530, 3494, 4110, 3256, 4527, 3491, 4107, 3255, 4524, 3488, 
         4104, 3254, 4521, 3485, 4101, 3253, 4518, 3482, 4098, 3252, 4515, 
         3479, 4095, 3251, 4511, 3475, 4091}]}, 
       {Hue[0.14213595499957954`, 0.6, 0.6], 
        LineBox[{7340, 6499, 7763, 6727, 7343, 6514, 7805, 6769, 7385, 6529, 
         7834, 6798, 7414, 6544, 7863, 6827, 7443, 6559, 7892, 6856, 7472, 
         6574, 7921, 6885, 7501, 6589, 7950, 6914, 7530, 6604, 7979, 6943, 
         7559, 6619, 8008, 6972, 7588, 6634, 8037, 7001, 7617, 6649, 8066, 
         7030, 7646, 6664, 8095, 7059, 7675, 6679, 8124, 7088, 7704, 6694, 
         8153, 7117, 7733, 6709, 8152, 7116, 7732, 6710, 8155, 7119, 7735, 
         6711, 8157, 7121, 7737, 6712, 8159, 7123, 7739, 6713, 8161, 7125, 
         7741, 6714, 8163, 7127, 7743, 6715, 8165, 7129, 7745, 6716, 8167, 
         7131, 7747, 6717, 8169, 7133, 7749, 6718, 8171, 7135, 7751, 6719, 
         8173, 7137, 7753, 6720, 8175, 7139, 7755, 6721, 8177, 7141, 7757, 
         6722, 8179, 7143, 7759, 6723, 8178, 7142, 7758, 6708, 8149, 7113, 
         7729, 6693, 8120, 7084, 7700, 6678, 8091, 7055, 7671, 6663, 8062, 
         7026, 7642, 6648, 8033, 6997, 7613, 6633, 8004, 6968, 7584, 6618, 
         7975, 6939, 7555, 6603, 7946, 6910, 7526, 6588, 7917, 6881, 7497, 
         6573, 7888, 6852, 7468, 6558, 7859, 6823, 7439, 6543, 7830, 6794, 
         7410, 6528, 7801, 6765, 7381, 6513, 7800, 6764, 7380, 6512, 7797, 
         6761, 7377, 6511, 7794, 6758, 7374, 6510, 7791, 6755, 7371, 6509, 
         7788, 6752, 7368, 6508, 7785, 6749, 7365, 6507, 7782, 6746, 7362, 
         6506, 7779, 6743, 7359, 6505, 7776, 6740, 7356, 6504, 7773, 6737, 
         7353, 6503, 7770, 6734, 7350, 6502, 7767, 6731, 7347, 6501, 7764, 
         6728, 7344, 6500, 7760, 6724, 7340}]}}}],
    Axes->True,
    Frame->True,
    Method->{"TransparentPolygonMesh" -> True, "AxesInFront" -> True},
    PlotRange->{{-3.75, 3.75}, {-3.75, 3.75}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23913430]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81019509],

Cell["Create an overlay mesh:", "ExampleText",
 CellID->130631304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"u", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "20"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"20", ",", "5"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394612338],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155659726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97546811],

Cell["Style the areas between mesh levels:", "ExampleText",
 CellID->207010765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"u", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "20"}], ",", 
     RowBox[{"MeshShading", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Orange", ",", "Yellow"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"20", ",", "5"}], "}"}]}], ",", 
     RowBox[{"MeshShading", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Yellow"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Pink", ",", "Orange"}], "}"}]}], "}"}]}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245937364],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVvQ18VdWZL7zK+UqCIEptaS0VW2Xo6DhprS3WqihFI4gEiwQJYPiSRIWE
BjACFfGDaAWhgoKt02gFscotOAgBBCNCgQxiRsRGjCMfHeb4WjAvN5cbwJff
vv/nedZae511dgI6c+ed4Rdjzjn77L3W8/l/PtZaA0dPKR0/cfSUsrGje9z4
i9EVpWVjK3vcUP4LvBX7ilJfeVAp9Xw3hb8D/MX/0b+H8J/82fZfQ+h3zHwj
UA/iF71Ucf5Y/ztHv9sB/++A/5+rX3fVr89zXrvXnRN5t695T25uDurqcAn/
qq4OZs2in+XLE/ROLGht1WOr9MYa816fTb/i4WsZh3vFuaf9xte9K8457T3P
Ps2ouvLXbqHfKUwomD+fZldQEPTpE+TkCHXxKxl060ZvlZTQxytXBg0NE/Ad
erR/R/91Sl8XP+1Y89wr/3+hw018H6KDEKFLlxTeJVlJYPb4Ummp8B/3x+u4
JhT/5AY89N69g8LCYPFiUKjsv7FE9JOPQImqqiA/HwKAK1I004oKIgE+2L49
SKeN/uECVpSgpoY+HjYMX0oIRXJyiEwQrC2vj88cXRDqa/tj7tLmlefpT756
ZvPOerZo+3X82bLntl979TPzCu4H3+OWm5j/8uXBvn0p735fE1lpaCBmQy96
9IjRdxLLri6gu4ysDBpXBp+3qtF0XcJ9rtK26PRzbp+z50Vx7vQ0yBoLy5C6
NhAVXB4Ew4qumYM59LtqEVnjHj2I57W1YHBH737flO+k08T20tKi66rpa9cu
Ch5QwcM5wWulQVPtKE3puP6/4WXM4ZzhbQc9Gve1ue4c7z48e/VTkdMgHQSz
gqAHzRiX1D90SfkPptRWTAHffHnvzlSq33GwvKSmdu6cYEl+DMPFPeZ2CzZW
Bc37+MIE3/0n+u61oAm9lrsHQa8gqA6CRlCErnN9SsJ72oVyh5Z0UDcrWNBD
6We9VBi8t5w+YjnkZ/UOxFjW8O0V/+QEQUkQbGfL2D5n/dcXyXP/sj1YVUKP
7CDPXdAj2D6fpFJuc4WeH3zY/CDoJvPD6248v2am9ZnZ7g76yovtfBtqgkW9
zHMf7UK0bW1Wp/jrPwzYYtBcu5m5YtI1p7eI/uvvCdWaaoPn+pDU4QfPAq3x
rM/5Fj/Qz6oLgnzzrB541uktpf/6ErkTaOo+a/v8W/H+c7gsh2+Tr5+XFpnh
H0yy5vTa6b/+O7nTvrrweUvyYVUKHc1o7/uRr7O03/e2p7tL8r/FU//rjLKD
lYy/15dAtboY9cbfrQanGkvn2xD9PbgTqK/IAQTir4236Osv864XL3nixP/X
8M6hV17eTXes+d3bCbxSsZaWE/qqPO9bvjfxX3fMmIuWTdjAUKsg7ukLvW9p
bfi8lewOLKw4hi3VA73rrqZfue/v+WTTxo8w2PJJqwcPeqFf32fLb1m4cPgT
iudwx7wEXqrYgJtq4GbwozrQrwSuxPUzpq/HZJs+PKyuj+KKupQ5zIYuxxiB
WvVd71ptLVqbxW7Sz6JeUPkB3nU/ZpKk0/8TjgTjnf3AxrFjVmA0ZTcvmj1k
AYbaUD7nyPQHyd4/IN974AH6sxP9ysUn+HzL3Y9ibmP7L8KEpk5Zu2xpA+av
rokc/d8G1qoUGHrDNTRf5F39Q5klbBSGLeOvm8XUzY50fGm9nHlw5MixZ5a8
WVb6B1C/qN/TUwufxGw2lT3WVPmIyvVmcy79ymmZ+WD9xOpnRszD5PElTAUU
gbT9JHIm39N8qDW2H7qwXPXUI7zCysu6Cj3+Z3vDKf/Uu9fpoo7v831Az+o5
bxbd9uKjtxa8NHziiftnd6QRJ47PnHl42rS9EyfiC9vGjlUJ+jN2cPJkvIsf
FcOvs+jKFL6CuYECdxZUX3vNnHlztxCPfhw5s156ZrMMg+DS0+pvoiQnQR5L
1AEupHEl8+1MoqmYphPrfA50vHbtB2Wlq8purqqdcOWJ+xMt01VdSUmKxp73
2b33YkqN99yDKa4bMWLDyJHblNrLrD8MfaK/Yg0gAP+oGH7FVw8fruK4we6y
skOVlSAT3ym18847P6rIfXX8NXjOyOI/QFIhJawrMWsReurZNwdBH0OAauG2
M/7echXwASCQlU9fUk5HBdFlaN8zS+rB3eqhJe9PvhDCDazRacNIhXFbDu+a
MGHz6NGY11alMNkmnvtJpjT9onvyj+pMv3JalNqv1C6lQC1Lh2MzZnRgycdd
N45Sp2ZpPJU4MK3bMyMGw/4sfHKboUi2XFysKbPPIDvIfZ1otHPtT+SqnYvJ
QIqJB4ZhemVFLb7m8r0SMEWwQ0X95iwbXXBkemfcDGPM+exe9cKtavmQIZb/
h5Q6qlSuN/9z+bWdv+qwcdQoyEdp6VujR793Fz0Td4u/MrYvBAD6DdHLj5zt
RXq2DcbLYc6Ngp2ca6+ydkq0AJ4t3aB1w/fCfuTFGpWAJ3t11fsYzNTCSZvK
rpDZJsGbg5PV5tFq61a1fbv6ZwW/RQQ7znwX4QcV9hj5P8TvH6Y/D+v5a3rk
cMR7TKmDSv1WqZXD1K4J6lAlc58lLd4yM6/mjoGQP4zj7yNp8V2fFgWEqi/1
rv2pXAWfIzgP/H9vOVtCN97xUcHFRgdgkzCGecOKIY2a58dnqsZ7FES1oUEd
PUq6ePgwTZuj+I5HeU6NTIh1kHS2gWIMoTMfl5drewjVwQdkH2P0Kwl9WK3U
Gv7eXiYa3y/nU6V27KCHHDqkdu2C5qiGUnX0Pk0lSCLGBj5teWvf30VS6TuB
9Qg5xrG1Kv9a9otxiinFbOxcfJ22PyxxcRKGG2fDRoEtTIUEJB8sw3CamtTx
42xbYR9OnaIpnOTxN7FNgGXAvGAlIOxNkyaBBid/+ctoz33WqVmzxK6AIqv5
q6Djp3y/gPUGNODnJE6eVAcPqs2biRjgh6YGeDTj1jLAFQCVvw1cRHWhzI9i
IjGeFb5MXStXwEIYw9nHu4IpGYdmwAeD6PAH/NSEqxUYIBEbjwUlMMKFC9UK
lgA4CrgLOI1IL5/CByDOjnHjIDIblXr2WdXczJYIs8JtIGx77lInf6nn2VDe
c2z/mTBHEFDfBwjXe+j5Wq7Pytf87COfIICUeb5Weq13B0GZgBgQq/qJl8gz
E57UyyyTx46pxka1YQPx4Z/GK4h3Hs0n3jJ9enrKFBH7DizkmBte0jtxln9Y
fo0HOjAogBvQFGGvmIRzWD+CqLpxo9q7V7W00HSI2qfUxx/TOJomOdYCNgqj
haMAe3xMIBS5wKdI6fe96yRPRZGA+IhVJT5aZKrG4BbLb6kkHxAzlMnQBOH/
Z5+Ruso4wThcmZ6i4OoTjFEFPey56y7QZk1xcZ1SO40BBT3IVn7Kr+mtONvS
XRZLdKBfCTgQ+BxYEdD86H33Kb5vDvQMtgEPOzZD7Z0ItKK2bSPzxLSLQ2vA
LYwJ8ipchRDD6cDCAXXA6egMg0+7b2vaNVgb4vvi6+UK4C5Du6u9K/geMQgs
ABVcqDw/9ulUGqPVmoRoDfR66xhyB3LVWaAfIJaYT8jF1jFjLOT4mE3NqWzE
0Yl+5R1nhwyHtBm2tbhYhBA3+nTq1G1jxZ7HD0+DgqqdO62MxcFFSDkGBpZZ
bwQsAjpBLfyoQGjUXdNon/FGJZd71/XNotFPtY0S2iA4Q5hDWIvlKg7phtLD
+INtIvsYF/Fvo3YBMv4UWL27TP2qn9rEMwXC+ExlIxCuNOScYnu6lwVpYf/+
rw0nUQB5hRKYbl0dTR0PEkqAJCAMyAMiCccg95B+AGO2h6GF/Zaef7PBYQU/
9Ob/s6z5X+Vdcb6xsIgrZg8ZB6JLRg+4G/IAtdd0gG5hkLA60C2y/oJOIEs7
7yTq7N9Pgz6oaRAHykgb5Ypt07qkdYtxStzilJOEhwiZ4A/cHnKJ56wbQfoN
2mgqgWJ4CBhh+BIn/7+NHo6BCpUAmgHjQmvqS4uhloSbsM2tPrX6edSqm+Xj
eM4PxxAxQaMQn+gnkyvazBY6ZnQecwD58EHC8VeQbogW1RgkLwmi7RZJYU3K
bWHNERwDlw5zA+MlBp0jOLbg2qIzosmxiGYdq9tuBkItRjPxN8YR2DwvaAsm
wb4byaJxgZ8gLRgNO6BpixFiqBBwfCzSAFgI+SBr1SOStudr2lYEOgDed4V3
3Q2WtuIDG2qu9K74Br+GUYSsE/ITjYSiQBIwDQyPqRuDJMLrg5yatuIlCaQ1
kDmROXTEX2uZGnuYnIA2QHsgl+AhoJ42Mhmw6/srKgCccPk6dhHAVOuh359p
exkHnyF50E+LCDFGWA1QEXY0YTgL9uN9TT/Iyozp66Fl4hOz6MdzT2DuVGmZ
W8w2v079yLv2xiATLzXV9vau+LrRZuAlGE+4Gnk+kCPYTjafqRMDuzEBqI6W
AxdZQno10oAcYKa/6tdv5/jxcAOgm4+kzmHwAHQJ5AHi/vqmEDpoakFPoRu4
OUymUAv8gi3Fm59+qkcDimJ0uEBTCwgIgJLiz2+3Ta140a2/oeJM30XB/36Y
4iy6rEAoJKmWuWcHn238cRBWYVQMEgw+bLk7X2suhB+yBEQVai40FMw0kh+H
hQMnBWbyjFIQRLAX84TxgSLhNyYPi0wYDNIjGINCNMZgAKFaY2P8C3QEEGG4
xbTDtR+Xh9ABDyL7kDD6KigUJBPaQeR2jCOmgGSiDRg7aEeeSWjXVNkdtunA
gWa2d6Gv6CaUaW2ur7q+vKSydulQX3Z0rXhVwbKnuOD36Gu+/J3n0JBQqjwR
g4MswTZrboLj8Gigm+9ToUKCODDmPXvI2MPEENelpgICgEJEFM5N5ALPwtxJ
tgc4YrPBHvQvyXityfqUGP3quEdCn+HDBfyDLcdnzsS9oO3AbVYb45B2cE0k
UCgt8BYjMHg/RghlG12g6QzJgBzYWcXSVV1BZ8qdfStSRjW9Jen6bO/g89Y2
6P15c9Gtj7IgPx1Nb8QcgNphzQsjg6CAypreoDzoTz5ZRgaK4jV57oTx3IKK
IWdEA55fHmby2vDhlrp1HOs1tYvsciTA3Mm5JDgn4MO1xSGSsbJpsC8hS9gC
DBZPprhBxocv4DqYSk1ZXAXhIHuukcfMPHgAIDPxKlmUFRtHMYOkFv7a6HuS
/nxF/ZbN5ROratfi0/m+N+LqegwuDYY5pCxoItBPjwyQDPoIG6FlAugYukae
IG70E58LbBZciLnh8vUj1ZMOMSXz4uNCysT8o1JvvqnBTkYmRvAxBgM9t/gY
OkPAvVKPBkYUrA8CM1q4PwhwOBsYfwA6qpd8M5KOXzMWQWesdi720c4A7dXr
Al3c2f7DwOlOiCH2QyQTPhESAHqcOmVGRDiiTkHbQksAjYcwgsQx40thSDF7
XGSRNfnSUTQ3zJlwldIIMX4gr9um865Y+J2hRNPyyypVcnavcTUXDJSf2q9f
iQu4RyMHtMV9edg6iSPynzA2HXx0og+yorgGgwv9gkAOPROIMcgtpV/6tXD4
UEzeeNzQyjJNYzqn82xv5aPtmzVFZwW6YNPsRyzSIQMgC8iVQVkoFkmmIDmM
bPduMmInf6lcvA7HpGckCISsq6Ak3AFkFqRn79MJIvWxEct0TtctXfNBSFC2
31WLENvD8ki5TeVQra2TlLLkB7qDK3AdrsZ36s+55EiyMwywjRi0xErk68U6
ILcdJWxBiJNwaYYGwkrg89B2QNwwKMKhfp+QyPR5Qt+/bNe2Id3QFgdauZqB
dwt9DnAdnXAoAFTIAVAS9LRZtxjEZX+FIxERMYBIFAYfN7OHTuMigyRyd+8+
a063n0y9dNLgHz+OOBdeVepMND+/QnAW/cqRGiiuAr7Dl/p+b8L8J4Y0fdhd
vBjIamNoN24CGzBwGTc8GkYRYi3xcxYB0ecZyBWuB+OiEX2tbYrHdHGubpYy
8fUtms77TGxec3GQ2Vni5/ylP+il5dvm3HZHBt1pvHZ8mCAmZT8nmwLNdOMD
8IDgmslkxCXwgrbDLwmuBcGq55QMGvjoE/M21O84CKCZEyUDwL//E/I/dsyK
otvm1PxuYEtLnhuhw4TAkDCdgeoyuE9jkABBU1EsY8bnGYgXiBRUDn2+T2Xp
BtMZxAU9gCb8+qGh9+JAR2Bpziu1258R2b9Hqn5nQbUIAR6H3zTUY6ElzPAy
sDv4mLy5a3cosrDxGzRYQjOR0oZ3ek6dMglUrV37wVlRfplqABBxEH3Z0oIT
JxLanoBmsA1uXgSYB1QNMRoGiY9DjEbIdFvm5xlYednogmeW1Id4wKd6V89D
Nq70M2yDNBmlMaaA4xVb9Twt7ellZ6Y5RBAEOTL9QQQQEpiR+BiMj6AMEa7v
Z1taomyNjfcg8zRzoTlQ0NgxMxFUQdw7eyNhvabqE9ce57zyct+Q5pJlAQPx
SLkzHoGX5GcsLgZXYApDdAe3FKI7fJ6hCYAkcCNGx8Jqa1chikRuLxVmdQ0M
0vKdNvZk+UVfWL555ilQoaF8jgSwzVVViwaoTz5x/I3289HWx7MtOn60XiEB
yoF+oCLcI3VuCK0RJWg/2gEPV7EbfrboRz98CO5Txel1HIS3hr8TzwryAHyB
+4BxCWOXYWFgZ/STwW2Y9cCiP8AB4KZw5GIXoa0Olh3jRFtAh0DZFL90jZR9
6bmhurbkwtINPkcKNUdqAl0CTn/3C3OEZytoZ56N/FINpaWIJsVg4nPASIhU
KF9ijvS8PHujowsbjcZfXXXN4EGPg5gwKtztmYM/IIF4B7TnBpcqoDkaa0N5
T0RTk3Lx+APTHqaSzxyVs2z0XIyt/JaF/fo+i4APrNry1j4oS0fDJ+7HCPkE
poA1IS4Ax6CbIZIEPgIOCxENjKmbo2MJGxNW5GN7KzrdMrCaciF+77TDJ0dv
rvWuGqzJLi0MpeqL80hsNKR5bP9Flkc5BydPbmDYCNmHifiXfyEenZqlRw0u
iAELvYaYpyz7JBYMegOPPG/uFlA2l7kEVXh11ftwioMHvVDUbw5FMmP7gkNS
/6HRcQ4MCogYVvp4ct6f/AjYNePWXw+4qQbahduB0WA33zGOPxi0zt7yVn40
+oRea5QtowZQwyzCz+lhjSGvUiKYmBWsM9UR73wE4LQNPp2TpU8mZ+XXwQdr
vWo0lZ8Gyme7/XQ+cmIOpQAJ6ydWi11rmT59s8SeHTj2RMi6qL/6ZIpjHTDy
0DNSJtqVWs+uxQ4c6FZWWkUVCKZlEmyC0oI184YVA7scmd45lckXSeZITjUJ
bXp1/K9mD1kgIBeiJBw5cKAZL8snVQJZRaNTyltuDj0d5X4zcBNMHEx2qD1v
v029IU2TJomUwtss0N7G7z53uOJojx8t+Lpxq1aQau3vL9McEQ7AMkD4hAOn
Zs3aPHp0i+EAVYHAEbj3nXfeCTnD8yhxmA4lDVYhtN6eFYtt2ngFjA95FPaW
CeMfXkSU2DIzj7KPlJ+ZxskKxXHGaPXrm1TNoEEbR42KcyYyrFuytsS33P0o
NNrhB9WfgRLAa8fbjXF8N8VAWzn/4eIt61NyBBsAM8DcUVZKUXns8LRpwgug
G8I4sGRnB27M3EXk/fNWjbLSDVTpjEdohunJNhrSajruVvq9FWydk3hcU+Uj
wg9MfY+SvFYKhgvmS5gEqtSOcPAKJFB0OuQEAX3XUi18cij0HCrAfTxhxwoM
FPGCI4JOwJ6IwmAYQMHVw8muEDcVUQdkhUs4pBScGCAWjSiyYCpV+Qw+SZzC
Fd0q4OgM307VsphjfSnb70YjZMeET/hr7VoKDJvYRhzj2ghoIXzaVPYYpkcP
8lcaJEN+xaj9VXIcfiTCOpOi1/vqls15iFLJ1XezA+ot40kx2/rwTwnnQmpo
TYCuvlE/q67P+X1FeVFaBvk+bu0cVbxKS62Xomz7CkVFjTa8K/4iCbd+6siR
zjBHBNYsb8m/95vz6vhrgJgEe1GOCoYHDmzDSAoEcXurE9LrRT+UCFU695dR
A6Y6+pgxe+66C6qYyOKw9IZBuIBOgF3CHCkeROjPonDYCyu1OZBPaJ51ietH
jlzPrBWqAKzvLisLqRJaRT8WyOCwxPSNK7mTr4NBCjlUw1tVEizJF2NfdOMc
KcN0CgSMFjAL9+muZdNOPT+rS0xsDvw8VIc6iwX7UbHEZKSOcw30FK9OI/8O
gm3laUGTgLOsWEf7NOgHnD0hXKHpsqUNI2+cTVVbLyMGMpKHSWXyr66OCqmS
+U58xpUH6Ces92f33qs8vsGRyTNgCLh8Z8bgo0HK8x5yEATQ4D+NJxEEiME8
ZfLaSm1j2ylyHtrOaI6Jpurq6qJe4scY5TXvI+82t1uIm5bk1z85rXxcde1z
D9Eo6nRUJf+2m3fms2Iiru0R19PJZ7eXNl1bwcpA4/5WvxeSOZuCFi0c/oSM
n/pMHTySokRheXmkp4y9r9Tzz7fj4wG1oRtUS01qFPFXAuZc7bRVMqnvgNY5
TGfoJxkBhqpr1qjZs9VKet5qAlMbTZePrZ6zzsbTXE2C6wQXmN+xN0ofvnnA
w1SZEG4DoE6dMgngJURROltpJVL8oR45hvAPSr1XVqb1EDOHJThqZ24Nsf68
dsJjsD70qE7tcV0aj7fPl47bXKqMPNdH8T8RB1qqtK+OXmtfSx0ji5m73WKa
u8M4za/XLVitXcx9rqT70dpK1cs2tJU6bQ9KvaODked3y8qEQBoh2ui0fscl
gK92ZhQxD/n5k7WjvxXWQ/BFcBSIiTv08kBVfF3YyfrDznUa3RwGlmv7HY/N
mCH9bm5Ff4fp9TzFCEO74G2G0zz2BGaBl59MowoKQj7N7/odB+F30+mu0ViB
/CqGCFnbsYNM1HFmJ0Rf6GGtVxtWeWrhk3iAQS8hPuosPGtt1pFD8z69su4v
26mw+IBZt/VaafDXxqzo7ZwQKy1nLueILC6bM4Z7DbZozGv0OT+rs5lHkeJa
z+OR2px0tRmz3GwsGDQOdg1vfjp1Kgj1cQUVLUxO60OqU1NemTmeB61CkH10
xuyNo6iWiTlJEkwSeFJ5B8/hBVevpvchPsJtnQcWYcc3N4wcmWu6EvBc6Wxd
w7qcNhxPCsdhdtJTpkgFvoPJCOo+DZFDGHYg4hBp+TgdYvfEEwTlNE+pc3jc
uJCn1puFOuDadASp9Cw/C5oM+R7TOd+lBdJLnqII0rYMg+tbqqmr3kfKX5Vr
9SrSbkVXsY+++qkAINTwu4dA56y+fZF1+Jqifk+fuH+2zCQJnHzIaPpRJl3M
rKRIm/c/YyUKLQAo+/vfh9Um4Nau8GKWurm0zmjIAjwDV1M+oZRS+4gwyGLa
7hHptQG4TTl8hneArenMXhj+GIPYzL1Tos9HubK6fEhYHUOMCp8BNKf5Kh0y
sDoakUqGFdIDKwOl3M/JDT9aEF91hhbbX1mcwVNpi39vuXT48IpIu5SMl3pG
rs1OBq2f1N8zrDy/svbrV9Iq9FmzzHpejZmjeZl0ddfRz+RORa0rWe+fJYGq
1XXw+l+VzozA2UEhQMiE8QeIFWrumEd2GvP/h0GDwD/ieDyTf4enCf+S8M0E
Y0mC1Is/V4/368drdBIIfKRr41BlZcv06Tr2wTAgeBvZMccMEsMdqfI+xsEI
TZXdqY8TWC9pxgX+hnr7xhvqpSEK5kD7LSjpp0ZqTxozrSLtdMraafxAVsn/
AYdF81eyt6SjoqAtae48SBBXHwgXOrI3pS93k682N9OCexlQ795Q0t6h1ZYI
d/v3tE8QyUCgUHbzolA7XS10tJNakA7b+i6jV9Fa+/5RKpTH775rUkg7EA4h
oLVhcdhRkOs9TsjGsrjKWDpPuAobv24EuUDAXvwDPqe4hGSBAMQps0JhFwjO
ka6s0qDuqYTx13DTGxlr/2+22MeOEfADOpemRVPr5g4RoC8ZcQ60mYWyKwQP
DqJeqU133AEhsmuc6mSF1BnZ6KQr/ZBsGKm8DH/cybXLAFp6heLnraE33lKd
JR/flKtqa2njEbwL9a2pkdVQMdM3WZi1uoznl+SWtUfb11/8sdO8785AZif9
PA9ePOIPL+2QgdBzgGyWjZ5rKZEH+oMlohhw1ICz0snq1NxS8LjgtGUz8FjY
lSCxE9VQdB9w6pRZpbSTwSHsKNlKthVxPG33XXc9yS0DYa1omxPlAtDPG1YM
66X5DLMzauTUtWtTaSO7MMY2b2Ez0lpvaQYVFZF2O2XzBOKHodOERPwVxEmX
34Kydy6WVaWJZYteJ/w0rJic8F+2Z/nw87M1G3+0tv5Ia3baZHfTvbxvJoyG
u/n2JIb/WZSG0+oD8z4cIKxluLLPRZubzrtCZ3Xk/jaL4lg9h0JxgNc//lHB
btruDfCFuhH3EMOTDr/Bvj0mTj7GTXrgNPCgXXMUBw744B6SIkiURJO4C7x9
Rl+H9psyujc2/fkXl9xteRmzSFLbbxeNnGL7DWnSn4km2M8oP2RtO6aMiTP4
aI/XYCkDbVn/mAAXi679ld4J5JMPsqKx7nLV8uVBly7ahDc36+5dTnHhwlkq
ks9JN2vflg7L+0KJU7xYyc4oIwI7kuw89gczyTsJFQm99g+9RAxIaSuHJdoe
QI1WDB36rul64m6RUbpbhDmchAmXuHndOrVkiVpCK2qJzxvMmrm0ZDF53dxZ
xzmLCYLD6GCE0D5JfkjfF7C/7dGAjcjoWUT0vmxpQ8h/xCWvfuOaaNxMiERm
IRQ5zKgz1BQIg130KJGJjkfL5wADts170eAg3aBzKJr3ra1Bfn79OZeU951e
W1OblX/5tlzV0KDten5+sG+f3YekjnnfI4v3cYNSBly3OPTiri473jrjfTAb
LI/W8XkXFcMphveHX6Re4GkPK3s9dPyY4X/eQX7G5/ffX1dCWArz/nSqXm5m
OrTyIApgFq2C3EBOWOJs4GoG65PZkufatcm420azoPKgjIx9f+IkC8vKYcNW
DHW0fn8F2fuwyiTVnbDeACff8M6hDHqNvHx2OqdrG+gb0HGX68kBPQD53Py/
/R6ENLR9UBKYW3Yx7UmGYLhVJSIZcdoTSvFuQtl78lwgUrFvH8mDuchKhURe
dbzu166ETWKqiIBltCDntihLIDM8I0ugfZrok0UQesYW/8m9cvc6/hDWpn68
btmmOjvLQVLWZ8mqw0OVpLpu3M39q5UcdydlRakAOcmCCHLHH28p9fbbum3R
qQTXccRna0oZfQpHpnfWmU+ZCa29ya8KPYOX8c9AwqJDMmN4ow1uzsLFTgiO
ADJyMlCe5rlEao0rZf8F3i8Pt4aZb2z0K4o9jK/QPMdveIEfZiC8iqzdE1iy
MyI0QWxi92QGQVStIyWWIDIjE1v4naGvvLw71Byvw4JWJTQ5/I8BK7m990St
3w0aBK3PXMW4kdBA0uH75hL14cSJsjYJ45PByMqGszCmpkmTNjAiOMqD28bL
aALu6JDColuvos5RawfwOsyjNpT31JY7YWdzwcAgkpcuPgZJ7BJX0Y5sqsL6
DriphjSlXd2X1Ftrs+z/wjvqiZTV1p7jfe/CSDm4XDOjITBZc0INMZVdzReJ
cGuXgv2y5+ratDOzBiIN9TsOTi18MuS2RUzROkURIAzGvyjC/Iz0zYrgjWZF
sKwGbJmuY/s1xerxG6j4y2v/Ugj1aK8GDu8BCvT6K6mhwInAvb2gSL6E+4j2
ZOmc7nSCJdq718n/E950O52AHXUvtvUSVCvv2F3PxstLZ8TErjcVyQmlypWe
hcOfgD5FS0hHDzfIGmfNfDzV7N4pa9lDn1BYaGyD+IParLV1kbuGUFdqUb+n
ZVzgzDoj7evIL/9S3ge5j38xOxEztHPz+zEE0Vvd2LmFIw9LSx0xHrVY62MK
+mHPnZXzucAU0tFP73NiANID0Tlm0EHOcZMZ2M02AoOHoODWcSMhb5bo3L/k
H/B9+CK339Grq/ldwsD9ZRr3xy0y/sHMEx0SmtdurOii7ZM8mtPLDlQVCku3
9jN3GTLy3nKSkRXDjBWBxRQD0drqdw1910qLxBRVVZdrNlWxtJRw7ijONDwT
qald+0H10AVZM0xa9Gxt5xe2JymAznnD5lsvlVHNk74XyugJpazEhHHmihXq
zRK7PpDWIkL/AT4gTYQ/3NzCGhZezi2cdZJFRhbJCsxDfCN+Q5pQYVHcnmTb
/8BVf+nGFmmBPAF3Ug9hB5NfAjcpW5yw3vn8vtmx9wZGN4HNl1RUZEegflUM
EE9jWt/ui6Rk7o6iO5O2VMueaXHamTKHypPB9u1+36b0w9JetvLsurofaPaL
z+kSaV9iHA3Q43k11GPCRcqBGwnZa7BBpsdJ7XfyoqfBHxneTO4dmVuHZHxm
ohPyQv94++20Jkc6yQE58UIakKTXUmTid6lzVLzh7J7gWzxP5i7xaCLN1b7a
4mLcx8kVe71tfk8IroSxCasW4o9C6Xl/8oVAI6E3BTYd/OPHTx91iOSESNWV
HqGDSAiAul4LENf8EQbJP9nH09dxLS1LC0hammpFWmK0zSk7mqz+dlkbQHvY
CppNp42smNikexDdayiyAsjUMvNBmSPE+5iZuxunS449G7U4SCzmWxK3t8eX
Kb+3x8vb5srnbH9Il0EJgBFEttSrLish0+mur7zcF9de89OnB948T7qvkwOu
nE9twPlVUy+dtKx7AcJLiVnx5C1KRzwZnauQjjBe8SuCsp4m9ETSIxp+Xjvh
Sp3pEs2gyKxrfna84tdYXcoCVjcaLbRSFbjVCeZa9O6PbcmOdPs075Od2BxL
09DgS09P+UZBgZYuIzuS6aqSfFjWE8LX3EeUtBlO/MArbDQzwpzXjRgh0QR+
r3Op4GIcXHTyTOyNK282ZaxlSOJsX4bke1Bi6D2YJylP4XeypSUPMjR2zExQ
mjLTOl6knfkAq2kJxRVzIEibzrsirI1/rNPitHj0XmXXpuwY53Qr0Uq8ckdO
8EL393eI/Hxs/5k6ZyH8JGr+YGY0em0r9vFlzM00PDNi3rKlDV9Cjh7gKib+
lF08dcQMKfFXNvX05Ky2ViNn2i+Iq5nfDqJ3ChP5sTFtINVjMwt3hsJfed/V
FBfptGeDvKxByrVjUhkN85B+9Vti6HffNTH0po1XjCyeDZkBq6J2ijf73cGZ
PNb9pi1bcsJ4CBaFGntjHnqRz4GUALFDyZC+Yis5SVqYdp/uDZR1ZgmrIx27
nz4OoliCl9HjR3p65H2vhjJ40AtfRFrEdwZ/baSBLehhPFavXjSglSuzpOVv
5EuLFweSTmtt1RiaaqRSScnaO1TkxF3vI9mh7K4VJ+eSdOMl13/Xfj3Tcmd3
F0f6+YxaM9UqWDF1/CSR9b8qvW4atz1ypPPUKZMgBjDjPrLnXAStOVn89Bul
E+59f8+FNh4C1pXOqnC1qmAcsR6wX7pv3iJg3Vcf7aU868I68bdldg5inzWO
cefnyFHKylHQXh0m/sVlRqKolwqNhdm+XWQia4WqZN11uF1dbSJzvRZmZVas
9s3A6XOl7Pngvk52XvyNzEcsZXZMKPYhOxNZ3bMEAVi2ffFyekkXD4tNYyzc
yX1fZMaNuWvXXll02xxYjyy0Jr1jiHZ56dLgEycStnNN+oU1v+GWYGNOnWoL
88KAQF5Ob1Ngu2BOAzs2XXtpLyLKqG649Zr6idW6J9Cse/HloUN7UiL96esq
jJRIrF1aylJCl/eSi2trAfqolHv/qnz9sFmB5GpT+rlSy3VlVHgo43flXCoL
trvzjLALAANCTatryXFjf7vk1juF3a5daY9uTrUox/Zdit7d/8vvP/wQLZn3
pV3y13DyZaVV4ZqPcCWQcP5QJRV/2sSzSettArNQLxZlQZLUDfydoTIqmJ26
khKJoSV6CPwYOmlrOR5VEXYg+PiSlmNLNclE3SwjE336aG/jWw7pwyi6Xoq+
TykjGXU80d5ZueJvZEmIZPRlLm5Pu3hNed+iz8DkFbIlCuEI0IloFyb+b1Nz
EY6AGn+47baWKE/mIJ6YNKBSHV5oB0S7w/Hs5NEeevB1unXk+nfuMiqtavqw
exsYtfEeqg6HVmHnTurTE6sgFiPWhrUI659Xzg+zcG3ktjNiHNrLx8lIchRt
0ElRv6ehSe3JhY+7NGaVhsqdi2WP1viyZ/nclIuKg+bmSMmI1/92Ke3IN+Gn
QUtaZ2aopzqHf1qN3fhmllSMLP7DgWkPZ/sNJ/5Pupk2x58mqZxu3kfIaKjY
keOomUJdaGtNjdpoqq9uBi/DHyF8RBBp7VTGGpr6c0wvtl8nlxyl7bbSUmG5
LlKRci2CdG7Z3ErHPXfpaMhaC2nm3F+hBl01du8Hnzr1MJNxk36t6CqeG7G4
VRI3ByNY43QnH3xF5ERnWui3XjUyYTzJQsUiLRtFtz5LNuGni4Ig7cuGdF8G
y2jjFurHN1ZDNmds4JyuxRdJ3EYGiJ814WqdDIkWG5+tHQ4O93P4Z3Omt0Tk
QaJI2RdkqcllR0R+7jOd3J8TG/m9UZJ9lJVowKxhJhU4gnb86WCi3I0bQ1xx
trUgAfdqy2f4BNHM0qVq7QiybHj+cyMepNg6Or/m8lz6gLJz+E7Em2EdJao1
eIK0/yv4P/H+K+3Yh6K+vEFXnyVc26OPRTPqNz1bPrSydvqwrN1ozHWyQkWv
y5nbLfi89RtB5i4oeg2Hzp3M1zts2ztJsUdrsGRJsn2iVIFCCrlIw8nOxcb+
INMnV5v9r/Ajq2zEjm/Zot64g4QFjuu9srKmqMjaqbPGEBpoNO9LyVeNH5FF
vlpKEJfUlYToMuVaBXzm7kiffLNE1dZy84lSf1LqzZISmXPYtZedR5OMtdBM
/Ej71nQ/Z7LlvuHqx0i0mWUxopFGfWFB+TWVtY89ryJ3rnUwpi85/vUauSzJ
130I7FPi4efZMqsr1nonmFJfoqiB4uZFKhuBSCVI3rdIwUMmrgS2xPMASASZ
sF/rJpIE1sLsM6fzwDeoOTi9d6J6rF+/98y+4m6c5Pq7hrOp0u/3UkouAPHN
jOlltDeJXTsndWDpMIMtsfFux/ffp5LSrglUid4yZswyk2pvOw4Vjdi08aPZ
vca5mDqbHp9xDlHel466rPedemAsk/qBi0baQKmCSuvqOO6Iq+z8l5EhqQTO
OlMZkn1DETefuQxtDwTvejJEZBqyQGUjdRfdtqFhSdunm4ljaE+BAdfNF37S
7tPrNC9PnqR2Y+sz1q6ldgA4rHe4tBPGQ1LzlvuKpfPliP11inb2WjJYrA1V
onm9kcYncE5vv03GCF4MZuepAQP+8otfiMsUuBbhU2TNh8wBkfbIy2fbOBdD
krFB4jaYsZ3k/Im8by23yOaa4mKRnxP3z+7X99l/r/y0ZXvE19Sw3NDHkfKS
sYrhG2csMc18724iMbn28988s3n6TRWwyuD+23fe2WgpaTt7vSycINQsb+6j
nSRH4mUyUKm9sNR0dldE0y7wOzW74dt+O3Ag7giWiFbLfcXyhDPxpMZ0lXzY
XUuloFeENQiC4CwfZ3k87IB5lS3tjiWNIQyA0bTUpiqULV9SduCXv8yWasnp
d8iKm+u4wC73HXnjUxDCwPirLyk5Zp/x3AiJcb+XsR+5qT8ijjq9vOhOa72Z
U7O9EwOi3/3DPy0YegNtjVOqnh9Mi2alp/RlDmjhOWSlyEErRW5+zMGEDjIR
abH7KgaydUyjRjyuL3HfB179qFxx5/uoF4cM+dDc95kepl/ZlxamUEfq5ZxU
GXCQs3u3mjcP2HYE5BlskuKdHrf4DJvXW+d0Tbg5VjohTA460/OgnPbZPYX7
Eutk52LbykU678ftTgDBl8iwZUhL1opRp/M9SmqyVxzqjB3805lLj2zhuF2f
uGI/FzaLTT9XkC1U//BhsulvjuYt60eNevyGG9aY5cArFfUxCmgWQy98KL/M
dCBnI2aJc0VOaD+PSi0/0osk+MfWZgBQlv+cfNpONgNwEtBSfx2BrAabOWPV
g7N77WSneaCdinBbcSIAiewwjR/pNsmOqZ34P2l7Qc/s/diy0XP1rnn/Hgtj
YmEjK7MCqR37smKuS8lNpF70aBdEUmbnVRPN6V0rglK+0/L2ZCJp9xTAj/SK
8fudt41VH31EVVlAjJoatX4EqSG88pM33fQns97h55c/YLJMGfKwdQx1pog8
0OYR07U8UEv7UXk/131/9WqdBVm5snP/gnlZKwtYGmL79h0ZcfkDYWznVuMc
SW0rO5CBVKSLUUbuIl1n3VAGmnMRsPu+u84o7Fb5EtJQWEg3XL5cn41k9pIr
zJIC/bn0KKQbTP5WS82sL8trWITAbtYyTevpH4tIBiAAwAw3/OyeSF7Ld4XX
1Mo4Q38XCg5DIz2yq4eHoBVxkI59G97pOfGelaENC+coOWRaD3TOJUJnpxqS
kUN241gXX7h88eLYpO0PCEz+Xb4Pj1RnIzrnfTcH7bzv4JYvwW9ZCgfFMvyW
+KJXW/xeMUxn0gy/RT5Kvwy/k9n8lvcRAMgyU/wU3TbndPxOWH6LDmspwC1w
Izf3Lfze8pbZ2TWa35St61mSrW9uZO5GnG1Vm9JVDxXd9qKldbLfVYtOdEhk
40nJNMr7azh8avf9BMIQQN+Qv9EIwXQtaj5L31l1tc6Zmty4isiZak6L719V
Yjldx5f3YU5zD1wGdnOzVbbXFz/SUiPvW53OtM0x4XGoGV+ez068QbvS6O6A
aD5TIu+KOVkRYMpWCYPsyvo6ky7J5GEWGqSDCDpdKNeJ98+uELb1vlPJdtZB
dbCsln/SdSjZPd3RU1VledVbe9yQt4iYAbU0b2U37iX59vrGQLIKX0aL3fdd
LXa1+wy0OKMmJRbAs9rUhrxVnZa7UuOh/FdetyyKZtR4toV74bXVM+DsASOc
dTGb6w0kRy/vu1VTd10snd1XWSlaXD10AQxNqMWyxokw1WtKdiGwfVb/F/gx
spjQbjY/XATtaqvLj3Uj9D7UvhfV0Xo0P9qim+tF23rfyR7HpF4Q8oM63S8q
luvcXFdbWWYJ9uR9yXQIP2TFmc8P6QLTa4uAlOUzv27vZwNP9zpyfYDsL6r4
3Wa/ayTyDlzHBGDT2xeooLExulry5UeWIX9yNHjzvjb6DL/gXf3XblW2mXHk
fH82cpaAG4V6leX/MP0on1Rpo7S2ajKufjh2LCOiWLNGl9NaWig1nxVRiG5Q
buKyyvYRh/u+27vj1mJD5J+NMN2aQRs58oycunPfhO37CbJ0I0brYfCFbt2U
v+rOtwN6xQ28DN76X/dF75lrpCCdXnb1OCrzDpoQXcHKylXIVh9/2Z4lnf71
p5PW7v8dpCzjfae+42Cps8yo8Qz52b7tI95SViXw15m+GxMAQjeTKrntEcnE
TUkXN7WVUXfed/AxcyxP7ttwdk/87Dq751OFo3dNeqShfM7OiQ891fH8DrSe
JLnz7IvxPt7ET/09Dy7u+C15v/7sixcPHiPvI84aPOgF33YkQ5mN0w4Csoar
uVl665f97hk+YGtE8Hmz7NRlv1l08zN6nwlEubqfQM6QaqjR5xr5svKc1REt
871708O2b9ed/EW3LaNbXr8o+Of7vKfVv/VReeF9JAnvLc98GmKu6Kc5kimp
dy1ptk8skBN3JkS8L71l8v5+3gxO3n/lZVrBGeYlhoxz8/YigXZnfu9920US
8O4FO3ZoyWz887dGjXzBSmaejPrhh9YuOe8KC9KCzA5xd6WT21ngZtQkvy5j
dbOwTm4+4ebmaXMr7nRLrDZvue/GqAtE6Bt91p3mqUTOixcLT6lTvHzs08S4
R7uQj+yayVf6J7l4SI3mq+xeUDfr9HzlnoM5mk+28zPgLo3No/X7cDpwPdnv
u9e/v+dChCZhZezG2cIn2r1tY0Q85Vb94MgA/cBRCNDeierpp+m2CMNwwZgL
h0D09J7bMur3dv/b7cPGg0/vc6FR4qeEjZ+ktK2yMZmDkZ2Vedk59rqwwnKG
3PW7FS9oj7uyDquiwnQMSd7juT5RfBXPE+qr5Sud1hXuJuF+Z8B181tm5gl/
LEbAz5pi2zEevi+Ez37/xImELJTX9Sq+p/ANPDl5MiNqhhTAXyy9FRoE16FS
uGLuXLW2uBhqBRUDNgCk0Dl2BE5jx6ygTo6OzmxJXopnI2hfq9TLt92mOWoj
V0l9qGyE4maqw32OhaNuj4gTjX0hjoZ+pF2OCobPzzcrfVvSeoe/dRXnZvNU
9hvaV5fF01uzeEmx/uQLhTeSWRZe0rrIezXPJNuR/X4baOBcXiHR08ZedJAc
Zz9ralRNIQE5KM/6kSPrzHm93jq1jN14pKLPJpd+dZaxU5ZrTgleNzermkGk
jFAnGwQ7eawMVLjf6cuxEayTtfn6lf8JvGT/nZNDP3bNiXNCsDnFRsWWLZpF
Xn3iOL2DaiYXw74/e2oefuAO4RTFEsIdyoli+JGOKFuDtD1zzvuxhU9mVMLz
Hq2ufWTgD6G7q4eTxvwPU6/4wOGW7d9R2b10Qnnp6Hqmx2C9p0Kuw8Xbhy3a
sgVuSokzhoYDzL8ydOjRLC66WWkn7o3Jfnr/bi5Kq0QWF816sYwdXGT1B3yV
3sFFVo/gZ2NVlwztai0aUs1AaXEU/zK1kFe8F4tW2ZV6HsIBOJeTXSzB5H3b
jYAfyQ6LRf3T1o/v6V8tNUhnPWTM61lKeTuxZqxntHkh/d1l3QtgMGgle47h
I0i++PzrgZMCE0KI531qAOUIj2fGbq6vdNdm/Adpo2vFT6uNmp+SW54/3+zP
JfswPkBb5NL+LJ1DXrUGQZ/6HZeU3zOj9rV3Ts9TboyrEh5J8q99dOO+L4hG
3j9ypDMiAtvhPrjvYqAA7ancXfza2ckr5Xa/0N6FbHlFN+Pvd7qw+PYXH3l4
NUIl9vUpOpdFKdkwbcMGyoBjYHpk9hzbzVzrthkrN+PlZiDLbl4EQvzHcjbs
hmuXszU19N0+fWSvnCTtYy6OEb93Lg4+b7Uxpkk500Hj+lyBcKeEbM6CC4io
hB4ANoA0gen+AgSKZeEiyTnK9YJtgqy8srtjk78/n6utLp29nQpjsrOq3T2a
dknb3CH+++evHTtmJiyRnBYWH1n8h8u/P2P2RcVWq3HDl17i/VB5jHm24/74
cfXyywSzxIq4K/BdSz/gusUtLSdkHm698cvyN9xZrx3+xmlHJMUbnzbLqacp
quZzmLJsNK/AuuMR2ikpR39xH7XHKiF9tyBo0NUEGw0brypy2kYHakae363Q
uxkNJw8dm/3AOBczZu2D3dZ+m7SKwsVBRznksGtvknLUzF7e2HabMmf7daAt
inMOHOhGYkYoQqct/qTUsluFux1d2yI753w0ieTokylT3PVlCdsPIotxdRww
oP9jL6bO3cMGxI1R3b6yM+dvpofVXTjS07F8uexvlwMPW/Qz9qRXL6IPevcm
m714cQdywjm4blnJI8TtAj4ngxhcEATNujYk+6011eqTlkJJEuwkh7cL15w+
m4waoIupXOwkBw74VdlsbZZ8ZVu7cMY87soOp/9cVvZrpXe45L0mziLvIJ6Y
cWwdm1hqw5pCsRWQuJHEPNt7dnwmnRz9ggla3X7i9yc/Aj8eYj3qlb1pPmJn
fBmO6qHrroNhRyT7+f33rzEaL9mvwO8tS9rdD6lThDnbI1JrNXdl3WRJid7P
lFJGP59b22+8nMmcKLpijlkPU0BzldVQy5Y2EIvHFwfphmhO2vN1g7Y78SRH
JN3edp+NwFk5orkJc5mxF4Kvs9l7AkruxdtBpKPlaiDrG0aP/qyKRgOfSqfv
0P50tPFHx3ffVbKtneIARbSO2asBurKrYagr3XQX01pJOjeWddGNU201SMbf
mRJr08tE4/HAt0aTcGP2K4qKlrA0HW+7C93tMT2dXda7lTc20le7dEF8o/ej
TqdpoX1FBT6EO07U3/NQ+bAnaxdy24flMcCaHPwDzxzNY7c318nNJWn/8LGa
l5JHCunldGNnZLVFY8P9mCL2s49JNoemHomGE0KbjyZNck/Dot0HoZRgHG2L
CXz1/GDyoNTBq3SODlr17C2qvp59Da1ic6yKRYR0GNo2VePudeVjKT45e6DM
R87RFf8tpzRD1Ddwi+trxcVidNxdLcTXyJyltydaa/UJA7KPQm2t6htIfCre
s37LdgT+ta9eo34eyTFJ/Vktg+Db/QM2jHRW5bgZBtFYoaW3Tvx0mplxesRJ
1j46n06o7p0fEz+g1G9+o+rHUX6Jz7uLk5+fPp0uVnK/OB+fO3a9CqNkb71y
njtyfPbHYSQSUCDpaxL5onzIOz0Dv5qSZ3eZCzivgscDZ8OWvnr77fVRfetS
PW6XT2Jdhw1jPkX0xei9UAqYX7bDJiP75qIdVzKdLHnMJvVCS2TXaDqalXHK
i7/333G2OIRe5XQdiKNoF20jvJPMMYgD/aWDySazfvF+bmdTVtf4IcVuECza
zBbsqNLi4p+6Z2PnDBQnZ9zPvuVeUFX2UiB5um3OiROJwElcyj06E4o3yN32
8uD3H4vU+vVqHSd/1zr7boVrgTJRjj5/RyqPnAW6vg1eyamQFVm6FWYfDXaR
nIHwRuJIK6EZWT3hJ7+fcmNPzFjv9GTXSLp6Rfsa7XD3zmph3lk0SucbQb3W
GsaJXYuDf6A66LZjHB9Mq1J/vlv94/DhjffcQ+lzDhTDOJQ2AN+bcQIb/oAw
2lVYKbuXAH5O3J+4+eppn3zy/2oJprMHgP2Nj9s2NiLCltqAoGDcG9YIYwVP
Mc7Fi9Wrw4YhwNlfUXH7z+YfONCctbtdxhlZ0mmKb7XFOxnK8mjepXhv5kqZ
CSQMI7H7w2Wsenf56q9kdPkqFS+pBdtz0jTvvF2saX9zzNPmeOJALbDFcJoH
D8ou7bnSryw/CAxXc87tMMMT2WEzjsHWKvX7WzN4pU/oldGC1uBdqIHhrqpi
ufXOoGalb1uzTro8d+t0VsoJCNyZc/VVsy9sj1+1tcSv/Pwsfl0q2hju+rPP
55izO0/3rKxpyl0X5K0azIgiXOsZalu4O/34X4Uc83HkIYMj99x1F9RIfCnA
DHyGrETQZw3KEZGBCRPk23kn2aIiYNg/eTIYLd1Pll2sqSk3eqUdsvvPtLaA
d9p4cmhgVtPiFpLhkN5IeV+4J3Ip8ZK8L+cgiQRsKjMnRkRrlu63l36glSvV
dVGcsp2c+WpIJJ/c1eqCOLL3jHAjtzatJRTyyV9fWT1nrT2ZiE4AKp8TjSZI
q357yy1v36nCXUfBIYThEAIC+XHjN0nXzbfOUhxAQD03cCpNkD/BzAqPQ1n7
qHg70LJ8ftg9y8pn7bRDiYFfZvfFZeQvQECQMVqfNJekwlhQ0CaXZmnfNSRw
91wjre83BxIWgRucnLa/zr+jax2gUoDOsn041GTKpRNpp6KE8VsAyemqh0ST
8mDl7BKmU5yw/OgjihvwILOfcBxai1uC1qtXS3UxD8gZT3jJ7B9cx8rE5yxX
4oYxgwxfK9aHvQqHMP4MzOHtzJhyozDflmfveiM+2q2Ke5g5RphNunYvyMAX
+kxGqTIp2m+xTxs8kn0karM0KWE96ugCobnkryOjqi7uansbiQEXAbc98YR6
16QfWuJ6E1x7Ho174lQC1g0U/pgxwaefar7HQVPacZO1gfaJ70BJyhRebxql
Xhs+XDb/pgCJJYz4AhWCIi1W6i9/CTVH77gpdDswzdSHwxNTdlySba/EeoSa
41oQ10O5HSOys7y/Hi3jbHC7h2ofzTXjgaSLGdxrvTmIPsndyjh0iE4PzsYB
7vit7GhPBZAKcZVTk+RMshCLhzXzyNN8iKrPFxa+8QYJIVM1AQmmAHMk0Zb2
5+DT2HivQF41pPWPxm72JAGnYNno+VKJ1ZmYGExxhmXDzICN6PwwW42QWm9g
8pVhRJ+9/0ssiyZOX1us5o6Bul4Ybd306ZbOXqXXetfpuo9eKz9MFXqfR3Zu
ZWB16WCKxHR6rxsMHQZvJR9wEtbi/F31w8o40ykXflp25EZIRVnl+2jakADS
JvY+KVAPCiWRJnQIuhSemANOiveRp3VSnLsHw2infWZYuKZgnfr8c+IfQXp7
stbUwklUNwpPChozM3pvBc+2J+2aRouSxGO76yVk969ovTrX06u2ONZNW7sz
4ljK3QXJ3w3CjYoPTFbPPks5OMk7SBFOYwT/VIxwlS9TKQ56VQycu6lk/LEZ
wv+47OIq5+Vw3jcHoTgoDbcEBq0eThr8Zol6rrCQjlzhUw4V+6j9Uivg8ypj
byr1yivEYWXPtyu7uSr0ktBzaDvt0WazMZCTaK0SfJStVY6XiqWruupKazsc
4nqN9C3W1V3jXaf7VOyZsYMjeEQv5fxJF4s7ud6UjJUCgnGUhXmzpORjE13G
7HpGrU3eiTWxqZdO0islhEYb1r97+89mvj/5QhWeZbWRhBPqxGdA06kiYNQq
Df64Uqfkju4pwOtHjHhdI2aikwiy7h6mWujaK0ML7aIcX0vcz1wtcb2SxFhm
ryBBA12F9rLGhk8GuLoN2vcJZMegQUH0LrlM+y5uP6W74xLk4Te/oS4K2SfL
br5uzz3YOmZMmMmEt98sJ33pfIIBB3qHI8JxGWdwJzBncBWPk1MEJVKNUY+L
0Jy53EWZ8Cfgu3/sHLkdyKpmphUd79mfTh0VPlgPE3okCbO+gD44nRpkDQnl
IoL6bqQ+dBUxA0Lr1UtvFjl3i/qpd+33NC5osLhgkHeFvzIhZbTbxdgpDIuq
BJsZWXHGOtyvhlxFO+dx0Alv29y8T1PH7iOL/0CN1Xo3s6UNICRpCZ/YkoIh
w+PAJRgsUBHe5rPPDFVJUh1eUcfaZ9wFUscFJJhNPE3XDT8uL28oi4P/kILw
9OSGd/aNHTPZepWYRZua7nSq9452dSayjuLkJqL59VUhdu1zujh1/W8jeQUd
Kgwk6hkcuOsXw+vk7Gtbq4JRWTdC/UapZjeOdE+fO91ZOv4plaRJ5ZdVAgvo
Fe6yVyvMP8Jv5hGdKg5CyWYYcCeIejZtUvOVnK1D6zZXsyGDvoILUFk+fSm+
evycG340BiOHeMnpmcCId/791Ndfz5HVrnCP4LA5x4t3DB7j7BjcXlbSzfiH
uhO524zZu6n/tbQf1j8Us9bQRb0ytAV0ThcFzp4jlNkd3GfmupFxUA/o96Bz
InNsr3dald1BStPU7gSnbB2oyZFk2kNm9gO0JarQPAHsiteYBgQLvleqC7F9
Fap2xAg62qqDc76VYq9GFK6d8FhRv6fhE2CX+D45oPaMvy070UEfUgzQJZvh
CaVs2TeUaki/7eJIuX1h7Ut8GDvKGqWgdb/ZSGX+VR4XenmSPsz7XHZ4WTB/
/TPF1SHFvGxJxvmL4TkdtuNlGzfIaxQFbuwSGyTU3nTeFW4PWgJ/YS6g9sLh
Q8kS8XlilG7WPI1nRSJHpj+4qewxgOXBfRc79NanTwOlKXtiyIoVzvmxtn6o
Ke7tX9qmTMMW673lLo6U6a9p2a0xstv4E+86vVu5rt6QdPt05+7YlLs3OZ1c
wWvtla23tGv7j/HntgeB8sZbxUfHjO2HjybbzzzuCLsMMwNW0GkXN1fNG1b8
6vhrwIBAlk1PnSoReQ6+Wz+xeuHwJ8b2XwSCg8Lwt1BH2akDf2DQ4KmuApzi
dBhie5vBsis7NNW9TFjKXRHiyzlEQve0RlP+61qah2nc6dNdnylA2eEeog+3
R9GdZoHZZZxztdn1m6ez6octPhLaSxU6rI2IVUfoCqJzF3EObAw1jc7dIgwY
dOXwiTcvGHDd4jg1etFqjKlT1mLqAJvSQQ5rLcu65Y50su5WU97Go1UHDuJl
026hpX9qHlXLtoZ1ioyYLpTwnm3TOc6nFEsYNuvKKErbuDpfDfc+t7PIOGXY
936ns+RSt2Lza3Ao+LJfmbpGzQUDMQ/QGVORiup7u/8NIk8YxPflshoLI4JW
wEync7qKnnxmVgOFuZP1IzlldlzZ2gjtpm+lFB6ZdtM/5ljyNqQ4mrrdNHXr
hHEIo3p71+nzeWh/DKlybB+u7b505dg67Rnb67S1CyclAOXuDu0ddzv2OgHZ
FbJiDiQh/jlTOZl0hJlhXsT2Z/ZE5cAjwCy8/nq4rsTzhrA69hydlBujZ0pn
6O2+oakidVY4vMa/D6IzbxeFdkCSphXF3hVnGQ8Ca/b+5EfaiHN8Gwxa7rzz
ziYjf4Q0QD7C3yKfoOo2LmvL54kjyc4AG/0L5j391J/IA/qrVpPRtCSram8t
1JQ7H5dl5w1hnkw8na3hRNtcRyL980dFIr+p6SUoAaYz/X3vOj/rYihcar7R
6lNYJBWzHnnjUxlnUG+LtrQ2B9Pgoof9XP0MO+3wfXCkgZnEV+SA2qtXd1y2
tAAyA2bCGMAAgLH+imDZSbF+x0EoD4IiIbfOwOiCG3RCngKyW7WwmHLLFukS
ivRyfgdDuqorHkIy7J/97FA8wRIqvcz5tAtefgTVyTl8R1N7ucET20d4V4r1
s6f8aWrbfQnCaMTVUbLH2wRTxAw36PQ++DW2DSl8Xscxn/SKblZhxTin4Z2e
Nb8bWD6psl/fZyG+cG14OvwXow3a+RGTBydWrfxnQIgBN9VMvXTSK+f3PZDX
TdnztT7mnlQYL9tVQp3wroWPNSpVU1gY7ijtxYxZJ1UAv5ffUkk5m+9F0v18
TfdmgxAKwAN9+kzb0m7o32js8fyR3hVSt642Z+hp+tv+pgzcEM6WpFnsRcxg
OnwOLy/0pz4NsLCOTyLbvt3UjZs+7P7qqmuq55SMHTMTxJdzzPIGD3oBWEJ+
cC98AN7ccX5fYDWY9EQmzeFoaRRx0y1CTVBmFLniIZomTeIjjsix+Wfi0Xky
m1V4pt7UQpONi6b6tzTV95k4hal+aRCdubpQU9vyqGRU4O7xRvnQ/ovCc83F
aocnB0pWJIxI6MxJTvhqdHaSMSsFMffeK3TGFS/ceuuaNYRMySfl8ixPnEhA
yKlFm/u0E0eOdDYeWyllaGFXmWr/6dKYPEfcWBQQdFt4HrbGHRxfGsv21mj1
1phwdX0YIQqVCbLL+e7fy/CL3TV1GzKoe4lHVR8P9Qg1Id9YoFY1yrtKKO5V
/zQOO+RhCuqZtDhNqoMapx1m9LprwgTTf55HSK9cl1cAW0F6SUGB+ph2J5rW
WTwK+pHTYgPWlCYuC68x5BXq4nnAkRtHjWo0dkPQSKhpsGkrhg7dvFnjjZhd
bZcVYft0Ewn+dps0jsobXcBXL3uOz5EYUBw0f5us+x3eVYIG/P4fWSnQZGl7
iluN4Re1tmLe2kPyTKkztK6khNJxVVVy2AJLSy7+kLyRkBdTB8Y6dIhxK8s3
2WjZFvOPf1RvcE8D1AYPsrFgAgTGa9B1r9QrbMzXkIlOEB9tZe7QRqwHw3ha
5FbO/KDJXhpJ2wt82vaO8oWaA62tRdfM0y3nrR+oEu8qqS6BlXIibRuooomF
McRtkFw5NCPDNz09YMAbJXwurPSbHr2PMOquCSSPubQlGK0yIskdS6s1pBM8
aeyJ1E6bxLvGrXUXLWFO5oBnO43xkCzKhx9y7x1TramyOyJAQhB/F0m1HiHV
xEr2otVQvifrbqgWFBTUn3NJ+Q+m1S75vRrtXSUYH8ZlauGTpOWWKjtcdHCI
vRPZtJhTu5fAV3LEn/JJZkCfdXXklpsmca35XK4I0NOk6F7KNBAJg17iHhtN
xTLsV9trwjIXF1iLEttH7HHO7AXegt8njH1ZJLUuDD2QWLsudCKHf632U83N
ehONLl0CwOwxWsvtPvSwhZQ7iBnvmZF3kTWZFE8KhpKe5J2c2vEwVAoxe2Mj
kWxNMTEeykrWvjPN6CxLLypn8BaeoAEF0KWlG3gx9kFduaLcwB5W3728h62D
LUaPtjmJXIkpIPb/z9Spkig4cX+i7OYqwkqXZfiT74SeoY8BnLJnI5FKI6jG
RjqGT9FmPESjsR4lz3P8RlPlI6EVdj11XHJY0AMMWyw5LAmmtl7RPuzS3QgT
JQ2OcBCrh5OygUyfTmWsnUuUolwhMAoot2UMNc/DGoJADUyg44ZGYpugkSAl
6X3c4OOtjmXjfIPEAeKTmdxK0I1vj0Suvqv/bDXbHSv+o9X3Ihrvb9+ua6r5
+UE6zdnYmCCJSCQkO+pBqstvWVg/sTojC3LIasvHPDHAC2OPyW6/OIQK/8AP
MPli7+Ow9CAj3oK05YKUbL82jCTCvvYaNYi2KFnVQ/56B7MGBEgY/YNH32P1
75CVcs3ZmQ/efUPV/1jxtvIjR6HTxVqmaoyNh7Vq1LXM8NpvyFXSraaoYY1W
BHJuKR5epbLwuf9a8oQtLSemTlkLQK7HGHpWa2Uald5RnPmdK618AXep0ukR
a4haTU2ctT+XsbfFJNT+pox0neTFgJsZc1jvGZddysGatOM5RQfBQhkTdAMa
smnjR/oUXZ9uPfWfjSaTkcP5j1Y/qvy6tVxyLK/iHRpHnBHl6CVTnuKXZ0bM
y/CbW0Vf48bS7ORJ/usvfkFrjLnWmwNNBL0a7yGTLySD94eRI7TMnSmBbTZT
eqVHmk0WCLaOyUFyJP4A1hRyZk+wytJL0dtXx/8KvpG6vr8fuNXzv9HUajaJ
SRG07X7W42tCrZoarY34XVurRn5hOWOtpqrq7CELrN8kJA/d2M2GxeLfxUpv
aMOdVymhGUw7yEjbgsv6sjgnxOyyBekDYvt2nMj35z/T8sCtTDXC1+XlIJzU
+yj7P2aMhDmJKA2NQ0MxSoTpgBQ/jJS17+k/txtZU5zfafZz8V+V69LpUNbw
Rzo96gvTj31JDNIP+0ar5MUHgM91DPRN9oVPLeZWDsjWxlGE3C0qc9ZvxWn9
VgzUBDYjeBY3GG3DBnIb28ep5wcPBnNSTmwN7dwlEi5dIEc5NozW0B9FUo1t
WIo9QJVJD3ThhtrmrPr0ufI1aGlVVSh6NTUlX5hyjFRi7+/5ZOSNT20qe0xj
DQwaKlvHUqDPmjVZ6hT+QtADYAaLL2t0KH73sBktjy8uVkmji3DN8KV7BN8I
hT41vgEi52vjjyMpdKmmUKNZZuFQyO/rO0e+Bg/QTe+nSms30mmikLvbe/Q+
ekeOHJv9wEZadzf5kbixwdCUFZy9kx4UqJIsdFEdIEpSJRRaMO7qbGmBH9l1
N+BmSIArGL7Vw4dv4+DgpBMrSPqQOpdh++NZ2uZn94Uql2mq1JkMIFPl1Izg
f73LERF9Qa8SA3pfvJhOuJUsEq24buC+tImaGhwLxGkHi9JVCHwATuV0TXjt
V28nswy2SyNOysgC+a8GUqa6EsoVIwxXOQQ+O9ntJBVVdQlWAcY/V6jeKCmR
ye+VSlfSeL4mk8WjvGHC05krAxdZ5odzJmS5bCk300yfHPy1MevUeL0rBKxM
RQXt+KjnDtC5kvdPL/euZ0nqjBgGGrFs9FyY40AOfJ6i15lKp8uuXUQJEEC6
wlpa6CXeVDnUS077aQIZETjiUAbvAaAvX64+4jloH7ib0TY0jWIh8fUN5XPA
b27Ta/Zr8MJv9u94aEPRrXysaJ9FROZFvehU0pb0N73v5FrOw0kNG6b9IHFe
Zj/Zu14wOxDPM0vqQYA3Jjxg/TNZSLAX04fEb5TcBzSAsnmMaZLWQwey3lFr
erKFJXsXo0vYZBjMhOl8GNt/EZWBN37kd6fJXHl/hzjtUnf372t/NSt4tIvE
tHSOGaabbsja8V2flAfLuHw55hvk5OgZ42+AZnxY6X2DKxDUTTBu3LO3/2xG
7YQrqceauwly5EhJWDk4A0l8wHcgkGBE0tmdL1VRTGppv1naAUgo6+kFk0Cd
IFDSfEDR0rWRcxbbR7uWrBgWPJwjUXycNi95qZD2L0k3+JW0DjLnA+8G//gi
OYTevQVb0+pd6Dvig2neNxgNJiBiGMngvo8/M2LwgWndxA8mJDuBKFJyaaoD
sD40sYmAA8EKWnatOknzj+IgFG9A9letUq8xooBJB/7FrEmqxQMcmPZw9dAF
Rf2ehlRRj4+/ekRmfqXM4/NW2lxpVUmwoAd3LiVoNwe8rJsV7KujvVLPEg1o
3kc3wKX44KXCZaMLyQZcUyyrfKmRG2AC9r+x8T5tOxiXpCDbAFoji/+AiVcP
LdlUdgX1zElmRhJd+AEIzSEUkAtBX82NUVADvAHhXz9S/UlqHzk8N9pntvBJ
3K927QeUZbk+w1JdreVxH7EOk1jUK1ck+NneNK3n+ijarAJzlH2KjcHUnYZF
/bjx7JqnaIEvFLa5eaZHOY4PqcsJT4fLwpzG9p+5cPjQ+omXqK58D9cPUbWp
rIylMQnPsuXuRwHTwRZeC3Hwhkiu8Mq5BO2+LqReWoCxggekH5BKuhyCig/e
W15f+ya0GSOZ5d2Js0nUW/3Ky7vxLMwJsfArY/s2VXZXZ9OdznZHSat2udcN
YkOnog1dAEs04LrFM6avB+coN1MQOdKbtK1rJjnZV0eLbevkrBfzj/jysPdd
tjG6nge7CwrOHjJOJWruGJhqKO8pE1XUOopXlN0ddmNJn8lQYnCcG3k/gBrd
HDkef33NQ95rwYHgHexfze/eVnH8olYelSOlF4wGrzAsvP/6hj/jQr+HXZ7z
oZ6ZfybCef/BrztmSLZ56unOt4x8HX3ex3/OXf7rf+s/8dmZ/HzOvqILHpLv
feX/AKIyYU8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104746996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277104881],

Cell["Color by parameter values:", "ExampleText",
 CellID->234323493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{"u", " ", 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "u"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"u", "/", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->915108523],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7214452]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", "u"}], ")"}], " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", "u"}], ")"}], " ", 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "u", ",", "v"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"u", "/", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->194047514],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->283761200]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(41)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1250993017],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AspectRatio",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21108],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " comes from ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->10987790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "u", "]"}], ",", 
     RowBox[{
      RowBox[{"1", "/", "10"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288508976],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNl19oTmEcx5+9z3nPO+/rP2XR/kiSa0ouhrAtxuRCLhY1S20XTMwNN9xw
ww03VrILf8q4mKxJTclKlChZCaUpzYWlyMVKvT7P7/ecs+O82sa0rPM+/87v
z/f39znb2dLZdvBQS2d7a0tNw9GWI23trcdq6juOcmTLjDF9/KoqDOsiK/n1
FYvMyTHHaHmVcTu3KMqfybCsZuFmm3hnHC2/rRO8q55AptCb8tQbOQ3G98ZU
lpzkUjybJqWonFRLRifrwXv8dlK+JUxBxD9DKP8vn00RTchiZOTri+cfWTAO
Pnpvu688c14OOw7fNbZuy+WNtV08xsrQuK2bc/dqIYNTMF/o9jXf9HSh0LUe
uO3prBucZuTyOIRusqhCodPstNX8M7sWyIkaxXOnd0j0BRcvPFZEQM0IUIj3
7rnh4BnDePLEfSvI2D4YeOeQZd1gx8Z+eOkVRa2qpaL67ZvP3gLrhlIbA0R6
Lxj1XxblesJz9sxDobMpLQum6IucRxP6OS90CHv65ANiMTiTiCGmGtkH588N
Ks5bPS8zgnx4+Esx+suYcck1fl6eOhdIMEn0BP29/tfedon3LNWp1p4+NcCL
69deQDn06pPgTOLW8l7sxixxIzEgxzlOkEQqYHW8sz+BOOGtdV7KereZo6AI
H8Rdl57C2N7WGyPhRGGoj808N+a/fRuDQfOD/MZRxA1+bIJ0c1G7pdRmXuUj
RIWrX8EGMNJhtkiVsRypHKpIPMAaRg4bPF43mxz2Ei10UzAQYjVbM0vkFCSe
ANm96yoUsO/wvI3iK4QBEeXwOr9Kr9AssMQYhHjJNHmepihncQhWiPc1oj1x
DPJRpuEu9I6Ofg9SuZj9w304Tf7f7aPcmWm9E+21RokC4eAUx4fjHs1xQrA0
kmSEJovZ7m1ZlZJVLQbAQCUQdxKMkJEW0vvMXMkukkGThkJDIqIhRn2dl1kX
UaGLXNDsIq3ZknKCSmtgNlAhQwBvtVa0d5M+9E4t2Q2+BmodR4ED5UAwhFrq
LAAEh7NMMMotbMq1S1IxSq0qAKO9CS0Iovx8H4k7kakqln7BRMuMfxdlw9qE
JlUWo8MY7fYoVkepVZi9SFBWRd5O8lKw2ivjew12OclqN9MHYmm4yX4ktv/S
rcOSk5IvL2/HSjmn7KKbkcE1AL1DSQTF4mwSLOo9Ncj5fZmIXx3lokrBuXqv
acuSrirc8d3Ow9pkJSLx7SCtR3CTe/qFELopp58K8TeDmmSCREzEH56mIP4B
o5eaZQhL9FMY0uaD+D4kTb13VoiG9Sm5NiU3RksF6o0rWnJ6uce3vMsFh5bZ
+lluSE9TSPlA0KYivEbw1P9FnJunyRndHcmb08375W3pfw+m7CeO2nn6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->491703538]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v", " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"1", "/", "10"}], "v", " ", 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->913678178],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54332105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->747548],

Cell[TextData[{
 "Set a different ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->104904833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "u", "]"}], ",", 
     RowBox[{
      RowBox[{"1", "/", "10"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->247719746],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219005963]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v", " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"1", "/", "10"}], "v", " ", 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->64580487],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->810565290]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Axes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17207],

Cell["Draw no axes:", "ExampleText",
 CellID->119855387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "u", "]"}], ",", 
       RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"v", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"v", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175497594],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->151910091]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesLabel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5259],

Cell[TextData[{
 "Specify labels for the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axes:"
}], "ExampleText",
 CellID->430834034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "u", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"u", "+", "1"}], ")"}]}], ",", " ", 
     RowBox[{
      RowBox[{"Sin", "[", "u", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"u", "+", "1"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"3", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->405251636],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{211, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->578710017]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesOrigin",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25706],

Cell["Determine where the axes cross automatically:", "ExampleText",
 CellID->59461538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "u", "]"}], "+", "2"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "u", "]"}], "-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->684374975],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->346264295]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113516430],

Cell[TextData[{
 "Specify the axes origin at the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->80022854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "u", "]"}], "+", "2"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "u", "]"}], "-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218910921],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159446635]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoundaryStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->151780475],

Cell["Use a red boundary around the edges of the surface:", "ExampleText",
 CellID->288952813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"u", "+", "v"}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"u", "+", "v"}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213478980],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106963070]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310167899],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoundaryStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFormula"],
 " applies to regions cut by ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1081074962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"u", "+", "v"}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"u", "+", "v"}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", " ", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "u", ",", "v"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"5", "u"}], "]"}], ">", "0"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->653624081],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89783964]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->753950212],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoundaryStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFormula"],
 " does not apply to holes cut by ",
 Cell[BoxData[
  ButtonBox["Exclusions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exclusions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->118163325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", 
        RowBox[{"Floor", "[", "u", "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", 
        RowBox[{"Floor", "[", "u", "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", " ", 
   RowBox[{"BoundaryStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2102372108],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579089564]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20124],

Cell[TextData[{
 "Color the curve by scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " values:"
}], "ExampleText",
 CellID->518535476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"u", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "u"}], "}"}], ",", "i"}], "]"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "i"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "x", "]"}], ",", 
       RowBox[{"Hue", "[", "y", "]"}], ",", 
       RowBox[{"Hue", "[", "u", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"In[1]:=",
 CellID->2070922090],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->265716940]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182799463],

Cell[TextData[{
 "Color by scaled ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " parameter values:"
}], "ExampleText",
 CellID->1260151701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "u", ",", "v"}], "}"}], ",", "i"}], 
       "]"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "i"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "u", "]"}], ",", 
       RowBox[{"Hue", "[", "v", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"In[1]:=",
 CellID->118673379],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->164161380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199998290],

Cell["Use a named color gradient:", "ExampleText",
 CellID->1901637531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"u", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], "]"}], 
   ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111562539],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->326084982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132676083],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->147068490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"u", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}]}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143803984],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31322321]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401089874],

Cell[TextData[{
 "Use red for the parameter ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", ">", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->550216045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{"u", " ", 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "u"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"u", ">", "Pi"}], ",", "Red", ",", "Black"}], "]"}]}], 
     "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33895657],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->685456352]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", "u"}], ")"}], " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", "u"}], ")"}], " ", 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "u"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"u", ">", "Pi"}], ",", "Red", ",", "Black"}], "]"}]}], 
     "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25150886],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1011219063]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20307],

Cell["Color the curve by angle:", "ExampleText",
 CellID->2107165470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{"u", " ", 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "u"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"u", "/", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->835889671],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->349908182]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->874765498],

Cell["\<\
Color the region by angle and vary opacity across the region:\
\>", "ExampleText",
 CellID->477203378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", "u"}], ")"}], " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", "u"}], ")"}], " ", 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "u", ",", "v"}], "}"}], ",", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"u", "/", 
          RowBox[{"(", 
           RowBox[{"2", "Pi"}], ")"}]}], "]"}], ",", 
        RowBox[{"Opacity", "[", "v", "]"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "True", ",", "False", ",", "True"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1653236148],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14109651]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EvaluationMonitor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->722374926],

Cell["Find the list of parameter values evaluated:", "ExampleText",
 CellID->28145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reap", "[", 
   RowBox[{
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"u", " ", 
         RowBox[{"Cos", "[", "u", "]"}]}], ",", 
        RowBox[{"u", " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", 
        RowBox[{"6", "Pi"}]}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", "u", "]"}]}]}], "]"}], ";"}], "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23281],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"Null", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.36999116229837065`", ",", 
       RowBox[{"\[LeftSkeleton]", "1618", "\[RightSkeleton]"}], ",", 
       "18.849368177818175`"}], "}"}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->557681240]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reap", "[", 
   RowBox[{
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"v", "+", "1"}], ")"}], "u", " ", 
         RowBox[{"Cos", "[", "u", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"v", "+", "1"}], ")"}], "u", " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", 
        RowBox[{"6", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", "0.5", ",", "1"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", 
        RowBox[{"{", 
         RowBox[{"u", ",", "v"}], "}"}], "]"}]}]}], "]"}], ";"}], "]"}], "//",
   "Short"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1270006629],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"Null", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.5`"}], "}"}], ",", 
       RowBox[{"\[LeftSkeleton]", "4865", "\[RightSkeleton]"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.959069696057893`", ",", "0.96875`"}], "}"}]}], "}"}], 
     "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->1451390755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436804932],

Cell["Find the parametric coordinate values: ", "ExampleText",
 CellID->5447],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", " ", 
          RowBox[{"Cos", "[", "u", "]"}]}], ",", 
         RowBox[{"u", " ", 
          RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0", ",", 
         RowBox[{"6", "Pi"}]}], "}"}], ",", " ", 
       RowBox[{"EvaluationMonitor", " ", ":>", " ", 
        RowBox[{"Sow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"u", " ", 
            RowBox[{"Cos", "[", "u", "]"}]}], ",", 
           RowBox[{"u", " ", 
            RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], "]"}]}]}], "]"}], " ", 
     "]"}], "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "data", " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19718],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->256027763]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"v", "+", "1"}], ")"}], "u", " ", 
          RowBox[{"Cos", "[", "u", "]"}]}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"v", "+", "1"}], ")"}], "u", " ", 
          RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0", ",", 
         RowBox[{"6", "Pi"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "0.5", ",", "1"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", " ", ":>", " ", 
        RowBox[{"Sow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"v", "+", "1"}], ")"}], "u", " ", 
            RowBox[{"Cos", "[", "u", "]"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"v", "+", "1"}], ")"}], "u", " ", 
            RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], "]"}]}]}], "]"}], " ", 
     "]"}], "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1161446070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "data", " ", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1945230907],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->354068183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->760371313],

Cell["Count how many times the function is evaluated:", "ExampleText",
 CellID->441855877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "=", "0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"u", " ", 
         RowBox[{"Cos", "[", "u", "]"}]}], ",", 
        RowBox[{"u", " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", 
        RowBox[{"6", "Pi"}]}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"k", "++"}]}]}], "]"}], ";", "k"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1723218239],

Cell[BoxData["1621"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40244265]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "=", "0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"v", "+", "1"}], ")"}], "u", " ", 
         RowBox[{"Cos", "[", "u", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"v", "+", "1"}], ")"}], "u", " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", 
        RowBox[{"6", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", "0.5", ",", "1"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"k", "++"}]}]}], "]"}], ";", "k"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->638302542],

Cell[BoxData["4552"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29539078]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Exclusions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->204192746],

Cell["Automatically determine exclusions:", "ExampleText",
 CellID->61833677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Floor", "[", "u", "]"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"Floor", "[", "u", "]"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64902304],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276149985]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v", " ", 
      RowBox[{"Floor", "[", "u", "]"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{"v", " ", 
      RowBox[{"Floor", "[", "u", "]"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "1", ",", 
     RowBox[{"3", "/", "2"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->464979107],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47761199]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14422671],

Cell["Specify exclusions using equations:", "ExampleText",
 CellID->169411880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tan", "[", "u", "]"}], ",", "u"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "u", "]"}], "\[Equal]", "0"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287243881],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVmE1oHVUUx29m5s1LXhNradNUEQ1Yumwr1IUEiVJja2vSpmm1Ki5iFJqF
Vmrd6EY3utGNbiyIXfgBfiwqlopQQSyIBbEgFkQFqSB1YREsLgLC+Dvn3Jk3
c999z4AL8TG5b2buOf/zfe55mV08fuSxxxePLy8tTu46tvjkkeWlpybvPnqM
V+mQc+40f49uctwX3Onf6aLgu76OsiZsXSdPqdDox42zZDxu9d+bgv2Nnm9U
UdbImnV34/TlM6vbFjyH9OM9iCrD5V4f17K31bZbV+6k/gWfpPY+DSRsi0gU
uo19JPfaGNp0/T9I2BDQTwyQlHqfJKvAHfd0E55vtIpsnWqiRtWUurXnTUkb
RsX0G+uzW+bE9iKeUyWqofTmoq0PlFwrK3/J7WHbc1XQa4hhTLP/4754/vyX
Pz/7zCdYHHL81xr+WzwrxjXB272ytOy5Mt3dV5TxlyxRaDaPPvHR1asrh6o9
165w+Fz89tflI6cuX/7DHawoRFCiEi9d+n3pkQ8ufP2LW+jy92gLPELef+8b
dyBKZVn36itfPH38zJUrf7r9DT3buouiDz/07sdnvnP7ohhKlSHpxRc+M5Vm
le6A1zfzaB2l++H739AIwz49+6P6yvQf4Gf1cAtvPP/c2fl9b5584yvxye5V
8Uo9uxzL4Lr/0Duohy9w3Uxfbnm8Vs1CUxyD6TAiGgfA6O5cldz1snTQEytx
CyB77zmJ3QCCg4tIiqlVIWlPG8O7MKE7YMDM7HwdpbjhEcsQwi76uh2V5xPf
U+T7RrUHbaBCPBzYAzfucMn07Sdcxh3PpmDCfiqJJTnmtdgSjfyWMqJQm3rK
C4xLMRlkAVcJLZ5NAhfJ5lpQuvTtty4Yr2upRGuMAru2kYm3ag6gj1FzkZUe
48Rr5w3WtVQyzvGSW7Kk5Jrfz1mGopbM6TM55rXJWeKUhxt66S4HMIJMjOuo
DhYXUS9THdHWI2dqJ/H0eFNRfE0DU8d1lMPi1kXEh96qTCWSX3V/p1SK30/U
NTQi4+c69/lPTiK8ubC5IGtYM6kaUTNe40TDA0/FD5aTKKcqySJLRrlENYPS
Erxxupdtr9fW7YXvZ3CRyYbSQYYleuXaKtGB3hAghVVjyLdpFZobq6S32gGe
dCV11wWcie8BhjAt6zCVg1GUBmUCu/HycizC26vFTq0+lDaMqg1Jv7XeWZ9P
4j7apflvHYnIooHkfx7UucVvj2IijBSxfhyeUYZ5b1m9lifcjDRwtCYkXQGh
xjCgHcXRM0MqGTrpQXmUar6MsrX+QGc9naT6iRGy+nhh3sdGpUEpOZY0cPSk
zHlEBE6yMuPxweZuUTt+q92ya1oumV9EWFJlQ9irk5KSV4JU0yGWFV5e05bS
D1pQXt/utFBOEqaNcEcmCTZxPfnYb5JgCwLqoDZJ9Gpos4LEZqEhQ2ORWWxI
P27moyg2S5DYoMhJuT/qs7SozRYZOqEZtQnqXF/63mkDcjvRETdb+bPsZXX6
EVWNWrPS+/DURcmaPbWc7Panlo+JTRx47eWXzlFtrOK73Y0sCed1mzTwIRJI
cUQhkCSbGcilk4b0F+ygXGkurFhmXe6OgR7UHtiBDCmwWGujGRMmHnkJ7FQ0
UvrrpkOMCDakiERd+qx1cvTmpXZ9ORE9zy2NnLhJo2A9G9WFXk8hLAcHPfyp
Y9bYJR3L5goS1qNujuq3pYxxddSncia0qjPPzy7186c66Wpnr8wHeSBxLCpR
54u0mi/szKuduYqk6Mj15+ywTk71uWao4aODNR/ZNWiiCPuB9ZI8sLCtOpCQ
tVkgD2a1HdHqDuXlgcVtRSF568jBJJc2Z0WuLJIpm1cl/+aiqM+OXFmZRSOW
RXbZ2W95JL9jRNoNEQndM1sztWWnvpUGGW250bbk5NZcyLacwuv7VGdtilhj
2Wj+QRvaggFxWoEiPeWagDt+hk1rxRsap5gVPUaCw5vyf1bNiewuWXMsggGR
1pII3dqoBJsVsAtliZ3/7TZW9M4IQFAs1hUHzQjWCQHC0pEo3VyJhz30H9pg
uyHPZgT0MJCBM4JExD7NWtBdfx5KRPXfKH0mP6XN63OVTQPxXFTq4Tp1NR00
Mqus0aTM3cgEEZ0P/CRhVAtFMGd4a83Kqjvg9K6Gzd8b9t8kN/Q3k+GJBw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308362053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90097164],

Cell["Exclude a fixed set of points:", "ExampleText",
 CellID->159370616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"u", ",", 
        RowBox[{"Pi", "/", "10"}]}], "]"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"u", ",", 
        RowBox[{"Pi", "/", "10"}]}], "]"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"u", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"2", "Pi"}], ",", 
      RowBox[{"Pi", "/", "10"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1418229854],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32190795]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->196243807],

Cell["Use no exclusions: ", "ExampleText",
 CellID->11902739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Floor", "[", "u", "]"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Floor", "[", "u", "]"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"u", ",", " ", "0", ",", " ", 
     RowBox[{"6", "Pi"}]}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108169565],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1W0mIZWcVvqn3Xs09J9VDzV1VXdVd6e50OomZOp2YySlowKAgWbRBSBYa
iXGjG92YjW50Y0DMQiM4LBIMESGCGBADYkAMiAoSQeLCIBhcBITnd853/nv+
+up2dZdoU/3eu/f+/3fmc/7pPnTp6cc/9elLTz/x2KWlB5+69NnHn3jsc0sP
PPkUbvWuaZrmJfx//kiD30P88v8vDYf4/qh99uza/zWP7nD3I/Y5+OMf/v76
b/7KP7Ro+vbdw91o+3Fv+4B9jr3zzrt4+pOXf//ct3/9xS/89MnP/PixT/6o
6V288GzTxy9c889IjeC7mcRdPOXfE4+/gHvPfvM19H7tV38B0sOOfY99Tr/7
7r9xE48+//TLH3vkex98/3No/MxXfo47r/7iz2gMlsZEjlH7mHrjd3/D4+e/
+zo7oxuJoTNumjgfcjp32ec4wL721Vfx+P57v4XW5OWtt/65V7D3eGtgQ1zw
3KKiAyDf54gX7LP/6Ce+D6AXX3gDjQ8JykHXGx6gGyAg1Ze/9AoQocnmvsTo
QU9UeXOtIFxXNP+zV/4EiYAAYkCAvqi5QMAz3C0IBnDU7Qvp2A2fpouLVZ8f
/uC33/j6L7uozrp6QQOY4BsGQVswcWfVG2h45OwFxabvj+PfqGAuOD9QNWg+
/OHv4PPtt//V3O5d7nBN4hnI0E8mpHfvCtdLjg6OgQB0SAu05lZH989RsA8j
AR3SgDjYN4w+IK6Erdcrzi1UAyQQghi3OB3/HMDauAke4Gf4TU+6ArpxsVqh
wuMgyk2Oer7YAtzD1yAAzb/P27c4+DfSofUT3grNEQsAhhc5XnPOeYVO4Jnk
9c03/0F/HdSYZkmNuw3HhNhwZrCDjo7WnK0wQQuf5ueHgrN+fA8E7ZSjQVMQ
jnI7TnO6E+249L7eryEcQsi0fcb7+t0+FcaOq+GjjtoHy2Cc1LxtcIEgxH0o
A8KdEEpnCyWK3Gx6v42iX4CRhQ3pd4NfExnRGBZiLrWfy46z7nfRHSCgQX4q
lHOlF8If3stQMxsgVnALaY04axU/ZHRTkNz+kwgTdAMerhApaAoO0Q15He7l
0USPNM6Dp9OhQ/dLyyygDcLoa7FGv8485PHOWOnhVmjtjHBzc6EBwpYPBoIy
7yi0OuTGA8t8ZwXlLuk1572WKp1B3tBh9roovTzrNYt+lzoxe90ove6WXse8
10KlK5PzfOiKrcEzeLD8y9YuVQ/ooGFefZPQuKdwHlrzXE6prBd0ZVq4WXq9
t+LcdHnEe81Kr1uk173F82BNe37Yex2TXu+RXvcVu0IR9nPGex2VXreGFno2
GhiwnKMPFGFSa+XyWkeurbpAY4ZxW6EcmrVHzQRHIejLsooEAZK4YzngtqJz
enXgulw9Rr5Rv73gRhUb9w9oDy4NIA4RGA5ofkvpDS6MK6+YlLoHXUcMnAl5
R4aSjYFjP6eHkctBg2WZBGhJ5CukHvvp4wjybXKAQ5PLM0lm/KDTWVvCKvs9
UkkM0gDduPQM0IN6YSj7ebCihpSOGmE/Tw6r6jheU4VOLTCaBmrqgzdrdcAp
sUrRGKb5NmshD5tHkhJHGzn6cLkmzCZNw7EWrQ0OSSRGpTIq6kMutCIpZlmw
DgHsp/NDPVa+fabYmOMM6N9G0hwl7qDNuD5cUQXrYJh5CBzgZqtvSml2g9Sm
b68w49RNO/4AU5UNt1hVK+TRoi/gWR4+U7wOSCZVTTWjySvIAK043orRSC88
s3zreMHj3upKWz9Oi7V83EH99iB2ePZJp4bmHPtwuOg8GfhcsQM0B/aiaoP3
iGli7i9y4a55SzvOAGWIjo7XCbeeR63agSoMjx+bwtfeCjnttF5p1CrDYcFd
LN4UcU1UOFHUbB/TkevK5zjWYoahfxwRXFYkVgmzxqnqOnH3Fu3AvqaHE4Xb
6HVMUJdLlIFBC8xTIu10hZp25HgTvcA9boHcbPjESqHP5ETbVlwSb494YTta
gPTQSdQ4GTX3aKtETS6nKtTMQuzFSmmesiCoa+L168IrUaflbjsqiTq1KKjU
eGbIdbmerFBTguMFNUYpS52omc/XxVeJOiW81qjF2maljWJ1tDMfJRqMgQv7
OVGhJY/LgqbjaaJmnWt9L7yGqJNi++ViJago9ZuoJ4XqmvSvUUEI5DJaMnuv
CuopsX2vcBG+syjPvcKTVkV7qVxH1lnrojLRZnNcwTYcdeOOVblFkb6mk5oj
ncwhSsdzzDilhf+DGzYk7pJYd6yiATZgsCLxCArmevhIm7tDI11jdGtPjv2z
mtcvyvW6cHyjaHKh2AuxmjwSFeUH1S9RIV7wZL16HZXovHjDgmjA28fcFNRR
dKziLBX/Bc+W2ZcFVWv6+U4ZkmpNJSPVUa3uoCGnUVZB+mUJZAd6N4k25kXH
Nb20U5sFt3C5lUqvpc6VDvPl00UbcJGkBgSMfAynpsaqbXdXxHPnht1jBac2
4NwbveG0No5ibc9cSZqZgQZJM8cLsf7QxiL4NWtqDdGREWfBcDeOpuBRvu7Y
4+WwzWdpuXmRjdx4HPWpNw4JFju8r2v1gvaFS8Iy7bUNV7kCCciT4rccC2V+
JwdTQm9e/HKl4EJGGxFj3GhfNgunsDADhmxhI7gNxLAaY/JbS3oMzM4pfyzV
TQlv88KFa2EMD7nscfHCs0xORnrEF/m46MrJEuzYrtJyZcLqfLuyEVlhXvyD
nEyKHlV+rh4CBdS5QGbSabSNFP+O1dTxcg1TWDbQGjkX2hlUPGSVUm3MFS/h
CjIsoStj+0oPYNrPtS6EqlLUsqvtoU2Ibz/bGTxsCgdtdG10v/RfFY3PFV0C
UqnmyvOcRMps0QbsaLlkspNqrmxQVrgBbiVeStHLSKsyEGXN8R6p5uzfqPbK
/LKq0qviRaSW1bWmpprIakHqOe9WzR4Uj+jKjLXma6o5L1CrMxazBowL1UMi
2/FOKRjwSTVX4W2OWP6VGVhZkfDG6GdtDsSzqaKVWC/p5MfWRlvUa4dd6xxA
gPnt5+Swa0dgSvRAvltqLBHbKqb7WfeqBwc+23YvxsVqKo+372dFihWJHVdW
mGlypKXRoFyTZmZ5ylq+7F+ZhZe1LdOvopgntWsw3fwhjuzn9LB7/MEMleOL
ibAMJU5bXL0OUm9XpwPEWfAo9mYx2o29Qwa1d7uijsRuiMoX99DCWfwuYilW
fXagVkltNWLqCtIy6jP/jaS0hs/cO2S8HLo81cgsB6MlUXMk2CWbx/UAhgRx
DjtsEHR1ktVxMrm1RyBzlps1s5JrwBhsCezkQ8H/QeGB/inzdbWdrT5yp5a6
bcvHvsvT2yJj+vlk4buV0fjmqkPWQso4VnTbp+OlTg4Mt66i1dm67HdRsqxs
KtlMhVHT3iPYqqGJ4db9NOJm5avsU1XzObEi6yyiBX5pddasbMzNir/xOsdl
xElpa2rpSWyVsTAr3EyLLvg8Kxr7Y7i55XlytRPVrb0scnUHdvYq+nVTM7S5
To3Iats2amoJ1c3uqKW1u6llvu+2u1IzX3uxaZrte+FtPMWI9rLPd3M9Wsef
rV1tr1v/Fa5ej+EaIzMMs8A9IhGXZQ28sy/VumtanXhbZOT+wv9FRruOEfb/
DG+n66zfMWY+vE1aVnw9C8MZP2wBLaMrLGKrxCOod22NbJcdZ7ZhMlo7MavI
1Wg4UHF8+XjnqkPG2FjhB99gE39ccddxvyAEHR335wyIa1EZu+4Po2hvk7qm
wV2kPzQntZxVtLk6xlHLFTWN9KwjpJazhl5B4XKLq8lnVCED9yoys5Nqrh3V
VHUusnUN3PIWR6ypseYys9rkv8ZPWYnPCYv99BnYOKfzQx8JcJOENLqzZVqE
NCbEerPSijsjYJz7OPjTSDjW6VEpbU1Hc29yt1Z0GWcfuqmkbkkl5401lfQq
tsqVHlt/MtCjlf1z5t2unW1BSxpE27or3Lk3GZITNatbjarxk/rrRr38mtnx
CjXHdmp9RaWH61qg7IXk/kCslsxLXOn5niPynO2zwhJ1slOiHPFshJUOiy/q
qneNpp4hq5CmmeBJd3nacwuxzrog/VcqKmLbMWYItOW5rDgFqjs+M+I3C6Lr
moKsDdoeCI90gALFpqQqBXeDc/Vm0a8zg5HGlMTDfPGlQBkp1+Ah97KSCmeb
uSJFKhlHqxWVtAj1kXG0NKzm3ZH1TPOLopcaLSVbKfaK1a+lTk1QBhtPLYgm
atTMravia4udNuReiqHOleuoCJ6/ouZm/lkV/58JyXXl/HDhOWKa2TGrXo2e
cbJaZIhdz6OCqjl0prQHg7bCQiqytx5UMubXxCd0H9+o9FtrJnqb1+KMEdH3
iIaInnlITx+oDKQCaYNKe+oBauGS8FpFR84jVLoznK49jEPFJ2MVyr3Lzl3A
+4CPBysVfurOdxkRo7oeo+Pcg4WP8PmVIn9EPXPaXrF/jV7mu9vXn9uTnKFV
2Y0P1LQsszePjhXLGujeIjOguHWiVqIO9gmVjcri5o9qy+mCC5I8vsM9iKwX
NW5GQ33mwlZFZwSX6xjcP8vTsXqigHGvp18c2/YxcOsZ36NSC/oIeBRKgDaA
zsM3UNdG8YA4t7NW4Sfvm0Un6Gdj/NYGsXbaOa+wrM+Td+CKC1lQFlS6GX7A
WDogsmwW/bZb5q7xAc9Z8c0DoDm5EXtTwZ7wqCAQzAPaPdL6xEPQSZl4bpg7
/zyC7RYYa0c6Qx+MxgyT5/ky4ompJ7T8HFeeF2e1i9VMWTmutMUd66wN6xV2
7pf5ebhR+h1u8QQvSPWKbaLeKPqNog23eGSIHAl4q3HwyFNiPCjJrUA00kg9
J17j/hdZLeOAp4p5NpLTddNGP+LzXJcPB0bq6oJQvkH49rMcUS0z09wpvXiq
L2cmm1WvlEJ7nSm8RJbjufKZcjcqyR3Si97H3G7y+nVkkbTxoNCurJTnO7I3
T78fET/jCUPGOwvTeeFis3hPZLGziTNan3zhKf0R36Zhikn7JtqpwlXsJ7kV
4n0U3IX+eL425zxbTwb1mtxZ0lp1svgnJDYr8M2D9rRyrFLRA7Py8VT8TuvE
er1RfCA04h7fzm6vDs8anCiW5DERRm9UQHp57u7vhr/2nD88BH/t2yLtmA7m
ad+X2BXyavEFaNgWJvhuy1rRcHj38q5x2zN3cTLBT5SHfhjB5SxVvfqt9idd
cAd9snbxHZ/1yufs1MGp6L9c9A98OxvJ943atzYAQRSd1fkIus8Tq3wfxCM3
fJv1Ps/wZb+5wh9g6f6ekyLC6Le296pvl/DcLd+OQr4GgYve7/rCKTMtSOop
OI/SHAnEGZ67vfeZIkV7IrVzJtiHv/A4G+j6+wCZOQnZnjq8tlDjUhX817R6
v/fxWLQ8QxkAuijUfKQwiqjiiV4OiKCsB73/+aID1nLwoud/vLaPQalgCQ7O
twTx2zLBBxzDK6+91ciaCnjzVj0x6zV2Enrim4MwMHBQxXiwG+kNnR5yPPfS
AceFfK/MvFTnA443yles0BDuBmA7ZuAY/j5CvE0HCjxgBDHL3t1Y8dHI9v6+
JuvLKCSjNvkmE4jrDlp74icyKHu794yhNzqBZvumgWlK33UkQq6jEMHfJpmE
Ivj6AOhDQXyDE+xDPihFd9aJlJWTSP726HirbciDx1AmhmNWTfzdEJ6Z4Z8t
TPbtexSOwFdKwT9ao9Ejjui2sZPWfHEV/Fgy9bzhrwvA9fjENoW9x27ejOW7
tM01/wF1ES3v\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91707995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121087815],

Cell["Exclude an equation and the automatically chosen points:", "ExampleText",
 CellID->576582404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Abs", "[", "u", "]"}], ",", 
     RowBox[{"Floor", "[", 
      RowBox[{"Tan", "[", "u", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{
       RowBox[{"Cos", "[", "u", "]"}], "\[Equal]", "0"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1689421084],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWc1rE0EUn81uTJp2s7Wt2niqeCrinyDeFBSP4kXBUIQWrNXas+jFHsSL
nryoBxVqvQl6qagtiIJYKArFglJB6sEiWDwUhPg+JvsxO5udpkkTatjszvzm
zXszb37z9u3uifLE8LnR8sTIUHng6Hj54vDI0OWBI2PjANmWEOIK/Bf7BZQr
UKK/V6lUhI0l+onzeBKNQTMAjjZQnymak7Z3aFsJdQJUiKxWTth8wR9qY7FQ
t1i/PqpPP164d/f93OxXVmBDCeqAioMp7aUa40MzrP/UyUeHD92ZvP5K9ocS
1AGV+pPbA/22xjuNGX1O0ar3bV6ukL51a9nSSqaaob3ECPY0HGtr6+R7BwqM
PH+2eID6QIGr5NkMlAmTenZH5kvr7TA74FhZ+c1aocDI2IWnrBUKXGWtUCYs
prW5Y263VWk9e/IK6tQl1QMne/7Dd2HD2kjMXyvA+Rg0ktpDFmORU6lX4xlZ
JjZB14hOqDMH4Rg0kmLL4ZgmNDGOLCKR7aXPPyO6oA44H4NGUmyx9r2mdqvZ
+m1H5m4G5TpECF54gfGoA7Es3/n4wDCynyShlCrZF/FId1MttJs/W88G3B1O
YjYQzih0WZc+W7MVKXVvFah+7eoMb2bh0H4P7judVQ7I9iycSnX0oRmLDsU6
jg6rPAqfK8KhOAd8iWgM+JWFU6mOPsmjiPvk08cfHMwpwAob8oGIZqjL9iyc
SnX08fxVN8nDa8fQ7bgfNoIWCX339hs0IOdcDU8LxNPy2SfHj90/c3rKl/Hg
agFdrZAmzMP452q4tldiHlwtoFi45+rqH+iFa+xqeFEgXsy+/jI9tfBiZsmX
8eBqAT2sLfVdV4X3n1vhyFOU9e4EuSob8lptbo06enJniryqj/ZMZGfkjOwW
lbo6m045Wx2eZC8jREyvbhyqnG7e9c5LbVfHU7UfHq9tvFpdsVGp4+4K6a81
Dv1swr2rVx3XioqcXlu9EQIyV2jATMSFE+48l560bt6Ygygwef2lj3u4r3FX
Um/01iWKB6Qn6+vB3nifxasThnzE96cd83CGdPmI5AuheQWFs6I3bokngRoQ
yfoycowJaPIYUkbvI/GRRBGbEQx9FvkwjUHanRaxnbbn1TrmPXrb/1uWaYZi
DpQzzHtM5LzIvFEiZ5jjmch5yXMwzGdN5PRW2mG1Ws8qjNK4QdPfvQiNFOuE
zEkyJgMnzNI5iwZcyu1TmBWVCxjYQ3aSnjaSnpz5CSLgAFuLP9WqTxpsraBY
y2jnCBmqZFQGTqSNmAd4xGrAvKhcMDozq6Fnx0j8TF6n1ryPbu9oqEcb/96u
6onepmhuN/+1fvXT3gRsRCopAvIXgIcP5nk/QzDjNYICI7dvvaEvAA4UkmSg
e79vRX0LZEvGGH3FcPgrhlYGurOVpDjAVpaXf3H8XV//yxqgwAikxWwFCkky
0L22lY14fTuycjNoY75eVme/i1o3+6W1eWNsN+9vJXeE9Q+T1tn6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{126, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251751996]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ExclusionsStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->415991474],

Cell["Specify explicit styling for lines joining exclusion points:", \
"ExampleText",
 CellID->625710437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"Tan", "[", "u", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"u", ",", " ", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", "Dashed"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "u", "]"}], "\[Equal]", "0"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2081287992],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66571424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46283114],

Cell["\<\
Provide styling for both exclusion points and the lines joining them:\
\>", "ExampleText",
 CellID->22209761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"Floor", "[", "u", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"u", ",", " ", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", 
      RowBox[{"PointSize", "[", "Medium", "]"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->125570121],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWL1v01AQf7FjCbEVCcRgN0HtAEKVsqBKSOAwNGRhSod0AlOlTSUQEDpk
i/gQUadIbEgIxggWlkoZ8w8g+CuYM2Y078tf53Py7NppLMX23bv7vTvfez+f
88Q57XZeOqcnh071cc953T05fFttvOpRlV4ihJzT39ebhN679I7/zl2XXuPn
2/SsUwOLXsvyyuRbbJTduPwgptQb3OsOGLVCMj2TKhjfBHIFyBqKuszLlDHD
2XA0zFujYlhPkMzV0Cw3HruHriU+NxYDKQdyPBcLiZI7+dULz7KZUD0vGuEl
Kn8F2PxAtTwvYz6fD4fDer3e7/dnsxkZLrAdjUbEO6iTtGX5/+I66FUGsr5k
HMq8PsZkMvFnHY/HqVHWzf6y4xOrHtbK35G2bbOnXEkalzIc3wDyVeVZtcFg
cJY8Op1O8VF8VQdatit+ZsBViOkio5F5k2Nclt1l5eNzUua6rDofP+IC1pmk
XXnAnSdsNKCF+9Hn4U6nU6vVJA+bnjbCzkcpEMNsvb//gpjfv/0mxsFBL8Lh
yYhe70CMdrvt++zs3JdIu7sNX9tsNlPFBjndRLVqiIKZqC+tL/PyZYlyLEqk
B5UyAEIdyEep10GWvaw26+qtsme0/nnmk1ExebLYHhVSR1VtGeGwh+wU4yGc
nfY4iseJISGGBztJE9UKvCRuEkhhbrq2cZeY9oMvxLhx/V6EmwQS2gnFYlPj
JjVEm8sIN9Euq9VqkYZ8SIFH/Ik5rnh3SdsFPMYt6XuskWk9JO+NxbjR+HIf
jcybz/5dZT4s4ucXqsuq8/EjTlEX1ch1ZNU+dTEuwb9Ot1yVXScQIZvg37Bp
EGEfZKF9kECE+5SBCZQwk3SPP0mU3pvPEX4RKMt6n2dulF8qnixRtpWy+wDk
rcRa4ZZFd0pqs67eKu9OaZ3yLLJTyiO2j4XUMf3Xm5rVO3ZKYDOs6xL2OFd5
dmFmEfawF6qwXkj/++efRC1Jf+mM7G+BA3sdnNHCfu+5HPDQdopnF//nmpT+
A9L+EA0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->970113382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->495453332],

Cell["Draw red lines where the region is cut by excluded curves:", \
"ExampleText",
 CellID->288541294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", 
        RowBox[{"Floor", "[", "u", "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", 
        RowBox[{"Floor", "[", "u", "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1842604355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31335656]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxRecursion",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->436378333],

Cell[TextData[{
 "Each level of ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " will adaptively subdivide the initial mesh into a finer mesh:"
}], "ExampleText",
 CellID->95077555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", " ", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"u", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"6", "Pi"}]}], "}"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "i"}], ",", 
     RowBox[{"Mesh", "->", "All"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "6"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191953008],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->357570381]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41783150],

Cell["Subdivision for parametric regions:", "ExampleText",
 CellID->1259140233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", " ", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "1"}], ")"}], "u", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "1"}], ")"}], "u", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"6", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0.5", ",", "1"}], "}"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "i"}], ",", 
     RowBox[{"Mesh", "->", "All"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1066038493],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->207274628]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mesh",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->120562846],

Cell["Show the initial and final sampling meshes:", "ExampleText",
 CellID->9407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"u", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"u", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30195],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->596810352]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1721507187],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->430847408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28775859],

Cell["\<\
Use 10 mesh levels evenly spaced in the parameter directions:\
\>", "ExampleText",
 CellID->11427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"u", " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "u"}], ")"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29355],

Cell[GraphicsData["CompressedBitmap", "\<\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