(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   3677652,      66473]
NotebookOptionsPosition[   3629716,      64809]
NotebookOutlinePosition[   3631459,      64853]
CellTagsIndexPosition[   3631370,      64848]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Parametric Plots" :> 
          Documentation`HelpLookup["paclet:tutorial/ParametricPlots"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Parametric Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RevolutionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RevolutionPlot3D"], 
          "SphericalPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/SphericalPlot3D"], 
          "ContourPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ContourPlot3D"], 
          "RegionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot3D"], "Plot3D" :> 
          Documentation`HelpLookup["paclet:ref/Plot3D"], "ParametricPlot" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot"], 
          "ListSurfacePlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListSurfacePlot3D"], 
          "ListPointPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListPointPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RevolutionPlot3D\"\>", 
       2->"\<\"SphericalPlot3D\"\>", 3->"\<\"ContourPlot3D\"\>", 
       4->"\<\"RegionPlot3D\"\>", 5->"\<\"Plot3D\"\>", 
       6->"\<\"ParametricPlot\"\>", 7->"\<\"ListSurfacePlot3D\"\>", 
       8->"\<\"ListPointPlot3D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Function Visualization\"\>", 
       2->"\<\"New in 6.0: Function Visualization\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ParametricPlot3D", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParametricPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParametricPlot3D"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["z", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]produces a three\[Hyphen]dimensional space curve \
parametrized by a variable ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " which runs from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParametricPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParametricPlot3D"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["z", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["v", "TI"], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]produces a three\[Hyphen]dimensional surface \
parametrized by ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParametricPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParametricPlot3D"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["x", "TI"]], ",", 
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["y", "TI"]], ",", 
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["z", "TI"]]}], "}"}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["g", "TI"], 
              StyleBox["x", "TI"]], ",", 
             SubscriptBox[
              StyleBox["g", "TI"], 
              StyleBox["y", "TI"]], ",", 
             SubscriptBox[
              StyleBox["g", "TI"], 
              StyleBox["z", "TI"]]}], "}"}], 
           StyleBox["\[Ellipsis]", "TR"]}]}], "}"}], 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several objects together. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->13310]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "No curve or surface is drawn in any regions where the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " evaluate to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", or anything other than real numbers."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->41],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " treats the variables ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " as local, effectively using ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15055],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and evaluates the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "i"], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[Ellipsis]", TraditionalForm]], "InlineMath"],
 " only after assigning specific numerical values to variables."
}], "Notes",
 CellID->13787],

Cell[TextData[{
 "In some cases it may be more efficient to use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to evaluate the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "i"], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[Ellipsis]", TraditionalForm]], "InlineMath"],
 " symbolically before specific numerical values are assigned to variables."
}], "Notes",
 CellID->27224],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->18222],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["BoundaryStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoundaryStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to draw boundary lines for surfaces ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine the color of curves and surfaces ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale arguments to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate at every function evaluation", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     Cell[BoxData[
      FormBox["u", TraditionalForm]], "InlineMath"],
     " points or ",
     Cell[BoxData[
      FormBox[
       RowBox[{"u", ",", " ", "v"}], TraditionalForm]], "InlineMath"],
     " curves to exclude"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ExclusionsStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExclusionsStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what to draw at excluded points or curves", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MaxRecursion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxRecursion"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of recursive subdivisions allowed ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how many mesh divisions in each direction to draw ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshFunctions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine the placement of mesh divisions ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshShading",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshShading"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to shade regions between mesh divisions ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for mesh divisions ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for refining surfaces", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["NormalsFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NormalsFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine effective surface normals", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PerformanceGoal"], 
    ButtonBox["$PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$PerformanceGoal"], Cell[
    "aspects of performance to try to optimize", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the initial number of sample points in each parameter ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "range of values to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives for the style for each object ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["RegionFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionFunction"], 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], "&"}], ")"}], Cell[
    "how to determine whether a point should be included", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True}}}},
 CellID->16439],

Cell[TextData[{
 "Interactive labeling can be specified for curves or surfaces using ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->27441],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParametricPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot3D"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Tooltip",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tooltip"], "[", 
     StyleBox["list", "TI"], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["f", "x"], ",", 
     SubscriptBox["f", "y"], ",", 
     SubscriptBox["f", "z"]}], "}"}], TraditionalForm]], "InlineMath"],
 " should be displayed as tooltip labels for the corresponding curves or \
surfaces. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6648],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["y", "TI"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["z", "TI"]]}], "}"}], ",", 
    StyleBox["label", "TI"]}], "]"}]], "InlineFormula"],
 " specifies an explicit tooltip label for a curve or surface. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26804],

Cell[TextData[{
 "All the functions ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "x"], TraditionalForm]], "InlineMath"],
 " etc. should give real numbers for all values of parameters at which they \
are evaluated. There will be holes in the final surface anywhere at which ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "x"], TraditionalForm]], "InlineMath"],
 " etc. do not yield real number values. "
}], "Notes",
 CellID->27834],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotPoints"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " corresponds to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotPoints"], "->", "75"}]], "InlineFormula"],
 " for curves and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotPoints"], "->", 
   RowBox[{"{", 
    RowBox[{"15", ",", "15"}], "}"}]}]], "InlineFormula"],
 " for surfaces. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->19368],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " initially evaluates each function at a number of equally spaced sample \
points specified by ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 ". Then it uses an adaptive algorithm to choose additional sample points, \
subdividing in each parameter at most ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " times. "
}], "Notes",
 CellID->31441],

Cell[TextData[{
 "You should realize that with the finite number of sample points used, it is \
possible for ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " to miss features in your functions. To check your results, you should try \
increasing the settings for ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and",
 " ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8872],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   RowBox[{"ParametricPlot3D", "::", 
    StyleBox["accbend", "TI"]}], "]"}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " print a message if it is unable to reach a certain smoothness of curve."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->40938333],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " corresponds to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " for curves, and ",
 Cell[BoxData["15"], "InlineFormula"],
 " for surfaces. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->32668],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MeshFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshFunctions"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " corresponds to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"#4", "&"}], "}"}]], "InlineFormula"],
 " for curves, and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"#4", "&"}], ",", 
    RowBox[{"#5", "&"}]}], "}"}]], "InlineFormula"],
 " for surfaces. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->19974],

Cell[TextData[{
 "The arguments supplied to functions in ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ". Functions in ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " are by default supplied with scaled versions of these arguments. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->19176],

Cell["\<\
The functions are evaluated all along each curve, or all over each surface. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->5137],

Cell[TextData[{
 "By default, surfaces are treated as uniform white diffuse reflectors, \
corresponding to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"], "->", 
   RowBox[{"(", 
    RowBox[{
     ButtonBox["White",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/White"], "&"}], ")"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->20633],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    StyleBox["data", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3241]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34709169],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->281251781],

Cell["Plot a parametric surface:", "ExampleText",
 CellID->15581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "u", "]"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "u", "]"}], "+", 
      RowBox[{"Cos", "[", "v", "]"}]}], ",", 
     RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434199828],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzUvXWYXMl5LzzXXlPsGJM4Tuwb59o3yRff06LV7srr5dWSt8W0klYrOAMa
Rg0zM2MPz/RAwzAzMzMzM8909/k93z11ekarHWmTdfL9883zqOF0VZ2q38tv
vXXEf2CsoarzwPjxowe//dDwgb7G40dGv/1Az5C99O3/oaKiksP+a/p7Ffbz
/8t+4v7lAGB/+P/o9Tr7+m122G+Rb+QDuD+Vb6kof1NRuXHsl2+Tl5e+/K6i
cu3/F+3eZV/Jqr79THsVsnL23w8Of/vu4ftP2HcyxLtcm3eeG/F7x+7522Nj
ftN+vzq8z0vHrr/zDfv/r2Pf3/6aft85XNf//gvaP9vuF4fz/KvnWr77FWy/
d/j+UxzjKlVVVZXD/uT397heJ15AERzy3j8fjqD8UQnstw5ncYG7xHtuLi89
d+U3hz2+z/3CTuLpL/xvPMY/Hs7yR+Trd56OcUjpT7/xOH9/uKIfc6v9ci7H
Je/jbzzi374Ao78+NvpxbL/56D8/xO7nLxiR4PEJ1+w3L6DhkVR9H1+VqiOu
OM7tPzl2h+Pc9yE35q+fm+Fxafj10Tgqyr9fHRv3u8faf8AN83eH6/zWfzr+
P7wA778/do/jfc5/w7n/8nAWvzk23vePtXv/a8Y7kvCjcX77gnmR3z/4D/of
l3jy9ffHxvnBsXZKSf4Rvt6KHN35uG44zpn/fOxOf3Xsd6Wm+etjV5/X9v90
eJ9/PzbeD4/1VOrY7+DFGvj5cX992PIPx8b90bGeb3/Def7qEIcTL5gnuf7O
Nxzn7w7bnz42zvGeb33D8Y4of/bYeD8+1vNNHFH+WRn/GV7MCWeOjfaTY78f
cRCnmTg7RUZ7/Vivn76g17PfKa73/zqk1J/+g3uqHM75pRdwonKUfzqc0dvH
Rvn5sdbH+VTZ+9eHvd/7L/U+4o3zx3r/zbHWx6XxP+/9rLfDcR43g6+T3ada
QZX7e25Ewitf5Z5z3NtxWXuey47ZG3bI94+N/ctjY7zCdfw2vqm8PudVHBv/
nWPf//5Y+7PfcCVH9vClY+MRdH/CWQtbirajaILfP/w37vFsi+P3+rdDGqr8
7S2K/oK9F0VrUrQ+RbOXLCjahpuAI0U7U7QbRXtStDdF+1F0AEUHU3QoRUdQ
tEA5Q3Jble+w38Mo2pei7bkhOKkma3zlvzjf7xyb7+8Ox1P59QWKvkrRdyj6
/tGs9SjamKLNuRvbPzNlH4r2p+igo/lGUXQsRSdSdDJFp1K0mJt+GtfrW+k8
WrkOMY9O4dEhFO2gXMdxrcNppade6ZEOewlfWqxnZ31kWVR+y876GkWzWH9O
0Q+embgJRbNw23I3+7pZxx3NWkTRUorOoOhsis5Voq+iUsyjS3j0t8tO0Crf
Lj9Bl5/k5s3d9aWC03T2aVp6khZS9FOP9JnVcBbgOT4+vop/POKVf7lM0dcp
+jZF36PohxStRtFaHNM8XYUTtxDvoyWEcVwS/TVLyKPoQoouoehybi1VJ+ia
U3TtabruDF3/Mt1wlm56lX6p+TVu5irfrX+VrnmVLn+FZheVwt3mOFedeuFq
vv8iqeWxv/Mpms+Nw67qJkcYdkkaFK393JLcuWYs74c8x0jH1lNEEWKwNKg8
RVefoZV6sPEc3fRHuuV1uvVPdNsbdPubdPtbdOc7dPd7dO95+lu9H9Aqf9X3
AUc27q/rHbrjTbrhNbriJLmRypd+sZJevzz89sNjK+PsOlnSD5SLukHRd7lF
qVO0zlMZ+Tm5xS8qTtNVZ+naV+n6c+QGLW8QCnS8Q3e+R3e/T/ecp3s+oHs/
pPs+ovs+pgf+TA/x6ZGL9NhllskmrpGX60fzVXIa25xdoPLKs56hyldm/Sxd
js+esww/eEoXJWkuPbMKpab5xVOSeHPqKIRrx7GYqpBSTaFUJZRqOqVK6MGj
C0/QJafo8jN01SuqKt8l/X/K3rH3Y7r/z/Qgnx66QA9fpIcv0SOX6dEr9NhV
evw6PXmTnv6Mnr1Dz9+jF+4rue97iw/Jbea+oGc+pydukS7d52mVIx3w7LpO
vHC1Pzq2WqIfv8OukVvTPz0+UmIWnN515tbnQ6kGcFqAbRFD0QmUahKlJqLU
pJRaJqWWw1PLP6lWdFqt9GW1ilfVq8+p1/1JvfFN9ea31dveU+s8T3r1fsLp
CGUEolzZ1GfsrKdvszwyc4ee/Zye/4JefEAvPaJX1OhVDdJpXYttsa59KHVr
2vSKJj3/iCy6n0+/YL28F673eFT51Bc8JO23+EqNpPIvStF7RNEsCLovAiGQ
Ug2lVCMpouwSCYXVxZR6GqWexVPPPalecEa9+KxG2WsalX98XPvG44a3NJve
1Wx9X7P9A82ujzTZLv181cFLauxMRq+pTdxUm/pMjcPjlwsP6MVH9BJNL6vS
K+r02mN6Q4ve1CVL3Dakd4zoHRN69wm984TeNSUXd83oHVN601h16TE98wU9
ohSA41EQ9RUJPR6n/uhQQrkZ/OEqR1rl4jWeW7wHZwqOFq/GthRSaqmUuoTS
yDihkX3qcd7Ljwtf0Sw5p1n+ulb1m1p1b2s3vqfdcl6n7SOdzk90uj/V6bug
w/Yauqo5cl2TncPkbc3pu5qz9zTnHzxefPR4SVVDyRl/vamjuqVHbxvQu8Zk
Qvtm9IEFfWBJy6xVZTaqcjtVub2q3EFVKenf3XfQ2LHXWjXVmtfWnFZ//Iz1
ezEnHMfgB8c5gYx66hJn1a9ziNw90sQsIkac0rI9QsSXsINaGKUeST2OpQh5
UyltCU8745R29svaea/oFJ7TKfmTbsWbutXv6Na9p9f0gV7rx3odf9bvuqDf
e0m//4r+0DV9ttfYLd2J27rspGa+0J17oLvwSGdJTWdFQ3tNU3tDR2tTT2tb
X1M5s7/ZM1Fn3w4sNPatNA5sNGR26nJ7dbmjusJZnXFVh4cGvB4zPmQqMh/d
fR/DDSeDZUv9JQv9F3DHH55DiFNJxxDiLNZrSgWoxOky5z2wkvIZd/GpSufQ
UbWh1Jx46u68xz48zQCeVihPR0DpxlJ6iRSZg+SkYfoZw6xXDHNfMyx43bDk
DcPytw2r3jWqO2/U+JFxyyfG7XzjrksmvVdMBq4bD900ZruM3zWevGc0fd+I
ndM8bbioZrisYbCqZbCmrb+hq7epr7dtqLtjrLP3RGffTJtD6Rcyay2ZndaB
g9aBk5bMWUvuqqlw12Q8NeGthQBdBOkhhExGEWEsE5ht+5tu+Zhuej9RUXne
Lz/yqX7HoXNk+V6ULXrp0C8hEdK32KlyfssflbgpmUvJVTc43D7nrqtRqtqU
mgFPw5T32IqnZc/TduXpePH0/Hn6wTyDCJ5RNM84gWeSfILMLf2sadarZrl/
NCt4w7T4LdOyd00r3zet/dCs4WOz5k/N2y+ad102771mPnDTYvgzi9G75myX
qfvmM4/M5lTN2PksaTxZ0TRZ1TZZ1zXe0DfaMjTaNjbcfWKwZ2ZwYK5/YKkn
s9ZV8pjcUVfmrCtz1ZW568o9dRXeuoyvDuOvg2B9RBgj0gTRZD4QWjLJNrIE
G1mc9UGsNXtlRl31hZ7+V3xrLuer9Oqezyh95+mVQ2T/7hg3HkUrRGOrnGP9
2CucnN4iPjhRyTTvsSZPS4+nbcLTteDp2fIMnHmGHjxjX55JEO9JGM80imce
x7NIOmkpOmPFts88Z537J+uCN62L37Eue8+68gPrmo+s6v9s3XTBuu2SdedV
m54bNv23bIbu2Izes514YMt2mVW1mVe3JohqWq5oW6zomK3pmW0Ymm4Zm+48
ebJr9mTf3OTA0lhubSyzNSJc5qAvd9RTyu8v5J4GMm8Dua+B3N9AEWjABBsg
zAhRTxBnjkRLpBAYIXVApguy3JDpigwX9sqmmwEX/z2NaV+A6FFW74gfvyYf
+BzCnPw/lxd+ieB78UjSVT+j1O9SRLtq8PR0eAaGPEMznrE1z8SRZ+rGM/Pm
WQTwLEN5VgKeTSzPNvGUXcrL9tJXHdj2OW86FrztWPyeY9l5h8qPHGo+cajn
OzRddGi94tBx3aHnpmP/bcehzx1Hv3Acf+g4perEdpl/7LCoZc9OaEXXdk3P
ek3fas3QYsPYYvuJxa65+b6luczaXG5rprA3VTgQPlQ4GytcDBVuhgpPDm5/
Y3mgsTzYWBFqzIQbQ2CCWDOCbaotpPbIILdArgeK/FAejLIgFAeRXvHmL464
vznvvvQsske5zKOsvZIunD98+SLhWrXrlMZNSvM2pX2f0mN/0uIZ6/OePOGZ
WfIs7HmWLjxrT56NP88uhGcfwXOI4TklnHZKPussfo3wQ/ZbbvnvuhWddyv9
0K3iE7fqT93qLro1XnZtuebaccO1+zPXvrtug/fcRh64jdNuU2puM4/d2F6L
2i5Lus7sfNYMHNcN7TeMbTdMbDafWG+bW+1aWu1bW8nsLBUOlnCyYFws2PaM
u6nC44nC01jhY6Lw56AOMVWEmyoEZkyUKRNtigQLJNtAwqLqjBxX5LOoehNU
ayLQEIOGeDQKCSjZHkpsn+O94zmb334NvkfZ4ePa+ciz4XB9i0+pXaI0rlCa
1yntW5Tu55TBI8qE/VWXZ27MszTnWdvwbJ149u48R1+eUxDPJZznGnXCLe6M
e9IrHqI/eqa94cU2znvfu+hDn9KPfSo+9am+4FN32bvxqnfLDe/2W95dd7x7
P/cauO898sh7XNV7UsN7RtNrTtuT7bWk77Fi4M5Cu2HssvnEedPUcdPMfsvc
btvSdtfGdt/ORuZgo3Cygas13InaYbwsGG9zxsdM4WfKBJoxIeZK/fBzJtpC
EWfJxFsiyQpiO6Q7IpsF1pMFliy7JgyNsWgVokuK7kxypT//SPS/gthfguxz
uZBjCKvcfsaKqfIpjQuU1iVK5yqld4MyuE0Z36dM1SjCMAY8W1OevRXP0YHn
7Mpz8eK5BfA8QnlekSe9Y1/2SXzVN+V1P8mb/hnv+LONCz4KLPlzYDk/sOpS
YO3VwMbrgS23AttvB3R9HtD7RcDAw4BhOmBMPWDisf+0lt+sjt+Cni/ba8XI
e83EiwV6y8xj29x928J129J529px28Zh185+38Fe7mzPuNrB3Y6swdsGvtaM
vxUTYMkEmjMhFky4JRNpxcRwNEi0YZJsOLXggCwX5LHc64MyP1QRhYC2RHSL
0Z+NkWKMVZArU81KXI48gOf9gu/hef8Az8bCt1ge5VOafErnAqV3mTK4Shnd
op7co8xpimh+PZ6DCc/Jgudix3Nz5nl48Lz8eD7BJ3zDT/lHvxwQ/1pg0utB
ojeD0t4NzjofwrYv+nNo6YWwysthNdfC6m+ENn0W2nontONeaPf90L5HoUOq
oaMaIeOawVPawTO6QfP6gQRA44C1J/4bZn4shtuWPjtWXjs2nru27rt2rrv2
znuOTgfOTnJXR8bdEV6OZAV+9vC3Q6Atgm2YEGsmzIoRWDPRNkycLZNoi2Q7
pNodaQA3FHqh1A+VQagNJX27UtCfgeECTFRgtoFcWR7A8tgL+JPb2X26I0jw
4iz8HY7tNPiUFp/S5VOGFynjy9ST65TZHcrqAWWrThEbY8RzM+N5WPO8HHje
rid8vU74+58IDDkVJDgbEvNaaMLroclvhYnfDU8/H5HzsYBtX3wxsvxKZNX1
yNqbkQ23I5vvRrZ9Edn1ILKXFgyoCYYfC8a0IiZ0wqd1w2YNQheMyEpWTIPX
zYM2LQNZ1HZt/Pfs/PbsffYcvPccPfed3PddXA9cXeQeLoyXC3ycyaoCnBDk
iBAHhNoj3A4CG0TZINYW8bYQ2iHFDiI7Yo0ynZDnjmJWaQagJgSNArQnkO6D
2RgvxUwtFtqYlQFyZXsZO9sv0pm/f4rcs1e571+oPJNX4thOn08Z8aknFymz
q5TFZ5TNF5S9KuWsySPmwYTnbXHC1/aEv9OJAPcTQT4nQwJPhYWdDY86J4j7
kyDxrcjUd6OkH0RnfhyTy49h25dcja24Hld9K67+TlzT57Gt92M7HsZ2q8b2
acQOasaMaMeM60ZP6UfNGETOGwkWTSLYLmvmYeuWoVvWoSyMe/bB+w6B+04B
B85+B66+B27eMndPmYe73Mud8XGDP5kSgl0Q4owwJ4Q7QGCPSFtE2xIYE2yR
xMEo5uQ80xF5bgTGCn/UhjDNUejkDM9IPiYrMN+E5R6sj7JX5LubWGOw+kIk
f/e1SHK8eI1lRA5HHQ5EMz5leYmyvkHZ3aWcHvJc1Xke2jyipE1PBFidCLI/
GeJyMszzZLjfKUHw2aiIc9HRb8TGvx2b9F6c6IO4tE/is/kJ+ZcS2fZlN4SV
nwlr7wob7gmbHwjbaGGnmrDnsbBfK3FIJ2FUL2HCIH7aKG7WOHb+ScySWTTb
Zd0qcsNasGUbweK47xh24Bxy4BIscwuUuQfIPf3kXr5yb2+Fryf8PRFIzBNC
3RDminBnCJwQ6YAoe8TYIc4WiRyOSglOsyct891Q4sXiyLA4tkQxXcnk4lgR
Md1stL2/j2UZlrYwN/OlLvySA8k3Dr/rz5gLbe6zIZ8y5VNWFyjbq5TDZzyX
ezz3Rye8Hp/w1T0RwDYwOxlqczLc8ZTA7VSU96nogLOxIefiBW8kxL4jTHxf
mPJhkuSTpAx+cs7llIJrqWz7itui6s9FdfdFjQ9FLaqiDvXUbs3UXu2UAd2U
Yf3kMcPkSeOkmSfCObPEBfOEZcs4tsuGbcymXfS2QxQL2oGL4MA1QuYeJvMI
lXsFy72DFL4BjJ8/E+CLQB8EE08AYR4Id4PAFZHOiHJEtANi7RFvRwQ4mRNg
FrR0VoaJDkKJJyr9FHUhipZopiflMA8pn2uQLXftr4/ubi0or2B+DwvbmJ5C
d/ULd5Cf4z9uz+zuEZiPORk+BJNP2V3iOV3nud054Xn/hI/qSX+tk0H6J4nC
sjgVaXsq2ul0rPvpeJ+zCYHnhGFvJEe9kxJ/XiT8SJT6Z7H0gjjzsiT3mqTw
lpRtX3kvreZ+WsOjtGa1tDaNtE7NtB4dab+eZMhAMmIkHjcRT5mKZs1T5y1T
lqySV2yIdG3aJ2w5xu04xRI83aJlHlFyT4HcO0LhE6bwC2X8g5nAIAQFINgP
IT5kPeGeiHBHpBuiXBDtjFhHxDkgwR5J9kixP1SILJ5ZHB+WejJVfor6EEUr
0TXykZyDqYq9hZadlf6tjamN7RVMH9UyzK5itEdRFPGcPP8HeD7k8FRnZZlj
TiWY9nzK+TLP4+YJ77sn/R6eDFQ/GaJ9KtzwVCTbxup0nP3pBJczQs+zyX7n
UoLfEEW8I44+L034OC3503TxxYz0KxnZ1zPzb2UW38li21c/zK6jsxvVs1se
Z7drZXXpZvXqZw4YZgwbZ4w9SZ80S5+2SJuzki7YSJZtxav2hKW3nJJ2XIS7
rgksnjLPOLlXrMInRuEbxfhHMgERCApDcAhCghAagFDiCiHCC5EeiHJHtCti
XRDnjARHJDog2QGp9hDbc+EOwRP5JGhQVPnJWTzbYmX9kr3Rgu3pmo3FzrXV
kZXNeYwzmFBwPo4MU1ucyI+g5zkO/e1XJJ1D8gEHoNKpMeQ+K5F0uUB5XOH5
3joRcO9kMH0q7PEpge7paOPTRBJtziQ5nklxOyvyPicJeEMa8k664HxG7MdZ
Qn526qUc6dXcjBu5OZ/lFdzNK/mCuLc1qvn1GvlNmvmt2vkdenndBnl9RrmD
Jjkjpjnj5tlTltmz1lnztplL9hkrDmlrToSft11Fu26pex7JLJhyb6HCN0Hh
F88ExDKBMQiKQrAAIeEIDUFYEMKJNwqBN6K8EO2BWHfEuSLeBYlOSHL8Esw0
OwJmNgsmMfDyaj9ZA3HBdgfSN8dL1mYbl5f6FtcmMcxgRIFROcZlZNiJLYwv
KrXBt1ESeYjjUYWYytM9bY5LVZXuNefqPOGwJEDyKc+LlN9VXtBnJ0K/OBmh
eipK63Ss/pkEkzNEN9u9LHE+K/U4l+7zRkbgO1lh53OiPs6N5+cnXS4QXStM
u1mYdbso7/OiwvvFpY+K2fa1j0satEqadYrb9Io7DYp6jAr7nxQOmRWMWhRM
WOVP2+TN2eUtOOQuO+WsumStu2ZuuWewvfY8pfveYhZLhV8K45/MBAoRlIDg
OITEIDQKYQKEhyMiFALOdY70QZQ3YjwR64F4NyS4QuiMJKdDLFmtKbVDphJL
J0WpB4sluUVn/PpQ9spkxcJc++zyCPoYDMgxKMOwDCMHHEtuYHQRI+MY6CLu
u9DsOT/7fz7F9HgtkMrVI09Sk7PeltxXgu0Fyu8SFXyNF377ROT9kzFqp+K1
TgsNzqSavixh2zi8kulyLsvzjRy/d3KDz+eHf1wQzS9KuFycfK1EfLM0/XZp
1udleffLih6Vl6mVs+3rtCsadCua9cvbDMs6jct6npT2m5UOWZSMWhVP2BZP
2xfNORYtOhcuu+SvueVteORueZIS2T2fjAO/dAJvgJgJEiE4BSFJCE1EWBzC
YxARBYEAkeGIJByHKD9E+yDWG3GeSPBAIguvC5KdkOIAEQcvy6qZdsjh4C3z
UHLfzza7kpZGCthP0ws94yuT6JGj9wD9exjYxeAuhjipH17AEItvH9rKlebq
q0j+5uvxVT9yMfU4dWrHffXkU34XqeDLVMR1XvSdE3EPTiaqnUrWPi0yPJNm
9jKJXx3P5bq9ke/1ToH/+aLgj4ojPi2JuVSWcK085WaF+HZl+ueV2fer8h9V
FatVl2vWEHz1ahoNalqMqttNqrpMq3rNKwcsK4atK0Ztyyfsy6Ydy+acSxdd
S1bci9c8iza8Crd9iALZ98+RBWSx+DLB6QiWIESE0BSEJyEiEYJ4RMYiKgrR
AkSHkVXFBCDGF3E+iPdCoieEbkhi8XVGiiOHrx2nCpT4OspZfFlt0xy+3CuZ
HS1hP48sDqNdgU4ZuvbQs4PeLfRvYmCDc+vnMDCO/j50NaBG+iKEucq2p1nn
F1WWHuWZOdQ1lB4WnzLm9K4zh7rfBSr4EhVxhYq5wUu4eyLp4clU9VMSndPp
RmeyzM/msm2c3ih0e7vY+/0S/4/KQj4tF1yqjLlalXizOuVOjeRebcaDuhy6
rkC9rkSzvkKnoVqfRG6NxvUtT+rbzeq6LOp6LWsHrGuGbavHHKonnapmXKrm
3SoXPSpWvMrXvMs2fUu2/YmqOQgqkAXnEdRDsxCajjApwkWISIEgCZGJiIpH
dCxiohFLgjLEBiHWH/G+SPCB0AtCdyS5IsUZqc+iboscOybfQVZKooPV1ujZ
/szx8SqiDVoUaJWhbR8du+jcQtcGetbQu4q+JTJ43zh6+9DdgsZ8FEW8AFkl
7s/nVp/PXx/veUQHpWdmxulsD44OwRepiMtUzBUq8SYv5fMT4ocn0zROZ+qe
yTF5Oc/ytUK2jfPbZe7vl/t8WBHw56rQi9WCq7WxN+uEtxtS7zVKHzRm0k05
6k2Fms2lOi0V+i01hi1slybT5lbz5g7Lpm7rpj6bxgG7hmGH+jGnukmXuhm3
2nmP2iWvmhWfqnW/ys2Aip1AIsYHISXy0CJCh/BcRGQjIgMCKSLFiEpFdBJi
EhEbj7hYxEeRVcWHIj4Q8X5I9EWSN5I8keyGFBekOkHswNHBFhk2yLaV59kd
lBDHYr4tfnwwjxjFBkbRKGeaDtCyi9ZttG2iYx2dK+haQvcCGbxnFN0s97ei
tQIVScdiMCIPv/kv04GrTLvJAc/Kgwmfsub0O/GULlARlzg6XKVSb/Gk906m
06eyNM/k6r9c8OSVYsvXS9k2Lu9XeXxY7fPn2sCLdaFX6iNvNMbdbhLea0l9
0CqlWzPV23I12wp12kv1OyqNOmpMOggpLNpbrdo7bNq67dr67FsHHVtGnJvH
XZum3JtmPRvnvRuWfOtX/evWA2q3gmp2Q6rZLrLwcnl4KSGFoBCReYjMRmQG
oqSIFiMmFXHJiBciIR4JxOlFYjgSQ5AYAKEfknyQ7IUUd6S6QPQMKdKtkWUj
y7XZK3baqPKe7EjqHa0+1PiKOhnTsI/GHTRvoWUdratoX0bHAjrnyOhdw+js
RQdLi2rUZyM/6EX66LuH2uZnfxFdvnWkn/6ZowcrFxZ8yoGzB+QuF6mYS1Ti
FSr1Gk/62YnML07lqJ7O03q50OBsiekfy63erCT0+LDO88/1vhcag640hd1o
ifqsNe7ztqQHHSK6M029M0uzK0+3u8igu9SoW+WHZOL/PuXZOuvTuuDbsuTf
vBrYtBHcuBXasBteR1AXVMsFFQT1qBJEFyI6DzHZiMlAbBriJIhPRUIyEoUQ
xpOFJEUiKQxJwUjyR7IfUryR6oFUV4icD1GX2hDUM60Ocqx2ixyWq7yHu0RK
D09WRRwV8sd9/zEa19C8jJZFtM6hfRodE+QG7d1oa0FrLRryUJHIGuyvwf3Z
7z/978nFrzg6sEJhw6dcWQvBp8I4OiReolKu8KTXeJm3T+beP12gdqZI+2yp
4WsVZm9UW79by7Zx/aTJ60Kz35XW4Ott4Z91RH/eqfJ9srYfVpr111j2s5+a
bfvb7Ps7Hft6nHv7XXuH3HtGPbvHvbq48hmV/ymLqiOOTXQlE1OO2FLEFiEu
D3HZiM9AQhoSJRCKkJSMJC5jkxyNZAGSQ5EchBR/pPpA5AmR2zPgWyPNChmW
B9mWXPz3vZ3iXULi8h155baiaoup2UDtmrKW4IdonkHLJFpJxhGtXWhpRnMN
GgpRlYocvyN+/7JW7r+C9/Gok+P7v+XwNudTjnzKi7UEfIro1ou8lMs8yVVe
5jVe7p1ThQ/OlKi/XKbzSqXRn2rM3663Od/o+AlR8d5XOpTVRf+Y8KgvWb1f
rDmQrjOYbTCUZzRUZDJUajZUaTFUYz1MsHcYbnMa6nQZ6nEb7PcYGPLsH/Hu
G/ftm/LvnQ3oWQjqXg7pWg3r3Ijo2BK07Ua2KvnyN0/PGDDxFUgoRUIREvKR
mI3ETAjTkSRBsggpXOonNQ6pUUiNQGoIUgMg8oPICyL3LwkiYQliiQyL/azD
PYwfbuZt7xRs7RcRj1JetqGoWGcqV1G9jJpF1M2jfla5uu+jpQvNzWhiKVKC
KgmKo3ZjSWL++J7EcdlQ0ubIR/o6X4mjw885Ojxl+gg+Fc/RQXKZl3GVl3ud
V3j3dOnDlys0zlbp/bHO+K0Gi/ebbT9q47jn9wG3ekPu9gm+6I95NJigNpT8
eFisM5KuP5ptNJpnMlpkNlpqMVZpPVZjS9ir2WmszWWs022sx2O032tk0Gd4
xHdo3H9wKnBgNrh/IaRvKax3NaJnQ9C9FdW5G92xH9OmwtXjKeIbmIRa7o7/
CmERkvKRlIPkTKSkI1UCkQgijhDiWIgjIQ6HOJijgjdHBReIHTkqWEFqiXTz
vUwztvFa5vZm9tZO7sZ+/johQvGqomSZKVtCxQIq51A9g5op1I2jfgQNg0qq
fQ+NzWioQT1LigyUxCLLs1/38TekxS/wTEbgJ1yA5XDE+NF8KonDPOMyL+cq
r/DGidLPz1Q+Olujea5e/80mpaT+u/OlHvbN51Z/wJ2B0C+GBA+HY9RGEh6P
JmuPifXG040mskwm8swmCy0mS60nK2wnqx0m652m2C6t7pMdnpPdXhN9PuOD
fmMjAaPjgSOTwSMzocPz4UNLEYOrkQPrUX1b0T07sd37cZ2HoCc2K4SNTFId
kmuQXMHx4++RmglROsQSSEg+BpIESGIgEUAcArE/xN4Qe0D8LOIWSDPbzSCh
+qp0fSN9bTtzdS97hSCev6QoXGCK51E6i7JpVEyiahzVI6gdQl0/6ru5VX8H
daWoyUFJInID1wJNn9P6x3n6S7Sf4/S/5nxPJZuH86k4PpXKoZ5zhVdwjVd6
82TlvZdr6VcbDiucTM53WHzSZXeh1/kq0eE+d4YD742EPhwVqI7FaIwnaE8k
602KDafSTaazTKdzLWYKrWZKbGfK7WernWbrXGYJ8J6zHd4z3b4zvX7TAwFT
w0GTYyETk6HjM+Fj84LRxaiRlejh9ZihzdiBnfi+vYQeJfDypDZFcguT0oTU
eqTWILUSojKIiiDOV87sD5CmQ0pCb6QJkRYHaSQkoRAHQOzD4e/6Jf4Sc0Zq
upNO9nhXRCvrkuWttKXdjEWCf86cIm9WUTDDFE2hZBKlYygfQcUgqvpR3Yta
kkBAbSPqSEyJmjyUpyIvFOkuvY/ppxHWkSfz869H/Ydc2EXcGj4VyaeEfErK
oV5whVd6jVd562StclVntd5q13+v0+SjbstP++wuDzjfGCKo3xsLfDAeSk8I
NCZjtKYSdKeTDWbEJrNppnNZFnO5VvMFNvPF9gvljgtVLgt1bsSDbvFeaPdd
6PKf7w2cGwiaHQ6ZGQ2bnoiYnhZMzUVNLsZMLMeOr8WNbsYP7yQM7gkHDlFP
6VKktjOiVoibIa6HuAaSCkhKISmCNB/SHKUU/g7pyUiLhzQa0nBIgiD2hdiT
g9xJqeoZsRkjebKdRgotlpMX1lLnN8VzO9LZ/XSyHyDPnlLkTjD54ygcQ/EI
SgZR1o/yHlR2oaoD1S0c2NWoKT3KiBVGIsNzycvwOfv7N1+P+Q+4EIu4MHwq
lk+l8KkMDvPiy7wK5bjn7r/WovZGu9a7Xfof9Dz5c7/lxUG7a8POt8gOkM/9
yUB6KlR9WqA5E6M7m2Awl2y8IDZdSLNYzLRezLVdKrBfKnZcKnNZrnJbrvVc
Jqrdd7nNf7krcLkneKk/dHEobGE0Yn4icm46enY2ZmYhbno5fmotYXIjcXxb
OLqXNHyIuahXIe5mJJ2MtA3SZkgbkFaDtEqklSK9COn5SM9BRqZyxv+K9ESk
xUAaAUkwxH4c7G4c7PaM2IqFXSE22ZYazsfPLSfOriXNbKZM74im9iWTBPaM
MUXWKJMzgrxhFA6iqB8lvSjtQlkHKlpR2UQArKpEFavaWU5PI1+z/RiRzXOn
837xvDb/gE8586lAPiXgUwl8SsKncji0SWB57UTD7bMt91/vUHu7W+v9Xv2P
+034g5ZXRuxujDnfnvD4gujnQLXZUM05gc5CjP5igtFSsumSyHw5zWol03Yl
x34133G1yGW1zG2t0mOt1pvYqmb/9bbAtc7gtZ7Q1f7wlSHB8kjU0nj04lTs
4mzcwnzC/FLi3Kpwdj1peit5cjdl/EA0SsCWDCgkfQppD5PWhfR2pDcjowEZ
NcioREYZMouQmY/MbLLSTLGy0hdpAkhDIGEVuxeHtbMSa4XIVCEy3pIYzMdM
LcVNrrKEFU5sJ4/vpXIbiNJhRfoQkzmInAHk9aGgF4XdKO5ASRvKmlHObXJX
sMFtMSpYrNNRxMUUac6LHjrH0VbqleMnqjjUv8un3PlUiNJ68ql0PpXPzVrt
Mq/+xunmu6+1P3ijW+3dPq0PB/T/PGRyacTi2rjtrUmnz6c9HhDlHPh4MVR7
SaC/HGO0kvBkNcl8VWS1JrVdz7Rfz3HayHfZKHLbKPXYrPDerPHdqvcnnlpr
yFZH2GZ3xGafYGMwan0kZm08dnUyfmUmYXleuLSUtLiSvLCeOrcpmtkRs4w3
QVCXjijShhTp/UxGLzK7kNmOzBZkNSCrFlmVyC5DdhGySGYAWVJkJiNdCUYo
pIGQsOrcHRIWdQdGZKVIfaJINdwW689Fji9Gj63Ejq7Hj2wlDO8KiaKUiwbk
kn5Feh+T2YvsbuR2Ib8DhW0oakFxI0rrUEaia5QVoiwHZSzqicgjEQ4jNPke
nsmXvRjtjzlfJYKzmiI+lcU5jSQIvXKy6ebZtruvdz14u1f9/KDWx8P6F0ZN
roxb3Ji0vTPj9MWcO02UcqD2SqjeqsBwLcZkPcFsI8lyI9VmU2q/leG0leOy
ne++XeS5Xeq9U+G7U+2/Ux9E4pXWsN2OiN3uyJ2+6O2BmK3huM2x+I3JxPVp
4dpc8upiyspK6vKaeGlTsrAtndtLmyFop48rMkYVmcNM1iCy+wgO2e3IaUFO
I3JqkVuJ3DLkFCI7h2PzVGQkIj1aqV9+D4kvJB6QuBC4xQRueYrBtkhvNmx4
IWJ4OXJoPXqQmOqE/n1hH0E8tUch6SbSlNGJLPY2rchrQUEjCutRVINigg5K
ClCSjZI0FCchT4AskmtZcNU4zuc/e4r8050OPT7ly1nMRD6VxsFdyqeILb5y
pvXma5133+h58O6A+kcj2p+O6V+aMLk2ZfHZjO3n804PF93ViEoO1F0PNdwQ
mGzGmG3FW24n2Wyn2u9IHXczXHZz3PfyPfeKvPdKffcrAvarg/brQvYJ4hGy
9siDruiD3tj9gbi94YTd0cSdiaTt6eSt2dTNBdHGsnh9Tbq2kbaync56EQsE
8axpedakInuM1a1M7hBy+5DbjbwOAkVeI/JqkVeJvFLk5nMqlWXxJGTEIl2A
NC5RL/GExBUSR0ZsrUg1JYCn6rLX50P7l8P71gR9m1G9O7E9+/HdBPDkTkVq
ByNuB2su0luQ2YRs9hb1yK9FQRUKib5FUR6KMlHEhkopyI9GdgCrWAh5j5+j
/OnX8/qnHNoxrN3kPhTwqQo+VU+QP9tx84/dd9/qf3B+WP2TMe2LkwZXp01u
zlrcmbe9v+REr7hrrPnokDR2qPG2wHQn2mI33npPaLeX6rgvcTnIcD/I9pTl
+cgK/WSlAfKKIHl1iLwujGwqtkQp2mMUXbGKnnh5f4JsSHgwmrQ/nrI3lbo7
K95ZkGwvSbdW0zc3Mta3Mld3s5aV0ak8Z0aRO8Xksf7EKPKHkN+Pgm4UdKCA
5cMGFNSgoAL5JM+M3Axki5CZgPRIpIciLYDj+X/mkLdRpJrJkw22k0kZwlxg
91IwGxB3bQi6tqM692JIGk+e2KZIamVSWiBqhqQR6fXIrEN2DXKrkcfegmQH
UZCLggwUSlCUgoI45AQj3f0I+aNzw1+D+BkO6HjuNYdPFfOp6gsnGwnir3bd
/FPfnXeHHnw4ps6f1LkyY3Bj7sntBYt7S7YPV53U1921Nn30SKlKqOmewGI/
2vogzk4mdJClOMslbop0T0W2D5PnxxQGoCQI5aGoCketAA1RJC3RFofOBHQn
Mn1CZjBZMZIiHxPJJsUHM9L9+bS9pfTdlcxdrjhV5dcEg7wFRf6comCaKZgk
zlvhMPEiirpR2I7CZiL0hTWHPJiXhVwpspOQyXJ6ONICIfWBhIDBiG0J2CmG
20It7nTTL3ejWtk3WVyzPKGJxFspDRDVQVKLtGpimbMqkFOG3GLkkX0p5Kej
QIyCZBTEIzcMGV7ERVFRee6M8Y+fw1rlyFs5waEs5F7ziFI5Wcs/TdzOK3/s
vfHW4J33Rx98MqF+cUbn+rzhZ4tPPl+2fLBqq7rh9HjLXWfH23CPYG0uj7CS
R9sq4hwYoTOT4saIPZh0bybLD7kBKAhCcSjKwlEpQE0UqXIlWCegIxFdSehN
Rn8qMyRSjIrlE1KZEt9/WcvZ3cjd2c7b2svfIFqlcEVRuKQommeKZlA8hWLW
Vx5CcR+KWUeiHcXNKK5HcTWKOMbLy0CuCNkJyGR5OwRpvpCyapxIPSOykKcY
bSeQwx4zXs3zvs3L/s1rQU2boU1ctc4vGGEtkquRWgVxBaRlSC9FZjGyC5HD
meTcNOSJkJ+M/HiivTPZkR1l0TovQpw7P/U0HnrR6YejCt2j2gCVf+dTmUS9
nKjgn67nn227dI5ouRvvjNz9cOLBp9PqV+Z1bi4Z3l0xvb9mSW/aaWw7a++6
6+/7GJNt8xArJsKWibJnYp2YRFcm2YMRezFpvkxmAHKCkB+ConCUCVAZhZoY
1MeRWbQK0Z6EzhT0pKJPBO4xGicmM+QzWbL57IPFnIOVvIP1/L2tgp2dQpKb
IoQoXiNpkdIFlM6hlAsSS4dQ2kdc59I2lDYRx6KEs3QF2chPQ24ysmORGY70
AEg9OWNqz6luo914QoVpt/o5z/olH5L13wiq2w6t24sg+Wd5dI0itloZY/0U
KaUQlZDIK60AGfnI4sx1Thohcx5rR1liRCKL1ewusgSSWTh+rpQ7u/eXVff/
GycPrGeTzT9RxD9VxX+5kf9qx8XXiaG/8f743Y+nHl6c07i2qHN71fDeuumj
TSv1HTutPWe9Aw8juY+pItCSYVuG2zORjkyMC5PgziSxsunLSP2REYTsEOSH
o0iA0ihUxKA6DnWJaEzisqWECmf70zCUzoxmMBNZiqls+WyufCFPvlwgWy08
2Cja2y7e3SshLhGhSNm6onyFKV9C+RzKp1A+ijI2huxFWSfKWAe7CWUkJ43i
AqKN88XITUR2FDJDkO6LNDfOlbRkybGfQM4qTDlXz7pVL3hUr3hXrftVbQVW
7YaQvUK5oFIRVc7ElCGuFAklh+fOIMlDGhuRZR/a8pxU5AiRG4fcSKW6lydb
7YSoPT1t/eO/nA7/m6ODmM/L5Z8q4b9cw3+lmX+u68KfSJR+44Opu5/OPry8
qHFzRffuhtGDLVPVHavH+/Y6B84Gcg8ThY8FE2BN6BDmyAhcmBg3Jt6TEfow
qf6MJJCohuwwIsaFUSiJQXkcqhKVB2e4LPwPZvKZuQLFYqFipVi+XiLbKpXt
lpG9ClnFngo5raTyb0zlGiqXUDmPyilUjpFkSUUvKjpJCFnBhTWlJSjORWEa
8lMILtkRyGRv7AWpsyKV1FPsxxPUJ+zLZ5zK513LlzzKV73LNvzKdgLLyJ3C
ShURJUxkMWKKEFdIEs7CPCTnvKQ0o1kSZKUgW4gc1rpGIjuY6H+x3Y5A77lz
4j/8y5H/DYc8G7zm88+U8V+p459r5b/ew3+TxOo3Ppq5e2Hh4bVljc/Wdb/Y
MqJ3zTT2rbQP7PVlzsYKdzPGx4oJsOOQd2YEbky0JxPnzST6MSmByglwXP6j
mmTUpZI7NkvQmoaOdHRloDeLVJAP5WAkF+P54HZOfnVQJZNV7curd8jRkOp1
khmvnkf1NKrHUDWEqj5UdaKyBZV1HOqFKM4inkc+y42szxeKTD+kuSpSrWVC
w8NTReM2xVP2xXNOxYsuxSvuReteRVu+RewPB8FF8rBCJqIAkfmIzkVsDuKz
SJI/OQOpGZCkK/v/AJkpyEpEViyyWd0TrLQFezEky/Mc+iQ79vR5Qy+gwrNn
Ncg7d4LrV1z+QEIMwukK/qsN/Nfb+W/28d8evXR+mm1z99LSwxtrGnc2dR7s
GqntmWkeWOnK7AwVzk8YD0vGx5YJcGCCnQkJBB6Mcvfg16JQqB795cehKAGl
QlQkk62dGhHqJWQuLeloy0RnFrqz0ZeDgTwM52O0ABOFmC7GXAkWy7BcjrUK
bFZhp5pbl8ofCFlq11G7jNp51E6jdhw1Q6jpQ00nqrhkSnkpSvNQnI5C1g9n
NYQA2awksFaKdc+M9+Mez4epjVnmT1rnz9rlLzjmL7vkrbnnbXoRs7vvnycL
ylOE5jLhORBkISqTbETGp0OYhmQpRBJIJEqN9D3iYWWxhpkVBVa7uRwkmK4H
qj33BJxnM/Iq/wld/qPcMheX/S1LJ05UCvknq/ivNPFf7+S/PcB/d/zShySt
cPfq6sNbG+r3tnUe7RtpHJjpyKwM5HYmjLM542HD+Ngf0ubbUb6HtFHqln+W
CJAeRdgrNx4FQhQnoywVFSJUS1CbRibXlImWLLTnoDMXPXnoy8dgIUaKMFaM
yRLMlGGuHIsVWKnCejW2akiX/TrFQZ1MXrevqN/l7kTufAr1C6ifQf046oZQ
14vadrLCqiqUF6E0G8USFApJ6JRD9AtrLw4STffiiO0eMc2esMiets6et81e
cshadc7acCOJgD2frAP/THlQJhOSgbB0CNLIdn2sBPESCMVIEUHEbRakJyOD
K93PFCCDoxixGJYboZpfkSAyyeNZ/v/xFe/q686QcPT5+RF9ivgnavhnW/h/
7Oa/PcQ/P3nxo3n2+p3r6w9ub6nf39VRPTDUlJnqya2MGHtTRlkp6++CIHc8
pcq/xgYhPgTCMKQIII6CNAaZ8chJRH4SiXJKRCiXoFKKmnTUZXKKLQetuejI
R1cBegvRX4ShYoyWYrwMU+WYqcB8FZaqsVqDjVps13FEapAfNBzISRXCPhGr
xnUlb/8bGsZQP4h6si2AmnpUVaCiAKUZKE4l8VUuq+V8WMMiE1rsxeqsRdDD
xuljT9KnzNNmrdIWbNNWHNLWnUniYMdDuu8tlflJmUApQiQIk0AgRrQIsalI
SIUw5XAbUypEejzSozku+Q7nLriz4roVQQLy554NRWSKPL6SUEZJnZ+9iBo/
5VN+HDWK+bw6/pk2/rle/psj/PenL3xCNiHu3Nx8cHdH/eG+trrcUFthaqhQ
Zr2dbb4iHVSID4EqMhAxIYgPgzACyVEQxUAah/QEZCUhl405RSgSo1RKUopV
majJIl0ac9Gcj7YCdBaiuxh9JRgoxXAZRiswUYnpKsxWY6EWy3VYq8dmA+my
26jYb5TLmmRMswzNe4QmzetoXkHzgpIy/wcN3OZITS2qSlGRS+5ZmIDccGRx
ZifFei9WfyeSnCgZNRJNPBHNmInmLUVLNiJlFfO2a+quR+qBd6rcL5WUMoak
IjwFghREJyMuCQlCJJFDDxDHk/WlRSM9AunBHIncWXncjjb6RvQ4/iQtzsr8
mE+5c/Qo4VMN/NMd/Nf6+W+M8d+bvfjp8rWrJHXx4N6eGi3TfsxRgosRXiYH
nVzg644Ab1KqTigRjOgwxEUgMRLJMWQHXJKAdCExkqxTmMeGqFIUpxFmLc9C
VTbpUp+HxgI0F6KtGJ0l6C5FXxkGKjBcibEqTFRjuhazdVisx0oD1htJl51m
Zq+ZkbUoFMrStVaOGC3raFlGywJaptE8qoykUN+I2ipUFaEiCyUpJD7IDmDV
C8u/rI3eiSSllyN6SeOGSVMmSXNmwkVLobJCf8tRuOMi3PcQyryTFP5JCEpG
aBLChYgUIjoRcQlI5BKyqbEQs+wWhTQ2ng+ClKsulzjuxJvO+6kRe/NtlRdZ
lG99PSV+xJFByqX1GvmnuvivDPL/NME/P3fxwur16yTdfP++jPObXrO0gJ0N
nB3g5gxPN/h4wt8HwQEICyb3iI5AbCQSopEUi5QEiIVIYxVtKrLEyJEgLw0F
6SjOJKq9PIfsbrBd6grRWITmErSVoqMM3RXoq8RAFYarMVaLiTpM1WO2AYuN
WGnCejNHi1bst0LeBqaNQZsMbRwt2tbRtoy2BbROo2X0UG/VlqMqH+VpKGT9
1BBksGGgw378kx0BMSJD2vFjenGTBnEzxnHzpnFLFnGr1qTgfdsxbtc1/sAj
Xu6TwPgnIDgRoQmIiEdkHGLiSO1dIlfwlRoJsQDSMEiDSH6cy6rsJ1kuBmmS
51YQbXF0CvzbX4+98qk1Yu61iX+ih392mP/GJP+DhUsX15U8/xb7m5YO9A1h
YgpLK9jZwckJrq7w8IC3N/z9EBRIiuPZZlGRpEIzPhbCeCQnQpQMaSrSxchg
3fU05KQjLxMFWSjOQWkuyvNJl5oi1JWgsRTNZWgrR0cluqvQV42BWgzXYbQe
4w2YasRsExaasdJCumy2Yacd++2Qd4DpADpk6CBGHe1rpGStfQHtU2gdIQtt
aj3aMavMRkky8kneGVInmdB8W6Az5UcPakSNaEVN6EZNG0TNGUctmkatWJDi
my276B2n6H3XGLlnjMI3lgmIQ3AswmIREYOoaMREIZ4c9EByBFLDIQ4FG1WJ
D/co2OtLYZyl4J5uyD3GBtxT3wjg331KCzIz7olOLx3lV5v4vD6Oz9+//hkJ
ctk/NU1GSw/6xjAxh4UNbB3g6AwXd7h7wcsXfgEIDEZIGKeIokiFbFw8EhOR
lITUFEjEkEqQnoaMdGRlIicLeTkkN1mcj9IC4uMQ/EtRV4bGcjRXoq0KHdXo
rkFfHQbqMdSAkUaMNWGqGbMtWGjFchuHfwd2OrDXCVkXmC6gS44uTgQ619C5
jM55dJCNRlKw09iIugqOAr9DEWuoucg4xWonUn8zlO6nw4c1wsc0wyd1wmb0
wxaMwpdNw9mmGzYR2/aCPSeBzC1S7hVJDrUERiMkCmGREEQiSoBYUpSLxDAk
hyA1GOIvsWe13NPncBIkjz877jsvlAQu6rvGp6Kexgj8V8f4b8/wP1m5fJXo
nzsPSKJJTZvRMoD+E5hYwsIWtk5wcIWzB9y84ekHn0D4hyAonEyTyEIcYhOQ
kMR5FSLiqoulpFohPROZWcjOQW4u8vNQWIDiQpQWky6VZaguR10lGqvQXI22
GnTUobsevQ3ob8RgE4abMdaCyVbMtmGhg3RZ68RmF7a7sNcNWTeYHpBS/R6O
HN3r6F5G1zw6J8hSm9vQWEtqSKq5pEVBBLJ8lEZhM1T5XKFfT2gGTesEz+kH
LxmTLQly+tImdNch7MA5TOYeLveKUPhFIEiAkAhygkMQflgCHx8MYRCSAyF6
WndBkl0Kkfmh7iGUOP4ssxdT4m8OW6vc4OxyM5/Xzz83zn9njv/pGtvq+p2D
24/k9x+TjQItI+ibwcQaFvawcYG9O5y84OoLjwB4B8MvDIHsRKM5yUhAjJCU
yyaKkCxBipQr3MmANIvsqmfmIjsfuQXIL0RhMYpLUFrGUaMC1VWoqyZ1Ts11
aK1HRwO6GtHThL5mDLRguBVjbZhsx2wnFro4anRjowfbPdjtxUEvFH1AnwJ9
nDPbu46eFXRzxbRtPaSUrYEdvZD1mcmV3ECkObOWYTOUZEX67/sOP/LlsuJ/
t2kZtGMbtO8QTA5tuofIvUMZ/1Byvis0FOEhiOS8odhAJARA6E+qIEW+RxRw
UIgsDj2X48/wejH6PzvUV5y9+FwZOpBXlgh/nOS/R3YvL1/fuX734A4tv6/J
EcEE+hYwsYWFI2zcYO8JRx+4+ME9EF4h8A1HQCSCYxAWz5nnZM7RFkMoRXI6
UjIgyoIkG9JcUuCQWUCyzbnFyC9BYRmKy0mX8ipUVqO6BnV1aKhHUwNaG9He
hM5mUp/f14qBNgy1Y6wDk52Y6SZdlnqw2ouNPmz1YbcfB/1QDAADCgxwdOjf
RN8qWXLXCNo60VyPhjJSVlXGef4Z7vIky61wsv3Te9d98AuP0UdeE+reM1o+
87rkWOKqia8yav3ZgWugzCNQ4RPE+AcjOAihQYggR+YR7Y84PyT6IdmXowVX
EsPlGlWeZgKfo8RP8OXzsgn/c1biMkcBUvrPP8FSgBRI8C9sXL6xe+Pzgzuq
8vvaJMehZQp9K5jYw8IF1h6w84ajH1wC4RYMzzD4RMA/CkGxxIMgSikVMWLE
S5GYDmEGkrKQkg1RLslmSguQXsil/EvI1nB+OQorUVzFEaEGlbWorkdtAxoa
0dRESmPbWkg1eHcbetvR34GhTox2YaIb0z0cEfqw2o/1fmwNYHcAB4OQDwFD
DAZlZOkD2+hf4YgwhLZ2UtRZX0Six6Kow1ro3SiDZT+655ZT/x3n4S9cyYNJ
NDzmtMhRiRVDz3UTry1z7x0r7z07H2WeXOHrzwQEINgfoSTIQpQvYrnDIUk+
pCz4sC7JkRFZ7QuN/kMqHM8dkkZcDvERqazgNbKkIHT4YJl/cfPyjb0b9w7u
qMnv6zKqxmTd+jYwcYS5G6w9YecLxwC4BMMtFJ4R8I6EXwwC4hEsJEEOkQcp
4tK5yuYsCLORnIuUPIgKICmEtBjpJcgqQ0452avPr0JhNelSWofyelQ0oLIB
NaxxZbVIC5pb0dqG9nZ0daCnE/1dGOzGSA/Ge0mX2X4sDmBlEOuD2BzCzhD2
h6EYBjl8OCwnEAyRXUP0TaFrAG2taK4iEWMJG8YFKXeMN4PVuq7Z9t2yG7zr
MHrfaZJ2ntEgRzmW9NxWDd02nrhvm7vvWHvs2XvuO3kduHkf5ciDuYO8kT6I
8Ua8N4TeSPH6khRiG3mKico3psWRReda/x8+Fc/nNShdJEKLS1uXb+7f+EJ2
R11xX49RNeFoYQcTZ5h7wNobdn5wDIJLKNwi4BkJ7xj4xSEgEcFJCOXysFFp
XIl/FuKzkZDLJZsLkFIIUTEkJUgrQ0Y5V6VSRTZ682tQWAdOP79c04K6VjS0
obkdrR1o70RXN3p60N+LoT6M9XMkGMTCEJaHsTaMzRHsjuBgFIpRYJTBKEeC
Ye5AXd8EunrR1oTGEpSzYXw4MjyQYn4gIEah55rVwC3r4bu24/ft2K9zGo6L
2k4rek7rRs6bT5y3LVx2bFx37d32nd0P3N3lXh6Mn5eywpoc/Y32QpwXEr2Q
7AmRB1fBpNzufjIfqv41FFAmC4/+XvTE5KPax5cO5YTbZf0dKUXikWw0/9wU
oc3l7cu39m/cl93RkN/XU6iaMprWZFgTV5h7wcoXtgFwCIFLONwi4RkN7zj4
JSIgCcGpCBUjgkv5kcRnNpeRzuP2AgqRXKwMXlS+W8DlKooaUdyEkiaUNoME
lCr/z/ggpocwP4ylEayNYmsMe2OQjUMxDmYcGFMoSwcwtIi+MXR1oY11j3JQ
HItsP1LAGEd2N7sumfZdMxu8ZTH6Odm1mFG1mX9st6Rtt6pvv2Fkv2nqsGXp
uGPjtOvgvO/iIvdwZXzcyVMUOAn4ATnVGu+BJA+kuisr9Lhdb9OtWO3nni2o
BPs4yt/g6cjsEFx+6X9y1qLqUCbOs7jvXP5s/8YDDnd9Bc3ibkMGMHaHuQ+s
/GEbBIdQOAvgFg3POHgnwC8JASkIFiNUSs59EdcpG1E54HaI/yGpFCnlSK2A
uBLSalKfmFGLrDrkNCCXI0FeE/KbUNDMFVq1oKSVbMNVtKO6A7WdaOhCUw9a
e9Heh+5+5Zj/tjCGlTFsjmNvArIJKCbATAATR6QZXkDfEDpZnVROav7zw5Dm
okgkWqODb9hz2WjgusnwZ2Tfc+qB+Zyq5eJjqxUd6zV963Vjm00z2y1LO/KY
HydHuZszediK8ikhYR4QuB9WsSe6k/NqItenlJEn6/33KXOYr+P+R4Z/4KhS
/CVVruxcvr1/4+HBnceyLwzktJnisS2j50L6m/vCMgA2IbAPh3MU3GLhkQBv
IXxTECBGsBShGco9h99H5SO6ADGFiCtGfAkSyyAsR3IlUqogqiYVE9I6UpiS
0YDMRmRxCaScZuQ2k1Kk/FYUtqKojVQPlLajvBNVXajpRn0PmnrR2oeOAdK+
fxjDIxgbVd6RtzOJ/SnIp8BMAZOEPBjbxPAs+vrR2YiGfJQlIMdXlmS1HqhF
xIav13dZf/C6Aft54nPjmYdP5tXMljTNV3TM1wwsNkysts2tybOuHOzkLg6M
hyN8uQfhhLohwg1RbojlSJXkSg6wEdrYcYU5+i+wFn8JdUhOhDwRWuWXxJaf
JOX9/Pc5QbnDkUSTI4m54rEdo+tKOpn5wzIINqGwF8ApBq7x8BDCOwW+IgRI
cbifFp6DiFwIuHRSZCGiihBdjJgScnwprgzxFUisRFI1OTuQWgtxHSQNXHkv
S5ZvpTexc2G7kULIFmS3IrcNeW0oaEdhB4o7UdKJ8m5U9qCmF/V9aOpH6yC5
Tfcw+kcwNIqxMUyNY2FSuXiVP8hnwMwA01y2YXwDQ1Po7UFbNWrTUSxgzflm
KCFJx8fa3Xyd/sskSzH2mf7UPYPZh0aLasYrWk/W9Ew3jMy3TS13La0O7Gzk
TraMmz28uac7hbgi3BWRLohxQTzxAMiRW5Y8EpY85rIUgxdZ829Kn+NPTecy
I3/zf0v7zug4sutMLKgZTbAVx5LstSzJq+BzLCtaWbJGVlilJmeYh5nDBkEC
BIlA5JxzbGSgkXPOGY0cGjnnDCLn3KG+c7buqyaH6gH3xy5PoYmuet2o+t6t
W/e99333EvnsO12inxGblu+nczcVl8SKa4bK26ZKsbXqobP6sRdnxmbEbcJh
HwVnKdwS4JkCn3Qh48fnQwsRXoLIUkSVI7qCWsZUI7YG0lrEyUAqs3okNiCx
EclNSGlBWisy2pDJOzTdLL6L/jm7Azls2i+vC/ndKOhGYQ+jUvahtA/l/agY
QNUA0XFkQ2gYQfMo2sYgZ93UO4nBKYxMY2IGs3NYmsfGIvaeCffU11gXbZGE
frifZiAb0/k76CTeYs1bv/t3Bv1/NBwW0a00dclw7prR4q0nK/dMNh6YbRuZ
75pYHJhbHVlbKxxsVS52nIcDfCkkQKgbIt0R404JUxLdkOKmySwjDMYVGab/
H/3zutbn2JwJU0x9t1X0I1oaF713eO6G4uJ95QePlLfMVGIb1j/enBmbJ7eJ
hH0MnOLhmiRwft7xy0FgHoILISlGeCkiyhFZgahKRLHJkJhaxMogrUNcPeIb
kNCIxCYkNiOpBclt0E3lO+j1NDnSO5DBb53IZHODutnd0PnH3B7k9aKgD4V9
KO4nAnDZIMoHUTmE6mHi7NSPopG5ufYJdE6idwoD0xidxfQcJdtZfYadJRwu
Q7Wiuce/yfpqHRN8h3aQ/rUqGrmumwEUIfT+7sHgnyjH8cR5/ZnLDxeuGy7d
MVrTe7JlYLLzxGzfzPzI0kJhZ6VysoGbLbztCdQQZ0S4ItqVMgUluCLZBWku
yKTUQKosm5PM00Yon3jpISP8e65le0Pj2dgd82nRd2pFPxgX/ZpW+M7eUF7Q
V159rLpprvrQTv3AVW3kw5kGcxZsttZeqrm6L3ikwzsLvrkIKEBQESSlCCtH
eAUiKhFZjcgaRLEZkZh6xDZA2oi4JsQ3I74FCa1IbENSO84k8v3xtSQ5kjto
S+lEKrtp0rqQ3o2MHmT1gtiqfcjrR8EAigaIkVwyiNIhYsVXj6KW9UfzBMnM
OqfRM4OhWYzPY2YRz55hcxkHK1Cuas74G6w/VjExhu461Keh2F8RS0+H7ndp
rWnoz+Kxs+KpC/fnrj54dtNg5cNHG/qPd4yM90xMDs3NTqzNlQ6WnIsV50nT
IwhyQJgT5QyLdUG8M5KckerMsoU5K7Ntj7Oe7qYZvqI3/kFrL3vPeDvf7xf9
aon1gOq8vuqKseqGpfqug1rfnXvkx5lKYBEJ6xi6YMckuKTCPQNe2fDJg38h
gkoQUobQCoRVIbwaETWIkCGyDlH1rA+aEMtvzZC2IK4VcW08IvE89mfi5Yhj
m84Zevm7+A4kdNLGfyixC0ndSOlGag/Se5HRh6x+ZPdDN2eAj1ByB5A3gMIh
lAyjfITay8bROInWKXTMoG8Ow/OYWMTcElaXsbMKxRq1wSo0QdpIHy35Vkby
T+ktn/ssrvvSzCW9hWv6y7cfrokNtgwe7T55fGBmfGxpqrQzUztR/MZ5W3MB
dpA4INIJMU6I4+NtJ8owxoDnGxxlme9nPj4dd+08v4zN+XcaX/TzBdFfafXu
/H31ZRP1dWv1HSfuvidn6A+zMOGZ8AXHZDinwS0TnjnwzodfMQLLEFwBSRVC
qxFWg3AZwusQUY/IBkSygXd0M2JaENOK2DZI26ErleNMrByvxfBP8LdiOhHL
gJZ2Ia4L8d1I7EFSL1L4rY/3VfxPWh90Pp/Boz6A3CEUsJF5xRiqxlHLwG6f
Qe88hhcxtYTFFWysUgPVBrCmfsFXeAN1KSjyPYkykv+czLz/t+KhP4rH/ipk
4n9nQ//hziPDfROjI/PHCmtjlQO5e87TgvOz4oJtuXB7RDtC6qjJ5JZBGclU
uQ6H2RZ7WU9Ox/mLGs/C7Prrou/UiP5zRvQnmj17/z53yYS7ZsPddub0vGAY
SKdrGQubBNizmSaXTLjlwDMP3oXwLUFAOYKrEFINSQ0kMoTWIaweYQ0Ib0QE
wzeyFVH81obodsTIocvjqhvdgU9E8T+RPLY02Ob/j+K3LsR0I7ab74MenInr
gW58D3S+mshj3Y90Ng+bM4S8YZD6Y4QkTvVTJF/tmcfoM8yuYJXZr2IT2OCY
H5kjKy6P4DLsV5yp3EXPr8UDv6PiERNnqa7Cwgfi5VtC3vvPHpoZnlgaKe0o
Ca/a3UztY84FWnESGy7KnnI2vgQtl0+P5L0s41f4Du16bcLYmWz4B4OiP6yL
rhDh7qIJ94Edd8sVej50zmZRsJTCNhEOqXBiU0juefAqhE8J/MoQUImgagTX
ILgWITKE1EPSgNBGhDYhrBnhLdQ+og2R7Yik2JNHVjeS/4noxGvhPMJnwjqf
P1neYj42oguRbIvpgbQX8b10OKkfqQMEc9YgCkZQPg4ZQ7d3AaO85TJoj7fA
bbIIdIployz23wt+1PZjcecvxL3vUvGJ0T+Lp94Tz10WP7suXr1L9Rt2Ht0X
5lU/pXI1puzM/uacxAqRdhpUhTSYlDnU+TjXejebQk3tOg0Crv+ktZdxMSjG
Fn2vXfTrZdHFQzJfE+6yHW65Q8+P4RoNy3jYJsMhHc7ZtMejEF4l8C2DfyUC
eVBlCK7jMQvmffDbIQ0IaURIEyTNkLQgtBVhbfSZcDkiOsDDqaOrhSeruxXM
v/1kUCeCOmg3/0tgB/zl8CPn7ct/wRm/NvizcbTOJ+nlKzzscb1I6EP6IPJG
UDqBmik0zkA+h4kVRs/YBrfFcB4n4pI6xXrGXNz+E3HXL8V9vxEP/0E8/lcq
DTJ/haplrN2jIhl7j8VHZvdPLB9o1PdqTxO1/1MuxBKRNojThlqRb8fanY70
/zwN6S9R/PGzedH7e6J7ND19iYeZjW4fhcI0BpYJsE2BQyZccuHGZhi8y+BX
iYBqBPEY1+MFuLohzfy38/hKWiGhp5yEgAqVv4ypzus8qAKS/BbA49mBM348
vp/ylcO3gzYf9gHPNri3wrUZLk1wboJTIxwb4NQA50boujTy3+vWBI9meLUI
lFCdL/P2njyATN6PjKJ0HDUT9C18ALi7BfU2g3yURBnLbo9bf0i1fnp+JR74
byo5Qy7jIrmMldtUnWPHUHxoSr5aaWegcjHSoM6FWCDCGlJ7TYZXTVJcZ2Wh
w34emxM9HfF/1vhjhjSbWfjRuOgvW6I7hPQFOzpHvUAYhsM0FpZJsE2DQxZc
8uBeDC82PPWrRkAtg5lhHMIMWAD4Bb6hzD4FfMleAzs1yPLA8rASoLreFGZ4
yeHZTpuOrgf/8kW3Nri2wpn5GYcm2DfCtgE29bCug5UMljJY1MK8BubV9GpR
A6ta2LC4ku8LvhPcGuHRpBnHfjOxn1k9e0yOrGJlAwoB9r4a5LoMPxS3/VDc
+TMqRjT0e6rxM/W+xszX71E5lANjwlxh90Dl/Ejt8YTzo0chIqwgtdNkg30O
ubrY6SDf8pWI/4vWXjY39E+i78pFv1sT3VSIjOgEb3jiHg97BEzjYJkC2ww4
5MClAO4l8CqHL1tnD6xHcOPfAM7jLWFoM75MKD9u+UJoD0K6EdxNHwjogn8X
/Drh0wnvDnh1wFMOdznc2uHaDpc2OLfBsRX2zbBtgnUDLOrxtE4YWX3iSTWM
qmBUiUeV0H1UgTOG5dA14C3gDcMyPGKW8KQcJuUwq4BlFRzrhLjoH3nnzv/X
tYy5DRzsMLzrk4+D7jd/Tyz/sbjnl+KB34pH/0R1h+Yuke9euyve0tcUnlHY
6iudDVQeRpyvMRds9jxiSXIgtIV0nQXOKHE+KrR+Jdpf0dr7qeejUNEvFkWX
j0SGwvV97sNAGETAJB6WqbDNhEMuXArhXgqvSvjWIICtHIa8hLNg1boanHV5
mHVeC+2FpBchvQjqQWCPZlzxKd8u+HTBqxOenfDogJscLnI4t8OhFbbNsGqE
eQNM62Bcq6l2dzEVF1JwOVXz+ddv5eBOLu7lwaAIpuWwkwnIfrVyBpOb2Ntl
mJYQZarlB+LOn4r7fk1+euKv4pnz4sWr5DQ29VjFnqdiha2e0umB2sOQ832C
YFOEWyCWjVeEdLJ5zpQVscT5pNj2lXh+VeMvhBlN0Q+GROf2RA+ez1vdDcTD
SJgkwDIdttlwyIdzEdzK4FUF31oENCCIUWdf2Cn/e2gXyFAJQV0eQJ03QvsQ
2g9JH4L7ENSLgF7498K3R+in1zy64NYJ1w44y+HYLnSlzhcKrZZyLZYyny6n
mi4nGi9LjVaiDFfCHq4E69OY1evDVdc7qw63Vm1urFpcXzX7YO3JlTXDS2v3
L6zdPb928721q2fXBN//XoTiQiL3QRruZeFJPqyLNdbfMIfdPQJanWLF0P9i
/7vi0f8tnjornr8sXr4p3hCzSklmVCtI5aSv9jDgfI0QbIJwc8RaI4nSylA6
/RcQl9i/2if/q9ZettLO5kV+vy66S475shtB9yASxjzUGbDNgUMBnIvhVg7P
avjKENCI4FYCWcjzwSPM40tbL3h8ebT5kVooH9i+GTKA4H4E9sO/D7698O6B
ZzfcGcjCc+srNS6rlY6rpQ6rRXaUpCDbai3dYj356Xq8Kem7I4w2JIakiPXR
33TX23S+t2l/d9P69qb5zU2TG1tG17YeXt0SX966c3Hr+nmK8s+f2zon2hT9
dVP05w3RHzc0eRje8zu6EI27cRpf/doyi0HmTfWafiSW/0Qs7H1n9gLVIeN/
2zYQ75uIj615qPXU7g/ga4igJwg3Q6wlkmyRQVVShEy+XKmLoszxlUj/r9OQ
/ozoRxOia8TOueSC22wYYpwIy0zY58OxCC5lcK+EVw186uHfhOA2AeNPaNBl
ABO+Om/xAIcO0iYZRPAAgRzQD78++PA49wqW9XX3zhPX9q3uQOLrtvhsNHht
yNw3qlw3yp03ip02Cxw2c+w2M2y2Uq22Ey22pU+3o0x3wowpT4Gf4Y7Xw11X
/V1HvV078a7Vh7tP7+wZ39ozvLmnf33v3gd7t67QkPXSxd3z53ffe3/37Lkd
AWvRn7dFf9wS/WFDs6J0PVUT//AwyH4sbv2puOtnYjLvP2qqUX2Wj6cpzjOm
0l9KRz3O/T58DRD0GOGmiLVAkg0yHAQlGlfsypW7KSqcXzFC+brGezCcP08W
/Re6lkuOuBkA/Sg24suCQ+FHIPsykIOEaLgb4T0I79V4m7fDBxA+yLYhhA8j
gt9GEDYMyTBChhA0qGn3Xf++E79u+jtDEZv9oVs9IWSIrQHbjb47dd7b1Z7b
Fe47pa6UmyDPaTfLYTfNbi/ZhpTdMRb7EU9pJTvA+MDH6MDj0aGLwaHDg0Ob
+4cWeodm944e3z00uH14/9bh3RuHN69Ry0tXDi9cpvHAuQsHZ9/fF53bF53d
E/1lV/SnbXYDayz+zVuMRsRDUfc9ceuPKdgbZjUP+ZBDaPHp3cdUbU1hL+bc
9eD7EMFGiDClSj3JNsh05PJcuUJXdam7utLjpMrtFXh/U2vvc+2YzufOW+OG
H/QY5Fa8+yiGa8UpeEf2IaofUQOIGkT0kPC8ix7Fmegx6Pw0cgzhbDE6dJiT
DB6H9NOK81T89rh0Zzh6ZyBytzd8j9/TFrzfHLhf779f67tf6b1f5rlf7H6Q
73aQ7XKY4XSY4nCUYHcktTmOsjoOsyChvJ/piZfxiftjhbORwt7wxPrhifmD
E5P7J0bik4cfnojvnNy5Tc0+uEGvFz84OX/1+P3Lx+cuHYkuHInePxSdo34Q
/XVX9Bfe0Dd4yIW4Qe95zjE+4uBD6rkr4uU74s0HQt29v1c6iKl+WYAhFeeK
fkole9LsaMxd5KEuoXUJVbXXSY3HK3D+ltbe56psnXfOmeGaB+5FwojxlRxL
4FYJb5k2yDEDkA5BOgzpCKSjkI5BOi58w7elk4ibBP/Kv4keR9SoInqErnAx
bXcuZW86aX88YX8k7mAw9rAv6rArgkieLZKjxuAjWeBRtT/lIijxPi7wPMn1
OMl0U6S6KJKclHEOymg7VYSNim8caKH2NVd7mqlcTVROxkq7x0qrR8qnhgrj
h8pH+ip9PdW9eyohkvngjvLKLeWlm4qL1xXnr528d/Xk7JUT0eUT0UXSLYvO
H9AQTbTDOxhhDpjHo/mH4p53qbzkzCXxEj98eSjeMxEfWZGlq70NqBZaxEs+
JM8Vpd7qMlqoU9USMed0tP9N40WYSvgd+tP3VbyrvhOKR0kwZ4Nt92pyzwEt
f4Nw3DASRpEwhoRxJEwgYRK6CVPQTdSsSH4jZZwIRCvZB4uZh3Pph9OpRxPJ
x6OJJ0PxJ/1SRXcMPRJaIxRNYco6ibImWFkZqCz1Vxb5qvK8VVle6nQPLtmN
i3fhYp24SAd6TIfYcgHWnI8V52HBuTxVO5qpbU3Ulk9UZkbqx4844T7/zD19
anpDT3Xtnurqh8ord5SXbisv3FK8f/Pk3A3F2WvUR6KrCtHVY9GlQ97E2afe
Ev1pRTDoET7Qu0wlGNd5F20qPrTVP3Ez0ETKMcyOU1khn0J3lPuqK31V1b6n
ccYEZLVrvjOG5WfJm1njWhAMEwlex1I27uMffWxqIeo5toljSJ5A8iSSp3jP
mzwN3ZQZ6PxbyiybtZ9VZ8wcZ03v5kxRtLBecLSSd/ws52Q+SzGToZhMU46l
qIaT1f0J6p44wqM9hmuO4hoiuNowrkqC8mAUByLfn8vx5TK8uRQvLtGDk7px
US7UWOLIBTlw/nacty1JwZwtOQcLQXP0RaPHMDDCfcZru2OgvvlQfV1ffe2+
6qpYeeWe4uKHivc/VLx3l2F8mxPdUotuKEQ3qKNF12i2THRv98Vc6aeX7ok3
jcT7luITp/vHnkbKIGN1FBUIZMW9eOt1oQo0Vf7qmgCVzP9UZp6A8r9r7WW6
UZqgERmqLvngfhyeMpS96jRPsE9G9iJ28COM06aRxkOrmzYL3fQ56HyLb5O1
gJwFdf78UeHcTvEsJR3eLj3eKD5ZLTx5lq+Yz1XOZCsnM1VjGerhNG4gBb3M
H8nj0SJFYwzqoiivQEUYSiQoDEZuIJfpz6X5ckneXJwn6X0jmfwxxIULdOb8
HDkvB439/oe9FawtYW4OYzMYmcLAhL733hPuzmPu1iPupqH6uoHq2gPllQeK
iw+U5/VV79+nLxLpcSIxv1FjkZjwf++RUngirj6mpa8Ny0cH9vdVHmKVv6Ei
9KmaD+1SaFjCiiWxUl+1Qer6YFVDkJKlb38F1t9+FdZnHXA3CqZ8tMGAJmcs
+Nv4ESSNIWWSUM6cQ+Y8suaRvYDcRTrX/GcoeqYufXZYsbhdvUD01b2q4+2K
k40y5WqJYqlIsVCgnM1TTeWqx7O5kUwMpqMvDd0p9Nm2BDTFoT4WNTGojKJ8
b0VhlL8iOxjpgVyKP5fgy0l9uGhvjkXe3/V0hpsjnOxhZwsrGzy1grEljCxg
wLhoYjN8aMrdMVbffqK6+Vh53Uh5xUh50Uh1gdm6yJDjx7b0ixFEjzmRCVFr
L7mcCBAroojhsudnrgx5gogniDHlEq3JhnNZLREq9xWAuhCuKVTVHKpskbwa
3//AR9UmBVv9wB+P+dFfCTzZoDmih0xXs+aZMYOsOUKSh7FwCUXL1KJ0BeUr
qurlQ9nydsPSmnxx4rBetSdTbVcrNypVq+Uk2F8oVs0WqqcKuPE8jORgMAt9
mehJZ+utKWhJQkMCZHGoikV5NIqjUBBBecwyJAIn6PvhPpB4I9CTlFbe7vBw
hasLHJ1g6wBLezy1g4ktHtuwMZUV9Cxxz4L78Kn6jpnqlpnqupnqipn6kil3
3pQBa0rNzpnjfXOcs4HIkd4apmqiOZRQuRt1giVFD1mOyHWlGoqsghoBWxeC
xjCuNULVFvF/8Q/f1dr7XNGs84Z+LGyK4cGmuKL7ED+M1AlkzQpH3yxaAmG5
igo2Z167ztWvnTSt7retbuh8ilqc6c/5m/n4L6eFIVmChBBIgxHNRjqh/lS0
J8AHvt7w8oS7B5zd4eAKGxdYOcPcCaaOeMJIXw/toG/L6dmo71mr7lqpblmr
r1mrr1pxF600nuF1Hp6L9rhkjwsuOO+B60Ga0XT/OpuzkAv5t8sC+LC0Mhg1
YagKhkyCRpa7qC2ak8eoOkiWcTp76nunoKTztuh3lAjQPAfuDCTpAJJHkTmF
vHn+viV4NArhhk20bJLDEc71XWU7Tlg8tt+MnUZs1pM0e7kGi1WYq8B0GWno
R4sxxISoPXnoYki2ZqIpgxaLa1NQmYSyBBTFURKg7GhkRCE1gvSt8WGIlbA4
JBiSQAQFkMTJ2xcePnD1hpMnHDxh6wErd5i7wcyVWho5w8CZe+Co1ndQiR1o
lfeWA3fNgbvqiMvM3i4647IbPvDAVW9cCcDdMAHZz6SO4tmxQNRhiSUbYtGS
gLYUtMZTZh45E3l1J3Ld/GM2flUeoV1rV6ACfF9zTzN+xsX3mNm7VmvgTJ9A
zgyKFvl7FlVrqN1A/SaDYptN9G0r+jZ3hzZW1F1QduKETZXvt2KnBZtNWGsg
HfViLeaqMV2JiXKMlmGohATyvYXoymffk4OmbNRnQpaBqjSUp6A4iZJa5cRR
HuC0GKREIzEKcRGIYZSDMAlCQhAQDN9AeAXA3Q8ufnDyhYMv7Hxg7Q0LL5gx
5tVjDzxy5wxc1fquarEbd9eNu+2Gm+506DprcN0HN/xxMwi3wqAXA5N0AdW/
r1vBqoDqIssg2ZePwSL056I3A33p6CeaP9efyizpdER/eJoF37vsp7kbYwfI
RAsWULaMmnUCtHkLbTt0tHsX/bvK4e298a3V6Y05dS+U3TjuwiGbPNtpw2YL
1pqx3IjFeszJMF1DoujRSgyXY6CMFO1dRZAzq23OQ0MOZNlM4pxOyUUKUyjb
ZnYiMuKRGockKeJjII1mbjsCknAEhcJfQvIXzyC4B8E1EM6BcAiAXQBs/GHp
Ty1NfPHEhzPy5gy8OX1vTs8HYrayeNcPd1iDO8G4G4p74dCTwiAZ/L3pUkn7
i+YwtIu9E4bsOuWCwUw9VTucKKOqfSMkr+ZGsg+GMjTqZ21U//M0VC/cZSmR
YvuRMYHSZ6heBX+v89bZsUv1APhDw/vc2N7h1M7W3PaSehCqfij6cNyDAzZJ
vt2BjXastWK5BYtNpGOersOEDGM1GK7CQCV6y9FVho4SBmkhGvIhyyNdf0U2
SjNRlI78NFJ7ZyUjPQkpiUiMRxwb7EfGICwaIZEIjCAli3cYPEPhHgpXCZwl
RFm2C4FNMLU0D4JpIIwDOKNAPAqEIWM7PQiGfgjuS6AXSm/1o/FAikfJFMJY
FTJ3J8znTB3iUPGc7brSjWetVP1wugqTpZrZtrmeZA1i2p5VwPVHmvufedQ7
Zuy2zBxH6QLlZ+HNsmuPKlwMHdD+qQPV7P7+4u46NwrVMBRDOBnAYT/22dLu
dhc2OrEqx1IbFvjzaMZ0IyYaMFaH4VoM1KC3Cl0V6BB0myVoKIKskPJaVOSi
NAfF2SjMQl4mstORkYa0FCQnU60IaQIz0TiExiI4Bv7R8I2CdyQ8I+EeAdcI
OIfDMRx2YbBhIl6LUDwNJa6GCXv7JByPI/AoEoZRMIiGoZR5Bx7JDFjmwY6P
BxvYuvQwyhbolyUFDhQkMuG2p7E+gOUOZhmUVOZoqvRzp2L4k1P2sv75deMa
uvcwcIDRQ0wdkW9dPFQs7+9wkyRoUY7hZITEXgeDJMPbYZK89W6sdOFZB+bb
MduG6RZMNGO0EUP1GKhDby26qkly3Mq4iA2lkBVTypaKApTmozgPhbnIz0Fu
NuXyTs9AChPCx7OQNCoJ4QkIiUdgHPyl8JPCJ5ZI8x4xcI2BczQco4kDaStM
zUVp4rjPmsfiqRRmUlqeMomnWWgTNpx4mgnLXNgXw6UKvoyEkTQK/j5vWtN8
8hOHJwoCcneW2xwWrPFkoX59ohTPV3s/huRPtfYyXuG7Z8U0n1bNAkjeGMeO
MH2MhWOCc/3okJsFNwP1FOlSjsdxOEbKrd1hbDM511oflnt4X465TszIMdWO
8VaMtmCoCf2N6K1Hl4zkw62CgrICsjLKO1RRTKnnigtRWID8fOTmkfoyMwdp
2UjOQkIGpCwcjUihylQhSaQGCUiEXwJ8EuAVD494uMXBOQ6OUthLhSfLP9jE
wToe1gmwSoJVMq30WaTCPA0WGbBiAQZBWQnP5wFf6hiK5tG4TuYze/wcU+Fe
V2wMHa90vcgX/TEcf3YajmSS6WPo2NJ4j5+sKQhCLBIrWz0H1SzpSo6mcDCB
vXFSX22NUDFLuiv6sdiLuW5Md2GiA2NyjLRhqBX9LUQO7myAvJ50wE01LBat
ZDmzylBWipISFBUjvwi5hSSZzMxHeh7p95JySElGRpmB8HSEppFiIygVAanw
S4FPCryS4ZEMtyTNdf+LPUu8Zp8MuxTYpdLatG06bDJgkwWbbNjl0USyE5us
4AH0ZytPsSyAKVxA3TrdhbzZLJ7QBe8cbvPI7G2Ob69QWvzPn4rgzzV+8UUt
6boljO/h2Qk2FGohrvy+chGKBdIdHM9ifxo7k9iewOYY1thE6bNBLAxgtg9T
PRjvxmgnhjswKEdfG3paWWmIRhLrNrGRE6W7qkZFFcoqUFKOojIUlFKGsOxi
ZBZRgv7UAiTnIyEfcbns+ZJNdaVCsxCSiaBM4vj7Z8A3XYPWV93SiBboxEYq
TulwzIBjJhyzaGHZgb9n8z5a3nCrhEctNQtq1wR9aQyzmjW075DpTTO3tXq4
v7FHs1DLK32vxOyX9Pp3L/ayfToj21g9wr6CO1EouXXaw60K3vHfD+dJurEz
g60prE9iZRxLDLm5IcwMYrIfY70Y6cFQF+k1ezvQ3c70li1oaaYsO/XMc1fL
UFmLshqUVKGoEgUVyCsnQWJmKdJLSBeXXIzEIsSzsCg6n9LqROQhLA+SXM19
8DXfbHhnwzML7llw5TdmmC45RH1wyYdzAZwLaW3TqRiu5fCogpcMPg0IbNXM
iCUMI2MSBfOoXkPLNnr3yNvzh+YPDp/tri1sTNE9+86piP2KXj+lhdjmIRQK
4okot6DcoD3KVRytYH9Jo99YmcbSJImT+DczI5gaxsQgyfaG+zDQi74eEld2
dZJ6vq0dLW1obEEdc9DVDaisJ21mqQxFtSioRl4VyQWzKpDBMqQllyKxhKRS
UpZpJLpI6KlvSAoRXICgAgTkwy8f3nlEzfPgt3x4MBqOexGxRNxL4FZKC5Nu
FbQ26VMHv0YEsonZSIH+NYYsNqDgRxONm+hgYe/YATe5uze5tTKxOgmW6OAV
9vVf+Nu8FDpvH+5ifwtH2zjeom/aW8XOCraWsPEMqwtYntOsa/7j+CgJ6oaH
MDiA/n709KGrBx3dpH5s7UCTnPSQ9a2oZada2USCydIGFNdTPu+8WpLwZVUj
o4qEY4xKqPPN6FISBUSUEvU8tAQhJQgqRkAxkUF9iuBTDO8SeDN/5FUGrwri
FnjxllP90WJiUOtHUyYJzO5z5lC8RNDwgwJhRDCwpxra2hlep3GurhYmp48+
3qXXd7Qsan0Xy5vYYGO3jXWsrmJlGUtLeLaIhXnMzmJ6BlPTpNgZnwCV79H5
dHI1EqtIIxRXiVgWwkdXIKqCOPbhFQirIIZxSAWCyxHIB3S6/vzLZ/0qiIvl
xwgrfjXwq6XVad86+DYgoFkzg8xfb3Q/rX8kjdOkm+CvXqtc04wsO3fQvX3y
Qh34Me7Mx673N2ww8PL1Cln5JzcxxWZG5tYwt4rZZUw/w9QCJuepKt7IDIan
MMTWWfrH0TtKyqXOIcgH0TaAlj409lIqQlkXyQFrOlDVgUo2vC1vR0kbpRwv
aKa8sjmNVFQivZ4EVEkyJNSQcCeuBtIaxLKIIqqaKPAR1UTFDq2GpJpIrMHV
xLQMqkFQLdHWdHQD+WfAZ/jWgbxX4W+YZrpnQuSa24aWi9hiRsoEMmaRt4iS
ZfCAkWVrqyq055gEjP77pWcZQ+dX3SyW6lvE4DMMPyPe8NACBufQP4u+adIz
dDNoOschHyXlUMsQmgapskJdH6m+anpQ1Y3KLhLrlXeijI1Pi+WUjb2gjdRj
2c3IbEJ6I2mXkuqRUEdKmbg60mPECvGNDJEyYqaHyxAmI05vSC0RTwWm5MsM
sxB2T4a0IaT9OcuGViGez5CnTCJ9hmZteVyKl2lCjJ7V6yrZMsWM2lkjtJkB
Aj6/OyVaEtb5ZdNonIZ8nkiTuh2z0PlBxwzk02ifQhtzvy1jpNhpHEH9EGSD
JLiq6ifxVUUvyntQ2k0p04sZkbOgA/lykm3ltFNVjIxWpLUgpRlJTaRMSWhE
XCNpI2IbEMOea1ENiGhAeD0xnSX1RMd9md6oYYI9p4EJuISxxa9owV7GkDSB
1Gmkz9K0du6iZgK2Yvm4bH79ba0r1s7vIODy+1P2ChVGckeJvVs5CR4g2RRk
/C8TaJhE/QSl8uRbyMZQO4qaEVQNUc2CigGSOpX2oaSXxE9FPSSEymeSm9xO
ZHcgS45MOdLbkdaOlFYktSKxFQktJBKRtpBeIaYZ0Syqi2hCeBPCmiBpOoWG
KLC1hPjszfBeRPbTUrZ0lJYBk6aQMoO0WWTMayzpTOE8E06fgoA2QgIif8BH
o2VmIW+kM45nER+r868jKBlFOVOi6JaNQOdzpcOkUOG3kkEUM9lKYT8Ji/JY
5vWcbmSzeYiMTqR3IrUDKfIXapi3EtoR1w5pG0kGYtoQ3YpI9sQIb0FYC3Ql
RDbVogJqxggaBlAvwvo0s8UxI7TMnDCJxCkkzyCVLdNlz6vSJnc+9hx569Qr
/6PWXvLO7Nn6Rtog0gaQMYhsNlTIGyKFQu4gU4fo5g7w0Ob0I7uPJDyZPUjv
QVo3UlnXJ3cisQMJcsTLQaoTUkXoxvLd92aMHFFyoppHsIdGaPtHl6mZ031x
jTq6RHI6EzaAiCFEjTxn0sXz1zqtmXJLnKCFcu2R0punXuefTrlOwVaMc+HM
NDSaZ1ZsD+L7NH8htZ//uyl0HoJmI5V4V6ma98k9JJ/R0U3oEk5e2onYDtrO
aFQKL3Ppdc6Ed2i+VOdvGIdvCWwjgTEXOkA8mMgRRI8hdhzSCRYZauuJtL2f
cIV/1trLniH08RtS4nTa1AiZCc7E9JBQIobOPLYbZ6T8Obwu7UZsF2K6EM18
WlQnzkTyP/x5E2edltp0JfwHXpf0EDtS8tLp6obyw/FPhAnknRFEjDJUtdn2
nzz1jP+ClzgAr11MgF4+jEpgXQO3JoGcr/OaFo1bRzegU7MCEdiDwF5iFwbx
d0MQ31FnBHJW4IAQ/3/5NDw+dg6iU+8S/uNX0yHOf251tjLY1zNmOOMkuzZC
l07xk54t8G6FbzudHT3nGSeaj5r4Pvfjf3yJD+0jh7ccXowfzR9806eTuKS+
zEH49sCnhwh7XvzWLfzhr2mdkbYCVjjvs6d4enYHvX2/GEbleFIB40qYVhGp
2lIGmzrYNcChEc7Nz32kWyvc2uBOa6bu7fz1EBHTtZ2IxG5y2nRd+R8XOfMG
3zjl7vn4OZ3T9OfnnvuQ12/k4G4hxMV4UEa8Y+Maoe9eN6mFSQ295Tf+d1MZ
s03tdd4zp/6V97X2aqu+fqn1Xju+Fr7lvNZe7XvsV/hoTPLxT1/ASwqol47+
Gn8TteppMo3pXNJqp+2z3n3pPY2ThE9d1mqlPbf2G81ZCK2vaB3V9v/0N868
aH1V81ntVr+gvtOsBevoXNM6qh1n/VjTWsgnf13rqPaz9/ua1kKdixt4iUf4
Uqtva1qxftW5pXVU27t/S9OaqU50bmsd1faU/6pp/VXW+o7mDLRbfVnTilm9
zodaR7Xvxy9pWjPejc49raPad8rnNa3Z+rCO+OUe1Ir3qRVbHdG5z/7sy2Mh
spG3NW3YnKCOPrQt73XN8f9ixx+8dFx4pWO/ZcceaiyDxQI6Jf9Przr/4/8A
41szGA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75015996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29334],

Cell["Plot a parametric space curve:", "ExampleText",
 CellID->211013130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "u", "]"}], ",", 
     RowBox[{"Cos", "[", "u", "]"}], ",", 
     RowBox[{"u", "/", "10"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15296],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->523072749]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->441951033],

Cell["Plot multiple parametric surfaces: ", "ExampleText",
 CellID->99222358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], ",", 
       RowBox[{"4", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
       RowBox[{"4", "+", 
        RowBox[{"Sin", "[", "v", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"8", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
       RowBox[{"3", "+", 
        RowBox[{"Sin", "[", "v", "]"}]}], ",", 
       RowBox[{"4", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210098037],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22060168]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35720798],

Cell["Use simple styling of surfaces: ", "ExampleText",
 CellID->382677537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "u", "]"}], " ", 
       RowBox[{"Sin", "[", "v", "]"}]}], "+", 
      RowBox[{"0.05", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"20", "v"}], "]"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "u", "]"}], 
       RowBox[{"Sin", "[", "v", "]"}]}], "+", 
      RowBox[{"0.05", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"20", " ", "u"}], "]"}]}]}], ",", " ", 
     RowBox[{"Cos", "[", "v", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"u", ",", " ", 
     RowBox[{"-", "\[Pi]"}], ",", " ", "\[Pi]"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"v", ",", " ", 
     RowBox[{"-", "\[Pi]"}], ",", " ", "\[Pi]"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "4"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "10"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "None"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57343227],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26487440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->404662467],

Cell["Plot surfaces with cuts: ", "ExampleText",
 CellID->824505316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"Cos", "[", "v", "]"}]}], ",", 
     RowBox[{"u", " ", 
      RowBox[{"Sin", "[", "v", "]"}]}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", " ", 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"I", " ", "v"}], "]"}], "^", "5"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "5"}], ")"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Green", ",", 
      RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "20"}], "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->257430365],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->491771773]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(15)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1205],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sampling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->682695533],

Cell["More points are sampled when the function changes quickly:", \
"ExampleText",
 CellID->507009906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1.16", "^", "v"}], " ", 
      RowBox[{"Cos", "[", "v", "]"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"1.16", "^", "v"}]}], " ", 
      RowBox[{"Sin", "[", "v", "]"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"1.16", "^", "v"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", "u", "]"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "15"}], ",", "6"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172764079],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{173, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8303632]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "u", "]"}], ",", 
     RowBox[{"Sin", "[", "u", "]"}], ",", 
     RowBox[{
      RowBox[{"Sqrt", "[", "u", "]"}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"5", "u"}], "]"}], "/", "5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1878282512],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{149, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->236733598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203184328],

Cell["The plot range is selected automatically: ", "ExampleText",
 CellID->473388551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v", " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{"v", " ", 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"1", "/", 
      RowBox[{"Abs", "[", 
       RowBox[{"v", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{"I", " ", "u"}], "]"}]}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11813271],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0.`\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->538472347],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnQdcG1e2/7W2cY3jlM1mW1529728fbvvDbg71UmcTRw7kXvvDde490Yx
vfciqui9d2zACIwxpth0DJhiwCDb9CrN+fz/c++MBFyEF2yEk137kwwzV3fO
93fOPfdM0Uji7z5zUP3o7jOH9u7+09JTu08cPLT39J++O36KaZr4Kx6Pp8fj
/crvtzxm/f8xW/h/PQBgXhiy3MksJzIdJqAttAL4H28Cs/pH3GMX8cpEtJjU
v83j/QH/2cwsUfPEEfYfqd2x7reG6DedWSBvJ3N/Wa9Xorioq6ujljm4hY9e
Ry0yu8w6a3c2/rOc20MF25e/yL26lHt1Kt6bWWEFMMu3Oe7AuKH9UNuv8fq3
HHkG2lJhLcud4s0a4ucUwsO3cfMSTsFMtDVZbkUOnMaNH09F3soRFNv7krP3
1gB/ceYQvd8Yob4vOC/fJeyR+TRjiD0VLoJstD7ldL1H2JmkYNyH2hnYAyvh
LeLs/fY5ulCU3uBUTOH+snsv4Lz6A7E3yfof3Hsux/pAAQtJ/Rvupcb1+hPR
i4zrf+PeFKfgP4nekwn9snlAxrvfl79z3I8IS9OIPSYPieykIS3v4D9/5Szi
kZuZ6QN3/SAvAL1eFAql4VAeBQ9joCYe6hLhcRKIb8IzkczPfv5UTvnUEXM/
4mKCt96PcYB4AdxwhpuukC6E255w1xvy/FD34mAoC4WKCKiKgtpYqE+Axuvw
JBmaU6E1HToyUJ+ebOjNleV9v6rpRFRURqzuL1xU8Mz+kH3d3xyCLSHMGqJs
Ic4erjtCihOkucBtd8jygFxvHLMAKAuGijCojoRH0dAQB02J8PQGtKRAmwg6
b6E+vXehLwek9wDyAVWhGUQWjHzsPuRU4tk7zVkfveJlBL7GEGgKoeYQaQWx
NpBoB7x3kOGpfXdAkg10HsB9RIZigDKAchioQJbrI1PwwcBRnGKtBXbaINAB
V13UxccAAozY3XhvJ9nSIns6Q0BnudC5bjSKlbe0zE9aGUhXh9B14fTjKFoc
Szcn0G036I4UultEs3tO6RdbisRCJUB1f8ZNJv6y8+T3XGSwrsmGl8D0Mlhc
AZurYK9BO2nRyFneX4IM6DAjabSpNN5cesNKctNGcsteckcgyXGRIH2ekjKf
vkp/SXWQpC5U8jhC8iRa0hInaUuUdCZLelKlTB/Jbak0i6ZzaPZghAI0QCTU
gmxODIgurhm89zmFWO9kjbOgfRb0zoHheTC9QFtclGKFUz00pT7akgDdvlD9
vkijvliT3utmvSmWvTPRq9O6bvT23uxl1qQZffSdPsjugzwJilWRFAOZhK9C
yqCOhgYaGmk8jihK7BCzKcfq+Q0xd7AulfMn4dJJ0DgJ2qdovdNSXIl4k63O
S+wu9DldQmgvjR4/rR4V1D4zzbLrtk1Xtn0nip5rZ5mws9Krs8avsz6wszGk
82lEZ2t0Z0dcF0+FHde7PZDbg4iFvVDSBw8kUCFhCZPkikFMkzX1P7De92St
3GEejzQyfOIonD4K54/Sl45yelX0T/QZn+w1P9Vjc6bb4Vw3G5v3AzU7w651
ROl2xBu0Jxm3i8zab1u23bVpQ+Kd2spc2yo92mq82+r925qC2p6FtbVFtnXG
tvcktKOA3+yg0zro2x0cAYko6IbibijrgYpeljBJ7gI8pWVHyBkw/LnGjMGe
MX9RTmHPph86hLqdOCQ9fQgl56VDvRqHe64d6dY/2mVyvBPz/uh2rt3rYpv/
5bYQjdZI7dY43ZYbBi2pxi0ZZi13rVqYHoWOzWXOzZVuzTWezfW+zU0Bzc9C
mtvCWzqjW3rjUQc6pZUWtdK3WuFOG2S3c2dfTCEt64SKLqSppgfq0LhDowTE
UsYxaKYnEyM0ZUi1IMdwar+n/f3kZzJ71Wn1fdKD+2TZcEq9+5x61+X9nZoH
OnDLVNOf2qyPtTqcQJo9zjb7XmgOuvwsXOPZ2/hVOukZnfoM0pshsxnutqDB
yW+ForaJbObXdMKjLmjo5nEz4akEmqXQSvNIP4ZW4uf4oSJv5cbtTdx3217p
zt2S3bv6ONqRXV3HdnWe2i3LHK19LXr7W4wPNlscfmb701N2brwVfVWcoN2U
rNuUZtB0x6SJaSqwbiq1b6pwaqpxa6r3bBL7NDUHNLWHNHVFNPXFiFXY2Z71
FPl6/xkUNkNpM5uFU+FROzR0QGMniLuRxuY+aJVA+5BRG3p0HN7b/gwmjraz
NuySbt4p2bYd5cjOrV17t3YwK4e3oVl1ekfLhR3Pru56qr3nqcG+J6b7xWwM
/u5yrMnzZKPfmcaQ848jLz2Ov/o4WbshTa8h07ABeW7ZUGrbUOHYUOPS0ODe
IPZqaPZraA9q6A5rkEQ9Rkl7/TGd0giiRsho4grCPTEUPoGSp0h7ZTNUozyB
+jZobAdxBzzFmdzaC+190CmV1cShWTtwzg6el2iVPNvA52BTVm2Xrt3Wt2FL
D9Nxy6bOLRvbd2xs48b68KZnxzc/PbPlycVtYo0dTWzrB+b7kBNOhxvcj9b7
nKgPOl0Xcb4u7lLdDY060bVHt/UeMa/mmz0qsXpUYfeoRvCowfWR2PNRi8+j
jsBHPaF1KAAxdXRCHZ1UD6n1cKsB7jSg/MOjPxMeiKFSDNVP4dEzPG1bQNwG
T9uhGVVpaO+Bzj7okg45Gx56xCd7TFcYFTIrcM5M4W/uW7WpZ+0GFPg1a9s2
rG3ZvKaZmxH714mPrG86saGR3Z6qta1eb0e9ye46q73IdddDtV5HawNO1HJz
O76GvlELN2sh/RFkPkKgvDooqMf7vgEVjVDVBLViqH+CNImb4WkLNLdBK0pD
6OiBrl4y7weO/wQebxi/JhF+YSvvMn7xN/Tw16JYrlzVunply8aVKMybV4iZ
5Z6Vjw+sRil8cm3d+fWPrm6q1dlSa7StxmJnNXdWFHKyKvrMw8QLD1OuPLyl
9fCu7kOmtdjsYbnVw2q7hw1OD8VuD1s8H3b4PuwNQi/RUVXsuP4a0qrhdjXS
k1sD+bVIaBnKBahqgNrHUN8Ij5EEePoMmpuhtRW73wld3dA9JAK/VeixCuEx
3p7OvM5fi4aRv6J1xY/Na35Ec2z98qb1yx9vWs6OwuSDK2qPrqw5vbr64toq
zQ1V+psf4vb3BXsq3fdX+B6uCD5WEXmyIv5sefLF8nSN8qxr5cht4/Jyi/Jq
m/J6x3KxS3mLsLzTp7w3oAK5HVlBx1ZAYgUkV3LnINjzKqS2qBpKa6CiljtS
1dfD48cgbsSl7im0NkM7dr6rE7q7FZ3/KPZ+MuE93mE6f30Pfw3yHgVg+bMV
36MsW/Nd46pvG9Z8W8fO8h3fV+9bVnXoh4cn+JXnVnJ6/2i4Cflov/OB694H
XvvLAg+XhR8riztVlnS+LO1yWZZmGfNqkWHpA9PSKqvSertSsVNpi3tpp1dZ
rz96iY4oo2PKIOEBJD0A0QO4VS47Nr8FRZVQ+hDKq6CqGmprkAuP60BcD08f
4zL3BNrxzO9qh+5OuqeHHP33R+7/LMZ5/ko0lfjLmvnfIef53zxesaR+xddo
qq75unrdEjQmO7+tUF9azno+7cKKMo3VZfrrSs02laJCt7PEY2+J/4GSsCPF
vDfZOR1WAtElEF8CN0ogtRRulSJuThnefxaUlkN5BTyshJoqqKvG0/oRPK2D
Zuxf+xPoQP7R3R3Snq5BVYrHzebh7q5NUug5eW2L93yPv6qT/2MbN/LfoOMM
f3Edf3Htqi+QolVfVK5ajDJ169cPmOXBb0uPLS05u7z4Cr9YZ3WR8boi9rg+
M/poYeLJwtRzhZmXCpntQt2CB0YFVWYF9dYFYoeCVueCTmFhn0+h7MrnehGk
FEF6EXdpca8ECkrZqM6Ehw+gpgLqKuHxQzzPa6EZz/+2JuhAAyPtapN0dw6u
as+9xpuoMBq4fr818I4XkwD8ZeiAyl+Cw/BFHf+zGv4naNxXfVKx8pMHKz5h
R27y9i+L931ddOSbwlPfFV5cXqDFL8Dt79lvynfdnu+9+36Q+v2ow/cTjt+/
efp+xoX7KCLX7pcZ3K8yvV9veV9sd7/V6X6XO2qn/fPpkHyIzIfYfDYC70Fa
AReXvEIoKIKSYnhQgjZryqDuATxGwwFPqqC5BlpwZDqacFha+rrbcdopHPfR
R4g97ssjxOe34RQR8798zCp9g78IBYe/oHzFgjL+fKSRv7CIWW7+tGDnF/kH
vsw/tuQ+7vm/uvx7zB/b9XnOW/K8duQF7s2LOJAX/1Neysm8jHN5zEsFmrll
erlVxrn1Frli27xWx7wuV9RO++XRwXkQkQcxeZB4D5KRHVl48qEgH4oL4EEh
VCIuPCqBhjJoQhUJnlVBCyoadPtjupM9IyPvJr1oZHDOTWUjw/8RVWH+1438
z+txAKrYoz1/dil/TjF/LtLFn5+/cj4a7a2f3GPPjU4tyb34Xa72shyjFTnM
tmBjjnBrjv+u7LB92XGHspOPZd86k82051/NLtXJfmiYXWeWLbbObnXI7nJB
7VLfHDooB8JzICYHEnIgOQdEuSgq3BzKvwfF9+DBfajMh+oCJLyhGBpL4Qma
xNBShcNSz52ndHa1DKqN/TWGzKSRxgefV85i9PCX4/n05WMcmWr+3Eq0olbK
VyviqyFd/Hn3+XPy+LNzWS0zdn6cfeCz7GOL755bclfju7sGy+8yrfZrs9w2
Zfluzwrdk8V7A/X7vdQniw7MgrAsiM6C+LuQdBdS77KZAbkoQlCcC2W5UJkH
1few/wXQWARiPI+aK6AVFbe+DnQO09LZLLs/+aL5MEM2U5ijB64cOBPmP+Sr
cceKN/mq2Fs15CpfLYevijSunZO1dX7W3kV3jnx25/TiO5e/ydRdmonr6Yxo
9cwbhzPTjmcyG/cvZZZoZlbqZtYZZ4otMlttM7ucMtlK+g5EZUJcJtzIhNQ7
MvezID8LaSvLhoocqM6FWjSRoLEAxHiSND9gx72rHckUdzSz99EJvwfee1J8
PJHdleZN5n+O6hAzunwKHdP5FFsPZ/BVGU/v8lWzcCPyZeOc27vm3z64KOPE
ZxkXv8pgo/OuNT/DaU2G56aMoO0ZUXsyEg9miI5mMC/cu5BRcjWjUiejzjBD
bJ7RapPRJUDtUq8M2j8DQrj9Z8GNDEjN4PzPuQ33M6EI0aAiC6ruQm0O1Oei
TXE+PC1izzMntrYhzfXMKYTszsW7w3rJm8n/EQ0s+48/u5x1kk/dwyvZfCqL
T6H48ybwqQw8NOtm39o+L33f/HT2DFHz63Tmj+UPaY6r0jzWpwVsSYvYlZ6g
np56BLXfO5deciW98lp6nUG62DS91Tq92wG1Sz3TwS8NgtMgIg1i07lowa10
7OctuH8LijKgFHkOVZlQmwV1OPeb7sETlG89zWi+P2lF5zA1bc/635dQl/17
R6HP+H2cKfylTZzDauyo5vMpbp5O4VO3cdMtPpXOp9KY9TVqIva13x+eLzr9
SerlxanMhvn3qQ4rUt3XpvpvSg3fIYrfK7p5SMS0550RFV8SVWqJ6vRFYhNR
q5Woyx61Sz1E4JcKwakQkQqxqXA9lc0k7LAI7ougKA1K06HiFlJbcxvq7uDc
5nRNantWxmqubmnEs1r2rtqA8563hvd5In8ZurhAxzXWHjPEzPhiV2/jljl8
SsSnUvF/N1FCz765Y3bK/jkpxxelXPg85dpXKUyj3Q8prqtSfDekhG1Nidt9
M+UA6pl3+mbRhZsVGjcf6d4UG99stbzZbYfaaWEK+KZAUAqEp0BMCiQiC5Ce
Ijs3ugmFN6E0FcpF2OVbUJcBDcjrviY0r8VPyrg6XvasifMFnSsih8lrO8We
4/s5+Prn0ypuwKlc1mVmdPFKKpPXKcwsoJLZDutUk7apJu1VS/ppQdLZT5M0
FycxjdbfJznzk7zXJrE1+m2pMAl8kiAwCcKTICYJElEnSEtCerLxemEylKZA
+U14iHIFHnEZPqm9MZflVD55KKs/yA3yDPY5/kzi/9Aoc4atRrNwtopkjUl8
6gZeuc4sV1PXN6te36V6/dC866cXXb/62XW2vr4RvPFGzPYbSXtR15zjNwrP
3qi4fKNW+4bY4EarOWqUCG7gevImhF2HGGQLkq9D2nXs5HW4h1tKbsCDJKhE
wYNaEXs19aQhR15Rcpse47Nx5Nr0Efk4S1Z7VfiqhTKX0lBKsrnAusWnElBF
SsDObKAStlMJ+2cnYL3vmH+T6LAs0WNlYtD6xKitiTf2JCIXjyUWnkksv5RY
q5Uo1k9sNUvELibSbongnQgB7L5vQHICpCVgFxPgXgIUJiBlDxKh8jpUoZHt
ecR6Oam8oYBVx83FmSP2jvFhJTeC8rmYyg4Y4xHnOxXHp2KZ/1BKUnFsv/eP
zY67sCCOWTP9Kt7uu3h3fnzA2vjIzfHXdyGZ2T8lFJ5OKL8YX6sZL9aLbzWN
Ry46xtNu8eAVDwFxEBoH0ZytGZAWi92MhXtxUBCH3YyHigSoQvFtqUll82Ti
zbpG7n79myPyELVO5rxKYNzAjsUwwxaNuf+5mYrZRcUcmR1zbn4Ms228ONb2
H7FuP8T6r46L2BiXuAPtcPdIXMGpuPILcbUacWLduFYT1ChxiKVdY8ErFvxj
ITQGomNwSqIl0nQ3GvKioSAGSnB7RRx3R7+8OoMNdWJNw9sj8gD1UuE8YEYh
mt2d8SASe/DnjVTUdirq4JyoU/Ojrn6MXrZZEu26LMZvZUz4hpiEbYh/93Bs
wYnY8vMxtVdjxLoxrcaosc8+RuoSA17R4B8NoWhHSIiC5ChIi8QeREJeJBRE
QnEkl+t9lbFcniB574xI/Tsy9f/HCJbNn3A+FcauMMv1VMRWKkJ9dsSJ+ZGX
F6E+Vl9FOS+N8uFHha2Ljt+KhGUdisk/Hv3gXHTtlWixTnSrUTTWHy1xiaI9
o8A/EkLRjhAfAckRIAqXXbeEQX44FIdDaQRKovIYlEPkswmKdbO9+BvqiJkR
inWH8PAZSChvGrOylgrbTIXtUQs/Oi/84gJEslgcKfg2kjcD7fNmr12kxDlS
6hkB/uEQEo5lhkFSGIhCcZiRRcgPoYtCUJ7+ekTq0DZbIfhUMJ8KkgU2iNnk
oSobspEK3akWenhu6Ln5YbjndM9l4SGrI2I3IYF39kfePxpRdjqi5lJEk3ZE
q2EEnl0zaL8wCMGC4kMhKQREwVhiMOQhBF0UhO9CkE9lKNb4G1nlZFI1kE8F
8NiYBTD/B+J+66ngbarB7Lx4y+TTMPuvwzyWhgWvDIvdgKJ0Rz38/pHwslPh
NRfDm7TC2wxQyvTZhkmcw6Qeodw7E/HBkBQEokAsMxDyEIUuDECvvj8ile+D
/Nya8sUx9MP/+TNKMeO9/WpBp+agqBp9HGK7OMT9u9AgfmjMehSlzL1h9w6H
lZ4MrbkQ2qQZ2maAGiW2oVKnEFoYDH7BEBLE3bmHpAAQ+WOZ/pDrh6sZ+TSK
YoW411+xNG/ZOPswYhmZOPkCNlEBe1UDT6gFMpsGC4Otvwh2+0dwwI8h0WtR
mt7eE3LvUEjpiZCa8yFNmiFt+qhRahtMOwWDMAh80V4QFQDx/mhF5IfkZPlA
rjd9zxtr/92IVcrmiCfW6MXoxS3/sYby20j57Vb1P6oacAnLtPos0PWbIP/l
QVFrUGRv7w6+dzC47ERwzfngJo3gNj2cbTZBIAgEYSD4BmCN/hDvB0m+XIHN
8qJzPCeOWB/u9REW5o6XHqxIZrmK8llP+e5Q9Tui6ndeDYXB8pMAl68D/ZYF
Rq5CajN2Bd07EFR2PKjmXFDTVdTSYxootQkAQQAI/cEXRy7KF+J9IMkbRF6M
FjrLQ5ojxPH7vUJ9vyb04WeL/gtrcsNLISORDeU6ynurqs9BVd+zamjELT72
d/4qwHdpQPhKFJeMnYF5BwLLjgXWnAtsuopaekwCJNb+IPAHoR/4+mJxPhDv
DUleIPJkhEjvuEuz3Uap7S9YlTOrkJXHrK+hvDarequr+pxWRSCzRX6Cxf4+
3/mHr/C/vgGJydsfUHo0oOZsQNMVFKZuE/8+az9a4AtCX/D1wdq8IN4TkjxA
JGSEICz5nNVzVM3AegR46YKFueMR9dxAee1V9Tqp6sPeIZ4mFfiA0Ad8vTHS
E+KFkCQEkZvsfa6RMf8oq7uTMc6VHal1lMduVU/2jpDxfB/7z328vvEN/cE3
YR0ar9x9fiU/+dWc8W26jELUZeLbY+0je2c1xBOihJDgDsluIHJl8H2Zjjz2
qZiBamYNq4Y3BWuwx0snRhWX4ljN20dxAhnO97b7zNtziU/ocp+EtUhEzl7f
kiO+1ad9xJfRGHQZ+/RYefcJvGihp6xeRblDghsku4DIWXa/axSq/oxl2OKl
o1zYasp9GyU8gjPHYJ6Xzadewq+9Q5Z5x69BKnL2+BQf9qk+5S2+jEap29i7
18pL4uhJC1F/CEEjCwkukOwMIsHoNH0gq04f8ikHNl9w8rptpdwPUUJmXW+u
p/Wnnu5feQV/7xW/GvFzdnsXH/JGci6hKtFj7NVn5Sl19KCFQizHDaKQT5As
AJEDe8LBPlkyIjVchKxlFV2A9bhsotwO4hTWneth+YmH25eeQUs941YhAdm7
vIoPeVWf9BJfQoPaa+wpsfKgHYW0EAcmxAWinCEB2aFFdi+qxxIv7ZhBw8Pl
vIFyVafczmBJFh8LXRd7BH7nEbfSE+vxLD7oWX3SU3wRbfYZe0ithLSjOy10
w3qcIUoACY50sj1PdiN5hHr+QzZaHzApxOb2KsppLeWyl3I9jcuj+SJ3ly+E
Ad96xK5AuZG906P4oEf1CQ/xRbQpMRLSVu60oxstRDMUQp0gyhESHKTJtpyU
D0etw4aJCrO2khKsoZx2Uy4n8OQ3W+Dm/Jm7/z+EMXwh1iEsPiCsOSEUXxRi
He60lRstcAUhzpRQAUQ7QKKdNNm6N9VidDrwM4R8yoydV2xQ1lCCHZTTMTy1
TOe5OX3i5v+Ne/SPaKyyd7BK3MUX0GafkRtt5UoLsAx/AYQ6QrQ9JNpKk61G
HRFOiTGbv2xYVlOO2yinn/DhwWSOq+BjN78lbtE/sErcSw641xxnlKCR6zVy
pa1caIEzVuIIYQ4QbQeJNtJki1Ep+RD6z9usmOHBOeKwhRIcoZzwXZHptJUz
CJwwxgHC7CHGFhKtpMnmLGaUFOYK2IKdrSsp+03M7GCvWo3UXBwXuvh+5Rq5
DKXD3W1uxfvdao67ii+gzW4jF7bOT8ES7CDGBhItpcmmL+Ypcx5tzjiLVtn7
LAdw1TCc7eywwMXnSxdWQ9Y212J115pjruLzLliDs8TKCZwE3LveEGYLMdaQ
aC5NNn6hSPyOSUK2Tqyg7NZR9uq4VOjPdrJb6Oy92Dnie0TN2upSpO5Sc8xF
JsJJYiUAJ9QTAlDCQKwlJJpx15X97A9GpAU/b8jMST2e7N8KynYNZbeXckCV
fI6T7SInry+cI5Y6c1L2Odccc35yHm12GQn6rBzByQFLsYVwNKZw3ZS1PvJR
+ZMsHu+zk3IFZbOKst2D56XuHIHNQoHX506sgjtbnJGCo2i9XcsJK3Cgneyx
AhsIt4RYc9mTZFiCfKaNSoUpk6J4FtjuwnPy2hxH64UCz8+dwr9z4lTsdao5
itY7tATdRo4DVFhBuAXEmo1CBer5Zxn9D3zKhElOTLfZienasx0tFzp6fCYI
/xbTNzsNpPcYOUis7MHJTkY3p2NN+hINXmYUjNmBWElZb6dsj+OBsFjg6PGp
IOxbAVYgKNwjqDmK1ju1HBkFUivsvJc1BFpChJk01vgFRwFr/YO67NMifMqQ
GQ0sxWorZXMMx8NigYPwE8ewf6ApcGeToEgmpUvLodfIXmptJ5NiARGmfbGG
eJYT9JHNDkINFmTCqtlM2RzFJ2Xm8+3dP3YI/QapydzkWLTHseaoI6umD6lB
fcDbCgLNsRqDsVVjjOeL5UbK+ghWYzbf3u1jh5AlaE5mbsRqfnLAauz7jOxk
aiwhyBwiTfpi9cdWjRFWY7GesjqEDyOm8+xcF9nL1DgU7XGQq5EY2UptbLAa
Cwgyg0jjvljdsVVjiNWYr6WsDuDDjclcO9eF9sFfo1S9w6jZzahB691adhJj
W9rGmlMTbApRRn1xOmOrxgAvzVdTluqsmjm2Lgvtgr+Sq7GXq5Ea23BqfMwh
2ASiDPvirr2kmmn9vZAOfTZ1VlEW+5jDIHojhTeFNrYBWyuMNcNYA9kUfkHm
1MFMPXmCsM8iGc22dVpgG/glmq+ZG+yZCNT+ZIcjYCt7ZpsREmIMUfovp2Pg
80PI7ltsbjD/duOjr5GajdN828DFWMh6u6LddjIhNmBiDbaWXC0LMYIo3ZeM
ycBPYCFT7zI5sQurMFSzEcy3DVhs26/iiC2rgjaxYlQgS76o/EC0ztipmMCp
YPPTbAc+8hmoWQvm2wR8gfi319sV77aVabFGWuwsWC0QasBT9PTxyynRx0pM
t2Ml+mrWjvNs/D/HStbZFu3ilHRpW0tNLDklfsYQpj/WSt5jz4oYJVvx8VhX
zcphnrX/5zYDlNhgJVYSEzw4bqbgZ8QooaO1xn58dLEWk834yKzDaJlr7cdp
sSnaZcNq6URacEjcGS2GEKb3slH5nbwXcNNYhxWyCQu5pmZlzwj5DFWrDEbI
TkYIWu/QtuwzZYWYgL8hhOuyE3okOt4ldPxJsY5reGm8EZ8faKtZ2s214nSs
tSncaS3X0WtqjnUYg78BhOuMuQ5tVscGrENLzdJ2rpXvp6wOa0bHo/54YB1C
I/DXp8OvvaSOSQN1yHIE5et6mQ4bpMOK0NGpbdGvI0BPGq6tLB3rKJPDeN5Y
z7XkdKyxLtzB6EDrndfkOgwZHX3hmsrQgZJuDWVyCKeq1VxLn0/kOqzkOiSm
6FXwYHTo9oZrKNJBnru+OUodKOlWU8YHsQ7Lfh1Wch1d18wlZqwOAwhkdFxV
lo5VlPEBnCKWcyy8P0Z16xanw3KIDp0e5ehAyb+CMt6PdVjIdazu19F9zVxq
hq8kPQ0giNFx5SV1kM8Qvzughhipy4R4LZILsewXYs4K0YcgPGvJZ/GHVyG7
shuGzlYOo334msJ8trnXQgtMtyyS0XuumUnN8SHfSx+CR0kfYQy08NJwD1Zh
Ntvcc5AKtN6jI1ehB8HaSlGhyarYjU9LkYoFWMUqRoVFvwoLuQotJaow2IVV
mM428+BUWDAq6rCKXh1T2gK9Ct66dMhYq2DfgdBgVexgVaiZ8fBTF5N7dU1p
Szlac0zJ+Hx7Gnvuxf4Tzjcf4Lo598wI+OjQIRpj6zW2PH0bvjgwUTMbCGZW
2i6Y9eqaTOinXx1bOvueOeP5VizAWM1UOA8JyEACzDkBejjvXFB06NArY89/
kzlmbsEXJQzfneObD+WD77UJY0pn39tiS9FmLMAICTBjBRRzAkz79HDeueiB
rzYdenlsR0CmAU2mTawGVVP3uWY4CxRp8GM0XBo7Dfjs+G35/N+IL4UMVU3d
CAkXTfv0sQRXRgKe+eTncsaEv4Hjm7jNkfPNMN9ExtdVFh/N7PUyvivHNxvA
N+L4/ppK46/DfAPER8fdWys5fivDN8B8Nx1l8VFtWYuLoD7Dnz2Yf8lEIucH
aCiNvwbz9VRNXDA/vZ9vzPHdrymLj0rbao5v7KJG8vsMDJXPX4X5uqrGzjJ+
yQ5Tjm8o4wdeHVs+W4VX4isXHYRGBTd9hSmJFmrTgVeUQF6ByddUjZ1Ux5nM
Xq1pDyAXb2fJRn2G+F0EoRYdeFkpZF1MNmLJaUPJHgz5ktLIWqpGApbMZ8gm
HNmIJWtKAi8qh6yO65vjYHLb5X5yb+AFpZB19nFkY0w2Icmemj1B58eMLP90
LyLvxXO6n7yNIGt0BZ0bFRmBhyXOZIh7MNFhCFFipM8SUUfy2XzFvGkcT/bJ
or+MmPujnGvIcb1GwVX0CaeB2+SV5UAd13ZjHfZYh+hHbqzbLxtKjcdXx65/
ouOqcnXwZsmPKztxoSOVXJEp8R6FkoHfkTdqBXaqRoQC2uSFFAz9foARK9kx
WEnJdhSUjiv4QCO4Bj6jUCL7JNooFKCDyXaswJZV8IPxYAXa4HNFkQLy3jj+
ZAb39PzLkg2UT942gJxKkJ20wVc5ZHQA3YoPeDaDfe68KidfVhp5iyJyF0fW
Ar8xJrNP8m9WBO1moc4M9JISmJsw0xpfv6bJmD0aSmVuxHd0OeaPxqXbkcO9
cqa/EpgTN2Am+ofvSk0EF03wvzi2o4g/5TLZSuZXCeuXpj53F8j/Arv7kPOF
l/Rt+nrsm6VsDEtlXLSvq+aEsY/m9HWDiEYssWfsiag6s99/sBbf9LZQTNSA
gPNKYK7hmAYKmG7KYc4YyBTJmVpy5jnumwLGjrgaE81Jop7yiKueR8THcGUS
0wiiu1KIK/G9SbN+IkrcHu1xJO5QOnHFYGLZQKLwyuiIiq5Q+kl8RaTegaRp
xL7kWd9ofWOJpq+MaMgRr+m+GqKHkohawxMvK49ogi/nXiVR5xURPceP2McR
LymPaDwuRB76alw+hc8OhzJ1MdNrFMy3CaaiOscxLxDMB6+QqYOZF8eWid81
nWb0algG/SzvcWHpjR9LokyWIWaJfjAYzLowfiwfhSzyfOKNUbPQAV203ODB
TszSVyLL4JWzfM+PHQtdw7JPX+jLWOUc65rSWJMGsriraoerSmLpDWU5Mqxz
qNe4sGjlsHQVsaS+Z5XHSh3IElyR+J4ZWxb7+bwd+GwW4ZbhVJTz2J1HwUN7
KvqdDZazHXO85qMq9XKckfk13rxtg3j6Mp7T5X8R3tZXyKsYB94WxTxn5fG0
xpW3GfM8Wd6ucePNI3mXlMObuEnOw9uTms/ik3/MI7+x7GVZGxWzXH7prA3/
oqz1BKtl/FmuymCtY1lz5axz48+6OGLWWwRr2HOFiWsxy2MAS2e8WW7KYWmO
G2sNx9J7dSx3ZbBWjztLOC6sVSxrjozVyrKEF8aDdX54Fvnc1QyFLLJuTJGz
VhKstvFneYyOhVDDM1Zghruc0f5CjJH5swI/Ij2AdWH8WeeVwOITrA6W5Tku
rIvKZrnJWZ1KZ6F/ymSxnwNym603kDURvM7xFJ/FvxgJvd/J3vmQk7ou6kwc
M0/k9qcMtI/6Y0eUSLmkRIrrK6F4K5uC74N6n1UqpVuJlMlDKTNeE4YQXAiC
zxnlES6/JgxPUFM+QZcl9HCE00om0GNPcCYIviMkzCII5Dn5KyF0c4RTyiNc
GR+CdDQEdO7yX8NZnjTQMuo5xsonOf2r2O/6hdtXevyvaiuyTz4xM3209lWV
a1/w2v7PxL7GL9t+j3LsO/7L2Nd8bf+1/dHbp37Z9h3k9rWUa7/3F29f67X9
sbSP9h/+ikJuF4kQXBqxZe4nJ7l/sm+2IX+fczTcN4i+5Bkpy8XfHDXoFz/J
31cmPyk97DXPYA1O/74a7H92Gi7+ojTIftOdx62imUB+Wn7sqW/+mxF0+gnO
rwkvSiCr+bRREuxeE36GhAvKJri8JrwmvDjB9l+N4Pqa8PMgnP+ZEdC530e/
UO0/F4LNQILbL4kwDWS/LvaihJkEgcyl14R/c4L7uV8kwfo14d+DoEISZhI9
FT1l8sL2ha/tv1r7Z8fcvtVr+z8f+x5ncX2YwHRUdDb1MnbR/ugHU8jfeSPr
z8tyJnEc8jvXyHtto+RMJjhMO+pGVlPysyqjpExkKero18aZxVtEP/JbM/qt
o73/W4FVHHFsmdWM2kmrH7yQZpWB1oeMwrtE7z++EGMCF2X5t+6qWBKcXxN7
kL/PPjxHhcsRBXY9z/DeA3YWjMzeX7hYzBjW3vuEnd+OyO6HnP/kb5xNG5ZD
2iW5ijl/4PSrEL2nD8v5HdHzNyPivM9xyM9RDM/5PdHzvRFxfs3FjayVw3PI
cSbzSjHnLc4fckYNzyHnATlPFHPe4DikquE5HxA931HIIb91WlYxyCwahuN1
ZkhFentEnMnc+JDRGJ5D1lUy4oo5Ezh/yL2H55BHiVnP56jjfzxUKcj3vodj
nB5yxHvzOTnQ30oej4e3T54RkJZY+yR15PrJnuQxkLVPRo5U1W/fgrBPeko+
ocDaJzNA0XMLiu2TRxnyEzGsffwdL0zjyO0qOv4OtUvOeHIGDWPf+zTvr5wi
xXbJ2vDB8+zeXKrbeFgHjDWQ3b8RPclvHmbtk5VX0dzlqfCpE3LNNpQW/gTd
34me5FGGtU8eQciKjO1PkXgdHWQffTXdcd7/En3J39JjCeSxkDy2sHn85CdN
zrbqP7GKzzDxEReNCmltMbFNHsPZvcm9SI1fEtvk2TNrhYwVGcuvcNjl28D+
djp7pU+OIznOX2PXUX9cVmX5NyS/yPxbgrflO3E0MtvJ2YD9Hfx8h5z4IRdp
cp/P0GKyfB92N2Dv/bLvqJNzmKwdH+P4DKTKZLDfS0fWLrK2zRmiGo02MoiP
h0MqJll75wyIlUwKHochtZCs5arEnkgEPjcbUuXIKv13BXviMcV1DMVZ4dMK
Q7yU2UAzEq3iWPP+h9hX4SdnFUYc6x5Sk6YS2x8oiBiaiaiJfCJI/qTakEpE
XiP+brCHwH4imGRNHBIHXDGHVCGyjpJP/01SMAJ/HiHr/7gxUshQ4Q2eC/Lf
4vtohNbJykfWriGe8GQj/s9tqxG2yIo2bbAHAzID1coJCrIOtU0dIX02Wk4h
KiFnR2XwPsDO4A+GWCKfepRdncq+cYLNNTynJ8tJcgyZnSqyUX8ug60Gc/EO
rKl+3bLfmfxohFbmAZs7slpBxhS4OTN5iD0Vrje+PuCtHvL6JIV7KGghrglH
ZmtgfNHfke+Jc5P3DwW+yvJnaL4MZ+UbxVF+7jOJQ59aZG19wY3c0NcJmzA4
w/72PCUDuPPl4z1cXRx+jBfhzfnEPkPj9M9HeCHIKtYkWVz/6UwdOM4LR6hk
qVL6zSNi/z1u1Ruy5P3q/wP+n9bw\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{133, 423},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120724335]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->267188002],

Cell["Ranges where the function becomes nonreal are excluded:", "ExampleText",
 CellID->198477081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "u", "]"}], ",", 
     RowBox[{"Sin", "[", "u", "]"}], ",", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", "u"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->366401567],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57041772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v", " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{"v", " ", 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"v", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "u"}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->615433788],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNfAd4E8e2v54xEAiEhAAh3OS23Jtb3qUa03tvwnTTu2kBG9y7XCRLtmVZ
zbKdQnogIUAKcAkQOoQWeq82YMDYYFwl2zrfe3PO7MryyCTO/d73//7+5NXs
7uzMOb/zO2fOzK5WuSh0RcCaRaErlyz64+jgRWtXrFwS8sdRQcHsUJP/UigU
29i/taOClf+Hleh/GwCwEx7b1WzbhFXwwj0sAP0pvFhxENVYI5xpghvvun2F
YuD/5/Va/4KOb7tQwL1m0nebX23zr/QVx7Z42LuR9TWNrBcl1GvRyOsmS/I3
cauvQM3Z/xsSCi82sq1JHsebC1d2kLTnTfC/FgKSbzeyrXZSfW+5ZkBAAK/Z
p5EtvCJJ04yOuy5/7vVNpR7bSt8tqQa/jtfo/QtXuvf8ktTzi249g8SvXvXs
0lz6bgVuPGvqklWSmF8TINmrrVsdlwgKX/peIrXTXuxZkLAH1V4otfhafU2l
NnpSnT4NMEjW5Q3pXCehN7Fud2qptwdu3h5HOkoSvSG0KPpTt0a32F5qUZTp
9f+zHl6VevhTAyjg8cZr/7J0xV+ElpoJsrVswCayV3dqdG8vSb29/Su9tfC4
UvQ04o+LKbKnt5La/0cD7cue7S1H4Ua0P0Fq77+F9sTaLzSyvbFSe12E9l4Q
ajf3aE+OFBzrP/6CNd6U+ugm9CHG72YN9uHBV8UfGqUb7vo0gFITt3gsRx7e
7uuNtkV76To5xuNW7KulcM0/Gyl7W0lG0Re7C+2LI9Y/ntO+bKdXG5D5/7IP
93ptJB04i+DIJ1J/PX4BIxSNYyRzSbZO6wYkl1o++hlv3AP9VoJEf6NLfSW5
WnPlf/ocjn6qoD9Rsoav95EkwRjFlD72BRMA6xz+SCHHOKENrP13urYFPD/f
elM69wpv98SXcGwD1jj6KRz+mGqIvvOS0ArPTkTOeWYxnSSZ2nEQT2yC41/i
+Z8+53rAwfWs0LVRvWHr3grPUcWzV9kfMTdiZj35NZz4inr9ArdHPoZDH5KW
YhSSc1Q5WjY0/nZopObtn9NGW07En7fCqc1wchOeOLaRxEJqcDxEuV4W5fDo
reExuDFytpVQpZjUAk5/g6Kd/BqrcFNxyh36iLTv/P9QspclBN8EIveZ75hw
eJ4Ld2yjTKKPcXvgfbb9VwPSuWzQKKnEzFker3/PZTi3Hc5+D6e/xQtPbeYY
Sb7Dg87BD/AqcbTkfubqjXfo6ZnPkekPkiyU67SB8zvg7HaGBlb8eStuT3zl
7r9Iblbe964rwrlJ0tajj8ZKIc9c3uLGOv9vOLcDpaBI2QJObZHJvAHj3JFP
kDFsd/97VEPMR14Ve3XDnHuYPDr+lQN4YSfrEuuf/Z4rLuO/kXNUpsEHuP0x
WyHHQcEK2OWfqf3XwC1atoVLu+HibtYLXn5uO27RE7bI8G6UYsdhSSnYm9tA
D+0ErWjkIvy85dqvwuUf4dIeuacduD3zrWTIk5tEPrnr8zehN4qS3kFdEoK6
JK7tmrS2a7IYa4i1rnGtoWjmPiKzliU7wZW9KCaTkazbGk0t4y4hclyMWbAv
t24uL47pzYO6qLiUrMa6bup13TXB3bXENbzmjySnZz7m6aWCJ7NuCJUOcO0A
XD3A5MZTF/fglhgqG3IrDQJuQw9nJzkJ7LbKPBMz0pZBnevL3U3DCsE9dCE9
UkN80sR85s3fpke9iIDoE3at4dpBuHoQruzD05dIF8Z+F1WYOszZ2IBGtmkG
Rz+XuL//feKKzasBbUiC1uwEo8vazon1tdEybVgh1Cc9tKc+tGeGR371xm/T
S4wmbnJQ9OgI1w/DtUNY68o+RjSy2Q8ssHH/ZvHVxTMymJz2HPwA9r8Le3Ow
/INJIc3Z2gmzctTQZa/OatSwu66ehr4ZWO5lCO9l8pYY+Pv/WMMmgoYUXdrD
jZ+Ykljr6kHcktO7WFk3lvEgxmKmNMp+yAYy2ZNY0zuNvCOpVeSIoCA3IVOw
u0tB1C7MNzPM18gUZOXw3uaIPtbIPjYPu/7uP9baW9CaPLgT3DoGN4/BjSNu
Bt4rGZgCOOnOR88t7tG7Loq4WZfGu9e4wlzzdV3dFJYtGtIznSscLisc0dsa
0SeLFSL7Zkf1zYnql+sxv+azSDkyPi/fayZoSfH8dbh9Am4dx1qkKBnZjcZc
0frjc13c4a66D0cP2GVRuLj3OsZx7phd1VxbNyX1oT5k1Z5oVSz0MpKSVpeS
rBDd793o/u9FD/jANQdrSC8klrxSoHCt+L0gaPom3+T9DHd+ZvripWRYUnY/
MXqvS18KTJK+MqO/oDGZxjCWAmCQRYPADgP2T+g3RR53kTRGR8XuFe3Yfghj
sawvGtXXzI0a3hl1j+yTHdHPhoX+OdH9MebFDFgfM/DD2IEfiXPbX59Zt3Ch
4LGa4YbGG3yTdwbyTmMtTwJgHNsLF3fBhR8UrnGdIjWnOeVEboPlj6gA7Mx0
5TvN6qFBJPdCPJD/oT3Q/myP8CCG97IwPCJ7I6ZRfXIiulnJ/u9F9Uesowa+
FzsAk8DYQR/HDP4obvCnXKNfzUDF+NAwOi0EdMiar8Ld85B/nmGEFe+clEhz
4yhuWTS4ut+FEQ+DCinx2SJnkHVB8CP3QAA7MhTyCrGAUldEiVjzOkLUU0+U
MYb3NLFjEb6WiF4UBHojX6L65HKIovtyynzIKIOFQR/FDULDxA/+PHbYJ6qh
G+rnS/8Be1oK+NDM6jW4dxHuXsBa+WcklJBGJyQaYf6yXxrzXU511i2IsNyQ
paCE1QuMRHy05yTC7bdahbTO0JxHTAEmjtObod31YT3QtcJ9jDyUhPdCnCJ7
2dh5RqWovohTVP93Y/ph6hnbn+G0nqj0iQun+CFfxA/FdDh++BcJw75KGL6p
gfU/kVtNoG6F0hMzcdX+Ne5xBVfg/mWGHMF2jiEnk+skJ5cLOdy9RMxyTRQo
f5cmiz9JxGL5NCHozUcY+B7Da0sXap1VEmpd6qHWiVAzcNTCfcgBfa2cXWyg
ieqdy1FjdTlqLCDFDsBAHzfw05ghSOe4IZ+qBm/gqHkxzAirhBGbEkdsSRq5
tXHoeeDlWmN7SUCPIsqf4ME1KLiK1zDq3ePUO8tCOlHvJNz8yR1AF/XIO3dQ
orlVCl/H+NTHLcmkjBm2pSvkdTNFM1aQEksGXheXZ76F2HUn7HqYwn0okvdE
7CJ9cVLDsIvoio3F9PkgasB73DP58Mewix+IdosftCFuKBbihn+eMHRT/IiN
HLukEegYSSO/SRr1TfKo71yrrfKsQvbjOqzE+0Uec7c/w6Ob8PAGQw4rMurd
v4SFu4x6Z4l6p3DLkLtJcU2knot3ksfi1mMexwKa695IM/LVxLWdKZ3rrAnu
oiXU3sZI1s0gxbMe5ggfC0aynjhqRPnmRPbNie71Hkct2hctEtvvYx7PYgd/
zOFTDdqgGkxIDflKNexL8twNicO3qEZhNpIw+uvkkRhd1KO3JY35Tj1mh7ge
075B1NoIqL3KUSu8DY9uYa0H1yXK3b8kU+4MZRGn4PZxBhweuU6JoYtyUv7w
rZwRk8M2lBKS5zaHTSqiWnJQ5wRiWwoDjXPtH2w/tLshvCvFte7msM6IYKSP
jXMt2vfd6N6IWnS/92P7EFh9P47rh/aJ7/9Z3CCi2NDPVYO+ZI0lDN6kGvZV
4tDNicM2Jw7fnDQUTZo84rvE0VhIHLtVPRrHeM2YnUnjv08Zu8tjPath/F4W
8KOVobfg8V14nAeFd7Diw5sMRSxg8OP0O88dl+ViuHvrJwnIawdwe3kP5R2u
sLfVtWzhinnSPFfKN1n024J8C+6sZWkXIfcvZFrnTAk5HzP3ycju2ZHdMMhF
93wvqg/xrff6GI5c/4/i+tJw0O/zuEGY2aoGbuR8Y2RLHLKZh8OEkV8nD/uW
I4cuyvg2anvyGFxKSB63LWUsRhvtuN3Jyu3a8T+6359BMTvUi3F0h5g1+QqP
bUX3oOgu1i28A49uE27XZbe95BbtXPnasXrUQ9Bcqavbct6JL2l5eL28bsXc
9N9IIvhGwznWDZHqmhnWlUaBLpaIrpRj+GRHdaMEo8d70T7kkD0/jOm3nnsm
RypuwOeqfri0kzDgy/ih3DM3JQ5BuhPBkP3Jw75nnahH4AKUZuSO5DH4EIl6
7L81Y1FSzfgftOP3aJSImmbirlTl/lTlAfGeyasN8u5VgXeUKfwFih9AcQEU
3ceKj/OhMA8LFAKJgFf56Av3zuNu3mkp/uEs72h9AvJhgwjI2XeS2MeXy4h9
hJ4PK6zsnBPaGXOW8K5WCb1uOVFdcznPYrpR2uHzYawvXhvn+2lsf0Jv4Oeq
vhuIZ18mDMDImjhws2o4FhIQPbRh0ojv1MO3cZ6x3jQjEbSU0buSxyOe6gk7
teN+TJmwGzmn/FE7EScwWr99qX4H0/yOuO7vcr9t25A3i/dr/gRPHjEIsVbR
fcZIQpG5MafjDcZIQpGNIpTA3D0rJTDSfOqoREeOokhHvsi9gePWi4+4Lt8I
70y4dcmN6orYRnd/P6Ybki2m50dx3XGcjvf5LK4PBjRV7w3xAxC3+CEbE/sR
2QZtThyENkoe9G0iDaGJo75RD9uePOp78s8d6tH/Jtbt5AOJbsxeNaec367U
CQdS/HAdQzuJ4YbSp04+nDrlkH7yMfEOVtsGcewg4EhR8w/wtAieFjI0sSLj
pERIDIpEyFuMk1h4cJUFRSy4DS0E6HFE88ZhuMYXW1xrZtsUMvO83eiYQ57t
w6GM7IzuGt1lfXQ3mg/0+DiuGw4JcT0/i++OiY+q50ZVP3LXfpsSBhLhhmxO
6v8NR5AzTz10W/JIhC9p5Hcpw39IHksOPHZnyhhkW8q4Pdpxe5kUqeMOpEzE
dYKUCXvSlUdSphAFp+5Pn4TxPH3KsdRphzOmnOLeKTxVw1dlnjeb9wa3p0rE
e95vQEkxPH2MVzxhKD8klAtkwuZL4w66ff1x515dxq3g484NabVDRrU5nGXj
trz0L2XZHyjc8eV/sV0+je1Gftzzi/hu5Me+Xyb4YJBI7Lk5YSARc8DWpIEI
K8NUPYAi3+AdySO2a4YjHzWjdqaMwDRLN+JHFgjxyITdurH78cj4/Tol+xxg
IumYN0/E4KT3O6abigzVTTuUMRnjVsbUn1P9jximnXHdKW0Gz79Hym/+PmcO
6DGTFp/GoVqd4FkJlDxhH6z+9DFDn2zwkKFPQYMRPB8LmD5xgl/ziBh8ADsu
I/4iXOELTW4TxFNfw0la2j7+mULSBpVRdI3rujG+G43Jvl8l9KCg6bs5sRc5
f69vEwcThwd/nzyIwB62XTOIIuaQXerRO1OGE3VH7dGOxg51o/drJxBdJ+5N
G4c0SJtwRDcJwWZipU06mj4ZOayfciJtGhbSph8zTD2T5o+Cp888bpxxweOu
7q8/r+f1m2zwO8EGtHrXEUqfMTNgXbREMVmiEJ7KoabOEhRqClmouSGHmstu
oeY0rca0kvKIG4fksW83hRq+ck2B+8zXMnvIC7rFdN8S3wMRT/DdmuhL9O71
bXIfirV9tycPoaFp2A7NYBrhh+/SDt2tGbWbwsdu3Yh9HHrdOOR56rhDOiVG
OJ3fIf14FESvPJ469bDeDwcUJl/6NIRbP+2kfjoSXu//s2HGWf1MjJEZs08b
Z140zbwsWuHX76b/Nis0+BRZBygrh9JS9sHqzCuekUuUFMlh6SE8oXG0+L6U
1j2uH5MeXCH2tyJb/OwKSLi9fhCu0UTiCtni0g75aRbJB3yR3Im9tyX1wUJy
v+3q/hRPBv6gGUphZOQu7ZA9KSP2UGzZpx2NjWnH7U8dhdEjbcyRVCUVlEd4
YEmb9FPGxJNpU4jl044ZJqOHGqac4aMlYX4uYybGTcOsc5mzMHXKnHPBOOeS
ac5V17Ml4kpb41GX13ZF7xHZT9e3g/IqKKtk6GNFNMAzMsDT5xuA5dU8Jt0h
xFsT+pehgALSvbNwlwLSHUphblMWeOMgXN9Hoiia1Obtc7d7d3ZsbS8EFB2g
/67kAYT4wF2aQbtTBiPiKUN/1A7DuKIbvl87mlg++mDqGEotxh9OG4s9pI8/
ljqJCpOO6f3Q9PrJJzMm/6yfSiyffipz6jlEefp5yQazzxj9L2XMwYOGuRdM
szFnMM29Ypx32TzvusdzxQ2utTTaFmJLrhX9ek+LQoWdnS2vVLyEtcsqoKyM
LCLHpmceselJQR3+bHwopPHh4TXmCVgQzJF3ghxR0aT63lEuDpcND872ORk2
AAO2avB+hVfykH2KfyLuw/Zph+8nyh/QjTxIuB9O5YF93NG0cZSQTDiWPoEi
ysST6VPQ4ulTGe6n9dMworCB1DANV0UY3zNnYJRkoBtmSzZgoBvmIfcN8y+a
56IPm+fdMC68YllwU36morGRR8575PUc0V6E9isS2hXVUOFAtNlpxn2GOOJd
Xod3qQvvIj6ituFos9CDhaJ8KfRwwB9dg4dugN8/J88K79FMqOCUwnX3pCUr
LOl/mnM9afiRpBFHKLoc0Y7CglfqmKOKvxC8P6VR8E5XHk9XniB4T+n9KEhP
Pp0x9bRhCqE69VyGPxX8z2fOuMjhNc68zLE1zrlsmnONic+wNc5HCRm25gU3
jYtw9cW4+Kpl0R3kOY5aMivr3Q3iOaX4rEJrRLGyhlCsxnN1WFZCeQVhWQZl
pYo6bj4rhhIKITJt4QkBWZwPRQTk45u0zMUI+fACPEKeVBdheul6Qk3RJWoU
wpY4Gl1bPfaEdtxxcv8TaROIdMqT6RPJ0yf9rJ90mnA6kzHlrIG83jDtfOZ0
bJWBZJhFhdkXjbPI5WdfZTGX4WSae53hxAiooGHSvBBta150k4FkXozrVual
t6xL8q1L83E2TbohSNIj4S89H6+WUOWEqlqorMUTDLjKeqhRSy9IkCH9SqD0
KYFWBM8et+AgFNF0segG+7BCbRH6iv0pSkgrl8S3LqtHX4kZd4FzSz3hjE6J
MKT6nU71w4EmfdIZ/WTkSsaUcxkSKhcM0y9w3mT6X8ok3jBUjBQLjXMRFURo
7nXT/Ovm+YTHgluWhbc5QgwYVrAuzuOoYDngblbAvaxl91+QEGoqjDetXCjJ
T3Q0lxDAQZuB+KyINC+EEiJKSQE8JaI8xfG+9mk+lGA/9pJ892fzFU3mjc5b
O+FmjN9V7nltUyajTqlTLrAPRaQL+ml4JGP6JcOMSwZ/VJSpmzmTFJ191Tgb
FfVimiraUhS6ydRlnkIMkDS2LMqzLM5DLZfkM4GtS1Ekri5em7W8QNHEtuKB
W5THB/fFu4StGuQJRqcmYJeOVTmREpRLvglVNfVYU2mXfK2iEirI18rLoJyI
U1YCZUScsmIoJRxLcSpR++yRsxSnc9W0rSrDLY1vfJ1v4YT7QZNQr6RpN+jI
31OnX9VNxxCR7n9V74+FjJnXDLOuGQglw+zrxjnXiSA3TPMQItP8W4wXiNXC
O4wUDCiEa3E+AwrhWnqX8QILyxArHvmzlj/IWoG5hG3lQ9vKR7ZVjyTGtGoQ
L/EJQnrajeFFvtMU7E6CrZZ9UAEv/O5QHzYHQ47D5uSwVVCsLy+tLadYX17i
KMNsx1mBW0dFcVVFMaJBlmqm7IJEWTwZSRk1427SzDz6NU3rtNk39XPwg7jM
vWmYiyhkzrttnI+MMS24Y1p4hyQyM0zamBcjHpYldy3EHWvAPWsAcidrWQFj
D4MEyyseZq18SPZnoNDYbHunMHv1Y/ahgahR+PxejlA0UjqcHCEv/MJ47LQD
+2ChyukkzJxVNc4qRKq20u4kpFjtykoar6Cygn2wUiVmiJUVpY5KBK+sstS1
5ooXNJ+uxOwkyP9R7BxURTP3nnbuXfJIL/38PMWfEaQFeYYFiELmwnzjIiyY
Ft81LkY4zEvumZfesyxFRCwB963LcNJlZTypw+URowoCsqrQ9g6iQbAUZa9B
smcHFmcHPskJetI4hH4nIeRV6+AZEPvmH9IdvzuyQo0dagmpWrvTSSA67TUO
Qsppr66pQqQclVW1VQ5nlaOSUHJUVVVUVrFCeRVu75WVy8828/uy/lOfLZ1V
EjoPeZa4oFCzEP0xdWEBjXLtMhbfNyxGCDKXFBgJC1NAgTGgwByAcFiWPTAT
HJYVD60rEAsGStYqdPOsdx57MVQULyBAa4psa9AWiFHgk+wg7MsrZ+1TRZOc
dSUSAq2fi5P864Mmcl5QzdB4oYagYdtqKjjswI944Vc7OuW0E0QOe22tHVlV
VVXtdGD8qrZX8yPVjtoqO6JXYcfjT+0198rt2J/8pKWixSz/8uXzkGgxi0vi
FqEWuqWP05Y+Tl9ayKN7G0MAap657JFxGRZMyx8ZlxeaCQ7LykLzSoTDsuqx
9Z3HZMus1UWKVlmriwmYYlsggmELYqhgsMxeW8K0ZKgQQsHPGEIhz34VIXHV
1zXWvemohiqChW0dDrBzrOQCi94cvWqGlcPJQSsjKKrsNZVUKLVX81OltFvi
cD6285S3IwnFCsr+GGdmz0H2hSypCF+C7pi0rES7/GnaCtRKv6JYykEzVxYb
VxYRDqZVxYpW5ncQB8vqYrnwJGsNApIV+NQa+MRGmHjZ1pYQj7LXPcNPMM4H
c4JLeej2ygllqV1uaNlvQonu0LBKdP+1qhoUnVBnysMxlDCAqrHAtpUOqVBG
ZCqzo3NRndoqqsMuKaM6Tx3OYjp1u4K484YLn6HIBfa3fGl1YACiFLOiPHlV
hWYVDpTp75Tq33nG56KvGlej5U1rSsxrsGAJLDEHSoWstc8sQai6de0z2zq8
0hZcaiMwWEHhlR1SRpEjJ7SMI5MTXq7wyg0vF+/f8XvL4ozyFYk3tPraiSXT
z0gptmXlUiqXy5qyg5Lu1c5SUpnVeeKo5fx4RqeKHM4iqpxfSU8S0xiAOraa
s6h2+XK8KGylXbW6OmE1hildYEV6IBYMQeWZQeVU83XTWmSSZW2ZmRfWlWUF
l7EtghBcZgtBt8wOrcgKxSO20LLssMrsMDoYXp4TUcm0yY2ozImoyI2s9LiL
WYcC2qqNpD0d7VhG2nMASquhhApPHFBeXXekhKGCSju5rk/pVLEDHlPlAjvk
V0m/cd18W/Zgyr9fUfpcVk5As81eSs9+vlMbGVgbvQZ5kRxUpV2HBf06uyHY
nhmMIdvItjRqmUMqFe0Rh5BKayh+EIfQSltYFalclRVWkR2B5ZwIuy0CwcyO
rMiJsvPImxNVmRtt/wUcxGc1sBLNI5ozixbRsMO2TO9iaVRiiNDaALPzE25z
Vo/OFTrgERXu2SGvCgtXK6TceO+j6i15KBt/PhT7VPa7rpxUziPEi8tWQ1Cg
MzQIyRS/zqEOwaiTGlqdHurICK2mfo1h1YRsO0u4w0ofBAJ1dpDOjqzIquwo
LOdEVduiEKZspnxMdXZ0JcciN9bROBzkmQPVbl9M+nEV2baQCo9km7uUfuiA
Bw4o4Oy3w20C4EoFj5qKJptYfOCt47PAdKzNzBWwNBAC12HNqJBaVSiqnxJe
qw2vTotABAwRtcZI5JopsoYxIbKGrnvFGlWTFY3nbdHVWdGO7Bgs58TU2GKI
EzFVuXE12bFVXOt342veja/2yNka1ryppDndhW3LFHtgl4jN1WNll5L3HXCP
Cnmyttcq4XKFxP+dD5wbbqLK/NcE+HSgckSB0h956b8Sa68JgZBQiApH/RIj
apMjarRRCEB6lDMjGg8ao8EU7TTH4EFLjNMa4+RYvmSLrbXF1mTH4YnsOKct
jhgQV50bX5sdjx3kxNtR84TaX9eauCVpTfdOvZl29+mDZ1BDzD/vOiCfoLht
h1tVcKNSsu7Fcq6v955C+L4AOOT8VzXKLmeVYx4rZ1dzjrdbuBZWh0FwBFaK
jXKqSFlNdG1qjDMtBvU1xEJmHJjisII5zmmJw4PWeMiKl2KoTYVHslXObFUN
FWpzEpzZCegfOQmO3MRa1nfDGvNFTvmvobtIrnt27FIa41sxffPow47eIa1Z
4UYVXHfpLtm66ZEnsPcxHtx617n+apnHk+Z/Bbe1CkkG0qjDgmBYFY6HIqIh
hkBIjHWqY51a0j09HjLiIVOFFUwqMCfgQUsCWBMgKwEP2hI4Mi2zE4kLiZCT
xD7kDkk1ucnOd5OhAUzoXm5jV1ObcJvS43V0MQPiJmOAzPirBMclosJ5iQ1N
Dz+BfUV4nHHiyzucAeI6BK484Oyc33dA/+hzXTmhWDnfOZEGynnB2MDaaAiL
xUJcvDMh3plMFNAlQFoC6AmDzEQwJpK0liQ2S7QmYTkrCbKSCaFkjlDzHDXk
qBEkts1VQ64GGprJNRYZ0cL05Kg34wTzfwYFSsOwoDZOl7nu/SqaH2JMIVy2
P4At98jJTxd7PKf7BrhlJW8gMoPuKKeUKhfCxBV48dwwCIiEQIIlMh5iVM4E
ooYmEVIIivQkyEgGAyFgUoNZDRY1lq1qyNKQdDb21SRbU4+N3jkpkJuCEshj
4H+ADPkRu4wjcq4czpL+DAViRosDT3B3VyHseIiFjXdqci+VaY7ixMrj2dKO
Eg6t5RGjo98qvGh2GCyNwkKICsITnDGkc1IyJJHttcmQpoZ0UjhTA0ZS0pwC
lhSwphA5tOBl0/IZZ7YW2AdpoQPpzgi41hPFdZDGYiD+GoE/k3KqVEabuNDy
ECHx42P4oRC2Exhf5dV+crPacg7TJJGZ7SQsXL9QVA7LV04rVS5xIiYkeadV
cbAuAcIJhbhkiCf7J6tBmwJaQiE9BQykrVELJh2YdUQKHWSlgi2V3CUVsqnA
tl45aSDyXHxiurGING9AG5olHHoKnBG7H8POQix8WwCb7jo/uYljmuE0TgOk
Z1Pqrm4jRY72LixGP1D6VyiX1k5azaO5osPCGFgRj+2FJUOkGqKJDioNqLWg
JhbotKAn/Q2pkJkKJlLbnAaWNLCmcR9J51pkpwP75KQ3Eg33KC+v5IseTvnF
i3uKYBfpvO0hoNr5GJ/ev1qVfcmecozmzeLTTHKG2kn2iJcnrYGpIdjGAgoH
a5IgRA0RZO3YFEjUQQIZXK2DVK6Vnn21zEyn0JAO5nSw6IkFesiigi0DvLIz
QPzdkKgB17W95O1koeY7HsH3D+AbSgM+u+X4+KbTdrFSIa9keLxvge3SHSG8
6aAcX6icVaEMqPEjfciGrwUkwKokWEfKRGkhVgfxZLHEVNCSAmnpoEuDDJI7
MwMyqWDOAAv7GMjV2dbLZgBx7BFXhLk24jM55IPNN92FDXdg/TX7B9fBcr5C
dwKn5x53z+W1ZvwtFHnj75VzKpXLajgP/CNRmsU0kgdqIFQLkcS3+DRQpUEy
KaPNgJR0SMvAcoYB9FTINIApE8yZWLZkgjUTsowe2oi24b926Cgc5b9CXX8d
ci7XZJzGyaM8Ar8ts8lbGVCtDIIpoTAjitugw7IkWJMCwYR7dDrEpoOKUFZn
gFoPOkI5PRNSSVq9ATKNkEnSmo1gMYHVBGI0FLHn0ooMEd+78DfJkxRNlZOK
lHPKGbTKIOfkMCn2tQ9QwyoiSmgaROkhhoRMMECiATQkT6oRtFRIywSDCfRG
gtcEJjOYzeARocR9LmUnie+idJjj072zJpPCYFoUzI6X4lCLlVpYo4Ng8r1o
A8QZQEVSJLGtl4YJgWs8OiPozZBGIulNYLSAyQIiTiKOXCKRh+IbGv4h49Zc
OfWpcl6FchmzsNMvHKZGw4w4Scq2y7WwmggZlgFRBoglEROMkGSCZBOWU0yQ
agGdmQA0g8EKmdZGSvimcFR8Z8I/ZY9popxbqgyoVAbWSDMGfxXMobE9gGJY
UDoE6yGCZIszgcoEiSSP2gxaCwlmRSH1WWDIAtEnGvQZWp9Be4oy8RkMxqWx
Ba4RuylzDWU4TGbAxcOcJAm7NitSYQ05cKgBIo0QSzIlWCDJAmorOXYWaK2Q
lgXpNs8xo8E4y3+l6SFP/X3C7DXljGfKBVXKFTVcOL8Y7HFWEswnZ1hBgq01
QEgmhBO94iygskIiCabOAg2TzeaZ6YhSkaU93uEkvrMA3+rwAo8jMTBFBf6J
ME/D2ffiqgxYkwHBZLxIM8RYIJ5kSMyCZBtoGi3Dnxvgt/t+ZxmZ9sqZpcr5
ZUioNQ5laA0TaTLF39lqWKirAycoE0JMEE5Wi80ClQ0SbJBk81xTFUd/Ls9b
EoNEOZBRdN/Y208F05JglgbmaaW7DwyLQCOsI3tEWCE6C+JsoMoGMecWf5PN
exR/MS7+jr+rjMCLylllykWMG8zja5VhoIwGpQqmUHo4VwcLU6XY6b3WDMFm
CLdCVBbwN9i4WgP+e3c+Poo9iZLge2746odyuV0ZWK0MrZVy3UlJMF0Ds3Ww
IA2WEOzvGCHQBMEWCLP+Yp/iuxTeEvblN+8oWrFBQSH/KUNqlFHOifHglwTT
NDCL4sdivbQaF2iWuuHrgnXvdmMF3uvfJauKvdFb31ooR+VL3Sy2K1dWK9c6
J4bUTIyo9WOzdh4pZupgbios0kMAEZ7ne/X64X4uepDo9/huu+bUol8cTEqE
KRqYoYM5afWfz0a0eHtinPiDsN+Hyz+3XLmEJA+smRhaOzHKyVufrIF6OVBd
u+L7Wn4v7A+gfU4zLMrjJL+6s7QnXjVb2Kcx12MEE5+XmwE8a+GWEt9/JD7f
OxXc1nQ93sQkZh1+Utv8Oe4e4DaXdas1HtzmH5wTbmfFJ+dHS7X5u8R8hbNi
hj9cqv0m1e4lSSDWGgx12ab0zka3s+J8qb9Um/xV0Vc4+4qw31uqzd/p1U84
K64g+0i16X1D1BPKK9bqJlmBv+1voHBWjLT/ktrk71gcJJwVx4m/S7X5mysH
C2fFNYW/SLWJsYohkrxiLTkzHkK1hglnG/rVOdYeQbWHC2fFTLKjVHsM1R4h
nBVzqHZS7QlUe6Qkr1jrZakWvX2TGPdLI1dryRrTqPYY4aw46rSQ2van2vhe
QM9Y3VyqM4fqjJOkdF9LkedHC6gGaoONLKE9xX/9L03pH/8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->222709870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->340058447],

Cell["\<\
The surface is split when there are discontinuities in the function:\
\>", "ExampleText",
 CellID->457656239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"Cos", "[", "v", "]"}]}], ",", 
     RowBox[{"u", " ", 
      RowBox[{"Sin", "[", "v", "]"}]}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", " ", 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"I", " ", "v"}], "]"}], "^", "5"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "5"}], ")"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30552953],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10469631]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->866407957],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " to control adaptive sampling:"
}], "ExampleText",
 CellID->410787491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "u", "]"}], ",", 
        RowBox[{"Sin", "[", "u", "]"}], ",", 
        RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "mr"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"mr", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pp", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389502305],

Cell[BoxData[
 TagBox[GridBox[{
    {
     Graphics3DBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        Line3DBox[{{0.9999999999987663, 1.5707963267942506`*^-6, 
         1.5707963267942506`*^-6}, {0.05996152090689936, 0.9982006892456704, 
         0.9982006892456704}, {-0.9999749121073166, -0.007083442380967266, \
-0.007083442380967266}, {-0.034368074205230754`, -0.9994092432409377, \
-0.9994092432409377}, {
         0.9944049419754639, -0.10563527523878664`, -0.10563527523878664`}, {
         0.9999999999987663, -1.570796327032857*^-6, \
-1.570796327032857*^-6}}]}},
      Axes->True,
      PlotRange->{{-0.9999749121073166, 
       0.9999999999987663}, {-0.9994092432409377, 
       0.9982006892456704}, {-0.9994092432409377, 0.9982006892456704}},
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02], 
        Scaled[0.02]},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], 
     Graphics3DBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        Line3DBox[{{0.9999999999997563, 6.98131700797675*^-7, 
         6.98131700797675*^-7}, {0.7829103708627669, 0.6221345121398786, 
         0.6221345121398786}, {0.17054692788813527`, 0.9853495549234896, 
         0.9853495549234896}, {-0.48671128029338595`, 0.8735628939207372, 
         0.8735628939207372}, {-0.922571706606025, 0.3858256681067841, 
         0.3858256681067841}, {-0.9470904651011167, -0.3209667442501644, \
-0.3209667442501644}, {-0.5391548539344013, -0.8422066512911035, \
-0.8422066512911035}, {
         0.1609564993570501, -0.9869615014349465, -0.9869615014349465}, {
         0.7703689411135215, -0.6375983803050567, -0.6375983803050567}, {
         0.9997611546826076, -0.021854829848320944`, -0.021854829848320944`}, \
{0.9999999999997563, -6.981317011384762*^-7, -6.981317011384762*^-7}}]}},
      Axes->True,
      PlotRange->{{-0.9470904651011167, 
       0.9999999999997563}, {-0.9869615014349465, 
       0.9853495549234896}, {-0.9869615014349465, 0.9853495549234896}},
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02], 
        Scaled[0.02]},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]},
    {
     Graphics3DBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        Line3DBox[{{0.9999999999987663, 1.5707963267942506`*^-6, 
         1.5707963267942506`*^-6}, {0.9295149702056089, 0.36878438166992106`, 
         0.36878438166992106`}, {0.7279972365802116, 0.6855800635458819, 
         0.6855800635458819}, {0.4238545325679434, 0.9057302773020289, 
         0.9057302773020289}, {0.05996152090689936, 0.9982006892456704, 
         0.9982006892456704}, {-0.34240160613159276`, 0.9395536919827976, 
         0.9395536919827976}, {-0.6881535731463637, 0.7255650623933682, 
         0.7255650623933682}, {-0.9201292863333058, 0.39161472958988836`, 
         0.39161472958988836`}, {-0.9999749121073166, -0.007083442380967266, \
-0.007083442380967266}, {-0.9251301739856053, -0.37965005094344945`, \
-0.37965005094344945`}, {-0.7166895960571671, -0.6973923020104357, \
-0.6973923020104357}, {-0.40475358455800237`, -0.9144257956704022, \
-0.9144257956704022}, {-0.034368074205230754`, -0.9994092432409377, \
-0.9994092432409377}, {
         0.3339205041649292, -0.9426012396014762, -0.9426012396014762}, {
         0.6558396704523886, -0.7549002097369575, -0.7549002097369575}, {
         0.8866865618717904, -0.4623709993024904, -0.4623709993024904}, {
         0.9944049419754639, -0.10563527523878664`, -0.10563527523878664`}, {
         0.9968514630936463, -0.07929161700997733, -0.07929161700997733}, {
         0.9986002143106957, -0.05289245672714173, -0.05289245672714173}, {
         0.9996499715465876, -0.02645627311067263, -0.02645627311067263}, {
         0.9999999999987663, -1.570796327032857*^-6, \
-1.570796327032857*^-6}}]}},
      Axes->True,
      PlotRange->{{-0.9999749121073166, 
       0.9999999999987663}, {-0.9994092432409377, 
       0.9982006892456704}, {-0.9994092432409377, 0.9982006892456704}},
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02], 
        Scaled[0.02]},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], 
     Graphics3DBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        Line3DBox[{{0.9999999999997563, 6.98131700797675*^-7, 
         6.98131700797675*^-7}, {0.985943380710271, 0.16707977146740924`, 
         0.16707977146740924`}, {0.9441689299407048, 0.3294617303035733, 
         0.3294617303035733}, {0.8758510530466368, 0.4825815297720142, 
         0.4825815297720142}, {0.7829103708627669, 0.6221345121398786, 
         0.6221345121398786}, {0.6573854131695284, 0.7535545226139436, 
         0.7535545226139436}, {0.5101485048115076, 0.8600863346423911, 
         0.8600863346423911}, {0.3460625472560361, 0.9382114438582935, 
         0.9382114438582935}, {0.17054692788813527`, 0.9853495549234896, 
         0.9853495549234896}, {0.0014582593360059801`, 0.9999989367392892, 
         0.9999989367392892}, {-0.1676724152253254, 0.9858427669626156, 
         0.9858427669626156}, {-0.3319731882438045, 0.9432888223058956, 
         0.9432888223058956}, {-0.48671128029338595`, 0.8735628939207372, 
         0.8735628939207372}, {-0.6248303512461155, 0.7807605472625112, 
         0.7807605472625112}, {-0.745648398812875, 0.6663396021157647, 
         0.6663396021157647}, {-0.8458200735524432, 0.5334682775720968, 
         0.5334682775720968}, {-0.922571706606025, 0.3858256681067841, 
         0.3858256681067841}, {-0.976893232291226, 0.21372789407000814`, 
         0.21372789407000814`}, {-0.9993988381119447, 0.03466932910361627, 
         0.03466932910361627}, {-0.9893555508755896, -0.14551836293629308`, \
-0.14551836293629308`}, {-0.9470904651011167, -0.3209667442501644, \
-0.3209667442501644}, {-0.8797770558241029, -0.4753865080599925, \
-0.4753865080599925}, {-0.7874986014347954, -0.6163164388025368, \
-0.6163164388025368}, {-0.6728736468946379, -0.7397574300503579, \
-0.7397574300503579}, {-0.5391548539344013, -0.8422066512911035, \
-0.8422066512911035}, {-0.37709714514907466`, -0.9261737110933443, \
-0.9261737110933443}, {-0.20247713577413026`, -0.9792869903601826, \
-0.9792869903601826}, {-0.021111971536997908`, -0.999777117490604, \
-0.999777117490604}, {
         0.1609564993570501, -0.9869615014349465, -0.9869615014349465}, {
         0.33452362046065676`, -0.942387365871325, -0.942387365871325}, {
         0.49734838555918787`, -0.8675509111179985, -0.8675509111179985}, {
         0.6442021008141544, -0.764855315276445, -0.764855315276445}, {
         0.7703689411135215, -0.6375983803050567, -0.6375983803050567}, {
         0.8658263760150877, -0.5003445678695633, -0.5003445678695633}, {
         0.937083330869283, -0.34910575905723756`, -0.34910575905723756`}, {
         0.9821481217057927, -0.18810918911574576`, -0.18810918911574576`}, {
         0.9997611546826076, -0.021854829848320944`, -0.021854829848320944`}, \
{0.9998656443081114, -0.01639186787175882, -0.01639186787175882}, {
         0.999940283073148, -0.010928416518085453`, -0.010928416518085453`}, {
         0.9999850687493864, -0.0054646388979397225`, \
-0.0054646388979397225`}, {
         0.9999999999997563, -6.981317011384762*^-7, \
-6.981317011384762*^-7}}]}},
      Axes->True,
      PlotRange->{{-0.9993988381119447, 
       0.9999999999997563}, {-0.999777117490604, 
       0.9999989367392892}, {-0.999777117490604, 0.9999989367392892}},
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02], 
        Scaled[0.02]},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}
   }],
  "Grid"]], "Output",
 ImageSize->{312, 355},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1717571860]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"v", " ", 
         RowBox[{"Cos", "[", "u", "]"}]}], ",", 
        RowBox[{"v", " ", 
         RowBox[{"Sin", "[", "u", "]"}]}], ",", 
        RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "mr"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"mr", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pp", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->481924092],

Cell[BoxData[
 TagBox[GridBox[{
    {
     Graphics3DBox[
      GraphicsComplex3DBox[{{1., 0., 0.}, {6.123031769111886*^-17, 1., 
       1.}, {-1., 1.2246063538223773`*^-16, 
       1.2246063538223773`*^-16}, {-1.836909530733566*^-16, -1., -1.}, {
       1., -2.4492127076447545`*^-16, -2.4492127076447545`*^-16}, {1.25, 0., 
       0.}, {7.653789711389858*^-17, 1.25, 1.}, {-1.25, 
       1.5307579422779716`*^-16, 
       1.2246063538223773`*^-16}, {-2.2961369134169574`*^-16, -1.25, -1.}, {
       1.25, -3.061515884555943*^-16, -2.4492127076447545`*^-16}, {1.5, 0., 
       0.}, {9.18454765366783*^-17, 1.5, 1.}, {-1.5, 1.836909530733566*^-16, 
       1.2246063538223773`*^-16}, {-2.755364296100349*^-16, -1.5, -1.}, {
       1.5, -3.673819061467132*^-16, -2.4492127076447545`*^-16}, {1.75, 0., 
       0.}, {1.0715305595945801`*^-16, 1.75, 1.}, {-1.75, 
       2.1430611191891602`*^-16, 
       1.2246063538223773`*^-16}, {-3.2145916787837403`*^-16, -1.75, -1.}, {
       1.75, -4.2861222383783204`*^-16, -2.4492127076447545`*^-16}, {2., 0., 
       0.}, {1.2246063538223773`*^-16, 2., 1.}, {-2., 
       2.4492127076447545`*^-16, 
       1.2246063538223773`*^-16}, {-3.673819061467132*^-16, -2., -1.}, {
       2., -4.898425415289509*^-16, -2.4492127076447545`*^-16}}, {{
         {EdgeForm[None], 
          GraphicsGroup3DBox[
           Polygon3DBox[{{7, 1, 2}, {9, 3, 4}, {14, 8, 9}, {8, 2, 3}, {13, 7, 
            8}, {10, 4, 5}, {12, 6, 7}, {15, 9, 10}, {23, 17, 18}, {18, 12, 
            13}, {17, 11, 12}, {19, 13, 14}, {22, 16, 17}, {20, 14, 15}, {24, 
            18, 19}, {25, 19, 20}, {1, 7, 6}, {3, 9, 8}, {4, 10, 9}, {6, 12, 
            11}, {7, 13, 12}, {8, 14, 13}, {2, 8, 7}, {9, 15, 14}, {12, 18, 
            17}, {14, 20, 19}, {13, 19, 18}, {16, 22, 21}, {11, 17, 16}, {17, 
            23, 22}, {18, 24, 23}, {19, 25, 24}}]]}, {}, {}, {}}, {}},
       VertexNormals->{{0., 
        0.7071067811865475, -0.7071067811865475}, {-6.123031769111886*^-17, 
        3.7491518045553436`*^-33, -1.}, {8.659274570719354*^-17, 
        0.7071067811865475, -0.7071067811865475}, {-1.836909530733566*^-16, 
        3.374236624099809*^-32, -1.}, {1.7318549141438708`*^-16, 
        0.7071067811865475, -0.7071067811865475}, {0., 
        0.6246950475544243, -0.7808688094430304}, {-4.898425415289509*^-17, 
        2.9993214436442747`*^-33, -1.}, {7.650055244365201*^-17, 
        0.6246950475544243, -0.7808688094430304}, {-1.4695276245868528`*^-16, 
        2.6993892992798476`*^-32, -1.}, {1.5300110488730402`*^-16, 
        0.6246950475544243, -0.7808688094430304}, {0., 
        0.5547001962252291, -0.8320502943378437}, {-4.082021179407924*^-17, 
        2.499434536370229*^-33, -1.}, {6.79289384763935*^-17, 
        0.5547001962252291, -0.8320502943378437}, {-1.2246063538223773`*^-16, 
        2.2494910827332062`*^-32, -1.}, {1.35857876952787*^-16, 
        0.5547001962252291, -0.8320502943378437}, {0., 
        0.49613893835683387`, -0.8682431421244593}, \
{-3.4988752966353637`*^-17, 2.1423724597459108`*^-33, -1.}, {
        6.075748962904675*^-17, 
        0.49613893835683387`, -0.8682431421244593}, {-1.049662588990609*^-16, 
        1.9281352137713195`*^-32, -1.}, {1.215149792580935*^-16, 
        0.49613893835683387`, -0.8682431421244593}, {0., 
        0.4472135954999579, -0.8944271909999159}, {-3.061515884555943*^-17, 
        1.8745759022776718`*^-33, -1.}, {5.4766061056499897`*^-17, 
        0.4472135954999579, -0.8944271909999159}, {-9.18454765366783*^-17, 
        1.6871183120499046`*^-32, -1.}, {1.0953212211299979`*^-16, 
        0.4472135954999579, -0.8944271909999159}}],
      Axes->True,
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], 
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxl1g9Q02UYB/AFXHE3kD9dA2FYqHhzQubZBZn1KlckSOXNAyyXYYpcIGeI
dVenFIFRY6GgJir9cZ2KaXeFKKeoLwtMRDFI5Qoq/i5AGhvsNzfm2Gq/9/k9
3n5777j39tzxfZ7PvRx7Yt/epsrxk0gkm///8ZcIx0wkovPsml9120pHiVy2
XNVYNYy3tkhaHLXsFxIhL9FWlJrwdro9p4+eSl83+uG5cSLc0Qmq5HthE9Qu
1eyoG7pDhFsOdY59xjuA795P69jv470T+kayflS4E2HOx9l8VLi9XMd/uijc
2+VXC+VXJ3286pFrxobl42SdpuHH6z3/oHfWooVrM+vbyJGQr5bYSybR+y6f
M0CfyjAX6dsn0BsyO23lsQYzpQulOamq39EbCvULrI7e9yEngeWg16lkfWtZ
X/S+AXOq2Zzo9XLVnkHvcFLlUFKlxcf7UXFrksNqJAdc8SH988bQu2cwRVGt
vE4WVU3XKpMt6B3kc4Zo75Ot7lKTGb1V0fkbX8ueortf1mbcbe5BbzXUP2Z1
9I5Bzh8s58H7Qt941he9u2DOGjYner1c1WfRm5nhOVYfb5emT/9Nlpl0bT9W
wG0dR2/Y4c0zHboO0hSeGfimnxW9a/kcA41ZuvelEx9MoffROdqSaSlH03OC
UyoW/4VeoZ7C6uhdDznRLOfB+x7y6oveTpjzDpsTvYLrIQ/ms0b0thV6Ht7m
493Urc5NbpgkwSMxNwLPGdF7TbFyrCy4k6Ttry/a8/M99F7hc0ZodqK6ot2f
Q+/+J344+l2jlYaXVj4T/3Ufeg9APYjV0XsTcjawHPRehr6rWV/0boQ5w9ic
6BVcvLf4PHqX8X8+dh8vF9sTZAi1kNT1Xypj3Cb0agI6b+lSu0jPYyF9+k/s
6E3kc0ap7jlFl/ELK3pl827qX9lko1s7y/dteXgAvRFQf4fV0bsCcr5lOegt
hr69rC96LTDnq2xO9Aou3rujCb2nv/cch4/304Ks+vICjrTklrdGzp9E7+r+
DZebd/9G8g7mp3HJDvSe5HPuUgPhZGGRNvTWxJkGbLOm6Zq32qSNzw+i9xDU
01kdvWcgZ5DloPcF6JvP+qK3DOa8wuZEr+DivXmX0DvH82+s0OnjjTh/O0vZ
biUDR1ssulVT6A26aKz7W3+LOCLbzi7wd6I3is/5lypebFY/rbOjd7Yi1E93
wUGXTgSWPfLeEHqjoL6Y1dEbBzlxLAe9riavvuiVwZzDbE70Ci7Pd68km6J3
r+fZk1w+3pMBqpkbC2zE3euem1BgQW/HwZ37nDO3yeeH58e+3jKDXi2fM0Hz
Vml1WfEO9B5RLpmbvsVJZbtSnVmnh9FbC/VwVkdvDeTkshz0XoK+GtYXvSdg
Tr8/+TnRK7j49z3VjF7grRB72b5hBycn2je6wekW7Rsm2Dfui/YNF+wbBtG+
4QKnQbRvCN9D90X7RjfsG27RvmGHfYMT7RvgOq5H73/YWWth
       "], {{
         {EdgeForm[None], 
          GraphicsGroup3DBox[
           Polygon3DBox[{{12, 1, 2}, {15, 4, 5}, {13, 2, 3}, {20, 9, 10}, {14,
             3, 4}, {19, 8, 9}, {17, 6, 7}, {16, 5, 6}, {18, 7, 8}, {22, 11, 
            12}, {30, 19, 20}, {24, 13, 14}, {54, 43, 44}, {23, 12, 13}, {26, 
            15, 16}, {28, 17, 18}, {29, 18, 19}, {27, 16, 17}, {25, 14, 15}, {
            32, 21, 22}, {34, 23, 24}, {38, 27, 28}, {36, 25, 26}, {35, 24, 
            25}, {37, 26, 27}, {43, 32, 33}, {40, 29, 30}, {39, 28, 29}, {33, 
            22, 23}, {44, 33, 34}, {53, 42, 43}, {49, 38, 39}, {47, 36, 37}, {
            46, 35, 36}, {48, 37, 38}, {45, 34, 35}, {52, 41, 42}, {50, 39, 
            40}, {88, 99, 98}, {55, 44, 45}, {57, 46, 47}, {60, 49, 50}, {58, 
            47, 48}, {66, 55, 56}, {59, 48, 49}, {65, 54, 55}, {63, 52, 53}, {
            62, 51, 52}, {64, 53, 54}, {67, 56, 57}, {76, 65, 66}, {69, 58, 
            59}, {56, 45, 46}, {68, 57, 58}, {72, 61, 62}, {74, 63, 64}, {75, 
            64, 65}, {73, 62, 63}, {77, 66, 67}, {78, 67, 68}, {79, 68, 69}, {
            82, 71, 72}, {83, 72, 73}, {84, 73, 74}, {85, 74, 75}, {86, 75, 
            76}, {87, 76, 77}, {88, 77, 78}, {80, 69, 70}, {89, 78, 79}, {92, 
            81, 82}, {95, 84, 85}, {93, 82, 83}, {94, 83, 84}, {96, 85, 86}, {
            90, 79, 80}, {42, 31, 32}, {98, 87, 88}, {97, 86, 87}, {99, 88, 
            89}, {100, 89, 90}, {1, 12, 11}, {5, 16, 15}, {3, 14, 13}, {22, 
            33, 32}, {4, 15, 14}, {9, 20, 19}, {7, 18, 17}, {6, 17, 16}, {8, 
            19, 18}, {11, 22, 21}, {19, 30, 29}, {16, 27, 26}, {14, 25, 24}, {
            13, 24, 23}, {15, 26, 25}, {12, 23, 22}, {18, 29, 28}, {17, 28, 
            27}, {21, 32, 31}, {23, 34, 33}, {43, 54, 53}, {25, 36, 35}, {26, 
            37, 36}, {27, 38, 37}, {28, 39, 38}, {29, 40, 39}, {31, 42, 41}, {
            32, 43, 42}, {24, 35, 34}, {33, 44, 43}, {35, 46, 45}, {38, 49, 
            48}, {36, 47, 46}, {37, 48, 47}, {39, 50, 49}, {34, 45, 44}, {44, 
            55, 54}, {42, 53, 52}, {41, 52, 51}, {70, 59, 60}, {45, 56, 55}, {
            76, 87, 86}, {55, 66, 65}, {49, 60, 59}, {56, 67, 66}, {47, 58, 
            57}, {51, 62, 61}, {54, 65, 64}, {48, 59, 58}, {52, 63, 62}, {57, 
            68, 67}, {64, 75, 74}, {59, 70, 69}, {58, 69, 68}, {65, 76, 75}, {
            2, 13, 12}, {62, 73, 72}, {63, 74, 73}, {61, 72, 71}, {53, 64, 
            63}, {66, 77, 76}, {67, 78, 77}, {73, 84, 83}, {71, 82, 81}, {69, 
            80, 79}, {72, 83, 82}, {77, 88, 87}, {75, 86, 85}, {74, 85, 84}, {
            78, 89, 88}, {81, 92, 91}, {87, 98, 97}, {68, 79, 78}, {84, 95, 
            94}, {82, 93, 92}, {83, 94, 93}, {85, 96, 95}, {46, 57, 56}, {86, 
            97, 96}, {79, 90, 89}, {89, 100, 99}}]]}, {}, {}, {}}, {}},
       VertexNormals->CompressedData["
1:eJxdlXtUjGkcxyOLtIhaqU3S1tGhkrBSUz+EKa1I0QVRScPpZru4rbSFtBRq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        "]],
      Axes->True,
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]},
    {
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1WGtsVEUUXqlFww9QFNsi0Qoij5AILRGUTYZEHtUYNTzFhFIqD4kiiJWk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       "], {{
         {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwNxdciGwoAAFBFJSEJSRTN3kNCJGTvIFYiA9VWW6X2KhpBEHvvWXvvvWe1
tVq1xw/de14OIfGrKdHezs4u94WdncP/65jICjPqqqY6iY9NEeFrLTgDB91Q
REiTEk0BmGYrKUNBjvRBxoQycjX0sTpuNxM1wsFkqaltpZQqM7rdRpvi44Yq
/a6bGust+F0F5UhNiw6irktJnTb6sYbRaiXHar17uljj4bw4o//oMHdRROjr
ZQ0mswcK2P163+lJQb0YMlcoPE0VrRRL4vXM+XThcot4q0Q+OyPY21GuZko2
1mQHZarNKNlhnio/hL7foZxI5UWEMW66mNvZ8pxA6hud99KCOJLldDfJ/17h
m8QCvDP4JRg5t8OcbjagigtM4YJq2cD3Jv/wAOc0AbhG4HKSzH+r9ZkSgu8X
RA085xEeqFkIKQ+mZYih+nj7NonrZZ6mSea2LodlyWAPa9J2OfxxR3GWLj3P
VLQq4R+iAy+y1U856p+dIVFBbs/5ml0VIleJ+HEUHKNy/xgRmmh05IU7B4Rj
eiKR3yJe+2iRoRGMWB3yk/aFT6TTZ719/rMXU49KMDgOGdC/jsM4RswX08s4
E0YW5RYURV2UQL9GvwqNcde9se9LwmrfvjC9f2l456iNRRrjMKY4f12sd/SH
VxEfXxsTHA0JHP1n38MYhjHR/yQJoItnaj95m74EBEZT2cmAzSzqWAqen4w7
SwML08GzaUReKkiaTjrPgIpSCcsZZEkmVJ1DVWfT5Nmw0xTQnxyPy1zERRZM
kUmJ/hq0n0tX5SE0eYyIb2H/8r1UZe6VZgd2AbDADKyzAM0FKEshTlgIKS5y
bbFCSqxwSbFroQViLSEVFRPkJfCyUvfSMkpjk9tGE9FWTjNXOPwt9+ywwX9X
OpirgP0VqN5qJ3MlurrGZboGa6kFWuohljo8tw5YbvNcqscP1uKKGpwnGggz
jS6jVWhrM6RyCG1tIYtbIFe92L1W8mobxdoK326nlba5Kjvgtg66rdPzphvA
6gIwu5C2dvhANyqkk97Vg4zsYbF6nRomePPNpIrvDhX9vvp+VFIfq3uAXTvI
LhhAGYb8kgdxnGE0dxh0OwKqG8NXjXKHR9G9fdiUMe74CCZ8HDMyzkudIGjy
6fxJ7N0UeG4KV7xCEMy4zMwSr2eIk9PYtFlB4RyuZlowNSdMnyctLOFXFgn3
i9CyA0r9kjhjWSxawDfPC1uWyeIF6OKKRLFDlq4RM1cpW+ukpg3Z2gZRtgaL
2qRmbcoe1mElW6T1LfnBLuVxF6HcQbStSnb2yB379PZtefY2rXVPmbuv3D1Q
CSbBT0ceMYeqnD+BRz88wo4ZwUe0419ez8delb/9kk74ySeA9DNw2pk09RTU
+dMz41yRcirKPIdmXaizL2B5h4zyv8F5l4jcS03+v5CaK2zvVXXTNXHmurHr
BtB9wxy+BcXr7EduOVN3/PUH6doDbPFeNHkH3nlELNxDdx8VOU8eR0/q42fN
f74JpAU=
            "]]]}, {}, {}, {}}, {}},
       VertexNormals->CompressedData["
1:eJyFmAk4ldsaxzXdVA6XqI7O6SDOrlCEIltvSAOR0qSJDEmTJk2SVMZ0NUgp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        "]],
      Axes->True,
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], 
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxlW3lclWXTxi0tcy93zLUX9+1VwY7e6vflbvFiiiZuqLl/5lpaEYZ9mpqm
5k4mZC5IrrijN6am4pJ7CoqAICKyHDjAYT2vPHPNHB/kj+7fmd94zVz3MvfM
3E9NfGd5TSrr4uJS8+V/yrnwX4ZyKfXn4fl38KyAZ6phbYvXsTUJMq6cW9mv
fve/VJ2Gi1euCEiXsdBR8vdY7x084tmioymKxwZtvfrk1EjT9srL5+1+clfx
2BByG/2WsbxhPVbvpn8v49ewW5fsaR67wc/3yD/No4nXzoPhPM5peHF2w4vW
1/j6JF1ODbOkqBHLww5ciXoqfKu2bjl0+KFLamu1XzraF1uF7+cGTpzuMCxj
7tnINOFbrd7A3r+HZWjdsvKkAV73hW91yE+SXPguAE5bwhG+ha3IbiDZFb6f
wk8f8lP4mngFHha+Ce6rnrivynqN77d+593zs1PV+uI21WKbJQvf1fF93da2
uqJar8kLbNUnS/jGGzhPdHS7846A9Azhu6bB9PEfj8vU3/dbOex5RJTwXQu5
P8mFbzJwHhCOc31htw3ZFb7fwM9N5KfwNfFae0T4Dh9W8pf9Gt+byx+f/dU7
Q92c8/tM24wU4Vtjy8Sia8HX1KmawyuNLpstfIcaOInatfNPH+5amCl8azVa
uTivsk0PnlSl74r2j4Qvy/uSXPiOAk4DwnGu72aTXeF7A37eJT+FL/MqU0Jm
2THhe2l2ycLnvsZ3wj2fyX3CrKpKkuvVSkdThe9lt97JS6rcUAN/PjR39Z85
wveCgZOkx3XzWRFZziZ8f278R9Bvx7J1zYBVXdtseyx810P+NsmF73XgjCEc
4XsGdgeRXeE7Hn7WID+FL/My+PqdEL7dje1jf42vrUnU24nVs9SAURtauTrS
he/y8jduBw+4qaLerfb47Hd24dvNwHmmgz9wu5n6Y7bwrd3s+tkhE3L1jBtL
1332RpzwrQP5VJIL317A2U44wtcPdqPJrvDNgp8fkZ/Cl3kZfOedEr6hISV/
+a/x/f+Z3oeWzrSpc5OXnq/b3Cp8B8WOORPx/S01beP0gbY++cJ3j4HzXCcq
W+0adXOF76YW6XG5VfO059hLlY/1iBe+myEfTHLhexg48YQjfHvC7nSyK3yX
wM8L5KfwZV4G32mnhW+jkjA2u/A1vnVO3PFuFZmt4oLOZQX3zxS+b4en7o45
e1vl17105P1yhcK3voHzQrv9b4TPv4PtwreeW/WywSfzdee0Sksqzn8ifOtD
3p7kwrcFcFoQjvAtPmWyK3xrw88E8lP4Mq+Su9dlnBa+P5Usu3vxa3z3lPcq
uvp+rnJEO5q2nZklfK9t/HpdYdEd9cOW5k1GnisSvisNnDQ9rf/KYO82+cJ3
a6uOTQd/VqhrfzOg0Ds0QfgGQl6T5MJ3E3AmE47wPQ27y8mu8N0FP8s+NPwU
vszLWN+9EcIX9HqV5kv5hh08baXyjXvg6SiVb6Qj3ygolW8UI99ILJVvFINn
Yql8g++hglL5xj3kG45S+YYd+YatVL4BXjvPCt9t7ef6bj+dru5viXxhr/+P
yoY/dN5jVapn83bbeqWqEPgfuXVw/5qxydri+eXi3kcTVSPMg4ehn0F2goIt
hB9kuQL97qSvMW+6M/CthK/3gRf7c4/80VmYh/9s+fQ/i5Zb1bbjgx5t/uGB
+EnnNF6daBPjM6dVhviZ2qnfOu/NL/TC8xmPhzmSxM+9hn4m+blxh/iZBv0F
pC9+7gD+KcIXP9mfQPJH/LwV+NXs5l2z1MR7V691t0eLn3S+ElRBh5Dg9S/v
E/azemTvmECvdH3EfWrPaf2fi5+uhr5NG/vzx53iZw3oHyZ98fNd4BcTvvjJ
/viSP+LnJ78GrrkeZ1OtbUPORH8WI35u7rDtHWsFq84MjQv0W/NC/FltnJcc
8idgt/izBfrppC/+ML4b4Yvde0GnD375Y46yL5vsfWZarNht/XWDk+t8M3W7
Jp8WrI1KE7uGPRc72V0YInbbQL816Ytdxs8lfLE7YkfMzaYedvWwzu6/qwbH
id3wi5vGdtVZ+sjA5NDbazLE7lwjX80ju7NCxe5p6IeRvthl/CjCF7sPdjqs
VxPylN75rN/YB/Fi96NatSs8aJCt7yxp8XD0UavYTTTyxgJtxOFJ+8Tux9C/
Rfpil/FPE77YHbWncc0vfipQwV1aRuyvniB2H49ZF/LVlzk688z4ys+iMsWu
t5G/FRl8/dseELux0M8gfbHL+NsJX+w+3Nu7UxNLkVpyfqq7S/9Esft5SHXP
RndzdfW8X7rPcWSJXcqjHMZ59Hc7KHZnQ78q6Ytdxv+O8MUu6jWxxyPij0L8
kbiNekedQh3E+ohjr913tA9j5dzy2OvjLVPcF1zUd66nFcQEZXD9h/0Tp9qj
/mJ9f6oTOV6LPuV7sToN8ZbvC3eqHzXPF4+jqM7So1APstwF9wXPI4+ov0ge
+JvIUUfL/PI4ELxuEy+Ne02jDtWoQ0X/B/BiPR4thKMwP3JP2ageVxyneJyO
eeuMepPlvL683jya1ivokNxrvL4nUM+yPuK8QpyX/YB6UC1Gncj7IeKN4z3m
pV3WEz0HTa7hmynrRef0iYpCvcnrS3lsvOb7iNfRj+pEvRH1LK8X6kRal7W/
O+9N2J1AdmU+URdr1MUy/+Gkr+CnzPMj+PkQ9SzPJ/P9FvUvzw/uF4X7ReYH
9aPqj7qS56f3mbs1D3x2VWfd3HXrf5raZH4ov03QhbjveB5Q5+o7qHN5HlA/
UrxdtkvmYbAZX+aBcVAvyzxYSF+xPs8D+/8h6l/mS3ngU9Wzy4Jnx3tmyTqi
flRVUVcy37Pzs5JSYq7rgKHley6Izxa+lN8+1Qo4zNeX6kddHXWuOe7lEl+/
PcL3uhlf+KJe1qiXhe9S+N+b7Mr6sv+VUf8yX+qpPVP+Hn3aPbxkE76oH9U0
1JXMN2jDsph1e2/oWnfH7dkdnCt8i43zm6QXA4f5os7VQ1DnMl/Uj8R33l7h
uwv4NQlf+DIO6mXhaye7KoDsCl/2fwrqX+Y734gnyepcj6rzHF45whf1oxqC
upL5jp9T5/LBpJv6t+Gn34n2zRO+1E9L1ueBw3y/p/pRo34Uvqgfie+0P4Tv
FOAHE77wRb2sUS8L36nw/y+yK3zZ/0Gof5kv6kTVAfUj80oy4kCKqtAn6kTT
R7kyD00+2nn472a3def79fyrNCsQvtRPS9FvQJ/5os7VT1Dnyr1E9SPlLeP2
C9+WwO9E+M77ATiol4VvNPx8k+wKX+bVDvUv80WdqGqhfmS+I414kqr6993p
+HBynvCNa9llW+rYO/rPkQtS1JNC4Uv9tFQ9APrMdzfVj7oM1Y/CF/Ujre9e
Z76UDPyzhC98US9r1MvCdzD8HEx2hS/zqoH615znFIOnM79CHvVa3hJpyNPV
8oFzPpxqzZd5CKpwflnlwJd1VfSt4XN+K5Z5oDyH77MC0T9POHoFcPaa8pl7
iLMOwaG8xY68xVYqP3GJwD0t87YH/niSPzJvqLsxXzbnfQdeP5I/Mm8/wB/U
4854QvU48o0C0X913vzdnHUxz3MW6nGe/yHIZ5AXSb3fA/nbc9SzXKdfx72M
e1z0DyBPOI66kvU9zfeX6DfFfZqP+o71UX8p1F9yX9+ie0TxPcU463FPWXBf
ME64WV/uTdRZCnWW4IdQ3FaI24Jfke4X/S3iM+Nvgz7uEcFHPaVQTwn+dIqT
CnFS8BciDp9FPGT8MdBH3Bb81hR/FOKP4LxAfCuPOMM4jaCPeCg4L+hcK5xr
wRmDuNEX55dxHkEfcUZwQmmfK+xzwbmB87UM+5lxfoE+zqnguNC7j8b7i5y7
tyDHe5Ds/8X0fqHxfuHMWyDHe4roUz2YqPh9geNAGXqP0PwewThVzHLB+Qg4
7+F9gc/dZerDq7Ho5zP+WerDa/ThBf8i5HgXEHwNHF/08xnfQn1vxf1zxl9M
fW+NvrfgL4McfXjB7wic39E/l3qF+swqAf1qxu9NfWaNPrPg94ccfW/BDwZO
EvrVjN+Y+rrqX+gPy/xTP1lzP5nx3zTLBb8WcFqhPyz5P/VR1VT0Y2X+qY+q
0UcV/EjI0dcV/O+BMxP9WMbvG//cLejoP/rz+71PnByQwe+pxv0S8Uco3sGs
/A6q33aZUa9PiyidGeX7YGK21ay/bT/ekbJE/4Fr6ptP1j1Ucx8F5FUNyuJ3
XHWT5Jrlr+LE9uP3GZvgbP/g//IDyj5Wtsc76p0YnC04G0musyF/FWdcxCG8
e+QIzuHQL+avPR6rFsRf8JhgzxGcfSTXX0Bu8sc9DO8JdsHZ8MHx1Pj0OGVP
eDqyyg674Kwhuc6D3OTPwSPo0+cLzsJI+6TO/3qiFiVVXHTs43zBmUdyzXLG
KcnbYlseCzfyN5dCwRk90iMmYEyCKkh22zK+oEBwvEmuCyF/FWdc8PHweUac
LhKcC8MqDt8f9VyldvOv+8XL/AJ9DRWJdZxH66Vd8e5u9KEarbNgn3BfQ/Uz
7yvuC1D/qN7PdOzdM0XfbXbrIGvqfX1gpNfl1e+Z95X/O+st2Fei39Ksb8Lv
9f6+cOALryrmfWv2p9oGym9cbIKfuip0zVqfaN3JZ26yx5VMsz9vbbRgf4p+
mlnfhL99xQG8Vzj3823z/hf9hm1cK+ny19SITL+ZnmuddfGp0Lbfdb7ySB0e
8/ObCQtssr5lI78NO9csVfkFFJ2uN9oq62XwqrAJ/aRs8fMw4WjGMfFy2WzB
eRH9MLO+iVfj8ofwHUS28NpsPo+ivxf+hwGH989qnOsc6LO89yRvj+cNY9W/
xx9puaqp85z27GmveX9Guqr+96IJ4ScyzXwLNluoT5Mr/lsIR3cBzqv73z9n
iwXnWvR7mPXN6/j1YXwHkSt895vjhui7w/+uwGFeIYg/X0Kf5c1tGw92/yRO
HZ1wb4D79Vzh22PkcfecqAwVVN9eaWxtm/A11su6FecuT/x/j3D0MeCY+L4I
tCD+iH5js774X4LfODsM8T9P+K41xzfRrw//jwOHea1EnGR9llcMuN9yxYp4
5f5Z7tT4hXnC1+CV9AvOe4H4WZb0tQf0Tbzit1kQD0W/nFnfxGv7zKO4pwqE
13xzvBX9ou/IT8Zh/2chbn8FfZY/r1EvOPrPJ+rElLrLV7YoMPN69CvihtPP
RNLXJ6H/6nnsNWO7BfFZ9J+a9c3r9fQY7k3nvTDCHP9FPxZ+ngIO+++Fe6QI
+iy/vn1k/Tb5CeqD6R4hXW8WmnhFJG9H3CgWPy+RvrZAn3ldNsvN6zLmBO7r
YvH/T9jtAX32pyPipDfFScnPZ+2rM/5Wxww1Nc5rbsv7fyn0u1WbzlFTC5sl
KpecH7MjOibLOZoyNOSA57f31Kh9vl5XktKElxFPmq21GNM/O0N4GcPONRbT
75dja8LXZYDP371NIHztQ/jCt6TKVV32hgNf+PrAn9HQZ74p6B/wb9mH4Dud
+OoV6O+3o/tR7cd9yrxSN33ef5LnZeVoP+9q+Uznd2hNoM/3KeNn072mOuIe
ZJxZnqtcgy5dUasO3ujW7ZDz+66n0Od7kHHCCvZY/Wo51ObwyeVqpdyVdVHP
Fg6/sz5RffViwMnKu4oE34Pk+mvIef9srDjzr5/72/QnRbPy+raxa353KZm9
2PonEZ8dMp9sdyvZlfmpiv75MbzP8vv7KeQ/Vsp/tAI+3ltVFt5PWT/nMt2/
AXT/in4r1OMd8O7J+p1wf71L95fon0J9fRTvlazfDfF/F8V/0R9C74zqLt4Z
WX/YOttkf4f1Zbyav6/M3GzRj6H3QZWF90H53u9ah41vNc9SVw5mDt3xd47o
X/mo54qVX71QDYz9GasceAcynwfnXy72J68fj77m/S/rOBb7lfcv1y84pxrn
1LS+LgtDwnldeZxqxpF6R1H+qTj/5H3I+5T3AY8VKD9UnB+yPt5zFd5zpe/h
g3nuTPMs8QTvsArvsKK/CPN8nuZZ9Pl7FPTD5FyUsOs1OQj5jEPizAbs/2G0
/yXOdDefF4kznXG+voGceb2K22uys582GPM2C/Ugr2O703Gj+71zSbmnX9iQ
UsMZN2ph3qyoB1n/wDxHp4CVkerS503LNrrl7KfxyDx55L4jzwuPMxDHeZ/w
v3fF/mX+POK7FP0Pvkvh73MiaT9r+l4jVuOdWGea36VlHGW2K3n4JbxT98B3
MnyOruK81AN+Pr5jfvW8+DdzvntGm+Ow4I9CXF1NcVXkeGdXeGeXfbV1UGLt
zKEFykjrVqXLOeXvmRzop7LcvJ9Kn99E/u5J1tGKvir3Wfn8RtP7vl6K7wfk
ez/yRz+HP/SOFav2oJ9bjvMzyPGdgA7AdwK8XkcobutViNt+pvd4B37fEzn6
15r72ea4cZK/F4vguDEL84nvHGQdV9P5UqNwv3A8rI3+uAI+y/n8roA/HE+4
787zzqO11HcQPP6CfRuN77t4Pi9j376HOGyezxTNv3nEORL+PLqaz6/sq+bI
iyoi3pr5Jij+zWOg+VwLDu5lhXtZzi+/K2BdTPWafPcg3/Fl4Fzb+D1BzjXu
cb0R+cNS0/8/4NBLET9ZvgX78CntQznveC/B74xScUD2ucSBFJwLV8g5fgbi
3MUAn897KM5dPr4rZDnyQt0K9xu/j/C9OBH3JL9fVBv61s39FdLQ340TP/Gd
H77zdcaxGqSP97E4sZuO71S6Qp/l/wUc4VEy
       "], {{
         {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmgn4z1X2x+/9Vsq+FBFCWoyhELIl0pSKFqOFUZYWMWlTtIxQKjUqkqXM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            "]]]}, {}, {}, {}}, {}},
       VertexNormals->CompressedData["
1:eJx9enk41dv3v0p1lYabJjSnuERoQicrDShKGkSDSmkUMjWrUNTNlDRIaKKk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        "]],
      Axes->True,
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}
   }],
  "Grid"]], "Output",
 ImageSize->{312, 261},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->755068046]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47795903],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus in on areas of interest: "
}], "ExampleText",
 CellID->40133860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1.16", "^", "v"}], " ", 
      RowBox[{"Cos", "[", "v", "]"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"1.16", "^", "v"}]}], " ", 
      RowBox[{"Sin", "[", "v", "]"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"1.16", "^", "v"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", "u", "]"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "15"}], ",", "6"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->707088999],

Cell[GraphicsData["CompressedBitmap", "\<\
eJycvQV4HMt27+t3IDnh3JycJDc3uckNJzcllmVZZqYRM0PNjJiZcUQjGDEz
M1nMaFmWJdliZlkWM8363utuSd722Psc7+dPbk9N19TU/1er1lpV3WrTdKz1
6SY61gZ6Ov/42FLHXN9Az+ofH5lZEm/9/P+5cuVKIfF39G+uEK//X+IV9bcQ
AK5csSWOv6DT6cJUyZo4/owo/Zws/Zx4AdSfK4LUWQviSL75y4taQtS7Zhel
X332GeJ48RmTi7N/+M2zhhct/jFZ+sWn7yNeCFDn9S8+/Wdk6Zefzl+0wU/V
oV+08T9+Sx29i3b+kkfXz3jK/03V1r5o8a94zvJS+b9Ubc2Ltv/nd9VWu2j7
f/Gc/QVP+b+o2ioXbf9vnrO/5Cn/J1Vb8aLtf/yu2vIXbf8zz9nf4yn/B1Vb
5qLtf/2u2lIXbf8Hz9nf5yn/O1X7xUXb/8Vz9lc85X+jaj+7aBt9V+3HF23z
85z9A54ypevKQ/jMsj87+4c85X+hat+7aFv0d7R9XvvORdvXfkfb1HhcuXnR
9nWes3/EU/4nqrbERds3v6v2tYu2b/Oc/WOe8v+hal+9aPsez9k/4SlTVndF
+KLtB99VW/Ci7cc8Z/+Up/wPVG2+i7af8pz9M54yNVuouUy2/eK7av/nRduS
PGf/nKf891Ttf79oW4bn7P/gKf8dVftfLtqW+67a/3TRtiLP2b/gKVMehCJD
vqn8XbX//qJtNZ6zv+Yp/y1V+28v2tbgOcvrRSnPd+VvLtrW/q7av7loW5fn
7G94yn/zqfaVnxNR6+Jdvd/xqb+mPvWXn32KjAX4+z/1i0/fRZzm/TbeuPBX
P3zul58+d/GdvPr++lt9+KKn5EveuCRNHv6wrw26mqCxBl6WQX4BpGVCTBIE
R4F3MDiwgNfLf9838UYparb8erkfZt/CaDf0tUNXMzTVQmU5FBRCehbEJkFI
FPiEgBMLLFyBaQsapqDIOLvQ+7ffGv2vvpU32lEz+jd7w7AxCCsDMNsHo6+h
vxNetUBLHVRVQFEhZGRDXDKERgMrBJxZYOkK+ragaQrKjFN5zWPyu3lj6q+/
+d28nB6Rh785HoPDMdgfhc0h+PAe5vphrAcGuuB1K7TWQfVLKC6CzGyITwZO
DHiywYUFVq5gYAtapqDKOFXUPCJapEnu8Or/dh94o+Z9oKb/BPd0Ao4n4HAc
DsZgawRWB2F+AMZ74d0r6GmDtnqofQklxZCVAwkpEBYDXmxwZYGNKxjZgo4p
V4NxqnLZE9rTddqDFd6s5C8+9ednRHd4Y+ZdoBzixAlMwekUHE/B4QQcjMP2
KHwchoX3MPEW3nfDm3Zob4C6SigtgewcSEyFUMIK2eDGAls3MLYFPVOuFuNE
TfOQ9KiS27Sna7QHy7Tbc7y9oTzghff5gQ5vr8jISQSMiSOYOuXOwOkMHM/A
4RQcTMLOOKyNwOIgTPTB4Gvo7YCORqivgrISyM2FpFQI5IAPG9xZYOcGJnZA
N+XqME40tKiO0bYlLztGuz7xN9/VN97Yfos8/DNM7MPUEcyccmfhdJbq3jQc
TMHuBKyPweIQTPbDcA/0dUJnEzRUQ0Up5OVBShqwOcBigwcL7N3A1A6YZmd6
zGMtrYOL7j1Zk3ywRLs9S3SPJjpMExj4alb/+Td7yZtT3CAP/wrjWzC1DzNH
MHfKnYfTeTiahcMZOJiGvSnYGIelYZgegJE30N9FTvvGasrT5EFcAgRxwJcN
nixwdANzOzAwO6Mzj9WV9onvkKJtST75SHRU8qKjQzSBfhrq+cpPfruvvDkK
lfH8G4yuwtQmzOzB3DEsnHEX4WQRjubgcBYOZmB/GjYnYXkEZt7D6FsYeAWv
CC9VQ3mpfIiIhmAO+LHBiwVObmBhB8Zmp/rMI3WlvR+6e5/o7ozk9XFJ0SEp
/rdEd3nJ/tk3e8ubI1HZ3H/A8CKMr8LMJsztwcIxLJ2dLcPJEhwtwOE8HMzB
/gxsTcHKGMwOwngfOZ27CddWC1XlkJcLkdEQwgF/NnizwNkNLO3A1OyUoXd4
2eFNySerkvcXJW993uHXNNTB2+c//WafeXMvMqMjFhiDMzC6CFMfYG4TFvZg
6RhWzs4+kN0+XoTDBTiYh/052J6BD+MwPwQT/eTUv/CHFZCeDlHREMqBgEDw
YYGLO1jbcc3NTvTUD9SVdnm7LT4mKTr4qds01MxrG9/uOW8eKEIe/hsGxmF4
BiYWYPYDLGzA0h6sHMPq2dkqnCzD8RIcLsLBAuzPw/YsfJyAhWGYHCDdw7kL
ramAxASIjgYOBwIDgcUCN3ewtedakp3f16A6L03boDq/IHlrmui8rFCfFH8v
DXXTUDsNNdFQLW///+Sb/efNNal1BR/0DcHgGIxNw/QCzH+ApQ1Y2YXVI1jj
nn2EkxU4XoajJThYhP0F2JmDj5OwOAJT72Coh3K99VBRTEqIiYYwDrApCe7u
YG9/ZsI4oiTsnEuQevLht0igoZe8Kijrvsgdf1DBm6cKnqt4NwgjYzA5DbPz
sLgCKxuwugtrR7DBPVuDk1U4/gBHy3CwBPuL5ECsTsD88IUVnQ9EIeGhEyA2
GsI5EBQIvizwcAcn+zNDnUOsvneh4sU6oULq/oLUrSkF0QFKxZvvVkHGON7c
lloJCsBbImAMwtgoTE/Bwjwsr8DHDVjbhY0j2OKeEgI+wvEqHH2AwxXYW4TN
GVgZh7khGOsj3Q0xe1trISsdkhMgLhoiOBAcCH4s8CKGwfLUUOeAEKCpuK0k
s0nOhMcrUvfnLwW8lSQFvKKhNhpqpKEaGqqgoWKyl+QGyJ98cwR4NfCdD8PA
Wxh5D5OjMDcFS3PwYQXWN2BjFzaPuVtwug4na3D8EY5W4YDQsADrM7A8DjPE
sPWSoegVEYpeQlYapCRAfDREciAkEPxZ4E1MZcNjI+0DrLb7hYZ787ISYwqi
/T+ioYiG8igf/60dpD/6pi7etcF/n0+SN93w/i2MvYfpEViYhJU5WFuBjU3Y
3IPtY+42nG7AyTocr8HhR9hfht0FWJuGRcIW38HgGzIJ6GqEqmLIToPUBEiI
gigOhAZCADE8rlxL+qGR9j6dkqYss3EpbU7l2rsLaXw9NNRFQ6001EBD1TRU
TkOFNJRLjgzZVd788dvKeNcW/3Xuvjo7oO8VDL+FCSLHHIHlSVidh/VV2NyC
rX3YOeHuwOkWnGzC8TocrsLeMmzPw+oUzI/C+AC8fw1v2qCjHkpyIScN0hIg
MQqiOcAJhEAfcLM9vRS3o6m4dSluWfpcnEi/rGAvjzhJVHwujoYy/uBCH2/2
9W19vHPuP8/1dbfB+y4yJBPeamEEPkzC2gJsfoStbdg5gF1K3zacbMHROhxQ
+jbn4cMUzA7DKBUWe1qgvRaKsyE3DdITICkKYjgQRgyeFziaHBP6jLX3CH1a
pL510j88Xla9MawiRujru9TXSUMtNFRPQ1WX+nIIfb93oY833/i2Pt7ISu1U
XYX2JuhthaEuMieffUcmTB+nYWMJttZgext2D2Dv9GwXTndIiYfrsP8Bdpdg
Yw6WJ2B6CEbekoua103QUgkl2ZCXBhkJkBwFscQQ+oO/OzgYHlnSDy4lbl5K
XFK//l5ZbICQKENKfP0jEtNpKOlnFyp5I+e3VfLmvP92rpKYPv0tMNIFU73k
+mNlhHQdW4QtrsPuDuwdwv7Z2R6c7sIxoXIN9j7AzhKszcLiOEy9h+E35LKx
uwFqS6A0G/LTIDMBUoiBDIZQFvg4nBEqrUiVuwy1bUKliswa0QOle9OfqXzz
uUopVCJJepcCGsq+UEm/2O/9nQp5VxzUXtw1aKmBngYYbIbxLph5A4sDsDpG
jtP2CuxswN4O7B/CwRn3AE524WgTDtZg9wNsL8HqDDkVJwZg6DW8bYVXxOK0
EMqyoSAVsoihjIBoNoR4g4fFCSVy/1Lkhoo0KVLr5hAlsl9B5O2lSDIboqG6
L0Wm0VAiDcXw+n0qr7+Ixz9o5F33/vO5xo5qeFsPI80w2QVzb2D5HayNw9Y8
7HyAvQ3Y34WDIzjknu3DyQ4cbsI+oXEFthbhwzTMDZNZ6uAr6G2BrhqoLoTy
bCgkNMZBUhhEBUCwB7ibHTsaHhIaTbR3GGpb2gqfa3x3qbFHkq/7XKM0KrvU
mE9DWT9R49/x1KL2Jq9DYzm8qoKBOhhrhukuWOwhF+8bE7CzCLursL/JPdg7
OzzhHsHJPhztwAExth9hhwgmC6TvJZLxsV543wlvmqC9EmoKoYKQmQKZMZAY
ApG+wHbmelAyrel7Jlo7TFVC5rqK1Colc/BSZu+lTDIluZRZeCkzlYYSaCia
hsJ59+R+ktKWMnhTCUM1MNEMs12w9AY+DsHm1Nnu8une+sn+zsnh0ckR9/QA
jomB3YK9ddhZJecsMS2XiKD/DkZ74F07afXNZVBLDGgmFCRCRiQkBEGED/ha
n3qYHTkaHFjjc6Wb2nJrKrSVc6VqpNK+S6VE3G+XRpXSqFQKFVNK875UGvbj
SsmMjPdqBrW7KwEVRdBRCn0V3JEamGqGhU5YectdHz7cXjje+3i0v3V4cHB4
yD09guN9OCRm6CbsrJEKNxfICEIk+VP9MNINA63wuo7EVZsP5emQHw/p4RAf
CBFe4Gd94mF65ESK3DXV2mYob2jJrKo/nb8UOUCIlCdFvqaRIttkUPmXIjNp
KIWG4mkoioY4X+2xfns8edVS5RvkEHSXcN+Vc8dqYLYZlrpOV/t31ycOdj/s
723uH+ztHXKPj7jHh3C4B/tEaNmALWJ2Em52BpaIZeR7MgINdUJfM3TXQEsp
1ORCWSrkxUJaKMT7Qbg718/qXO0+odZEY5OhuKYltcK4P0qpfX+p9s25WknU
9KXa3M/UhhNqaYjN63G/rfcfeGr9/bnepnx4U8QdLONO1HDnm4+WX2+tDm1t
Le3ure/s724fcPcJscdwuA/7O7C7CVsfyKHdmCdTCGLxOdVHDu27NnhTD12V
0FwMNVlQmgS5UZAaDHEsCLE/87M69jQ9JPXqbpuobTDkVzVpS1/qfXupt0sW
vZRBZdKoRAoVSZJOl0yBaCiZhuIovaE0FPh9enmvtlHe+CaU5EB7HrevkDtc
xp2q2V/o2FjpX1mf39r9uLW/vb5/tnPIPTzmHhKxdA92iOxv9WJ8iXxiaZSc
r+NvYJDIFhvhdTV0lEFTAVRnQEkC5ERAKhtivQnJpxeSmbvW2lvGKmt02RW9
pzOM+yOXkvsvJXdTkiu+lJxzKTmCmLKU5ICv1nrf1vx/eGpRu563oDILunK5
AwXc0bK96bqPi69nPsysbK2s722u7p9tHnD3jgjNsH8A24Tgj+QYby/D+hys
TJBjPEmsZl6Rgntr4dVLaC2C+hyoTIXiOMjmQIo/xHiQmv2tjjyN9x3p21aa
G8ZKq3TpZYNHY/QLze8uNfdIC3TLocrPNdMuNJMJxKXmEEIzDfnwXuX5tup/
4qlFZU+3ITsd6jO5Pdln7/PPxsuWZ9tHlyZn1xY/7Kwv752tHZxtHXL3jwn7
plSvXY70IpnWE8v6mQEYew0DzdBXD2+qoLMUmvOgNgMqEqEoGrJDINkXoly4
IfYnfhaHHoa7jnpbVuprxgorWHKREj5MdEiTFN6nJNYrL9wjxdf1ufDLSJT9
pfBgGvKnIe+vxpva37y46vWD8n/hqfXX58qJjKAlndubdTaUPzHWODXXPfph
bnZzdX7vbGX/bP2Qu0PIPiZz/631y/FegvVZchU6R4TebhhsgYEG6KuB1+XQ
VggNWVCVAqWxkB8OmWxI8iGUn4XYHvuZ7XvobzvobFiqrhrJLRs+mzR4NHqp
fEBNvE/p6hs5wW5Z1CCHXsqicpkf3Fj+ZToV+aVyr+9U/q88tah1zx0oS+F2
pp71Z24MFQ1Ntg0sTo+tLc/sni7un60enG0ecfdPYJOQvXEx4NtUlFqdhIUh
GO+GYWKV1ERmLb2V0FUMLblQlwYvE6A4EnJDIN0PEjwhyuk0xPrQ12TXnbHl
oLVmqbxiJLNo/HT8B+U3BlTF3yqK9Mjyd8mjqnPl0t9Wfu7Ag2jIj1BOQ668
9v5t7f/GU+s359qrkrivUg7fZfYMNnTPTbz/sDS5czq3d7Z0cLZ2xN0jhO/A
1ubFkBP59DYVswjhE90w2gHDLfC+HgaqoacMOvKhMROqk6AsBgo4kBUIKd7c
eNfTSIfjYMt9X6Mdd7zhoLFqobhsKDVPan84Sr83RGnvVxF7oyDULY06CO2U
M+fRnkVlIp+0s2nIl4Y8acjl+7T/O08tKku9y02Ph/oE7uvkqf7c1unR3uWl
sZ3Tqd3T+f2zj4dcYnm7uQtbWxfjvk25N2JRsTgIUz0w3gmjrTDcCO9r4W0F
vCqC1myoT4XKOCiJgLwgyPTlJnucxjodR9geBJvv+hpsuemu2autWMgvmj2f
NH4yrv9whJCvc+sd0S1l0R55gS4FVCN3If9zx5734/Kdv7qi/W39vHduULnO
XTK/aIk7602qHR/qWlwc3j4Z3z2dI4yemOuE+D1qrlNjv71Kjv0mkXwOkgus
qVcw3g6jzTBUD++q4E0JdOZBczrUJEJFFBSFQq4/N93rNMn1OMb+IMxqL8hk
m8XccNNetVdZtpCdp/SPEfrx3UHtG/3kclG4W46PGPtqHid/qT+GytE+BbZA
GmLRkMdv10/mprz3oFBe4h6URHPbY950p7fOL77bOh7dOZ3dP/twyN0+5m7u
w9bOxaBvU2sLUvR7mHsLM69hqhPGW2C0gUzc+8qhuwDasqAhGapjoSwMCtnc
bNZpmvtxgtNBlM0ex3w70HCTRV9z0/xgp7RoLj1r9nyC1P1gWO/2Oy2Jt0S3
FAWJQa/7Ed2539LtQ0PuNORAQza8u9HfHnleAn9+TqAyktsV3biw2r91MrJz
OrN/tnLI3STkHwBp89uwvQE7H6kV5AwsD8JiP8z1wEwXTLbBeBOM1sH7l9Bb
DF050JIG9fFEe1AazM33O83yPE5xOYiz24u03A4x2QxgrnnrrrqqL9spzFtJ
ThEEjB6PMO4N6t7s1xTvJbqlwN+hgGq/RSCfSt4+J3AR3n8igf/LU4vaS7l/
HBoJdeHznVH9W6cju2fT+2fLh9wNgsAhbO2Ruz87G7D7EfYoAqtDsDwAi70w
1w0zHTDZAuPEUrwa+kuhJx86MqA5CWqj4SWHWxx4mudznOF2mOy4F2u9HW62
GWy45odXvbSWXVQWbeVmCQimz8YMHw7T77zTkXirLtZD9EwetVMQqj4FPGlU
LIUKKQixl3P/i1BPQ04UBOuvrkqcU/gzHgq891dRO9P3T2PDoZkzsH02uns2
s89dOuSuH3O3DmGbyGKpVQqxvt4nnP40eV2WWIsv98FCD8x1wkwrTDbCeC0M
VkAfsfbJhvYUaIyDmvCz8qDTIt/jHM/DdOe9RLvtaIvNMOM1NnPVV2fZQ33R
SXHOVmbG4sWEyZMRg/uD+Fa/9vVeNdFucjKgOsIDfkWhgFq0xH7pAT9RcKQh
exqy+k4KfDy1qMzwIQ1haYTP0kKP20JGd7mzB/DxCDaPYfsQdvZgd5vaYPlI
brsTIDbGYG0IPvTD8htYeAVz7TDdDJN1MFoJ70ugNxdepUNrAjREnVWFnpYF
HBd4H2a77qU67CRYb0aZroUarAbqLftoLropzznKTdtITZo/GzN+NMy8+07v
Rp/WtR5V4a5vsricE1+zOE8EnC9ZWH7lE3/1TRa899BRdzE8JVhIISyJsBLC
8ghDXvD8AXygcBB2sbMPu7uwtw37G3DwkbyYsjsDW+OwMQwf38GHt7DcDQsd
MNcM03UwXgnDpTBQAG8yoTMZWmLO6sJOKtnHJazDfI+9TKedFNvNOIu1CKPV
EMayn/aCp8qMq8K0g8ykNW3c7OmI0YNBxu1+XYlejavdKoKdX0Epu7SOhEtH
wQPF9xKKHQ1Z0JDxVzbybS5kjvgzAsOVP5BBWAFhFYQ1ENZBGCOsj7ABwkbE
SYrW83PLkaZQaSKsivC+awiUstcJWsQK4QB296jtxy1yr+rwIxytwP4s7E7C
1ihsvIePffDhNSx3wEIzzNbBZCWMlML7AujLhtep0BF/1hR5UhtyVOF/WOy1
l+u6k2G/mWS1HmO6GsZcDtCe81Gb8VSadpGbtJcat3o+YvpoyPDeO/rNPh3x
HnWRLmX+dopZrQKqlkeVcqRzJWbUuRUlfOlcP6UVLpRfIZjZ0pA5DRl9JzNy
LfVzkpk6wUyRAkHg0EWYSdEyR9gaYXuEHRF2QtiFem1LmZnsJWNNCrA2ZX6H
vmyoCti+tLf9bQrfGnnt62SFvAa/PwW7o7A1CBt98PE1fOiApWaYq4OpShgr
haECGMiG3jRud9JZW/RJI+eoOvCw3Gev0H0nx2kzzWY9wexDBHMhSGfWX2Oa
pTLlqTDpIjNuTxuxejpk+uC9/p1+LNGrLdatJtSphFo+h/iZ1eV+BfFTjHa5
dM42NGRGQ4bfx/AfLhn+miAgR01ANYS1Lu3O+BKj7SVDd4Q9EfZG2Bdhf4QD
iI/+zJU4PDuHTqfIEg0ehQY0lnuTlkhw3CQvZBxTHE+W4WSevPNmfwx2B2Gr
DzZew8cOWGmGhTqYqYSJUhgpgPfZ3L70s56k067Yk9aIo4bggyq/vVLPnQKX
zUzbtUSz5UjmHEdvJkhrOkBtiqU86SE35iw1Yvd8yPLxe5N7/fq33upd79EU
faUq0K6MGi9pVn1mj3nU1nH8t2i6fUbTmqJp8H00//flLNaR/nIW0z9jaoKw
JcJ2CDtTNL0QZlEo2ZfHEITDEI5EOJoC7UMNCdHqSazfwTYcbZBXLU8+wskH
OF2B00U4maPushqD/UHY6YOt17DeAavNsFQPc1UwVQZjhdyhnLOB9NPe5JPu
uOOOyKOW0IO6gL2XPjvFrhvZth+SzRZiDWYj6TMcnekgjckA1QkfxTF3mREn
2pDt03cWD/qN77xl3nije61bQ7hTha/1HCnlFkmfKPODdSZ+Fis+T6FcKbd4
jtSKhkxpSP87Z/nfU+XzSStNWhvJV+vTjP8xrOcWSphnMMIchCMomnEIh1Nk
YxCORzgJ4VSqzlka65i61H26CqcE1iXyxqaTGTiehONROByEvT7YeQ2bnbDW
Aiv1sFAFM2UwUXg2knP6PuOkL/m4J+6oK+qwjbPfxN6rZm2XuK7l2C6nmM4l
Gs3GMmci9aY4WpPB6hP+ymPeciNuUkOOz9/ZPO43v/fW6NYbxvVunatd6oLt
KqhJGTVQZHksNflLsp8Cjvsl2YsoTEMmNMT8EbLU1csrP/xLXiX4BWWtMp/5
Q8J/MqipbIawFeUzfwDKhwP4cDDfBdBPENMQzkQ4B+EEhJOpYgb1TihBdhXO
KCM9nYWTKTgeh+NhOHoPB32w1wPbnbDRAqv1sFQFc2XcqcLTsdyToYzjgeSj
3vjD7qj9Ds5eS9Burc9GmeuHPNvFDIu5VJPZRIPpWPpUpO5kmOZ4kOqYn+KI
l8ygK+2dw9N+64dvze70GN7opl/r0hbpUONvJZgqoXoq3eUx1aQfYer2GVM7
iqnxjzP9Ax5r/RlP+e8u/aveebxW/swjGCJsShntJ9KulDv43G45gjhCEMcI
4nhBnCyI0wRwpgDOFcAFArhEAJfyX4DPRzgP4SiET2fgZII02qMhOByAw7dw
0AO7nbDVAmv1sFLFXSg/nSk6mcg9Hsk8ep9y2Bd/0BO19ypsty1ou85nrdx1
ucB2PsdqNsNsJtVoOpE5FYsnIrXHw9THgpRH/OQHvaTeuT7vt3/81upej+mt
boPrXfhqh5ZgqypfM2G6hJMlABGmK0uabiFluikU6a/TJY/P/Ox56CfSJSMa
YvwI6fPbjM//kKvsX/wO8v/r0hfTP0U2dSrUE+T1KL9xnikYf+Y3PC59cRD6
wcbPjTpJCCeJ4DQRnCmCc0VwgQguEcblwrhSGFcJ4Up+XIxwKcJFVGXCwA/7
4eAN7HfDXifstMBGPXe1+myp/GSu6Hgq72gs83A45eBd/N7b6N3XYdsdQRsN
PqsvXRdL7OcKbGZzLGYyTaZTDSYTGROxuuNRmmMc1RG24qCvzDtPWr/L0177
hz1Wd7pNb3Tpi7XrCrdo8jer8jUSZq6Iaghsn8xckjRzHv6fnLLHl3HOhkq9
DElgvJn873+XpZ/ftUy7zK+u/EyJtHo5KrU699Zql/gNKZMnsgqHS5P3uwx8
4Zd++tytZCGci3AhwgWCOFcMF4jhYjFcLoYrxXCtGG4gfkRwvRCu48fVCJcR
iXA3d6+Tu9fO3W3hbjWcrVWfrpQfLxYfzeYdTmYejKbuDybsDsRs94ZvdQWt
NfksV7vOVzjOldjNFlhN55pNZRpNpupPJOKxWO3RSPXhUOXBQPl3LKl+j+e9
zo977O53W9zsNLzWyhBt0RVs1hRoVOOvV6LyCor6J5NP/Rb1cGrvzP0r6ma/
lTp5JK39l9+g/UvKr0h+Zd0Gl37lc6M+9yjneUUswokIp1BumnAeBXy4mA+X
8+FKPlzLj2sFcdVVXHkd117HDddx83Xcfh23ieFWUdwihJv48X7b6W7z6Xb9
yWb18ceKo+Xiw/m8g5ms/YnU3ZHE7fcxW30RG6+CVpt9Fuvc56td5iocZkps
pgsspnJNJzMNx1MZY4m6o7GawxGqgyGK7wJk+3xove5Pexzud1neajO93moo
1swQbtITbNQSqFfjr1XiI5LglwSYz4w69bOQGHfpVMIuCX+ebFifJxu/nfDX
v1fw5d0fFGl8HiXPVxl6l76DSI9tLg3Z85Mt8+FQfhwmiKOEcKwQThTCKUI4
QxhnC+N8YVwsjMtEcKUIrhHBDQRUURJt21XcQTC+gdtv4q6b+PVN3H0dv7qG
W0XIUdqqPtqoOFwtPljK35/L2p1K2xlL3BqO3XgXsfY6aLmNtdDkOVfvNlvt
NFNhN11iNVloPpFrPJ6pP5aKRxJ1hmPUB8OV3wXL9/lLvfF82u30oMP2dqvl
jRbTa82Gok1M4UY9oXotwVo1/molPnLNRt4xhAqlSFtO/xJ27KUte38J+2JH
5Dz/IGh9m/WvLqyZl/HfXGYijN9izbaUy7ChFiLuVFpM2jQfDuPHUQI4TpDE
nCyKU67h9Gs4Wxzni+MicVwmjl9exzXXcf25KUvgLgn86gZ+fQP33MRvbuG3
xM9d3H8H99zAHddIB75Wsv8hf3cxe2c2bWsyaWM0du19xGoPe7HLb77Ne67Z
Y7beZabaYarCZrLEcqLQdDzXcDSTMZKqN5yoORij+o6j8DZA6rX3s06XB22O
d1ttb7VYXm82FWsyEm1gCtfrCdVqCVarCVQq8VfIUY6agETZ9Oekz206gspH
vChf7f6trITxo6T/9BuEqTzkP6W/zPXOl20GVNL3KYu2p5Z6nlQqcm7LEfw4
RgAnEEmIEE4nDFkE54uS7rhQAhfdwqW38cvbuPo2rr+Dm+/gtju46y5+fRf3
3sVv7+H+e3jgPn7/gIgJg8Thet9d/OomruDDy9lb8+kb00nrE3EfhyJW+oIX
egLmu1hzbV6zzW7T9U5T1XaTFdYTpeZjhcajufojmfThVO33cWr94Qpv2NKv
WM/aPR61ud5vdbzTYnuj2VK8yexqg5FoHVOkVk+4WkuwUk2gQom/TI6vhDBm
AtDlxaxz3/y5MftcUj73zZ9v4Bj97LsZ//VlxsE8D4FKlyFPk3qhcrle+TwC
OiLshujeiO6P6MF89DB+epQAPVaAniiIU4VwpjCZaxSK4pKruOIqrhYjfXLd
TVx/Fzc8wE2PcNsj3PkIv36Eex/jgcf4/WM89AQPP8WjxM8zPPIUDzzEb+7h
Mn48l/xxKv7DSMTi+9CFPvZ8j/9sl89Mu8d0s8tUveNEte34S8uxUtORQsPh
XMZgms5AglpvpOLrYOlO/xftPk/aPB+2uN5rdrzVZCvRaHWtwUyszki0hilS
pSdcqSVUoSZYpsRfIsdXJI0KKNAZl6B5bJkH9LmLPt/1Mbzy46T/5MdI/+Lc
ms+XhtQ7upfs6eqIroPoTMQwRgwLxLBFDCfE9EBMFmIGIv1QPv1wfma0ADNe
gJksyEwXYmQLM/JEGEWijLKr9Eoxeu01eoM4brmOOyRIh/zqDu6+j18/xj3P
cO8LPEDDgzQ8SsPjknhCEk9KkS/GaOQg9D3CpQJ4PGpxJGzhffBcX+Bsj+9M
l9dUm9tkk9N4nd1YldVIudlwsdFgPvN9hk5fknpPtGIXR6Y9SLLN/1kr63GL
54Nm1ztNjjcb7cQbrK7VmYnVGF2tYoq+1BOu0BIqUxMsURIokuMvIPzzJezU
S5OOuYyErEsX/XWeR2Qc+j+N9e9TmYbUxQqGroHouojBQAwjxDRHTGuk74D0
XZGBFzLwQ4ZByJDDZxjJbxgrYJAgaJAibJAhop8tqp8vpl90jVkmzqy8zqy5
wWi4yWi+RW+/Q391l95zD/c+IMENPMGDz/DwC5LsmDSekMPTcnhWnjxOyeIJ
Gdz/DPc/xW8e4+HQ2Xfsmbd+U6+9Jzvdx1udxxrtRmqthivNB8uM3xcyB7J0
e1PUu2MVOyLl2jnSbUEvWgOetrAeNXvea3K93egk0WB3vc5KvMZMrMro6kum
aLmeSKmWcImaYJGSQIEcf54UXw4FN+1bLpn1Zfxz+TLZYP4ES/6rS7pY+iK7
oGsiuh5i6JN2y7RA+rZI3xEZuCEDb2Toi4z8kXEwMgnnN4kSNIkTNk4QNUwW
M0y/ZpgtbpAnYVB0w6D0pv7L2/o1d5j1d5nN95ltDxhdDxk9jxlvn9AHntIH
n9OHafRRKfq4DJ6UxdPyeE4RLyjjeWU8p4RnlPC0Iu5/gfuIn+d4wG+y13u8
232sw3mkxX64wXqwxuL9S5N3xfpvc3R7UtW7EpU7YhXaI2XbOJKtwc9bAh43
sx40ed5tdLtZ7yRRZ3e9xkq8yuzaSyOxcqZoqZ5IsZZwkZpQgZJgnhx/jhTK
ogB/bbq+XwE+d8jnW0dk2CP58t578Xuf+JIZxieuAtTag66G6NqIgRHDADFN
EdMS6dshfWdk4ISMHJGJOzL1QWaByDwUWUTwW8QImicIm6eImqeLmWeLm+Xe
MMm/ZVR4x7D0nmHFfYPqBwb1j/SbHuu3PdHvfMZ8/Zz59gVzgMYYkmKMSjPG
ZemT8vRpRfqsMn1Bhb6kRl9Sx/NqeEGNPM6q4p/1SeIrQm9p+I3HyCuX4XaH
wWab9/UWA1Wm/aX6b/J0X2VodqaqdiQqtcfKtUZKt4TRmoOfNgU8amTdb/C6
Xe92s87pRo2dRJWV+Euza+VGYqXMq8V6ooVawvmqQrmKgtmyfFlSKINCm0yt
QD5FOQ6F9twFf527kbHu57+VK6/dfpmxnftb0isYIqYZhdgcGZkiEwtkZovM
nZGFB7LwRZZsZMVB1pH81rGC1onC1qmiVpliVrniVoUSViU3rSpuW1beM69+
YFr72KT+qVHTc4PWFwadkgbdUvq90voDsvqDcsxReeaEImNaiTGrwphXYyxp
MFa0iB/6ijae18ALmnhRizz2yeC30vi162Cn4/tW24FGy/4a07fl+q8L9Dpz
tDsy1dtTVdoSFVpjZVuipJrDnjcFP2kMeNjge7fe63ad280apxtVdhIvra6X
m4mXGokVM64W6ormaYhkqwhmKfBlyqEMaZRGUeaxXv/PKHt8tpv0Q6D7fsq/
uaTMPPe9KpR3IHwvkwStT0dGeshEF5npI3MTZGGFLO2RlQuy9kI2fsg2GNmF
89lHC9jFC9klidilXbXLumaXJ25bJGFbdtO28rZt7V3bhvs2LQ9t2p5YdTyz
6KKZd0uZ9sga98ob9isaDCoZjKjoT6jqT6sx5zWYi5rMFW3mqi5zVY+xqkdf
xXheGy/o4AVdvKhLHt/K4Q67/harvjrTNy8NXpXQOwt0OnI12zPV2lKVWhPl
W+JkmqNoTWHPGoMfNwTer/e9U+t1u8btVpXTzZd2EuVW10tNxYsMxPOxWI62
SLaGYJYKX6YiypBDadIohQL9uS2HUpcffb/KKM7ztosgd+WnkabyY/3LVR4R
5RhqyEAFGSkjE0VkroIsNJElRlYGyNoM2VgjWwdk64bsvJG9P3IIQY4RfE4x
Ao4JQo4pIo4ZVx2zrznmX3csvuFQfsuh6o5D3T2HpgcObY/su57Yv35m3/vC
rl/S9p209ZCc1YiCxZiy2YSqyZS60YyWwZyO/pKu/qqe/hpdf43BXGMy1pn0
dX28boDn9fACxot0vMTAvQq4way72rCrgtlZotdRqN2eq9GWqdKaqtiSJNcc
J9UY9aIh7El9yMO6wHu1vnervW5Xud166XizzOZGsfmNAiOJXP1rOVgkW1sw
S50vUwWlK6E0eZQig5Io2J/CXRh1/4PfpU8+h+1KRTx7yqTPt/OZ38/6Ly9Z
G8iSW0MMaWQgiYwkkYkkMpVC5tLISgFZqSJrbWRDR7aGyM4c2dsgByfk6I6c
fJBTIHIORS6RfK6xAq6JQi6pIi6ZV11yr7kUXHcpueFSccu5+q5z/X3n5ofO
7U+cXz1zfvPCqU/KcUDGYVDOfljBbkzJZkLVelrdclbTYkHbbEnX9AM2/sgw
2tA33DTU3zRkbhoxNo3om8Z40wTPM/ACEy/q415lXG/cVW3QWUFvL9VtK9Rq
zVVryVRuTlNoSpJpjJNsiHpWH/64LuRBbeC9atbdSo875c63S+xuF1rdyjWT
yDG6ls0UzdYTytLmz9RA6aooTQmlyKMkWZRI4f7csD/H7fmlYVufX1Qmd0l/
Gm8qNzakVozE6uQH3pLIQgpZySBbRWSrjux0kD0DORgjRwvkZIecnZGLB3L1
RW5s5MZB7lF8HnECHknCHmmi7lli7nnX3YtuuJfdcn95173mvnvDI7eWJ24d
z9y6aW69Um79Mq7v5FyGFJ1GlR3HVR2m1O1mNG3ndWwW9axW6JarTPN1A7NN
I5MtE6NNY/0tU+a2GWPbjL5tTt+2wPMGeMEALxriXlVczWx/idtKdVoLNVpy
VZuzFJvS5BqTpBviXtRHPa0Lf1gT/KDK/36F971St3uFjnfzbG/lWkrkmF7L
NhLNYgpl6vFnaKN0DZSqilKUUZICSpBF8RTyT9lcIOW0z5HzmLcNtdI2pzam
6T9O/I9/B3HaD8TNKOLW0shOFjkoI0cN5KiLnPSRswlysUSu9sjNBbl7IQ8/
5BmEPMOQVzS/d7yQd7Kod7qYd/Z17/wbXsW3vMrvelXd96p75NX0xKv1mVcn
zfO1lOdbGc8BeY9BRfdhZbcxVZcJDedpLac5HccFPftlut0Hfds1Q+sNY6tt
U4sdM7MdC+NNM+aWBXPbkrFrxdi1pu/a4HkjvGCMF03wG3X8Ure1VKulUK0p
V7kxU74hVaY+kVYb+6wm8nF16KOXgQ/LWA+LPB7ku9zLc7iVayuRY3kt21Q0
y1Aok8mfoYfSdVCqJkpRQ0nKKEERxcmhWAp65Kc74z+LlOdG/ilGWlFGTvgU
w1/8/yJO4qZd4DaXRJZSyIbALYMc5ZGzCnLRRC4YuRogN1Pkbo08HJCnK/Ly
Rt7+fD7BfD4RfKwYft8EId8UUd+Ma745Er4Ft3xL7rIq7rOqH7Hqn7Can7Ha
aawuKVaPrE+fvM87Re8hZa8RNc9xDY8pLfcZHdd57LLIcF7Rd1o1dFg3tt8y
s9uxsNm1tNq1Mt+1NtmxNtiyYu7YMHZt6Xt29H0HPG+KF8zwtDGu0G4qUW8s
UGnIUajLkK1NkaxJeF4d/bQy7ElZ0JNiv8cF3g/z3O/lutzOdbiRYyOebSGa
ZSqUacifwUTpGKXqoGRNlKSOElRQnCKKlUPR1M5SxOVdFufEz23c/ctgaUnF
S8KtGJA2zvs7KT9O/ArxEUzMjEvgphRwKwq4PQFcFrkoIDdV5K6F3OnIwxB5
miEvG+TtiHzc+Fg+fL4BfH4hfP6RfP6x/AGJQgGpogGZ1wJyJQIKbwWU3vV/
+cC/5rF/wzP/Fpp/h5R/t6z/G3n/fkW/9yq+w2qsUQ2fCS3vaV2vWey5wHBf
1nf7YOS6ZuKyYea0beG4a+Wwb2O3b2u9b2exb2+672C4ZcvYsWPsOtD3HPGB
M543xwsWeEgfF6nW5SvWZsvVpEtVJ7+ojHteHvm8JPRZYeCTfL+Hed73ct1v
5zjfyHYQz7K5mmUhnGkikGGI0pkoFaNkXZSkhRLUUZwqilFC0fIokvx92Ytr
3mzKlftSfvzrmGlOmbjRReTk/Q22X/44cyOKOZMaL9J/U8BtKeBOBHA55K6I
PNWQpw7yYiBvI+Rjjli2fL5OfH7ufP4svoBAvsBQPnYUHzuOPyhJKChNNCjr
WlCeRFDRraCyu+zKh+zaJ+zG5+xWSXanDPu1PPutIntAhT2oFjii4T+m5Tep
6zuDWXMMn0UD7xUjz1UTj3Uz9y1Ltx1r131b5wN7xwMHuwNH60Mni0Nn00MX
oy0Hxo4jfdeZvueCD1zxvBWet8aFSjW58tVZMlWpUhUJkqXRtKKw5wUhT/ID
H+b53sv1up3jfiPbWTzL/mqmjXCGhUCGCUozQqn6KJmOEnVRgjaK00Axqiha
CUUqoHCKeSh1f14g5ch9Lhc4PIHz3MgNr/ziJxOnU0NFfJ7AbS2F7KSRA4Xb
lcAtj7yUkLc68tFFLCbyNebzs+Tzt+MLcOYL9OBj+/IHsfmDOQLB0QIh8UKh
yaKh6ddCsyVC82+GFt8JKb8fUvUopO5pSNOLkDapkC7ZkB6FkLfKIe/Ugoc0
gke1gyZ0A6dwwCzDf8HAb8nI94MJ66OZ94al17a1566tx4GD+6Gj65GT05GL
/ZGrzZGb5ZG72ZGH8ZYzY8eFvutK33PHO2543hZPWuIc2ZfpMmVJ0sVxUgVR
L/LDnuYHP8oLvJ/rezvH60a2m3iW89VMe+EMa4F0C5RmilKNULI+SmSgeD0U
p41iNFCUGopURuEKiEMRD6ZM3P8yVflm3DShuOn/VOLnXpyYH5aSyIbC7SiD
nCncHgRuBcRSRr4afH56fP76/AEm/IFW/Gx7gSAXgWBPwRA/wdAgodAwIU6M
UFiCSHiKWHjG9fCcm+EFd8JK7odVPAqrfhpW/zysSTKsTYbTKc95rcR5qxI6
oB46pBU6qhsyiUOmmcFzBuxFo8Blk4BVc/91S79Na98dO599B+9DJ68jF48j
V7djN+djd4cTT9sTL6sTb/MTH5MtV8aOO33XA+954U13PGePs+RKUmULE6UK
Yl/kRz3NC3uUG3w/J+BOju/NbK/rWW5imU7CGfYC6dYozQKlmKFkY5RogOIZ
KA6jGB0UpYki1fjDVARCFPiDKeLsy+TwtwRN0ov/8rtp//oHj2J0SdueoC2N
nGWQmyzykEPe8oilxOenzuevzR9AFwg0FGCbCQZZC4Y4CIW6CnO8hMP8hcOD
RcLDRSJiRCMTr0alikdl3ojKvR1ZeC+y5GFkxeOIqmcRdbSIRunwVrnwToXw
buWwXrWwfs2wQZ2wUT3OBIMzY8CZNw5dMg1ZMQ/6aMnesAnctgvYdfA/cPI7
cmUdu/kce3gee7odezmfeDue+tid+lqf+Vmc+ZtuedB3vOi73njXB390xzOO
OEWqIPFFfuzTvMhHuZz7OcF3sgNuZrGuZ3mJZbqJZDgJptvxpdmgFEuUbIYS
jVG8IYplohjMH6kjEK4lFKomGKLEHyyHgijgAb8rZppQV2/1r/xE4p/s20YS
2UuRuF2kkZsM8pRF3nLIV5HPT+0CN9tQIMhUMNhKMMReKNRFmOMpHOYrEs4W
ieCIRkZdjYq9GpN0LTZNIibzVkzO3eiC+9HFj6LLn0ZVvYiqlYpqlIlskY/s
UIp8pRrxRiOiXyvivW74CD18XD982ihs3iRsyTzsgxVnzSZ00y542yFoz5l9
6Bp44h5w6ul34uVz4uN1zHI/8XU59XM89bc7C7Q+Y1twg0y3vOk7PnjXF2/5
4GV3nELLT3iaF/soN/J+DudOdtDNrIDrmSyxDE+RdDfBdCe+NHuUYoOSLFGi
OYo34Y8xFIxiCoXTRTg6QqEagiEq/MGKKEgeBcqiACpj+Z0R0+D3vpv2X3xh
30QL9pLISYqk7U7QlkE+sshXgc9flS9Aiz8QC7ANvqTtIRzGEokIFI0MEY0K
FY2NFIuLuxafLJGQfish+25C/oOE4scJZU/jK17EVUnG1krHNMhFtyhGtytH
vVKL6tGM6tOJfIcjhxmR4wYRU8YRc2YRi5bhH6zD1+3CNx3Ddpw5+64hR+7B
p15BZ96Bpyz/U1/Wib/XSYDHaaDrKdvpLMj+LMSGG2rJDTXdD2Du+OFdf7zO
winP8hIe58Y8yIm8m825mRV0PdNfLIMlku4pmObKl+qEUhxQki1/gpVgrLlQ
lIlIhNFVDlMkVE8oRFswRJ0/WBkFKaJAeRQgi/wo4D5f2fcX4ZLc0Sbtm/dJ
K+fE/+jH7duEashJErlKIXdp5EXglqFwq/AFaPIH6gmw9QWCTASDLQVD7IQ4
zsJhHsLh3iIRPsLRLOG4QNH4ULGEKPHEeImklJvJGXeSc+4nFzxKLnmaXPEi
uVoquV42uUkhqVUpsV0loUs9/rVm3Bud2D69mHf06CH9qDGjqEnTqFnzyEWr
yBXbyDWHiE3niF3XiAOP8GOvsFOf0DPf4DM/9lmA/1mg7ynb+zTY8zTE7SzU
+YzjwA235YZbcsOMj0MNdgLxdiBOfpyT8CAn5m52xK0sjkRm0LUMf5F0H8E0
T75UN/5kZ8EEB6FYW5Fo66sRFmJhJlc5BiKhDKEQXcFgTf4gVRSkjAIVkb88
8pNFLIr4jy0zL8Ll7/002gZU/m1GjZyrJPKQQl7SJGo/+R9QBzEFgo0FQywE
Q22FOI5C4Y5CkU5CMc5C8R4iCayriWyxJI54cpRESsLN1NTbaZn30nIfphU+
SSt9nvZSMq1GJq1BPq1FKa1DNbVbI/WNdmqfXsoAPXmQmTRimDhunDBpGj9j
ETdvFbtkG7NiH/3RMWrTJWrHPerAK/LYJ/LML4LrH8YNDOGyg86CA85C/M5C
fU7DPM/C3c8iXLiRjhBly400Pws3OOQwd4LxRiCOv5sVfSszXCIj9Fo6WzTN
TyjVRzDZUyjRTSTO+Wq047VIO/EwKzGO2VWOsUiovlAIFgzW5g/SQGw1FKiC
/JWQH5EjELGLou3xZai0/jxUXvn9n8zaiBotYqJ4EAMphVjSyE+OL0CZL1CD
n617CdpMkGMuGGEuGGUhGGspkGAnlOgikuR5Ndn3WkrQ9dSwG2nRN9MTbmek
3svMfJiZ+ySz8HlmqWTmS5nMGvmMBqWMFtWMDo2Mbu2MXr2MAUbGkEHGmHHG
pGn6jHnanFXqok3Kil3yqmPSunPipmvCjkf8vlfcISv2xC+GGxAN7EhuUBg3
JJQbGsTlBHLD/bgRrLMor7Nod26MK8Q6cmOsudEmJ5H6B2GMnVAcdzsj6kZ6
mHhayNXUQOEUP5FEn6vxntdi3MUjXSTCHcTDbMQ4lldDTUVCDIVCGILBevxB
WoitgQLUkL8K8lVCLAUyanlSEdPtqyhpfhklmRRr3qca/eLHWetTn7ShWvSW
RCwpYgLxBSjxBarzs3UEgugCIXSBMIZAJJM/mskfp8+faCqYZCWcbC+a4iKW
6nUtze96etCNjPBbmTF3shLvZac9yMl6nJP3LKeIllMmnVMpl1OrmNOoktOq
ntOplfNaN+ctPXtAP3vIKHvUJGvCPGvGKmvOJnPRPn3FMW3VOXXdLWXLI3nH
K2mflXjkl3ASGM8NioOQGAiJAE4YhIVCRDA3MpAb7c+NYXHjvLnxHpDgyo23
58ZZnMUYHUUx9iJw7M3UyOspHLHk4KtJgdfi/cRjWBJRXjfC3STCncTD7MU4
1ldDzUVCjIWCDQSD6PxBOoithQI0kL8a8lVBPsQ6QwF5EkkwxdrlR+KjPsmZ
9+lKv52zOdUOMXgsSeR/DlmVP0iNP1SNL1ydL1KDL0aTL16TLwkLJBsIppgK
p1qLpjmIpbuKZ3hJZPrfzAq+nR1+JyfmXm7Sg7z0R/nZT/PzX+QXS+WXy+ZX
KeTXKec3quW1auZ16OR149w3zNx+g9z3xrkjZjnjljnTNjlz9tmLjtkrLlkf
3TLXPTK2vNN3WGn7fqlHgSknQUnckETgxEN4LIRHks9JiwyB6CCIDYQ4f0jw
5Sb6QJIHN9GJm2DDjTc7jTM4jMExEskR1wiXlhAiEcu+GeV/K8LnRriHRJir
OMdRjGN7NdRSJMRMKNhIMIjJz9ZDbB0UoIX8NJCvGvJRQd5KyFMBucshN4qz
05dh8cJz0BDjJ3JWp4bJicrd/aX5AqVRsCwKlSdXVJFKKFqZ3EZIUOdL0hFI
YQilGgmnmYum24hlOIpnuklke9/M8b+dG3I3L+J+fuzDgqTHhRlPi3JeFBVI
FRXLFJbJF1YqFdaoFjZoFDRrF7TrFXTR83v0898a5b8zzRuyyBuzzpu0zZt1
yF1wzl1xy/3ombPunb3Fytr1z9wPzDgKSj8NTeOGpUJEEkQmQHQcREdBdCj5
wKU4NiQEQKIfJLMg1Zub4sZNduAmWXETTY7jGdESCZE3Y8NuR4fciQi8FeF7
I9xbIsxdnOMsFmp/NcRGJMRCKNhEMMiAn81AgRgF6CI/beSriXzUkZcK8lRC
7iS6K7+SurgK+flmFOkyfvXdhKlMT/VTGKRyyEBikSqNOLIoXI7cKIhRQnHK
KEGVL1lLIAULphoIp5mKpluJZdqLZ7lIZHvezPG9ncu+m8e5nx/1sDD+cVHy
45KM56U5kqUFMqVFciWlisUvVYqr1YvqNIuadIpacVEns7DbsLDXpLDfvGDQ
smDEpmDCPn/aKX/eNX/JI3/VO2+dlbfln7sbmLMfnH0UmnUalsmNzICoNIhJ
hthEiI+DhBiIC4X4YEhkQ3IApPhCmg+ke3LTnLmpdtwUi9Nkw4+ROPJuJOdO
RNCt8IAb4SyJME9xjqtYqNPVEDuRYCuhYGI9ZszP1keBDOSPkZ8uYmkjH03k
RbH9I0VyU8hJBjlQO7CffMVFrkFDdMov8z6t7LdQVqQGyYHyF0QmEyyJONIo
XBZFyaEYBXLzMVGZL1mDP0VXMJUpnG4smmEhlmkrnuUkke1+M8fndm7A3fyQ
+wURDwoj75fEPSpLflaeSavIlakolK8oVap4qVpRo1FRr1XRpFvegsvamaWd
BiXdxsVvTIv7LIreWRcN2xWNORZOuRTOuhcuehas+BSs+RVsBhbsBucfhOYd
heeeRuZAdDbEZkJcGvmQ48QkSI6HlFhIDIWkIEgJhDR/SPeFTB/IdOdmOHLT
rblpprsJOPxOROitcPaNMD8Jjrc4x0Ms1OVqiINIsI1QkKUg25SfbYgC9ZE/
A/mRz1m88ifq5OamqzJyVkBOcshBGtlJIVuKssWntQp5reZXP8r3D7/lJ+Qo
T+NAWTHhKkIlUYQ0ipJBMXIoXgElKqJkNf5UbcE0unC6oWiGmVimtXiWg0SO
681cr9t5fnfyA+4UsW+Xht4tj3xYEf/0ZcqLykzpqjy5qiLF6jKV6kr16lqt
6kbd6lZGdadB9Wvj6jemVX0WlQNWLwdtK0bsy8ccyyZdSqfdSuc8Sxa8i5d9
i1YDijaCCrdDCvfDCo8iC09jCiAuD+JzIDELktIhJRVSk8hH7WXEQRqHfLRM
egBk+kEWC3K8IduVm2XPzbQ8TDEIuxUefCMsQILjKx7qJRbqdjXEWSTYXijI
WpBtzh9oggIpQFf+HCNvXeSpjTw0kZsaclVBzork7r29LLkTZCNF0rGkMF94
iT/4br5UpidFuRoXavsqTBJFSaNYGRQvhxLlUYoKf6qmYJqecLq+aIaJWJal
eLadRI7zzVzXGwXuN4o9JcpYNyoC77zkPKiMelwV/7w6VaomS7Y2T6GuSKWu
TL2uUquuTreuiV7Xpl/XZVTXY1rXZ1H33rpuxL5u3LF20qV2xq1m3rN60btq
xbdy1f/lOrtiM7hih1O+H152GFl6HFNyFlcMiUWQlA/JuZCaBWkZkJEGmcmQ
nQg58ZAVDhlsyPKHHF/I9YE8D26uMzfH9jTTJPRGWJAEx1881EcsxPNqsKtI
sKNQkK0g+5zpr42QrwHyYSBvjDx1yR15Nw3kooqclJGjArKXQ7Yy5K69lRSV
slFwDSnvwLjy2+mSd9tQOd1zyvE6U9uwEZIoVgrFy6AkOZSixJ+qLpimI5zB
EM00EssyF8+2Es+zuVZoJ1biIFbufO2lh0Ql63YV+14151FN1LPaBFpdqkxD
lkJjvnJjsVpjuWZjlU5jHW5s0m9sM2rsMm3ssWjqt24atGsadWyacGmccW+c
92pc9GlY9qtfDahbY9duhNRsc6p3I6r2oyoPY16exFecJZZDcimkFkNqPqTn
ks9hz8okH4CZmwL5SVAQD/mRkB0Iuf6Q7wsFPlDgxs13PM2xCJHgBIqH+omF
eF8Npv57mSu/sUABZsjPBPkaIh995EVHnnrIXQe5aiIXdeSkghyUkL08spVD
1jLISpq83HeRmVFUz3nyPjXxt1jrE8pnO1FXzaIkUbwUSpJBKQr8aaqC6VrC
GVg0U18020A0z0ik0ES4xEyo3FK40u5qlfP1as9bNb53a9kP68Ke1ke/aEyQ
bkqVb85WaslXay3RbK3Qaa3GrfXM1mbD1naT1lfmrW+sWvtsW987tAw7t4y5
tUx5Ns/6NC/4Na8ENq0GNa6FNGyE1W9H1O1G1+7H1hzFV58kVZ2lVELaS8go
g8wSyMgjnyqfkwW5GeQjGwtToCiJfNxUSRQUsKHAD4pYUOQFRS6nedbB4qGU
Xf5PNyG2k2CgHX+ANZ+/OfIzRSxj5GOAvJjIAyN3XeSqhZw1kJMaebXUThHZ
yiNrOWQpiyykkZnURS5G+gCysZ9I9gGVb7CpexxiaShJCqXK8acpC6arC2Vq
CuZoC+TrChRh/lI6X4U+X5WJULWlaI29eK3LzTrPO/W+DxqDnjSFPW+OlmpJ
lGtNU2zLVm0v0Ogo0emowB3VzI56w45mk442845Oq47XNu299u0DTu2Drm0j
Hm0T3m3Tvq3zAa1LQa0fQlvXwlo2I5u3o5t24xoPEhqOkupPUuvO0mshsxqy
KyGnHPJKITcfcrMhPxMK06EoFUqSoSwRyuOhPApKgqHYl7LNv/cXZfuIsD2E
Al0FAhz5/W35/Kz4fM0Qy4S8EuSljzwYyE0PueogZ03kqI4cVJCdErJRRNby
yFIOmcsiM2lkInXBVP/8DnMqQSP+/eb/TvRtsnepCBZMXe+Np6FUGb50Ob4s
BZSjhPJVUaEGKtFCZbroJUZVBoI1pqK11tfqHG7Uu95p9Lrf5Pe4OfhZa7hk
W4xse6JCR5pKV47Gq0Lt7hK97grGqyqDV7XGrxrNulosuzpsul7ZdfU4dva5
dL5z7xzy6hhjdUz6d8yy2xdC2pfD2j9Gtm9Et23/f5V9CVRb2ZkmcVV10p30
9Jz0TM+ZPt05nelOumdOP8DlSiVVqVSlKkklqYowxtgY7xsYzL7abAaMwWBj
sxhsg82+mH3fEYgdITYJECABAgmxilUghJbvnHn3AS4scCXt8w6W4L377v3u
f//lLv+X2KpMalGlNKvTmjSZHH12I3LYyKtFfjUKKlBUhsJCFLxCURZKMlCa
hvJkVL7c0Zs/Qtl9lN/TFPvJ0mzDjz24935EkGm4v0m4j8l9L+Mwd+NQZ+qe
I3XXngq+QYcLVMBVyv8yWda/fY7ytqa8rCiP05S7JeV6knK2oJzMKYfjBFr7
3XU/5iXM9OR1Zo3EkPvhWzD+FYNxDLORIYlFZRynsi2oXEsq34oqsqZKzlPl
F6nKK1SN7dFahw/qXH/B9vqkwe+zxqDfcEK/bH7wVUuUWWvcifbEUx0p1p0Z
53k5l3oKr/WW2vZW3uytdeplu/Q0unc3e/Jab/E6fLu6/Lt6A7n8u9zBUO5I
eKf4Yafkcac0pkMe1zH/rEOR0LH6sl2Z0q5Kb1Nntmpftehzm5HPQUEDiupQ
XIPSSpSVo6wIJdk7WvTHqHmJmmeojkXVI1Td3y4LmMmyCzsaHmJ6P9A0zM8k
7LZJqKfxPTfjECfqrgMVZEcF2lIB1yi/K5TPJer2ecr7LOVpTXlYUW6nKVdL
yvkk5WRBOZhTN48z6BK/9l0DhN/5ryH8MZPR4QmD8EsWlXWcyj1B5VtSRaep
Emuq/BxVeZGquWpaZ/dBvdMv2O6/bLj1Gcf/i6bgL5vvf9UayWqLOdH+1LIz
wYqXfLY342JfztX+IltBmb2gyklQ5ypo9BC0eAs6fAQ8f0FvIL8/mD9wr3/o
ft9IRK8osmf8cbckplv6hDf9tGs2gbvwgruczF1L69zI7FS/6tTmdegL2lHU
iuImlDairB4VtYy8/hsqclCRSZLe1aSQ3Eh1iaiLR200ah+qK4LmchxDj4bd
NQ29Y3rP1yTklkmIh/FdF+NgRyroJnXnBuVvQ/ldpXwuU7cuUN7nKM+zlLs1
5WZFuZymnC0px5OUwwnqpjlld5wAbEvmKY3ee40vfW2Kyg/wt3wLwj9nlEQs
s/mJ1hOvzKgCc6roJFV6mio/Q1Wdo2oumdZd/6De/ucNzr9s9PyM4/NF050v
W0L+2BrOaos050ZZdD851Zdg3Z98gZ9xZSDXZrDIfqjMSVjlKqzzEHK8ha0+
wk5/YXeQsD9keDBseCRieCxSOBElnIoZksUNzjwdmEsQLL7gLyXzV1P71zP6
NrN7t3J6tvO6tYU8fXEXSjtQ1rajCX6KmjrU1qC+Euwy1OahJgO1aahPQUMS
Gp6D/QT1j5XlgfP5LveO3gs2DQkwvetjEuxtEuxuHORsHOhANp3421K+1ymf
K9StS5TXBcrjPOV+luwtdLGinE9TjpaUw0nq5gnKzpy6cZyy/Z6B/Bpm6d1B
1vBkJuONHWNkN4ZBNoM571xsTpVaUBWnqCorqvacad2VY2zbnzc4/LLR9dMm
ry+a/X7XEviH9rtfc8PMeiLM+x9b8uPODCScH0y+PJR5fTjXbqTIcbTcVVTt
Iar3FnF8RK3+os4gUXeImB8mHooQj0aKx6PFU0/E00/Fs89F8y9GF5NGllKG
V9KFa5lDyleDm7kD6nyBpqh/Z/z/X1S1oboZtRzUNYBdT5hCOFVorkBjAdgZ
YKeiMRmcF+A8RWPMUmnAXKF7yNG7QabB/qZBt00CvUzuuBnfcTIOuEn536B8
bajbVynvy5TXRcrjAuV2nnI9S7lYU05WlONpysGSsj9J2Z2gbphT5DSw0X5c
Nydq/yu4mjIOQzRj2bKYLHGlx8l552pLqvaMSf2FY+yrP2+0+5jj9GmT2+ct
Xr9tv/1ll/8fewK/5t87PhBxcjDKaijunDDh0kjytdHMG+Jch7Ei1/Fyj4lq
74l6XwknQNIWJOGGSHrCJPwHkqFHkpFoiThWIomfkD6fkL+YmE8eV6SNL2eM
rWaJ1nNGN/JGGNmkdBWDqBKguh+1PajlorYV9c1gc9DIJtRLzTVorUJbGcmQ
2JSFplQ0J6ElEc1xW3Vh8iKPu0eDAk0D/Uzv3DIJ8DTxdzX2czT2s6d8bKnb
1ynvK2QvpsdFyu0C5XqOcj5LOVlTjlbUzdOU/SnqxinK5uRe/h7GA2OQHO5K
JnAdrgsORfY/md0bUcyuvFdMPvJyM6r6BFV7yqT+7LGGSx82Xv+YY/dJq8Nn
Hc6f89x/2+v1e77vV4OBZkP3LIQRp0eizo7GXRQnXB1LuTGR6SDJdZks8pCW
35LV+MrYAbKmIFnbPVnnfVl3hKwvUiqIkgpjpaPx0rHnU5MvpmTJUzNpkwsZ
k4xsGqtKxtRlIk3lqK56BLVC1A+CzUdDHxp5YLeisQlNjWhmo7UObdXoqCQp
NzsK0P4KrSloS9K3PlPVh0sK3IKP3rljGuBr6u9t4udu4uti7ONgfNuOumVD
eV+jPK9Q7pfJpmLXC5TzOcrpHOVwjrI/R904R9lYMZvqaUyP0KDuYKqa4uzA
+Bdiysya/QejX3fHP4uqNKPqTpiwT7/fcPZnTRd/0Xrl406bX/HsPut1/Jzv
+ttBzz8Iff80HHhi9N4p0QPrsagL43FXJQm2kyk3pZnOslx3ebH3TIXvbM2d
2fqg2caQ2ZawmfaIGW7kTE+UvD9WPhAvH34uFyVOjydNM1L5/mKubLlAulYs
3SiTqiom1VUSTe2Ern4cDWI0joAzhOYBtPSjrRfN7WhuQmsj2uvRUUsycndV
gFsMbh64WehM1bU/32x4IMp3CTrq52/q52Pq62Xi42Zy29n41k1jb1vK6zrl
cY1yv0K5XaZcLlNOlymHy5T9Zcr2InP4YwdQcwNMl8ZqcDjn2Ldg+hMG092x
z6KqWcYNJ0w5p95vOfOz9vM/5176qPvaJ703PuXf/GLQ5Uuh51cjPmajgSfF
96zGIs5NRF2SxF2bSrCTpjhOZ7rO5HrOFvsuVtxR1NxdYocuNYUvtT5c6nik
4EYvdscu9MXP85/P7VifDycyZqXZM/LcmbmCGUWRfKVUvl4hV1XLt+umtWyZ
niNFkwQt42gVoW0Y7YPoFIDbh85OtHPQ0UDyzPNq0V1NkmZ2F4KXA16GpiNB
yYkMOeobeNTHz/T2bdPbnia3XE28nYy97I09bSgPW8rNlnKxpRxtqZu2lJ0t
ZXuVOYLwGtETe6DuYfqearoDe/8OQ/bI25H9MWOzdsc+QZbiHDdpPXm03eoD
7tkPuy9+1Hf1E4HNr4fsfzvs8odRzz+JfMzHAi3H71lLIi5MPr4ijbORJdjL
U1zmMr0Veb7LxXdWKu6u1YStsyPWmyLX26LXuU+UO9bnZ6K0tfHMVUn2ijR3
RZ6/PFu0tFCiWCpfXKlcWK+Z36ib32qY03Bm9S2zaJtG+xQ6JsAdQ9coeEL0
DKCXTxhGeM3gNaC7Hr016KtCXyl689GbvdH2bL3pcbDp7Tsmt3xNvL2NvTyM
PV0oDwdyuTpQzg6UowN104Gyu8kcmNnD9PprTI2OkFQ37+zgynptsZYkjftR
NMym+5eh/CPGguUyZCtlLKqKRTWbGXdYmHadOtZt/WHf+Y8Fl381dP3zEfvf
jTp/JfY0G/OxmLhzWnLv7FTEJdnja/K4m/OJbkspXiuZvmu5d5TFdzcqwlQ1
D7bYj7YYSf2oN1EtSFIL09SizO2JV9vSvG154fZciXqhbEtRoVqu2lyrVSrr
1zcb1raaVrdbVrRtS/oOBbjz4E6jS4puCXrG0SdC/wgEQxgQQMDQQfSy0V8H
fg0EFeAX6/m5Ky3xK82Pg4y9A4y9fChPL8rDjXJ3o1zdKGc3ytGNsndjDnu9
BvnSPpAtDseZOTP2ztZcz7SoCjjIMmi4FvEtOP8jczIzl5FmWk9UMkw3Xeam
PZbH+q1+PnDul8KLn41e/43I/vdjzl+Pe5pLfCwn75yR3rs488BmIdphOd5t
LdFLmeKzkXlHlXt3i5HbXzTFa9oSNNyXmp4UDT9dO5SlHc3Vjhdop4q18jLt
XIV2sUq7VKNZqd9ea9hWctSbzVtbbZuajg0dVwneGrqX0buIHjl6peiTgD8O
gQiDw4THaFgAYQ+GOjDQiIE6DFVjsEwnyFd3Jy9wIgMpDz/K/Rbl5k25elNO
3pSDN2XvRU550QjbHkT4yEmSrs5iT0G81hE7+G4rhMuydgKSIRPO4fh+zwBf
Zo7nH5hM3AUsqoRhcWpnGXcfP9pv8bOB0x8JrX81evFz8fXfjdn/ccKZNel5
UuprPRN4eTHUduWhkzLabSPeS5XosyOvnxQ91JRHaWvitOxnuqYXurZkHTdN
15Op47/SDeXpRgp1YyW6yXLddJVutlY3X69TNOhWONr1Zu1Gq0bVoVFztzW8
bV2PGn1b6N+AYA0DyxiYB1+KAQkGxyAUYXgYo0MQ8QmFwmg7YdQQ1mK4SjtQ
sNWTOt3wIIBy86dc/Cknf8rBn7L3oey+BVzLXXzfeY2v0RHi1r5jtheG7Ua+
28tjy9Nd8vGGA6zJhqvw34LzDxmVnM84EM2E+ce0l3Vs0PzDYcuPRdafjl38
zfi130vsWTIXy1mvcwq/K6tBdhthTpuMvP46OWQ7474m56GmMFpbFqerTtCz
X+qbUvWtGfrObH13rr6/QD9QrB8ug7gSkhqSTm+mQT/H0S+26Jfb9Gsd+g2u
TsXTqXu0mj6tXqDBwDYGtzCkwrASI6sYUUAog1CCkTGMiiAexhjD5DjWRbIF
izl6Ua1msFDVmyZh3w+mnIKpm8GUXQBzYtn7DYRt9iN8igGZxvgISWXz3msr
t+vlMvlA3tWsyTYVI3NTbWMjlYaMR4eyhB+O798xmZbzGH3cyjLuYh3tZ/1M
ePwX4pOfjFt/MXnpD9PXzWbtLRedzy57XF7b8QZ++9B7O9pPEx+oSQzRpoTr
MiN1uTH6oniUJaI6maQCb8xCcw7Jjs0tQk8p+BUYrMZIHcYaMNkEWQtm2jDf
AQUXKzys92CzT6/m67WDer1Qh2EtRrYxqoZYRWgpx9cxsYqxWUI3Jx7DuAgT
w5AMQtJLkjJPtOjFddvC4s3+jPvUzVDKfg/gGwYAXyMAX98B+LQhxu+8xtiI
+GcMwu9sLkumJ9ulE00H2CgNd/99C74/YJy1HXvXzjLtZh0TsD4cYX08YfFr
qdWX8vN/mrtiscig+hufm+og1+0wb22kvy46SBd/T58YgZTHyIxF7jMUvUBZ
KqoyUZeDhnw0FaGtFJ0V4NGWvxYCNoQckp57vJ3kLJZ1YaYb871Q9GNVAOUg
VEJsj0AnAsTAmA7jGki2MbmFqU1C+Shbh3QBEikkY5gcJfQ5UgGmejDVoRtn
bwwWbvAz/3JsjY6cIvhZ7pk6Bl5GX5jt0w/vbq7JVxUiyXjzmLjekNPK8BTI
4Qgzc8LfZTRxM8ukk/V+L+uDAdaHw6xPJnc8rS9tzisdr6o87Ld9XDSBXrow
P31kMGLC8PQhXkQhNQ6ZCchJIuxHJVmoyEVNEdil4FSgpRrtdYQDqqcJ/a0Y
bIeQixEeIbWQ9BF23RkByQ6sEGJlBEoRVGMkX592ApAAU4BUD5kW8m3MbGFW
hVklZpcgl0M2hulRQqgq5+tlXdqJhpWBvDV+xpvI2h5E9sweuATbI5YEv1N7
yoJG9692EN1QrK1MKRaEoyK2IWem4Ummb0H0XYKocSvLlEsjysjml6zfz58w
W7KyXL14VmlzZcvxhsbdSevjoQ/0QWgQHoYhJpKQ1L14ipREZCQTSom8VyjK
R1kxKivIxBW7HpxGtDajvRXcdvC46OWhvwcDfRiiDdMA0ZyTw4ScakZMqBaX
Jwhz5+YU4UzVyKCfBuTALDCnx7wOixosbGFhHQsKzM9gbhJzo5gb0k3zNJLG
BX6Ooi8tgOQu2A+ozX5Aj9CIMlnCvnuGSY1yfk+Ad0Jfo53ZRZVKubY2p1CM
D402DAzXHODzNET1O29FlZHHk6xjfEIv+2s564+L5hZrVmc2LhIqX42jg87d
Dbdv404gQkPxMJJs6nr6DAkvkZSKtExk5iKnEPmlKK5CeR2qGlHTTOZZ2O1o
7ERTF1q6SSDbyUfXALqHCEPn4AihtxSLMTEOqQTyScxLsSQj1FKqGZINVTcH
LACLwBKwrMeSBktbWFqDYhEKORQS/cKwVt69Pdkk78s+iOaNfWjuAHiByTBz
mUnts5Mb+DSjAMxe47mpVq9trChWZLMLI/3C2gNZsQy/H44n8dN24lIyNW7c
Qsb+0W6C7cdTrC9mzb5esrBUWl1QX7ymtbmpd3AlDLq3A3DnHkIfIjIWsQl4
moLETCTnIK0QWaXIrURBHYobUdqCsnaUdaKiC5XdqOpBTR9q+1EnAHsADUNo
GkbrKDpE4InRSzuwExBOQjQFiYwM74VZLM8T5q4tBXQEVbyDVb3RP2FVg1UV
YUlcWcDK9NbckGamRy1tlvRm+lG2tyhbT8rGlbJxZNIg2TA5GndgvMZ8td3L
FHye0QQ7Y57xZt9bV2+vqTYVawtzCkn3UN0BifzLEP3hroQyEcePCbeiSQfL
lMd6v5/1iYz12/kTrJVTVpvWlzUX7WDjQhiy3QPgE4KgB7gfi0cJiE3B02y8
KEByKVmSzapDTiPyW5DfjgIuCnko6EFBHwr5KBKgeIDWPyVDtCEtHUIZc5XT
lxA1I2gQkXkEOuDtmkS/lLhX4zOQz2NhEStLJD+7ehX6dT2tv+gf/w1KPZRa
kjR5fUW3OrM+M7Ap523JWgIoGx8maZc7k8DrJj3WaQyNvm/HfHZgrht7qRjf
GPc7qK5sa1e21IqNtbmVGdmC+IDFN8wSuYOqYTa3/459jJT/SqYVjNsZVPtY
n8qP/37xpPmalfWW9TX9JSfYesHJH54h8HuA4BiEJ+BRKmKz8bQAieVIrkV6
I7JakNWOzE5kdiGjG+m9SOcjfQBJfCT240U/+ZxBsM2kf7yTNYCsQWQP0t9f
0T/+I2cQBUKUjYI9jk4pemUYkmNsHtMKLKwQ0VStQ7cB/YZev6kHuTT6TaV2
bXZJ3r8q4yqlzf5Mci5PJu+cI5Ouy5n57MZ8tmdE9eDQ30FUsa1TbGkWN1Vz
awqZYupADGCoWQ9HdI/DlPEXfkEcKxpRE9pr7WX9etbij0uWFsrT57etbPUX
XXHDFy534fUA/jEISUBEKh5lI6YA8eVIqEVyE9LakdaJdB7Se5Deh3QB0oRI
GEB0H8K7EdQJ33aUh6xwIte645XDyRtT2RuLhUqbUjhVwr0at+twh42YTmQP
oXgUNRNokaJbjoE5jCkwu4qldZIMXaPCEd2W3ugf9Gq9bnNDsz7POq9emGpX
SBp890TUYy/N9Wts7d4c8ZaMf8og+V25mrBFz2/p5lXbs8p12crcxML4gdjV
0P4fjudf7457Rp7NSChrwqVDrONfzJ/40+rJUyrLS9pT9voLHrANgEs4bsXg
TgLupSI8G48KEVuB52wktyK9C+k78sjIYMoongkRO4hIvjbo+nK02+ZLv63c
sO3KaG1zoq47nUS2E6W6uVrdKke70bat7lJr+9aPR2gv58GzChEtyBGiVIRa
GlIZeucxuoTpNSxukPzyajU02wy1nEqlVi6YX1Kb2Wh2JNOHSc/nu2/gv22Y
7yBJu7+yLcyo9TMqrXxDJVtbliimD3CKGjKm7yC5PyMs0ZqvcxvTNzLa4k+E
e9eYDlh7zH6nOG62fuLMtsVVraUTzt/CjRC4PsLtZwhKRVgOIosRW41njUhq
35NFPtKGkC5G5gRSxvFyVGtzYt718nqQsyrKX5sUrs95gvIkNOaAW0q4iMQc
yNqh6CYpuNVCvV5Me/i0e0979fPmibhZiKc85A2jTAz2JHjzEC5jSon5Tayo
oSLcXnrVllq1obC4um1upz3urDf3RAADqNebw/sKY+Wt3/A7/0awhpFNEq5N
qDBFY6rSyTa2p9aVE8sLogWJ4c4NQ19/F893v5HKXXAN8r0SOWVmGr8isH4o
Zv1mwezE5vFzmhO2upOuOO8Lu3C4xuJ2Iu5mI6IYMbV42oSXnYxUCpAxjFdj
yJtE4TQKZfqaGZXVnxavXFS5OWqC/Qi/clICXmWitAh1NWhqAreT+KdCASTD
hEF+fRLb09DRHijtfipUtKk/fk9/OQ2+VUTn5o+gRkJmEQeWIVFibgurhBBB
v76lVm4sW9pun3TUnnDTn7yN04E4E4azj/C2Uc5En9/vWETPCgbWMbyJ0U2M
qSBRYXJTJ1Fuja+ujirkB9YNDaPUP4crcaAIDy1TjjUJoY4NsT6dYR3fYF3U
HLfXWXjgQjDsIuEaD99UhBTgYSViG/C8Ayn9yB5GnhiFkyidRuU8GhbRqtCa
fz5jaam8aqf38Mfdh3iciBd5yKxGLgeFnSjtR3E/ygZQJQRHjK5xCKWYpd0l
BfRr0K0Da2usS6rjvvpzifAswqNmZA6iUoKuBYysQarCnBqKbf3ylnpxbf7U
Te0pF52lF6z8YR2CcxG4GI2rz3AzGW7Z8ClEUCUiaP3cikQeUUq5IyidQK0M
TfPoUOyCK9zA8AZEmxjf1I8pNeK1jdFlxQEGUyKx36G/EkTfhirZicgwR1qR
KZSPplhfr9B6nuWos7iNC/dwIwquzxHwCqEliKzBk2ZSq1Q+CsZQMokKOeoW
0L6C/jWMb6jN/rBseUFr46GjjVdYCuJKkMRBKn3/IJ4O4AHtRt3d6E7UyAvV
SvbarTrkClE9Rib96HhIswXdlk69Lme54eQD2KYhqAovaedLhOZZ8FfIlIp0
i7Yg+tnNTfGc6LST7oy77owPzgbiQhguR+LaE9xIhHMavHIRUILQGjziIL4D
yb2kO/JEKJOgTo7meXQuoXcVfCUGNzC0gREayQ3d6PrWyMraAdbQv/kzGBpm
ZWWeP8X6cIz15SLLSsWy05jTQN7HjVi4J+NOPsIq8KgBcW140U26t3wKVTNo
XETXGqnLuEo/t6Vl/WH5hJ3uciC8nyO8GIltSO1DDiOzdldUdNia/4ospg71
YV4E3QwdDq1ZJiBVgK55yFVQbmuX12bMXHA6BNcT4Uf3Qx8BskYGrgKDSmZU
bm6LluYvuuvPeerPeuvP+eNiCK5E4HoU7J7CMQnumfDJR3A5IuoQQ3d7F1L7
kSVEvhjlk6ifQfMCAbJnFf1KCJSkWFoqheuaodWNA9ycf/1nUHxvVxIN82Mz
OtiSdWyY9fks6+QG65razBNn7sEmDh7pCCxCeA2iOHjaQUQlW4jaWbTQY2QN
AxtE+0xv0YZCR/eEmZ3uaiT8cxDXgowh1M2hfx2sz+dtgxBXg9RhqBZGt9qk
Jz/oLaE1phose51DOorF6FvFtFpv7YJzvrgcgZuJ8C0gaqRQjGoZWheJFNE2
ZGhlnTcttvXBVfo2f1wJwrUw2EbCPhZOCXBLhfcrBBQhtIr0/dM2vOwmmv3V
MBlHFVKw6WovonMZvFX0rpO6MYDqB1a3DLkvv3cQyX0WfX98ZLTLVmBkwfpE
yjJbpVUUy1VvEYxL0XBKhl8hImoR3YRnnUimxUMMzjy4y+CvkwbRSntxm/ak
ddvbWtYN3blIUv1ndGw5he5V4sdtqmHzDMUTWN6m4/Dt7T519kOd6zN0rsAx
FD7ZxLjQn9tn5hzuwD4Uzk/gl4WwSqQJCHg100xHrdMAa9394RIAx0DYBxMP
w+4+7B/CIQrO8XB/Ce8M+OUhuBQRNYhtIlo8qRcZg8gdRdEEKmVgzxHwOpbR
tUp6fge/3uUtQ+7M7x5A7ge7UvfP5Js56ysF69wmrfnMA2AdiRsviCIJq0FM
C55zSZ+XStA4C94ShtbJCJphqJY2iU+nY309f+o+bhciuhXFYxhcxYwKWjX0
SjxqxfAiluegGIWwBbUlyCjA8wrShGIZoh4j5BHuPiH+aQDtVNElNBC1UDhG
ZLl5iShXv2DcpgOCELiHwjUczg/g+hhutD55Cs9E3EqBXzaCChFagcf1RMAT
mNpmDRGdVyJBlRwN82heRNsyuGvMetYaOhaUhiyTf3UAn7/dj48Z67SS1mbH
b8MyAleewzUbwZWIZgxCGp8o10Y5uhZpDUB8qdktMiejVIN2ePVbOtbFdat4
3KsjFWuVk4lxBUMkrVNgmwaBi3whSgTI5iNpAC9oi5eFzDQ8Sybx+eMMPMxD
VAWeNSGlB1nDKJUSs1Mzqw8NR3A47oST4NMnErei4B2LW/HwSYBfMgIyEPSK
2P8wWniqCbDxtNblEQncGXmlU6ieAXseTQq0LqNjFdwVcGaWDTkY3zuAjCHf
CuOLfE0jRKsni1Cci4NDBvzLEMnZVfOl42iQ7fpZYxtESS+qSFSwpYJ+S6/f
IJ7EpVQiLPnD4ExhaIHEt3O0aZQTJuapIbIGNtiB7mayhaaqimxuzixDaiVe
1iCBTawsrdcy6TEhRbFc/yQGUdF4GI3waIRG424MgmgRi0dAAgKTEJyGe9m4
n48HJXhYQex6VMOu4NCaIJMZW/TIrpDRGIO9gKYlAg89Xg8w9L17AJn9nH5E
AzHI/JF1auW4D07FwDYVt4pxn42nXBLlF4mI+9ksR/cChKvEA53dxPImNjYJ
I7VGSWDRL4N1R+dehqhOpPDRMgXuJHonMDBOlgn7hOD1o4WHmg6UtqKQjsFa
kdGOlK5dQLLGkC1BWiKSniPhOZ4+J0cioxPI5M+DBNxPROhLhKbifiYe5CKS
9t7K8LgK0bTRa0R8K7F7rwdTsQTlMlTOoJZ2HBXgKNCwAKP//LOY7PGvM+Po
n2ggTsbgRjp8advKwTNGIEvFqJ9C2wz6FGSBTrqOhQ0sK7GmhHKd8MpvL0Or
gG4e2zNwKEVYC551E1kpHkLpEI6Uk5mS0gGU0KqD9hkFyOQjfQjJw3g+jEd8
XWk2CjKQnYqMNHLyKCkNL9LxPB3x6YjNQFQGIjPw6BUe5yOqBNEViKV9PTbi
moixesF4fNmM6achoEdfmRxVs2QM1i/Q3ovGkKvvnQMI/P1h4+WfaSQsaJFI
h085wjmI60JSP4lIGqXonIVAAfEKpmhVukb7N1haxcoK1pcIv9/mHDbkUEqx
LsHaGJZH4VID/2aEtOMBj466Irth9JOduRBC4l2JpjLUl6CyECV5KMghZwKy
XyEjB6k5SMpBYi6e5SIuFzF5ZKIllg5rSxFXhfg6PG3EsxZidGiLTXcTHT3k
j6FwAkVTKJGhfAZV86icRfGUysj0W1DY0aXv7hrrd/bGxec0AuaxsMnA7Qrc
b0J0BxJ6yHuqJ0i0y6cHxQLEi5hUQL6E+SUsKrC8gKVZKKaxOEWYrOkIb34U
c8OE+lQmIKuLYh6GOwhle18TuthoqwOnGrUVqChDaSmKSlBQjNwiZBchowip
xUiiHcwSPKWvMjyrxLNqPK/D8wYkNBHH8yUXST1Eg70aQa4IeeMomNxRMiif
Rck0jI4ZtPvIG+3en+/d6C2cHEafmfngeCyuZeBWBUIaENnKCEMfEYaWaXTK
0TODgRmMzGJ8DrJ5zNDXDOTTkEsxLYFsHDIxpCOYFGJiEGIBRvsx1A0+Fz3t
4DajlYMGNmrrUFWL8hqUVqOoCvmVyKlAViWZ+E2hg40qvKjBy3q8bERSE5ke
SqYjRtqWdhPvmzbXtOV5NYocOhaXIH+KhONF08iT6o1+xhiJ1whgJ0b9Zubq
3UPiBEMcGHn4mBWFyxnwKkdgHcL3yUPVBBon0UqrPin6ZBiUYXgaYjnG6UuG
iSlMSDDOLDKLRjAixNAABvjg96G3BzweOjrQ3IrGFrK9taYJVRyUN6KkEYUN
yGPjFRuZbKQ1IJWDtGaktSG9Exm0/uxBJt1wAel9WpdkDCNLhOwx5EiQO4U8
GT5i1N3rdr/uc0Ne1z3vfs9Tfd3vH5pF4EI63MoQzH6j0yvEqBsDZxytE+iU
gDeJvikIpBicwqAEg7TmF0MwQlaLegbBE4Dbj/ZetHYTQ9DUhUYu6rlkR291
Jyo7UdaB4nYUtCG3FdmtZC46m4tsHjJpR5KZiE4bJDFqyhDShpE+iswxZE0g
exIvRbpP9kn3N71q2MI9xhlGw/+HWbDOOh3OpQikW9W224W0ri4ZRvkIqkdR
J0KjGM1jaB8HdwJdY+gSoXMEbUK0DJLtnRw+GvrB7kNdD2q7Ud2NSh7KeCjh
oagLBV3I60IO3YYuZPUgo3+3DUfoRhh9l25GMqP5U0eRNoa0cSSNEdL4w9rB
zLa+EYkZnjhg4tmfnk6DQwkCGvCgDfHdRE2nMmJBm/DcIRQKUTqMyhHUjpJ1
kEYRGkZQP0w2AdcMomoAlQKU96OsDyW9KOpFQS9ye/Cqh1Q+s59ECvv7gK58
Em3RXgrpmiWNIkmEhFFECbRfEIzf0CsE8R8cIltML/zIPBlX8+FRDb8GhDTj
YQdiuxHfg2e9eN6HxD687Ecy37AhxUIUDaFgAPkC5PLxio+s/t0xsFtDGme6
ikbfTRKCruMLIRIZIxsvRMwQoeo+OAP4HfrrTq1/tFvbH5Nvf083xjwJN8vh
VgOfBgQ1I7wDDzoRycXjLkTxEMPDk8PqbHQkRQCjv0kS4IUACQI8F+CpAHEC
xPDxsA8Rvbjfi88MakI00Ht7MfbOnI8Bp+WBE4A/vFoCp2q418GLjVuN8G1G
QAsC2xDcjpBOhHIRzsODbjzsISsPIVwEtMO3Db8zfLPR7gw+My/wesZp39vO
7mpJZo6V4Sh9PZr23WVpYEvIR8YTN/rX3ScMZ8BYh/QGeQ/jjzD8sQdmGwye
Jogxs7dMbY4YfcMuZTjfbtjz+zX+Xm2Z+u38fGPU7ZVpuCP1MGkiD/7LW8ox
3FNpuKPq890W/YPBfd9/S3l7Z5UNy/n4zTt3a/WPf2Gp38fhsz2Ga2kf7db2
n3bL/8Fbytufu5kgbbh2/MFuOT82uO9v3+jXv9v93/DpnxrU8nu7tfnp7v07
pZjsK2X/0/9u8PQ7u0//vzeePmpwl+Hazf5S9mTph7sl/e9DUX8f3+jH/SX9
i8HdexL1vwzewLyRQc5w3c2wtL0e2n8fg9mOX2SA3P6n/xEHW/V/DJ5hxigT
Y5Fa/tVuqw7dOXhAHg17bqcsyuCthnsKDHfXGmYGf3e39H9/852vMTM+tNXf
vM9wd/SB8o122kvaycxE7PJ/v1mi4fghNv2vD6BA+uZ/7t79m0PLYuz9e69r
t6+k17L1Rhu/eN0fB8fgazu8e+Zmf/32+vef31IihTdH4R5Ce8/9+C3P/Xr3
/p+85e833vL7E/jGEnyDjoVBjc8w/396CGaH+fRWh95tGPueZu76ZLeM//HW
v+6vxw8PtGKnZr/arf1eK6zf+K3zofVxZH5beOCn0Xf+P5M0d1g=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{173, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21819997]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"1.16", "^", "v"}], " ", 
      RowBox[{"Cos", "[", "v", "]"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"1.16", "^", "v"}]}], " ", 
      RowBox[{"Sin", "[", "v", "]"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"1.16", "^", "v"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", "u", "]"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "15"}], ",", "6"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2037587217],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40711987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1029081900],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Exclusions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exclusions"]], "InlineFormula"],
 " to split the resulting surface: "
}], "ExampleText",
 CellID->76875945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "-", 
        RowBox[{"v", "^", "2"}], "+", "1"}], ")"}]}], ",", "u", ",", "v"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"u", "^", "2"}], "-", 
       RowBox[{"v", "^", "2"}], "+", "1"}], "\[Equal]", "0"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->424980419],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57476233]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->772275229],

Cell["Multiple curves are automatically colored to be distinct:", \
"ExampleText",
 CellID->150311282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"8", "u"}], "+", "i"}], "]"}]}], ")"}], 
         RowBox[{"Cos", "[", "u", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"8", "u"}], "+", "i"}], "]"}]}], ")"}], 
         RowBox[{"Sin", "[", "u", "]"}]}], ",", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"8", "u"}], "+", "i"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "Pi"}], "}"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74897845],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25700326]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19467850],

Cell["Provide explicit styling to different curves and regions:", \
"ExampleText",
 CellID->12356458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"8", "u"}], "+", "i"}], "]"}]}], ")"}], 
         RowBox[{"Cos", "[", "u", "]"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"8", "u"}], "+", "i"}], "]"}]}], ")"}], 
         RowBox[{"Sin", "[", "u", "]"}]}], ",", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"8", "u"}], "+", "i"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "Pi"}], "}"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", "Dashed"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235628210],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235403722]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], ",", 
       RowBox[{"4", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
       RowBox[{"4", "+", 
        RowBox[{"Sin", "[", "v", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"8", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
       RowBox[{"3", "+", 
        RowBox[{"Sin", "[", "v", "]"}]}], ",", 
       RowBox[{"4", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"12", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], ",", 
       RowBox[{"4", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
       RowBox[{"4", "+", 
        RowBox[{"Sin", "[", "v", "]"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37527117],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106576110]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73338555],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " to show internal structure and ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 " for additional depth cueing: "
}], "ExampleText",
 CellID->775135223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "u", "]"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "u", "]"}], "+", 
      RowBox[{"Cos", "[", "v", "]"}]}], ",", 
     RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.8", "]"}], ",", "Yellow", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "50"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208716656],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyNXWuQVtWVbVAMOj5AM4mJqEDUMtEogzia+E0WURAfmLIYKjH4JL4QHfGB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   "], {{
     {RGBColor[1, 1, 0], Opacity[0.8], EdgeForm[None], Specularity[
       GrayLevel[1], 50], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3QnYdlP1BvDzPs95/yJChMxzmUmGaDDPU4YMmRUyZZ7Th0imzGTmkzkk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        "]]]}, {}, {}, {}}, {}},
   VertexNormals->CompressedData["
1:eJyFXHecVkWyHVDUXQMCLiJgAOWxrohvRReVCzWkNZAEE6i4iooSFETx6YIw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    "]],
  Axes->True,
  ImageSize->{180., 202.2059482132854},
  PlotRange->{{-1., 1.}, {-2., 2.}, {-1., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{1.5768934753318855`, -2.545049793981625, 1.5767461791962},
  ViewVertical->{0.26310604439734414`, -0.09288149499988432, 
   1.9738964818216604`}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{184, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->944660782,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80823672],

Cell["Add labels:", "ExampleText",
 CellID->66674802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"8", "u"}], "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"8", "u"}], "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"8", "u"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<coil\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73436451],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27353656]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<torus\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17296097],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->411080101]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193501475],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for each curve or region:"
}], "ExampleText",
 CellID->703033904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", "u", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"Cos", "[", 
             RowBox[{"8", " ", "u"}], "]"}]}], ")"}]}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"Cos", "[", 
             RowBox[{"8", " ", "u"}], "]"}]}], ")"}], " ", 
          RowBox[{"Sin", "[", "u", "]"}]}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"8", " ", "u"}], "]"}]}], "}"}], ",", "\"\<red\>\""}], 
      "]"}], ",", 
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", "u", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"Pi", "/", "6"}], "+", 
              RowBox[{"8", " ", "u"}]}], "]"}]}], ")"}]}], ",", 
         RowBox[{
          RowBox[{"Sin", "[", "u", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"Pi", "/", "6"}], "+", 
              RowBox[{"8", " ", "u"}]}], "]"}]}], ")"}]}], ",", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "6"}], "+", 
           RowBox[{"8", " ", "u"}]}], "]"}]}], "}"}], ",", "\"\<purple\>\""}],
       "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Purple"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162853632],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   {RGBColor[1, 0, 0], 
    TagBox[
     TooltipBox[Line3DBox[CompressedData["
1:eJwUWnk41N8XnrEkQhvKVtoltJCl0vlQshdZsrYoaypp4VuotNgVSlEpSilb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       "]],
      "\"red\""],
     Annotation[#, "red", "Tooltip"]& ]}, 
   {RGBColor[0.5, 0, 0.5], 
    TagBox[
     TooltipBox[Line3DBox[CompressedData["
1:eJwUWnk4VO8Xt0xoQflmjZCSlNBiiTq3lFBJlpJUkjUlFJIlIYQUCqVEliht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       "]],
      "\"purple\""],
     Annotation[#, "purple", "Tooltip"]& ]}},
  Axes->True,
  PlotRange->{{-2.9999921659125817`, 
   2.9999999999994493`}, {-2.9999905672970093`, 
   2.999991840162093}, {-0.9999999966336229, 0.9999999999346731}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1177083128]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"4", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
           RowBox[{"Sin", "[", "u", "]"}]}]}], ",", 
         RowBox[{"4", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
           RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
         RowBox[{"4", "+", 
          RowBox[{"Sin", "[", "v", "]"}]}]}], "}"}], ",", "\"\<red\>\""}], 
      "]"}], ",", 
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"8", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
           RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
         RowBox[{"3", "+", 
          RowBox[{"Sin", "[", "v", "]"}]}], ",", 
         RowBox[{"4", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
           RowBox[{"Sin", "[", "u", "]"}]}]}]}], "}"}], ",", 
       "\"\<green\>\""}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->228985387],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx0nXWclsX39xdYYIEFtotlYWFZWpEG0fuikS4REQlpRFpKWkpBREokJQQE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   "], {{
     {RGBColor[1, 0, 0], EdgeForm[None], GraphicsGroup3DBox[
       TagBox[
        TooltipBox[{Polygon3DBox[CompressedData["
1:eJxFnHXcFcXbxncX2T0+O4ezdqOAkgICKpiA3YGoWCgiYlGKXahgYXcL2Ijd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           "]], Polygon3DBox[CompressedData["
1:eJwtnAn4FdMfxs9MzFzNue7NEkpUtEgplRZEm1BJIrKlQpZSEVmzlOxU9jXZ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           "]], Polygon3DBox[CompressedData["
1:eJwV1XmQz3Ucx/GvK3JMWaawudZ9ixgGkUmjcUWbY8kZuRdFkqOZpMIUI4NU
pDEG05SSI6HCWrvIVZbNsW4l08FMuerx/uM9834936/X5/P5fn/f7/dXfWhm
r/GFkySZoIqpnQ8kybZSSVK+UJJcuy9JctQnpZNkLDZeX7NEknQR2MW3Bu+p
r4sVmGVhd0smSW/rzKGrF0+SRTwjZMfQqXzt+LdgX/FODo8aih2nq+If2XeG
3AuqmNw+vIG+gxpitoe+YI/69rgre0/9jFWWXW4+PXzqFPYklo2toxeq77HV
WA/71XaWU7L5WAtsC98HPLPUd9inWDe+Wnz5fEOc5Qr+n3kK1tRsIc9wfLR5
JawN9gtPRzzLemt531VbeSZG8f2qUsxW8IzBxtE1ZJ+W3S2bg9U0v4OfV3lY
Pd612DxrTYj16I34FPM0NUw2S26Kepn+V1Xj709f5PtbpqQ9avKdpBvKf2b+
Hj5Z3XM/9+Jp+hqqj3s7VPYqVliunGomu4NeIvuEvjKWbZ8Mvgv4H3L3Y2lm
J+I341tvj/n4S+oHLJs3Dbstd0Zt4PkSn6SvovrLtsbKlvG76wdYb6XsJZ5B
sg2xB7FbWB2+edhSuXfoNdbdSW/HX+RrxveX2WXZwXhjrCx2h7c5zwJsuflS
epNsAXYba0V35JvHf1a2F1ZWfxsvUOewvlgVrDjfb/Fc0TvkR2LNsRvWXY99
gWVgjbDDWD86zbWdxJ6jD8qOwOphBVhf7DhWC5srv4R+i17tfM/SBfY+R99V
5fgn8DWRvazPiHuKb+TbjA/Bmtr3Ij6Jbsp3BetPn+VrTI/DT+lH8V0yO2/9
fvLV9CWw382O8FyIZ1LfBpsezxD2J9YEa4/Nxg7IlsWmOWsG3k4dxFKw6diA
8MZ7SR+Qf0WmvrNUxXL4SsW7wNctfh91g87nezOug+/R+B448xbeD+nOarvZ
Vb5jfDPjPmN1+Q7zVMDftt4oumswOotvAl8dvoew/dhuLD6ALVxHoTgztgfL
xFpiReIeWK8iPtd6Y+ju6ijPJay2vi3fDP4z9EF8qr5BvIPhw/ZiE+M7iT0c
+9In8cr61rJTYn/XNjXWxMbGvcf60NXxE/p02QNmw7C62NmYx7cPq00PxI/o
h8ueNutCV8KP6Hvy7Y53hh6MH4vnju+MWWe6In5YPxjbYJYa99Q1p+vHxzfM
dVfCjmI96XFqPvaUbAXZQ7KDZD/H12Eb+DLje6/SzbphqXxH9b2wPXzV6HQ8
N65JNs8sl86zTyrWCpuMVeXrhe/DhmLHsUd4frJHb2yiWuAs5bFDWCd6kHod
K4f9GN9jeqCaiTW2Vilr7op3xnqL4rnGUrAc7HlsFVaa3iq7wnm7xP0zK4N9
g62ku8Z1YGmyRfFv4/eId0F2DtYOuxn3lO+feAad5YzsCf31eJbNdvJ9jU2N
/1U1CuuALeb9mF7Dt9uZ21rrDfwmnRnfF77X6Jb49Tgz71Wz877js+IdpG+p
er7jp63fBSvCd40nL/7fZDfhr/LUUqPNUuNd41tMT+NZFvc0riv+C7Eeaj9f
aZ5c7DGeHnGeuM9827BVPN1Vbtwrvv1YS55n4nfia8Q3xj759Mj4NvFt51mM
tY/fFcuSr0jPln9fP5V3iWw2X1FskP5xrH78b/FtxpfxdVKbrPE/vmIrqw==

           "]]},
         "\"red\""],
        Annotation[#, "red", "Tooltip"]& ]]}, 
     {RGBColor[0, 1, 0], EdgeForm[None], GraphicsGroup3DBox[
       TagBox[
        TooltipBox[{Polygon3DBox[CompressedData["
1:eJxFnHX8FUUbxX9wd3B38e7sNVAREezGbuzuTixsBUwaxAIDxQS7W0lbbLGw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           "]], Polygon3DBox[CompressedData["
1:eJwtnAncF9MXxl/NTN4Z5s68siSKImvIvv6tUbJnSVK2LCnZKkpSWUqrLClE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           "]], Polygon3DBox[CompressedData["
1:eJwV1XmQz3Ucx/Fva90sOXJFaZJboc1VIcfKlJCRphyrSaJc41iqXRu7rs2O
O1fHMiZN5W6kWHKGtewmNCzGKOPIHbLo8fnjNfN5PT+v9/vz+f6+n+/nV3vg
8J7DYqIoGkFFaWW5KLoSF0VvloqifLoLfs/HBJWMotLYvtgoSpDrh83BlmEz
5LqXjaKLVFDCHP5MkSgqVz6KpstlqTmF7aTP1G7Dnla3m06qnaCuqOwi8+sp
Sf6+XA+8qT6J2EAaxcfIZRovp8FyteQu0B/W/ZQG6ldeJsMay82flttDtfkn
5Qabn2vdl7Hicil6TpLbGp6FWsk1lRsjt1DuXaySXBaeHfbFn6FMfqTcdrmf
5c5hu/WqKduL/5Dqm9uD1cLe4IdRQ+wnrCr2At+TymAP8SPxQdbI0msmbeWr
451lEqm6XDtrvm7t6ea/wiZj3cJzYUuwFdhsrIK6z7G1+l3Bj1CW3Fmsq8xB
uiEXhx2zTp7fbmrYD9ZEpiE+3HgB1kdtHf5iyMql0fvmHrbGfNnV1rgs8ztV
xBZi67Hr/DF6St0l+lNdOg1RW0Quybqj5dbILKBiWDKWim3hv6b7euVhB9Ql
28tLanP5J2QH8eOoFXYAq429w4+lFthitUnW3Wu8Bbul33j+GhUxXqXnvnD+
+OsUi63G9mNl+KN6HuKnqO2OVdF/I1YqnHfseYrk8rFcuRS+o7nxfGz4/fVb
R2M9z1AswtL5KdTPud5hfzPVn1KzUX1T9SfCe8T+CXvGOmDT1Map3aTucPit
9JuIlcBW8L9SGnZO7TK1N9VuU/uq2kdldsnWxT7ge1A7uWflkrAMuY/UT8Wu
yd3hC8LZ0i8fmy93Tu4XvI3audhtuUL+ktwPctWskR3OtFx/mU7UW6692jRs
lmxG6Indk3vAF/Kb1Z7ElspdlsvGO6qtod9OuTrYUP61sK5MjmxL4730l7l/
sRjqbDwRa6DnrfAeqQuWijXC2qhrho3FFmHvhXegfxnrbDA+RHPsZZTMVYr4
7+xlh/w9vkX4HswPwBPoLhaP1cf68x2oKl8TTwzPa414rCvWGkvGZuo3KfzO
1i0bzpFxHs3T40W55nLj5GbITcBv8/XwGua7802obbgTsanGX1pjkvwrfBs8
xThT7WRz17FvsUJsB/a2bKp1S1p3pfnt4fn1rSJzPpzfcHbpLfnZam/J3uUv
hN9B7o5MeeplfppebfFG4YzS8XBv0AhzjcN7pBP8NBqJHdRvHvZ3uCex1uon
8jeomD5rsTxzj9nbfus2Nx4t048eyAzB+vpWzod7R/5xuRwsXm6MzABqbo0z
2FGZvjJ17bml2k54Cr9E5mP5VlgClootxT4JZyR8L1Q8fKvq87FdMpnY6XBX
Y81kV2DJ2EFsKx8bzhbWABuGzQ9nXo9CvhL1Cd9W+BawTeGdhfsP+1G/+njp
cBfY8yx7zQ2/A1XGVsnmYGVlrmEb+PRwF4V3iVWmdVgadgTbzlekoeG/m+7p
v5I2m/uPr0C9jafLtNdvo9op4R7HNsjVwzP4bLyx8S4qMPeIvazBcu0lDrup
dnF4hvBd8zl0Sa6UXJrnyJTLCfdnuO9lCrDD+nfjq5n7JrwL9YfC3aS2GM3h
9+HPGf9GZ8P3GZ4Va8vvp4tYIt8Fzwj/3XrO0zMdu2qN2/xx/gtr/A+7rD0H

           "]]},
         "\"green\""],
        Annotation[#, "green", 
         "Tooltip"]& ]]}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {
      Line3DBox[{236, 234, 3222, 576, 238, 3245, 599, 277, 3259, 613, 302, 
       627, 3273, 318, 641, 3287, 334, 655, 3301, 354, 669, 383, 3315, 683, 
       412, 3329, 697, 441, 3343, 711, 466, 725, 3357, 482, 739, 3371, 498, 
       753, 3385, 518, 547}], 
      Line3DBox[{1554, 1733, 2076, 1734, 4237, 2078, 1737, 1772, 1738, 4242, 
       2091, 1774, 1775, 2097, 1799, 4173, 1800, 2103, 1817, 1818, 2109, 4209,
        1835, 1856, 1836, 2115, 4212, 1858, 1886, 1859, 2121, 1888, 1916, 
       1889, 4253, 2127, 1918, 1946, 1919, 4258, 2133, 1948, 1949, 2139, 1973,
        4189, 1974, 2145, 1991, 1992, 2151, 4227, 2009, 2030, 2010, 2157, 
       4230, 2032, 2057, 2033, 2059}], 
      Line3DBox[{1555, 1735, 2077, 1736, 4238, 2080, 1741, 1773, 1742, 2092, 
       1777, 4169, 1778, 2098, 1801, 4174, 1802, 2104, 1819, 4179, 1820, 2110,
        1837, 1857, 1838, 2116, 4214, 1861, 1887, 1862, 2122, 1891, 1917, 
       1892, 4254, 2128, 1921, 1947, 1922, 2134, 1951, 4185, 1952, 2140, 1975,
        4190, 1976, 2146, 1993, 4195, 1994, 2152, 2011, 4229, 2031, 2012, 
       2158, 4232, 2035, 2058, 2036, 2061}], 
      Line3DBox[{1556, 1739, 2079, 1740, 2081, 1744, 1776, 4167, 1745, 2093, 
       1779, 4170, 1780, 2099, 1803, 4175, 1804, 2105, 1821, 4180, 1822, 2111,
        1839, 4213, 1860, 1840, 2117, 1863, 1890, 1864, 2123, 1893, 1920, 
       1894, 2129, 1923, 1950, 4183, 1924, 2135, 1953, 4186, 1954, 2141, 1977,
        4191, 1978, 2147, 1995, 4196, 1996, 2153, 2013, 4231, 2034, 2014, 
       2159, 2037, 4236, 2060, 2038, 2062}], 
      Line3DBox[{8, 581, 3227, 23, 282, 3008, 38, 2784, 53, 2797, 68, 2810, 
       83, 2824, 359, 98, 2838, 388, 113, 417, 3105, 128, 446, 3130, 143, 
       2855, 158, 2868, 173, 2881, 188, 2895, 523, 203, 2909, 552, 218}], 
      Line3DBox[{257, 255, 3236, 590, 259, 3252, 606, 291, 3266, 620, 309, 
       634, 3280, 325, 648, 3294, 341, 662, 3308, 368, 676, 397, 3322, 690, 
       426, 3336, 704, 455, 3350, 718, 473, 732, 3364, 489, 746, 3378, 505, 
       760, 3392, 532, 561}], 
      Line3DBox[{1560, 1754, 2085, 1755, 4239, 2087, 1758, 1787, 1759, 4243, 
       2094, 1789, 1790, 4245, 2100, 1808, 4176, 1809, 2106, 4208, 1826, 1827,
        2112, 4210, 1844, 1871, 1845, 2118, 4215, 1873, 1901, 1874, 2124, 
       1903, 1931, 1904, 4255, 2130, 1933, 1961, 1934, 4259, 2136, 1963, 1964,
        2142, 1982, 4192, 1983, 2148, 2000, 2001, 2154, 4228, 2018, 2045, 
       2019, 2160, 4233, 2047, 2066, 2048, 2068}], 
      Line3DBox[{1561, 1756, 2086, 1757, 4240, 2089, 1762, 1788, 1763, 4244, 
       2095, 1792, 4171, 1793, 2101, 1810, 4177, 1811, 2107, 1828, 4181, 1829,
        2113, 4211, 1846, 1872, 1847, 2119, 4217, 1876, 1902, 1877, 2125, 
       1906, 1932, 1907, 4256, 2131, 1936, 1962, 1937, 4260, 2137, 1966, 4187,
        1967, 2143, 1984, 4193, 1985, 2149, 2002, 4197, 2003, 2155, 2020, 
       2046, 2021, 2161, 4235, 2050, 2067, 2051, 2070}], 
      Line3DBox[{1562, 1760, 2088, 1761, 4241, 2090, 1764, 1791, 4168, 1765, 
       2096, 1794, 4172, 1795, 2102, 1812, 4178, 1813, 2108, 1830, 4182, 1831,
        2114, 1848, 4216, 1875, 1849, 2120, 4218, 1878, 1905, 1879, 2126, 
       1908, 1935, 1909, 4257, 2132, 1938, 1965, 4184, 1939, 2138, 1968, 4188,
        1969, 2144, 1986, 4194, 1987, 2150, 2004, 4198, 2005, 2156, 2022, 
       4234, 2049, 2023, 2162, 2052, 2069, 2053, 2071}], 
      Line3DBox[{1635, 1719, 2054, 4165, 2025, 1629, 1713, 2024, 4161, 2006, 
       1623, 1707, 4157, 1988, 1617, 1701, 4151, 1970, 1611, 1695, 4147, 1941,
        1605, 1689, 4225, 1940, 1911, 1599, 1683, 1910, 1881, 1593, 1677, 
       1880, 1851, 1587, 1671, 1850, 4145, 1832, 1581, 1665, 4141, 1814, 1575,
        1659, 4135, 1796, 1569, 1653, 4131, 1767, 1563, 1647, 4205, 1766, 
       1727, 1551, 1641, 2073, 1725, 2072}], 
      Line3DBox[{1636, 1720, 2055, 2027, 4263, 1630, 1714, 2026, 4162, 2007, 
       1624, 1708, 4158, 1989, 1618, 1702, 4152, 1971, 1612, 1696, 4148, 1943,
        1606, 1690, 1942, 1913, 1600, 4219, 1684, 1912, 1883, 1594, 1678, 
       1882, 1853, 4249, 1588, 1672, 1852, 1833, 1582, 1666, 4142, 1815, 1576,
        1660, 4136, 1797, 1570, 1654, 4132, 1769, 1564, 1648, 1768, 1730, 
       1552, 4199, 1642, 2074, 1726, 1728}], 
      Line3DBox[{1637, 1721, 2056, 2029, 4264, 1631, 1715, 2028, 2008, 4261, 
       1625, 1709, 1990, 1619, 1703, 4153, 1972, 1613, 1697, 1945, 1607, 4223,
        1691, 1944, 1915, 1601, 4220, 1685, 1914, 1885, 1595, 1679, 1884, 
       1855, 4250, 1589, 1673, 1854, 1834, 4247, 1583, 1667, 1816, 1577, 1661,
        4137, 1798, 1571, 1655, 1771, 1565, 4201, 1649, 1770, 1732, 1553, 
       4200, 1643, 2075, 1729, 1731}], 
      Line3DBox[{1638, 1722, 2063, 4166, 2040, 1632, 1716, 2039, 4163, 2015, 
       1626, 1710, 4159, 1997, 1620, 1704, 4154, 1979, 1614, 1698, 4149, 1956,
        1608, 1692, 4226, 1955, 1926, 1602, 1686, 1925, 1896, 1596, 1680, 
       1895, 1866, 1590, 1674, 1865, 4146, 1841, 1584, 1668, 4143, 1823, 1578,
        1662, 4138, 1805, 1572, 1656, 4133, 1782, 1566, 1650, 4206, 1781, 
       1748, 1557, 1644, 2082, 1743, 1746}], 
      Line3DBox[{1639, 1723, 2064, 2042, 4265, 1633, 1717, 2041, 4164, 2016, 
       1627, 1711, 4160, 1998, 1621, 1705, 4155, 1980, 1615, 1699, 4150, 1958,
        1609, 1693, 1957, 1928, 1603, 4221, 1687, 1927, 1898, 1597, 1681, 
       1897, 1868, 4251, 1591, 1675, 1867, 1842, 1585, 1669, 4144, 1824, 1579,
        1663, 4139, 1806, 1573, 1657, 4134, 1784, 1567, 1651, 1783, 1751, 
       1558, 4202, 1645, 2083, 1747, 1749}], 
      Line3DBox[{1640, 1724, 2065, 2044, 4266, 1634, 1718, 2043, 2017, 4262, 
       1628, 1712, 1999, 1622, 1706, 4156, 1981, 1616, 1700, 1960, 1610, 4224,
        1694, 1959, 1930, 1604, 4222, 1688, 1929, 1900, 1598, 1682, 1899, 
       1870, 4252, 1592, 1676, 1869, 1843, 4248, 1586, 1670, 1825, 4246, 1580,
        1664, 4140, 1807, 1574, 4207, 1658, 1786, 1568, 4204, 1652, 1785, 
       1753, 1559, 4203, 1646, 2084, 1750, 1752}], 
      Line3DBox[{1011, 1009, 3843, 1351, 1013, 3866, 1374, 1052, 3880, 1388, 
       1077, 1402, 3894, 1093, 1416, 3908, 1109, 1430, 3922, 1129, 1444, 1158,
        3936, 1458, 1187, 3950, 1472, 1216, 3964, 1486, 1241, 1500, 3978, 
       1257, 1514, 3992, 1273, 1528, 4006, 1293, 1322}], 
      Line3DBox[{2166, 2345, 2688, 2346, 4373, 2690, 2349, 2384, 2350, 4378, 
       2703, 2386, 2387, 2709, 2411, 4309, 2412, 2715, 2429, 2430, 2721, 4345,
        2447, 2468, 2448, 2727, 4348, 2470, 2498, 2471, 2733, 2500, 2528, 
       2501, 4389, 2739, 2530, 2558, 2531, 4394, 2745, 2560, 2561, 2751, 2585,
        4325, 2586, 2757, 2603, 2604, 2763, 4363, 2621, 2642, 2622, 2769, 
       4366, 2644, 2669, 2645, 2671}], 
      Line3DBox[{2167, 2347, 2689, 2348, 4374, 2692, 2353, 2385, 2354, 2704, 
       2389, 4305, 2390, 2710, 2413, 4310, 2414, 2716, 2431, 4315, 2432, 2722,
        2449, 2469, 2450, 2728, 4350, 2473, 2499, 2474, 2734, 2503, 2529, 
       2504, 4390, 2740, 2533, 2559, 2534, 2746, 2563, 4321, 2564, 2752, 2587,
        4326, 2588, 2758, 2605, 4331, 2606, 2764, 2623, 4365, 2643, 2624, 
       2770, 4368, 2647, 2670, 2648, 2673}], 
      Line3DBox[{2168, 2351, 2691, 2352, 2693, 2356, 2388, 4303, 2357, 2705, 
       2391, 4306, 2392, 2711, 2415, 4311, 2416, 2717, 2433, 4316, 2434, 2723,
        2451, 4349, 2472, 2452, 2729, 2475, 2502, 2476, 2735, 2505, 2532, 
       2506, 2741, 2535, 2562, 4319, 2536, 2747, 2565, 4322, 2566, 2753, 2589,
        4327, 2590, 2759, 2607, 4332, 2608, 2765, 2625, 4367, 2646, 2626, 
       2771, 2649, 4372, 2672, 2650, 2674}], 
      Line3DBox[{783, 1356, 3848, 798, 1057, 3629, 813, 3405, 828, 3418, 843, 
       3431, 858, 3445, 1134, 873, 3459, 1163, 888, 1192, 3726, 903, 1221, 
       3751, 918, 3476, 933, 3489, 948, 3502, 963, 3516, 1298, 978, 3530, 
       1327, 993}], 
      Line3DBox[{1032, 1030, 3857, 1365, 1034, 3873, 1381, 1066, 3887, 1395, 
       1084, 1409, 3901, 1100, 1423, 3915, 1116, 1437, 3929, 1143, 1451, 1172,
        3943, 1465, 1201, 3957, 1479, 1230, 3971, 1493, 1248, 1507, 3985, 
       1264, 1521, 3999, 1280, 1535, 4013, 1307, 1336}], 
      Line3DBox[{2172, 2366, 2697, 2367, 4375, 2699, 2370, 2399, 2371, 4379, 
       2706, 2401, 2402, 4381, 2712, 2420, 4312, 2421, 2718, 4344, 2438, 2439,
        2724, 4346, 2456, 2483, 2457, 2730, 4351, 2485, 2513, 2486, 2736, 
       2515, 2543, 2516, 4391, 2742, 2545, 2573, 2546, 4395, 2748, 2575, 2576,
        2754, 2594, 4328, 2595, 2760, 2612, 2613, 2766, 4364, 2630, 2657, 
       2631, 2772, 4369, 2659, 2678, 2660, 2680}], 
      Line3DBox[{2173, 2368, 2698, 2369, 4376, 2701, 2374, 2400, 2375, 4380, 
       2707, 2404, 4307, 2405, 2713, 2422, 4313, 2423, 2719, 2440, 4317, 2441,
        2725, 4347, 2458, 2484, 2459, 2731, 4353, 2488, 2514, 2489, 2737, 
       2518, 2544, 2519, 4392, 2743, 2548, 2574, 2549, 4396, 2749, 2578, 4323,
        2579, 2755, 2596, 4329, 2597, 2761, 2614, 4333, 2615, 2767, 2632, 
       2658, 2633, 2773, 4371, 2662, 2679, 2663, 2682}], 
      Line3DBox[{2174, 2372, 2700, 2373, 4377, 2702, 2376, 2403, 4304, 2377, 
       2708, 2406, 4308, 2407, 2714, 2424, 4314, 2425, 2720, 2442, 4318, 2443,
        2726, 2460, 4352, 2487, 2461, 2732, 4354, 2490, 2517, 2491, 2738, 
       2520, 2547, 2521, 4393, 2744, 2550, 2577, 4320, 2551, 2750, 2580, 4324,
        2581, 2756, 2598, 4330, 2599, 2762, 2616, 4334, 2617, 2768, 2634, 
       4370, 2661, 2635, 2774, 2664, 2681, 2665, 2683}], 
      Line3DBox[{2247, 2331, 2666, 4301, 2637, 2241, 2325, 2636, 4297, 2618, 
       2235, 2319, 4293, 2600, 2229, 2313, 4287, 2582, 2223, 2307, 4283, 2553,
        2217, 2301, 4361, 2552, 2523, 2211, 2295, 2522, 2493, 2205, 2289, 
       2492, 2463, 2199, 2283, 2462, 4281, 2444, 2193, 2277, 4277, 2426, 2187,
        2271, 4271, 2408, 2181, 2265, 4267, 2379, 2175, 2259, 4341, 2378, 
       2339, 2163, 2253, 2685, 2337, 2684}], 
      Line3DBox[{2248, 2332, 2667, 2639, 4399, 2242, 2326, 2638, 4298, 2619, 
       2236, 2320, 4294, 2601, 2230, 2314, 4288, 2583, 2224, 2308, 4284, 2555,
        2218, 2302, 2554, 2525, 2212, 4355, 2296, 2524, 2495, 2206, 2290, 
       2494, 2465, 4385, 2200, 2284, 2464, 2445, 2194, 2278, 4278, 2427, 2188,
        2272, 4272, 2409, 2182, 2266, 4268, 2381, 2176, 2260, 2380, 2342, 
       2164, 4335, 2254, 2686, 2338, 2340}], 
      Line3DBox[{2249, 2333, 2668, 2641, 4400, 2243, 2327, 2640, 2620, 4397, 
       2237, 2321, 2602, 2231, 2315, 4289, 2584, 2225, 2309, 2557, 2219, 4359,
        2303, 2556, 2527, 2213, 4356, 2297, 2526, 2497, 2207, 2291, 2496, 
       2467, 4386, 2201, 2285, 2466, 2446, 4383, 2195, 2279, 2428, 2189, 2273,
        4273, 2410, 2183, 2267, 2383, 2177, 4337, 2261, 2382, 2344, 2165, 
       4336, 2255, 2687, 2341, 2343}], 
      Line3DBox[{2250, 2334, 2675, 4302, 2652, 2244, 2328, 2651, 4299, 2627, 
       2238, 2322, 4295, 2609, 2232, 2316, 4290, 2591, 2226, 2310, 4285, 2568,
        2220, 2304, 4362, 2567, 2538, 2214, 2298, 2537, 2508, 2208, 2292, 
       2507, 2478, 2202, 2286, 2477, 4282, 2453, 2196, 2280, 4279, 2435, 2190,
        2274, 4274, 2417, 2184, 2268, 4269, 2394, 2178, 2262, 4342, 2393, 
       2360, 2169, 2256, 2694, 2355, 2358}], 
      Line3DBox[{2251, 2335, 2676, 2654, 4401, 2245, 2329, 2653, 4300, 2628, 
       2239, 2323, 4296, 2610, 2233, 2317, 4291, 2592, 2227, 2311, 4286, 2570,
        2221, 2305, 2569, 2540, 2215, 4357, 2299, 2539, 2510, 2209, 2293, 
       2509, 2480, 4387, 2203, 2287, 2479, 2454, 2197, 2281, 4280, 2436, 2191,
        2275, 4275, 2418, 2185, 2269, 4270, 2396, 2179, 2263, 2395, 2363, 
       2170, 4338, 2257, 2695, 2359, 2361}], 
      Line3DBox[{2252, 2336, 2677, 2656, 4402, 2246, 2330, 2655, 2629, 4398, 
       2240, 2324, 2611, 2234, 2318, 4292, 2593, 2228, 2312, 2572, 2222, 4360,
        2306, 2571, 2542, 2216, 4358, 2300, 2541, 2512, 2210, 2294, 2511, 
       2482, 4388, 2204, 2288, 2481, 2455, 4384, 2198, 2282, 2437, 4382, 2192,
        2276, 4276, 2419, 2186, 4343, 2270, 2398, 2180, 4340, 2264, 2397, 
       2365, 2171, 4339, 2258, 2696, 2362, 2364}]}, {
      Line3DBox[{2775, 2978, 3216, 1641, 3215, 2979, 3218, 4199, 2917, 3217, 
       2981, 3220, 4200, 2918, 3219, 2983, 3222, 2919, 3221, 4029, 4237, 3224,
        2920, 3223, 4030, 4238, 3226, 2921, 3225, 1740, 3228, 2922, 3227, 
       2986, 3230, 1644, 3229, 2988, 3232, 4202, 2923, 3231, 2990, 3234, 4203,
        2924, 3233, 2992, 3236, 2925, 3235, 4032, 4239, 3238, 2926, 3237, 
       4033, 4240, 3240, 2927, 3239, 4035, 4241, 3241, 2928, 2995}], 
      Line3DBox[{2776, 2980, 3242, 4017, 4205, 2997, 2982, 3243, 1648, 2999, 
       2984, 3244, 4201, 2929, 3001, 2985, 3245, 2930, 3003, 4031, 4242, 3246,
        2931, 3005, 1742, 3247, 2932, 3006, 4167, 2987, 3248, 2933, 3008, 
       2989, 3249, 4018, 4206, 3010, 2991, 3250, 1651, 3012, 2993, 3251, 4204,
        2934, 3014, 2994, 3252, 2935, 3016, 4034, 4243, 3253, 2936, 3018, 
       4036, 4244, 3254, 2937, 3019, 4168, 2996, 3255, 2938, 3021}], 
      Line3DBox[{2778, 2998, 3256, 4019, 4131, 2777, 3000, 3257, 4020, 4132, 
       2779, 3002, 3258, 1655, 2780, 3004, 3259, 2939, 2781, 1775, 3260, 2940,
        2782, 4169, 3007, 3261, 2941, 2783, 4170, 3009, 3262, 2942, 2784, 
       3011, 3263, 4021, 4133, 2785, 3013, 3264, 4022, 4134, 2786, 3015, 3265,
        4207, 2943, 2787, 3017, 3266, 2944, 2788, 4037, 4245, 3267, 2945, 
       2789, 4171, 3020, 3268, 2946, 2790, 4172, 3022, 3269, 2947, 3023}], 
      Line3DBox[{315, 298, 4135, 2791, 300, 4136, 2792, 301, 4137, 2793, 302, 
       2794, 4173, 303, 2795, 4174, 304, 2796, 4175, 305, 2797, 306, 4138, 
       2798, 307, 4139, 2799, 308, 4140, 2800, 309, 2801, 4176, 310, 2802, 
       4177, 311, 2803, 4178, 313, 328}], 
      Line3DBox[{2817, 3047, 3283, 3046, 4182, 2816, 3045, 3282, 3044, 4181, 
       2815, 3043, 3281, 4208, 4039, 2814, 3042, 3280, 3041, 2813, 4038, 4246,
        3279, 3040, 2812, 4144, 3039, 3278, 3038, 2811, 4143, 3037, 3277, 
       3036, 2810, 3035, 3276, 3034, 4180, 2809, 3033, 3275, 3032, 4179, 2808,
        3031, 3274, 1817, 2807, 3030, 3273, 3029, 2806, 1816, 3272, 3028, 
       2805, 4142, 3027, 3271, 3026, 2804, 4141, 3025, 3270, 3024, 3050}], 
      Line3DBox[{2831, 3068, 3297, 3067, 4216, 2830, 3066, 3296, 4211, 4044, 
       2829, 3065, 3295, 4210, 4043, 2828, 3064, 3294, 3063, 2827, 4042, 4248,
        3293, 3062, 2826, 1842, 3292, 3061, 2825, 4146, 3060, 3291, 3059, 
       2824, 3058, 3290, 3057, 4213, 2823, 3056, 3289, 1837, 2822, 3055, 3288,
        4209, 4041, 2821, 3054, 3287, 3053, 2820, 4040, 4247, 3286, 3052, 
       2819, 1833, 3285, 3051, 2818, 4145, 3049, 3284, 3048, 3070}], 
      Line3DBox[{106, 666, 1593, 107, 667, 1594, 108, 668, 1595, 109, 669, 
       110, 2121, 670, 111, 2122, 671, 112, 2123, 672, 113, 673, 1596, 114, 
       674, 1597, 115, 675, 1598, 116, 676, 117, 2124, 677, 118, 2125, 678, 
       119, 2126, 679, 120}], 
      Line3DBox[{2845, 3085, 3311, 4218, 4053, 2844, 3084, 3310, 4217, 4052, 
       2843, 3083, 3309, 4215, 4051, 2842, 3082, 3308, 3081, 2841, 4050, 4252,
        3307, 3080, 2840, 4049, 4251, 3306, 3079, 2839, 1866, 3305, 3078, 
       2838, 3077, 3304, 1863, 2837, 3076, 3303, 4214, 4048, 2836, 3075, 3302,
        4212, 4047, 2835, 3074, 3301, 3073, 2834, 4046, 4250, 3300, 3072, 
       2833, 4045, 4249, 3299, 3071, 2832, 1851, 3298, 3069, 3087}], 
      Line3DBox[{2846, 3086, 3312, 1683, 3095, 3088, 3313, 4219, 2948, 3097, 
       3089, 3314, 4220, 2949, 3099, 3090, 3315, 2950, 3101, 4054, 4253, 3316,
        2951, 3103, 4055, 4254, 3317, 2952, 3104, 1894, 3318, 2953, 3105, 
       3091, 3319, 1686, 3107, 3092, 3320, 4221, 2954, 3109, 3093, 3321, 4222,
        2955, 3111, 3094, 3322, 2956, 3113, 4056, 4255, 3323, 2957, 3115, 
       4057, 4256, 3324, 2958, 3116, 4058, 4257, 3325, 2959, 3117}], 
      Line3DBox[{2847, 3096, 3326, 4023, 4225, 3119, 3098, 3327, 1690, 3121, 
       3100, 3328, 4223, 2960, 3123, 3102, 3329, 2961, 3125, 4059, 4258, 3330,
        2962, 3127, 1922, 3331, 2963, 3128, 4183, 3106, 3332, 2964, 3130, 
       3108, 3333, 4024, 4226, 3132, 3110, 3334, 1693, 3134, 3112, 3335, 4224,
        2965, 3136, 3114, 3336, 2966, 3138, 4060, 4259, 3337, 2967, 3140, 
       4061, 4260, 3338, 2968, 3141, 4184, 3118, 3339, 2969, 3143}], 
      Line3DBox[{2849, 3120, 3340, 4025, 4147, 2848, 3122, 3341, 4026, 4148, 
       2850, 3124, 3342, 1697, 2851, 3126, 3343, 2970, 2852, 1949, 3344, 2971,
        2853, 4185, 3129, 3345, 2972, 2854, 4186, 3131, 3346, 2973, 2855, 
       3133, 3347, 4027, 4149, 2856, 3135, 3348, 4028, 4150, 2857, 3137, 3349,
        1700, 2858, 3139, 3350, 2974, 2859, 1964, 3351, 2975, 2860, 4187, 
       3142, 3352, 2976, 2861, 4188, 3144, 3353, 2977, 3145}], 
      Line3DBox[{479, 462, 4151, 2862, 464, 4152, 2863, 465, 4153, 2864, 466, 
       2865, 4189, 467, 2866, 4190, 468, 2867, 4191, 469, 2868, 470, 4154, 
       2869, 471, 4155, 2870, 472, 4156, 2871, 473, 2872, 4192, 474, 2873, 
       4193, 475, 2874, 4194, 477, 492}], 
      Line3DBox[{2888, 3169, 3367, 3168, 4198, 2887, 3167, 3366, 3166, 4197, 
       2886, 3165, 3365, 2000, 2885, 3164, 3364, 3163, 2884, 1999, 3363, 3162,
        2883, 4160, 3161, 3362, 3160, 2882, 4159, 3159, 3361, 3158, 2881, 
       3157, 3360, 3156, 4196, 2880, 3155, 3359, 3154, 4195, 2879, 3153, 3358,
        1991, 2878, 3152, 3357, 3151, 2877, 1990, 3356, 3150, 2876, 4158, 
       3149, 3355, 3148, 2875, 4157, 3147, 3354, 3146, 3172}], 
      Line3DBox[{2902, 3193, 3381, 3192, 4234, 2901, 3191, 3380, 2020, 2900, 
       3190, 3379, 4228, 4065, 2899, 3189, 3378, 3188, 2898, 4064, 4262, 3377,
        3187, 2897, 4164, 3186, 3376, 3185, 2896, 4163, 3184, 3375, 3183, 
       2895, 3182, 3374, 3181, 4231, 2894, 3180, 3373, 3179, 4229, 2893, 3178,
        3372, 4227, 4063, 2892, 3177, 3371, 3176, 2891, 4062, 4261, 3370, 
       3175, 2890, 4162, 3174, 3369, 3173, 2889, 4161, 3171, 3368, 3170, 
       3196}], 
      Line3DBox[{2916, 3213, 3395, 2052, 2915, 3212, 3394, 4235, 4073, 2914, 
       3211, 3393, 4233, 4072, 2913, 3210, 3392, 3209, 2912, 4071, 4266, 3391,
        3208, 2911, 4070, 4265, 3390, 3207, 2910, 4166, 3206, 3389, 3205, 
       2909, 3204, 3388, 3203, 4236, 2908, 3202, 3387, 4232, 4069, 2907, 3201,
        3386, 4230, 4068, 2906, 3200, 3385, 3199, 2905, 4067, 4264, 3384, 
       3198, 2904, 4066, 4263, 3383, 3197, 2903, 4165, 3195, 3382, 3194, 
       3214}], Line3DBox[{3396, 3599, 3837, 2253, 3836, 3600, 3839, 4335, 
       3538, 3838, 3602, 3841, 4336, 3539, 3840, 3604, 3843, 3540, 3842, 4086,
        4373, 3845, 3541, 3844, 4087, 4374, 3847, 3542, 3846, 2352, 3849, 
       3543, 3848, 3607, 3851, 2256, 3850, 3609, 3853, 4338, 3544, 3852, 3611,
        3855, 4339, 3545, 3854, 3613, 3857, 3546, 3856, 4089, 4375, 3859, 
       3547, 3858, 4090, 4376, 3861, 3548, 3860, 4092, 4377, 3862, 3549, 
       3616}], Line3DBox[{3397, 3601, 3863, 4074, 4341, 3618, 3603, 3864, 
       2260, 3620, 3605, 3865, 4337, 3550, 3622, 3606, 3866, 3551, 3624, 4088,
        4378, 3867, 3552, 3626, 2354, 3868, 3553, 3627, 4303, 3608, 3869, 
       3554, 3629, 3610, 3870, 4075, 4342, 3631, 3612, 3871, 2263, 3633, 3614,
        3872, 4340, 3555, 3635, 3615, 3873, 3556, 3637, 4091, 4379, 3874, 
       3557, 3639, 4093, 4380, 3875, 3558, 3640, 4304, 3617, 3876, 3559, 
       3642}], Line3DBox[{3399, 3619, 3877, 4076, 4267, 3398, 3621, 3878, 
       4077, 4268, 3400, 3623, 3879, 2267, 3401, 3625, 3880, 3560, 3402, 2387,
        3881, 3561, 3403, 4305, 3628, 3882, 3562, 3404, 4306, 3630, 3883, 
       3563, 3405, 3632, 3884, 4078, 4269, 3406, 3634, 3885, 4079, 4270, 3407,
        3636, 3886, 4343, 3564, 3408, 3638, 3887, 3565, 3409, 4094, 4381, 
       3888, 3566, 3410, 4307, 3641, 3889, 3567, 3411, 4308, 3643, 3890, 3568,
        3644}], 
      Line3DBox[{1090, 1073, 4271, 3412, 1075, 4272, 3413, 1076, 4273, 3414, 
       1077, 3415, 4309, 1078, 3416, 4310, 1079, 3417, 4311, 1080, 3418, 1081,
        4274, 3419, 1082, 4275, 3420, 1083, 4276, 3421, 1084, 3422, 4312, 
       1085, 3423, 4313, 1086, 3424, 4314, 1088, 1103}], 
      Line3DBox[{3438, 3668, 3904, 3667, 4318, 3437, 3666, 3903, 3665, 4317, 
       3436, 3664, 3902, 4344, 4096, 3435, 3663, 3901, 3662, 3434, 4095, 4382,
        3900, 3661, 3433, 4280, 3660, 3899, 3659, 3432, 4279, 3658, 3898, 
       3657, 3431, 3656, 3897, 3655, 4316, 3430, 3654, 3896, 3653, 4315, 3429,
        3652, 3895, 2429, 3428, 3651, 3894, 3650, 3427, 2428, 3893, 3649, 
       3426, 4278, 3648, 3892, 3647, 3425, 4277, 3646, 3891, 3645, 3671}], 
      Line3DBox[{3452, 3689, 3918, 3688, 4352, 3451, 3687, 3917, 4347, 4101, 
       3450, 3686, 3916, 4346, 4100, 3449, 3685, 3915, 3684, 3448, 4099, 4384,
        3914, 3683, 3447, 2454, 3913, 3682, 3446, 4282, 3681, 3912, 3680, 
       3445, 3679, 3911, 3678, 4349, 3444, 3677, 3910, 2449, 3443, 3676, 3909,
        4345, 4098, 3442, 3675, 3908, 3674, 3441, 4097, 4383, 3907, 3673, 
       3440, 2445, 3906, 3672, 3439, 4281, 3670, 3905, 3669, 3691}], 
      Line3DBox[{881, 1441, 2205, 882, 1442, 2206, 883, 1443, 2207, 884, 1444,
        885, 2733, 1445, 886, 2734, 1446, 887, 2735, 1447, 888, 1448, 2208, 
       889, 1449, 2209, 890, 1450, 2210, 891, 1451, 892, 2736, 1452, 893, 
       2737, 1453, 894, 2738, 1454, 895}], 
      Line3DBox[{3466, 3706, 3932, 4354, 4110, 3465, 3705, 3931, 4353, 4109, 
       3464, 3704, 3930, 4351, 4108, 3463, 3703, 3929, 3702, 3462, 4107, 4388,
        3928, 3701, 3461, 4106, 4387, 3927, 3700, 3460, 2478, 3926, 3699, 
       3459, 3698, 3925, 2475, 3458, 3697, 3924, 4350, 4105, 3457, 3696, 3923,
        4348, 4104, 3456, 3695, 3922, 3694, 3455, 4103, 4386, 3921, 3693, 
       3454, 4102, 4385, 3920, 3692, 3453, 2463, 3919, 3690, 3708}], 
      Line3DBox[{3467, 3707, 3933, 2295, 3716, 3709, 3934, 4355, 3569, 3718, 
       3710, 3935, 4356, 3570, 3720, 3711, 3936, 3571, 3722, 4111, 4389, 3937,
        3572, 3724, 4112, 4390, 3938, 3573, 3725, 2506, 3939, 3574, 3726, 
       3712, 3940, 2298, 3728, 3713, 3941, 4357, 3575, 3730, 3714, 3942, 4358,
        3576, 3732, 3715, 3943, 3577, 3734, 4113, 4391, 3944, 3578, 3736, 
       4114, 4392, 3945, 3579, 3737, 4115, 4393, 3946, 3580, 3738}], 
      Line3DBox[{3468, 3717, 3947, 4080, 4361, 3740, 3719, 3948, 2302, 3742, 
       3721, 3949, 4359, 3581, 3744, 3723, 3950, 3582, 3746, 4116, 4394, 3951,
        3583, 3748, 2534, 3952, 3584, 3749, 4319, 3727, 3953, 3585, 3751, 
       3729, 3954, 4081, 4362, 3753, 3731, 3955, 2305, 3755, 3733, 3956, 4360,
        3586, 3757, 3735, 3957, 3587, 3759, 4117, 4395, 3958, 3588, 3761, 
       4118, 4396, 3959, 3589, 3762, 4320, 3739, 3960, 3590, 3764}], 
      Line3DBox[{3470, 3741, 3961, 4082, 4283, 3469, 3743, 3962, 4083, 4284, 
       3471, 3745, 3963, 2309, 3472, 3747, 3964, 3591, 3473, 2561, 3965, 3592,
        3474, 4321, 3750, 3966, 3593, 3475, 4322, 3752, 3967, 3594, 3476, 
       3754, 3968, 4084, 4285, 3477, 3756, 3969, 4085, 4286, 3478, 3758, 3970,
        2312, 3479, 3760, 3971, 3595, 3480, 2576, 3972, 3596, 3481, 4323, 
       3763, 3973, 3597, 3482, 4324, 3765, 3974, 3598, 3766}], 
      Line3DBox[{1254, 1237, 4287, 3483, 1239, 4288, 3484, 1240, 4289, 3485, 
       1241, 3486, 4325, 1242, 3487, 4326, 1243, 3488, 4327, 1244, 3489, 1245,
        4290, 3490, 1246, 4291, 3491, 1247, 4292, 3492, 1248, 3493, 4328, 
       1249, 3494, 4329, 1250, 3495, 4330, 1252, 1267}], 
      Line3DBox[{3509, 3790, 3988, 3789, 4334, 3508, 3788, 3987, 3787, 4333, 
       3507, 3786, 3986, 2612, 3506, 3785, 3985, 3784, 3505, 2611, 3984, 3783,
        3504, 4296, 3782, 3983, 3781, 3503, 4295, 3780, 3982, 3779, 3502, 
       3778, 3981, 3777, 4332, 3501, 3776, 3980, 3775, 4331, 3500, 3774, 3979,
        2603, 3499, 3773, 3978, 3772, 3498, 2602, 3977, 3771, 3497, 4294, 
       3770, 3976, 3769, 3496, 4293, 3768, 3975, 3767, 3793}], 
      Line3DBox[{3523, 3814, 4002, 3813, 4370, 3522, 3812, 4001, 2632, 3521, 
       3811, 4000, 4364, 4122, 3520, 3810, 3999, 3809, 3519, 4121, 4398, 3998,
        3808, 3518, 4300, 3807, 3997, 3806, 3517, 4299, 3805, 3996, 3804, 
       3516, 3803, 3995, 3802, 4367, 3515, 3801, 3994, 3800, 4365, 3514, 3799,
        3993, 4363, 4120, 3513, 3798, 3992, 3797, 3512, 4119, 4397, 3991, 
       3796, 3511, 4298, 3795, 3990, 3794, 3510, 4297, 3792, 3989, 3791, 
       3817}], Line3DBox[{3537, 3834, 4016, 2664, 3536, 3833, 4015, 4371, 
       4130, 3535, 3832, 4014, 4369, 4129, 3534, 3831, 4013, 3830, 3533, 4128,
        4402, 4012, 3829, 3532, 4127, 4401, 4011, 3828, 3531, 4302, 3827, 
       4010, 3826, 3530, 3825, 4009, 3824, 4372, 3529, 3823, 4008, 4368, 4126,
        3528, 3822, 4007, 4366, 4125, 3527, 3821, 4006, 3820, 3526, 4124, 
       4400, 4005, 3819, 3525, 4123, 4399, 4004, 3818, 3524, 4301, 3816, 4003,
        3815, 3835}]}}},
   VertexNormals->CompressedData["
1:eJylnXecl9XR9lFRFEHsDbsxGnuNbZOjAlasYIkxir0rIArSRYo0AUE0wQII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    "]],
  Axes->True,
  PlotRange->{{0., 12.}, {0., 8.}, {0., 8.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->616776132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->316520050],

Cell["Create an overlay mesh:", "ExampleText",
 CellID->18061074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"8", "u"}], "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"8", "u"}], "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"8", "u"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "25"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142919983],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1W+lyHEUSbk33jA5rNJKQ7JFkWTKWMWDjC5YlgJ3lNKc5gh9E8IMIBzFg
ExAc60fYd+BFeL0K6MzKrMr+qrp7RrGrsGemqquz8r6q++Gjp4/nPz96+uS7
R6cf/P7o18dPvvvP6YNffq+nypWiKP6s//93WtS//6p/8f8/nXP1heTz+/qz
qhd8zKMf6LOshzzS2cdmln5+xLNPYHZXIN3PXt2uPwYEsvSg6ZPG9wIWRRVX
F8Wk/qLbhwxnPp/LPXcDnnT3lnyv6SrB2696KjA2GLq/6hfc4a/fDGz6G7es
+0XgEE7FMFyXvW7z90+yZtdgwjQCH27y6h9l9V5zR6FmUzh5HGgtlXEG0g7s
hNc3QJYe2lz2OIS7K7i7FBwQ6mWG8q5AORbcLvdAuwDjI4byTiL1A4FntQRh
Dzvo7IJ9SXC+1gNvlNx53AJxT7C93gNxVXa+0gJnV+DcyEgUbeZGCwy1lxcB
xirgcr0hP7Wflxa66wvZ4w6sXoPVZ7z6oay+D6vXYTXLo/hEMPnHQqs/FNj/
zKwmKB6DBxn+4R2omVd5KX1WIjG6iPqMWOahPGtmC7ESwuffcPcm3H3K648E
B9x7KvNvAZQxrDthKGcwqzr73rnu3hUKXqHv2Zt/oA8ay/XTwMWmlu7I7nr/
QL4nAGcC+x4HfhJ0jSUvEzQCW9YgZKXnVhxvLgT5nuBFch0EiF5woyUheg95
R3Cc8lXX2K9yGrEi1AsAdRugeq92S/A8EMqvCLR1gLbRA60S7PYZ6gsC9Uhx
rQHV/wrixHEWzzgm7lAA2zE7FKq1ibf0Po52Zv2qhMv8r28nMmIiqQLaeOdh
2En2x7jLcZn1ucxcvdzEpv5xGXYfmzFlDIP6w2YdgcsLYqK6zBY2DPvUf8T5
o8zutCNqyU7C5fxuJ0L3cwB3AOMpjDeE58x8P51oKko+j8Gx0PtiDwYXYbzm
rNTb7WXLSDZq9qHM3oK7Sxjvw3gou6727GppD9hzpkGTd3t23cvwogxSBh6Q
WtBFtc3gNePunuY1l9dx4spQuHNvCcxU27dyPKqH3tJtDkuzGNM8bhjNed+G
/oZoJ8l8H6a7Op7zn1hEtCfRiHoCrbWUeYzde+GuXP6bYgwz9QaIM+ruROT8
TMBVfSDhg757mNGGqOH9HNUskvlQg+3Tyk3BDi2To66JjRoh0CaGwlebQxbn
wBf9/Es9XFVPgfwKeDc4PQboGOUxA95dEvuh68Yeua4eB/MC5LqTrD3N1psx
OcVd9WbU4G+UD2KMPtPbuY1UOV+1bcakIZgh9vGZ14eKyVofxxbjw1Z78C0V
37n+oQebNCmqf2D13octU5upGHldkgmgZd9KODrgWJvPOgLGSbbwTA/WyjGv
B1oNKT+94A3yHvvKYj/IYH8z4S96jP8N9sjzSRfPE6zROz3vNKNpz0EQb9Qb
XL+s1my1UKBy0uwcK40zl8+FEJ/NHnrQ96AE0IMug3/iHc0Y6SFb36i3SbMt
7+f+33Rh30J7XkxZ8EE5XxR3j9C9fcRKr5RYTrGQlvH1kQ+cEobYAFC7kEqU
9h7si9cx7g5h7Knbg1mswDmaQm1NtjQQOyequNvCgg/VsicpkUwfTfs9NKGk
sCfiXZhGNpSUtakdoWHVpXFVq52RixnMYvRhFERNuwj0oaZiXoH08dhDTbPl
bP6Buu9XWu3TfOmCM/lxIxqi1HCc8xMx92+nFju2KK/lqUWbaOwoOk+XbXbi
nPXUMZ/dWJJqsgZSEPYeYhXpCQBQ31mzL0d/Urt07K09FFrn+29FyNdztOe6
PcEatFXiKwbN+BvnI3R1Q2QkZAmqIYM7F5372Z20fp461HWr/X5yIUqroBmu
KFB3PN4Bh+DJI5ZrC9OHGnDJyHEmhT/1hLA3WbnoiYm8dl2N+r0j9yyKv3pV
613pm3qQmK8Sjn0d2cTztvhPjptOPRlGed8JoZ/YBYla1VZBEEY0te9Md8sD
9J3rlpyCrq8lutXnH7CjFfCX8Viw8dxOdSNfS+y5fLV7AmPWrIZXjxWmZ0of
/pdyEDv636MuOpL8fFvowA72lW46nNHhjowQde+AEYQKBLrXgQcLy2JLaAic
lN4VyyKpd3LxY2kaGhLtk0jVQo2tN+z6dQfRUugJ1p3QxKcAM38eRLatvTXb
RWc/Bpiix+nCtJHRCeacgUo8s5hS37cyfmgmPfVKg4mPA6xlA4ndiFfo4jQ6
DtpJQ22hmy8JNAuJvNeFek69N7Eu6rbPO3F37cD53fXMTWN34KnQyhY0833Y
EugbyM7ok3W+GeGw40b0UoBA/AZBSm195nCtvulUuLLlTL810SCmahVm5dph
L6aVsxUkYpqtS9M8sr7tuuCoddumfKMN4qle6mWnlkpFO+mxhbrwHDgjD850
LLJnmlxaRStt9kwnn6E3x6XTXrelMx8dmmPSIayWF6USOXZmxqrhqN3rzlp1
PpbTzzUXNRJrwZRSPCOy0PSMBC0Fu0+LUj3KUW3OWAo2FYI2ymhntiPQoMXj
hXoZLQ5PpmzORbQifuelkz2q2F2zfitCbou6mKM2Vun6N5O6pKODPdN+r1kx
b551oj/J26r2FjRDxlXXnLE4ybqy1QRwPN97yOVrNNx2sdeU7+C107HCeB3A
7FUDhRiD3MI+p5evzY3zfQ7EK+ailQrf0Ma1aeZkBM/zsO72NOFzbmlONtdT
wz7KjL2gDiJdI5FeaaXOsVLi+CztrixGzxHMHmcxbVYXeY7b9e3WhdY3dKCX
gSfkiSZZvjS7iilN/FxUPYm0VDLfRwPGHNR+pGEE0uQY5YpEv9FK0Io89ldg
9iCLLcoV5b44Na2dCjiHiVaE2r0YXScwe9FyrRUKyD7xyT4WWR+B9KjUu2pQ
jDcYjzwFpzDLNbNLz1Wy+rIA5taCGeF5egaG1T/mQZjfeMyvCg+oesDMpK+7
yrxJKn7suATpNSJ6O9545kx4r9RDwtfjjM/Veq2LVsYQkp7dOMvrdXuvi2f7
yN38OUIc46lGivUZrIhx2fNpK/DOhaxgnHA496wa5RL5ONKO7zZgUyX4YqaE
Hncs+Ibng7rxnKcn+MhjzAXxtLNMcHwOVuAJl5e5tSTSQM/VIHMbIb1b6z2H
XR5TfhqxnkEu6plIqKel1t5wLnkGZk1kbTVk4uLzrRYu9jJz/fomhi/ACswa
tNZBH442P5POU9sTMl3ZP/uChuVyvcP44fPmehZAmkuql40SDS+qFSLGQe1T
78r3YRYLz6WbsMuW7D4R+VrYRCHNISd3BXPUha59bwl89H2hNp/5WhyzfYzI
Wq1WJj/kvCLWfKIV8r5JkqX7sUYhSyvujWPaj07hnwU4fjd81v8qjPUsGCnK
nbRV4L/iLncBKkZu3QUzNJSVni2oXXvo9wDaSZOzAhttE70NvcewEmDelx3y
sNCCMIMlessA6xXAD3P8Pi+CmnzbmedEkncVDrMYY7zHqEB2Tjf505VXAabv
q8vYFAUIFTPxGwKVd0vezZi2QMVsED3HmUD1Twq9JpKaWroZFGkKPvEc6m7T
Rb3mzPOaxeuA5X4W7oGLEaCSjI4W+SeE3wAYGAfI9ikpsln8kUBg+RVvwh14
3n8q+x7IXf7do3+5mFemVh332pe72Cck76tglvKq8IfjfvJeCuZg9wU2R7bi
bbiKeeZtWc3PT/r3npLqNo5VS/1bhe86Wz/GVTcEX7aM4n24muveEMzXePUD
uIoV7omsZvkUH8BVrH9Vpswzfqsp917BVPDld3b8O5kdFcSewOS9+b2qbGQy
sqTVvK74FK7mTiZo9ee8+iFcxXMozYy+4tWfufj0EOJPw6951RfmqiZVBOMb
vvpl/Umh+FseFSt/A2oTzPI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->475647361]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63220257],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->639570977]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310670862],

Cell["Style the areas between mesh levels:", "ExampleText",
 CellID->94092385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"8", "u"}], "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"8", "u"}], "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"8", "u"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "50"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Orange", ",", "Yellow"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245937364],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->875727]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "25"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", "Yellow"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Pink", ",", "Orange"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1642453520],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->577152149]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->285333046],

Cell["Color by parameter values:", "ExampleText",
 CellID->24223989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"8", "u"}], "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"8", "u"}], "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"8", "u"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z", ",", "u"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"u", "/", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->915108523],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->584922001]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "25"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z", ",", "u", ",", "v"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"u", "/", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->194047514],

Cell[GraphicsData["CompressedBitmap", "\<\
eJysvQWUFcf29v0bN9wdgmsgBBIsQCBAjCRAYHB3dxncLbhLkCAJ7u7u7q7B
bRhgtNb3du3qPjOcmdyb+19fLzjTUt2naz+1fVedqk26t27RoUn3Ns2aZKvS
tUnn1m2adctWuVNX65SXB3DP+r8kHdb+/2ftyf97SinrQpzPgdant3WpoRwN
0p9e1qEcQSbrr6f1t7wcD45zVe+msz70IV6muf4sJ7tD3Fqmtp+Dr6ultbVo
0cLaT/iOFPazfd3eqKzrrfGObQ3J7fYB0t568kftB9nfn8z+m0juN61Mw6/k
zwT7KUn0kY/ruv2sMvJ3nP0MT7c3TvQf7hljPzdlnLfTu+7PKCmtR9nfkMat
tZdb6xLSerj97HT/qvUQG+8MCbyJblzyI3p5uz0jrdtdPm7Xv5C7+9vPyvZf
Wgfa75JX7uprf2cOt7t8E7gr7ogwd/e2vzP3f7nby/5Od+rkkaf0tN8h3395
SpDbsXwr1e27s9rvUsDtKX7/oSexT6mm3Md2Rvt5n7o9z9/tft94d+b9hyem
t9/0swTe0NPmIhcdErg/jU3FognR6aOWn//DE1LZ3/CF2xPcaVLkH+53+L3E
v7rfQSapfVdpt7vc8SwsdzWxW3/l1jqRW2vBRSSoVwJywf27Er67vv2GFd1a
J3ZrXUha17G/q1ICz3aNFILtZ37r1iqJ2zMLSutfVXxpXsXtzqRudxZwoaNP
Vv1XrX+23+oXt9bJ3Frnl9Y/2s+u8V9am5GqOcjbljyebn35d0/IE+esfkBm
+/tru92d3O1uw2mfqISlSwb7fTQuyW296v4uXi5+y+d2d5o4V/XTSf8TjarR
xNoLpkVdWtandSPaNKFtc9q3oF1L2rWmXRvataVte9p1oG1H2naibRfaWLd0
pVUXWnSheWeadqKRfFEqt/dJ4fYGeRJ8r5QJjJgczjmf8tSpSP3KNPyOxlVp
ir8+G9SSLm3o1o7uHejWkW6d6daFbl3p1p1uPeja03q7AN3Ouw8tetGkJw27
U8/L5ty4b5jS7V1yu/D/WE6ktCmfy/WupalTlvryJfojazVa16BtLdrXoUN9
OlmnmtC1Gd1a0r01PdrRswO9OtO7C7270bs7vXvSuxe9e9M7hF596dWfXgPo
NYhe1o2D6TGYboPpOoTOQ+g0hA74yHf2pX4f6vSmprxyoFtfUrn1JZdrJHrG
kXQ5nR6kKUFdnO0bmlWhxfe0qkrrn2lbnXY16VCbTnXp3ICujelutWlBz9b0
akvvDvTpREgX+krPU4fQvx/9+9NvAP0G0W8wfYfSdxh9rWsj6DOS3iPpNZIe
I+k+iq6j6DyKjqNoP5I2I2g1nOauvlWz38XvX/WrhN2vnM7VTwn+jNqyS9BX
NCpHkwo0q0SLb2n1A22q0u4X2tegYy0616YLgTK6ejCoD4NDGNyPwf0twifV
ZwPH02M83cbTZTydJtBxPO3G0fo3Wo6l2WiaSK+9+vOj/b7ebu+b2u195Q0p
btM9h3M1P8GFrPcV+eJfnHpf0kArCZqWp3lFWlam9Xe09dNXszSiVxP6NKdv
K/pZx+0Z0JGBXRnck2F9GNGfUYMYM4QxwxgzgjGjGDOGMb8xZhyjxzN6IqMn
MXoyo6wbpzJyGsOnMWwaQ6YzeDoDfPXzA6bRaRodptJ2Cq0no63pCTQaR70x
lmCQ9/PpR2XTWWXs7XRufZReiZZ2YRJk7eS1HiBbEeoUpV5xGpSwRIVlTtO8
PC0N5xT4mc7V6VqT7rXpWZfeDQhpTN9m9G/BgNYMbMsgkTbDezIqhDEDGDeY
CcOZNIrJY5j8G5PHM3kikyczeSqTpzN5JlNmM2UOk39nsnXjfCbOZ8J8xi1g
7ALGLGDkfIbPZ8g8Bs6j/++EzLVYTqjgM4uWM2g2jUaTqTeeWqbnXoOp1I9y
us9p48gAxCJw+EmETW7pawGNap3C1C1K/eI0LGFJAellscq0/46OP9LlF7rV
oGctetchpD79GjGgKYOaM7glg9syrCMjuzLauiGECQOYNIQpw5k2mhnjmDWR
OZOZM5U505kzkzmzmTOXOfOYs4A5fzBnMXP+ZI514zJmL2fmcqYvZ9oKpqxg
0nLGL2PsMkb/xYi/GPong5cyYCl9l9BnMT0X082M6N9pNpuG0y2poAezoGtc
K9tej0Xbx6ZERqFEIZsSLtnoY8Gen9qFqFuY+kVpaHjyq7K0FknTvgqdvqdL
VbpXo9evhNSmXz0GNGRQE4Y0Y2hLhrdlVEfGdGVcTyaGCIxDmDGCWWOYO455
k1gwjT9msngOi39n8XwWL2TxYhYvZclfLFnOklUsWcOSdSyxbtzI4o38sYkF
m5i3ibmbmL2JGRuZtoHJG5iwnt/WMXotI9YwdDWDVtF/lUV4WEH35XRZRkf9
4p6aCj7zaDCH2jOoMZWfHPKkcaOLVzy9If6RWCwJ+XqfOBTzzkXtvNTJT92C
Rk/xVQmal6ZVWdp+bYl/qELXH+j+E72qE1KT/nUYVJ+hjRjelBEtGd2WsR0Z
35VJPZkawvQBzBrCXOuuMSwcz6LJLJnGn7NY9jsrFrJqEauWsOovVi1n1UpW
rWb1OlZvYPUmVm9l9Q7WWDfuZtUeVuxh2R7+3MOSPfyxh/l7mLub2buYsZOp
O5m0g/HbGbuNUdsYvtVCCDZb4smMnTW0XylwGy7yXkDwXKpbl6bybayl8N8p
l1fF+mNG7+agdi7q5NGjVOhUlCbFaV6CVqVpW5b2X9OpkiUtLIuP3j/TtwYD
ajG4LsMaMKIJY1oyri0TOjK5K9N6MjOEOQP4fQgLRrBoDEutuyazfDqrZrNm
Hmv/YP1SNi5j8wo2r2bzWjavZ/NGtmxhyza27GTLHrbsZ+tBtlo3HmHTETYc
Yd1R1hxl5VGWH2XpURYdYcERfj/CnMPMPMy0Q0w5xMSDjDN08t/LoN3030Wf
7XTfQqeNtFlHi9U0MVJ3Cb9arebxg8ju8kJLd4vF8x8ol9sec2JRahWbWeRT
dmrndLTOVwWo/ylNitK8OK1K0LY0HcrSqQLdKtHTulyV/r8w6FeGBDO8HiMb
MrYZ41sxuT3TOjOzO3P6MK8/CwezeARLx7BsPCsny+CZzcZ5bP6DrUvZvpwd
q9m1nj0b2bOZPVvZs4M9u9m7l70H2HuIvUfZe5y9p9hj3XiWXWfZcZZt59h8
jo3nWHeO1edYcZa/zrL4LAvPMP+MNbCFdilPMemUpajgBKOOMewIgw7Rdz89
99BlJ+230WozzTaIujFi7E9+sj7nUiGWjj4uuhnSxeNQ0XMuazSvcvwBi5hZ
Cf7E0Y9l8lAvPw0/pVlRWhWnbQk6lKZzWbpVoGdlQr6nv9WoGkN/ZURtRtfj
t0ZMbM6UNszowJyuzOvJwhAWDWTpUJaNZOVvrJnI+mlsmiVj6w92LmX3Cvat
4cAGDm3h8HaO7uToHo7u4+hBjh7m6DGOnuToaY6e4+gFjly2BiRc5dA1Dlxj
73V2X2fndbZdZ/N1NlxjzTVWGipeZcFVfr/C7CvMvMw0666LjL/A2POMPMOQ
k/Q/Tu8jdDtIx3202U3zHTTeSn19q6HECr5fTMU5lMKxMv8tVT+xqZnfGcHp
Cc5IsEVaeXK2nNTNrcna5FNafEab4nQoQefSdCtHz4qEVKb/dwyqyjCraU3G
1GFcAyY1YWoLZrZlbifmd2dRb5b2Y9lgVg5nzWjWj2fTZLbOYPtcdi1gbxrh
sfscfcDhBxx4wL4H7DJjK+191t5n1T2W3+PPeyy+y8K7zLsr+vU2024y6Qbj
rjLqMsMuMvAcIafpcYLOx2h3mJYHaLqXho6OwHs5FRdSeiafO/TxjkufWD2a
xR5lLnqkITgdwRkIludkyKHp0SAfzQrR6jPaFadTCbqVoWc5QirQvzKDvmNo
VUZWs6Q+lnic3JDpTZnVit/bsbAzi3vwVwgrB7BmCOtHskn8qNRrObWRM1s5
t5ML+7h4iMtHuXKcK6e4fI4rl7h6havXuHKTK7e5co/LD7j8N5etOx9x4THn
pIdaPwpiGZ+z4zlbn7HpGeufsfoZK57y11OWPLWGMDxmzt/MeMDke4y/w+hb
DL/BoKv0vUyvC3Q9S4dTtD5Os6M0Mvy6i+q29viL0vOFfNaWWMX3ybPIrhPf
KuiMtlQEp3U4NG0W6mSjjjZTaJyPFoVoU4QOxehSgh6l6VOO/hUYVImh3zGi
KmOqMa6W2B2NmN2Mea35owNLulimlViKmSezZwb753BoAUcXc3wZp1Zbskvr
v4vbubybq/u5doQbJ7h1htvnuHWBW5e4dYWbN7h5h5sPuPU3tx5z6xk3X3DT
uvEF155bZJWx5/2KU685/oYjbzggvlHmt6x7y+q3rAjlL+v4DQteMfcFM58x
5QkTHjHmISPuMfgO/W7R+wbdrtLpEm3Pa7mnCXmU4ANU28X31v4aSi/l87kU
1A92j6xkFjo6Ub1CDqXTpXTM+AzUzkzdrNQTOjbNR6uCtCtCp8/p9iW9StO3
LIMqMLQSI75jdFXGVWNSLabVszQClqO3SOzMbH3ZOIitw9gxmt3j2TeZgzM4
PIdjCzi5hDPLOLeaixu4YjXdwY093DzI7aPcPcX9czy8xN9XeHiNhzd4cIsH
d3hwj/t/c/8p919yP5QHYdwXKiZ6w7VQroRy6S3nwzgTxsl3HHvH4fcceM/e
D+wMZ5tQN30ES8P54z3zwpgVyrTXTHzB2GeMfMKQR/R/QJ97dL9D51u0u05L
69kXqH+aWkf5ZT/f7aSi9YiVfL4oYYpKhMaV4ZCRmVY3IziF0DQttdNTNxP1
slD/E9FVeWlTgA6F6VKUnl8QUooBZRlSgRGVGP0tv/3IxGpMrcUs41V80pHV
XVnXi4192TqIHcPZM5r94zk0maMzODGXUws4u4QLy7m8mqsbuLGVW9Zt+7h3
iAfH+fs0jy/w9ArPbvDiFs/v8Pwezx7w7G+ePubpU54+54kZlams2yL5O5z7
77jzjlvvuf6Bqx+4GM65cE5HcCKSo5EcimJ/FHui2RnNthg2aUqwRt41RSSz
w5n2nklh/BbKyNcMfcmA54Q8pccjOj+03FrR1Nepf4Gap/j5CN/uo4Lh9eUU
WGCNOIgXdTSyM0AlHDV1zz7orggKqfWjCE4uKKShdjrqZaRBZhpmo0lOWqE9
uU6f0r0ovYvTrySDvmLY14yqxG/fMqGqZY2JTM7eiCXNWd6G1WgfdVMvtvZj
5yD2DGf/aA6P59gUTs7gzFzOL+DiEq4s5/oabm7kzjbu7eIh2nB8coJnZ3lx
kZfXeH2b0Hu8fcjbR7x9QugzQl/wRhDI+I7XH3gVwSvrrhiex/Akmr8juR/J
3UhuRXE9mivRXIzhXAynFMcVRxQHFXsVuxTbBYr1FhqK5Yo/lSWTpQ8pI5kY
ztj3jAxjSCgDXtPnJd2f09nAcZ/Gd6h7lV/P89NJqhym/F5L18Nai0CetjyO
j4d7/Dy+fe8VV47biTaJDKa0ziUSWCwWSUWdtNTPQMNMNMpK8xy0zi3uUCF6
fkZIcQaUZEgZRpRnzDeMN/1JV4sFdVnciGXNWdWadR1kFPZiV1/2DuLAcA6P
4dh4Tk3h7AwuzOXyQq4t5cZybq/h7kYebOPv3Tw5wDMdIdKUF02ZXvFK8Vzx
RPG34r7ijuKG4qrikuKc4rTihEPxfRbFhdybheKrheJLFAsUcxUzjUZKFs3Y
SEaEM/g9/cPoHSpBtue0tb7ybxrcI/gW1a/w4zkqn6DcIUp6J0BtY+vrUe9N
/DxbwlT/2D7TQ8vxskiSjOCU1ElD/XQ0ykiTLLTMTttcdMpLN3QUp9/nDPqS
YaUZJe1T/cDsX5hXk0V1+bMhK5qxpjUb27O1Czuty305OJAjwzg+mlPjOTeF
izO5MpfrC7m1lDtCV9+zhF4i7DrvbvPhAeGPiZTRHvSaqFCi3hIVRtR7oj4Q
FUFUJFHRlhjSpH1vIsEpFdcEgvOKMwLBUcUhCwJptD0OBMsUixXzFbMV05Wl
3aUHKaIZHEm/cHpbB6F0fEVr6+sfU/chv97n55t8d5mKZ/nqOF8e5DOR9Vkw
md9Yy+3fj3YT0Y+NFUr0KJl1IUBGvEikuqmon5ZG6WmamVbZaJeDznnonp8+
VoOiDC7OcBk/yb9mSiVmfs/vP7OwBktrs7wBq5uyvhWb27OjM3t6cMBqN5AT
Qzk9inPjuGTsl0RreLyBp1t5vouX+3lzhLcneGdduMT7axqI9/f5IFGPwNdE
hxL9lugwot8T/YHoCKIjiY4iOoZoT0W0BFIVHxRh8u+N4qXiqeKR4oHirujY
5IqTBhlpvFuQ2aRYp1hpZJHid4szFNMUExW/KUYZDRcUTpf3tA8VW+YZwY+p
9pAf71HlBl9fovQZiuFoiPQ2TQPioMH/iFG8FnGwyu5wSVBigpNRNyUNUtM4
Hc0z0joL7bPTJRc98tKnIAPM2EpShonlmFaR2d8yvyqLq7MsmFX1WNeYTS3Y
3pbdndjfncN9OC5USjqd23O4N58Hi/l7GY9Wa5ieWDDt5NU+Qg8TdoIPZ4mw
ml4jyujlgOdEvNZMkgA8+Gh8kjr4mH/vFKEORC5BdlO46LLFRSYan1RUxjbB
aK1ihWKpYqFijmEdxQTFWMUIxRBl9VYQSBJNp3DaWC/1hnov+PUpPz3mu4d8
c4ey1yhxwRq72vLI8Rcp3aVYuv+Ri3zckHHl6RL522xULzkNU9EkDS3S0zoT
HbLRNQc9cxOSn4GCTeJSTCnLjArMrczCH1j6CytqsrYuGxuxrTm7WrOvA4e6
cswgmWwEV8dyYwK3p3JvFg/m8WgRT//k+UperOPlZl7u4NVeXh/izXHCzvDB
YHMf9YiYZ0S/JjJMC7CYSGKiiImx9Le/sj5SCTaRigj5Fy7wvIkDzz3F7fh6
Ru46YMaYYkM88WYx0STFOMVoxXAlAXRFL6FQ4ijhpDBqv6baC354SuXHfP2Q
0rcpbl0+TR7rc6lFQXeMJAbsyuj7fiTPYlvJeev5UrORSDckOIDaekjRKAVN
U9EyLW0y0DELXT+hVy76GtyKMKYYE629Mswqz7xvWPQdf/3Eqhqsr82WBuxs
yl6RB8lCuDCQK8O4YR2M595kHszg0VyeLuT5Ul6t4M0aQjfxdjthe3h3kPcG
iavCNfc0HuoZ6jUqDBWB0kgEaSTSCo2inX9RgocB44Wj9C0wbimuK64oLlpg
yC3HjLoRobbNjJaMH4u0KQ67jJQbBij6KLorCS7H0NR6v/fUfMtPr/n2BRWf
UfYxJaxL1ylwhhzWzmJLObhn+w0aaVRsnUVcfhCvQ+dfvKntR51AyVMmo3kK
WqWmbTo6ZqJbVkvjGdoXYERhfvucSV8yHZ2bWVCBJVVY/iNrqrGxFtvqsdto
nLYc78jpbpzvzaX+XBvCrZFSHjaRR9N4Opvn83m1mDfLCFvNhw2Eb7WobrT5
SaLPEXOZmBvE3LV6DXFRiELXTmD30Oqj3tUfqQWM8I+ReGhpFUHCiKwLcs9J
sb0OiLW7Q7HFaH07Gyhm1wwRXJop5IZBir6KHorOirY2JaxXjaDaO34IpdJr
yr8QQ/cRhW+Q56yofctkdkcijQuJuDrHHRGx0/QY8yLYh7r+1A+SxHtyWqek
XRo6ZaB7ZrFBcjIkLyMLMq4Ik4sxowS/Wye/5s9KrPyedT+z2ZZITTnaipPt
OduZCz24EsKNgdwZxv3R1gvDFJ7P5NXvvPmDsD/5sJIIE1vYS8whYk4Qc5aY
TPo5aWWgv1e8Vbx2DFxD4ZtG6gi1TscZ6JZm2KrYKJ6E0Qy2J5FWdPdYucHS
C/0smaPoomivaKlobIIRUfwUTpV3VAi1eF3bu589Jv9Nsp8jg3W4wLat3Kv+
cNUUeblR2tEHngL0x1RP5+gFfy/q+tIggCaJJL2ZnPap6JyW7nI1MDtDczEq
H+MKMeUzZhbn91Issi5UZPW3bDBjvxZ763GoEceac6oN5zpyqRvXenGrH/cG
83Akj3+zhjQWB72ZQ9gC3i8hXCJjksENvIq6hbL0wWP0W4ei3qHeO4M/wbHv
pZW32UTypRKTKtbxkOZn44z8PY69a1lVqxR/OQpBK23j6SmGOfKnm6KDopWi
qTLRXP20HyL5JtwSADrE9PkrCjwh1y0yn7ecZU2DQJuaRvbEr9Fyr0vzVHGq
JOOg4kgtUnhSx5sGfjQJoEViiwu1y9c5NT2snUwMyMawHIzOw/gCTPmUWZ8z
70sWl2G5Gf8/s6sG+2pzuAHHm3C6JRfacaUzN3pwJ4T7A3k0jKejeTGe11br
mbzzcqKUKTYTswO1F3UIdRx1FnUJdR11B/UQ9VQAChN0PjgAxaACE8LITzRF
uGNVvRIR9dRY2cnEJznlMI4ll3aKXHKpa5dDOEN0xHjpl2UWhIh26KRoo2im
aKio7bx7QIwlCrBs9WJhFAol91Oy3ibdWVO24M43qeKYtWYzWSXlxE3tCwnh
Fq8i1b2+IYV13cMj2Iv6PjTxo0UgbRKLRksp8GVgYGaGfcKYnEzIy9SCzCrC
/OIsMZ5vBXHJf2TPLxyoyZG6nGjE2WZcbM3VDtzqyt1ePOzH48E8G8HLsXb8
I62owshlRK0magPRW4nZRcx+1BHUSdR51BXUTZRR8i8ExneCYTgq0oGRBHFM
HA/HuJ6+1jZyw2Uj5zIoDosk3CmScEMcD3+h8fAtQOWGMXHsrx6CaVtFc0Uj
RR1NUH5SfGskVCRfhFP4PXnfku0ZGW6R/LR4uO6opvwfuC/ucWI3FOU54kJ7
BXt41POisQ+WsGoTSMckdDVx33QMysjwrIzJzoTcTMvH7ELMLyp59VKsLcfm
b9iBThQerM6xYE7V41xjLrXgeltud+J+dx71sbjBRFHIMIkP08V5X0jUUqJW
ELWWqE1EbydmDzEHUcdQp1EXUddQt1EPhBlfCZDvBcUIATI6QX701B+Wnxkj
9vSHeFDa7qhlT8s9lgl3QSIGx410TSw4mtiY8XWM8TY1Lo4Wb9r1OnGBVJKl
VXynqChX/WL4LIp8EWQPI+MzUl0n8AQe/xpJR5u5R3Pca9ekuk7Ui2cdTxp6
0dyHNv50DKKreUu/VAxMx7BMjM7K+BxMzc2s/JaGNX7Al6wtw+by7KjEXuv4
J47X4ExtLjTgShNutORuOwlPGuwyD+PtaN6N58MUImZaOlybQupP1Epi1hOz
heidxOwj5jDqhEjUy6gbqLuov1HPUW8ExA8OiFEOiPG40dO2+gyKLoZ8bQSr
4rEYJ/fioxhHxm6ze+hgaQzxWR9jOdCxwjvb0TgXlkrqO5QE9hVfymd+Rc5o
MoeR+jGJrwpc7mim+A9ounu1rkypex1pUsOPeDbw9GjmTWsfOvpLNUMSif6k
Ykg6RmZkXFYm53DiiIkKs7IY60qw+St2VGBfZQ7/IC7ir1yqw7WG3GrGPUEx
XU9e9eX1IN6MIHQsYRN5P43w2cKTi1HLUKtRG1BbUbtRB1BHUaccyeoyXyzJ
KpnTdAJZjPyLjmNCWr7rMwHKji78A1A7HGW4RmRqJgOSNJ4o3pILJMtU6Sj8
ZoyUuoLRzxa/CUxlLYwUReRSDp3CIk0oSR7iczF+tFRo7rIkE7IoXa3c64+1
cYp3fTybeHq08qa9r8ASRJ8kkttPxYh0/JaRSVmZYR3mYWlBVhZhXTG2lGRn
WfZV4HAVTv4oTmNNrpucShuedeRFV173IrQfYYN5N4L3Y/kwifDpRMwhaoGY
gMtRa1GbUNtRe1BGUgrje70VxorUnKOdKC/DVi7O8nZxlrLvSOUGkDQwln58
gOKGr7VQFKQCHXc2LkCWLdnaCEQTC/oYoC90eTr55LssoFNHkfQVfvfEJnHn
I4ORM9PHfaaLK/ubFq/GHp4tPT3aedNFS2RCghiQhCHJGaEHJxMzCRI5WJKH
FQVZV4QtxdlVkv1lOVKRk1U496OlzyXKmaIeDxvzpDnP2/CyI2+68bY37/oT
PoSIkUT+RtQkomcQMxe1UOi9ErUOJZGygDNxNJbFIE9QL8WtFbkcrTFwSbt/
0lpewkCWvIvUx5H6OByzeduy6cY/sJDL2o9rT870svlz2McIGWu/oRFz8g7f
ITkeB6E8ik/kvCWBk0Tg9wKu+n40qwFboun3CnAhFU+ruc9TCCKwjnSnhYdn
W08PXR3tQx9/+gcxOAkjkjPGWFb+WVmSgxV5WFeQLZ+xszj7S3G0LKeEX5JV
567VqB5PG/OiOa/bENqRsG586EPEAKKGEjMKNQ41GTUDZaEl1Eu6BbUTtQ91
WOz9Mx+bGAawt6KXpHf/hFKQoBThxFHD5dPlNVvs9MCgldHxlg9+DNJKxyWz
QJojzzbhiFHYUaHecXBqYnllimA93cBSzUbOK74SrD7VZepkMzJJbFe/D/DI
OyFu8nbDLhazhOr1BemUBNQTrNp4eGmD3ovePvTzY2AgwxIzKjnjhL9+z8Ti
rCzPwdq8bC7Izs/Yb2wFnc34lptVuVudvwWul41505y3bXnfifDuRPYhegBq
KMrAZXzTRai/BIH1qLiIGXvivyEWkBBi3qKbTCjvg8VU76zu28FvSwA+kta3
nPzROZx4alw/2pWdmKekiEECq78pRiqGCCppFF0lwmFAq6eopaimpDhcUcHh
r0K6bJ0sivQOZr7Wu7/x4Ub8SKu73efvsiwS0lYJWYriYVvfKxH15MJYjQRS
nTr19OjlRV8fBvgxJJARiflN9JcekhlZnpU1OSzvzCBZnFPW2XJcqciNb7lb
lb+r8bQWL62TjXnXgg9tiehEVDdi+qAG2EimmYKaifodZUzEf4LU5XTHhTRc
2ntaiCZKCFGfOIhaBkeYPhuqOSM2OBhPoZ0Qb22/ifo76Qw7PiuNp4pCc5n4
fRU9DcellriVQbWm4hclhZiK8koCgwJsLjE50hoyG1SjvHmSBPN1/xlZ8dmM
hfiRzegd74xjNaZ341h5QhKS1iWgufCC1oUeniFeHgN8GOzH8ACpBkvGrFSW
22Vb88nysq8gh42GKcnlstyoyN0qPPyRp9V4WcsiqQY4ogWRbYju6ODqYlgj
X10ArxTMXAAfiQewiaq8tO3GNHGs+/eSMjRuWhw5qil5w+SjEoygeNnyUHvb
0liHTyTbMSyOZa+9bcExpctolMbfiE1SQklCSkDMLBrPUrMml0mMD2FJuJHu
/28E497pjqTLTyBxQwJb2x4c3n08vPp7eQzyYZivqIpEllkjKOoBl5XtOdib
V9KqRThbnEsluf4VdyrwsApPf+RlNUJr8b6u2BPNiTFPTdEN1RvVHzUENfJj
lWkZOEtRKwTSzagdcXjWZXEaJtWiMh6HSpsUwoxuIvbix8FKtxSwpRkXmapP
J3tlC1lFfwkjd3VsTB0Rk8dqR012KlqKUSyYIpaj5kCqLRidCpYXjPElJgnP
0rp48iNk3CMl/ztXZnTDUlrKBKMkTQnSdU349sa7n4fXQC/PoT4eOhFkZhUk
ZXEKVqRhg3UmC3sMPoEFOFOEi8W4VpLbX/GgAk8q8/IHQn/hXU1Lk8mD26As
znRD8jfUJNR01BzUAgdJiUYGuhjSpUQtRy5U4mP/gKWObrosnndi61hi9pXJ
ECeJw55HxdbZE8dlWOXkI7Wt4+RgXOwZ4uRd2jkCVts6pu/J9WxRvtbzXSku
tk5eRXaBNJWxdRQeJp4Zk5T36TAPNxapE3EO/D9zpTuSct2PVHVJ2tLIS3z7
4jPQw3uIzYX+zApkYRKWJWdtarakZze6yv5Ybk4X4EJhrhbjVgnul+HJ17ys
TOj3lhkiPU1am5gGkgprhWqP6orqheqHGowagRqLmoiahpqNmm+7ciTdFscD
dMXKXK65ibS8Nwk1o+4cxaScf3H151sn2Wz8QZfuvOKyhQ45cc4t8eKcHylP
M26FWXu6MasTVfnZibOUM8JXTxh2DFnBN5Hod4x/F5OCmPTcyRWv3i/R/8yd
mfVhgAtTc5GUDUmmMw4E9LHnYuiHeE70ZaY/8wNYmpjVydmUih3G3/yEU7m4
kI+rn3KrKPe/4HFpXpQn9Bveo8NnkTWICia6PjFNBNR2qM6oHqi+qEGo4agx
Doq2rbtaQNqK2hUn2HIBdTVOGPu5ZEnfSdzThWiqjxGNjhe5jq2+kZYfmUKO
HbTxY1NonrR0Vd+MjFvZkcGJXFsgNXbZuHKD5lXZKa5nu5NPYjBZdOaNFAKq
t0bUB5VYQM3E81zxamTF63DZt/9k50qNt08sZ1pb6qaxtan46okAnt7jvT2n
+3r87sfiAFYkYn1Stmn0OJyRk+hwwJW83CrI/SI8Ls6LUoQa36oKEVWJqEZk
LaLqEd1YIGyL6oTqjjLWrbRMZSlLNwPXRAOsa3EN3HMfx0CfSSBbXjSlk2sI
E5vnWZygpq7EEWpejGu5umpxcOyeRabQA9sf0U6kYqg4kUa2dpF3TS/+fgNF
bcuPlMbfOdrShDULuBhQFGZSm03QelxJLDImK2/ziNhzR83IWGdetK738HZN
eUjah0T22EmG7zhP76neXnN8PBf6efzlz5pAy1bUmb6DaTieQerms3MzN/fy
87gwL+SuoK/48DXhlYj4nsififyVqLpENSK6mQDTwVZWJDVqz8hKl9pbglqO
WiOYxA2ZmWC51xtH6YmfEcfXt2CJ0pov2s90WKo95IqLfY4IHrvj1EbZbr15
n5zi1I//WNf1lCS4HSHDDmFqf0L2K4s/UVLxucVBxEYx00o2wwLb187OBqCS
o7T/SHi+/4yIe02/IJOd9A1I25aU3UnWl8SDCRyun+I30cNnupf3PG+vJb6e
K30kM5eI/ck4morT6biUSSptcvIoH8/RBYjvvuB9aT6UI/wbIr4lqipR1YkW
0RdtiT4T/+sioi8ENRA1DDUaNT4e36xCrbdjNEEn/jkug64ZUCaW5hXjiD3t
aZkKI4edTP3U23jZu9veti47HqeAIS58fzoMZaIyUxxdFusOOgC2kRCnFoGC
tsUy31o+vqKMy/y0GEoekkHMlSTaedfhPLFJE2sBoKTqIkYmC8RbO8JEZ7wT
kIAyWjF6zwszx0/LPtF6PmRsKu/TkxT9STrUzn/gPwW/2Z4+C728l3mxTstI
9gZyOAmnUnAhDdcycCcLf7tszneF+VCM8JKEf0VEBSIqE/UD0b8QXdNGNVFz
VBsBxGWrDIlnqxgNt1GaWYptf0Ie/0Mns2fipHHTetq+MxWxTh7P2CkvncIU
VwHEFaf0R7OlHfyyc3grHFDnmWpfaTbe+Pgmjx7Hp2gTR68FK2fOUcq4fqJj
qnyiyCTPSi7hQLFWvCwRIvCmQ2VF5TY4OStEGZ6MX8n437K1Urmiq0eUROQy
6QkJpOlNyoEymMcQpIvl8J/n4bfEw2u1jI5dPhz053gQ55JyJSW30lqetImq
5iO8EBFFifiCyNJElSfqG6K/I9rI2mBUfVQTVEtUOwGkh6PyjMtvy1qXd+gS
rsZ22R/P579rGylahj4V1FzF8toNFBIedQKkOx1uXOeq1lroZOymSdNxjjwd
JEVFdt1aJsckiY2VOjruG9kppSgmVon2IESmpjOzC4QrPV1qToOXCZUDlS92
DmO8+Nu/w1Dfn8bmTeHmfGRpR8bupAsh9WDh+fEkniZj8A/8lotC2u7pudfH
44g/pwO5lJgbyaWoLj0vMhOaXVz3/EQWJupzokoQXYbor0ULfo/6GfUrqg6q
AaopqpWg4pK9dtw4rvA1GBoFuTpO3MbkMly+xCO5ZOrzwg1fWvSK0brRUytJ
P6FiuJiczx2M7xrP0OLCo3J5r1MgsfHjJIWF7jx5s3xOmcRYMTiHisLs67Cm
zvnJVYNvbYmFmwhOJdGZpWW/iJgxuRRZBd9UxoyRS1oYqSBUSizm1CjnRhVC
FRPZ6742jd//kVNT2GiLXyL1FJl6kkHnBEk1lhSTSDaTxPONb4vfJnx2eXgf
9PY64ed5LtDjaiJJZKfgWRpeZ+BdFiKzS3a9ANFFiC7mRGwCKqCqoH5E/YKq
iaqLaoRqhmrtcGdgXDfDwG0COsYeMjPvjDF0wOHXM+JuXHaiAuhaR1d1bEw4
MdFONWyMTA+I5mkUD6O4Hcn1SC5HcyHGjunYzCzfEihu4oo42Y65hpdN4biX
LX9tXjbmqkTQTQKxsavCwh1uUbKfOVGCT7Sz7oTtjCzWjf1RyVBpUZn1oQb9
M1QJjEj/GDnff0A8bv2FIw80wkldCGfpTSYRxGnHkXoqKeaQ7A/jKRGwDb99
Hr5HvH1O+3lf8vfSxlNiHiflZUrepiU8I9FZic4hed2CwsbFUaVQ5VAVUd+i
qqKqoWoJxgZ7Ex6w9np+bFGNc/xJ/z+cUM8aMak2o7YJV4sdG3ROz7B5c4mn
l3l4lXvXuXWDaze5dFsk8X2OmXo1/3ds/8CWcDYK1GvENrI49k8n6ztbKtWm
Oi6iKaMdKkj2d7RqVydX39LJNdYVb9HWqulFq8aCKYo1jyWe5VlpHcXq64rx
qES20aSyo/I6kJb5n/GMP68j9jixja9IBAkofRJCFhHWGSaQdgap55FC1zyR
eJOQ4iD+J7z8zvv46hrMAK+HQR7PEvM6Ke9TEpVWO7kx2WyLyd8SN9b4+yIe
xIZeFsQNRXDH1bwhonnt+K9lWU2Q6Ox0Ma5+Nxlos17LUt4u5fVSXrjqUcz5
88y7yrzbzDft/N4x5wOzIzUPmgk2UywIcRAzRemDJHQTIrK3uzBkR9PCV4I4
jR0R/KvltshT04h+Le7I3zwuFYuTk7RVrI8WwfqkZR9lQ+VBFbRh1M93XwfE
5yMLOG6FhlPfq5GSnHN+cnUnRz/hxzFknkSGWaRdIANjLcm010+iowSd9gy4
5O2v2dDf+3Gg14tEHm+TEJFMhlU6obn1VjllJy5YZQUsdJWilrmWlq0tZlJj
VAtUWzsn4ttX+HGoWMGjxBA2s5EmEz1Jlw1ESOdiVzg9z5AbUqBgU/ctIz8w
IlL7GpZ9M1jZs1PyO2KxowRJW4ud01QLR03dOuI+VnPi35UlXmo59SXksLBx
Q4y1KkyVQqeI9CUvl8GqkgkmmaTrBaXfX9qwuHGWGQT6r7vG9LdtVJm9k5W8
PTDbJ2PJOoXMc8j4h4yUDaTaQfIDwkDnCdJM4+3/0Nf3qb/36wDPd4FEJtJm
mP4mS25nFDM6LiDFXdxgacHKKMvu+QlVXYRkPeeab2uHhbqK+dPbQWKAZqeY
vrYmdc0U8jpLxyt0umNZS+b+dzL9UsjUReJdHcx3iigzLNBApJnFBTXNPZbF
8T12BqKcI9MsZ+FTOZlTIisZdTZWI5DY6A4bgQDpcWrdXX0yL6qIjLzScvij
4JDSHu2x1HfiY/qszChIRH6H6jnHkX0a2XRUloyrSL+JtLtIfZgUp4xHTtBd
j4C/Pf2eefm88fZ870uUv5DLeo0UOjOnMgjhc9gj26+YVpuWpFXlUd+I2PrR
RevaQvhGIrqai9lpRndbnEpjvfqMaBXfVzQLo2mEJmFToWJDR64EyzCuLqVC
VS1Syvksoh7KiN9lrHcjXXII7dKLxjdxEVvAQBxqZhAZk1tOFhM+Li/71TRB
k9mUMxacW7Ym3uj2tFtnNnQu1J38ohJyTyDXDHLMlwGwhsxbybCXdEdJfcZE
Vgl8rAtnfELx+uAhat5PjNAkEr5JrSM4lm1iy/BkZniXRH2F+lqoZwj9s1gB
ltQJlpO1ZaeWsdP1nFGTgznJD5f46Y7EYl/x6ztqRmmS1hCqmvDSjxZhFVUc
j6msYzYXF+1bSEK2ZqRmcoR30rg6WMtvyWSZwWrIqwrImZJapxluUsGO9JBc
jLXjPkfP26WdNZ3+aZ6+ZHGc+WPZKNLNHk/5JpF3Frl1Cpvs67Qlm2U/mXSV
I2mvkfouKXWpCYle4x+Gj57r5eGhvD2Uv4cK8lBJPTTtUwopjXzJLt0wnPGZ
M2rLiI6uIOO9sgNGFWe/qK3TvVmhk856NaTBNTwx67YYPGrUtF93mRS7naTs
Jb6+LZWkr6nynirRWlhb5mxFGSs+IjNKitj4XNcwOjo5t2jTLHHGe2JBxtuM
+EQWa+khJZUdGpRPpDdxxLjVA/OulmNoiGzHErycqhD3HNe/nTvuZWDWSMua
f9kpqksOKKSn/VBAh9DIs4JcG8mxk+wHyXZKRt4NMtwn3RNSvxJCSXmbnx5k
Xr7Kz1cF+qpE3iqJ9C65o5rjImXkS1Hh6i8cOeRVQndXGVD0Mdu058mqqfZ1
Rv1qA6KP0zkWkm8pezkTfpad4B/s+w9R+AyfX7FMcpFdFgBfCN2LiplTSGRR
XnE2jcGaQdRrSgn0BQrL6O+xhpUOLCQSwZrOjvhpw8dSZ0VFqn7loFNNnPem
Oqxm1vGKm6XSELlX7f9brNzXpMzu6L2kfPYbhafa/c+/mnybybuL3FINkuMK
2W6T5SGZnpMhlLQf7HoBrbyClGeQ8glSfgEqwE9/RZCnSuyh5a5hLaNB0DUJ
GrOctvfhm8qlE6bpYlP2nTeWE4v74NqGlKP/F74YK1Zo75UvmE+DXdjh901w
bPM6svRmky/sa+nWSVnVcXJdIO9NqQF4ScEwCkZr96KAqQoQrsopjJVVhJ3F
W2mIlXc6UCvjTyJEASKwU4q0zqI7pE9+ivpc8BPjUJ/5ReSy1FapjvY6DLam
+b+g5i4znRWyLJ4oNpai0/hMp+kovIZCWyi4hwIy3PNcI9ddcjzik5dkDSOT
LufWRoddJ5tUeSZR3olkVPgqXx/l760CvZSBLxmmy1q6p5XRakDMIPupZT/I
x44x+LDgif57RCepOLrV4bJlPVnQ0oWUF8O+YGAhbFLilbM2eeMgGVA6mPIO
mNVFYtarqj+bl8Z8T+rVEtg/SvrzZL5uDSg9TTBbGJ9EaZs2m5IzYlqlF+sq
lYjIJGbKq0tKJtF2lp/jfaR2DJxcOsynPpWTJQXKb2J1mHbHWpj3lPqMOGuT
uFeF/1tMnRnRLixT8uUYvpAQYDG9mhNFt1JkL4VFmRW8Qf575H1C7tfk0Ill
e7BmkI7aFkaQzhR4BChPf+Xtp3x9lb9EP4K8VGIvldT6Z+wiz8QWMQKSeKlE
ctkrsZy1TKs2Wj+y4rUdHeb8AY6ttAFZ1ZXFjfXO1MrGQmFAFvqmo3dKeiSh
m6yq3NHbs72Hd1ttcwcK7smbkrox6RqRsYGRpN6Gdb8Mpoxd1+H1c21+rRU7
Cj5tVV7/6ZObEanlbdC/NXGEJGdJcU2Cx89J/ZbUkVoBpnLitkmVEUWaW31i
7T8HaC2NUuqBrE+6lGIRbWPpM+U01nqnunw2EleuXZwKSrea//8D2v5u92Vx
UE9NqdGUFLlbYhkl1uud4uITfX6Jojcp/IBCzyjwhnyiG3PF6DRgNnGpM0hg
01Rk6FGeSJRNgDB0gPILVP6WSJZDD0+tT70DlU9iozETabfQ2gYJ4pvfc+w1
l/Q0VW6e5sJmvbP/N2npzcKfmV2RqaWY8FkKOZOrPnnrUaAORerY89q/qS08
W49astO4Oi10RSRdStNLr43C+FQsCGS19PgwXmfwvSqx2GcEhhIQqV86QNnR
Y28toQTBZMrDjkDHxdDof4x3VEhE75fikHxtawTtAtZxpK8U0OjNXYYmjKQT
UXCqDdxtIqk28KNcP74aRZkpwjjLKbOeUjucvHaJy3x5m+IP+fw5n72VMR1N
gWjyxWh/JZdoGsSIyKxllbE8dLQyufJMpv8JM9sxG62ZPlNmV9BYIQfn33Hn
jXyfD7f0CpmcmsqhYezqbtqlYX45ZmkjhYl5GJeN0ekZloLBWnzS19uzj6dP
L/y7k0hok6oD6dqSqTXZZFXfPI3IX9+W7JZFVL4OVaTwu2YDZ9XW5sG00W4E
3b42fB24NBkbRQYc8eQMskibRldXjEZArP70EsfBT0INiZ1og8u7zyHmkHEi
ijliuCJO5LeGBD8lIaVbdNPZKJzfcInFKEmCyLr/fklm+dD3lx9J+cmys5zy
Gyi3k7IH9eFXVyhzh1KPKPmSL8P0mWJRegJfkWjtfhYSIPIpG1RjQWSTk5nM
UkoWqlkk2pJLzhbWsRij6XQQx9qWSK2jtd2I5JEOpPP8lu1Jc/V3zo7laF/2
Spng+homW83U7EzIyJhUukDb2gZ5e/X39OmLf28S67VZSd2FDB11bsmMq8L1
KSqruZepS8X6fFvf1rUNhTva1KeDKNoe39K3nN4ZXcimdt6VadkqjsTxIM4H
cFOstpd+vPMj2l8MIeP+JYlj6KV3jNqcNpCqsOZPfcYEDCrJvgwdHSkQA1fJ
Yso6vDlI77iv8u6OptjD8apkZWULGYDfjKDiJL1TaRnfbKCiXm+KCqcd7iz/
mHLia5SJoFQkJaMoEaMnihUXID4Tg/5Tx6bXtMhrjdk8dolIAblW1NGXVWxb
ykfjOUbObpSch+0PvhDp+uY+L06bEcyNqVwYwgnxXnfVZfNPrKnAX19ISU1A
DkE6f0s+bUHRJhQTF61cAyo1sjEJqtecplLO3UGvEUF3wa6/rMA+qgQTC9vt
0q/Xa1JwKC2nU3E5BXcFxzfJCU8hSKWyK6615ZPJcaZkET1bLRqRWlprRjuL
pGWqyHadXGprl7DpQ4l9uK9q4e6dGMwy2BaPcJ4MniqSrP5uGd+t51s9Y5hv
T/HtFb69ZzLLVIygQiRfR+vYTzmH7KXEN/5S3GMDWzHxkz31kVh1JcSBLis1
GOgfENGfbeVzjAudA3J8R9cP2Gfe/c0bXTrA01VyJiOXRcAcbcy+GmyvzAZd
3s/SPCzIypy0TBPxNc7Xa4yXz0gCBpNE0ntpe+tU3yfdySXStVB7PmtL8VaU
aGZT0+dnAbFha1q00b+lYVtCvYRRB1Z1jieW1H8WfepYv8eycS4z1zPyQIKD
7zIRlVm8EKMNc4hdk1fYzpixxZ1QXblYKZrIziLVcxRkO1QXu1hYH47+93i6
/8qI1J7I7VT9k5/WUVWvLUjVk1S9TNW7VH3Kj2/sGRR8H8V3MbpMporAUEkS
QBUkYl1ezhjEy8vJb+SM1fgHCQrWVI7/2VUujJXPtfJ5Tj4fSqW5tcV8IOIx
73VsmVcbePoHDyfZGvJkMIe+Z7eIvXX5WfkJS9OzQFhlhp/XNG/fiQSOIekw
4agBZOlHjhDy6N/h0OGn4p1ty6tya35oRXX90yc06UCbjnQSPu7VUv9egbUN
lljDb9/ZqP5RghXF2FTERjXZpdzclsDkm9x8yCMA5nN0YGGJ3BQTbpShZ8lQ
uxZCfhTjo3xvBznTx04ESjt368V9xQaDY2a3s+kdHIOotpTqa6kuSZPqJ6l+
mRp3qaGn7lPjAzUiHavkFyG2xGs9dWgxQCNlbT9IBPcnZTf4VYK7Jmaj67xD
JLthrDZdCrBX5gJY23Opf3yjHE8kUjzLsK28+pOn0/UaHtZ2q7WpfWZXIbbk
YF0GVopjucjPa5633yyCxDxLM5qMw8k2hFyDyd/fprp/mW6Ul/jUd534qQM1
hXgtupirfiHt6d+SwQLfqFqMr8aUH5xVMpaXZWMpdkk47cTndoTJP+wzIouK
4DQuRQkRn1858zTjJG/BAay9cJ4jRnWm6DfZnxMPJ/f1awxuWRLAzbIQqkn5
nrUFryFYkAs+QfAl6tyhriBX9wN1I6kb7UkdU8yZSJc7dRPCD5EU7gzZ3yBF
cWdlcQTd+zfap3kvl3T93VPblvmwi7AVvJnFSz0NhcftuNuQ69W5WNmeYvbF
QEr3p1wI3+h1jKjag+rdqN3NtnQ69qJ7D0IkyTKoPcNa2nJqYh2m17B7svxb
NlRip64o5vhXnC/N9dLcL2UUfiqd+JHQuH6xYCcF0UznH/QZV9nLADmUqhe9
I8Fad8nmzjGG0lltzSUUlk7VnGi/Wj29EDv1T9DgEo1u01gCIU0+0CSCJtG6
RKWpEMxH/xXbqLkkjlpJMry9XOsm5Q4DpbDQ2qZKeZq1bXEE2h3ZMZT/YOgf
LtUYj1H3hFrZiFrDB8nxhA7gdSeeNeHBr9z+Vp85/zkn83M4K/u0R+2x2d9n
rbf/ChIvJaXEzbPMIuc08k+ksIy/kiMoO4wKg6kipQy/9KVmb7vCuHNfeobQ
T2AcJsptjPyWw5TGzBQXYcmvBr3MO8T/O16F85W5Xpn7Yvi9qcSHysRUQX2n
s3W6H658Ri3ts+kzjSV1ZNijs5xxlZyNdOK5aqlcSECiJYzfJ25n7d8tqS0J
14YrbP+CpsdpdpEWt2n5WJ9o/V5HRNpYfNLWTsu0k6xre0vGdbQL2bpIaUN3
yY/3EWiGSlHaRIeJlsrnLjEL0b+KqT8jrCdE2r9YKfMyXuv6Gt2l8ygzIzED
EYN5342w5rwM5rGQ8+YXXCrA2Wwc10B67vX32e4dsIkka0m9QkbBInLPo+Bs
HRG0tjLj+HoslUbx/QiDn2+jATQXNd91EL0HMKC/7Q2M6c74zvoHHKxtjtgm
fzVgTT021balXrbj1Tlfjeu/cF+M99e/8L4a0ZZRWEPXHek3ryOM11AAbCZn
2midpEzaVewoFacqWx/O1lVIemdVPG/cHUcPwTG721nXilFBNFlC8402T7Y+
T9ubtNezzOj8ni4RdIm2+tHV5t3ukkQ3gIUIHv2E/QaLNhrpMOFsqVFa6tJP
+2VO0zW5HGqMCz2IHL9Dzzp+q2uT9f4FqX5cryuabWsjsjUf6hKqM/P8/SV3
CnLtEy5qM9zzeIDvQe+APSTZTmopJMm+krx/UXgRxSWbWG4639ir0vrXHkWD
kTQbQWuR8j2GEzKUQUNsm3ZCP6b0YUYP5tjZa+8VrVjXnK1N2N3IXovtej3u
ixZ6U5d39YiqL0WCxhZsJhUnJmNuzIluUtBrqhmGyBmDnh0ZnY9apBcIcdW2
xkXH3Yo0GLr//qaskOdNQ+lPq9W03WnHlLvp+Z70ek+fCPpo/EJMuYKezTBI
pqEMk5VGrW20aK3xMulhupz5w4mrHJYK/RsymSJMQmMaMfGdlRGlwn42aAdk
nZNFcjhCW8W21/2qJE8L8SA7t3Uq1PNCgO9pn8BjJD1IGom+5NxMgXV8tsq0
T/7jTKoLC9afRJMJtBpP+3F0GSNDTZTkqBGMF+EzYwhz+rMgxMlmrO7Cxo5s
b8deMShPteJiS9tmSR7agvctiDQIyWXNX50dFhPLVE/5GySFYKPEnDB8r2Qc
6blFq2Rna7yodcJY5XQ76/qdXR/a/EkHiRN2P0WvK/YcPb1e9aBIhkRrdIYK
eUeJZ2zQmShnpkvV3xyprF+sHNm7VWZPHJQWF2WGxRM9d0mqfDRSKWzE9L8o
2ZfQmp4aEBe0kaIu2mHym1GVZMAkKiVh1UrL+H4Jv/xBrfnUE+3fYgbtptN5
Kj0m2R7FyImMm8gUkU+/j9U/AGRtywazWoyHLb3Y1YP9ovnOdeFqF+505pHt
CSSK7iJQiCWjHaoQQWOg7SMbyWfsS3vu3mINib4ktXnyBincKO4eNza45LLt
EeEdf5oL73TS1d70Pkbfiwy4zeAnpspL097aJkl5l6H9XDucEaDnZh6SQvlz
sn6ptT1TtqHhiR3Dtqlun8krBfnOMiSa/AdRG3VfPiJ/QzmsTGQp3n3K6xy8
0pk4j4eBPne8A66R/LLO4Vhb3qN8eoDiuykj7n+V9VRdTY0V1PmLRqLk2y6g
0zy6zzX4pBkxi3GzmDKLWbOYp+v3WSJYrRnLxtFsEULsE7vlZD8u9uNGP+73
5an+zUHe9yWqn2SQrOE+0zYAlbPAkd7foic2E1t/5jafPh4OedzOyl0Sgeiy
lN56NhODzjL0OiNkyaxxYUyM1MWu5rcqdeXzepkZu0NcH/3SMnX2qoz/x8b7
0fLKxQXeQn0JK7ksPyVqTxcCjpIx1z6W+jGliChMWE7eaep7vgj0eeATeI/k
t0h/TTfJd44iJ/nyCGUl4/D9Dn7ZSvBG6q+jqf7BJjout+XSoCWMEIgnL2LW
Iub9waIFjke0ZiYbp7N9Krsmsu83+2yWsyO5MoI7I3g0ghfCRhEjiBopa7GM
suMMulR1opQxTtVlyfrM71KZvAjbxFtjLzyl9/fqsUb83612j/8abPK6nXVm
pFlWeIj0bdhxRl5kzG3pVSjTPzArxra8F8k8keVSm27CCtukZn2/mHGn5cw1
scsfSp27kVM+cZHy1dXx+q1fSg31Gev1bbtO976viG6jdKtoVzGmMOE5iRCY
Xgb6PvcJekLyv8kgayHlv0bRS5Q8S7mTVJbUbo191N1N4x1GngT0Wkv/NQxb
zVgZxzNXMW8li1ewbLmNRs7Ni9i+gD3zODCHIzP1qXOioG5N5v4knk7ijcRM
IyYTNVmKxKfqeTv69WbK7LnfRWBJ3Z5WIytklsA6Odwmq4Ltl/1j+tP9V7wT
xsf9N7CltlACW/3+ZKggPvYME64xWeyAOWHMj9QR82VC/TUO62wXvWFtR8Q8
uyBy7K4TRAh1KkIcZa+M/veyD5xLwpB67tENWTNyt15YS5+ZJg1TaqPWhqqM
DpBG5yRGL7Lj9T7I761vojceKV6SUXzrAvf4/BalrupF6L87Z/sradrso5Oe
/k3INgZvZeQWxm9hmqjPRZtZLjtbNrNTOHn/Kg4t49ifnJba4msLuW2vzZfu
pYgsy8+L/J3oeah52Jr9D5FjS21s9Jm1wjibHN4xcx2PyP4ZV9WLO0oe1qFG
xyCU39YyWqoJHVIx4RhTLjD9lj5a+IYl73U+ynDIVhFje2QRB+PrGEl2W+bb
PVeOLDOpEaVcakUQsONN2hh7LDOdj0uhuhHLUx3F0t6Ejb0ShXukkHyJ0WNB
tS/Q8AwtTtLuGF2kk/0PMGwfY/cyeS+z9th2UOKNe9i+mz27OCTa5uRmzuoF
Fri+lturebCKJyt46fBMqohlelXRmGUyKcZQdZVIpHWi8QQ1vRDGLhFNIkH1
a5/Sk3yduXjuK3l8TOGCbi1E+6dmqPCZtc04pX9+zdqWvmT5W9ZF6RFvbftE
bR+TKRYm4HlLJsA9dcXMfN1Gua8tmywM9Sy7yzKtXIJDmq8nywSR3jqyj6TB
jVDS8cecOktg0S8mkX+0r7GRMor2L/iKYk8o85hvHvKjVPDUvUHjq7S6SIdz
dDujzww+yajjjD/GtKO2JbruKNuOsecoB49w/DBnDtn23/Xd3NnJwx082cbL
rbwV4kZstGeY6ZkLok21sNkhI0PMbm36HZKunNDLHugzl1y+yR3Te/UvcCiU
EA7JGLMU17ZYxvza12wO1978fqHqaVHXl8W/uGdqFI1T6BrhPnFx+Fj6vNcr
bRjpLL0wHfxdNOIwcbvaOGhUlpJVg4ZWEd4qkX+Mb+Joj5TRZJLFoAuGUfwV
X72i0nN+FElU7wFN79LmFp2u0/Mq/fWPszH2gu3xzzvLEj3Lg41n2Xmegxc4
dp7TZ7lwxsk13TvJw2M8PcKrw7wVvRu5n8h9RO+TxXX3YxjZR1P/uLzoaT3w
7V9tVvcdwmV2o613POp/mhD1vZgktvHCE8ZZ89KRr0hlyPsxjT2dse0u5Y2k
eS3T1q7r95ObsopCmyDRiB4Okavp3GQ8Igcov8QxQmTR5YUsIofx1TsqvaXq
G2qKr9/sMW3/pst9et9j4B2beomn3GD2Nf0Lin9eZY1kH3Zf58gNTt/kgp5z
wM2r3LvqeH2vLhF2gQi9BiRRZ4g6TcxpnTU/Y8ipJ1Cek9jQBZu+fkrMFj0l
76GeEq33X5k4pXvm+2NaF06I1smZIRMO/zrJWrEL977myAetTi8KPe/KshHP
ZbLtWzkTpSkcYw9vFxDEWqviK4hwllCxTP28LJPtdxqdmEH81G7al0VSwjb9
P5VEVlz6e6aM0Rl1Tf9IvoikbCSVI/Vi8bVEBTR/RbsXdpZylIR8pj1g7n3+
uMeyu6y7xzYZikcf2nHlmw+5+4C/7+vfM3stpkXEXf0Zc4uYm0Tf0DaAp7pp
VLee9nhb//PU4iTIJvkDWbpBuMwsxKF3jD7K5kZfz3gIFLG1qk15a5snNVZr
z7BNshzH3nA2XAuVW9LpFyLT38pCHh9sGscoZ8z74YqA6cULXsrLXZcRc9DR
/QtEg44ytatJpaxCqKyvJfNWQf7KN7HySKlsKn+q+CKGsjFUibFHW4Zubwh5
zZBXjJYhP+M5856x+CkrnrDhKTuecUAvAcD5l1x7xZ1XPHzJ05e8eknYSyIk
264XFXquaRbzxKLJE6OQ9bh4qoXFM5u2z+TfC4ekoVpI6h1x+ONFcePTtqhb
i2QuGi8RS2L7eQ6IWjgfyrUIbb8/ckLr4SJdokXAiCiJsYWIs/k5VkoyWYPg
tvi+xx1F9JfMqZwkUaMQvTwIJiT6E6qi5FiS/qSoJVKkRQTt39H9PX3DGPKO
0TJwZr5lfihL37DqDZtCbXsl4IL8mt79cJ5E8DKCtxFESBGninQqcTTob+1Y
iI8Ks+koZ8wvCYC9sjKOKWAicLErpijzW18mUv55AhQ0fMO2w+w7z3Gh3423
+uflnsrzImWhBaHcRzEDDB2VyzeyZXaoBlmemV/G6SFxupHpqLNkjupQsUVM
ADJYpsVVkBRoQafgNqmHLlb1CJQa69hRKyn/ypJvrCVzDK2tfQTdI+gbydAI
xkQwSXzn+fLTjsby2BnBQfmVQmu7HsW9aNuKMvSNiCYyxh4WJgKrlyQIj107
Xr9OtN7xtP7YNYDSe31/7gQpbcZqMTdKJ3coHcCR85wX+f4wjOdRtsh13iGu
rjOLx8owDcT11cqVonsu4sASaRfk3XPKmjQLZQbwbyJ/ezgmX03UDzLT5Aup
H/jEkNlT+fsqr6B/QeYO0XSP0XH0oTGMiWZSlJ0dXxXFxkh2RLI/kuNRnBOC
3Y3RwT0kmRXh8J2Xo7C9Ygerl3zEDifd8zz/gabF48hW8yxevOVdlFFVYLxy
1/NlvXFvh6/9hWNeiEa9Jdx9UgzMbTKgs4jf3l8ifEZl/SpprHJSZpFfT4AR
knmrQH9dZmmTzJR+JUwyyRv1deZpm3TRkhhWxrAhmu1R7IviWDRno7liz/b2
fiVaIJZecceblz0IxK+OnS9gy0f48p8424szxwyzCo089Xj2E9pEOAIk2pYh
MuiS2pENs2nb6rbo9tPCylJupR2mP2xuFrqnEgurikxn+lwKHDS5PFVyX5Uo
UPklVZ5xyVVcZi26yCVPCBoSJ69mojQrYlgfw/YY9kVzNMaZOXnLEdlvRahH
i56IR6mPONX9GF3pFUut2PFVIgGeNTmJ4zv1zyNb26sHfHgmzGdGmSHjB1kx
IdThXCM8YlyxiTfCqvaKK0kkWnRERyEwLucSUS5TZQq/xbQ9tSOsL9WWFGSS
+jI/Hkkkh0gaa5QsvjZdVstwEWqb/X3+xq674XiMiP6LVM46MvFp4x17bKx1
T9eoKvlPUsyXczscIG4RbfHUSztzoLksVMzyN5oqJiIup16YjLYsc3bZiVNQ
wLFj/hRfdYaoiBGyykxXx3w34quCWJBFpPYwi2t8BTnjK6NUaSLlYmWkqOhH
mRNX10nSd5GU4CDJAY6XGdFzZbUYW/LvdoLl5yUNaKzil06EKcJRg3jGmHNe
yrkWa0YU/oh6pRKyxiV+fGIlV6R66vVZwq/I4jiSk9bjRHuN6rmpO3HIdVXc
g1MybvZYBJM3zi0sOEkk1yDxKE2pZX1xKr+TiswS4vLkttdFUIl9VJAwpJch
WA5588+lnq6iTBmsLvOMG8vkY2vrJauLDZcUz1Rb+fttdqKlxyT7ZtuyRoa9
dmgRpdduchttMfZoM4sRYiw6Dxe9SqvYiJTxLs6vsJ8WdpyYc5oOZp6BCKWb
YgpftbWqFudHRaLvdpztZSKmZuNI+G46dyGcJZUJVUS8fyFV5jmd0tYgL+Vv
SfgkzpByUaiUlKp9JxOwa8uvRrSUSz1sqgTMFMG1RNZPQELKrvSLHUk3UZzH
UrwWapPGK8YZReGuUaR9CG8XVb5KYBTZkuXacvsOR/udFTl9UixXixiHHd9h
m4S0JC6uSTJHxM044bMBWuKI75BC5HcxsRByOFOUA1E+vsozkUxmzuBUtxeV
Gs2vZSEsuTfIJZlcnPWHE8zdZOqgjdwwIS0TU7krsUPTl1AnMSV90Xzk5cwm
tZTrxxTQsWR7HLxZT/gWE6Zz6i12S8huh3R6M2q9PYNCG0ZzZLWq8RJvHCQh
xy6OhVRPah0sKVNRUpFJfpI6xPoyB9yUlvaOwwqTJdE2X+A2ka8dUk11WOA+
KyuLm37dkz4+cvrvddeFciEbZbPOUDm3PqaKtXE+/MX/a+v8XqoKgji+13v1
KlelK5FkP5SQMgsryTJS6pKGVGSSEaWYEiQZFPSTQOwHJERB9RT9evXJP6GX
HnqOeugPicjUFtr9zOy596z6IufsnHNndmdnZme/s+ffoh89RSr43Pwi2r0Q
9kU/ChcdSPaENcodtopA/Hv0zTC13CUswn5giG00ueVOXcZWV9tMgSHeDMq9
Ay4PE9cMVhjSqWAX7nGMy9Pgi8TKL9hyvlj2vL4mcn/HK/1Mrr8l/bBH+0FO
+Dxuy3ufOqI/5pXy9zuz6jeQJDOFDr9BjZ/7BCca0RpgYZcwgqcp6u0jiOvC
DgKdtsUq21Djq2dcKJcpUmjTBtTfEJ70BWsoc32Ccxg8mkuyM69xvh8CgERl
FtzjFzLkZbk/J3LuthVVgs6WpMd7U9DprPn10iy/EvU2+IB5klmP2Fd6gFt0
I3str3O2mwnbLiY+Y5tytjFvC84tNtpsE5Wq20PkJWaspMa19i4BhSDTXhB8
iVgiyWLCebVynw222fVOmvvmoK05szRnVuYIpWfljD/2wq5TdDVJ54+ybh7C
ofd7A8yMKwyA/x0BQzqOzxZVEy4f24AOewuPn5Ief68pKsvawfewfKluIOKx
pczjnxtmZQampoPWJEydoCqll37di8q06fGLvsauPm/rnAOtt1VFSvO2BQ+x
D7D6UXr3JLDY80F3RGtys1jIZ0wZfydwK98pHoy49ehrqYg1SxfNCiAsgEgb
MM7izovG1lfZuhpfnZtzmryBuvEWqlJ2hRFnrKsnsGTT3LxlDVZ7p3JAXtFx
LTNva3qF4f7ki93mb69Z7jGrB5hKLsZvBx9fcxBfcIyIawjJa1U6Lw7ZCHc/
Ld1659mjBdlionWFijnDSts53/RT8R6Xn1k+XO/Spzp56tQ6ulp5PaTU5Kmd
CkovxFQDSkUOygm51lpXXpdU+kNQn13Hf1Ve9+u7ibbNcNQaY0aOKHU/1Oei
1hj506PUJahHVLqYqlv5RQud5qZb4xqd0L+MqhmNWmPMbadSn4H6QtQaIzyD
TiKXWx4KvzHVDqXit900S7fGaKdWlQ46F96mW2MMzhZ99xjUl6PWGCnSrNRX
oB6LWuOqxI1KfRXqcZUupgonj01DNRG1xueYNOg7Z6CGjzX5k3A6x01oJq2N
cgh5bb9N+5QtnzLq/9/nrufZv/ghVybzH3HMtT8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->132796135]
}, Open  ]],

Cell["Use named color schemes: ", "ExampleText",
 CellID->282713241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "25"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "#4", "]"}], 
      "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->317733308],

Cell[GraphicsData["CompressedBitmap", "\<\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