(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12095,        427]
NotebookOptionsPosition[      9013,        323]
NotebookOutlinePosition[     10313,        360]
CellTagsIndexPosition[     10228,        355]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Naming and Finding Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamingAndFindingFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Naming and Finding Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directory" :> Documentation`HelpLookup["paclet:ref/Directory"],
           "$HomeDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$HomeDirectory"], 
          "DirectoryName" :> 
          Documentation`HelpLookup["paclet:ref/DirectoryName"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Directory\"\>", 
       2->"\<\"$HomeDirectory\"\>", 
       3->"\<\"DirectoryName\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ParentDirectory", "ObjectName",
 CellID->17236],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParentDirectory",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParentDirectory"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the parent of the current working directory. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParentDirectory",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParentDirectory"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the parent of the directory ",
     Cell[BoxData[
      StyleBox["dir", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->26792]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParentDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParentDirectory"]], "InlineFormula"],
 " returns the full name of the directory as a string. "
}], "Notes",
 CellID->27065],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParentDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParentDirectory"]], "InlineFormula"],
 " works only under operating systems which support hierarchical file \
systems. "
}], "Notes",
 CellID->19278]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->663156268],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->162450082],

Cell["Get the parent directory of the current working directory:", \
"ExampleText",
 CellID->57668920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "$InstallationDirectory", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216824141],

Cell[BoxData["\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\"\>"], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->483336479]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParentDirectory", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375617640],

Cell[BoxData["\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\"\>"], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->876104685]
}, Open  ]],

Cell["Equivalent form:", "ExampleText",
 CellID->342131474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParentDirectory", "[", "$InstallationDirectory", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->192341795],

Cell[BoxData["\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\"\>"], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->42771919]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10976],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$HomeDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$HomeDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectoryName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryName"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7547]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4198],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->31496]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->18577475],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->281058237],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->17863778]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParentDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 8.6945648}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ParentDirectory[] gives the parent of the current working directory. \
ParentDirectory[\"dir\"] gives the parent of the directory dir. ", 
    "synonyms" -> {"parent directory"}, "title" -> "ParentDirectory", "type" -> 
    "Symbol", "uri" -> "ref/ParentDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4811, 156, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->663156268]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10085, 348}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2197, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2820, 82, 53, 1, 70, "ObjectName",
 CellID->17236],
Cell[2876, 85, 886, 27, 70, "Usage",
 CellID->26792]
}, Open  ]],
Cell[CellGroupData[{
Cell[3799, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4277, 134, 234, 7, 70, "Notes",
 CellID->27065],
Cell[4514, 143, 260, 8, 70, "Notes",
 CellID->19278]
}, Closed]],
Cell[CellGroupData[{
Cell[4811, 156, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->663156268],
Cell[CellGroupData[{
Cell[5196, 170, 148, 5, 70, "ExampleSection",
 CellID->162450082],
Cell[5347, 177, 102, 2, 70, "ExampleText",
 CellID->57668920],
Cell[CellGroupData[{
Cell[5474, 183, 129, 3, 28, "Input",
 CellID->216824141],
Cell[5606, 188, 229, 6, 36, "Output",
 CellID->483336479]
}, Open  ]],
Cell[CellGroupData[{
Cell[5872, 199, 106, 3, 28, "Input",
 CellID->375617640],
Cell[5981, 204, 222, 6, 36, "Output",
 CellID->876104685]
}, Open  ]],
Cell[6218, 213, 59, 1, 70, "ExampleText",
 CellID->342131474],
Cell[CellGroupData[{
Cell[6302, 218, 132, 3, 70, "Input",
 CellID->192341795],
Cell[6437, 223, 221, 6, 36, "Output",
 CellID->42771919]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6719, 236, 311, 9, 70, "SeeAlsoSection",
 CellID->10976],
Cell[7033, 247, 719, 26, 70, "SeeAlso",
 CellID->7547]
}, Open  ]],
Cell[CellGroupData[{
Cell[7789, 278, 313, 9, 70, "TutorialsSection",
 CellID->4198],
Cell[8105, 289, 156, 3, 70, "Tutorials",
 CellID->31496]
}, Open  ]],
Cell[CellGroupData[{
Cell[8298, 297, 318, 9, 70, "MoreAboutSection",
 CellID->18577475],
Cell[8619, 308, 179, 3, 70, "MoreAbout",
 CellID->281058237],
Cell[8801, 313, 140, 3, 70, "MoreAbout",
 CellID->17863778]
}, Open  ]],
Cell[8956, 319, 27, 0, 70, "History"],
Cell[8986, 321, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

