(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    198101,       3949]
NotebookOptionsPosition[    191222,       3709]
NotebookOutlinePosition[    192654,       3748]
CellTagsIndexPosition[    192567,       3743]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ParetoDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParetoDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParetoDistribution"], "[", 
       RowBox[{
        StyleBox["k", "TI"], ",", 
        StyleBox["\[Alpha]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a Pareto distribution with minimum value \
parameter ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " and shape parameter ",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8326]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a Pareto distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], "-", "1"}]], TraditionalForm]], 
  "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "k"}], TraditionalForm]], "InlineMath"],
 ", and is zero for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "<", "k"}], TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->8315,
  ButtonNote->"8315"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParetoDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParetoDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " to be any positive real numbers."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->21184],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParetoDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParetoDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->5692,
  ButtonNote->"5692"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->620376828],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->565153950],

Cell["The mean and variance of a Pareto distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->5692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ParetoDistribution", "[", 
   RowBox[{"k", ",", "\[Alpha]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14550],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9V0tOwzAQdWOnP1qgFCGW3SB2HAM2sOEGUYXUNgJC6SJikx2sqi57hC57
BI7QY/QYxnHsxJlMPrQUS4kzH78Zv9jj5MGZjZ6endl46Azupo43Gg/fB7ev
U6GiNULIXFxXl0Q8c/Ekrznnoqfhnfm+/y3bdrv9TPQ0CAIuG/lCtXVxswUY
saVZNekkektZw56Jnok+1FMla3sEGzUo01J0ClC7hqztFkC1jAyys2rqEEqW
XnYsK5gCrTFWpt4AXsq3AXypgZh4sT2yoQXRz7DoBbKFzI79D38FWaH2v+ew
IIPTKjyWzvMwTNo5+efpd2VO7728WMc7c6TrRzVu4jXKEj1JW6q9X9TL0nxU
YgnPBUe3US3GGswhzVaOFueOmb6wQjKg07OClVXLVkyDbMqSNxqLhiGf5PCa
jqSZtkBO5WumC2RovwFyP/M+4T4+R+Pqc7KjsrwGo0I5LNMX6Gj87D2Utg9y
e5Ne0TyXy+VqtdLMxXszdyWFd9cYn0RpceMENqLVEZ2J4HneYrEIH7G1Ufxu
XHS+cJf9FU49lws4sqs8/b3fncuNulNQb5u8qLJOICMk+lYJ+zbGVgYh+rIR
35Nqf/ckD0JW9nuO1aqWioGeeniWGYzf5Ylj1MHYalhHvFoVfeTZ2tirFKFj
eMVFMLVS3co4FB0/4cYJg8dnSXz992AieKWZS8oRXl6SkWy9XgeybTabtvL9
kPbor4XUfgAcba3b\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83070362]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"ParetoDistribution", "[", 
   RowBox[{"k", ",", "\[Alpha]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13795],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWM1uEzEQdtbe9IcWKlohLohwgQPQNwAFkNpTpR4QN5CiCqkFIaLSQ245
cqpyzCPkmEfgEfIYeQzX9tob59vxTxqosLTxzo9nxp/HY29OelfnX3/0ri7O
ep3jy17//OLsV+fo56Vi8RZj7Fo9Lx8z9S7Vm3mupVS9/8v1rxgMBn9Mm8/n
peKUSpmVRsE2/c5VX1ip7oXqheo1n1vaySvDVUOaJ61zsLrr0U5egNXCi8AK
+HA4lKaxTefC0karrGlrJsL1xprQN0DL6m6ALvcsLrTEGtHwiPeHlPcIXRCz
E3eDXyQqUv73MYxEsJeDY3Ke/wbJMhB/iH9b5NzeC/m6f2uMXP3Iw6bOUbHg
s2VJ3vqSWoXDIwslOhbaeklyKdQwhmW0AlwaO+HrYoUUwHOzwsrq6KKGwTQr
CY2mvFGWHwRwXfbkkC4gpnTO7AKN8kOg9xvrifv4gPTbtvPasVG+gFGa1mX6
ETn6951yt6kZeXQ7If9AWt0CrR2g8SzEHZXSf096xfXUo+rsCOa/dHUO6x6g
UNemlSy9y4rU3VDQUpvIuRxaEONybFXRVtzxeDyZTCSxmuQ5Fd0nKXp9i37k
4Tz83yPv9/uj0UgS+9LfhzpRdG6b3LO35dpdY8fi3mkHR7pq+lbmVAr0cy8h
L61frMKIB+39GLTerKF1BFjmeXwmvVM+crvRGRG+x3zD2XtraXIp80yvVlV9
l1XnIuuaBex2u1b+hLS1ZT2R3yJ0rA0bLlrMh8h8GzZSudMibX2XzXuGPqP1
J60eQY96Kps3kG3ZrNwnK6Df8eJ19pZ3/amM3Uw6Vtoc9ynsTyz8sfp+JVax
kPiyQkQ+RvHENfy80BbT6XRo2mw2e07qvQIEv5j+Nalb/R/BWjfX1sa0\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->262157234]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17350],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ParetoDistribution", "[", 
    RowBox[{"k", ",", "\[Alpha]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10036],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["k", "\[Alpha]"], " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[Alpha]"}]], " ", "\[Alpha]"}]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393402148]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ParetoDistribution", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3760],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->131935828]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2534],

Cell["\<\
Generate a set of pseudorandom numbers that are Pareto distributed:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"ParetoDistribution", "[", 
    RowBox[{"1", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "66.14652204124324`", ",", "11.678691688195597`", ",", 
   "12.306445822865534`", ",", "1.045240654712478`", ",", 
   "29.581110384407168`"}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309207013]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1936],

Cell["Properties based on higher-order moments:", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"ParetoDistribution", "[", 
   RowBox[{"k", ",", "\[Alpha]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25584],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"-", "2"}], "+", "\[Alpha]"}], "\[Alpha]"]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", "3"}], "+", "\[Alpha]"}]], 
     RowBox[{"\[Alpha]", ">", "3"}]},
    {"Indeterminate", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{145, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->265083275]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"ParetoDistribution", "[", 
   RowBox[{"k", ",", "\[Alpha]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29182],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWM1uEzEQ3ux68wNt+ClCHAuoQgWJ0gsIHgBOnHiCqEJqQYio9JBbbnCq
cswj5JhH4BHyGDnmEYzttTfez+OfJFCxUnZ3xuPPM2PPz+bj4Or887fB1cXZ
4PDD5WB4fnH24/D990vBKlpZll2L38mjTLxz8aZ+15yLp30v5J2NRqPf6lou
lz/X/GI8HnN1ZW1xKwVEVqphfSkh8cz1qHwy8WTiKfmFps14BVtdSBdR9AJQ
9y3ajOeAmlsauFZ1zRKaVlJlTWuYANeaq1TvgJSW7YBsYSGupdgO2hSB1e9T
qwfonLCO3Yz/AlqR43/fhwEN7qb4MWrnv/Fk6dHfx9/Wcyb2fGv1t/aRyR9p
vqnPKFvzs+ZI2v6SUrnxR5KXaF1o9JLkUl5DHZre8nBp3zFbFjMkA56xCjOr
ofPaDerSI77Z1GoU8h2PX5srGU/noFP8zOwDjeMvgT5w9hPj+AG5rqmTe1rL
ZzBL0jJNPyRn/7pR7gFlkUW3I+PvSFSsNntAYy3EiIrJvyVXvQdScn9N7+A/
/9zkOcx7sH4dixsjocxpkvama7EzlsoexDlMoTfCilawNBs63Oq8gpEUo8na
GEdMtKPiTqfT2WzGifNrn796M3eyp+fXroEbyP4eK/yxbU6xeZpOe42L0W7T
WXBmyX3nvNJqOBxOJhNOZBCM7VsBHSj6NtB0RtokJ37lVj0P9DFyZUm2SJTK
rsViMVZX9kneisoJlJ32zsj819LIIfTVatVAn8/nNrpzbnoaX/qw7dX8CznX
6NYlR+nO4xRsPAK6T2LhDqtYcaPNWe0VzMO62+dun2JnLL8dMeSjJBTMjhgJ
WAWPiVVyLzp+mcRqKJ5mzLAoj9oek1p0tY74pdbhVqe2Uy3Ow0hOZjIdKJWh
0EbaJidSCZoRVrS3qAtur4IocqG6lkcrQ5qFPZCKnY3d67nzfwON6NhHfqE2
5qEt2+3p/2Mx/bXooBO+8UdooweEWZvVfJ/FjZlWXJQgU395srWMWwHSTm3I
EvmKnQL6C3cI83UsSmgtT0DqaToKE/W8qu+ijUCcx+BJxHmu+K+B+ySwZ+tZ
b4CLdfuFkqr+Pc5afwCfb9T4\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102939817]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23116],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["q", "th"], TraditionalForm]]],
 " quantile of a Pareto distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"ParetoDistribution", "[", 
    RowBox[{"k", ",", "\[Alpha]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9425],

Cell[BoxData[
 RowBox[{"k", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "q"}], ")"}], 
   RowBox[{
    RowBox[{"-", "1"}], "/", "\[Alpha]"}]]}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6812425]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19982],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellID->29591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"ParetoDistribution", "[", 
      RowBox[{"3", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25867],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->691616220]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->703691229],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->22632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"ParetoDistribution", "[", 
      RowBox[{"1", ",", "\[Alpha]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "10"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"1", "/", "10"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20189],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx0fQV4VMf39saVOC3B3T24zYUf3hQpFCtuxSnuXpziWtyCFQ2uwS0Fgktw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   "], {{{}, 
     {RGBColor[0.3361474884770754, 0.1317029181821084, 0.5894762764112981], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmweUVUUSht9jgGHmvp7EY2bJjIIYQDFHgoirEgyIIMGEWVFRMSCoqAiI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeYldURxr+F7Tvs3l3uXiIgCJYEAwoqEkUEWxIVRJFeFOkIggiCghUR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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.42161046543122616`, 0.2802999545463253, 0.7096048292338941], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXeYlNUVxr/Z3ZnZWWVmv9lvZ1VCE8UGdsnzCCpGTURAowJiAYImRuxg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmAmQVNUVht/A9HTPgP26X7/uFhGGYVEDGCOiibKqsQwCGkmgVASjVCWx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         "],
         VertexColors->None], 
        PolygonBox[{{3780, 5273, 1973, 5275, 3779}, {3902, 4949, 1703, 4951, 
         3901}, {4445, 3780, 3779, 4446, 1312}, {4259, 4447, 1312, 4065, 
         4258}, {5326, 3902, 3901, 5327, 2017}, {4422, 5323, 2016, 5325, 
         4421}, {4651, 4259, 4258, 4649, 1472}, {4950, 4718, 4717, 3904, 
         1703}, {5324, 4711, 4710, 4163, 2016}, {3740, 4422, 4421, 4716, 
         1511}, {4711, 5328, 2017, 4164, 4710}, {4707, 4715, 1511, 4714, 
         4706}, {4718, 4721, 1513, 4720, 4717}, {5274, 4707, 4706, 4113, 
         1973}},
         VertexColors->None]}]}, 
     {RGBColor[0.5070734423853769, 0.428896990910542, 0.8297333820564902], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXm0VNWVxu97Nb2Hpu6tqlsF2quTqExOrcE2kjike7XYjsRoSJwQ1KVG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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHm81nMWx3/PfbZ7k+e3PL/73JjXWEa5WYqJknWYUSNLg7rCaBEVhai0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         "],
         VertexColors->None], 
        PolygonBox[{{3898, 4643, 4642, 4941, 1697}, {4693, 4104, 1952, 5242, 
         4692}, {4798, 3795, 1575, 4800, 4797}, {4232, 4940, 1697, 4939, 
         4231}, {4695, 4693, 4692, 4696, 1500}, {4647, 4353, 4352, 3724, 
         1471}, {5243, 4232, 4231, 5241, 1952}, {4643, 4646, 1471, 4648, 
         4642}, {4353, 4407, 1274, 4406, 4352}, {3796, 4798, 4797, 4803, 
         1576}},
         VertexColors->None]}]}, 
     {RGBColor[0.5849334404192587, 0.5614874666256158, 0.9099800429575229], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmUVNURxpuZnu6Z0fR73f26EQUTo6IxRxCjYTk5ahTUnCguSMAtyKZA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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQVNUVxt/M9EwPkPR73f26WQQTjQIxVYNaJqBJiYbNSiIYlrAoQYad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         "],
         VertexColors->None], 
        PolygonBox[{{4514, 4796, 1573, 3794, 4513}, {4990, 4514, 4513, 4988, 
         1744}},
         VertexColors->None]}]}, 
     {RGBColor[0.6477685039202281, 0.6624459296292877, 0.9114124888707044], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXm01VUVx3+84b57H3qn370PRZxXLCTLElAcyiWQCpgCKg4lyBQg4USu
FNCHmiJDggwKCKjoUgIHQDREAVeL0tIwtJAZWU1MKhoOKVbfz/vuP/rjvN+5
5+yzz9777OF7zjtx8I39bqhJkqSz/tTqu6EhSc6vT5LV+vFCJkm+zibJcn1f
0Pew2jL1GwtJMriUJCdqzRTRXVOXJHe3SpLZ+SSZUU2SpaL7QmOPiNc4zd8i
+mVpkrwk+j/qu0Gtg+YW6nu95j4Qz325JPlHzvw3av+bta676D/RfN9KknRk
TN9bKuY7ptZj47Tv/eIzWHRbtHab2kKtay9dLtL8V6I7Tv37NPaq5GrWt3VT
klwqWbtKxtNE86zG7xHdPI3Nqvr3PI2fX2MdLxTv32rNCo2vEf+V+k7Xvldr
30fy1v3FYpKcLJtMEM92+k4tJ8nOOtsO+gnic7jO8nyqfn/154V9nhWPJ6uW
b4r4DEht06zG/iQ+C0TfqN+t1darXxVdZ/F9VP0bZY+bKubFebHf85KnJJm/
LTk6iKZGc9u09tfqr8+aDpolDdYf3Wc26uzU/qkzmKuxPaKbqu/DDT7LsaJZ
q7l1aru19mDG/WH1/r4W482SZYLaE1q3pMZrGN8qWbaoTRb9eK39UPzb13j/
J0V7l/iv1z5Pae46jV+l/q8aLNvrdZ4biP+Ix1vYud5nkcvZtv21Z41sd5vo
P5bdPql6bmX4L+c1RDRD1WaJ74ey8UG189TfVO91PeJcmL9dv/drn3fV7tX8
/Vo3qWKZ9uYcD/jq4+KxT+d3l9YN1/wItYcafNa9w/9W1nkMG/5H53mG5Fyl
/s1aP0c0k9Se17rvaHyZxt8WzVMl27aL/K67dLlW+92q8Z+rTRLN56I9XzR3
SK8u4vOYZN+q/hSN1WlNX63tLp6fFRxLv9O6JzU3VON3qN+sNrzG8b0ibDRI
ulxUsH8M1Px1ZZ/F4fB79P2RaK5SW6z+Qcn1kVpW9piusWlq72fsO49k7D87
JcsQ8eyd9bprYi32xu7If6nGLin7N/6HHxJTJ2rdWanjcKz0vUTy95ItB2nP
vep30njbGn8/TkzXs84xOwjdtWaFfk9scE4hnxTEc2jJvjeEs64zD2y0MfLJ
NH2vqDHNT8RnmNps8WjW2s7S522N36mxO9QWNdhHuqf2E87mOY29nvj3Juld
R4LV978NjuN+WvdFwXJxrt1y5gnte0E/SbL3Sx0HnWIOHXdor9apbcuZrYhc
hN13RU4YK95tRbddazu2UYyFX6V13p8ccq3s3bro+Hq51rkFnxwXsTm/3r/h
0Uf7nlsIn9DapWr7Rfc+++osdql9lbU928ZZFBqsP7r0kbzttf5F7E0OULtU
c7/Ut0FrL1P/v5LlTNH8RjTjtU+l6NpCDsU+FCfWkMdyannNz5Ad79X4lRnr
xXh9xjmO/LZD/dPrnD/htaLB9E9r7JDaqRq/SzzurjgHEadPRC7qKrneKzu2
Dim+tzX5/FppvEbtSO3xhr6zy96zddgWm52p8Y0aP13jt0rHqyVruc65kJz4
jcS08IMencjRyN+ktVW148R/tNbOU/+79a4zE5ocFx+Kb5c683q4Ylug19Gp
YwN/wSb4HPuMVXub2qi19eIxQnY+Omd/X5y1zw8T/x6pz+4B8ZhW9Rw1mzq5
VzRNWfMi11ws+nLVcqBbGn71A/G4IHX8c274N2fXTfTjNH6Mft6u/X9WMn07
ydNP8h+qtT7ww69YP1/tU9GPjnxCn7p8n36fAY36E4mfGvvN61EjyDXgADDA
Bdp3Ymqb91D/HvWPVb9G+z9UdV05Te28euME8v6pkZc+EM2xqevhfslYla0X
Y8+M92bfnTrnXeJ7TsY+8lnF5/pK0fmCuE61zxOp62B30Tar3057TdL3Da3Z
mvF5HwyZh2ndjDTsnPU849Mlz6iC42+79t0hXmdp7iL2rzr+T8jZl6j15CJ8
B9/Yon1ebjLGIkdAu0XydMo4ToiRB6gPBeOn16LWI9NIjS2QPAcyjvsDEfvQ
YefN6teK98zUPoZvQddJMm8tWx90OQxurNi+e3LGHOT7xvAf/L9/o+eWRexW
st7nZOl4vHRsn7WuD6TWgfras96YarBkWKs9bso59sBJ6Fqq2nbYravG22Tt
h8Q2Po1s1G98HZkHSOZzCvalgeK5Sv1R4nmZ9rw8NUbBH0cHRjpGsuWqlhW9
lwafs9U/Kuuzvkf79ykak4KnwMjggXX6ts4Zn+JXB7L2rf1Z90/W+IKMf9MH
E5BH8Ocr2DvrvQrav1j17xcl84Wp14Gr1wT+AdOD7cn3nCu+hV8R39gVnxkv
OY9rMh15KNNk36T+cW7EB2eEH1HHtwYf5KLfO3hyLsQVMdVXev+i5HMClxwZ
9n+maIyL7+Gn5OiWPJZ33KLjCNGMLJoXsXdljfP2dPnRuXnX2X5hI+xTLhon
4fvD87YFc0dqnyPUjo56S10hNqn1j2Vc75EDn8Ofqbe7cs6HYIqFGe9zSHpc
khorEns943zB6/gy+Rn/pd+CryTLYbX+GeeIXlnnHzDknqDBlpwTZ4TdD0VN
XhPnRyykkWeJEdbtjXHuJfOrxgEzI3Y4F2rKhMD8YNW9sRf5eEDkZPTqF3ec
yyu+a3GnapB+60qu3ffJhpdpbqXGGzW+JnXuBeNMivPaI5uvL7muUveLap1b
+bxYx5mBBQoxPrfBOJu7DzgQjIY93xefkwrOq+Cx5XXGbNO0/4MV74lcr6SW
bVbeOJhcvSXiCp5gyQerxpOztW5OxbV/TtR44u5V8VidWibsCrbAtvPjfoIM
YMMTAtNQm8Ap+ORPxW9Uxfz6aq+H8t7/Hcn2cNE4iLso9ORJdHs68Mah8GP6
nAP8W7CN1jYVPL4y8Db3mt0aH5m3n7aTvBnRjAGTaJ9Pi7bRrnrfo8Atf9VY
67L9+YDWDq/6jvGY1j6aGjuAr/EV/OSHokkLvieCzzhTYgqMnC8YA6PTqrz1
+ixrvwFrf6XxIwqOO2LxuojHx2WbdpqbVes7aDn4gy3RA56c8/ai7Twx8GZL
PdVYbdl+uUQydmh0nOJ3W4r2Pd4ecoV4fxDt3xUDzzTaj54OX5pddR4fGNiA
L7ItCh/AVksbvQ4551aNO8lBYFlwN1gXv2GMuCZnLAl5zpIMqwu+550a90f8
kPmlwXNA5BnOt0/FZ8Z5odOSoKEWkRPJhy/gpxW/wYDZuROC27/MOybx+Tb6
HqU2WrZcLBm25n3v4z48SmPN5G3N/6Hq36wn74PhySmroo/9zkxtQ/yM+gNm
vq1s3Ek+PkUydmw0jyn6PTkwWFute6vq+yu4F75gOWrbxXHn5X2GuzWxD/ZE
R7ABtY53Dvaj3lLDqF/EAW9C2Io++hF370m/tOScjD71oeMSjW3Lm+eQetd1
bMj+PUMGcPeMkuN7ecQTOm4t+m6JD68LWZj7s3R/t2xM1E73pnebrP/qyMfY
rUm61xYsWzt9z0htly2yx+aq4wP8ge7gatafEmdN7aEGkP+v19mOrPh9hTep
jZJxU2LfgJ69tqNf2brxRoatwOFLw3/wrTdLvjvh4ztFv6Ns3HFKnBt8qD3c
B8hvyyu+H3KvI2fvLTpmwCnUM2oZbwRnRx88eXzOPMAjY6POYptvtrF+vOng
C7xjvMx7nmzy/QbfI4l54h389L0G6/689t2dNx5mDFrw27FNvg9Q/w6K5qOS
sRC2PxQ+1i1rX98Ub3rNcabUHPIi9YX7xEup1wwqG+uD83+s/ty88yVvM6fF
exw+MjP8pCs5suR7xg7JckHB9bNTYGQw811NristuUHfyRW/pfWK88V+PQp+
Z6Hm4q/18eYGNu8fZ9E16jNn2jPsjy8zNiHuXEsDmxIjvDMtT/37VfFeVDI9
d4jJqfHX76u+l7If963VZccFdxiwKvkTXL823u768Bba5FzFOXPe7A/vO1Pz
/1j9T0rO0QsrfqME72wu+54Mjn5K3+fyjqeZFdds6vXUit8yyKfc7dCHmvhO
2fdkcPoi7VOpGpNSM5cEDXeRFUXjf+5M68v2Sd6x7k5t55bckHd+eDCNnNjK
d5GWHNHK72RfB07grYpYa45z4bspsPRLcRatZI8atTY5x1GHiN/e0uXLgnMb
+A4bcL4LqvYV/AT8yzruRbzlgCO5jy/kDbxoPwdjohMyn0QM5r3vyqLfkTl7
7qwbysYbYPPj41zwnxMiHp8V7XNF38mnpM6V8OTOw/swdiBm98edgjf4mwvW
8+K4b+ID4E8wPXjyUXg0GYvuiXFwwhaNLyzZ/7kvsSe2/QvvdmXvR7yDnfAT
7rstcS6a6/N+v+v1f3YnFsZEziBmT4+3K/hPjjdRag3fOUHTMf4vQF5tXTD+
IBeBFzYXjRl4M5gcaw8UjdfBA7nUb2dTA+8jS8sbn/jMrxj7fKveuJQ7DvtO
CT5diOWia9kGnXWDfu/NGtviC4zzNrCvaGx3TGrshdzkqubIV9t4kyuZL28t
Q/O+X4wvGv+B/T5KvR88R4DfSpaLuwi+BI6uLfq9G8yxRvKsrdrXPi/4zRcb
UdvmRbyfF/8vwW7ojO7gsTHaf1/JtuVNZW7Qo9ue+H2D+I2uGLPzDt0t3qLB
mLuL5vfvgmODPQYGjgRrvVm1LbAD96cFcYf6m9b9q2Rs/z+WZZFL
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwVdUdx2+Wl7wQfcu99wUDAWsZKaO2VgEFbcsIlE1rAii2giibbEVF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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7106035674211975, 0.7634043926329598, 0.9128449347838858], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXuUlVUZxs9czpkLem7ffAdDGLm5TG3lqgAvDCsTBQUEdJXoguTyhxKD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twVdUVxk/uzb15ycm959x7QOQVg1XaTjttCWqJ0wpKKigg7YDOUF7T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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7723369860935524, 0.8502346877370417, 0.9096827269279394], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXmQVNUVxt8wW3eXdPdMTz9MUi7A6LApi8ogsVD2fRCwNJiUEg0uyOoC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mQ13UZxz+7vz1+uyO/6/v7frepEHbZHfbywHEWoyK5ZJdLFyuGckaS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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8287671378002528, 0.8690526396965866, 0.8844020695322377], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuMVdUVx89cZu6dO9R773DnHBShjygwPAZftfIQ5aWg1JYZxqSiYn0i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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmeMlVUQhs9elrv3gty7y+X7LkVjDHUbzSAgIizSAqLsApEivQgGlqaA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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8851972895069533, 0.8878705916561315, 0.859121412136536], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG1snWUZx5+Ws/Y8h3FO24dzTgeJhg8bDmXry5Busm4jqGs1I2EvbOtA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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllWto1XUYx3+7HXeO85wz/57/3zkofJFdrLWdaWnpbGZ5IQhEQ3MWrS0K
QmuZ2UWJkmhFZVHNAu2Nbx0RXtKKrV2sVaBpJnRRkcq1bk5J1k37fPm+eOB5
fs/191yntq5duqY0hPAMUA40VIdQD/wJcR64MhvCvnwIz4E3VoZwrBDCWt5S
JchAb8iFUBOHMD0dwolMCO3wO+CfHhfCZvi/wXsXOAz/M/j1EfLo1ON0LnAG
2bGJIfSBj2JzEvwIGCKWB1IhDGDvP2Sy8I9jrzwJoQy4gOxE7B2G/yUwCP0E
/Ln4mgO0o78En/vh7QNWQB+Bvxh8EdAOfh+wmVhujC17G3AA32/zdg5/U/nD
JvAG+PPgNQN1xPIR+egkH7PQnw2+Df4ueN3ADGLrROc4+t/C78XeBKCNv0zG
XgKvBf8b4Y0CC8FvBVrB7wWGsXUNPlqJdwh7v0B3A5+DD/HfF9H/AroG/KeM
c/MddFvGOfoEWwGZ+/F3EntPgk+HPwv9k8jsJpb1vPWWuqb9yPcBDwXHcDFr
G9K9hHhr0Z0Suzaq8RZ0b4ZeBn4HsAS8H5v70b8TegX068iMYL8N+lXwx8jR
QnwN47+C/KQS/y2FzNFJ1KHgXqmDfzm8K4Cd8I9hcyDvHCp3W7DRjP2bYuve
nnavPkjMj1S6Z9V7e+GfSrsHG8GLwMrgGtYivwyZech+D1wAH8T/CfRrkB+D
bsB/bnwIh3j7Gd296jHwQeKrSpwj5WYE+it4O4hxHbbOIfMXvD28Hay0TpHY
p6iHSi1zfdZ/0l9aKpy7gci9rhz+zSyMInO2xDNxrfpB9Qefk3bvduecW/Vw
Nbpbc869aq7avAK9PO0a1YI3Rp41xaBZGIn9F83EemK5JXYtq+A/nHfPqFea
iPEf4pmGTh2++uEvRnYDMhH4SnS6Ys+Ael81W47sD+T4sjLX5J68Z06zNq3c
vfsC9n/MuIc/gPdhwbOpGo0jv5WJa6ue7CUX27FRXeYZP4jtQ0BS5hl9DVvj
E9duGPpZ6JnQ8/H1NfTz0NdBLyj3TL4EPT/2rJ2C7oEejRybYtbfHgd+L/Uf
N2pXxc6FajAD2aMF17oI3Ud8Rwqe5U+Jrwl6K/GtrvAOewP8zWrXWjPxTt46
ktUO7EX3Y+CbSu+si+S7BB+rqOVYif9erPYuVg7K4aWAu1PegdpFdbF7Qzvp
BvUv9pqwtw17a+Av5W1R8Mz3wPs3690kn9odPZFzoR3Sh/yvsXdNBzr9ykXs
3f009OTYO1+7/ip8Ppr3TtIuUo7V+5ohzY5mYEFsG9JVT2YS95x67XTGt2RV
wbtbN+Vq5M9n/ffZyN8F79Kcb80mIE+such/aycHIfKN0m1SzkqwX5r4NmiH
VkTe2drVytnZrHtavawZ0y5eXbBt7eQucv1WzrtfNTxQsE/50o54n/j2AJ0p
75iZkXtCvaC3dOIcKnfq8e2xd5x2m27Ee9ATEu8O9Vgz9pPYuWzBfkfeN0e3
Rjsqi+2qyLdPN0S7/Kmcc6OdXsRWfeJe185al/dN0y3TDNRjvyvnWVVP6Ja8
nHPudVN2wd9dsG/1iG61drZ2tW72Geg/Ys+Wdvj/o7QeRA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl91P1mUYx29+WDw8CM9DD8/vQTzo5Q9wai8HvW9W6+2oddRBB22KeVBb
KtDc2hTUQlIhS+tAkMSXTRGxZSIhSlkTEFFUSEucbM3IZG262lp1fXZ9GRxc
u+/7+l339f5y/x58693X3olCCK/mhZBv61mDXwx+Nng/HUKNwYtzQsga5AzO
GL4oF0JTKoSbyRCmIseXR04Ta99tdOW2P27rnXzHj9l+3hzH99v+UeNTa3zK
i0KoN9xZu5cf+f7ZQj/nTMZ+g9jgMaP/0OjnGf1uOx81WG58TmZD6DW4mgjh
XGkIQwbr7gnhlOleaHc2G7/vMiH0Gdxf4PLnyZYdRvt0SQhvGn1HHMItg19N
7j7j3WWwFznG+6bhRyM/HzNYbXfbbP0m6boURo5fFVwv8JW2b7d7kwY3Itfv
R8OP2/6i7U/bfsz2ZdIHn+DDijkzuArpiU5bbJ+29ZZBIzS2XjY/jRocMJoo
ctnIfd1smm+2vRFcNj4otvXjpN+BPrbz0qTzzyTdnqrggE3Vwe04Khv3KRbY
yJrTfqfBBePZrJjDk7izLtMemci+VOg826RnQ9Lx6FMb3L91ts41Pg8UeH51
STayuuR/6O6zbyOFLh9+e8SzTPuMaLt0d1PS6bcEXy9qny5yW1YGv1cmPuuC
5x16lRQ5fpn4Z7TPKgbYuFp+xH855Sw8+Ybd1AS2NsgPSywvtlo+TxAXs/cV
w122/SLDf5Dy/K+yHE5aDr9g3580/FOx02FLfdL9Th1iC/54wr7XpZzPbdtP
GfTrOyv2ki8D8jk8yKmtwWsPmeQMuYZefCO34Ye91DH1TI0TI+LDvjrp9YHf
vjD5p63WHipw/3Mf36xRziSUj9ciz8m1wVf8/XzsNmMv/EYSntf457J0QSa5
S97+Y3l+Ius8N5nc1Wnne8xwXVm/X5n0ur8dOS9qjr4BnxX3Oq+U6Zs2WGbn
6wmnB08fWWswavRLEn5mPxk5LT6/m+80f9r+e5P5b4nj6Tcvx87rB8P/V+L5
Qu1yn/pFJ3DHVQvgDgbvlfSAn+TzrPon9+BNzsNnfoHjKkRzRrkGL/jQY+in
Y+rTU/LbCtmJjSHl+qHHYtP34dj77yLDPW46P5NwOdg7qZyYUNwWWW7+ZTR5
kffQvITnBbbOzTnPaotJY8p7GLVWWuTx+shwj+T8TF6khae/s1+pWqP28uSv
Sdk+EHu8iTXzAxrys0J9E99tSXmNTSjPoIUnsSJmxJH1jvasd5Xb9K3bigt9
CH9NyUbsI9b1KdcDvtgNHd+AYtHAr1gzcY16P72IOUBOc/7a/Py3fMispb9T
m/i9UWfq4cZ0rUgGPHeYDqUZ1xX/NKiuY/VMehe2VMoeetMGg/UGhw12GbQa
dBi06HzE4EtmQHAee8WnU7R8+z32+UodMyc2im+75kGzZha5Qs/5w+j70t5X
TokXck5Kj071JXopOYP+9IOV6qvoy1w4JN7o+pV0bDPoEz9w9Db8eEC2M4fI
82t2HjI4F9yPjcH7Hu+ds/p2Prh+fZpl9Ox+5WG15gL3e6X7uM7DBp9bLLaX
etwX2Hsqm+f8rojHgGqaPXWdU80Sx6v6Phj87TUonehTNcF9vNBqZXHOc31U
vQx9eKO9FLvNvYolPr0xq78uNV0aDK4H1yvOm9Gd9ZpotunbHs1o5hm4pbpb
qDlATHbr/VU9S++rsvWKbMyqFseUt9QD/tmc8rcROg7oHnf2K2+Jf4Pk4sti
1e46xee8fL5ANNg0oTqZtjeeFQPWYcVsWHafUMzxc49yl/z6Nnjv5Jyvefi2
6A/Jv/RYaMiPMb1Zoa1RzKCnL1Lb1PWQfEyu8Q6k7ul1zPn30j53eROOKa7d
du941nHM81Vpn3/Vep/AM6sYDit3uqX7b7HPP2ZfRm9VYkbdfmKwTXXD+ql8
2qR6oEafi/XWtL5yOut9v1Z3m3SnbRaP3eJ9Sz2IuuO9MaI3Savucb9Nb0n6
0LjmOjlVJ17QrJcMzrxvqNFmyQT/WfA+1Si+LcFpOO9U3A6KF3q16h586VG8
eTbpLcTcWaP34YjeVcgcV78mRqPyOz7nG/eRx1yvVG+p1FuXfZNkoiP9r16y
MubPsozPkkZ9b5HcC3rHbpB903Zy3ij7WuSH5cpLcoy3eaT3TLH1hs7Y+2iz
crVdfqyT/Z2qH+qAXntJb9e0+sRWxZM+ekSyqe8a+Xet8uWwePTKx0fEmznf
oX+o7bZfmJ3Ji52Ky7jecfh8SHXVG2bqE/2ma5Jv1ES+bNwl2R26c048BpX7
PcoJdKyVzzrkC+Y+b1L6z17VBX5hPpTr7XRIMntkU5/0aZV9h+VH7lYpx2rF
p0d6DypuVfLdtK4nZD96dguo237hBnVuFy9w/wPQwimL
         "],
         VertexColors->None], 
        PolygonBox[{{5567, 5569, 2268, 520}, {5424, 5425, 2111, 749}, {5563, 
         3631, 2758, 2261}, {3642, 4293, 1169, 2111}, {4882, 5060, 1823, 
         2273}, {5940, 3836, 520, 2833}, {4503, 4504, 1374, 754}, {5560, 5564,
          2261, 514}, {5428, 4560, 1410, 2115}, {5568, 3635, 2760, 2268}, {
         5574, 5573, 530, 1638}, {5368, 5061, 1824, 2049}, {5706, 3992, 751, 
         1823}, {4558, 3994, 1826, 1409}, {5809, 5871, 2763, 2517}, {4210, 
         3668, 90, 718}, {5683, 5681, 718, 2368}, {5693, 5691, 727, 2379}, {
         5810, 5873, 2764, 2520}, {4213, 3675, 115, 735}, {4212, 3672, 102, 
         727}, {5872, 3678, 143, 2763}, {5900, 5901, 2520, 533}, {5897, 3978, 
         735, 1166}, {5938, 5937, 513, 2830}, {3833, 5559, 728, 513}, {3971, 
         5936, 2830, 2840}, {3986, 5809, 2517, 2793}, {5873, 4217, 1096, 
         2764}, {5898, 3982, 739, 1094}, {3631, 4286, 1162, 2758}, {3635, 
         4289, 1165, 2760}, {5700, 3983, 740, 1167}, {4559, 4558, 1409, 
         1410}, {3646, 5368, 2049, 1374}, {3838, 5899, 2793, 530}, {3678, 
         4215, 743, 143}, {5869, 5870, 1167, 743}, {5867, 5868, 1166, 739}, {
         5865, 5866, 2260, 728}, {5939, 3977, 2833, 2832}, {5705, 3991, 749, 
         1096}, {3984, 5701, 1094, 740}, {4881, 3840, 533, 751}, {3672, 5941, 
         2840, 102}, {4884, 4882, 2273, 1642}, {5057, 4879, 1638, 1819}, {
         4293, 5057, 1819, 1169}, {4286, 5682, 2368, 1162}, {5562, 5560, 514, 
         2260}, {4289, 5692, 2379, 1165}, {3675, 5942, 2841, 115}, {5062, 
         3993, 754, 1826}, {5061, 4883, 1642, 1824}, {3976, 5939, 2832, 
         2841}},
         VertexColors->None]}]}}, {{}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4379, 3668, 4210, 3966, 5681, 5683, 5682, 4286, 3631, 5563, 
         5564, 5560, 5562, 5561, 5866, 5865, 5559, 3833, 5558, 3832, 5937, 
         5938, 5936, 3971, 5941, 3672, 4212, 3972, 5691, 5693, 5692, 4289, 
         3635, 5568, 5569, 5567, 3836, 5940, 3977, 5939, 3976, 5942, 3675, 
         4213, 3979, 5836, 3978, 5897, 4290, 5868, 5867, 5806, 3982, 5898, 
         4214, 5701, 3984, 5699, 3983, 5700, 4291, 5870, 5869, 5808, 3985, 
         4215, 3678, 5872, 5871, 5809, 3986, 5899, 3838, 5573, 5574, 4880, 
         4879, 5057, 4293, 3642, 5425, 5424, 3991, 5705, 4216, 4217, 5873, 
         5810, 5901, 5900, 3839, 5575, 3840, 4881, 3992, 5706, 5059, 5060, 
         4882, 4884, 4883, 5061, 5368, 3646, 4504, 4503, 3993, 5062, 3994, 
         4558, 4559, 4560, 5428}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3623, 5414, 4859, 3826, 4857, 3825, 4858, 5413, 4856, 3824, 
         4533, 3823, 5658, 5659, 5657, 3960, 5656, 5655, 5441, 5557, 5556, 
         5654, 3666, 4206, 3959, 5044, 3958, 5045, 4281, 3625, 4864, 4865, 
         4863, 3830, 5676, 3964, 5675, 3963, 4209, 4208, 5680, 3965, 5677, 
         5679, 5678, 4285, 3630, 4869, 4870, 4868, 3831, 5891, 5892, 5835, 
         5890, 5889, 3671, 3629, 5864, 5805, 5894, 5893, 3835, 5696, 5697, 
         5695, 5896, 5895, 3674, 3634, 5570, 5571, 5446, 5447, 5698, 3981, 
         5054, 3980, 5055, 5852, 3837, 5572, 4876, 4878, 4877, 5056, 4292, 
         3639, 4502, 4501, 3988, 5720, 4014, 5448, 5449, 4193, 4192, 5105, 
         4031, 4580, 5461, 3692, 4400, 4401, 4402, 4254, 3776, 4477, 3775, 
         5585, 5586, 5466, 5467, 3695, 5591, 3871, 5470, 5469, 5468, 3863, 
         5587, 3778, 4255, 3864, 4911, 3865, 4912, 5476, 4915, 3867, 4913, 
         3866, 4914, 4260, 5588, 5589, 4916, 4917, 5814, 5816, 5815, 3698, 
         5477, 5478, 5333, 5790, 5789, 4153, 5783, 5928, 5927, 3681, 3645}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3913, 4929, 3882, 4928, 3883, 4930, 5531, 4927, 3881, 4926, 
         3880, 5598, 4336, 4337, 4039, 5736, 4038, 5737, 4424, 5503, 5502, 
         5501, 4052, 5746, 3781, 5743, 4048, 5494, 5495, 5496, 4420, 3703, 
         5493, 5492, 5742, 5741, 3872, 5734, 5735, 5731, 5733, 5732, 4419, 
         3704, 5499, 5500, 5555, 5554, 5426, 5722, 5723, 5721, 5912, 5911, 
         4405, 3702, 5491, 5490, 4047, 5740, 4222, 5122, 4051, 5121, 5497, 
         5498, 4432, 4433, 4050, 5744, 4049, 5745, 3641, 5452, 5451, 5450, 
         4152, 5782, 4151, 5340, 5341, 5337, 5339, 5338, 3697, 4325, 5704, 
         3989, 5058, 3990, 4334, 4333, 4252, 4907, 4908, 4906, 4910, 4909, 
         5475, 5474, 4905, 3861, 4904, 3860, 5584, 4250, 5846, 4251, 3853, 
         5458, 5459, 5460, 3869, 5590, 3688, 5457, 5456, 5828, 3771, 5553, 
         5421, 5715, 5716, 5074, 5714, 5713, 4394, 4395, 4028, 5728, 4027, 
         5729, 3633, 3673, 5445, 5444, 5856, 3974, 5694, 3975, 4288, 4287, 
         5048, 3969, 5047, 3970, 5049, 4211, 5689, 5690, 5419, 5420, 3628, 
         4284, 5671, 5672, 5670, 5674, 5673, 4207, 5668, 5669, 5415, 5416, 
         5417, 4280, 5043, 3956, 5042, 3957, 4205, 3665, 5888, 3955, 5651, 
         5653, 5652, 3821, 4530, 3822, 4850, 5411, 5412, 4852, 4853, 4851, 
         4855, 4854, 3622, 4279, 5035, 5036, 5034, 3951, 4204, 3662, 5032, 
         5033, 4845, 3813, 4531, 5037, 5038, 3952, 4846, 3814, 4532, 5039, 
         5403, 5804, 5404, 5642, 5641, 5405, 4847, 5858, 3815, 4526, 3816, 
         4848, 5406}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV01toz3EYx/EvS5bMTmYos/8OhcSNEJNyYeZQIhulJhdks5kLimFzvOPG
aYxQDmmElFDKsZzdOOXQ5rRhSs6nDa/vxbvP93mez/N8n9////sl5i+ZUd0l
hNCJhakhNPcJoTEzhBt0Nz2eHsLLjBBeYJd4cq8QxmWF0OB8TK1FvhnbxCVq
FWkhLDBnu3gnduC0XJ5aO1+R3g+0Se97+g4Jtf7yb51fOx9Ve0Vf2KFNrp9a
d+dk9HVuotn0iNmn4n68rXyL3XtQbpq40p3V4kPiKnqYnpErVMvT+4n/g/NJ
/e001cw09EQvpGC6fAES/LnIkEvHtziD5mMgEsjFTPlB6OquJJw1+xzOY4j+
kTz1dhlNR+G+/E36gD7ELbVf+n7ikbibeJedG3BPf7I4Ry0XA1Hjrsl8UzCJ
Z49ZxXRwdghz1UbEPfna4q40gVbnwjifFtA/+I0K8W3zF7mnApUYam6WWX0w
S70MpXFf/onxLgznO0GH0TT9LfH/iP8fcsT71PZjsXoVqjFVbSmtwRLc4avk
2UoHqLV6hjZcENfSSs/xkR7gKaEPe4fwGI9wl+effYJzB/2LTuzle2b2c4wR
F2EsCvifyuXTJ7QUZXE3d3TEd4bOEc9GY/wGcJF3Da1DLVZjFZbxbnDvRqxH
D/2b6CX+z+66TN/E50EbkjDP3PL4rjtP4L/Jf4VvC00Rb6Y9aT3qsFecSZd7
X1dgJYr1fjH/avx9xNfoV/F4+j1+u3Ff+ev0mzhL/zrxWtRjnlw5fuA/R/CV
GQ==
         "]],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV09lL1FEYxvFTtpltbtNKEVE33aoQBtFCSZQzetFNq9KqlRVFIYZBC0Tl
lgZFe1kRtBh0o2n/Q3XhNopQF0WkqS1ESZ/fxXee933e5Zw5wywurSg+PC6E
MNHHwhkhnE0PITErhAu0iJ6jt2eG8FL8NTOEF3R6dgjT0JcRQr+ZZj19NClP
4/fSpPwBv5f2yKfyL8knxEJIwVW7nsp71LvV9zijgVePJ/xufhe/Tl6LAnm+
HTXix+of1N7jinyD2nykRnW13Xa9cs8WxHjZmOTM+3qzxE/FmfRB9H30D5j9
ZNdd+R1skmeop6NOvdy+e/wv/BZ6LHoPepSm2RXnL8Ei/fX6/9n1FyO8X1kh
jEZvoO+neIyfF91NXGl+nv5W+Tv1NlrNyxHnYq19a7DF/HLMduYcxJCiby4t
Uf9sRzvtwB99k/lveW30DVpxXv8COol2Ru8e/TZYIM/jT0HcfCpN8tPoVLSj
y726sVjviijX14m9ziqQ76Ov3XeDuM/sEAZxnP+dDqM/emcc4G3UV0Yr7Szk
bUam3R/lI+Jib/Nbvt5b1TinFqv4pc7o4H8zP4RB5MpPm6tCXE9M/lU8Ki6M
vhMK7am3ozH6PdRWR78RHcN+8T5cEFc49wgS+otwTX+OWhNtMB/nHVQvx1Ln
VNMz2Mrfhuv6yvXfoI36t0f/B3sv67lIi91lpbmd/F0owXj91/Q2YYc8Xz2h
bxm9aS7D3An+SZzCoWi/3uuokmep39Z3ie4wty56D341bulJerP1vAFxmfp3
OoxmPMJzd/1Bn9GH0X8CQxhEwtx/9NmZvw==
         "]],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1FtMj2EcwPGnMMeVUwz/bLKxsTnMRWWuRGwuRM0c2pBQNhlyYc7MqTJE
Y0MOMzdOjRjNZSwkp6HMktNGyYWR48bnvfj2/Z2e3/O+b61heatmF8WFEFL8
GN87hEIUYGefEGoSQ0jnE9zeL4Sb3MY3eOGAEHaIpySEMDEphO3is2bv9A2h
FlvkGXrpepvFZ/Ruqddgg3yyXrxeHMr0Fth5yb0Xkaz3wlyaXiOf0n/OzxDT
e8ypek+4Uq9J7ZG4m9oF5xvl/dRfcKm7yhDveeOwxD3NXKJWx3v5nNmHzjdg
tzzTuUHoat8+vTxn9qi3qJ3gQvlxLuAudsxQ7202EfvNr1Cv1P+kniIfjmue
qxqDxCU4jEMoxzz1dVyM9c5ed3a2WszuZAzFRr0r/UO4iiqM07/MY3nUwBBG
46m5GMfUTut9kJd6p/dcFn07O2aKs1DvjgY8QK75OtzwvEf4ibl88RS9pVxt
PkP8VL0NrVirvtz7fhYP0bsvrsdgcZPaS4zxLpnyqdE9el3lDZwsb9cvEH/h
NHkquuvnyXtwo+fo5JmbuZf8D/fkEeZeiVPELTxSniDOdy6R30Rzzr3jvvIx
6n34rfw7viHLt+lQy+AfPIu/cg7/5hn8i7N5l/dsdSZJ3MZV6p+41t6P3IHF
evE8hztxHv81t5SXIRf5WIK99q3kIsSwBquj36v5Ql6Buujb8HL8tG8Tb0Yx
tmMbuqiXcCl2R3uxJ8rtf+27tmCWb5ODbKTZ39neVP7n7H3xIrOTcMC5g9iP
QyhHgpkjfBQV0Z3+BrbimPl59r0Tz+e5WBD9b5A3oREnzRx3/23xtOjbi6fz
YnPnxRV+P3V8F/eQpF7veR5ggvw/Bw6oSQ==
         "]],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1FdsT1EcwPFTajxQRbVGCJGUeCgPSo1YURKhElTNmLUi+oDaiVVB4sUm
qBqJvXkhYsSoXVusB1JUbBIixuc8fPs9v3F+995zb//NxhYMmJYQQujjT2py
CNNqhzAAAyPiXB6EB7VC2Jgawib0qxdCDsYlhVBRN4SxfFz+nXWZ3rf8BuW4
UCeE++pn+R4vlFuES+IRZi6wno8S++6qn5YfJj/RtScgRb5Mfp/1UPm5eueg
WP62/BH9Q+Rny3UXt3Nfs6y3qh9Q24/p4m5q+Wbk6Z0hLsRM7JdrqHZDX6a9
N3mLvdf5GqrKVUGp9UN9m+NZcJG9y7AUo838oydbPpEr4y/GyAfn8s/6lf1X
rF/z9xTn6rq/OM28+hgs/iHO4z36Mnkdt+X0tBAy0BpNXSPJvO16G6gVc0Nu
ZkZT9LVnp+tecV+luIpDej7jC9bqXYNFejP4g9xHrHBfJebuMn+iPbv5jFkT
rFeqlau9Qb54tXgNDtrX0oy11nvV9qHQ3B3xHvBJfTfvQn/39Fa9Au/i9yNO
19uPk3i9OZeRIB4trhSfQfwzvgtOFLewbolr4jNcyl9xA61c6yaX67vNGeJb
vMBz3OV78VzVyvgOvuE+HuC9/CN+iIX6n/NLtJF/yq35F59zzZHqmWhvfhba
oSM6xHPU14W7ojNme+5ZWKK/pjgJNZCMWjio/7HzfILzZl/AqPgNo6d6Nnqg
N3rF96c/h79zH/7Gc8wv0p8qfipO4Wecxof5hdlH+aLZl3AZWfrz1P/I5/Jf
HsK/eRQHzzqc/8X/N/OX628sfiFuxC+5CR/jV+afiO8qvo/4btBJ/0z1quZM
52pcyIk8RT3P95KL6uJ58su5rzkdzWkun44WSNDbHiflS/Sc4izx+PjNxTPk
8fo2+J42YqraZPEk5CNZfb2+lTwi/j7YXxB/DzAD2eIK9Rz1peIiLEOBOcXm
bcNiz19fvYxXqe2Q+w+2XcIL
         "]],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1HtMlmUcxvHbFdMsU1AB1xZpGhoyC6rVzMq5moiuVdCs+eoEqzlPqVuK
NjOzoWkK0aZ2UPLAK3hankibqdOZSRnmqdJOCqs81TIPmWaf+48v1/O7ftf9
e+73fnieziXjnh7bIoQwzZ/qW0NISQ2hMT2EljSjXQjzsJifaB/Ch3R8Wghj
8ay6GI+0DWF/B2vwEv9L2oAnrP9AfhSvFO/xFmF3nKU3DMvMztGrpg+oA+bq
d+d1wSDzC1GuX2btFBTxB2Oh3Ej5BbSqYwjP8CbrT0KpfJN1zcjin6C/IF/+
LfnbebfhDtksvCmfoENRwC9EldyL8u/QCvP7857Xfw4l8j+Z9zMy+T/Q4+gl
Xy6fweuATrKZmCk/kA5CX34/VMq9IF9B3zb/MV6Bfn8Mk//evGNI5R+lR5Ar
P1O+Ha8N0mRT8YZ8H/qnZ/EQvzcejucez9PsOXhQ/Yd+7/g75Q+Zt1p9E38V
Pai+wm+lbokU5PEL+DP4+dadVefx78P9GB7P0+zZuFd9JvblEvIHrKtTt+DX
0kZ1j/iM1dfpNXzHf132Vb/pFf9zv6tzrT9Fe9Fm2pP+RnvQX2kOvUf+M+u3
4VMk+V+bX0NT9L+lN9Cj9EZaJj/R/JPqbHUT7U5P0G70LnRBV9yJu+WLUW/2
ZjSYvQ8r5Ffo12AplmMZVsqedQbnMFJuDd3IW0s30dG8MRiFv3nn0dbc1rgZ
y81tQ29BjfyquCfnUkez6eq4PzpBv9L5VaCbupb/lLWt+ANoFi2Mz5RWu8cs
uYHqEe57RvY0Juqtc4+V+kl0NWeOs5kvOw8nec1oQrm6xNqt+kutKXX9EZ1s
RhmetHYGzaFT4rsiV4kkatCTX0Vz6bs0n06Vy6PldBY6Yqg9zo7fBJpOB+uf
t9e/sNce9lj7Of3Hnq7gX1zCZVyVaW9Pj2Kc/S2J3xMsMudl9XgUmZvk7ZV5
nz+Bd9Xa4vg8+dfMSLrnF/pp+vvi+aj/49fqN8Q6fttoXfz/5a+lX6nX0P10
HQ1mrqeN6o/pRmxAunozrccmbMEnyOBvpzuwDbviu+K37qSHaab+Afca4rre
Xr+J767rBA66fjy+x/FbSwvivmWm0dcwHUXxO6X/I47oXeJdxAVkq/s4hwT9
Hwby3Pw=
         "]],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1Ftsz2ccx/HHIt0c0nOJQ7V/2gtNOxanKNq/mixBJ6tEHZZlcSGymFOI
BDHUOSsmwcacGUbirBSl6nhhblxJJNicwpXjtGZez8W7n9/n83ye7+/5/f7N
LzFpetW0ViGEb/xJzwghAwfSQxibFsIfdC9yUkPYk8ljJ3ZjF7LlW+k2bMbv
2IKW7BCa8Zvrazq/0qt0WlYIY8x9kxNCFU3taA+92cE+2kKP6jXRI7TYegk2
2r8Jc52tp/OstV5Ef6ZrUIt16K7bA7ddF9ICHDfnkPsdo3fkU5zhOf8Mu2VL
ZctQgxVYju3OMpLuoGV65UgiT3+VvJt7r6R5dDXNpfs9b4Luo/l0XTwnOjlD
F3pW7wVexv2eI02+0/y/+F00nZ+glxefgV6Qv8FbzNT/073/dX0RCZ18/KLX
Oc7Hefkr7NMriL+jLBO3ZNk0CxP13/P/oRHvcFB/g/wQbeYv4X98wHp5rn3d
0MC/xgG9QvMrXX8dfyfvpU52mJ6is2VzUOz3KkGtrFT/pPdyCidwGnUo9tz3
6H2802nGPP2xdD5dZGaL60+tp+CMrDf9Ap+b3QtrZIN06mVnYwfncQ4l5j+g
f+O9zgcs1K+mP9HF5n9iRhvrn6Fe1pf2Q295f6yVDdZvkF1AH1kjvRjPYf4/
9CFay1OwWH+c/hK6xPy2snbW28YzyZJ0KAbIh6Asqv4lWan3XcoPok3xXuY/
oiP49vJUpGG8/lKza5DJ39HLis9t/mj6mi+Xf4nh8R76l+WDzamI96NX+L56
j+lIPkuegw6YoL/c7GXoxN/V66zXYP73tJX+V/JRqERS/6q8TD6CL6fX+P72
PaGj4v+pvCtyMVF/pdkrkM/f00voNZq/gLbRr4rPGc+CCv3r8mT8LvFD6Q1+
oH1PaSWfkBegEN/qF9Ge8Ttl7b7ed7Im87foZ8gmWfsBU+M7snZTPkw+Ob43
eosfYl+170WS/iifgVkYxtfG7w9m2FvBp9Aaax8B0c60zA==
         "]],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{
      Rational[1, 10], 5}, {
      Rational[1, 10], 4}}, {{0.1, 5}, {0.1, 4}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 234},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41801874]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20183],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->18613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ParetoDistribution", "[", 
      RowBox[{"k", ",", "\[Alpha]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "k", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", ">", "0"}], ",", 
      RowBox[{"\[Alpha]", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10600],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102858256]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332729216],

Cell["\<\
The probability density and random variable have a power-law relationship:\
\>", "ExampleText",
 CellID->63892748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ParetoDistribution", "[", 
    RowBox[{"k", ",", "\[Alpha]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419416617],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["k", "\[Alpha]"], " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[Alpha]"}]], " ", "\[Alpha]"}]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->906547258]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"constant", "=", 
   RowBox[{"\[Alpha]", " ", 
    RowBox[{"k", "^", "\[Alpha]"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->506624372],

Cell[BoxData[
 RowBox[{
  RowBox[{"power", "=", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[Alpha]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->245467550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"constant", " ", 
  RowBox[{"x", "^", "power"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->77871665],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["k", "\[Alpha]"], " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[Alpha]"}]], " ", "\[Alpha]"}]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->13434676]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->508680630],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParetoDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParetoDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " is not a real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ParetoDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "I"}], ",", "\[Alpha]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31155],

Cell[BoxData[
 RowBox[{
  RowBox[{"ParetoDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(3 + \[ImaginaryI]\\) is expected to be \
positive.\"\>"}]], "Message", "MSG",
 CellID->120979496],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ParetoDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "\[ImaginaryI]"}], ",", "\[Alpha]"}], "]"}], 
  "]"}]], "Output",
 ImageSize->{232, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->431559184]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParetoDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParetoDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->23158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ParetoDistribution", "[", 
   RowBox[{"k", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4464],

Cell[BoxData[
 RowBox[{
  RowBox[{"ParetoDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-1\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->17378088],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ParetoDistribution", "[", 
   RowBox[{"k", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141519558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"ParetoDistribution", "[", 
    RowBox[{"k", ",", "\[Alpha]"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"k", "\[Rule]", "1"}], ",", 
    RowBox[{"\[Alpha]", "\[Rule]", 
     RowBox[{"3", "+", "I"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{
  RowBox[{"Greater", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(3 + \[ImaginaryI]\\) attempted. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nord\\\", \
ButtonNote -> \\\"Greater::nord\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->361904317],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9V0tuwjAQDXHCr9AfVKWrsmmrqlKP0c+CQyBUCdQiEGUBdMERUFcs2hUb
lhyhR+AYHCO1nTExk3FI+dQSODOeefP8HBtTqXbrL81qt1Grlh871Xa9UXsv
P7Q63MUSlmVN+OeqZPFnjz/Jz8TzeM/Et9Pr9X5kWywWX4GfDYdDTzbrm/Qm
+ZfLwSxXDkOTQby3YVT0Du8d3gs/A1uN+7B+wzZbi84Qal6z1biNUBWjc3JW
aVUCbBEtiXmqKQyDV8uV1FMoCmJTKJZpiEGUswUbFlH9lKoeYdvE7C7+R78I
VuT47jWMYHAcR8e189yPkq6Bv8m/qXJq75lqHW6skfunXbp8R53Ab62OxFtf
MspWesRSieZCo7ukl1INc1hVK+yN0M7RY/EJ6SCfmhU+WZVtL2WQDUZM2VQ1
CvnIoOtqJaW0rWWWzPPW8PLIxuP3yC6E1hPv41uyrvqdzAHLG5QlbHFM35HZ
9G/vfr3+vMbj8XQ6FY9ZxLiI7L6WFWBltCixWEVkD7Ssdrs9Go3E48GaWj2S
dxq0PYP+wxgVhT0wZjHgz5a84+n5Bjm4sniFU2rva35xK1iezyG0V4/a5fgm
kUQ6K20yKI6u4aPx2yDsTn8nc1vLEhSSa+KeiGpBXsAuC+zI+1CIXQtFYf22
m3sTovFqYVTMNR46jhLniTAryJ8DpQoboeJ3Wq5D6J253gn2M8wA3yZPQEeX
RMWnCZ5nn8zS10SdJtE7XQR/BqPObDYbyjafzy/Jmv6/IivxC1sP4kY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->477078872]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19649],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->3415343]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParetoDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 9.1945776}", "context" -> "System`", 
    "keywords" -> {
     "Bradford distribution", "Pareto distribution", "power law", 
      "power-law distribution", "power law distribution"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ParetoDistribution[k, \\[Alpha]] represents a Pareto distribution with \
minimum value parameter k and shape parameter \\[Alpha].", 
    "synonyms" -> {"Pareto distribution"}, "title" -> "ParetoDistribution", 
    "type" -> "Symbol", "uri" -> "ref/ParetoDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6673, 223, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->620376828]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 192424, 3736}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1286, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1909, 61, 1583, 37, 70, "ObjectNameGrid"],
Cell[3495, 100, 764, 24, 70, "Usage",
 CellID->8326]
}, Open  ]],
Cell[CellGroupData[{
Cell[4296, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4774, 146, 657, 25, 70, "Notes",
 CellID->429991538],
Cell[5434, 173, 503, 17, 70, "Notes",
 CellID->21184],
Cell[5940, 192, 696, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[6673, 223, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->620376828],
Cell[CellGroupData[{
Cell[7058, 237, 148, 5, 70, "ExampleSection",
 CellID->565153950],
Cell[7209, 244, 270, 6, 70, "ExampleText",
 CellID->5692],
Cell[CellGroupData[{
Cell[7504, 254, 172, 5, 28, "Input",
 CellID->14550],
Cell[7679, 261, 959, 20, 58, "Output",
 Evaluatable->False,
 CellID->83070362]
}, Open  ]],
Cell[CellGroupData[{
Cell[8675, 286, 176, 5, 28, "Input",
 CellID->13795],
Cell[8854, 293, 1122, 22, 64, "Output",
 Evaluatable->False,
 CellID->262157234]
}, Open  ]],
Cell[9991, 318, 121, 3, 70, "ExampleDelimiter",
 CellID->17350],
Cell[10115, 323, 252, 6, 70, "ExampleText",
 CellID->8315],
Cell[CellGroupData[{
Cell[10392, 333, 196, 6, 70, "Input",
 CellID->10036],
Cell[10591, 341, 303, 10, 36, "Output",
 CellID->393402148]
}, Open  ]],
Cell[CellGroupData[{
Cell[10931, 356, 308, 10, 28, "Input",
 CellID->3760],
Cell[11242, 368, 2502, 45, 169, "Output",
 Evaluatable->False,
 CellID->131935828]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13793, 419, 215, 7, 70, "ExampleSection",
 CellID->2534],
Cell[14011, 428, 250, 7, 70, "ExampleText",
 CellID->6050],
Cell[CellGroupData[{
Cell[14286, 439, 222, 7, 70, "Input",
 CellID->28082],
Cell[14511, 448, 333, 10, 36, "Output",
 CellID->309207013]
}, Open  ]],
Cell[14859, 461, 120, 3, 70, "ExampleDelimiter",
 CellID->1936],
Cell[14982, 466, 83, 1, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[15090, 471, 176, 5, 70, "Input",
 CellID->25584],
Cell[15269, 478, 1179, 37, 78, "Output",
 CellID->265083275]
}, Open  ]],
Cell[CellGroupData[{
Cell[16485, 520, 176, 5, 70, "Input",
 CellID->29182],
Cell[16664, 527, 1334, 26, 70, "Output",
 Evaluatable->False,
 CellID->102939817]
}, Open  ]],
Cell[18013, 556, 121, 3, 70, "ExampleDelimiter",
 CellID->23116],
Cell[18137, 561, 310, 11, 70, "ExampleText",
 CellID->6388],
Cell[CellGroupData[{
Cell[18472, 576, 200, 6, 70, "Input",
 CellID->9425],
Cell[18675, 584, 302, 11, 36, "Output",
 CellID->6812425]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19026, 601, 223, 7, 70, "ExampleSection",
 CellID->19982],
Cell[19252, 610, 112, 3, 70, "ExampleText",
 CellID->29591],
Cell[CellGroupData[{
Cell[19389, 617, 310, 10, 70, "Input",
 CellID->25867],
Cell[19702, 629, 2677, 48, 70, "Output",
 Evaluatable->False,
 CellID->691616220]
}, Open  ]],
Cell[22394, 680, 125, 3, 70, "ExampleDelimiter",
 CellID->703691229],
Cell[22522, 685, 362, 13, 70, "ExampleText",
 CellID->22632],
Cell[CellGroupData[{
Cell[22909, 702, 453, 14, 70, "Input",
 CellID->20189],
Cell[23365, 718, 159123, 2663, 70, "Output",
 CellID->41801874]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[182537, 3387, 233, 7, 70, "ExampleSection",
 CellID->20183],
Cell[182773, 3396, 229, 5, 70, "ExampleText",
 CellID->18613],
Cell[CellGroupData[{
Cell[183027, 3405, 493, 15, 70, "Input",
 CellID->10600],
Cell[183523, 3422, 158, 5, 36, "Output",
 CellID->102858256]
}, Open  ]],
Cell[183696, 3430, 125, 3, 70, "ExampleDelimiter",
 CellID->332729216],
Cell[183824, 3435, 124, 3, 70, "ExampleText",
 CellID->63892748],
Cell[CellGroupData[{
Cell[183973, 3442, 200, 6, 70, "Input",
 CellID->419416617],
Cell[184176, 3450, 303, 10, 36, "Output",
 CellID->906547258]
}, Open  ]],
Cell[184494, 3463, 180, 6, 70, "Input",
 CellID->506624372],
Cell[184677, 3471, 165, 6, 70, "Input",
 CellID->245467550],
Cell[CellGroupData[{
Cell[184867, 3481, 125, 4, 70, "Input",
 CellID->77871665],
Cell[184995, 3487, 302, 10, 36, "Output",
 CellID->13434676]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[185346, 3503, 230, 7, 70, "ExampleSection",
 CellID->508680630],
Cell[185579, 3512, 435, 14, 70, "ExampleText",
 CellID->19522],
Cell[CellGroupData[{
Cell[186039, 3530, 197, 6, 70, "Input",
 CellID->31155],
Cell[186239, 3538, 214, 5, 70, "Message",
 CellID->120979496],
Cell[186456, 3545, 305, 10, 36, "Output",
 CellID->431559184]
}, Open  ]],
Cell[186776, 3558, 451, 14, 70, "ExampleText",
 CellID->23158],
Cell[CellGroupData[{
Cell[187252, 3576, 184, 6, 70, "Input",
 CellID->4464],
Cell[187439, 3584, 198, 5, 70, "Message",
 CellID->17378088],
Cell[187640, 3591, 278, 9, 36, "Output",
 CellID->141519558]
}, Open  ]],
Cell[187933, 3603, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[188057, 3608, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[188363, 3620, 340, 11, 70, "Input",
 CellID->25838],
Cell[188706, 3633, 385, 7, 70, "Message",
 CellID->361904317],
Cell[189094, 3642, 1000, 20, 70, "Output",
 Evaluatable->False,
 CellID->477078872]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[190155, 3669, 314, 9, 70, "TutorialsSection",
 CellID->19649],
Cell[190472, 3680, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[190666, 3688, 299, 8, 70, "MoreAboutSection"],
Cell[190968, 3698, 182, 4, 70, "MoreAbout",
 CellID->3415343]
}, Open  ]],
Cell[191165, 3705, 27, 0, 70, "History"],
Cell[191195, 3707, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

