(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     94880,       3744]
NotebookOptionsPosition[     74499,       3002]
NotebookOutlinePosition[     76337,       3047]
CellTagsIndexPosition[     76251,       3042]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Elements of Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingElementsOfLists"], 
          "Picking Out Pieces of Algebraic Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"], 
          "Getting Pieces of Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/GettingPiecesOfLists"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/PartsOfExpressions"], 
          "Manipulating Lists by Their Indices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsByTheirIndices"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Manipulating Elements of Lists\"\>",
        2->"\<\"Picking Out Pieces of Algebraic Expressions\"\>", 
       3->"\<\"Getting Pieces of Lists\"\>", 
       4->"\<\"Parts of Expressions\"\>", 
       5->"\<\"Manipulating Lists by Their Indices\"\>", 
       6->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"First" :> Documentation`HelpLookup["paclet:ref/First"], "Head" :> 
          Documentation`HelpLookup["paclet:ref/Head"], "Last" :> 
          Documentation`HelpLookup["paclet:ref/Last"], "Extract" :> 
          Documentation`HelpLookup["paclet:ref/Extract"], "Position" :> 
          Documentation`HelpLookup["paclet:ref/Position"], "ReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/ReplacePart"], "MapAt" :> 
          Documentation`HelpLookup["paclet:ref/MapAt"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"First\"\>", 2->"\<\"Head\"\>", 3->"\<\"Last\"\>",
        4->"\<\"Extract\"\>", 5->"\<\"Position\"\>", 6->"\<\"ReplacePart\"\>",
        7->"\<\"MapAt\"\>", 8->"\<\"Take\"\>", 
       9->"\<\"PadLeft\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Formula Manipulation\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Matrices and Linear Algebra\"\>", 
       5->"\<\"Operations on Vectors\"\>", 
       6->"\<\"Parts of Matrices\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Part ",
 StyleBox["([[\[Ellipsis]]])", "OperatorCharacter"]
}], "ObjectName",
 CellID->21665],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "[", 
       RowBox[{"[", 
        StyleBox["i", "TI"], "]"}], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Part",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Part"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["i", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "[", 
       RowBox[{"[", 
        RowBox[{"-", 
         StyleBox["i", "TI"]}], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]counts from the end. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "[", 
       RowBox[{"[", 
        RowBox[{
         StyleBox["i", "TI"], ",", 
         StyleBox["j", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Part",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Part"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is equivalent to ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        RowBox[{
         StyleBox["expr", "TI"], "[", 
         RowBox[{"[", 
          StyleBox["i", "TI"], "]"}], "]"}], "[", 
        RowBox[{"[", 
         StyleBox["j", "TI"], "]"}], "]"}], 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "[", 
       RowBox[{"[", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives a list of the parts ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "[", 
       RowBox[{"[", 
        RowBox[{
         StyleBox["m", "TI"], ";;", 
         StyleBox["n", "TI"]}], "]"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives parts ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "[", 
       RowBox[{"[", 
        RowBox[{
         StyleBox["m", "TI"], ";;", 
         StyleBox["n", "TI"], ";;", 
         StyleBox["s", "TI"]}], "]"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives parts ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26152]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can make an assignment like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["t", "TI"], "[", 
    RowBox[{"[", 
     StyleBox["spec", "TI"], "]"}], "]"}], "=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 " to modify any part or sequence of parts in an expression. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20454,
  ButtonNote->"20454"]
}], "Notes",
 CellID->32000],

Cell["Part 0 of an expression is its head.", "Notes",
 CellID->97389508],

Cell["Common spans of parts include:", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->420921086],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     StyleBox["expr", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{
       StyleBox["m", "TI"], ";;"}], "]"}], "]"}], Cell[TextData[{
     "part ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through the end"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     StyleBox["expr", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{";;", 
       StyleBox["n", "TI"]}], "]"}], "]"}], Cell[TextData[{
     "from the beginning to part ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     StyleBox["expr", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{";;", 
       RowBox[{",", 
        StyleBox["j", "TI"]}]}], "]"}], "]"}], Cell[TextData[{
     "column ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     StyleBox["expr", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["1", "TR"]], ";;", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]]}], ",", 
       RowBox[{
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["2", "TR"]], ";;", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]]}]}], "]"}], "]"}], Cell[
    "submatrix", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->133829891],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a list, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "]"}]], 
  "InlineFormula"],
 " gives a list of parts. In general, the head of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is applied to the list of parts. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->11593,
  ButtonNote->"11593"]
}], "Notes",
 CellID->3617],

Cell[TextData[{
 "You can get a nested list of parts from ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 ". Each part has one index from each list. "
}], "Notes",
 CellID->29173],

Cell[TextData[{
 "If any of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " or ",
 Cell[BoxData[";;"], "InlineFormula"],
 ", all parts at that level are kept. "
}], "Notes",
 CellID->30786],

Cell[TextData[{
 "Notice that lists are used differently in ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " than in functions like ",
 Cell[BoxData[
  ButtonBox["Extract",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extract"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31597],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}]], "InlineFormula"],
 " gives the parts in the corresponding ordinary array. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->147882474]
}], "Notes",
 CellID->26224],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    StyleBox["spec", "TI"], "]"}], "]"}]], "InlineFormula"],
 " can be input as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "\[LeftDoubleBracket]", 
   StyleBox["spec", "TI"], "\[RightDoubleBracket]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17728],

Cell[TextData[{
 Cell[BoxData["\[LeftDoubleBracket]"], "InlineFormula"],
 " and ",
 Cell[BoxData["\[RightDoubleBracket]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace][[\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " and ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]]]\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[BoxData["\\[LeftDoubleBracket]"], "InlineCharacterName"],
 " and ",
 Cell[BoxData["\\[RightDoubleBracket]"], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->26260],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    StyleBox["spec", "TI"], "]"}], "]"}]], "InlineFormula"],
 " can be input as ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   RowBox[{"[", 
    RowBox[{"[", 
     StyleBox["spec", "TI"], "]"}], "]"}]]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   RowBox[{"\[LeftDoubleBracket]", 
    StyleBox["spec", "TI"], "\[RightDoubleBracket]"}]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12158]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->117694169],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(10)", "ExampleCount"]
}], "ExampleSection",
 CellID->21889114],

Cell["Pick out a part of a list:", "ExampleText",
 CellID->7545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
  "[", 
  RowBox[{"[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14767],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->566507207],

Cell["Pick out a sequence of parts:", "ExampleText",
 CellID->249909138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
  "[", 
  RowBox[{"[", 
   RowBox[{"2", ";;", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->291778766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->315627229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30787],

Cell["Pick out a part of a matrix:", "ExampleText",
 CellID->8217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24565],

Cell[BoxData["f"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29942]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2088],

Cell["The second row of a matrix:", "ExampleText",
 CellID->10273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2815],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", "e", ",", "f"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30837],

Cell["The second column of a matrix:", "ExampleText",
 CellID->9388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19269],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "e", ",", "h"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126591617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13830],

Cell["An element 2 from the end of a list:", "ExampleText",
 CellID->10809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
  "[", 
  RowBox[{"[", 
   RowBox[{"-", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4640],

Cell[BoxData["e"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7321]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18319],

Cell["A list of parts:", "ExampleText",
 CellID->29881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
  "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "1", ",", "2", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "c", ",", "a", ",", "b", ",", "f", ",", "f"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13020]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1411],

Cell["Reassign a part:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->20454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25893],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21984]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2357],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22999]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["m"], "Input",
 CellLabel->"In[3]:=",
 CellID->30336],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18829]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->622748114],

Cell["Reassign a sequence of parts:", "ExampleText",
 CellID->86684127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->704179957],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311039832]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"[", 
    RowBox[{"2", ";;", "4"}], "]"}], "]"}], "=", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->685356397],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10599737]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["v"], "Input",
 CellLabel->"In[3]:=",
 CellID->20673363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", "x", ",", "x", ",", "e", ",", "f"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->788890635]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5950],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " works with expressions of any kind, not just lists:"
}], "ExampleText",
 CellID->21457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"c", ",", "d"}], "]"}]}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32405],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10365]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"y", "^", "2"}]}], ")"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2334],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30049]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "->", "4"}], ",", 
    RowBox[{"y", "->", "5"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19094],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28592]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " always operates on the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of expressions:"
}], "ExampleText",
 CellID->31270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "/", "y"}], ")"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->30119],

Cell[BoxData[
 FractionBox["1", "y"]], "Output",
 ImageSize->{16, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->23017]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"x", "/", "y"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->29313],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Power", "[", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//FullForm=",
 CellID->15253]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4977],

Cell["Equivalent forms:", "ExampleText",
 CellID->21505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24591]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6562],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4854],

Cell["Pick out parts 1 and 3:", "ExampleText",
 CellID->20072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23016]
}, Open  ]],

Cell["Pick out parts 2 and 3 of parts 1 and 3:", "ExampleText",
 CellID->25050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "i"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21945]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->360390727],

Cell["Parts 1 through 3 from the end:", "ExampleText",
 CellID->108303232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
  "[", 
  RowBox[{"[", 
   RowBox[{"1", ";;", 
    RowBox[{"-", "3"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3865998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125264684]
}, Open  ]],

Cell["Shorter notation:", "ExampleText",
 CellID->367327425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
  "[", 
  RowBox[{"[", 
   RowBox[{";;", 
    RowBox[{"-", "3"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->952717068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121742403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->392542588],

Cell["Parts extracted in steps of 2:", "ExampleText",
 CellID->120365238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h", 
    ",", "i", ",", "j", ",", "k"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"3", ";;", 
    RowBox[{"-", "3"}], ";;", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105967024],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "e", ",", "g", ",", "i"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15136925]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h", 
    ",", "i", ",", "j", ",", "k"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{";;", ";;", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->250226481],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "c", ",", "e", ",", "g", ",", "i", ",", "k"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->493738643]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1852],

Cell[TextData[{
 "Enter in ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32521],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6344],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace][[\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " and ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]]]\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->20259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
  "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28366],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2885]
}, Open  ]],

Cell["Enter as a subscript:", "ExampleText",
 CellID->14439],

Cell[CellGroupData[{

Cell[BoxData[
 SubscriptBox[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
  RowBox[{"\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]]], "Input",
 CellLabel->"In[2]:=",
 CellID->2718],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9107]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5268],

Cell["Assign several parts at once:", "ExampleText",
 CellID->3554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32050],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7432]
}, Open  ]],

Cell[TextData[{
 "Assign parts 2 and 3 to be ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->13799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "]"}], "]"}], "=", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32020],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16735]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["m"], "Input",
 CellLabel->"In[3]:=",
 CellID->31098],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", "x", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2792]
}, Open  ]],

Cell["Assign different values to parts 1, 3 and 4:", "ExampleText",
 CellID->3916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4"}], "}"}], "]"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{"s", ",", "t", ",", "u"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"s", ",", "t", ",", "u"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->19029]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["m"], "Input",
 CellLabel->"In[5]:=",
 CellID->25316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"s", ",", "x", ",", "t", ",", "u"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->3059]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13758],

Cell["All standard assignment operations work on parts:", "ExampleText",
 CellID->4583],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "+=", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1135],

Cell[BoxData[
 RowBox[{"b", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8357]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["m"], "Input",
 CellLabel->"In[3]:=",
 CellID->20070],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"b", "+", "x"}], ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->15271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22342],

Cell["Rearrange elements by reassigning parts:", "ExampleText",
 CellID->17780],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], "=", 
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30406],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "a"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28295]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["m"], "Input",
 CellLabel->"In[3]:=",
 CellID->17686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "a", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29500177],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " gives the parts in the corresponding ordinary array:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->147882474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
      RowBox[{"i", "-", "j"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38145154],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "6", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 6, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->310830910]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->549973647],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1uwjAQNklTVZT+QEGqVAZeoy/QTl07EyEkGKpWlIEtY0ZGRh6BkZGR
kZGRkZGR0T3bZ+ykTmtUHCGVSIl91hd/9t35cpeXsN9pv4X9bitsPPfCj063
9dl4eu/BkF8ghDThfrwn0KfQ43eTUmj1Z8Ce/ng8pvwiPjx8gJawvYM2wJbJ
NxwURZGGJ+SMd5fL5XQ63Y2y16i8oE+KxtEqf2E3SipG1LVc52KxSPOORiN9
NQ54t9vtYDBQvL4cFdRiHQflFXqO4xhIWNfb8Xrz+TxwxAfmAyMm+bh+1+u1
y30qz9F5lZe54gXlCtfP4GV61k8Dm9uDtoZyWeoH8QXjLK8p+f+ipD4vaTKq
PKB8YTWL2RtK1Mbu9RTKPWMF9xbkzpz/Xk+Mv3k+49AjSB3lotUsx3qu80cx
CwYYSfQIIuWy1SznNGlL8xclbXEz6vaAjFkxwz1z/ns9Me7HyHyCRYwrmowg
Urbz/GM91/ughsOhBUrVNjoKcrbNZiP1qVc6MoJUsRVWWa1Wk8mEdfVMEZJW
rEfMX5R0Lpp92rMy1NlsZsjIYem4muzM2D5+/MQPOk5UIHYV19/3rayoeD3Q
9eH1zCo8D7TJZ0aNqf15Tvi+aRB5RZnlklcxCF7d2/UoIr2/xlHiXwEpfAGq
jXzM\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{96, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->16598820]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->576873262],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->344726261]
}, Open  ]],

Cell["Rows or columns are represented as sparse vectors:", "ExampleText",
 CellID->304706573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->823857625],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->67015011]
}, Open  ]],

Cell["Values can also be set:", "ExampleText",
 CellID->16925559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}], "=", "1"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->480215609],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->281497479]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->38619827],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVztvwjAQdpKmqih90Yc68jf6B9qpnVkjVAmGqhVlYGNkZGTkJ2RkZGTM
mJGRkZHRvfMjdlxHuG2CkEqk5M7W5T777ny+e476nde3qN9tR82nXvTR6bY/
m4/vPZgKPEJIC96HewI8BY69LUqB6t8Qv8F0OqXsIQF8AhCtC3oNNAR6KsYX
TGg4HGryhBwxNk3T2WyWzeJvVD7Ak5p19ob9kM0WSJ3LdSZJYuJOJhN9NRXg
bjabwWCgcAM5y6H5OkrF5XYejUYAgqyf4fqLxSKsCA/cB07M4zH7rlarKvep
IkfHVVFWFS4Yl4d+AS7aWT8NqNsHeibGV9I+Qt6zankxxv9XStoTs0kosoue
ZU6ctNijoU7zfm9YpczoqB6xJvYW7hx593s9IG6LfMTADHJL8xml5qRlX8/1
7qXQg3pdIjOIPG2XTlqOad6XbjeKGScHrAPW37AwO+h1hV5nIG04adnXs/oT
qfF47CCl+hVdCuqw9Xot7WnLCpLy6m+5XMZxjKxe/UEhKnoM+y2xzePmmGPN
53NLZQ3LFSsornBttYMbJtgy1z24dUu/25/ykMLywY7l2BC7MB8sxbQJa6h9
+KVhfLOOwOLtT9lYSivHkneZefolvWNSvG8n3heXnkI1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{88, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->271772867]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8252],

Cell["The zeroth part of an expression is its head:", "ExampleText",
 CellID->23035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], "[", 
  RowBox[{"[", "0", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7285],

Cell[BoxData["Plus"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28428]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "[", 
  RowBox[{"[", "0", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16678],

Cell[BoxData["List"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25960]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101],

Cell["Reassign the head:", "ExampleText",
 CellID->20949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2364],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26385]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", 
   RowBox[{"[", "0", "]"}], "]"}], "=", "f"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27626],

Cell[BoxData["f"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17157]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[3]:=",
 CellID->2737],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->4841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18938],

Cell["\<\
Heads in the original expression are reused when \[OpenCurlyDoubleQuote]lists\
\[CloseCurlyDoubleQuote] of parts are extracted:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->11593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17096],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"b", ",", "c"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31033]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"h", "[", 
     RowBox[{"c", ",", "d"}], "]"}]}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4493],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"g", "[", "b", "]"}], ",", 
   RowBox[{"h", "[", "d", "]"}]}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29768]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29935],

Cell["Pick out the first solution from an equation:", "ExampleText",
 CellID->19109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"5", "x"}], "+", "1"}], "==", "0"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->30096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "-", 
        SqrtBox["21"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "+", 
        SqrtBox["21"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20381]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21561],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "5"}], "-", 
    SqrtBox["21"]}], ")"}]}]], "Output",
 ImageSize->{91, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5584],

Cell["Pick out all solutions for a univariate equation:", "ExampleText",
 CellID->25923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"5", "x"}], "+", "1"}], "==", "0"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->28499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "-", 
        SqrtBox["21"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "+", 
        SqrtBox["21"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16731]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "1", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "-", 
      SqrtBox["21"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      SqrtBox["21"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{202, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8606],

Cell["\<\
Go through the first 1000 primes, and count how many lie in each possible \
\[OpenCurlyDoubleQuote]mod 10 bin\[CloseCurlyDoubleQuote]:\
\>", "ExampleText",
 CellID->6850],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "10", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28287],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"m", "[", 
     RowBox[{"[", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"Prime", "[", "i", "]"}], ",", "10", ",", "1"}], "]"}], "]"}],
      "]"}], "++"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1000"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26040],

Cell[CellGroupData[{

Cell[BoxData["m"], "Input",
 CellLabel->"In[3]:=",
 CellID->22769],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "245", ",", "1", ",", "253", ",", "0", ",", "1", ",", "0", ",", "254", ",", 
   "0", ",", "246", ",", "0"}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->9223]
}, Open  ]],

Cell["Another way to get the same result:", "ExampleText",
 CellID->1588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Count", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"Prime", "[", "i", "]"}], ",", "10"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1000"}], "}"}]}], "]"}], ",", "j"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "0", ",", "9"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->12083],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "245", ",", "1", ",", "253", ",", "0", ",", "1", ",", "0", ",", 
   "254", ",", "0", ",", "246"}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->3400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11158],

Cell["Apply a permutation:", "ExampleText",
 CellID->15606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16938],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", "e", ",", "a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19463]
}, Open  ]],

Cell["Invert a permutation:", "ExampleText",
 CellID->130433625],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pinv", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", "5"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"pinv", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], 
    "]"}], "=", 
   RowBox[{"Range", "[", "5", "]"}]}], ";"}], "\n", "pinv"}], "Input",
 CellLabel->"In[2]:=",
 CellID->362484033],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->562127600]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"d", ",", "e", ",", "a", ",", "b", ",", "c"}], "}"}], "[", 
  RowBox[{"[", "pinv", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->287779767],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->300323404]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20920],

Cell[TextData[{
 "Pick out parts cyclically by using ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " with offset 1:"
}], "ExampleText",
 CellID->18366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"Mod", "[", 
      RowBox[{"i", ",", "4", ",", "1"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "d", ",", "a", ",", "b", ",", "c", ",", "d", 
   ",", "a", ",", "b", ",", "c", ",", "d", ",", "a", ",", "b", ",", "c"}], 
  "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19685]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9023],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " picks out ranges of parts:"
}], "ExampleText",
 CellID->20229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ";;", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->754332122],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223361023]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"Range", "[", 
    RowBox[{"2", ",", "5"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19298],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29356]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5470],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23175]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " operates on the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of expressions, not their formatted forms:"
}], "ExampleText",
 CellID->9988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"x", "/", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7619],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Power", "[", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->2946]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "/", "y"}], ")"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32190],

Cell[BoxData[
 FractionBox["1", "y"]], "Output",
 ImageSize->{16, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2469],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 " does not return part specifications in a form that can immediately be used \
by ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
     "1"}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "7", "}"}], ",", 
   RowBox[{"{", "8", "}"}]}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26197]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
      "1"}], "}"}], "[", 
    RowBox[{"[", "##", "]"}], "]"}], "&"}], "@@@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1654]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Extract",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extract"]], "InlineFormula"],
 " extracts parts specified in the way returned by ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}], ",", 
     RowBox[{"{", "8", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5794]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23791],

Cell["\<\
Successive part extraction is not always equivalent to direct part \
extraction:\
\>", "ExampleText",
 CellID->13341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "]"}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24837],

Cell[BoxData[
 RowBox[{
  RowBox[{"Part", "::", "\<\"partw\"\>"}], ":", 
  " ", "\<\"Part \\!\\({2, 3}\\) of \\!\\({\\(\\({a, b, c}\\)\\), \\(\\({g, \
h, i}\\)\\)}\\) does not exist. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/partw\\\", ButtonNote -> \
\\\"Part::partw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->101216921],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], 
  "\[LeftDoubleBracket]", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3"}], "}"}], "\[RightDoubleBracket]"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122270887]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12675],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "i"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->319203845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17438],

Cell["Only parts that already exist can be reassigned:", "ExampleText",
 CellID->9958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548318674]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", 
   RowBox[{"[", "5", "]"}], "]"}], "=", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15013],

Cell[BoxData[
 RowBox[{
  RowBox[{"Set", "::", "\<\"partw\"\>"}], ":", 
  " ", "\<\"Part \\!\\(5\\) of \\!\\({a, b, c, d}\\) does not exist. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/partw\\\", \
ButtonNote -> \\\"Set::partw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->201513904],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->457285366]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29235],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["First",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/First"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Head",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Head"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Last",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Last"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Extract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extract"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6890]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23425],

Cell[TextData[ButtonBox["Manipulating Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingElementsOfLists"]], "Tutorials",
 CellID->19312],

Cell[TextData[ButtonBox["Picking Out Pieces of Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"]], "Tutorials",
 CellID->734],

Cell[TextData[ButtonBox["Getting Pieces of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GettingPiecesOfLists"]], "Tutorials",
 CellID->452],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartsOfExpressions"]], "Tutorials",
 CellID->5169],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsByTheirIndices"]], "Tutorials",\

 CellID->29562],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->149530873],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->472777720],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->486355395],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->283490868],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->350686078],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->611272032],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->79737873]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Part ([[\[Ellipsis]]]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 16.9135252}", "context" -> "System`", 
    "keywords" -> {
     "columns", "elements", "expressions", "lists", "matrices", 
      "multiple parts", "parts", "rows", "selector", "sequence of elements", 
      "l-values", "destructive operations", "part assignment", 
      "subexpression", "setting parts of expressions", "indexing", 
      "array indexing", "expression indexing", "tree indexing"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "expr[[i]] or Part[expr, i] gives the i\\[Null]^th part of expr. \
expr[[-i]] counts from the end. expr[[i, j, ...]] or Part[expr, i, j, ...] is \
equivalent to expr[[i]][[j]] .... expr[[{i_1, i_2, ...}]] gives a list of the \
parts i_1, i_2, ... of expr. expr[[m ;; n]] gives parts m through n. expr[[m \
;; n ;; s]] gives parts m through n in steps of s.", 
    "synonyms" -> {"[[", "]]"}, "title" -> "Part", "type" -> "Symbol", "uri" -> 
    "ref/Part"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17328, 574, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->117694169]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 76107, 3035}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4108, 84, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4731, 111, 111, 4, 70, "ObjectName",
 CellID->21665],
Cell[4845, 117, 4119, 143, 70, "Usage",
 CellID->26152]
}, Open  ]],
Cell[CellGroupData[{
Cell[9001, 265, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9479, 282, 435, 15, 70, "Notes",
 CellID->32000],
Cell[9917, 299, 72, 1, 70, "Notes",
 CellID->97389508],
Cell[9992, 302, 197, 4, 70, "Notes",
 CellID->420921086],
Cell[10192, 308, 2433, 74, 70, "2ColumnTableMod",
 CellID->133829891],
Cell[12628, 384, 745, 28, 70, "Notes",
 CellID->3617],
Cell[13376, 414, 463, 16, 70, "Notes",
 CellID->29173],
Cell[13842, 432, 373, 15, 70, "Notes",
 CellID->30786],
Cell[14218, 449, 603, 23, 70, "Notes",
 CellID->31597],
Cell[14824, 474, 551, 20, 70, "Notes",
 CellID->26224],
Cell[15378, 496, 633, 24, 70, "Notes",
 CellID->17728],
Cell[16014, 522, 587, 18, 70, "Notes",
 CellID->26260],
Cell[16604, 542, 687, 27, 70, "Notes",
 CellID->12158]
}, Closed]],
Cell[CellGroupData[{
Cell[17328, 574, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->117694169],
Cell[CellGroupData[{
Cell[17713, 588, 148, 5, 70, "ExampleSection",
 CellID->21889114],
Cell[17864, 595, 64, 1, 70, "ExampleText",
 CellID->7545],
Cell[CellGroupData[{
Cell[17953, 600, 206, 7, 28, "Input",
 CellID->14767],
Cell[18162, 609, 154, 5, 36, "Output",
 CellID->21754]
}, Open  ]],
Cell[18331, 617, 125, 3, 70, "ExampleDelimiter",
 CellID->566507207],
Cell[18459, 622, 72, 1, 70, "ExampleText",
 CellID->249909138],
Cell[CellGroupData[{
Cell[18556, 627, 235, 8, 70, "Input",
 CellID->291778766],
Cell[18794, 637, 213, 7, 36, "Output",
 CellID->315627229]
}, Open  ]],
Cell[19022, 647, 121, 3, 70, "ExampleDelimiter",
 CellID->30787],
Cell[19146, 652, 66, 1, 70, "ExampleText",
 CellID->8217],
Cell[CellGroupData[{
Cell[19237, 657, 380, 13, 70, "Input",
 CellID->24565],
Cell[19620, 672, 154, 5, 36, "Output",
 CellID->29942]
}, Open  ]],
Cell[19789, 680, 120, 3, 70, "ExampleDelimiter",
 CellID->2088],
Cell[19912, 685, 66, 1, 70, "ExampleText",
 CellID->10273],
Cell[CellGroupData[{
Cell[20003, 690, 355, 12, 70, "Input",
 CellID->2815],
Cell[20361, 704, 209, 7, 36, "Output",
 CellID->27579]
}, Open  ]],
Cell[20585, 714, 121, 3, 70, "ExampleDelimiter",
 CellID->30837],
Cell[20709, 719, 68, 1, 70, "ExampleText",
 CellID->9388],
Cell[CellGroupData[{
Cell[20802, 724, 382, 13, 70, "Input",
 CellID->19269],
Cell[21187, 739, 213, 7, 36, "Output",
 CellID->126591617]
}, Open  ]],
Cell[21415, 749, 121, 3, 70, "ExampleDelimiter",
 CellID->13830],
Cell[21539, 754, 75, 1, 70, "ExampleText",
 CellID->10809],
Cell[CellGroupData[{
Cell[21639, 759, 224, 8, 70, "Input",
 CellID->4640],
Cell[21866, 769, 153, 5, 36, "Output",
 CellID->7321]
}, Open  ]],
Cell[22034, 777, 121, 3, 70, "ExampleDelimiter",
 CellID->18319],
Cell[22158, 782, 55, 1, 70, "ExampleText",
 CellID->29881],
Cell[CellGroupData[{
Cell[22238, 787, 337, 11, 70, "Input",
 CellID->31626],
Cell[22578, 800, 243, 8, 36, "Output",
 CellID->13020]
}, Open  ]],
Cell[22836, 811, 120, 3, 70, "ExampleDelimiter",
 CellID->1411],
Cell[22959, 816, 103, 2, 70, "ExampleText",
 CellID->20454],
Cell[CellGroupData[{
Cell[23087, 822, 237, 9, 70, "Input",
 CellID->25893],
Cell[23327, 833, 298, 11, 36, "Output",
 CellID->21984]
}, Open  ]],
Cell[CellGroupData[{
Cell[23662, 849, 164, 6, 70, "Input",
 CellID->2357],
Cell[23829, 857, 154, 5, 36, "Output",
 CellID->22999]
}, Open  ]],
Cell[CellGroupData[{
Cell[24020, 867, 66, 2, 70, "Input",
 CellID->30336],
Cell[24089, 871, 298, 11, 36, "Output",
 CellID->18829]
}, Open  ]],
Cell[24402, 885, 125, 3, 70, "ExampleDelimiter",
 CellID->622748114],
Cell[24530, 890, 71, 1, 70, "ExampleText",
 CellID->86684127],
Cell[CellGroupData[{
Cell[24626, 895, 183, 6, 70, "Input",
 CellID->704179957],
Cell[24812, 903, 247, 8, 36, "Output",
 CellID->311039832]
}, Open  ]],
Cell[CellGroupData[{
Cell[25096, 916, 170, 6, 70, "Input",
 CellID->685356397],
Cell[25269, 924, 157, 5, 36, "Output",
 CellID->10599737]
}, Open  ]],
Cell[CellGroupData[{
Cell[25463, 934, 69, 2, 70, "Input",
 CellID->20673363],
Cell[25535, 938, 247, 8, 36, "Output",
 CellID->788890635]
}, Open  ]],
Cell[25797, 949, 120, 3, 70, "ExampleDelimiter",
 CellID->5950],
Cell[25920, 954, 217, 7, 70, "ExampleText",
 CellID->21457],
Cell[CellGroupData[{
Cell[26162, 965, 304, 11, 70, "Input",
 CellID->32405],
Cell[26469, 978, 154, 5, 36, "Output",
 CellID->10365]
}, Open  ]],
Cell[CellGroupData[{
Cell[26660, 988, 248, 9, 70, "Input",
 CellID->2334],
Cell[26911, 999, 200, 7, 36, "Output",
 CellID->30049]
}, Open  ]],
Cell[CellGroupData[{
Cell[27148, 1011, 239, 9, 70, "Input",
 CellID->19094],
Cell[27390, 1022, 154, 5, 36, "Output",
 CellID->28592]
}, Open  ]],
Cell[27559, 1030, 329, 12, 70, "ExampleText",
 CellID->31270],
Cell[CellGroupData[{
Cell[27913, 1046, 163, 6, 70, "Input",
 CellID->30119],
Cell[28079, 1054, 174, 6, 53, "Output",
 CellID->23017]
}, Open  ]],
Cell[CellGroupData[{
Cell[28290, 1065, 123, 4, 70, "Input",
 CellID->29313],
Cell[28416, 1071, 429, 16, 50, "Output",
 CellID->15253]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28894, 1093, 216, 7, 70, "ExampleSection",
 CellID->4977],
Cell[29113, 1102, 56, 1, 70, "ExampleText",
 CellID->21505],
Cell[CellGroupData[{
Cell[29194, 1107, 341, 12, 70, "Input",
 CellID->153],
Cell[29538, 1121, 154, 5, 36, "Output",
 CellID->24591]
}, Open  ]],
Cell[CellGroupData[{
Cell[29729, 1131, 308, 11, 70, "Input",
 CellID->6562],
Cell[30040, 1144, 153, 5, 36, "Output",
 CellID->3576]
}, Open  ]],
Cell[30208, 1152, 120, 3, 70, "ExampleDelimiter",
 CellID->4854],
Cell[30331, 1157, 62, 1, 70, "ExampleText",
 CellID->20072],
Cell[CellGroupData[{
Cell[30418, 1162, 405, 14, 70, "Input",
 CellID->11134],
Cell[30826, 1178, 318, 11, 36, "Output",
 CellID->23016]
}, Open  ]],
Cell[31159, 1192, 79, 1, 70, "ExampleText",
 CellID->25050],
Cell[CellGroupData[{
Cell[31263, 1197, 481, 17, 70, "Input",
 CellID->9193],
Cell[31747, 1216, 298, 11, 36, "Output",
 CellID->21945]
}, Open  ]],
Cell[32060, 1230, 125, 3, 70, "ExampleDelimiter",
 CellID->360390727],
Cell[32188, 1235, 74, 1, 70, "ExampleText",
 CellID->108303232],
Cell[CellGroupData[{
Cell[32287, 1240, 253, 9, 70, "Input",
 CellID->3865998],
Cell[32543, 1251, 223, 7, 36, "Output",
 CellID->125264684]
}, Open  ]],
Cell[32781, 1261, 60, 1, 70, "ExampleText",
 CellID->367327425],
Cell[CellGroupData[{
Cell[32866, 1266, 250, 9, 70, "Input",
 CellID->952717068],
Cell[33119, 1277, 223, 7, 36, "Output",
 CellID->121742403]
}, Open  ]],
Cell[33357, 1287, 125, 3, 70, "ExampleDelimiter",
 CellID->392542588],
Cell[33485, 1292, 73, 1, 70, "ExampleText",
 CellID->120365238],
Cell[CellGroupData[{
Cell[33583, 1297, 322, 10, 70, "Input",
 CellID->105967024],
Cell[33908, 1309, 222, 7, 36, "Output",
 CellID->15136925]
}, Open  ]],
Cell[CellGroupData[{
Cell[34167, 1321, 292, 9, 70, "Input",
 CellID->250226481],
Cell[34462, 1332, 247, 8, 36, "Output",
 CellID->493738643]
}, Open  ]],
Cell[34724, 1343, 120, 3, 70, "ExampleDelimiter",
 CellID->1852],
Cell[34847, 1348, 188, 8, 70, "ExampleText",
 CellID->20747],
Cell[CellGroupData[{
Cell[35060, 1360, 201, 7, 70, "Input",
 CellID->32521],
Cell[35264, 1369, 153, 5, 36, "Output",
 CellID->8061]
}, Open  ]],
Cell[35432, 1377, 120, 3, 70, "ExampleDelimiter",
 CellID->6344],
Cell[35555, 1382, 312, 11, 70, "ExampleText",
 CellID->20259],
Cell[CellGroupData[{
Cell[35892, 1397, 212, 6, 70, "Input",
 CellID->28366],
Cell[36107, 1405, 153, 5, 36, "Output",
 CellID->2885]
}, Open  ]],
Cell[36275, 1413, 60, 1, 70, "ExampleText",
 CellID->14439],
Cell[CellGroupData[{
Cell[36360, 1418, 225, 6, 70, "Input",
 CellID->2718],
Cell[36588, 1426, 153, 5, 36, "Output",
 CellID->9107]
}, Open  ]],
Cell[36756, 1434, 120, 3, 70, "ExampleDelimiter",
 CellID->5268],
Cell[36879, 1439, 67, 1, 70, "ExampleText",
 CellID->3554],
Cell[CellGroupData[{
Cell[36971, 1444, 155, 5, 70, "Input",
 CellID->32050],
Cell[37129, 1451, 218, 7, 36, "Output",
 CellID->7432]
}, Open  ]],
Cell[37362, 1461, 125, 5, 70, "ExampleText",
 CellID->13799],
Cell[CellGroupData[{
Cell[37512, 1470, 191, 7, 70, "Input",
 CellID->32020],
Cell[37706, 1479, 154, 5, 36, "Output",
 CellID->16735]
}, Open  ]],
Cell[CellGroupData[{
Cell[37897, 1489, 66, 2, 70, "Input",
 CellID->31098],
Cell[37966, 1493, 218, 7, 36, "Output",
 CellID->2792]
}, Open  ]],
Cell[38199, 1503, 82, 1, 70, "ExampleText",
 CellID->3916],
Cell[CellGroupData[{
Cell[38306, 1508, 258, 9, 70, "Input",
 CellID->26182],
Cell[38567, 1519, 209, 7, 36, "Output",
 CellID->19029]
}, Open  ]],
Cell[CellGroupData[{
Cell[38813, 1531, 66, 2, 70, "Input",
 CellID->25316],
Cell[38882, 1535, 218, 7, 36, "Output",
 CellID->3059]
}, Open  ]],
Cell[39115, 1545, 121, 3, 70, "ExampleDelimiter",
 CellID->13758],
Cell[39239, 1550, 87, 1, 70, "ExampleText",
 CellID->4583],
Cell[39329, 1553, 175, 6, 70, "Input",
 CellID->22399],
Cell[CellGroupData[{
Cell[39529, 1563, 140, 5, 70, "Input",
 CellID->1135],
Cell[39672, 1570, 175, 6, 36, "Output",
 CellID->8357]
}, Open  ]],
Cell[CellGroupData[{
Cell[39884, 1581, 66, 2, 70, "Input",
 CellID->20070],
Cell[39953, 1585, 244, 8, 36, "Output",
 CellID->15271]
}, Open  ]],
Cell[40212, 1596, 121, 3, 70, "ExampleDelimiter",
 CellID->22342],
Cell[40336, 1601, 79, 1, 70, "ExampleText",
 CellID->17780],
Cell[40418, 1604, 175, 6, 70, "Input",
 CellID->13877],
Cell[CellGroupData[{
Cell[40618, 1614, 294, 11, 70, "Input",
 CellID->30406],
Cell[40915, 1627, 199, 7, 36, "Output",
 CellID->28295]
}, Open  ]],
Cell[CellGroupData[{
Cell[41151, 1639, 66, 2, 70, "Input",
 CellID->17686],
Cell[41220, 1643, 218, 7, 36, "Output",
 CellID->2403]
}, Open  ]],
Cell[41453, 1653, 124, 3, 70, "ExampleDelimiter",
 CellID->29500177],
Cell[41580, 1658, 419, 14, 70, "ExampleText",
 CellID->147882474],
Cell[CellGroupData[{
Cell[42024, 1676, 481, 16, 70, "Input",
 CellID->38145154],
Cell[42508, 1694, 479, 17, 36, "Output",
 CellID->310830910]
}, Open  ]],
Cell[CellGroupData[{
Cell[43024, 1716, 106, 3, 70, "Input",
 CellID->549973647],
Cell[43133, 1721, 897, 19, 70, "Output",
 Evaluatable->False,
 CellID->16598820]
}, Open  ]],
Cell[CellGroupData[{
Cell[44067, 1745, 144, 5, 70, "Input",
 CellID->576873262],
Cell[44214, 1752, 175, 6, 36, "Output",
 CellID->344726261]
}, Open  ]],
Cell[44404, 1761, 93, 1, 70, "ExampleText",
 CellID->304706573],
Cell[CellGroupData[{
Cell[44522, 1766, 146, 5, 70, "Input",
 CellID->823857625],
Cell[44671, 1773, 452, 16, 36, "Output",
 CellID->67015011]
}, Open  ]],
Cell[45138, 1792, 65, 1, 70, "ExampleText",
 CellID->16925559],
Cell[CellGroupData[{
Cell[45228, 1797, 275, 10, 70, "Input",
 CellID->480215609],
Cell[45506, 1809, 158, 5, 36, "Output",
 CellID->281497479]
}, Open  ]],
Cell[CellGroupData[{
Cell[45701, 1819, 105, 3, 70, "Input",
 CellID->38619827],
Cell[45809, 1824, 877, 18, 70, "Output",
 Evaluatable->False,
 CellID->271772867]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46735, 1848, 238, 7, 70, "ExampleSection",
 CellID->8252],
Cell[46976, 1857, 84, 1, 70, "ExampleText",
 CellID->23035],
Cell[CellGroupData[{
Cell[47085, 1862, 172, 6, 70, "Input",
 CellID->7285],
Cell[47260, 1870, 157, 5, 36, "Output",
 CellID->28428]
}, Open  ]],
Cell[CellGroupData[{
Cell[47454, 1880, 173, 6, 70, "Input",
 CellID->16678],
Cell[47630, 1888, 157, 5, 36, "Output",
 CellID->25960]
}, Open  ]],
Cell[47802, 1896, 119, 3, 70, "ExampleDelimiter",
 CellID->101],
Cell[47924, 1901, 57, 1, 70, "ExampleText",
 CellID->20949],
Cell[CellGroupData[{
Cell[48006, 1906, 144, 5, 70, "Input",
 CellID->2364],
Cell[48153, 1913, 209, 7, 36, "Output",
 CellID->26385]
}, Open  ]],
Cell[CellGroupData[{
Cell[48399, 1925, 140, 5, 70, "Input",
 CellID->27626],
Cell[48542, 1932, 154, 5, 36, "Output",
 CellID->17157]
}, Open  ]],
Cell[CellGroupData[{
Cell[48733, 1942, 65, 2, 70, "Input",
 CellID->2737],
Cell[48801, 1946, 213, 7, 36, "Output",
 CellID->4841]
}, Open  ]],
Cell[49029, 1956, 121, 3, 70, "ExampleDelimiter",
 CellID->18938],
Cell[49153, 1961, 222, 5, 70, "ExampleText",
 CellID->11593],
Cell[CellGroupData[{
Cell[49400, 1970, 227, 8, 70, "Input",
 CellID->17096],
Cell[49630, 1980, 204, 7, 36, "Output",
 CellID->31033]
}, Open  ]],
Cell[CellGroupData[{
Cell[49871, 1992, 379, 14, 70, "Input",
 CellID->4493],
Cell[50253, 2008, 262, 9, 36, "Output",
 CellID->29768]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50564, 2023, 223, 7, 70, "ExampleSection",
 CellID->29935],
Cell[50790, 2032, 84, 1, 70, "ExampleText",
 CellID->19109],
Cell[CellGroupData[{
Cell[50899, 2037, 229, 9, 70, "Input",
 CellID->30096],
Cell[51131, 2048, 608, 23, 51, "Output",
 CellID->20381]
}, Open  ]],
Cell[CellGroupData[{
Cell[51776, 2076, 150, 5, 70, "Input",
 CellID->21561],
Cell[51929, 2083, 279, 11, 51, "Output",
 CellID->25739]
}, Open  ]],
Cell[52223, 2097, 120, 3, 70, "ExampleDelimiter",
 CellID->5584],
Cell[52346, 2102, 88, 1, 70, "ExampleText",
 CellID->25923],
Cell[CellGroupData[{
Cell[52459, 2107, 229, 9, 70, "Input",
 CellID->28499],
Cell[52691, 2118, 608, 23, 51, "Output",
 CellID->16731]
}, Open  ]],
Cell[CellGroupData[{
Cell[53336, 2146, 152, 5, 70, "Input",
 CellID->11849],
Cell[53491, 2153, 474, 19, 51, "Output",
 CellID->25442]
}, Open  ]],
Cell[53980, 2175, 120, 3, 70, "ExampleDelimiter",
 CellID->8606],
Cell[54103, 2180, 180, 4, 70, "ExampleText",
 CellID->6850],
Cell[54286, 2186, 191, 7, 70, "Input",
 CellID->28287],
Cell[54480, 2195, 362, 13, 70, "Input",
 CellID->26040],
Cell[CellGroupData[{
Cell[54867, 2212, 66, 2, 70, "Input",
 CellID->22769],
Cell[54936, 2216, 294, 9, 36, "Output",
 CellID->9223]
}, Open  ]],
Cell[55245, 2228, 73, 1, 70, "ExampleText",
 CellID->1588],
Cell[CellGroupData[{
Cell[55343, 2233, 463, 15, 70, "Input",
 CellID->12083],
Cell[55809, 2250, 294, 9, 36, "Output",
 CellID->3400]
}, Open  ]],
Cell[56118, 2262, 121, 3, 70, "ExampleDelimiter",
 CellID->11158],
Cell[56242, 2267, 59, 1, 70, "ExampleText",
 CellID->15606],
Cell[CellGroupData[{
Cell[56326, 2272, 275, 9, 70, "Input",
 CellID->16938],
Cell[56604, 2283, 229, 7, 36, "Output",
 CellID->19463]
}, Open  ]],
Cell[56848, 2293, 64, 1, 70, "ExampleText",
 CellID->130433625],
Cell[CellGroupData[{
Cell[56937, 2298, 424, 14, 70, "Input",
 CellID->362484033],
Cell[57364, 2314, 233, 7, 36, "Output",
 CellID->562127600]
}, Open  ]],
Cell[CellGroupData[{
Cell[57634, 2326, 200, 6, 70, "Input",
 CellID->287779767],
Cell[57837, 2334, 233, 7, 36, "Output",
 CellID->300323404]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58119, 2347, 233, 7, 70, "ExampleSection",
 CellID->20920],
Cell[58355, 2356, 218, 8, 70, "ExampleText",
 CellID->18366],
Cell[CellGroupData[{
Cell[58598, 2368, 365, 12, 70, "Input",
 CellID->15758],
Cell[58966, 2382, 340, 10, 36, "Output",
 CellID->19685]
}, Open  ]],
Cell[59321, 2395, 120, 3, 70, "ExampleDelimiter",
 CellID->9023],
Cell[59444, 2400, 192, 7, 70, "ExampleText",
 CellID->20229],
Cell[CellGroupData[{
Cell[59661, 2411, 246, 8, 70, "Input",
 CellID->754332122],
Cell[59910, 2421, 223, 7, 36, "Output",
 CellID->223361023]
}, Open  ]],
Cell[CellGroupData[{
Cell[60170, 2433, 275, 9, 70, "Input",
 CellID->19298],
Cell[60448, 2444, 219, 7, 36, "Output",
 CellID->29356]
}, Open  ]],
Cell[CellGroupData[{
Cell[60704, 2456, 271, 9, 70, "Input",
 CellID->5470],
Cell[60978, 2467, 219, 7, 36, "Output",
 CellID->23175]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[61246, 2480, 226, 7, 70, "ExampleSection",
 CellID->24196],
Cell[61475, 2489, 348, 12, 70, "ExampleText",
 CellID->9988],
Cell[CellGroupData[{
Cell[61848, 2505, 122, 4, 70, "Input",
 CellID->7619],
Cell[61973, 2511, 428, 16, 50, "Output",
 CellID->2946]
}, Open  ]],
Cell[CellGroupData[{
Cell[62438, 2532, 163, 6, 70, "Input",
 CellID->32190],
Cell[62604, 2540, 173, 6, 53, "Output",
 CellID->8275]
}, Open  ]],
Cell[62792, 2549, 120, 3, 70, "ExampleDelimiter",
 CellID->2469],
Cell[62915, 2554, 371, 13, 70, "ExampleText",
 CellID->25519],
Cell[CellGroupData[{
Cell[63311, 2571, 243, 8, 70, "Input",
 CellID->14341],
Cell[63557, 2581, 316, 11, 36, "Output",
 CellID->26197]
}, Open  ]],
Cell[CellGroupData[{
Cell[63910, 2597, 286, 10, 70, "Input",
 CellID->8545],
Cell[64199, 2609, 218, 7, 36, "Output",
 CellID->1654]
}, Open  ]],
Cell[64432, 2619, 344, 12, 70, "ExampleText",
 CellID->7158],
Cell[CellGroupData[{
Cell[64801, 2635, 415, 14, 70, "Input",
 CellID->14058],
Cell[65219, 2651, 218, 7, 36, "Output",
 CellID->5794]
}, Open  ]],
Cell[65452, 2661, 121, 3, 70, "ExampleDelimiter",
 CellID->23791],
Cell[65576, 2666, 127, 4, 70, "ExampleText",
 CellID->13341],
Cell[CellGroupData[{
Cell[65728, 2674, 516, 18, 70, "Input",
 CellID->24837],
Cell[66247, 2694, 418, 8, 70, "Message",
 CellID->101216921],
Cell[66668, 2704, 444, 15, 36, "Output",
 CellID->122270887]
}, Open  ]],
Cell[CellGroupData[{
Cell[67149, 2724, 482, 17, 70, "Input",
 CellID->12675],
Cell[67634, 2743, 302, 11, 36, "Output",
 CellID->319203845]
}, Open  ]],
Cell[67951, 2757, 121, 3, 70, "ExampleDelimiter",
 CellID->17438],
Cell[68075, 2762, 86, 1, 70, "ExampleText",
 CellID->9958],
Cell[CellGroupData[{
Cell[68186, 2767, 155, 5, 70, "Input",
 CellID->30580],
Cell[68344, 2774, 223, 7, 36, "Output",
 CellID->548318674]
}, Open  ]],
Cell[CellGroupData[{
Cell[68604, 2786, 140, 5, 70, "Input",
 CellID->15013],
Cell[68747, 2793, 375, 7, 70, "Message",
 CellID->201513904],
Cell[69125, 2802, 158, 5, 36, "Output",
 CellID->457285366]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69344, 2814, 311, 9, 70, "SeeAlsoSection",
 CellID->29235],
Cell[69658, 2825, 2131, 80, 70, "SeeAlso",
 CellID->6890]
}, Open  ]],
Cell[CellGroupData[{
Cell[71826, 2910, 314, 9, 70, "TutorialsSection",
 CellID->23425],
Cell[72143, 2921, 168, 3, 70, "Tutorials",
 CellID->19312],
Cell[72314, 2926, 193, 4, 70, "Tutorials",
 CellID->734],
Cell[72510, 2932, 152, 3, 70, "Tutorials",
 CellID->452],
Cell[72665, 2937, 148, 3, 70, "Tutorials",
 CellID->5169],
Cell[72816, 2942, 179, 4, 70, "Tutorials",
 CellID->29562],
Cell[72998, 2948, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[CellGroupData[{
Cell[73168, 2956, 319, 9, 70, "MoreAboutSection",
 CellID->149530873],
Cell[73490, 2967, 145, 3, 70, "MoreAbout",
 CellID->472777720],
Cell[73638, 2972, 151, 3, 70, "MoreAbout",
 CellID->486355395],
Cell[73792, 2977, 145, 3, 70, "MoreAbout",
 CellID->283490868],
Cell[73940, 2982, 163, 3, 70, "MoreAbout",
 CellID->350686078],
Cell[74106, 2987, 152, 3, 70, "MoreAbout",
 CellID->611272032],
Cell[74261, 2992, 143, 3, 70, "MoreAbout",
 CellID->79737873]
}, Open  ]],
Cell[74419, 2998, 50, 0, 70, "History"],
Cell[74472, 3000, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

