(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    111143,       3904]
NotebookOptionsPosition[     94745,       3339]
NotebookOutlinePosition[     97260,       3393]
CellTagsIndexPosition[     97174,       3388]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grouping and Combining Elements of Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GroupingAndCombiningElementsOfLists"], 
          "Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/NestedLists"], 
          "Partitioning and Padding Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningAndPaddingLists"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Grouping and Combining Elements of Lists\"\>", 
       2->"\<\"Nested Lists\"\>", 
       3->"\<\"Partitioning and Padding Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flatten" :> Documentation`HelpLookup["paclet:ref/Flatten"], 
          "RotateLeft" :> Documentation`HelpLookup["paclet:ref/RotateLeft"], 
          "Split" :> Documentation`HelpLookup["paclet:ref/Split"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"], "ListConvolve" :> 
          Documentation`HelpLookup["paclet:ref/ListConvolve"], 
          "MovingAverage" :> 
          Documentation`HelpLookup["paclet:ref/MovingAverage"], 
          "CellularAutomaton" :> 
          Documentation`HelpLookup["paclet:ref/CellularAutomaton"], 
          "FindClusters" :> 
          Documentation`HelpLookup["paclet:ref/FindClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Flatten\"\>", 
       2->"\<\"RotateLeft\"\>", 3->"\<\"Split\"\>", 4->"\<\"Take\"\>", 
       5->"\<\"PadLeft\"\>", 6->"\<\"ListConvolve\"\>", 
       7->"\<\"MovingAverage\"\>", 8->"\<\"CellularAutomaton\"\>", 
       9->"\<\"FindClusters\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Matrices\"\>", 
       2->"\<\"Handling Arrays of Data\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Rearranging & Restructuring Lists\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Partition", "ObjectName",
 CellID->23656],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Partition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Partition"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]partitions ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " into non\[Hyphen]overlapping sublists of length ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Partition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Partition"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates sublists with offset ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Partition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Partition"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]partitions a nested list into blocks of size ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], " ", "\[Cross]", " ", 
        SubscriptBox["n", 
         RowBox[{"2", " "}]], "\[Cross]", " ", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Partition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Partition"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["d", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["d", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses offset ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at level ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Partition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Partition"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["d", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["L", "TI"]], ",", 
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["R", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that the first element of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " should appear at position ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L", "TI"]]], "InlineFormula"],
     " in the first sublist, and the last element of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " should appear at or after position ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R", "TI"]]], "InlineFormula"],
     " in the last sublist. If additional elements are needed, ",
     Cell[BoxData[
      ButtonBox["Partition",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
     " fills them in by treating ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " as cyclic. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Partition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Partition"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["d", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["L", "TI"]], ",", 
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["R", "TI"]]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]pads if necessary by repeating the element ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Partition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Partition"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["d", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["L", "TI"]], ",", 
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["R", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]pads if necessary by cyclically repeating the elements \
",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Partition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Partition"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["d", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["L", "TI"]], ",", 
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["R", "TI"]]}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses no padding, and so can yield sublists of different \
lengths. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Partition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Partition"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["nlist", "TI"], ",", 
        StyleBox["dlist", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["klist", "TI"], 
           StyleBox["L", "TI"]], ",", 
          SubscriptBox[
           StyleBox["klist", "TI"], 
           StyleBox["R", "TI"]]}], "}"}], ",", 
        StyleBox["padlist", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies alignments and padding in a nested list. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25713]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "All the sublists generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
 " are of length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". Some elements at the end of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " may therefore not appear in any sublist. "
}], "Notes",
 CellID->3332],

Cell[TextData[{
 "All elements of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " appear in the sublists generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23092],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is greater than ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
 ", then elements in the middle of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " are skipped. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->15733,
  ButtonNote->"15733"]
}], "Notes",
 CellID->17182],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L", "TI"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " effectively allows sublists that have overhangs that extend past the \
beginning or end of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26467],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      StyleBox["k", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11320],

Cell[TextData[{
 "Common settings for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["L", "TI"]], ",", 
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["R", "TI"]]}], "}"}]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->7358],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], Cell["allow no overhangs ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], Cell[
    "allow maximal overhang at the end ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}]}], "}"}], Cell[
    "allow maximal overhang at the beginning ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], Cell[
    "allow maximal overhangs at both beginning and end ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->21074],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L", "TI"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R", "TI"]]}], "}"}], ",", 
    StyleBox["padlist", "TI"]}], "]"}]], "InlineFormula"],
 " effectively lays down repeated copies of ",
 Cell[BoxData[
  StyleBox["padlist", "TI"]], "InlineFormula"],
 ", then superimposes one copy of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " on them, and partitions the result. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20333,
  ButtonNote->"20333"]
}], "Notes",
 CellID->3987],

Cell[TextData[{
 "Common settings for ",
 Cell[BoxData[
  StyleBox["padlist", "TI"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->9094],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["x", "TI"], Cell[
    "pad with repetitions of a single element ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "pad with cyclic repetitions of a sequence of elements ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["list", "TI"], Cell[TextData[{
     "pad by treating ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " as cyclic (default) "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", "}"}], Cell["\<\
do no padding, potentially leaving sublists of different lengths \
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->4983],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " has length ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
 " yields ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"], "[", 
   RowBox[{"0", ",", 
    RowBox[{
     ButtonBox["Floor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Floor"], "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        StyleBox["s", "TI"], "+", 
        StyleBox["d", "TI"], "-", 
        StyleBox["n", "TI"]}], ")"}], "/", 
      StyleBox["d", "TI"]}], "]"}]}], "]"}]], "InlineFormula"],
 " sublists. "
}], "Notes",
 CellID->21364],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["r", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " effectively replaces blocks of elements at level ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " by depth-",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " nested lists of neighboring elements. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->25656,
  ButtonNote->"25656"]
}], "Notes",
 CellID->27264],

Cell["\<\
If no offsets are specified, the neighborhoods are adjacent and \
non\[Hyphen]overlapping. \
\>", "Notes",
 CellID->19714],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
 " uses offset ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " at every level. "
}], "Notes",
 CellID->26746],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["nlist", "TI"], ",", 
    StyleBox["dlist", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["k", "TI"], 
         StyleBox["L1", "TI"]], ",", 
        SubscriptBox[
         StyleBox["k", "TI"], 
         StyleBox["L2", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["k", "TI"], 
         StyleBox["R1", "TI"]], ",", 
        SubscriptBox[
         StyleBox["k", "TI"], 
         StyleBox["R2", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " specifies that element ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " should appear at position ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["L1", "TI"]], ",", 
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["L2", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " in the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " block of the result, while element ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " should appear at or after position ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["R1", "TI"]], ",", 
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["R2", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " in the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " block of the result. "
}], "Notes",
 CellID->24390],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["L", "TI"]], ",", 
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["R", "TI"]]}], "}"}]], "InlineFormula"],
 " is taken to be equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L", "TI"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["L", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R", "TI"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["R", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10425],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["k", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["k", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]], "InlineFormula"],
 " is taken to be equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26255],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["r", "TI"]]}], "}"}], ",", 
    StyleBox["klist", "TI"], ",", 
    StyleBox["padlist", "TI"]}], "]"}]], "InlineFormula"],
 " effectively makes a depth-",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " array of copies of ",
 Cell[BoxData[
  StyleBox["padlist", "TI"]], "InlineFormula"],
 ", then superimposes ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " on them, and partitions the result. "
}], "Notes",
 CellID->13163],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " has dimensions ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["r", "TI"]]}], "}"}]], "InlineFormula"],
 " then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["r", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " will have dimensions ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["q", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["q", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["q", "TI"], 
     StyleBox["r", "TI"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["r", "TI"]]}], "}"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["q", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["i", "TI"]], "/", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["i", "TI"]]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31467],

Cell[TextData[{
 "The object ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " need not have head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->5985,
  ButtonNote->"5985"]
}], "Notes",
 CellID->5792],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->14231]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80297647],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->199160393],

Cell["Partition into sublists of length 2:", "ExampleText",
 CellID->12126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31159]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17518],

Cell["Partition into sublists of length 3 with offset 1:", "ExampleText",
 CellID->3220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "3", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31314]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25456],

Cell["\<\
Partition a two-dimensional array into 2\[Times]2 blocks with offset 1:\
\>", "ExampleText",
 CellID->24147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29156],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"11", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"21", ",", "22"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"12", ",", "13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"22", ",", "23"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"21", ",", "22"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"31", ",", "32"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"22", ",", "23"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "33"}], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{307, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30134]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->751],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Padding",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21380392],

Cell["Incomplete sublists at the end are by default dropped:", "ExampleText",
 CellID->16208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31478],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22294]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12589],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7976],

Cell["Treat the list as cyclic:", "ExampleText",
 CellID->9694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3", ",", "3", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4090],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "a", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20189]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29372],

Cell[TextData[{
 "Pad with ",
 Cell[BoxData["x"], "InlineFormula"],
 "\[CloseCurlyQuote]s:"
}], "ExampleText",
 CellID->7419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3", ",", "3", ",", "1", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30301],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "x", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24844],

Cell[TextData[{
 "Pad by repeating ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "InlineFormula"],
 " blocks:"
}], "ExampleText",
 CellID->20523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3", ",", "3", ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26539],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "y", ",", "z"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20609]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11827],

Cell["Use no padding, so later sublists can be shorter:", "ExampleText",
 CellID->6637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3", ",", "3", ",", "1", ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8186],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", "g", "}"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27416]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Padding Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1827],

Cell["Insert padding at the end:", "ExampleText",
 CellID->15169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3", ",", "1", ",", "1", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17623],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "x", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{487, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22514],

Cell["Insert padding at the beginning:", "ExampleText",
 CellID->10415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3", ",", "1", ",", 
   RowBox[{"-", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3644],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f", ",", "g"}], "}"}]}], "}"}]], "Output",
 ImageSize->{487, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23669],

Cell["Insert padding at both ends:", "ExampleText",
 CellID->10378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3", ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31676],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "x", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17858]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7952],

Cell["Insert no padding:", "ExampleText",
 CellID->9846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3", ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f", ",", "g"}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5915]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22988],

Cell["\<\
Make the input start at position 2 in the first sublist, and end at position \
1 in the last sublist: \
\>", "ExampleText",
 CellID->24616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3", ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "x", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28074],

Cell[TextData[{
 "Pad by laying down repeating copies of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->20333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "4", ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", ",", "x", ",", "y", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f", ",", "g", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "y", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "y", ",", "x", ",", "y"}], "}"}]}], "}"}]], "Output",
 ImageSize->{441, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11056]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Multidimensional Arrays",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25656],

Cell["Partition into 2\[Times]2 blocks:", "ExampleText",
 CellID->30062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "12", ",", "13", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22", ",", "23", ",", "24"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "32", ",", "33", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"41", ",", "42", ",", "43", ",", "44"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"11", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"21", ",", "22"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"13", ",", "14"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"23", ",", "24"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"31", ",", "32"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"41", ",", "42"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"33", ",", "34"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"43", ",", "44"}], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{307, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24524]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12129],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXL1y2kAQFsgyNjiepEvpOkUeI6nyBKkYT2bsIuOM44KOkpKSkkegpGQm
DY1nKClduqSkVO5OkiWWlXZP0g3CLDP8LLq93f3ubm/v90f/6e7X7/7T/W3/
5vtj/8/d/e3fm28Pj+ovv+V53rN6//zsqd+h+mXez2GovrOfgf70p9NpaF7e
uaF12oj+AuiPFZ9fGHo4HMa0b7Q4Mz/X6/V8Pse00M8DRbbj7y6gYfprJr+W
rpN1mPxJ+h4hv5OgulqtoJWTySQHa8zqLH0FaC3dC95oI4PGAj7HczmkLGg3
ju52ux0MBim6fvJvBPBemdqi66NS+bZC/g+W+lD5Q7priWLUEkejkYLsrWyM
1u3lcgmthTSFHnwO+WF62/yhNYFl/rbo4Xgod6Wc1i56poW/vr5iUmythFbB
/CgrIX8Pkd9W5EWJ0tF8sE7zUEv9fBa1tE+oiprrutGMuqeabdRtO0IR99W2
7bhK7+JGFoVu1BbSXrrFQlfTukUEYdoyEtpntLBzkP6qRn79fYlamdrDs/Ir
oYXtc9FCtBAtXGihaU3qdNol9gBN+dY8/rOQ74+y6a8I+eWsND3vnseHHr6L
pirX5+AS8byaJZfX79mWAOxX2oC+ztewwNpLlOsTSAUtouIwqCsrAjoMYhZa
UFZS+R8nijqXJL6B0vX/1GgZiyUxvl64G0dxRkp5cWB1FHCu8mVNzTnA/G1H
/XXnD+3D25YtikZqrb0IZz7SRS/iXi41q1SuBJJRS3ZeIRs9UHNvQYhHG3Xw
Y62eZyXkqnsuvcvS4t8JpGoG0nm1Oi8Gp1prHn/VWp0nX7yna7luvCcrCtjT
BcZxaN9sHYM3s8eXGLxYf4nBy6PQtLI+zrokMzl8uW5mcrIzdlgMXnbGrw5+
WcEQLUSL09JC+8miPV8cP1u054vyR0FYvOdL+r330+8VxUvYnpmiEQ21G4WK
r6g9PFT+kB/2m26iYNkfVgeKsC5Rewip+QRope3o2+wGZPhKTG/NB8c+1J5K
WQXh5C+rIIeWK6sgfCubMTff1JWL978KcmxnN8R7upbrzntWieM53rFKHE9F
AVRcTsXx9ayMSBy/S0sc7y6Ol5UUFyjKjBJfrqyklLeyGbPEooVocWpajMdj
Ky2OcyUlvZMga+VkMtlsNpiVcr4Rtxs/Pfry8jKbzd5yjdGdz+fxjQVV0YUR
ou0JY9vT84c5g7tYLJDz36qCxtjK6IqDovJnO3cQRFzpCVxqZHyap+hTf5+i
1latt+q9F67vpTj0vRdmd6BqnyZdXLb5dU3uZOGjmsXRz6AbXYaBoZvs0Mw7
Nc+Zkys6NV+FH2vRHWBPZCXMte55d5N/fF+T1/oPSqBvGw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{204, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->143058313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1984],

Cell[TextData[{
 "Partition into 2\[Times]2 blocks with offset 1, padding at the ends of rows \
and columns with ",
 Cell[BoxData["xx"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", "1", ",", "1", ",", "xx"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7049],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW8lu2zAQlbfsiZOiaNNDi1y7nPoR7akfYQQFkkPRIs33NZ/mioqVMM+U
H4czpGzDAWxpJHLmzaKxyIf8mN3f/Pw1u7+9nl19v5v9ubm9/nv17fddfWk0
qKrBv6qqvl5W9fm8Pms+7u+h/jyePp4du+9Re3dejYl8DvIbMv5IOZ/p0+JD
/9cNH4vfWyE+lEfui6JG+aL+GtbiZUCbu476usaH0ITmS+1jVkvb7/L/nTJb
w6RsOVROdMdJfcT7++Q+ygfNxSd54dtwcVyUVPPXXkMNk4Q5UagMojBeHCdE
3+FGR6HLSwtM+vrYyxAZm2epmTXxfas6sDiM+8HRMh2HIQTP0W2D8+JKm8X9
yLEsAiEccZHp9tUqPpjBrYtPAj5t3Rwk2pU/fyxqoS69pAV+aZfjiV3xtCNm
rf/nIKNVRBXSt4R6CdVrMmsE8lkfqFfcPyH2WJQvyHxpRQ2auEo7+h7IwYpa
cR/1TQNZXJUltM/0afEHn0NPxhVGafysynA8izdWGbOX573Br31EH0KFzz56
GdPNzyLGsC7Ostf6hfjPIOpoB6ts3fxpcafYTMnV1MC3PJVr3V/A0zl/0z+J
GMO80HYhNj/YRTfOy6MEDPJ8nhp42ufq7jQ4Km4uZugzQRRVd5FYNLixX5fE
/Z7o/kJsxdWKdCfczRpVz2u18/nLnZXQnqEvfyT6Y/qqb29K7L/KbB+zhPM/
KbP02CTc6YP6bMd6rDe+HeuRYn9bWI9W3zgpS64vTRa/JaF9/j1yH2XcO7Jm
U5i9VP9anFE8RoJ/40j9qf514TdjKAI+d/m04yOedQT3lYshiEGkede0jFSQ
mSiMo2i8LJkKof1cjMXw6WGXMhUoo/XQbj72HF/G3XQbJiS4tlV4iWszRMk4
DRumROsVopYyHTHMi4b5aLKYtActyZ10vDWTosWnxYurDuudUK1/iEfKlLDd
QKxSKXPSdExxlWKfxGcbs8J6QSiqGiZGmjUpI+HzV8zvFOZFi7/FZ8GM+Llw
xxwsSFoVZmE91qiXZOE7Muq39i+Z6RDYOE6wkaeay/Ma+S0mVVQPTEkpuznj
wRgYia4PBFe44kuzM9L5TN8qfO4oZW+k87X4GLuD46VZbjpaIzyoz7TroB3b
UxZfGbaHvcfHPDE79qc0+6PNWm42yFo/s5fqXyobZK0/1b+SbBCzWY4N0lZ/
jKzndDaPEYpfH+n921QWSBaj7ed/pLvVKKfsA2LX8WXGaWj5puBaXWCP7duy
fVaGl8WPMU9a/9jue8x/w6zCa8MR5f4F0XJG1uNzz5dyRtb6tf5pOSOmz4Yz
Kl21rHdJx0s5Km1WY3p9DKdkxVVZPIVWHFMXf5WPaypdvaxnrBv3FNNDND23
b+6J+bfZ3FPp6t4W/iluPZXmx6ZwTnEx6J9tsti98d+C/P+ZHgXi2Af75OOZ
zlfj64N98vGsF/tUDf4DJ9dUtQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{446, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->617489697]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18026],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXL1S20AQNpKFMH9DuhRJhjpFHiOp8gSpPExmoMgkQyjoKCkpXfIIlC6Z
SUPDDCUlJSUlpXI6nSz5Y6W9O51tbNYztrzS7e+d9j7dSvo+PDn8+Wt4cnQw
3P92PPxzeHTwd//r72O1K17r9Xq36vvjfU/9z9Q//b3NMrWt/yb5b3x5eZnp
T29d03nbgv4M9F7H4xuaPjs7M3Ssrejrv/f39+PxmLIibxUpMjJbw6Y/5b6B
RRuUu7tietKyN+/u7jC6o9GooY/18X5FG1VTe7Ys2qSM18uup6Cfn59PT0+r
6Mbl3iLAL7gS01fldgfoDcabefMX9Pn5uXIp/xtNvIxubm7Qu3VG+gDaby+Y
v7BfpRmVbKa902fI4+NjKRVjGGJEYazRm2XXU0S3yuP16FY5n8o/IbIhjk30
etn1TPJPMV1bRvcLY63r8aLPq9lkbYFWVPrECrFCrFgdK3I6NmkxMbNRneZy
cBN/32y5GXId2m9m7vnaz3M9NycT2qjpQ6tNslVE7uViRWukZS1UryMa8Ys/
IsYI6N1m+1p8HZBc76AV9nJiI7WFv0QZTWh4hhFqOc6NC1f5yxG1tCYVraOu
5ZFGL9IGvi2wnst0KbT3wf12EaHzo38/I43tUT62p3B7SPllZF1WcAZekdSa
g84Z3AoWrbH7nBFS74cgsc3PixIJlCsMdWTArUYl0H67I/9HL69wrIZe1920
suLfG2j1OiLdNIqb8DR33jXx+45iGzwtuXHGeh3Xv/3ibzXLv7APMRc59zrj
6a4zOiJDbG8XIcHTVNQFT3eNyKL7mcPTXeXb4GlZg5mdXkSe3Vb2mvC068oc
4mlX/k9BvHodq6ZihVghVrRbkWe8xOS4xGTTOm2TMSn+XK9N/kmgvVQWsjdS
WSD7A5BmG/6xmdlc8Bm1RuAin7o+nA3O74I6ubHiKp/rRU4+hdrDRw3HSgz0
DuM1d7XkurZe3vHIjWHKbqlKhJQvVYlMqhJSlViCSsLqVyXy0dOGxW3OuzYs
bnOnuCsWl9w4Y71zqUoganPF4jb5sQsW52Z5lM9h8TCVCsHiPlETLC4VDZpf
KhqZVDSkoiFWiBVixcSKi4sLJytWp6JRPYde93w0Gj09PVGeu+JFvxkFj9NS
5qnLp2ZRSH54eLi6uppINhEej8fmifGuEUZsa3O3jAs2njfiL/ivr6+J54XV
oDSxlOskil/lsalnyPE9BNw1LOcV8tvc4dXGT13z297xRfH5P0Fd5foqcpE6
Q7l+cR0H3CoDV8HEp55Cy/epVWgedV5q3aaPm8ecawT91sDweJcZJIwurEKk
EKe4Fr3ipQhU9NreLRETs13buyliE4Eu/Hg9l4L9hVcoJfRauJZv3q/TW/sP
B0FJJQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{204, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->172085682]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10202],

Cell[TextData[{
 "Partition into 2\[Times]2 blocks with offset 1, taking the array to be \
cyclic in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", "1", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5416],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW9ty0zAQdeKkCZe2KcNAees38BHwxEdkOsy0DwxM6feRTwuWE0M4XXu1
F0lxSWeaeBPt6qx2tZZ1oi/rx7uv39aP97frm88P6x9397c/bz59f2g+qidV
NflVVdXH66q53jZX7X/42zT/u8vd1avwWnffbqsZI69Afse0f2nU5+xZ8aH/
x4aPG7/3Qnwo1+GFRY3yVfMybcRrwlr4HO31tafQUPrS/jGqufvv8/+DMVpT
VbQCqiCG93nzjt8vmO9RXhKogt60R/+M+V7an9a/2f59zth7ofSvjrSv9a8P
v1f8+vAvjPHzyeJWa/5Hbm3QWMJMW5CtZTYwD2L8pPTie9WgoK339+k1Olz8
hhGMdYzSIoodW58ZKM3vBWUF7nJPfcJqcw4yVy0vQa5BPmP0sT/Sqyeo3zJa
iOKC8Qrb4zoOvcD2Kq8Eo4qxRPxc1BA/jgf2L71HojwJL+J5gijJDB74nhtF
rn9pe6m+1D+yLgxkqRQfh8fqnzSrrf1xWV1mZdTdNXBOXe4/52qLNYu5WqeZ
BRTuiwM/KX+5bMX2VDQpu1r8Hc6Vs11uFpfJQu/aY83K0rXHWluxP7wDl/bv
/6itcc8l52SrOF1rnuuenKKyNdIji/fcLKCtjGUM0iCQrsp0M0XKDAStuvr7
DLva/rtrhe2ptXbfXZPS5+wN4av3OTSE780Avk4/Fz5q9TA0fjWMX8zqg5N3
TEG43JivTqzTceM7sU6a/p8L69TZm6mi5M0G4f6hN5vF9af1L5YNwl1YbzZL
618ffq/49eFfGuOXc93f3ZtTsE15EcQgsqyPPUcKY1kCR9nx0iLSIFiqEcQg
3K0ENEzroRyzs4c17FDGvRUfpovcJTB4iU+LiJLjpHyYLqtXiPo1yBhLjoni
mC5cu3JMV9T9zJ2hTb3bKWW2rPiseDl+1Lq7bPWPqyDW8ZBmsTQebcUVZ7GU
1eZqCTXqFiZLGlXNbw9imScNg2XF3+HD2aAZp0OcV9s4vGmyLjWzVLq2pGaW
vO2n9k/a3zhqZ34mKX2PqkwqwCrl6jf/eEgRSHq8UPUYN3tKsEsSfc7eEL7w
rmGXJPqe+GLZpUP9FaPP4W2rZytszFfWjDyxS3nx5WGXuDVvzIw6sU252SZr
1FKzT6XPOqVmn0qfdUrNPpU562TN6hjZziGNj4GKf8ay+zdW1sk2Rr6ZV55p
sj77e59W4vaNrcwW+bQv6M96bkn6q14px2X1zxoP6Tks7hyVjo1KfX9Jfc4p
9bkoqb6UnfK2b/XPm53i7Hv/dn+3R5Q7q7naJ20vZcOsUdeeb0KcXqyYxyzt
9uq84xrs4h6cNd/KZC1XS46N7ZLWKusvBaT4jr0Wl2G7cmf1c2G84p6+dH6M
heXSjYFPxuRntqxWpOegSjBdknNQJZiuPnzHz3RVk99yjHqr\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{446, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498242302]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14552],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXL1y2kAQFsgyNjiepEvpOkUeI6nyBKkYT2bsIuOM44KOkpKSkkegpGQm
DY1nKClduqSkVO5OkiWWlXZP0g3CLDP8LLq93f3ubm/v90f/6e7X7/7T/W3/
5vtj/8/d/e3fm28Pj+ovv+V53rN6//zsqd+h+mXez2GovrOfgf70p9NpaF7e
uaF12oj+AuiPFZ9fGHo4HMa0b7Q4Mz/X6/V8Pse00M8DRbbj7y6gYfprJr+W
rpN1mPxJ+h4hv5OgulqtoJWTySQHa8zqLH0FaC3dC95oI4PGAj7HczmkLGg3
ju52ux0MBim6fvJvBPBemdqi66NS+bZC/g+W+lD5Q7priWLUEkejkYLsrWyM
1u3lcgmthTSFHnwO+WF62/yhNYFl/rbo4Xgod6Wc1i56poW/vr5iUmythFbB
/CgrIX8Pkd9W5EWJ0tF8sE7zUEv9fBa1tE+oiprrutGMuqeabdRtO0IR99W2
7bhK7+JGFoVu1BbSXrrFQlfTukUEYdoyEtpntLBzkP6qRn79fYlamdrDs/Ir
oYXtc9FCtBAtXGihaU3qdNol9gBN+dY8/rOQ74+y6a8I+eWsND3vnseHHr6L
pirX5+AS8byaJZfX79mWAOxX2oC+ztewwNpLlOsTSAUtouIwqCsrAjoMYhZa
UFZS+R8nijqXJL6B0vX/1GgZiyUxvl64G0dxRkp5cWB1FHCu8mVNzTnA/G1H
/XXnD+3D25YtikZqrb0IZz7SRS/iXi41q1SuBJJRS3ZeIRs9UHNvQYhHG3Xw
Y62eZyXkqnsuvcvS4t8JpGoG0nm1Oi8Gp1prHn/VWp0nX7yna7luvCcrCtjT
BcZxaN9sHYM3s8eXGLxYf4nBy6PQtLI+zrokMzl8uW5mcrIzdlgMXnbGrw5+
WcEQLUSL09JC+8miPV8cP1u054vyR0FYvOdL+r330+8VxUvYnpmiEQ21G4WK
r6g9PFT+kB/2m26iYNkfVgeKsC5Rewip+QRope3o2+wGZPhKTG/NB8c+1J5K
WQXh5C+rIIeWK6sgfCubMTff1JWL978KcmxnN8R7upbrzntWieM53rFKHE9F
AVRcTsXx9ayMSBy/S0sc7y6Ol5UUFyjKjBJfrqyklLeyGbPEooVocWpajMdj
Ky2OcyUlvZMga+VkMtlsNpiVcr4Rtxs/Pfry8jKbzd5yjdGdz+fxjQVV0YUR
ou0JY9vT84c5g7tYLJDz36qCxtjK6IqDovJnO3cQRFzpCVxqZHyap+hTf5+i
1latt+q9F67vpTj0vRdmd6BqnyZdXLb5dU3uZOGjmsXRz6AbXYaBoZvs0Mw7
Nc+Zkys6NV+FH2vRHWBPZCXMte55d5N/fF+T1/oPSqBvGw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{204, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->386646755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12755],

Cell["\<\
Insert padding at the beginnings of columns, and beginnings and ends of rows:\
\
\>", "ExampleText",
 CellID->11417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", "1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], ",", "xx"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22844],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXL1S20AQli3LBv8wSZdJSIY6k8ljJFWeIJWHyQwUmWQIBR0lJaVLHoHS
JSUlJSUlJSWlIukkS/44a/dOJ9kyywyWVto/7d7d3u7a+jE9Pfr1e3p6fDg9
+H4y/Xt0fPjv4Nufk+iS3/G8ztjzvJ/vvOg8jM6S//hvEv2rUzwL4k//6uoq
wQu9fgJndKH3GeA3Nd/fSeDz8/MU9hMte8np/f39fD7XaRljdSOwmx5TsuQv
uzaKjn56K4iOyGMP4ADwXdH30uOASZ/hDxnPiDoNMu/e3d2hNWez2QqfJ/d7
OZyKWroySlRcXElV6QEnykY9FpehFqurvWonUc9rrXIJ++PoUfDz8/PZ2Vm4
8LSfXVXOfkEVj7F43GRHnJ1dgKmn3CHo97TPu8vh+oLqrc7CJTClK+Lvgm0Q
X8EXFxeReRfPqlai29tbtHTf0NJIP9ZoR1q6Qf5ovcCQP2V9xFf6R+EgCgrL
1k9WtsfHx8zqL7QiZtakINnEYoMVdONQvzYjvIof4o3C8nFZplcWBykbIE/1
7Hn8LVo7j9W6OEJFrLaPU8R3zT/zXpkNV8YCta1jeutDoi6usjp9yp4nYHEx
iax2EqtHdJdyPwKtml/5DqwTcjy0H+Y7Qt2aiBr2AX8SLu8oqZWjD/jjivSf
tFbIn5dnha+EVNf3RUvRUrQULe32N3HECVI4YEaVIr4r+lg1zpodAD6n6oA6
2VmTszfnVR1kj2It1zAvsPM05sITndYG/tSOpAI8Ahg9zdnHmOQAuiqLCX+k
p3JhN16gMiVO/lslU3LNnxoVFH+kr8cLnFUPPeMbWg7HN9Lj/KOquBR/yjNZ
tZ6adzq9bSsYPO+gJTl9BaqC4aRmWmLdqnVOal5W5c+pYOjmmrm33scf0pOo
Re4+0Np5KK4x+V5ekcCxU9YD01UwTHtoWMEwpcc6Ds8K+JRN91SHLC3jD7z2
WjDb4SGb6IT5I2dNKMs/bemzfJKacb3QPP90Ez2k6x22rutt52nselP5J+eb
HmUwlX9yopDJDo7KlCj+VP6JqyXPC5J/mvGX/HOVJbY3/5QO+mZ00O28JR30
+uTqO+imHpIOenzaju6aaClaipbbraV00JvuoFN7bddZkN3OAO/ruTQpa33d
8abzYszOON8vLqPHEdeOvHjdXpDqxEKrDVvRqOqg6bdBdNVB7vf6dXSb1R2n
xjVVWzX97g2FT/FHeFgz/+a649jBrdsTdh0DvF8l8ruR5a7zXVZD19XksUeR
wTEap2dQxB9XpJfO93ZitsND0vmuMzJwOt+mPRqJHuGau9pUxuLaY1RXkOJv
mjdW3XlJV9uGv+SNtpZ7vXmjTdW37eOayhur8m+uq407f6kY82S561iXrY+6
cVyWN3I6zmV5oym9dKxFS9FStNxULS8vL4205Oxddhk4VIwROTw5yov5+wuL
XpzNZk9PTzovsn9rbrgf1u75RQ4pR3n14eHh+vo6Pi2+sWg+n6dvL+T8jtzV
XmkT6ZWVbm5uNO88iwZ6ajuxUrquL72XT2Ud+RuXtL/ZaPEM2jY5yot5HM69
2I1WA5t+ACe6UDVRkcOTk1QnovUomXXpXFs9974QWrq+PwB9/IKW6sWRm6Nl
ro/SEqma7tcl8hNAvT/a6/wHcfoz3g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{268, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->712705265]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19443],

Cell["\<\
Pad the beginnings and ends of columns, and the ends of rows:\
\>", "ExampleText",
 CellID->6824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", "1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "1"}], "}"}], ",", "xx"}],
    "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31999],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXD9P3DAUD8mF6/FPdOvQVsxV1Y/RTv0QJ1QJhqoVZaATIyPjjXwExhuR
urAgMTIyMjIypk7sXMKPl9iOfb4L95DuLk6e3z+/PP/iF/x9fHzw4+f4+HB/
vPftaPz74HD/z97XX0fiVLIWRdGN+Px9F4njTBwVn5ssE7/yeyf/TvKzxV/0
Cdq7jtcL/lFanL24uFBnU6BKxFcsmrH6LU5E8q88NzKgWaekvyI5w6J9enpa
kxNFg+Lw7u5uOp3mh9iruD6o2krUszObBjRDjdV9lyPbIkpvb2/Ru5PJRFGh
d1M1VuXvNrTfaKwJ3V9a+fT0dHJyUlmZlGeloS+sXNdIGQH91oL7SyvPzs6E
SflhPLMyvr6+xpFPDaLFJKLQ12hF3+VIv4k0I5LNc68Wd8jDw0M5Vni/+siG
OGpodd/lyHaVx+verXI+eveLRlvb67P8IKfrBWkhI6/KumsL1KKSx1qwFqyF
Dy3ydqLSYqpmo3pbl4Ob+g/Ur26GXAf6jcw+X3ezvJib01lbiRkA1QZJFZNn
db6iJdK8FirXEo108z8ixRjaO836tdg6Inu9BSocZXwOJrm29C9RRhMKnqOH
Wq7r4sKWfz+8NqxxRe2oZ3lsoxXDhn6boL0u0w2BvgvuN/MInR+7jzO2kR75
Iz2F233yLz1rs4Iz6uTJQrLXOUO3gkVLdJ8zfMp978W3+X1RIoFyZaGODHSr
USnQbzn2/9DJKoxV3+u4G0Za/FsBquXwdFMUN+Fp3X3X1L9rFJvgac6Nc5Zr
uf7dzf9Gs/wL/RBzkXOvNZ52ndERGSK9mYcYT1NeZzzt6pFFj7MOT7vyN8HT
vAYzP7mIPN1W9prwtO3KHOJp2/4fvVi1HKumrAVrwVq0a5FnvFTluFRl03rb
JGNS/XO5JvknBXquLGQrUlkgxwOQZhv+MZnZbPAZ+ZaLBX/q+XA+ON8Fdepi
xZa/bhR1/CnU7t9rGCsJtLc1VuuelmzX1ss3HnUxTOnNVQmf/LkqkXFVgqsS
PagkvP6qRB49bVjc5L5rw+Imb4rbYnHOjXOWG6QqgajNFoub5EcXLK6b5ZG/
Dov7qVQwFu/iNcbiXNGg+3NFI+OKBlc0WAvWgrXorMXqVjRs8WK3GQWv01xC
ygpXs7D1MGJbk7dlbLBxPxA/PyeF8BpaYfKGV1t/6pnf9I0vql+4moVt5U9H
j89Vukom/veTb/7haha2nuy2JobXXWYUP7L8VSWadmFIiNmvba+KRHnApT9X
JZabajk8zVWJVc9+4eoOth5GPKyLHeRvi6ddZ2quO5jwZzy9XHja1XO+40GH
p135h6s7rOoKjb/KQhueNqkMtOFp2/5cWWAtWIv+anF+fm6lRd93zAslR3q3
2r+27t3JZPL4+Eh5t++7PYaSI719f39/eXmZH9Z3HJxOp2o3Vpu5k8LYbXNf
iP7SyqurK2LvTBFAyvbXYaXIQ8/2XcU9dMm383ocwWHvlCqfV96NxV1C1dp8
ZEPdGkzf5RRPS+L+K6JUxWZzrH7WaGl7fQjykpoWckPdcFpU8qQW2Gs+u8Pf
yCFa+w8nkMcT\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{204, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->259073139]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->121],

Cell["Skip elements by using an offset larger than the block size:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->15733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}], ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "h"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19917]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15793],

Cell["Padding can be longer than the block size:", "ExampleText",
 CellID->21873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "3", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "5"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31175]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9074],

Cell[TextData[{
 "The head need not be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->5985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32501],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "d"}], "]"}]}], "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31622]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13208],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->27395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], "->", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11026],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWllOwzAQdZKWFlAX+OKzZ+AQ8MUhogqpBSFQ6f1LnLQIDeN4GS9xO0gt
HsezeObFtZ/8Uu83rx/1fruuV8+7+muzXX+vnj53TVdVCFG8CSEeH0TTPjSt
9iP/3ptP1+xat/K7Oj09iJFGvgbyQjP+hqivs0eND85/aPHp8re0jA/KlfzS
Ro1FVTbiHWJN9kN7qvFYNJi+rX9Y1dj+VfO/J1ardKqWjEqKY9A/UfRD/aln
ezr7vuOH70zs+GXVxo0I+0PkH/MTB2Wt1vhXbm10sUjkT5RPoU05GlbMl20T
XyHnBXOacl4qvZCVssWUGVJtZ1qhMc7QXviOzTzagnFB2z7jnieMG82hp0zD
/Y/t2g3lorXrZ+3D5wl14Q6QYktn22fcMPMx40YR6CnT1B11yF9TRhQjihHF
iGJEMaJyQJQtuyi1pLg4/ofPId+iG6/Tt/UP+ZsQ/stjNWzmvzzqUXe/HRso
m5Antm8xszzs+JhZdvF/Lszyyd7IqUq5M8pURtaUUb5S+KHGHyv/U8f8h9xf
ylF5M8oqvZBcsmtMMdlxuxpNnWuE+e5+rS6FSXZjZM04ZLjvSMl6m+V47pRj
dE29mDO021nU7PRs6zvked8sxziCbNeidvVhBPV6YQQxghhBjCBG0LARlCPz
28e89jG/JswrlXnuY35N5o/xTJ1AZ3pdzlz/EGPxJjDzGzZ/fpjfimiFmeAU
TDC1arHuug6VWU191zhPZpiKOkwOzT/mwKgO6b7xeTHFpYP2XznkndghMbAp
7x3nxRz7XgN9ngyHdJZNeQMrrzM4I4oRxYhiRDGiGFGXgygqglzv4MZigmPc
Qe6zl5aJFsUPkSqkUg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{362, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308761351]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31988],

Cell["Partition to lay out a list in 2D:", "ExampleText",
 CellID->10929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Prime", "[", "n", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "50"}], "}"}]}], "]"}], ",", "10"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9072],

Cell[BoxData[
 TagBox[GridBox[{
    {"2", "3", "5", "7", "11", "13", "17", "19", "23", "29"},
    {"31", "37", "41", "43", "47", "53", "59", "61", "67", "71"},
    {"73", "79", "83", "89", "97", "101", "103", "107", "109", "113"},
    {"127", "131", "137", "139", "149", "151", "157", "163", "167", "173"},
    {"179", "181", "191", "193", "197", "199", "211", "223", "227", "229"}
   }],
  "Grid"]], "Output",
 ImageSize->{286, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30977]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10193],

Cell["Find pairs of successive elements in a list:", "ExampleText",
 CellID->8],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0",
      ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", "2", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12254],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtOwzAMTVsKBcTGeOJx/Aw88RHVBGwSAzT2LfC5JW4ZQ6eOkna5dFUm
rbJT+8S1nSY9j+V2+bQut6tFOX/YlB/L1eJzfv++kUNZIkTyJYS4uxVSrqRU
/+n3Lf+N2EiXdM12dytxDvoU9BPQLwL7Dz3+64HnL6NLC4X0VKozxprGXdtj
VX3Fc+P5ebEaKVsNGs2litZn8kJqrkEtmCg5v1B42LMqvFNFHnTxqfJnG68Y
ST34LuSyRD1NqCL/G699+ZySNdY6VXoPC5tbk2psjMQ0Yl92xWDy6gq73c84
E66CKxabtcL9s+XlH2tihIWnAV1EeP9Q/8lR5xj7KqntdO9JHhutMLP8OvCP
hedXHkt3ynR9n++rY8lxv/039lXsq9hXsa9iX/nAin0Vqq+QC6JR+hagimQM
CnIs6a/d1JI9ckT/7SkuPDVy+Lv4u9jPAj0vzxiSiFxyd0k319DY3LGz0S91
VTKDWSI7vLdfGmXNF4sbiiXlmBwfrKsLltQkvufKpOohWNNQrKIpY2x7Xpe5
NH2m5s2Zaqxdco6uuT1kGG1zgzZzgfscorxWfdauzROx6y8B3U5/KL7NXOhi
XVexWrFa5hHGau29YrXGVy0T3qQvQ2KDweAYkj6MR9f4VfhvddZINOEkRPID
DNJqZA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{406, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81931570]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30876],

Cell["Find successive ratios in a list:", "ExampleText",
 CellID->15137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "2", 
   ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13803]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divide", "@@@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21090],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["a", "b"], ",", 
   FractionBox["b", "c"], ",", 
   FractionBox["c", "d"], ",", 
   FractionBox["d", "e"]}], "}"}]], "Output",
 ImageSize->{97, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12289],

Cell["Implement an elementary cellular automaton:", "ExampleText",
 CellID->17253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "3", ",", "1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29979],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f", ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7299]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"#", ",", "3", ",", "1", ",", "2"}], "]"}], "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "_", ",", "y_"}], "}"}], ":>", 
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"x", "+", "y"}], ",", "2"}], "]"}]}]}], ")"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
      "0", ",", "0"}], "}"}], ",", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12322],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "0", "0", "0", "1", "0", "0", "0", "0"},
    {"0", "0", "0", "1", "0", "1", "0", "0", "0"},
    {"0", "0", "1", "0", "0", "0", "1", "0", "0"},
    {"0", "1", "0", "1", "0", "1", "0", "1", "0"},
    {"1", "0", "0", "0", "0", "0", "0", "0", "1"}
   }],
  "Grid"]], "Output",
 ImageSize->{131, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22902]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7863195],

Cell["\<\
Partition a flat list of elements into a multidimensional array with \
specified dimensions:\
\>", "ExampleText",
 CellID->14950773],

Cell[BoxData[
 RowBox[{
  RowBox[{"unflatten", "[", 
   RowBox[{"e_", ",", 
    RowBox[{"{", 
     RowBox[{"d__", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"IntegerQ", "[", "#", "]"}], "&&", 
          RowBox[{"Positive", "[", "#", "]"}]}], ")"}], "&"}], ")"}]}], 
     "}"}]}], "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"Fold", "[", 
    RowBox[{"Partition", ",", "e", ",", 
     RowBox[{"Take", "[", 
      RowBox[{
       RowBox[{"{", "d", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "2", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "]"}], " ", "/;", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Length", "[", "e", "]"}], "===", 
     RowBox[{"Times", "[", "d", "]"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140729201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"unflatten", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99426464],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21013751]
}, Open  ]],

Cell["Create a multidimensional array of successive integers:", "ExampleText",
 CellID->13034821],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dims", "=", " ", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"unflatten", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"Times", "@@", "dims"}], "]"}], ",", "dims"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->233703703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "10", ",", "11", ",", "12"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"13", ",", "14", ",", "15", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"17", ",", "18", ",", "19", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22", ",", "23", ",", "24"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{366, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->345865351]
}, Open  ]],

Cell["Restructure a matrix:", "ExampleText",
 CellID->107763972],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"unflatten", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", "m", "]"}], ",", 
   RowBox[{"Reverse", "[", 
    RowBox[{"Dimensions", "[", "m", "]"}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->249091302],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->621880116]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12274],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " is essentially the inverse of ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->5226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16463],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28134]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24348]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31720646],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListCorrelate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListCorrelate"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " effectively combines ",
 Cell[BoxData[
  StyleBox["ker", "TI"]], "InlineFormula"],
 " with a partitioned ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->284045099],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ker", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"Range", "[", "10", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->471966646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{"ker", ",", "list"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150221561],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"6", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"7", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"7", " ", "x"}], "+", 
    RowBox[{"8", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"8", " ", "x"}], "+", 
    RowBox[{"9", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"9", " ", "x"}], "+", 
    RowBox[{"10", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{525, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->297439353]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " the list into segments the length of ",
 Cell[BoxData[
  StyleBox["ker", "TI"]], "InlineFormula"],
 " with offset 1:"
}], "ExampleText",
 CellID->521698515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pl", "=", 
  RowBox[{"Partition", "[", 
   RowBox[{"list", ",", 
    RowBox[{"Length", "[", "ker", "]"}], ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->210552214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}]}], "}"}]], "Output",
 ImageSize->{468, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->264602059]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " to combine the kernel with each segment:"
}], "ExampleText",
 CellID->469082901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ker", ".", "#"}], "&"}], ",", "pl"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->660433503],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"6", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"7", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"7", " ", "x"}], "+", 
    RowBox[{"8", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"8", " ", "x"}], "+", 
    RowBox[{"9", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"9", " ", "x"}], "+", 
    RowBox[{"10", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{525, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->143076866]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " is similar except the kernel is reversed:"
}], "ExampleText",
 CellID->5954264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListConvolve", "[", 
  RowBox[{"ker", ",", "list"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2437656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y"}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"7", " ", "x"}], "+", 
    RowBox[{"6", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"8", " ", "x"}], "+", 
    RowBox[{"7", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"9", " ", "x"}], "+", 
    RowBox[{"8", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"10", " ", "x"}], "+", 
    RowBox[{"9", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{525, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->15232153]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Reverse", "[", "ker", "]"}], ".", "#"}], "&"}], ",", "pl"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->10975788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "y"}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"2", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"4", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"7", " ", "x"}], "+", 
    RowBox[{"6", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"8", " ", "x"}], "+", 
    RowBox[{"7", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"9", " ", "x"}], "+", 
    RowBox[{"8", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"10", " ", "x"}], "+", 
    RowBox[{"9", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{525, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->329404301]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9079],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotateLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotateLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Split",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Split"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MovingAverage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellularAutomaton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellularAutomaton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindClusters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindClusters"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32091]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22619],

Cell[TextData[ButtonBox["Grouping and Combining Elements of Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GroupingAndCombiningElementsOfLists"]], "Tutorials",
 CellID->2880],

Cell[TextData[ButtonBox["Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NestedLists"]], "Tutorials",
 CellID->4718],

Cell[TextData[ButtonBox["Partitioning and Padding Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningAndPaddingLists"]], "Tutorials",
 CellID->16128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->327225102],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->67211413],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->80641386],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->27617197],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->430184552]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Partition",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Partition"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Partition"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Partition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 13.6165658}", "context" -> "System`", 
    "keywords" -> {
     "Beck parameters", "blocking lists", "blocks", "circular partitioning", 
      "cyclic partitioning", "gathering elements in lists", "handles", 
      "hot spots", "knobs", "partitioning lists", "splitting lists", 
      "neighborhoods", "overhangs", "reshape in APL", "sublists", "unflatten",
       "wraparound partitioning"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Partition[list, n] partitions list into non-overlapping sublists of \
length n. Partition[list, n, d] generates sublists with offset d. \
Partition[list, {n_1, n_2, ...}] partitions a nested list into blocks of size \
n_1 * n 2 * .... Partition[list, {n_1, n_2, ...}, {d_1, d_2, ...}] uses \
offset d_i at level i in list. Partition[list, n, d, {k_L, k_R}] specifies \
that the first element of list should appear at position k_L in the first \
sublist, and the last element of list should appear at or after position k_R \
in the last sublist. If additional elements are needed, Partition fills them \
in by treating list as cyclic. Partition[list, n, d, {k_L, k_R}, x] pads if \
necessary by repeating the element x. Partition[list, n, d, {k_L, k_R}, {x_1, \
x_2, ...}] pads if necessary by cyclically repeating the elements x_i. \
Partition[list, n, d, {k_L, k_R}, {}] uses no padding, and so can yield \
sublists of different lengths. Partition[list, nlist, dlist, {klist_L, \
klist_R}, padlist] specifies alignments and padding in a nested list. ", 
    "synonyms" -> {}, "title" -> "Partition", "type" -> "Symbol", "uri" -> 
    "ref/Partition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[29960, 1045, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->80297647]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 97030, 3381}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3500, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4123, 103, 47, 1, 70, "ObjectName",
 CellID->23656],
Cell[4173, 106, 7872, 251, 70, "Usage",
 CellID->25713]
}, Open  ]],
Cell[CellGroupData[{
Cell[12082, 362, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[12560, 379, 548, 19, 70, "Notes",
 CellID->3332],
Cell[13111, 400, 404, 15, 70, "Notes",
 CellID->23092],
Cell[13518, 417, 671, 26, 70, "Notes",
 CellID->17182],
Cell[14192, 445, 668, 24, 70, "Notes",
 CellID->26467],
Cell[14863, 471, 715, 27, 70, "Notes",
 CellID->11320],
Cell[15581, 500, 299, 13, 70, "Notes",
 CellID->7358],
Cell[15883, 515, 1121, 29, 70, "2ColumnTableMod",
 CellID->21074],
Cell[17007, 546, 895, 31, 70, "Notes",
 CellID->3987],
Cell[17905, 579, 141, 6, 70, "Notes",
 CellID->9094],
Cell[18049, 587, 1292, 35, 70, "2ColumnTableMod",
 CellID->4983],
Cell[19344, 624, 945, 37, 70, "Notes",
 CellID->21364],
Cell[20292, 663, 972, 35, 70, "Notes",
 CellID->27264],
Cell[21267, 700, 132, 4, 70, "Notes",
 CellID->19714],
Cell[21402, 706, 613, 23, 70, "Notes",
 CellID->26746],
Cell[22018, 731, 2337, 85, 70, "Notes",
 CellID->24390],
Cell[24358, 818, 875, 34, 70, "Notes",
 CellID->10425],
Cell[25236, 854, 948, 36, 70, "Notes",
 CellID->26255],
Cell[26187, 892, 945, 33, 70, "Notes",
 CellID->13163],
Cell[27135, 927, 2092, 82, 70, "Notes",
 CellID->31467],
Cell[29230, 1011, 365, 15, 70, "Notes",
 CellID->5792],
Cell[29598, 1028, 325, 12, 70, "Notes",
 CellID->14231]
}, Closed]],
Cell[CellGroupData[{
Cell[29960, 1045, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80297647],
Cell[CellGroupData[{
Cell[30344, 1059, 148, 5, 70, "ExampleSection",
 CellID->199160393],
Cell[30495, 1066, 75, 1, 70, "ExampleText",
 CellID->12126],
Cell[CellGroupData[{
Cell[30595, 1071, 217, 7, 28, "Input",
 CellID->14825],
Cell[30815, 1080, 357, 13, 36, "Output",
 CellID->31159]
}, Open  ]],
Cell[31187, 1096, 121, 3, 70, "ExampleDelimiter",
 CellID->17518],
Cell[31311, 1101, 88, 1, 70, "ExampleText",
 CellID->3220],
Cell[CellGroupData[{
Cell[31424, 1106, 227, 7, 70, "Input",
 CellID->10035],
Cell[31654, 1115, 456, 15, 36, "Output",
 CellID->31314]
}, Open  ]],
Cell[32125, 1133, 121, 3, 70, "ExampleDelimiter",
 CellID->25456],
Cell[32249, 1138, 118, 3, 70, "ExampleText",
 CellID->24147],
Cell[CellGroupData[{
Cell[32392, 1145, 440, 14, 70, "Input",
 CellID->29156],
Cell[32835, 1161, 984, 36, 54, "Output",
 CellID->30134]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33868, 1203, 215, 7, 70, "ExampleSection",
 CellID->751],
Cell[CellGroupData[{
Cell[34108, 1214, 227, 7, 70, "ExampleSubsection",
 CellID->21380392],
Cell[34338, 1223, 93, 1, 70, "ExampleText",
 CellID->16208],
Cell[CellGroupData[{
Cell[34456, 1228, 228, 7, 70, "Input",
 CellID->31478],
Cell[34687, 1237, 318, 11, 36, "Output",
 CellID->22294]
}, Open  ]],
Cell[CellGroupData[{
Cell[35042, 1253, 238, 7, 70, "Input",
 CellID->12589],
Cell[35283, 1262, 318, 11, 36, "Output",
 CellID->17524]
}, Open  ]],
Cell[35616, 1276, 120, 3, 70, "ExampleDelimiter",
 CellID->7976],
Cell[35739, 1281, 63, 1, 70, "ExampleText",
 CellID->9694],
Cell[CellGroupData[{
Cell[35827, 1286, 247, 7, 70, "Input",
 CellID->4090],
Cell[36077, 1295, 387, 13, 36, "Output",
 CellID->20189]
}, Open  ]],
Cell[36479, 1311, 121, 3, 70, "ExampleDelimiter",
 CellID->29372],
Cell[36603, 1316, 125, 5, 70, "ExampleText",
 CellID->7419],
Cell[CellGroupData[{
Cell[36753, 1325, 258, 7, 70, "Input",
 CellID->30301],
Cell[37014, 1334, 387, 13, 36, "Output",
 CellID->21702]
}, Open  ]],
Cell[37416, 1350, 121, 3, 70, "ExampleDelimiter",
 CellID->24844],
Cell[37540, 1355, 179, 7, 70, "ExampleText",
 CellID->20523],
Cell[CellGroupData[{
Cell[37744, 1366, 317, 9, 70, "Input",
 CellID->26539],
Cell[38064, 1377, 387, 13, 36, "Output",
 CellID->20609]
}, Open  ]],
Cell[38466, 1393, 121, 3, 70, "ExampleDelimiter",
 CellID->11827],
Cell[38590, 1398, 87, 1, 70, "ExampleText",
 CellID->6637],
Cell[CellGroupData[{
Cell[38702, 1403, 276, 8, 70, "Input",
 CellID->8186],
Cell[38981, 1413, 352, 12, 36, "Output",
 CellID->27416]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39382, 1431, 233, 7, 70, "ExampleSubsection",
 CellID->1827],
Cell[39618, 1440, 65, 1, 70, "ExampleText",
 CellID->15169],
Cell[CellGroupData[{
Cell[39708, 1445, 258, 7, 70, "Input",
 CellID->17623],
Cell[39969, 1454, 663, 21, 36, "Output",
 CellID->14899]
}, Open  ]],
Cell[40647, 1478, 121, 3, 70, "ExampleDelimiter",
 CellID->22514],
Cell[40771, 1483, 71, 1, 70, "ExampleText",
 CellID->10415],
Cell[CellGroupData[{
Cell[40867, 1488, 276, 8, 70, "Input",
 CellID->3644],
Cell[41146, 1498, 662, 21, 36, "Output",
 CellID->5436]
}, Open  ]],
Cell[41823, 1522, 121, 3, 70, "ExampleDelimiter",
 CellID->23669],
Cell[41947, 1527, 67, 1, 70, "ExampleText",
 CellID->10378],
Cell[CellGroupData[{
Cell[42039, 1532, 328, 10, 70, "Input",
 CellID->31676],
Cell[42370, 1544, 801, 25, 54, "Output",
 CellID->17858]
}, Open  ]],
Cell[43186, 1572, 120, 3, 70, "ExampleDelimiter",
 CellID->7952],
Cell[43309, 1577, 56, 1, 70, "ExampleText",
 CellID->9846],
Cell[CellGroupData[{
Cell[43390, 1582, 328, 10, 70, "Input",
 CellID->27137],
Cell[43721, 1594, 524, 17, 36, "Output",
 CellID->5915]
}, Open  ]],
Cell[44260, 1614, 121, 3, 70, "ExampleDelimiter",
 CellID->22988],
Cell[44384, 1619, 149, 4, 70, "ExampleText",
 CellID->24616],
Cell[CellGroupData[{
Cell[44558, 1627, 306, 9, 70, "Input",
 CellID->7288],
Cell[44867, 1638, 731, 23, 36, "Output",
 CellID->2382]
}, Open  ]],
Cell[45613, 1664, 121, 3, 70, "ExampleDelimiter",
 CellID->28074],
Cell[45737, 1669, 232, 8, 70, "ExampleText",
 CellID->20333],
Cell[CellGroupData[{
Cell[45994, 1681, 376, 12, 70, "Input",
 CellID->3915],
Cell[46373, 1695, 970, 27, 54, "Output",
 CellID->11056]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47392, 1728, 288, 8, 70, "ExampleSubsection",
 CellID->25656],
Cell[47683, 1738, 72, 1, 70, "ExampleText",
 CellID->30062],
Cell[CellGroupData[{
Cell[47780, 1743, 549, 16, 70, "Input",
 CellID->9616],
Cell[48332, 1761, 984, 36, 54, "Output",
 CellID->24524]
}, Open  ]],
Cell[CellGroupData[{
Cell[49353, 1802, 102, 3, 70, "Input",
 CellID->12129],
Cell[49458, 1807, 1614, 30, 70, "Output",
 Evaluatable->False,
 CellID->143058313]
}, Open  ]],
Cell[51087, 1840, 120, 3, 70, "ExampleDelimiter",
 CellID->1984],
Cell[51210, 1845, 193, 6, 70, "ExampleText",
 CellID->4872],
Cell[CellGroupData[{
Cell[51428, 1855, 463, 15, 70, "Input",
 CellID->7049],
Cell[51894, 1872, 1704, 32, 70, "Output",
 Evaluatable->False,
 CellID->617489697]
}, Open  ]],
Cell[CellGroupData[{
Cell[53635, 1909, 102, 3, 70, "Input",
 CellID->18026],
Cell[53740, 1914, 1635, 31, 70, "Output",
 Evaluatable->False,
 CellID->172085682]
}, Open  ]],
Cell[55390, 1948, 121, 3, 70, "ExampleDelimiter",
 CellID->10202],
Cell[55514, 1953, 267, 10, 70, "ExampleText",
 CellID->18775],
Cell[CellGroupData[{
Cell[55806, 1967, 449, 14, 70, "Input",
 CellID->5416],
Cell[56258, 1983, 1663, 31, 70, "Output",
 Evaluatable->False,
 CellID->498242302]
}, Open  ]],
Cell[CellGroupData[{
Cell[57958, 2019, 102, 3, 70, "Input",
 CellID->14552],
Cell[58063, 2024, 1614, 30, 70, "Output",
 Evaluatable->False,
 CellID->386646755]
}, Open  ]],
Cell[59692, 2057, 121, 3, 70, "ExampleDelimiter",
 CellID->12755],
Cell[59816, 2062, 126, 4, 70, "ExampleText",
 CellID->11417],
Cell[CellGroupData[{
Cell[59967, 2070, 664, 22, 70, "Input",
 CellID->22844],
Cell[60634, 2094, 1903, 35, 70, "Output",
 Evaluatable->False,
 CellID->712705265]
}, Open  ]],
Cell[62552, 2132, 121, 3, 70, "ExampleDelimiter",
 CellID->19443],
Cell[62676, 2137, 107, 3, 70, "ExampleText",
 CellID->6824],
Cell[CellGroupData[{
Cell[62808, 2144, 643, 21, 70, "Input",
 CellID->31999],
Cell[63454, 2167, 1823, 34, 70, "Output",
 Evaluatable->False,
 CellID->259073139]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[65338, 2208, 237, 7, 70, "ExampleSection",
 CellID->121],
Cell[65578, 2217, 149, 3, 70, "ExampleText",
 CellID->15733],
Cell[CellGroupData[{
Cell[65752, 2224, 254, 8, 70, "Input",
 CellID->31413],
Cell[66009, 2234, 357, 13, 36, "Output",
 CellID->19917]
}, Open  ]],
Cell[66381, 2250, 121, 3, 70, "ExampleDelimiter",
 CellID->15793],
Cell[66505, 2255, 81, 1, 70, "ExampleText",
 CellID->21873],
Cell[CellGroupData[{
Cell[66611, 2260, 328, 10, 70, "Input",
 CellID->12060],
Cell[66942, 2272, 525, 17, 36, "Output",
 CellID->31175]
}, Open  ]],
Cell[67482, 2292, 120, 3, 70, "ExampleDelimiter",
 CellID->9074],
Cell[67605, 2297, 239, 9, 70, "ExampleText",
 CellID->5985],
Cell[CellGroupData[{
Cell[67869, 2310, 201, 7, 70, "Input",
 CellID->32501],
Cell[68073, 2319, 313, 11, 36, "Output",
 CellID->31622]
}, Open  ]],
Cell[68401, 2333, 121, 3, 70, "ExampleDelimiter",
 CellID->13208],
Cell[68525, 2338, 326, 12, 70, "ExampleText",
 CellID->27395],
Cell[CellGroupData[{
Cell[68876, 2354, 374, 13, 70, "Input",
 CellID->11026],
Cell[69253, 2369, 1086, 22, 70, "Output",
 Evaluatable->False,
 CellID->308761351]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[70388, 2397, 223, 7, 70, "ExampleSection",
 CellID->31988],
Cell[70614, 2406, 73, 1, 70, "ExampleText",
 CellID->10929],
Cell[CellGroupData[{
Cell[70712, 2411, 311, 11, 70, "Input",
 CellID->9072],
Cell[71026, 2424, 537, 13, 94, "Output",
 CellID->30977]
}, Open  ]],
Cell[71578, 2440, 121, 3, 70, "ExampleDelimiter",
 CellID->10193],
Cell[71702, 2445, 79, 1, 70, "ExampleText",
 CellID->8],
Cell[CellGroupData[{
Cell[71806, 2450, 329, 9, 70, "Input",
 CellID->12254],
Cell[72138, 2461, 890, 19, 70, "Output",
 Evaluatable->False,
 CellID->81931570]
}, Open  ]],
Cell[73043, 2483, 121, 3, 70, "ExampleDelimiter",
 CellID->30876],
Cell[73167, 2488, 72, 1, 70, "ExampleText",
 CellID->15137],
Cell[CellGroupData[{
Cell[73264, 2493, 217, 7, 70, "Input",
 CellID->30816],
Cell[73484, 2502, 416, 15, 36, "Output",
 CellID->13803]
}, Open  ]],
Cell[CellGroupData[{
Cell[73937, 2522, 95, 3, 70, "Input",
 CellID->21090],
Cell[74035, 2527, 306, 11, 51, "Output",
 CellID->7912]
}, Open  ]],
Cell[74356, 2541, 121, 3, 70, "ExampleDelimiter",
 CellID->12289],
Cell[74480, 2546, 82, 1, 70, "ExampleText",
 CellID->17253],
Cell[CellGroupData[{
Cell[74587, 2551, 237, 7, 70, "Input",
 CellID->29979],
Cell[74827, 2560, 593, 19, 36, "Output",
 CellID->7299]
}, Open  ]],
Cell[CellGroupData[{
Cell[75457, 2584, 660, 20, 70, "Input",
 CellID->12322],
Cell[76120, 2606, 441, 13, 94, "Output",
 CellID->22902]
}, Open  ]],
Cell[76576, 2622, 123, 3, 70, "ExampleDelimiter",
 CellID->7863195],
Cell[76702, 2627, 142, 4, 70, "ExampleText",
 CellID->14950773],
Cell[76847, 2633, 846, 28, 70, "Input",
 CellID->140729201],
Cell[CellGroupData[{
Cell[77718, 2665, 269, 9, 70, "Input",
 CellID->99426464],
Cell[77990, 2676, 321, 11, 36, "Output",
 CellID->21013751]
}, Open  ]],
Cell[78326, 2690, 97, 1, 70, "ExampleText",
 CellID->13034821],
Cell[CellGroupData[{
Cell[78448, 2695, 337, 11, 70, "Input",
 CellID->233703703],
Cell[78788, 2708, 778, 24, 54, "Output",
 CellID->345865351]
}, Open  ]],
Cell[79581, 2735, 64, 1, 70, "ExampleText",
 CellID->107763972],
Cell[CellGroupData[{
Cell[79670, 2740, 485, 16, 70, "Input",
 CellID->249091302],
Cell[80158, 2758, 361, 13, 36, "Output",
 CellID->621880116]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80568, 2777, 233, 7, 70, "ExampleSection",
 CellID->12274],
Cell[80804, 2786, 328, 12, 70, "ExampleText",
 CellID->5226],
Cell[CellGroupData[{
Cell[81157, 2802, 217, 7, 70, "Input",
 CellID->16463],
Cell[81377, 2811, 357, 13, 36, "Output",
 CellID->28134]
}, Open  ]],
Cell[CellGroupData[{
Cell[81771, 2829, 99, 3, 70, "Input",
 CellID->22972],
Cell[81873, 2834, 243, 8, 36, "Output",
 CellID->24348]
}, Open  ]],
Cell[82131, 2845, 124, 3, 70, "ExampleDelimiter",
 CellID->31720646],
Cell[82258, 2850, 461, 17, 70, "ExampleText",
 CellID->284045099],
Cell[82722, 2869, 251, 9, 70, "Input",
 CellID->471966646],
Cell[CellGroupData[{
Cell[82998, 2882, 137, 4, 70, "Input",
 CellID->150221561],
Cell[83138, 2888, 916, 33, 36, "Output",
 CellID->297439353]
}, Open  ]],
Cell[84069, 2924, 296, 10, 70, "ExampleText",
 CellID->521698515],
Cell[CellGroupData[{
Cell[84390, 2938, 203, 6, 70, "Input",
 CellID->210552214],
Cell[84596, 2946, 716, 25, 36, "Output",
 CellID->264602059]
}, Open  ]],
Cell[85327, 2974, 217, 8, 70, "ExampleText",
 CellID->469082901],
Cell[CellGroupData[{
Cell[85569, 2986, 169, 6, 70, "Input",
 CellID->660433503],
Cell[85741, 2994, 916, 33, 36, "Output",
 CellID->143076866]
}, Open  ]],
Cell[86672, 3030, 225, 7, 70, "ExampleText",
 CellID->5954264],
Cell[CellGroupData[{
Cell[86922, 3041, 134, 4, 70, "Input",
 CellID->2437656],
Cell[87059, 3047, 915, 33, 36, "Output",
 CellID->15232153]
}, Open  ]],
Cell[CellGroupData[{
Cell[88011, 3085, 208, 8, 70, "Input",
 CellID->10975788],
Cell[88222, 3095, 916, 33, 36, "Output",
 CellID->329404301]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[89199, 3135, 310, 9, 70, "SeeAlsoSection",
 CellID->9079],
Cell[89512, 3146, 2196, 80, 70, "SeeAlso",
 CellID->32091]
}, Open  ]],
Cell[CellGroupData[{
Cell[91745, 3231, 314, 9, 70, "TutorialsSection",
 CellID->22619],
Cell[92062, 3242, 188, 4, 70, "Tutorials",
 CellID->2880],
Cell[92253, 3248, 133, 3, 70, "Tutorials",
 CellID->4718],
Cell[92389, 3253, 168, 3, 70, "Tutorials",
 CellID->16128]
}, Open  ]],
Cell[CellGroupData[{
Cell[92594, 3261, 319, 9, 70, "MoreAboutSection",
 CellID->327225102],
Cell[92916, 3272, 152, 3, 70, "MoreAbout",
 CellID->67211413],
Cell[93071, 3277, 154, 3, 70, "MoreAbout",
 CellID->80641386],
Cell[93228, 3282, 144, 3, 70, "MoreAbout",
 CellID->27617197],
Cell[93375, 3287, 177, 3, 70, "MoreAbout",
 CellID->430184552]
}, Open  ]],
Cell[CellGroupData[{
Cell[93589, 3295, 305, 8, 70, "RelatedLinksSection"],
Cell[93897, 3305, 363, 12, 70, "RelatedLinks"],
Cell[94263, 3319, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[94665, 3335, 50, 0, 70, "History"],
Cell[94718, 3337, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

