(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49410,       1486]
NotebookOptionsPosition[     42245,       1246]
NotebookOutlinePosition[     43569,       1284]
CellTagsIndexPosition[     43483,       1279]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PartitionsQ" :> 
          Documentation`HelpLookup["paclet:ref/PartitionsQ"], "DedekindEta" :> 
          Documentation`HelpLookup["paclet:ref/DedekindEta"], 
          "IntegerPartitions" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPartitions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PartitionsQ\"\>", 
       2->"\<\"DedekindEta\"\>", 
       3->"\<\"IntegerPartitions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup["paclet:guide/CombinatorialFunctions"], 
          "Diophantine Equations" :> 
          Documentation`HelpLookup["paclet:guide/DiophantineEquations"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combinatorial Functions\"\>", 
       2->"\<\"Diophantine Equations\"\>", 3->"\<\"Discrete Mathematics\"\>", 
       4->"\<\"Integer Functions\"\>", 5->"\<\"Mathematical Functions\"\>", 
       6->"\<\"Number Theoretic Functions\"\>", 
       7->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PartitionsP", "ObjectName",
 CellID->26588],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PartitionsP",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PartitionsP"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number ",
     Cell[BoxData[
      RowBox[{
       StyleBox["p", "TI"], 
       RowBox[{"(", 
        StyleBox["n", "TI"], ")"}]}]], "InlineFormula"],
     " of unrestricted partitions of the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30538]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PartitionsP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsP"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9246242],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->416744254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PartitionsP", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "7", ",", "11", ",", "15",
    ",", "22", ",", "30", ",", "42", ",", "56", ",", "77"}], "}"}]], "Output",\

 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289152705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Plot the number of unrestricted partitions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"10", ",", 
      RowBox[{"PartitionsP", "[", "k", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxVzHlMk3ccx/GHG6llKMhRKjDkEkGubkwY9iOXUK6e0KkMRKpsYTiEYGcy
V9AqwxDIdIxERSdmBjbUmUkgA+lchk5LvEqmJuCkTBQZIK4cCmUufJ8/9kue
PHk979/nebtgt1RlyTBM4Zvnv/fSmRQy/z8wf3ZK7Jx4j77bY74/qyHwy0Gy
ExbjL+ZM5z4hu2CjXs3hcJ6T3VHymzj/SAv7Xz4WXYtXJN2ZIvtgvFktqN9n
Ivtiv+noX6lnZsh+8IpRCw2zc+QANFkILI/NviYHoXYd94lTmJkcjId1s2cf
2DNYcgjMjKhkzMGCvB7t3mrlrWnW4ThUf1vV9tSSHAGT9FC14LoVORKHv5uy
t71gTY6C184urVZrQxbAHDfZ15dvS34HJv/Zew3hduR34XDjxESvhT05GpYd
VztsbrB+D44ikcHu2DLyBqT2PzN+q3AgxyDhijZ+1I1DjkVNWtf3PAPr95FY
OJtrrltOjsMQ9hurk7nkjXhQMPP12DxrIYpVHhXl5x3JwFhXkbEy760la4D1
Ibc+F9s6Ud+Ek2t3Hi/eRtZsQqiR29t/ke3xKCxe943BegX1eHSnPRuOyyEz
CZDvrd0d3sL2BFxN4Y7q59ieCGuz28zj1JXUE+H/lba/p5HMJGGutLNz9Qjb
kzAxXmSZK3CmnoxiubfKo5KsSYZsn2vofT3bN+PXPxudHN1dqG+G8KcF3rYC
MpOCkJNV6qAf2J6CmpK9Mk8T21MRZLDpqY1bRT0VkoEebqyWzIgQ5T/MLdKz
XYTCqMdVAytdqadhuOTE8vtKsiYNQwfcPQOa2J6ORpGty/wQ29Ox3eS+NjLQ
jXoGKtxEMVMfkzUZOMd1DuWfZ3sm/nhdMGiYZHsmxE5PXRcj3alngbPgHfNz
OVmThYG+hsEXl9kuhkl00K97mgwxmto/urss2oPui+ESPbdqooKsE2PcSvnL
1nYyI0F6TW1EoYkMCdoydJJXUTzaSxDMv2Mdtoesk6BDd/zS9AUyI8Xi6V15
+X+TIcVpPq95e7An7aUYqXK+ZreLrJMirD9SLGomMzK0CizyBI/IkEHV1jJ6
hcenvQylC7zRlwqyToY9CU38vnoyI4e3V8KHsptkyOEg89ZW2qymvRyTWqNv
npCskyOzLGB6RE1mFDjT53jd9xIZCpTbvLzNec7uFQjd8PualjVetFfg07At
rTNbyUw2OHPJZ+ePkpEN7rUjBy7fJGuy8Un1I9tAK2/aZ0NVdmoyM4bM5KDb
7bA2opSMHDz0+GJKf46syUHrTOc/foPs/s39doU938GH9koYVUH91v5kKPHj
DnOsXkjWKFFgLuwt20LWKbE47PriVTm7/wB3ZW3uO+p88C+rG54c
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0., 100.}, {0., 8.280052920492299}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->395904407]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Compute the number of partitions for large numbers:", "ExampleText",
 CellID->235119025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PartitionsP", "[", 
    RowBox[{"2", "^", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->712293765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "5", ",", "22", ",", "231", ",", "8349", ",", "1741630",
    ",", "4351078600", ",", "365749566870782", ",", "4453575699570940947378", 
   ",", "61847822068260244309086870983975", ",", 
   "18116048323611252751541173214616030020513022685", ",", 
   "6927233917602120527467409170319882882996950147283323368445315320451"}], 
  "}"}]], "Output",
 ImageSize->{534, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7130439]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PartitionsP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsP"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartitionsP", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "5", ",", "11"}], "}"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306094974]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->582683114],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->584428420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PartitionsP", "[", "n", "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->312046436],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox["p",
    PartitionsP], "(", "n", ")"}], TraditionalForm]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->149815768]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Number of non\[Hyphen]isomorphic Abelian groups of order ",
 Cell[BoxData["n"], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Times", "@@", 
    RowBox[{"PartitionsP", "[", 
     RowBox[{"Last", "/@", 
      RowBox[{"FactorInteger", "[", "n", "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", "1", ",", "1", ",", "3", 
   ",", "2", ",", "1", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->495112075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Compare cumulative counts of even and odd partitions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Accumulate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"PartitionsP", "[", "k", "]"}], ",", "2"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1000"}], "}"}]}], "]"}], "]"}], "/", 
   RowBox[{"Range", "[", "1000", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->385369873]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Visualize ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]adic valuations of the number of partitions:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"IntegerExponent", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"PartitionsP", "[", "n", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "120"}], "}"}]}], "]"}], ",", " ", "k"}], "]"}], 
      ",", " ", 
      RowBox[{"{", 
       RowBox[{"k", ",", " ", "2", ",", "120"}], "}"}]}], "]"}], ",", "2"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztW+l55CAMfU4naWlLSAP5mS0/2WGMOARIWGCYjfLNYUAHknjIePL+8fnn
4w3A18/r78/r2In2sPbXysm0/1T2n8Hy5KCOHF3/xl3+kh2Nc62tZFFGQKD5
llyapXSzhbKZuY4uGg1WBN9qS6x8yZLRCrsko0eQGU3V+z9m/wrUnsILTNKc
DH0iEIULOhkuPP7SEXXxRhPWizHztF3IpJJ6NNpsPV10QZIpRIiFmabGYiin
MGcxy+8iF0QJ3LGAdzaCacwV9dOQaO2ZAtZWD/bCWk4G931AWWIjsrOC4R4E
FIQsFJ1lSpb6vmZWT86l4rnoIC3NXnEBf/Dr4HaPCmkNO9ewQkVCk7sOn+bf
l00OgAUG2rDTIk4gCK4NHDaBxaviQ58N6H7wqj7uKPa/BiWZw3RKBKRXNei5
yHCB9NMZqWm8FakobaVbXAFznqWItADxQLoOrY9Qk70zL9ggN0QiSNCrRsMW
eGmpA/Zm4GNNRzk7N0Fu9t57Heo06ZbzX//7l4pPa3sOO3TZEvWBdnG+u3t0
AjzqVkALzOdcPzrIhnZqMGccFXn9yZWNxrYYzVbPdSqSl2ko72bT1qDaRVmr
3tSiI+u1WelWUGZAXw42uHRCxeex3ANmAWME8U/PxFmG9BOxMnk9GeuPeZLn
SP4H6WD4a7dC+vKwRUjUlVKK16oEgLF1zi31hlx6L65cGRizSNhYDIYEjEqt
1VqimuyPnnR1MKuMSV6ZbU3tOjLeF7zPpXyI3xrWhG0nNP4DJvgL7yV4xAKe
6OcGBvgGkkB+9SJIQoB+B+ecRkzO+j5Pg0hUGN8iXiHcE8pqBYCmiCwF1Gz/
jcr9XJF7e4bVh5Tdztx+BM4+SoDMJH5t5k04wuln7JnOSipXAoYIr0BK47bU
LpyM8cl7ct4eImHoXG4G7fXrVlk0huqPNEDRCOJ8zo0+iJsmEqwaBGadrWUj
PV/gx2CaCFb1qZzM8hqRsIX/pZLJdELI10eQjvgGAmA4BA==
   "], {{0, 0}, {120, 119}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->{225, Automatic}]], "Output",
 ImageSize->{229, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452212134]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PartitionsP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsP"]], "InlineFormula"],
 " gives the length of ",
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->173257980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", "5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68128658],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7665396]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartitionsP", "[", "5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->485295486],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->142861694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Obtain values of ",
 Cell[BoxData[
  ButtonBox["PartitionsP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsP"]], "InlineFormula"],
 " from series expansion:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", 
      RowBox[{
       RowBox[{"t", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "8"}], ")"}]}], "/", 
       RowBox[{"EllipticThetaPrime", "[", 
        RowBox[{"1", ",", "0", ",", 
         RowBox[{"Sqrt", "[", "t", "]"}]}], "]"}]}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "12"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"t", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWNtu00AQ3fqStLRJ3CKgARXShzbQfgF8ADzxEVGF1D4gUOmn8268zo6z
OT57c4oKlhxndu5nZ3bX/rp6uP32ffVwd7NafLlf/by9u/m1+PzjvhnK95TK
3iilZqeq+V83/9pbrrPmXpO/mztrWIfmOd/iqLzTaiVs+lUrqfL1Q1+aOQKp
cfOjyTGMl81Pacb18BHwR2Z8fyAf/bn8SBwZxDMBucLwc/CLci57rviLQB4y
jjiL3eNIuyiH+BQOvFz2S6IvfvtVkhMrPbq0K1SRWirdUr1RrNan0kWch2kh
qtwKqzGbzhLyYH3Sl0qxGIfqLhYPWqg2dL/uCmqnevTI0OKw+YyLC23lVAqR
4H0pqxzrTzaOeR0auYNAvqly+wwJIheFs0UfefL12XHpsVXUmXe4Uommznwk
1ejxVA32JJqIOcrhHIheQpV6rCXsG7BbBldfi8bdO1SPu8qH6hjlU+t5mogX
2kP9VP8Un6TqY+epcDVhHCc7x4EWUrsB9f+lrhhShRlZXVFOzoYhuafuAjnD
o13US51zF258Rw71Tsvfqln0F6o5mQ/tvyD5/k81rudGm35OrOnxU8f4C4KJ
T/5lBAZMjvWklpsH7G3F712hWISsjkTudSDCsZE7i4xwHjW78t7LTky9WuvF
NAO6oj5d/TyLltZdGfNGrMlplFV2ikpZsyQq7Ck2az67HAPPu0voNDDQFssn
XluqCE+5WB+h87bWf+acw7RY1s7k4jinrnWZQYm/lzJp1elc1PwLVFVb3QCz
WQgWsO9o13aHau+V8VOa59TDLzxxSB9NiL7NZ70vu2fXh2PAyLJVOHx1yJHd
ROZ2QvE/qTffuuxvpPxtvfDEt/549wmiWAD9zmRxDuMXgNx74C8JPxM5R0Ro
AxFaBvjX1uz05JJQwGzfQjYLKxv9vApEesnQ+ksoXIEv3sdsj1TqI8nTps9N
vlglGBObfZum/F3wcOheg58M6BaF0caWMOJ6g1VJblXF0tAfSMTC71ZaqBap
Y7vKUE7qPaut79x8ppXa+wOfal6d\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{539, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4451798]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["PartitionsP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsP"]], "InlineFormula"],
 ": "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"PartitionsP", "[", 
       RowBox[{
        RowBox[{"5", "n"}], "+", "4"}], "]"}], ",", "5"}], "]"}], "==", "0"}],
    ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{"n", ",", "Integers"}], "]"}], "&&", 
    RowBox[{"n", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->284493135]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PartitionsP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsP"]], "InlineFormula"],
 " evaluates only for integer arguments:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartitionsP", "[", "12.1", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"PartitionsP", "[", "12.1`", "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->437716664]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " to find implicit integers in arguments:"
}], "ExampleText",
 CellID->270319749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartitionsP", "[", 
  RowBox[{"12", " ", "+", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"E", " ", "+", " ", "1"}], ")"}], "^", "2"}], "-", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"E", " ", "+", " ", "1"}], ")"}], "^", "2"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"PartitionsP", "[", 
  RowBox[{"11", "-", 
   RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
   SuperscriptBox["\[ExponentialE]", "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{223, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->205761091]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->63616441],

Cell[BoxData["77"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->9960521]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Successive differences of ",
 Cell[BoxData[
  ButtonBox["PartitionsP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsP"]], "InlineFormula"],
 " modulo 2:"
}], "ExampleText",
 CellID->19768499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"NestList", "[", 
     RowBox[{"Differences", ",", 
      RowBox[{"PartitionsP", "[", 
       RowBox[{"Range", "[", "100", "]"}], "]"}], ",", "100"}], "]"}], ",", 
    "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->602961573],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztWFuO3DgMHGP3InulHCFIvvf+fztB1gOFXS952qbdYwPE2DIlkVUsyj3/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   "], {{0, 0}, {100, 101}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->Small]], "Output",
 ImageSize->{184, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->504284512]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153493948],

Cell[TextData[{
 "A \"random\" walk based on ",
 Cell[BoxData[
  ButtonBox["PartitionsP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PartitionsP"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->166750205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "#", "]"}], ",", 
      RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{"3.4", " ", "Pi", "  ", "I", " ", 
      RowBox[{"PartitionsP", "[", 
       RowBox[{"Range", "[", "500", "]"}], "]"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167776127],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->564496573]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17004],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PartitionsQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PartitionsQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DedekindEta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DedekindEta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPartitions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30623]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18104],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->20877]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->20353],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#15406"], None}]], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/PartitionFunctionP.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/PartitionsP/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
PartitionsP"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->134341515],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombinatorialFunctions"]], "MoreAbout",
 CellID->163903721],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "MoreAbout",
 CellID->325126762],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->131596160],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->92686790],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->523575160],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->694516495],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->163101203]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PartitionsP - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 14.4915882}", "context" -> "System`", 
    "keywords" -> {
     "Euler's pentagonal formula", "Hardy-Ramanujan-Rademacher algorithm", 
      "partitions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PartitionsP[n] gives the number p (n) of unrestricted partitions of the \
integer n. ", "synonyms" -> {"partitions p"}, "title" -> "PartitionsP", 
    "type" -> "Symbol", "uri" -> "ref/PartitionsP"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5219, 160, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->9246242]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 43342, 1272}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2912, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3535, 93, 49, 1, 70, "ObjectName",
 CellID->26588],
Cell[3587, 96, 734, 24, 70, "Usage",
 CellID->30538]
}, Open  ]],
Cell[CellGroupData[{
Cell[4358, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4836, 142, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4971, 148, 211, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[5219, 160, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9246242],
Cell[CellGroupData[{
Cell[5602, 174, 148, 5, 70, "ExampleSection",
 CellID->416744254],
Cell[CellGroupData[{
Cell[5775, 183, 203, 6, 28, "Input"],
Cell[5981, 191, 330, 10, 36, "Output",
 CellID->289152705]
}, Open  ]],
Cell[6326, 204, 105, 2, 70, "ExampleDelimiter"],
Cell[6434, 208, 66, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[6525, 212, 298, 9, 28, "Input"],
Cell[6826, 223, 1904, 40, 169, "Output",
 CellID->395904407]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8779, 269, 200, 6, 70, "ExampleSection"],
Cell[8982, 277, 94, 1, 70, "ExampleText",
 CellID->235119025],
Cell[CellGroupData[{
Cell[9101, 282, 248, 8, 70, "Input",
 CellID->712293765],
Cell[9352, 292, 533, 13, 88, "Output",
 CellID->7130439]
}, Open  ]],
Cell[9900, 308, 105, 2, 70, "ExampleDelimiter"],
Cell[10008, 312, 196, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[10229, 322, 144, 4, 70, "Input"],
Cell[10376, 328, 214, 7, 36, "Output",
 CellID->306094974]
}, Open  ]],
Cell[10605, 338, 125, 3, 70, "ExampleDelimiter",
 CellID->582683114],
Cell[10733, 343, 203, 7, 70, "ExampleText",
 CellID->584428420],
Cell[CellGroupData[{
Cell[10961, 354, 147, 5, 70, "Input",
 CellID->312046436],
Cell[11111, 361, 260, 9, 50, "Output",
 CellID->149815768]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11420, 376, 207, 6, 70, "ExampleSection"],
Cell[11630, 384, 139, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[11794, 392, 297, 9, 70, "Input"],
Cell[12094, 403, 311, 9, 36, "Output",
 CellID->495112075]
}, Open  ]],
Cell[12420, 415, 105, 2, 70, "ExampleDelimiter"],
Cell[12528, 419, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12629, 423, 405, 12, 70, "Input"],
Cell[13037, 437, 3738, 65, 70, "Output",
 Evaluatable->False,
 CellID->385369873]
}, Open  ]],
Cell[16790, 505, 105, 2, 70, "ExampleDelimiter"],
Cell[16898, 509, 163, 5, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[17086, 518, 545, 17, 70, "Input"],
Cell[17634, 537, 1361, 28, 244, "Output",
 CellID->452212134]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19044, 571, 217, 6, 70, "ExampleSection"],
Cell[19264, 579, 347, 12, 70, "ExampleText",
 CellID->173257980],
Cell[CellGroupData[{
Cell[19636, 595, 112, 3, 70, "Input",
 CellID->68128658],
Cell[19751, 600, 643, 21, 36, "Output",
 CellID->7665396]
}, Open  ]],
Cell[CellGroupData[{
Cell[20431, 626, 107, 3, 70, "Input",
 CellID->485295486],
Cell[20541, 631, 158, 5, 36, "Output",
 CellID->142861694]
}, Open  ]],
Cell[20714, 639, 105, 2, 70, "ExampleDelimiter"],
Cell[20822, 643, 208, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21055, 654, 597, 19, 70, "Input"],
Cell[21655, 675, 1275, 25, 70, "Output",
 Evaluatable->False,
 CellID->4451798]
}, Open  ]],
Cell[22945, 703, 342, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[23312, 719, 411, 14, 70, "Input"],
Cell[23726, 735, 161, 5, 36, "Output",
 CellID->284493135]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23936, 746, 210, 6, 70, "ExampleSection"],
Cell[24149, 754, 201, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[24375, 764, 90, 2, 70, "Input"],
Cell[24468, 768, 200, 6, 36, "Output",
 CellID->437716664]
}, Open  ]],
Cell[24683, 777, 226, 8, 70, "ExampleText",
 CellID->270319749],
Cell[CellGroupData[{
Cell[24934, 789, 341, 11, 70, "Input"],
Cell[25278, 802, 407, 12, 39, "Output",
 CellID->205761091]
}, Open  ]],
Cell[CellGroupData[{
Cell[25722, 819, 103, 3, 70, "Input",
 CellID->63616441],
Cell[25828, 824, 157, 5, 36, "Output",
 CellID->9960521]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26034, 835, 208, 6, 70, "ExampleSection"],
Cell[26245, 843, 223, 8, 70, "ExampleText",
 CellID->19768499],
Cell[CellGroupData[{
Cell[26493, 855, 330, 10, 70, "Input",
 CellID->602961573],
Cell[26826, 867, 2863, 53, 202, "Output",
 CellID->504284512]
}, Open  ]],
Cell[29704, 923, 125, 3, 70, "ExampleDelimiter",
 CellID->153493948],
Cell[29832, 928, 216, 8, 70, "ExampleText",
 CellID->166750205],
Cell[CellGroupData[{
Cell[30073, 940, 472, 15, 70, "Input",
 CellID->167776127],
Cell[30548, 957, 7179, 122, 70, "Output",
 Evaluatable->False,
 CellID->564496573]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37788, 1086, 311, 9, 70, "SeeAlsoSection",
 CellID->17004],
Cell[38102, 1097, 726, 26, 70, "SeeAlso",
 CellID->30623]
}, Open  ]],
Cell[CellGroupData[{
Cell[38865, 1128, 314, 9, 70, "TutorialsSection",
 CellID->18104],
Cell[39182, 1139, 156, 3, 70, "Tutorials",
 CellID->20877]
}, Open  ]],
Cell[CellGroupData[{
Cell[39375, 1147, 321, 9, 70, "RelatedLinksSection",
 CellID->20353],
Cell[39699, 1158, 251, 5, 70, "RelatedLinks"],
Cell[39953, 1165, 189, 4, 70, "RelatedLinks"],
Cell[40145, 1171, 200, 4, 70, "RelatedLinks"],
Cell[40348, 1177, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40774, 1195, 319, 9, 70, "MoreAboutSection",
 CellID->134341515],
Cell[41096, 1206, 157, 3, 70, "MoreAbout",
 CellID->163903721],
Cell[41256, 1211, 153, 3, 70, "MoreAbout",
 CellID->325126762],
Cell[41412, 1216, 151, 3, 70, "MoreAbout",
 CellID->131596160],
Cell[41566, 1221, 144, 3, 70, "MoreAbout",
 CellID->92686790],
Cell[41713, 1226, 155, 3, 70, "MoreAbout",
 CellID->523575160],
Cell[41871, 1231, 162, 3, 70, "MoreAbout",
 CellID->694516495],
Cell[42036, 1236, 137, 3, 70, "MoreAbout",
 CellID->163101203]
}, Open  ]],
Cell[42188, 1242, 27, 0, 70, "History"],
Cell[42218, 1244, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

