(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13097,        440]
NotebookOptionsPosition[     10445,        354]
NotebookOutlinePosition[     11602,        386]
CellTagsIndexPosition[     11559,        383]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/Introduction-Patterns"], 
          "Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"], 
          "Naming Pieces of Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/NamingPiecesOfPatterns"], 
          "Specifying Types of Expression in Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecifyingTypesOfExpressionInPatterns"], 
          "Optional and Default Arguments" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionalAndDefaultArguments"], 
          "Pattern Sequences" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternSequences"], 
          "Patterns for Some Common Types of Expression" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsForSomeCommonTypesOfExpression"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Introduction to Patterns\"\>", 
       2->"\<\"Patterns and Transformation Rules\"\>", 
       3->"\<\"Naming Pieces of Patterns\"\>", 
       4->"\<\"Specifying Types of Expression in Patterns\"\>", 
       5->"\<\"Optional and Default Arguments\"\>", 
       6->"\<\"Pattern Sequences\"\>", 
       7->"\<\"Patterns for Some Common Types of Expression\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Blank" :> Documentation`HelpLookup["paclet:ref/Blank"], 
          "Optional" :> Documentation`HelpLookup["paclet:ref/Optional"], 
          "PatternTest" :> Documentation`HelpLookup["paclet:ref/PatternTest"],
           "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Blank\"\>", 2->"\<\"Optional\"\>", 
       3->"\<\"PatternTest\"\>", 
       4->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"],
           "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Patterns\"\>", 
       2->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Pattern ",
 StyleBox["(:)", "OperatorCharacter"]
}], "ObjectName",
 CellID->5783],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["s", "TI"], ":", 
       StyleBox["obj", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]represents the pattern object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     ", assigned the name ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23387]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The name ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " must be a symbol. "
}], "Notes",
 CellID->28793],

Cell[TextData[{
 "The object ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 " can be any pattern object. "
}], "Notes",
 CellID->28050],

Cell[TextData[{
 "When a transformation rule is used, any occurrence of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " on the right\[Hyphen]hand side is replaced by whatever expression it \
matched on the left\[Hyphen]hand side. "
}], "Notes",
 CellID->19679],

Cell[TextData[{
 "The operator ",
 Cell[BoxData[":"], "InlineFormula"],
 " has a comparatively low precedence. The expression ",
 Cell[BoxData[
  RowBox[{"x", ":", 
   RowBox[{"_", "+", "_"}]}]], "InlineFormula"],
 " is thus interpreted as ",
 Cell[BoxData[
  RowBox[{"x", ":", 
   RowBox[{"(", 
    RowBox[{"_", "+", "_"}], ")"}]}]], "InlineFormula"],
 ", not ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", ":", "_"}], ")"}], "+", "_"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18268],

Cell[TextData[{
 "The form ",
 Cell[BoxData[
  StyleBox["s_", "TI"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], ":", "_"}]], "InlineFormula"],
 ". Similarly, ",
 Cell[BoxData[
  StyleBox["s_h", "TI"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], ":", 
   StyleBox[
    RowBox[{"_", 
     StyleBox["h", "TI"]}]]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["s__", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], ":", "__"}]], "InlineFormula"],
 ", and so on. "
}], "Notes",
 CellID->31274]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21511],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blank",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blank"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Optional",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Optional"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PatternTest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6618]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30884],

Cell[TextData[ButtonBox["Introduction to Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Introduction-Patterns"]], "Tutorials",
 CellID->19483],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->566852007],

Cell[TextData[ButtonBox["Naming Pieces of Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingPiecesOfPatterns"]], "Tutorials",
 CellID->32629],

Cell[TextData[ButtonBox["Specifying Types of Expression in Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecifyingTypesOfExpressionInPatterns"]], "Tutorials",
 CellID->83007426],

Cell[TextData[ButtonBox["Optional and Default Arguments",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionalAndDefaultArguments"]], "Tutorials",
 CellID->102082052],

Cell[TextData[ButtonBox["Pattern Sequences",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternSequences"]], "Tutorials",
 CellID->13997],

Cell[TextData[ButtonBox["Patterns for Some Common Types of Expression",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PatternsForSomeCommonTypesOfExpression"]], "Tutorials",
 CellID->39836925]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->819837561],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->537508433],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->725717985]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pattern (:) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 21.1480086}", "context" -> "System`", 
    "keywords" -> {
     "colon operator", "default value", "named pattern", "pattern", 
      "pattern name", "pattern label", "pattern mark", 
      "reference to pattern"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "s : obj represents the pattern object obj, assigned the name s. ", 
    "synonyms" -> {":"}, "title" -> "Pattern", "type" -> "Symbol", "uri" -> 
    "ref/Pattern"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3336, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3959, 101, 99, 4, 70, "ObjectName",
 CellID->5783],
Cell[4061, 107, 569, 19, 70, "Usage",
 CellID->23387]
}, Open  ]],
Cell[CellGroupData[{
Cell[4667, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5145, 148, 138, 6, 70, "Notes",
 CellID->28793],
Cell[5286, 156, 151, 6, 70, "Notes",
 CellID->28050],
Cell[5440, 164, 275, 7, 70, "Notes",
 CellID->19679],
Cell[5718, 173, 508, 19, 70, "Notes",
 CellID->18268],
Cell[6229, 194, 631, 27, 70, "Notes",
 CellID->31274]
}, Closed]],
Cell[CellGroupData[{
Cell[6897, 226, 311, 9, 70, "SeeAlsoSection",
 CellID->21511],
Cell[7211, 237, 956, 35, 70, "SeeAlso",
 CellID->6618]
}, Open  ]],
Cell[CellGroupData[{
Cell[8204, 277, 314, 9, 70, "TutorialsSection",
 CellID->30884],
Cell[8521, 288, 156, 3, 70, "Tutorials",
 CellID->19483],
Cell[8680, 293, 178, 3, 70, "Tutorials",
 CellID->566852007],
Cell[8861, 298, 158, 3, 70, "Tutorials",
 CellID->32629],
Cell[9022, 303, 196, 4, 70, "Tutorials",
 CellID->83007426],
Cell[9221, 309, 172, 3, 70, "Tutorials",
 CellID->102082052],
Cell[9396, 314, 144, 3, 70, "Tutorials",
 CellID->13997],
Cell[9543, 319, 199, 4, 70, "Tutorials",
 CellID->39836925]
}, Open  ]],
Cell[CellGroupData[{
Cell[9779, 328, 319, 9, 70, "MoreAboutSection",
 CellID->819837561],
Cell[10101, 339, 128, 3, 70, "MoreAbout",
 CellID->537508433],
Cell[10232, 344, 141, 3, 70, "MoreAbout",
 CellID->725717985]
}, Open  ]],
Cell[10388, 350, 27, 0, 70, "History"],
Cell[10418, 352, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

