(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    160766,       2961]
NotebookOptionsPosition[    156607,       2830]
NotebookOutlinePosition[    158155,       2870]
CellTagsIndexPosition[    158068,       2865]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Method" :> Documentation`HelpLookup["paclet:ref/Method"], 
          "MaxRecursion" :> 
          Documentation`HelpLookup["paclet:ref/MaxRecursion"], 
          "EvaluationMonitor" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationMonitor"], 
          "StepMonitor" :> Documentation`HelpLookup["paclet:ref/StepMonitor"],
           "SystemOptions" :> 
          Documentation`HelpLookup["paclet:ref/SystemOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Method\"\>", 
       2->"\<\"MaxRecursion\"\>", 3->"\<\"EvaluationMonitor\"\>", 
       4->"\<\"StepMonitor\"\>", 
       5->"\<\"SystemOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Plotting Options\"\>", 
       2->"\<\"Time Measurement & Optimization\"\>", 
       3->"\<\"Tuning & Debugging\"\>", 
       4->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       5->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PerformanceGoal", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PerformanceGoal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
     " \[LineSeparator]is an option for plotting and various other \
algorithmic functions that specifies what aspect of performance to try to \
optimize with ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     " settings for options."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Different settings for ",
 Cell[BoxData[
  ButtonBox["PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
 " effectively change the meaning of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " for other options. Any explicit option setting is not affected by ",
 Cell[BoxData[
  ButtonBox["PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->73140546],

Cell[TextData[{
 "Typical settings for ",
 Cell[BoxData[
  ButtonBox["PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Quality\>\"", Cell[
    "optimize for quality of final results", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Speed\>\"", Cell[
    "optimize for speed of getting results", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->145081921],

Cell[TextData[{
 "The typical default setting for ",
 Cell[BoxData[
  ButtonBox["PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["$PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PerformanceGoal"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->408422148]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->608396707],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->337060715],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
 " usually uses different settings when ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " controls are active:"
}], "ExampleText",
 CellID->2130497847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a", " ", "x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134984451],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 1, 2}}, Typeset`size$$ = {180., {70., 74.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$35856$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$35856$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot3D[
        Sin[($CellContext`a$$ $CellContext`x) $CellContext`y], \
{$CellContext`x, 0, 3}, {$CellContext`y, 0, 3}], 
      "Specifications" :> {{$CellContext`a$$, 1, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {114., 119.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->1265242980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->555692266],

Cell[TextData[{
 "Compare the results for each setting of ",
 Cell[BoxData[
  ButtonBox["PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->261901143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Timing", "[", 
      RowBox[{"Plot3D", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"x", " ", "y"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
        RowBox[{"PerformanceGoal", "\[Rule]", "pg"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"pg", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Speed\>\"", ",", "\"\<Quality\>\""}], "}"}]}], "}"}]}], 
    "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->943620434],

Cell[BoxData[
 TagBox[GridBox[{
    {"0.0022829999999771644`", "0.1202570000000378`"},
    {
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFlFtIVFEUhodjW44ilBAklqGFkfSgElbUw15RKBRhN3upB9ORehEtQoIk
Cu3mQ2JBUj4UUXSBGonoAtGBIcxMUavpogmW7MbUcU7RLuhBE3UtWXvm0IZh
488/v+ubtdfKKqvaWWH5fD7/1CfB9/9TMn1CMr6uYvSZ43r4dYx+d/r8jdEn
Z46H34L4+SJGnzk2cJ8XT0jivWd+dndX2TPJdSUvdmYWThR0Sp7jyrYTDYlB
953h1/J8JOHBgfp+0pE3tz5nw6XBQdKR19+ceTTwasjwW/A163F68ZFvRr6A
UEt1JOnjsFGPDeMpSY27IyNUd3xeRd/jXIpuXr8i3gpWpyJeXo8i3uJdWze3
3BsjHXm3ZNfVZaRHDb8FZ18+qU6ZjBr5AublNb/I3hE16rGh8GHvyO+0CNUX
/x24xIv94roiLp7jSvw9uV9T/agjb036oo79fXM68hYZdSKv/3i779TysJEv
YLQq7+CvTQNGPTbsDT2qXLcgSHXE768mXt5HTby8X5r+D++Lppv//pp4V+Vv
LDl0+DvpyPtztn7ut6C1vCe6veCqkS9gYqi2sfj5J4fXY8P9pZ8Hnq4ddrz2
BerIi/PFdUXvkOe41C/u18SFOt7LloRrM9re09/Iu7B5sXvG3+5wvwV151Ry
0FEOzxfw4a24EOgfN7hsWH15UJ8MjDteexB15MW9wXVFfeQ5Lr1D7tfUL9Sx
LuRCHe87s33hfgtCN8u3Vf+JOjxfQFpqwb7XiSMGlw0911sbfnzpdbz2O+rI
i/uQ60ri3uA5rsT54n4t8R2ijry8XxZgvcjF/VPzO5yTur4r7PB8AQNjp/uv
5AcMLhus5MqgnTi31+LPryBePqeCePk8CuIdZXMniJfPlyBefIeoIy/2i/st
4uL5AmpulBbdagob9dhwrHvltTe3o9Rvkxd15OX71iZevucxx5W4D7lfS9wb
qCMvzhfqyIvvkPst6hfPFx5cNjTlpqxZUdon/wHOjayg
       "], 
       {EdgeForm[None], 
        Polygon3DBox[{{2, 1, 11, 12}, {12, 11, 21, 22}, {22, 21, 31, 32}, {32,
          31, 41, 42}, {42, 41, 51, 52}, {52, 51, 61, 62}, {62, 61, 71, 72}, {
         72, 71, 81, 82}, {82, 81, 91, 92}, {3, 2, 12, 13}, {13, 12, 22, 
         23}, {23, 22, 32, 33}, {33, 32, 42, 43}, {43, 42, 52, 53}, {53, 52, 
         62, 63}, {63, 62, 72, 73}, {73, 72, 82, 83}, {83, 82, 92, 93}, {4, 3,
          13, 14}, {14, 13, 23, 24}, {24, 23, 33, 34}, {34, 33, 43, 44}, {44, 
         43, 53, 54}, {54, 53, 63, 64}, {64, 63, 73, 74}, {74, 73, 83, 84}, {
         84, 83, 93, 94}, {5, 4, 14, 15}, {15, 14, 24, 25}, {25, 24, 34, 
         35}, {35, 34, 44, 45}, {45, 44, 54, 55}, {55, 54, 64, 65}, {65, 64, 
         74, 75}, {75, 74, 84, 85}, {85, 84, 94, 95}, {6, 5, 15, 16}, {16, 15,
          25, 26}, {26, 25, 35, 36}, {36, 35, 45, 46}, {46, 45, 55, 56}, {56, 
         55, 65, 66}, {66, 65, 75, 76}, {76, 75, 85, 86}, {86, 85, 95, 96}, {
         7, 6, 16, 17}, {17, 16, 26, 27}, {27, 26, 36, 37}, {37, 36, 46, 
         47}, {47, 46, 56, 57}, {57, 56, 66, 67}, {67, 66, 76, 77}, {77, 76, 
         86, 87}, {87, 86, 96, 97}, {8, 7, 17, 18}, {18, 17, 27, 28}, {28, 27,
          37, 38}, {38, 37, 47, 48}, {48, 47, 57, 58}, {58, 57, 67, 68}, {68, 
         67, 77, 78}, {78, 77, 87, 88}, {88, 87, 97, 98}, {9, 8, 18, 19}, {19,
          18, 28, 29}, {29, 28, 38, 39}, {39, 38, 48, 49}, {49, 48, 58, 59}, {
         59, 58, 68, 69}, {69, 68, 78, 79}, {79, 78, 88, 89}, {89, 88, 98, 
         99}, {10, 9, 19, 20}, {20, 19, 29, 30}, {30, 29, 39, 40}, {40, 39, 
         49, 50}, {50, 49, 59, 60}, {60, 59, 69, 70}, {70, 69, 79, 80}, {80, 
         79, 89, 90}, {90, 89, 99, 100}}]},
       VertexNormals->CompressedData["
1:eJx1lX1UzXccx7tFbjYVmSgzD0Ook9Gm6diHSITm4aZSiRTr4SpTJlNNsSlt
wrK1To8zIloPelgevoqw3Ojeujduqnu7dR+6JQ+HyLHmqPdvf+2e03mf3+ev
Xuf98J0SEL4+yNDAwCDw7Z+Rwf/9HpPpyhUBFosaGS4nhWEWGT6PKFXrlG11
TcndlQ+9H8/M7iKRU9z2zGw1dx/6prR3Px13n//upyLBCTNeaoSeu9ddDa9j
exQk72E107O6ufvg90Pinf9elhvcw91Xuc12e/XpA1q7LTb9qxf/3ffXZkbe
3Sujof+Xu5sN8hC+wQeugTOZpgPzGhh0+P4Xdov6u2lbkVSS36hgg1rP1orP
T32s1JFu0vLFiWGd7Eisn0F5iogZuSTn8M6ryeiiaD7fVssG9TZjwpGSkLEd
9KQsYIOxSMdm+pc6O/5+g51ZkeopXtBOcZb7+Fsud7GBwHWFXZIqJv2rOOFH
QyWNl62ukS3Qsw/rPX/9wpqxwjRFjsBfQXECu9PNnno2qJfYly6WydeXKWhV
Qp6qf6KeOXtFH6ueUMEyzm39waZSwfHCN/gFHvCBa7/JwL6tHi0M2nBibKP5
Zi3l5B8yFqxoZ3MWFvMjttxnITZOgXuXaqjgiU2gfZqKDWoDK+rvy3Rar6Hq
Le6rhfHtLNTB7cK3GXXMT153dAJfRxmJXs9LXslZsLGTe93rKmYv/6B0TH43
eZpGp9d+ksvE+oKiuXcOskP8v5fs6O+l+MmWK88mtg7pVYqXhvrkP9STMEli
XpqupbTNKwOvtNXQ7ZRjBWZlKo4XeUQO4RN8g1/gAR+4hEt47s+imxn0Y8uY
dhehjmKX2q9xLZSwRZ03n4XwRUzyT4LsZm0PnfPK8E+1uEHbQza+/51lBd09
l19UG9VLlX8WRwTHqYa0gWaMq59sJ9SQw8YxwfXJOmIGubHBainxnjvarrvY
Rm+8g6btbdVTnFGylVz9Nq+CWU+vftdEe964XLbWd9OpDQ8kO1wb6OXL1qpV
0Q0cL3qGfiF/yCNyCJ/gG/wCD/jAlRfhKzHdVM/pqDlRLEnWQ1GdIXOv1ajI
I3eZVV1uG5n2KQWvU1RkedD1D94kLZl7ycfzxiooomF09cZJzaTrt3avNOmi
DKks5lVVCyVZ17dNFcjIUuyc3N/WNaRycosNyzMZJiPrb34K9jrQRdW5sfzQ
o00UbX+87zC/mePFfmA30Cv0DP1C/pBH5BA+wTf4BR7wgasp+PLIw791cLoz
28/3SqSc1O1NAekdago5vlkis1BRnt30cKP1TeTjcKHG46CGGg1Mly0SKej0
iHv+in3NtDastrbaV0mBI2JinpVIafh4b1b8i5Y6ZqXcmpegYoqE56GOBVJm
nCS26uhRc7zYRewh9gL7gd1Ar9Az9Av5Qx6RQ/gE3+AXeMAHrl3l10XvaVSc
uuaMTJB93UrmZgYOm0wukae2LOqkbTktFmw65VvYSyeTDP0ar6lZr6bKJctc
yeYF2rhVC1oouvipKPxnHTs9pa8la5SSBVmNMq+oFnO82HvsPHYQu4g9xF5g
P7Ab6BV6hn4hf8gjcgif4Bv8Ag/4wCVR8j4vSe9gUI1RxaxIoZxuL/xsTKKt
hu3c3dvbt7yDTQzRlxcEi2n37mmChQ80LHKYY0l8cjtLrlx94NY4KceLdwzv
F/Yde4+d53YQuzi0h9gL7Ad2A71Cz9Av5A95RA7hE3yDX+ABH7iiQsUHho/u
ZNBEb+c7Ip8m8s0yO3vio/t0XTD73vZdUlpTEzT3ZY6e48X7jHcZ7xbeMbxf
2HfsPXYeO4hdxB5iL7Af2A30Cj1Dv5A/5BE5hE/wDX6BB3zgKnOcQYbaTk6P
POoq9RhRT/8CpKWYNg==
        "]],
      Axes->True,
      BoxRatios->{1, 1, 0.4},
      Method->{"RotationControl" -> "Globe"},
      PlotRange->{{0., 3.}, {0., 3.}, Automatic},
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02], 
        Scaled[0.02]}], 
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFXQd0U0ezNrZlO3QCPzWU0Am9hBrYS2ihQ0INoYSWBDAQaugOvfcWAiR0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       "], {{
         {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFnQXUFtXXxeeZnhdULFQMxMZAMRAMMLADxe4CLBTs7sIu7MYCMRETExQR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             "]], Polygon3DBox[CompressedData["
1:eJw1nAncVdP3xs+594yvBikNmqMBGRJKCaUSGStDxibKnAZKIpUoUzI1CA00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             "]], Polygon3DBox[CompressedData["
1:eJwt1nm0VlUZx/ED931572XMmBZgMSMoBaRLWYHIFKMMIWIBMikzwop5lEFG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             "]], 
            Polygon3DBox[{{1835, 1928, 1213, 1419, 2433, 1834}, {2417, 1835, 
             1834, 2416, 1293, 1294}, {2008, 2007, 1324, 1105, 1106, 1325}, {
             2133, 2403, 1230, 1106, 1105, 1456}}]}]}, {}, {}, {}}, {
         Line3DBox[{898, 1, 780, 308, 1730, 16, 1744, 31, 1756, 46, 1765, 61, 
          1773, 76, 1788, 91, 1803, 106, 1819, 1820, 121, 1840, 136, 1846, 
          151, 1852, 166, 1858, 181, 1871, 196, 2168, 504, 924, 211, 897, 546,
           1130, 212, 507, 926, 213, 885, 509, 1703, 928, 214, 887, 511, 215, 
          1131, 216, 1132, 217, 1506, 515, 771, 218, 1610, 694, 517, 773, 
          1133, 219, 890, 519, 1134, 220, 1135, 221, 1136, 222, 1512, 523, 
          776, 223, 699, 525, 778, 224, 1514, 527, 779, 225, 701, 526, 1892, 
          210, 689, 501, 762, 195, 680, 480, 1869, 180, 1856, 165, 1850, 150, 
          2109, 424, 736, 135, 2245, 642, 405, 728, 1838, 120, 638, 387, 1816,
           105, 1801, 90, 1786, 75, 347, 725, 60, 795, 2035, 331, 716, 45, 
          896, 532, 30, 2019, 310, 899, 15, 895, 528, 1013, 14, 1011, 13, 
          1009, 12, 1007, 11, 1005, 10, 1003, 9, 1000, 999, 8, 997, 7, 995, 6,
           993, 5, 991, 4, 989, 3, 987, 2, 1338, 307, 898}], {
          Line3DBox[{1730, 1956, 1137, 1729, 1957, 2552, 1893, 1731, 2497, 
           1894, 1732, 2498, 1895, 1733, 2499, 1896, 1734, 2500, 1897, 1735, 
           2501, 1898, 1736, 2502, 2364, 2450, 1737, 2503, 1899, 1738, 2504, 
           1900, 1739, 2505, 1901, 1740, 2506, 1902, 1741, 2507, 1903, 1742, 
           2426, 2562, 1904, 2019}], 
          Line3DBox[{1744, 1958, 2365, 2451, 1743, 1959, 1152, 1745, 2508, 
           1905, 1746, 2509, 1906, 1747, 2510, 1907, 1748, 2511, 1908, 1749, 
           2512, 1909, 1750, 2513, 2366, 2452, 1751, 2367, 2453, 1752, 2020, 
           2173, 2563, 1910, 1753, 2022, 2174, 2564, 1911, 1754, 2427, 2604, 
           2175, 1912, 2351, 933, 2024, 704, 2188, 2622, 782, 2025, 706, 
           896}], Line3DBox[{1756, 2368, 2454, 1755, 2369, 2455, 1757, 1165, 
           1758, 2514, 1913, 1759, 2515, 1914, 1760, 2516, 1915, 1761, 2517, 
           1916, 1762, 2518, 2026, 2176, 2370, 2456, 1763, 2027, 2028, 2371, 
           2629, 2352, 2353, 2021, 2029, 2445, 2620, 2264, 2189, 2242, 2023, 
           2030, 2565, 2265, 2266, 2190, 2243, 2428, 2616, 2032, 2267, 2293, 
           2268, 2031, 2294, 2295, 1960, 2034, 2269, 2296, 2270, 2033, 1651, 
           2297, 1961, 2036, 2271, 2298, 2272, 2035}], 
          Line3DBox[{1765, 2372, 2457, 1764, 2373, 2458, 1766, 2374, 2459, 
           1767, 1175, 1768, 2519, 1917, 1769, 2520, 1918, 1770, 2521, 333, 
           1771, 2522, 322, 1363, 335, 232, 799, 1365, 337, 801, 233, 1656, 
           804, 339, 806, 234, 1657, 808, 341, 810, 1659, 235, 945, 343, 814, 
           236, 345, 1367, 237, 347}], 
          Line3DBox[{1773, 2375, 2460, 1772, 2376, 2461, 1774, 2377, 2462, 
           1775, 2378, 2463, 1776, 1184, 1777, 2523, 2047, 2048, 1778, 2566, 
           1962, 2037, 1963, 1779, 2567, 1964, 2038, 1965, 2302, 2301, 2623, 
           1780, 2299, 2303, 1966, 2039, 1967, 2354, 2464, 2446, 1781, 2209, 
           2304, 1968, 2040, 1969, 2465, 2273, 1782, 2300, 1970, 2041, 2621, 
           2405, 2274, 1783, 2406, 2553, 2042, 1971, 1784, 2524, 2043, 2177, 
           2044, 1785, 2525, 2045, 2178, 2046, 1786}], 
          Line3DBox[{1788, 2379, 2466, 1787, 2380, 2467, 1789, 2381, 2468, 
           1790, 2382, 2469, 1791, 2430, 2569, 2055, 1792, 1267, 2049, 1972, 
           1793, 2570, 1973, 2050, 1974, 1794, 2571, 583, 2051, 1975, 2470, 
           1795, 1976, 2052, 1977, 2471, 1796, 1978, 2053, 2568, 2407, 1797, 
           2054, 2179, 2605, 2429, 1798, 2383, 2472, 1799, 2384, 2473, 1800, 
           2526, 2061, 2062, 1801}], 
          Line3DBox[{1803, 2385, 2474, 1802, 2386, 2475, 1804, 2387, 2476, 
           1805, 2064, 2573, 2065, 1806, 2408, 2554, 2056, 1979, 1807, 2409, 
           2555, 2057, 1980, 1808, 1552, 2210, 2058, 1981, 1809, 2574, 1982, 
           2059, 1983, 2477, 1810, 1984, 2060, 2572, 2410, 1811, 2388, 2478, 
           1812, 2389, 2479, 1813, 2390, 2480, 1814, 2431, 2576, 2070, 1815, 
           1284, 2063, 2306, 2305, 1816}], 
          Line3DBox[{1820, 2527, 1919, 1818, 2528, 1920, 1822, 2074, 2578, 
           1921, 2180, 2077, 2079, 1922, 2078, 2307, 2580, 2447, 2081, 2195, 
           1923, 2080, 2412, 2581, 2083, 1924, 2082, 2414, 2582, 2085, 1925, 
           2084, 2529, 1988, 1210, 1829, 2530, 1926, 1831, 2531, 1927, 1833, 
           2087, 2088, 2584, 1928, 1835, 2417, 2585, 2090, 1929, 2089, 2213, 
           2244, 2214, 2092, 2196, 2276, 1930, 2091, 2443, 2617, 2246, 2218, 
           2093, 2197, 2342, 1931, 2245}], 
          Line3DBox[{1838, 2216, 2275, 2217, 2072, 2215, 2355, 2613, 2442, 
           1837, 2308, 2309, 2071, 2559, 2418, 1836, 1989, 2558, 2416, 1834, 
           2433, 2583, 2086, 1832, 2484, 2394, 1830, 2483, 2393, 1828, 2415, 
           2575, 2069, 1290, 1827, 1987, 2068, 2557, 2413, 1826, 1986, 2067, 
           2212, 2612, 2211, 1825, 1985, 2066, 2556, 2411, 1824, 2076, 2579, 
           2075, 1823, 2432, 2577, 2073, 1821, 2482, 2392, 1817, 2481, 2391, 
           1819}], Line3DBox[{1840, 2395, 2485, 1839, 2532, 1932, 1841, 2094, 
           2344, 2586, 1933, 2095, 2313, 2314, 2096, 2310, 1934, 2356, 2311, 
           2312, 2624, 2098, 2315, 1935, 2097, 2419, 2587, 2100, 1936, 2099, 
           2533, 1990, 1937, 1842, 2534, 2396, 2486, 1843, 1219, 1844, 2101, 
           2103, 2588, 1938, 2102, 2316, 2318, 2317, 2105, 2560, 2198, 2277, 
           1939, 2104, 2219, 2248, 2220, 2618, 2106, 2199, 2278, 1940, 2247, 
           2221, 2249, 2222, 2108, 2200, 2343, 1941, 2107, 2625, 2319, 2320, 
           2110, 1942, 2109}], 
          Line3DBox[{1846, 2397, 2487, 1845, 2111, 2398, 2606, 2181, 2112, 
           2191, 2589, 2321, 2360, 2322, 2113, 2323, 1991, 2327, 2324, 2325, 
           2114, 2326, 2420, 2626, 2116, 1943, 2115, 2535, 1992, 1944, 1847, 
           2536, 1945, 1848, 2537, 2399, 2488, 1849, 2117, 2119, 2400, 2590, 
           2118, 2329, 1993, 2357, 1535, 2328, 2201, 2120, 2223, 2250, 1994, 
           2253, 2619, 2202, 2251, 2203, 2121, 2224, 2252, 2421, 2614, 2123, 
           2204, 2205, 2122, 2538, 1995, 2182, 1946, 2124, 2539, 1996, 1947, 
           1850}], Line3DBox[{1852, 2401, 2489, 1851, 2126, 2402, 2607, 2183, 
           2254, 2127, 2192, 2448, 2627, 2330, 2128, 2331, 1997, 2335, 2332, 
           2333, 2129, 2334, 2540, 1998, 2131, 1948, 2184, 2541, 2130, 1949, 
           1853, 2542, 1950, 1854, 2543, 2133, 2403, 2591, 2134, 2337, 1999, 
           2359, 2206, 2610, 2440, 2135, 2225, 2000, 2258, 2441, 2611, 2256, 
           2207, 2136, 2226, 2257, 2001, 2138, 1542, 2208, 2137, 2544, 2002, 
           2185, 1951, 2140, 2545, 2125, 1952, 1855, 2546, 2142, 2143, 1953, 
           1856}], Line3DBox[{1858, 2404, 2490, 1857, 2145, 2146, 2491, 1859, 
           2147, 2193, 2148, 2492, 2260, 2345, 2279, 2003, 2358, 2004, 2336, 
           1860, 2593, 2005, 2132, 2006, 1861, 2547, 1954, 1862, 2548, 1955, 
           1863, 2549, 2007, 2008, 2493, 1864, 2227, 2009, 2255, 2010, 2261, 
           2494, 2444, 2280, 2228, 2262, 2011, 2259, 2012, 2495, 2229, 1865, 
           2230, 2013, 2139, 2592, 2422, 1866, 1462, 2186, 2141, 1867, 2550, 
           2152, 2153, 1868, 2595, 2014, 2144, 2015, 2339, 2338, 1869}], 
          Line3DBox[{1871, 2362, 2363, 2496, 1870, 985, 2346, 920, 921, 754, 
           860, 1680, 755, 922, 756, 964, 863, 1872, 2435, 2596, 2156, 1873, 
           1240, 1874, 2551, 2158, 2159, 1875, 2597, 2016, 2149, 619, 1637, 
           757, 620, 679, 621, 1638, 758, 623, 2150, 2594, 2423, 1876, 2151, 
           2187, 2608, 2434, 1877, 2436, 2600, 2163, 1878, 1333, 2154, 759, 
           760, 1639, 624, 681, 625, 762}], 
          Line3DBox[{1892, 2282, 2347, 2283, 2166, 2241, 2263, 1586, 1891, 
           2239, 2281, 2240, 2165, 2238, 2341, 2237, 1890, 2291, 2292, 2164, 
           2561, 2425, 1889, 2439, 2603, 2172, 1888, 2424, 2599, 2162, 2018, 
           1887, 2449, 2598, 2340, 2161, 2236, 2235, 1886, 2615, 2233, 2234, 
           2160, 2232, 2231, 2628, 1885, 2349, 2350, 2348, 2361, 1725, 1884, 
           2171, 2602, 2438, 1883, 2170, 2601, 2437, 1882, 2017, 2157, 2290, 
           2289, 1881, 2288, 1640, 2155, 2287, 2286, 1880, 2284, 2609, 2285, 
           2194, 2169, 1879, 1497, 2167, 2168}]}, {
          Line3DBox[{987, 1251, 1138, 2552, 988, 1253, 1152, 1016, 2455, 1164,
            1028, 2458, 1173, 1037, 2461, 1181, 1045, 2467, 1190, 1057, 2475, 
           1200, 1067, 2482, 1208, 2528, 1076, 1215, 2532, 1084, 1435, 1520, 
           2606, 1222, 1092, 1447, 1522, 2607, 1228, 1101, 1467, 2491, 1525, 
           1233, 1111, 920, 977, 869, 1122, 2609, 765, 1498, 767, 926}], 
          Line3DBox[{989, 1139, 2497, 990, 1153, 2508, 1017, 1165, 1029, 2459,
            1174, 1038, 2462, 1182, 1046, 2468, 1191, 1058, 2476, 1201, 1068, 
           2577, 1411, 1519, 1209, 2578, 1077, 1423, 1424, 1216, 2586, 1085, 
           1702, 1724, 1436, 1723, 1670, 2589, 1671, 1093, 1599, 1448, 1449, 
           2627, 1675, 1676, 1102, 1604, 1468, 2492, 1469, 1678, 1718, 1679, 
           1112, 1636, 1680, 1330, 1482, 1684, 1686, 1685, 1123, 1640, 1687, 
           1334, 1499, 1641, 1692, 1642, 1703}], 
          Line3DBox[{991, 1140, 2498, 992, 1154, 2509, 1018, 1166, 2514, 1030,
            1175, 1039, 2463, 1183, 1047, 2469, 1192, 1059, 2573, 375, 1069, 
           2579, 390, 2079, 392, 262, 953, 2096, 410, 831, 270, 2327, 845, 
           430, 846, 278, 2335, 854, 448, 960, 2358, 284, 862, 468, 964, 292, 
           487, 2157, 299, 511}], 
          Line3DBox[{993, 1141, 2499, 994, 1155, 2510, 1019, 1167, 2515, 1031,
            1176, 2519, 1040, 1184, 1048, 2569, 1385, 1386, 1388, 2554, 1275, 
           1399, 1276, 1401, 2556, 1285, 1412, 1286, 1714, 1663, 2580, 1414, 
           1626, 1715, 1296, 1425, 1297, 1665, 2624, 1664, 1427, 1562, 1716, 
           1305, 1437, 1306, 2626, 1672, 1439, 1630, 1316, 1450, 2540, 1317, 
           1677, 1453, 1322, 2593, 1470, 1323, 1113, 2596, 1483, 1526, 1484, 
           1124, 2601, 1500, 1527, 1501, 1131}], 
          Line3DBox[{995, 1142, 2500, 996, 1156, 2511, 1020, 1168, 2516, 1032,
            1177, 2520, 1041, 1372, 2523, 1373, 1375, 1267, 1387, 1268, 1390, 
           2555, 1277, 1400, 1278, 1403, 2612, 585, 1413, 1287, 2581, 1416, 
           1298, 1426, 1299, 2587, 1429, 1307, 1438, 2535, 1308, 1094, 1451, 
           1523, 2541, 1452, 1103, 1234, 2547, 1114, 1240, 1125, 2602, 1502, 
           1503, 1132}], 
          Line3DBox[{997, 1143, 2501, 998, 1157, 2512, 1021, 1169, 2517, 1033,
            1360, 2521, 1361, 1362, 1259, 2566, 1374, 1260, 1377, 1269, 2570, 
           1389, 1270, 1392, 1552, 1553, 1402, 1279, 1405, 2557, 1288, 1415, 
           1289, 2582, 1418, 1300, 1428, 2533, 1301, 1086, 1223, 2536, 1095, 
           1229, 2542, 1104, 1235, 2548, 1115, 1485, 2551, 1486, 1704, 1725, 
           1726, 1504, 1694, 1693, 1506}], 
          Line3DBox[{999, 1144, 2502, 1001, 1158, 2513, 1022, 1351, 2518, 
           1353, 1516, 1354, 2522, 1356, 1364, 1261, 2567, 1376, 1262, 1379, 
           1550, 2571, 1551, 1391, 1272, 1394, 1280, 2574, 1404, 1282, 1407, 
           1290, 1417, 2529, 1292, 1078, 1217, 2534, 1087, 1224, 2537, 1096, 
           1454, 2543, 1456, 1105, 1324, 2549, 1326, 1472, 1331, 2597, 1487, 
           1689, 1688, 1489, 1580, 2628, 1705, 1581, 1505, 1585, 1609, 1584, 
           1610}], 
          Line3DBox[{1003, 1146, 2503, 1004, 2453, 1160, 1024, 1357, 1708, 
           2629, 1171, 1035, 1654, 1655, 1365, 1617, 1179, 1043, 1618, 1619, 
           2464, 1380, 1662, 1186, 1050, 1273, 2471, 1395, 1194, 1061, 2572, 
           1283, 1203, 1071, 2483, 1211, 2530, 1080, 1219, 1089, 1440, 1441, 
           2590, 1226, 1098, 1631, 1633, 1632, 1458, 2610, 1539, 1600, 1231, 
           1107, 1569, 1635, 1570, 2494, 1473, 1544, 1605, 1237, 1117, 1574, 
           1638, 1575, 1490, 1548, 1719, 1242, 1127, 2598, 1690, 1691, 1508, 
           1247, 1134}], 
          Line3DBox[{1005, 1147, 2504, 1006, 1341, 1161, 2563, 1025, 1342, 
           1529, 2620, 1611, 1612, 1698, 1613, 1254, 1656, 1620, 1621, 1700, 
           1622, 1263, 2465, 1381, 1187, 1051, 2568, 1274, 1195, 1062, 2478, 
           1204, 1072, 2484, 1212, 2531, 1081, 1430, 1431, 1220, 2588, 1090, 
           1673, 1309, 1674, 1535, 1717, 1536, 1628, 1566, 1594, 1318, 1601, 
           2611, 1540, 1602, 1541, 1634, 1571, 1603, 1327, 2495, 1474, 1545, 
           1546, 1118, 2594, 1332, 1491, 1243, 1128, 2599, 1335, 1248, 1135}],
           Line3DBox[{1007, 1148, 2505, 1008, 1343, 1162, 2564, 1026, 1588, 
           1344, 1530, 1614, 2565, 1615, 1699, 1616, 1255, 1657, 1623, 1624, 
           1701, 1625, 2621, 1264, 1382, 1188, 1052, 2605, 1384, 1196, 1063, 
           2479, 1205, 1073, 2583, 1419, 1213, 2584, 1082, 1666, 1302, 1667, 
           1533, 2560, 1534, 1627, 1563, 1310, 1595, 1537, 2619, 1597, 1538, 
           1629, 1567, 1598, 1319, 1459, 1542, 1543, 1108, 2592, 1328, 1475, 
           1238, 1119, 2608, 1477, 1244, 1129, 2603, 1509, 1510, 1249, 1136}],
           Line3DBox[{1009, 1149, 2506, 1010, 1345, 1346, 2604, 1515, 1347, 
           1531, 1348, 2616, 1589, 1358, 1649, 1256, 1659, 1257, 1658, 1366, 
           2553, 1265, 1383, 1266, 1053, 2472, 1197, 1064, 2480, 1206, 1074, 
           2558, 1293, 1294, 2585, 1421, 1558, 1303, 1591, 1304, 1592, 2618, 
           1559, 1432, 1564, 1593, 1311, 1596, 1312, 2614, 1565, 1443, 1568, 
           1320, 1460, 2544, 1321, 1524, 1462, 1476, 1463, 1120, 2600, 1492, 
           1493, 1495, 2561, 1336, 1511, 1337, 1721, 1695, 1512}], 
          Line3DBox[{1011, 1150, 2507, 1012, 1349, 1706, 933, 934, 781, 789, 
           2295, 788, 941, 794, 814, 813, 1517, 1368, 2524, 1369, 1054, 2473, 
           1198, 1065, 2576, 1408, 1409, 1410, 2559, 1295, 1420, 586, 2244, 
           640, 593, 648, 595, 2249, 653, 604, 1442, 2538, 1313, 1521, 1445, 
           1461, 2545, 1446, 1109, 1478, 2550, 1479, 1481, 1333, 1494, 879, 
           880, 2341, 631, 697, 633, 699}], 
          Line3DBox[{1013, 1339, 1340, 2562, 1014, 1350, 1528, 1646, 2622, 
           1645, 1707, 1647, 1648, 1359, 1651, 1650, 1709, 1652, 1653, 1367, 
           1258, 1518, 1370, 2525, 1371, 1055, 1396, 2526, 1397, 1398, 1284, 
           1710, 1712, 1711, 1713, 2613, 1554, 1555, 1422, 1557, 1556, 2617, 
           1590, 1560, 1561, 1433, 1669, 2625, 1668, 1434, 1314, 1444, 2539, 
           1315, 1099, 1464, 2546, 1465, 1466, 1329, 2595, 1480, 1682, 1681, 
           1683, 1576, 1639, 1577, 1496, 1579, 1607, 1578, 1608, 1586, 1644, 
           1587, 1513, 1697, 1722, 1696, 1514}], 
          Line3DBox[{1130, 1245, 1497, 1121, 1239, 1728, 2496, 1727, 1110, 
           1232, 2490, 1100, 1227, 2489, 1091, 1221, 2487, 1083, 1214, 2485, 
           1075, 2527, 1207, 2481, 1066, 1199, 2474, 1056, 1189, 2466, 1044, 
           1180, 2460, 1036, 1172, 2457, 1027, 1163, 2454, 1015, 1151, 2451, 
           1252, 986, 1137, 1250, 1338}], 
          Line3DBox[{1133, 1246, 1720, 1549, 1507, 1583, 1643, 2615, 1582, 
           1126, 1241, 1606, 1547, 1488, 1573, 1637, 1572, 1116, 1236, 1471, 
           2493, 1325, 1106, 1230, 2591, 1457, 1455, 1097, 1225, 2488, 1088, 
           1218, 2486, 1079, 1210, 1291, 2575, 1070, 1202, 1406, 2477, 1281, 
           1060, 1193, 1393, 2470, 1271, 1049, 1185, 1532, 1378, 1661, 2623, 
           1660, 1042, 1178, 1363, 1355, 1034, 1170, 2456, 1352, 1023, 1159, 
           2452, 1002, 1145, 2450, 1000}]}, {}, {}}},
       VertexNormals->CompressedData["
1:eJx0vHc81f/7P25rqZRSKlpEU0PRukK0VEiloRLR1DBKkyZFklASiqyQvfXI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        "]],
      Axes->True,
      BoxRatios->{1, 1, 0.4},
      Method->{"RotationControl" -> "Globe"},
      PlotRange->{{0, 3}, {0, 3}, {-0.999995929152416, 0.999992657739563}},
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02], 
        Scaled[0.02]}]}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 CellLabel->"Out[1]=",
 CellID->1578517698]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["$PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PerformanceGoal"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->270268465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"Plot3D", ",", "PerformanceGoal"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95146561],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PerformanceGoal", "\[RuleDelayed]", "$PerformanceGoal"}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->927053636]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PerformanceGoal"]], "InlineFormula"],
 " is effectively ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"], "[", 
   RowBox[{"\"\<Speed\>\"", ",", "\"\<Quality\>\""}], "]"}]], 
  "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->72615382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$ControlActiveSetting", "=", "True"}], "}"}], ",", 
     "$PerformanceGoal"}], "]"}], ",", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$ControlActiveSetting", "=", "False"}], "}"}], ",", 
     "$PerformanceGoal"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->548203510],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Speed\"\>", ",", "\<\"Quality\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->91534706]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$ControlActiveSetting", "=", "True"}], "}"}], ",", 
     RowBox[{"ControlActive", "[", 
      RowBox[{"\"\<Speed\>\"", ",", "\"\<Quality\>\""}], "]"}]}], "]"}], ",", 
   
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$ControlActiveSetting", "=", "False"}], "}"}], ",", 
     RowBox[{"ControlActive", "[", 
      RowBox[{"\"\<Speed\>\"", ",", "\"\<Quality\>\""}], "]"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17542859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Speed\"\>", ",", "\<\"Quality\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->197794617]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxRecursion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxRecursion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StepMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StepMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->7064865],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->634413363],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->146733253],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->32396992],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->9837816]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PerformanceGoal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 27.1950384}", "context" -> "System`", 
    "keywords" -> {
     "objective goal", "optimization for accuracy", "optimization for speed", 
      "optimization goal", "quality goal", "quality target", 
      "speed accuracy objective", "speed accuracy trade-off"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PerformanceGoal is an option for plotting and various other algorithmic \
functions that specifies what aspect of performance to try to optimize with \
Automatic settings for options.", "synonyms" -> {"performance goal"}, "title" -> 
    "PerformanceGoal", "type" -> "Symbol", "uri" -> "ref/PerformanceGoal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7553, 223, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->608396707]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 157925, 2858}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2411, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3034, 81, 1580, 37, 70, "ObjectNameGrid"],
Cell[4617, 120, 706, 20, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5360, 145, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5838, 162, 579, 18, 70, "Notes",
 CellID->73140546],
Cell[6420, 182, 221, 8, 70, "Notes",
 CellID->1067943069],
Cell[6644, 192, 502, 11, 70, "2ColumnTableMod",
 CellID->145081921],
Cell[7149, 205, 367, 13, 70, "Notes",
 CellID->408422148]
}, Closed]],
Cell[CellGroupData[{
Cell[7553, 223, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->608396707],
Cell[CellGroupData[{
Cell[7938, 237, 148, 5, 70, "ExampleSection",
 CellID->337060715],
Cell[8089, 244, 379, 12, 70, "ExampleText",
 CellID->2130497847],
Cell[CellGroupData[{
Cell[8493, 260, 453, 14, 28, "Input",
 CellID->134984451],
Cell[8949, 276, 1579, 34, 256, "Output",
 CellID->1265242980]
}, Open  ]],
Cell[10543, 313, 125, 3, 70, "ExampleDelimiter",
 CellID->555692266],
Cell[10671, 318, 237, 8, 70, "ExampleText",
 CellID->261901143],
Cell[CellGroupData[{
Cell[10933, 330, 711, 21, 70, "Input",
 CellID->943620434],
Cell[11647, 353, 139309, 2255, 70, "Output",
 CellID->1578517698]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[151005, 2614, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[151246, 2623, 360, 13, 70, "ExampleText",
 CellID->270268465],
Cell[CellGroupData[{
Cell[151631, 2640, 144, 4, 70, "Input",
 CellID->95146561],
Cell[151778, 2646, 161, 5, 70, "Output",
 CellID->927053636]
}, Open  ]],
Cell[151954, 2654, 428, 15, 70, "ExampleText",
 CellID->72615382],
Cell[CellGroupData[{
Cell[152407, 2673, 426, 14, 70, "Input",
 CellID->548203510],
Cell[152836, 2689, 141, 4, 70, "Output",
 CellID->91534706]
}, Open  ]],
Cell[CellGroupData[{
Cell[153014, 2698, 582, 18, 70, "Input",
 CellID->17542859],
Cell[153599, 2718, 142, 4, 70, "Output",
 CellID->197794617]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[153802, 2729, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[154121, 2740, 1228, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[155386, 2789, 299, 8, 70, "MoreAboutSection"],
Cell[155688, 2799, 141, 3, 70, "MoreAbout",
 CellID->7064865],
Cell[155832, 2804, 173, 3, 70, "MoreAbout",
 CellID->634413363],
Cell[156008, 2809, 148, 3, 70, "MoreAbout",
 CellID->146733253],
Cell[156159, 2814, 196, 4, 70, "MoreAbout",
 CellID->32396992],
Cell[156358, 2820, 177, 3, 70, "MoreAbout",
 CellID->9837816]
}, Open  ]],
Cell[156550, 2826, 27, 0, 70, "History"],
Cell[156580, 2828, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

