(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21214,        780]
NotebookOptionsPosition[     16825,        631]
NotebookOutlinePosition[     18201,        669]
CellTagsIndexPosition[     18116,        664]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ConstructingLists"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Constructing Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cases" :> Documentation`HelpLookup["paclet:ref/Cases"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"], "Position" :> 
          Documentation`HelpLookup["paclet:ref/Position"], "Boole" :> 
          Documentation`HelpLookup["paclet:ref/Boole"], "ListConvolve" :> 
          Documentation`HelpLookup["paclet:ref/ListConvolve"], "Select" :> 
          Documentation`HelpLookup["paclet:ref/Select"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cases\"\>", 2->"\<\"Part\"\>", 
       3->"\<\"Position\"\>", 4->"\<\"Boole\"\>", 5->"\<\"ListConvolve\"\>", 
       6->"\<\"Select\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Elements of Lists\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pick", "ObjectName",
 CellID->21263],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Pick",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Pick"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["sel", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]picks out those elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " for which the corresponding element of ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Pick",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Pick"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["sel", "TI"], ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]picks out those elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " for which the corresponding element of ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"],
     " matches ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " can be a nested list of any depth. "
}], "Notes",
 CellID->23458],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pick",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pick"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["sel", "TI"], ",", 
    StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
 " picks out those ",
 Cell[BoxData[
  RowBox[{
   StyleBox["list", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  RowBox[{
   StyleBox["sel", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 " matches ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9594],

Cell[TextData[{
 "Depending on the arrangement of elements matching ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 " in a nested list ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Pick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pick"]], "InlineFormula"],
 " may return a ragged array. "
}], "Notes",
 CellID->27371],

Cell[TextData[{
 "The heads in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " do not have to be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17945],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Pick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pick"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->13502]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19556333],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->408407584],

Cell["\<\
Pick out elements wherever a 1 appears in the \[OpenCurlyDoubleQuote]selector\
\[CloseCurlyDoubleQuote] list:\
\>", "ExampleText",
 CellID->307972453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pick", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196982906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "c"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172601701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->285143650],

Cell["Pick out elements from a 2D array:", "ExampleText",
 CellID->106834209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pick", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->490998796],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30617476]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13335],

Cell[TextData[{
 "Pick out elements wherever ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " appears in the ",
 "\[OpenCurlyDoubleQuote]selector\[CloseCurlyDoubleQuote]",
 " list:"
}], "ExampleText",
 CellID->169800848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pick", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "False", ",", "True"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87645302],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "d"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193129949]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28592],

Cell["The data does not have to be a list:", "ExampleText",
 CellID->291358052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pick", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}], 
   ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->757974756],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "3", ",", "5", ",", "6"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217221514]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22336],

Cell["\<\
The \[OpenCurlyDoubleQuote]selector\[CloseCurlyDoubleQuote] list has to have \
the same length and structure as the data:\
\>", "ExampleText",
 CellID->754478687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pick", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "False"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->663914333],

Cell[BoxData[
 RowBox[{
  RowBox[{"Pick", "::", "\<\"incomp\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Expressions \\\\\\\"\\\", \\\"MSG\\\
\"]\\)\\!\\({a, b, c, d}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" and \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\({True, False}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" have \
incompatible shapes.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/Pick/incomp\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->5500770],

Cell[BoxData[
 RowBox[{"Pick", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "False"}], "}"}]}], "]"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20121856]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15760],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Select",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Select"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3586]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8246],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstructingLists"]], "Tutorials",
 CellID->20420]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Pick",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Pick"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->227492444],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->22063582],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->63422388]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pick - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 29.1794642}", "context" -> "System`", 
    "keywords" -> {"masking", "pick elements", "compress in APL"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Pick[list, sel] picks out those elements of list for which the \
corresponding element of sel is True. Pick[list, sel, patt] picks out those \
elements of list for which the corresponding element of sel matches patt. ", 
    "synonyms" -> {}, "title" -> "Pick", "type" -> "Symbol", "uri" -> 
    "ref/Pick"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7271, 253, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19556333]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17974, 657}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2299, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2922, 80, 42, 1, 70, "ObjectName",
 CellID->21263],
Cell[2967, 83, 1512, 49, 70, "Usage",
 CellID->16461]
}, Open  ]],
Cell[CellGroupData[{
Cell[4516, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4994, 154, 143, 5, 70, "Notes",
 CellID->23458],
Cell[5140, 161, 1051, 41, 70, "Notes",
 CellID->9594],
Cell[6194, 204, 391, 14, 70, "Notes",
 CellID->27371],
Cell[6588, 220, 332, 14, 70, "Notes",
 CellID->17945],
Cell[6923, 236, 311, 12, 70, "Notes",
 CellID->13502]
}, Closed]],
Cell[CellGroupData[{
Cell[7271, 253, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19556333],
Cell[CellGroupData[{
Cell[7655, 267, 148, 5, 70, "ExampleSection",
 CellID->408407584],
Cell[7806, 274, 160, 4, 70, "ExampleText",
 CellID->307972453],
Cell[CellGroupData[{
Cell[7991, 282, 294, 9, 28, "Input",
 CellID->196982906],
Cell[8288, 293, 203, 7, 36, "Output",
 CellID->172601701]
}, Open  ]],
Cell[8506, 303, 125, 3, 70, "ExampleDelimiter",
 CellID->285143650],
Cell[8634, 308, 77, 1, 70, "ExampleText",
 CellID->106834209],
Cell[CellGroupData[{
Cell[8736, 313, 486, 17, 70, "Input",
 CellID->490998796],
Cell[9225, 332, 275, 10, 36, "Output",
 CellID->30617476]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9549, 348, 216, 7, 70, "ExampleSection",
 CellID->13335],
Cell[9768, 357, 288, 10, 70, "ExampleText",
 CellID->169800848],
Cell[CellGroupData[{
Cell[10081, 371, 277, 9, 70, "Input",
 CellID->87645302],
Cell[10361, 382, 203, 7, 36, "Output",
 CellID->193129949]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10613, 395, 239, 7, 70, "ExampleSection",
 CellID->28592],
Cell[10855, 404, 79, 1, 70, "ExampleText",
 CellID->291358052],
Cell[CellGroupData[{
Cell[10959, 409, 324, 10, 70, "Input",
 CellID->757974756],
Cell[11286, 421, 228, 7, 36, "Output",
 CellID->217221514]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11563, 434, 226, 7, 70, "ExampleSection",
 CellID->22336],
Cell[11792, 443, 172, 4, 70, "ExampleText",
 CellID->754478687],
Cell[CellGroupData[{
Cell[11989, 451, 248, 8, 70, "Input",
 CellID->663914333],
Cell[12240, 461, 551, 10, 70, "Message",
 CellID->5500770],
Cell[12794, 473, 336, 11, 36, "Output",
 CellID->20121856]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13191, 491, 311, 9, 70, "SeeAlsoSection",
 CellID->15760],
Cell[13505, 502, 1414, 53, 70, "SeeAlso",
 CellID->3586]
}, Open  ]],
Cell[CellGroupData[{
Cell[14956, 560, 313, 9, 70, "TutorialsSection",
 CellID->8246],
Cell[15272, 571, 146, 3, 70, "Tutorials",
 CellID->20420]
}, Open  ]],
Cell[CellGroupData[{
Cell[15455, 579, 305, 8, 70, "RelatedLinksSection"],
Cell[15763, 589, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16148, 605, 319, 9, 70, "MoreAboutSection",
 CellID->227492444],
Cell[16470, 616, 135, 3, 70, "MoreAbout",
 CellID->22063582],
Cell[16608, 621, 143, 3, 70, "MoreAbout",
 CellID->63422388]
}, Open  ]],
Cell[16766, 627, 29, 0, 70, "History"],
Cell[16798, 629, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

