(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    754442,      17018]
NotebookOptionsPosition[    711568,      15510]
NotebookOutlinePosition[    713023,      15550]
CellTagsIndexPosition[    712935,      15545]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Plotting" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicPlotting"], 
          "Labeling Three\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingThreeDimensionalGraphics"], 
          "Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Basic Plotting\"\>", 
       2->"\<\"Labeling Three\[Hyphen]Dimensional Graphics\"\>", 
       3->"\<\"Options for Graphics\"\>", 
       4->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListLinePlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLinePlot"], 
          "ParametricPlot" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot"], "PolarPlot" :> 
          Documentation`HelpLookup["paclet:ref/PolarPlot"], "Plot3D" :> 
          Documentation`HelpLookup["paclet:ref/Plot3D"], "ContourPlot" :> 
          Documentation`HelpLookup["paclet:ref/ContourPlot"], "Graphics" :> 
          Documentation`HelpLookup["paclet:ref/Graphics"], "Show" :> 
          Documentation`HelpLookup["paclet:ref/Show"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ListLinePlot\"\>", 2->"\<\"ParametricPlot\"\>", 
       3->"\<\"PolarPlot\"\>", 4->"\<\"Plot3D\"\>", 5->"\<\"ContourPlot\"\>", 
       6->"\<\"Graphics\"\>", 7->"\<\"Show\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Function Visualization\"\>", 
       2->"\<\"Precollege Education\"\>", 
       3->"\<\"New in 6.0: Function Visualization\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Plot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Plot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Plot"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a plot of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Plot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Plot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several functions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->5984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", " ", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["k", "TI"]]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " plots ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " over a series of segments, potentially breaking the curve at each of the \
",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->27110],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " treats the variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " as local, effectively using ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24417],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and evaluates ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " only after assigning specific numerical values to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->29397],

Cell[TextData[{
 "In some cases it may be more efficient to use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to evaluate ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " symbolically before specific numerical values are assigned to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8125],

Cell[TextData[{
 "No curve is drawn in any regions where ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->41],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->7406],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    RowBox[{"1", "/", 
     ButtonBox["GoldenRatio",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GoldenRatio"]}], Cell[
    "ratio of width to height", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ClippingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ClippingStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "what to draw where curves are clipped ",
     ButtonBox[" \[RightGuillemet]",
      BaseStyle->"ExampleLink",
      ButtonData->252139847]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine the coloring of curves ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale arguments to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate at every function evaluation ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "points in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " to exclude"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ExclusionsStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExclusionsStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what to draw at excluded points ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Filling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Filling"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "filling to insert under each curve ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["FillingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FillingStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style to use for filling ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MaxRecursion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxRecursion"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of recursive subdivisions allowed ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how many mesh points to draw on each curve ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshFunctions"], 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}], Cell[
    "how to determine the placement of mesh points ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshShading",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshShading"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to shade regions between mesh points ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for mesh points ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for refining curves ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PerformanceGoal"], 
    ButtonBox["$PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$PerformanceGoal"], Cell[
    "aspects of performance to try to optimize", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "initial number of sample points ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " or other values to include "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRangeClipping",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangeClipping"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to clip at the plot range ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives to specify the style for each curve ", "TableText"]},
   
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["RegionFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionFunction"], 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], "&"}], ")"}], Cell[
    "how to determine whether a point should be included", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->11410],

Cell[TextData[{
 "Interactive labeling can be specified for curves using ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->28463],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Tooltip",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tooltip"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " specifies that the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be displayed as tooltip labels for the corresponding curves. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->32048],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["label", "TI"]}], "]"}]], "InlineFormula"],
 " specifies an explicit tooltip label for a curve. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->4690],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " initially evaluates ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " at a number of equally spaced sample points specified by ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 ". Then it uses an adaptive algorithm to choose additional sample points, \
subdividing a given interval at most ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " times. "
}], "Notes",
 CellID->4969],

Cell[TextData[{
 "You should realize that with the finite number of sample points used, it is \
possible for ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " to miss features in your function. To check your results, you should try \
increasing the settings for ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5344],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   RowBox[{"Plot", "::", 
    StyleBox["accbend", "TI"]}], "]"}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " print a message if it is unable to reach a certain smoothness of curve."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->40938333],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " will explicitly draw a point at every position on each curve where each \
function was sampled. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->28599],

Cell[TextData[{
 "The arguments supplied to functions in ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ". Functions in ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " are by default supplied with scaled versions of these arguments. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->14643],

Cell["The functions are evaluated all along each curve. ", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->10155],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClippingStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClippingStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " a line is drawn at the top or bottom of the plotting area wherever a curve \
goes outside the range of the plot. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->12464],

Cell[TextData[{
 "With the default settings ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exclusions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exclusions"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExclusionsStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExclusionsStyle"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " breaks curves at discontinuities it detects. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exclusions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exclusions"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " joins across discontinuities."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->131709506],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " normally returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      ButtonBox["Line",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Line"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14537],

Cell[TextData[{
 "With a ",
 Cell[BoxData[
  ButtonBox["Filling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Filling"]], "InlineFormula"],
 " specification given, ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->5558]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->133417416],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->108395154],

Cell["Plot a function:", "ExampleText",
 CellID->8764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"6", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7234],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135272067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14015],

Cell["Plot several functions:", "ExampleText",
 CellID->30118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "x"}], "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13384],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylXPuTVdWVPvZ99ZtX0xJjjHlO/onU1IzlJJZJkcRQ/mBFBbQETYiJoDMt
KhjSMBMSCaICNo3yigiJjWCDsRMIjhSkCMw4MDLgqFAapErKCkTLLqm6+fb+
1l7r3HVv34h2aXPOvWfv863Xt9ZeZ5/+5vS5s279wfS5s2dOv/JrP55+56zZ
M++68l9++GN8VLgky7Id+P+OKRmOqziK/++oVvFv/ncFvwv4qiWchYNq/Mla
cLg+XtHqvimEX0U7z7KSu2I1Py7wn/DTkk4vap7Px/PRD84fPrDhrVOHsvFx
xDvH3zw4uOvo0EvvnT13ebzivb+ePfjS4Nt/PpJNDueVw4fe2vL0y2sHD+K/
jRsO43R09ELWFUdj0MtP78EEmIaI3j17EqPxOxt3EfKGCz4XTkvn/nJ667oZ
B/au3L55DoDyPpULox+OLFi3dcZS3OrFpVs2TfvJ63tfzi6LI945c3zz4A24
KcYdOzKcTYifHth/auGCkauvGvjhnO0PL9+XtQB9Vlq18gDO8em8ucO/G3k1
aw/Xdh4bPoAZ9y0fwuy4x57+X+F+UJFOe+q1/d0f03pXxvMLH45CnqBTesbw
r+diznDYzu9HP3y+bxA4xK52PoXyfzgKMNANznA8tHEWpM4iptLRI2/PnjVE
gYJlKhET5b9+2iZ8Gj8pYDboEDPzHq04H57/yJYnp8Pg+ACOwVt0fSJJXz74
9L7dy6PPx3PghAJNUkB4deRQBE5NzF11av8r4bAXv1qg74Ib1xHvDMlgRggK
cTvjJ6dPn4OEkPvs2feKcQx8AlqzubevuXtoyXzD8vqJvc8P9UWTa7SGWCrn
/s1L9Nlku02PT4OSMt5lZMeCV18ZiSqM54gduGQ45PjR8+9vvmExIoPxE+IJ
4zGLjAcEAAmHbfH85Ml3Z87YihBjRBZgOZwjzAQ1ZsJ8mJVSFTnf7v4NMCB1
BUVBXaqr7FKRhxYBWECOQ+M5vBD+E90qzQ/vD37R6rTY4yzK8XBcuK/JD7ww
C6TIJkYlwByIsW1DR3GGiTBdmRG5dyUC2rTT4tAZ9nobIHgQj2ZZeCooxnQO
A8AMplPzqknueo6HAhlMafze1+FI58+Pis1+vvTFNQ88A/TUUUmvh+/CgwU7
bLr24WuCZRtjv6IqjLv+sanhqrLTJ7GcO30WGgn6Z4SASkFC4TDqMzAq4BtW
6tHG7xw+Buwh8nn/1d96cPBnL9j3UBzUp1FQxs3ePXmGEPfs6gdlNkN/9L+G
Xnxhqd0daoAybHawJjKA2q9Ai4fDCRLPFYeCXgRaQvSGw3jf4luHTmyf8wiz
DGfGbXFzw61+iR9GcjPc5jEVFyMFp/VOevX+V+A0CXdWQIggUGw8TEieFNvD
6+/tez5oPTJ0ST0OLBViuej8LN61jEDDjauRxOk67TURe4Xzq1bRYTH+O7ir
m7LMWAonCYfjkofheo3ICq1KdSAuEZ3Bs6c476JW4ToQhdeSc6P2y4c3jBxY
uYOfU5eGNK/tz1QbcYLzuZDPIHqIekoAl4HjmATGAnF8Wc8BHGQIqv+U8zai
h/7xNWTEGeOK6JXT9PNm6PE1LjL00DzMDa2mvKGM2J2kWXtNX/Adold9c3xJ
7QEeDDz+qTRq/dT7A49H3yiR9yEBEwLjq6TxQ2NkzXCbT0fWK2tmCTab8whC
ihkFBQ1yheE3r2xL86xfux21ESuqUClgSDXFeBHsOL/vObpkRFnWaMEPZ2tr
iPNy559RmpIyIMwElUjEkQHCYVe1lmnIizu2Lll47wMh4ojSOJ7MtGLZ+sEV
MzViSxprTNiZIQyRRg1aRUBkWnXQ/YWBdSbhChgbJjf9AdOdty/e9tTdgoxi
KRIw9pqFffecOP6OIMPMmF9dM2umO/NN1kFQZKjUIocTnc4m6GwE0S3u3zO8
4xDGCTqNbKkUEah/3LcHJAEx6IOYGjcwH2yGz3iW/A/efPXwixgumfftI28M
zVpm6MxnGSvIXgCIQ6ZoiRVjOGIcWHZVIMWYHahDzWJUCGcbAyNHG0ZoaOeq
RcG+Pc6+7c5fyUaoaBCp+F1NGZNcikEYqijL6j34YaUaK0vwdqR/Fv1jIP10
PLeqtzP55xMLr4cOBanZmkiNZ4kUKRWJlVMyc09pZPOKZvVqzBDkIcnoav0s
ZB5DG6KG+rQKhijPvPb/jy++Khz2OJsTJcoVFC25eNh/Cmkn3oHXa0VKrZC7
7HrjV16PVSjIqqr8RF9gLDfTrs3TmbSy9hffAM9I1YegReha5FilToZBMvre
DZvhB2mVpnm6t1ob963O14kbOoZbBB4gblqT3kbcaUWSX92nFb9fnXza3YMy
QfHPrr8z5BPK5Ctjq2M4H8uVCCfFr9Q9HG+rm4qLDV7P1aeel9T2TAscxXvV
rB4rThrfz7jMaZhrPmRPaPhP+9bBn4jPsgZ1DuEgoskHbcO71Vdy7MjxVq/6
OpXXYyXApQzlK9JH6BmUzXdmODAnakNZw+llzvspI5cYrKiI0SoHWaFp1qKM
5BrDbPmpp+F4vwIxv6aMrBcYtZ/Mfo4pZGb6UG8D/QfGoUyaF0RGY8aehna3
1QKvh9FgOkVWZA1HzY0lU6nauA9AWYw9YhYpq1Zxxqiitax6oo6MRRgxYIHr
p20K2iZyy07MmMbx/N6vRODOcOpqYhWJiXPvngGIZpLlJfLnlND1Ecqq42pK
XpTQ5b0cp1BC4xTPg5TQsrvXgM8PtB3zAe8SZVOeTP96eaTirmWPsmoWP1xF
9zo8nMc4hPJg+YH4CBmyzfnaRKcPymMrdl6PhSJK6GQx1gPmFaSLlGEvc95O
5JoR8cO1Ua/zFSK3dVjR3ZlILB6J3NidyG0dlu9NBcnpa1w9UndlxV2vedfV
CT0xrJjUZ3Ma8ixOOaxiIK8Yi/u6h3IYi0hPSnsk7c4jeX8EzLHDz8MGWTMp
XO2dWwcWnN8qz8q6kFJYp5DXG0/7OnOCG+/rD14PzgBzqDXCuu7QM9uhyKZS
+ArdVoO+e+gzYtF9z7vCoeBW6pu56B/vbOkrjnj/VhgC5iBEciX1WGoiA4t8
k8Eq9oKLSMpg/QVfqWklxr6BrDVN05TB+gytzlJR5lblcJzRt6ml2lgmdmMT
Yrf6uuhiktitQ+M74cSu+hPs5uvE7tnVOIHPUjQz4gel2s6n+sJTk8ban+Jm
6HDaLbpoJCtBHUyLRFzReiRoS7MfexHGFOylGJd6xorXlzX7gUWfe/TB1PGp
Qx4yjT2JMz6hBNY7CN+HVNkj1+efULDHpCyAH+o++kBJ70UyE+3To1MtyHxm
PNApnpGVNYoQLlvung/9NpYjMktZz6upnUE5jDFYuemKAU7Xm2aSaoTSKBuo
ITrr7sB4lN6WsoV/punZISJqy1cdtBXQDU6dt/7RqS7TTa67L+eiZD4j4DpZ
P6tc4icRV0kZQvqvHWLXFodSOmDKH42lch2D9rxUuuIBvjXLvoa7Fj+i5Tir
9CCUYbTalCielHwkkL4CVQbSJNCRu1+ma0bzNemiaTw1fGLsK40aSfGbBQRi
7anlN0P5TSStiwfp9ygbqZwS7z25+6mXKdXQjF3V/HrYophPn5WHqvm63Rgl
IFAOKLGGAJh1fTchoLOPJAsnq6tiirVX4SD0yaJnhgjgEq6aGnyWt2vlsXVc
lMd6v2LR1D1M/N7lsLImo4kGbpn+h+EljWVKHtXi5mNVUfvUNHpeLl9OFB3G
ZKIKYL6ljcbV+Tk7t4y02lxgtbpl3O48uiKttO3+JZtX3mjShO+nuHHtLo78
WiNao0T/wxrq4IGXMLHkWF9PWM7lrPa8kCuWhQtGfr1o8+qf/9MYXnOpG9Xu
fJ/YLDaJjdiB5b57t8GEgs3We8RmvTvpNmstEn21CO+65VsDAz+9BvcuNERH
xoQ1QUCGzry5zUVXvD6smJ+7b/mTj14HtXEGq7KIzPp0nME6GZQE/rFq3tQT
/zOSNcNlo7w/trkoIS7gfmLG7GX9M6EyzmA1gu6mkKzIc3uGSVzQ2C/uuGnX
E/1Ncdko72nEZWsYjl93z+z+u2638VY1yZpFM5rMp6sLXv/Yvy0YWPA9jeto
3SdiV0nxLbljgX7vecCfl/IRGWYppqskjzYcZXHMxJEf12B2Rls21lV/71zu
BkOu6P/2b+5alOYZG/vfm12iutndzGvrd1HpOHmq8JGkuMjzS2ptuuL220Ls
0wdsrUQfs14SI84YZFJOIgTo4w/989pr/xUuP7EhAuMUecLpIsTWKBPceNdP
Xz3vO8aiNoqzWK0ozKWMwqwKORfe9yR8hiaQWf3TVx8nFkeXG5ZQ2g0s+sbC
OVswaY+7juOsxutw3xMN5PjP3UPQqDzrIxqLej57H9wlax7lGEPBXPn7R56T
3sQkdyVtaBVYp9MabciVALMy8xCRGC9SL+a3lM/YOKeXEDkbVnx3x30PsSwQ
THat9yvWFJYPo/9UWLlrrmUSr8sj8kQg9h+DL1FTloEdrp1b71lz421M8ILL
/LLNeVCX+z76pfUONNWyZvL5l5WgZRIis6o+hyzEEJT/q/nfh3YX9+/ZOXxs
otOJ9DH06VCX02lc+ZV0QUUFSeSZpqXf7Z4pWVahVS2rfKbWz0qbl98Cb7Ra
crzzJqK0SqbbeSNRqgbpXoLSfFT6ilojEqVVMpKjNScbyqwClIC/8dFpjF9Z
iY130Sfreu0hdLvvWU/mOyyMyYKLanKQVful5I1S1XgOyiFtJb/BSiRNVeq4
hhFsHbFup3NizXe0yGbSldJnb9LZ0bVWyfmGZ/d6rLDVM32L2LRYtfLAxg2H
xzWMbKu3+b1lFHqt7yFad9DvdZmcol1WAiUXoR0u5nKYpQsAbL8d/BnN7Ps+
bh9Azm/pL7ZDlrh9B9eis8XZvdfNX3R+057kEha7ojbOgvV3P7sk7GBo3G8z
FkkZYoKLmc6GmvZPFYZmLXv7yBumaXu+VHAa6XDeY4jT+pkdOGsWpAfNnY5T
6COWSca7GOL1ZEHTbe1ThSBxr4utgovpDjdvDrHULFzF0Jt8X9mPbk0Wljwz
wemD19szgoKLYulSal0hzxy0a8nrrSfY4exZj74an2//78gexErj3r6N9rtq
J7i44t10H15dH4forWIjelsFtrjvO138NESPr187uhcjGj9fsSzV6qJ+oouu
Nmc73xX0u7zZ9VNWqsYGKOzC2DK2clEZpiG1Su1I3LrfJbGfsgJxW86e6GKM
19uzVP+coOw8mrjzO+z47M3XdJ81bdd1kULk8D7GDf75gmdDX1Pye+OkoosF
2aWr+XxylU/VpQ+qeVyeaGkeJ+7W6tj7T6IlK67Lx+0edc99K272xJQ9Dm0l
aYP7q+r2L/B7425W7jqv7B+k7xgbURbuHMv36PyehaiT1vxak/7DHEodWN5K
+xPoOcbek5Ln1FTFpgu/74TfW91HmXS3ozxA8M+lLkamQooYJnc+0BAb+X0V
dget5iWPkmf8znljCo73uxNsH3UcLzv3WEF1uRk/vp2oTaqKuLjV1nAak+jb
L1JrTXZyNx5fuwc7v4eGcoFA3zj+EimXHGAxfOUYcqX+aqlOHhIEda965pZM
sZsxjPQS9SmVPPF02c721/v9M21uvOws3Ltyz9aHYDrxPMuOzaSpe3LSlpdK
6w7hbI5g9RoPq7UsUXGa7nVIeL3tVhLLut24ZumeNP+mpTejEBfJTFOULHFe
2kvSsNckfsxWgaw0Ri8Ax+nT5yIu3SuZiwC/XiZ+q66ECdx+XatziB/M8Hj/
1SBAwW+VAfGnHCl7ZWLIk//lfRG329JHvOV21giau/HDsbpLXHI6awTPgDgZ
+Perw3tSxGm7zA2n12vQWgTOLZz01bJqqJoYmZq1tQ2RajZXktb9+zW1le1y
0R1WTz98a9gj6SP3c2MirXmnAZmMO6XVF+WZl+9g8d0Q9VBuJhQ723xEabtH
iRInf9y9BnFpe4ElTpqgtHcPpH+rbwPCjsQh++V0bRoxFskPoEAQYbtYhna0
1UKsXItM+URPZFbrNkYWPbOk/iNsUEnRsHHNPWEHgo9+7oQaXP71227dGKLd
V6adzrZ875NyeQ+wVa4h1Fgv6Rqa5V7KhKMXli++9tgr/1eX2YhsWf8tw9ty
NbPVnp3OnnGVVbNfMPdGTc5bP99Ee+pDUvPQrgiwdY9dxy1aks+1V8HdJwik
h5YsDm8ZyNtlmge63fWxX1DMv2UVfMDvt2qCsay+V615869Iz+UaoZR0I+8c
RpRF7jM7/eYxYOMd3b6P3PqJPZf8s1Ki8+uuxkiLtb7IaeXdG/WDmne4bA0Q
I6WsryRVEzvJO4e64hqX4remX2gy69uDkhc8vzZBXrMbhXUx33hStoUnhHby
/lPMNvqehMyHr8EE9napZZOK80Z5G1V3GMZn12C+oosovy/8CzURRnTaQdAg
4yzWmWhJuuW7pGoaerGt86Sr6lYI5p/jna4Zi/b+Ge/r30iw+Qx9ne4rqhuc
2Yx+bwLjFf4BJsVvpsnoO+Ed9KLTln/Gz+6Af6vSWI7j7d0ov8e4MX5aQW1d
TS84EbvV8Lrf9Qc3PLn5pv9Q1GXn4Ty3DC8dGdex8vtq7XpfY39xbNTtmvfy
Wq+mXQaU/6mbl95147qwn481FwIYqA2pPdXhne3ZyiSnb8aibuCQ8WZdjrdc
bMhtB4q9Mc6crAzCaYRt6N/QNTw+xCORIAIQviiQrTMgbw/7t2InOU/XdYr4
ZcV5SsnZsLHO/TvGrH7hxH/+7xMUin0A3AfmJbUAM3w9YKYfcIdUePokzwVd
Z9Nk8rs1JRrcDnjzbo63tdCXogzhqrH+6oZfpZTTDPJOvuxHPnlm050/euHZ
B+reJ+cdsWYB50Mu2XkEiSEuhIbL+e6s7z7SI62Kkrey3S5Z67FyvK0KKGOb
k6P+7zH4dUvqV8hbAh+c3/Dwddvv/iUMxyv5pzQUUZErTjAtxIx3C9Ut0iAK
XIivf/Ojoh6IH9OjZJfz7zPoU1/q+JuQMlRzUUuVfP8MGkMMhrFf/gQSZl38
2xpwMLg6VIj5sZwBCsQwbsyqLVR1cf5upBFISZngoezZorxEBKI0R+hde81a
sAc+kedQH5zH7LAOUhVjJ2akViRe/jkSHMB7+JdDcMzdlIDCUSAaHEDUf7gI
GcMFrclqIG2oGLxNLsG9wEwDV81jS5X5rQ1uCH8Eesj2j19d9e2p6+GbWG3o
E+AwE+BjJqTK+OZYqEeBGmSBEgEHOI2VVpHYWY185WNaZvUnGpdW5OnvckQi
rvk7O/ydXfI3vfyjlw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154347910]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->658092056],

Cell["Fill below a curve:", "ExampleText",
 CellID->1012403142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}], "+", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "15"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->946672413],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->475719274]
}, Open  ]],

Cell["Fill between two curves:", "ExampleText",
 CellID->237812485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      RowBox[{"x", "/", "2"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "+", "x"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "10"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->447368328],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56104018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->477483238],

Cell["\<\
Plot multiple filled curves, automatically using transparent colors: \
\>", "ExampleText",
 CellID->101482510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->282693146],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156057888]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20547],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sampling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22776660],

Cell["More points are sampled when the function changes quickly:", \
"ExampleText",
 CellID->5555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"30", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172764079],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183750852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100736041],

Cell["The plot range is selected automatically: ", "ExampleText",
 CellID->749339086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11813271],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mEtoHVUYx6d3Ju9Upb4q0uQWRHShgouCSAy25tW8rLbpIriIQUgErdS6
0Y1udKMb3VgQu/ABVhcVS0WoIBbEglgQC6KCVJC6sAgWFwHh+vu+75zMzLln
5qZEGyZzz+P/Pc73OufM7NKRlSeeWjqyurzUnDi89MzK6vKzzfFDhxlKtyRJ
cpL/J7cntFu09P9kq8XvorxT6etfsqCj+3X0vXfPra39I83Moy5d+jtEHTzw
/sWLf5VQ5779LUc9qqOXL69NTx2TZhevBqCDhdmffvxj+fGP/Gw7jzneMthw
tN1R1Ly8e/K1JMkbr3/14fHvaFTwneSdMZi2Ub7w/GdnvvylmrJdltnBUwhB
FXLf/DvW2DDv546cqqWYc3Zp6Oyxt79J7C9up0d09NDTn7jR7pJHbHZsz1vO
93Ee+wK/9dSgiKOjb57thMr1iaMe9nGE+VAt6S1pbbOfn/75pRdPS7O3hscr
L3/x6akfqlFq/xQZRKxI6qtBfXzi/GuvnpFmX0kfm11dOXH++9/9bNxvRSv2
16AsIqtRswGvgZI+swGPgSiPGR09+/WvLuBSF8nxGJj2dmKZyM395uI2raRq
EKKSd9mGKPbqKEOESMlrBao836Z0iFREK8qValVdMyY9GqtJ+oa84/k2EVD1
Oxlx9LiOEgigxU7bSp4Z83HE6oju5Poojz3yzi5c+BMUAYfRb4jiHlQcfLAw
4pi7KYob1cVhH3BULt4S6TdHsSOKRTaCDSt63lJaRU8rr9BF+wli2CHTwpxU
p4aWKOxHjX5s8QMerIAatwZaNGvoh2vkKj4aLUlWrK472kY0LrvxGHULtWwn
wQBDgWbDbZRhDuzoKL1hP6lblFtX2pFOfJV5+sHiDPmLjwgUijhJQPlFdcab
/5v2nW2sPu3H18i27ZVIsp0NXRnE7+Gah5zfm1dRT82qrcQ3KlEq0Y3dwkyJ
wjTAMF7Y6UXDnR0t65HN/0xTq+BmUTGq1NRkAMOiJKqOjhxl+6LNCDNseGZk
49+mW1FW5zgJKYY3uKpiLdYoF8Uzsh4NeagvDTFxxhaP/jwsREZ0bSl2By+m
93ub5xdq3Azmh0K5qo3to2S2+TdJEZipfBQxjVCtITqmdvAVggdaxbrXX/CC
WHcu0MQq6OKmR2UlxwPNI7vUBvvXbJK+su90vmryrqTfZrXQV7cH83d18JJE
wW7pZUSHZSGlN5NYzahrRBIP20eDuNJQd3yzKN9d8uq2ysND1YYRwWkZYRnN
Q2roSGqVU4RpdmSINkqKfV9Uwj3y6mVXsw2CIIeRpRqlwriy4TEllyaLe7va
CeGNUZ53ymuQDiTQrjNk3zEFySBmMdDOKP1t8urnVESBQiGOLBDDhYVjAaO8
o2Rx5dPLMBQc9hEHEUUaQbC5OypF94ceO2mYihBwWZDz4b1RCt2vuhDBKrA9
6og5dkWx2xWL5+BurDFwcl9Jaz1ZdVEhwBg/kX1/lJ9aOqPaETsAYTwSxelJ
Uc56SKTKs7zRKG6b9gkLnMKK7Iy4rpnNojFmlHPC7iiP67SPyRAkdU7Po3p7
T5P2c++12qeD9QT9kKIXgvxqBFRWJXCiOwmPbYhqq/axJquTvWG8kkq6hs7v
QYbe34qf3we1n9/xJtbRRd7hd48BrxEWFS/rHSM54GTE0QhAjDQnS94Z8DZx
t7qpqHfWdzKiqxrV5/UiAMUre2tQ5DL5J804ys4ncIGXrHG6pHWfjyl3j5yu
4UEOE1bVqB4vyd3GZ2pQOBXXSnOmpE9vYOM6HnZJq0Z1eyu6zzizNSiyjdws
o/y5pKhPHY9cH0PNt8rfwuJ7b/69TXc5+/LRfiKrySvjk9+6N8eHwCQ8r5RP
Xlvybzab0yO35ub4sEu5+bl1r/iTZcwrlvXUJ/JFmvOleOgKojefbeeRWzJA
uW+zmfebW2eAclov1IwmW/4FymQ/Lw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63978322]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119237889],

Cell["Ranges where the function becomes nonreal are excluded:", "ExampleText",
 CellID->360827733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453187265],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWEtoVFcYPuZOJml9ttrER5OMWm2trdX6tmrUiYnxkRhSdSEtpKGQLKpi
40Y3utGN3dSNhaKLVsHHQqlYBAVRKBVKhVJBtFAsFF0oBUMXgcLt959H5pz/
/vdOMqWlITNzzrnf/53/fc7Mtp6Bvo8/6Rno7+0ptO3v2dfX3/tpoXXvfixF
Y5RSV/A6OFVhHGOkX1fiGJ/+ew3eIzyqohkNYv2nqjBswoA+I++ZIixeLRnP
mjI4NV7Vsid6NVeaK9WQWKlhMuvKIhrK7lJlPiKrvNU/KitXj4+ck/+PtPx/
+awSbapjkzPF1CeFf3l3X2ZDWUTTCLWpsdrn7WeT/XTrRTZvZHiTfsna3M32
35mxStznsJjTsxcZhlvWyObjy+BT5zeu/0LDuaOUf0V6ntC6w82/vXpfsP/y
pXvC6ulTP4Sr5OFdIebI4euC5N493wiru3acFVY3Fr8cGvqL7aKiez8/sbq/
n9gRruIsF87/dOLz7/jqwwdPez+66K9SzmG7Le2n8b6D7Qm17/74O9vTZimc
gX8jsTWWO3bkssbKwIb+vktGZou3HidqRDnJ6mEEVBwcHLKaJKXzLMJRKH3s
6E2EOlWa9yqqvkibcOf73w4MXKW17lHIqvzwHH9dnV89e/ZnmnxOXgkYPjt+
GznZHXjb1Xh1Am3C3B3G3tcu+mD3uUeP/qBhVxBzE0GTPOHTJAeiAcMoV2WU
4QIR6Gi4PQP1+PFzWw0ySnskOnTw2u1bv9KwM9DaZI6xOnya7BQljo4MFLiQ
qWSbjMoz27ZloBB62EZcJRRpXct8vVXkMNkFaYQMXrKooOKq/dgr4bQxO8Fs
GE9DnYMjrSFv/oKeoxxQFDTcnMJD0cq5PE7Iwx+whWo5S97vBGQPTU0XRx2j
mmnYniLvznzuh7FM/00VySMK0J/iuSmIBe8D3HvjmPZtYrzNeWmaOg1bg5yZ
ENvKQ6ZTNrSKHAaFbosGTnpuFFET4zD/WkTUJKZPMQOFvVA1qB0PRVq/7PwG
rSnuG0QOg8KBY0/L9SJqsp6jGaIl0nCdiJqi51+cvHPm67s0bBZR5q5Q6ghr
A63rnE3QB770nvocdS4iQJHla4Kc4DkgZVV9bKsCvqOYrk7JypRzwmOa6vwM
XYjpvYqZpuk57AETRWzVqJiIaDpjWJnBEAlemcHkV6TIczluyauxrQV4l3iW
B/Fx92Yu1cB2XybGvpGhlgb5U/CeIrpqicgxjLLRXyyiZrrIooIoy94VUbPi
Ui6ixalFImq2Q6ERoo7UwkBrc99GcaF4aLhA5DAoFBcaA3WYt0XU63qOxmH9
85aIesNFCLbhUqLmi6h5zgPwE3qEejPQer5nOdk0T+Sg/atgmq5quzYnyIeR
1Ku2lTqQjevclMwsX2ULPMupw8ypmOmd2PYQ6ISOrl5LYfJPNhLXsc/BGzgD
0AfhwFkV66Bzkm4Z9gyYWTGTroEIuQAmimYhiFFw7/WkljhbEGFjS6OYBcuc
njjFyesNQSatcJ7E3viCY/pHgkN3swjPgaIcmC6iVrn4Yif69jFNROkunYO6
uBfgH4N6EadPFro/gI0qoC7Qu1mzmAxA6cINU0QWfV5S5dqcmyyi9NmbMxEw
bC+JuCJjmySiWhJsEwLd2zwWsmy8yNLmWGCh8dPY4bxI+02Q50i78yFu5BQR
faM09/LMX2N4hm72YoY2CqVqK2TS93n6lgnb4QFzixwhDwEMEi6FY8l3+Qr1
2PmP5HhtfqhXk787qTF/A0OSNnA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->300652382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252963271],

Cell["\<\
The curve is split when there are discontinuities in the function:\
\>", "ExampleText",
 CellID->430742835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"Sqrt", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30552953],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVs9LG1EQfsnLBgWpUHCNikUw6r/QS6lQqid7E/FUggh68AcqFNqL9R/o
uUUUpBXUo2LxqldRkBaKHnoq9lAvSg+BwjozO5t9+/Zt8mJjow2beZl538yb
nf1mNkOFhYnxqcLC5Fiha3CuMDsxOTbfNTAzByaZEkLswPdVTsBvD37Rd8fz
YFVlN8gMbKVhTcPagVY0eMEHre28Sl7bND0Hq1SiSGUVIo/S8WOWJGGFLJ1E
MZSTDQgXRVZFmHEtlji37IlBjljKFK5k67HKEgHCKZ3N0XJ3IP9eAyIWU9+P
nGF7Fy5zICFCjfNuLXuaNO603mKduy1jJ+eNPRZ0Tcn4T7mS96LdbJ4NHcod
JM0GfSaEsyE+kRq0zDei1uOjHxcXv9mKLbYFxozR06mgP6gSf9vxap2PrmeN
VXqp6Y80vdfmqcSs+IQ3b+T591Y8W8jnz5afPnkPl0ijkEAcRq7VMa/qa5IJ
+B3bYdoLRYlh9DmAXSeD7pNnp7+4Rlmq0dbmCeM+kLfUvPVoG1WgotMn4Y78
oUAfnb13g3F4ShPtFot/3rzem5neFo0oJChgwq13xhi+19cvP4GIcIkGFKjz
vtmr/vwzMeimKBOX6S2M3bm6cgiXaEKhdOsiMyN8UyEzUPU9D/a/RzxB1zy9
CpyqjLC7u3pzMza1sb+Zbc3EtvPzS96fjuTWR2ifzkjmZmI0lDOGvg8T0+KJ
28yiGAYhjwk7MrzOc/MhzU3QGTlqHV9W5CPKZD6mEyPXm4d4ygva/fTxmBnl
EqM+735jdL8xxhDp8P+OWesSa6+uimW9/l/GqZhx0qEWPO3aadqFHZ03ZoIB
fE94OcHjCD3DquZrlOF9eYer1rdBVZlxnRrjnEhuS4QGCLO6k1gdvqucqvMR
qWvAInCc\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173049790]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35274416],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " to control adaptive sampling:"
}], "ExampleText",
 CellID->596378793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "15"}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "mr"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"mr", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pp", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389502305],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{3.7499999999999997`*^-6, 3.7499999999912104`*^-6}, {
         3.6067664957812102`, -0.4485781785686358}, {7.516910614453026, 
         0.9437273974057886}, {11.167936106015448`, -0.9851824404009166}, {
         14.747342970468475`, 0.8195471636808159}, {14.99999625, 
         0.6502906889822173}}]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 15}, {-0.9851824404009166, 0.9437273974057886}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], 
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{1.6666666666666667`*^-6, 1.666666666665895*^-6}, {
         1.603007331458316, 0.9994812704422169}, {
         3.340849161979123, -0.1979406046734789}, {
         4.9635271582290885`, -0.9686302044782503}, {6.554374653541545, 
         0.2678775051761893}, {8.28005831458316, 0.9105942671928123}, {
         9.89057814135393, -0.4491378764720829}, {
         11.63593413385386, -0.8018808073937703}, {13.34945962541628, 
         0.7054720801478971}, {14.947821282707858`, 0.6890243541816921}, {
         14.999998333333334`, 0.6502891063027346}}]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 15}, {-0.9686302044782503, 0.9994812704422169}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}]},
    {
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{3.7499999999999997`*^-6, 3.7499999999912104`*^-6}, {
         1.803385122890605, 0.9730729456531088}, {
         3.6067664957812102`, -0.4485781785686358}, {
         5.561838555117118, -0.6603965696052458}, {7.516910614453026, 
         0.9437273974057886}, {9.342423360234237, 0.08226154010234522}, {
         11.167936106015448`, -0.9851824404009166}, {12.957639538241962`, 
         0.38136174792012784`}, {14.747342970468475`, 0.8195471636808159}, {
         14.873669610234238`, 0.7408222456651246}, {14.99999625, 
         0.6502906889822173}}]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 15}, {-0.9851824404009166, 0.9730729456531088}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], 
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{1.6666666666666667`*^-6, 1.666666666665895*^-6}, {
         0.8015044990624913, 0.7184034732212784}, {1.603007331458316, 
         0.9994812704422169}, {2.4719282467187194`, 0.6207229069075503}, {
         3.340849161979123, -0.1979406046734789}, {
         4.152188160104106, -0.8471484209684397}, {
         4.9635271582290885`, -0.9686302044782503}, {
         5.7589509058853166`, -0.5005503669579394}, {6.554374653541545, 
         0.2678775051761893}, {7.417216484062353, 0.90612477736096}, {
         8.28005831458316, 0.9105942671928123}, {9.085318227968546, 
         0.3329777040723998}, {9.89057814135393, -0.4491378764720829}, {
         10.763256137603896`, -0.9731352932391243}, {
         11.63593413385386, -0.8018808073937703}, {
         12.49269687963507, -0.07360710485758432}, {13.34945962541628, 
         0.7054720801478971}, {14.148640454062068`, 0.9999341799728336}, {
         14.947821282707858`, 0.6890243541816921}, {14.973909808020597`, 
         0.6698846828060199}, {14.999998333333334`, 0.6502891063027346}}]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 15}, {-0.9731352932391243, 0.9999341799728336}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}]},
    {
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{3.7499999999999997`*^-6, 3.7499999999912104`*^-6}, {
         0.9016944364453026, 0.7843790631979717}, {1.803385122890605, 
         0.9730729456531088}, {2.7050758093359075`, 0.4227854966579304}, {
         3.6067664957812102`, -0.4485781785686358}, {
         4.584302525449164, -0.9918081389591128}, {
         5.561838555117118, -0.6603965696052458}, {6.539374584785072, 
         0.2533960502647443}, {7.516910614453026, 0.9437273974057886}, {
         8.429666987343632, 0.8388193863555953}, {9.342423360234237, 
         0.08226154010234522}, {10.255179733124843`, -0.7382024579676181}, {
         11.167936106015448`, -0.9851824404009166}, {
         12.062787822128705`, -0.48256665081610917`}, {12.957639538241962`, 
         0.38136174792012784`}, {13.852491254355218`, 0.9597527852607078}, {
         14.747342970468475`, 0.8195471636808159}, {14.810506290351356`, 
         0.7817436103847348}, {14.873669610234238`, 0.7408222456651246}, {
         14.93683293011712, 0.6969462753310188}, {14.99999625, 
         0.6502906889822173}}]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 15}, {-0.9918081389591128, 0.9730729456531088}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], 
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{1.6666666666666667`*^-6, 1.666666666665895*^-6}, {
         0.400753082864579, 0.39011186706875506`}, {0.8015044990624913, 
         0.7184034732212784}, {1.2022559152604035`, 0.9328541620178646}, {
         1.603007331458316, 0.9994812704422169}, {2.0374677890885176`, 
         0.8930707955786185}, {2.4719282467187194`, 0.6207229069075503}, {
         2.906388704348921, 0.23304132423010768`}, {
         3.340849161979123, -0.1979406046734789}, {
         3.7465186610416144`, -0.5687012156759124}, {
         4.152188160104106, -0.8471484209684397}, {
         4.557857659166597, -0.9880837769352715}, {
         4.9635271582290885`, -0.9686302044782503}, {
         5.3612390320572025`, -0.7967792051277197}, {
         5.7589509058853166`, -0.5005503669579394}, {
         6.156662779713431, -0.12618523649821256`}, {6.554374653541545, 
         0.2678775051761893}, {6.985795568801949, 0.6462119285028903}, {
         7.417216484062353, 0.90612477736096}, {7.848637399322756, 
         0.999985719611982}, {8.28005831458316, 0.9105942671928123}, {
         8.682688271275854, 0.6758296082530767}, {9.085318227968546, 
         0.3329777040723998}, {9.487948184661239, -0.0631282190508179}, {
         9.89057814135393, -0.4491378764720829}, {
         10.326917139478914`, -0.7846548511382858}, {
         10.763256137603896`, -0.9731352932391243}, {
         11.199595135728877`, -0.9792598383143003}, {
         11.63593413385386, -0.8018808073937703}, {
         12.064315506744464`, -0.48122805152146936`}, {
         12.49269687963507, -0.07360710485758432}, {12.921078252525675`, 
         0.34731621833782517`}, {13.34945962541628, 0.7054720801478971}, {
         13.749050039739174`, 0.9256233518096256}, {14.148640454062068`, 
         0.9999341799728336}, {14.548230868384962`, 0.9166962125147307}, {
         14.947821282707858`, 0.6890243541816921}, {14.960865545364229`, 
         0.6795123281327828}, {14.973909808020597`, 0.6698846828060199}, {
         14.986954070676966`, 0.6601430563488703}, {14.999998333333334`, 
         0.6502891063027346}}]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{0, 15}, {-0.9880837769352715, 0.999985719611982}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}]}
   }],
  "Grid"]], "Output",
 ImageSize->{312, 285},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->58794875]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226160967],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus in on areas of interest: "
}], "ExampleText",
 CellID->316263374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41344862],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->161803326]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->596150632],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Exclusions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exclusions"]], "InlineFormula"],
 " to remove points or split the resulting curve:"
}], "ExampleText",
 CellID->24664850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Tan", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Tan", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "15"}], "}"}], ",", 
     RowBox[{"Exclusions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "==", "0"}], "}"}]}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287230197],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->142196574]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5373264],

Cell["Multiple curves are automatically colored to be distinct:", \
"ExampleText",
 CellID->150311282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "4"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "4"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"7", "/", "2"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74897845],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237697742]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90466730],

Cell["Provide explicit styling to different curves:", "ExampleText",
 CellID->238286887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "4"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "4"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"7", "/", "2"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Automatic", ",", "Red", ",", "Dashed"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67697223],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->278286624]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103486521],

Cell["Add labels:", "ExampleText",
 CellID->797294755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575371355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->664209048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64589049],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for each curve:"
}], "ExampleText",
 CellID->213196035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Tooltip", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", "x"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162853632],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW
8illTzghhSKlEopCsszMtY6ZCf3O9/n9dZ7X88y5d+a9nXuf0XD03H1UTERE
5JmoiMj/VnEs29C19qIhr/z/10V95ZvmxtrD7YLmkTlkFT7Tdm6J8QTvW/lG
n8n6W9GFXxhzHi48qghMI2uryeXK9JgboHYx9f0esn6xj1mSFJMC64xnWO+9
mQK73VVb78TkwFosLAu4ngM3h23z4mMwrFd6ZKQWjGFT9XbZLb6NcKW0zFjW
uBG8Ai2P5Hl9g6IzVbqlLc1wsvholNiCn7A4e+4HM3Y7fO7dJpPp2A3dPS0H
qqW7IEKbJ1J4oBc0pB6Lbmf2gPeKmluv0tkg9H27NpvfC91Huy+kFrLB2694
wVrxPrBJFXG/8JYNzy7MUCue0QcblTZsQX1s+OSgu/jR/D4Q+/eIizU5sLVv
5mY9iz6I+XTNFOdxwOl4mqJoch/kBuwUlFVwwbKl+bSefj8InU48/eExCP/N
7G247TgADswR/1K/QXj579C8F24DUF0euPVe8CDEOsfWN/kMQLRqxLf9UYPw
wtxv01jIACz5kCX2+ckgrLOMWNybNgDWG3ts6tiDkOu06FrkrwF4yjjyr9Bt
CFTjrU9WHmCDYnlv7S2fIUivEKudfoQNASe84k4FDoH591YTSxc2GL05v2x1
xBD4Nomnlfuxoe1s8p4nj4bgRq5PukUsG6T/tGU+6B2Cd0byDnPescGxzGZX
9LFhCN2LecFrObC6UIVS9RwGH96CCF99DojltDbdPzMMAfNXvbffyoG0VLt9
eWHDoHXfwXqeFQc6Lx2z+/p4GPTSbhpudOeA43Y/9zn0MLxaH1T/I5W4+VZY
1pkRYJzYyGkQ58Lqxn3bdS6MwOHu5twCGS6I1arKlYSNQJhzETtWgQtpJUk3
3t0dgb5DNwvXzeZCZ1J6PPflCOzPv3ZKaTUXHJ0LHuqKjMLPKq9V6+y44DT0
+dWrsFFwDXHtEORwwSEwel9x9Ci0585xCszngq24BTfnzij46dVvGynmgo1S
1eyUrFGISize1EDyaLbhud+5mlHoMF0Qu7SJCysvXtfcKD0GMpMfNTxGubBc
dluVDmMM1BLcrU/xubAkVuLgMpUxeF28rMVnggvq6Wevqiwdg+ug/GW/BA2s
WtdOnukYGEYHna1h0cBnmNzJuzoG67ITn67VoWH0rqh29o0x6HiXF/1Kl4ah
+WXVabfHIERUWLB1PQ39urojNzPHoLjx7pvVQMOP/fMtvd6OgWiEQW+eBQ2V
qVPiWlI84LJVTm0+RkP5spKEhQo8qD39eeEuVxpe5p7WmaPMA05F4fR97jTk
v2bbTV/CA1pyyH+HDw2Zva0v+kx4cGdBbun3czREriryzAjlwSFtT/PLsTTU
rW7uOR3Fg6FtaStk4mmQXjt+2DieB2ZskSuhd2i4vEHPojudXJ/VleqWRMPZ
LUVL51fzYOyCwslvGTQUGzWnDL3nwe72Y9M0HtHAMxmfWfGZBzOkDys6ZtPg
Y64n6dDNg9YropH1OTS4WRf9ShIfhzfbY9q2FdOQZdO8/+T0cdCK3zjdpoSG
nv3jH/RZ41Au4pJ9sJSGI4f1ytvmj8OnmOObdryiYf+xogTVLePgrDca2fyW
BlP/oj23LoyD7jzxuAtfyPcNbK5zDhuHFS4b41nNJH5B45t1o8ehKFZNLOUb
DYYX9VY1pYzDs0AvpZQ2GtZFFMkx8Ti8WuaubvSLhlORzZd+vhmH9IuqxxI6
aciNGhfmNIzDqlt5VF8XDVqxen2W7ePALvdK8eyhYWFiUXXk5Djkr6sJ1hig
wTG5Wd9Wkg+XWq6ObGTTkJo6nrdiBh9mDva+t+DQMCddL61uDh9yt0T+d4Cm
4WDmPtWEhXxQd7fKtR6k4c6jM9GumnzY2F0222yI1NfTomBpfT60XM9QURmh
Ydez5rHmrXwYXJmfPUoclTvunmnOh5HJa/drR2mQLdI7ZHKIDw2CxnxbHg1m
L/Z9UnLiw/RZ7R9njdMQ+vLMtt9u5PvsHNv1kVjsVZHe5UA+WH25dWqJgIbH
M6iMyRA+REr82vWZePchd8Uz1/jwI6tZ119IgzDrTchgLB9u1pirs/7S8ICn
PuSayAdtLpOVTmxhdNa+6yEfQpeKzlg5Qer/5pd62yd8KJAdmfGU2Egr4vHO
cj5MZlktjJ2kgR3YrVL7hg+WGsEb+MRxNYZXt3zgw8QLzb3WUzToz7w79rKZ
D/sSt57JJP7tNOK09icf1vllpwwRRz3f8elpLx/+BexsWP2P5PNfJlo6xIcn
dmriJ4jbLcRy7gv40GQvaZhAHJpgqzZbTADpBsLgV8QrewuvxckKYFx/qPoH
8de1TOEMlgC2LumkhomDL51wuTpbAI+3vz06SbzkY/VXkYUCGA1IKv9H3DhX
3ThQUwC35JzVBMT+7oF5I7oCyG6fE9JHrF7yWeOkgQAmdr1nNxLXSGlH9xgL
gGcWcDiH2Gtv+JS9pQByVml9vkys8qDLvcVGAB28kV1WxK8GDdp22xPLf29S
JHY1vLPt/XEBPPDi2X4gv5+KHC4y9hLAizs27AvEJS0Wi7G/AAzDqJBlxI5L
MuPWXxTA99db5taS+MqeFhXPDRdA5X6xCnvi3MpD3itiBJD8ycONQ/JzkFHY
8TBBADeMs2b5EIvZMSznPhDAgm0fP3JIfrOz3UpvZwvAXCAf7UBsLXi9nJkv
gB28sL11pD4mTObdjSgVQJmz6/wVxBadTafP1QvgVBnV9JFP6kF7ZTfvC/n9
V/SLlIkTz4Xt9moXAAqKemBN6pGjYqDtRAvg/KGwW3ljJL87M3rNmEJy/nj8
lhwm+U0S2VepKoTscUemBOmP9v6D1ZvmC+FI7llTAekn7VCFtJVrhEDrmjXV
kH5rLPU/pLhXCA3ms30mekl+ZJtqrx8Wgro0PZ77h+Rnv9Z6qWNC0Da4HOFA
+tlr5Jei0E8I4tbezamk35nLzRs67ghhZ5zN7MIfZD5JpTBrUoUwcNJHG30n
8f49bP0sSwjJsUFnK1tpcL6f0HahWAi5Nz+V5pD5U6zS36vxTQiHjmjTmh9p
uM4z0JT9KQSGzcF6/w8kP59veg7/EcKS+Jie0noapkdv4FWOC4Eb3v5Oq44G
O6lwcWflv8D21vPIraRhze/vJhbz/oLfY0rnFZmH0lWrInSX/IWG5NjVb8pJ
PoO/MST1/kLbqN9ICZmnkrwlczNs/oLUUHmgaS4N/3W/Wd976y8UC48qcVJo
uFg5K6gx6S98DH4qcp7Md5tUD1yc/hfqZTeskblHg4jtTJPwgr9Qeeyc1zRy
PuxpOrpn+Ze/8G5Q7vDDa2QeVEh4uCtOQCqvMsrjNJk3KVseDMZMwJswuU2b
t9JwtabxR8i9CSiefXpRHDnf3gzZqSg9JJ83XqXSvokGY6Oz1zcUTMC8i12z
9pHzcUtf3pmQ5gn4cfl53o+FpP/XLLJQnDMJ2eHjKw3JebvqrdSYXvokXIzv
yrUu5YLn4C3tuieTgJ5d6Yso4sJT1YVutoWT8Hrf5Z3FuVzQckcdF95Ogozs
ghx+FjnfmQG1tX2TUHjduFvhFhcWHupPOrRyCk5kH3G9e4ILyvR7k/NFU1Ap
2Rm0gOLCnZv4SB+egqiLZsp2clxQ0c0N2lMzBS8zlzlGTyMOuJ27pIXs76pV
+C7kwCxxx7mNwinQ0pbgK3RxYK7y+Ji64T8Y6xzxHHjOgcWgkV75+h9k+I8z
z23jQMLbElFxVxF0SPHnIl8HNgz+fBZAu4sgx2eJWSvJ85+pMGOozUsEHXuc
cKDLig2jmrG/8v1F0EK1IzvWb2WDZcyJimNhIkjJPfVJ9CI2iB2ec7EuUwSV
fArtnOgdgBPD50RiekRQULOISCN5PtVX2/xP3VkUNV4NO1B/sB/MbD/7OLqI
om8dVT0aVv1gfe94zwN3UXRQcEXU07QfTqhG1S8+LYra/yb0D6/phwSltnua
oaLoQ/HRb/fl+oE/4/T69Vmi6Gy5SVxyaR/kT2V572SLoqsxJmFLlPtgxU9G
97lTYuiA3ki3WtEfeJJFuRT4iCM5ntQHr45uCGo/3LQiVAL92H102SWPX+Ct
v948OU4SBTWaxq0JbgNhipHjQPQ01Npjcb9m5Wdo9EpwOJMmhebKBSz1+fwW
NpjOn/pxXxp9/Cp3bErkGdQab8hCiTJoQ6Pd3JzIpzj9+d0NndmyqJGlrp9+
pgYrLdB0s3s0HVkvyV1o8rsJfxKVDlEtlUMSdSmPdFvbcIG0b0Zj7QwUF7Cq
oCr+F9ZUYrg5VsujFdEP9tu+7MZ0FE9xzVcFtOo6s2tx7R/MHpxbqdWqgExS
qkpqm/7g/t2mnkvbFVA1vefJsfY/uHvmnVq1HuKJG9+iRv7g1uQNwdI8BbQx
xmLqtlovdtxXPsKVZSD15Y5brnn14h3HRQ+/Xs5AW5Ocm7uYfXjB1avanm4M
JFNrE9K0uR/7fNUNdnRnoHWF4gkvt/fjV4s63+/1YKCl7ce8k/b0Y7vX+m76
Pgx0s63dxvJoP04QHX4oE8hAJwY+VjiH9WMqyHbWw3AG8reMNnGs78di3jqS
LVkM5HpkovHm7gFs9ap9z/vHDKQVrvT7ycEBnKoQmYb/Y6CgeH3/KscBbPi0
BzKeMdD355KKbT4DOHDgXqBvMQOF/2GxX8YM4OGj0wZn1DBQ44eSM1s+DuDO
g22tW/4wkI7x5jk229hYzmBfpkMfAyWXtX3Qt2LjtfOafIMHGIgjrxA/+wAb
h3XVyZXQDDTLxseqwoWNtd1LDHX4DORWNM30yVU2Djp3N22eDBM9dog1l3zN
xkqp+9wmljPRbulIjcx1HGwY0rRulhYTlR3/JB9pwMEuzjvF12szkcnSiPcu
RhxcutQ00XcNE+n3pz6X2c3Bjs/XNfRvYqKqRh1OrzsHP61UWt1iwUQa6mlX
Z9/nYLPfTYICDybqXmDx3Eici8+tiDqb48VEpqVxIy+luTjX22wyy4eJzt1U
714hz8Wzp0pFEv2Y6G1HYd2YChdzZ2ZIhQQz0VS0brjOSi6OM/NXsoxiok9a
0v+Z7uPin9lzdHqeMFF9igL79wMuVhr+mtuRw0Srn5mEeWVx8fb1N3VbnjNR
xqkv2SP/cXHea8n17wuY6OnvW5e7Crg49AfXMLeMiVYwzO1c35JXWYUKi+B6
JhLk1VbL9XGxv89Rl5kcJtqT5mifvZjGYebc4xtpJtpcu2pazHIa31545rjd
EBMdZ4u98lxJ48KvYccyxpgoYsDUhbGOxiMb/3NeN8VEXb5j7j1GNPYQH3Gw
UaBQpKuFbbcDjc99P+sQyKTQ4vGZ+ZucaRxZIOGQzKKQyZ8j8hHHaZx9fKZ9
jzKFKN7zN9M9aNz7bsNhP3UKccwPaj4IpLFT3IUD8ToUYsiBpEYMjX1Oyhwo
WUOhvttKqr1xNA4xidnfvpZCeyfPamTcpnEq/8G+xRspFJv3VU4qicbttm/3
Fm6h0IJI1/W2mTTmrN21t9WIQikhu9taH9F4Qr7FesqEQpvOvnPf9R+NZ1f0
7zExp5Dn1+T96s9pvH+R/O6veyi00rcQ7SmhsctUvJVwL4UiIvlG4aU0PtM8
z2rufgotk/ReXVhO4/hwnV3HbCm04ln4m9FKGjdxrC15zhRylYmslHhHY8vC
e9tn+lFo4+yRa54t5Hojjv+U/Cm0Re7eLn4rjS+tWp6vFEgh/bE29YDvNC5+
XKymFEwhH4vHnY4dNJ6f8mWQFUqhRem+v75201j/e2I6K4zES7yRP6+HxvtU
nQ+yIijksGVC5cgfEu/Y4SoqikIv717xeddHY95VhdvMeAqxMCsEcWnMqP5q
zrxD9m+627yNpvEKsWQRZgLJR/3DNeaDNHYI0nRjJFPooerOqbXDNA58MTKX
kUqh0ya+7vNGaHyLV9KkkEbstvSnyCiN67y2GShkUCjZ+Vhz9hiNu58whuWz
KGSdePngaR6N//U3Z8g/JvGNsutcN05j3aPHGPJPKTTHKvTffT6JT5pW9Yxn
5P6nA+LMBTR27RgNmJFLIVOhjxaHOPnApS65QgodL2txU/lL4hO//Y5cMYVG
Nk/IpxE3NTF3yJVQSLHgRuGCCRpzGS2icqUU8ij0PZJELG2ZWji9nEJru8MV
FCZJPK8dPzH9FYUM2wpe+RMb1KxUn15JIXG9H6daifdL8j7LvqZQ5s0/K3Sn
SP1tKQuXfUOhyUvlv68QR56/bChbQ6GY9B1p5HkbZ5aaj8jUUei/yJAjzH80
rhRQWTLvKbS7wWKBOfH3da22Mg0U2jWV9CeImOd7nynTSKENOa5PM4iZz13e
SH+i0EkfchoRa3K1z0p/ppDyN7OtncQmK8a1pb9SaI3nDuYosYNLebfUNwpF
Vz/9Rd4/8Nn0K3elWinUcNwtn7x/4PhOC0up76Qefp0PJ+8f+Nk8RXGpdtKf
pYMOA8R1tm1F036S+4W82viF+PfdNPdpnaQeSkZnFhGLNLtqTOumUC07biya
eJaizlfJHrI/6fFXR2JdK36EZC+FrlttLtEk3hmFQbKf7L92LJVL4uH2LnRU
gk3i07AsPIv4srTlIwkuhZYkJJ46SJxsrGQnMUghpscnRwniFyHfKYlhCnnX
/NyTQeLPnXALEudRKErsj+Enkr8D+82XCcYpdMJRJMmO+HXeiq9cAYWaq0t3
dJH833Vja7dOUkjkU3zmFyGNJd68//7hH6mfNWO7thJ7aDwJrxZlIQ0Z/x2P
SD0ZfTvZ9UyShQLfXkB2pP5y1lhGZ0ixkPUiG70npD5n3VhpkCjDQg6d3Iuj
pH4Hjen4qzNYaHqmGsud1Pe9PK/tdkrEuWXL/w3ReJqC1fgeZRY6EMR9zSD2
ctN5uE2VhcZ/+OfPIv1kojE8qavGQk/OhsUpk/4bjvJ9Pn0RC/kVBtkXkP48
3L/HTnQJC73l2mSH99K4xlh3+vhSFkouibe0If2cNDHq3KlJ9gs9E7+R/jdz
81N5octCOVfk7S6S+ZBXbVP9dB0Lcbqvn1Rpp/FcDT2fh+tZKMp/9GsmmScj
zePvbuizkMFwa3FOy//iH3D+mBELFfVpVTk10Vjm/gFNWxMW6n0nzC77SONT
ExtarMxY6IJoxpBCI4235QlXG1iwkHnD2ltJ72k8qh7Uw7JmoVl2PLPD1TS2
D7KNlbFhofzTzgsDq0h9Neujf/tIPHepOdyooHFK1OTd/kMstGOnmTCtjMbb
J4J3VDix0NLf3954FND4fvPFfA9fFoqfdUPn7gMa91Sv6og6zUJCVFgkfZ/0
Q36HTM4ZFpoBRjs9k8l5FG1gT59loSvs0AKNuzR+v00g43WZhTbYNfnOjqIx
/6WXvfctcn2rla5OfjQ2fDwv4uZtFtKuP+hk5Evm7Z2G/Od3SX4bW8/O8aKx
/GlN2eEkFvIPd5me60rjBSt7830yWOjcgEW5jy2ZT6n2sqeKWEhRXNTMHNE4
Lkp+bdwLFmq1/HQ7WZ/GLUFl9vkvWai++ahS33oaOx+YXTCKWejf02nJTjo0
DqCa7U/XsFDoanVxWoPGDy9bFvi1sFAP217RQZTGQhcDh4C/LPSpPiIm7wU5
318uR6cnWajq+eOLiJzn92aoqHv/YyH3k5Jd1c+4WD93uMNFXBE1BX8RKcnk
4uC/mfb7pysizrmVNaa3uFg8irLXm62InuSYhwo9uFgu78/hsY2KqOK/vYuq
53CxreQXgyF9RbT1/dw0R2UufrKvUo1jqIjqKX4Rn8nFlhOJP7q3KKKEmFX5
8lJcHG28+/Dn7YooM/m0YucgByt+K7XNO6iIemsWZS2p4mC1yZuHvAOJ/ySo
rnckz0edO17cDlJEnQ152s6HOPjUWxnl8mBFVDj4qe6qNQfX3bz4SfaSIpJv
Yt0pMOFgv8Xe2x5eU0Q/LhW/yV7OwY07d+k1JyqiixJWBhJDbBySJs8ywIqo
tVhp76kzbNxjeq1OWkIJ2dpz1nw4MYAdzR3UF01TQue3BeooOw3gH5Zr/TZL
K6EJwa+ofeR59fPeDo1AOSX0W1vMt8JsAFc6rQkYUCRWRos2LhrASefbljQs
UkJWox52Fd/7sXXRiiuxpkootfHQ+HqTfly1+D3MvaaEmp1eaziK92E36QwJ
DZmZyM9Ydnu9fQ8uSl1oUHVzJpIq03Ir1ejCDZv0q3czlVGoT0l11e0OzHe7
t8chShlpF1mXvI39hmt2peydMVMFTbZ/e6se1YgdN+hnZsapoHt+tllqiRU4
7ds5919qqui9y5UNice9sGaosGmI2HVXlcvUIi9cuObMJrG5qkgHurQqajzx
uygv2QXETLsjP7dVeuBRI6csZ2JGgaPWoQJ3bPLcrPsP8SWuhOe5ey64P5xl
y52niugajfpXxx3wKb3oqinijurmQZlaezzVLbdCQZ3cz2mvcUylHankaUJt
4huvrXrTCmyxPo9/25vYavNqldf39uMox/amUeIkv6yV01x2YRXGoU2SGqpI
aaqxeU6VJU4ra05TIi59Yr5Lq9ACF6l89F5H7FRassky0Qz/bKhS8Cd+22Ys
Eu2CsFsQOhNGfEKh4jsq0sejy8ra7xAXe7GKjiStx9JXCp+8IL62dsHxB66r
cMzqNUp1xIoqXwLDUpbiOT9zglqJ3z+oXlR3Qh1nXNfs7ic+KWaUouzFwDqb
Hpn/JV6oc/1//3eV/x8h6tFh
       "]],
      RowBox[{"Sin", "[", "x", "]"}]],
     Annotation[#, 
      Sin[$CellContext`x], "Tooltip"]& ]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJwVmnk4VV8Xx7koma7pXmOihFRSUvlFeyckVJKhwRRpFGmgMpfQJCRlKFJK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       "]],
      RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]],
     Annotation[#, 
      Sin[2 $CellContext`x], "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
     0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242288447]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71232987],

Cell["Create filled plots: ", "ExampleText",
 CellID->594811598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388733632],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14013362]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122198397],

Cell["Create an overlay mesh:", "ExampleText",
 CellID->130631304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->766762485],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81904647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266062213],

Cell["Style the curve segments between mesh points:", "ExampleText",
 CellID->207010765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "None", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->643226829],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->729351141]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28841],

Cell["Link curves to external information:", "ExampleText",
 CellID->523612379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Hyperlink", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       "\"\<http://mathworld.wolfram.com/Sine.html\>\""}], "]"}], ",", 
     RowBox[{"Hyperlink", "[", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], ",", 
       "\"\<http://mathworld.wolfram.com/Cosine.html\>\""}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1965258634],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->631660686]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(55)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->616814996],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AspectRatio",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->624645531],

Cell["\<\
Choose the ratio of height to width from the actual plot values:\
\>", "ExampleText",
 CellID->120205381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417624274],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->520622674]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Axes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20803],

Cell["Draw no axes:", "ExampleText",
 CellID->119855387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175497594],

Cell[GraphicsData["CompressedBitmap", "\<\
eJxll1uIllUUhrfO//tbZqZNOdo0TpOamofMPJaaWlOmZdJBorqYhmDmoiZs
uqmLtIN20A5q5Vg5hXayLowGIzCIhEiIhEiICsIg7CIJki4GgulZa/3btdrB
zDd7v9+71nrX2mvv/c3NHb1d9z/Q0dvd2dF6w8aOh7q6Ox9ube/ZCNQwLKU0
wG9PU2I8xEh/B4aG+LtWng0//fhH3+6jPQ9+kqrLl/alyvp1+x579LN39h87
efKve5R3kzyrR7785d67P+i87yNeHfv2t1QVtHbq1N+8wMGGO97l3aeHfhgc
/CfdpXY3yrNy/Pvfu7sO4vLEiT/PUU9E3LrlCww+PPCdsDcou13ZzPv3foMB
ZucpQoSdO74i9NGvf71Tmder7tOnBx/pPQQ5NSoPucz5weB25V2nPHCEieLx
OscNzj4//HO6TVmrchVgwU0T1BveN286jEwErVfeyuwNccJr1jkJY0dq6VZl
rcgsCiqsFp3zHisKldYp69qcAajYtuY5ZZKMblHWckURAIrqdKnOeY8yqdva
wKJEVFOGk3VOfvimFGmNspYpigJ8yXBqzhoWT1vjtDSrJSeJMC3kLOpXK+ua
rIscWaY0I+hEhFeU8onv4WeshiN+Vta7fdsRGar+ium1DmpQ/tVhXWQ4W+cf
HzzOElMpU1GBTiNREIRUgx1GmMpwTl71eq0XaQ+iFqn0OhplnWpqu0S5vECe
DOcWq7cgx6SDoFDes9RusfKYokXqNq9YT51X0IAsCzgq2EHCuQzn5xWu56ja
KyRinc1gtNotymtM4jJcmHPEv6zIzLxzCAbEizFqtzCvFDqlNxaHbmVbp+m5
921Dk+jYYOd1WZL3Kjwr65RQVSxxJnUYp9YLiupYl6ETadIvbf+1JYbk3hhs
vbuX5chA1rot/7OWzC5U6/mhyyXyinwiEZnSoXuiWhMPxW7dFKx9dVblTmX1
QXGjUaoMqDO9RDXEWn2mq9Sac4fayrA9n6JowQGNLFw940agkMjE550doc3B
h/eynqg1ZLN3iAebXmF1pa+1g0eSCSEpBenBsAqzwJPU37ziFNATZAT6reWQ
xRWAjAa5Dmo2XbO6nxnySFwUtwVPrkzPyCqBiG4/svP1/EhXFlEfD6h7MHRu
wd0UUOcaekVR4c0B9VUzdE5xmjwRUOcaOrvgPhlQFpoFcnRW0dtPBdS71tCZ
BffpgNJ+dI8MDb282KlbAur7MKIQKb+jM4pKbg2oV9LQ6UUlnwmoV8fQaUV1
ng0obUlfO3pZkfFzAfXqGDq1yPj5gHrGEfWMDZ1SZLwtoJ6xoZOLLLYH1DM2
1O5dQhFQhi8E1LMwtK3I+MUzqNx9L+nskiLTiHqmhrYW3JcD6ud/RD1TQycV
VdkRUOca2lJwdwbUuYZeXHB3BdS5hjYX3FcC6lxDLyq4ryo6Mdeh/rX1WkC9
ZoZOKGq2O6C+zwxtKtarL6DezYaOL3pmT0A9C0P1ZpCvlfpXzuuKXpCjQRdl
bwTUoxnaWOzJNxU9P+fG4SzfLXsD6h4MHVdUsl/Rsbmb0SD37FuK6j0Uvkjf
DqjvB0PH1Lt5n87Orc/262x03hUgMjR0VPbOJSM3vm6jdLaiXF/UXr5v31N0
pDwrBCRv+5p/X3H9KqyROSVhFe3GRZp82R9wRtX+D0AB57TUWJcqDYRnGvYv
nYkiEA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9225530]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14406024],

Cell[TextData[{
 StyleBox["Draw the ",
  Deletable->True],
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 StyleBox[" ",
  Deletable->True],
 "axis but no ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->189914434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "True"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101784242],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->398363028]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesLabel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6006],

Cell[TextData[{
 "Use labels based on variables specified in ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->63765685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "u", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->301560927],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140234398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->514677278],

Cell["Specify a label for each axis:", "ExampleText",
 CellID->430834034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Sinc", "[", "x", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->405251636],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->584073196]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesOrigin",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22620],

Cell["Determine where the axes cross automatically:", "ExampleText",
 CellID->59461538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}]}], "+", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "4"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->684374975],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42810425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113516430],

Cell[TextData[{
 "Specify the axes origin at the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->80022854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}]}], "+", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "4"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218910921],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2192680]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32670],

Cell["Specify the style of each axis:", "ExampleText",
 CellID->393797997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{"Thick", ",", "Dashed", ",", "Red"}], "]"}], ",", "Blue"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106363442],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88680977]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->783172295],

Cell[TextData[{
 "Align graph by the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis in each plot:"
}], "ExampleText",
 CellID->240808472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Im", "[", 
      RowBox[{"Zeta", "[", 
       RowBox[{
        RowBox[{"1", "/", "2"}], "+", 
        RowBox[{"I", " ", "t"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Axis"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"Zeta", "[", 
       RowBox[{
        RowBox[{"1", "/", "2"}], "+", 
        RowBox[{"I", " ", "t"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Axis"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22380555],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->897474956]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ClippingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->252139847],

Cell["Omit clipped regions of the plot:", "ExampleText",
 CellID->779958163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->525026018],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563726368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13073618],

Cell["Show clipped regions with red lines:", "ExampleText",
 CellID->516664253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2143421572],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWV1oHUUUntzde2+T2vz/J8YYa8X/qohP2vzHIiI+2DyEPsQgJKCt1Pii
D9EH9cW+1Bcr0j74A1qFFmuLUGmxIBbFiFgRFaSiRMQiGHwICOt35szc2Tl3
d+9N7g1kd2bnzHfOnPOdM7N7H55fXnziqfnlpYX54ZlD808vLi08Mzx98BAe
BQ1KqdP4f7JXoR2hpf9PRxHuc7jm0J3Vvb10Dda+/H71wEvRyopqoUuA4fXf
/qShfTGpUye+OTx3xJNa/fp3Xyp3/NhXrQkaXnn5wtkzP1CzRfeT5qrg2eUz
l774tZLU/rn3rlz520pJTQ/tPb6+vpGO8aB+ChEIUrM1UWraIKvwpx//Wnj8
A/1Q5XAL9FPu81/Bs2KKrnnyt/5D4/nnPlF5q8U8DdL6nhWjuIZWRRwS7qwG
kbr7Uqx65+3VLVpVjvXpuZ8ZKyw9NT4pVIlw+bs/GCEfR6ClFz3vluISPPrI
W1ev/mutzJmg0D2fqHNGP93Y+G9q4k1qtmVIgV4gmZVy2nkUFAVRK2GcOnn5
8KsXK0kdff0SApGm6cUXzsG16RiOpfBfyWWWpblYDAQ/TZyQAjZGYTwauc2x
M8+zEA4ERdWAWLINTw8e+KhqJMFzkmf318MWDlENSDZKNg5BlBSX6civbe2p
WCoAhUHkdClte7C29s/sY+9Ss6OcAcHFz35BYbKjaRhYOdafhuGqehYGyieK
aLrUpPYrFsR0NB6K+zUXY7XvNT03D/h4WLg8e5EKN8loqmi1IQ7rPnLCrP2e
mL2vHfl8C+jUHaJOERUIkUWygS7gAsIA0qi7YhpQoCpoiFeHuN3X6j62cUCA
Qcxxig4ijUieeP/b3RqgGPlVZqfp6103z6GspD++Qlm1B3Uf6kwVzRt8vXeb
OSPCBh0Dta2irp2iv93GCi61fLM8i+8qdGe7UG+XFk9SU2sLmC+wjLHLtNOR
rIHu/CgwbqFR2820eMAwU+7YbLnL5S7hxX7dR/QQOuJIkx1HeSVrb6jC2q36
EyxH+KxVtM4BG1MMUbPJIiNH2KCRutgzYvQ1R379kd7ps95BNiH6qtHMy9kY
wyiMquvrZlW8f43VjmQhLd2J1iHtkN/UbBTzGR+1ALGn+cNVWGlPU3YP2mXu
bAtvu9TsNs/7hQebYvPjvBsSuEzwHm0RUFFOAIx1hnvuP6pCuBtHG6wMZl8X
8VtDj1h9r+6703eb8MZNWkMnXYuQAqOQvMhJQAGBuK1rTgE1DMmJSRjGbgaN
XOFgj9Ek/d4r2NsuNO/SmrU9Ba6LUMulESTS3A+hH/sm1onwDIg49xgfcXzd
OZZ3R9ho9Nyo9XA9Re6iDkIWY3RW5rcWTESVhiITJ3cyld7ssYw2VavLZiLi
QDZpG0Pg4dwECDiHD3WaFwWshqs/9hsIoNtpbTV1RPosWb8bZ58jMGZ+j+9N
LBTLxXL4xYds+dBmFGcavSfAGrgDJKQVyB1TVkpmOPwIjbSvFSvIB1bevAm0
psmbFTanjZszWOJ4Y6kPk2AYE5STV+3wfYInaMBZiZaqm3WTYWh9BSG13UbM
nOd6DQs5Mu5tRTOJ9nvIYekIkfZcHsvkJDIM3JZoxS3CCua0O9X2Cq8xD9w5
ctDmLHgJXbABgjAmtHleymUoYHdwZNStQjPXC1c/+hI1u+wbshnFpFY5HKxU
ES2IoGgBhUsW7RN6Veo2q8FwuFVwvM94uFtYovdcqgewhNC0T9TtAq3ZSpmq
0S/s7xJxe0Cj3BFF3p6wQ0Q9GQUQAHIodwoU5g6sQiDJ4gFvZW534Nm77WwU
ElqJ3jNQlgeF7k6Lar7E7NGz9SmWdiJQnuLIPHOVKxnFVT5Gudt6ExZjzGSD
Y4fd6bPeNOyJr0v4kDXo8zzVeeiFm8BvxuJCaXUknOozz/mlM4O3OuCjyjnd
9+pswCOsjlOB3wKst7eilbqdIltZ2302MzgVuZLWuK4Oy27zNWZUT5uuAtme
9WX97RA82Rxi3FZ74mdvuNMqI85E/tt7GLuX2+Myi2fPJUrBZP6AE5NyFrgv
mskY7TY+5u1lLEPK+WfM08R2uGqSheEqXBKG+4Y75vmr7NtiRixZDzZOpJFD
Ko9l5S8ykneMjHpuxmtDpi7vM+6cMF43WxnZnbHrjeyYXRsyRVAyY9yLvfzy
JePdJpgzXuJVuZSrTk7KWeC+jCVjlM7NJlcmMqTc29CEp0m+iaRj0K436Xki
KQv8XxPynhZ3MprIilHGN3wZe16be/upL66LTi241GU8V/sy8cp+d5AMaxFx
n8xCK/sNQn4jYzR3ovNjnLQz5Eorcvk8mcgbxnaVOF2K2DVVGnUaHGeyNDgG
TCZguDhKjGMfR+fPAwOXYGrsDZNtQmp9dDoaHYUULsHZ/SvGlb6mWX+OkeEv
sarhf43WyMA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->412506405]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->294710028],

Cell["\<\
Show clipped regions as red at the bottom and thick at the top:\
\>", "ExampleText",
 CellID->1299715350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1372732424],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWU1oXFUUvpk3P01qk8n/rzHGWvG/KuLKNv+xiIgLWzC4iEFIQFupcaOL
6kLd2E3dtCJ24Q9oK7S2VIQKYkEsihGxRVSQihIRi2BwERCe37nn3nffPfPe
m0lmBjLz7rvnfufcc75z7nkvD80vLz759Pzy0sL8yOzB+WcWlxaeHZk5cBC3
gial1Fn8PdWncB3iSv+dDUP8zuE7h+E+PdpD38HqV5dX9r8cHjqk2ugrwPTa
b3/S1N6Y1OkT3x6eO+JJrXzzuy+VO/7W1+UEDa++8tnH536gyzY9TlqrgueW
z1388tdqUo/PvX/lyt9WSmp6cM/xtbX1dIwH9F2IQJAuy4lSMwZZ5X/68a+F
J07qmyqHn0Df5TF/ip4V0/RdIH/rDy5eeP4TVbBazN0gbexZMYbvvFURh4Q7
a0Gk4d4Uq959Z2WTVlVifXr+Z8bKR3eNT4o1Ilz6/g9GKMQRaOslz7tRXIJH
Hn776tV/rZU5ExT6LSTqnNV319f/m558ky7bM6RAL5DMSjntPAuKgqjVME6f
unT4tQvVpI4dvYhApGl66cXzcG06hmMp/Be5zLI0F4uB4KeJE1LAxigfj0Zu
Y+ws8CqEA0FRdSBGtuHugf1nakYSPCd5dn8jbOEQ1YFko2TjEIRJcZkJ/drW
kYqlAlAYRE6X0rYHq6v/7Hv0PbrsrGRAcOHzX1CY7GwaBnaO/adhuKqehYHy
iSKaLjWl/YoNMR2Nh+J+zcVY7XtNry0APh4WLs9epPIbZDRVtPoQR/QYOWH2
fk/M3tePfLEJdBoO06CECoTIItlAF3ABYQBp1F0xDShQVTTEq0Pc7mv1GMc4
IMAg5jhFB5FGJE988N1ODVAK/Sqz3Yz1qVvgUFbTH9+hrNpDegx1pooWDL4+
u82aUWGDjoHaUlXXdjHeamMFl1q+WZ7FTxX6ZbtQb5cWT9Gl1hYwX2AZY1do
p5asiX75VmDcQrN2mGnxoGGmPLHZcpfL3cKLA3qM6CF0xJEWO4/yStbeUIO1
m/UnWI7wWaton4M2ppiiyxaLjBxhg0YbYs+o0dca+vVHeqffegfZhOirZrMu
Z2MMozCrrm+YVfHxNVY7koW09CRah7RDftNls1jP+KgFiD2tH6nBSttN2TNo
h/llW/jYpcsec39AeLAltj7Ou2GBywTv1RYBFeUEwNhnfvf9x1Qe7kZrg53B
7OtCfmroFbvv02PXfbcLb9ykNXTRdwlSYBSSFzkJKCAQt3XNKaKGITmxCNM4
zaCRKxzsMZqk3/sEezuE5h1as7anyHURark0gkSa+3nox7mJfSI8gyLOvcZH
HF/Xx/LpCBuNnhu1Hq6nyF3UQchijnplfmrBQlRpKDJxcp2p9GavZbSpWt02
ExEHsknbmAce+iZAwDnc1GleFLEbrv44byCAYZe11dQR6bNk/W6efY7AmPW9
vjexUWwX2+EHH7LlQ5tRnGn0nABr4A6QkHYgT0xZKZnh8CM00rlWqiIfWHnz
JFBOkzc7bE2bNz1Y4nxzNIZJMIwJysmrtvk+wR1cwFmJlqqb9SXD0P6KQmqr
jZjp5/oMCzky7mlFM4nOe8hh6wiR9lwB2+QkMgzckmjFLcIK5rTravuE15gH
ro8csjkLXkIXbIAgjMnbPI9yGQrYHRwZdavQzPXC1Y/+RM0u+4ZtRjGpVQ6N
lSrhCiIoWkDhkkXnhN6Vus1qMBwuC473Gw/3CEv0mUv1AJYQmvaJul2gtVop
UzUGhP3dIm67NModYeidCdtE1JNRAAEgh3KnQGHuwCoEkiwe9HbmTgdevdOu
RiGhnegzA2V5SOjusqjmTcxuvVp3sXQSgfIUR+aZq1zJKK7yMcrd1puwGHMm
Gxw77Emf9aRhO75u4UPWoPt5qvPQCzeB34zFhdLqSOjqM/v8qGfwdgd8VDmn
+16dDbiF3XEq8FOA9fZmtNKwS2Qra7vPZganIlfSOvfVadlt3saM6WUzNSDb
Xl/W307Bk40hxm21HT97w3WrjDgb+k/v+dhvpT0us3j1XKIUTOYXODEpZ4F7
o5mM0WHjY55exjOknH/GPU1sh6smWRiuwiVhuHe4456/Kt4tZsSS9eDgRBo5
pMpYVn8jI3nHyKjnZr4+ZBryOeP6hImG2crIrsduNLJjdn3IFEHJjAkv9vLN
l4x3u2DORMSrSilXnZyUs8C9GUvGiPpmkyuTGVLuaWjS0ySfRNIx6NSb8jyR
lAX+fxMKnhbXGU1mxSjjHb6MPe/NPf00FtdFpx5cGjKeq32ZeBX/d5AMaxNx
n8pCq/gfhHxHxmiuo/NjnHQy5KIduXyeSuQNY7tKnC5F7JqOZp0Gx5ksDY4B
UwkYLo48+5jdMSQW5k+qMrXIwdiuN858dFlKARZS9KBfpi9U26OwVEpRr8Kf
dloQcKl3kY6sNnf5Da1q+h/XttNn\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388962683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28339071],

Cell["Show clipped regions as red and thick:", "ExampleText",
 CellID->112230166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1643613234],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30806770]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19205],

Cell[TextData[{
 "Color by a scaled ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinate and scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " coordinate, respectively:"
}], "ExampleText",
 CellID->4524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sinc", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sinc", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->25078],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->509467862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->460288641],

Cell["Color with a named color scheme:", "ExampleText",
 CellID->1901637531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->835092793],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWM9zFEUU7sxsshAIv0JINokQkKBoCZalFibZEFjYDZFACEmWQyxcIlW7
pdFkswsYBEX8CSYklFWWqbIs+As85ECpFz178eTFf2VK33vdvZm86Zmd3Q3F
1ux0v+7v+/rNe90zPTOcKWSvTmcKualMVyqfmcnmpua6kh/locmuE0Kswj/X
JqD+H9Tov+o4DnS4zlE4W9Blo2VDhVoFVR9TvQHPEdkjO+sZ1m1jdUW226ob
flYJ5pKRyi5ehNm96FvP2BIpQYnVKJwu+vgVZXzboCdsEOibeAgHaQk7PvGw
d2wJDjFagS5eUQ+W8YnlLdQIClCPp5fFBR+dSGAksXqMbNBQ9jYaIb18fl2u
Glylm/0G2X3ji/3ppX7woxlxUB8mditDt8EJnYkhCkg6X3huJixQFVaP2KnK
dihRynLPHs8IMTZPcERRfzz9wNE/bG1hY3mj1B6iBT3BSV+HpdGbdmbvIbvk
DcmVfJHN8rqegi8dzN6NpyiLTGDULEOsMRMdG+WNPZBeVLbOcoxFzDaOV008
2jwcmYmBSwt6LGdt5onIWruck7V7oOMnxz0xeVe18xVKOBjefXfrcPmmV4P/
qjjKRjgo7XfuKJvuKscnb9Ub2Uck+t2byj7E2PIOcjJzAxTgEMEq88p+gang
ncQCkU1G9itkJz7IKPuwHHOqqOzXiP3ebGMo9kuMfZTY2dxWYuNc/Mk3lnzm
NjHtLayfP2GayvTLJ0gim1V2C+vfgb4m3r+y2aTj8fZl5t2rTL2b7FMfToIi
VncaVWS8UoXz7mifmr58ULNV+65Q7Ncla/qysveh2umZdIuRfZix3yT79Mwl
YGC1U7FbjewXGfstspOz48n8mKPuAlYyfzEWii2f5qm50VRhBKvNqn8kNXcB
ROTc8KjImT56O6Hsfq06WDyHVStZGGokPwpDwh4sDkM79Iq9odQGyAYWsAev
vQ3CxUH4pywoRSRZOAON1HV2v1HvENPDknjAh+PM9SGtZkPjgVAas4TCley3
z+Ozvpsp5AlLu6DAfWC1Onwfw/dtcmbnFuLKnvPR4fs0/dzqroHvtp9nOgUf
He8OhkfGrKRzpHdb/NlzgLGKjin/4VD7GepaAGrh0YlAVBdDXX/qqH0MdaMC
1LqVUF9Cy0R5Yk7r3v5lNaXsj53q5nBYHZwpEcOMeY7x5wP4/N0Mr5aP78fX
eB6HTsa/uSF8nYtyb24djP2JY8q3RP3957kNQLUz1K0aUDGGul0Dqo2hPg1A
/fv7aCCqlaE+W5cTngNTVs0K1dwR9zClO89ICa+SK3weoGAboiJ3if/8PFKG
z3n8Ssw67jVjGa5/N2PddUy5D4dqZqgvakDtYqgvA1B/zQ8FonYy1FdG1A6G
+roCVCWrYDtT+Mapdu5unNI2sv8Y18++b32U3PdrLLeH5JX3oIkp3ataaStT
ur8uQ367JTOLZ1++If6W6FP2d0ZUI0MtBKB+jfcEojYz1KIRtYmhHhhRUYZa
qgHVwFDLpSjrL33l1gHdP0Hge2Lyd2LvtzTz2zYIPOk9BoeoSGetRXnxQ0i2
HBXHkz/k/lgJNyK50umVKq99pRRt95yWX+C9X+1F3f90dQpP\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109290114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19973],

Cell[TextData[{
 "Color a curve red when its absolute ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinate is above 0:"
}], "ExampleText",
 CellID->22638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"y", ">", "0"}], ",", "Red", ",", "Black"}], "]"}]}], "]"}]}],
    ",", 
   RowBox[{"ColorFunctionScaling", "->", "False"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3815],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WFlv00AQdmsn6Z0ebuskbUmhBzeiUqtSBEI80BcO8cJ7VCG1DwjUlvuG
AgXKKQRSJV74Df17EczY3wZ7PeskDkSNZ3e/75vZnR3b21yqbK5ev1HZXFup
lJfXK7dW11Y2yhdurtOQ3WZZ1h591zyL2r+p5X/3qtUqAaFrjq7tBNncs6nh
j1p+85ffzvLVCZAAzGjccJ+bZ+mSpe61ALdBo097jR5yF0QI6R2tf5oufdS9
aphPTuPbWn+JLvkm9TzTU1gHT7iD7BWD3knMEDcX6MKEXrIZspcjuc+GbFg1
D9UA7EVfNaqxPKAefA+ir7yPwRbJsqw9vOMxbwVtb0eRAxfqTGytxQZGOCaX
ZBtbMW5R6w8j5y5WY/+nuCWtPxTKkp6H2ngkRgn5LP2D6IOI4sCnh35QYuoT
j5Rm5V5M42rRCyo67uDajFuOXUAEFVGvfE+LrFat6ljVr7mOj8PDFOwS6sgR
2cfAmoFdrAb3UjJ7Fpbv05yRfZTn6T8H/44p5Rxm1ZmoPAL2CfR51d2+gvP3
05gDvbp6oe/RxvXnbW8dnPfXJj8j2nieV0PjHZI+NrvDmM1JeJuGekBkHwJr
DqxJ3qFq8LST2ex7HuxxsF2RfRC+F8Augj1iZLPvxRCLrSeyZ+Gb6y9Lth+2
aGSz7zNku6pBRbEdE9kzYJ8j65KdSGSdJ9tPtiyypsFaJpvDbgQ7aTod6FWh
PGz4HP+dmnhq0PVT0G8a9PozQn/L19Prb3n1HlS6203owv0DdfTx04G+8v3w
cCeSc3Uq0M8SUba+j5NA76ZAuTLsRJS190R0H7RmlLX3RXQCWjPK2geR7Pi7
n6mxgsTGchXVNl9T49A/TNhbR9jRRnT6CZpXpXSPDDrF09c5llJXgu5xJLf1
ztNRlXSSsxNR1j4R0QK0ZpS1T1OgHtBnKdBRoM8bQKUnJjel7I9A+cKwa/Wf
HK17GEbGm/PAq1GxXyYobWHVLiKadDpfn7GLuFuRfKv/dnT2EKJtiXs3BF+v
RHQQWjPK2tciOgCtGWXtGxHth9aMsnZbRPPQbkey00g15uH3bVOVEPbQh9it
eeA5vDN4CD/H2Cr++9QRezDn1jzwHHYiGTe9vbsRb0fcvS6gH4woR/ooop1A
P4loBzzLaA7oZyPKnr+IaAbaryLKlZepof4sLCt2hpIyZcPvN1/ZKaDJ+8Ix
nCb0wT3iv46toNYs63sKreXPxbJ+NKN1anHpbzflindrOQ5XYPArXvyXP6vt
D/EsOOQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59935184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24041],

Cell["Fill with the color used for the curve:", "ExampleText",
 CellID->24485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15063],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76746844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->293157448],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for coloring the curve:"
}], "ExampleText",
 CellID->147068490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26433733],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WFtTHEUUbrpnIReRQBA3C0ZiEuP9WlqRTVgg7JIoBGJYrCImSFIuQWMg
yyYhSsRoNJGNgKmUVqUqZZU/wAcrD+qLPvviky/+F0rPOX1mnentnmUXpZqe
7vOd7+vTp3tmenZosnD23Q8mC9NnJjsH8pOzZ6fPzHVmZvJgUnVCiPvwPx0X
0P4bWvR/f21tDYBA3QC1BEhhT0GDrIKa31O7HmtPIxqMGb7BPja7oarvGl0d
07hiN/iTJfeAnB4hwPeMfhKqLaDnJUdXjzliajA4yuh3UR8EuqiITVBJ6KJt
JZldQXikCm2cyWtaM7uCEigFmjg5vPq6UISEatih7UVmF5uvkseBLKuBbCNY
PBRWB7LL7DUYWs36wDWo9QprLYOcVmxGLTBo/sOGfxxR6MbZK4htY5s/Zgdf
E5gBXOvgzipT3mHsIY0fzH5FwS0LaYzWgqpgi5XlK7EOC8aCt0QdXq3xJIz+
Qzg7CAdlWv2sQV8X9T9F0W70t1O/2x+WFMysYdJk2VjtnP32/yCKFh3F2FJ3
9hbEQntW8q6QGBZgRY7IPmYtuYiXcVo5jiLGMbZUigP3Epr9J01pDhuOYQeP
gCPL1Pg1ygJj5lMqbkQhAquQWPv3XnDfE8+hAoyyh64nFvGZ5aXevupZvZ+l
fmricurkAhTxOLP2k71n4hIwoQhZSeHUfOrUFVTYR7M8sQjsyTn2eVmrnZ4B
QSjCHc8zyO59b4JiYhsqothLdD09Q3Ex1hCp8jQzn8d+T25KAnsrMXAt7jlz
aO7dRtZ7wLCbq9dYAce9onpzuTbD3kT26XdgZrkptlnfZ2WRPsWRvUjXXE6o
vvdPMrabaH3nxkFZl2arxpPITeeHhAIhtr2AuwakdtH13LjA8BjbFqmCbwcJ
TKEOnR87dP4txPCpDt2sBKVWK/sJ9AC2fk8RM9s/M9o/+6Z+pvbPHgMLFCGh
anNqYAR678LQ/TPHQUDI9IURZHgggvYs+9tV9nEk9K6vBz6w0/nhdP5oZm4Q
7DR7DxpgSV8YhiJBN+HUwogOYieGhPwQqGTm3sgUXhcyUziiBi4expVV0BYx
sCJG44A3Rj7cYVXG+1SOLPT2kJ1kS5oSNEF3gK5hXS0tdkZq9pEdOYUjSDf1
EOq0KuxlhQHKEbgDSxec517ibFpznxXN+8XXmyMfutcjz5Amfw/zCw6+eY+Z
571KfPNM559WiDdVTF6sghfs767ALz/vmTN/jBUuhXLun+jM02HY21zVXYxe
rgGlfaKK36XAA4pwe0lwmreij0KlIlHkXrGiO5nrRpH7YShLtAtiJS+d4LKc
hbnV761HkP/Dj+mPItbYs6zsenjmdxXOyuctOHi+nznPjhp57cy7GsptpS+s
MMt+vv7jt0HwgCLcXhKcPraidM6LRJG7WAMaZ/STGlDd/+uXEfDApttLgtO1
UE7NHNpWo42ZnzpWsfITZeMK+DWkqlbA2fhjfxbBVJZZt/KILp7pb0ZMJ/Y/
7x29Hsq3/61qeuN3lip5m2u3nbU+t6ItzHWjyP3CijYz140K9fv8YfDApt0L
TzXodMOJSkBvWtEm5t4MZWk9u7KJdb+sakcEFR5kBaF+PZ5i240NqZESKGLT
FVfwmYdXigJoxZpHxi8LtWEFjOFWaBVcb/yt7C3Uz71dbFuyru4W9ASnYIaL
kZ7LVnQz9X9K7tcDCrsXxo1OK1a0gdFVJyoB/dqKxph724ribo2VUIpCiLJz
mS2TinXvEHOzBY1eNxzDq4Kv/DxCG2uM+psauPiH435bDdcrjQvlbo0zvlvK
cXCH6t+Jy39bFnX/AGqdbuA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308320653]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->132966000],

Cell["\<\
No argument scaling on the left, automatic scaling on the right:\
\>", "ExampleText",
 CellID->233969651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"4", "Pi", " ", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "cf"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"cf", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38928736],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10085188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20307753],

Cell[TextData[{
 "Color a curve red when its absolute ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinate is above 0:"
}], "ExampleText",
 CellID->18827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"y", ">", "0"}], ",", "Red", ",", "Black"}], "]"}]}], "]"}]}],
    ",", 
   RowBox[{"ColorFunctionScaling", "->", "False"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9583],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WFlv00AQdmsn6Z0ebuskbUmhBzeiUqtSBEI80BcO8cJ7VCG1DwjUlvuG
AgXKKQRSJV74Df17EczY3wZ7PeskDkSNZ3e/75vZnR3b21yqbK5ev1HZXFup
lJfXK7dW11Y2yhdurtOQ3WZZ1h591zyL2r+p5X/3qtUqAaFrjq7tBNncs6nh
j1p+85ffzvLVCZAAzGjccJ+bZ+mSpe61ALdBo097jR5yF0QI6R2tf5oufdS9
aphPTuPbWn+JLvkm9TzTU1gHT7iD7BWD3knMEDcX6MKEXrIZspcjuc+GbFg1
D9UA7EVfNaqxPKAefA+ir7yPwRbJsqw9vOMxbwVtb0eRAxfqTGytxQZGOCaX
ZBtbMW5R6w8j5y5WY/+nuCWtPxTKkp6H2ngkRgn5LP2D6IOI4sCnh35QYuoT
j5Rm5V5M42rRCyo67uDajFuOXUAEFVGvfE+LrFat6ljVr7mOj8PDFOwS6sgR
2cfAmoFdrAb3UjJ7Fpbv05yRfZTn6T8H/44p5Rxm1ZmoPAL2CfR51d2+gvP3
05gDvbp6oe/RxvXnbW8dnPfXJj8j2nieV0PjHZI+NrvDmM1JeJuGekBkHwJr
DqxJ3qFq8LST2ex7HuxxsF2RfRC+F8Augj1iZLPvxRCLrSeyZ+Gb6y9Lth+2
aGSz7zNku6pBRbEdE9kzYJ8j65KdSGSdJ9tPtiyypsFaJpvDbgQ7aTod6FWh
PGz4HP+dmnhq0PVT0G8a9PozQn/L19Prb3n1HlS6203owv0DdfTx04G+8v3w
cCeSc3Uq0M8SUba+j5NA76ZAuTLsRJS190R0H7RmlLX3RXQCWjPK2geR7Pi7
n6mxgsTGchXVNl9T49A/TNhbR9jRRnT6CZpXpXSPDDrF09c5llJXgu5xJLf1
ztNRlXSSsxNR1j4R0QK0ZpS1T1OgHtBnKdBRoM8bQKUnJjel7I9A+cKwa/Wf
HK17GEbGm/PAq1GxXyYobWHVLiKadDpfn7GLuFuRfKv/dnT2EKJtiXs3BF+v
RHQQWjPK2tciOgCtGWXtGxHth9aMsnZbRPPQbkey00g15uH3bVOVEPbQh9it
eeA5vDN4CD/H2Cr++9QRezDn1jzwHHYiGTe9vbsRb0fcvS6gH4woR/ooop1A
P4loBzzLaA7oZyPKnr+IaAbaryLKlZepof4sLCt2hpIyZcPvN1/ZKaDJ+8Ix
nCb0wT3iv46toNYs63sKreXPxbJ+NKN1anHpbzflindrOQ5XYPArXvyXP6vt
D/EsOOQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227389771]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46892398],

Cell[TextData[{
 "Use hue to indicate ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction and brightness to indicate amplitude:"
}], "ExampleText",
 CellID->2016335543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"x", ",", "1", ",", 
        RowBox[{"Abs", "[", "y", "]"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190566020],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15714235]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Epilog",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11812],

Cell["This inserts the graphics object in the resulting graphic:", \
"ExampleText",
 CellID->148959388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "0.04", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"Pi", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "Pi"}], ",", "0"}], "}"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3010693],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75993089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257764008],

Cell["\<\
Insert special markers to indicate whether a point belongs to the curve or \
not:\
\>", "ExampleText",
 CellID->507292931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", " ", 
   RowBox[{"Epilog", "\[Rule]", " ", 
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "White", ",", 
          RowBox[{"Disk", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"i", ",", "i"}], "}"}], ",", "0.05"}], "]"}]}], "}"}], 
        ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i", "+", "1"}], ",", "i"}], "}"}], ",", "0.05"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141183270],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1vEkEUf91h22gI6aV2Y8p2LUI54rmphWqpkhhOjZyaEKJs40crNvXQ
pNz1ZuqBmsjFhIteFMORm/Fg5E/gZPgzxnkzA7sOuyy0MZrgJszOe/u+Zub3
3r7lXvHQfvCkeLhXKlrbleKBvVd6bmX3K4xFZgCgyX5HBrA5ZTP+a1LK7sNj
ho0hJqAjRVCSX1DmT0M46p1Ox7KsQqGQTCbb7TaYXLZarTLatm0wXLow0pbG
lICwSb1ev5Hahuj+08+gP370kZBZ4Fe324V5GVNIscMtMNJ2xdbr9VKp1OKi
EYvFvzS/gdn58RPIm9P3u7ulRqMBVxUbxDO2Wc5ltiR3bSytDA/K4fqtfFPG
Pev5NOfLddbqL3Nx7n8vq1SePgMM4g/xTHxPM0G9csJQZAViEO4sIpYj9kDX
nQPpdB7m6+++c7SzO7fA7jjVcNDPal913ZUb7hgE9hcWrphm7NXLT2AoFggf
Ks9eC3UZQ7K/WhmpGrmadcLjrbGkpgfpuEI8tWWJFVORirr4KNenOaZgziWN
J2N5aGvSuptvBuhpgk/kY3ZpfdIltUi962t0hDecqtGotPB+KcBKkBd1TUty
L/Q/Yl2VJ4PT/b2yB+l5xjHSgtitObk6izonrkncuPlIO/i5OH7vUlkFZF0R
eXGHOrUtl8utrMRfHNXA5HUkn3/IaKxlWS6LO7WFENNDodDx8THlFS0cDkOZ
I0+tASraLgc8D6KD9Pn+yhoZiURYncZ1TupV5E6r1WIs7CcmjdLb3vn1g+wJ
VKl7vxxA//16Oh1ezucb36r+/UjQm1lUJqe7yY6lxeuXrAQ7O/fj8cTbsw+y
uy6XK4nEKlaC6762iHznjdfxxyaISWS0YRgyo8X6WIaygDBD/WMazgCnC9oa
7PR09C//pu8gL6O/VjddXPCQSvfPXGbCeEjZoNSj3xfvf+cbWPQNtxVd5CIp
bDDpk5Mq5blwzboJSxvrNdDX1041TXdyQfO1NByVmgsiKicXyGDXRn+nZvo7
I+nYYD/xRA44NfzfAcz8Ahn1r0s=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168116867]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EvaluationMonitor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5705],

Cell[TextData[{
 "Find the list of values sampled by ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->28145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reap", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], ";"}], "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23281],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"Null", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"2.0408163265306121`*^-7", ",", 
       RowBox[{"\[LeftSkeleton]", "564", "\[RightSkeleton]"}], ",", 
       "9.999900201158699`"}], "}"}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{284, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->421515655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->556023555],

Cell[TextData[{
 "Show where ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->5447],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{"Reap", "[", " ", 
     RowBox[{"Plot", "[", " ", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", " ", "0", ",", " ", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
       RowBox[{"EvaluationMonitor", " ", ":>", " ", 
        RowBox[{"Sow", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", " ", 
           RowBox[{"Sin", "[", "x", "]"}]}], "}"}], "]"}]}]}], "]"}], " ", 
     "]"}], "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"data", " ", ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19718],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->749288408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->608954883],

Cell["Count how many times the function is evaluated:", "ExampleText",
 CellID->1722059395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "=", "0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"k", "++"}]}]}], "]"}], ";", "k"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1723218239],

Cell[BoxData["432"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1015141146]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Exclusions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->451634687],

Cell["\<\
Use automatic methods for computing exclusions, in this case for a piecewise \
function:\
\>", "ExampleText",
 CellID->679453048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62905889],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV11IVUEQ3nvOPVcxDIICyf+ICDN8iKIXEYLMKIuoiOohbpdAKzXUEvIh
o+iHjEApEiofsqCft8QIDCIhEiIhCqKCMAh7SIKkByHYZmfn/Ow567k/R6KH
Dnv3nNmZ2Znd+WZ2b2Oys+lQS7KzOZWs2NSePNbUnOqoqG9rhyEzxhgbhl9X
EYNvDl/4G+Yc3sG+GnoTBErgHYd3KdHlgis+OD7IF2QctVZruDYNPasI4YtP
/+wx7aylabSWks9+a/rZyjQ+GbRir++VOc3m99WevZze+n0rFl3cpYNrKfbM
4x03negJbpnnrYuezZda3vgX+iSHQkYLoL8HgzFVZuL1V2jMxM6l4z46Y/7s
7G/cFt2KPfR/fjjf0EayIA2dzko6/X9tfv0u6FEuc3hq6ufgrVfQ2ALRmY9H
3hP/hKNl5xozZ2ZmFemx558D0pnml390FdIfP3ynDMnHDJHpIVhHFH+qUbq/
70Vb6yNoLE905vHOEViQYB2N7M9ae8XkTwL9mZz8QfyU4s86lIbdI38S6M/p
ntGAdK7+DCn26pB7/tyzutoBaMwSnQlBIen9IXNYXNZNS8vN12EqIylBbsTx
6elftA8W7sP4yy8ktysjG/VIv3v7TameLhbkLAnaC/06Er5Rf+5JqTzuObE8
3K1czY444v3B/TfE36ZEoxGlwb87QxOutJsdrnSu0d+JNMxI/pg+Cw2KP7g/
Ao2KtJvbDZH92Ys0ZINynrkR2qD4sw+lL/eOESpM7CC+Aen5yY4DnGoJZYeJ
HVQLkq4NmYMuL/QYPAxjiFvlRuNHsj57MtMTJNYNsa87tt/WrWT9X/Bj/vTo
SoaP6dlZ8T6MGt0nnxBGDMSIi/A12pg125EmHBqIQ6jaoVrZIKsFaffkMzCX
INHp5lbjaIlVtNrxokpg+OpGTWR/2jlVJmXFUHGJX6X408G5ci4ZvnpcFdmf
LtFZTq2GBr6xlYoXKOM5FaQXLopXhNiTqWc/tkhIPqa7H+WkJchuXOme3Xdl
VdmyeRBQwZZHtezmEU9bayyvrNgP/ykXzLM4d0848e5BmwBPGQtInUrt7p+y
Y0Y4WxYZKWdwBc6pBA2+5b9lBylnUQbsOTLCdklk2xdw1bBYOSlAtEixexH5
jl0QLIps8xLOCbVA7iCkyBLFZi+nzJGRgMurwNPiEAvxtCeSBITME7uf7zPp
CkqmDj6UeQAlexEqeDHPMrabmxZLeD3NZp1hZ1A/RgRu1TIi0AT6CrUR6cNd
cOowtIU5IUbYvYZ24Tbl2B24Pi7/7QU0r6KsgypooDeHbDZovYH009FPdK5Z
ioc35+RGsmc59QWaQL8ZtGqBVSUeZta2WewPL8I6gg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->488901421]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2760467],

Cell["\<\
In this case the exclusion comes from a branch cut discontinuity:\
\>", "ExampleText",
 CellID->65528635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"I", " ", 
       RowBox[{"(", 
        RowBox[{"y", "+", "1"}], ")"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121800348],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWE1oE0EUnu7sJhjqrf4cbBIPXj17kQqiIiLiQTyEHmIQEkErMV4UQS/2
0l4UpMXaHPwjmkPEUhEqiAWxIBbEgqggFaQeLILFQ0BY37w3u9nMTpLNtq7F
ZbKZefve937mze7MO5wt5U+ezpYKuWz6QDF7Nl/InUvvHyoCifcwxqbgd2or
g74NPfxN2Tb8V8WdizFezEJqArujI7NDZx6Pj82VJ18/m/nEjPk3Xxmv139L
3jG4GSAa88gsLv4Arrt35kHmyuUZZgACM/ftnRjYPQ5tMFMhCjwDDgIm3KWl
nxJ3RGtTn7ibhA9NyIE4IgEitOPH7hmgArUR5eKFpxx5Zl98JqmFd9+KgCPA
DUWL8MTSak6jZvCbMACMUAGe9BTyNS40W9AhCsWNIR9/VFsgSYxgTtHBEb0x
ZszUWrETu+AAYVGUpQaaKRFYEV1T2MKPHrktaaa48evXXlLEmaVYlcD4A7LU
twtupsaOoJYOIHV5+ZfENxH/4YO3TfobNifQvvOl6ZWVuhDdE0gvd+aLTYa0
M6zcLU/et86aatPq0K+ztaE2IvE3tay1L53wnChzz1Mm1m3LiE/45i+u8Klr
nuRu2JTvRkj5YHobs+Tnt+x2maTn9/K1z9O4/NdzrZ88jXnnQXkzp2z/W9vJ
hqTmmVeuVRZt11oRVzhNX/RTilxMGW9Txv73Sr+PomZMUmsbQdGleqXXtMXW
v8tVmzdJvuCInVdL0vZm1gZ1dtZRXLu3zZS+qfQgNjmrXZ9/MR9/5wxUZ1f1
MqhVXpm01jrnXeJ8+1J28zumv8NzPWo0XzFhQ8WJJ+1XVZ42481d8nc71mbm
KsYbtTFQvS53GdVovhRR7zWi+b5Ft6NZ/Y4krJ5/vZP5P/fC0e24W+2j9PMZ
9gSVQeqT6ffyBNjrnADlCTGGJ8S5V1/kCZLDbUcgXY35Jx1wpJQYvQgEmE06
QKe0gTsnZ2swU3FP8fCcmc01BGh9If2+hF23hgEN7JH4bjUBGlUT3DoGtOGr
z5k463P0gg7KruYQloxi161pQIPZIA1YMjh0sEwVm0K+hhUbgSAjh/Ua6+OH
7141LfTcRHuoasHwElUbqgHlTlSFn0QVFAu8lDoYAx9ltt4XuYt+g43yead1
TtUt1vMHvWoUnQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30417837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->635260353],

Cell["Indicate that no exclusions should be computed: ", "ExampleText",
 CellID->746689756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"I", " ", 
       RowBox[{"(", 
        RowBox[{"y", "+", "1"}], ")"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->84608084],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWU1oE0EUnmZ2Ewz1Vn8ONokHr569aAqiUooVD+Ih9BCDkAhaqfXSItiL
XtqLXloUc/CPaA8RS6VQQSyIBbEgFqQVpILUQ4tg8RAQ1jfvzSab2Vm7SZOw
WSazs7Pvfe97M29md19Op4ezFy+nh3OZdOLUUPpqNpe5ljg5OARdvIMxNgO/
S/sZtC1o4W/GsuA8LWourvFgJvZGsTkxvjB45eXU5GL+wYfX819ZaOnjD8ZL
pb9SdhKqEKiGHTpra79A6vGjJdAZuznPQoDAjBPH7yePTkEZSBWoB+6BBAET
7vr6b4k7ruXUJWqD8KEIPVBHJECEcv7ckxCYQGvUMzoyx1Fm4e030lr+/HMI
cAR4SLEiPDG1lhNoGfwmDAAjVIAnO7lskQvLJjSoh8aNoRx/UVwmTRzBjGKD
I3rlmjFDy+IwNsEBwqJRlhZopsTAitE1BBd+9sxD2WeIit+9845GnJkKqyiO
/+rKhrR3BCpDw8Mv0yT2bm7+kfgG4j9/9qnKfoVzFPn19eaJAuvxZZfb88VS
KAQgYMe/vpt3s3CSjnXiHWWqVr/lXF26u/4wWi/lPTNBZh20sd4pHzvquEOa
iX3PdwQes9R4jyh66h6qx7H3k1CD8Pzx8o5Ct75p1bIy9fpOvdr2hYg8+9MK
Yqw2Z18IO+NGeVLHLfdT3I7umLxnW2BSztbzWhUHtSwiiqThmv24ohdWrg84
NIiReyV0u3rUmI5p2ZEjdKh+YdOFu8/SP91V1nuknBPBi72Nuf0Kj1nO6N2l
zmygxrZ2doZVibLaWdm7kD4Owy757SNRneNY3bycKAktP3sXs99y4lb17tYt
zxhQcmFyD1m9hfZ81xA+FezZoq8kVeY/13trlPd9LTlrI38H17u1Y6B63d/k
WWjP52PQWAeNT2t2hKQVlPfmxr/nNopHu70vB/8p0Q7rL2h8WvcdrX5piKb/
+O9RpGrLI42OzGUuTIsUWSfmya4Pz8o8WhjzaIvvv8s8G4fqkC9b6nrY2ipJ
jE4EAswqG2BT5uq4nV80B1KFcq4T7jOjOtMKpatOv29gs5zphQJ8JH455wqF
cq7lbC+U27feMJER5egFeOW0XAeTCWyWM79QXs1+IQuYWO3rzVNeO5ctYl5b
IMiRw6y2ubqy4TTjYece8qHcLsND5LYpUw6TL/ykXtFjgpfSBmPgo4zupyLW
0W/gKO9X5lmf56f/AFjHP3ovS1s=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->501963969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106415380],

Cell["Exclude a fixed set of points:", "ExampleText",
 CellID->1156017922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "Pi"}], "/", "2"}], ",", 
      RowBox[{"Pi", "/", "2"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->908660645],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322452244]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->834144820],

Cell["Give a set of exclusions as an equation: ", "ExampleText",
 CellID->315146631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", "x", "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", "x", "+", "1"}], "==", "0"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544255647],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22677019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107438009],

Cell["This gives two sets of exclusions: ", "ExampleText",
 CellID->103987792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tan", "[", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", "x", "+", "1"}], "]"}], "+", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"3", 
        RowBox[{"Exp", "[", "x", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"x", "^", "3"}], "-", "x", "+", "1"}], "]"}], "==", "0"}], 
      ",", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{"3", 
         RowBox[{"Exp", "[", "x", "]"}]}]}], "\[Equal]", "0"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->490460486],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89445095]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->822333],

Cell["Exclude an equation and the automatically chosen points:", "ExampleText",
 CellID->1249951496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", "0"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1249758318],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdV01IVFEUvs6M9iNpP5tMc6bAnwokIyNHIqhmhqZUyn4WrQYJdFGG2aY2
talNbWqTm1xU+37ECAwiIQgiNwlRQbgIWyRB0kIIXufcc968O+ddR5++2TTc
ue/ec8797nfPPfe8+zpzQ33nL+SG+ntzicxg7lJff+/lRHpgEETRMqXUKPwH
NitoO9DS/1HHgec5rKPY1z91poi0C2oURuAZgWeF1aob65gnJXvTLmodV6el
MzO/Jz98x2YzVAgTC4x32EWaePMNm+sN/C+ff7J095JwcZ1H3JEvxj55eMtd
53LHdTEbl5Xd+1tdriztEFa0lunpX/Pzf7FZbYy6dvUlOM0dhXOktPzO7Ymp
jz886yAxE0RKLGD7jx0dmZubz7NIa/m9u29BiM2qkrKo19KnT6auDI0hi2QB
C09eZVjPzv5hDyUFZkrow+Ied3018uA97LZqF1bEFjb58aNJ2FS1bsFRuLaM
1do+80mHsoA9/k4LqT2WE1jHYD6gAgXc6Z728kXGZ3wjKw1EiOuBi8+hgKrV
ghR111pgSQg9TrFz1SOkkidZnWIMu9buz+0aDnbj4IFhKhDpai8jZa3a1SFF
kV3arOeEmCUPQYGwUC3MqEuPuXF9nFQqgpWRcco0xg7tZQh62icAaxFzdTqc
ichCRaCKBeZawXHTxLvbJKwaWN7oGG8Ttcqwglptc7z4h6OhYlihHp7YLNd9
b431YpbGIn2Vn5WCmX5uJjdHJZhj1Do7Jb+lzC59QNOuCcDZ1m8W/UgJUfUZ
LHhHSrvFcBt8CN7ORxjPO+3gW47COFYCx7TXJ5uzLcQDn4E4VKg965TyXKJv
nunokTlK5pv/XR82nhF1Rc6RjEGpl31CDbrvGEdxrb118zXHV6XOsXQxzs/k
w6C8QDdoDONKqHYui4M9z6ro8P13BVnfY9QpRu3Sbs6/ZaG8Gv9Kp5SxCjO/
md/sWPl3Pr1OGGvlK1ur0WF2yrZQkM5xYdvqcqA3BFslDATwex4BPjE0Au7l
Hh8+ahMhsdf3ScxE7JWssGoTeh0jdL/DWxTcZen1nmW2bT5NfWBOYdwQq10e
J7ofQoHGIcs47O7zWdYFmKf0t74NWup9N2TYul3Iaw1r73shIzD3C31tSHG0
UUshSPjrOC2s2l09fwNvWXAUri1ptV45y00OZw7+ek0Jq6TQ1xijvK/YFLPs
EPKakFgW4w5ZAo6VnwX4iuWlZWGXqrJ/FIpfrQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289765107]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ExclusionsStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->490706925],

Cell["Use dashed lines to indicate the vertical asymptotes:", "ExampleText",
 CellID->51594208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", "0"}], "}"}]}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"Dashing", "[", "Small", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5317268],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66929028]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187374077],

Cell["Use black points to highlight the exclusions:", "ExampleText",
 CellID->167362351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Black"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190507458],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV08vxEAUf9vZXY2DRCQiaFU4cHdAiD2tk5sv0IioxL/gKsFl3Vw4uNiL
CwcOu7JfQvgUPsd405kyXqftBNmEaLbT+b2Z95t5M7953a6Eh9H6dni4uRYG
y/vhXrS5dhDUd/fRxEoA0Mb7aAiwzrEW323O8amXU1gybPLwWVZPgcdFq6jw
+IJRZa/EXtOk1dMwlhCQdp/gMYIdI2uR16iaMx3NzGbydhDqdjBEbsfm8fTc
E3Ync93EHKD8gdOxeIZZxk7vu6eP4mfsXjIb6aXvv0t63tpYm9dP+ANfFGx1
dQtNURTBWdxLRHqPlpKRqd8Uh4ZZgmu1WrPZTLVTTPko7i3w/y6fY4yyVoAn
vrT2Ygfvvr5r/6NYeqpjoi6qENnHIVZGsMxdjUZDnQ2KNzJZmDrHwEZGPKwz
VgV/d6cFrK9vELHrujne6Tm0Wo8zM3Mnx+fgvzy/Aru8uJmdXRBny47FLl61
cuxj5Sp/SBF/aZRypqYT3WtA67PE8xVd53mKlt5BEBgUXa32KG+qKsomWTqd
zvz84idFo8KFou1Ykmj1927GiljpuTu7/fuU1p1RWObeFOkg5PmKnsxkEVB6
Dw+LHO04FfCXFq+Aue6AytHSO09BkgHVrP7r+ARLBrvMa6f57LX613H3RvnJ
N64pm59yk471bxyhAQFlT5mVhYaDWMOYVBVTiRdpWDJQzRbnTRrdQ2xNf59C
6Q1dSLsn\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17943858]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->144029047],

Cell["Use symbolic or explicit values:", "ExampleText",
 CellID->15802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Axis", ",", "Top", ",", "Bottom", ",", "0.3"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32581745],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92868734]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->491200879],

Cell["By default, overlapping fills combine using opacity:", "ExampleText",
 CellID->410116164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->424548474]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24215983],

Cell[TextData[{
 "Fill between curve 1 and the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->200504289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26059],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16677774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28110335],

Cell["Fill between curves 1 and 2:", "ExampleText",
 CellID->396638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11560],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160686160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->678051541],

Cell["Fill between curves 1 and 2 with a specific style:", "ExampleText",
 CellID->30883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", "Yellow"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15905],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7777492]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->637116188],

Cell[TextData[{
 "Fill between curves 1 and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineMath"],
 " with yellow:"
}], "ExampleText",
 CellID->114357690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "Yellow"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11831765],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137667645]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->590217671],

Cell["\<\
Fill between curves 1 and 2; use yellow when 1 is below 2, and green when 1 \
is above 2:\
\>", "ExampleText",
 CellID->1241540290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Yellow", ",", "Green"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1616539778],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308844449]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FillingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->14409],

Cell["Use different fill colors:", "ExampleText",
 CellID->10234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
     RowBox[{"FillingStyle", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12500],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->224504531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->839],

Cell["Fill with opacity 0.5 orange:", "ExampleText",
 CellID->21157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "->", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Orange"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5668],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->847316277]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1711066621],

Cell[TextData[{
 "Fill with red below the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis and blue above:"
}], "ExampleText",
 CellID->943182170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1485932683],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126174302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4485],

Cell[TextData[{
 "Use a variable filling style obtained from a ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
   RowBox[{"Filling", "->", "Axis"}], ",", 
   RowBox[{"FillingStyle", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31022],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599814477]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxRecursion",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->10906],

Cell["The default sampling mesh:", "ExampleText",
 CellID->6885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.001", ",", "0.1"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17245],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277195709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1551013183],

Cell[TextData[{
 "Each level of ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " will subdivide the initial mesh into a finer mesh:"
}], "ExampleText",
 CellID->95077555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", " ", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"1", "/", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.001", ",", "0.1"}], "}"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "i"}], ",", 
     RowBox[{"Mesh", "->", "All"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "6"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191953008],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->510634398]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mesh",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->175033095],

Cell["Show the initial and final sampling meshes:", "ExampleText",
 CellID->9407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}], ",", "\[IndentingNewLine]",
    
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30195],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151999103]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->908508703],

Cell[TextData[{
 "Use 20 mesh levels evenly spaced in the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " direction:"
}], "ExampleText",
 CellID->11427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "->", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4129439]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->314682034],

Cell[TextData[{
 "Use an explicit list of values for the mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->238138513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", 
       RowBox[{"2", "Pi"}], ",", 
       RowBox[{"Pi", "/", "4"}]}], "]"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50003947],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84145504]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15452],

Cell[TextData[{
 "Use a mesh evenly spaced in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " directions:"
}], "ExampleText",
 CellID->236651916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Tan", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", "f", "}"}]}], ",", 
     RowBox[{"Mesh", "->", "20"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", "x"}], "]"}], ",", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", "y"}], "]"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237800640],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->557761568]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450987812],

Cell[TextData[{
 "Show five mesh levels in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction (red) and ten in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction (blue):"
}], "ExampleText",
 CellID->1980240883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red"}], "]"}], ",", 
      "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206959375],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlmGtsVEUUx4fdbnfBJ5TyUErqA422UAkoSsIrBiyighEEBBIrr6K8LEUR
JAWprCIogvJIjP3gg4CGoBI2JjUaSYwNKsFIgkAkGKUSRaJQGgR6/c3M3b17
Z2fvLX41ae/OzP2fM+f8z2Nm98Gq2uqZ86pq50yvKr2vpmph9Zzpi0pHLahh
KdpBCLGb/2U9BGOHkfrf7Th85j4H8YwAiMpZVCLlqhByrZyxXIpkvZND+a7M
8i4tl1Dju+SzwJMSIm7oud2YR3MkygxEoTGP/Y92irmR6nvZOxS4kvniEjPw
5f9ph+y5YiWTW3H3s8z9LDTm8axPf3YmDL3bw1ZjrDa8/U3T1z/v/+7X5ua/
xTb1Tnq4k1cdrPLKv/j58xeRQRL5jRu+WjD/kznVu0Rk2JCtEcYRVkVU6z11
qkV7HHdaW51k0hk+3FmyxDl9WpMjuhr6zf1KQt53CZmb+I5Wr66UrGKtsjyx
uHYPXjw89h38mTZlO+N1a/c2Ta6JOqr4cUJLvWLVpTwqOH78NPo+2nXwp0Gj
lFyiqXMZJKEMwthm75fHAEDkaquW7vJR5KRSjmpK8m/btoM//IbMBzu+R37Z
0k/RNfLetzCSATazyH4u53VWrT10CNFaV4c+zcZVmVDiZsZxbGULFlN7DgE4
c+a87l8xI47i6cxO6T4oOmIo/iGcXP0FGseMbsBQBp+PnSdMFhdYLe2v5jrP
fhlyv5YqhMPpT3yoff2s8SjbzLVKD5CPzgZ7Rw7/od1cuaIR7/ARXYxZmT/v
LyDV1Y6YadU30OBNVV8nFGIE4ldf3QI0ErmIi1u3NLFIOVVZNY1Q6YYi+Nuy
5QLevffufoyYOOF9WEJepwbydrYnWLVWqlQnRujTuYE+4sjg26m1JuOP+CL2
kNJFzrDt0YEj3fic6DcYdv3o7B3HKgayGW6cUQ+rxJnwkKKQM84qOc7gUvmZ
INIEh9IgJhhO3sAiDj1g1TFZPuLYTHJCHszpTWUXG22VmCYfhXoLuKGs4Yki
HWVFP65s4jUgoPyhfPnyf3SSjPDxN0PFCSyaO3U6A6SwsE2MsOpV2XUFrldU
nBtdeQBDiD5umFG+xypdrToLPpJjiDaOmWtGdpBV7sl0LZ0YNsZR9xAlVVnp
k5KHlnk2PaVYy47y9nHPEdm7lYSGp68zpqyqzHgmzmQXoSUhZXdS52rOXSlq
zFVnKUAQZwkEDqg6zMFJPXJao/DAACNCsAfkxWfPa5UcdpFEJB5Z1991Kfsc
N/17RkmRgP3vOKDzokIDo/pDWG4Lz6p5795trMRil0SFNV4KFdM9Yvas4zQF
2X37WrFL1ZyyJ0cJjO6/mdx83nFrGx1g9F0kR4dGsQf+w7a+l+WglqeziBji
tbjNiqpTc1gEIoe3WlEr1BxFbCeHt+RHyXgOHXJIM9zH590LWWzG422ij1XL
Sh2nlDN4MIr24ebNVtwqNccgzJLDm6yoejWn1GkIcnhjAArL4Z02mgf1oppT
z8QOrLjBilL3gyjbsakclvo4eEnlyvyZO04uXOb1jxKrpqTC/r603jsVk8lA
rDNpUlIskdyLzfQLFxtWt65sKlUqjrGYEK2yz7dPVvkTTa3ad2fxj4uHfix6
O/l608tpjil12VO0/uzvV7L65HSNwWAvJ6xO1xi6wyXkXVDeHnu1y0t1c5R1
iX4Z+eutMVjr+GvpugBU7aIW9wbjoWR+rFNvS0sdt0aCdFAj5eVnJ008nAel
dVFAHNDS6p5W1KuOv7Z7BKBo0fScMBR7saPsgR5K+rbe4Ke7Vcdrxk5BqPr6
S6zMmtUWiNJsylM+CAWb/fq1jB9/KA9KW0/1kwNy2M2Kel3NOTlp7nJY7GNg
g+PvRsUBOjwGglBwzRXOQwXl/AbDtq4aGnhqmha3X2b27D/dDM8nE80wUlIi
45hIpLHRvNYTpW7FJ9evb01rdf2VT1Nio5pz3+RqKodFTrrWIxarNdrrOkVW
1jUKAqExDEVsuOnKyvNQcuc3jTh0sep4Q835iseXxDDUlMeaXa6DUD17XnBZ
DkLt3HmhqEtzQ0M+lLaeIqAU5LCzz7dN6i2JS/r63+bq4FrMdToMRfAIYRiK
U5tvM2EoehIRyY/S1tO85B2f4bUBurjEszLx0XNWBryeE2QP2VxWdnbqlCOB
9nidQNsTVOObjPx0JQLrVct4naQ9MpsNpq6xWiYFNFJfaLOQ7dDunRTtlZEn
ejhHWjvm+LRfzu9x+hc80eFfxY+Gcw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112561528]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshShading",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->374839548],

Cell[TextData[{
 "Alternate red and blue segments of equal width in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1563263586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1456152504],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130272987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->913462102],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to remove segments:"
}], "ExampleText",
 CellID->1504189831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->740997133],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWE9onEUUn+xm/0RblZrWFFEXkdKLNbaartWYqhgDKk3btLvaRLMGZdui
u8ZSYkUCIvRgpIi2aVKh1TYGEQlicY8L9rDuaREP9SAUvOTYY47je/Pmm5nv
7eyX7Pbqwn7fvG/e+72Z9+97871eOFV89/3CqeNThcwr04Vy8fjUR5nh0jQ8
incJIa7D/2SfgLGEkfpflxLu7jUF1zhMxZDCgVQ/EYPhVcWRZjNxvHRbWogE
41ikx3G64S8WkG3hnFQcS9caQ4MLX07/KM+di8nZWRA8e1ZWq3JtTexoY4XI
QIi5Iz8A4suDF2S5rBATcmZG7t8v02k5MiKXl8VjHe5c4cfrf/xb+uDXym9/
i6SSkJWKzOdlJgPQj3aIfJqQbt1CJFjk6mrG+A+tm3TurtxMsIKlgQKace7G
w0ruAc1/RvHnDl1Fi7z0rbCzLsrHbF9+rsWOnuIqLnl5JhSt/T93Q+yL4NI+
ffFSJFd9eq702le4Az/XODmjVsNogPh6NrRKPbu2JnfuBE+I57wYx4hrclJe
voxDP9ebxAUswAjDQS/XG8S1uir7++Eqno/igsBYXsah5cJV61mIQQgbGA55
MXLEdfs27g00Pc5sf18o2txcDvKbR55GLJchb3FIiLmxJR1phEgZ4kZ+iuHw
unGUHjYaaBMY7jKxOfxF5UyAy6sPJZSjxqsHSY2fzWIYwPAJ5oN7O1z3Eebx
J4men5fFIg7vaYGbkP7MHjPRCIUF1rWHaFgkmAaGmyPwXBxOjzG/7WHxszkU
CcGdoxwmKahXEE+QSU8TPToqV1ZwuCkUo2NsVnPfvInbAWnL7eo4xCJhL1v5
3VFSxr97jX/BjqDLL3WQuGB5sEgYPkM0KAJ1MLzLK3VAWV9nUbYEG9rHvGbl
0A4KOqhlQxepdjgx0tNai8qA4s+VX/6iWuJEQtordb+keN8KdwyQXk1zvuD5
Nr1G1wp+5F5Gb3Vo0UKDS/P5LXhJujFMe7PaY3ofrtS2degtet9962uDQMlm
N7ZXn5X56tAG231aUyGt8FMJQZWlbc18vlevxLWX7fxsFiU3pE3RobrSauf8
OfeT1m9yP+HV76K5q+d8QZQGd747i46z39CseXN2e3V/LcMVws+lsUz1iUdx
GSw/13mGpXahbH5FhDOIanJT9+6jE4Ymh9E+1pNql/5fyx3SXczDVAOGGSfP
ol2M5tVKJYDbiwe5q+AXzHNd4U2+XLQSjjVoTf450uTMJV0rUl88H9Knc9Tk
xAW2dtdWNifOR3EZLD8X9WZ46oOjJAxVn+90u0ejpMy7m6T02/qFRUfKdkS2
Q6A3f73yZ2ngE3xL+3V0Gx3QoDQaWsqeJvxSWpd5L2eJNl7MeaWoo2zqhKCk
QLO3npTBHmC68yEr0EnXVljd2ZneJO/VkWJefIrZUp1pFHar0wjvR9MsenYb
DdTVq/MY6Y3s6nnGpllM7GZ62sFFsofkzSmhn1n7WIfrVH1mfGnohI5wfaqB
Y261GoUbnD64PQkvd+CKPs1R/UEn55VLxyPwmuOd49ovDXRqtOfSiZDng9MH
R+FZMxGKST1rTjRveWMwyzz7dhQXtOfzqqj5uXRmganB4DCc9HLpTDIxWQit
WmOYPqngxaBM0ZXs1c/EVARXbvQ77b0orvrv/5ROrKAv/Fwb+ZLT+Zeh7e5+
IG5nvTLUw+cOX9PnplkTJbbDdXLDE4cKIaHj7p3P0QO1mvhU4fQw3uavdTz+
HlQcmLVQXCEharUU28eHHSI/hJdNmGeADCkBrzAIB1W/MXCq1dzIAjm1HQ3I
8IhU6QdnbngnQpQBPnD19UHI1sdPl977CUKg01Uv3pFckO3BN87v1dPmb9mi
6z/6tqbR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212470746]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113916258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->101485524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->914958790],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120113869]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->424843825],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for styling the curve:"
}], "ExampleText",
 CellID->649526388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Green"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122170518],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294039201]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78638807],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for some segments by setting ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->68474456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Yellow"}], "]"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1946430847],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109714226]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13901850],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1974674987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]",
    
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1920453998],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26375364]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->117797214],

Cell["Color the mesh the same color as the plot:", "ExampleText",
 CellID->124974016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199280146],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107038219]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->751885160],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->542506413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1343653111],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497181625]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->643903660],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction and a blue mesh in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1837201776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1330372666],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->881362539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420838548],

Cell[TextData[{
 "Use big red mesh points in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->2133487437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2002303716],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWV1sVEUUvnT37rZAuxVKW0B+NKBoEYmAoKSxBAoBpdFSaLWtsjRoy18J
ojH6IgmxL/4kYgxNCBAFEpAHDISGBIOhKhIMTYwYU4kNjaQ+QDSAmBLkes6c
mTtzz869S1dfbNK7c/bO+c6Z8zdzZpent7au3Zje2taSnrxkS3pza1vLq5MX
t2+Br2LDHMc5Bv/ryx0YezAS/8c8Dz7NZxKeMXiVhxQOPPHn5MHwUzEjn72J
4SOuacdx2Yw2mtbV5ZHYGD06OuT7acQWow/8y1NkLnKqqkw57s3U6D27v9u/
r6fn/OXBwdvOA0NYBU6QqOXlEjWOjwRAdu48277paPXCXa9tPf7FyYtTcrRO
q6Av/PDbuSmVPn7MmzlTWR4fBWe/7d/29sn6lQdAkrdnj1dcjOrk54MVnQk5
Sn4ZHy7YZMeH37S1Huk9cQ5glfxTp+SsuOAaGLi2v6nD0M/33jg/btBrCePT
lLVW0Jcu/d6y5vBnh76nVbnewIC3ejV6rKHBO3NGroF5UNjelFUmZRAmWAaU
B2Sn2OKpe30OU5sWQXef7gPXXb8+6NxDnKBEQK7vg3FWlDWC7jr+E6BgZI0i
lL4+8o5E6Xq9MxIlLWhwK/gXhyVWy+RBwI238jfhI2nGRP+6N9568wRqJDhi
4F4wOQ7HBuzX5NnycnDbdolM3LA4MDEOy63yG7P4jFBAG/A8eikSJeC7iUbM
4GrKojhDfTdB+RpsgsPSKJS+vtuFKQPFz4KJzJJjMi2ZAB031HberG/03Xaf
WjtE6M+9VwyuTNkd73wJoYTDqYKG+cCF6y6xcr2gog8Ycfgg6gJRYp/9vKCv
Xv0TbAlP5yFBgwAoPDgcFcEFgYlVB4aCKwEe2V253ixBqYA1iAuCBkIHhw9b
40xXkJFW2fWChuxsbjyIGldkiTNCUXXI3D3UjsJrUj3zaYUlBosEv+AM1NIk
w+K71SrlQ7A3DqdniVLSnu+BVLINsVa5SK5i/pyu4jlQi3Q8j8xxXStZ1M3w
AtXq18plBzbudFIh6K5n3x3qPJknsMGhr2cJGkwHBsRhYQSeicPpOubhWSwy
CwMxoz45ygpBww4IkYj5OEfQUE6gqGhbquivY29ptq5i9mivZfEyl2k+wspV
g4+EWfuPzG2GCJjnyWwHe6JMO/dyLzovSQdQANTA4fAolNC8nMt8q1HQWjVe
Zs49Kb77/MiF997txmFBlNzQjHqCxVC+FWW0R/mDlRlDq0TSlAfh+cPzRPGV
ynWZO45dcgmjxxg0AvD5IirdGxf7T99fdWt+pTwXDGezOJeo6wkzZ8giWqc8
uXqTqzQL7bLoHC6tV55VOgQnFKm7s4jNV3m+b1h0G5Yba9MiaWoBT0pQwhqy
Jvw9t8dIqalpX91V6SxP3JV0QQfqHueIMYsUGvLDYgyHpI+uVa5Vn9GefTUJ
tuoixqdyQX3y1Wtp+PYZ9rZa0PrsEbfq9jRbQTWzhJ1rGZO1hK0kFsGlZS1h
suxcS5mspUyWsIrw8V4nkPdyj8roxG2069MUILJry8I1VPq/kSLrga6PEuf/
tIYh0sOCnpW1Z7Gn85qqMs/8GYxmdZOCSsahtuezelbcLHZCnrEj6nm0Y+kY
XcQQn9OI2n5yFYsYqnWu1HShmKtPFLV6bsL0C/VCC8RsfXJYEdCX7Kyzr4ph
69mZ3tHZN1/INk9QBx5pANC6CG4tk04q4SeoWisKVevOnWf37+vBIZ1Uwk9Q
USjaOhIlcJLSq9DnWm0hOiWGn6DscuNKruxpJUroScmO4rIIEyjuL1//+NXU
BfrWY6WVl/Yd3evQCVPfU9RHcOkYf5xp0BCwFd1E6d1nDovyBqsMfjKZzSwu
OmOBHdaj8t4jn8XrY0qC7OPFLQDJjezjeFUSuHhj8fGc1juplN/JP8rkDQU/
5tstPCMqmBca/43+ETlDcto3He05fzlKjupI7XYPZhP11PqmrikCMzNjMrBD
847uZvTNR3MgalSXGoIamoeEqm+ZCFXFu+gjdB9/pbpmR+P70oq6X37R5zEl
FzJkcZ9vVKaXIrj0KokLWj5o/HBo5ypiGonb/Bg4GVyNw9VWrhTTUNzL6ap/
J5l/eHYjKJEO2KRYrUPeXE72omPbrjGh6P5/UpbItaPQDbWuVhMt8Zm2ctKt
tM7oCVmizy5/lLIFyAfrS5RbvRdvJkfYok2joCVLlK/lTb24lU9AGnUfOmNe
c6+xyibugYFr4GN4int0vOl8xTpb9DhJmAf2vvFRZ+CXkhLJ2WrlpC738q6D
If4tVpYEBBxqFN1rhfu1SNkALAgbv7MuQoegX0Vmu/xXH6qI1E/jOWy9p6qE
7jSN+mmpS6XWSPhr2nT53rXFe3xw23ZQH1wBjtwgZBYw3MxfnnitkpJZrfqg
ZjuEBKxISWa2/KOgGA5NmEMbc5RbRo4I/rYC30FNBytCIQJ8sCWdK/4uLUsA
SPsQZOGESSK2wThgJXA14D5V2dk9fp7L8izXNUyx2k5nXq64U8nl7HenzX5U
mb/ufSK+zfz12Bn2D3Rfm1U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435323073]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PerformanceGoal",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->786377051],

Cell["Generate a higher-quality plot:", "ExampleText",
 CellID->1024732519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"1", "/", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->808944785],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{241, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->351973828]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->410197437],

Cell["Emphasize performance, possibly at the cost of quality:", "ExampleText",
 CellID->2008081540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"1", "/", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2120930175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVVXs01IkX96rNYwtJK4WVRBHtYrV2fVRiK/LIK1lZySa0bVuKraiMDSFU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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0, 1}, {-0.9999926717459962, 0.9999862643202806}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{224, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5015838]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotPoints",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->241659577],

Cell["Use more initial points to get a smoother curve:", "ExampleText",
 CellID->1529333113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "i"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10", ",", "15", ",", "25"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269859248],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->229747706]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->195009142],

Cell["Show the curve over the whole domain:", "ExampleText",
 CellID->893230115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->784240289],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WFuIVVUY3p595ozX8VJj2owzx1vmJa+VZZaZl3FmHC/JNIr4MA7CzIMp
Or0URL3US73US0HkQyWUPRiJEihIQiiIQiSIBWEQ9pAESQ8Dwvb7/3U5e/37
P/vMGaFh5uy11v7+7//Xf1trTk//8OChw/3DQwP95Y5j/UcHhwaOl7ceOYal
eFwURWfw9/asCOMEI/47kyR4Zj8fo8+YEPwTzcFHEVN6FvBst/OywD2qSrel
5viMWulZrLw3fGmEzjvVai3Y52z7jAW6JcMv+dx+mvl1s9A+T6Afz/DNFYhW
wTCTnzOtt+rnc34OedozcllPtqm+rXBpsSlYuYL1VEGxyESgWr5QakVRUcg0
iHmpzvf14kf9/s6df/8PfQ/LV0hkdtKwqca83c3ff+8iDWXu15J/hLXuEyx7
w9V33zkfrtKiwAwNnlYkd+/8QlndsumzkZH7crWv9yRCla/lww8ufXf6hlzF
El7I1Ru//AWj0qtUKVDc3XkCn31+nSogigcOfvvrrb9p8bVQAs+PP/rp1Dc/
92XWL/34+1tv/pBdv3dvBEpS6w3e40ZNSofRjsGJz6/iN629IgURCNp3XVYq
3QmJhNY4q0peDj/Grb2M6UzZaIQatSwM5M3e65GP3Y6s1XXpzswrcdlThafB
+kOtqPirL69/+smVWvJpOdnZDM/du//ZbN4TRKHRPqWUiQ7SA0lCw1d9XGMf
O5Oi4dusJRUP7M5BmVysjjK7xBawERruykEh4Ah7iIq9p6h4ek+CpgpHSXDs
zEGBC9u7ffufKqhGsbcdKmq88FOPR1FkJghf96gcBoUGeO7sTRpuz0Fh71BG
HtBRE3kOIttPu1XUJJ6/MXz2yuU/aNgVWD2Z36J0D+z/mrpll8oxWfi60+cm
gTIVpWT7FOG7bczQLVCcr0HVyHw3PIgkqMjeengI0CR81jFGO6aKOG59KB50
cuyHzqWx8kxLbPYdef178ssWHyGKRinRe9d0npuDjYabffQJNEPscZOaGwYF
ndAM/VVQfAOgPMM+sdvoFRXFN8IYiYo6pF1sVFHNIoYvB1bznTRGM0ZLpuEG
lcPcWXHluHD+Nxq+lIOCJSif69f+rIKa5WIID9Cp+6KKmp3YmkZ/oEiv9yiK
TIvzD95Sxb+gchgUdEATeXGdimoVqOdV1ByBek5Ftbm8gl2EWhtYXRYcz6oc
EvWMz03ZPYL7RYphrmB4OtGqRN59ZV+al2KhCKwZNQtN5wvp1WOyYYGLM1jo
PFqlshQTvV4XprKE8nFlVem8+ROJzVdkNdI/WuHjkXfTWJTYWkDRoLSi5T7W
BFqc2KqznWSZmglLEttvoJniuFRF8Sp1AfiIamGJilrm4mHvuotV1FNJpepw
vkdPBlYvd3tCv6E9LVI5Vrq9AUVWL1RRHEm6Q0ATRXaBiuKsofMLKPL9fBW1
xkUIvsaRazLXVx1XGZ3GthrKKodBIUvgH+rL7SpqbSofyQNtKop7QxF+ghNM
6FpV3DoXOdwmKD9bArvXu1hAF4jMdxYZDu6edJ+2fuTuyjcO9z1NrbsGd2nb
s3BKmC5ubjapPsP5nXumbmAENotzBr8YmO92Rn/b4POLTipYQjEw33hsl3uo
aQmflkWTNfAcAjFjjEybnXdtVkz33lXkcpn4hhF7m8wNpOaNo0NEt8nnAIG2
ucjBOsrGKWqGdKay0dBMUnEcpyLYkI3GaxNUXI/wyXgVtSOMAbKhFNi+y7FA
GyrA7DzDwv81FVEDKCPkFGyKVRz/9xejQ0CPj2wGZb51MN+XReMeAJ9uBE0=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87848843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->190153465],

Cell["Show the curve only where it is real-valued:", "ExampleText",
 CellID->1607850275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69469756],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylmH1o1VUYx892d+9yvZiVtHRbC6SiF42SipJebWViZi+Gici6SVtlylpJ
6017WS+m2SybZZu9gtUfRmIEBpEQCZEQCVFBGIT9kQRJfwyCX5/nnN/5+Ttn
z73bbsPd/c7vfJ/veZ7v85znnOuCzt6uFSs7e7vLne3X93Su7uouP9jesaqH
V4U6Y8wuftc0G54TnuzvriTh7+jPmXwWALTwtyH9K+PTZVYeEvtjpqfvG6zV
rGi2JTc2inVLNG6LxnUqa+sYVtNSn+PVdLbYWiKqZ5hfRXxvr4ktjrAlZW9L
/+q6iQ+m4ehY193z5N8XsuzlV2mtkL3WdN5Z5fN/YoR8e8Jvm/jcwcu6EHP4
8D/yGNs0ReP/O18YY34sfMwfz9eHUR08+Jeix/7vfg/fitbvhJjNA18rlt1d
O5W38+cN69gDP/wRrWIKjlheDof4Q4f+vuP2D/IsaaU5ou2j3n+y88CGl/Zu
j/hHRv5dtPDdI0dG8vzFTCGW/+jD7/NzpWyOGsADCIa02cx4KFjRKl7ITM1b
YVT5vBQwTnXdZlFpgduffCZlLNxFlYVVkOTnn/70LMGObFRt4opB0DSXb9bA
Id2hfnjo2/HaZp1YfF/1wKdSF28otsVU0zhuN6ZAynd9LJndWsE29jE/Ltnx
3q9+fbTvc3kcHJWBxiTX+3KWLqKtg/vef2+/PL4e5H+SnX2od/e+b36Txy1q
/o+JMqejHBcREifRmtdUVJNXAyUF9aqKOjZCbQ68Pt7P4g+1awZUDofC39Sf
V1TUCdFKm1TU5BxKFHg58GdKbhYhzUaVY4rXB7nZ/WaDijrZjmkN7DXZketV
1ClJuiNZURR4UUVNTdLdsmzpDtqmeSHw+lTvDxwUh3le5Wj29UPlSfX2p9V7
tPLMqB2m7YLTfAWnnfVZS6Du72BnxPU8zY45GuARr5+ZAI+/e9l4sIfFPFWj
H61eW6pLevK6GnnsXaOBTJNvCoNkPlkjk7tLUX9kW+rriSTuEaVE71BnWG6y
S9k5WR4LKmWGnXexojnO9qm1MsPHgrxAMXhExZ1pcS6HLMnCa1Tc2XZMLJxO
ovHDgVfneK9RzhV4r8pyrl+NOqeIUbhHxZ1vcVQoqxEAxKtV3EwfJVKwrmxC
FXeBxbGc8w/ilYH/F3m/cArX8P8+lWe2xTHt/Kf9dKu4i73/SA+OdnSPirs0
F+dz/V+CWxH4dbmd/2z3j9l8WeWZE+IIpDNXmFpvqHQzuMIzIZOLcLm6B0rR
OJ6/KlQAyZbVxHON50Fx/vGwdNw8MpzrM4YTuEJgS1T7hkTfjx3yUUQGZHWl
LyfB4ooc1cY3WC6SSBVytaSw5by4LYl7Q6X7w43Wns1AtWPvEm1uCSrmplz+
6GHodbNaMQstFx0KXYiLjS0nygIVu8j7TYMAi/dyOs9Xsbd6H1EKrHPBzFOx
i0MfiEr06AjiWeLXRi1X3HJizVX57rSFQH4In3bmei+uXK2ibT0WUZConJrC
fKWKXV6BeU7gazlkXLd2j9xALlMZ7/aMX+z5BZFc+IR5iYq23aOUqYABZhjP
VtH3el3xAD/wRurkQhV7v2UmFAIiLNdEScOsIDLbfUuwuMplfYRg/fNUzh6/
PprylQ4vpAbsGWGPzfHcUXpz+lAeLgwSdFaS72u5QdXz2J5pJcIiSvKHhHzp
QE57Sk7gxtLn84A5JO6+wdCe2vp36Kp+PW756C7oCh8NDgdxs61GvrWWj27n
KhDhyBPJnZ7CR9lWZXvaspE7l0fYXNU1J3HHqnSb6fcM1ICrBMcwNaguexdu
dLmOgOYktcLWV7GYrFpsDC2uu3ZbJo45TrUYCKPPcjMp8H1LqHhWESWVczDM
N7uNQsKFgoq234rlfg1IvjPoqGr/R2Xq/gN+xdZ1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90546529]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40633603],

Cell[TextData[{
 "Show the curve from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"-", "2"}]}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "2"}], TraditionalForm]], "InlineMath"],
 " over the whole domain:"
}], "ExampleText",
 CellID->1213642703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20474098],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWEtIVFEYPs6dsTcW+SrU0ez9jqgoQqnIMjNTM5UwmyTQRRlmm2pRm9rU
pja1yUUP6LEwEiMwiIRIiIRIiArCIGyRBEkLIbh957/n3rnnzD86VgolM+fe
85/vfP/73DuWRlobjxyNtDY1RHJ3tESONzY1nMgtam6ByEoSQnTgeyZT4N7G
HX07bBvX2LEcYxCAeppVyNGSeDlzpSUKE/StytuDtLrPkAYwyGlN3FX/vMaz
QgSj0lhdNZ59AQhD7GptXGnUnviY8ZJKe2vHXcu/52GFsprPdKUhtVhUvMq0
tIgkxvU3Ub9bp/9LrWQY0myVp5w48lxDnsqy+HcLxSYjFjbkPFuK0hVQ1znq
amYw25iHmXW5L41Y0wzd8wx0ljE3bcsy9qfTNV15Nla2bLVPZyEPtNOVy4OO
CGtMXCYCPpR7zWMjP7Enknz4xZ4IZicmj3F9rPiE1y+cfzoR+v6Uj57bWrXb
TG9489OnHttMfZr42baWx6bGdjs2uyXFbcPDP41TUljv331VLPt1/LWrPbdu
9posva8+Nx976Jeqeq+uuj0w8L06Rg4OMPnkIUc+OPgDW6RFUb0WWXTl8vN7
d19LYVV0V7LnLTbWHbgzNDTMruLvQXvfpYvdVbrd/vhb8AB+yNvKEVD9/d8a
Dt+XFkZRAa8nHnW+VTVXwXI4KEAAlLflI6CgAyb1vfkSB+VUERyHPRjFXhbl
1B7yCS6ER5SxqEkuClUiUXu06E+mVViiOEpZjik+TUi62M2ipvpQGOktI/77
yjSag01FYhehR3tPmE5zWIpdT7o+iOK4u+R0hhvtc2e7UGViZ0I6UmiOklQx
KUpo10yao8xQrD0vPontCe2aRUWBHJ9s7UTbwNRtXtS4NyHqfAs9BttQr2Ir
m4lUN6uoH9nTW7Sc02kUhCooRFGAppBlyTBYClhUps4G+GYWN5dwWAYIuUBg
N7G4LDf6OC0wio0eKuA+gYPYDAqYhUBvYFnChEMVIq744GYdi6MnbxA0IMMh
gkSsZXH5hMNJA6varr+EAWtY3Hw5hBANgFAIcECeJ6tY7ELCQiV8cZyV2BVa
rhazmGUs31IdC2MldgmLXe5i4bTnkljEYle6WKDKy26AXZ4BC1jsatd/J4Ho
O3kS5LNYinQQXYzYo5y7n33M03K9nrjQUXgqOv5IG3NYLqqCEOxy/MEobaRa
8n6rmycQVVYInE5aUSayb6lOY37Rm3upxkPAY1fUNuqYUXu+wGcr4olHhjz/
nPdi7ne/tL3QVl2GpwtUQlkqi6/zPNbfS+s9r2RkD9Es9r8aIukXiCqL6w==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->334978332]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRangeClipping",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->45643252],

Cell["Constrain the curve to the framed region:", "ExampleText",
 CellID->1306291737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->252825347],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52194818]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132484217],

Cell["Draw the curve using the whole graphical region:", "ExampleText",
 CellID->1119900478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563149880],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77736094]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->362103647],

Cell["Use different style directives:", "ExampleText",
 CellID->193335196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Thick", ",", "Dashed", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", "Thick"}], "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42985262],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9W1uIXVcZ3nNuM8mkyTS3jkmTTJNGJ0mr4z2W5uKlbS7VJq2lozUyMUQS
oXaoEYI+TPJiXpQBfYgF6TyoHdoKkyLkIKRMteA0UDwgDQ1aGFqQ0wdLwCIh
IGy////WWnuddfY5e+9JJkMys9faa/3rX99/XZf99aOnThx/5uipk8eODj3y
3NHxEyeP/Wjo4WefQ1W5J4p6Xo+iaNdghOcYT/pffv6M/3zM87Qcv8voWpJS
2dKIoxIejy/w3fe7vPu2jroieFOWX5WkHEXVoMWR29Dju5k9vqV/+vBbqsu5
RpAGn+br69fj8+fjnTuBjHYfGIhHR+PZ2WhDYYoj+vrGjf89/+vLe3Y9H1Xl
V/mhr/4GZdRG6wtT/Iy+bvztX8/+8I/HvvcH0/Of//j3hx/+Vx4txUouiqVk
1rOzMlGtV4b27o3feUderV2gLujcK/HcXDwyEp84gQfVtGp87Vo8PQ18BdVr
16LNhSl/ymJw8sQFAbQkvyo/PnVx6oW3fvHzNw4/9lutKT/15IvvvXdNGg8V
HkNRqUBMIPv73zWALpFGDWB/7dK70ZbCND/JZpg/4FDLU0ENDsYTE/JvZKRM
7KF+7LG6APYlp2/x1BTFF/WyTLjn56N7clNSjKvQq4P7pwAmML385vvUqtpH
H90AzEAXL/D6jb/M58O35PS32fyPeVO1ZcgSRBegDfcrT2K1+/bF6mHj06dR
JK+CBebu6pvNIpimSA/0xsZAPlrCMowEWAPb4jqmnFfrF68SY1g01IwyqwLj
n/7kT6jFP0gh2lSY+gNaBh0oqzzmk73f4j4KqNGQGaIW/qFeV78KRYCO9vVJ
7fg4EV1uJFzz/rbNthzPzMSHDsljP8vz8+If4Ac2ZvQnN9AU6CJAgV2KB1Up
VIHbkadfQi2UEi3UU2fzAlzhMWw5c+yKOCzC0GgsZc34uFGtqalVioKdhZkt
vCq0EtpyB8vAEtqIsh2Rs8JM4FWoAyLtfluLWaIWc5O53tdCG3M2Vrk74HYH
eTt3znA7NbWMNdBdcjs7u9Jx29azDCMRmTSbxkqMzlsc2kZicIMSgyWdZwXc
Uh5nz1wK+7CMif7ql3+VR44B87/y9gdpY2wn70CO+nb+/HLWwGNyfs3mnS3Y
k4IoLeDH4wDLmAImYriWduQecQSMIibDjykvFQQNFFEJy9nRQhMTxIwSmugS
yGY7bQbeaHhY2IOnh26vcByhat++KOG3babq/dELj3eyjHgBWpDGjqD9Nos1
XTHClPaovHrhCl02jH970GePls/97HUILZF4SFM8JaqgBNevD7AGOqH5AYKJ
1jh793OXSKKaZ0dmRrBxzABavypu9QHrctOAsmBOkvGssvqDMuaRi8be2PhC
Y+/rM/r4iAw7/aPtNBorfWtC9G42Vb608RaP2hvQCvO8bayEi6jX5XE1ywAH
EOFxsDBFcgsfQp3Gw6pWnYa6F6e6zWq/KY8sjK+yaJTGYTtTWsTYGC3E5ewM
RR75TPryXoqWQp8p91JWTuMijRi2JfV6eDjSn5WLM3qVaapxd95bcgCVlGx1
UTlgrGDWFXkYyN+SN26psFxrXccVX0YbgfF745q8FLmT+nS1O7WenDbk0PPq
/bKM1Z/GuXrmoSGROlstS5kPx0do1yZrF5ejGoIMvTUcORuG7VQZJBtAFZq+
8vLfo0XlSzLnEtQ13BlYmsaXcAD1gm/Fw125eCotGCuJhVAm1NI/tsuPWCH3
iRi/PCmn6JZdlYQ+P+RuSQYStAqJmjqwvgpnkGgWMsBGI1WCt4of2jE0hrky
VEyGCVs5jqh/i8qR26egousgqXouL5CbyFowTZ868RPqWU6JMX9HRtaRnypd
F3P8RJcqho/eVA5DKiXj+7px1GvaVSkaeCj4KY6dqumJPmlw6yi9m+alF4kl
cy8SjdMt1PHDdeui8KNj1KBFSLx9ZlK9gIxME+ioSWm8hJrdHRvJbbkuUZOO
44yootHQ02MG+jCq9sWJdpVSeM3iMXzPtb5o++Qkq0rGH1j0y+q2mIZK4zW3
mAN6JAQKZqGQX8kbvZULNDH7dreaC4urnXmfGxPrCdNmbcaYoafJhb3m9KiC
nZbijuhjRcs+4ZiKXpuWDMbp1tPuk9RWe12N/LidCJ+fdA+KpiMj0SduYjSu
3uAYXPwPqSyxVLCkY9OPFxsvxUJTJWN61i9ehW+wcwpl1mGMvhBBFGH8zWZX
DK3da8swbnWWbKcZ+TrDXf5kvRjSWRL049qb7+7NOQZ9B1eU3IwMzxZCq4rK
bFdkFNJM9oXDMXwvIX+Hg/e1rnTNunN8vCNdDyFN/NN46G6FWzmSGos8bgjK
W1vaMUiePXPJtEsspLUdAxjcYfRwMO4Wsgh5RmYX7G7WeHqZ34/45XsdZiCF
x42BloW4bEjlzO1BwOlri8T7X3n7gywa5AFLHUAij5sC/QjnEO6lbfHlPjnp
zSGSTbkCHjaFqttNIFfJ/pbNCtO5ocwhadMv2dPq3o86IPvCQ1pGDwBjUZB+
m4J+m33d0NX3Rl831KcX0+5QJ8iJyyjadOJu04+64PZYoQKbrC7w1AOZQKe+
HBMtkYAmY4KWXUNk6NA9ZMztxU5OGq65j49YnI5BuO79WBq6nhbwZCXJ2K00
1R5FZ/GMeGOkyY1+0QLyB1Fyix9LaCvPcCaPWP0J5G58DPQbTe1ZakVEYuU+
xBrwxiy1Xg/n3KNzpuCZwMp8H8Oz8PeNlL9iOz34Kz17MhAbHRWnypPfyObH
/N3SK6NVeu3SoNathFgsTO9mePFmr5hLrmDk3Np8Ebnisuu2zLOlPPXCW1Le
bOcNyxZvlTLvmxl58eeywL4675qxQl3dLaqklyW1UheJg/ON4Nag3aXvxITU
pvuRTvGDmRDrsvZqkmxcw036WqFLeasbk2dgucesIBihir2ydrg6j8qUJc+o
rmwiXNYYIU+aI1aSHarp6Syu+9p6FEW3aOZEn2wirzvb3K984L0Lh5u0BYuy
xe1aIAF46skXEfDZgpmD3JQ4YFu0ZjllE/+wZg1PP7vwald7qnKGjj0r4Ehi
AX4iw+grOuP27/cHlGXWspN+0I1gM5ENVg5uPzs/r8lKjvmHywLMmcUBXxPB
m+ylcm3gzooBsG3F7AVMmhtkbq5J+ojMgrmMOxduOzfugmzVlXnQaWk5dA96
vSRu8PYWF5DySrMJkycR5wPBOM/447i13npi7HKfmZn8XBuM49jsfmhOCs/3
qH0n7s/tVayz6HK/HSpx0LSjL331wpXLb74vjyeT/rOzbp22johwNxrWEt6B
6IJuLUEXP7pGM9RcPio8e/sxbhkmWDNT4xmkrEQebaOJyeDFD4J6LqTGxykb
d5IHtPLxbtfdaSfwdm+U2AltvYhgeE3WHLty00hW17R1fyWahwrfAQaz70zv
hoJZnXajYXcmlJi/ODdUkjXp/anI2dWEv3tF8mF0abvJG+B1F8tu529XPoot
u14IjE7HSQ/exWCbk15bGXpoDhcGA5wfzKSoiLfubOrlSrEi7vnLDVQLub3N
w1335QtF1N2PMoi6+xsLRMD4Nka5NVrjdk+wfCxOlXrIA2V51JMY8UKevubA
tXW/01tDkp7xtOfORZ8tgKfbU/Tula1h2UW03QUpJWtqUnI3LgpQYlRCImZ2
LvNh5Ky+ZdW9mjXe7YdOCLWcA3m0K4FmmZtT7i7YntyU3P6tc/q8EcRTPcbT
dpQ6UftOx5bhzraRMS/fIhpz1OS8bGbmc10wCbFIeGm7Tebu9aVj0pGSubcI
3QECvDnnbklJUpebGmdev3gVBiaP38zsaTGrkIy72zg3t5Jz4r0o+LDPK4EV
ceuZVLj2MsiENwehOlAgPH45oz/5cNkh0oEBW0PTOnvmUhYNd5Mb2bnseQkP
JYSLrwT9UjXd3jhUwZobh+7+arNJFDZ6lPz7neZ2pbONw75czN4jb76t8OTO
Vd6hFpoQIFyHPPJ+J9yluTF42Ofe21McG1sRyHB6+guO2/CEImq/W+t21Q+n
ta8wc+HlLd5f4XqD8wn7cBaIyOaql9qW+DTMSnZMH0+TmUZIe7eWYwiWyB11
fl9swZ7ry9Z7zZIXP+G/r/B2Jgftt1Lgfi/wfNy0ZbRHCmY05olUBMw9SzA4
N8d70YI+3Qr9QMJh+1pZvn0YHZXHfmcjjDnhaO7ePW0AkMsajyd47jsI2EHY
b9DqvSmHGJsbiN5N8SVuFvxiAQFifj7aGVtLL0dRe56QYjnmCwTgAyVKvkiA
3XCGDxWgpWhV3SkfrD75FoESSu7cf60AXZ6IvnbpXeMbD3Xpm3rHqGKyDMh/
ZsbcKoR2Ejm9ih99SZEbCHq3f99g/XW/0wyQnpvzLBOacvp0tC83JSIOTLC6
O/L0S2blCvsza2mdZQ26wXv8zJPRPDzLy+BV4hLIgy7Us2rHRNIo0sjmNlXW
NfFYTJUjvZJWr5s7dtBLpjJUzUbjgQL4+i36qQBYv4E8/RxiN4SHuISR4WCm
p8Mdk2yqqlF9AII6yS8P4HCALGJ3WSXAS/rSMB/SbVzLLhMIQmzm3ihkiLDB
j5TEMoqjrnz3imkSWqIOWIaGIvPdl8Y6aVYEcWlwB2kzfwauIIToCFcHrxDu
lXSmwltLwI7fbkQVxRIwmNs4+ewi4cf5xFjvWwBM2XHI5sd+62jslF+zKXVF
SfVGXj1YACW/RfYXpGEPjaM1+EF4MQQwuDPEs5R9qFsxtq5gamIpEOfEhNgi
ou38/O6csz1+W1rwG1ubl9o9juMFy/zOWEjm+Qo66vk/Gn9K9g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->32017507]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1845615257],

Cell["By default different styles are chosen for multiple curves:", \
"ExampleText",
 CellID->702451365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "x"}], "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210197233],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16174060]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28469554],

Cell["Explicitly specify the style for different curves:", "ExampleText",
 CellID->24232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "x"}], "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5765],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152747427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8248407],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->185208180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1043126087],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220192733]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170913875],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->43022358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->891938947],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8519089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->534064321],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 " by default uses the same style as ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->214639584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1575199054],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223752839]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RegionFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->624241578],

Cell[TextData[{
 "Show the curve where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["\[Pi]", "2"], "<", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"mod", " ", "2", " ", "\[Pi]"}], ")"}]}], "<", 
    FractionBox[
     RowBox[{"3", " ", "\[Pi]"}], "2"]}], TraditionalForm]], "InlineMath"],
 StyleBox[":",
  Deletable->True]
}], "ExampleText",
 CellID->1386283524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"8", "Pi"}]}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "<", 
       RowBox[{"Mod", "[", 
        RowBox[{"x", ",", 
         RowBox[{"2", "Pi"}]}], "]"}], "<", 
       RowBox[{"3", 
        RowBox[{"Pi", "/", "2"}]}]}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1217101565],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWs1rHVUUn7y8l6RN0ny8l7wk9aNY/w1xISoiIi7EhbiIQUgQrdS4sZu6
0Y1udGOLGPAL/FhULBWhglgQC2JBLIgKUkHqwiJYXASE57n3zJ3z5jfn3Dsz
CSRvzszc3zn3nt/5uPfloc3d7aee2dzd2do8dv/Jzee2d7aeP3bfiZN0a3Ii
y7Lz9Pv0WkbXI7ryv+dHI/qs/p2mv5P0QsdJ7mLkf7IOXU7BvbN+xAzcnXR/
uiJnWU8dxy/yTyeISRz3wpp/fPPm/olnP/vl57+y40He2T5ny9ev/0PyjRv/
ZvMt7Wa9p1784vMLP7lLxiUjLn/7u8ik5Mr3f7jLO7y8v/8f38qOtNQ79PLV
H/8kHNFDSl/YvSDypa9/I9NE/vTc1ddeveQuD6b3lZe/Ks2XlJAqkckInD+Z
KnodowJ7NBathlV65OF3yWfiPZLpriGTNx979AN3ueC1DHP0obo2X1789aXT
F0WmCdG0RP74ox/eeP2bMlrVRnqFXpRRuDKkghRpKxVD3XryEyKpjEKZpkmT
FfnBB/ZoMWzUlbBe9KKMkvXSZVJJit3lYgSVWEx0tzlnr6ugOi+twtPj6vqi
LOsbsxH5SQbn8aiv7xOPf3jt2t8pVNsLRZTTLeEnXd17z1vucklFHaheouxE
LNe8wrLkAEF166l7B6MAvSMZImYjeinlNYIk4BRq/djBrBJDlbd0X9Pi0hJr
Xoyhyls8ihxL7hXf215cLnlp0NDH6MVl1ca+6mu7GqAXGTVk6fEqHCozZuy+
yoP337ty5s3LNi9EZo0etVR/pkEPdgT9BN9S9Yn1Yt/BZW/MjJp2YN3DPCN5
BfN4k/k7sa9yF+W77zqTjysyUp6B+oa+3kivyMswHjNaqoLE9I3rQZn10qLR
0mm4qb6H9QYmh09dC8YHdgg2u1lLiOl2sSCcFbSqjchszJHIQJFjqDjKrofI
2xiqXR8xZyJbY6jI6VRXI9wZlLy0nGAsy3Z3M1BtXEqMSmXeGKrdSbFM9CKS
aQyLocqo7ohzy0b+mXXz4f5nWNwtbhW1QSq365e6+V7RrfKsfy7591D+XEEx
7JOxmAv93suB8SvKDnUFZK+nV8jcGjATekV9yw1DLN4rSSQcHnseJuQ21hPu
U2Ga9CHmPDjsms+D0z5HTSm76nOQuJtVcKtzqPpEItmcC79Sdy651RzL429o
nmCd0jPNw/NOcha+qx/LHGEfejTYkiMb1ssa5+P4Lckdg1ozkK6uMgMzJhZB
E9bpjWBfjmzMoDc+A4ljyVPez1PjXNLReCZSKQ+X10cZ0Snm5Wa5BHpDhV7P
P32FG1uVMK5bPKcLToSe/2Hl3CdHqNTdWRgrllRXGKt1/eq9EkHF6l2/T42h
2jU/dXoQQ7VrfqqaM6qLgb08Cqs6sH825TwSa7/fRM55yj0A8rQpYld7Pl3I
EuxZtf886GzYdlfLOE5VW1JyxUcLATU3/BA89+/3il4nn9tto1J+4dTg47la
iSRvLDawCPsglO3YXY2glkd19t7+7s6RFqPS6wiayyaL8LRefy47xJhtuI/E
Mw07VmOoGNH27hFlHdWf7TbeI4o8jKDiDhBl+5xLUJ2XFuCp3p/bp2IxG+2u
vswo6bhjaKmTT5tpMdT6J/VYO7R1TO0T7bO1mI1YWexTDH4ufdyaisrdFZ6x
pXZ+kvdiqE2/gZGMF0PFkwdkVjVXrZe8c8Tgm951CHNiNqVOY+0cxagzI/s0
EevhfIKLKXaxRt+bRk/TsObPq/zDs12bf+st9c4BTlOGNtHrxLlW3JWsaOkL
p4fozzkYr59fYN0W3sb0xXqwOcDRM6nNbNYbmBv2JrqW9pm1HLvMwfbdt6CN
2zirMhdlO0duRFCRl/VPZ2OoqRxon37FUFNcwKoqXhXUThFB9jdSesYSr8Zs
RN/Xz0dHVVTeB2N2SZ2pixxDTZ102l6MoVqdk+0tQdNOHZtGZMw2u+ro3/rK
ut+iovKuqv05dAw13TfgugqanKCk1tH+Nl23bcZap9J/c2AuEr7e6lEdyqR2
vqTUBdxt6l1+lXV+L1vZ9/oOplSHsCLMJPiF2aBgDnHAneS21Tsd5oXfW5Xm
SRPDOku33GUTve6FqcBNooh4jmTSLzKvc0nOWXl7y3mePdC4UM/Dqe87/m71
/96yif8BaeLp6w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344000670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->330014972],

Cell[TextData[{
 "Exclude the region where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "<", "y", "<", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->953404243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"8", "Pi"}]}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Abs", "[", "y", "]"}], ">", "0.5"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41823188],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314939407]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->14211021],

Cell["Evaluate functions using machine-precision arithmetic:", "ExampleText",
 CellID->309974128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"10", "^", "20"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->869598241],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV01SwjAUfm0KdXTHn7jjNLryEB3GERaKg5xFZ2TjHWSpV9ALuHXJ0nVN
agLh5aV57aCwgIG0X/L+v9c0XGaz0dVNNhsPs8HFNLsbjYf3g/PJVE6JCAAW
8nfdB3mfy7vid5rnOQh1V3zgSQ3gn43l5LxAqRyVSKxQYyVbrAE0SQtHaLaB
cEJqgdBGlTcDLSmFEwmxNdqnrW0iVZCWTnTOvHzKpVO9mnq05oHahxjZEpdW
bQS7qgnSpLVCTPL6AfvG1RaljFLSzK5J1tiXoeG4ia77xa265Xc1N3fOc+ra
8TPF9fvfevvJMVVxP8dNJ9ekJsu/Ypaax9KaZ9d3Iy/bN+vHWl/Tx/Hjx/sX
iOXyW0tHmxxNbl/kFx7UIN5eP2mpQw9snVNRIUts13TfZh3NlY5i508588Tl
Zo/leGcummFz6gryis5bXJaq9K4tT7MZznrnrLLOXuUdDV69MKdUb5Rxi6uK
95621u/qXulojOti5nu6Fic1/XUQ7qK6UH5tjNdbTgTHnsjo3SvWuds2ewHc
0rXqM2Oh3lRVcmwTcapanTH9V60pXu9o/+apUHGIVQ9wtDej8uWH5zEv62xi
3alUVNiK6VhzpWvyN/uIivEZqL52zvoUdt4geE9kWTl42bYXhCOS4dCugtdD
GOsX/41g4Rkh+gEJ+Hua\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261091442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47084891],

Cell["Evaluate functions using arbitrary-precision arithmetic:", "ExampleText",
 CellID->152555420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"10", "^", "20"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1711418652],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->415218748]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12344],

Cell[TextData[{
 "A function and its inverse are reflections in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "=", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->429557237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"Log", "[", "x", "]"}], ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "3"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Dashed"}], "}"}]}], ",", " ", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263579494],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188539566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->216061825],

Cell[TextData[{
 "Illustrate that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], "[", 
     StyleBox["x", "TI"], "]"}]}], "\[LessEqual]", 
   RowBox[{
    StyleBox["x", "TI"], " ", 
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", 
     RowBox[{"1", "/", 
      StyleBox["x", "TI"]}], "]"}]}], "\[LessEqual]", 
   RowBox[{
    ButtonBox["Abs",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Abs"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 " in the interval:"
}], "ExampleText",
 CellID->395866629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"1", "/", "x"}], "]"}]}], ",", 
     RowBox[{"Abs", "[", "x", "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Abs", "[", "x", "]"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Dashed", ",", "Gray"}], "]"}], ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Dashed", ",", "Gray"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218172574],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322335587]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->659438975],

Cell["The general solution to a differential equation:", "ExampleText",
 CellID->373092530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
     FractionBox["1", 
      RowBox[{"1", "+", 
       RowBox[{"y", "[", "x", "]"}]}]]}], ",", "y", ",", " ", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192897750],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "x"}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "x"}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]]}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{571, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->802382408]
}, Open  ]],

Cell["Plot two particular solutions: ", "ExampleText",
 CellID->159360491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "s"}], "/.", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "\[Rule]", "0"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "2"}], ",", " ", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12335598],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90097779]
}, Open  ]],

Cell["Plot a family of solutions: ", "ExampleText",
 CellID->523850018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "s"}], "/.", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "5"}], "]"}]}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->710590572],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->378990259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->196661769],

Cell["The general solution to an algebraic equation: ", "ExampleText",
 CellID->16246599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", "y"}], "]"}], "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111429370],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"\[Pi]", "-", 
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}]], "Output",
 ImageSize->{380, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64897000]
}, Open  ]],

Cell["Plot a family of solutions: ", "ExampleText",
 CellID->28414461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"2", " ", "\[Pi]", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}], ",", " ", 
       RowBox[{"\[Pi]", "-", 
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "\[Pi]", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}]}], "}"}], "/.", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "5"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->342191019],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->398232573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193726743],

Cell["Visualize the trigonometric functions with singularities:", \
"ExampleText",
 CellID->467503847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"-", "2"}], "Pi"}], ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Exclusions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"f", "[", "x", "]"}]}], "\[Equal]", "0"}], "}"}]}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Tan", ",", "Cot", ",", "Csc", ",", "Sec"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184333108],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->72602956]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19445],

Cell["Color a curve by complex phase:", "ExampleText",
 CellID->27609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Zeta", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "+", 
      RowBox[{"I", " ", "t"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"Rescale", "[", 
        RowBox[{
         RowBox[{"Arg", "[", 
          RowBox[{"Zeta", "[", 
           RowBox[{
            RowBox[{"1", "/", "2"}], "+", 
            RowBox[{"I", " ", "t"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}], "]"}]}], "]"}]}],
    ",", 
   RowBox[{"ColorFunctionScaling", "->", "False"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15414],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46966891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11630],

Cell["\<\
Plot as a function of parameter the output from 100 iterations of the \
logistic map:\
\>", "ExampleText",
 CellID->25318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "#", 
       RowBox[{"(", 
        RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", "0.5", ",", "100"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12432],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95921294]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24090],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " samples more points where it needs to:"
}], "ExampleText",
 CellID->18461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWmtwlNUZ/txvN4mkkYDEJi6RgGiibRUJl9CYvWU3WRKSIHIrJS0RxcSq
TZG2dMTBkUGEWuMwjNksCTFBjQ7jIOoQdaw42hnqOB2m0x/0R2eY6R9+8pOf
X9/LuX1nv12bsLPZ/c6ec573Pc97Obf0DBwYfOq5gQNDewcaOvcPDA8O7X2h
oeO3++En9zbHcT6Fv2dqHXj24In+PvU8+DY/y+HThaoQlvDBo5cTgsez1KLC
qnHxI6zLjhOxWuT5Z5e/8BWSxTnhJKj8+wMX421j8HYi+OFu6poS9X1z0A8b
xKk62zEh8MoJLxk/LVr2znO8MSr39UwJ3DB8uPG2XMjC75knfpvFA+Eu6M5O
ePL16tGv4m15qs7BJ4jsVdZF7suM7wLkSCLGXfF94rWvWX7Zd3//70ZBFWL+
5fVvWf8fCyzuq7SCd/+uGR5d5MmBc3EExY7p1ISzSfU0pbdSW8UbvJ9/9oKz
gPgA6erX4N4/p97vvnPFp/uPqFVSklFEMvUNJ+N5pXgVoU1P/UORAQN2uor2
BvuOLRTfaOO8qMv6OGI5SsdkLLeQ5Owf/kTyk0M5GwPltPgZBs1mL/7bqZb8
JBM4wkz7eIneYTUc6LqYWnz7zX/Wr3vx/Znvikhd79cZ3kuoxTNDpwQr2RL9
NnW9rUxJ/cLtydOK0E4fOwWS8jUBjGYCpa2jvju2vae0rKFfMBKI2fZkvrNE
T+Av1jqSiOdBz7vkL4n4CBuko3hPd3Z2NpslCmqp3NM9DtLBDI7uhaPj1jy6
Z38z7dRRGaSsXfMnZD9Yxloqb91yVmDejWiHDx/m1jKezVwq86sd22sMdtPt
b4H976YWudFvhB05b0kPyTthQiMcXz4qt5DtTE6SXGnnvBOlMtsmlRgjOWhV
xrfnBU43hrgflNdc4KFRye0vdk709Q6LkSXbRuMxDLo5jQyLzX7vAoqWUvXN
mzdra2tv3LghcnIikbh06RI1LiIh4gVnXpaAsbj25d273gfr1FOLwcHB0dFR
T2ZH99q1aw0NDfgYKSHBRLbLJMmdmZnZuXMnPt5DZVAblNdyjh07dvDgQS1H
epr8DkaFQIBwwMdlVAZVQWFPZli3qanp6tWrGtX29tVUBj6BVeDWwYGit3Pv
K1eurFq1Ch/LVO+QtI4LNAFZ+Ej0uCAIxOHjBirDcGBQ/t6FsrUFl1P50dZ9
IjooO4n4PfLK5+wrBSiPWFZaQeWu7JiIX0bp6zkjysEoqwxZ27e97txL5c9m
/wm5AnM+o/Tv/sO2rZjIDRTkg3Vgb4W056y0RsaZCCi+fv06PpbS4eML38Ps
gDJWWixzZtLZr6IEivYmRgHBIF6j7NmzZ3JysjgKNkUn55mnpaXl8uXLQb4d
FQyYo60Tv3F25oiVuSbkGfmzQGqdUcYed1q2tWOY8mnEjEWgilF8EUpywpo5
sdr2tQn5LBq1JC22WA0LfqIFGuBgi2mgWS+tgc2wWV5kWSRscUZ5sszEBad8
Yf8H0iqEH5l6+3v4+dWjX4pe89WmOsBCIaGFS37BUZGIjbI/+GTQvB/p3TTB
sTlHXQrxmBsdxTJ31htWgjlqaPDDxvuzRfXZsX14x/bTEIFz1EcyzL6is4G9
31jqyZiBBw4b0iUkNQirWc7T0eKPGiw95PnzxYOeP1887PnzRWWg1j/z/J79
oGVRRtGeWwpF54CfWF7KulZXV/OgBAqNFvdVAPTr/nMCReeqn1q6cb2eOWmv
QTnqjLIKY+ISFj0/V5AzwlbZzmj/V73wBh6v3eNWJVC5QpXhpWfxwhXTrUrj
tR2naM8rzLGuZhXX9swqTM92JqiybFdp1VNeKjdHNbDnz2Kmt72J4/jIKx+K
+sD1qO4lZnb2XI7+vt6jwnO3bJ4S9eyTmfZTolylUdCeau/xgOePX8aBvLGh
5aUzE5cEzgNNqaf3ncO40zgc1TqZ0WLI/eqvV2EV8fGFf9HcjKsr1hRCAwIE
H+/wawIdmlf/EaBZEwg8CD985Lldr7O4Xq+zLBzlodxOrxV5vaLXik1W2cAR
WfP558QRhNNIbfWKcbWlQ6M1toUFWHpv1WiNb7XVt1HwVW0xjGcTsSMjb3wk
EPTImq2R3E9lHT+F2sCLU6ZoC2OCNIUj413Vr/pfEyO/j8pvjnwhytVBWBwA
Akuv+Rlrc++kGDljdWbeEmUDq8yMER7ZSsOzhwYnxRoOWIDMf3b6bwLt4Yey
Tz35gTqhUHyFLJZ5bbt967tC9jrB8krLuxZpnXxxq23PSCeOn82kj6PcdRbC
vQJ5sT9eRRSHLNutsMrrLdutsMqLSqBq5nlXAWYBp0CdybGMOWW55XOldOVV
04njX4teeq5lVD1rLreiQqPq0wO9P+fWerbk/ZPeCS0z7P/y4Yu8Li6iI3hF
/+6pTHqf2JVpnXhPt7EzJ+y+zPJJRq3wip9wBM8tel9zj7A372hh9wT+iXmP
JT0x8OLjW0bRT1gSZfWSpwH2mTjLGx4eHhkZwcd6g5eXDn3iPMoj2rz5/Pnz
ul6fGSy5Jbl6N1xvMcdyQSiI1vXaB+ci11U8gzAQiY989qHWpUIejAssC9QL
eXr1VUyePAsJPrEAUoFafOS5Xcd5zPLmqOVZNSXk/fBapKd7kk6pxwWujiqW
q/NJ1NKjxuexcrUfJIXPNCGWxG+1FsNxzx+BfFKnPZslyfjlMyB1hpyM5+ss
D6HlKeR3ef5ea3hqR+YQx25BBJcJv5qmvJAX+2F9IpUIGEmN588lJZDxhDXb
OcqrHG6hM1qSWnS0j/O5Pbg1t9BnIMHI7MN6Tud6nWWSUnI6hceTnZkzdxlc
7P7lSeamCC706+4a+d3wSVG/prln7xMzqE0qgAs+L+CZDcQZyGi126m2e+OE
sMkSQ49U8qCTJk2zGXHlAlbl83PZ4hSIDda1IkAXXsPyaXwiNsboERhPe2qc
72Vwx7PYkMCHt3VFJfg9zurZnjydkUyrU1luY57RB6MTM2H2OyaHtNf3MzBy
PP/m+zT2H2ygbkJirSdBsf5dM6XwTc0WCcbohkDfGYDAaitSoj4bVvq9FPTg
9q0bDrECfDcSTqe4BZK80PAKXM9HA3VcIO3ju3+qsrTp8vMCb1orh/mOKBnP
AVPB+JXKR8AbTJnG7VQ8T/jqFkxmD9rnhs17uqVFZTgReRcpe1f6dQZP6ZZj
VXjYjhmw7/O0JORf3dKpNsgS2dd3E4kRSjd/EWkrYQzhC4pkMFl94FiqfL1l
vFBWiKgbZAbge11zPNhcxIzZlk7eOVqd4Bt3e8aqklkobtz8uqCJqKdVUoRT
m+aM7sVdZQfRS9+bcy/I8KrXlr4pvhcQWcra6/pmVXt+u0NLGxMBqnTELIi3
9o9RG2U31igM6jEGkBSmXqCHQK2fpzYcbZipWFIFqxTD+0isYk3wftqs70zL
O/q5sIANOP537XiP79+dMsJTd/PO41ofoz6dlLeby+Y5Tsqt5V3oXcqMuXgs
h/5Iiz43hT6eF2znkIOc4GD5PGXy/3XI9Y48a52mXwv/s8S57X/mR3db\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236770333]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->762793504],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " for curves:"
}], "ExampleText",
 CellID->71264896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "^", "2"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"1", "/", "GoldenRatio"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33614225],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1nEuIZVmVhm/eV9wb98YrI59mZlVZVYhlplnqXBw0KtI0TQ/EgTgoC6Fq
4AMtJzpREB2oKDpQQXTgA+zugSIogg1NC00LjYIoSLcgCqIDRVAcFAjXtc+/
z/7P+c6OmzciMciMOPu81r//9dhrv84/PfPCc+945zMvPP/sM4+98b3PvOe5
559932NvePd749Tk0mh06Q2j0eitN0ZxvImj5n/6eWP81+HZR4fxexIPjFNp
0j65GY3j8HNbrn2yefoIVybp19Tl0WiGOz517ic+0pxexO902+Tcz7+mKf/2
t3/6///7fTq82ZRffPGvuXy5Kf/5zy/+4Q9/SYeH7fVf/eqP6fDkISXHa3/2
09+lw5c0ZRXaN3cliU0V0uH6HBynG17dXPnxj37ztrd+49m3//t3v/Nz1fXD
H/r+v/zzV374P7/OdX3+uW/GHSE31/Wzn/nv1//DFwPn6MY5ZQWr8bL49+Uv
/a9kfe2rP37Lm78exSzrk5/4wT++6ctRpywrQL3utV9IWA4uaEGvSr/mgT7q
EPLjIAQG+OvNkyEpzodqg4CG32nwHQA/9tH/DNHCEGQEJf/2rz/Zsb7dO5p6
z97/wneiCnGog1EjeyYogSkEhD2Njpu3xdlgIBj5wud/KPkf/MD3Qn78e0gO
ogahOp3SccIxTuSnVwQPiffjci4ICBqKZU2DtED6g//6ZQA6PxPCoKd1Kizv
3e/6trgo5+N3HGcugqtgTDoSF0FNKCiKmYt0NsWXeefvUKqqplOqxfW+XsLs
vvXNn2WpwfR/fP8XsolGylTohOP6LhInekc6VDSUotPh1UZykB8qKIqQ5Fl4
Q2g9DsO/kr81vM+EGGdHj2T5kierLZqYlJpleXo0DqOaUdksr/DSk1fsJJ99
WU9SWGqgSeclKQAHbEsK0hQpRWCWVPjQ5SxJFoCzTc26jD69yVFHjGW5BeXo
SqNjidMjOm78JHl+1EPnVd91XwPZ7l9WlRqgA7qlFsSSOpG3Jjak58Kz4pfZ
UEDJ9S6eJVq21ru8ISMo9cwIjJAIDga8yLnWfduP+kStzqi/YFu663sFaMZA
ewg0KaZIcrEYqQD2LLnhLOEyze2b7PdheOnwFFZHuap1YSV+dO+6qo++bYdh
51Z92pRFjaWWKJWl2ssltaCOH+lYUguL2dvr+r7flB11VXPpzBjs2WNcF4Zh
lF+DwaQJavs+tDkDyzXW03saLc+LV2zaqK56F/6kjq31tqXN8ruvQCdjYFB9
Szl+pJ/Vhn6voFevs+PIDDo+Bb9jXB9amvSvupfYqtC8te7l3oxB7V46VFZU
6pK90DYiDMUON23sWw3sUe+sc+A6Sn5pcTIHxicO3No08iel3crXI2XL799v
XlqigADB44UhjDNMtIGNsjhQ62sOzJE4CEAlVRb+1cA2hbv1eUUat8xzlCW3
4zfgRnVX6uDrfn6JelS5GVjEK2Fle5u+F5yg9hOwcwAUlLo8w2ppGcLhOLwH
SzlB7RQxHe/XuF84ipYyO8Y9Btvb2HEuUEclfzc79p8DsFHV2bz4V/zo2To7
9sOEI8Us2Yz9Q6zYf9YoM4aLFWcZxLeNFbdWfTRmawpbWkHHYstt6TK/ZwLW
ntxJK7ZhacWZinC4JRu0UJu+Zy1h82PU16w4nvhtdTSWPoVlrqBD1d5t/RK1
pY6e7OHwe/dg8SeZ3Rlqu4LNTvJ9+7A52o5YaHtE3fGHURqVqfRV7jVlt/oL
lE9grVMwsQKzkumWfIky9Xbl3Fidf+rdjjfHkCWsbpnqtu5IscT9Y7xP7Ko/
2O3n7gEnx33uQc4C2j2BtQq3s5wVnu9bg7kkt6cXRGrtL6H9Y0gQUnu1kDp2
TXB9iZq1OWTzXBmxUwrSgb0jbvuj5NgfNV7ilmoGRlcZh+rjfJD1p0UcPiRi
2p49+Rg1mIJZMc0cwNfrfmfbPo8tp6Lwsu12BD2C5TCTXkFDzGKpsTHu382W
jZS2YJsTs27JxKyjQs3bujFb76PXuSZnMdv0ac6MavZ+ti1HYHIGplfQRN0S
+vlO6VudAyF1b4aOwKAQOr71vcvZs97jXGMMm97GZBcfy3ehMcVJe/URynre
0WEFDdMCFqgvbXloqw9CLIbdkokZ5x9H0Cn7Kaqh84cpbGqB+9mH6+cNe/lv
nVdH833oSyjtaXNY3j5QTMD7Ajzrui3/yk747Bn7sLcj6GkOu9b9zB+Md4H6
jGEH/Rz0HtjYx91HkFbXKcejLH0PNkG/f7KHg220bUOjdG4ZhMPxhFmGcNhr
hYPjEy7X+yt3IWUFDziE1Dmk7oMN9muY8dOH2X+5C22tIK/Me+WoPIf2hId5
cr8/1tU+tbncwhJ7a5ZyCJuh7paQOsPze/CICe6vs0StuTdwiPK86gPMdM2i
8NiDqVWzlCw7zTYkcBqhSrOR+knXJMn51CLfOwEC6nHZ1jhHxllNj9PuCGu6
ubHczNETQFfGMDvo2l71soeK1s48NG7MPjWDNTIWjAsuGUbLwNDCrqLcjBfk
uTj3xvZr3pFbOMXXxabbJ4krGckMFtGOSzB2P7ELrrljeQtNzCC6zcpzco3M
D/shcVfHLxIqRXi3aGVcIMure2kV69QRdTTIKbv8ydoXuCMhnpZcjB7Clj5u
zB6yE4+zUsOefp0PdPHFT4SpBSysj6+Pu1sucbDHYDqb/IBzyHW03bFto7WW
lvltzB/ZBux1ahW/w33mPb2z5Y97clzdidWOv3L9i5A40+kjtlWzlQDioHEO
S+77U9Qg3zzedHKkQe/zRr56rcp3d67cfBulRvTLU3k+mRayyDJGk4CXX8b+
9V5rHZ2+lJ7xuSe2YR3Msvu68KBfZdR5ToZjMUZdBscHfe+W82m5V2bT3AYU
4zP532ZPZZ1PoBqNhuupOPK137GTAFYs2pbkehmr6tUfwe7mw+POW6UP5gN1
P8jT6RXcC0jo4pafLqG1NtdvWrsebudyws156nhGVAz6CbvppO1tKLvozHLH
OY7hJwSTUl9Ga1tXaXdy/jSrWBZ7SKq9A+Dj23BOu3Oe49Ly9NtfI7Unsoe4
aKXkFn8Ge9rDe1tfuBjXTzVltxrKIzk74JggdLZ/2pVQuD3jDFoZt8z6Y3x/
CjoXHuc/a5QXVXzs2znbn+P+hr043p29xPUrmvPOAoXSuQGttK5jl+s6Zv/d
OO70cDiOHEKba9jKolp2ri52mKNzduZiNmabYr+XM1B1ndrmOMrFOetVZofZ
4lNVrTlrqdu6tUpcHDdg+WHY4igBRxEY2axDRj7aEm1tDfm3d9Ke24A1at32
RziuzHGEObRaZ4vt2M22nN/y8qbMkSbk053aLqHTat438Ey3E+tsW3daHNkz
xJLjXFmZnLWwRm1lS/Zc5kyMU4xj1Nqlhi0Zl/LQxNSH4/ix/DfV5FL8TXde
OpvbvVIOk1PvIfXvq9nVw5adEwq2VxfmOuwkdV7Kec3kyL0IPpfXQj3gPTmv
zu/xeYWK9rzRi6be3dbsEM0TfZ7jrQlTY0p/H57Prmmp0TmZVpOwjem8AvUB
75FjDZnOa5UG5/OqxVGvn5jurNsTZ6pk9w+KwGWtWVQg1fIE1xVj3IryfRyR
LLmnmrx8nauMZDFG/bHemrzh2kTY0wB/IA9q0wrXOn5noMeoT8GbtcPx8+5Y
YYs3Rfx5KzfHXsao3do/XY+YE6LTen1l3W43hJaj5Jx1ZGbvbKPGbkJ/r4oj
4kkQk/oyj+M54eAIK+dV2Q4TF7Xab2l2z0hLThQ2lVh7aVPmCg23e/tVnVPH
rl1fxz5/d9OduQwtaMihaXWGWnNmur/prD/o4JyDlTpL2B1xbhsrbAXXycMf
7Vh0OjyBzYgtzsNSt/3ep9ny+bvAweuPVrWGedmBFpljcZTHNsXVFxdjT1LC
Q4OQNMb7CHQi9hzfiJJzEZw74Ugm12LXWbTtP1LVJmYLuXYLuZbHJvvspfMH
F2KtRM1gLWUpyiAdt06AmvNsbFXYN+NIO+dPyFoZGY1XpgzvDrR4GfK5ZoBz
tvXxcs6AsY+8a3xbwrJvo/ZcEbtsbTT3C7iygH21uqeY7bs9HL7vNrR4Gc/p
fvcL2FrNYYscry6jy5nVi3ksV87casqOM5eBUpbPXhR17ee5unIGdml7XGlz
C7YlPJxNpS/YGthb4noBzgnXWTxrbqS0jXknpvaG2lNPYYuSzhVYbjM5frGA
rc6Avs5e2VWZ8Xh15inY5Yi08HA1xtmjU1yju7/pznC0c8J6q9vMm5ByChvi
vBuf5zgFbYBrWO71cJj9m1VtcfyV6/u44oejU1xvYLZOCivDPkFoJ1CkIfqb
0FFC5VETroZg/mPP5Kg91xEwq9X7HG9uQAvca6XacvTJns5xCY6RcWdCnR2u
qbwBizsFCxzlpc64k4djUROwWGcpPDIeSR4lPG67ODOxgE1x1Kluy/0x/C6L
dZa4q+M6uD0FC9QFdcdcmq0E1zWRJY7FX69qjavMbPMcE5uCVa6kpW1fLiwl
vz/A09dQvoKnGeVWQCt2HI84zsq1h/d6OMpW94zD0Vkzd9wh4fdyPJVzoO0K
Fq6eFRtHm7NX9XPc4AD8CpljwVXohyPJa5Sn0G9df2bszrmx2sOEzR6sMtfG
ubxGmTOwS5Rp+2K3GdXduhaa413C7Uhytco5s3prlTvKuG6raw3p750LIrS9
Xq0y3Z/H7NqvmOWOHvoNmXULc1FmuS7wCpgSbs5tWaMHVYtw9OOeFO6vuX1B
xP1VtV2EQsxVvI5I9FfuVmHfhLtszsN0Kh7CdhnPr0EDHLs5qFpGf4fb0DJs
absxnIpHeLOQuj9zFZKE1G1DQtpby9Nbk9hfF53uOz2DyXYdP6PXUfe5jgWI
QfZjsMt6sIeQOxaocdvwkMFtCAde2YlDQup4O8f9B2C47k22nQlqepZtEifn
G4Tb0Yu7LoXbmSBHKbiHurqGerAy3pZWZ3gb4mO84QTMXQNTHNM7QI3Y/+C4
EVfG9POEdpVPHaWlCqVzO6F0n5WjUULJL3hwZ4if13V77J2d8HFfqTP063gf
1+0eAA/7KdwDIBYdy/q5Z1k1lq3wuC3nnE/9B/stv6shNGfvKFhVdepym3te
hm0Jh7MLZugz1KrkAr0dBdyfw115LpuV4Zo67gKy7tjbm0Kq2iHu+kGfdF50
tWlXRt+v4nDU5+4p9vI4ilW+gtTbKW0b4n4w7qrfxo5t5wgohIp9Re5QGu4y
a/KyebGFTbvemazIZpyFcA3RDWhvChs5qtqE4xPHDmm7dVa4rpf7LW5sui22
bUFo6LfY3z0vOtq0U+B1VrgOjeMmtmGujDyq2sJw3yvXIZ8WNrwC0rbBqHWz
giK9lbuFGb3EQtHJpl2vcD/LZWa6bnHkr6XdhOdMgYM2zK/HSH5ho9jmlaot
cMRunWv5kioKewrn6RmtujpIf2kDHOVZw7Iln2NvziWOUGZLLBa6X2XTu7ex
4BFErjGso3FbwD2CjE5Dnai1JCu0Dfq3cDias98kHPxyFkap5iW+bdrlOGal
3eMznGO0Z9yqeoBb5ONBbeWD+p5N97s18pr7PbmcpfN7JZe7rakFR29+v0K1
L/Fg035Bq24TV8E1R49vVXVulo4HXOt4+PUy1YC2IPn8Voi1cgu6FhuO/cOv
xOlY328r2ZiMZ7SNA8+rln0FOWbertqby8cDxnVNGArWvLaszoBnUTlKeAv2
Mka5af1npb3Ki2oku/h2Xm1Vr/816JjzwKq/Wxju7xeCYoF5hZV6YjqrZ5+u
yuVKDdesGYmal/iyaf1YO10KQ3lF3mH/rAgZ9X3+eqvZHAE5xieJ3T00OobE
/B1Q1VAFWf3Tm+78H0eOXJacbuupa0lO+aKnFJKlqCDbbiymsfxE5mB9XKUH
qXprPVeyQa7iaCzC31TMK+JOu2ikhoxGd6o9fezcOEIvQXnSDueiGhy9mCo1
dnc2bso3D4VFd+sdYuYYUpuY0ethsy9YcrFQpr+N6fnaRxv5JabnVXjataGz
iohNNJrKIKXdl14QSxhkvDUxXnpQ2WaFpXzHM6+wO23PqhXJWZYYEjZp66IM
aWVvVChYDp5CJ1HLQJRmj5s6TqMQfqCQWfazRFEf3xUzigO65/zMCEMwE7UJ
JFFBrbAsq9WSXYZuQolxQVlGHId1pA2xqnOIjxqkJ87DRLqhyUpmIT1eFk4Y
1UoW/HhrKd23pgwv7mqzhORD3PnzIDnx7jCgUKa+XJvlaIVSigqSE1fyCqqy
zqs783IBPX/63E985O8m6eObTWecaZ7/fg7lTzR3pUd2+QL66NLfANboQHI=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->160746590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->402920390],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " for parametric curves and regions:"
}], "ExampleText",
 CellID->34695851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
       RowBox[{"r", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "1", ",", "2"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557810802],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->22776320]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157163518],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " for implicit curves and regions:"
}], "ExampleText",
 CellID->350119962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{"1", "<", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "4"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58342368],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmAlsVFUUhoeCoolFVGICBspSAYmIAsUagYPBmKAYKIuiCUogLBI2IawV
EVS2sIlgoEBYIiCVtUDZPSyylLXQ0spStiLQbYZIA4TVmXfPN8285iVD6cx7
957z/9/579TrPbRL37hAINC2UiAQee2WsG98lXvLZf2EbU8KHoQ04P1s3O1e
b2tGYoe5iR1WaN2Uya3Wh/8+oKTo69HLV+j8O6/njAv/Xp696+DI9E06vfuQ
hk1KQ7rCe3+GbnhSWFpUHP59W+DXbYHNuiy+aGl8UUiPt9vdpXeNndr6dNGQ
s7khLckcfCFz8C59/nGg+6zskE6s3jB1yWt79GT5c2+2PxrST3+fOagsYZ+W
JfzSKmNrSNO8++/X8pf6DihMD2n15Ps7puUf0Abv18jstzj895Sa81NqHtR7
Y2aHr5D+Fbn9hUMaX1q7a+XUkE7d02dgr9ARXTPR+4cWes8/pqfutA5fIb02
5dCD7B6ndO+xN8a890xILw77e0uj5tnaYFWbXyaWB3VJteJl1YqzdZt336D+
5q3njJY9fruBrglqYq95A//bnqNJYy9+sX9IUFM1ZZSm5OnMjIfhq0x3ep/L
0waXZoxpca1M133b7PaGWvk6oKDX9O/yyvTs3kvvJG3M1yGRt2WW6WVvfRd0
VKVNa1peL9UJefGrjvQv0LWH9uzVgaX6VeXUw7l7L2mzpI2jO8aXapzXtyua
363W8ODmEj0d1zQ7rukV/XNHWvgq0U5VR3auOvKKXvTuW6JdI+Waf1UXeW8o
1nnefq5pUp0TCYNaF2vhW8Fr4UsXLs4KX0V6wPsp1I/nRt5YpD+1Tw5f1/WP
GUfD1y1tGPn43Otap1ZJ+z7jb2nS5yPC1796OHV3+Lqpcf1eXNCm1w3d7m3r
ht79Zmn4qnjl/3kfn+M+3Jfn8FzWwbpYJ+tmH+yLfbJv6kBdqBN1o47UlTpT
d/pAX+gTfaOPU8/sGDS5cZm+snLEuRdSzkf7TN/RAbo41nZKbpXCCt2gI3SF
ztAdOkSX6BTdomN0jc7RfcRVE9pV+AKf4BuvfGkhrX8762rzKweiPsSX+BTf
4mN8XfP89uKE7ArfwwG4ACfgRpQjxhU4A3fgEFxa+zQ5dWf4d7gF1+Y5zilc
g3Nwbbh7v3C/xu5+wvNy3fOE9Uxy6xHWO8mtV9jPOrcfYb/H3H6FevR09ZCg
1UtcvYR6Tnf1FOr9squ3pFs/xrp+CP3Kcf2S/dbPE66fkmj9znP9Fp8eJGh6
meX0Iq1MT7WdniSrSWbjm58Eta7nt1yZbfob5vQnx02fGU6fgn5XO/0K+s5x
+pZppv94p38ZY/7Id/6Qdeafcc4/0tL81dH5S86Z/x49jfxclrXmz5POn+Lz
ryw2f3d2/pZk8/8c539ZZHy46vggPn5IuvFlkuOL1Df+1Hf8kSzjUwvHJ/Hx
S+4b18rdqzxrXNvi3ifJxrVD7j7i46dMMa6tduuQI8a1j9w65YZxbYHbh/j4
Ld2NawtdHeQz49o/rk6SY1xLd3UU3/yQzsa15q4P8qNxLd31SXzzSV41rk1x
fZYC49ogpwPZaFzr73Qivnkoo41rs5zOpKFxraXTpfjmraw0rrllBKUgdl5L
gXFtn/OF+Oa9TI/NA+LLC1LPOGc+FF/+kE6x+UTGx+YXgXPGATkZm39keWw+
El9+krux+Ur6x+YvgXPGPZlvnDPuiS/PCZwz7kkj4xz3yzPO8Tw4x3p+MM6x
3g3GOfYD5yzPyZfGOerxgXHOuCdwjnpWN85R71TjHP2Bc/Qvyzhn3JP7HhdO
yaPJW4f2eBiUfOOecVBWG/fQC9wLmZ4SjHs2V2WgcW6O6RHOJZpe041zxj25
aJxD79WNczb3Bc6NNr98b5yz3CBtjXPJ5jc4Z9wTyyFiuQQ/C37uYpxLM7/D
OeOeXDfOpRkvjCcCT342zq0x3sA5455YDhPLZVLVOAfP7hnneOX/eR+f4z7c
l+fwXNbBulgn62Yf7It9sm/qQF2oE3WjjtSVOlN3+kBf6BN9o4/0lT7Td3SA
LtAJukFH6AqdoTt0iC7RKbpFx+ganeMDfIFP8A0+wlf4DN/hQ3yJT/EtPsbX
+BzfwwG4ACfgBhyBK3AG7sAhuATX4BZc627nVrgG5/g7HOTzcJL7w1GeD2fH
fxghdQWHWT+cZn9wnP3DeerDHGAuMCeoL3PEzq0Sb+dYO7fKEjvHMoeYS/SP
uUV/mWvMOeZedA7aXEQ/zE3mKHOVOcvcZQ4zl5nTzG3mOHMd/TP3yQHkAnIC
uYEcQa4gZ5A7yCHkEnIKucXn72jOIfeQg8hF5CRyk48v0ZxF7iKHkcvIaeQ2
+EauI+eR+8iB5EJyIrnRx9doziR3kkPJpeRUcquP79GcS+4lB5OLycnkZt98
ieZscjc5nFwO98jt5HhyPTmf3L86dj6qb35GzxGcKzh3cA6Be5xTOLdwjsmL
ne/Rcw/nILiXbd/vcG7iHLXe+Uqq2fdDM5zv5L59f/T0Xc+XwvdLvrwSPbdx
jusZm3fUl4ei50LOiZNi85T68lb03Mk5tHFsXoueWzn3+r/P+x+9zCkN
     "], {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       TagBox[
        TooltipBox[LineBox[CompressedData["
1:eJwl1Gl8CAQYBvDNNrPLsHs228zYfR92JXSJrhEpJZOKakN3SclRuuhQObov
R+VIpwihVKKD7nJ3UBRdCP/9+vB/3s/Ph+fNaGxuaAoMCAg4QbTcVgQRTAit
CaUNYYQTQSRRtCWadrSnAzHEEkc8CSSSRDIdSSGVTqSRTgadyaQLWXSlG9nk
kEse+RRQSBHFlFBKGeVUUEkV3ammhlrqqG/pTQ9OpCe96M1JnMwpnMpp9OF0
+tKPMziTszibc2igPwM4l4EM4jwGcz4XMIQLuYihXMwwGhnOJYzgUi7jckYy
iiu4kqtoopnRjGEsV3MN13Id13MDN3ITNzOOWxjPrdzGBG5nIpOYzBTu4E6m
chd3cw/3ch/TmM79PMCDPMQMHuYRHmUms5jNHB7jcZ7gSZ7iaZ7hWZ7jeV5g
LvOYzwJe5CVeZiGLWMwSXmEpr/Iar/MGb/IWy3ib5azgHVayitW8yxrWso73
eJ/1fMCHfMQGPmYjm/iET/mMz9nMFr7gS77ia77hW77je35gK9vYzg52sovd
/MhP/Mwv7GEvv/Ib+9jP7/zBAQ7yJ3/xN//wL4c4zBH+4yjHaBl/IK0IIpgQ
WhNKG8IIJ4JIomhLNO1oTwdiiCWOeBJIJIlkOpJCKp1II50MOpNJF7LoSjey
ySGXPPIpoJAiiimhlDLKqaCSKrpTTQ211FEf+P/fOw6q4YlT
          "]],
         RowBox[{
           RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]],
        Annotation[#, $CellContext`x^2 + $CellContext`y^2 == 1, 
         "Tooltip"]& ]}}],
    AspectRatio->1,
    Frame->True,
    Method->{"TransparentPolygonMesh" -> True},
    PlotRange->{{-1, 1}, {-1, 1}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyd23+w39OZB/DrR+2wzdZmdXH9WCySrJ/N5GpGw1GxWGPaK7WRql4WUZIs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     "], {{
       {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmwncl1P6xp9zzpNtEkmWNkoRyhaVFlKE7Em2UIkoMqGkSClkqZAlDFMx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           "]], PolygonBox[CompressedData["
1:eJwtmHnAllMaxt/znKMpzbQog5DS0AwzsjSUmUq078tMVNoLQ5tKYYSaKCFl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           "]], PolygonBox[{{1068, 420, 1067, 374, 405}}]}]}, {}, {}, {}}, 
      {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwl1FWUlWUYhuHNDF3ScACsBdIp3SgKHHhCxwkn1EIapKRcLEoJFRDlgEHp
7g6lpEEaVBqkQ3oAGeB6Fwf33M/zfnv/e8/3f/8u1rFPy97pEonEIH82JScS
X4aTEol78nq+hI3yBtzGLaw1u4D18jrkwL8omN4ar8FqZEILbDFvztPxE5ph
ptkK15gqL+KiehEUxlu9qfkmuQlPxmfYqzfmV9Yb8Ub9E56Ehtijf8zPrdeP
76zX44mogz/0uvzM+kfyU67C83iC+ez4PnoN+Vt8g2rYbVadH1q/yP/FvnAB
8wv8QP+Hz+McftX/4r9xGmdxBr+Yn+ITGGqfZ+kn5RQ+xsdxBEfxZ+yR+SE+
jAO4rx/k/D53P9/T9/Hd+H+4Mk7KI7gquntdFe7B43mutcryY67Ej7hW3Ge5
Jp/S52CaXlt/Ir/AGj2VT2M+ftQbWH8pv8Za/X8+gwWYrn9qPU2uKr/hatwL
PfGdtcVmP8tJ8sjYN30JZph9riejrpyeL6Ml0umZuR5f4Wu4isFxHSTjun4T
NzAi3o878mj7vcH178pfm2VARtyP+xn3EKP0TPEZsUd6K84V+4D2yKLvQm65
NefhDrGv8nbXTpFnoWt8nlkXHsNzeCyPQ9s443qbOO9xb7BA3h17J+/nhXpv
uQT6xPOhHzBfJB+KfdL7y6XiecVS/XDM49zwcn2QXAal5YmYFPuOyVgWe4bv
5SG8Asvj/HnvKrOhcnnsQFY9G4bJqaiAnchuVhY3vScHv4jzgF3IqZfDLWsf
8Kt4hpLf/8aUj+eNK/Bt67ni7Fh7Hc8ncusV455Zy8NpZm/i2UZePR+Gy29R
MX4TkDCrxKv5hPetlFfhq/jfzI6a3cAP8hR0i+8e+8NfxHeVV/Ixr1kqD4j/
UR/I42IPsUw/Yn2x3Df2Ru8X9xUl4zzrB+PeyT2xPc573CMuiQ/jDMX58Zrr
KKa304vz7PjNQCf8btY53h8ZBfEchcx/423Yimd4Gtm1rmGLvBmP8DCy2ZWk
97/p7wAD1dcI
        "]], 
       LineBox[{1077, 1049, 1135, 728, 1136, 1078, 1079, 1050, 1137, 729, 
        1138, 1080, 1081, 1051, 1139, 730, 1140, 912, 840, 1141, 841, 1142, 
        769, 913, 684, 1178, 845, 774, 846, 1179, 685, 916, 688, 1182, 853, 
        779, 854, 1183, 689, 920, 780, 1147, 855, 1144, 1146, 1145, 921, 1148,
         1089, 1090, 1088, 1092, 1091, 1150, 1096, 1097, 1095, 1099, 1098, 
        1152, 1103, 1104, 1102, 1106, 1105, 1154, 923, 701, 1185, 789, 897, 
        898, 702, 1186, 860, 790, 794, 1204, 793, 740, 704, 1188, 866, 795, 
        800, 799, 900, 899, 1162, 874, 1159, 1161, 1160, 933, 711, 1126, 1127,
         1123, 1125, 1124, 710, 1121, 1122, 1118, 1120, 1119, 709, 1116, 1117,
         1113, 1115, 1114, 708, 932, 705, 1189, 873, 798, 931, 871, 1224, 872,
         792, 865, 1213, 864, 927, 862, 1223, 863, 788, 859, 1212, 858, 924, 
        787, 857, 1184, 700, 922, 698, 738, 1060, 1059, 1101, 1100, 695, 736, 
        1058, 1057, 1094, 1093, 692, 734, 1056, 1055, 1087, 1086, 690, 732, 
        782, 1084, 783, 1085, 778, 919, 851, 1211, 852, 896, 777, 1181, 687, 
        915, 843, 1209, 844, 895, 773, 1177, 683, 911, 768, 839, 1174, 679, 
        727, 1134, 1076, 1077}]}}],
    AspectRatio->1,
    Frame->True,
    Method->{"TransparentPolygonMesh" -> True, "AxesInFront" -> True},
    PlotRange->{{-2, 2}, {-2, 2}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{330, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->47287799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448224811],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLinearPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLogPlot"]], "InlineFormula"],
 " for logarithmic plots: "
}], "ExampleText",
 CellID->46767761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"10", "^", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], ")"}], "^", "2"}], "+", 
       "100"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", 
     RowBox[{"10", "^", "0"}], ",", 
     RowBox[{"10", "^", "5"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24914874],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWFuIVVUY3jP7nHESHR0HHUclJ0UrE0lEulBeGLxU2jDIaKYmp1NyRnHG
yyg6KmaI9lCo+eKA5IMpdHkwFEUwCIVIkIRIEA3CIOwhCRIfBoLlt/5/rT1r
r/2ffc5pNIocmLP3v/b33y9r7b041114d32uuyOfa16wKbeh0JHf3Dy/axOW
wqogCM7gv3N0gHuFO/o/oxSu7m8jfkM8Gm2u1bhW49rg0aG5Diuybq913vNG
j36MtGptgV5W9Md0pp9mvIuoT0UEAsfQijgkCUNKWjWyJKLmkb+P/P13+5uN
VgxfQ2lN+M/87zzXtz5dRTA95XRMmlR8GjYoeUoOK7LuTlGX1lq1WfXeela0
5oAXjcdF1EEjY5y5ZhKrLk9ITw95q2Mde+yO0uRhjoirbOOtW38YmvtoFH57
rV8JnjEl6LElno+inN+923f4429Xrfjs8ne/6OjUlqWr3aNpMoRffP7DsvaT
+C0yF3ypH+ifzKWLP4MLRsCUISJuH+Fu3vi9q/P0jp7zt2//WSfi9hLuzp17
e967kH/7y6vf/zpcxL1PuL6+v3qPXIbqry/8NELE7SEcHgN04tOrYGgQcbsJ
d+3H3zoKp6AaBowUcbsIB/MBAhQMjSJuB+EQDtiHzMCAJhHXQ7ivTl0DiO0b
I+K2EQ4JBu6jDy/BPqpnW+Tmz55J6j3urcSN2kT0t3SfxQ11EOc4dTrUeXS3
9YsrDvlp/puSNnv1NqECOZrcaCsPZnDlTSxTQo2JUo233qViNYooTSpTYjaB
8OfYemXqGsnjun6SgWF//tyZqYWZodEvNCF1nTJdgNJBGFBGTxNyeEl71jrR
Q4kielMizlCITUGZ/oj6dyrh/Urz9ayxfnO/wO9pxDdCyfP+HVtfUV8/q6R+
yCu/b6aLuBzhoBZB576ZIeJWK9PXcA4uoghmirhVjn1QjQA+J+JWJux7XqX3
q76uSFj7YpkVaPfX5Qk/XqpAgksvtZ6iuZAJeDqrQltIgtPhc8rkH+TRGVOT
S5Ty9pq5A5Do0m3Kr+4WVbI7nWdSJbcqv/Lnqag3nbOM32mLVayn0QELlO00
aWotslGJOnlhKv5VFZty8JVWqCPTYrTQ+rN/3zc8wUhzovLnW/uPfXIFiTp3
9vrrIo6iYXZmQMHQKuJabG6inblNxFEtmMrnnXmJiJut/A5uF3FU7bEOXiri
qL9iPfsG4bJOvcTO22YttMPAeUbdrvdpbNLcvW+SLMLFKjy54uux9fqC9Tc6
I64ckExN0swLOTa6s98akESXnpmI5uoHJnuGUyEc3dwDkz3dRjmqqnysCuyZ
o9h7Du1ysWqjnTBRbbR7mm7g+KwRcVOtPQBxNxRE3DNEo0n5+MDnggSKThXm
/Ij2h9Z1Iu4pomE/Dwg+9SRQk60PPLHga6eIm2SlQSt0BxtE1ESbVbjJ0jaK
ODpfhpg3sA26+fxJU0/qxCesbowcRJHPvfw2nVIFdBYO0WgwRN9uKYtrPNFI
FNTp261FuTQ5ePbLvRlEJMhACQYnPEKo9VtXNahtZWkcjB/dZEEtVIILTkIi
BCOGWEF+ecfEsMAk0rflyaXnWUQXprW1HodLSIeJLaKIfEN0sD2KvNQJ9E6r
Zwts0ZEPbUwxaPTtdjG79BY2CC0NLugEhd/XXjmm9feIHPRdJwtvOVdoAVQ2
v7cVwcIaOAWJiIl+1ZaxRGcwYjADYACYUnD6dAQotsBgZwoKqUJyoDYVhR4A
CkFPRcEgoJD0Iij+TjCv5Sgg+la2nlG8v/ejapX8Ld3PscxNX9Ir+o7m0/8F
uZpkeSjVh2InWhm191DkohDj2Za+9cnZ9rnlivrnUShzNE5xlPy1j1eDqvs4
InhC\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->461039252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->749854],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 " for data: "
}], "ExampleText",
 CellID->1112749563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10", ",", "0.25"}], "}"}]}], "]"}], "]"}],
    ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->789105347],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2489222]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->421304857],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " for function and parametric surfaces:"
}], "ExampleText",
 CellID->693877993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}], 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24486205],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->828032554]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"Cos", "[", "u", "]"}], " ", 
      RowBox[{
       RowBox[{"Cos", "[", "v", "]"}], "^", "3"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{
       RowBox[{"Cos", "[", "v", "]"}], "^", "2"}], " ", 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"Tan", "[", "v", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->704574670],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{152, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136956775]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4970],

Cell["Eigen functions in a potential well: ", "ExampleText",
 CellID->1530322957],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"n_", ",", "x_"}], "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", "Pi"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "4"}], ")"}]}], 
       RowBox[{"HermiteH", "[", 
        RowBox[{"n", ",", "x"}], "]"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "/", "2"}], ")"}]}], 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"2", "^", "n"}], " ", 
         RowBox[{"n", "!"}]}], "]"}]}], ")"}]}], "]"}], "^", "2"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->243810284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "@", "\n", "  ", 
    RowBox[{"Append", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "+", "n", "+", 
         RowBox[{"1", "/", "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "0", ",", "7"}], "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "/", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"Filling", "->", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"n", "->", 
       RowBox[{"n", "-", 
        RowBox[{"1", "/", "2"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "8"}], "}"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->320644712],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 199},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->28225040]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21293],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLinePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLinePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParametricPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolarPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolarPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Show",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Show"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9129]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17206],

Cell[TextData[ButtonBox["Basic Plotting",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicPlotting"]], "Tutorials",
 CellID->16911],

Cell[TextData[ButtonBox["Labeling Three\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingThreeDimensionalGraphics"]], "Tutorials",\

 CellID->150738960],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->62653972],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Plot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Plot"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->421966252],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "MoreAbout",
 CellID->512350195],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->82575996],

Cell[TextData[ButtonBox["New in 6.0: Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FunctionVisualization"]], "MoreAbout",
 CellID->170492408]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Plot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 9, 45.5876702}", "context" -> "System`", 
    "keywords" -> {
     "curve graphing", "curves", "function graphing", "function plotting", 
      "function visualization", "functions", "graph", "graphing", "plotting", 
      "visualization"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Plot[f, {x, x_min, x_max}] generates a plot of f as a function of x from \
x_min to x_max. Plot[{f_1, f_2, ...}, {x, x_min, x_max}] plots several \
functions f_i. ", "synonyms" -> {}, "title" -> "Plot", "type" -> "Symbol", 
    "uri" -> "ref/Plot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[34003, 1022, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->133417416]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 712790, 15538}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3234, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3857, 98, 4188, 83, 70, "ObjectNameGrid"],
Cell[8048, 183, 2141, 73, 70, "Usage",
 CellID->5984]
}, Open  ]],
Cell[CellGroupData[{
Cell[10226, 261, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10704, 278, 1005, 36, 70, "Notes",
 CellID->27110],
Cell[11712, 316, 390, 15, 70, "Notes",
 CellID->24417],
Cell[12105, 333, 488, 18, 70, "Notes",
 CellID->29397],
Cell[12596, 353, 418, 14, 70, "Notes",
 CellID->8125],
Cell[13017, 369, 407, 14, 70, "Notes",
 CellID->41],
Cell[13427, 385, 351, 12, 70, "Notes",
 CellID->7406],
Cell[13781, 399, 11310, 302, 70, "3ColumnTableMod",
 CellID->11410],
Cell[25094, 703, 619, 21, 70, "Notes",
 CellID->28463],
Cell[25716, 726, 1143, 39, 70, "Notes",
 CellID->32048],
Cell[26862, 767, 445, 14, 70, "Notes",
 CellID->4690],
Cell[27310, 783, 679, 21, 70, "Notes",
 CellID->4969],
Cell[27992, 806, 625, 20, 70, "Notes",
 CellID->5344],
Cell[28620, 828, 569, 18, 70, "Notes",
 CellID->40938333],
Cell[29192, 848, 615, 21, 70, "Notes",
 CellID->28599],
Cell[29810, 871, 838, 27, 70, "Notes",
 CellID->14643],
Cell[30651, 900, 213, 4, 70, "Notes",
 CellID->10155],
Cell[30867, 906, 544, 16, 70, "Notes",
 CellID->12464],
Cell[31414, 924, 1120, 38, 70, "Notes",
 CellID->131709506],
Cell[32537, 964, 564, 21, 70, "Notes",
 CellID->14537],
Cell[33104, 987, 862, 30, 70, "Notes",
 CellID->5558]
}, Closed]],
Cell[CellGroupData[{
Cell[34003, 1022, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->133417416],
Cell[CellGroupData[{
Cell[34388, 1036, 148, 5, 70, "ExampleSection",
 CellID->108395154],
Cell[34539, 1043, 54, 1, 70, "ExampleText",
 CellID->8764],
Cell[CellGroupData[{
Cell[34618, 1048, 230, 8, 28, "Input",
 CellID->7234],
Cell[34851, 1058, 3653, 64, 128, "Output",
 Evaluatable->False,
 CellID->135272067]
}, Open  ]],
Cell[38519, 1125, 121, 3, 70, "ExampleDelimiter",
 CellID->14015],
Cell[38643, 1130, 62, 1, 70, "ExampleText",
 CellID->30118],
Cell[CellGroupData[{
Cell[38730, 1135, 402, 14, 28, "Input",
 CellID->13384],
Cell[39135, 1151, 7614, 129, 128, "Output",
 Evaluatable->False,
 CellID->154347910]
}, Open  ]],
Cell[46764, 1283, 125, 3, 70, "ExampleDelimiter",
 CellID->658092056],
Cell[46892, 1288, 63, 1, 70, "ExampleText",
 CellID->1012403142],
Cell[CellGroupData[{
Cell[46980, 1293, 311, 10, 28, "Input",
 CellID->946672413],
Cell[47294, 1305, 2648, 47, 140, "Output",
 Evaluatable->False,
 CellID->475719274]
}, Open  ]],
Cell[49957, 1355, 67, 1, 70, "ExampleText",
 CellID->237812485],
Cell[CellGroupData[{
Cell[50049, 1360, 524, 17, 28, "Input",
 CellID->447368328],
Cell[50576, 1379, 3432, 60, 142, "Output",
 Evaluatable->False,
 CellID->56104018]
}, Open  ]],
Cell[54023, 1442, 125, 3, 70, "ExampleDelimiter",
 CellID->477483238],
Cell[54151, 1447, 120, 3, 70, "ExampleText",
 CellID->101482510],
Cell[CellGroupData[{
Cell[54296, 1454, 449, 14, 28, "Input",
 CellID->282693146],
Cell[54748, 1470, 8509, 144, 125, "Output",
 Evaluatable->False,
 CellID->156057888]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63306, 1620, 217, 7, 70, "ExampleSection",
 CellID->20547],
Cell[CellGroupData[{
Cell[63548, 1631, 228, 7, 70, "ExampleSubsection",
 CellID->22776660],
Cell[63779, 1640, 98, 2, 70, "ExampleText",
 CellID->5555],
Cell[CellGroupData[{
Cell[63902, 1646, 268, 9, 70, "Input",
 CellID->172764079],
Cell[64173, 1657, 10562, 177, 70, "Output",
 Evaluatable->False,
 CellID->183750852]
}, Open  ]],
Cell[74750, 1837, 125, 3, 70, "ExampleDelimiter",
 CellID->100736041],
Cell[74878, 1842, 85, 1, 70, "ExampleText",
 CellID->749339086],
Cell[CellGroupData[{
Cell[74988, 1847, 226, 8, 70, "Input",
 CellID->11813271],
Cell[75217, 1857, 2196, 40, 70, "Output",
 Evaluatable->False,
 CellID->63978322]
}, Open  ]],
Cell[77428, 1900, 125, 3, 70, "ExampleDelimiter",
 CellID->119237889],
Cell[77556, 1905, 98, 1, 70, "ExampleText",
 CellID->360827733],
Cell[CellGroupData[{
Cell[77679, 1910, 235, 8, 70, "Input",
 CellID->453187265],
Cell[77917, 1920, 2010, 37, 70, "Output",
 Evaluatable->False,
 CellID->300652382]
}, Open  ]],
Cell[79942, 1960, 125, 3, 70, "ExampleDelimiter",
 CellID->252963271],
Cell[80070, 1965, 117, 3, 70, "ExampleText",
 CellID->430742835],
Cell[CellGroupData[{
Cell[80212, 1972, 249, 8, 70, "Input",
 CellID->30552953],
Cell[80464, 1982, 1136, 23, 70, "Output",
 Evaluatable->False,
 CellID->173049790]
}, Open  ]],
Cell[81615, 2008, 124, 3, 70, "ExampleDelimiter",
 CellID->35274416],
Cell[81742, 2013, 357, 13, 70, "ExampleText",
 CellID->596378793],
Cell[CellGroupData[{
Cell[82124, 2030, 653, 20, 70, "Input",
 CellID->389502305],
Cell[82780, 2052, 7999, 160, 306, "Output",
 CellID->58794875]
}, Open  ]],
Cell[90794, 2215, 125, 3, 70, "ExampleDelimiter",
 CellID->226160967],
Cell[90922, 2220, 223, 8, 70, "ExampleText",
 CellID->316263374],
Cell[CellGroupData[{
Cell[91170, 2232, 685, 23, 70, "Input",
 CellID->41344862],
Cell[91858, 2257, 3945, 69, 70, "Output",
 Evaluatable->False,
 CellID->161803326]
}, Open  ]],
Cell[95818, 2329, 125, 3, 70, "ExampleDelimiter",
 CellID->596150632],
Cell[95946, 2334, 236, 8, 70, "ExampleText",
 CellID->24664850],
Cell[CellGroupData[{
Cell[96207, 2346, 569, 19, 70, "Input",
 CellID->287230197],
Cell[96779, 2367, 5912, 101, 70, "Output",
 Evaluatable->False,
 CellID->142196574]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[102740, 2474, 231, 7, 70, "ExampleSubsection",
 CellID->5373264],
Cell[102974, 2483, 102, 2, 70, "ExampleText",
 CellID->150311282],
Cell[CellGroupData[{
Cell[103101, 2489, 574, 20, 70, "Input",
 CellID->74897845],
Cell[103678, 2511, 4596, 79, 70, "Output",
 Evaluatable->False,
 CellID->237697742]
}, Open  ]],
Cell[108289, 2593, 124, 3, 70, "ExampleDelimiter",
 CellID->90466730],
Cell[108416, 2598, 88, 1, 70, "ExampleText",
 CellID->238286887],
Cell[CellGroupData[{
Cell[108529, 2603, 718, 24, 70, "Input",
 CellID->67697223],
Cell[109250, 2629, 4535, 78, 70, "Output",
 Evaluatable->False,
 CellID->278286624]
}, Open  ]],
Cell[113800, 2710, 125, 3, 70, "ExampleDelimiter",
 CellID->103486521],
Cell[113928, 2715, 54, 1, 70, "ExampleText",
 CellID->797294755],
Cell[CellGroupData[{
Cell[114007, 2720, 414, 13, 70, "Input",
 CellID->575371355],
Cell[114424, 2735, 2579, 46, 70, "Output",
 Evaluatable->False,
 CellID->664209048]
}, Open  ]],
Cell[117018, 2784, 124, 3, 70, "ExampleDelimiter",
 CellID->64589049],
Cell[117145, 2789, 219, 8, 70, "ExampleText",
 CellID->213196035],
Cell[CellGroupData[{
Cell[117389, 2801, 418, 14, 70, "Input",
 CellID->162853632],
Cell[117810, 2817, 24370, 416, 70, "Output",
 CellID->242288447]
}, Open  ]],
Cell[142195, 3236, 124, 3, 70, "ExampleDelimiter",
 CellID->71232987],
Cell[142322, 3241, 64, 1, 70, "ExampleText",
 CellID->594811598],
Cell[CellGroupData[{
Cell[142411, 3246, 363, 12, 70, "Input",
 CellID->388733632],
Cell[142777, 3260, 4636, 80, 70, "Output",
 Evaluatable->False,
 CellID->14013362]
}, Open  ]],
Cell[147428, 3343, 125, 3, 70, "ExampleDelimiter",
 CellID->122198397],
Cell[147556, 3348, 66, 1, 70, "ExampleText",
 CellID->130631304],
Cell[CellGroupData[{
Cell[147647, 3353, 279, 9, 70, "Input",
 CellID->766762485],
Cell[147929, 3364, 2843, 51, 70, "Output",
 Evaluatable->False,
 CellID->81904647]
}, Open  ]],
Cell[150787, 3418, 125, 3, 70, "ExampleDelimiter",
 CellID->266062213],
Cell[150915, 3423, 88, 1, 70, "ExampleText",
 CellID->207010765],
Cell[CellGroupData[{
Cell[151028, 3428, 398, 12, 70, "Input",
 CellID->643226829],
Cell[151429, 3442, 2254, 41, 70, "Output",
 Evaluatable->False,
 CellID->729351141]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[153744, 3490, 239, 7, 70, "ExampleSection",
 CellID->28841],
Cell[153986, 3499, 79, 1, 70, "ExampleText",
 CellID->523612379],
Cell[CellGroupData[{
Cell[154090, 3504, 547, 17, 70, "Input",
 CellID->1965258634],
Cell[154640, 3523, 4409, 76, 70, "Output",
 Evaluatable->False,
 CellID->631660686]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[159098, 3605, 223, 7, 70, "ExampleSection",
 CellID->616814996],
Cell[CellGroupData[{
Cell[159346, 3616, 232, 7, 70, "ExampleSubsection",
 CellID->624645531],
Cell[159581, 3625, 115, 3, 70, "ExampleText",
 CellID->120205381],
Cell[CellGroupData[{
Cell[159721, 3632, 596, 20, 70, "Input",
 CellID->417624274],
Cell[160320, 3654, 3847, 67, 70, "Output",
 Evaluatable->False,
 CellID->520622674]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[164216, 3727, 221, 7, 70, "ExampleSubsection",
 CellID->20803],
Cell[164440, 3736, 56, 1, 70, "ExampleText",
 CellID->119855387],
Cell[CellGroupData[{
Cell[164521, 3741, 262, 8, 70, "Input",
 CellID->175497594],
Cell[164786, 3751, 1927, 36, 70, "Output",
 Evaluatable->False,
 CellID->9225530]
}, Open  ]],
Cell[166728, 3790, 124, 3, 70, "ExampleDelimiter",
 CellID->14406024],
Cell[166855, 3795, 287, 12, 70, "ExampleText",
 CellID->189914434],
Cell[CellGroupData[{
Cell[167167, 3811, 316, 10, 70, "Input",
 CellID->101784242],
Cell[167486, 3823, 2287, 42, 70, "Output",
 Evaluatable->False,
 CellID->398363028]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[169822, 3871, 225, 7, 70, "ExampleSubsection",
 CellID->6006],
Cell[170050, 3880, 217, 8, 70, "ExampleText",
 CellID->63765685],
Cell[CellGroupData[{
Cell[170292, 3892, 271, 8, 70, "Input",
 CellID->301560927],
Cell[170566, 3902, 2282, 41, 70, "Output",
 Evaluatable->False,
 CellID->140234398]
}, Open  ]],
Cell[172863, 3946, 125, 3, 70, "ExampleDelimiter",
 CellID->514677278],
Cell[172991, 3951, 73, 1, 70, "ExampleText",
 CellID->430834034],
Cell[CellGroupData[{
Cell[173089, 3956, 349, 11, 70, "Input",
 CellID->405251636],
Cell[173441, 3969, 2429, 44, 70, "Output",
 Evaluatable->False,
 CellID->584073196]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[175919, 4019, 227, 7, 70, "ExampleSubsection",
 CellID->22620],
Cell[176149, 4028, 87, 1, 70, "ExampleText",
 CellID->59461538],
Cell[CellGroupData[{
Cell[176261, 4033, 362, 12, 70, "Input",
 CellID->684374975],
Cell[176626, 4047, 2387, 43, 70, "Output",
 Evaluatable->False,
 CellID->42810425]
}, Open  ]],
Cell[179028, 4093, 125, 3, 70, "ExampleDelimiter",
 CellID->113516430],
Cell[179156, 4098, 213, 8, 70, "ExampleText",
 CellID->80022854],
Cell[CellGroupData[{
Cell[179394, 4110, 405, 14, 70, "Input",
 CellID->218910921],
Cell[179802, 4126, 2256, 41, 70, "Output",
 Evaluatable->False,
 CellID->2192680]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[182107, 4173, 226, 7, 70, "ExampleSubsection",
 CellID->32670],
Cell[182336, 4182, 74, 1, 70, "ExampleText",
 CellID->393797997],
Cell[CellGroupData[{
Cell[182435, 4187, 412, 13, 70, "Input",
 CellID->106363442],
Cell[182850, 4202, 2424, 44, 70, "Output",
 Evaluatable->False,
 CellID->88680977]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[185323, 4252, 237, 7, 70, "ExampleSubsection",
 CellID->783172295],
Cell[185563, 4261, 165, 6, 70, "ExampleText",
 CellID->240808472],
Cell[CellGroupData[{
Cell[185753, 4271, 833, 27, 70, "Input",
 CellID->22380555],
Cell[186589, 4300, 7451, 126, 70, "Output",
 Evaluatable->False,
 CellID->897474956]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[194089, 4432, 282, 8, 70, "ExampleSubsection",
 CellID->252139847],
Cell[194374, 4442, 76, 1, 70, "ExampleText",
 CellID->779958163],
Cell[CellGroupData[{
Cell[194475, 4447, 341, 11, 70, "Input",
 CellID->525026018],
Cell[194819, 4460, 2604, 47, 70, "Output",
 Evaluatable->False,
 CellID->563726368]
}, Open  ]],
Cell[197438, 4510, 124, 3, 70, "ExampleDelimiter",
 CellID->13073618],
Cell[197565, 4515, 79, 1, 70, "ExampleText",
 CellID->516664253],
Cell[CellGroupData[{
Cell[197669, 4520, 341, 11, 70, "Input",
 CellID->2143421572],
Cell[198013, 4533, 2665, 48, 70, "Output",
 Evaluatable->False,
 CellID->412506405]
}, Open  ]],
Cell[200693, 4584, 125, 3, 70, "ExampleDelimiter",
 CellID->294710028],
Cell[200821, 4589, 115, 3, 70, "ExampleText",
 CellID->1299715350],
Cell[CellGroupData[{
Cell[200961, 4596, 396, 13, 70, "Input",
 CellID->1372732424],
Cell[201360, 4611, 2681, 48, 70, "Output",
 Evaluatable->False,
 CellID->388962683]
}, Open  ]],
Cell[204056, 4662, 124, 3, 70, "ExampleDelimiter",
 CellID->28339071],
Cell[204183, 4667, 81, 1, 70, "ExampleText",
 CellID->112230166],
Cell[CellGroupData[{
Cell[204289, 4672, 409, 13, 70, "Input",
 CellID->1643613234],
Cell[204701, 4687, 2688, 48, 70, "Output",
 Evaluatable->False,
 CellID->30806770]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[207438, 4741, 230, 7, 70, "ExampleSubsection",
 CellID->19205],
Cell[207671, 4750, 258, 9, 70, "ExampleText",
 CellID->4524],
Cell[CellGroupData[{
Cell[207954, 4763, 845, 27, 70, "Input",
 CellID->25078],
Cell[208802, 4792, 3275, 58, 70, "Output",
 Evaluatable->False,
 CellID->509467862]
}, Open  ]],
Cell[212092, 4853, 125, 3, 70, "ExampleDelimiter",
 CellID->460288641],
Cell[212220, 4858, 76, 1, 70, "ExampleText",
 CellID->1901637531],
Cell[CellGroupData[{
Cell[212321, 4863, 288, 9, 70, "Input",
 CellID->835092793],
Cell[212612, 4874, 1847, 34, 70, "Output",
 Evaluatable->False,
 CellID->109290114]
}, Open  ]],
Cell[214474, 4911, 121, 3, 70, "ExampleDelimiter",
 CellID->19973],
Cell[214598, 4916, 182, 6, 70, "ExampleText",
 CellID->22638],
Cell[CellGroupData[{
Cell[214805, 4926, 595, 18, 70, "Input",
 CellID->3815],
Cell[215403, 4946, 1501, 29, 70, "Output",
 Evaluatable->False,
 CellID->59935184]
}, Open  ]],
Cell[216919, 4978, 121, 3, 70, "ExampleDelimiter",
 CellID->24041],
Cell[217043, 4983, 78, 1, 70, "ExampleText",
 CellID->24485],
Cell[CellGroupData[{
Cell[217146, 4988, 474, 15, 70, "Input",
 CellID->15063],
Cell[217623, 5005, 3018, 54, 70, "Output",
 Evaluatable->False,
 CellID->76746844]
}, Open  ]],
Cell[220656, 5062, 125, 3, 70, "ExampleDelimiter",
 CellID->293157448],
Cell[220784, 5067, 363, 12, 70, "ExampleText",
 CellID->147068490],
Cell[CellGroupData[{
Cell[221172, 5083, 402, 11, 70, "Input",
 CellID->26433733],
Cell[221577, 5096, 2067, 38, 70, "Output",
 Evaluatable->False,
 CellID->308320653]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[223693, 5140, 241, 7, 70, "ExampleSubsection",
 CellID->132966000],
Cell[223937, 5149, 115, 3, 70, "ExampleText",
 CellID->233969651],
Cell[CellGroupData[{
Cell[224077, 5156, 779, 23, 70, "Input",
 CellID->38928736],
Cell[224859, 5181, 4327, 75, 70, "Output",
 Evaluatable->False,
 CellID->10085188]
}, Open  ]],
Cell[229201, 5259, 124, 3, 70, "ExampleDelimiter",
 CellID->20307753],
Cell[229328, 5264, 182, 6, 70, "ExampleText",
 CellID->18827],
Cell[CellGroupData[{
Cell[229535, 5274, 595, 18, 70, "Input",
 CellID->9583],
Cell[230133, 5294, 1502, 29, 70, "Output",
 Evaluatable->False,
 CellID->227389771]
}, Open  ]],
Cell[231650, 5326, 124, 3, 70, "ExampleDelimiter",
 CellID->46892398],
Cell[231777, 5331, 196, 6, 70, "ExampleText",
 CellID->2016335543],
Cell[CellGroupData[{
Cell[231998, 5341, 702, 21, 70, "Input",
 CellID->190566020],
Cell[232703, 5364, 3241, 57, 70, "Output",
 Evaluatable->False,
 CellID->15714235]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[235993, 5427, 223, 7, 70, "ExampleSubsection",
 CellID->11812],
Cell[236219, 5436, 103, 2, 70, "ExampleText",
 CellID->148959388],
Cell[CellGroupData[{
Cell[236347, 5442, 701, 23, 70, "Input",
 CellID->3010693],
Cell[237051, 5467, 2700, 48, 70, "Output",
 Evaluatable->False,
 CellID->75993089]
}, Open  ]],
Cell[239766, 5518, 125, 3, 70, "ExampleDelimiter",
 CellID->257764008],
Cell[239894, 5523, 132, 4, 70, "ExampleText",
 CellID->507292931],
Cell[CellGroupData[{
Cell[240051, 5531, 1128, 36, 70, "Input",
 CellID->141183270],
Cell[241182, 5569, 1278, 25, 70, "Output",
 Evaluatable->False,
 CellID->168116867]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[242509, 5600, 233, 7, 70, "ExampleSubsection",
 CellID->5705],
Cell[242745, 5609, 206, 8, 70, "ExampleText",
 CellID->28145],
Cell[CellGroupData[{
Cell[242976, 5621, 406, 13, 70, "Input",
 CellID->23281],
Cell[243385, 5636, 429, 14, 39, "Output",
 CellID->421515655]
}, Open  ]],
Cell[243829, 5653, 125, 3, 70, "ExampleDelimiter",
 CellID->556023555],
Cell[243957, 5658, 357, 15, 70, "ExampleText",
 CellID->5447],
Cell[244317, 5675, 680, 21, 70, "Input",
 CellID->18716],
Cell[CellGroupData[{
Cell[245022, 5700, 165, 5, 70, "Input",
 CellID->19718],
Cell[245190, 5707, 3588, 63, 70, "Output",
 Evaluatable->False,
 CellID->749288408]
}, Open  ]],
Cell[248793, 5773, 125, 3, 70, "ExampleDelimiter",
 CellID->608954883],
Cell[248921, 5778, 91, 1, 70, "ExampleText",
 CellID->1722059395],
Cell[CellGroupData[{
Cell[249037, 5783, 471, 15, 70, "Input",
 CellID->1723218239],
Cell[249511, 5800, 161, 5, 36, "Output",
 CellID->1015141146]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[249721, 5811, 231, 7, 70, "ExampleSubsection",
 CellID->451634687],
Cell[249955, 5820, 139, 4, 70, "ExampleText",
 CellID->679453048],
Cell[CellGroupData[{
Cell[250119, 5828, 239, 8, 70, "Input",
 CellID->62905889],
Cell[250361, 5838, 1599, 30, 70, "Output",
 Evaluatable->False,
 CellID->488901421]
}, Open  ]],
Cell[251975, 5871, 123, 3, 70, "ExampleDelimiter",
 CellID->2760467],
Cell[252101, 5876, 115, 3, 70, "ExampleText",
 CellID->65528635],
Cell[CellGroupData[{
Cell[252241, 5883, 398, 14, 70, "Input",
 CellID->121800348],
Cell[252642, 5899, 1387, 27, 70, "Output",
 Evaluatable->False,
 CellID->30417837]
}, Open  ]],
Cell[254044, 5929, 125, 3, 70, "ExampleDelimiter",
 CellID->635260353],
Cell[254172, 5934, 91, 1, 70, "ExampleText",
 CellID->746689756],
Cell[CellGroupData[{
Cell[254288, 5939, 449, 15, 70, "Input",
 CellID->84608084],
Cell[254740, 5956, 1461, 28, 70, "Output",
 Evaluatable->False,
 CellID->501963969]
}, Open  ]],
Cell[256216, 5987, 125, 3, 70, "ExampleDelimiter",
 CellID->106415380],
Cell[256344, 5992, 74, 1, 70, "ExampleText",
 CellID->1156017922],
Cell[CellGroupData[{
Cell[256443, 5997, 413, 14, 70, "Input",
 CellID->908660645],
Cell[256859, 6013, 2559, 46, 70, "Output",
 Evaluatable->False,
 CellID->322452244]
}, Open  ]],
Cell[259433, 6062, 125, 3, 70, "ExampleDelimiter",
 CellID->834144820],
Cell[259561, 6067, 84, 1, 70, "ExampleText",
 CellID->315146631],
Cell[CellGroupData[{
Cell[259670, 6072, 484, 17, 70, "Input",
 CellID->544255647],
Cell[260157, 6091, 2355, 43, 70, "Output",
 Evaluatable->False,
 CellID->22677019]
}, Open  ]],
Cell[262527, 6137, 125, 3, 70, "ExampleDelimiter",
 CellID->107438009],
Cell[262655, 6142, 78, 1, 70, "ExampleText",
 CellID->103987792],
Cell[CellGroupData[{
Cell[262758, 6147, 824, 29, 70, "Input",
 CellID->490460486],
Cell[263585, 6178, 3221, 57, 70, "Output",
 Evaluatable->False,
 CellID->89445095]
}, Open  ]],
Cell[266821, 6238, 122, 3, 70, "ExampleDelimiter",
 CellID->822333],
Cell[266946, 6243, 100, 1, 70, "ExampleText",
 CellID->1249951496],
Cell[CellGroupData[{
Cell[267071, 6248, 449, 15, 70, "Input",
 CellID->1249758318],
Cell[267523, 6265, 1473, 28, 70, "Output",
 Evaluatable->False,
 CellID->289765107]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[269045, 6299, 236, 7, 70, "ExampleSubsection",
 CellID->490706925],
Cell[269284, 6308, 95, 1, 70, "ExampleText",
 CellID->51594208],
Cell[CellGroupData[{
Cell[269404, 6313, 447, 13, 70, "Input",
 CellID->5317268],
Cell[269854, 6328, 3282, 58, 70, "Output",
 Evaluatable->False,
 CellID->66929028]
}, Open  ]],
Cell[273151, 6389, 125, 3, 70, "ExampleDelimiter",
 CellID->187374077],
Cell[273279, 6394, 88, 1, 70, "ExampleText",
 CellID->167362351],
Cell[CellGroupData[{
Cell[273392, 6399, 327, 10, 70, "Input",
 CellID->190507458],
Cell[273722, 6411, 952, 20, 70, "Output",
 Evaluatable->False,
 CellID->17943858]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[274723, 6437, 228, 7, 70, "ExampleSubsection",
 CellID->144029047],
Cell[274954, 6446, 71, 1, 70, "ExampleText",
 CellID->15802],
Cell[CellGroupData[{
Cell[275050, 6451, 487, 16, 70, "Input",
 CellID->32581745],
Cell[275540, 6469, 6922, 118, 70, "Output",
 Evaluatable->False,
 CellID->92868734]
}, Open  ]],
Cell[282477, 6590, 125, 3, 70, "ExampleDelimiter",
 CellID->491200879],
Cell[282605, 6595, 95, 1, 70, "ExampleText",
 CellID->410116164],
Cell[CellGroupData[{
Cell[282725, 6600, 356, 12, 70, "Input",
 CellID->70],
Cell[283084, 6614, 4637, 80, 70, "Output",
 Evaluatable->False,
 CellID->424548474]
}, Open  ]],
Cell[287736, 6697, 124, 3, 70, "ExampleDelimiter",
 CellID->24215983],
Cell[287863, 6702, 162, 6, 70, "ExampleText",
 CellID->200504289],
Cell[CellGroupData[{
Cell[288050, 6712, 421, 14, 70, "Input",
 CellID->26059],
Cell[288474, 6728, 4307, 75, 70, "Output",
 Evaluatable->False,
 CellID->16677774]
}, Open  ]],
Cell[292796, 6806, 124, 3, 70, "ExampleDelimiter",
 CellID->28110335],
Cell[292923, 6811, 68, 1, 70, "ExampleText",
 CellID->396638],
Cell[CellGroupData[{
Cell[293016, 6816, 445, 15, 70, "Input",
 CellID->11560],
Cell[293464, 6833, 4157, 72, 70, "Output",
 Evaluatable->False,
 CellID->160686160]
}, Open  ]],
Cell[297636, 6908, 125, 3, 70, "ExampleDelimiter",
 CellID->678051541],
Cell[297764, 6913, 89, 1, 70, "ExampleText",
 CellID->30883],
Cell[CellGroupData[{
Cell[297878, 6918, 510, 18, 70, "Input",
 CellID->15905],
Cell[298391, 6938, 4139, 72, 70, "Output",
 Evaluatable->False,
 CellID->7777492]
}, Open  ]],
Cell[302545, 7013, 125, 3, 70, "ExampleDelimiter",
 CellID->637116188],
Cell[302673, 7018, 213, 8, 70, "ExampleText",
 CellID->114357690],
Cell[CellGroupData[{
Cell[302911, 7030, 513, 18, 70, "Input",
 CellID->11831765],
Cell[303427, 7050, 4340, 75, 70, "Output",
 Evaluatable->False,
 CellID->137667645]
}, Open  ]],
Cell[307782, 7128, 125, 3, 70, "ExampleDelimiter",
 CellID->590217671],
Cell[307910, 7133, 141, 4, 70, "ExampleText",
 CellID->1241540290],
Cell[CellGroupData[{
Cell[308076, 7141, 578, 20, 70, "Input",
 CellID->1616539778],
Cell[308657, 7163, 4442, 77, 70, "Output",
 Evaluatable->False,
 CellID->308844449]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[313148, 7246, 229, 7, 70, "ExampleSubsection",
 CellID->14409],
Cell[313380, 7255, 65, 1, 70, "ExampleText",
 CellID->10234],
Cell[CellGroupData[{
Cell[313470, 7260, 542, 17, 70, "Input",
 CellID->12500],
Cell[314015, 7279, 5331, 92, 70, "Output",
 Evaluatable->False,
 CellID->224504531]
}, Open  ]],
Cell[319361, 7374, 119, 3, 70, "ExampleDelimiter",
 CellID->839],
Cell[319483, 7379, 68, 1, 70, "ExampleText",
 CellID->21157],
Cell[CellGroupData[{
Cell[319576, 7384, 521, 17, 70, "Input",
 CellID->5668],
Cell[320100, 7403, 4495, 78, 70, "Output",
 Evaluatable->False,
 CellID->847316277]
}, Open  ]],
Cell[324610, 7484, 126, 3, 70, "ExampleDelimiter",
 CellID->1711066621],
Cell[324739, 7489, 172, 6, 70, "ExampleText",
 CellID->943182170],
Cell[CellGroupData[{
Cell[324936, 7499, 392, 12, 70, "Input",
 CellID->1485932683],
Cell[325331, 7513, 2925, 52, 70, "Output",
 Evaluatable->False,
 CellID->126174302]
}, Open  ]],
Cell[328271, 7568, 120, 3, 70, "ExampleDelimiter",
 CellID->4485],
Cell[328394, 7573, 234, 8, 70, "ExampleText",
 CellID->23592],
Cell[CellGroupData[{
Cell[328653, 7585, 528, 16, 70, "Input",
 CellID->31022],
Cell[329184, 7603, 3019, 54, 70, "Output",
 Evaluatable->False,
 CellID->599814477]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[332252, 7663, 229, 7, 70, "ExampleSubsection",
 CellID->10906],
Cell[332484, 7672, 64, 1, 70, "ExampleText",
 CellID->6885],
Cell[CellGroupData[{
Cell[332573, 7677, 280, 9, 70, "Input",
 CellID->17245],
Cell[332856, 7688, 9834, 165, 70, "Output",
 Evaluatable->False,
 CellID->277195709]
}, Open  ]],
Cell[342705, 7856, 126, 3, 70, "ExampleDelimiter",
 CellID->1551013183],
Cell[342834, 7861, 254, 8, 70, "ExampleText",
 CellID->95077555],
Cell[CellGroupData[{
Cell[343113, 7873, 571, 17, 70, "Input",
 CellID->191953008],
Cell[343687, 7892, 22106, 367, 70, "Output",
 Evaluatable->False,
 CellID->510634398]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[365842, 8265, 225, 7, 70, "ExampleSubsection",
 CellID->175033095],
Cell[366070, 8274, 81, 1, 70, "ExampleText",
 CellID->9407],
Cell[CellGroupData[{
Cell[366176, 8279, 587, 19, 70, "Input",
 CellID->30195],
Cell[366766, 8300, 5154, 89, 70, "Output",
 Evaluatable->False,
 CellID->151999103]
}, Open  ]],
Cell[371935, 8392, 125, 3, 70, "ExampleDelimiter",
 CellID->908508703],
Cell[372063, 8397, 167, 6, 70, "ExampleText",
 CellID->11427],
Cell[CellGroupData[{
Cell[372255, 8407, 270, 9, 70, "Input",
 CellID->29355],
Cell[372528, 8418, 2842, 51, 70, "Output",
 Evaluatable->False,
 CellID->4129439]
}, Open  ]],
Cell[375385, 8472, 125, 3, 70, "ExampleDelimiter",
 CellID->314682034],
Cell[375513, 8477, 189, 6, 70, "ExampleText",
 CellID->238138513],
Cell[CellGroupData[{
Cell[375727, 8487, 518, 16, 70, "Input",
 CellID->50003947],
Cell[376248, 8505, 2721, 49, 70, "Output",
 Evaluatable->False,
 CellID->84145504]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[379018, 8560, 230, 7, 70, "ExampleSubsection",
 CellID->15452],
Cell[379251, 8569, 245, 9, 70, "ExampleText",
 CellID->236651916],
Cell[CellGroupData[{
Cell[379521, 8582, 795, 26, 70, "Input",
 CellID->237800640],
Cell[380319, 8610, 4023, 70, 70, "Output",
 Evaluatable->False,
 CellID->557761568]
}, Open  ]],
Cell[384357, 8683, 125, 3, 70, "ExampleDelimiter",
 CellID->450987812],
Cell[384485, 8688, 276, 9, 70, "ExampleText",
 CellID->1980240883],
Cell[CellGroupData[{
Cell[384786, 8701, 710, 23, 70, "Input",
 CellID->206959375],
Cell[385499, 8726, 2502, 45, 70, "Output",
 Evaluatable->False,
 CellID->112561528]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[388050, 8777, 232, 7, 70, "ExampleSubsection",
 CellID->374839548],
Cell[388285, 8786, 193, 6, 70, "ExampleText",
 CellID->1563263586],
Cell[CellGroupData[{
Cell[388503, 8796, 485, 15, 70, "Input",
 CellID->1456152504],
Cell[388991, 8813, 2762, 49, 70, "Output",
 Evaluatable->False,
 CellID->130272987]
}, Open  ]],
Cell[391768, 8865, 125, 3, 70, "ExampleDelimiter",
 CellID->913462102],
Cell[391896, 8870, 199, 8, 70, "ExampleText",
 CellID->1504189831],
Cell[CellGroupData[{
Cell[392120, 8882, 484, 15, 70, "Input",
 CellID->740997133],
Cell[392607, 8899, 2112, 39, 70, "Output",
 Evaluatable->False,
 CellID->212470746]
}, Open  ]],
Cell[394734, 8941, 125, 3, 70, "ExampleDelimiter",
 CellID->113916258],
Cell[394862, 8946, 328, 12, 70, "ExampleText",
 CellID->101485524],
Cell[CellGroupData[{
Cell[395215, 8962, 536, 16, 70, "Input",
 CellID->914958790],
Cell[395754, 8980, 3246, 57, 70, "Output",
 Evaluatable->False,
 CellID->120113869]
}, Open  ]],
Cell[399015, 9040, 125, 3, 70, "ExampleDelimiter",
 CellID->424843825],
Cell[399143, 9045, 358, 12, 70, "ExampleText",
 CellID->649526388],
Cell[CellGroupData[{
Cell[399526, 9061, 536, 16, 70, "Input",
 CellID->122170518],
Cell[400065, 9079, 2738, 49, 70, "Output",
 Evaluatable->False,
 CellID->294039201]
}, Open  ]],
Cell[402818, 9131, 124, 3, 70, "ExampleDelimiter",
 CellID->78638807],
Cell[402945, 9136, 478, 18, 70, "ExampleText",
 CellID->68474456],
Cell[CellGroupData[{
Cell[403448, 9158, 590, 17, 70, "Input",
 CellID->1946430847],
Cell[404041, 9177, 3742, 65, 70, "Output",
 Evaluatable->False,
 CellID->109714226]
}, Open  ]],
Cell[407798, 9245, 124, 3, 70, "ExampleDelimiter",
 CellID->13901850],
Cell[407925, 9250, 337, 12, 70, "ExampleText",
 CellID->1974674987],
Cell[CellGroupData[{
Cell[408287, 9266, 754, 22, 70, "Input",
 CellID->1920453998],
Cell[409044, 9290, 2220, 40, 70, "Output",
 Evaluatable->False,
 CellID->26375364]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[411313, 9336, 230, 7, 70, "ExampleSubsection",
 CellID->117797214],
Cell[411546, 9345, 85, 1, 70, "ExampleText",
 CellID->124974016],
Cell[CellGroupData[{
Cell[411656, 9350, 335, 10, 70, "Input",
 CellID->199280146],
Cell[411994, 9362, 2689, 48, 70, "Output",
 Evaluatable->False,
 CellID->107038219]
}, Open  ]],
Cell[414698, 9413, 125, 3, 70, "ExampleDelimiter",
 CellID->751885160],
Cell[414826, 9418, 160, 6, 70, "ExampleText",
 CellID->542506413],
Cell[CellGroupData[{
Cell[415011, 9428, 330, 10, 70, "Input",
 CellID->1343653111],
Cell[415344, 9440, 2722, 49, 70, "Output",
 Evaluatable->False,
 CellID->497181625]
}, Open  ]],
Cell[418081, 9492, 125, 3, 70, "ExampleDelimiter",
 CellID->643903660],
Cell[418209, 9497, 264, 9, 70, "ExampleText",
 CellID->1837201776],
Cell[CellGroupData[{
Cell[418498, 9510, 533, 17, 70, "Input",
 CellID->1330372666],
Cell[419034, 9529, 3059, 54, 70, "Output",
 Evaluatable->False,
 CellID->881362539]
}, Open  ]],
Cell[422108, 9586, 125, 3, 70, "ExampleDelimiter",
 CellID->420838548],
Cell[422236, 9591, 170, 6, 70, "ExampleText",
 CellID->2133487437],
Cell[CellGroupData[{
Cell[422431, 9601, 441, 14, 70, "Input",
 CellID->2002303716],
Cell[422875, 9617, 2799, 50, 70, "Output",
 Evaluatable->False,
 CellID->435323073]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[425723, 9673, 236, 7, 70, "ExampleSubsection",
 CellID->786377051],
Cell[425962, 9682, 75, 1, 70, "ExampleText",
 CellID->1024732519],
Cell[CellGroupData[{
Cell[426062, 9687, 348, 11, 70, "Input",
 CellID->808944785],
Cell[426413, 9700, 3608, 63, 70, "Output",
 Evaluatable->False,
 CellID->351973828]
}, Open  ]],
Cell[430036, 9766, 125, 3, 70, "ExampleDelimiter",
 CellID->410197437],
Cell[430164, 9771, 99, 1, 70, "ExampleText",
 CellID->2008081540],
Cell[CellGroupData[{
Cell[430288, 9776, 347, 11, 70, "Input",
 CellID->2120930175],
Cell[430638, 9789, 3542, 67, 128, "Output",
 CellID->5015838]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[434229, 9862, 231, 7, 70, "ExampleSubsection",
 CellID->241659577],
Cell[434463, 9871, 92, 1, 70, "ExampleText",
 CellID->1529333113],
Cell[CellGroupData[{
Cell[434580, 9876, 533, 17, 70, "Input",
 CellID->269859248],
Cell[435116, 9895, 4277, 74, 70, "Output",
 Evaluatable->False,
 CellID->229747706]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[439442, 9975, 230, 7, 70, "ExampleSubsection",
 CellID->195009142],
Cell[439675, 9984, 80, 1, 70, "ExampleText",
 CellID->893230115],
Cell[CellGroupData[{
Cell[439780, 9989, 286, 9, 70, "Input",
 CellID->784240289],
Cell[440069, 10000, 2042, 38, 70, "Output",
 Evaluatable->False,
 CellID->87848843]
}, Open  ]],
Cell[442126, 10041, 125, 3, 70, "ExampleDelimiter",
 CellID->190153465],
Cell[442254, 10046, 88, 1, 70, "ExampleText",
 CellID->1607850275],
Cell[CellGroupData[{
Cell[442367, 10051, 290, 9, 70, "Input",
 CellID->69469756],
Cell[442660, 10062, 2143, 39, 70, "Output",
 Evaluatable->False,
 CellID->90546529]
}, Open  ]],
Cell[444818, 10104, 124, 3, 70, "ExampleDelimiter",
 CellID->40633603],
Cell[444945, 10109, 312, 12, 70, "ExampleText",
 CellID->1213642703],
Cell[CellGroupData[{
Cell[445282, 10125, 282, 9, 70, "Input",
 CellID->20474098],
Cell[445567, 10136, 1555, 30, 70, "Output",
 Evaluatable->False,
 CellID->334978332]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[447171, 10172, 237, 7, 70, "ExampleSubsection",
 CellID->45643252],
Cell[447411, 10181, 85, 1, 70, "ExampleText",
 CellID->1306291737],
Cell[CellGroupData[{
Cell[447521, 10186, 274, 9, 70, "Input",
 CellID->252825347],
Cell[447798, 10197, 2273, 41, 70, "Output",
 Evaluatable->False,
 CellID->52194818]
}, Open  ]],
Cell[450086, 10241, 125, 3, 70, "ExampleDelimiter",
 CellID->132484217],
Cell[450214, 10246, 92, 1, 70, "ExampleText",
 CellID->1119900478],
Cell[CellGroupData[{
Cell[450331, 10251, 334, 10, 70, "Input",
 CellID->563149880],
Cell[450668, 10263, 2412, 44, 70, "Output",
 Evaluatable->False,
 CellID->77736094]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[453129, 10313, 230, 7, 70, "ExampleSubsection",
 CellID->362103647],
Cell[453362, 10322, 74, 1, 70, "ExampleText",
 CellID->193335196],
Cell[CellGroupData[{
Cell[453461, 10327, 564, 18, 70, "Input",
 CellID->42985262],
Cell[454028, 10347, 5134, 88, 70, "Output",
 Evaluatable->False,
 CellID->32017507]
}, Open  ]],
Cell[459177, 10438, 126, 3, 70, "ExampleDelimiter",
 CellID->1845615257],
Cell[459306, 10443, 104, 2, 70, "ExampleText",
 CellID->702451365],
Cell[CellGroupData[{
Cell[459435, 10449, 406, 14, 70, "Input",
 CellID->210197233],
Cell[459844, 10465, 7613, 129, 70, "Output",
 Evaluatable->False,
 CellID->16174060]
}, Open  ]],
Cell[467472, 10597, 124, 3, 70, "ExampleDelimiter",
 CellID->28469554],
Cell[467599, 10602, 89, 1, 70, "ExampleText",
 CellID->24232],
Cell[CellGroupData[{
Cell[467713, 10607, 514, 17, 70, "Input",
 CellID->5765],
Cell[468230, 10626, 7345, 124, 70, "Output",
 Evaluatable->False,
 CellID->152747427]
}, Open  ]],
Cell[475590, 10753, 123, 3, 70, "ExampleDelimiter",
 CellID->8248407],
Cell[475716, 10758, 336, 12, 70, "ExampleText",
 CellID->185208180],
Cell[CellGroupData[{
Cell[476077, 10774, 492, 15, 70, "Input",
 CellID->1043126087],
Cell[476572, 10791, 2360, 43, 70, "Output",
 Evaluatable->False,
 CellID->220192733]
}, Open  ]],
Cell[478947, 10837, 125, 3, 70, "ExampleDelimiter",
 CellID->170913875],
Cell[479075, 10842, 331, 12, 70, "ExampleText",
 CellID->43022358],
Cell[CellGroupData[{
Cell[479431, 10858, 640, 19, 70, "Input",
 CellID->891938947],
Cell[480074, 10879, 3338, 59, 70, "Output",
 Evaluatable->False,
 CellID->8519089]
}, Open  ]],
Cell[483427, 10941, 125, 3, 70, "ExampleDelimiter",
 CellID->534064321],
Cell[483555, 10946, 341, 12, 70, "ExampleText",
 CellID->214639584],
Cell[CellGroupData[{
Cell[483921, 10962, 331, 10, 70, "Input",
 CellID->1575199054],
Cell[484255, 10974, 2819, 50, 70, "Output",
 Evaluatable->False,
 CellID->223752839]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[487123, 11030, 235, 7, 70, "ExampleSubsection",
 CellID->624241578],
Cell[487361, 11039, 387, 14, 70, "ExampleText",
 CellID->1386283524],
Cell[CellGroupData[{
Cell[487773, 11057, 616, 20, 70, "Input",
 CellID->1217101565],
Cell[488392, 11079, 2425, 44, 70, "Output",
 Evaluatable->False,
 CellID->344000670]
}, Open  ]],
Cell[490832, 11126, 125, 3, 70, "ExampleDelimiter",
 CellID->330014972],
Cell[490960, 11131, 254, 10, 70, "ExampleText",
 CellID->953404243],
Cell[CellGroupData[{
Cell[491239, 11145, 472, 16, 70, "Input",
 CellID->41823188],
Cell[491714, 11163, 2701, 48, 70, "Output",
 Evaluatable->False,
 CellID->314939407]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[494464, 11217, 236, 7, 70, "ExampleSubsection",
 CellID->14211021],
Cell[494703, 11226, 97, 1, 70, "ExampleText",
 CellID->309974128],
Cell[CellGroupData[{
Cell[494825, 11231, 361, 12, 70, "Input",
 CellID->869598241],
Cell[495189, 11245, 904, 19, 70, "Output",
 Evaluatable->False,
 CellID->261091442]
}, Open  ]],
Cell[496108, 11267, 124, 3, 70, "ExampleDelimiter",
 CellID->47084891],
Cell[496235, 11272, 99, 1, 70, "ExampleText",
 CellID->152555420],
Cell[CellGroupData[{
Cell[496359, 11277, 345, 11, 70, "Input",
 CellID->1711418652],
Cell[496707, 11290, 2510, 45, 70, "Output",
 Evaluatable->False,
 CellID->415218748]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[499278, 11342, 223, 7, 70, "ExampleSection",
 CellID->12344],
Cell[499504, 11351, 211, 8, 70, "ExampleText",
 CellID->429557237],
Cell[CellGroupData[{
Cell[499740, 11363, 559, 16, 70, "Input",
 CellID->263579494],
Cell[500302, 11381, 4312, 75, 70, "Output",
 Evaluatable->False,
 CellID->188539566]
}, Open  ]],
Cell[504629, 11459, 125, 3, 70, "ExampleDelimiter",
 CellID->216061825],
Cell[504757, 11464, 671, 25, 70, "ExampleText",
 CellID->395866629],
Cell[CellGroupData[{
Cell[505453, 11493, 764, 24, 70, "Input",
 CellID->218172574],
Cell[506220, 11519, 4901, 84, 70, "Output",
 Evaluatable->False,
 CellID->322335587]
}, Open  ]],
Cell[511136, 11606, 125, 3, 70, "ExampleDelimiter",
 CellID->659438975],
Cell[511264, 11611, 91, 1, 70, "ExampleText",
 CellID->373092530],
Cell[CellGroupData[{
Cell[511380, 11616, 337, 12, 70, "Input",
 CellID->192897750],
Cell[511720, 11630, 921, 32, 43, "Output",
 CellID->802382408]
}, Open  ]],
Cell[512656, 11665, 74, 1, 70, "ExampleText",
 CellID->159360491],
Cell[CellGroupData[{
Cell[512755, 11670, 402, 13, 70, "Input",
 CellID->12335598],
Cell[513160, 11685, 2818, 50, 70, "Output",
 Evaluatable->False,
 CellID->90097779]
}, Open  ]],
Cell[515993, 11738, 71, 1, 70, "ExampleText",
 CellID->523850018],
Cell[CellGroupData[{
Cell[516089, 11743, 457, 15, 70, "Input",
 CellID->710590572],
Cell[516549, 11760, 9859, 166, 70, "Output",
 Evaluatable->False,
 CellID->378990259]
}, Open  ]],
Cell[526423, 11929, 125, 3, 70, "ExampleDelimiter",
 CellID->196661769],
Cell[526551, 11934, 89, 1, 70, "ExampleText",
 CellID->16246599],
Cell[CellGroupData[{
Cell[526665, 11939, 320, 11, 70, "Input",
 CellID->111429370],
Cell[526988, 11952, 654, 21, 39, "Output",
 CellID->64897000]
}, Open  ]],
Cell[527657, 11976, 70, 1, 70, "ExampleText",
 CellID->28414461],
Cell[CellGroupData[{
Cell[527752, 11981, 786, 25, 70, "Input",
 CellID->342191019],
Cell[528541, 12008, 20961, 348, 70, "Output",
 Evaluatable->False,
 CellID->398232573]
}, Open  ]],
Cell[549517, 12359, 125, 3, 70, "ExampleDelimiter",
 CellID->193726743],
Cell[549645, 12364, 102, 2, 70, "ExampleText",
 CellID->467503847],
Cell[CellGroupData[{
Cell[549772, 12370, 661, 23, 70, "Input",
 CellID->184333108],
Cell[550436, 12395, 9243, 156, 70, "Output",
 Evaluatable->False,
 CellID->72602956]
}, Open  ]],
Cell[559694, 12554, 121, 3, 70, "ExampleDelimiter",
 CellID->19445],
Cell[559818, 12559, 70, 1, 70, "ExampleText",
 CellID->27609],
Cell[CellGroupData[{
Cell[559913, 12564, 959, 30, 70, "Input",
 CellID->15414],
Cell[560875, 12596, 4014, 70, 70, "Output",
 Evaluatable->False,
 CellID->46966891]
}, Open  ]],
Cell[564904, 12669, 121, 3, 70, "ExampleDelimiter",
 CellID->11630],
Cell[565028, 12674, 132, 4, 70, "ExampleText",
 CellID->25318],
Cell[CellGroupData[{
Cell[565185, 12682, 364, 13, 70, "Input",
 CellID->12432],
Cell[565552, 12697, 2635, 47, 70, "Output",
 Evaluatable->False,
 CellID->95921294]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[568236, 12750, 233, 7, 70, "ExampleSection",
 CellID->24090],
Cell[568472, 12759, 204, 7, 70, "ExampleText",
 CellID->18461],
Cell[CellGroupData[{
Cell[568701, 12770, 248, 8, 70, "Input",
 CellID->132],
Cell[568952, 12780, 3807, 66, 70, "Output",
 Evaluatable->False,
 CellID->236770333]
}, Open  ]],
Cell[572774, 12849, 125, 3, 70, "ExampleDelimiter",
 CellID->762793504],
Cell[572902, 12854, 338, 12, 70, "ExampleText",
 CellID->71264896],
Cell[CellGroupData[{
Cell[573265, 12870, 630, 20, 70, "Input",
 CellID->33614225],
Cell[573898, 12892, 6669, 114, 70, "Output",
 Evaluatable->False,
 CellID->160746590]
}, Open  ]],
Cell[580582, 13009, 125, 3, 70, "ExampleDelimiter",
 CellID->402920390],
Cell[580710, 13014, 232, 8, 70, "ExampleText",
 CellID->34695851],
Cell[CellGroupData[{
Cell[580967, 13026, 842, 26, 70, "Input",
 CellID->557810802],
Cell[581812, 13054, 20377, 338, 70, "Output",
 Evaluatable->False,
 CellID->22776320]
}, Open  ]],
Cell[602204, 13395, 125, 3, 70, "ExampleDelimiter",
 CellID->157163518],
Cell[602332, 13400, 358, 13, 70, "ExampleText",
 CellID->350119962],
Cell[CellGroupData[{
Cell[602715, 13417, 840, 28, 70, "Input",
 CellID->58342368],
Cell[603558, 13447, 26495, 452, 70, "Output",
 CellID->47287799]
}, Open  ]],
Cell[630068, 13902, 125, 3, 70, "ExampleDelimiter",
 CellID->448224811],
Cell[630196, 13907, 476, 18, 70, "ExampleText",
 CellID->46767761],
Cell[CellGroupData[{
Cell[630697, 13929, 500, 17, 70, "Input",
 CellID->24914874],
Cell[631200, 13948, 2108, 39, 70, "Output",
 Evaluatable->False,
 CellID->461039252]
}, Open  ]],
Cell[633323, 13990, 122, 3, 70, "ExampleDelimiter",
 CellID->749854],
Cell[633448, 13995, 335, 13, 70, "ExampleText",
 CellID->1112749563],
Cell[CellGroupData[{
Cell[633808, 14012, 543, 18, 70, "Input",
 CellID->789105347],
Cell[634354, 14032, 4100, 71, 70, "Output",
 Evaluatable->False,
 CellID->2489222]
}, Open  ]],
Cell[638469, 14106, 125, 3, 70, "ExampleDelimiter",
 CellID->421304857],
Cell[638597, 14111, 365, 13, 70, "ExampleText",
 CellID->693877993],
Cell[CellGroupData[{
Cell[638987, 14128, 584, 21, 70, "Input",
 CellID->24486205],
Cell[639574, 14151, 27248, 451, 70, "Output",
 Evaluatable->False,
 CellID->828032554]
}, Open  ]],
Cell[CellGroupData[{
Cell[666859, 14607, 733, 24, 70, "Input",
 CellID->704574670],
Cell[667595, 14633, 23275, 386, 70, "Output",
 Evaluatable->False,
 CellID->136956775]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[690919, 15025, 223, 7, 70, "ExampleSection",
 CellID->4970],
Cell[691145, 15034, 81, 1, 70, "ExampleText",
 CellID->1530322957],
Cell[691229, 15037, 783, 28, 70, "Input",
 CellID->243810284],
Cell[CellGroupData[{
Cell[692037, 15069, 883, 29, 70, "Input",
 CellID->320644712],
Cell[692923, 15100, 13956, 233, 70, "Output",
 Evaluatable->False,
 CellID->28225040]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[706940, 15340, 311, 9, 70, "SeeAlsoSection",
 CellID->21293],
Cell[707254, 15351, 1691, 62, 70, "SeeAlso",
 CellID->9129]
}, Open  ]],
Cell[CellGroupData[{
Cell[708982, 15418, 314, 9, 70, "TutorialsSection",
 CellID->17206],
Cell[709299, 15429, 138, 3, 70, "Tutorials",
 CellID->16911],
Cell[709440, 15434, 192, 4, 70, "Tutorials",
 CellID->150738960],
Cell[709635, 15440, 141, 3, 70, "Tutorials",
 CellID->62653972],
Cell[709779, 15445, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[709973, 15453, 305, 8, 70, "RelatedLinksSection"],
Cell[710281, 15463, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[710666, 15479, 319, 9, 70, "MoreAboutSection",
 CellID->421966252],
Cell[710988, 15490, 155, 3, 70, "MoreAbout",
 CellID->512350195],
Cell[711146, 15495, 150, 3, 70, "MoreAbout",
 CellID->82575996],
Cell[711299, 15500, 174, 3, 70, "MoreAbout",
 CellID->170492408]
}, Open  ]],
Cell[711488, 15506, 50, 0, 70, "History"],
Cell[711541, 15508, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

