(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42662,       1149]
NotebookOptionsPosition[     38247,       1002]
NotebookOutlinePosition[     39704,       1042]
CellTagsIndexPosition[     39618,       1037]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotStyle" :> Documentation`HelpLookup["paclet:ref/PlotStyle"],
           "Mesh" :> Documentation`HelpLookup["paclet:ref/Mesh"], 
          "Arrowheads" :> Documentation`HelpLookup["paclet:ref/Arrowheads"], 
          "Inset" :> Documentation`HelpLookup["paclet:ref/Inset"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PlotStyle\"\>", 2->"\<\"Mesh\"\>", 
       3->"\<\"Arrowheads\"\>", 4->"\<\"Inset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Options & Styling\"\>", 
       2->"\<\"Plotting Options\"\>", 
       3->"\<\"New in 6.0: Data Visualization\"\>", 
       4->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       5->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PlotMarkers", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PlotMarkers",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotMarkers"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions like ",
     Cell[BoxData[
      ButtonBox["ListPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["ListLinePlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
     " that specifies what markers to draw at the points plotted. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2819]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used: ", "Notes",
 CellID->8907],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no markers ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "standard sequence of markers ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      StyleBox["s", "TI"]}], "}"}], Cell[TextData[{
     "standard sequence of markers with size ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["g", "TI"], Cell[TextData[{
     "markers consisting of copies of expression ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["g", "TI"], ",", 
      StyleBox["s", "TI"]}], "}"}], Cell[TextData[{
     "expression ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " at size ",
     StyleBox["s", "TI"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], "2"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "expression ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " for dataset ",
     StyleBox["i", "TI"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], "1"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], "2"], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], "2"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "expressions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at sizes ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->29071],

Cell[TextData[{
 "For a single list of points, ",
 Cell[BoxData[
  RowBox[{"PlotMarkers", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " specifies that ordinary ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 " objects should be used to indicate each point. "
}], "Notes",
 CellID->5022],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PlotMarkers", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " uses a pre\[Hyphen]defined standard sequence of markers for successive \
lists of points. "
}], "Notes",
 CellID->20561],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"PlotMarkers", "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", a copy of the graphic or other expression ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is placed so that its alignment point lies at the position of the point it \
indicates. "
}], "Notes",
 CellID->1991],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"PlotMarkers", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["g", "TI"], ",", 
     StyleBox["s", "TI"]}], "}"}]}]], "InlineFormula"],
 ", the object ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is scaled so that one unit of its coordinates corresponds to a fraction ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " of the width of the whole graphic. "
}], "Notes",
 CellID->22052],

Cell[TextData[{
 "The symbolic values ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 " can be used for ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ". With these values the size of the markers is independent of the total \
width of the graphic. "
}], "Notes",
 CellID->5251],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"PlotMarkers", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["n", "TI"]]}], "}"}]}]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are used cyclically for successive dataset lists. "
}], "Notes",
 CellID->1523]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->172964043],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->743367436],

Cell["Use a default sequence of shapes to distinguish datasets:", \
"ExampleText",
 CellID->946519202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "6", ",", "9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "7", ",", "10", ",", "12"}], "}"}]}], "}"}],
    ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1736854685],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWDtPwzAQTvNoERI7og/KY4Rf0KYdKDDxC4ChKkgwIJ4TAiZg4g9UAiYY
kBj5f8YXnxvHudhJUyQiNc75Pt/rOzuBveHNyfHZ8OZ0NGzvXg0vTk5H1+2d
8ys+5VUcx/nhv9tFhz8z/hT9fhjjo3rf4HePqxp89PnYRHkZtPDAoivSg+hH
qzYJrZT53Wkb9PCoW6+QVpuWVUsYs+6NttYiYnIxYzX2lams6bFK68s40nWr
w82P5XQudcWOOu9N2ANtSxkp9qRerFL5X9CQH4Vn5/n9i09WSMy8RfY02S+4
/r/Zd8kq9CzyqqXqwN0niYn2ZT8cP5Fa6J6Aax9JLeyfakLr4kmQvcbsz9Y9
2XkITMDEjtZZgkiDcXjZQu9HEbqqoBzDqiZmNIpwNYJBECW6gVUR6DmKX6uP
vKuS+UD2ydNAz+hjkjdUMpiizh0lXvA8MKJkL2wZUXWs2FbCf7eQDXM8ZfuK
4jx1Wo9fwudcaMjX5+inCWuyZ2UfVbn2MeZU6VGdsyQ6i9mkxyyUPQtbnfTZ
EC32kZ01EtXF6EJkOj7NZB9Ahh3sEvqs6yCqm7JBeeoZ45FRH+fumqyK7jPR
nYOYS+P+/As8wNM4zxptVdPSZ0mNKd8nU+0tffYQq79Nag+QwUHC/gGyT58R
+0Zt2qI5Gls+Wb3wzkTPeTm5fWOik92c+Fcm9oebigJARa0Vjbb8m+WOie6j
92RRLfi5L2Gx7BsDP9jxcjPq8sBEdzUwFlFtN1Vt/f2vy5Ap9HB9CjsgQi1g
hyyVjGNWdsrkQ9V3XcC9mBP5NgtycDmb2Vl7ie2JtpKXLBK1o6EWflzL2kQr
DKAZ6iQCNhQWDDXXv3ZesSdccjX19w+IxVdZIi7UN8laUX3zHU2l/x/iVH4B
1Tw/zQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392821989]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->626914952],

Cell["Use text or typeset labels to distinguish datasets:", "ExampleText",
 CellID->673952066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "6", ",", "9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "7", ",", "10", ",", "12"}], "}"}]}], "}"}],
    ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\"", ",", "\"\<\[Gamma]\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1269153684],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWTtvFDEQdnb3CBRQU0bi7hLeDZQRHTTkkoYA5SlCSgoEhJBAQxJqaqRU
eVCQwB+BQBMq2vwS4/F4vfZ4vOt7EImVbne9/r6xPY/Pt3dz/bXlZ8/7aytL
/akHq/2XyytLr6fuv1hVj/IJIcSp+ny6LNS9VHf6cyqluobnO+qcK0BXXQt1
7Zj2DPTCjdSHfd7SrLukt+u0RYTttml/xlqdbmhfMXO+mmSNjtlWp8ys3J37
taGs0RV2jPUZc+X9pllF1Q4913bsuM8LGz13lG4ketOmvwjif5EgT2qeXlDn
P+CioL/V0D73j/H/O3/c42HONkXp0oCjNOHHbe+s8Wle7JL2QkP/DdZKXZ3B
U6jW3wMwQSeKe7M7R2wvKKWAbmyrm69xXG5xIvMsZmZ/EC1E2LM4ZK1pDYTu
3ILFl6G8MaiPcB07s69M+1vUZy4KfQJZUZRaST2swB3j6S2NdnNGRFiiZcdQ
h7pn4rGt+ZOEnTMeFYW1pm64iOHMzhMuZHNe7vBmHWEkN6Pc+nlwsX5v/env
cdRHXScO4J1D61m7c9K9TMH4nEvJjock7h9Y1BxBbUdRblY8jttKyIIn3uzn
k6LNj9irjfJilNMc1Ucsd57EcJNFLZjY8b1+7PAb1c7HWdPLK1abRSXVkcM6
GoEV0wvtOwWuVMXVCWhDU0e0hTbt2ViOVUDbWNYTRFJDzZwkrW94ve0Rz2yN
gJonKGBBkdxMQutK82rqVpQHPsQ5+RVVjQQr7rERwqe0rvi9vsfESz8jlXW9
wf/jidUb6evaUxa1TlCoTLH8AjQIB2pRs+Kvo0+JHi7WsIG8Iak+1THc8YCZ
e/PLmVXE7NPvhdT6W8dX1TompfPO5aDfSdRAXoP9CBrLNrt5rd9IQlFb/Pjp
KMjoaqSsjE9QKbyFDRnWBL+zjDv/65ix/P4hUYPw/bk5375LqkKtGiYQNYPo
UNE4p1CB8sQZHstQf7JEbr2vho/MrvQ15zaL2iMoXt8BBaXM7xraRqA/lXrD
HA8kVQNe3fclags/0n6ilQNnVf5cXNRnidrhz5T3pvGTreQO8du5JFaXsDCP
zQ9J5sgknwn7zAzAFUjW2eblGX3LoG3OXhjFfATroEjTQcQGsQjNXZwX0UH9
29wIq9+ToWKG72HDrv6nE+fKi+VFmFsuyr8k5iRCx63IZ6P74xvb+NHmaMFy
jllUWVx4lCGk6ktHcCI+aVFoyJgbwEJNhtC3BbAC+ViwbIqG/qLc54La4GfA
2Qj2MFIRWWVpoPzHKKbkOyLDf1LExF+yKFm2\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->821002160]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "6", ",", "9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "7", ",", "10", ",", "12"}], "}"}]}], "}"}],
    ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"\[HappySmiley]\",
FontSize->18]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"\[NeutralSmiley]\",
FontSize->18]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"\[SadSmiley]\",
FontSize->18]\)\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40799692],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWjtv1EAQ9is5KKCmy4UklweUUFp0IHSJhMSjP0VISYEg4egQ/IGrka4h
VRR+CY8SKtr8kmV2vbZ3x+Pd9WPvdJx0tse7883sPNe+O5pMT16/mUxPjyfD
J+eTdyenx++Hj9+ew604DILgGr5f7gRwzeBKfK8Zg3P1+ACOMUwYwTmB846k
9/gov2DiU9xfE1wP0ehIoYMabpXG4xGJumuht6TO+05oWOY2HCK5clX3g1Zo
eIU7En1Pnmm7Ca6kpKuW21Zw1PtJ4T1VyqjGe7tyPKn4/xaa+dtw9yYc/3IT
VcbXLPS65/mrzt+3vCxmbV663VCKbX7feIue72bFEaKfWcbvkyimPON3ebby
3F9/lM6/kXPvChqGJZ0g+tIjVwSXUWNOOAYRoq+0FW8tcU3NuczraServRU4
1/o8PRNnmPzZoAlM07BLesMi+6NA5ZmT5P2kd3Q1DwOLFDiKyyDOCD40RKhU
tGaSBgg57rAeKho+CSk3ECqfxcl+rEWh+/G4vlPx5/tiv2TweYToTSdP+MkG
PW/7QKvNayW/X5Gzxx11eL4k1LZ5XCJzDxw20JOKkpf/lU39eapp9vm2a7Fb
ms/SrjlNW0CizlIdtaCHjMpOx/5Si3rZGAWOuXcKOtuTWHp2ITOCy4jUQ63J
gazRSh+zrMJS2b1y92PBpjFB7epcZler/yzNz0csiy/6qWJskfGUmWN/f0mo
lM3HCIWq/m76UhGt6kxVrHua7w5X1K7L8ZbZnn509ecljlpmYHqWP5XTGTjN
ZNZ2n6y71FUzN277XlzFoXZWLww4HMaHHmacuLU18FubdjoMmPKG1GBJvPOh
dzZuMvO4/ZCPQpTxXEr4gZxNyAAWYARNkszRRbRbuHTNGnBR2W+0grEOk5bo
oN0iudpbol5WeytwLnWHEJOzfghar4EhkCE/M2aoTXZOez3AGHlPd8HhMCo/
1WWiha/AD4bLCurX39zneeT9dJqpYl8w/bmHjrqvTK9/uB7Snbc7F9X7DrQV
XyxJs0VbAfctfX/b0Qo1fSt/JjbGRG3/2iB0CoEsY1H+nCk/EaNzppCjr62B
HGE7LaPxO1ZMqzKpLrGJvIFjtA+5YpzouH2tl5PLtu3qyMxeOWQffmmLVJeo
wTlNV//uuqMq0RGp2j3KZyu6Uth+K63/BfVPj3hNZf+SazPtw3RbhkAqEZP9
ZUR+mAxZei9hwhFRMSg4MlAJbUKjIjAqEQ3Zgt+uYR3zqkToaUDh49wC391W
bEFqYcNGFcPBvw4Vwc0f1X91BeE/OhTxwQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->45987325]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90106410],

Cell["Use any 2D or 3D graphic as plot markers: ", "ExampleText",
 CellID->586637188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "6", ",", "9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "7", ",", "10", ",", "12"}], "}"}]}], "}"}],
    ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      Graphics3DBox[
       GraphicsComplex3DBox[
        NCache[{{
          0, 0, (Rational[9, 8] + Rational[3, 8] 5^Rational[1, 2])^
           Rational[1, 2]}, {
          0, 0, Rational[-1, 2] (Rational[3, 2] (3 + 5^Rational[1, 2]))^
            Rational[1, 2]}, {(Rational[1, 8] + 
            Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[1, 8] + 
            Rational[1, 24] 5^Rational[1, 2])^
           Rational[1, 2]}, {(Rational[1, 8] + 
            Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[1, 8] + 
            Rational[1, 24] 5^Rational[1, 2])^
           Rational[1, 2]}, {(Rational[1, 8] + 
            Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), 
           Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2]}, {(Rational[1, 8] + 
            Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), 
           Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2]}, {(Rational[5, 8] + 
            Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[1, 8] + 
            Rational[1, 24] 5^Rational[1, 2])^
           Rational[1, 2]}, {(Rational[5, 8] + 
            Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
            Rational[1, 24] 5^Rational[1, 2])^
           Rational[
            1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
            Rational[1, 2], 
           Rational[-1, 2], (Rational[1, 8] + 
            Rational[1, 24] 5^Rational[1, 2])^
           Rational[
            1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
            Rational[1, 2], Rational[
           1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
           Rational[1, 2]}, {(Rational[3, 4] + 
            Rational[1, 3] 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 2], 
           Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2]}, {(Rational[3, 4] + 
            Rational[1, 3] 5^Rational[1, 2])^Rational[1, 2], Rational[1, 2], 
           Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2]}, {-(Rational[1, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2], 0, 
           Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2]}, {
          Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2]}, {
          Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[5, 24] 5^Rational[1, 2])^
           Rational[1, 2]}, {(Rational[1, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2], 
           0, (Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
           Rational[1, 2]}, {
          Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
           Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2]}, {
          Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
           Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2]}, {
          Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), 
           Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2]}, {
          Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), 
           Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
            Rational[1, 2]}}, {{0, 0, 1.4012585384440737`}, {
          0, 0, -1.4012585384440737`}, {
          0.17841104488654497`, -1.3090169943749475`, 0.46708617948135783`}, {
          0.17841104488654497`, 1.3090169943749475`, 0.46708617948135783`}, {
          0.46708617948135783`, -0.8090169943749475, -1.0444364486709836`}, {
          0.46708617948135783`, 0.8090169943749475, -1.0444364486709836`}, {
          1.0444364486709836`, -0.8090169943749475, 0.46708617948135783`}, {
          1.0444364486709836`, 0.8090169943749475, 
          0.46708617948135783`}, {-1.2228474935575286`, -0.5, 
          0.46708617948135783`}, {-1.2228474935575286`, 0.5, 
          0.46708617948135783`}, {
          1.2228474935575286`, -0.5, -0.46708617948135783`}, {
          1.2228474935575286`, 
          0.5, -0.46708617948135783`}, {-0.9341723589627157, 
           0, -1.0444364486709836`}, {-0.46708617948135783`, \
-0.8090169943749475, 1.0444364486709836`}, {-0.46708617948135783`, 
          0.8090169943749475, 1.0444364486709836`}, {
          0.9341723589627157, 0, 
           1.0444364486709836`}, {-1.0444364486709836`, -0.8090169943749475, \
-0.46708617948135783`}, {-1.0444364486709836`, 
          0.8090169943749475, -0.46708617948135783`}, {-0.17841104488654494`, \
-1.3090169943749475`, -0.46708617948135783`}, {-0.17841104488654494`, 
          1.3090169943749475`, -0.46708617948135783`}}], 
        Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
         19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 
         5, 19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3,
          14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}]],
       Boxed->False,
       ImageSize->30], ",", 
      Graphics3DBox[
       GraphicsComplex3DBox[
        NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
          0, 0, 5 (50 - 10 5^Rational[1, 2])^
            Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
           0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
            Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), 
           Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[
           1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[-1, 
             2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[
            1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[-1, 
             2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[
            1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
          0, 0, -0.9510565162951536}, {
          0, 0, 0.9510565162951536}, {-0.85065080835204, 
           0, -0.42532540417601994`}, {
          0.85065080835204, 0, 0.42532540417601994`}, {
          0.6881909602355868, -0.5, -0.42532540417601994`}, {
          0.6881909602355868, 
          0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
          0.42532540417601994`}, {-0.6881909602355868, 0.5, 
          0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
          0.8090169943749475, -0.42532540417601994`}, {
          0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
          0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
        Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
         12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 
         10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {
         6, 4, 5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}]],
       Boxed->False,
       ImageSize->30], ",", 
      Graphics3DBox[
       GraphicsComplex3DBox[
        NCache[{{Rational[-1, 2], Rational[-1, 2], 0}, {
          Rational[-1, 2], Rational[1, 2], 0}, {0, 0, -2^Rational[-1, 2]}, {
          0, 0, 2^Rational[-1, 2]}, {Rational[1, 2], Rational[-1, 2], 0}, {
          Rational[1, 2], Rational[1, 2], 0}}, {{-0.5, -0.5, 0}, {-0.5, 0.5, 
           0}, {0, 0, -0.7071067811865475}, {0, 0, 0.7071067811865475}, {
          0.5, -0.5, 0}, {0.5, 0.5, 0}}], 
        Polygon3DBox[{{4, 5, 6}, {4, 6, 2}, {4, 2, 1}, {4, 1, 5}, {5, 1, 3}, {
         5, 3, 6}, {3, 1, 2}, {6, 3, 2}}]],
       Boxed->False,
       ImageSize->30]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30979567],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->18229875]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24612],

Cell["Use smaller versions of the default shapes:", "ExampleText",
 CellID->753861120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "6", ",", "9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "7", ",", "10", ",", "12"}], "}"}]}], "}"}],
    ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "8"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1283618984],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWLtOwzAUTeukRZXYEX1QHiN8AQ0sLUx8ATBUgFQGxHNCwAYTP1AJmGBA
Yuz/GV/7prGdm7guGYjUOPf9ONdO4GB4Nzq7GN6dnwy7+zfDq9H5yW137/JG
sFglCIKJ+N0vBeKZiyf5m3AuVv2+Ke5MiFpiDcXaRnoFpPDA5SXlQIbSaouQ
JrS4B90COTza3iuk17bDahlztqPR3jpETlWsWM99dS5vdq6J9xVc6b414Ram
dLaWpuZH57MpeiDtaCuFXiJXVjr+i5bmpze3Ie7fglkhdRoOmll06Gn/3/xX
yS7sOOg1R9cBuy8PZGBq2G48fsmVhkL6bPgHbmRwi21mjzd7HRFXO9pGSUlr
GjcgtOA8iMbxdRuzOZN6dQIxIHVtqOxUai9QeBIxWtgtPyszFlRr7n67op5R
SQ07GJU2J9taNRBn4NSC7PtGvB5Kk/npe/rQtY4K85i9Tgpzfy15ho9f45cp
WslsMtwvoZA+p1hqs2ljZGrnIWlGLMabyt4Xf5obYxY7iMaG0fcYK4kRyXXS
Rw+1ejgVtJYeKd/XYyYP11QUd8697w65mtZ+ifqgntVjRJamVs2S0mdjnWvf
GaWcDTT3GBEbGH6PEe38XZ0vzXqcL/+/Yv7O1ZSFHvowsywTHZTeuJp7Npc3
32zLfzM8cDWD9I7MSsH/o6eNzwy68scPbLyqhf2oZrprv69t+omrGW1hDczD
D8POwA5ozmFvn4Rl+PlLPUTvWdr75C0UzYBZOdyyo6T+1PgkV9Ic+oSVnalP
ucoQzW2LD+x+mFoW9Nj+KnnHGWCkNfX3CJD+Vo6MS5qTH8nK/l8iqPwCKxn+
tA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216297633]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28465],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arrowheads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrowheads"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27523]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->80585973],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->130425793],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->43301202],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->782326337],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->54860834],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->117684606]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PlotMarkers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 9, 41.4781900}", "context" -> "System`", 
    "keywords" -> {
     "plot markers", "plot glyphs", "plot icons", "plot symbols", 
      "multiple data markers", "data markers", "data symbols", "data glyphs", 
      "data icons"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PlotMarkers is an option for graphics functions like ListPlot and \
ListLinePlot that specifies what markers to draw at the points plotted. ", 
    "synonyms" -> {"plot markers"}, "title" -> "PlotMarkers", "type" -> 
    "Symbol", "uri" -> "ref/PlotMarkers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11556, 370, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->172964043]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39474, 1030}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2199, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2822, 74, 1576, 37, 70, "ObjectNameGrid"],
Cell[4401, 113, 790, 23, 70, "Usage",
 CellID->2819]
}, Open  ]],
Cell[CellGroupData[{
Cell[5228, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5706, 158, 68, 1, 70, "Notes",
 CellID->8907],
Cell[5777, 161, 2938, 95, 70, "2ColumnTableMod",
 CellID->29071],
Cell[8718, 258, 430, 14, 70, "Notes",
 CellID->5022],
Cell[9151, 274, 297, 9, 70, "Notes",
 CellID->20561],
Cell[9451, 285, 344, 11, 70, "Notes",
 CellID->1991],
Cell[9798, 298, 469, 16, 70, "Notes",
 CellID->22052],
Cell[10270, 316, 723, 27, 70, "Notes",
 CellID->5251],
Cell[10996, 345, 523, 20, 70, "Notes",
 CellID->1523]
}, Closed]],
Cell[CellGroupData[{
Cell[11556, 370, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->172964043],
Cell[CellGroupData[{
Cell[11941, 384, 148, 5, 70, "ExampleSection",
 CellID->743367436],
Cell[12092, 391, 102, 2, 70, "ExampleText",
 CellID->946519202],
Cell[CellGroupData[{
Cell[12219, 397, 491, 14, 28, "Input",
 CellID->1736854685],
Cell[12713, 413, 1136, 23, 143, "Output",
 Evaluatable->False,
 CellID->392821989]
}, Open  ]],
Cell[13864, 439, 125, 3, 70, "ExampleDelimiter",
 CellID->626914952],
Cell[13992, 444, 94, 1, 70, "ExampleText",
 CellID->673952066],
Cell[CellGroupData[{
Cell[14111, 449, 600, 18, 47, "Input",
 CellID->1269153684],
Cell[14714, 469, 1582, 30, 171, "Output",
 Evaluatable->False,
 CellID->821002160]
}, Open  ]],
Cell[CellGroupData[{
Cell[16333, 504, 716, 22, 49, "Input",
 CellID->40799692],
Cell[17052, 528, 1581, 30, 171, "Output",
 Evaluatable->False,
 CellID->45987325]
}, Open  ]],
Cell[18648, 561, 124, 3, 70, "ExampleDelimiter",
 CellID->90106410],
Cell[18775, 566, 85, 1, 70, "ExampleText",
 CellID->586637188],
Cell[CellGroupData[{
Cell[18885, 571, 10442, 194, 77, "Input",
 CellID->30979567],
Cell[29330, 767, 4326, 75, 251, "Output",
 Evaluatable->False,
 CellID->18229875]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33705, 848, 216, 7, 70, "ExampleSection",
 CellID->24612],
Cell[33924, 857, 86, 1, 70, "ExampleText",
 CellID->753861120],
Cell[CellGroupData[{
Cell[34035, 862, 542, 16, 70, "Input",
 CellID->1283618984],
Cell[34580, 880, 1071, 22, 70, "Output",
 Evaluatable->False,
 CellID->216297633]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35712, 909, 311, 9, 70, "SeeAlsoSection",
 CellID->28465],
Cell[36026, 920, 933, 35, 70, "SeeAlso",
 CellID->27523]
}, Open  ]],
Cell[CellGroupData[{
Cell[36996, 960, 318, 9, 70, "MoreAboutSection",
 CellID->80585973],
Cell[37317, 971, 163, 3, 70, "MoreAbout",
 CellID->130425793],
Cell[37483, 976, 142, 3, 70, "MoreAbout",
 CellID->43301202],
Cell[37628, 981, 166, 3, 70, "MoreAbout",
 CellID->782326337],
Cell[37797, 986, 196, 4, 70, "MoreAbout",
 CellID->54860834],
Cell[37996, 992, 179, 3, 70, "MoreAbout",
 CellID->117684606]
}, Open  ]],
Cell[38190, 998, 27, 0, 70, "History"],
Cell[38220, 1000, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

