(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     75968,       1598]
NotebookOptionsPosition[     71730,       1463]
NotebookOutlinePosition[     73240,       1503]
CellTagsIndexPosition[     73154,       1498]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MaxRecursion" :> 
          Documentation`HelpLookup["paclet:ref/MaxRecursion"], 
          "MaxPlotPoints" :> 
          Documentation`HelpLookup["paclet:ref/MaxPlotPoints"], "Mesh" :> 
          Documentation`HelpLookup["paclet:ref/Mesh"], "ControlActive" :> 
          Documentation`HelpLookup["paclet:ref/ControlActive"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MaxRecursion\"\>", 
       2->"\<\"MaxPlotPoints\"\>", 3->"\<\"Mesh\"\>", 
       4->"\<\"ControlActive\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Plotting Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PlotPoints", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PlotPoints",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
     "\[LineSeparator]is an option for plotting functions that specifies how \
many initial sample points to use. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20267]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With a single variable, ",
 Cell[BoxData[
  RowBox[{"PlotPoints", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " specifies the total number of initial sample points to use. "
}], "Notes",
 CellID->12341],

Cell[TextData[{
 "With more than one variable, ",
 Cell[BoxData[
  RowBox[{"PlotPoints", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " initial points should be used in each direction. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->617],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PlotPoints", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies different numbers of initial sample points for each successive \
direction. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24968],

Cell["The initial sample points are usually equally spaced. ", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->25065],

Cell[TextData[{
 "Adaptive procedures controlled by ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " are used to choose more sample points. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->27321]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214308661],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->48148413],

Cell["Use 10 points in each direction:", "ExampleText",
 CellID->469106496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "10"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->860410135],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1lV1IU2EYx2eLKAi6KS+sJCkJIUovxIrYeyr6IO3DyI+CujBL0YulBhWa
fSjhhazAwDDC1kXQjYZEJJLrEwssI7BZvSbpVpZnjqDQoDAZ5/eO85522Hh5
fxtnz2//531OWol3/7E5LperdPbtdiW+lvVVzb76xf+5dPCC2BVO8H3Twatj
H/xw8MLYfX45+Ebf2Hrf2LSDp8bu/8fBrctIwB1+7Fl7jntbF22/I/CFr1ta
eXSNp1vgC8/adC/QF3oi8IW/9rwo7Eh9KfCFXyrfkPJ154DAFx68sqe2v/Ot
wBeeXlrcWNs5KPCF/96RV+/3D+FhwH0Rd1dZ40fNTybwlcrL7itV/XZfKd5Z
ddp9pZi26rH7SuH+MOlKKvyk+UpxMq39atHIZ81Xihu5RWeTy0KarxSP8yqT
Ij1fNF8pBq+fiCwYGld+ej/iC7fnJRXHiz0r/ye+8BqrfnzhU1vq54lrYeWr
7m/ViS+85XnvtnPNE8oXnnzgcF3N7Yjyhe9Kb2hYnhLV/MwE+ZoqR3u+psrL
nq+pvOz5muKR9f/b8zXFkQe+1oz737V8TVW/PV9T5AwHO5u8US1fUxSd9hy8
NRPV8jXF3MzWZ+n5cV99fuAL53zhC6cP8YWTF78Hx4s9a8R/4Xxu9qTyha+u
ODVRPBJVvvD8xaMzZ9rivvAlA3/Xyop4vvCMrM0FVdXflJ8+F/GFB23nUSrO
+cIXTh/iCycv6oDjxZ7VbeWCr8p/5as2z3xT+cLHRpObzd3x8wsPeTPLf24d
Vn76vMcXzjzEF87cwBfO+cIXTh/iCycv6lP9a3mxZ50SD8Mzq8LKFz5a4Q90
XQwqX/jdkjfRfdntyk9/juELZ87jC2ce4gsnR3zhnC984fQhvnDyom44XuxZ
b5aseNp0qCWAL3xhqO7y3t73cC5D94Xb5616bhnMeW2+G8xDbQ4azA1tXhic
L+1cGfSh1n8GeWk5GZoXPkZHqhzuzhkP/AP28Kda
   "], {
    {EdgeForm[GrayLevel[0.]], 
     GraphicsGroup3DBox[
      Polygon3DBox[{{12, 1, 2}, {15, 4, 5}, {13, 2, 3}, {20, 9, 10}, {14, 3, 
       4}, {19, 8, 9}, {17, 6, 7}, {16, 5, 6}, {18, 7, 8}, {22, 11, 12}, {30, 
       19, 20}, {24, 13, 14}, {54, 43, 44}, {23, 12, 13}, {26, 15, 16}, {28, 
       17, 18}, {29, 18, 19}, {27, 16, 17}, {25, 14, 15}, {32, 21, 22}, {34, 
       23, 24}, {38, 27, 28}, {36, 25, 26}, {35, 24, 25}, {37, 26, 27}, {43, 
       32, 33}, {40, 29, 30}, {39, 28, 29}, {33, 22, 23}, {44, 33, 34}, {53, 
       42, 43}, {49, 38, 39}, {47, 36, 37}, {46, 35, 36}, {48, 37, 38}, {45, 
       34, 35}, {52, 41, 42}, {50, 39, 40}, {88, 99, 98}, {55, 44, 45}, {57, 
       46, 47}, {60, 49, 50}, {58, 47, 48}, {66, 55, 56}, {59, 48, 49}, {65, 
       54, 55}, {63, 52, 53}, {62, 51, 52}, {64, 53, 54}, {67, 56, 57}, {76, 
       65, 66}, {69, 58, 59}, {56, 45, 46}, {68, 57, 58}, {72, 61, 62}, {74, 
       63, 64}, {75, 64, 65}, {73, 62, 63}, {77, 66, 67}, {78, 67, 68}, {79, 
       68, 69}, {82, 71, 72}, {83, 72, 73}, {84, 73, 74}, {85, 74, 75}, {86, 
       75, 76}, {87, 76, 77}, {88, 77, 78}, {80, 69, 70}, {89, 78, 79}, {92, 
       81, 82}, {95, 84, 85}, {93, 82, 83}, {94, 83, 84}, {96, 85, 86}, {90, 
       79, 80}, {42, 31, 32}, {98, 87, 88}, {97, 86, 87}, {99, 88, 89}, {100, 
       89, 90}, {1, 12, 11}, {5, 16, 15}, {3, 14, 13}, {22, 33, 32}, {4, 15, 
       14}, {9, 20, 19}, {7, 18, 17}, {6, 17, 16}, {8, 19, 18}, {11, 22, 
       21}, {19, 30, 29}, {16, 27, 26}, {14, 25, 24}, {13, 24, 23}, {15, 26, 
       25}, {12, 23, 22}, {18, 29, 28}, {17, 28, 27}, {21, 32, 31}, {23, 34, 
       33}, {43, 54, 53}, {25, 36, 35}, {26, 37, 36}, {27, 38, 37}, {28, 39, 
       38}, {29, 40, 39}, {31, 42, 41}, {32, 43, 42}, {24, 35, 34}, {33, 44, 
       43}, {35, 46, 45}, {38, 49, 48}, {36, 47, 46}, {37, 48, 47}, {39, 50, 
       49}, {34, 45, 44}, {44, 55, 54}, {42, 53, 52}, {41, 52, 51}, {70, 59, 
       60}, {45, 56, 55}, {76, 87, 86}, {55, 66, 65}, {49, 60, 59}, {56, 67, 
       66}, {47, 58, 57}, {51, 62, 61}, {54, 65, 64}, {48, 59, 58}, {52, 63, 
       62}, {57, 68, 67}, {64, 75, 74}, {59, 70, 69}, {58, 69, 68}, {65, 76, 
       75}, {2, 13, 12}, {62, 73, 72}, {63, 74, 73}, {61, 72, 71}, {53, 64, 
       63}, {66, 77, 76}, {67, 78, 77}, {73, 84, 83}, {71, 82, 81}, {69, 80, 
       79}, {72, 83, 82}, {77, 88, 87}, {75, 86, 85}, {74, 85, 84}, {78, 89, 
       88}, {81, 92, 91}, {87, 98, 97}, {68, 79, 78}, {84, 95, 94}, {82, 93, 
       92}, {83, 94, 93}, {85, 96, 95}, {46, 57, 56}, {86, 97, 96}, {79, 90, 
       89}, {89, 100, 99}}]]}, {}, {}, {}},
   VertexNormals->CompressedData["
1:eJx1lXs01nccx11aLVZLsi4capMosie1FPY5pwtqtOUp0WWlJJ3uqVnXJemi
SaXIuumiWuWRHMUmH0RLcsndE/J4ejyP54I6IRHbOO/nnP2x3znO+zkff73O
+/Idt3qL11o9HR0d/3/+9HX+72sl/BopUJ1elZPPM2Pc49XOLdp783RvgW1P
Nat7Djx846LR3s8qnOLGZEpYUuPbOiFOqb2nbBzyLniWjD3GRL59opRr7/rG
kwuH5cm5qTYyzTpQpr3/Fvvv18QOfZ9UezfSzLRoUSo5caJjbYOnRHvPFOz3
eytVcXtHQsLWVa+092oN546/rOZ+rSHw4P/gUsxYLB9pms/QZP/HlnpHm8km
ULQuYmUe92s1U4q/n3uimpyCPS6/Hv0Xb/TdFbxBKOEthwfvK3ZV0slU830B
nMP9+pqLzkfPLC2Q0yCLXu+bJ7M5rzHD9sVUOaudlq3oOCajJgdbkXF8Jr/y
nBV2sUPB6Z/p6pufkVKnZ2qcovsRO8258ut3Lkoecid/dI5GQvYTlEVZk/5k
QZ+qeP0iUYhlZD3NV0qmueakctSES92FNSoet2dGp7CmjuATeOEXeMAHrlbV
ds3OjEqGejbGXZe4qGib2C2sM6acy6VtX3UJ6nnvKf2ZPwQ00fvZapc6n1Lu
Vyn7eBRN+nhGTu3r7i5MdnnBbSEjrcZGyNjSbLul1aBGulaYn2qWVshd4nPh
5QZydpzbFBFa/pps5gWPWLIpnz9ZpRDc7ZVz7Y62i/cGvqZFHrote44+5cV9
quC67x1b6s5LacAah3c273J5bVHalMT7Cha/XzCvOEZKyB94kUP4BN/gF3jA
B669g3t3+y2uZWhp1IiyYT8qqOiXjMkuA8UcftvGYr+vhHdYHSjJOiKnvPEL
TTOzKth6/uasZ+0NvGNYwvw/xsop4Y21v31sKYv6VMr3PnRccvKS03B9ZcDk
oGKO1jf62VAg5cqW02uqSEHf6i14eMb8GR/Qnbo7db2EY7ydr582UFLAQKcF
BV1ZfO6YT1typ5gFYpOU4XfUhF6BF/1C/pBH5BA+wTf4BR7wgUvkuVe4uruW
od2zCuZEd8gp6OqSUwdvVbHR8YRp10rqOKD0yNPlXzfRps7k8iBhCVu1R2Ta
7XvJJttjzSwCVWQSmTSgfVIOT11hOif4xgv2Gdo4PXtJMx26kOwe5BBCYX16
ig7KTMae6GmhGB2rKkNhLt3OnCjc9LGSRgyv6DW21xD2ArzYDfQKPUO/kD/k
ETmET/ANfoEHfOCKP2HwXFBWxtCkTJNX6YFqevuh0fb88DQOj9pTJPwig589
Mb548nILZRW8M/7WL5dmCVtNw5sLKC9sd/rOG810dXTVxg3R5WQm2vXoy7kS
+rynujtPpCBnx/zmI99U04X7oa3GSY2U8DYoZPODBsIOghd7iL3AfmA30Cv0
DP1C/pBH5BA+wTf4BR7wgStp6/KSoUuLtWo4aSeHV2ioK5xfbnCtpcAAsTLD
WELpySuHjnncSNmPfKa4za6npV4/nRucKKPf7azPHtWTkJGPeJTuiHoadcgt
XtdcQRtLjbK9zV8S9h282HnsIHYRe4i9wH5gN9Ar9Az9Qv6QR+QQPsE3+AUe
8IGrfs+K8uKlUq26RuT7X4uqJ+GyE2fL7KQUmnR1lLNKRmab6KZ9qJi2FdyO
0sxtILeF82J375dTr/vCia4hlYR3C7x4v7Dv2HvsPHYQu4g9xF5gP7Ab6BV6
hn4hf8gjcgif4Bv8Ag/4wDX9+LEM34EyrfoeDpPNuFVJduv1BtSKpOT14OD1
VMtG+vTG3LoU+yrCe/zf97mG8G7hHcP7hX3H3mPnsYPYRewh9gL7gd1Ar9Az
9Av5Qx6RQ/gE3+AXeMAHrq0PHz83lEu16nHFILRiex39DTN0t48=
    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 2}, {0, 2}, {-0.7568024953079282, 0.9999553435370768}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1476195476,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->538791341],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " will cause additional sampling beyond the initial 10 points:"
}], "ExampleText",
 CellID->1428896040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "10"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146119879],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1lwtMlWUYx48c18TZbNPUSElXLK2m6DIvFe9nXgsoqERrSydFXnADJW/z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   "], {
    {EdgeForm[GrayLevel[0.]], GraphicsGroup3DBox[Polygon3DBox[CompressedData["

1:eJwNxdciGwoAAFCrLZVYqViJJkiiRoYiS8lENtnUViN777RqhKB2ib333qWq
tGq2H3XveTnwOp2wLsDPz++Dv59f4P83BADCg55FPHse+fxFEwAMCg4JCwxK
iomNehGcHBvXGAhsBsYkRERCIqOgUaBYYBgsGvy55SUcHJMIehUfHpESF5/9
Jg0Rn/A8MuKPJzEdBk97DWuFIDPgSZlJyV+Uqe1QVBcCk5OWnpuegc/I7FGg
+r0YdHJKGxJLyETHhYUPqrDDahwlJ/duDD/uI0xqicXv8guyc6Z1pFk9Of9t
tiGvUFTMWjbSVk30dTNj08J8WKCw8gvmC0uERcU72+x9G7deXrYlKCsXlJwK
Ky5d0vMz8bGD/1WTVSkUHdp5F07JlVvWCAj41BD677r8RVRkYBjwWUT4ibxu
18oJCg9bWqQGg6K2RaxmMAAYGxMWFxseHwdKhDZFh0YkxEdCEmDpaVFQyOu0
N7HJSXEpyfGIlFZEAhgOi4a9bkdCPChoTBIcnpE+qCZ1oVOS0ZmTOroCi3yT
/bYNg0jPzelR4pIyMzLwuV4CelhDfpv/LrsgP4dS0K8iZhLwY5TcOx91XEub
1jNO/77PZxUvsAoeFtlLRs7mvOBdcdGyibtq5gkrK9Yt/G+n73es4l2bZN8u
PXTIikXCImHp8ZZcUF52Vik6d1aBm2MuXNWzBqa8vu5jg/91fdmluya0ARDY
GHB1UgtoBAKaQjuVqF4FrkOBbAGF9CmzhlQkYDMgugncrcL0qrEjanKfBjel
pQ/piDM6xoieNGGkDmgJc3rmqIF8YJPeGwpXbJwZM33DzJ+zMB4tgikTbcXI
5VjZe1bJmom3Zue2fH715JBvOHjaKdoPZ/VPV82eU1zjrj1wSY7ssoaPAb9b
QiCtCTetyJs2RHcbFtTyquGTP7Qd0tGOau9AKjpQiR6opxOl7ExFdKXcdmFu
vWhVN7atG6PowQ14icoelKofo+7FKb9kKftwmr4sbz9RO0D0DhAUvdhOT6pq
kKQaIqqHyZphnHqEpB8h48dydUMkzdc8zSjZMJpHGaOqB7HacYJvnDbhox25
pb4JKsGHN07QtJN03SRxVJNnmqLrp0nmGYZ+lmmYJevnGJSFAt0M3TLHvJ9n
mlfpgvkS0ypvcYljXKIal7mmZRp1kcJaYBtXOLYVrmmNa1/jWXcl5nW+bprh
2ODPbzItmwLLOuNxiy/fKjNv8NjbLNG22Lknse6Jbbsc9iLHti+1HUisO+zt
HbF9n5uWk+06kDoOee4jmeNYvnXMfzqR1Z7UnX4r/XtaIT4TCU9Lv59VuS5r
nOfis++Vzotq14XE+aPK9bPafSk9O6+yH0ndV7Xl12XXv+pbfr9svUG03SDH
7qi/rj94/qR23aK9txjfHf7kSrb4QFl4YM/fF9oPZZZHvuGeufUocDzJTp7k
1/8+/Ad6yZEa
       "]]]}, {}, {}, {}},
   VertexNormals->CompressedData["
1:eJx1VnlUjfsajk4os4RwCEkkqThCeV3NyDmkCDmUkhJSTpQpCSFFKrNoEorK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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 2}, {0, 2}, {-0.7568024953079282, 0.9999553435370768}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1262997832,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1344283241],

Cell[TextData[{
 "Use 50 points along the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->614541152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "0"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1675012435],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->601685390]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1840465047],

Cell["Use different numbers of points for different variables: ", \
"ExampleText",
 CellID->464020611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", "t"}], ")"}], " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", "t"}], ")"}], 
      RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "0"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"50", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->938855156],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxd0/s71IkeB3AGY0aGMcyMS8O4J3dRFL6fUlHZyrWoiEKK7BFJNlqPzYPN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   "], {
    {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[{GrayLevel[0], Opacity[
     0.3]}], GraphicsGroupBox[
      PolygonBox[{{1, 2, 52, 51}, {5, 6, 56, 55}, {2, 3, 53, 52}, {3, 4, 54, 
       53}, {4, 5, 55, 54}, {6, 7, 57, 56}, {10, 11, 61, 60}, {7, 8, 58, 
       57}, {8, 9, 59, 58}, {9, 10, 60, 59}, {23, 24, 74, 73}, {11, 12, 62, 
       61}, {13, 14, 64, 63}, {14, 15, 65, 64}, {15, 16, 66, 65}, {16, 17, 67,
        66}, {12, 13, 63, 62}, {18, 19, 69, 68}, {19, 20, 70, 69}, {20, 21, 
       71, 70}, {21, 22, 72, 71}, {22, 23, 73, 72}, {98, 99, 149, 148}, {24, 
       25, 75, 74}, {26, 27, 77, 76}, {30, 31, 81, 80}, {27, 28, 78, 77}, {28,
        29, 79, 78}, {29, 30, 80, 79}, {31, 32, 82, 81}, {35, 36, 86, 85}, {
       32, 33, 83, 82}, {33, 34, 84, 83}, {34, 35, 85, 84}, {36, 37, 87, 
       86}, {37, 38, 88, 87}, {38, 39, 89, 88}, {40, 41, 91, 90}, {41, 42, 92,
        91}, {42, 43, 93, 92}, {39, 40, 90, 89}, {43, 44, 94, 93}, {45, 46, 
       96, 95}, {46, 47, 97, 96}, {47, 48, 98, 97}, {44, 45, 95, 94}, {17, 18,
        68, 67}, {48, 49, 99, 98}, {49, 50, 100, 99}, {51, 52, 102, 101}, {62,
        63, 113, 112}, {53, 54, 104, 103}, {54, 55, 105, 104}, {55, 56, 106, 
       105}, {56, 57, 107, 106}, {57, 58, 108, 107}, {58, 59, 109, 108}, {59, 
       60, 110, 109}, {60, 61, 111, 110}, {61, 62, 112, 111}, {63, 64, 114, 
       113}, {73, 74, 124, 123}, {65, 66, 116, 115}, {66, 67, 117, 116}, {67, 
       68, 118, 117}, {64, 65, 115, 114}, {68, 69, 119, 118}, {70, 71, 121, 
       120}, {71, 72, 122, 121}, {72, 73, 123, 122}, {69, 70, 120, 119}, {74, 
       75, 125, 124}, {25, 26, 76, 75}, {75, 76, 126, 125}, {92, 93, 143, 
       142}, {81, 82, 132, 131}, {80, 81, 131, 130}, {77, 78, 128, 127}, {78, 
       79, 129, 128}, {82, 83, 133, 132}, {84, 85, 135, 134}, {85, 86, 136, 
       135}, {52, 53, 103, 102}, {83, 84, 134, 133}, {79, 80, 130, 129}, {86, 
       87, 137, 136}, {87, 88, 138, 137}, {89, 90, 140, 139}, {90, 91, 141, 
       140}, {91, 92, 142, 141}, {93, 94, 144, 143}, {95, 96, 146, 145}, {94, 
       95, 145, 144}, {88, 89, 139, 138}, {96, 97, 147, 146}, {97, 98, 148, 
       147}, {76, 77, 127, 126}, {99, 100, 150, 149}}]]}, {}, {}, {}}],
  Axes->True,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotRange->{{-14.388690740302792`, 11.315892047585024`}, {-9.72802314089655,
    12.887537106375447`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->335889121]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2137],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxRecursion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxRecursion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxPlotPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxPlotPoints"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6932]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18655],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with PlotPoints",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=PlotPoints"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->606808764],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->6681224]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PlotPoints - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 9, 58.0567394}", "context" -> "System`", 
    "keywords" -> {
     "curve samples", "points to sample", "points to sample in plots", 
      "points to sample on curves", "sampling distance", "sampling in plots", 
      "initial plot sampling", "adaptive sampling", "initial points", 
      "starting points", "global sampling"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PlotPoints is an option for plotting functions that specifies how many \
initial sample points to use. ", "synonyms" -> {"plot points"}, "title" -> 
    "PlotPoints", "type" -> "Symbol", "uri" -> "ref/PlotPoints"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9902, 268, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->214308661]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 73011, 1491}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2211, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2834, 81, 4194, 83, 70, "ObjectNameGrid"],
Cell[7031, 166, 479, 14, 70, "Usage",
 CellID->20267]
}, Open  ]],
Cell[CellGroupData[{
Cell[7547, 185, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8025, 202, 229, 7, 70, "Notes",
 CellID->12341],
Cell[8257, 211, 429, 13, 70, "Notes",
 CellID->617],
Cell[8689, 226, 569, 18, 70, "Notes",
 CellID->24968],
Cell[9261, 246, 217, 4, 70, "Notes",
 CellID->25065],
Cell[9481, 252, 384, 11, 70, "Notes",
 CellID->27321]
}, Closed]],
Cell[CellGroupData[{
Cell[9902, 268, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214308661],
Cell[CellGroupData[{
Cell[10287, 282, 147, 5, 70, "ExampleSection",
 CellID->48148413],
Cell[10437, 289, 75, 1, 70, "ExampleText",
 CellID->469106496],
Cell[CellGroupData[{
Cell[10537, 294, 455, 13, 28, "Input",
 CellID->860410135],
Cell[10995, 309, 22618, 374, 159, 5924, 96, "CachedBoxData", "BoxData", \
"Output",
 CellID->1476195476]
}, Open  ]],
Cell[33628, 686, 125, 3, 70, "ExampleDelimiter",
 CellID->538791341],
Cell[33756, 691, 247, 7, 70, "ExampleText",
 CellID->1428896040],
Cell[CellGroupData[{
Cell[34028, 702, 455, 13, 70, "Input",
 CellID->146119879],
Cell[34486, 717, 23523, 399, 159, 8004, 140, "CachedBoxData", "BoxData", \
"Output",
 CellID->1262997832]
}, Open  ]],
Cell[58024, 1119, 126, 3, 70, "ExampleDelimiter",
 CellID->1344283241],
Cell[58153, 1124, 162, 6, 70, "ExampleText",
 CellID->614541152],
Cell[CellGroupData[{
Cell[58340, 1134, 362, 10, 28, "Input",
 CellID->1675012435],
Cell[58705, 1146, 2819, 50, 126, "Output",
 Evaluatable->False,
 CellID->601685390]
}, Open  ]],
Cell[61539, 1199, 126, 3, 70, "ExampleDelimiter",
 CellID->1840465047],
Cell[61668, 1204, 102, 2, 70, "ExampleText",
 CellID->464020611],
Cell[CellGroupData[{
Cell[61795, 1210, 733, 23, 70, "Input",
 CellID->938855156],
Cell[62531, 1235, 5908, 98, 177, "Output",
 CellID->335889121]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68500, 1340, 310, 9, 70, "SeeAlsoSection",
 CellID->2137],
Cell[68813, 1351, 960, 35, 70, "SeeAlso",
 CellID->6932]
}, Open  ]],
Cell[CellGroupData[{
Cell[69810, 1391, 314, 9, 70, "TutorialsSection",
 CellID->18655],
Cell[70127, 1402, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[70268, 1407, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[70462, 1415, 305, 8, 70, "RelatedLinksSection"],
Cell[70770, 1425, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71172, 1442, 319, 9, 70, "MoreAboutSection",
 CellID->606808764],
Cell[71494, 1453, 141, 3, 70, "MoreAbout",
 CellID->6681224]
}, Open  ]],
Cell[71650, 1459, 50, 0, 70, "History"],
Cell[71703, 1461, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

