(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     75314,       1583]
NotebookOptionsPosition[     71682,       1465]
NotebookOutlinePosition[     73189,       1505]
CellTagsIndexPosition[     73103,       1500]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotRange" :> Documentation`HelpLookup["paclet:ref/PlotRange"],
           "PlotRangePadding" :> 
          Documentation`HelpLookup["paclet:ref/PlotRangePadding"], 
          "ImagePadding" :> 
          Documentation`HelpLookup["paclet:ref/ImagePadding"], "ImageMargins" :> 
          Documentation`HelpLookup["paclet:ref/ImageMargins"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PlotRange\"\>", 
       2->"\<\"PlotRangePadding\"\>", 3->"\<\"ImagePadding\"\>", 
       4->"\<\"ImageMargins\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "Plotting and Image Regions" :> 
          Documentation`HelpLookup["paclet:guide/PlottingAndImageRegions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Shape & Size\"\>", 
       2->"\<\"Plotting and Image Regions\"\>", 
       3->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PlotRangeClipping", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PlotRangeClipping",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotRangeClipping"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions that specifies \
whether graphics objects should be clipped at the edge of the region defined \
by ",
     Cell[BoxData[
      ButtonBox["PlotRange",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
     ", or should be allowed to extend to the actual edge of the image. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20531]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"PlotRangeClipping", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", any parts of objects that extend beyond the region defined by ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " will be clipped. With ",
 Cell[BoxData[
  RowBox[{"PlotRangeClipping", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " they are not clipped until they reach the edge of the whole image. "
}], "Notes",
 CellID->7239],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"PlotRangeClipping", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", graphics objects are effectively clipped to the region defined by the \
rectangle from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], "]"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8339],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"PlotRangeClipping", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", clipping is done only to the rectangle from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageScaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageScaled"], "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], "]"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageScaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageScaled"], "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20552],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["PlotRangeClipping",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangeClipping"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for functions such as ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26830],

Cell["\<\
Clipping is done for all graphics objects, including lines, points, text, \
polygons and disks. \
\>", "Notes",
 CellID->20474]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->76475405],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->85533738],

Cell[TextData[{
 "Allow graphics objects to spread beyond ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "5"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "4"}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17399],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}, 5]},
  Frame->True,
  PlotRange->4,
  PlotRangeClipping->False]], "Output",
 ImageSize->{154, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->289400975]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"Sec", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}], "^", "2"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->148611795],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->23776124]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->485],

Cell[TextData[{
 "Clip all graphics objects at ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "5"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "4"}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25455],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}, 5]},
  Frame->True,
  ImageMargins->0.,
  PlotRange->4,
  PlotRangeClipping->True]], "Output",
 ImageSize->{154, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->653078153]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"Sec", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}], "^", "2"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375449886],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVvYd7XNX1Nnq+kWSbGmJ6h4QWIIX0ShoQwNjGBYyNMbh3y7Zky5LVe++9
9957773NaHqv5wwh+eVPyHPvWnufczQajWyS+333uZfneJgZjUZ7v2utd71r
l7N3H/c/d/rycf/zJ4+/8Lfrx6+eO3/S74X3fK/DW17/i2GYXPiX8wQDz/8v
eEb+5f773/+GH2x6fAAeveADEnyFT/5N/mMk8PQxeIL/93L5GYOfhX87Pfzs
2/zeY3f4e+TzzINuPyHveq+/ZphHNr2z3e13Htz0Ce//4lseuWtLSC/I73l7
wGLz5x/kPyn5/1gP/v+H+X/TYp9/U7/87n/VUuG3H/8/3ELX33nov26p67c8
9i1b/ADfw238/4U43u6C251+/qjbz2k8u7INbb7wnycOSCIfcP/J5hYn/m/+
HDYsTPDHb/l55nF40tzjbOvnOoa4rlGud4Lrn+YG57iRJW5slZ1cY2dVjgWt
fVlvkxmsCqNZbTLpzQaTRQ+/yNo0XztU/2CVzA5Pf83dC+4XX1t0aumKYXzC
0tnjgDdTo1Zun+g/+6fqj59McY+mh9xek1Y/RV/v2pmw76n0T76fd+SNki9/
Vn3q903n3+28snvA79PxW1/Ow2cirypib6oTQnQpUcb0OFNmshnezMu2Fubb
SortZeWOymr2v0HsDnDNqBzzWseSzibVW+VGs8pk0pkNRoveatU6bBqnXfUP
h/JfrJx5Cb/rHrtRJVvRUyAqq20UiFO/q/hoZzz9xOMfPZy47+mMT1/K+/yH
ZV/9ovb02y0X/tbt+/GQ/+HJwBOLYRfWoq6r4gK1SWEGsY856RbXPjJiD3l3
Jv8JHk4i7TF44rFDE2vstJKd0zoWdfZVvXXNYFEZTVqT0WDRW6w6u03D2dXf
OJT/wypexu/ZwZlVCpl+YnK9PwFHe778WTH56ePv3x+z+5Gk/c9mHnql8OiP
K078uv7sn9sufdh7bf/Izc+nb59aDr+siPbXxN/Wb9Wd9b4Qv3gUXnps9JSS
ndWwCzr7CvqtRWk0a0xG8FuzRWezaVm7+u8O1T9ZBfMKafXfbUq1Qjc9be7s
xVYnhS74fdLx+Zv55KePffBg7N7HUw6+kHP4B8XHflp18reN5/7acfmj/uuf
jAUcmw0+uxrhq4oN0G3V6s0t7hnn+qa4wVlueIEdXWbHZeyUgp1Rs8Rv7Og3
ADP6jdFIYCZ+gzD/C1r8GvFK2uLE2/PQyh+Q7xX8JB/95Je1p//YcuH9nqsf
D984PBUEfnJxLdpPG3tLlxCsTwo3pEYb0+NNWdDKDEt+jtUN1UfgZe842z/F
Ds6yI4vs2Ao7IWOnFeysGqjAsZkKwLdFKnidhM7frUpoHD4lrXt410PxHz+Z
9sn3co+87hKpewb9Dk1ApIack0ZeU8fc0IAjJ4bokiP1abGGzERjdqqJkWxu
W984OzDNDs2xo4vs+IpjUuaYUTjm1OijYO41wdwGMLcVzc0J5vbYtkc/eCBm
z2MpB57P/uy1oi/eqjzxm4azf2m/tKvv+sHRgC9mg8+sRFxRRvmBidXxtzVJ
YdrUKF16nD4r2ZCTbvSAXP8EOzjtGJ5zjC06JlYcUzLHrNIxr0HTrlLTQgQJ
prW7mNa9deT1I7sfTtz/TOahlwuO/qj8+K/qzvyx9SLYdd/wjSPTQSeXwi7J
geNi/JVxt1SJIerkCE1ajDYjQZedot/Ysofh5cCEY2jaMTLnGF9yTK46ptfs
c0r7gsa+DGRlQLJSE7IyCWT1tZ1w+xse2/Xhd+I+fopY9I3SL39ec+oPzeff
6/LdO+j/2WTg8YXQC7KIK0BN8tibivggZVKoKiVSnR6nyUzSbm7X4IRjeMYx
Om+fWLJPrdpnSLsWNXzsKjzFLhDOpnaR1w/veTT54AvZh18rOvaWa6iO3zo2
F3J2NeyiNNJXFu23FndLnhCsSA5XpkarMuLVbnbcCS+HJh0jM/axefvkkn16
1T67Zp9X2Za0tlXexTbQIBgReP1Njy3a9d14iMxDrxQc/XH5cZHyDozePDpz
+/Ry6PmV8MurUdekMTdk8YFriSHylEhFeqynFg1PO0Zn7ePYItuM1DYnty2o
bMvYIpExNmYadosWoe2eTEOueLNUzCkiVwSfWQq7sBzhuxLttxobIE24LUsO
V6RGe2rRyKwDAJpYsE0t22altnm5bVFlW9FapZv4gboTxKDHFn0XOfaJVPdM
Tvnhq/nbpxZCzi2GX1qKvLoc478SHyhLClW4MwO2Z3TeMb6I8Eyv2Oak1gW5
dUltXdVZZa6cAG4k8NVW7XkYOAE5/8Vc5Py3qignXN7Vf/3gGHBC4PG54NPz
oRcWIq4sRl9fiQuQoS9FqDwgBCQwuWyH5iA8Muuiwrqstkp1QiY1owtRlhId
271F5PXOPY+BX+cgRf2kErzozJ9aL37Qe3X/yI3Pp299OXP75GzI2bnwS4tR
11bQkYIUSWGqza2ZWHZggIHvrNkQHKV1RW2R6ixi7Btd8vrfSV733JrdjyYd
eD7rs1cL0ad/VYce9F63794hiP6Ao1OBX00Hn54Lu7BInEgGsZYY4qE1yEEy
ElgK26ISgVnVWGR6i8JTayhHem4N5D4iKgqoRkIuEnTgjSOQYKZvn5xDB7q8
EnVNFntTnnDbQ2uAqJF5FHYIKvAa9GKdZc1FO5jWQ4u0hpP/kLQm/OIorxDf
oK3ZmbD/mQwaXciMv286904H+A6EvP9nEwFfTKP7nIGUvBLpK43xl8cFemrN
mmNGTvgZWqOxreisUv2G1hBstC7YyCk2iwvGvEz1Jmxe3oANUuLBUf9DEzeP
Cq25sBLhK42G1tzy1Bo5SbEq+4LaDhSIrTGgC29lKdFvaGs+ezVH8JtHkg48
l3UI/OZH5ahS3m6BrAGWAi0F2PCtOS20xm+L1oBaUkLCx9wFQhvShFTv2hox
t/KZf8vWQK7g0/6PK2huBR5E1gG/OTyJlvoKWxMKrblyx9aoHHMarJKWiAKB
1tC8BZR8hwjf1JrHgHBQZKIIoRH+fg/EFHDgjSNTAcdmAJvb0Jrzy7Q1sQGe
WqNEJYmt0fGtWSWtoaWIdmsGXG8Nz4CoelMhvx9+vQRULzLgn9sufoCSEoL8
JrLObNCJ+WChQZjrAzwx4JSKm9FgCbFAqohlvkWCEiItMll0rpLDc4t4DSnk
CEjuqNM+7AUxBMUQ+M6tL+eCTi5A+gKDhV/23CLUG1Nq2iIU3NgiHeZ06tCQ
1j0Hu6g33Fr1XdTdEO0v02ivPvm7JpAcoB6hpkGrfTEDPnT71GLI2eWwi6sR
V2TQKvfM9bCI0qzQJle3diMgCDJwJGq6TW0StRlkU3Cmz14tImFPSQjDHkgI
MgbULYHH58GZQs6thF2SRviuRflBpezmT4+QdqE/QS0F7XJ1KbFdYvCDg4tw
/Y+gZt1bBnlj/3NZwI3gVV/8pAIpgBISUMDBMVBEaMMTxIaoi2SRV+XR/kqQ
3purKPR0FZYk8+jsKK8F11qnJQw94lqUmbBCIcRNlb9L62glAErt46fSIc1C
ffr5m2XHflp94jf1WEnxHDUecBTMOX/7JDHnBWLOa/IYf1XcLY1Llb3lCBF5
LdTcfB+mSR8ofSxu6gPSBzE8BZglAENiRtu79+E1Wq0+EAtEApQPgQJcAmU2
sP7J3zVC9IrkRiQMqKolNP9FYv7ripgbOI6w5WjINrfX5OePUf6bVuIoEVRg
QMiLWgyoFaFGVAkBZaQsSGJq3RSs4jWPvYCoglgHcobEBQUGSLDjv6o//XYz
ZFKIeN+PkRRB0aOrnCaucom4ip8y9qY6Pui/6YUcClys1Nx6ISVEpRQyi8hV
fBTaVd8QY9DRj3/aFWadWi7Vz86YoDs3Pus6/fvKgy9m0NEPiEpIOEAWQKqQ
cyADgjoAFjvzpzZwMIzN/SNArVAPB50EEb4cemEVI+CaItofik9N/G0d8x/1
Cz2NeRR6hclS5Zin+VJrI3wnZKg7mgerrO/h193/Pw6FVa9WyPRzs6ahEWtr
F1tdz2anKKKvT/p92nHytxUHnkv/HvW/B2PvbrxPxyHUoUwUXFAW4SuPuq6M
uaEGF5Rs2Uvvf7uMWT2BenaNnUTDsWIXF6kk0PEcpRDSnl6kKaGLkIqp7V4k
PQRNadRopCuGqSlz36C9pZODHhbk6hJuLwR+2X/+r3WfvZpHPvkk5CGwIxDF
AcJkR4DJ3qoE+QDSCqgfVDnkbOAKSJHIFaeWgs+uQDkcflkeeU0Z7a+OvaWN
v61PDDNtbU1vT69xzHNcxuHgltxzxLmqoA1dtvFdhprw72SQBtTi8/idD7Am
lVahXVo0jk1Ye1x6nRotDTs/dmV367G3SoCzGfLppz7amQh5BbgFCiOw7eHX
iymHQ3aBVAxqBegFaPzGkWko2oJOLoXQnuMYhTLaTx0boI0P0ieGmJIjLB7H
JIVReNLfp7Gek3Hja9yEnN2KZMQMSblSL3AljVDRl2lKYp7F730QnhFf1s0t
mEcn3bsddW3G/1DPyd9VQ33zHGkH9B+N/Xw2pq0fFENCBXsTUm3iSXX3wLWD
o5DtiQCB0BXs7auMuq6OuaGNC9QnBJuSwi0pUTY3PfIMVtFS5xjp6CTp6Azp
6DwVlFoqT6yuPESTgpHkNtGjWd686NHPkH5Sj5bJjLNb9DPwy6Hz7zQdfq2Q
fP5ZWvPufybzE7DuK4VH3iyFUhMoCrQoGPgM6SrkaSxjDoMcpXl6OfS8FLt6
le9q7C19/G1TYqglOdKWGuNw6+2zOIqx6uQ7LOcmFeyGNK5d56cNHSYyQ+wz
T78kF/LzD0/jt3+HNau0Wr107U49vrK749hPK6AOYZ7C33nuw4fiCFlBKJN8
Caz8s2qM5t81QT0AAX3h/W6Rm0niXCCjNqvhl9aw137EwEKvkyJsqdGO9Hhu
Y7+fx/GkVeew1Dkqc46hR2PXp0nX57Dr6NGksBLkusDO67236E0bCYwmH/Tr
J4gShRc2i1bzLQA4+du6gy9kf/hQPJ0JfAEsT2UsSEaookFfg+XRw3/bCOoH
MfhbN0ha372DaHysGmcotYWcWw27BOStgOiOubkBhpQoR1ostwmJ7yESK84h
4gQbwECh6VgHQyBxqsuhfFESKodsReOcJizRFQi7qSm7ASQPE7UJT+BNKJON
Jv23weXU7+uP/7oOvAA8gnzD99+/PwbKeUp6IKiAASBzAwNARXQcwuIPzcB7
kLwvfdgH1Ac+QkYcpsFNKBUAAZLkpoi6rkJ8AoXgAHyiEZ+0eC49gXOLkgdx
THTZCTBhrMico2tOiJUJBbcuFwUWlECwMPdTSb4ZKVe3kQBUzHbbJuWC/vMd
ok8APPgZ4Ko1GtQ6g0JtvDNgvns6L33Ycf7ddmDBYz+rBnjAieic8SvgUSCm
QYjycufVQgANYgsKbUKeoHsaMLze6YR8eWXPwFUeuilSmSwEnVjExIkaSBpx
RY7oCSy6jl4cehegl5Ho9IjfIHEziLkRdDN3COcJhBLAkLkfnA1wFCvTNdfg
I84GKEoAGAlOe+5wi0GqI8DtJKQggyegnL4hF/VFqDegVfAcYAeXhW9UGUxy
rUmmMq2smZZWzVti/NVwwNEh/88Grx8Y8N3bDxEIPAxlJlA0+CV8JyhKgBzK
dPBXeNzzWDLymgTN8BpgD+9irn6BxjToMFQpwOZQy0Nkw3eh/wKtv9d9eVc/
1PXXPxm7AcxOOQ7hXwk5uwr8Di4cfnkN1csNDYQ4GiEMjZAqGCGDGCEz2c0O
T+Kcw5KTuvIGUyi4SSUnMj8Jeox7LIFIFbRh5IJkAUYCxpCATzP3awkFgG/T
nCCyIk34ADLQgQSeMW/AO3abFuSPK03AJ+G3wLprerNUbVlWWBZllrkVy8yi
ZWrOutkQ0X6zkVdmwi5MB5+eCjoOKWDC/7Ox6wdHz7/XBdIHoOVJ4U30b3gE
pKG4BRIBp2ck8HPmVVQNmE35UgxSKdAG0Or5dzrhW4BcQTqBMoY4IGOEk4Rf
wQTLLvjLI64oSJZVEQ2pi79tTAojWVa0QqIzIwmtkJXidGMU1FIDi85BwRhg
iWHCK2Ny54RgDGRgtAdfj6JJtHxV6jocISccw0ggRCRomB0AJdCNWmQcws0m
PmIgcpg34S09ueDHInvDp+HbVrTWJRUO1M9KbdPLtokF29iMbWTSNjhmd7VD
WowsOVyaGLwad2sl2m850ncp7CKoj/mgE3PAGCC4gUxOEzYGWOERaip85+0W
cHHQaeDuEijlmVdQyPyx9fy7wFx9kNVBuQFvQ0Vydd8wsDegDzFAORzKMJLg
AP21Dej7aVDmBOhIsjMkhpqp0kEb0DAQbJCd6hYP9+Ls4IJzU0h8TQ0hAUsw
9xNbcGCLaTrygoMvxBwuA2gSMIYEooPxlhLahyiBSwJwMjtclQOYBZ4o8TKj
vZg3wXLwgTVy0VFB+CqomeaUOO02tWofX7KPzuE04cCEo2/U0T3k6OxnqRkK
8/R5WbrsVG1moiYtRp0coUwMUcTdksf4gxCShV2Ugrf6H56EyhxcGB79PhmH
YgAwBXIHdgEjAdYgICXANszLICbgp4A1/TxQPxRM4Pg0d4K8wDQAYhrn7NYi
rigjr6pAYW5AP8iAVBRixjiIsIINxHwANsgCG6Q6s9OcOenu0SDYYXHdFMPU
FGtoCgnYgnlwXMFHBhpERQyi5ofC5shwJjXIgg5yCPwDxmK8aBIBRBm0EOON
SVlvXSUXfQd+DB9awov8HvMxfMEC+TKIOqjVJ2Q43T6ygFPv/VNszzjXNcJ1
DHCtvVxzF9fY7qxuYCtrHGXl9pJiW2G+NS/LnJNmykwypsUaUiL1iaE6qKCh
jo68pgq/rAi7JAf0Qs/LwI8BSWB0IBUozCC/AsGAi4OMvwUXRZskXRC3IvFD
GYPef0kefkURQYqZaD/4cl1sgD7uliE+yOiKf0qUHakoluUTghAGohVyMtzi
YQfO5c85++edblHhBbZgtqHyIekCNCImbzknmYQI2Y5UJbAVSmi8HIwX1EyS
OZWd2TGvsuNYB144HTmvsM4pbHMKu9es3M54z8jtM3LHNFxrDsnUmoP5zuQa
O75iocAPbwF8Q7uzrsVZ0+hkJHWtTubnNdQKFYIVsi05aWawQnocb4WEIE18
kDY+EDSxJjYAxLEqxh9qYJAykEhlkb4ga1bDL4M6XA49hwNYoRdwbjr8Ek6b
R/jipH7UNVx1AGQfc0MTexN8XgsKEoifiEhDQggoITOUlMmRgDwQkD0tDvyf
zUjkJCiIdmwGPzfTDf97cJ3HrBNM0EdNIGQIUE6MF5hCAmHBbEehLuWgYKNF
Kh1zYSQAG3MvoDYuw9UhcE3ihesdANVpvOwS4BTGa3rFOrVkmViEqBhftDN/
GFt0jC04Rsk1gheiPjzPDk5beke0/eNG3gJjbNewi+u3cXXNzpoGZ1Ut2gGs
0NDhbOwAs7DVDY7KantZua242FqYZ4GQyIaQSDRkxOozojTpUdq0GH1qtD4l
SpcSqU2O0CSFqZNCVYkhyoTbivggeXzgWsyN1ehry1HXpGAeMFLMDUXMTWVs
gCruljoeDHlbmxCsYySJIXrmAXiWcBuX0SSGGJLCTMkR5pRIS2q0NS3Wlh5n
z0hwZCaxWckcI8EsfE+WJyvkZbkz0nZ42TPt7J1xUnvQkGAkYBEvCAwJmIXZ
PrTsHF52jqxwcI2ucmN4gR3Aa5kdo8vsCFxL3MgSO7qEq4rG8HJ4jS87GJ+x
edvojGVkyjw0aR2csMP3Tjgk/fCvb5yV9I6zzM7uYWt7j7alda21Q9XRa+oa
YhH4Hq65kwLP1TRwlTXO8qoN8Euae5zMiw0d8AFHdb29otpWVmYtLrIU5Jnz
s4wFabqCJE1+kiYvVZ+bbspJM2anGrJS9FlJusxEbUaCJj1enR6rSo1UJIXI
EgJXE4LWwCAJt3EhS2IorrRJDgeLgd0MjCQ12sg8AM+SI/TkMiZHmlKizKkx
lrRYa3q8LSPRnpnkyEphs9M4ZhugzWxzxTsv2833feBl96SzZ8qJuM+CvwPs
PoA744ORsOAcXMRraAksOQwP24cXcbkWXEPgqfO42GxgDn4G/5cMzbHMPcNz
7DAmTtvAuLV/xNw3ZOodtHQP2LoGHIwEcqiko59lHmvvZ9v7uJYua2Ozrq52
rapssaZyta5O3dhsau5gEeomrqaeq6rhyiudpWXugAPektYBJ/N8UzdQkqO2
2V5dZ6uospaXmcuLDBX5uopsdXm2pixXX1pgBEMUFVqKCsyF+caCXENBjj4/
W5ebpslOUmXEytMiZWlRirQoVWq0JjVGlxarT48zZiSYMhJB22UmWZgH4Fl6
vAnySlosZBdTWpw5Pc6SnmDNSLRlJtuzUh3ZaWxOBsd452Y4vZHcfUSs83Pc
PRzXUXZNOAHy7imnBDCXgLNvQ+C9+6jLzzkH5p0SBNVrYJYbmIELvLt/mmN2
9k1xvXBN4tU3iYvn+ibZXlCIw9bufnNnj7Gjy9jeaW7rsLa025vbHU1tbFMb
JwE4mcfqmqzV1bqKkrWS3MXCtKmizLnS/NXyEnVlpammjgBdwZWWOouLPMMN
aEvah53Ms639XFO3o77NDl9YX2+urzY0lGsbitX1JZq6Ml1thbG62lJVa6us
sVVUWysqLeUV5tISQ3G+riBbnZemzEmS5ySrcpI12Sm67BSIBFwgmJthZSS5
mTbGKyfdmp1myUoh2JuAvZPMWcmWrGRrVootO9Wek+7IzWQBWx8A1wf5w5ui
XJDr5tc4atw55uwaB/YAvCUAOOMFkFNHZ7YR5PHfFOCMiE5wSAASyHfwuTGu
C65R+N1OeHgFM+Cgo73P1tZlaW03tbQYmhoNjY2mhgZLfb21tt5eU8dW13HV
tVxFpa20SFeYLc9LXcyOm0oPH8qMGs+On8tLlRZkqYvyTaUlHEBcmH8noAFn
CTb86fZhrq3f0d5tbW83tbcYOhq0HTXq9hp1W52utdHY3GxuarU1drAQAWCP
2kZrda2pssJQVqwtyVcXZSuLctRFObrCXENhrrkwz1qYD4xXWOBg7i/Is+fn
2vKzrXmZgD1YwJybgUYAE+Rm2nOzHHnZ7D35uU5v9F8vii2zGd+OUWcHwWgM
PtU5jmAD1Mw9+PAFvgD8EUZUEJDCOuEawvXC7UPO9kFn26Cztd/Z0sM2d9ob
26wNTeb6emNdjb62Ul9daayqMFWWW8rLgUkdpaVcUaEtP0ufnSzPiFlKDZ1K
vDUcd6073r8/KXA8JXQuLUqamaAGX8rL5u4KLTQMjN83zfWN2/tHrP0Dpv4e
/UCHdqBV1d+q7mvX9XYaunvMXX22zgEHfL61n23usje2WuoaTTU1+qoKbUWJ
uqJEW1FqKC8zlZdZy8sh57Jl5RA+bEmxo7jIXlRgA7wLci35OZaCXHhiA8QL
8hyF+SxzHzTQuyAPEIMn/HToto380D6C7UQv6BiBf6PO7QRhhJv8hJEAgsyB
9kGufYBr78errY9rBT7tc7b0Yk8bOti6Fkdto62m1lJdBUgaKop15YW6sgJD
CRBivrkImpdnz820ZCbqUqMg8SzF3ZyO9h2OONcTcqIl7HRHxIWBaN/xWP/5
+EBpUpgG4rAgj7srsIAqCJixBfv4jGV80jQ+qp8Y1Ez0qsZ71WMD2tEhw/CI
eWjcOjjp6Jtgu8fBJTCqWrosTa3GhkZ9Xa22rlZfW2eqrbPU1ttqG1jIAZW1
zooqZ3klIAyeYC8pAf1UXGRlthUXgdCxFxc7Skq4khJncbFze1GR06eoEFih
qMBZWOCEx81e2zbkhIuRgP8x3vAMvZGg7QPoMt7wBN6EHoFzSgBQ5gBA2tLD
tXTjBQKsqcvZ1MkrrhpQXDW28kprWam5tMhYkq8vytYWZmoLMnT5GQaS7AFh
Y2qUOiFYFuO/GHF5OvTs8O2vegIOt/jvr73xSeOtIx1BXw0Enx4PuzgfGyBN
idKAgC4u4u6AM+A2OI0gT6/Y5lct84vG+Vn9wpRmYUw1P6aam9DOThmmZ01T
89bxOdvIrH1ohoXs0TPu6Bq2dvSZ2zqNLW36ljZjc7ulud3W3OFoaucaWknG
BVVZ56ysYSuqHeWVwBagJZntUGOVVbCQHiAVl1U4S8udkCeYHQC5D2DOeIFX
bPZjRBpBhCTtDQ/bEO172giqAGoz8VJAshEuBBMURGM7x+xtaHPWt2GHaxrZ
qlpohK201FpUaC7INeVnGfLSdbmQORI1WQnazHh9erwRtGxCsCLGfyXi8lzw
mYlbx4b9D/Vc29d65cPaC38tu/Re1ZVdjdc+7vT7dCDoxETElfmEIGl6nAaU
8Vb4do5w4JojM/bJBdvcimVlzSxTGGVS3dqSZm1eKZtTSRe1q8v65VXTwop5
btkyvWSbWLSDgh9aYAem7X3j1p4hU1efsQvy8YAVGKRjgG3rRddp6uCgd7R6
qm7gqupAD1XWQJ0GeFfWctAUEJYV1dTZEegd0EYJQO1VAnC7zIL6bES5hSDK
+ODDBXjRKlzrOHcjyNBFqN4A3fpWZ32LE7Qs1BG1Tdicqlq2vBKCy1ZcCLRg
zssyZacZMpP0GXHa9Gh1WqQqJUIDGjQhWB3jLwu/vBh8evrWsTH/QwO+e7su
vt9y7s91p35bdvzn+Sd+VXz691Vn/9J0ZU/nzSODIWcmoq/PJ4XKMhM1Bbnm
zXgDffWMsKDEx2dsM4uWxVWzTG5UqQ1arU6nVOtkSq1MqZFr1Cq9QmGAH4E1
Ftcs8zLrjNQ2ueogAwT2oWnLwLh5YMLaP2EH0/WMQrnEdgwiJULYgo9hzdrq
rAXt3uQAt6pp4mivqxuc1fXU4XncvQF4xqu8AtGHC/y/wulVVr4V+sjViDC5
fFCTwv+Zc5sRJ3+exxpirKae/8MVVWxpGSQMSA/iAIYhPU6fGqUFzk0MViUE
KeMD1dH+CiiRg0/P3To24Xdo2Hdv78X328/+ufHkb6qP/bT08zfyD72UcfjV
7M9/WAzvXHi36dq+zlvHBsMuTMTenE+JlGWnaiCCXKEHXLoG2P5R+8ikbWoW
GMS8smoEiLUancmgtZnUNp3SqlVaDBqjHkyh02j1So1xTW1aVZmXlJYFhW1W
bofqdmLFNrZgGaP+P4ebEUCP8iMGQyBdOKBOhAJx4OrbuHU0WpyiDarqndT3
vcEIXmAFL3AUsELlFqwCXwgX4wUP3mBd5gvgEI9Iu353JbFvaRlbXOQozLPl
ZVnJOIUpPd4AFXFSOBS2mrhbqmh/ZdQ1AFsWfHox4Ni036Ex370DF9/vOvvn
lhO/qTv204ojbxR9+v2cfc+k7Xk0Ye8TKYdezjn2VvHpP1Rf+qDJ75POoOOD
EZcn4gPn02NleZma0lILhbypk2vvZXsH7UOjtvFJy+yceWkJSMWgVugMGq3V
oHZaVd/YFX+3KTmrymFRW80ak0mnB/ANBpXeKNeZpVrLssa6qLbNqRwzctv0
mmNS6hhfcYwukhEDHChACds9iioLxBWSAalK77uDK1KAGAlA5AVZ1gdwugPP
UKpmfOBBAl/HvEqpBAgNvrCmySWcajfQWEkxC8ozP9sGQh+EfUaCMTUGyldd
Yog2LlATc0MVeU0Zfll++9RywBezfp+OX9kzeOFv3Wf+1Hri1/XH3qo8/Hrx
J9/L3fd0xu5Hkt6/P4auEXnio53xB55LO/J63vFflp77S43vnpabR7pDzg7F
+E0lhy1mJa0V5ulaOtmuXkf/kG10zDo1ZZ6fM60uGxQyvVapNWs1DqMK8CaL
Ll79H1bxjUPptKtYm8Zm1ZqtOoNFrzMb1SaTwmiWGSw4OKyzz2twYdS03DEh
JdyzhDUw1GhQh/VMYMXQMSyoWkK96KldPPr17RvAwhE0L4CL8aoimMEFT+s8
4C/uMXbbXSnuDEXTgjm84MELbMy8XN+24e9UN/BGoTRHjQKkBvkb7EIiwUIi
wUgiQUciAThHGXlVEXZpLfjMys3Ppy9/1H/+nc5Tf2j+6pe1R39U/tmrhQee
z977ROqu78Yz92BLHtr1UNz+Z1IPv5b71c9Lzv6p+sru5huHu8AWYAWKvFKm
06m0Zp2aNam+sSnIb736L07+D1b5d4eKs6vtNo3FqjNa9HqzQWMyKuiYPMJu
p7ATl8dhHd7lp4nLA+wjvGTDVChmPIq84PR1Lev8y/gAJhKCvjvawppFlxeb
dz4S1NvRpMw2+Hbm+zSo3CgHsaYxUI6qGaQSKNP8bHs2EE8iGaaO0iWFaeNv
q2MDVNF+ighfedhF2e3TywHH5q4dGD331/ZjP6s+8kbppy/l7382c8+jyR88
GEtnqHd8+GDsvqdSwO9FfB0m1T/sChKr3/8n781qh01jtWoBUPBjFycW0JQR
AllHk4UyGDQ8VLztG/3YQ0IjaDIS8LBtxJXdcfyWe0jxEyhHWkElAogS+F7m
hXUoN3EJ1Z4AJYh7KEtzM+yZyWaAMjlCmxiqiQ9SxdxURl1XRFxZC70gu31q
iTLK5V19J3/bCETy8VNpH+1MJLusfdzQY8g6hxf+xSr+4VByuFhCpzMbaPSv
6nGaYkFjn1PhmPmUDPezjS3hiO3gHNs/w/VO44AOFGmiJ3rgAEIA26BzXgjd
JsQ23X3BI2IY+YiSD3wP8zxlXVHBiKEN7gbRXUTGGaCMz8tyZqfa0+PNKVGG
xBBNXKAq5oYi8poc8lzoeWnQyaWbR2eufzJ2Zc/Aub92HPtpFfAtxvWjHnEi
7z4HDkbXSFCKXEOQrC4g2XmQltnhRXZwgeufw0Hd7iksErGIHSIORiO2T6gF
CEvivIIP+oEXiIQN4w7fDiHyCZriGAk8eAFIgBQJfIhN6lBiVIK0LiGBCRV5
fg4OkuakOzMS7akx5qQwQ3yQBrRX5NW1sEvSkHOrQScWgQqvHRy9vHvg/Htd
J3/XeOT1EvApuit/C6Qgt4juBGApBbCWdTjfOE/BAiklZUdXueFlbnAJR717
Z3GkqmtCiMYhl4DscVLF44Pc44NZRbjWsbrbnQZEpBAYDGB48AJfYp6rJvxF
yQsjjrgSH3F5OKaZm4GD+JnJzrQ4e3KEOSHYEHtTE3lNEXZRGnx2JfD4wo0j
U8BfmDHe7Tz9dvOXP6smDpXgGSXy7nPimhsd4X6KkhRQIrOy82r7jNIxpWAn
1rhRGTe8ipMz/Qs4XNrjEnoibdG4o4TlDYEnQb9CtDbz/VY7wfGTqGgAEm+A
RIJC6Vk+0tyB4QpyubxsLjeDy07jMpO5jEQuNdqWGGaOC9RH+6sjrihCzkkB
GP/Dk1f3j1za1XfunY5Tv2/+6he1R94A/0mnq888I/PsPwX/EROj0miSAzgG
dKEFrX1O7ZhRsZMKnBsckTnXwZkl4EwI4NAMKZAS4w3woGaQoGbYWvWhO0DX
vaHrqBOZZykANIBKSvm0VpAHALC5mWx2GpuVzGYksmlxbHKkNSHYFBugi7qm
QiFxeiXg2Ow1AODD3nN/aT/1u6Yvf17z+Q/LcL3UzoQtMCDvPkO9w2LVmgQM
cNmKqyxT4/rJCQU3tobr6YZWcA4Pw2iGhBFNaqJKIDHkBYzjBYEkQVGLQHiu
NnhtJgHe8EZ9/Mw6e9DOF2Fk5OdyuVnQeUdWiiMj0ZEe70iNcSSFW+KDjNE3
tBG+ypDz0sATixAZvnsHgWQhHUFYfP5m2aGXC/Y9nf7EHfpO7U9TucmiMxAW
kRvNlEIWdLgmYlrNTirB/jhPDPYfWsKJG7A/n5fGcZjWNadjZeBNnEAcgtk8
ToYqphZ7XgNVWTVYfj0LU9cv4jkhPwdcn81KdWQmQZIB6rSnRNkTQ82xtwxR
1zVhl+RU0/h9OgGuD7oezC7KGlyi5bn3T/CW3yBktEQWygxW3vJax4yGnVJx
E0re8sPLOFu1bnnq/a6973V6QQQgAhJaRnZtMQqLVSNJqxJSk0I5+rRr2IPX
C9mVy0kHr3dkJNjTYm0pUbakCFv8bVPMTX2Er4pG/o0j00CJUNac+n3TF29V
gtX3P5O5+9Fk5sk79F3UceD7ZgvmD+r1guXtc1pcizGp4sYVaPkR0fKUFsXu
i8Hf7/TCwtC7pZeXdYjC5vkpVFxEdEmw18+J4yGlLhEPfQcBRlIml53KZiY5
0PTRtuQIa2KoNS7QGOUnmn7W79CE794hYD0o6TDiX8zd81jKBw/EkN5773ks
Sew9WYv8FORMCHkHqQeow4tl2JJodTW1OjcKVl8RrD7LJwQa8lSO4UyhRBjN
Xe/7xn5vw35X8Yqd9liCIz9Pg8FdI53qBFBUOelcVgownSMt1o42DwOysxCb
KwWbkzS4qx9c/qtf1Bz+QfH+57JAftI12l7XD7RDl0l3yQNUQt8Q5Sl6+noS
FK2t4Yi1Od7ay0hzfURaid2mzs6Pbg/wWlToPbq+Z2/nO17pxDEv5lnkN0Eg
uRoc8z/tezKbnuBIjbUnR0Kms8bfNsfc0EVcUYacXQ38av7G4alrJNOd+SOE
e/Xh14og1kEC8H2/+Xl3Z68Dn5LXT9GO29Y7ThIczf7YcQft+Dq/Lwv8Ltp7
Yl1+Y9/J7LAPxjshvJZeT/OwFd+iz/m0z5lOktpJn2Nony18n9Heq4K9R0SK
Q3sDv+0U+hxwtAf6bDeoqL2fvpO99dTeQreV62mNujmf2qc2dJvZ2O8+z/3+
vmu/+ch27XcRTpoUbO53vNDvUNd+e/bzA89l4frbLfpNWO2Ofk76TcNbTkh9
xUlVcZ9YRbgQG53J8RIdnaGe3uLJ073EKGcot23ofonQfRrjYveTxO5b17t/
RelK7aB2z/y5DRTd4ddLDjyfDdW6595TZmOF3otS14XTgdy4KaH3mNBp7xeE
QL9D71vE3nuMc/fePy9Wix56n0WFvth7yuzY+2iX3kM9dP3gGPT+LPT+l6Bn
Sw++mLPn8RQcqXvKIwL/pAgIGf1bIbD6/yICGzgeEEgVEIi+EwJXdg+c/Uv7
8V/VYXr7Xt7eJ1JxtGZLBL62C9mNIKDwgADrjsAyn9q3QmC7iAA/Dbwp9rdv
znGY4iTQd+bpO/bevqH3/rT3q669B1F74jcNR39UDroOSuIPvxPnufcv/YPF
gVa7kNvder94h94v4vK89cJY6H2bMJawufPufa/+j/qe5sxK4TISWD7Bh/MJ
PvKqKvS8LOjkYsAXM36fjmNF9yFw/gb339R3onRe/p+Nvi+kOrNMT4dPoJxz
zGpA1NE071ynfer+/2H3v23/n9ncf4j9nHRcuZ2ZxKXHswL3W4mmV4ddXANh
d+vLuRufTwMEoO0uvt9z+u0WqGmQ/p/P2rUz4UmPCIiZ3kRKfZWg7ID9V8D6
WizmBOs7N1hfJIBNZe23ROBlj95P5Z0HADJ5ALJSnFDPp8U5oKhJCrdhReev
Cb8sDzm7Aj6AGBzBISEIgfPv4pAQyvtXCj9+Mo1xR4Co+ufpXiy7TQuSXu8y
JEQQsC5pSUkPIFBhT0CAqn5ICIF1FnQd+BBAYDbkf08oeLuiQHTPC1uikC2g
gJGAa8nTEzioa5Mj7VDXx9yEulYRdlHGA3Fszv+zyav7hiEYCBfUAxeA0N/1
UPwTHnEAT3C4kACUNnKhslvmPcGOS8FVLPKAAjdpDNNYEMSfyIV8jft/AAcX
HSQwAo58ZSQ60+K4lGgHEGLsLT04BKghCAoQvzhGiKOpOI0FQUF5AYICMoI7
DnTPIfUHnhBcppx4PiQ40CGeKeIPo8QfhgVaWGdFURiNC2NhBAo3RbgZCR9X
JOisNxDDi65QbKj3KDmm42JehIJ4RVosR/jR5IpGsFgK8KOBXUARx96qhAyx
7+l0rAbwzsPMvaAVDjyX9sVPCqEMpujIpXq9Sms3qL+xKchnXsZ5IjJDBz5j
8jhKSOpCGjhTKjIcokCshmVfY+ysbCIQl5pBxEqsl+6kITZ7zksbPEesljxR
CQRRRoIzPZ5LjXa4IhZ5FRHDOVBSLV/9eAhHyf7agaSKwyUlB1/MBRf68MHY
+7ENOz/aGX/opazjvyy9+H7DzSPd4ZfGkkIXctKU5RWW+lZnezfbP2Qbm7DM
zZmkKwaNUmfRq7+2Kh/4Nz8/9LWQhVwH1GgiEmtsAUtOxHJk7Wv0uy2oCEvu
/5SN3hBHG7ak5bvCmUhoKdaB6jzEFBeoj7mhibymDL0gDTq5EPAFJKhR370D
l3f1AaIX3us+9QcckQaZfvCFnD2PpTD3YTse3v9M6tEfFZz9U/W1/W3BpwZj
b85kxMuLiyzV9Thr09zt7B5ihybsU3OWpRWTQmEw6HUOqwZ3XN9LVI2o68XU
pjYZ1UYT7nDUm2U6sr9LYxM5bZKOViKmuAPtP4KVoLrNNdNtGs34IR2/+i+h
TcPYdmE6SH3WxDBTfJA+5qYm0lceen456MTczc8n/A+N+X2KewCh2AcRcP69
rlO/bzpGRcBzWTi2R+6H+8juRxI+eyX7xK/LLu9qvvXFQNTVmZRIeX6OGZpF
AW7qxhWhfRPs2Jx9bsUiVZg0II2tOgh48g0/Eqtlgi+fOBW4iQsowLymM8u0
5hWNdUltm1fh/OaUAjdnjMs5SBt0UJxmDsqYd4V4s5igc6CbR0npvDojwRFS
H7GwdlVXL20JNdVYoi8nO0mZYU0KNyXcBi9WRVyRhpxdvH1qDtAOPD4HWgMk
JyhuSLSQXc6/24ly4yc4mvjxU+mguD94IIbMiT0JTz58CLfEghQ79tOy8+80
+x/qDzs/kxC8lp1qhsa4Ag/dBQCG5tipFfuSwqLQmSAjgz7H+5445HSm6A06
T0+Fu9kFfyrdVol2WdbgreuWVNZ5pW1WYZ+S4w1ox2QcVvAC/gMC/uv5+9uZ
gK5m8aI28JDLxSUOd7DEts2WkOCGiE9Ee2SvSz4oea3JEeD02mh/eeRVWcQV
WfhlGegdIBaofYLPLN8+tRT41QKwNSl/SPH3ZukRuuX1taLPXi2EJ0feLD36
4/Jjb1Wdfrvp6r7+2ydnYm+upceb83M5j2bom3WOrbBzCrtUZwGE8SYPBpVN
I3fo5JxBzplx77QDd/NS5cQXj1JBNoF8BMWwQGbM5pR4Ez9+oZaMHZVyIy5W
WDfBLKADdmAe+DaWaBYs4c1PbHc5PdqCmgPnDpht4gS+aA5ije3r1ijgDYIr
zSW45nyfm0UykxxpsRAYhoRgLVgkLlAbewu3gUHmhHIEKrKIK4rwS0BMsltf
zV//ZAyoHsTXhb91g+g4/04nbjF+t5NsLu4DY/l+PAx5IdJ3LTnSlJ3O3cEW
ABcwCeRDvJuARq9aU6uX5NoVuV4q18uVOrVGp9dBFUe1CIhXHLnTYvKcJ3tV
geshhU4r8W4mk2u4MWxilUzzbrYCGAB3gzD3dU/x2mQrQ1Bt4iMO4FNDMHQe
626rhzByxDlOH35+TzAXc0d7eVF74WpfCa6x/ko0W37uBlIDk2UmO9LjrWAy
CKKUaCuk5uQIKw6Rh5jjb0OONsYGAMHpoq5rQDIHn3bfjUn23S8H495LvGsO
yEkQShkJ3F2NBXUC3s5OYVlYMSzOaZYmFCsTcumUXDqrXF1Ur67qVuTGZbVl
Wai0Z7DYxmoTZQ4ZaYWUMUYmmUfQTNzwEueBr1xNNM7PMG02lKudmtzs5D7f
uHHdkfu93yXCDEU1XTlKbXaX+Lofs7yQ6FHEF/Gx5moxCW6G/JCv9l3KG9T0
cSyZyiMDP2FmstHSlBhiTAg2gBKID9TF3dLGBuCtqiFbJYXizYxSo21psbgD
/NvYalThHJFyowvWsSnj2Ih2vE852b023bs2PaiYGlVPTeomZ40Ti5aJVTu5
MQqO/qNx5FgJjmBW/3pDPbjA7xd0t9K4k+xP8RZ3T7TjDMEQ2MBzRNHlpYKl
yErHu65u8ng3tftEe7marNJlmTcdg/SiNiNZap0bXQ0nWA24EQhyDzzDuBMK
MkG34TRcVrI9I9FGQs+cEW/OSjJnJ5uyk4xZiYbMBH1mnC4jFhfOwzs5qea8
dFt+liM/i83Fqay7G6x/geuZdnSN2boHTD1dut4WVV/92kDj2kCror9T3d+r
6xs09o5a+iZtg3McbhNc4oaWuMFFssF8UwSJm+BcTbUeSrydBp3em+pXTD90
7pbfPSAE1F3XVLmfpiHeHe5eunh1K0NtFyo9nzKXCSJkQi9kwo/gGViLxtu6
zfIBTzYv25GbactJt+ZlWguyLUV5lpICS2mhubTAVJJvLM4zFOfq4Qm8U15i
rSh3VJSzZSVscSFXmMvlZd3JIj1TXOeoo23A3txtbWgzNzbom6rUzSVrraVr
rZWKllp1S6OuudXQ3Glu67N3DuNCSdznhlsInT2TOILmOjtOd8EA8vCS7ptz
/ZFQdXivzyz1Ab/xHLfdNXKEHR3UJuuzy55O1PG02kYirM30cbMDg/PwSHbM
B+t0Jy7iIvDDc3gHKh34gLgCk0zacyUluPS7qMBWUmwrK7VVlFurKq01Nda6
Omt9g6W+zlxXa6qtMdbVmRsarU3N9sYWtr6Rrallq6rY8nL4da6owLMpOka4
1n5HU5e9vtVa02CurDaVlRnKCzQVWfKqzLWqHEVlgbqyRFtZaaips9Q325s6
cDdIWx/XPkg2ww26LIUT1NUDiHA/vgs/4zcouS2Zo3GA0DM+ogrg13Js8xgN
dz5ZxtvNDl7iGlnRDsw2XKWPT7a7rm8FvPGxiq+C3oYPQBTBr7usP+ZwU1GV
o6rGXlNvr2u0NwAOrbaWDltbl62jx9rZZ+3stXR0mzt7rd0D9q4BR0evo7WL
bW5nG5rZ2gaytbKKKyvj3PBv6eMaOx11LfbqemtFlbm01FRUYMjP1uWkaXMT
FPmxa/kJirwUVX6mtijPUFpsqaiww1fVNOBW7oY2rqmTaxL8tYFfI3YfPMF3
uvBPoMTqRbxdF8My9yD7+DR5RB2XU23I7Fvd188Fax8KuLgS/B66HFx8TfL8
XsSVvK4W0K1txlV/0GiXhblsQxvb1MG2dDvaeh0d/Y6uQXvPiL1vzD4wYRua
sg3P2IanrSOztuFZx+CUo2/c0TPMduIeJbalCzde19M97rXrMDd0cLXNjqo6
3OdWUmIuzDflZRmyU3UZCdrUaHVymDIlSJYSIk+JUKXHarOSjbkZloJcO+5h
K8VNxZXVHLS5pkHYdEAb34gv19vfTu5i0Ilo0sWgzHZ4tQ3LCy9+4bHrGvet
16vVUES3wQOu29uBL56hb9I/i7DRv9yyDh7+5W7e0hCEbQPkWJsRrmcMd7Tg
IRuz7MgCrvnFkyykuGZTAiUu84spqWN8GW/gAB/ox73YZPMRuWUA+FZDG/4h
QLGmCRB1lFXgnRkK8sy5maasFEN6vC4lSpsYqo4PVMb4K6Aeibomj72pSrit
Sw43psVYMpPskNYhv0Pa57e1lq5HG8QauEUVcYr1rpF+4ZJqgiiDqx8fwLWi
d0GNrgKV1CBqDc7t8MIbvo2sVN4nArXZUIAVBAblKAIXtw7XvAtc9IQNNdan
UKvy47Y6y7LKuii3zkmt08vWyfn1Ox71Ddl7+u1l5ebMxLW06JXksMWEoPnY
G3NRV2fCL06HnJkMOj4ecHTM/9DItf1DUO5BJR56fjXiijzaTwWqNDHEkBKJ
t0RIjwcMLdmpFnDJvGwL5AAUWgTACgpgrUs8EZeknWV2QF+9AMN7+NWjd8cO
V9AifoQ46Xcx23GVNq5jriMXWbnNeMNXU9WCqw+RST5CJPsEJEkWhrwCyRoC
FI/emLNPLNqnlm0zq7Y5mW1BgWMsKxq8pQ7U/nqzgRw7g1NKFqsOB3RNeq3e
oFIb5AqDTGZYWTEuLRj7Bm2AZ+SV8RuHu64faPPd3Xzxbw3n/lJz6veVx39Z
euyt4s/fLPrs1YIjr5ec+kPz5d0D5C6es7dPLYaeX4m4IovG22Ir4gMVCcHK
JIj4SGVWsr4gD/yZ5ZPu3XxyG8DqVY//2kgMI7peHtfkuiO7ncArRizjw38T
XdEL7khDl6r4x1vFtDnMaxkQO33T3OAsOzqHuzpnlqxzK9YFqWVJbllRWqRq
HD5UGPAe3iaLDoD8h0NJGfqhf7Hyf5LdKU6bymFWWw3q1SWDiOSp31V89mrO
Jy9m7Hsmdc9jibseiiO/9dxHOxMOvVzw1S9qzv21w/dj8M/RG0cm8WyKU/Mh
Z+fDLsxHXJ6PujofHyRNi9XkZpgLcm3FRTyMonPi6sNNzikBEHaQtfF1ZNME
ArDjLhg2oQkoht4i3/LevQ1Z4Slww2Yhjtuo1qAykGzn75129s9yQwvc6BI7
uWyfXbEuSs3La+ZVBd64T64xKfVGtRHvZWazagEqMp6+jTWp3KAi4+TPf/Bg
7P5nM4+8UXLiNw14s+ddfVc/HvT7ZOTGZyM3Px+5dWwk9NxUjP9ScrgyM8mQ
ky5gI0o7j14mOBpZ77+NxBzPWegtpK+td8KolmKEOwW8CE6uqZVWFo0dQqXh
TR5oxAJguEMf68uHIWLpfVRAmg/OY/EzusJOSB0zMjtw3KrCLFcalWq8oaTW
YIAQNVt1nF2Nt0q8fwvEyPtPffRw4sEXc4/+uAJvLow3Key89GHnlY86/T7t
DzoxHnEF/EiWFqOlcOXn2IoK2RIBrs3eRBUdH5qE8ZG1mtA3SJ9plN1Tdze8
hN0VCBWzTeRNmnXAoXxwdTVy2+OYIsi29c5RdCfxRjNQDg4t4i18xqXkuDiF
Y0FlW1Fb1jQmlc6o0+uNRp3ZjEdp/B3i8cEtMCLvP7n38VSIuGM/qzr+67qT
v6s7/07L1Y97Ao6CM83E+K8khakQoERDTpoAkFgtbEymZAyMaC8adWI9QhmI
ItSCDNRC9qkQPr8DTgRPxgfB2kF1B03OVGHijQR6nNtQUD7OB+AQz/1QEEOh
3DeP6/2Gl7kxKbndNX/wmH1FZ6PH5uhMeBd2iDvwJPH+pR5QIu8/DbG375mM
wz8o+vJnlWf+2Hh5V6ffocGgk5MRvovxQXJAKTVam5FgyE4z52XbigpYqHY2
e5IIVBWPFfEob1dttc5Sd0MGP+lN0OF1S9s6NFRdbENOf5SyOYQZRtg0DiMM
AC5LePenCRneBnxGxZ8sRnOiRjiRirVp8MSKh7bAhZwe+vjeJ1I//2HZid/U
nX+37eq+voAvxkLPz8X4S+MD5UmhAiip5rwsWyEFZbP3CLWPlxhozGZctgvM
tHkGY4O3wMO9tRvFPa9PBZngg7X4I6C5OmhM0YBawKEwDCg8f5E/p2ZRyx8F
h95C7hFqs2m/tqu+uwUiZLb92QPPZX35s+ozf2y+vKvb/9Dw7ZPTEVeWov2k
cYHyxFAViNaMeAGRfJYOfmzwFBdceK4meYzEEhFKFBASUt6CRvK8Wo/uZKVK
aodHvQ5Y4FAeGdN7xDV8gGEGlnBedVSKbjK95gDJTg/uWdXzx7xB2rIQIv4H
q7wjJo9C9Hz6Uj6krfPvdlzdNxDwxUToOcjkBBZyrhPAkh5vyEoBdY+wFBU5
XX2FrqrY7hZHHnARMpGEj6Q7RJGLqiQo3usq/fn6VYAIR9Lw1jGPuEURvQnq
mAzvuT6jsM8rbUtqPNeInhSmNYMm0hMOVv2LkxOEtm9GCKQPXcuB5xqBhDzz
x9bLu3r9D40GnZgJOTcffnkp6ro0LoCgFKlNjzNkJSNKBXlsUSGWNRKAibmX
ulDpFgodMfJBHvbhKzgSIR7iiEfFGx8eqG1xeqQWxIUKRSJ4yM11IIeT/CTG
Et6mfM05IeemFSytX5Y1eGaZ3GChrmMlzIs5nCBzz9dWpUGtcQXn3F9rD7+W
88EDMTw+Hz+V/sVPKs+/23V131DAF5OIz9n58EuIT2yAPCFYlRwh4JNhK8hF
fMCRJHiflXt5X9oCH7J7z7tGyOxCXiclnOfIIpuime348Pxm5sV0ROERxSBR
OK6BNbL29ZjCOankZlTsPASWxoZnzJGDy8BzzBY8sfMbyN4EnXu/sSlMWs3a
qn5mxkQBir0xffNI95k/Vn36UhbZf/vcwRdyjv+y7vJH/X6Hxm4enQw8PhNy
huBzTYrnlRF88EzMJHMOwQdv8kNcaD3WtsAHqdibFmp3QqSV3tmSeM8LW/Ev
LXiBa1DTjPMUTONpkMTTqPzrcZVzSs3h4ataxzI9BZecTWggbuMkbkNPA4Yq
w2ZQq9Z0C/PGkVFrR4+josqaES+LuDx2bX/b8V+V7n8mdSdfWSQefq3o9Nst
V/cN+x0av3l0KvD4bMjZhfBLyx4Bys/l3AHanM1FXUg8yMfVgzxFV6tYgzEv
uok+N76hlSwdTBYhWo+sjRAtCSeV0ESFuZscJUnjBk+mxTMcVvWjY5biIkPA
0Z6zf64+9Eo22cv9HOarn9dcfL8H79zNF64LeBwXPcktUJUUqk2NNmQkmLNT
bXlZHM6g/G/EBcdV6S72ety7DMi8QEXenWGhIeVOOPKvx5TOSRWH5+CCpNGu
HzJFydhByJjuYTdrNRSP6wfbdz+SQM8PRw4+/HoJeMnl3f30TvJBJxZCzi6H
X5LiAFOAKiFYmxxhSIs1ZybbcjK4/BwcXSJzuvfdFRDm2yPSJlaarUQtMy9u
ZhlXEkaWGeWB6RZRWSI3/19zR4WmKCQaEx5zB6rGaSenoT68CRnci0CQef7g
C9ngJ+f+0o7sS2Dhb63vK4/250+PTo02ZyTYstPY3EwnRYZy8JbI1Lgj4+3x
jghiBFFQyDCQBOvS+9dR2UQxyL2EfmmNKdLvoBv9ElQWSWUgKmB6AiqVNlug
Qt59bM9jyeAvJ35dDwX59U9GRVTCyYEDsQHahGBDcqQ5Lc6WmczmpDv5AcmC
dVRI/t5xp5rz2+OyHR/u2Ypzyd3v8D5tj9KxHZQypFDiE5KMR2SanCdCj8eh
1Ksm1GshQ2WYk+6AyCPgJ0d/VA4F9yVQMYcnN5y/cFMbH2RICjOnRtsyEtms
FCdFpCAX984Uu+Tqu1Thd0GERBC5xwhcZKf/PVvxLNn7hcA8Tn1FLApEhYe3
Vlc4Jwgss+S8B5FuRQ1MeQWrpZ0ekSHvPgK+8ulLecd+WnXmT62+e0EFz7gh
Q+8DnxbH4q3HU3E5SF42zl1DEBFk7uOR2RqcbxNHiA7yK7m8hN392zGMNiFE
d8c82Sbc5o+CRJm3byPzjiucU6oN0SQTEhKIGbtwdO8WCBGV8yQ9D/qz1wqP
/7L2/Dsd1w4MBx6f34xQaiybnsBlJuOqC8o0BflOsWagCNFVa9v/a5S8RJQY
4S4IjI8bATO4M5bcoq9tkI8x0Ze6XHl4mR7C8jUPkwvprKIiNmuMRoNZb7Vg
fNEDmEDX8CvM3ZF6SOAdPGTpezmfv1l68rcNFz/oBtEXfHrJ3ZcIUvRcDREs
Oh1CeOc+vm7YWH3+P8BqGwXMhYHIyPLzdGRZjLl2YaiU0pCoiwdXPCOFcx96
i9Jg0poMJrPOYtHahIM1kaG/4xEp8u6T+5/NhKjDA9Z+XP7lz6tPv918eXff
zc8nQ8+vboUUxl46LtanVC26FfWpeyhUrgMYG9HiK9IN44Qe1lcwHu7K4jq3
zCNK7jFxD52k5C8XdMWxe88Ii/BS9UgRHnJDGOoPjX1Fa13Tm9UGo9ZocDvK
D6iNjiFuQpisiX9q13fj8Qi7N0rwcBg80Igfa726bxDUZPjlta1Azk7HvVI0
AfA4l5I1PKTe38Ej7DZ0dndd+R/c68YFYx9yX7YNM9d0SpPeEnKAVHQCtJ3i
2JErtMvkNA4BWsiksyrHosYm1VoAWoWBPyjR9UhRUBh4kuj9HtEl7z6z94lU
PHfnp1UgMk7/sQXKXzz/EA++GPH/bDzo5ELUNeUGdJNcXJigi/xIkog4oELw
9XbF19MInPfGqvg/xXdDniHo3scP3HZviTHNN8+0DfFpho62uILM0EPQZELK
UbLkwEZyhD2pn11O2uRxhtzzT1ZJ7pl2z9+tSqterVVqAWn4KkD6q5+XfvK9
7A8fiqP3Ynv+wPPZ9KhiPMn5vS7+sDo8c3sGkhGea39RGnND44o3fFE2xTtz
HW8qfqnmLS3n+ZVftUYHzcm6HFyd4L0+W1Xv9HFhj3Wfdl0J4eMR7zDxs3e/
f1jit7RjoshUwv19ksg7uZsemf/1fwMC3ciQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->24885224]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29700],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRangePadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangePadding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImagePadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImagePadding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageMargins"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24234]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->69215856],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->128196298],

Cell[TextData[ButtonBox["Plotting and Image Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingAndImageRegions"]], "MoreAbout",
 CellID->152994815],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->552437504]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PlotRangeClipping - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 10, 0.1817938}", "context" -> "System`", 
    "keywords" -> {
     "clipping of display area", "clipping of graphics", "graphics clipping", 
      "cutting of graphics"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PlotRangeClipping is an option for graphics functions that specifies \
whether graphics objects should be clipped at the edge of the region defined \
by PlotRange, or should be allowed to extend to the actual edge of the image. \
", "synonyms" -> {"plot range clipping"}, "title" -> "PlotRangeClipping", 
    "type" -> "Symbol", "uri" -> "ref/PlotRangeClipping"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8347, 267, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->76475405]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 72961, 1493}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1918, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2541, 70, 1582, 37, 70, "ObjectNameGrid"],
Cell[4126, 109, 748, 20, 70, "Usage",
 CellID->20531]
}, Open  ]],
Cell[CellGroupData[{
Cell[4911, 134, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5389, 151, 653, 20, 70, "Notes",
 CellID->7239],
Cell[6045, 173, 706, 26, 70, "Notes",
 CellID->8339],
Cell[6754, 201, 686, 25, 70, "Notes",
 CellID->20552],
Cell[7443, 228, 727, 28, 70, "Notes",
 CellID->26830],
Cell[8173, 258, 137, 4, 70, "Notes",
 CellID->20474]
}, Closed]],
Cell[CellGroupData[{
Cell[8347, 267, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->76475405],
Cell[CellGroupData[{
Cell[8731, 281, 147, 5, 70, "ExampleSection",
 CellID->85533738],
Cell[8881, 288, 220, 8, 70, "ExampleText",
 CellID->6923],
Cell[CellGroupData[{
Cell[9126, 300, 438, 13, 47, "Input",
 CellID->17399],
Cell[9567, 315, 329, 11, 175, "Output",
 CellID->289400975]
}, Open  ]],
Cell[CellGroupData[{
Cell[9933, 331, 765, 25, 47, "Input",
 CellID->148611795],
Cell[10701, 358, 32020, 529, 170, "Output",
 Evaluatable->False,
 CellID->23776124]
}, Open  ]],
Cell[42736, 890, 119, 3, 70, "ExampleDelimiter",
 CellID->485],
Cell[42858, 895, 210, 8, 70, "ExampleText",
 CellID->19634],
Cell[CellGroupData[{
Cell[43093, 907, 437, 13, 70, "Input",
 CellID->25455],
Cell[43533, 922, 348, 12, 175, "Output",
 CellID->653078153]
}, Open  ]],
Cell[CellGroupData[{
Cell[43918, 939, 764, 25, 47, "Input",
 CellID->375449886],
Cell[44685, 966, 24700, 409, 170, "Output",
 Evaluatable->False,
 CellID->24885224]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69446, 1382, 311, 9, 70, "SeeAlsoSection",
 CellID->29700],
Cell[69760, 1393, 975, 35, 70, "SeeAlso",
 CellID->24234]
}, Open  ]],
Cell[CellGroupData[{
Cell[70772, 1433, 318, 9, 70, "MoreAboutSection",
 CellID->69215856],
Cell[71093, 1444, 153, 3, 70, "MoreAbout",
 CellID->128196298],
Cell[71249, 1449, 161, 3, 70, "MoreAbout",
 CellID->152994815],
Cell[71413, 1454, 197, 4, 70, "MoreAbout",
 CellID->552437504]
}, Open  ]],
Cell[71625, 1461, 27, 0, 70, "History"],
Cell[71655, 1463, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

