(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40243,       1234]
NotebookOptionsPosition[     34188,       1031]
NotebookOutlinePosition[     35565,       1069]
CellTagsIndexPosition[     35479,       1064]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotRange" :> Documentation`HelpLookup["paclet:ref/PlotRange"],
           "ImagePadding" :> 
          Documentation`HelpLookup["paclet:ref/ImagePadding"], "ImageMargins" :> 
          Documentation`HelpLookup["paclet:ref/ImageMargins"], 
          "PlotRangeClipping" :> 
          Documentation`HelpLookup["paclet:ref/PlotRangeClipping"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PlotRange\"\>", 
       2->"\<\"ImagePadding\"\>", 3->"\<\"ImageMargins\"\>", 
       4->"\<\"PlotRangeClipping\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Coordinates" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsCoordinates"], 
          "Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "Plotting and Image Regions" :> 
          Documentation`HelpLookup["paclet:guide/PlottingAndImageRegions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Coordinates\"\>", 
       2->"\<\"Graphics Shape & Size\"\>", 
       3->"\<\"Plotting and Image Regions\"\>", 
       4->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PlotRangePadding", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PlotRangePadding",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions that specifies how \
much further axes etc. should extend beyond the range of coordinates \
specified by ",
     Cell[BoxData[
      ButtonBox["PlotRange",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27518]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 " can be used for both two\[Hyphen] and three\[Hyphen]dimensional graphics. \
"
}], "Notes",
 CellID->28262],

Cell["The settings can be of the following forms: ", "Notes",
 CellID->27944],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["p", "TI"], Cell[
    "the same padding in all directions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["y", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "different padding in different directions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["p", "TI"], 
         StyleBox["xL", "TI"]], ",", 
        SubscriptBox[
         StyleBox["p", "TI"], 
         StyleBox["xR", "TI"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "different padding on left and right, etc. ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->21726],

Cell["For each direction the following forms can be used: ", "Notes",
 CellID->17015],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "an automatic amount of padding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["s", "TI"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " coordinate units "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "a fraction ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " of the plot "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no padding ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->22893],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " includes all points in a plot, then ",
 Cell[BoxData[
  RowBox[{"PlotRangePadding", "->", 
   RowBox[{
    ButtonBox["Scaled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Scaled"], "[", 
    StyleBox["s", "TI"], "]"}]}]], "InlineFormula"],
 " yields a plot that covers a fraction ",
 Cell[BoxData[
  RowBox[{"1", "-", "2", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 " of the whole plotting area. "
}], "Notes",
 CellID->19323],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PlotRangePadding", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " adds a total of 4% for ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " settings ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Full",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Full"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". For explicit settings, it adds no padding. "
}], "Notes",
 CellID->3569],

Cell[TextData[{
 "Any padding specified by ",
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 " is added outside padding specified by ",
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->184550763]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->429181163],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->87756344],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", "%"}], TraditionalForm]], "InlineMath"],
 " of padding is added to the plot range in each direction:"
}], "ExampleText",
 CellID->471321252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184858516],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], RectangleBox[{0, 0}]},
  Frame->True]], "Output",
 ImageSize->{154, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->317352220]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->419329616],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->46710449,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmPtOE0EUxqe73d5oC20ptFzKHUQE0oCIVbzFYLwg6BsQbAKJBoP877Po
I/k+G505M92ZfjOLW5Hopgzd6fl935mzt9k5OL487X46vjw7OZ59cXH8+fTs
5Mvs/vkF7/JTjLEP/O9jg/HvP/k3+nsWhiHzu91uSBubEQ17zNuAd87S3h5v
Pb7nq/+yt8Nbv9fLpXoqvFUquwbn8wDvfP2rHbVjqvOoQESlxe+MycAWxW0p
P0+pZUWcSDL8dhGFsmmKbYNmwYgVHzN2E2KLIjbDv4D0FEXfgSzKlG0UzT8e
VLRJ3G1wqQgua3J6DJNErIBTjaqn8/JE42tqgqgl8BkDypcNITq7BaAaTkp7
SWoWMpwAKg1Ug6gWeE0DFUCG40RNgteMk9JekmqC1zxQGfAaI2ocqEUnpb0k
NQoZLgOVBapOVBW8VoHKQYajRI0oque15qS0l6RKRobCazO6HuUJiFSNqCHI
sJ2IykOGW0DlgaoSlVMUjZjJbQfGVoCKVCKyd9UJatdJab9k1BBQI4moImQ4
3E/xQAG4Ke0lqSx43Qeq1KNUSHkwSnklo8pAlRJRw1CN4gCU9kpGjQA1RHEZ
oDpAVSDDwgCU9kpGVeF45QejlJebegDXGFK5RFQNqkE15/fXfuohZFiDcQ1I
qQxvkhqFcWVunNLVuA6VBmrv71Kqhv8fVYfKB9egfKAeOSldw39PmeOSc4z+
GrqpjjGrlNv3H6Hc1b5XKtwz5rNyC4TEFVcEHRFGs950N5r1MrZtKeVBCe80
hpKRURsqIeYHJVDCu6pbacPKqEo6+t5XSaSzZunUIZ9kOrcsnSbo4PPMrbPo
qNA0KOHz1K00Z2U0Dzo4B5A6dDKZB5+1LKVlp5I++mrKl9Y9jE1ZKqt/oNK0
VNZBBWdRLpW6o8pt0Ckm0Kla2eyACs46XSrDlkoHVHDG21MxD1PRUnkEVwTO
05WKcc7kHXV56sxF5+9ZKhkrk33QyP9Ww7c0XoFGDo6P11cTRpsQfAtc1skJ
7D3UK+N2CKKqK5934IDvlL3Ryd2oR0RwUsCHoIBvwJ51f6d8eMARkPierkYX
6jc40xdrk4bjkiI6Yz0PjqBSuBIhOZrLWdU6BNaDKks2F5PxG8jYTRcclToQ
ZMwqjaSGYjxfi8axiiSpklUdcgrUoxo8ys6a0KjSKjFDezgmo5cUH406iq84
xm1eNzqPaozyc94IYRGVinRHrTE+UXHizPKjuHqM6q4RLWTkk2bcUr0LcfIt
p+EY1YYRKcop3ymbMf4roCtXDCYt/0UV5ytVua4zFaM6yZtARQsZuWrXslQb
4C7XQGdCe32kCv7z9NOcpVgE5xXqnrfisuC8Rt0LjvHQ3dJw3qTIJUNRnsw9
x236fZm3Gb63K+1SvwDIs5LX\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->571103222],

Cell["No padding added:", "ExampleText",
 CellID->726623739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->531124329],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], RectangleBox[{0, 0}]},
  Frame->True,
  PlotRangePadding->None]], "Output",
 ImageSize->{154, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->239513332]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", "]"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46564708],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}],
  PlotRangePadding->None]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->81247604,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztmOtOE0EYhrd7amnpkZYWqKWAFcQK4RCsEEo0QWIMnr2ABptAosEg/70W
vSTvp9E5vN2Wd1c6KCTGSOhkd77n+Wb2PDOHnfPj7sfO+clRp35w1vl0fHL0
uf7k9ExUOTHLst6L34eKJbZ/iC31e9Tr9SxHbHW7XblZl4W1J0pP1Oi9XVHa
Ys85vf/FDmq3RemIPU/UWnKj9/VMlNasirbgJCKjW4gmZdTVUQ3UVHwDucdl
3AviyHFLMWvIkb2EWRk6OllbiGSrim2izeJQj8W/ZcvC0adHglOKXkbrZSN6
EbmniHaIrii6gdxVI3oBdI1ol+iyouvoSZ1oj+hJRdeQe8GInkHuBtE+0SVF
TyH3khFdBr1MdJzooqKL6EmT6ATRE4ouIPeqEZ0DvUb0GNEFRafRkw2ik0Tn
FZ1C7i0jegx0i+gU0TlFJ9SzIGoFLYWHI9ows7itrJE1TlbmBq00WWllxcna
vhYrQ9a4kZUlK3WDVo6spJGVJ2tMWT5ZO9diFchK3KA1QVbcyCqS5f+B5ZG1
O6KHZha35f23QpZLVvtarBJZ7j9tOWTt/fVWG2PYCtFOJC2fYblrf/veu6yt
aLsF2yeb7yxt22RvwU6SzW+EaHtdFHJgnSGb35PR9iraLvyW3YQ9STZ/D6Lt
u7CnR9h2pN3AcdfI5u+ettEFOT2wbqPdBTL5Oztk6matOZiLZPJoIGzWYC5f
2ZyWhRvMbMTfCuXgEUw4Rxnnap1MHmeFzSL6/WCEGQuZeZg7ZPI4sm8OrmwG
ZvvKZhLH+ZhMHvGGzTjaPCCTx/ph04X5jEyeU8B0AxPeC/J4nqM9qb02IlWN
ICX8NsKIiV1JXrxi8rl4R7QfooP3HvK/IcMLGfLdLN/C3BM3RPqU+9VIIz7C
cEJGAr3hM2mHyCTlfnmJMZjNqR54AdXTqw6aSVNGdd0vrIhoLkPc819wWbQ5
fP8MWstTlkNR2IHbnwfL3IOjKJLzVBROEC3B2Re1sjv6q1smp42oHpVXKNoS
hTw9erbUXxfYhKPnujPkNOHo1YEqnCU4as0H979e96iRPwdSrzfNwq8i67yq
nSOnBGdRRecpmkP0nor2V2VSyLiqahvkuHA2VfSOKH2x19LPYOwnT/6AAg==
\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->410336149],

Cell[TextData[{
 "Include ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " coordinate unit of padding on all sides:"
}], "ExampleText",
 CellID->180294061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", "1"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->429680998],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], RectangleBox[{0, 0}]},
  Frame->True,
  PlotRangePadding->1]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->325243355]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", "]"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->321455261],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}],
  PlotRangePadding->1]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->346210103,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztmd1uG0UUxzfejzh2EicOaRKSOG5LKJSGUgptqYSQuIArHiIqlloJVBR6
z7OUR+J9VjDnzNn17G+GeusrLoiUjc/Omf//zJyPGZ/8dP3m5eLX6zevXlzP
f7y5/u3lqxe/z394feNe5RtZlv3sfn85ztznv90n/f2+russXywWtf5kF/LI
vnPP0r2cq/Stew6clNtf//a5e8rEMkBwT0N4ZrrD5OgTGx2JVLTs7sNMxx8b
9rZIZTtuGOeq88gwJu/QeWg606TOmeo8MK4PsBMDyCeqfd8Qj3pp3zPsE4zm
kI9V+9Kwz3pp3zXtGUYLyGppNjdL5hgtId9S7Zlh3+2lfWrYlxitIB+q9olh
f9JL+8i072N0E7J6T5/y8gFGh5APVHtq2A97ae+Z9iOMbkHWWMt2zJLHGB1B
3lftsWE/6aW9ZdrPMDqGvKfaQ9N+vgJ7qR3m6zcrOCbLWZ08pm3bkHeX86K8
fNp/7jsy8CvIOyk5iiNmD/3XD4V58mVqBVxhhMKMYORNUr6JUCh/sRYKd5s5
swd5lERhrnwOeT+lH+0DY/BqLRRGFWvGNLUDEQrj4bO1UBgPrHYHkDeTKPSk
1OXCHfLMdJ50VRKNHpVKnDu0weurPzL5UL+9aXd3JTozgvtyYOhlgJ4lbBer
pNAMk6jcp4mhDgW1MJsVmFY39Zr5XyZ5uMax8YyFp2x5bA3MnS1bQ7JqrOTS
6u9Qd0M/OKKBPFQO0OAHEZk9adbDhJaA74E1dw+uIzcmRnWa6RZk7wHH4JiE
LMUYrpMek4+sAGlm3uHyFcwFmJt10kOejXbxDjhYwVYGbHIqylTuVZrpQx0K
T1WJwinwKyVpV2Ms3JMiyXCqQ0s5Rt90D95bGVNp7Pb267cmiexzuTG6n83n
2O/9/xgud2v2P24SV/JEa3qAt9CfY8zMe+HtGF7+5181s12m8V7JKO7HMjKW
SliWJ1HL8faGccWq4nlozQV4KvfQM9/xiJpUkVWnZD/k3FYgyIUWJFmKP6iF
hfcHnvA9WQLbK3iElZ973p8xZBmBheco/cKzJc0yb9bl0IWgMrZdEaIbAk9Q
cgySHLfVvJbD/DLtRlji/sGbXRr9Tu1Pt6Ngf7LEzYm3To+m2+Jfqp1a0P1W
ibmZoOaJ+x3vDDHarMZNLUAcrIXY9C9CL8hKD81GflPgnT9GlMomvkB/S+5P
4qUsi3xAjhiz6W3oeqLTfdtsZXUi7kaEu2+4yZgLIrg0y3mP4X2yYeh6IHVP
0nDoxK/Qnb83/sh2O3WeCOJtvGeExIibZvEpND+FzFyIkQpDYpeO3/CYo4ZU
hH6WYa6F3zdZSTyOwHy01szwzSU0+I1ZEDacKDO7cSZZytn81l5Fs1nf70Bm
96CMEGT3pffFmexeFNFMnmYX743A/WQEsA+TRwhN544z2QcaRDMZ4Yxj9qNC
hGU3krO0F9apPOJXP4c1kXcx7cZ1OoR+Hqszc/jf5k3qdB/+60BeWsfaxkrU
/D/Cazd9YWo97ewSR8khluSt9qFhUkt8WTSnWbR67s5VHXY/uMes9VKtxF2+
u9j03al1aZi+t0yfs8LNDdN3588Mk1pnhqnfRKPIZ24dm7b/38+FYVLrwJg1
l6OazloxMcx7qs38511nbNpaE9v/rFCrMgs09zv1TCKtMAyN2Oxj96wW1gfP
so1/AI3gklI=\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3830],

Cell[TextData[{
 "Include ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "10"], TraditionalForm]], "InlineMath"],
 " of image size of padding on all sides:"
}], "ExampleText",
 CellID->317582922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", 
    RowBox[{"Scaled", "[", "0.1", "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329684157],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], RectangleBox[{0, 0}]},
  Frame->True,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{154, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->47398299]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", "]"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", 
    RowBox[{"Scaled", "[", "0.1", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5186209],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}],
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->611433905,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztmd1u20YQhWmRlGRZlCzFsWzHsRWlsdHEifNTtEGKxEUvmqs+hJEKSIAW
KdTc91ncR+r7CM3O7JBcHs6SdNg2KFAjofiz5zuzs8vlcvnj5Ye3y18uP7x7
czl/vbr89e27N7/Nf3i/MqfCjSAIfjL/f94LzP5fZo//f79er4NwuVyu+S84
pk1wYbaxOTnno5dm2zFHofzasy/MloSxQzBbITyXsn316tdydUBHUeZudo74
+jNhD+kozq4L4zaXeSKMcUWZcykzVcsccpkz8dqBTHTgeJ9L3xfirFHpU2Hv
w9UQjve49D1h81FsWqcQbaxq7jqa0EiQHMExxx3MJa6ZqDrvH/7eoV8ojZ67
rD5yPEkVG7WN92plo6Z4e6r2Fjj3HC39s9o+aG+ydh98B0Wt2fFrZ067ke8Q
fK9WpN0ELfcJ3qYxk+9Y1Q5Ae4O1U/CdkLaL2qDkbNXbjpqcd0jdA7WteonA
fT5IJPZd8d9VY++YX4x/wvotiSDV73v1QZj12FLbW9amw6La3CZWlLF4hKnm
bDOnL5wdielYjYlYmJNc745JE4ln4eVUxTTOmYWRLJHovlCpUQ11lFNL49ZA
4j1VybFSb4dWMWZFEvGXXm5VxAl74NmomBeJ/Ex16IJDt5GDO0bRffBIZfeU
rAxVXuZqEIR66OVVZWOrgm3Bfna/Jg9t2JtKHgYteVV5YK9SDXqN2IOaPLRh
byl56LfkVcXahj2sYfdasBMlD12Vh/1Bv8+SmlgtG+cVGCuzw/zJbp8v9llH
u5htGsmidLbZms75poFrmf7hLCr++3ycWiDvv+RC7a6OzLXkc7Ufjf8BnpsF
vUXxLLIff3Y21j76n/0Z2PiW1W/E3lb69L/Dw7o/8fKq+nEz9uPsXfJqRbN0
pGJGw0ZUmjHSq0IQ/fFnPi5ro1B7L5r/8luxsaJi9FvO1qiRF86xsWVPwKur
ejWrV53XXfEKwiyHAbXQJnlWjO04D/s093nqXmjBkVrfumdWM8dDtc9MvY54
L+ku2FsOoAV3VT7NWNT3r1r+zNNqB6pPXVs189xR2+pYdcQ3AN2Rk2lPykpF
7jZR3RY1vRLfFq/vm6j940StJb6TXd9tAP3kvuqD75XX9+l5+ssj1a99FiO1
9Z6pbriGgG8HGyU3vKc7qts3Xje851KH4qgRl4gvWhI5ZgvkS69UHq4CYfbL
bLpTeXFC+IT9TmXjulU9OxJ25MTv5+Oan4dfWPuhy32N7lnTxBHZMgmZAOWC
Nvm6aobQCaX1O4f0qkhapyu0FPeG2SVCsZ8uee6kUJRRBBk4F6GVOpo9XXhG
B9RTW9lZVtH/JejtymG3pMc7cKRxZI024AX2MkNbu6Q6UA46QfF+jkrqvqcG
34oan1WdEgFXrrEONDpQFXA+65LylW7sD09FzeNe7PZmyqjVJjURnAmDzxdW
ia1+VKM/Ff3Uox97Yl+Izv1alUc9AddE2u1IVIdCtaWnHo+ZlL5TyCZ+TcP7
dSoq+n4VZqqb4pH2oJFTKkpHpgC/vSG7Byq7KrQHqmF6bIX8XKYbZrG23z7t
6nD6zWnoqKlLdxy+/bpxC/i4qjYXrv0eleYWSx0K84BLHcFVvFv3pLT9anos
TCx1Q5wXXOoOXMURaCzMUy69gKt4N25J6QdcOv0aiaW6EsE5l7oHvTESxld8
9cRsu+bouc30xke+olr0\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->154551926],

Cell["Specify different padding on each side:", "ExampleText",
 CellID->3256323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.5", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.3", ",", "0.3"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11015496],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], RectangleBox[{0, 0}]},
  Frame->True,
  PlotRangePadding->{{0.5, 1}, {0.3, 0.3}}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5214796]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", "]"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.5", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.3", ",", "0.3"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->307618327],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}],
  PlotRangePadding->{{0.5, 1}, {0.3, 0.3}}]], "Output",
 ImageSize->{154, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->134557595,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1701],

Cell["Add padding to make the range of data more obvious:", "ExampleText",
 CellID->10794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "50"}], "]"}], ",", 
   RowBox[{"PlotRangePadding", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18561],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVmUtPE1EUx4d2SksCKtoKCsgAxphIIkkXJcFEEhPZ+Eg0cYlBIykao0GC
O10SFi5d4IawcOHOhQkfATd+CD/JOHc6c++dX888CiVEknZ67jnnf573MZeH
a1vtV2/XtjZernkrm2vv2xsvP3j3320GQ+UBx3H+Bp/P407w2w9+hZ8x3/dL
wY/fwdNxFOWU1Xj45xzljB5fs994RrMafCuRkiXrKDr4DIr6NYxSqixqdYY7
f6WYzEFR5ElsUsuNIi8Wlwu6ImpVI8z4WelTXc6yt6SeUD/j3BlbzFlYB9fQ
TkrW8rqhKE4x++l91F87tsR2SO/s7ARD7XbbaYIe15m2sxo/hyD9JqQ9zwvo
Wq3mTIJfB39crG4NUh3Uw8PD5eXl/f39CNXw6+BnoRop+v4J/NsiCiNYAEoL
9D2NovLVgI2bkK4Anfxh8BfBr4k+34VWRfTC8IfBXwQ/y4rRWgC9ArqWyIy8
JjxBfKOgVzO0jL+joFcTlp/Cr1HQq4kZYK8A2fvPYNfcq0qz06InEN0PX1qD
OuWzYAvimvgfiF1l6AboZg/xKHICGSTefE7Xs8sboNP8ifc01qMJ/fmc+cD+
56zNsp+1EzeBMw/6RaLTiu3Unm/2QCU1HTxd0OWoiRQ9k/Q6Gg1XVFdXBDpl
Y3lQa2rha1154H48FSZDz5moayk1bdESP9/OFdTVFRDVgXlAPXVM4ZxSolpx
BP15TrQc6pU72VKjk7n+VYA7Jvhny09Gteye8ZxhxSK1qqdVR5CzrFgDvl3R
DM85oxsRRqkL/TxyMiwhJzRmi8VqeRNiVu3uNpmT4w21I4m8vuTqcTm3D5jz
kdTseKmcko5U8Yl4sederCf7Q4fb6ywdQTayY4tXBT1YtJrYr+NVSj15emyA
ryLIXxFnLb+xBlq+3MrorK/pGpZ3e4k6ckfgGfWLiNkCpget16LWGKSmYNsD
Ks9ez0LUS8H3n6he3TbydkQ32XXauNyt/aPLiI0nhkJ4BfzOezc/Kd0rvosa
umLVKDUF/pwfdUowpDrlBvhV6F8V9bFP6znAvWMb9HJs3d77UmIwUtug+d5W
F1F+wnaWlMGuJ+KRz22rsL+eIWXsryeQn8OujHEAS3PpUlVtybcOeJ01X1v9
BrywXlXthW8dpCLNmp/+7sQO3UPEQ4iR7yoXQqyw4zLfTTgz94A7DrvHxf0F
3F5wzP1Pt3z8FpB+u5f9LsKVYgl53E1UKn73iG8i7yA7u2IPLSF2WSp5F/gY
fvBGY0nEeAR/eEPBvYr76EQGKu89eDPA3jS0jDoH2x+Byg43KCo/12HjIMOG
wZiCzRXQLRFlGlIzsL0CupXwlOeFGfjE+5+W7ri0O1z28DQQvocIQ5DqvvNk
7x/1oGfm5OnaOa5e8o7bvpuVV4r/4aY/GRO7I23nkLPGkx377LS10vsnrl6x
ONgjcs+krd9n/7+afnWEM/APaP++Vw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->384148230]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14992],

Cell["No padding is added if the plot range is explicit:", "ExampleText",
 CellID->548966236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254003942],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], RectangleBox[{0, 0}]},
  Frame->True,
  PlotRange->{{0, 1}, {0, 1}}]], "Output",
 ImageSize->{154, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->19297511]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1670],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImagePadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImagePadding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRangeClipping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangeClipping"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1124],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->646104522],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "MoreAbout",
 CellID->133664143],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->82154487],

Cell[TextData[ButtonBox["Plotting and Image Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingAndImageRegions"]], "MoreAbout",
 CellID->721411602],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->257234319]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PlotRangePadding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 10, 22.4479888}", "context" -> "System`", 
    "keywords" -> {"graphics margins", "plot margins"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PlotRangePadding is an option for graphics functions that specifies how \
much further axes etc. should extend beyond the range of coordinates \
specified by PlotRange. ", "synonyms" -> {"plot range padding"}, "title" -> 
    "PlotRangePadding", "type" -> "Symbol", "uri" -> 
    "ref/PlotRangePadding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10845, 332, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->429181163]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35335, 1057}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2637, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3260, 88, 1581, 37, 70, "ObjectNameGrid"],
Cell[4844, 127, 688, 20, 70, "Usage",
 CellID->27518]
}, Open  ]],
Cell[CellGroupData[{
Cell[5569, 152, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6047, 169, 260, 8, 70, "Notes",
 CellID->28262],
Cell[6310, 179, 77, 1, 70, "Notes",
 CellID->27944],
Cell[6390, 182, 1292, 37, 70, "2ColumnTableMod",
 CellID->21726],
Cell[7685, 221, 85, 1, 70, "Notes",
 CellID->17015],
Cell[7773, 224, 1272, 36, 70, "2ColumnTableMod",
 CellID->22893],
Cell[9048, 262, 587, 20, 70, "Notes",
 CellID->19323],
Cell[9638, 284, 778, 28, 70, "Notes",
 CellID->3569],
Cell[10419, 314, 389, 13, 70, "Notes",
 CellID->184550763]
}, Closed]],
Cell[CellGroupData[{
Cell[10845, 332, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->429181163],
Cell[CellGroupData[{
Cell[11230, 346, 147, 5, 70, "ExampleSection",
 CellID->87756344],
Cell[11380, 353, 220, 7, 70, "ExampleText",
 CellID->471321252],
Cell[CellGroupData[{
Cell[11625, 364, 250, 8, 28, "Input",
 CellID->184858516],
Cell[11878, 374, 287, 9, 169, "Output",
 CellID->317352220]
}, Open  ]],
Cell[CellGroupData[{
Cell[12202, 388, 134, 4, 70, "Input",
 CellID->419329616],
Cell[12339, 394, 1733, 33, 129, 62, 1, "CachedBoxData", "BoxData", "Output",
 CellID->46710449]
}, Open  ]],
Cell[14087, 430, 125, 3, 70, "ExampleDelimiter",
 CellID->571103222],
Cell[14215, 435, 60, 1, 70, "ExampleText",
 CellID->726623739],
Cell[CellGroupData[{
Cell[14300, 440, 308, 9, 70, "Input",
 CellID->531124329],
Cell[14611, 451, 313, 10, 170, "Output",
 CellID->239513332]
}, Open  ]],
Cell[CellGroupData[{
Cell[14961, 466, 205, 6, 70, "Input",
 CellID->46564708],
Cell[15169, 474, 1491, 30, 129, 88, 2, "CachedBoxData", "BoxData", "Output",
 CellID->81247604]
}, Open  ]],
Cell[16675, 507, 125, 3, 70, "ExampleDelimiter",
 CellID->410336149],
Cell[16803, 512, 176, 6, 70, "ExampleText",
 CellID->180294061],
Cell[CellGroupData[{
Cell[17004, 522, 305, 9, 70, "Input",
 CellID->429680998],
Cell[17312, 533, 310, 10, 163, "Output",
 CellID->325243355]
}, Open  ]],
Cell[CellGroupData[{
Cell[17659, 548, 203, 6, 70, "Input",
 CellID->321455261],
Cell[17865, 556, 2102, 40, 129, 85, 2, "CachedBoxData", "BoxData", "Output",
 CellID->346210103]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20016, 602, 215, 7, 70, "ExampleSection",
 CellID->3830],
Cell[20234, 611, 197, 7, 70, "ExampleText",
 CellID->317582922],
Cell[CellGroupData[{
Cell[20456, 622, 342, 10, 70, "Input",
 CellID->329684157],
Cell[20801, 634, 319, 10, 170, "Output",
 CellID->47398299]
}, Open  ]],
Cell[CellGroupData[{
Cell[21157, 649, 238, 7, 70, "Input",
 CellID->5186209],
Cell[21398, 658, 2120, 40, 129, 95, 2, "CachedBoxData", "BoxData", "Output",
 CellID->611433905]
}, Open  ]],
Cell[23533, 701, 125, 3, 70, "ExampleDelimiter",
 CellID->154551926],
Cell[23661, 706, 80, 1, 70, "ExampleText",
 CellID->3256323],
Cell[CellGroupData[{
Cell[23766, 711, 471, 15, 70, "Input",
 CellID->11015496],
Cell[24240, 728, 277, 9, 137, "Output",
 CellID->5214796]
}, Open  ]],
Cell[CellGroupData[{
Cell[24554, 742, 370, 12, 70, "Input",
 CellID->307618327],
Cell[24927, 756, 2680, 49, 138, 106, 2, "CachedBoxData", "BoxData", "Output",
 CellID->134557595]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27656, 811, 222, 7, 70, "ExampleSection",
 CellID->1701],
Cell[27881, 820, 90, 1, 70, "ExampleText",
 CellID->10794],
Cell[CellGroupData[{
Cell[27996, 825, 303, 10, 70, "Input",
 CellID->18561],
Cell[28302, 837, 1761, 33, 70, "Output",
 Evaluatable->False,
 CellID->384148230]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30112, 876, 233, 7, 70, "ExampleSection",
 CellID->14992],
Cell[30348, 885, 93, 1, 70, "ExampleText",
 CellID->548966236],
Cell[CellGroupData[{
Cell[30466, 890, 459, 15, 70, "Input",
 CellID->254003942],
Cell[30928, 907, 317, 10, 170, "Output",
 CellID->19297511]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31306, 924, 310, 9, 70, "SeeAlsoSection",
 CellID->1670],
Cell[31619, 935, 977, 35, 70, "SeeAlso",
 CellID->27161]
}, Open  ]],
Cell[CellGroupData[{
Cell[32633, 975, 313, 9, 70, "TutorialsSection",
 CellID->1124],
Cell[32949, 986, 138, 3, 70, "Tutorials",
 CellID->12933]
}, Open  ]],
Cell[CellGroupData[{
Cell[33124, 994, 319, 9, 70, "MoreAboutSection",
 CellID->646104522],
Cell[33446, 1005, 151, 3, 70, "MoreAbout",
 CellID->133664143],
Cell[33600, 1010, 152, 3, 70, "MoreAbout",
 CellID->82154487],
Cell[33755, 1015, 161, 3, 70, "MoreAbout",
 CellID->721411602],
Cell[33919, 1020, 197, 4, 70, "MoreAbout",
 CellID->257234319]
}, Open  ]],
Cell[34131, 1027, 27, 0, 70, "History"],
Cell[34161, 1029, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

