(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    317597,       7359]
NotebookOptionsPosition[    301562,       6811]
NotebookOutlinePosition[    303067,       6851]
CellTagsIndexPosition[    302980,       6846]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Primitives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"], 
          "Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"], 
          "The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Primitives\"\>", 
       2->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>", 
       3->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Raster" :> Documentation`HelpLookup["paclet:ref/Raster"], 
          "Rectangle" :> Documentation`HelpLookup["paclet:ref/Rectangle"], 
          "Cuboid" :> Documentation`HelpLookup["paclet:ref/Cuboid"], 
          "GraphicsComplex" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsComplex"], "Opacity" :> 
          Documentation`HelpLookup["paclet:ref/Opacity"], "Specularity" :> 
          Documentation`HelpLookup["paclet:ref/Specularity"], "Glow" :> 
          Documentation`HelpLookup["paclet:ref/Glow"], "Lighting" :> 
          Documentation`HelpLookup["paclet:ref/Lighting"], "Disk" :> 
          Documentation`HelpLookup["paclet:ref/Disk"], "Line" :> 
          Documentation`HelpLookup["paclet:ref/Line"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Raster\"\>", 2->"\<\"Rectangle\"\>", 
       3->"\<\"Cuboid\"\>", 4->"\<\"GraphicsComplex\"\>", 
       5->"\<\"Opacity\"\>", 6->"\<\"Specularity\"\>", 7->"\<\"Glow\"\>", 
       8->"\<\"Lighting\"\>", 9->"\<\"Disk\"\>", 
       10->"\<\"Line\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Polygons" :> Documentation`HelpLookup["paclet:guide/Polygons"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Objects\"\>", 
       2->"\<\"Polygons\"\>", 3->"\<\"Precollege Education\"\>", 
       4->"\<\"Symbolic Graphics Language\"\>", 
       5->"\<\"New in 6.0: Graphics Primitives & Directives\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Polygon", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Polygon",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Polygon"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["pt", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["pt", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics primitive that represents a filled \
polygon. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Polygon",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Polygon"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["12", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["pt", "TI"], 
            StyleBox["21", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a collection of polygons. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17041]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " can be used in both ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " (two\[Hyphen] and three\[Hyphen]dimensional graphics). "
}], "Notes",
 CellID->9845],

Cell[TextData[{
 "The positions of points can be specified either in ordinary coordinates as \
",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "}"}]], "InlineFormula"],
 ", or in scaled coordinates as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->23630],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " can be used to specify coordinates in two dimensions. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->5094],

Cell["\<\
The boundary of a polygon is formed by joining the last point you specify to \
the first one. \
\>", "Notes",
 CellID->10400],

Cell[TextData[{
 "You can use graphics directives such as ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " to specify how polygons should be filled. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->8993],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " can be used to specify how the interiors and boundaries of polygons should \
be rendered. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->2054],

Cell["\<\
In two dimensions, polygons are by default rendered with no explicit edges \
drawn. In three dimensions, they are by default rendered with black lines on \
their edges. \
\>", "Notes",
 CellID->8394],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexColors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexColors"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " can be used to specify different colors for each vertex of a polygon. The \
interior is then colored by interpolation between these. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29204],

Cell["\<\
In three dimensions, shading of polygons is determined by simulated lighting. \
\
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->5542],

Cell["\<\
Polygons are by default assumed to act like diffuse gray reflectors. Color \
directives can be used to change their surface color. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26124],

Cell[TextData[{
 "You can specify surface material properties using the graphics directives \
",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->32569],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Glow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glow"], "[", 
   StyleBox["color", "TI"], "]"}]], "InlineFormula"],
 " can be used to add glow colors that are not affected by simulated \
illumination. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8581],

Cell["\<\
In three\[Hyphen]dimensional graphics, polygons are considered to have both \
front and back faces, with their normals taken to point to the front. \
\>", "Notes",
 CellID->2643],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FaceForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceForm"], "[", 
   RowBox[{
    StyleBox["front", "TI"], ",", 
    StyleBox["back", "TI"]}], "]"}]], "InlineFormula"],
 " to specify different properties for front and back faces. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->21827],

Cell["\<\
By default, the normal direction for a polygon is determined by a right\
\[Hyphen]hand rule, so that typically the first three vertices will be in a \
counterclockwise order when viewed from the front. \
\>", "Notes",
 CellID->18201],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexNormals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexNormals"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " can be used to specify effective normals at each vertex of a polygon, to \
be interpolated for purposes of smooth shading. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->4502],

Cell["\<\
Polygons in 2D and 3D can be non\[Hyphen]convex, and can intersect \
themselves. Self\[Hyphen]intersecting polygons are filled according to an \
even\[Hyphen]odd rule that alternates between filling and not at each \
crossing. \
\>", "Notes",
 CellID->19023],

Cell["\<\
In 3D, non\[Hyphen]planar polygons are broken into triangles for rendering. \
Quadrilaterals are broken in two; other convex polygons are typically broken \
into triangles emanating from the center. \
\>", "Notes",
 CellID->12038],

Cell["\<\
For purposes of shading, non\[Hyphen]planar polygons are taken by default to \
have a single average normal. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->3561],

Cell[TextData[{
 "Individual coordinates and lists of coordinates in polygons can be ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23834]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194441815],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->486263078],

Cell["Triangles:", "ExampleText",
 CellID->32225171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->241287288],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[
   NCache[{{1, 0}, {0, 3^Rational[1, 2]}, {-1, 0}}, {{1, 0}, {
     0, 1.7320508075688772`}, {-1, 0}}]]]], "Output",
 ImageSize->{104, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->137627028]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26130044],

Cell[BoxData[
 Graphics3DBox[Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->45246440,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytmWtv2zYUhhXbku924lzs1K7jOnOzpO2ya1vsCvTDOmAo9huCzkALbNjQ
9eftR+17YWw85JEsP6bDyLOBKKLE93kPSYk3vbp5/2b++837t69vJi/f3fz5
5u3rvyY//vHOXCrvRVH0q/n7bRCZ83/Nmf17sVgsovJ8Pl/YX3Qmh+gHc4zN
xYlNfWeOJZMq63939WtzFGFFUhXDchBzdIznmjuRVGzuf/j7nyyL+jzVPNWU
YfK4bCXENbL5v1DPeo7p8pvziJqh1XymHk1JJZkmk/lV16pq2buZKirLIc5y
a2lcdI81ujY0FSt0bnKLjqdWfaWOXajjO6kv1Hsf6gTqMtQDq56p9+Emtfw3
P7/6XNVHUFehrkDdt+qJRn4MdQ3qGOoTqx6rdx/quq14p3YAujv9UN0H0DfW
9PS38draF/970DfvqO+rfuTTx5l+Qx3YGrdHuXgfjJaXkYBh2zzqaRxnYLQL
MPYXuf4hx+jkWlJOSzbtHkjJypbpWVpbS/UAtG6Axjo6sLSmxnYO2j5o5UBs
jlZX2qwgjbHZtzWqbaD1CpZ0SUuvynvPEh8WjLG7pFayq552OQpw+cx0lty1
/pRP4fH27NxVb0+fczmBSyXgYvv5qIqrfGJO4dLfiQtbif1XyIW8lteFsZzA
ZQCXOODS9LowzXHkdCcufBp6cLkXcKG+4XWpI83xeAiXJOBieWvt0ES6A5fR
TlxaSHNeE3JhXdS8Lm1v2ZYu9+FSDZTF79LxttPSZRxwYVmqXpeuL1fO5Szg
0oA+8brsIx3DZQKXWqAszoU9Sg/pMlymgbIIVQaMmpd+iHSpIF2iyVYfrAv/
PGk5ehnMbFMdze0vylYld2NrWuZGDwvWvp/K2fDGeAtR2bMy1nrg3fJTuWq4
2IrKlmSspDYCo4Cfylg/DlAZa8VL5VhyuRPqAahXoDYDNeCnckR6tBMqV62P
t6JyfclYSW15+pwwlbE+2QmVY/AnO6FyzBWq3SUI0MpeGnczpD7ldqlgrH46
R+4rpScfbn8W/HTO1hn7hdIbATp7Kz+dsX9kDjJgcO3KN/lu9AboU42dK7zt
6JzLTJTO9QzpfIf99BroY6VzvsxenrGXvHTOkIZa75yPcbzbjj7Q2M8DdNaM
o9sK0oGetXKiZI5SnLeEyYz5SMns/YuTE5B7SmZP5Ztr3U7mDLSrrfg5yFwh
hMkVkNsa8zOQuVpjbewFyQ0lfxMgM+aUvHmmXFPy9/+bzFlyrPX8IkDme6Hk
OLvi0lYn2V6Cx92DDbyVGXZZWT+Dxb2b21murHL7Fx8nzjiuYbUPE7HcelVA
wxWRfCr4CXruwEnse+a2xLz6hAlXRqyqucTWKXmjcM++bwYkjG+tJmNISs1W
/eWpTvfDRffUNt/S26fh+DtU7bXXc73MnMuNkRbW5Voc65x0H3RNr/Hke21/
JFw/D5HuaLuObyEt94qpPtI4Bmm9ZE0o507L3YzBhrrtpfWRAZye+xR9pKeq
z74vuBgyfXeR/x6y1F2qLvuatBL1gaek+fSnWm+lzCf9XsCcz1Zqknfp89XC
reJd7mNlMpd8wZOiuhkyS8Yae7LI7zuw/rmnJfUiTen2P9OvOcw1U6bb/edz
wbX3RJnuC89Imcw1Uqb9crT2zvCdHGhum8/uj2ffVnO5DtV5anM9wF3fOkiY
Fzb3FHd9M2TJ/cjmTr/5MVeiEVzbXLPcXXnaKsr40t59aI6JST23qWjvPyWL
RqA=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90565965],

Cell["Self-intersecting polygon:", "ExampleText",
 CellID->105059788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459443524],

Cell[BoxData[
 GraphicsBox[PolygonBox[{{0, 0}, {1, 1}, {0, 1}, {1, 0}}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->6848204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->394699851],

Cell["Differently styled 2D polygons:", "ExampleText",
 CellID->14609133],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->993836995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", "p"}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", "Pink", ",", "p"}], "}"}],
     "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Dashed", "]"}], ",", "Pink", ",", "p"}], 
     "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Dashed", ",", "Blue"}], "]"}], "]"}], ",", 
      "Pink", ",", "p"}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->410781247],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], 
     PolygonBox[
      NCache[{{1, 0}, {0, 3^Rational[1, 2]}, {-1, 0}}, {{1, 0}, {
        0, 1.7320508075688772`}, {-1, 0}}]]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[Large]], 
     PolygonBox[
      NCache[{{1, 0}, {0, 3^Rational[1, 2]}, {-1, 0}}, {{1, 0}, {
        0, 1.7320508075688772`}, {-1, 0}}]]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[{Small, Small}]], 
     PolygonBox[
      NCache[{{1, 0}, {0, 3^Rational[1, 2]}, {-1, 0}}, {{1, 0}, {
        0, 1.7320508075688772`}, {-1, 0}}]]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], 
     Dashing[{Small, Small}]}], 
     PolygonBox[
      NCache[{{1, 0}, {0, 3^Rational[1, 2]}, {-1, 0}}, {{1, 0}, {
        0, 1.7320508075688772`}, {-1, 0}}]]}]}], "}"}]], "Output",
 ImageSize->{452, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->481737613]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->690501634],

Cell["Differently styled 3D polygons:", "ExampleText",
 CellID->466344167],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225867643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", "p"}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", "Pink", ",", "p"}], "}"}],
     "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Dashed", "]"}], ",", "Pink", ",", "p"}], 
     "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Dashed", ",", "Blue"}], "]"}], "]"}], ",", 
      "Pink", ",", "p"}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91775463],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytmWtv2zYUhhXbku924lzs1K7jOnOzpO2ya1vsCvTDOmAo9gv2IegMtMCG
DV2B/fjC2HjII1l+TIeRZwNRRInv8x6SEm96dfP+zfyPm/dvX99MXr67+evN
29d/T3788525VN6Loug38/f7IDLn/5oz+/disVhE5fl8vrC/6EwO0Q/mGJuL
E5v6zhxLJlXW/+7q1+YowoqkKoblIOboGM81dyKp2Nz/8Os/WRb1eap5qinD
5HHZSohrZPN/oZ71HNPlN+cRNUOr+Uw9mpJKMk0m86uuVdWydzNVVJZDnOXW
0rjoHmt0bWgqVujc5BYdT636Sh27UMd3Ul+o9z7UCdRlqAdWPVPvw01q+W9+
fvW5qo+grkJdgbpv1RON/BjqGtQx1CdWPVbvPtR1W/FO7QB0d/qhug+gb6zp
6W/jtbUv/vegb95R31f9yKePM/2GOrA1bo9y8T4YLS8jAcO2edTTOM7AaBdg
7C9y/UOO0cm1pJyWbNo9kJKVLdOztLaW6gFo3QCNdXRgaU2N7Ry0fdDKgdgc
ra60WUEaY7Nva1TbQOsVLOmSll6V954lPiwYY3dJrWRXPe1yFODymeksuWv9
KZ/C4+3Zuavenj7ncgKXSsDF9vNRFVf5xJzCpb8TF7YS+6+QC3ktrwtjOYHL
AC5xwKXpdWGa48jpTlz4NPTgci/gQn3D61JHmuPxEC5JwMXy1tqhiXQHLqOd
uLSQ5rwm5MK6qHld2t6yLV3uw6UaKIvfpeNtp6XLOODCslS9Ll1frpzLWcCl
AX3iddlHOobLBC61QFmcC3uUHtJluEwDZRGqDBg1L/0Q6VJBukSTrT5YF/55
0nL0MpjZpjqa21+UrUruxta0zI0eFqx9P5Wz4Y3xFqKyZ2Ws9cC75ady1XCx
FZUtyVhJbQRGAT+VsX4coDLWipfKseRyJ9QDUK9AbQZqwE/liPRoJ1SuWh9v
ReX6krGS2vL0OWEqY32yEyrH4E92QuWYK1S7SxCglb007mZIfcrtUsFY/XSO
3FdKTz7c/iz46ZytM/YLpTcCdPZWfjpj/8gcZMDg2pVv8t3oDdCnGjtXeNvR
OZeZKJ3rGdL5DvvpNdDHSud8mb08Yy956ZwhDbXeOR/jeLcdfaCxnwforBlH
txWkAz1r5UTJHKU4bwmTGfORktn7FycnIPeUzJ7KN9e6ncwZaFdb8XOQuUII
kysgtzXmZyBztcba2AuSG0r+JkBmzCl580y5puTv/zeZs+RY6/lFgMz3Qslx
dsWlrU6yvQSPuwcbeCsz7LKyfgaLeze3s1xZ5fYvPk6ccVzDah8mYrn1qoCG
KyL5VPAT9NyBk9j3zG2JefUJE66MWFVzia1T8kbhnn3fDEgY31pNxpCUmq36
y1Od7oeL7qltvqW3T8Pxd6jaa6/nepk5lxsjLazLtTjWOek+6Jpe48n32v5I
uH4eIt3Rdh3fQlruFVN9pHEM0nrJmlDOnZa7GYMNddtL6yMDOD33KfpIT1Wf
fV9wMWT67iL/PWSpu1Rd9jVpJeoDT0nz6U+13kqZT/q9gDmfrdQk79Lnq4Vb
xbvcx8pkLvmCJ0V1M2SWjDX2ZJHfd2D9c09L6kWa0u1/pl9zmGumTLf7z+eC
a++JMt0XnpEymWukTPvlaO2d4Ts50Nw2n90fz76t5nIdqvPU5nqAu751kDAv
bO4p7vpmyJL7kc2dfvNjrkQjuLa5Zrm78rRVlPGlvfvQHBOTem5T0d5/Kp/G
mg==\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[Large]], 
     Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmVtv20YQhSmSut9vlmzLluRb3NRukl5TBG2AoEgfiqK/oA9GICABWrRI
A/THG0TL2T1L0oezhgQJiazlzvlmdrnaHY5+vfv0fvPn3acP7+5WP3+8+/v9
h3f/rN7+9TG9FFWCINik//+YB+nn/9JP5v+bJEmCaLPZJOYVrOQteJ2+V9OL
a9P6IX0P01ZobIVjXoHtfYXeSP6mnY4mFpb2Mn2Xi1VnEUtfEFijpbH5FpS6
s6ne//6vdQWWtfsKrIb8Nd4yuyCksSyM4gXILSiMoJpFAPqJsX0G2zZs40ds
bxBJB7Ym4CizLUVzZFRP4aGPcdYKKnnpqmuoBlDVSRWR6tCoLhHhEBGyKibV
3KjO4WsMVUNUcsfsRCverG4FbxPomiUd+5sZ3Sn8HUDXclFCFyoerXIB5Ryz
0i4o5WOo+DwwykPEeghlR1FWSTk1yhl8HiNaVkaKT6ucQrmAsluYH/tP8zox
2hHiPYG2p2prpB0b7QB+l9D2S9pI8Wu1XfhdY56GW/kdGW0bfs+hHe2gbUJ7
Ae2Y749HPTTqRkEdPaKuk3qQqYt72Bkok90pcXY1/bACZ8orxsPp55xqdjXJ
90LRHOzOKlzlveYY1JmHyvqeStX2IlHPiRp7qF1D5RHw+pxhNvej8vqZgnro
oTbJvqNSue120iOiVj2x6lS2GmFejz1UjrWtUtnKnTALD7VF9i2VylY9UE+I
WvPEaql8dzpKO3qEylE0VWpX8S3UUw+1rd2XErWnWAl1tWWsOrWvrDRRr7eM
ta5SB9R2edqZQo2UWHXqkNouPzwnar2wZ5nkRAytDGT1bMr3VsysjxuDy6dy
TWVPCm2XfVwo5AiJrrqjqLmDKC6J1PDcfT9FrK/2okxAeaJQIuW7qFPGoFwT
pen5RuuUEebFR+ERGX0pv3KUz4jS8sSiU1yW/HRvilh/vhfF7cI3RGl7Tgyd
4p4xbvei9DAvu1E4C3CUZ1tSYpXSBeX5XpROgSJ5YndntZtV8yAr6ZENJXAk
3hV0UruwVuRyzTOq7Wju3LoGrXWvr0Cdxrmgo12B1vPQeNfXac0k36Nlzkae
7/t2NHeWrhEbZ8FNz0gjL02sl6BxluaLTae5E/kENM4iGjvRakmej8q88Yns
TiLeV3VaFbQZYuMTwJ2YOq14Lru4piDxblfbmuRiGoP0hSfn4F1JJ4nPAebq
yy1jCkukGKQeYvqOSNWtSRFG1wbpFZFiz+jKpDDJqypi+FohafUOkErZUh2c
N7txincgsPUxQb8lSoRx8R5VpoivELH8olC06s/DMQXmJd2/kT70jKViVCJv
pL3sNfR4rZRjT9966aWfdiTYuypHRxOEH++12oiu185EYbxUGbwHYOyJrZBM
oOXvil/J+9YchJuCd3tHdH09yatRXSWXtRXkh+u+nDUtqB0hipUaRSW9IN5t
BJxTHlO7BVZ2DgQ+kqtwMWEIgqkYVTOCHRRGxE+dc8+8ZpW+DGD1vSSvfRZ1
S+hMrTcOCgV0q+NnvSm1r6A3X23rNtPyE92E2rfpW1NmKlOMCuusaClV/BiW
di7Zgn19I4rM2tVS2eoFrGwOOqNefia/hbWtC8zBZCupvctNtBWkI+rlJ+wL
MG0dU1tbxfYK1rYq7erZ2gqVCOxvAafUy1nODEz7e8kyyX9XKVqNYXVurNbU
y3tMHxE8MdZnSf6LD8+FMG+MlczEwwpoE/3PTf9lQS0LLYaPr02vrMNa2vre
tILK/+kuUZ8=\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[{Small, Small}]], 
     Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFmX1rE0EQxq+Xy3tzaV7aJjVN06a1WhW1iC+I+AYqiPoJ/KOUgIKi1IIf
Xg7dmZ272zw3yV2rYNCkm5vnN7Ozu3N7m3cn559mX0/OP5+eTF6fnXz/9Pn0
x+TVtzPzVWnF87yZ+f9l4Jm/f5u/+P+LKIq80mw2i/jlTejNe2beA/PlLree
mHcyKZlP33xam8fSCujToNIrD8W+Ildivnn3dtjivmhrZPnr48+sxT2xqFMk
ZBEkMZo/xmxzV/w0Y5tyYiOsbba7LaxV7quJx9iy0yWaW6JpgSaIozWfdMmH
/G2x+kgia+eoS6Aesvqa+O6Yz5qj4FSqigPx1zWfdVAEoBiwYio+1gsrdh2F
2yc3Qk4oqDdZPZYIN0Bdj8fWts0/1LPCG4n34SX1Q/FP49PKaCqg4T5y5OST
fIfxXEk0lCn0ZXXroqM+twvp+qzrSoxj6KPuG2PuMWMtctaow9Dj0BmhMPY0
hjPSvnmrAqHLhKb0hGZZT1HVQNVhVV380mzug6qk+EpV7rf7C9Toc43V7re0
+qfQZ4zeVitzXSg4kg51rmLtAleL0OXiyLRTbqZi4VgjO8hhh5lMREplG4GX
dcULjoVOxhpGa3KIVUShtVQaVqvhhWg4pzA3WK8GQK4o5FWVjO0+kLWY3VHD
fjdVL2jVy/FSAS/I071gjzvgZSvHC0bZUL00oE1rYCcnSxhZXSU3oR0qZIoZ
7SwN50hLpafZGAO5qpBrKjlU856SMebi5LY6b5aTl+W5qnpZg3YFvEwKeIn3
iVl6B9pUCfZziMSgy1yErHRB7F1olxR6Dei+0LEmVVQPvDbTu4R5HQDf7m5s
pPal1it9H8Ld5FR7KndJ1dCpWAsxG3Vl9i2LLyVhfA3zhqtfJ1EVva6ol1Wb
skqi0Tj6zyScN13IE/a0mVO9dSpWa4y1qWS/GOmGQsJKoZOoUty+tJqq2Z0C
vQgupF6WWUvCnUwI+cAerSrVKJ+Kz6BEpaoY/hMajRkVIT8nA8XotPe5aZT0
VUXpvbp7y1CoihwJpaFQio0GUQ6FEiq9U/elGQrec6dC7OascKwKlo67aqRP
ZDQ21Ir9t/RtiR33Z5ejU/7GQsQ9DhJxzelEGteREPcUIs7BxZSB5PEqUGqF
KWXIXV/iwhpXXUh09xi48+kKDSuERvNzaW2hHSs0dxRwbmfJ1Ou25O4+0HAX
n0+jUW9JbI+Bhjv3YrSG0J7m0HA0szQfclgR8ksg03Mtrgehld29G5/rSOZe
KdHhCljE8CWOtwXiWLGadA8ph60fQIunC5gdy+G7gPmLDN8DwS9EoLtSNc5r
bEl3K9N8oxHLiZ0dmAVrkSq5Hx+c/XJPsJ5fgIozrCN9TbIjjEcKE7WSscg+
n9AJaWAAD3mgEuVCHa7wkeiPVf2K+YJ0VlsVnzvKfCIG1qcsAfdUI2g3hDSd
j8az4zLPakTpGWlmZxjIIPFr24nLU1mrwBhCO3lqgJm1yWM+46eddMzt+sJn
84HSd31mdeLeW6qsjfR0FElTmU3JKelcHPgkvA7tI8k53Z/8xFcncs/cU+tj
sXb92Bz2wBKfYh8I0Vr3pYVW9PtMKbHagKt4dkC/w1D67S5sE67iGQb9skJp
tWcpA4kAra6LlT2l24Kr+JS5LxHYE+ErwkSriTDtLwLbcBV3g1eEaX/RGcNV
3IFuCtv+erUjEaBVT6z4lNnbhat4hwglgkO23ovS39syq9U0b7IVZWL+nkJz
oyY2d9jmQEh4NyTZPbY4lNYjbnkrfwDEQPre\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], 
     Dashing[{Small, Small}]}], 
     Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1mXtrG0cUxdfa1dsvWZZt2YokP/KwEzdpa0LaUlJaSKAQ+gn6hwmCBBpS
0kA/fFjauXfO7E7O3rUlQoQtaXbu+d07r6vZ2VfXH98s3l1/fPv6ev7yw/Xf
b96+/mf+4v0HdyldS5Jk4f7/Okjc9//cN/3/Nc/zxmKxOHafSfILSknqvrhP
uTjXmp/de+quNKSUJonUiqGv/Qm6TD5dpXz3NT+gpoWaJPVY0c7U4inIbbH4
9Oe/SdPTc32J3VTtrkDqib3YZVKXwMjbfAtWN0TpXmKq9s0CCu4d1TwGdx0R
ZioobBPf4rJ8qKpLqDagagaV+6xXXSC+LUOlnUOqsaoewNfAfXaCQsxrFfeg
GAZFVvpIctYcqOYUse1Q31X1Gen3VX8MnyO0rUtta5qqKbzuQdWLvPk/1u2p
bgJvY+j6kTcdbFN1CJV8bt7qaaSafUQ4CZrIi44hqXZVNYKnCfXm8oQhCFO0
cIuUqaEcqnIbEc+g3K601PLqtZt5mQ/SoI3jdW9tUuqMSfrweqq1ftDlnQmp
QRgooQvfMnuHK6niqyfU4xapQ5rtz/yfot92DaVc5zi2VK3MLE5cx+CMVudU
ctUM41HH4hZtlqwbctmExorpWZhosG8t5YXzy5F7O+D16d545DZMGmcbWfFj
g9Yju3WTZuUF6T8mtoz4PJFHjcu7IB4Zfal5kez7JpXj3sH4fxmVrQY0/kxv
1tB7Jp1HQFbVtIbItl2T2KeyzLeZMVJsZ9PWTbpvupA41rZB1nGx1wH5l1bO
DSJH0TaJW4ZV+kXEbSq3aOwtchgpyYp2ywdUlvV1WkPSNiw+313ase5QWQRn
BjXFbkYuc55omWT9lSuztNPfJW4nynkSrLSdZ5LN3g1l7M2YXOyI4rlUoVq7
EOm9e0TrGbOz+RUJDwx1/NtgZtoKSfro3CBZWcYmFPtTqJnWXYk2QN88XInC
cy1QHhGlb/yKfE3CN4aaM21mqiU7PCb1uuHbVku2emL4tnYmNiHcR61G4Z1G
TJF1u/nJ3mndrL6UzOIuN2piWY4mWVlGU5JNyyAt1yKhnCOenjE+5t6rQpFV
fh8UvgOxYrEp4VftDKSdWzICrzWb2gH1GH21V7MSOdt6Gu9ohSYhTBEj72g6
K9MCiXcHHfz+2K20SEcgnRgtXC4emXljUDibSzw8MxsmpZmX9yXS4xcGieOx
SeG8Z4iYOIO0a0nxHqCZl/eaYvg9UcKekXvaJsV7mg0QnxrE1DjJsInr6Kcf
a+K6nSIWPcTynCjZ0pQGersN0m9GPDWUrKDk5cmTmL00ouF+XkMk0ezUoydn
utCX7pF+X55U7r8QxR+GVs8Bi9cC20YvllZlrvoV6RroS84x3m84ocwKCz9T
5E9UL9R1QbuZRVe74GpPF3q58tykst5TxZdEKb/GTZxFSl8/0/6IGdbZn2dY
e7cMIy6ev6vEIyGvuQui9wxesxMwwlx9VGGkFUYbbZmFCRPNyMCK93G8v68S
eS8yoXLIRmGMC2IY4wox3NswSc+yItJESK1FdAbqp6RfXXz/NabyDii6fjEr
RmFEYxxW60Zenm3GnMPaOVacZVJkfBe5R+WTaCykvcVZr69HXyWVe8cRlS9o
fhQ7J7TLUwZ5eUIcqy9rZkjIfSVhaPRsXL7Kw1MGVu7CNyvC0wdvxf3D/SfP
F5rIIv5kWJhsJe2RTvSnEDyKPFvOYe1Pvw6plu/PzhCBP/s8QgRsNQfTn3rf
oVre7U1g7Z9RTPPofj+y2odn/6RlTrWcdYZg6mlw8WyArbZgdV+tTqmWc2QP
ETxU6zN1W9T6Ade2CfGJ2tzNq8+zUlhcqYV4loX9TEvJ2v8wmpOL\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->330696241]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6990],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Polygon Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25761626],

Cell["A collection of polygons:", "ExampleText",
 CellID->692594619],

Cell[BoxData[
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232213795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"{", 
    RowBox[{"p2", ",", 
     RowBox[{"p2", "+", "1"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10379191],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[{{{0, 0}, {1, 0}, {0, 1}}, {{1, 1}, {2, 1}, {1, 2}}}]]], "Output",\

 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->418769061]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->478128593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"{", 
    RowBox[{"p3", ",", 
     RowBox[{"p3", "+", "1"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->159961143],

Cell[BoxData[
 Graphics3DBox[
  Polygon3DBox[{{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}}, {{2, 1, 1}, {2, 2, 2}, {1, 
   1, 2}}}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[4]=",
 CellID->263570008,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1mWtv2zYUhhVL8j2W7cSOk7iO4zTNruiG3YoBw4B92D7tRwStgRbYsKHr
z9uP2vdC2ETyUKIfMaHqZAXi+liHz3tEkYeH1K+3715vf7999+bl7fqXt7d/
vn7z8q/1z3+8LX6KD6IoelX8/baIiu//Ft/03095nkfxdrvN9b/oQn1EPxaf
afHjWls/FJ+tworlf/Pr98Wnapg6hOJTCC/Et+u9+q1c7SsrKdWLLyt9/Sth
D5WVlteF8UT7fCmM7B6f5+Iz9fostc9nonWMnmjBPtXenwjxpJH3jbBPcTWG
vdDe18JeNvK+Eu8VriawdaTRWiJZ42oKe669V8I2rGKcyFVG5m99nrsjo2j9
/u9/ik/zTBzvNuyZbn0q2h19M6a1ATRrf5I7Iy8t298RQwe2HgX6M7bjM65i
aKkPpz/O0LoL+0jTphLRELR4L9pYaIegJQFaD7aeE9Gh3OkItDZoHMF92BNN
G0hsY9A6e9F6QpuA1g3QBrB1NLo3fbT+B8ZW0dy8xjsOURljVlF38iGfyxDc
BThD2KOKW8t/HI+H+7PvyYRdqIwCKoc+uzZPmeXaUBlDhfm6mQrzWwKVSUBl
5OvBmgrzWAsq04BKBnvgVdH2zhhQ+XAG9nwvtjsGFHUeoI5h973UHvohFOvE
177Wu6SegDrbi8pRvghQp772NWoH1DNQWbM0o3KunAeoR76oHkyl3fZSU1Cf
gMrY/FTOY1JXgVjVeE1sTRHMChcBml1zmcNSLz0G/TLQAz2J1ZvLanTmmk2A
3pbYuX459FqOuQ4w49ytQZoxn4HJkR+XK72XV62xBeLGw/LtCEz7pNb+I7TP
5AnoaiiKapWXw3FyZuK5q4FEwh2Am21UW9YoSU3B/qoKYo6grqh4s89OBd5M
R91vu/BeQicRHfYHMwerbO/aX1PNRFWvPUnZOnd2ko+uORPNsdXc2n9cN5lx
WPv79fjcl/IEWQVSjRkphT+ftF/tUu6OewGqMUPRv5naxrFVdar3gAWEs5gZ
i3uLZmpXsMuVVmyVi3Z2wHfsPagWN1JT40aZ+l52csngUfg2g5WtJVU0o7OC
fwo7y915bEa9b2/iXcmCdJXzbPZ0so+aw4/Ct9ku+5/4qfC5zzQZxnSVb4fI
3NJMrSVqR1BLoNYL3FvrTjW19M5Ab4POWdGMvpHYF6B3A3T2lKHrDpPl9DJ3
5pfjOYdSD0rMJWGlVe6v5ajUf7CSPVXjSsFnMwwoMXfUldT+Us1ArvbHUBpB
iXk/rGTP2Vj5USmDEtcz9t5BTWmSu7Oy8uS8mQSUeE9WqfpllPurxymUpg9W
6stz4nkAM89xQImzpK7UkXs6hydPveZQ4plkWMnWiDzVptIJlFhP3aFUrbWi
cwm/DDqnPp3UrS7V6mpytYIzP/P87uwDeC7nGlye/i7BZT2r+uOguKz6YXd2
KD3SeTK48tFrUZv5fV9d52Pr3XJast+bHU1ci1eNDFWRkTcAT+9ukipWH4t1
zwVsnvtvvDHW+5S5maOYZ09Pa7HWmfbc2sdSj+DKeTb+qJjHOYvVGFV1/uoe
UnW2z9Yqz6k6fWH7qBwW6rtpy9NWnvmeC2Nq+6MEmPZcH5jxNtJ+YNubGMr2
We5/a/extEvtne9EzbWCGf0L6bdWqWPf9NDzu52e5FXqfJOb3GS8Z7n73qLy
Uu8/E1t5BE+eP8/dE6zQyb7qF/UozXm1fSNHr2thmrc1HBfc5a9zp5bUO1nF
pNdSmPrtVW3+cN4uxNu8Nb4QJr2ORFlnjogZn/nKnt7caG9mG64rdrfyqfa2
72Tp1ZYInmsvN9uq0ZYI42t99Vnx2S6sF9qKDv4DvHYtVg==\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215074798],

Cell["Polygons with multiple vertices:", "ExampleText",
 CellID->108829176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", "\[Pi]", " ", 
         RowBox[{"k", "/", "6"}]}], "]"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "\[Pi]", " ", 
         RowBox[{"k", "/", "6"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224599039],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[
   NCache[{{1, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
     Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-1, 0}, {
     Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
     Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{1, 0}, {0.5, 
     0.8660254037844386}, {-0.5, 0.8660254037844386}, {-1, 
     0}, {-0.5, -0.8660254037844386}, {
     0.5, -0.8660254037844386}}]]]], "Output",
 ImageSize->{104, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->77718227]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", "\[Pi]", " ", 
         RowBox[{"k", "/", "6"}]}], "]"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "\[Pi]", " ", 
         RowBox[{"k", "/", "6"}]}], "]"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246236988],

Cell[BoxData[
 Graphics3DBox[
  Polygon3DBox[
   NCache[{{1, 0, 0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2], 0}, {
     Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2], 0}, {-1, 0, 0}, {
     Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2], 0}, {
     Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2], 0}}, {{1, 0, 0}, {
     0.5, 0.8660254037844386, 0}, {-0.5, 0.8660254037844386, 0}, {-1, 0, 
     0}, {-0.5, -0.8660254037844386, 0}, {
     0.5, -0.8660254037844386, 0}}]]]], "Output",
 ImageSize->{104, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->243215421,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzlmdtuEzEQht3dzSYpTZqUnmhIDxBBS48cSylCSEjlioeIIFJ7UYGAJ+KR
eJ8VeMb/tu5vt1kKEhJESrKzM/4ytmds7+Td8Ovx6HT49eT9cPXt5+Gn45P3
X1aPPn62t9IJY8wH+z5dNPb6h73S94eiKIx5Yz+T0Wi0otJr+5layaT2YqQv
s6yaV7DLRBITZ2D6qj1EuzyqPUDbpkiZ0zqD26rfh36KWjvtE7DbQeue6h+h
dVek2pkejCW12QXj5hU22+DMe17IZULyglo/AHGRtCnJSjPrYPcqWd+DdZ+0
Gclzan0XnqxUsl4D+w5payTPqvUy2APS5iTruOp8Cft+JetbYG+Qtk7yjFov
gL1VyXoO1jukbZCsMaNt5ObDMdYdte6A/aSSdQvsZ6Rtkjyt1jfAPqhk3YT1
IWknSdbMMUd09wbJLbVqgPmysrWfsezJVEx2cxZk4YvYL7AHwXxzdu5fi8J5
yLPVjo1wQOGMe3otCmcix9k0yc0ohXPuMckdkhtRCsuPKlH4tzl6ZZ3I7RbE
PenGfj2gcXTLOpJYWv7tu37zKLOPcSrHt6wgqaVNWqp8s75cBeI95rjvgtaB
jzwi5SpR7ruX+8nx3AJ5Dn7GRktEjs08So9FqPjbg99MqYMejb6AzvOdw/cV
0DmXM9B57DVDgjzh6ElAH4DunR0K70Qxlqs7irQ15WvDEr07I5w9KnkonmxJ
e7lvv/UykgtxQht92mEC+sjREadMwY+HRKkhhjjD4hT3W9YcrXeJ1ii75sXK
n6fyrqsRGsRp+69Q60TlrK9G3SNq/t9Ta0TleI1Tp8fMVjUqnxQ6v0jltSz9
56kZUXlv/JvUTfuhC7ksoA5ekcx7VZfI67KWWnVOfifXos8QfQB6cwyd94Ok
En0N9Fa5z+G+Cc5S1Xh9jHLX89b8Ek1gS/BqvqS4bgY7Z5xSnudmQVnAXnfV
6SdOWgSphV6VJI61OM0/4fVBqns+ZSY8hcdn0SetgqTBOypfpWfRp7CxPOlb
ghHLIrPFlIl4/4QiwsXTl5zT4d0ccXjVCblL4PLZIfPGUzzm2sx48jz6zft/
3R/fs3Ngn6x4xwj5N+E5j51reZ63XMvhfbMkX1zZRORs2CaZexaSymeRGbLk
WgpHaUhqYjR5hncjpAkrCiGk5PDn1m9RUlBuU6s9kvNLKbpNjMI6G1eNagEh
Vm/j5/GsUiuuBaRhK7Jgb8cT5E4S6SdXM5KgJecjjzVXVXyCe1pMIjOkFZ2a
v3rITLg2HM0cI8+LgmrGrh3nE68Ul7WbhI9s79frzr3jLOc8eAGas25BYqvD
C6PE+c1ZKp6kZ9a8ZvNzqsypdNOdbbuFV0mnHKmVq6Kr3l6xz22B6SqEs2Cy
1TqsXAWWa+68Ug8KbyU5qwWz1Qr81CgIYoFjpQem+39jibS8ui3AWjNS24oH
seqzeHBPrfqkjT3nCHNTrZeL8B8WuZyEla53ujOH2dCAja4qWuNPQRJTzSD9
n0AkrewaM/ETLJf+Og==\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Polygon Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->59281063],

Cell[TextData[{
 "Color directives specify the face colors of polygons: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->8993,
  ButtonNote->"8993"]
}], "ExampleText",
 CellID->14992635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193705270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], 
     PolygonBox[
      NCache[{{1, 0}, {0, 3^Rational[1, 2]}, {-1, 0}}, {{1, 0}, {
        0, 1.7320508075688772`}, {-1, 0}}]]}], ",", 
   GraphicsBox[
    {RGBColor[0, 1, 0], 
     PolygonBox[
      NCache[{{1, 0}, {0, 3^Rational[1, 2]}, {-1, 0}}, {{1, 0}, {
        0, 1.7320508075688772`}, {-1, 0}}]]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], 
     PolygonBox[
      NCache[{{1, 0}, {0, 3^Rational[1, 2]}, {-1, 0}}, {{1, 0}, {
        0, 1.7320508075688772`}, {-1, 0}}]]}], ",", 
   GraphicsBox[
    {RGBColor[1, 1, 0], 
     PolygonBox[
      NCache[{{1, 0}, {0, 3^Rational[1, 2]}, {-1, 0}}, {{1, 0}, {
        0, 1.7320508075688772`}, {-1, 0}}]]}]}], "}"}]], "Output",
 ImageSize->{452, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->104697334]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2101616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0, 0], Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytmelu20YURmlJ1L7Y8iI5UmxFruLaSequSdAVyI+mQBH0GYxUQAK0aJHm
7QWh5Z25pKijK4+lyoApDjnf+e7MkLPxze3Hd9M/bz++f3s7ev3h9u9379/+
M/r5rw/JpeJeFEW/J/9/9KPk/N/kzP2/ms/nUXE6nc7dX3Quh+in5BgnF0cu
9UNyLCSpov76q98mRxGWJFVKWB6SHD3jpeYuSypO7s9yWdTnueappIxZmq2A
uIYu/1fqWcsxff7kPKJm4DRfqEdDUuVMk8ls1Y2qmu5upoqKcoiz3FoaH91T
ja4FTckJvZvcouOpU1+rYwfq+F7qS/Xeh7oMdRHqvlNP1PtwnVp+5dRUX6j6
COoK1CWoe0490siPoa5CHUN94tRn6t2DuuYq3qtnprvXD9S9D319RU9/F6+r
ffF/AH3jnvqe6oeWPs70a+rA1bg7ysWHYDRNRhkM1+ZRV+M4B6O1AWN/nusf
cox2riXltODS/oGUrGyZrqO1tFSPQOsEaKyjA0draGwXoO2DVgzE5mk1pU02
pDE297ZG1TW07oYlXdDSq/Les8SHG8bYWVBL2VWjXY4CXD4z7QV3pT/lU3i8
PTt31ezpcy4ncCkFXFw/H1VwlU/MKVx6O3FhK7H/CrmQ1zRdGMsJXPpwiQMu
DdOFaY4jpztx4dPQhcuDgAv1ddOlhjTH4wFcygEXx1tphwbSbbgMd+LSRJrz
mpAL66JqurTMsi1cHsKlEiiL7dI222nhchZwYVkqpkvHypVzOQ+41KEvmy77
SMdwGcGlGiiLd2GP0kW6CJdxoCxClQGjatIPkS5sSJdostUH68KeJy1GrwQz
WVdHU/cXZauS+7E1neijxxvWvk3lbHhtvBtR2bMy1lrg3bKpXDVcbkVlSzJW
UuuBUcCmMtZPA1TGWjKpHEuudkI9APUa1EagBmwqR6QnO6Fy1fp0KyrXl4yV
1KbR54SpjPXZTqgcgz/bCZVjrlDdLkGAVjRp3M2Q+pTbhQ1jtekcua+VXgad
z4JN52ydsV8qvR6gs7ey6Yz9k5lfvnPtyjf5fvQ66GONnSu87eicy4yUzvUM
6XyHbXoV9DOlc77MXp6xF0w6Z0gDrXfOxzjebUfva+wXATprxtNdBelAz1o5
UTJHKc5bwmTGfKRk9v6bk8sgd5XMnsqaa91N5gy0o634JchcIYTJJZBbGvML
kLlaY23sBcl1JX8XIDPmlLx+plxV8o//m8xZcqz1/CpA5nuh5Di74tNOJ9le
g8fdgzW8pRl2UVm/gsW9m7tZvqxy+zeLE2cc37Dah4lYbr3ZQJOPQd4U+VTw
C/TcgZPY95LbEvPyEyZcGbEqySW2TsGMwj/71gxIGN/PtL1mWeOr2bK/PNXp
frjons8i7EOvajj+DlR7Y3qulplzuTOkhXW1EscqJ90HXdFrPPle2yZw/TxA
uq3tenYHabFXTPWRxtFP6yVrQjn3Wu5m9NfUbTetjwzg9dyn6CE9Vn32fcHH
kOk78/z3kIXuSnXZ16SlqA+MkubTn2u9FTKf9HsBc75Yqknepc83c7+K97mP
lclc8gVPiupnyCwZa+zZPL/vwPrnnpbUizSl3/9Mv+Yw10SZfvefzwXX3iNl
+i88Q2Uy11CZ7svRyjvDd7KvuV0+tz+efVvN5TpU57HL9Qh3rXWQMC9d7jHu
WjNkyf3E5U6/+TFXWSO4cbkmubvytJWU8bW7+zg5lpPUS5eK9v4DDttNvw==
\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[0, 1, 0], Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmdtu00AQht34kHOaJk2TtmmSHtJSKFDOIEBIXJQLBDxDhSKBBAIBj9dX
i2BndmK7v8fdJMoFiLrd9f7fP9619/jh8s+XyffLP18/X47e/br8+eXr59+j
ix+/TJa/5nnexPx863nm77/mL/55O51OPX8ymUz5nzeii/fGXEOTuc+p1+Za
MClfftvcl5IKKBUQnSHmahnPzZXAITuY+94VFfEK4LjHpZ8KrUSpyJZOM4dc
6pEwy5QKpdRVHrnPmgdCrqbioP8FuoRxaWsj0dwXTQ00/kxjclBzJrHVQROw
MNZkotxh9W1xXAd1OJf6lqg3ctVcm54P6m1WjyXyFqgjUAeg7rH6ULw3QV2c
Sz0S7w6oS1x1or7S9F3WD8S9C/rynPq+6Hugr2T0Iei3WL8t8e9o+jDR2zpA
Bj81R0Ix9IFRXYDREcYeMGoqIwIGt53XkmcZAKOebsnZl+PHn0CmZttMa0pE
I6A1lqLVJbZ9oDXV5ysCg99sryoRHWmMBSKytLLQxkDbcNCw/fib9Uo5tJaD
hi3ZjGmzXNIeArUNVN8RY4oaxLlKa2w6uBjtesLN9MRDYHeWZ6dy1THiBpfA
4dJQXbCfxd5hy+GC7y+PKZlcbCXsw7orccEn3gKXHriEDpea6oJpHE22V+KC
7YQj3g64RA6XqupShjSOyi4XjLKiulQgjTOH3aVcsLVr2juScumDS9HhUlZd
6lq9plz2HC5Y4yXVpaG2U+IydNTYfC7rkC6Cy2jBZymqLk1Ih+CyvxKXDUgH
C7oQj29Th2gx4oR9VxvSBXA6AKcSOBXECcfqSHXj3iUZyQxmfAOfcmlsVntG
fT4mM3aC5JKlPrAlbqIm9YHUsuO7u6EeUtTj/5jaBuoJUCsOKvP02WWKemsl
VBxXTldCxXHkNlCrjtFKpzaBeuc/puIYdwbUmtL/ZKk4O0PqvQVjDVRqA6j3
V0LF8Zeo1Dc1HE+u03B/g+qTF700uZZQ6ysh0xdAtyNHi+FXr9NxfnAi9Iqj
jnU6rgmQPhY6rlzxK56PXgH6gdQ5rvSQjt+CTsc5zUhixxWHK3ZfpZeAPhA6
zmixh1+Oviv0gYOONaPTcR7Wk3p3zSzmo0dA35LYcZTCGZJOz8yXYI1NAuxR
kYzfTJaMMbeEjP3f4mScja5LXT8EMs6wsTYKTnJNYn7mIGPMWTLObStCfglk
XHm6yT6QS0J+A2Rcn+eR82fJkZDfOmLGt1fIYZxj06yjdrtwRJrDuzbD9iW2
98DCfZy5WCbxaUHOGksJQwcHH0GN+2q6Gr/4osl6tyTJvh+kozGdjjyw1ewJ
RUyyAvna8N1oSjSvWJMwrqgZM6WlLqbJ3jlpn3LTJto8Hc4AdkV/ntHrz14U
3yHcJcbpnAxcNfWRJTEdqrw1k0Ecy8KdlF1IN4R1bRdCJc12mJHQkRbuxa2T
Pj+ybzjugfRyarkVP9FscWr1jWn6JCPRHYiuNov+mivuI3QgfSrqUFXj/sAm
pM/luQtxlK1p+rQoKflM8m094l30eWIuQVx6dvaBpR5IKTvr7yqtmk7fldJ2
h6onTCxFJ23UgHavdAfuViF9JEx7YoBvBb53IyltT5ZmJ1Pa20kR2JO/AdzF
VURXmPb8dChMLNWWUnxO4O3DXW29RBGccOmDaXI6jHVBzDMuxWcu184OynL/
nO+PU2p6vwLxeMx3j801MqkXnPLW/gHABPWM\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[0, 0, 1], Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1mYlu00AQhrd27JzN2TRJ27RpQyjlLAgVEEJcUkFCwDNUKBJIIBDw4H0B
CzyzE9v5PWWTKFRt0rXn/2Z2vcfs+v3F78/Tbxe/v3y6GL35efHj85dPv0bn
33/Gl/wNY8w0/vvaN/H/f+L/+O9VFEXGn06nEf+YEX2YF/FnIb54yKVn8SeZ
+PG3F39bm6dSKtB3jErvPBb7UO7M+PGnOWCLM9GWqBSSibmMfxMza/VQrMpU
ChIra2g8iHyPNffFd4XvphqPPoLEWqIZsuae+KmBxp9p4guouSOaTdAUWJho
clHusPqmRNlwqH1QD1h9Q3y3QB2k6ktudlU9Ed9tUIegLoC6z+qx+N4CdXEh
9aGou6AuceVn6ktF32P9vsS+DfpyTh+AnhXcR8j/YEX9QPzvgL6S9pTLBJFj
cK25JhTDHjCqSzC6whgCY3MhBj8705a67AOjrjJCYHSY0YwyM0KG0ViCURfG
kcbwU4YnQ1KGYq6HcH82VanVGGhNBw3biMeWKUtsE6C1VqZlr2KMbaD6DmqT
qaXMVdIitbM6tZBcna0FGe6Wg4tPu5Fyc/Mw9h9kFxzseq4lImXuxRHXXYsX
nGVxbth2eCmCflP1os6nGS898BI46mK9oG+0wnm27/CCvJrqBcu4lgwcXrBt
qqoXtOo4vISOuuhecEzjmrzj8IJRVlQvFShj3rDnaDGMsqx6qWp9JONluGRd
rBe15+W8pl72HV6wLiXVS119TqmXg7V4aWhW//BSdHgpql6aUA7By2gBL0m2
naO3oFwA+qGDTjy+TROhxVxRjzaUPfB0BJ5K4MkTTzgXhqo3Hu/pChZjJv/g
01VqI3VG1LMwydMJguSyY2ToVJxtr62Firn2emLFOfs6UCsOaqBScY4+XgsV
dzo3VqKq+WaGegLUqmM90am4ftz8L9RbjhZYjNoE6m1HrDhCdSqubXeWbIGC
Sq0D9e5KVMz1kHoPqDVHC+hUXHeJSnNTfS00evY0LXpLPi2djmcmNAroduho
CRyjOh1zg2OhVxyxL0bHM6KJ0OuO0YEt46t0zDjGQsddHtIxdkvHvQzSR/JU
cbeBs/tq9KHEjtnsanTMknaFjpkf0nFM6/Qi0AdCd2UXi9Ex99qWdsf1D7Ok
xegB0LckdpyvkY59z9KzGRnG3RYyzliYB2PcnpPcEPKDJWPOk7E1atLWZ46Y
3WTMcSsS81Mg4z7KTfaBXBLycwcZe0KejNlyKOTXQMbzhSvIQXLFljkiat3z
NfE8ie/dkrwNq5/L3On2R+DgeZPOIQy9OvgAajyx09WzHUHcd81bjRAkBPug
rhjXVWG8XIKBfa0lDO6jQcowfLaK1lL7yO786LSIXrOcqVq97rjK7Yr/U36I
GQb73ogvkM5qi+L3ABikn89oNTXuiveQIpGMc5F4OVYlyp62z2duxBhCNHlC
DZQDKHeF1EvbNvO2yI4OPPPoKzUkRiutkWxKrX52Ro66sTzX2qwWc17x3KAL
5RPxmsxFU/4RdSvKvqtJVafiM+vPtlQHLHG//0iI1npLSmhF7wb9xGob7uKJ
C73vo0a3GV5PecrZMr21o+a1J1N9iQCtTsTKnpHuwF08JbsmEdgz/l1hotVI
mPY90hDu4o5zV5j2beE+3MW9SU/Y9q3pgUSAVh2x4vcD5hDuavsliuCYrY+i
9F0vZtDEvM1W1BLz6wD1jZLYnLLNREi4spHsIVscS+kJl8zGX1MMRSU=\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 1, 0], Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1mYtuGkcUhse77ALL3YAxGGwc7DhxmsZV0/QSVa0SqakqtX0GK0JKpFat
kjxe36xCyZ4zh2H873EHMLVkYHbP//1nZ3fn+uv1hzfzP68/vH19PX317vrv
N29fv5/+9Ne7/FC8Z4yZ5/9/HJr898f8F/+/WCwW0Xw+P82/jflRSibOf+Tf
dHDKZ77PP+P8SCwR9uhzKSVUismB/0TzrZxNqZTkZ//9x1goxZxwzDPhlqlU
sjE2LGKmjaefY45/Ksyqx3QSo2u+EI9smaUVmIg+EtIZYwX0e8KaJ+JTB03M
H05TcByx+rGom1upLyXfFqhLSzV9538xqIesfiDeHVAna6nvi3of1CmoS6A+
ZPVMMu+CuszpW7UFoH7A+lNx74O+sqb+WPwHQX0C+gPWj8V/CPos6G/1I9GP
QF8L+vMV81XQwSPQ1wv6FPQ91vfFfwL6xvJJd2+LloNldIVxDIymysA8+M6b
tlzH9A6MpuRxDxgt70l0b3HsXuHCneEn2dQkoxnQ2gEa1hG/VaYquZ0DrbM1
zT+KOe4DNQ5Q2zdyRFo3QMO7wa2QqXDVuqPKfbkDN3FHLdrgc9MDdinAbq7Y
3lG1d/Bc+jtxwXYV24IDcEkCLg3VRW1/PZdBwKUM+rrqoraSnsvhVi54FMvY
+g83dKmpLnht2EeNduKC7zL2wkcBF8wyU10yKONIYQwuacClqrrUoNwAl8lO
XOqq68rlOOCCNc6u+rtaqMHbXcoBl7Lq0tJy8VxOduLShnIKLtM1XKhn0Guq
A+US0E+BXlF6Ix7ienMI/Tr2oRyB072AUyRO2Bamqhu/76seLMec/wefLoDq
CJ9Wnd3zykYhVwNvhqWGWtuzABWfnkSlYusaynU9ag+o94GaBWpAp2IbfbET
Ks5tHm54t7ajYq74ZFmqOnr1qJc7oWKv9Ggn1DZQPwNqLUAtqVTs2x7vhIoz
88+BWgcqvvH/JxVHkBqVVxe2omEvTneJTkeBXPF51+m4XkJvATW6aeCurUfH
scGF5J4F6FgzsUrHMcG50Jsb5q7Tq0CfCR1nd/jubUc/kXrH2Qa2bTodZ0pI
n0juOJpFOr4fOh1HSUdCxzHZdvQy0IdCD40u1qPj2GsgdOz/QvRIpSdA78ld
xV4AR3jb0TuS+xOg44hbp/vjPayVlpC/DJDxqS6SMeeGkJ/dmYzj3Ezq+jsg
44wtTI6BXJGcfwiQ8X4VyThiToX8Esi4krE5ORbyKyDjKg/Wxp4lJ+6ILfPK
GNXuLxtmKrwb43g6/XsgL51DGNpE+A3UuG6nq5fzg3Ie+LNGSBzBVuwtbUhN
GC9Y4xhUMsWW3nov92H2Rftc8y85/7ndudHnGKT/6lbvvfwgeVpf7ElpDS3N
I6/Yb+WvacuS8wkwyP+yoI8KepyJjJEj1+LPk3RSJpkgoSmESZCAqxZDKPeF
NPDq1ZtZMqOx8Hcbbl4XaTvLOnFCq8NVhgMoz0Tvdh3cM2Bzx/WDPpQv5Z66
MZtkbdWdhb9Hs1JdiWvkfLoQgfP9r4Vko3sLf+dpFbXcIbRReK1YF7TXR9Vt
x48DYWIU7c9RxdgVKax/vLcPJdquxI7gLK6SnUkGdm3/SDLAqKkw7b7RBM7i
jHMs0XZ/8Hjhrd94UQNx5p0bWUPH3n5V7gqT9wfczhtGtSTqgqNmcBZbskwy
eMTRZ2zrt/z0FFWEeMUx54vijnMsEU85gpzTvPQNl8zeJzlxsVY=\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->260513136]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168303146],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " can be used to specify the styles of the interiors and boundaries: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2054,
  ButtonNote->"2054"]
}], "ExampleText",
 CellID->33725189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FaceForm", "[", "Pink", "]"}], ",", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Directive", "[", 
      RowBox[{"Dashed", ",", "Thick", ",", "Blue"}], "]"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434762952],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], Dashing[{Small, Small}]}], 
   FaceForm[RGBColor[1, 0.5, 0.5]], 
   PolygonBox[{{0, 0}, {0, 1}, {1, 1}, {1, 0}}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->654434413]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FaceForm", "[", "Pink", "]"}], ",", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Directive", "[", 
      RowBox[{"Dashed", ",", "Thick", ",", "Blue"}], "]"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->115120159],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], Dashing[{Small, Small}]}], 
   FaceForm[RGBColor[1, 0.5, 0.5]], 
   Polygon3DBox[{{0, 0, 0}, {1, 1, 0}, {1, 1, 1}, {0, 0, 1}}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->222722227,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNWGtPE0EUXfZR+oCWlodUKlSwoggSVBSfJMZoojH+BqIkmmg06m/2XzQ6
987Z3dnTAYfGDxJY9s6cc/bOnTvPtyc/P55+Ofn56f3J8NX3k28fP73/MXz5
9bspSmaiKPpg/j6vRub9t3nTv+fj8ThKTk9Px/oTbcgjOjbPzBQO1XpqnrGx
Evy3pY/MU4iZo2CeUDgCtu6tvY/aplhp8XXzsq71d6E9J1ZW1EPjimIOoNE5
B7MPTM+LGShmF99aokjEZPcVvQPFS0HobWj3qTYhe1XRI2gPgtBbQK9TbUq2
ehoN4cmQajOyVxS9Du2tIPQatEdUWyN7WdF9aN8IQl8CeodqZ8nW3tOnFO5S
bZ3sRUX3oL0fhF4A+oBqG2RrrkXz8OQu1TbJ7iq6Be37QegG0EdU2yJ7QdF1
oB/9RbtE5yPl151j8ysFaRSNuSX8tU7JT12+cKPECo2LkWIKYXNfzZHdLnWl
VNTMbwPK07Fbhh2bF3HLDi9bLmXXSGHeZ9v8QzstuQuPUmrflSn1+tDj2aDt
a3FlPEij1sxDnIilpaZM3pd9PcY9OqG0CT94fgxjjzTChm6TIYqhxv20QHbT
q7aT51Na5JP5kV7j2aNLto5SO8dUonxghLKi1y7Ov+dpn9pINvGNtepnaD0U
blZyVVTTM/ZEzFFxMvuxUowNf1JEjEfrbJWN+DK7ds444YjVghTnKqOE2by+
PCV2F/5cnNnzMLOSWemHJxfnIi4X5jo9xx4v5jGHa5PtnI4lgDAW99Gzf8Iq
I1IyswmmAHzf41imVSZi+T8wlyg6to28lzv+71nSLtk/rHgikVQZzhwkZhwQ
S7/CERRqAaPJKsQTo/gQGs2AOeQsDVkdpKDt0XAjl5Z8R3UfHvSmYu+CvULs
hb+yBXAT7MvE7vyy+wH3S7FXYYS2r5NC2xM/UkAvbsKHLVKYP1PBbZcgNqCw
7VlFwhQGUNiZWqEPhdseBRdrc0i7o5BcQQzvELfl5zolS/jqA2I2Pf03M8Hu
gs2rb+McdlnSBptntIYnZmBXRk0DrX5O/Hogv4bvvyL+bCA/Af8N8Wvn84s1
XKrfebiVzFCe0mj3J+brIDbvYnRfBB9fkEKGnpsxReJztc/FDXsOLc8dsaPo
+sg7lIx8s8q8CsgpJd/1pZ59TgK/q/4JWtYOPZc77ENix1427+lXwZaW5eeI
vSAlvi0o7kyc/aw6a1WgfV0E00Lbq5yfrvkWxu1PaflQ08DVshG3mcBn8TWy
25QdPKu7mVHeJrBKNzBDdL3KrLqFSqSsNp9eVz22myc9J4ZWyOrwKZbv0zag
k0GnmevYHit0OmP/fdx1ZJzNYyE7J5c8ejhqWSU+pfF5d4+yLz/llQr5fRIz
D9GWsocYwd8WRlKgl6HLKLmJkpDYHQBHgCO8B7Q9N3K/8eny5tjeANvbhfzO
jlEjaNp7Kc43vhkbQtPe7A2gyagBNC8ryjeuJuaEfPzZrDEWoxbx5U1FXaVa
nus60NxW9CbV8vrZAvqWovNbWUbV4IHeNWrc8lrJnxQa97RWclemCr3fi6KZ
P7pFAWo=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24570176],

Cell[TextData[{
 "In 3D, different properties can be specified for the front and back of \
faces using ",
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 ": ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21827,
  ButtonNote->"21827"]
}], "ExampleText",
 CellID->129740532],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", 
      RowBox[{"Yellow", ",", "Blue"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"Sqrt", "[", "3", "]"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->411783593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"p", ",", 
     RowBox[{"ViewPoint", "\[Rule]", "Top"}]}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"p", ",", 
     RowBox[{"ViewPoint", "\[Rule]", "Bottom"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45449775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {FaceForm[RGBColor[1, 1, 0], RGBColor[0, 0, 1]], 
     Polygon3DBox[
      NCache[{{1, 0, 0}, {0, 3^Rational[1, 2], 0}, {-1, 0, 0}}, {{1, 0, 0}, {
        0, 1.7320508075688772`, 0}, {-1, 0, 0}}]]},
    ViewPoint->Top,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmPFr00AUx69N0zTtuq7tunZscxWRISL+IKIiIiJaxhgiMmSISOkC2w8y
mfuP/Lv8U4repbf08mnOhWDgSpu89+59P7kmbe7lHU+vz6Pv0+uL2XQ8uZr+
OL+Y/Ry/v7ySIa8ihDiTn88jIe0/0oo/Z/P5XIhZFEWV2KpK65u0qklEeNKU
ltyKrypi+Dqjtogsgl9ULBXRWX4S0+pTFV+Jpo+qnKqez4ne1+S+sjK/+LDG
/JT5Eb5d6SPzA3zfqqwj8xh+3aoMkHkEP7AqG8g8hN+wKkN9Did637JmNuXm
UIbWrBmt+Kgy9vuXeou3aqN8YzxbuQblGyjtxyyubEP5Gsp2Ccp1KF9BuW5V
dqB8CWWnBOUGlC+g3ChNqf73sVg8v1EuUkS3TOViRDwzZqt4vX8rl/c2OfhU
aWvJN5VDpapTd0s19yeK4CeEfN/g/1Bwhzav/2Nc/yryc/weSid7ID8C2StM
roH8EGSuUi6QfZAfgMz10QVyHeQDkLky5ycHIN8HmSu3C+QGyPdAZs3gAjkE
+S7IoYPkJsj7IDcLk1lP7WXUU66RWY/tZNRjrpFZz21n1HOukVlJDjMqyWJk
1ouDjHrRNTLrzX5GvekauQtyF+Sug+QeyB2Qe4XJfZDbIPcdJG+C3AJ500Hy
AOQQ5EFh8hbIAchbDpKHIPsgDx0h70jXpHnGs60a2o5ufVI0/BHm5mFuo9xz
U6uM6hrtKsdPiIonX7t61K7n+rdnzEy99jFu76xw9b8D0hjjt3Wxlv74hpTy
0/n2jpnpv4PftCpZjU7gh1ZloM/5kd7bM4v3KfmElr83Wrwfy6fvT/A9q5Id
gRP4VbtSmqf6PGZnRdYe+GrffLZUV/4Cv0+QLA==\
\>"]], ",", 
   Graphics3DBox[
    {FaceForm[RGBColor[1, 1, 0], RGBColor[0, 0, 1]], 
     Polygon3DBox[
      NCache[{{1, 0, 0}, {0, 3^Rational[1, 2], 0}, {-1, 0, 0}}, {{1, 0, 0}, {
        0, 1.7320508075688772`, 0}, {-1, 0, 0}}]]},
    ViewPoint->Bottom,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmPtr01AUgG+XpM91fa3dOlmt+MYHiKiIL1TcxDFFfIH4oMzA9oMoc3+6
vxa9p+ma5CO3jXdccLTZPfee70vSluTk7I6O9sPvo6ODvdFw+3D0c/9g79dw
68ehnvIKSqlQvz+sKz3+o0eTdzgej5X6FoZhYTJa0qOvMvL0QP/XWxWtJGc+
y4wfxdFUOkcCMX2UQTCby/RNchN7lOF7xLJeyNyLh8y3iD0j6SPztd7IMReN
RADiFWIzWUTmLuKSkSwhcwdx2UiWp+fzAkTFSFSRuYW4aiRrevNcT9XnZihP
yd9veT2VjcTT9WUjuQzyiTX5GKT5aOsgH4FcMZIrIB9akw9ANoxkA+R9a/Ie
yKaRbIK8C7LlgGyBvHNMRimqvYCUa08E25O3E0crs53FZLRyAvKWkP7sE9IL
C9j4yqwXbwodzOh8ez+5IXXVl7O4ge+Z1/xF3zvvFvHv4Loz8zWYebfJb/Zg
vurMfAVm3ufym32YL8PM+2F+cwDzJWfmizDzTpzfXIT5gjPzeZhZA+Q3l2A+
58x8FuaytbkM8xmYK9bmCsxDZ+bTMLOyym+uwjxwZt6EuWZtZq13KqNi+9/M
rBX7GbWinZm15Loz81pGrWlnZi3ac2buZtSqdmbWsp2MWtbOzIq17czcyqiF
7cyslZvOzA2Y29bmNswrzsx1mDvW5g7MNZhXrc2rMFedmSswd63NXZjLzswl
mHvW5h7MRWfmAOa1fzJv6DBp8xLPsLLUD+c9F/Ia1cexLeHY+sg3dwJ4xd6Q
TRCb5aXUJrLMPQm5q0nfaiCBn/CoARzmXgrrgEHqbJUaYn1R3yqOh8emVJze
c77u2jPENSPJunR7+gmZCVbf7AGau4bFqfslCHOHks9q+buiWR1YmvN1fd8g
9o0kewPvpucLIphljKNux9xOdqoT/mlyAMmZKEt2+iWx95iPu++q8Bc/uVOm
\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->192273717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120891637],

Cell[TextData[{
 "Colors can be specified at vertices using ",
 Cell[BoxData[
  ButtonBox["VertexColors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexColors"]], "InlineFormula"],
 ": ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->29204,
  ButtonNote->"29204"]
}], "ExampleText",
 CellID->2274228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"VertexColors", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3999477],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[
   NCache[{{1, 0}, {0, 3^Rational[1, 2]}, {-1, 0}}, {{1, 0}, {
     0, 1.7320508075688772`}, {-1, 0}}],
   VertexColors->{
     RGBColor[1, 0, 0], 
     RGBColor[0, 1, 0], 
     RGBColor[0, 0, 1]}]]], "Output",
 ImageSize->{104, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->286260863,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"VertexColors", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->371472107],

Cell[BoxData[
 Graphics3DBox[Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}},
   VertexColors->{
     RGBColor[1, 0, 0], 
     RGBColor[0, 1, 0], 
     RGBColor[0, 0, 1]}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->756675226,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Coordinate Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->236940489],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->23630,
  ButtonNote->"23630"]
}], "ExampleText",
 CellID->471505131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{".5", ",", "1"}], "}"}], "]"}], ",", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->539412333],

Cell[BoxData[
 GraphicsBox[PolygonBox[{Scaled[{0, 0}], Scaled[{0.5, 1}], Scaled[{1, 0}]}],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->650289811]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", ".2"}], "}"}], "]"}], ",", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{".5", ",", "1", ",", ".8"}], "}"}], "]"}], ",", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", ".2"}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56458757],

Cell[BoxData[
 Graphics3DBox[
  Polygon3DBox[{
   Scaled[{0, 0, 0.2}], Scaled[{0.5, 1, 0.8}], Scaled[{1, 0, 0.2}]}],
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->223756326,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35973966],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " coordinates in 2D:"
}], "ExampleText",
 CellID->363977525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ImageScaled", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"ImageScaled", "[", 
       RowBox[{"{", 
        RowBox[{".5", ",", "1"}], "}"}], "]"}], ",", 
      RowBox[{"ImageScaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49070823],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[{
   ImageScaled[{0, 0}], ImageScaled[{0.5, 1}], ImageScaled[{1, 0}]}],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->395980281]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->594396467],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " coordinates in 2D: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->5094]
}], "ExampleText",
 CellID->39409126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Offset", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"10", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
      RowBox[{"Offset", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "20"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".5", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"Offset", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6203245],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[{
   Offset[{10, 10}, {0, 0}], Offset[{0, -20}, {0.5, 1}], 
    Offset[{-10, 10}, {1, 0}]}],
  Frame->True]], "Output",
 ImageSize->{154, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->140940822]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2775],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexColors",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17889],

Cell["Polygon with vertex colors:", "ExampleText",
 CellID->301316760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"VertexColors", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->830008806],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[
   NCache[{{1, 0}, {0, 3^Rational[1, 2]}, {-1, 0}}, {{1, 0}, {
     0, 1.7320508075688772`}, {-1, 0}}],
   VertexColors->{
     RGBColor[1, 0, 0], 
     RGBColor[0, 1, 0], 
     RGBColor[0, 0, 1]}]]], "Output",
 ImageSize->{104, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->111348380,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8533092],

Cell["Specify vertex colors for 3D polygons:", "ExampleText",
 CellID->222606742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"VertexColors", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->439135573],

Cell[BoxData[
 Graphics3DBox[Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}},
   VertexColors->{
     RGBColor[1, 0, 0], 
     RGBColor[0, 1, 0], 
     RGBColor[0, 0, 1]}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->424571493,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexNormals",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12069],

Cell["\<\
Compute normal vectors using the cross product of edge vectors:\
\>", "ExampleText",
 CellID->909021973],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19586270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{
    RowBox[{"p2", "-", "p1"}], ",", 
    RowBox[{"p3", "-", "p1"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85845950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36289076]
}, Open  ]],

Cell[TextData[{
 "A triangle with normals pointing in the direction ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->794880732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], ",", 
      RowBox[{"VertexNormals", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "n", ",", "n"}], "}"}]}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->157239568],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0], Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}},
    VertexNormals->{{1, -1, 1}, {1, -1, 1}, {1, -1, 1}}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->67406623,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytmWtvGkcUhtfALnew8QUcCCa4xLWT1L0mUa9SPiSVqqi/wUqREqlVqzQ/
r/8sQu2cmbMXHgaPoSB5vbM77/Oemdmd276++fB2/sfNh3dvbiav3t/89fbd
m78nL/98by6V96Io+s38/T6IzPm/5sz+vVgsFlF5Pp8v7C86k0P0kznG5uLE
pn4wx5JJlfW/u/qtOYqwIqmKYTmIOTrGc82dSCo29z/+k2dRn6eap5oyTB6X
rYS4Rjb/V+pZLzBdfnMeUTO0mi/UoympJNNkMr/qWlUtezdTRWU5xFluLY2L
7rFG14amYoXOTW7R8dSqr9SxC3V8J/WFeu9DnUBdhnpg1TP1Plynlv/m51ef
q/oI6irUFaj7Vj3RyI+hrkEdQ31i1WP17kNdtxXv1A5Ad6cfqvsA+saKnv42
Xlv74n8P+uYd9X3Vj3z6ONOvqQNb4/YoF++D0fIyEjBsm0c9jeMMjPYGjP1F
oX8oMDqFlpTTkk27B1KysmV6ltbWUj0ArRugsY4OLK2psZ2Dtg9aORCbo9WV
NtuQxtjs2xrV1tB6G5Y0p6VX5b1niQ83jLGbUyvZVU+7HAW4fGY6OXelP+VT
eLw9u3DV29MXXE7gUgm42H4+quIqn5hTuPR34sJWYv8VciGv5XVhLCdwGcAl
Drg0vS5Mcxw53YkLn4YeXO4FXKhveF3qSHM8HsIlCbhY3ko7NJHuwGW0E5cW
0pzXhFxYFzWvS9tbttzlPlyqgbL4XTredspdxgEXlqXqden6chVczgIuDegT
r8s+0jFcJnCpBcriXNij9JAuw2UaKItQZcCoeemHSJc2pEs02eqDdeGfJ+Wj
l8HM1tXR3P6ibFVyN7amZW70cMPa91M5G14b70ZU9qyMtR54t/xUrhoutqKy
JRkrqY3AKOCnMtZPA1TGWvFSOZZc7oR6AOoVqM1ADfipHJEe7YTKVevjrahc
XzJWUluePidMZaxPdkLlGPzZTqgcc4VqdwkCtLKXxt0MqU+5XdowVj+dI/eV
0pOPtz8Lfjpn64z9QumNAJ29lZ/O2D8xBxkwuHblm3w3egP0qcbOFd52dM5l
JkrneoZ0vsN+eg30sdI5X2Yvz9hLXjpnSEOtd87HON5tRx9o7OcBOmvG0W0F
6UDPWjlRMkcpzlvCZMZ8pGT2/puTE5B7SmZP5Ztr3U7mDLSrrfglyFwhhMkV
kNsa8zOQuVpjbewFyQ0lfxcgM+aUvH6mXFPyj/+bzFlyrPX8IkDme6HkOLvi
0lYn2V6Bx92DNbylGXZZWb+Axb2b21murHL7Vx8nzjiuYbUPE7Hcer2BphiD
vCnyqeBn6LkDJ7HvmdsS8/ITJlwZsarmElun5I3CPfu+GZAwvreajCEpNVv2
l6c63Q8X3VPbfLm3T8Pxd6jaa6/napk5lxsjLazLlThWOek+6Ipe4yn22n4C
189DpDvaruNbSPleMdVHGscgrZesCeXcabmbMVhTt720PjKA03Ofoo/0VPXZ
9wUXQ6bvLorfQ3Ldpeqyr0lLUR94SlpMf671Vsp80u8FzPlsqSZ5lz7fLNwq
3uU+ViZzyRc8KaqbIbNkrLEni+K+A+ufe1pSL9KUbv8z/ZrDXDNlut1/Phdc
e0+U6b7wjJTJXCNl2i9HK+8M38mB5rb57P549m21kOtQnac21wPc9a2DhHlh
c09x1zdDltyPbO70mx9zJRrBtc01K9yVp62ijK/t3YfmmJjUc5uK9v4Dreub
8g==\
\>"]]
}, Open  ]],

Cell["Using different normals will affect shading: ", "ExampleText",
 CellID->238986113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], ",", 
      RowBox[{"VertexNormals", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "n"}], ",", "n", ",", "n"}], "}"}]}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->220323761],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0], Polygon3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}},
    VertexNormals->{{-1, 1, -1}, {1, -1, 1}, {1, -1, 1}}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[4]=",
 CellID->222896284,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31391],

Cell[TextData[{
 "Define a polygon with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " vertices:"
}], "ExampleText",
 CellID->122104825],

Cell[BoxData[
 RowBox[{
  RowBox[{"ngon", "[", 
   RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
  RowBox[{"Polygon", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", "Pi", " ", "k", " ", 
         RowBox[{"q", "/", "p"}]}], "]"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "Pi", " ", "k", " ", 
         RowBox[{"q", "/", "p"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "p"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111287636],

Cell["Regular polygons:", "ExampleText",
 CellID->197198423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "LightRed", ",", 
        RowBox[{"ngon", "[", 
         RowBox[{"n", ",", "1"}], "]"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "70"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "3", ",", "14"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->410561802],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytXUtwlceVvtLVfQm9kJCQBRICJFmg9/sN8owNTM3gIWXKY+M4JeyZQKpi
oAyOGbsc2aly5FVYBTYptHAN2DUZk1XYxSuXF1m4KhtXViy9ZDELlsx3+nT3
+e/3/1ciqVEVlLj9Ot959enucy5nL964/B/vXLzxs7cv9p9+9+K1yz97+3r/
qavv4qN8XS5X99+5XG67O4ffn+I390d+fo8/+usp+S3//fffu8+f5t52LSPy
d+Hx48dff/311tbW5Z/+9P79+7mP8Wk9Psnlf/jhB9//Jdfz4cOHN2/evHb1
6oMHD548eZJbc7Pit6/dT65+c3Ozfn1trR4E5BqGBwb6+/q2fv3rR48eveXW
G5K/m7799tvt7W1MhJ7dXV1tra3rS0s3L1268/HHr509uzg/jw4fhplv/eY3
mCRXjy65MnpjYvQ489JLWOrOnTtYFUSuunm/++47gEAT+pxZX9+6fv3WBx+c
O3WqXCphCPpj3hnpWQZBQIBPAAVEoBVD0E1Wqd/8+c/rv/788/zTv/41V3z0
pz+Bsv7eXkwL3oCg6QRlQk+LYM0DxOYvfwlO5p5zSPvl7z3gN1iGdc69/PLw
0JDQPj29cf48SMMKP3zzTa4gqzR8++WXaHjt1VeBZcrND1I33U+uXf7KYxov
iXEnCXTEelj/2sWLoDHXIPM0Y56Hv/sdAFy+cAFQarEr59YogQv4CKuC+MmR
EeDE4FxRZiphJkwDosAVEH/r1i1g0bVLkOjw4CAYix7gMJCgd65FxhUwA2SI
haFLwOCpBV8wCHIEtYJa+z7+858333kHn958/32har/jXI/jXFInISHAgDZB
qFjywW9/C67mmh3n7kM9envBCgjErZXHQiAb/XId8lceg65duSLaOupoAWrM
KYPeeQcU6DyNtTinQ485rQFN0BoMhigxHj2xOqZokhnKT/7yF1B2bWND1X7j
Jz+BvgDWsIxtwC8Qws3Ll9Gt02kWBkLhQSpmA3vR4VjgFeAIVy5dEl61B15B
abAqCBJedTpeOY6VH/7xj2lLglT2OQ5hQeUyyHH2LlYNZKAl1yU98rc+/HBy
bEzkqxRAbhA51sI0GK29REfRESBA4KDTA4yAEWMqrAttQG+Ri1u1BJ3c3tpS
VZgcH4ediTYMuPW3796F/oiu9ThsGAW2oSNWFf8zGDQcWEG3l5OjogB6oHKg
DfyFJHMdjg9djsegZ3FmRg3rgKMZv0SP4uSQf/DVV1hb9LXbYcfak6Ojd27f
Vt/UAAGLQ5iehizdHHnMt766KmsddT3AbYyAMDDJQbfKd3/4A2jCGAA77PqA
RWAUDB2E97k+mA6UgFE3f/GLw0EPBV9vL8YKvp6AD3xTfCKRvQ6fk3Yes0JO
Yu2HEl4D+ghWOc42QFXxz3OnT2PCniD9y2+8ce7sWQzWddEH3hdKB5EBW87R
lweGxdlZeNCc65UHynNnzoj0D7t2YAE6aerT9ocPvQyPuHbRzxs3Nt58U9sF
HRAoOplFKQY0WAfEjIVaHbJ9wZuCX0KNm63hziefYHZYMhoOh50L2O/86lee
3ge3b4scoVN91R4GhIoWKtWQPzQCWLB+NaqjhOpAkBuohsfAwEHXY/Pq1c2P
PpLGnsBhxQUoA0GycJ7womhqTmCCIECudHFrNYBDMDkQDRVTaqB10CShtj9S
C8/10UdKjUhKLcB7ArdeHtSDQNHYXsI0SJieCzsJOLf92We54cx2LAELk6bn
XTt6Ql3churQOAvLY7O79tZb0mHIoYEWQn9gKpBk5B3GQdlAinJ388oVmJ54
K10Jqg87F11XStAXi0feJpA8T5R2Bd5jCrAIix93PcAIDJJG5wnz9+/dg5VJ
0zHXDoZvffqp21AclvawDgbGXg3QO0hQ7ajb9cDWI4JyXkHmgaXh35jdrwPQ
0Cuh9HjwoKoAuW5CcoyQ7EvIBAaDPcnLFPOJ9XXR/COEs9Hh2BtsAr2En6Mp
q+kMHMeGILozHHQQ/IECo0e0vMW5OVi/p+T+rVsQqsQxXYRkhJC0B0q9Do9H
HZ6dFW+5j3zWaPAT6C/tiqQt7kgYhV7joRciBbDUax/6Q5OMX9BRzCr86gh7
PkQtTWNBXrJqpMJQjBEK5SQ8EsxYmibCrgB6hAs6P1gCJbH5ZdcYGxN5VxyK
1sBLdJS9ZTJIFY5C9H9v0E5gl/bxuMrMDCzL5Il2oVKpAD+kP3xcO6GYIBSt
URYjTkxTYeeCVxUq9wZLh6IaSui3t/RyAgW4DiWwWSAIkChNLQkPCDUSUYY9
Br4BU6Gplfg1GeQJPRT7aSMkU4SkheQxTZS2kp1PkZ2XHBKdBR95rZgOWgEt
slWwDfpZZnSWS5cQJUtTc/DPcFE2HvSiv8irhVDMEIomksds8BLe3zWTlc+Q
lRcdiuYQsWBDt1mwgeoxzrdDxNiGDQW0Cpu7USEh6OCgeIk5XeXkSQRZ0Scm
UMwRCm1H9Ab3IE3aDlF7fdhDFj5LFq4omgirzoL4CVG/UYlZEABau6HcQxqh
7Yi8oajRIyZsZ8G1Q93gxKWpolx88AD7lTRpO1gKxtp409g5svCCQ7GH/NR8
sFBsz4YCGgX22SzYWL1GNZLezgdeCWqsou04B2CHNCoRPCFyNhQmi4UwHiGl
tZuFL5DdNDgUjeTzF4lX2bxGTyxsq0BW0CjZVXh8hcYv0PgyyWLJtcNIoB7R
emV3xCZv7WCZ19h8AgWAAZ50UCoQkMEvGa+BErwxjYArhlIaFeiMbcTGm0aW
w3jIRuxGqcA/9DpE9TrBxWW1i40NiM9QyOFd46olok9RVMIOvfXee9aLNQLA
vcYsBB+Fzc5WAePBfhtv1l/ObBfr3t42FBLXXbwoTYoCgoP4bH6ziyXSeEVR
Jr1eIYlV4p4CnxFRmCeOvIRGiV2tkKx242UhjAdVopErZBc6vlwqQREMpcmy
PoFCNGJry1DArcK5VmmE16glorIQre+DD2w8a0RtXhZIFqtkFwXaT3R+GBFM
aTcUFoVoO05uPvpVKi5fuHDnzp3oIxLWt0pcKJKnXiFPnSdZrBEXCuTjVsjH
ZaNYpSikRO1LIdYBew0Fjwe9IjvYVZF8EMtKUVhEuUZ2USAft0I+bicUGXrv
fcwK6WWexq+RxL3GXb1apXFGZfZ41jj8Ax9V6YrnUjaKNZJ4gTRqhTQqmwq2
XjgsuC0bbz6Qx58gu9N2/AMf2fy2H9XtgML8vVIh5/WPP86y/mwU0HBQaRpX
m4r6TBTmiXV+ix3WKHbYCQVLVDTom2+qJCoahpNMNi/Nx+xGRTYK2tUSGsl2
k43iBPEqT7vWGvEqmwqjMltW5h2yx9Ouloiz1mg/2QkF88I0ao00KpsK8w55
kuUayZLHn5S/itEu8INechuMz+sg4jrIeCfK2eLML8SVk34htXL0W/jRXcq5
g2L0V/jRMfp5lCd+1Hs4SuE46uA5sinVlWJkgR/dqdZTn9daSXce/TzuOtQf
AoPY9POtrS2EW44yfFyHz3eiLHtk9ee1VgJoeXdwn0e/RP2jjuNHrdRRho/r
8PlOlMm5MjwfqWWleZNcKfpv/KhX08+jlVL/5Ocm/ToIvw7S30nvoN5QNdO7
v1HjEztB/d+otyeoXdfHP2AKob0O/6zD4jshED3SM/3f53ksbvj7xlu7jre4
ZI3m3wkFzAjGZLPYjr5GO3o2FbaX6ng7teh4O7U8m/9W+7Hx0VZ23Avt7KM7
skVX2k5R/667kPpQm9/2ymcbX3sX2wmF8apA7SuZEufxtlfpeNvL+GyUPd5s
InLRn3rWyOZ2QsFno93ibR5v9zs6HuoFJbPx1p691xqXdLy8AX75pY236G2n
eN1mKRIv+JyajcIkXiCNWKF2HW8nPI6+dov3d0Jhq+jZyU7jSxR38NlJqRCv
+PixUVGbCw3kg1bJLnbThV3OsX4vKJOPWSK7USrsToJl+WyncUAaHhw0lHyC
NO+wkuUdaqAwvX22OwW7jV8hjVAUck5VT7lEnlKptDuJ5Uwu2I65lLUjhjuD
eEesVMSIYtcbP6XC7qCZVyXSe6XCzrlxPBgj6y9ncqH2bUDyrs3u85fIB+hd
m519FjJX2b5717ezxuj8Fj0skt2USBZLZBclWn8pa1f0VNod7yJFII1BL/39
jKKw03qZ9H6RNGa3u7oyyWKRNKYc1vfvAYthv/HvAXoHrXfM9mqxQBrB7fE+
3u/tFbLORdKYyi6y1Ha7a9P27c8+82e3StBI/16xEDVe32aSKIB1cXZWXj/n
icpnew+wW6Z54mUj2U1s9+/E8Y7b37VpO1imz3CePvOBur69k+mrRlPgJSRk
L0TmSePbjPd0c5my4hciO+fuCbxcX16W+WcDCngTycpoIlnMBu+xvroqnr6Z
NF5fuOxVI/lOBlOCkERiOotFe82k9zNkvdkvVBbzNhGKaULRTLKI86+vrIje
85voVNAV/8KUfLM0HzNNnkzb9aRoKCzyVirkPeHGjUT7e+9tvPmmjTcUk4Si
lXzkVLBe9BeNayPrji+73rqTb8j2qmHvuxqBxDfkmCuiPTRXRGTeErgpOWmw
rKlAJybBvP4t23CME469pJMT1N5O0p4g+1YcitbemOIs3j73Bm6lsh80g0fb
7S59InALC0HGPq/AUIxmUgmXdubkSRtvb7MdZN9jZN+VBAp7qYp5B5Ie++mn
fhbLrRoN9uVzq7RdYutPPrFVRLOXlyXft5NQHCcU+4I2aNJOispOsu8Rsu9k
tovkgMzOin25Xg2aIwJ3i0ikM2hVzH7TfJdk9lvMd/FWOhp8jc97209YhglL
V5Coz6ZSWsE1v3vuJys/RlaezEDCLNj8LT9IUhr7+iSzQDOlLEtxKM6iWYq6
ip3PjweOQcKWaWUohgiFy0+qynMbJp/dTXY+THaezAoz/dOsMEBHuAF5YviB
sINJ7vWVKz57DfzyuabPhWjDv8LqOlAEv4MdICQDhORA4ERVppbIc25OxvcE
TqMdwaFvR5jqMwKTuXqw2M2rV6WD5urF7DYQeij0gA6L3vQH7YOiQfRYqifw
FAOwNyJ60rWuvfWWj8x6CcsRwtIbZgB2zRo9GixNdB5yPeh6gJyYfaiZkpp9
qBmVznN6m7JzQ6Q3Zh8eSXBGONcX4jz591df+YxKTIhJLIPzcKT59GnR1H7C
1E+Y+sN+5vNE+wO90Bg5dTx65DibyhR1TyhVmaJtCVyWY6UZpcmct4EEF8F7
TKYZvNgQfR5iMvMW8QHCMZFoX/TdMzOC/0jAD42PSd6Wn6tZ3mgTlK5vVXa3
WzOV03w0sbJhfS5gjQm/zj/4fEfNNtFcbs1nTmb8DofYCVTLDtQdUEgKOPZJ
zaKO2eQAItZ8gLye41mNSgDN5M6uBBgM8avPaNsvfTNy2p93VPhc7t5ehCvC
y32Bl+htudzOFtXDVUBbzPyX6ouQ+S+7WIfjRTK3eyToovfNXcGnQTdkn3K8
knxaoAQvYNuWAQ7x+vxul/1eSleRyJoux78EPqdLSuCDZXbJxnSeDtKSEZq3
z/UQo4EfiNost70t8ENz29FX6HFaoH5uD/4dK0kQ28RKEnDFV5LsCTtezPYf
DxYD/oLm3D5XD4FBmsSvtEjGO+iG0oC7LsivUC0EdALLQTlkjFaAaB0Q6EAb
4EGKsQalDFrkIez8eYCGGsRioQknV/hR8ZIOgZYrqGjB5pxU3ZScHmnVDSaI
VTeTwbZVm2FbLYKmQYtztCjC7Vxq441aYwR+JSsjMEqtSatukrUjUyHeqqq6
ic8jvo4FuiSVPAMDQCj26+ZphrQxJ8iR16UaVTfCu1l3mMBvgCQlKH19mAk8
Fm8yMoJhco2xvQ0kC8F2MVLFDnbnQmWVq4UqSrais0utscKoubBzw/SE/GaH
Acrsz0FamTQUqMDc6Ji2MsyulUgfhuhQ/XOuHkvmKmgG2RgAIWIk1sAsvq7o
ZNilABqfwpRefBpqyUCHt5d/d3So9kW9Rp/NYBtb7gefiKd54nqLEH7///ib
O8bDeaovlc+/0M/lSCn28uKLcV+R1nvaWnoanr7ihgry3bz/pT3ysUeuPsQS
4Ct0wRfffZ7q5+ymQbxViJ2+CPKXS85XX4W3kR33P4OX8/c576dmKlI0+eMw
wp9tXIBXwbxQMyiyWq/ubxCryEYT4EAFNBLkoIdqMYQBTpwOVigXF65oazhF
Q6k6OsfA190ojRQ0OPgH+aSI4dATzI9V4C/gfxpC1AM/LhZzI2g0FA2RoXK0
grnVP4FmdcRwMuCU+MwXHP1AAmpgUXKVcf06fgEXIaihFLUVRy38OuYCRzCF
u5wtxrgmBjQnEjSrU4Hpgo6yo9nuj95N7EVS0eLay1I99cEHEvr09mpUAPsA
mctuVq3JgUFJEZFzLa76sADRQHcgTKwp/Diaon9PiKqgidj10ekVisvqKS7T
FQEUBGBFxQFCm+iEee2pj/ARX4h3d3VyFXh3jX9AKSgBI+CZ4DaFupkQ48Co
xJudPy/7oMNfwAxYRn1crDKqQtIU9i+EaxKy3737I0LSQEg0kQrGoEhkH9jY
wJKtoZ/kFEInXHKZnDLBfvHaLn4oAzJUA/sitA96CirAZCw25lBAnaCYWgMn
azvqilqdBdOAzkFgEFtfCkdLiE6AX6OTlwlHkXBMBxywM1AiXsDh6AhxObgs
J5qhsJ9De8RnH5K/5O7d3zIfJmtx0WUFug2ywHyQDWtJmrNV2sGexUjOnpW4
TyMXrKubOAxduHgwhbQtEZPqjvHPhLRMSMeDbcFgFSmCFRC4P5z9/HlJo0t4
sI1XXhEbOiR/yb2kb+8nG3MRvKR4Jv0CVELW1Jgfxg8S1SNItKTVhLGqUuMM
PTNWYWxPRQpnCGMjYTyewAjLBddh+MCokbfd+TtbTtym6/nK7lb7yP4Ggjb4
jInesEdAbcFL+AlQmTuYiDpjYOAra5O4OhLRop4KTxGuJsLltK8I4tW6FRcI
i6cnnARkLcVl2dWKy+4xe8kah+iG0MmgoFGHOqdYIVeIcSFkKbtVZwpXZ/X5
HXD+kXC1EC53gitCPxQXBASTB5wjRPfhqHP6UqUndHt36CHrGw4nLf8Stj/h
6eEXYhA5GDy9Hpu8p29PIdsfblhirdo6IWsjZE6DiiAPM8hGvr6uyOLthM+o
VWuyF/J49yAvLNC0WEcopylY23FC3hXGQ4hyrjoe9lTIDogwxd4Umuf0Niic
3nMnCEs7YXE0lDCVRkRacaxhmL9DQ18fwxwKluPvpgbjraO+augd2p3bt31t
3AhJSm8a7JVaby0tA7kthaYnecfibiRXCM8+wrNfd5l795IxWKq6rDd4fH9n
GW/zfEZ38t5Tb9PHSDZ6v2Xvs2OENY3lYJBejFoXCUsXYemKFq9vsJMUEbmd
I/EyodWd92/d8i/hHcETwnLkFnqCaIw1gD6/doI8aWsKQ18qop4jDN2EoZMw
cF1aD3nrY+St432/vw+ZIjnova9lsUyEuwfPgzSG/hDLw0Lk5neGEPQQgn2Z
COzetoc04ViWJiSsYjrcofh74b2ki1zjmEZwOERCUE0sAmlNEoaDhKGDMMS6
PR8Bxepcn0XDNanNKXuYJTkpSssd8fWD8cWzJYVCb4TlTTKcEMYIRR+haCcU
/iXuxg2YgPkfe6EaCTuo39lj3Z63B33btVyfNvLXU2G8z2ZIYxisPiVgkeOE
gW9v9xKGWbK5zqAt/rVwjDA2xt1S7WGR5BBfI/1uOkP20pzCMJQ4H+j91jBh
4Fv1tkwMFqnECmVfzRZfEv25oZHGL5IcFINlns2QxaQxDAeLiDeXg4SBXzla
iQZ9m7YXso4QTfnMkgmisULjueKuKVi1z0LS+S0LqSmF4Xgq6j9CGPjNqYVo
mKf4g6ufp0jXOJNqiTByFsFc8Jz+tJDGMBqi+njHc4gw8OtfcyYGy8fgOvIp
8q6MgevQsjMpyCdUYRhLxhwugudXJn6NbSIaFijaaKW4Z4biHs61WiY+N5J3
XojeWSP7PSkME6lovYcw8Lv4nkybtFgj5mL4F+9o85JHg7g6G4PtYo0kR85n
S2Nwkra4HIvwSzJnKLBfsSrXe/eeRZ+LNH6F2jlPi22+MYVBJY1o3N8b8rs+
54pkexWLNWK1dI3spWwEXKlYO7cxjWA2WEPMCWgnDJy1k22Rlu1m2XbqWRfI
63B29ipJQTXNKhpifqXPYk1jcFyqirxbCQPnT7E2+xzRK1f8d9aUaZfl7Mqa
tZJeDjVqJaNHqKQwOHuUyBuaoPeRnD01TxhYFzhnODtb17xWds6y0ahysnzC
lTA+mU9YhWEpEWlo8N1IGBYJQ7YumNfZjY81Kwy9928IOyTOM9ZuWbjlFIaV
EGnE2LtEGJYJQzYf6RsEEpXaq8HmJXqCrmTXFzJGsyeuD0xjcD0s8sYiDYRh
lTDUoCFGGtm1vfB73q9k13WYHOoDD3xdyUnaxUspDCcDSnSS7z+pJwQnCEHN
OiXJM/v+e99uvl0rvKJvjwtrZVbk/tNkzVgqs7mK4hPVXgjuXNfEL5LPCMnH
mkGfGZhdExjvW/Cj54R0HVstWtVS1rPijypaV1Nev0C0rhKt2RpiXj9K2J9y
I/+9R8yWj9VP7ja+hqX6mzDZe8uEYJkQZNspZVknfA37w2wEXMdm37jANdtp
BEvVERBgNhKGRcLA/tJXt8fvZCmQz48+2/v8mpVLnssNZCVcv5XGsJCKRJsJ
wzxhyN63LBIt0t7L39mQjcHksNv3DKT3rbmwb8UTQRthmCUM2fGD8Vl10fI/
de+1E+6zxQ+1vx8gjUHjOH1v0ZNZO2GYJgzZcZx5zErQBR+Lxr3bx6LPFsfZ
dxRkfk9LFQZHYdUJuZMwTBIGjqeXad/y3w5ENQusK7vF0zZ+icanMUyG+CHe
VHQThnHCkH2qsfhhT/CMPq97Puyt/jYm+0xAfidR3aLzW3VLGsN4dRx3//79
A4RhlDBkny4tjmsm3zpHvjUbg/mdSrQnvTFaIHtKny71lJ983+8lDMcJA5/y
+Tua+BvWZsivZJ+QLU6zmz31awvk19IYRqrjOLnIJwzDhIFvW3wNTzzXxHNR
6vvTNB7OxrBb3cpOty3HEpGGxtNHCcMQYci+9bJIw76TT+PhKeLzs9161a4w
SmMYDlbvT/lDhGCAEGTfPVqk0R4s0t+fxlsCf3/6zHePPlaKp1vvtWrdASff
dYYJwxHCwHfAcxRp2LebqmecIM/IGLLvgE2KM9SexqDfGps85Y8Qhn7CkH0X
b5FGJ2nzGGmzWixOFz6TINsj2PvaDLWnMRwJ1oBIA+4cVjdOGPoIQ/abiEUa
+oZod4f8PZ2xksxnfMyT12ojr8b3r+k3EX2dSuaPTxKGg4Qh+3XKIo1uooHf
lZuDvfgMgTnynG20u2R+/2YVBs2BT0beM4ShhzDwK+E0RRpxl/fVlYrBvh+i
Nei7z96YJowqZ7v1inVT/tYr/UrYm4g0NPKeJwzdhCH7rdYiDb1Dtvdmfem0
9+b4bazeHrLfau32UTHY7WMaw4EQacTc6yXC0EUYst/MLdI4QL4xvkd43xjr
x7w9ZL+Z2wlognxvGoPmMCQznVYIwz7CsD9EM+f0u7snyW/ou79VND5Pu3h8
f/P2ME5y0HarR47f7et30HTugtOUqsj7BGFoJwxO34uaRRWzOgFmlGjtIx87
SD52P9lFfNP1b7Kqs1YPqFjsexLTWLqCXVx+4w2NwF8gLG2ExfHbMlRjVu0w
8e1Q1B2N4AaJ791kH8fJD6nuYu/SbFX/IoiFsKOBQ5n5PvH/Ioh3qi8SmhZC
42LEUjJXGWigCU/it7dbJHI4WpPmnGm75W7FVyVYi1Q8DZP0HOJCMms4xkMF
9NIcQRAhud4dKWwdqRj9FGFrImwDCWyazaQ5QIKtnyKUw2TJR8mSDwQrgveT
OrvnSVqaT6c5nlr7EquxUjme6Xy6vYloRWP3fyJsjYTNRWQ1MrUOUuRyNHpa
vY/VXEG7j1WrgwlqUaePUE1uWqkmVbIuV9dXF8VKLbhsBIqaq6syrsLWmojp
9fbwXwhbmbCNBmwxqc6w2f8noRHNQPDg/r48RnX+vlzPQBCyr99ye3kxma2L
6WGEsWYNMtKsasmn0PxVzbHT6iKJQNL5qy0U8/8rISwSQlcHYzmDMRsy5q/5
WGcoxCqLU1NSiHNI/6+VEye81sX/tWFxdlYszsnEcq61Nmgj5Fy7LAjLjQT2
bZcb6bRPciOl6CTmRqYzkZtS54IfEc4GwunywSybFfNrNuteiodc/VpeC2qk
nKbP1dTo19VI0xGyPscnnyUvXwG3tJRLZMmL3LUCDDRshPzW6CHE18T8Vima
OZRC6qzN31Pq6eE8Ia0npEsBaTIfGR2bKWq6RrbmNKeM7Q4KAKUDZ7VuQStz
NNdf903M6rOPNdc/1rz57ON0rn85cX7Qm8p/c1RGFJF8/fKlZDa1ZoxXKF56
l6zJrVCBCmllFuiT0sbxcYgbOiYa7OogLC/c14I67kleuFbi+bzwgRSCUur0
oFUuikBpfyHQHvP6lfYixUnXyVbyQYfAUq20KJdKWmoFcgWty/wtx/8D6jVX
NSz/GdSVKyAgXeWS/F+m9Jzw46A1fhdxu7HVIMRainqKg96Tvyr+//q4cCEW
tICJWtCS0/x4cE0LJHLpCqF8IuLXyOaLIP1YyXH59dfRpBVPUDFf3eMrnspx
LsyUjLr/J6DCPMKn/9X+VrWVDG+TVVsF7dHd2alho2u7b5SDS2KP8umX7lP5
LVVTVvd/8piUlA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{427, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->181488764]
}, Open  ]],

Cell["Star polygons:", "ExampleText",
 CellID->375416968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Reap", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"CoprimeQ", "[", 
           RowBox[{"p", ",", "q"}], "]"}], ",", 
          RowBox[{"Sow", "[", 
           RowBox[{"Graphics", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "LightGreen", 
               ",", 
               RowBox[{"ngon", "[", 
                RowBox[{"p", ",", "q"}], "]"}]}], "}"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", "70"}]}], "]"}], "]"}]}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"q", ",", "2", ",", 
          RowBox[{"p", "/", "2"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"p", ",", "5", ",", "12"}], "}"}]}], "]"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->229623322],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {1, 
        0}}, {{-0.8090169943749475, 0.5877852522924731}, {
        0.30901699437494745`, -0.9510565162951535}, {0.30901699437494745`, 
        0.9510565162951535}, {-0.8090169943749475, -0.5877852522924731}, {1, 
        0}}]]},
    ImageSize->70], "\[InvisibleSpace]", 
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{-Sin[Rational[1, 14] Pi], Cos[Rational[1, 14] Pi]}, {-
         Cos[Rational[1, 7] Pi], -Sin[Rational[1, 7] Pi]}, {
        Sin[Rational[3, 14] Pi], -Cos[Rational[3, 14] Pi]}, {
        Sin[Rational[3, 14] Pi], Cos[Rational[3, 14] Pi]}, {-
         Cos[Rational[1, 7] Pi], Sin[Rational[1, 7] Pi]}, {-
         Sin[Rational[1, 14] Pi], -Cos[Rational[1, 14] Pi]}, {1, 
        0}}, {{-0.2225209339563144, 
        0.9749279121818236}, {-0.9009688679024191, -0.4338837391175581}, {
        0.6234898018587335, -0.7818314824680298}, {0.6234898018587335, 
        0.7818314824680298}, {-0.9009688679024191, 
        0.4338837391175581}, {-0.2225209339563144, -0.9749279121818236}, {1, 
        0}}]]},
    ImageSize->70], "\[InvisibleSpace]", 
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{-Cos[Rational[1, 7] Pi], Sin[Rational[1, 7] Pi]}, {
        Sin[Rational[3, 14] Pi], -Cos[Rational[3, 14] Pi]}, {-
         Sin[Rational[1, 14] Pi], Cos[Rational[1, 14] Pi]}, {-
         Sin[Rational[1, 14] Pi], -Cos[Rational[1, 14] Pi]}, {
        Sin[Rational[3, 14] Pi], Cos[Rational[3, 14] Pi]}, {-
         Cos[Rational[1, 7] Pi], -Sin[Rational[1, 7] Pi]}, {1, 
        0}}, {{-0.9009688679024191, 0.4338837391175581}, {
        0.6234898018587335, -0.7818314824680298}, {-0.2225209339563144, 
        0.9749279121818236}, {-0.2225209339563144, -0.9749279121818236}, {
        0.6234898018587335, 
        0.7818314824680298}, {-0.9009688679024191, -0.4338837391175581}, {1, 
        0}}]]},
    ImageSize->70], "\[InvisibleSpace]", 
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{-2^Rational[-1, 2], 2^Rational[-1, 2]}, {0, -1}, {
        2^Rational[-1, 2], 2^Rational[-1, 2]}, {-1, 0}, {
        2^Rational[-1, 2], -2^Rational[-1, 2]}, {0, 
        1}, {-2^Rational[-1, 2], -2^Rational[-1, 2]}, {1, 
        0}}, {{-0.7071067811865475, 0.7071067811865475}, {0, -1}, {
        0.7071067811865475, 0.7071067811865475}, {-1, 0}, {
        0.7071067811865475, -0.7071067811865475}, {0, 
        1}, {-0.7071067811865475, -0.7071067811865475}, {1, 0}}]]},
    ImageSize->70], "\[InvisibleSpace]", 
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{Sin[Rational[1, 18] Pi], Cos[Rational[1, 18] Pi]}, {-
         Cos[Rational[1, 9] Pi], Sin[Rational[1, 9] Pi]}, {
        Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
        Cos[Rational[2, 9] Pi], -Sin[Rational[2, 9] Pi]}, {
        Cos[Rational[2, 9] Pi], Sin[Rational[2, 9] Pi]}, {
        Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-
         Cos[Rational[1, 9] Pi], -Sin[Rational[1, 9] Pi]}, {
        Sin[Rational[1, 18] Pi], -Cos[Rational[1, 18] Pi]}, {1, 0}}, {{
        0.17364817766693033`, 0.984807753012208}, {-0.9396926207859084, 
        0.3420201433256687}, {-0.5, -0.8660254037844386}, {
        0.766044443118978, -0.6427876096865393}, {0.766044443118978, 
        0.6427876096865393}, {-0.5, 
        0.8660254037844386}, {-0.9396926207859084, -0.3420201433256687}, {
        0.17364817766693033`, -0.984807753012208}, {1, 0}}]]},
    ImageSize->70], "\[InvisibleSpace]", 
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{-Cos[Rational[1, 9] Pi], Sin[Rational[1, 9] Pi]}, {
        Cos[Rational[2, 9] Pi], -Sin[Rational[2, 9] Pi]}, {
        Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
        Sin[Rational[1, 18] Pi], -Cos[Rational[1, 18] Pi]}, {
        Sin[Rational[1, 18] Pi], Cos[Rational[1, 18] Pi]}, {
        Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
        Cos[Rational[2, 9] Pi], Sin[Rational[2, 9] Pi]}, {-
         Cos[Rational[1, 9] Pi], -Sin[Rational[1, 9] Pi]}, {1, 
        0}}, {{-0.9396926207859084, 0.3420201433256687}, {
        0.766044443118978, -0.6427876096865393}, {-0.5, 0.8660254037844386}, {
        0.17364817766693033`, -0.984807753012208}, {0.17364817766693033`, 
        0.984807753012208}, {-0.5, -0.8660254037844386}, {0.766044443118978, 
        0.6427876096865393}, {-0.9396926207859084, -0.3420201433256687}, {1, 
        0}}]]},
    ImageSize->70], "\[InvisibleSpace]", 
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-1, 0}, {
        Rational[1, 4] (-1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {1, 
        0}}, {{-0.30901699437494745`, 
        0.9510565162951535}, {-0.8090169943749475, -0.5877852522924731}, {
        0.8090169943749475, -0.5877852522924731}, {0.30901699437494745`, 
        0.9510565162951535}, {-1, 0}, {
        0.30901699437494745`, -0.9510565162951535}, {0.8090169943749475, 
        0.5877852522924731}, {-0.8090169943749475, 
        0.5877852522924731}, {-0.30901699437494745`, -0.9510565162951535}, {1,
         0}}]]},
    ImageSize->70], "\[InvisibleSpace]", 
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{Sin[Rational[3, 22] Pi], Cos[Rational[3, 22] Pi]}, {-
         Sin[Rational[5, 22] Pi], Cos[Rational[5, 22] Pi]}, {-
         Cos[Rational[1, 11] Pi], -Sin[Rational[1, 11] Pi]}, {-
         Sin[Rational[1, 22] Pi], -Cos[Rational[1, 22] Pi]}, {
        Cos[Rational[2, 11] Pi], -Sin[Rational[2, 11] Pi]}, {
        Cos[Rational[2, 11] Pi], Sin[Rational[2, 11] Pi]}, {-
         Sin[Rational[1, 22] Pi], Cos[Rational[1, 22] Pi]}, {-
         Cos[Rational[1, 11] Pi], Sin[Rational[1, 11] Pi]}, {-
         Sin[Rational[5, 22] Pi], -Cos[Rational[5, 22] Pi]}, {
        Sin[Rational[3, 22] Pi], -Cos[Rational[3, 22] Pi]}, {1, 0}}, {{
        0.4154150130018864, 0.9096319953545184}, {-0.654860733945285, 
        0.7557495743542584}, {-0.9594929736144974, -0.28173255684142967`}, \
{-0.14231483827328514`, -0.9898214418809327}, {
        0.8412535328311812, -0.5406408174555976}, {0.8412535328311812, 
        0.5406408174555976}, {-0.14231483827328514`, 
        0.9898214418809327}, {-0.9594929736144974, 
        0.28173255684142967`}, {-0.654860733945285, -0.7557495743542584}, {
        0.4154150130018864, -0.9096319953545184}, {1, 0}}]]},
    ImageSize->70], "\[InvisibleSpace]", 
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{-Sin[Rational[1, 22] Pi], Cos[Rational[1, 22] Pi]}, {-
         Cos[Rational[1, 11] Pi], -Sin[Rational[1, 11] Pi]}, {
        Sin[Rational[3, 22] Pi], -Cos[Rational[3, 22] Pi]}, {
        Cos[Rational[2, 11] Pi], Sin[Rational[2, 11] Pi]}, {-
         Sin[Rational[5, 22] Pi], Cos[Rational[5, 22] Pi]}, {-
         Sin[Rational[5, 22] Pi], -Cos[Rational[5, 22] Pi]}, {
        Cos[Rational[2, 11] Pi], -Sin[Rational[2, 11] Pi]}, {
        Sin[Rational[3, 22] Pi], Cos[Rational[3, 22] Pi]}, {-
         Cos[Rational[1, 11] Pi], Sin[Rational[1, 11] Pi]}, {-
         Sin[Rational[1, 22] Pi], -Cos[Rational[1, 22] Pi]}, {1, 
        0}}, {{-0.14231483827328514`, 
        0.9898214418809327}, {-0.9594929736144974, -0.28173255684142967`}, {
        0.4154150130018864, -0.9096319953545184}, {0.8412535328311812, 
        0.5406408174555976}, {-0.654860733945285, 
        0.7557495743542584}, {-0.654860733945285, -0.7557495743542584}, {
        0.8412535328311812, -0.5406408174555976}, {0.4154150130018864, 
        0.9096319953545184}, {-0.9594929736144974, 
        0.28173255684142967`}, {-0.14231483827328514`, -0.9898214418809327}, {
        1, 0}}]]},
    ImageSize->70], "\[InvisibleSpace]", 
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{-Sin[Rational[5, 22] Pi], Cos[Rational[5, 22] Pi]}, {-
         Sin[Rational[1, 22] Pi], -Cos[Rational[1, 22] Pi]}, {
        Cos[Rational[2, 11] Pi], Sin[Rational[2, 11] Pi]}, {-
         Cos[Rational[1, 11] Pi], Sin[Rational[1, 11] Pi]}, {
        Sin[Rational[3, 22] Pi], -Cos[Rational[3, 22] Pi]}, {
        Sin[Rational[3, 22] Pi], Cos[Rational[3, 22] Pi]}, {-
         Cos[Rational[1, 11] Pi], -Sin[Rational[1, 11] Pi]}, {
        Cos[Rational[2, 11] Pi], -Sin[Rational[2, 11] Pi]}, {-
         Sin[Rational[1, 22] Pi], Cos[Rational[1, 22] Pi]}, {-
         Sin[Rational[5, 22] Pi], -Cos[Rational[5, 22] Pi]}, {1, 
        0}}, {{-0.654860733945285, 
        0.7557495743542584}, {-0.14231483827328514`, -0.9898214418809327}, {
        0.8412535328311812, 0.5406408174555976}, {-0.9594929736144974, 
        0.28173255684142967`}, {0.4154150130018864, -0.9096319953545184}, {
        0.4154150130018864, 
        0.9096319953545184}, {-0.9594929736144974, -0.28173255684142967`}, {
        0.8412535328311812, -0.5406408174555976}, {-0.14231483827328514`, 
        0.9898214418809327}, {-0.654860733945285, -0.7557495743542584}, {1, 
        0}}]]},
    ImageSize->70], "\[InvisibleSpace]", 
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{-Cos[Rational[1, 11] Pi], Sin[Rational[1, 11] Pi]}, {
        Cos[Rational[2, 11] Pi], -Sin[Rational[2, 11] Pi]}, {-
         Sin[Rational[5, 22] Pi], Cos[Rational[5, 22] Pi]}, {
        Sin[Rational[3, 22] Pi], -Cos[Rational[3, 22] Pi]}, {-
         Sin[Rational[1, 22] Pi], Cos[Rational[1, 22] Pi]}, {-
         Sin[Rational[1, 22] Pi], -Cos[Rational[1, 22] Pi]}, {
        Sin[Rational[3, 22] Pi], Cos[Rational[3, 22] Pi]}, {-
         Sin[Rational[5, 22] Pi], -Cos[Rational[5, 22] Pi]}, {
        Cos[Rational[2, 11] Pi], Sin[Rational[2, 11] Pi]}, {-
         Cos[Rational[1, 11] Pi], -Sin[Rational[1, 11] Pi]}, {1, 
        0}}, {{-0.9594929736144974, 0.28173255684142967`}, {
        0.8412535328311812, -0.5406408174555976}, {-0.654860733945285, 
        0.7557495743542584}, {
        0.4154150130018864, -0.9096319953545184}, {-0.14231483827328514`, 
        0.9898214418809327}, {-0.14231483827328514`, -0.9898214418809327}, {
        0.4154150130018864, 
        0.9096319953545184}, {-0.654860733945285, -0.7557495743542584}, {
        0.8412535328311812, 
        0.5406408174555976}, {-0.9594929736144974, -0.28173255684142967`}, {1,
         0}}]]},
    ImageSize->70], "\[InvisibleSpace]", 
   GraphicsBox[
    {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0]], 
     PolygonBox[
      NCache[{{Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {0, 1}, {
        Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
        Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}, {-1, 0}, {
        Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {0, -1}, {
        Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
        Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {1, 
        0}}, {{-0.8660254037844386, 0.5}, {0.5, -0.8660254037844386}, {0, 
        1}, {-0.5, -0.8660254037844386}, {0.8660254037844386, 0.5}, {-1, 0}, {
        0.8660254037844386, -0.5}, {-0.5, 0.8660254037844386}, {0, -1}, {0.5, 
        0.8660254037844386}, {-0.8660254037844386, -0.5}, {1, 0}}]]},
    ImageSize->70]}],
  Row[{
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{
        Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {1, 0}}]}, 
     ImageSize -> 70], 
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{-Sin[Rational[1, 14] Pi], 
         Cos[Rational[1, 14] Pi]}, {-Cos[Rational[1, 7] Pi], -
         Sin[Rational[1, 7] Pi]}, {
         Sin[Rational[3, 14] Pi], -Cos[Rational[3, 14] Pi]}, {
         Sin[Rational[3, 14] Pi], 
         Cos[Rational[3, 14] Pi]}, {-Cos[Rational[1, 7] Pi], 
         Sin[Rational[1, 7] Pi]}, {-Sin[Rational[1, 14] Pi], -
         Cos[Rational[1, 14] Pi]}, {1, 0}}]}, ImageSize -> 70], 
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{-Cos[Rational[1, 7] Pi], 
         Sin[Rational[1, 7] Pi]}, {
         Sin[Rational[3, 14] Pi], -Cos[Rational[3, 14] Pi]}, {-
         Sin[Rational[1, 14] Pi], 
         Cos[Rational[1, 14] Pi]}, {-Sin[Rational[1, 14] Pi], -
         Cos[Rational[1, 14] Pi]}, {
         Sin[Rational[3, 14] Pi], 
         Cos[Rational[3, 14] Pi]}, {-Cos[Rational[1, 7] Pi], -
         Sin[Rational[1, 7] Pi]}, {1, 0}}]}, ImageSize -> 70], 
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{-2^Rational[-1, 2], 2^Rational[-1, 2]}, {0, -1}, {
        2^Rational[-1, 2], 2^Rational[-1, 2]}, {-1, 0}, {
        2^Rational[-1, 2], -2^Rational[-1, 2]}, {0, 
        1}, {-2^Rational[-1, 2], -2^Rational[-1, 2]}, {1, 0}}]}, ImageSize -> 
     70], 
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{
         Sin[Rational[1, 18] Pi], 
         Cos[Rational[1, 18] Pi]}, {-Cos[Rational[1, 9] Pi], 
         Sin[Rational[1, 9] Pi]}, {
         Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
         Cos[Rational[2, 9] Pi], -Sin[Rational[2, 9] Pi]}, {
         Cos[Rational[2, 9] Pi], 
         Sin[Rational[2, 9] Pi]}, {
         Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-
         Cos[Rational[1, 9] Pi], -Sin[Rational[1, 9] Pi]}, {
         Sin[Rational[1, 18] Pi], -Cos[Rational[1, 18] Pi]}, {1, 0}}]}, 
     ImageSize -> 70], 
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{-Cos[Rational[1, 9] Pi], 
         Sin[Rational[1, 9] Pi]}, {
         Cos[Rational[2, 9] Pi], -Sin[Rational[2, 9] Pi]}, {
         Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
         Sin[Rational[1, 18] Pi], -Cos[Rational[1, 18] Pi]}, {
         Sin[Rational[1, 18] Pi], 
         Cos[Rational[1, 18] Pi]}, {
         Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
         Cos[Rational[2, 9] Pi], 
         Sin[Rational[2, 9] Pi]}, {-Cos[Rational[1, 9] Pi], -
         Sin[Rational[1, 9] Pi]}, {1, 0}}]}, ImageSize -> 70], 
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{
        Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-1, 0}, {
        Rational[1, 4] (-1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {1, 0}}]}, 
     ImageSize -> 70], 
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{
         Sin[Rational[3, 22] Pi], 
         Cos[Rational[3, 22] Pi]}, {-Sin[Rational[5, 22] Pi], 
         Cos[Rational[5, 22] Pi]}, {-Cos[Rational[1, 11] Pi], -
         Sin[Rational[1, 11] Pi]}, {-Sin[Rational[1, 22] Pi], -
         Cos[Rational[1, 22] Pi]}, {
         Cos[Rational[2, 11] Pi], -Sin[Rational[2, 11] Pi]}, {
         Cos[Rational[2, 11] Pi], 
         Sin[Rational[2, 11] Pi]}, {-Sin[Rational[1, 22] Pi], 
         Cos[Rational[1, 22] Pi]}, {-Cos[Rational[1, 11] Pi], 
         Sin[Rational[1, 11] Pi]}, {-Sin[Rational[5, 22] Pi], -
         Cos[Rational[5, 22] Pi]}, {
         Sin[Rational[3, 22] Pi], -Cos[Rational[3, 22] Pi]}, {1, 0}}]}, 
     ImageSize -> 70], 
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{-Sin[Rational[1, 22] Pi], 
         Cos[Rational[1, 22] Pi]}, {-Cos[Rational[1, 11] Pi], -
         Sin[Rational[1, 11] Pi]}, {
         Sin[Rational[3, 22] Pi], -Cos[Rational[3, 22] Pi]}, {
         Cos[Rational[2, 11] Pi], 
         Sin[Rational[2, 11] Pi]}, {-Sin[Rational[5, 22] Pi], 
         Cos[Rational[5, 22] Pi]}, {-Sin[Rational[5, 22] Pi], -
         Cos[Rational[5, 22] Pi]}, {
         Cos[Rational[2, 11] Pi], -Sin[Rational[2, 11] Pi]}, {
         Sin[Rational[3, 22] Pi], 
         Cos[Rational[3, 22] Pi]}, {-Cos[Rational[1, 11] Pi], 
         Sin[Rational[1, 11] Pi]}, {-Sin[Rational[1, 22] Pi], -
         Cos[Rational[1, 22] Pi]}, {1, 0}}]}, ImageSize -> 70], 
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{-Sin[Rational[5, 22] Pi], 
         Cos[Rational[5, 22] Pi]}, {-Sin[Rational[1, 22] Pi], -
         Cos[Rational[1, 22] Pi]}, {
         Cos[Rational[2, 11] Pi], 
         Sin[Rational[2, 11] Pi]}, {-Cos[Rational[1, 11] Pi], 
         Sin[Rational[1, 11] Pi]}, {
         Sin[Rational[3, 22] Pi], -Cos[Rational[3, 22] Pi]}, {
         Sin[Rational[3, 22] Pi], 
         Cos[Rational[3, 22] Pi]}, {-Cos[Rational[1, 11] Pi], -
         Sin[Rational[1, 11] Pi]}, {
         Cos[Rational[2, 11] Pi], -Sin[Rational[2, 11] Pi]}, {-
         Sin[Rational[1, 22] Pi], 
         Cos[Rational[1, 22] Pi]}, {-Sin[Rational[5, 22] Pi], -
         Cos[Rational[5, 22] Pi]}, {1, 0}}]}, ImageSize -> 70], 
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{-Cos[Rational[1, 11] Pi], 
         Sin[Rational[1, 11] Pi]}, {
         Cos[Rational[2, 11] Pi], -Sin[Rational[2, 11] Pi]}, {-
         Sin[Rational[5, 22] Pi], 
         Cos[Rational[5, 22] Pi]}, {
         Sin[Rational[3, 22] Pi], -Cos[Rational[3, 22] Pi]}, {-
         Sin[Rational[1, 22] Pi], 
         Cos[Rational[1, 22] Pi]}, {-Sin[Rational[1, 22] Pi], -
         Cos[Rational[1, 22] Pi]}, {
         Sin[Rational[3, 22] Pi], 
         Cos[Rational[3, 22] Pi]}, {-Sin[Rational[5, 22] Pi], -
         Cos[Rational[5, 22] Pi]}, {
         Cos[Rational[2, 11] Pi], 
         Sin[Rational[2, 11] Pi]}, {-Cos[Rational[1, 11] Pi], -
         Sin[Rational[1, 11] Pi]}, {1, 0}}]}, ImageSize -> 70], 
    Graphics[{
      EdgeForm[
       GrayLevel[0]], 
      RGBColor[0.88, 1, 0.88], 
      Polygon[{{Rational[-1, 2] 3^Rational[1, 2], 
         Rational[1, 2]}, {
         Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {0, 1}, {
         Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
        Rational[1, 2] 3^Rational[1, 2], 
         Rational[1, 2]}, {-1, 0}, {Rational[1, 2] 3^Rational[1, 2], 
         Rational[-1, 2]}, {
         Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {0, -1}, {
         Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
        Rational[-1, 2] 3^Rational[1, 2], 
         Rational[-1, 2]}, {1, 0}}]}, ImageSize -> 70]}]]], "Output",
 ImageSize->{431, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->591932692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41617689],

Cell["Define the regular hexagon:", "ExampleText",
 CellID->171265380],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"Polygon", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"2", "Pi", " ", 
          RowBox[{"k", "/", "6"}]}], "]"}], "+", "x"}], ",", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"2", "Pi", " ", 
          RowBox[{"k", "/", "6"}]}], "]"}], "+", "y"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "6"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141910737],

Cell["The regular hexagon tiling:", "ExampleText",
 CellID->64374289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Opacity", "[", ".7", "]"}], "]"}], ",", "LightBlue", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"h", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"3", "i"}], "+", 
         RowBox[{"3", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}], "^", "j"}], "+", "1"}], ")"}], "/", 
           "4"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Sqrt", "[", "3", "]"}], "/", "2"}], "j"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "10"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16518451],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->269004477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147312004],

Cell[TextData[{
 "Get face polygons from ",
 Cell[BoxData[
  ButtonBox["PolyhedronData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyhedronData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->123437608],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Normal", "[", 
    RowBox[{"N", "[", 
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<TruncatedIcosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], 
     "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113072100],

Cell["Shrink each face with respect to the centroid:", "ExampleText",
 CellID->373148642],

Cell[BoxData[
 RowBox[{
  RowBox[{"shrink", "[", 
   RowBox[{"t_", ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"x_List", ",", "opts___"}], "]"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", "=", 
      RowBox[{
       RowBox[{"Plus", "@@", "x"}], "/", 
       RowBox[{"Length", "[", "x", "]"}]}]}], "}"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "t"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"#", "-", "c"}], ")"}]}]}], ")"}], "&"}], ",", "x"}], 
       "]"}], ",", "opts"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->847443274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FaceForm", "[", 
        RowBox[{"Yellow", ",", "Green"}], "]"}], ",", 
       RowBox[{"p", "/.", 
        RowBox[{"y_Polygon", "\[RuleDelayed]", 
         RowBox[{"shrink", "[", 
          RowBox[{"s", ",", "y"}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2.5"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", ".8"}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
   RowBox[{"AnimationDirection", "\[Rule]", "ForwardBackward"}], ",", 
   RowBox[{"DefaultDuration", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37382128],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`s$$ = 0.16, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`s$$], 0, 0.8}}, Typeset`size$$ = {180., {95., 100.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`s$213421$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`s$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`s$$, $CellContext`s$213421$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{
         FaceForm[Yellow, Green], 
         ReplaceAll[$CellContext`p, Pattern[$CellContext`y$, 
            Blank[
            Polygon]] :> $CellContext`shrink[$CellContext`s$$, \
$CellContext`y$]]}, PlotRange -> 2.5], 
      "Specifications" :> {{$CellContext`s$$, 0, 0.8, AnimationRunning -> 
         False, AnimationDirection -> ForwardBackward, DefaultDuration -> 1, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 2.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{327., {132., 137.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`p = {{
          
          Polygon[{{0.85065080835204, 0., 2.327438436766327}, {
           0.2628655560595668, 0.8090169943749475, 
           2.327438436766327}, {-0.6881909602355868, 0.5, 
           2.327438436766327}, {-0.6881909602355868, -0.5, 
           2.327438436766327}, {0.2628655560595668, -0.8090169943749473, 
           2.327438436766327}}], 
          
          Polygon[{{1.9641671727636467`, -0.8090169943749473, 
           1.2759762125280598`}, {2.3894925769396664`, -0.5, 
           0.42532540417601994`}, {2.3894925769396664`, 0.5, 
           0.42532540417601994`}, {1.9641671727636467`, 0.8090169943749475, 
           1.2759762125280598`}, {1.7013016167040798`, 0., 
           1.8017073246471935`}}], 
          
          Polygon[{{0.5257311121191336, 1.618033988749895, 
           1.8017073246471935`}, {1.3763819204711736`, 1.618033988749895, 
           1.2759762125280598`}, {1.2139220723547204`, 2.118033988749895, 
           0.42532540417601994`}, {0.2628655560595668, 2.4270509831248424`, 
           0.42532540417601994`}, {-0.16245984811645317`, 2.118033988749895, 
           1.2759762125280598`}}], 
          
          Polygon[{{-1.3763819204711736`, 1., 
           1.8017073246471935`}, {-1.1135163644116066`, 1.8090169943749475`, 
           1.2759762125280598`}, {-1.6392474765307403`, 1.8090169943749475`, 
           0.42532540417601994`}, {-2.2270327288232137`, 1., 
           0.42532540417601994`}, {-2.0645728807067605`, 0.5, 
           1.2759762125280598`}}], 
          
          Polygon[{{-1.3763819204711736`, -1., 
           1.8017073246471935`}, {-2.0645728807067605`, -0.5, 
           1.2759762125280598`}, {-2.2270327288232137`, -1., 
           0.42532540417601994`}, {-1.6392474765307403`, -1.8090169943749475`,
            0.42532540417601994`}, {-1.1135163644116066`, \
-1.8090169943749475`, 1.2759762125280598`}}], 
          
          Polygon[{{-0.16245984811645317`, -2.118033988749895, 
           1.2759762125280598`}, {0.2628655560595668, -2.4270509831248424`, 
           0.42532540417601994`}, {1.2139220723547204`, -2.118033988749895, 
           0.42532540417601994`}, {1.3763819204711736`, -1.6180339887498947`, 
           1.2759762125280598`}, {0.5257311121191336, -1.6180339887498947`, 
           1.8017073246471935`}}], 
          
          Polygon[{{2.0645728807067605`, 0.5, -1.27597621252806}, {
           1.3763819204711736`, 1., -1.8017073246471933`}, {
           1.1135163644116066`, 1.8090169943749475`, -1.27597621252806}, {
           1.6392474765307403`, 1.8090169943749475`, -0.4253254041760197}, {
           2.2270327288232132`, 1., -0.4253254041760197}}], 
          
          Polygon[{{0.16245984811645317`, 
           2.118033988749895, -1.27597621252806}, {-0.5257311121191341, 
           1.618033988749895, -1.8017073246471933`}, {-1.3763819204711736`, 
           1.618033988749895, -1.27597621252806}, {-1.2139220723547204`, 
           2.118033988749895, -0.4253254041760197}, {-0.2628655560595668, 
           2.4270509831248424`, -0.4253254041760197}}], 
          
          Polygon[{{-1.9641671727636467`, 
           0.8090169943749475, -1.27597621252806}, {-1.7013016167040798`, 
           0., -1.8017073246471933`}, {-1.9641671727636467`, \
-0.8090169943749473, -1.27597621252806}, {-2.3894925769396664`, -0.5, \
-0.4253254041760197}, {-2.3894925769396664`, 0.5, -0.4253254041760197}}], 
          
          Polygon[{{-1.3763819204711736`, -1.6180339887498947`, \
-1.27597621252806}, {-0.5257311121191341, -1.6180339887498947`, \
-1.8017073246471933`}, {
           0.16245984811645317`, -2.118033988749895, -1.27597621252806}, \
{-0.2628655560595668, -2.4270509831248424`, -0.4253254041760197}, \
{-1.2139220723547204`, -2.118033988749895, -0.4253254041760197}}], 
          
          Polygon[{{2.2270327288232132`, -1., -0.4253254041760197}, {
           1.6392474765307403`, -1.8090169943749475`, -0.4253254041760197}, {
           1.1135163644116066`, -1.8090169943749475`, -1.27597621252806}, {
           1.3763819204711736`, -1., -1.8017073246471933`}, {
           2.0645728807067605`, -0.5, -1.27597621252806}}], 
          
          Polygon[{{
           0.6881909602355868, -0.5, -2.327438436766327}, \
{-0.2628655560595668, -0.8090169943749473, -2.327438436766327}, \
{-0.8506508083520394, 0., -2.327438436766327}, {-0.2628655560595668, 
           0.8090169943749475, -2.327438436766327}, {0.6881909602355868, 
           0.5, -2.327438436766327}}], 
          
          Polygon[{{0.2628655560595668, -0.8090169943749473, 
           2.327438436766327}, {0.5257311121191336, -1.6180339887498947`, 
           1.8017073246471935`}, {1.3763819204711736`, -1.6180339887498947`, 
           1.2759762125280598`}, {1.9641671727636467`, -0.8090169943749473, 
           1.2759762125280598`}, {1.7013016167040798`, 0., 
           1.8017073246471935`}, {0.85065080835204, 0., 2.327438436766327}}], 
          
          
          Polygon[{{0.85065080835204, 0., 2.327438436766327}, {
           1.7013016167040798`, 0., 1.8017073246471935`}, {
           1.9641671727636467`, 0.8090169943749475, 1.2759762125280598`}, {
           1.3763819204711736`, 1.618033988749895, 1.2759762125280598`}, {
           0.5257311121191336, 1.618033988749895, 1.8017073246471935`}, {
           0.2628655560595668, 0.8090169943749475, 2.327438436766327}}], 
          
          Polygon[{{0.2628655560595668, 0.8090169943749475, 
           2.327438436766327}, {0.5257311121191336, 1.618033988749895, 
           1.8017073246471935`}, {-0.16245984811645317`, 2.118033988749895, 
           1.2759762125280598`}, {-1.1135163644116066`, 1.8090169943749475`, 
           1.2759762125280598`}, {-1.3763819204711736`, 1., 
           1.8017073246471935`}, {-0.6881909602355868, 0.5, 
           2.327438436766327}}], 
          
          Polygon[{{-0.6881909602355868, 0.5, 
           2.327438436766327}, {-1.3763819204711736`, 1., 
           1.8017073246471935`}, {-2.0645728807067605`, 0.5, 
           1.2759762125280598`}, {-2.0645728807067605`, -0.5, 
           1.2759762125280598`}, {-1.3763819204711736`, -1., 
           1.8017073246471935`}, {-0.6881909602355868, -0.5, 
           2.327438436766327}}], 
          
          Polygon[{{-0.6881909602355868, -0.5, 
           2.327438436766327}, {-1.3763819204711736`, -1., 
           1.8017073246471935`}, {-1.1135163644116066`, -1.8090169943749475`, 
           1.2759762125280598`}, {-0.16245984811645317`, -2.118033988749895, 
           1.2759762125280598`}, {0.5257311121191336, -1.6180339887498947`, 
           1.8017073246471935`}, {0.2628655560595668, -0.8090169943749473, 
           2.327438436766327}}], 
          
          Polygon[{{0.6881909602355868, -0.5, -2.327438436766327}, {
           1.3763819204711736`, -1., -1.8017073246471933`}, {
           1.1135163644116066`, -1.8090169943749475`, -1.27597621252806}, {
           0.16245984811645317`, -2.118033988749895, -1.27597621252806}, \
{-0.5257311121191341, -1.6180339887498947`, -1.8017073246471933`}, \
{-0.2628655560595668, -0.8090169943749473, -2.327438436766327}}], 
          
          Polygon[{{-0.2628655560595668, -0.8090169943749473, \
-2.327438436766327}, {-0.5257311121191341, -1.6180339887498947`, \
-1.8017073246471933`}, {-1.3763819204711736`, -1.6180339887498947`, \
-1.27597621252806}, {-1.9641671727636467`, -0.8090169943749473, \
-1.27597621252806}, {-1.7013016167040798`, 
           0., -1.8017073246471933`}, {-0.8506508083520394, 
           0., -2.327438436766327}}], 
          
          Polygon[{{-0.8506508083520394, 
           0., -2.327438436766327}, {-1.7013016167040798`, 
           0., -1.8017073246471933`}, {-1.9641671727636467`, 
           0.8090169943749475, -1.27597621252806}, {-1.3763819204711736`, 
           1.618033988749895, -1.27597621252806}, {-0.5257311121191341, 
           1.618033988749895, -1.8017073246471933`}, {-0.2628655560595668, 
           0.8090169943749475, -2.327438436766327}}], 
          
          Polygon[{{-0.2628655560595668, 
           0.8090169943749475, -2.327438436766327}, {-0.5257311121191341, 
           1.618033988749895, -1.8017073246471933`}, {0.16245984811645317`, 
           2.118033988749895, -1.27597621252806}, {1.1135163644116066`, 
           1.8090169943749475`, -1.27597621252806}, {1.3763819204711736`, 
           1., -1.8017073246471933`}, {0.6881909602355868, 
           0.5, -2.327438436766327}}], 
          
          Polygon[{{0.6881909602355868, 0.5, -2.327438436766327}, {
           1.3763819204711736`, 1., -1.8017073246471933`}, {
           2.0645728807067605`, 0.5, -1.27597621252806}, {
           2.0645728807067605`, -0.5, -1.27597621252806}, {
           1.3763819204711736`, -1., -1.8017073246471933`}, {
           0.6881909602355868, -0.5, -2.327438436766327}}], 
          
          Polygon[{{2.3894925769396664`, 0.5, 0.42532540417601994`}, {
           2.2270327288232132`, 1., -0.4253254041760197}, {
           1.6392474765307403`, 1.8090169943749475`, -0.4253254041760197}, {
           1.2139220723547204`, 2.118033988749895, 0.42532540417601994`}, {
           1.3763819204711736`, 1.618033988749895, 1.2759762125280598`}, {
           1.9641671727636467`, 0.8090169943749475, 1.2759762125280598`}}], 
          
          Polygon[{{1.2139220723547204`, 2.118033988749895, 
           0.42532540417601994`}, {1.6392474765307403`, 
           1.8090169943749475`, -0.4253254041760197}, {1.1135163644116066`, 
           1.8090169943749475`, -1.27597621252806}, {0.16245984811645317`, 
           2.118033988749895, -1.27597621252806}, {-0.2628655560595668, 
           2.4270509831248424`, -0.4253254041760197}, {0.2628655560595668, 
           2.4270509831248424`, 0.42532540417601994`}}], 
          
          Polygon[{{0.2628655560595668, 2.4270509831248424`, 
           0.42532540417601994`}, {-0.2628655560595668, 
           2.4270509831248424`, -0.4253254041760197}, {-1.2139220723547204`, 
           2.118033988749895, -0.4253254041760197}, {-1.6392474765307403`, 
           1.8090169943749475`, 0.42532540417601994`}, {-1.1135163644116066`, 
           1.8090169943749475`, 1.2759762125280598`}, {-0.16245984811645317`, 
           2.118033988749895, 1.2759762125280598`}}], 
          
          Polygon[{{-1.6392474765307403`, 1.8090169943749475`, 
           0.42532540417601994`}, {-1.2139220723547204`, 
           2.118033988749895, -0.4253254041760197}, {-1.3763819204711736`, 
           1.618033988749895, -1.27597621252806}, {-1.9641671727636467`, 
           0.8090169943749475, -1.27597621252806}, {-2.3894925769396664`, 
           0.5, -0.4253254041760197}, {-2.2270327288232137`, 1., 
           0.42532540417601994`}}], 
          
          Polygon[{{-2.2270327288232137`, 1., 
           0.42532540417601994`}, {-2.3894925769396664`, 
           0.5, -0.4253254041760197}, {-2.3894925769396664`, -0.5, \
-0.4253254041760197}, {-2.2270327288232137`, -1., 
           0.42532540417601994`}, {-2.0645728807067605`, -0.5, 
           1.2759762125280598`}, {-2.0645728807067605`, 0.5, 
           1.2759762125280598`}}], 
          
          Polygon[{{-2.2270327288232137`, -1., 
           0.42532540417601994`}, {-2.3894925769396664`, -0.5, \
-0.4253254041760197}, {-1.9641671727636467`, -0.8090169943749473, \
-1.27597621252806}, {-1.3763819204711736`, -1.6180339887498947`, \
-1.27597621252806}, {-1.2139220723547204`, -2.118033988749895, \
-0.4253254041760197}, {-1.6392474765307403`, -1.8090169943749475`, 
           0.42532540417601994`}}], 
          
          Polygon[{{-1.6392474765307403`, -1.8090169943749475`, 
           0.42532540417601994`}, {-1.2139220723547204`, -2.118033988749895, \
-0.4253254041760197}, {-0.2628655560595668, -2.4270509831248424`, \
-0.4253254041760197}, {0.2628655560595668, -2.4270509831248424`, 
           0.42532540417601994`}, {-0.16245984811645317`, -2.118033988749895, 
           1.2759762125280598`}, {-1.1135163644116066`, -1.8090169943749475`, 
           1.2759762125280598`}}], 
          
          Polygon[{{0.2628655560595668, -2.4270509831248424`, 
           0.42532540417601994`}, {-0.2628655560595668, -2.4270509831248424`, \
-0.4253254041760197}, {
           0.16245984811645317`, -2.118033988749895, -1.27597621252806}, {
           1.1135163644116066`, -1.8090169943749475`, -1.27597621252806}, {
           1.6392474765307403`, -1.8090169943749475`, -0.4253254041760197}, {
           1.2139220723547204`, -2.118033988749895, 0.42532540417601994`}}], 
          
          Polygon[{{1.2139220723547204`, -2.118033988749895, 
           0.42532540417601994`}, {
           1.6392474765307403`, -1.8090169943749475`, -0.4253254041760197}, {
           2.2270327288232132`, -1., -0.4253254041760197}, {
           2.3894925769396664`, -0.5, 0.42532540417601994`}, {
           1.9641671727636467`, -0.8090169943749473, 1.2759762125280598`}, {
           1.3763819204711736`, -1.6180339887498947`, 1.2759762125280598`}}], 
          
          
          Polygon[{{2.3894925769396664`, -0.5, 0.42532540417601994`}, {
           2.2270327288232132`, -1., -0.4253254041760197}, {
           2.0645728807067605`, -0.5, -1.27597621252806}, {
           2.0645728807067605`, 0.5, -1.27597621252806}, {2.2270327288232132`,
            1., -0.4253254041760197}, {2.3894925769396664`, 0.5, 
           0.42532540417601994`}}]}}, $CellContext`shrink[
         Pattern[$CellContext`t, 
          Blank[]], 
         Polygon[
          Pattern[$CellContext`x, 
           Blank[List]], 
          Pattern[$CellContext`opts, 
           BlankNullSequence[]]]] := 
       Module[{$CellContext`c = 
          Apply[Plus, $CellContext`x]/Length[$CellContext`x]}, 
         Polygon[
          
          Map[$CellContext`c + (
             1 - $CellContext`t) (# - $CellContext`c)& , $CellContext`x], \
$CellContext`opts]]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{331, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->136376423]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30301],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " offers an efficient way to generate a polygon with many shared vertices:"
}], "ExampleText",
 CellID->235093517],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23974798],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "5"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11945553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".7", "]"}], ",", 
      RowBox[{"GraphicsComplex", "[", 
       RowBox[{"v", ",", 
        RowBox[{"Polygon", "[", "i", "]"}]}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"GraphicsComplex", "[", 
      RowBox[{"v", ",", 
       RowBox[{"Line", "[", "i", "]"}]}], "]"}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->56811946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Opacity[0.7], 
     GraphicsComplex3DBox[{{0, 0, 0}, {2, 0, 0}, {2, 2, 0}, {0, 2, 0}, {1, 1, 
      2}}, Polygon3DBox[{{1, 2, 5}, {2, 3, 5}, {3, 4, 5}, {4, 1, 5}}]]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    GraphicsComplex3DBox[{{0, 0, 0}, {2, 0, 0}, {2, 2, 0}, {0, 2, 0}, {1, 1, 
     2}}, Line3DBox[{{1, 2, 5}, {2, 3, 5}, {3, 4, 5}, {4, 1, 5}}]],
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1mm1v2zYQxxVbip/y6CR1mkcnTbpsa9el3SOGYcBerK/2IYLCQAts2ND1
6wubeDxK1I+0qaSdgdgidff/H+/IO0rM73cf3i7+vPvw7s3d/PX7u7/fvnvz
z/y3v95XXf21LMsW1d8fh1l1/W91JX+/lmWZ9ReLRSmfbG6+sl+q76LqvJDW
z9V3r2r19df2/uT3VlAOpfpWlB+qb9PZM79GYl26MyORZVb0XLq+A1Zueota
SFGt7CtFdbICul7L1hdnIn3rIRsbhqY396V78MCx6L2ARRPTO/AtajBOpfUM
o90U3Eaqh/aJaH0Bnm3PPisY17uB3m6g14eeHdc1rNwL9HLoHYneE/A96qg3
B99hoFdA77HonYHvuKPeCfROvJlUq9o54+mKVYLg23oW1R1Adya6M/Be3EP3
QHUd75Oo7hC6EoFs6tlseJ9GdUfQPRDdHdh8cw/dTfjqc09KLsv2quLI9wVl
AguePQhlBP99lUChJ2UNSK9BseL2c5tAom+mNZKTMiivHo6SN1JZ9jKBMwbO
boNT1FJq09fAyoE1cfd1GDsxmzRqL7piqV0eliflZjCjR7QNoEnG1JnRSOWK
9vyToBVlfH4SjTl/aymakzKx+DKBuoVYbEZR14HKFVksQ1Vb46gDoN4kULeB
urEctcnm1cVnCdwd+EDmlI4ZK6mF+7Qrrtobxx0HuNcJ3F3gjpfjtjKu8fEV
sKlFm+PYkyj2JbAZGdo9imJvRLEvEthTxHC4HNtD6aF9lmAx3pHdZr+st2oi
s3IFxJhOE0ybjqmwDrDdda1euTZifCcJvrHy9QPvL+fcKVdzHic4B8pZRHGQ
fZLsfbQfo82akCv7IIqTYt+NajXtwxh7q7qZmyNIMTvHuaflau7ZMu7MfbgO
Hsabo/0I7aLNW11wVXB92slOa/YTvAdo94LxckZNoBGtooEd5KEdvp2y2ctC
H46hw1nZjZkrxkTGlBCicX6NOrFF4+i1twL/ToAwhMa4Ey/nLXnHOkrmGY6K
K5rW3Yd94Z7662y1Xn4KdmYZZiuyu3cMjGjUs979TdzPo+xHK9hl/URyBpm5
GrY6MbNGcNwxVvMkxXFu/y9sJta5e27Tes9su9OJmfU3TzBLvKvbMttaT2p7
nfhOI3j+c2PAV92qI6o2xZmYS7lnijGZZv38ore6oZ8DvQf0YR0hzvkmD3dj
msuE4M6HuaZXNm8IA87WO6R94PcfyCptNxM8xvheljuUFD/eJbk5Xv0y07Bm
Mn9yHcT5LjVe9CuzJuskdwpc73G2c41WqyonmDlu1lTmNX2l42WIM2WtM+KS
zMGIpqomc3nIfKzMRKK3mT1TVSXNPNO41tVOc0iKmZZuJJh7AfO+jnkbzPQ2
6xPjzrjSkpB5V5mnnmSWZUlmxp0rhzuGkHlLmSXHFP5TRbPbXc4f2z2Ge9SQ
v22hac6i/Bx/yh/Mz2l+Ezsz245ikq13KeSKPztwx7yKO9exn0GyH3Cn/DAD
QuytpRmC719z++KjmQ8TzGsCY4ivcMf3XyzWnHuMEJ+01gL/XkOiAKMwBO+H
TjvylLKGTJboxNPy6jk0WJMsB3dilxEtOdO0DwINfMa48tlRo1LaHTBx3fOJ
S84xbtZsi8hxcJxDRabHOFKLNlD7Pg6F6/AE7dsIylrVNNoWgVnkGO2XaPcC
BHeCRE05c2llvXrPFtQrrrRvJAx12+2EJKMbLsp/67UbFlYMZrG4FneE3KG6
k3IrPdUWpb7Xfusj3iWHsSSvpd1pJKVuVcouCeZFVubnKm3fHx8qJqXMaYIJ
kj17YB5ijb1STHs+xohzLs1V2p6TunPh2IwrXJXKWC+YodwOyv4nwrliUmpP
peQcN8gYXEvbaoGcgEg2cCei9IXBlBMoe0LQmqEjvS/neq31a+ZWrhwys+VM
ZL1q/SitbO0/Dgnn0g==\
\>"]]}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->256424641]
}, Open  ]],

Cell[TextData[{
 "Applying ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " to the graphics complex produces ordinary polygons:"
}], "ExampleText",
 CellID->293083684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{"v", ",", 
    RowBox[{"Polygon", "[", "i", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->502847507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{580, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->98819311]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1835],

Cell["\<\
In 3D, if the vertices are not in a plane, the polygon triangulation can be \
unpredictable:\
\>", "ExampleText",
 CellID->554393455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328954082],

Cell[BoxData[
 Graphics3DBox[
  Polygon3DBox[{{0, 0, 0}, {1, 1, 0}, {0, 1, 0}, {0, 0, 1}}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->413919892,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmG1PG0cUhRfvrjEEMDEvMcQ1bgglpVAa0iQobVSpH9JP/REotZRIiVql
+en9arUzd8+u189M8QRLXvvOnHNmdubeOy+/33x+N/148/n925vJb59u/nr3
/u3fkzd/fnJF+UqWZX+474dh5v7/6/7Z99fZbJbl0+l0Zp/syD+yX9yzdIUT
s167Z8dZuX6r0lfu6YllS8E9pXAtbC9a+0K1694qmtbdn7HVP5P2hrfKpl4a
XxnmqTT6t2AuhRlEMSPDnKutXYxEB/aBoc+k+CAJfSrtA9TmsIeGPpH2KAl9
LPQYtQVs62k2UU8mqC1h7xt6LO3jJPRDaZ+gtgt7z9AH0n6ShH4g9BlqV2Hb
7NnTF56jtgd7x9ADaV8mobeFforaNdjma9mmevIMteuw7xv6nrRfJKHXhL5G
7T3Y24buCf1qifYcXZe6/JAV7vt8STv9OHP2z6x0vz8AvQF7K8peE/u7L2M7
hiO60or9DdCbMXvBl3zbu2J/fSf2gdiM4q3YmwTssdjML/3YHATsY7EHd2I/
EZvvuR3znIB94dhFlgXxcB+21S9Eu2dfqW1mrzT2S7UdxCGjOmD+5N1FnmMC
7svRWsJ0v/ZXb8DoWE1i98RmXusmsTfF5ipUsUuwX4O97R45Ri+NuSkmZ61M
Yq+LzXdOY6+KzTyWxi7Epq/fwi4atriMiyXcrP7sRHkFeD87Xgezwj1KnHmt
aKA37MEuouznervoeryUfSU2s0Aa+1JsZvk09rnYjN84Owf7TGzmjTT2qdhE
p7Efiz28E/uRPOVwVq30VMmjrEnjXzPbDvtiv5/zkGWeE1ccS5H71YFU6VH0
5krV2p6fCWwlrXRL4PvSZQZgfLV0W70dWUbwG4YKRXWfx303uG7TP+Lqh+oz
95I99ZkqaapDqcZynjf3Uc7VM666L1VGXUeqh0tUO1HVXan68Sun4TmF2TOu
Mmip+GKeSBjrlYoNSNuFbI3rZPN9OT38EWzOunSLRtfyzHzcPJSrIPuaorkF
r1yTNtfIx7C5jsW0N1o+WUTi5gR2zB+ouS7NVfWT78gdODVXIpo9aXalSX87
hc0dV63ZdoBuK4d4KHNPombLM8tWtvNNccfO8y1HO1TMpVjH3UMwvoXNNXbx
vTM7ClmG1+hWH8YhT9bMWIGqOs3TEU9q9NhKx8vQd9OYt3kqz/teYcWZnlmz
mzEI2BewuwGbKxqzxfewy0DBT4Ffm8nk3UMRMLlqHn2xAseTHsATeh4o1HcI
ZPIupBMw6fX06atbFOb3ImTZrUrZ2NXUyk+YCbkb+tEGqbGbtpi5GM//x+vP
4jeC7VuTee+Yy5iH6pvRCl3fUBH1cmGUWMs2fE/yBr0nTaL8XBb1Kha8PUfn
QujqbMwxZpb3mctPV3XnUd8AEnUizeqWi3PObDeRZnVPOJImUSNp2h4m8HzG
1lDo6hb6SJpE7ahli+Xgloi5oi9NW2GCzMF9SL3rtJzY3PHGzvW+Bxb7C/nM
e1ohDfNYW4G7U90WZtnKf0Qzlwk=\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "3"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34225559],

Cell[BoxData[
 Graphics3DBox[
  Polygon3DBox[{{0.20269238995129046`, 0.5025725898126545, 
   0.32701174939415933`}, {0.7107764098522351, 0.19139185746381426`, 
   0.061441818211869004`}, {0.6321951423492933, 0.7884282235422213, 
   0.5461434256124358}, {0.10175670431331851`, 0.7383670542510201, 
   0.46746086512488016`}, {0.37301884529662854`, 0.7117724779621786, 
   0.28146973707906553`}, {0.8462140602379213, 0.7695600001539753, 
   0.5873322288809282}, {0.2483782246020887, 0.8813360085669282, 
   0.40346825818352805`}, {0.5978095141323012, 0.022710565749709755`, 
   0.33043025451506836`}, {0.3375722392198719, 0.58306935160505, 
   0.7770255137935163}, {0.789289763673505, 0.14126828580230089`, 
   0.4692165053359625}}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->1837966,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->149774102],

Cell["\<\
Seams can sometimes appear between individual polygons as a result of \
antialiasing:\
\>", "ExampleText",
 CellID->39409971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "+", "1"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "+", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->260324932],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.5], PolygonBox[{{0, 0}, {1, 0}, {1, 1}, {0, 1}}], 
   PolygonBox[{{1, 0}, {2, 0}, {2, 1}, {1, 1}}], 
   PolygonBox[{{2, 0}, {3, 0}, {3, 1}, {2, 1}}]},
  ImageSize->{147., Automatic}]], "Output",
 ImageSize->{151, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28245755]
}, Open  ]],

Cell["Using a single polygon object avoids any seams:", "ExampleText",
 CellID->148256467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "+", "1"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "+", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "1"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->215121604],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwTAZiUwkGIPs/kAXG
k///B9LIJDOQ7G1oaGAe5Y3yBgUPM40yMAIA8IWd8Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{147, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23652673]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10039],

Cell["Random triangle collections:", "ExampleText",
 CellID->26006648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "30", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->189363013],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.44743984532170145`], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.5646902108852683, 0.8836702825642015}, {0.9121303757845525,
      0.550311400269685}, {0.8271746008453265, 0.4947099185117023}}]}, 
   {Hue[0.8246478187501354], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.03823048466048018, 0.9496211051071173}, {
     0.06324887707249238, 0.5752658978082514}, {0.17188004500755638`, 
     0.051309122520198924`}}]}, 
   {Hue[0.1951133565435612], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.00821634842057506, 0.32856485435255367`}, {
     0.43356410958710834`, 0.5410461079731943}, {0.2177125759916576, 
     0.4674526934408372}}]}, 
   {Hue[0.8724018478753772], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.7801624972789762, 0.6634275503130453}, {0.6003373881464085,
      0.08322719738965856}, {0.9737740440355409, 0.5543565603603249}}]}, 
   {Hue[0.059052480877478386`], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.7994538754253435, 0.017138878219333797`}, {
     0.5808907978884263, 0.9993205549127091}, {0.8952635566303824, 
     0.4015048291466048}}]}, 
   {Hue[0.003969077494786699], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.1945848816011322, 0.48658480704784424`}, {
     0.19808447504747595`, 0.7868419296288043}, {0.2931847135336325, 
     0.024304366160681656`}}]}, 
   {Hue[0.9318871382988287], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.7731243601920521, 0.7616032977409417}, {0.4718142368526441,
      0.4821842830861043}, {0.9795585161354876, 0.8733021390847893}}]}, 
   {Hue[0.08187241910581089], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.2950760198901574, 0.23938642449692993`}, {
     0.9104751883318687, 0.7064525550154568}, {0.5590962351266142, 
     0.5149359291884898}}]}, 
   {Hue[0.2697503152795371], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.6791961549698171, 0.13134607304897727`}, {
     0.49429344754361737`, 0.6834828736174698}, {0.7889791078945652, 
     0.8245555717504527}}]}, 
   {Hue[0.007554611557342161], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.4718952630556601, 0.7762275989699927}, {0.9783470300649528,
      0.3817976397561693}, {0.1464259403109034, 0.6199277274861899}}]}, 
   {Hue[0.9078757639729547], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.7386990602288106, 0.4708925307059937}, {0.9696022880353723,
      0.061041303452869844`}, {0.024850287023569395`, 
     0.6535664763920843}}]}, 
   {Hue[0.9501359780764052], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.35770160383759064`, 0.661711169569875}, {
     0.6952751326867381, 0.24229839107562512`}, {0.040595760361176625`, 
     0.09793000872055724}}]}, 
   {Hue[0.13739470535982723`], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.7424014486505337, 0.39263339946273623`}, {
     0.3379897064361761, 0.17109698534349294`}, {0.8041796530902656, 
     0.15953064705350317`}}]}, 
   {Hue[0.8585413288677477], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.9509077458146498, 0.14530980960049544`}, {
     0.17464911176019982`, 0.8642238598464329}, {0.5402535106252759, 
     0.9758348473461322}}]}, 
   {Hue[0.7526991242781254], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.7615521516218127, 0.4145601567139543}, {
     0.11198916368961087`, 0.19029417692033856`}, {0.928412794099976, 
     0.17959410911744733`}}]}, 
   {Hue[0.9881846948770245], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.6928895970789546, 0.7451150214205156}, {
     0.02071609575902289, 0.4676188287646368}, {0.5548592316106473, 
     0.40154161749703277`}}]}, 
   {Hue[0.8049488154004967], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.0277193796565387, 0.9304906825046255}, {0.8224160847948154,
      0.4438056042308196}, {0.211662150328644, 0.9072433512451175}}]}, 
   {Hue[0.7131671029186948], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.4708711745547458, 0.8750897634650467}, {0.7465610373456593,
      0.5400730373383733}, {0.05440815332251603, 0.027832183306937486`}}]}, 
   {Hue[0.6624188719288342], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.33717169271785785`, 0.9892610788329337}, {
     0.5972929892573913, 0.22592592539865985`}, {0.928574529488668, 
     0.2053482746819022}}]}, 
   {Hue[0.4851405120727035], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.5039133945380998, 0.09906309391015888}, {
     0.8725450409982081, 0.2435675966631814}, {0.023936700404585398`, 
     0.14024242934667353`}}]}, 
   {Hue[0.19155940870355592`], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.4429510947130646, 0.3065202598283461}, {
     0.03276498228985725, 0.598001365246311}, {0.8637291286115327, 
     0.7187285614873229}}]}, 
   {Hue[0.8680013010065759], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.35595121487768044`, 0.34711488259183954`}, {
     0.06899982552164352, 0.47612147843193475`}, {0.4266379808347105, 
     0.40054087589091014`}}]}, 
   {Hue[0.4637199758613295], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.9821857106951442, 0.6427469592849111}, {
     0.24475373619389718`, 0.7728159494950488}, {0.14486170992816993`, 
     0.8523992782380518}}]}, 
   {Hue[0.5066435347538205], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.879479489950298, 0.9812116196473792}, {0.6614927648399922, 
     0.9924012176222432}, {0.4908283249241405, 0.30371031821350547`}}]}, 
   {Hue[0.2587361313021206], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.14408887165355733`, 0.4729687337014836}, {
     0.4439327521890055, 0.04834444980280006}, {0.41805963416052494`, 
     0.39900737400115327`}}]}, 
   {Hue[0.8157748177084172], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.35175544830172223`, 0.8235215278341641}, {
     0.12903875465697134`, 0.6346256908427084}, {0.20593298459177034`, 
     0.8130972255013218}}]}, 
   {Hue[0.4530801172771819], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.3059256940656676, 0.19520715893342921`}, {
     0.7213287445067909, 0.45100962877652795`}, {0.1747009367834309, 
     0.6316645777010979}}]}, 
   {Hue[0.2039624090499652], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.13251570230123533`, 0.7168955771280188}, {
     0.7573334169977535, 0.22819230520225453`}, {0.5638878398588674, 
     0.013117368641627936`}}]}, 
   {Hue[0.03668821636633557], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.47176930934000216`, 0.3840448888949559}, {
     0.6837327281800822, 0.020441559046046498`}, {0.5337644037140385, 
     0.5814230868194032}}]}, 
   {Hue[0.9788412032141334], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0.36280382287349444`, 0.8827014725600668}, {
     0.12306255906572194`, 0.8506717803877815}, {0.8410825396792658, 
     0.3666384164871217}}]}}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->843069192]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
       RowBox[{"Opacity", "[", ".7", "]"}], ",", 
       RowBox[{"Hue", "[", 
        RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", "30", "}"}]}], "]"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->960015455],

Cell[BoxData[
 Graphics3DBox[{
   {Hue[0.966283805055961], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.9138519248745778, 0.21697758090553942`, 
     0.8519033375542762}, {0.132966213169889, 0.21362208198039823`, 
     0.7276633552107774}, {0.37633040592540046`, 0.831216994303964, 
     0.476391795710454}}]}, 
   {Hue[0.26800557539677894`], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.6033250099945571, 0.24647652111355267`, 
     0.588254805267499}, {0.7138459148314649, 0.5691804321626932, 
     0.8819734784056679}, {0.15825717199487, 0.29808549566113296`, 
     0.5495326261109295}}]}, 
   {Hue[0.7668382367312709], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.491645051261685, 0.01710035766018203, 
     0.9216714846459668}, {0.889111039387517, 0.09743946159004846, 
     0.5173809696037484}, {0.17255564025434333`, 0.8065906604484683, 
     0.5615278364664709}}]}, 
   {Hue[0.019414249660977045`], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.8635384568335145, 0.9532611430130578, 
     0.7085993361344485}, {0.13984906889407056`, 0.6027924019017843, 
     0.29483001738849124`}, {0.055538656751337845`, 0.7786077896130177, 
     0.03560085406922919}}]}, 
   {Hue[0.6219952932314456], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.10952856091190166`, 0.31370082577886604`, 
     0.16589845712463136`}, {0.10104994921922206`, 0.9711163708894863, 
     0.6327970538890411}, {0.9255001651270081, 0.19501136871957314`, 
     0.30876664497795203`}}]}, 
   {Hue[0.9196538953216582], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.4178902472929822, 0.5471857800012827, 
     0.5025328650137377}, {0.05047072009762443, 0.6338599685344519, 
     0.3505058125074083}, {0.5052678607810603, 0.12864589302937834`, 
     0.03866072213226546}}]}, 
   {Hue[0.1293910483387819], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.15992453773177817`, 0.28618169163248486`, 
     0.4964873868492954}, {0.66166284306747, 0.3829639011275572, 
     0.4182253141814687}, {0.15037053522425903`, 0.04723271622825753, 
     0.24780776515240488`}}]}, 
   {Hue[0.12070700005496371`], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.2591293705475395, 0.8316250829669201, 
     0.9680937941516978}, {0.5067348464302812, 0.48486987879237975`, 
     0.8872413520465343}, {0.578658434029091, 0.3450851702101838, 
     0.8245352866253082}}]}, 
   {Hue[0.2853176000681763], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.9201359274671896, 0.8548653532566817, 
     0.6151594216163125}, {0.6736713302338178, 0.4078403879534669, 
     0.8458372322088883}, {0.46259489041178137`, 0.9266803687074014, 
     0.26556802662223933`}}]}, 
   {Hue[0.9823117781153834], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.5209564229850501, 0.4038193301770139, 
     0.020082351726884884`}, {0.4905830374742619, 0.8768696616582259, 
     0.18793871559852837`}, {0.30430453241036237`, 0.329937234710058, 
     0.42891379110138295`}}]}, 
   {Hue[0.07157207426936929], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.07662211158756715, 0.20935651716065373`, 
     0.3487827991960908}, {0.351605529808217, 0.23590344211181935`, 
     0.8654722428560568}, {0.8906156548120627, 0.9062746013081266, 
     0.7178890001794858}}]}, 
   {Hue[0.7693211242602775], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.974716579450482, 0.29517709655779467`, 
     0.8251345999573725}, {0.8011975565600267, 0.010192413071465234`, 
     0.5014561553795649}, {0.7537674270090076, 0.010224591074343037`, 
     0.013092631084998141`}}]}, 
   {Hue[0.15928902703218095`], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.8917321626869223, 0.9338407575996777, 
     0.44519461521779635`}, {0.23515325521497443`, 0.32336124520614984`, 
     0.3906763276343057}, {0.688954281677093, 0.883978402069902, 
     0.5233164627040352}}]}, 
   {Hue[0.645172925465374], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.5989016953526478, 0.31758071909970886`, 
     0.2790566776220835}, {0.21319181635563678`, 0.68073190170863, 
     0.07159339598409598}, {0.8496073159009263, 0.8098016917641735, 
     0.6353997924923673}}]}, 
   {Hue[0.7348321504807731], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.5002862078905663, 0.1483137005129791, 
     0.6737913051632392}, {0.23777183807612046`, 0.351617635385743, 
     0.9393536564626273}, {0.23264191745566354`, 0.31781061750615835`, 
     0.8439906006606224}}]}, 
   {Hue[0.23756981172894331`], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.1421374045813235, 0.0348020245287437, 
     0.5139373247243832}, {0.052132407966821726`, 0.3010851797552472, 
     0.5013467062264585}, {0.7311977293412038, 0.4649312391249416, 
     0.5318212330335195}}]}, 
   {Hue[0.5515710594571452], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.6494806653359797, 0.7004957070843243, 
     0.6423566069002797}, {0.3540701084351947, 0.41634082102671366`, 
     0.16561211705686785`}, {0.3392644234261617, 0.17357946566280025`, 
     0.3038198689170819}}]}, 
   {Hue[0.3311837909718818], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.4577998594083448, 0.2979626662781609, 
     0.8247750288988762}, {0.3937379881666796, 0.5734614488218917, 
     0.05486201786801659}, {0.6763133363166425, 0.3510530603051898, 
     0.5177093741989811}}]}, 
   {Hue[0.9018579187754778], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.5245363416946052, 0.7353987025971087, 
     0.184962805304284}, {0.16752746559229292`, 0.5534773974804694, 
     0.4163425175983959}, {0.9413556326096904, 0.9795962976532704, 
     0.90126252914005}}]}, 
   {Hue[0.5676725045424367], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.7556303477035158, 0.043171064899117706`, 
     0.6310963394499542}, {0.7250328416014546, 0.9734030307607948, 
     0.6061548138218993}, {0.9187688607606086, 0.33402196942058815`, 
     0.4699134793954809}}]}, 
   {Hue[0.4913469240364503], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.11153184702501462`, 0.25309013926025337`, 
     0.7085559683891838}, {0.09907673670002048, 0.13299707966193863`, 
     0.3926185417215542}, {0.04359832302420852, 0.958196109678666, 
     0.16485642478169793`}}]}, 
   {Hue[0.12046034666103744`], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.5907852130413784, 0.3101033865467202, 
     0.6220199654502983}, {0.13445943170093666`, 0.7238567545203791, 
     0.18722872895284093`}, {0.32960729282132695`, 0.7553295579015227, 
     0.7139548222069889}}]}, 
   {Hue[0.034758149051191234`], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.7009655503746439, 0.5568959955564887, 
     0.4238439617778451}, {0.5370095871662903, 0.3494446386065415, 
     0.3132852969058728}, {0.8072758036825411, 0.6895675450705465, 
     0.9926526051700788}}]}, 
   {Hue[0.9368133030172827], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.19434695748423825`, 0.6100870367880011, 
     0.40589449383368525`}, {0.37648895445632435`, 0.2478525431909242, 
     0.23881285540016983`}, {0.41752054704513664`, 0.10551261573932802`, 
     0.5347733516783546}}]}, 
   {Hue[0.3551606519118091], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.11743406753173291`, 0.38486146498487606`, 
     0.0533312788800806}, {0.8990067789418603, 0.4040746080622646, 
     0.2941900569165705}, {0.4457023233059645, 0.006194150559599487, 
     0.30922909901625406`}}]}, 
   {Hue[0.26231397096672415`], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.7282898065432455, 0.7862562246771923, 
     0.04531426242979064}, {0.4463774818664603, 0.9269379442586316, 
     0.6540757801566774}, {0.9711485638866706, 0.04924307061780708, 
     0.48923942896002504`}}]}, 
   {Hue[0.3601942560357485], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.2869401182805109, 0.8512033655667333, 
     0.2579298327386965}, {0.18663899764684655`, 0.4471431554833729, 
     0.3980876600749368}, {0.8094348686838764, 0.22768066321179514`, 
     0.11518736899845239`}}]}, 
   {Hue[0.27804075580819165`], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.6256860594803983, 0.34247546047328603`, 
     0.35401400773351543`}, {0.995978232336953, 0.8965982130738979, 
     0.4925560484871856}, {0.6650738538374112, 0.36387336970520323`, 
     0.7576878816640529}}]}, 
   {Hue[0.5425735804923246], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.028193851657319025`, 0.8665781483192001, 
     0.7010699937163007}, {0.41824845175576364`, 0.3055427307369134, 
     0.22803006332902642`}, {0.09961164830314595, 0.2881692394691877, 
     0.2328959549115519}}]}, 
   {Hue[0.5256214997472508], Opacity[0.7], EdgeForm[GrayLevel[0]], 
    Polygon3DBox[{{0.7593498431294523, 0.00315899636139072, 
     0.7316336842495805}, {0.9910245558273398, 0.2561790795082233, 
     0.2837021557602877}, {0.013946269458357197`, 0.2409556403395352, 
     0.7787741134709554}}]}},
  Lighting->"Neutral"]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->203728359,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143860220],

Cell["Digital petals:", "ExampleText",
 CellID->539166279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d", "=", 
     RowBox[{"2", 
      RowBox[{"Pi", "/", "12"}]}]}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", 
         RowBox[{"Opacity", "[", ".6", "]"}], "]"}], ",", 
        RowBox[{"Hue", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "11"}], "+", "q", "+", 
            RowBox[{"10", " ", "r"}]}], ")"}], "/", "72"}], "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"8", "-", "r"}], ")"}], 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", 
               RowBox[{"d", 
                RowBox[{"(", 
                 RowBox[{"q", "-", "1"}], ")"}]}], "]"}], ",", 
              RowBox[{"Sin", "[", 
               RowBox[{"d", 
                RowBox[{"(", 
                 RowBox[{"q", "-", "1"}], ")"}]}], "]"}]}], "}"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"8", "-", "r"}], ")"}], 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", 
               RowBox[{"d", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "1"}], ")"}]}], "]"}], ",", 
              RowBox[{"Sin", "[", 
               RowBox[{"d", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "1"}], ")"}]}], "]"}]}], "}"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"10", "-", "r"}], ")"}], 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", 
               RowBox[{"d", " ", "q"}], "]"}], ",", 
              RowBox[{"Sin", "[", 
               RowBox[{"d", " ", "q"}], "]"}]}], "}"}]}]}], "}"}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"q", ",", "12"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->861104232],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{7, 0}, {Rational[7, 2], Rational[7, 2] 3^Rational[1, 2]}, {
        Rational[9, 2] 3^Rational[1, 2], Rational[9, 2]}}, {{7, 0}, {3.5, 
        6.06217782649107}, {7.794228634059947, 4.5}}]]}, 
    {Hue[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[7, 2] 3^Rational[1, 2], Rational[7, 2]}, {0, 7}, {
        Rational[9, 2], Rational[9, 2] 3^Rational[1, 2]}}, {{6.06217782649107,
         3.5}, {0, 7}, {4.5, 7.794228634059947}}]]}, 
    {Hue[
      NCache[
       Rational[1, 36], 0.027777777777777776`]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[7, 2], Rational[7, 2] 3^Rational[1, 2]}, {
        Rational[-7, 2], Rational[7, 2] 3^Rational[1, 2]}, {0, 9}}, {{3.5, 
        6.06217782649107}, {-3.5, 6.06217782649107}, {0, 9}}]]}, 
    {Hue[
      NCache[
       Rational[1, 24], 0.041666666666666664`]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, 7}, {Rational[-7, 2] 3^Rational[1, 2], Rational[7, 2]}, {
        Rational[-9, 2], Rational[9, 2] 3^Rational[1, 2]}}, {{0, 
        7}, {-6.06217782649107, 3.5}, {-4.5, 7.794228634059947}}]]}, 
    {Hue[
      NCache[
       Rational[1, 18], 0.05555555555555555]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-7, 2], Rational[7, 2] 3^Rational[1, 2]}, {-7, 0}, {
        Rational[-9, 2] 3^Rational[1, 2], Rational[9, 2]}}, {{-3.5, 
        6.06217782649107}, {-7, 0}, {-7.794228634059947, 4.5}}]]}, 
    {Hue[
      NCache[
       Rational[5, 72], 0.06944444444444445]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-7, 2] 3^Rational[1, 2], Rational[7, 2]}, {
        Rational[-7, 2] 3^Rational[1, 2], Rational[-7, 2]}, {-9, 
        0}}, {{-6.06217782649107, 3.5}, {-6.06217782649107, -3.5}, {-9, 
        0}}]]}, 
    {Hue[
      NCache[
       Rational[1, 12], 0.08333333333333333]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-7, 0}, {Rational[-7, 2], Rational[-7, 2] 3^Rational[1, 2]}, {
        Rational[-9, 2] 3^Rational[1, 2], Rational[-9, 2]}}, {{-7, 
        0}, {-3.5, -6.06217782649107}, {-7.794228634059947, -4.5}}]]}, 
    {Hue[
      NCache[
       Rational[7, 72], 0.09722222222222222]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-7, 2] 3^Rational[1, 2], Rational[-7, 2]}, {0, -7}, {
        Rational[-9, 2], Rational[-9, 2] 
         3^Rational[1, 2]}}, {{-6.06217782649107, -3.5}, {
        0, -7}, {-4.5, -7.794228634059947}}]]}, 
    {Hue[
      NCache[
       Rational[1, 9], 0.1111111111111111]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-7, 2], Rational[-7, 2] 3^Rational[1, 2]}, {
        Rational[7, 2], Rational[-7, 2] 3^Rational[1, 2]}, {
        0, -9}}, {{-3.5, -6.06217782649107}, {3.5, -6.06217782649107}, {
        0, -9}}]]}, 
    {Hue[
      NCache[
       Rational[1, 8], 0.125]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, -7}, {Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2]}, {
        Rational[9, 2], Rational[-9, 2] 3^Rational[1, 2]}}, {{0, -7}, {
        6.06217782649107, -3.5}, {4.5, -7.794228634059947}}]]}, 
    {Hue[
      NCache[
       Rational[5, 36], 0.1388888888888889]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[7, 2], Rational[-7, 2] 3^Rational[1, 2]}, {7, 0}, {
        Rational[9, 2] 3^Rational[1, 2], Rational[-9, 2]}}, {{
        3.5, -6.06217782649107}, {7, 0}, {7.794228634059947, -4.5}}]]}, 
    {Hue[
      NCache[
       Rational[11, 72], 0.1527777777777778]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2]}, {
        Rational[7, 2] 3^Rational[1, 2], Rational[7, 2]}, {9, 0}}, {{
        6.06217782649107, -3.5}, {6.06217782649107, 3.5}, {9, 0}}]]}}, {
    {Hue[
      NCache[
       Rational[5, 36], 0.1388888888888889]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{6, 0}, {3, 3 3^Rational[1, 2]}, {4 3^Rational[1, 2], 4}}, {{6, 
        0}, {3, 5.196152422706632}, {6.928203230275509, 4}}]]}, 
    {Hue[
      NCache[
       Rational[11, 72], 0.1527777777777778]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{3 3^Rational[1, 2], 3}, {0, 6}, {4, 4 3^Rational[1, 2]}}, {{
        5.196152422706632, 3}, {0, 6}, {4, 6.928203230275509}}]]}, 
    {Hue[
      NCache[
       Rational[1, 6], 0.16666666666666666`]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{3, 3 3^Rational[1, 2]}, {-3, 3 3^Rational[1, 2]}, {0, 8}}, {{
        3, 5.196152422706632}, {-3, 5.196152422706632}, {0, 8}}]]}, 
    {Hue[
      NCache[
       Rational[13, 72], 0.18055555555555555`]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, 
        6}, {(-3) 3^Rational[1, 2], 3}, {-4, 4 3^Rational[1, 2]}}, {{0, 
        6}, {-5.196152422706632, 3}, {-4, 6.928203230275509}}]]}, 
    {Hue[
      NCache[
       Rational[7, 36], 0.19444444444444445`]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-3, 3 3^Rational[1, 2]}, {-6, 
        0}, {(-4) 3^Rational[1, 2], 4}}, {{-3, 5.196152422706632}, {-6, 
        0}, {-6.928203230275509, 4}}]]}, 
    {Hue[
      NCache[
       Rational[5, 24], 0.20833333333333334`]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{(-3) 3^Rational[1, 2], 3}, {(-3) 3^Rational[1, 2], -3}, {-8, 
        0}}, {{-5.196152422706632, 3}, {-5.196152422706632, -3}, {-8, 
        0}}]]}, 
    {Hue[
      NCache[
       Rational[2, 9], 0.2222222222222222]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-6, 
        0}, {-3, (-3) 3^Rational[1, 2]}, {(-4) 3^Rational[1, 2], -4}}, {{-6, 
        0}, {-3, -5.196152422706632}, {-6.928203230275509, -4}}]]}, 
    {Hue[
      NCache[
       Rational[17, 72], 0.2361111111111111]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{(-3) 3^Rational[1, 2], -3}, {
        0, -6}, {-4, (-4) 3^Rational[1, 2]}}, {{-5.196152422706632, -3}, {
        0, -6}, {-4, -6.928203230275509}}]]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-3, (-3) 3^Rational[1, 2]}, {3, (-3) 3^Rational[1, 2]}, {
        0, -8}}, {{-3, -5.196152422706632}, {3, -5.196152422706632}, {
        0, -8}}]]}, 
    {Hue[
      NCache[
       Rational[19, 72], 0.2638888888888889]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, -6}, {3 3^Rational[1, 2], -3}, {
        4, (-4) 3^Rational[1, 2]}}, {{0, -6}, {5.196152422706632, -3}, {
        4, -6.928203230275509}}]]}, 
    {Hue[
      NCache[
       Rational[5, 18], 0.2777777777777778]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{3, (-3) 3^Rational[1, 2]}, {6, 0}, {
        4 3^Rational[1, 2], -4}}, {{3, -5.196152422706632}, {6, 0}, {
        6.928203230275509, -4}}]]}, 
    {Hue[
      NCache[
       Rational[7, 24], 0.2916666666666667]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{3 3^Rational[1, 2], -3}, {3 3^Rational[1, 2], 3}, {8, 0}}, {{
        5.196152422706632, -3}, {5.196152422706632, 3}, {8, 0}}]]}}, {
    {Hue[
      NCache[
       Rational[5, 18], 0.2777777777777778]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{5, 0}, {Rational[5, 2], Rational[5, 2] 3^Rational[1, 2]}, {
        Rational[7, 2] 3^Rational[1, 2], Rational[7, 2]}}, {{5, 0}, {2.5, 
        4.330127018922193}, {6.06217782649107, 3.5}}]]}, 
    {Hue[
      NCache[
       Rational[7, 24], 0.2916666666666667]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[5, 2] 3^Rational[1, 2], Rational[5, 2]}, {0, 5}, {
        Rational[7, 2], Rational[7, 2] 3^Rational[1, 2]}}, {{
        4.330127018922193, 2.5}, {0, 5}, {3.5, 6.06217782649107}}]]}, 
    {Hue[
      NCache[
       Rational[11, 36], 0.3055555555555556]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[5, 2], Rational[5, 2] 3^Rational[1, 2]}, {
        Rational[-5, 2], Rational[5, 2] 3^Rational[1, 2]}, {0, 7}}, {{2.5, 
        4.330127018922193}, {-2.5, 4.330127018922193}, {0, 7}}]]}, 
    {Hue[
      NCache[
       Rational[23, 72], 0.3194444444444444]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, 5}, {Rational[-5, 2] 3^Rational[1, 2], Rational[5, 2]}, {
        Rational[-7, 2], Rational[7, 2] 3^Rational[1, 2]}}, {{0, 
        5}, {-4.330127018922193, 2.5}, {-3.5, 6.06217782649107}}]]}, 
    {Hue[
      NCache[
       Rational[1, 3], 0.3333333333333333]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-5, 2], Rational[5, 2] 3^Rational[1, 2]}, {-5, 0}, {
        Rational[-7, 2] 3^Rational[1, 2], Rational[7, 2]}}, {{-2.5, 
        4.330127018922193}, {-5, 0}, {-6.06217782649107, 3.5}}]]}, 
    {Hue[
      NCache[
       Rational[25, 72], 0.3472222222222222]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-5, 2] 3^Rational[1, 2], Rational[5, 2]}, {
        Rational[-5, 2] 3^Rational[1, 2], Rational[-5, 2]}, {-7, 
        0}}, {{-4.330127018922193, 2.5}, {-4.330127018922193, -2.5}, {-7, 
        0}}]]}, 
    {Hue[
      NCache[
       Rational[13, 36], 0.3611111111111111]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-5, 0}, {Rational[-5, 2], Rational[-5, 2] 3^Rational[1, 2]}, {
        Rational[-7, 2] 3^Rational[1, 2], Rational[-7, 2]}}, {{-5, 
        0}, {-2.5, -4.330127018922193}, {-6.06217782649107, -3.5}}]]}, 
    {Hue[
      NCache[
       Rational[3, 8], 0.375]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-5, 2] 3^Rational[1, 2], Rational[-5, 2]}, {0, -5}, {
        Rational[-7, 2], Rational[-7, 2] 
         3^Rational[1, 2]}}, {{-4.330127018922193, -2.5}, {
        0, -5}, {-3.5, -6.06217782649107}}]]}, 
    {Hue[
      NCache[
       Rational[7, 18], 0.3888888888888889]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-5, 2], Rational[-5, 2] 3^Rational[1, 2]}, {
        Rational[5, 2], Rational[-5, 2] 3^Rational[1, 2]}, {
        0, -7}}, {{-2.5, -4.330127018922193}, {2.5, -4.330127018922193}, {
        0, -7}}]]}, 
    {Hue[
      NCache[
       Rational[29, 72], 0.4027777777777778]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, -5}, {Rational[5, 2] 3^Rational[1, 2], Rational[-5, 2]}, {
        Rational[7, 2], Rational[-7, 2] 3^Rational[1, 2]}}, {{0, -5}, {
        4.330127018922193, -2.5}, {3.5, -6.06217782649107}}]]}, 
    {Hue[
      NCache[
       Rational[5, 12], 0.4166666666666667]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[5, 2], Rational[-5, 2] 3^Rational[1, 2]}, {5, 0}, {
        Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2]}}, {{
        2.5, -4.330127018922193}, {5, 0}, {6.06217782649107, -3.5}}]]}, 
    {Hue[
      NCache[
       Rational[31, 72], 0.4305555555555556]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[5, 2] 3^Rational[1, 2], Rational[-5, 2]}, {
        Rational[5, 2] 3^Rational[1, 2], Rational[5, 2]}, {7, 0}}, {{
        4.330127018922193, -2.5}, {4.330127018922193, 2.5}, {7, 0}}]]}}, {
    {Hue[
      NCache[
       Rational[5, 12], 0.4166666666666667]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{4, 0}, {2, 2 3^Rational[1, 2]}, {3 3^Rational[1, 2], 3}}, {{4, 
        0}, {2, 3.4641016151377544`}, {5.196152422706632, 3}}]]}, 
    {Hue[
      NCache[
       Rational[31, 72], 0.4305555555555556]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{2 3^Rational[1, 2], 2}, {0, 4}, {3, 3 3^Rational[1, 2]}}, {{
        3.4641016151377544`, 2}, {0, 4}, {3, 5.196152422706632}}]]}, 
    {Hue[
      NCache[
       Rational[4, 9], 0.4444444444444444]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{2, 2 3^Rational[1, 2]}, {-2, 2 3^Rational[1, 2]}, {0, 6}}, {{
        2, 3.4641016151377544`}, {-2, 3.4641016151377544`}, {0, 6}}]]}, 
    {Hue[
      NCache[
       Rational[11, 24], 0.4583333333333333]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, 
        4}, {(-2) 3^Rational[1, 2], 2}, {-3, 3 3^Rational[1, 2]}}, {{0, 
        4}, {-3.4641016151377544`, 2}, {-3, 5.196152422706632}}]]}, 
    {Hue[
      NCache[
       Rational[17, 36], 0.4722222222222222]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-2, 2 3^Rational[1, 2]}, {-4, 
        0}, {(-3) 3^Rational[1, 2], 3}}, {{-2, 3.4641016151377544`}, {-4, 
        0}, {-5.196152422706632, 3}}]]}, 
    {Hue[
      NCache[
       Rational[35, 72], 0.4861111111111111]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{(-2) 3^Rational[1, 2], 2}, {(-2) 3^Rational[1, 2], -2}, {-6, 
        0}}, {{-3.4641016151377544`, 2}, {-3.4641016151377544`, -2}, {-6, 
        0}}]]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-4, 
        0}, {-2, (-2) 3^Rational[1, 2]}, {(-3) 3^Rational[1, 2], -3}}, {{-4, 
        0}, {-2, -3.4641016151377544`}, {-5.196152422706632, -3}}]]}, 
    {Hue[
      NCache[
       Rational[37, 72], 0.5138888888888888]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{(-2) 3^Rational[1, 2], -2}, {
        0, -4}, {-3, (-3) 3^Rational[1, 2]}}, {{-3.4641016151377544`, -2}, {
        0, -4}, {-3, -5.196152422706632}}]]}, 
    {Hue[
      NCache[
       Rational[19, 36], 0.5277777777777778]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-2, (-2) 3^Rational[1, 2]}, {2, (-2) 3^Rational[1, 2]}, {
        0, -6}}, {{-2, -3.4641016151377544`}, {2, -3.4641016151377544`}, {
        0, -6}}]]}, 
    {Hue[
      NCache[
       Rational[13, 24], 0.5416666666666666]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, -4}, {2 3^Rational[1, 2], -2}, {
        3, (-3) 3^Rational[1, 2]}}, {{0, -4}, {3.4641016151377544`, -2}, {
        3, -5.196152422706632}}]]}, 
    {Hue[
      NCache[
       Rational[5, 9], 0.5555555555555556]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{2, (-2) 3^Rational[1, 2]}, {4, 0}, {
        3 3^Rational[1, 2], -3}}, {{2, -3.4641016151377544`}, {4, 0}, {
        5.196152422706632, -3}}]]}, 
    {Hue[
      NCache[
       Rational[41, 72], 0.5694444444444444]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{2 3^Rational[1, 2], -2}, {2 3^Rational[1, 2], 2}, {6, 0}}, {{
        3.4641016151377544`, -2}, {3.4641016151377544`, 2}, {6, 0}}]]}}, {
    {Hue[
      NCache[
       Rational[5, 9], 0.5555555555555556]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{3, 0}, {Rational[3, 2], Rational[3, 2] 3^Rational[1, 2]}, {
        Rational[5, 2] 3^Rational[1, 2], Rational[5, 2]}}, {{3, 0}, {1.5, 
        2.598076211353316}, {4.330127018922193, 2.5}}]]}, 
    {Hue[
      NCache[
       Rational[41, 72], 0.5694444444444444]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[3, 2] 3^Rational[1, 2], Rational[3, 2]}, {0, 3}, {
        Rational[5, 2], Rational[5, 2] 3^Rational[1, 2]}}, {{
        2.598076211353316, 1.5}, {0, 3}, {2.5, 4.330127018922193}}]]}, 
    {Hue[
      NCache[
       Rational[7, 12], 0.5833333333333334]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[3, 2], Rational[3, 2] 3^Rational[1, 2]}, {
        Rational[-3, 2], Rational[3, 2] 3^Rational[1, 2]}, {0, 5}}, {{1.5, 
        2.598076211353316}, {-1.5, 2.598076211353316}, {0, 5}}]]}, 
    {Hue[
      NCache[
       Rational[43, 72], 0.5972222222222222]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, 3}, {Rational[-3, 2] 3^Rational[1, 2], Rational[3, 2]}, {
        Rational[-5, 2], Rational[5, 2] 3^Rational[1, 2]}}, {{0, 
        3}, {-2.598076211353316, 1.5}, {-2.5, 4.330127018922193}}]]}, 
    {Hue[
      NCache[
       Rational[11, 18], 0.6111111111111112]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-3, 2], Rational[3, 2] 3^Rational[1, 2]}, {-3, 0}, {
        Rational[-5, 2] 3^Rational[1, 2], Rational[5, 2]}}, {{-1.5, 
        2.598076211353316}, {-3, 0}, {-4.330127018922193, 2.5}}]]}, 
    {Hue[
      NCache[
       Rational[5, 8], 0.625]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-3, 2] 3^Rational[1, 2], Rational[3, 2]}, {
        Rational[-3, 2] 3^Rational[1, 2], Rational[-3, 2]}, {-5, 
        0}}, {{-2.598076211353316, 1.5}, {-2.598076211353316, -1.5}, {-5, 
        0}}]]}, 
    {Hue[
      NCache[
       Rational[23, 36], 0.6388888888888888]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-3, 0}, {Rational[-3, 2], Rational[-3, 2] 3^Rational[1, 2]}, {
        Rational[-5, 2] 3^Rational[1, 2], Rational[-5, 2]}}, {{-3, 
        0}, {-1.5, -2.598076211353316}, {-4.330127018922193, -2.5}}]]}, 
    {Hue[
      NCache[
       Rational[47, 72], 0.6527777777777778]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-3, 2] 3^Rational[1, 2], Rational[-3, 2]}, {0, -3}, {
        Rational[-5, 2], Rational[-5, 2] 
         3^Rational[1, 2]}}, {{-2.598076211353316, -1.5}, {
        0, -3}, {-2.5, -4.330127018922193}}]]}, 
    {Hue[
      NCache[
       Rational[2, 3], 0.6666666666666666]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[-3, 2], Rational[-3, 2] 3^Rational[1, 2]}, {
        Rational[3, 2], Rational[-3, 2] 3^Rational[1, 2]}, {
        0, -5}}, {{-1.5, -2.598076211353316}, {1.5, -2.598076211353316}, {
        0, -5}}]]}, 
    {Hue[
      NCache[
       Rational[49, 72], 0.6805555555555556]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, -3}, {Rational[3, 2] 3^Rational[1, 2], Rational[-3, 2]}, {
        Rational[5, 2], Rational[-5, 2] 3^Rational[1, 2]}}, {{0, -3}, {
        2.598076211353316, -1.5}, {2.5, -4.330127018922193}}]]}, 
    {Hue[
      NCache[
       Rational[25, 36], 0.6944444444444444]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[3, 2], Rational[-3, 2] 3^Rational[1, 2]}, {3, 0}, {
        Rational[5, 2] 3^Rational[1, 2], Rational[-5, 2]}}, {{
        1.5, -2.598076211353316}, {3, 0}, {4.330127018922193, -2.5}}]]}, 
    {Hue[
      NCache[
       Rational[17, 24], 0.7083333333333334]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{Rational[3, 2] 3^Rational[1, 2], Rational[-3, 2]}, {
        Rational[3, 2] 3^Rational[1, 2], Rational[3, 2]}, {5, 0}}, {{
        2.598076211353316, -1.5}, {2.598076211353316, 1.5}, {5, 0}}]]}}, {
    {Hue[
      NCache[
       Rational[25, 36], 0.6944444444444444]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{2, 0}, {1, 3^Rational[1, 2]}, {2 3^Rational[1, 2], 2}}, {{2, 
        0}, {1, 1.7320508075688772`}, {3.4641016151377544`, 2}}]]}, 
    {Hue[
      NCache[
       Rational[17, 24], 0.7083333333333334]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{3^Rational[1, 2], 1}, {0, 2}, {2, 2 3^Rational[1, 2]}}, {{
        1.7320508075688772`, 1}, {0, 2}, {2, 3.4641016151377544`}}]]}, 
    {Hue[
      NCache[
       Rational[13, 18], 0.7222222222222222]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{1, 3^Rational[1, 2]}, {-1, 3^Rational[1, 2]}, {0, 4}}, {{
        1, 1.7320508075688772`}, {-1, 1.7320508075688772`}, {0, 4}}]]}, 
    {Hue[
      NCache[
       Rational[53, 72], 0.7361111111111112]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, 2}, {-3^Rational[1, 2], 1}, {-2, 2 3^Rational[1, 2]}}, {{0, 
        2}, {-1.7320508075688772`, 1}, {-2, 3.4641016151377544`}}]]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-1, 3^Rational[1, 2]}, {-2, 
        0}, {(-2) 3^Rational[1, 2], 2}}, {{-1, 1.7320508075688772`}, {-2, 
        0}, {-3.4641016151377544`, 2}}]]}, 
    {Hue[
      NCache[
       Rational[55, 72], 0.7638888888888888]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-3^Rational[1, 2], 1}, {-3^Rational[1, 2], -1}, {-4, 
        0}}, {{-1.7320508075688772`, 1}, {-1.7320508075688772`, -1}, {-4, 
        0}}]]}, 
    {Hue[
      NCache[
       Rational[7, 9], 0.7777777777777778]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-2, 
        0}, {-1, -3^Rational[1, 2]}, {(-2) 3^Rational[1, 2], -2}}, {{-2, 
        0}, {-1, -1.7320508075688772`}, {-3.4641016151377544`, -2}}]]}, 
    {Hue[
      NCache[
       Rational[19, 24], 0.7916666666666666]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-3^Rational[1, 2], -1}, {
        0, -2}, {-2, (-2) 3^Rational[1, 2]}}, {{-1.7320508075688772`, -1}, {
        0, -2}, {-2, -3.4641016151377544`}}]]}, 
    {Hue[
      NCache[
       Rational[29, 36], 0.8055555555555556]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{-1, -3^Rational[1, 2]}, {1, -3^Rational[1, 2]}, {
        0, -4}}, {{-1, -1.7320508075688772`}, {1, -1.7320508075688772`}, {
        0, -4}}]]}, 
    {Hue[
      NCache[
       Rational[59, 72], 0.8194444444444444]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{0, -2}, {3^Rational[1, 2], -1}, {2, (-2) 3^Rational[1, 2]}}, {{
        0, -2}, {1.7320508075688772`, -1}, {2, -3.4641016151377544`}}]]}, 
    {Hue[
      NCache[
       Rational[5, 6], 0.8333333333333334]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{1, -3^Rational[1, 2]}, {2, 0}, {2 3^Rational[1, 2], -2}}, {{
        1, -1.7320508075688772`}, {2, 0}, {3.4641016151377544`, -2}}]]}, 
    {Hue[
      NCache[
       Rational[61, 72], 0.8472222222222222]], EdgeForm[Opacity[0.6]], 
     PolygonBox[
      NCache[{{3^Rational[1, 2], -1}, {3^Rational[1, 2], 1}, {4, 0}}, {{
        1.7320508075688772`, -1}, {1.7320508075688772`, 1}, {4, 
        0}}]]}}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318698430]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->755651057],

Cell["A rotating star:", "ExampleText",
 CellID->529113792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Polygon", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "t", "]"}], ",", 
            RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", 
            RowBox[{"4", "Pi"}], ",", 
            RowBox[{"4", 
             RowBox[{"Pi", "/", "5"}]}]}], "}"}]}], "]"}], "]"}], ",", 
       "\[Theta]", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1.2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206413774],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Theta]$$ = 3.518583772020569, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Theta]$$], 0, 2 Pi}}, Typeset`size$$ = {
    180., {88., 92.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Theta]$2870$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Theta]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$2870$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Rotate[
         Polygon[
          Table[{
            Cos[$CellContext`t], 
            Sin[$CellContext`t]}, {$CellContext`t, 0, 4 Pi, 
            4 (Pi/5)}]], $CellContext`\[Theta]$$, {0, 0}], PlotRange -> 1.2], 
      "Specifications" :> {{$CellContext`\[Theta]$$, 0, 2 Pi, 
         AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {125., 130.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 257},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190665469]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11210],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Raster",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Raster"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cuboid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cuboid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsComplex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsComplex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Opacity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opacity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Glow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Disk",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Disk"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Line",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Line"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13917]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13101],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Primitives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]], "Tutorials",
 CellID->595610080],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Polygon",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Polygon"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->415640875],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->441926635],

Cell[TextData[ButtonBox["Polygons",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Polygons"]], "MoreAbout",
 CellID->817173889],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->35578191],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->429959288],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->198958374]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polygon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 10, 50.3080770}", "context" -> "System`", 
    "keywords" -> {
     "2D polygon", "3D polygon", "face", "facet", "filled region", 
      "polyhedra", "polyhedron", "polytope", "region", "piecewise plane", 
      "piecewise planar", "polygonal mesh", "polygonal tiling"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Polygon[{pt_1, pt_2, ...}] is a graphics primitive that represents a \
filled polygon. Polygon[{{pt_11, pt_12, ...}, {pt_21, ...}, ...}] represents \
a collection of polygons. ", "synonyms" -> {}, "title" -> "Polygon", "type" -> 
    "Symbol", "uri" -> "ref/Polygon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[19021, 555, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->194441815]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 302836, 6839}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3741, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4364, 105, 4191, 83, 70, "ObjectNameGrid"],
Cell[8558, 190, 1600, 50, 70, "Usage",
 CellID->17041]
}, Open  ]],
Cell[CellGroupData[{
Cell[10195, 245, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10673, 262, 498, 17, 70, "Notes",
 CellID->9845],
Cell[11174, 281, 1028, 39, 70, "Notes",
 CellID->23630],
Cell[12205, 322, 265, 8, 70, "Notes",
 CellID->5094],
Cell[12473, 332, 135, 4, 70, "Notes",
 CellID->10400],
Cell[12611, 338, 557, 19, 70, "Notes",
 CellID->8993],
Cell[13171, 359, 564, 17, 70, "Notes",
 CellID->2054],
Cell[13738, 378, 209, 5, 70, "Notes",
 CellID->8394],
Cell[13950, 385, 763, 23, 70, "Notes",
 CellID->29204],
Cell[14716, 410, 250, 7, 70, "Notes",
 CellID->5542],
Cell[14969, 419, 302, 7, 70, "Notes",
 CellID->26124],
Cell[15274, 428, 513, 17, 70, "Notes",
 CellID->32569],
Cell[15790, 447, 426, 13, 70, "Notes",
 CellID->8581],
Cell[16219, 462, 188, 4, 70, "Notes",
 CellID->2643],
Cell[16410, 468, 395, 13, 70, "Notes",
 CellID->21827],
Cell[16808, 483, 243, 5, 70, "Notes",
 CellID->18201],
Cell[17054, 490, 754, 23, 70, "Notes",
 CellID->4502],
Cell[17811, 515, 268, 6, 70, "Notes",
 CellID->19023],
Cell[18082, 523, 240, 5, 70, "Notes",
 CellID->12038],
Cell[18325, 530, 279, 7, 70, "Notes",
 CellID->3561],
Cell[18607, 539, 377, 11, 70, "Notes",
 CellID->23834]
}, Closed]],
Cell[CellGroupData[{
Cell[19021, 555, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194441815],
Cell[CellGroupData[{
Cell[19406, 569, 148, 5, 70, "ExampleSection",
 CellID->486263078],
Cell[19557, 576, 52, 1, 70, "ExampleText",
 CellID->32225171],
Cell[CellGroupData[{
Cell[19634, 581, 417, 15, 28, "Input",
 CellID->241287288],
Cell[20054, 598, 341, 10, 108, "Output",
 CellID->137627028]
}, Open  ]],
Cell[CellGroupData[{
Cell[20432, 613, 390, 13, 28, "Input",
 CellID->26130044],
Cell[20825, 628, 2106, 39, 129, 89, 1, "CachedBoxData", "BoxData", "Output",
 CellID->45246440]
}, Open  ]],
Cell[22946, 670, 124, 3, 70, "ExampleDelimiter",
 CellID->90565965],
Cell[23073, 675, 69, 1, 70, "ExampleText",
 CellID->105059788],
Cell[CellGroupData[{
Cell[23167, 680, 419, 14, 70, "Input",
 CellID->459443524],
Cell[23589, 696, 266, 7, 121, "Output",
 CellID->6848204]
}, Open  ]],
Cell[23870, 706, 125, 3, 70, "ExampleDelimiter",
 CellID->394699851],
Cell[23998, 711, 73, 1, 70, "ExampleText",
 CellID->14609133],
Cell[24074, 714, 435, 16, 70, "Input",
 CellID->993836995],
Cell[CellGroupData[{
Cell[24534, 734, 761, 24, 70, "Input",
 CellID->410781247],
Cell[25298, 760, 1103, 29, 110, "Output",
 CellID->481737613]
}, Open  ]],
Cell[26416, 792, 125, 3, 70, "ExampleDelimiter",
 CellID->690501634],
Cell[26544, 797, 74, 1, 70, "ExampleText",
 CellID->466344167],
Cell[26621, 800, 404, 14, 70, "Input",
 CellID->225867643],
Cell[CellGroupData[{
Cell[27050, 818, 768, 24, 70, "Input",
 CellID->91775463],
Cell[27821, 844, 8301, 149, 131, "Output",
 CellID->330696241]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36171, 999, 215, 7, 70, "ExampleSection",
 CellID->6990],
Cell[CellGroupData[{
Cell[36411, 1010, 241, 7, 70, "ExampleSubsection",
 CellID->25761626],
Cell[36655, 1019, 68, 1, 70, "ExampleText",
 CellID->692594619],
Cell[36726, 1022, 329, 12, 70, "Input",
 CellID->232213795],
Cell[CellGroupData[{
Cell[37080, 1038, 214, 7, 70, "Input",
 CellID->10379191],
Cell[37297, 1047, 293, 9, 121, "Output",
 CellID->418769061]
}, Open  ]],
Cell[37605, 1059, 359, 12, 70, "Input",
 CellID->478128593],
Cell[CellGroupData[{
Cell[37989, 1075, 217, 7, 70, "Input",
 CellID->159961143],
Cell[38209, 1084, 2256, 42, 129, 133, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->263570008]
}, Open  ]],
Cell[40480, 1129, 125, 3, 70, "ExampleDelimiter",
 CellID->215074798],
Cell[40608, 1134, 75, 1, 70, "ExampleText",
 CellID->108829176],
Cell[CellGroupData[{
Cell[40708, 1139, 521, 17, 70, "Input",
 CellID->224599039],
Cell[41232, 1158, 641, 15, 108, "Output",
 CellID->77718227]
}, Open  ]],
Cell[CellGroupData[{
Cell[41910, 1178, 533, 17, 70, "Input",
 CellID->246236988],
Cell[42446, 1197, 2289, 43, 130, 499, 9, "CachedBoxData", "BoxData", "Output",
 
 CellID->243215421]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44784, 1246, 235, 7, 70, "ExampleSubsection",
 CellID->59281063],
Cell[45022, 1255, 215, 7, 70, "ExampleText",
 CellID->14992635],
Cell[CellGroupData[{
Cell[45262, 1266, 712, 24, 70, "Input",
 CellID->193705270],
Cell[45977, 1292, 944, 28, 110, "Output",
 CellID->104697334]
}, Open  ]],
Cell[CellGroupData[{
Cell[46958, 1325, 675, 22, 70, "Input",
 CellID->2101616],
Cell[47636, 1349, 7920, 141, 131, "Output",
 CellID->260513136]
}, Open  ]],
Cell[55571, 1493, 125, 3, 70, "ExampleDelimiter",
 CellID->168303146],
Cell[55699, 1498, 477, 16, 70, "ExampleText",
 CellID->33725189],
Cell[CellGroupData[{
Cell[56201, 1518, 666, 21, 70, "Input",
 CellID->434762952],
Cell[56870, 1541, 388, 10, 121, "Output",
 CellID->654434413]
}, Open  ]],
Cell[CellGroupData[{
Cell[57295, 1556, 708, 21, 70, "Input",
 CellID->115120159],
Cell[58006, 1579, 2059, 39, 129, 220, 4, "CachedBoxData", "BoxData", "Output",
 
 CellID->222722227]
}, Open  ]],
Cell[60080, 1621, 124, 3, 70, "ExampleDelimiter",
 CellID->24570176],
Cell[60207, 1626, 375, 13, 70, "ExampleText",
 CellID->129740532],
Cell[60585, 1641, 611, 20, 70, "Input",
 CellID->411783593],
Cell[CellGroupData[{
Cell[61221, 1665, 327, 10, 70, "Input",
 CellID->45449775],
Cell[61551, 1677, 2731, 56, 110, "Output",
 CellID->192273717]
}, Open  ]],
Cell[64297, 1736, 125, 3, 70, "ExampleDelimiter",
 CellID->120891637],
Cell[64425, 1741, 338, 12, 70, "ExampleText",
 CellID->2274228],
Cell[CellGroupData[{
Cell[64788, 1757, 564, 19, 70, "Input",
 CellID->3999477],
Cell[65355, 1778, 16175, 274, 108, 252, 8, "CachedBoxData", "BoxData", \
"Output",
 CellID->286260863]
}, Open  ]],
Cell[CellGroupData[{
Cell[81567, 2057, 537, 17, 70, "Input",
 CellID->371472107],
Cell[82107, 2076, 17259, 289, 129, 183, 5, "CachedBoxData", "BoxData", \
"Output",
 CellID->756675226]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[99415, 2371, 245, 7, 70, "ExampleSubsection",
 CellID->236940489],
Cell[99663, 2380, 302, 12, 70, "ExampleText",
 CellID->471505131],
Cell[CellGroupData[{
Cell[99990, 2396, 543, 17, 70, "Input",
 CellID->539412333],
Cell[100536, 2415, 301, 8, 162, "Output",
 CellID->650289811]
}, Open  ]],
Cell[CellGroupData[{
Cell[100874, 2428, 580, 18, 70, "Input",
 CellID->56458757],
Cell[101457, 2448, 3343, 61, 194, 142, 4, "CachedBoxData", "BoxData", \
"Output",
 CellID->223756326]
}, Open  ]],
Cell[104815, 2512, 124, 3, 70, "ExampleDelimiter",
 CellID->35973966],
Cell[104942, 2517, 211, 8, 70, "ExampleText",
 CellID->363977525],
Cell[CellGroupData[{
Cell[105178, 2529, 557, 17, 70, "Input",
 CellID->49070823],
Cell[105738, 2548, 323, 10, 162, "Output",
 CellID->395980281]
}, Open  ]],
Cell[106076, 2561, 125, 3, 70, "ExampleDelimiter",
 CellID->594396467],
Cell[106204, 2566, 283, 11, 70, "ExampleText",
 CellID->39409126],
Cell[CellGroupData[{
Cell[106512, 2581, 865, 28, 70, "Input",
 CellID->6203245],
Cell[107380, 2611, 344, 11, 169, "Output",
 CellID->140940822]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[107785, 2629, 217, 7, 70, "ExampleSection",
 CellID->2775],
Cell[CellGroupData[{
Cell[108027, 2640, 229, 7, 70, "ExampleSubsection",
 CellID->17889],
Cell[108259, 2649, 70, 1, 70, "ExampleText",
 CellID->301316760],
Cell[CellGroupData[{
Cell[108354, 2654, 566, 19, 70, "Input",
 CellID->830008806],
Cell[108923, 2675, 16175, 274, 108, 252, 8, "CachedBoxData", "BoxData", \
"Output",
 CellID->111348380]
}, Open  ]],
Cell[125113, 2952, 123, 3, 70, "ExampleDelimiter",
 CellID->8533092],
Cell[125239, 2957, 81, 1, 70, "ExampleText",
 CellID->222606742],
Cell[CellGroupData[{
Cell[125345, 2962, 537, 17, 70, "Input",
 CellID->439135573],
Cell[125885, 2981, 17259, 289, 129, 183, 5, "CachedBoxData", "BoxData", \
"Output",
 CellID->424571493]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[143193, 3276, 230, 7, 70, "ExampleSubsection",
 CellID->12069],
Cell[143426, 3285, 114, 3, 70, "ExampleText",
 CellID->909021973],
Cell[143543, 3290, 419, 14, 70, "Input",
 CellID->19586270],
Cell[CellGroupData[{
Cell[143987, 3308, 201, 7, 70, "Input",
 CellID->85845950],
Cell[144191, 3317, 231, 8, 36, "Output",
 CellID->36289076]
}, Open  ]],
Cell[144437, 3328, 258, 9, 70, "ExampleText",
 CellID->794880732],
Cell[CellGroupData[{
Cell[144720, 3341, 403, 13, 70, "Input",
 CellID->157239568],
Cell[145126, 3356, 2187, 41, 129, 170, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->67406623]
}, Open  ]],
Cell[147328, 3400, 88, 1, 70, "ExampleText",
 CellID->238986113],
Cell[CellGroupData[{
Cell[147441, 3405, 428, 14, 70, "Input",
 CellID->220323761],
Cell[147872, 3421, 6178, 106, 129, 171, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->222896284]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[154111, 3534, 223, 7, 70, "ExampleSection",
 CellID->31391],
Cell[154337, 3543, 159, 6, 70, "ExampleText",
 CellID->122104825],
Cell[154499, 3551, 568, 18, 70, "Input",
 CellID->111287636],
Cell[155070, 3571, 60, 1, 70, "ExampleText",
 CellID->197198423],
Cell[CellGroupData[{
Cell[155155, 3576, 506, 15, 70, "Input",
 CellID->410561802],
Cell[155664, 3593, 11200, 188, 70, "Output",
 Evaluatable->False,
 CellID->181488764]
}, Open  ]],
Cell[166879, 3784, 57, 1, 70, "ExampleText",
 CellID->375416968],
Cell[CellGroupData[{
Cell[166961, 3789, 1048, 31, 70, "Input",
 CellID->229623322],
Cell[168012, 3822, 21692, 440, 173, "Output",
 CellID->591932692]
}, Open  ]],
Cell[189719, 4265, 124, 3, 70, "ExampleDelimiter",
 CellID->41617689],
Cell[189846, 4270, 70, 1, 70, "ExampleText",
 CellID->171265380],
Cell[189919, 4273, 607, 20, 70, "Input",
 CellID->141910737],
Cell[190529, 4295, 69, 1, 70, "ExampleText",
 CellID->64374289],
Cell[CellGroupData[{
Cell[190623, 4300, 864, 28, 70, "Input",
 CellID->16518451],
Cell[191490, 4330, 9602, 162, 70, "Output",
 Evaluatable->False,
 CellID->269004477]
}, Open  ]],
Cell[201107, 4495, 125, 3, 70, "ExampleDelimiter",
 CellID->147312004],
Cell[201235, 4500, 218, 8, 70, "ExampleText",
 CellID->123437608],
Cell[201456, 4510, 290, 9, 70, "Input",
 CellID->113072100],
Cell[201749, 4521, 89, 1, 70, "ExampleText",
 CellID->373148642],
Cell[201841, 4524, 810, 27, 70, "Input",
 CellID->847443274],
Cell[CellGroupData[{
Cell[202676, 4555, 812, 21, 70, "Input",
 CellID->37382128],
Cell[203491, 4578, 16090, 299, 70, "Output",
 CellID->136376423]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[219630, 4883, 233, 7, 70, "ExampleSection",
 CellID->30301],
Cell[219866, 4892, 264, 7, 70, "ExampleText",
 CellID->235093517],
Cell[220133, 4901, 503, 16, 70, "Input",
 CellID->23974798],
Cell[220639, 4919, 430, 14, 70, "Input",
 CellID->11945553],
Cell[CellGroupData[{
Cell[221094, 4937, 530, 17, 70, "Input",
 CellID->56811946],
Cell[221627, 4956, 4936, 90, 131, "Output",
 CellID->256424641]
}, Open  ]],
Cell[226578, 5049, 239, 8, 70, "ExampleText",
 CellID->293083684],
Cell[CellGroupData[{
Cell[226842, 5061, 204, 6, 70, "Input",
 CellID->502847507],
Cell[227049, 5069, 1500, 47, 71, "Output",
 CellID->98819311]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[228598, 5122, 225, 7, 70, "ExampleSection",
 CellID->1835],
Cell[228826, 5131, 143, 4, 70, "ExampleText",
 CellID->554393455],
Cell[CellGroupData[{
Cell[228994, 5139, 464, 15, 70, "Input",
 CellID->328954082],
Cell[229461, 5156, 1901, 36, 129, 103, 2, "CachedBoxData", "BoxData", \
"Output",
 CellID->413919892]
}, Open  ]],
Cell[CellGroupData[{
Cell[231399, 5197, 256, 8, 70, "Input",
 CellID->34225559],
Cell[231658, 5207, 2998, 54, 129, 742, 12, "CachedBoxData", "BoxData", \
"Output",
 CellID->1837966]
}, Open  ]],
Cell[234671, 5264, 125, 3, 70, "ExampleDelimiter",
 CellID->149774102],
Cell[234799, 5269, 135, 4, 70, "ExampleText",
 CellID->39409971],
Cell[CellGroupData[{
Cell[234959, 5277, 705, 23, 70, "Input",
 CellID->260324932],
Cell[235667, 5302, 367, 10, 74, "Output",
 CellID->28245755]
}, Open  ]],
Cell[236049, 5315, 90, 1, 70, "ExampleText",
 CellID->148256467],
Cell[CellGroupData[{
Cell[236164, 5320, 707, 23, 70, "Input",
 CellID->215121604],
Cell[236874, 5345, 316, 9, 70, "Output",
 Evaluatable->False,
 CellID->23652673]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[237239, 5360, 224, 7, 70, "ExampleSection",
 CellID->10039],
Cell[237466, 5369, 70, 1, 70, "ExampleText",
 CellID->26006648],
Cell[CellGroupData[{
Cell[237561, 5374, 531, 16, 70, "Input",
 CellID->189363013],
Cell[238095, 5392, 6623, 119, 203, "Output",
 CellID->843069192]
}, Open  ]],
Cell[CellGroupData[{
Cell[244755, 5516, 670, 19, 70, "Input",
 CellID->960015455],
Cell[245428, 5537, 23216, 389, 216, 9056, 152, "CachedBoxData", "BoxData", \
"Output",
 CellID->203728359]
}, Open  ]],
Cell[268659, 5929, 125, 3, 70, "ExampleDelimiter",
 CellID->143860220],
Cell[268787, 5934, 58, 1, 70, "ExampleText",
 CellID->539166279],
Cell[CellGroupData[{
Cell[268870, 5939, 2141, 64, 70, "Input",
 CellID->861104232],
Cell[271014, 6005, 21580, 503, 201, "Output",
 CellID->318698430]
}, Open  ]],
Cell[292609, 6511, 125, 3, 70, "ExampleDelimiter",
 CellID->755651057],
Cell[292737, 6516, 59, 1, 70, "ExampleText",
 CellID->529113792],
Cell[CellGroupData[{
Cell[292821, 6521, 949, 28, 70, "Input",
 CellID->206413774],
Cell[293773, 6551, 2149, 48, 70, "Output",
 CellID->190665469]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[295983, 6606, 311, 9, 70, "SeeAlsoSection",
 CellID->11210],
Cell[296297, 6617, 2399, 89, 70, "SeeAlso",
 CellID->13917]
}, Open  ]],
Cell[CellGroupData[{
Cell[298733, 6711, 314, 9, 70, "TutorialsSection",
 CellID->13101],
Cell[299050, 6722, 197, 4, 70, "Tutorials",
 CellID->595610080],
Cell[299250, 6728, 197, 4, 70, "Tutorials",
 CellID->815154705],
Cell[299450, 6734, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[CellGroupData[{
Cell[299649, 6742, 305, 8, 70, "RelatedLinksSection"],
Cell[299957, 6752, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[300353, 6769, 319, 9, 70, "MoreAboutSection",
 CellID->415640875],
Cell[300675, 6780, 143, 3, 70, "MoreAbout",
 CellID->441926635],
Cell[300821, 6785, 128, 3, 70, "MoreAbout",
 CellID->817173889],
Cell[300952, 6790, 150, 3, 70, "MoreAbout",
 CellID->35578191],
Cell[301105, 6795, 162, 3, 70, "MoreAbout",
 CellID->429959288],
Cell[301270, 6800, 197, 4, 70, "MoreAbout",
 CellID->198958374]
}, Open  ]],
Cell[301482, 6807, 50, 0, 70, "History"],
Cell[301535, 6809, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

