(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48826,       1904]
NotebookOptionsPosition[     38846,       1548]
NotebookOutlinePosition[     40386,       1589]
CellTagsIndexPosition[     40300,       1584]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"], 
          "Polynomials Modulo Primes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PolynomialsModuloPrimes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Algebraic Operations on Polynomials\"\>", 
       2->"\<\"Polynomials Modulo Primes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolynomialLCM" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialLCM"], 
          "PolynomialQuotient" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialQuotient"], "GCD" :> 
          Documentation`HelpLookup["paclet:ref/GCD"], "Cancel" :> 
          Documentation`HelpLookup["paclet:ref/Cancel"], "Together" :> 
          Documentation`HelpLookup["paclet:ref/Together"], 
          "PolynomialExtendedGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialExtendedGCD"], 
          "PolynomialMod" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialMod"], 
          "PolynomialReduce" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialReduce"], 
          "PolynomialRemainder" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialRemainder"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"PolynomialLCM\"\>", 
       2->"\<\"PolynomialQuotient\"\>", 3->"\<\"GCD\"\>", 4->"\<\"Cancel\"\>",
        5->"\<\"Together\"\>", 6->"\<\"PolynomialExtendedGCD\"\>", 
       7->"\<\"PolynomialMod\"\>", 8->"\<\"PolynomialReduce\"\>", 
       9->"\<\"PolynomialRemainder\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Division" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialDivision"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Polynomial Algebra\"\>", 
       2->"\<\"Polynomial Division\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolynomialGCD", "ObjectName",
 CellID->10223],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialGCD",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialGCD"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the greatest common divisor of the polynomials ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialGCD",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialGCD"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{
         ButtonBox["Modulus",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Modulus"], "->", 
         StyleBox["p", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates the GCD modulo the prime ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->12712]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ", all symbolic parameters are treated as variables. "
}], "Notes",
 CellID->27170],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " will by default treat algebraic numbers that appear in the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["poly", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as independent variables. "
}], "Notes",
 CellID->4766],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}]}], "]"}]], "InlineFormula"],
 " extends the coefficient field to include algebraic numbers that appear in \
the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["poly", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29042]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->50159349],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->72189360],

Cell["The greatest common divisor of polynomials:", "ExampleText",
 CellID->413363412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], 
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"4", "+", "x"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->375647984],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33898322]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4322],

Cell["The GCD of univariate polynomials:", "ExampleText",
 CellID->73164955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", "4"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191097715],

Cell[BoxData[
 RowBox[{"2", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131070282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->343619152],

Cell["The GCD of multivariate polynomials:", "ExampleText",
 CellID->206957919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"2", " ", "x", " ", "y"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"y", "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341104949],

Cell[BoxData[
 RowBox[{"x", "+", "y"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->968234358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11097135],

Cell["The GCD of more than two polynomials:", "ExampleText",
 CellID->164659289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "6"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "7"}], "-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673771430],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "x"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32258066]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19595],

Cell["The GCD of rational functions:", "ExampleText",
 CellID->303378762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "3"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "4"}], ")"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "5"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "3"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "6"}], ")"}]}], ")"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->765856930],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", "x"}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "6"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "4"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{160, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366839041]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8911],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Extension",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21115],

Cell["\<\
By default, algebraic numbers are treated as independent variables:\
\>", "ExampleText",
 CellID->253018439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
   RowBox[{"x", "-", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213770173],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->748131595]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " detects algebraically dependent coefficients:"
}], "ExampleText",
 CellID->240831450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
   RowBox[{"x", "-", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14105561],

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], "-", "x"}]], "Output",
 ImageSize->{48, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89081880]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->387],

Cell["Compute the GCD over the integers modulo 2:", "ExampleText",
 CellID->63591734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "^", "3"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", "x"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173502094],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], "2"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3216209]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31221],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " treats trigonometric functions as independent variables:"
}], "ExampleText",
 CellID->411074813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", "x"}], "]"}], ",", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138321982],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->521647451]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trig",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trig"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " recognizes dependencies between trigonometric functions:"
}], "ExampleText",
 CellID->25147952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", "x"}], "]"}], ",", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->212562188],

Cell[BoxData[
 RowBox[{"Sin", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->834727124]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->237],

Cell["Find common roots of univariate polynomials:", "ExampleText",
 CellID->246298022],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "7"}], "-", 
    RowBox[{"2", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"5", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"12", "x"}], "+", "5"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    RowBox[{"x", "^", "7"}], "-", 
    RowBox[{"9", 
     RowBox[{"x", "^", "5"}]}], "+", 
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"17", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"7", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"6", "x"}], "+", "3"}]}], ";"}], "\n", 
 RowBox[{"d", "=", 
  RowBox[{"PolynomialGCD", "[", 
   RowBox[{"f", ",", "g"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->331804822],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120521327]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"d", "\[Equal]", "0"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->125742410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["5"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{206, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->345075068]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Intersection", "[", 
  RowBox[{
   RowBox[{"x", "/.", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]}], ",", 
   RowBox[{"x", "/.", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"g", "\[Equal]", "0"}], ",", "x"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->164344023],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["5"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{206, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->194745494]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->354206521],

Cell["Find multiple roots of univariate polynomials:", "ExampleText",
 CellID->215414733],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "9"}], "-", 
    RowBox[{"7", 
     RowBox[{"x", "^", "8"}]}], "+", 
    RowBox[{"19", 
     RowBox[{"x", "^", "7"}]}], "-", 
    RowBox[{"27", 
     RowBox[{"x", "^", "6"}]}], "+", 
    RowBox[{"35", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"77", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"145", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"157", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"88", "x"}], "-", "20"}]}], ";"}], "\n", 
 RowBox[{"d", "=", 
  RowBox[{"PolynomialGCD", "[", 
   RowBox[{"f", ",", 
    RowBox[{"D", "[", 
     RowBox[{"f", ",", "x"}], "]"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->899252202],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", 
  RowBox[{"5", " ", "x"}], "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435458270]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"d", "\[Equal]", "0"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->681842579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115275316]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"x", "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->473025481],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "1.`", ",", "1.`", ",", "2.`", ",", "2.`", ",", 
   RowBox[{
    RowBox[{"-", "1.068757255260645`"}], "-", 
    RowBox[{"1.2688873677655133`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.068757255260645`"}], "+", 
    RowBox[{"1.2688873677655133`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.068757255260645`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.8212240798160036`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.068757255260645`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.8212240798160036`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{427, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->230036470]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22604],

Cell[TextData[{
 "The ",
 "GCD",
 " of polynomials divides the polynomials; use ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " to prove it:"
}], "ExampleText",
 CellID->18185028],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "7"}], "-", 
    RowBox[{"2", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"5", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"12", "x"}], "+", "5"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    RowBox[{"x", "^", "7"}], "-", 
    RowBox[{"9", 
     RowBox[{"x", "^", "5"}]}], "+", 
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"17", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"7", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"6", "x"}], "+", "3"}]}], ";"}], "\n", 
 RowBox[{"d", "=", 
  RowBox[{"PolynomialGCD", "[", 
   RowBox[{"f", ",", "g"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->403915550],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139014123]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", "d"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->997477632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->796055599]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " divides the numerator and the denominator of a rational function by their \
",
 "GCD",
 ":"
}], "ExampleText",
 CellID->59582222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{"f", "/", "g"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->380599883],

Cell[BoxData[
 FractionBox[
  RowBox[{"5", "-", 
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "4"]}], 
  RowBox[{"3", "-", 
   RowBox[{"7", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   SuperscriptBox["x", "4"]}]]], "Output",
 ImageSize->{76, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1573382]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialLCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialLCM"]], "InlineFormula"],
 " finds the least common multiple of polynomials:"
}], "ExampleText",
 CellID->710239861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{"f", ",", "g"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->75288802],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"5", "-", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "-", 
    RowBox[{"6", " ", "x"}], "-", 
    RowBox[{"7", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    SuperscriptBox["x", "4"], "-", 
    RowBox[{"9", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    SuperscriptBox["x", "7"]}], ")"}]}]], "Output",
 ImageSize->{296, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->266334633]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f", " ", "g"}], ")"}], "/", "d"}]}], " ", "//", 
  "Together"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->21191702],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->178878424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36408620],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Resultant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resultant"]], "InlineFormula"],
 " of two polynomials is zero if and only if their ",
 "GCD",
 " has a nonzero degree:"
}], "ExampleText",
 CellID->194711376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "4"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", "x"}], "+", "4"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->277174888],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->339501817]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "4"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", "x"}], "+", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38330313],

Cell[BoxData[
 RowBox[{"2", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->359183869]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", "9"}], ",", 
   RowBox[{
    RowBox[{"6", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"3", "x"}], "+", "12"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->93077371],

Cell[BoxData[
 RowBox[{"-", "3807"}]], "Output",
 ImageSize->{40, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->561424790]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", "9"}], ",", 
   RowBox[{
    RowBox[{"6", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"3", "x"}], "+", "12"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->863364964],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->141346879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14529322],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Discriminant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Discriminant"]], "InlineFormula"],
 " of a polynomial ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is zero if and only if the degree of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"], 
   RowBox[{"(", 
    RowBox[{
     StyleBox["f", "TI"], ",", 
     RowBox[{
      StyleBox["f", "TI"], "'"}]}], ")"}]}]], "InlineFormula"],
 " is nonzero:"
}], "ExampleText",
 CellID->407152571],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"3", "x"}], "+", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"2", "x"}], "+", "1"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->20002916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Discriminant", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331405909],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->785629128]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{"f", ",", 
   RowBox[{"D", "[", 
    RowBox[{"f", ",", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->133530601],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "x"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->105742962]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Discriminant", "[", 
  RowBox[{"g", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->560921847],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->631944395]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{"g", ",", 
   RowBox[{"D", "[", 
    RowBox[{"g", ",", "x"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->60471566],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->456150182]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Discriminant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Discriminant"]], "InlineFormula"],
 " of a polynomial f is zero if and only if the polynomial has multiple \
roots:"
}], "ExampleText",
 CellID->662066817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->368459124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->160172198]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"g", "\[Equal]", "0"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->461326751],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["5"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{206, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->5007817]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19946],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialLCM",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialLCM"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialQuotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialQuotient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cancel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cancel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Together",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Together"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialExtendedGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialExtendedGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialMod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialRemainder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialRemainder"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16981]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->268],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->28458],

Cell[TextData[ButtonBox["Polynomials Modulo Primes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PolynomialsModuloPrimes"]], "Tutorials",
 CellID->180770870]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->98390531],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->651030206],

Cell[TextData[ButtonBox["Polynomial Division",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialDivision"]], "MoreAbout",
 CellID->46971972]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolynomialGCD - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 11, 51.6377720}", "context" -> "System`", 
    "keywords" -> {
     "common roots", "GCD of polynomials", 
      "greatest common divisor of polynomials", "HCF", 
      "highest common factor", "polynomial GCD", 
      "polynomial greatest common divisor", "Zippel's algorithm"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PolynomialGCD[poly_1, poly_2, ...] gives the greatest common divisor of \
the polynomials poly_i. PolynomialGCD[poly_1, poly_2, ..., Modulus -> p] \
evaluates the GCD modulo the prime p. ", "synonyms" -> {}, "title" -> 
    "PolynomialGCD", "type" -> "Symbol", "uri" -> "ref/PolynomialGCD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7846, 247, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->50159349]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40158, 1577}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3091, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3714, 95, 51, 1, 70, "ObjectName",
 CellID->10223],
Cell[3768, 98, 1610, 51, 70, "Usage",
 CellID->12712]
}, Open  ]],
Cell[CellGroupData[{
Cell[5415, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5893, 171, 475, 17, 70, "Notes",
 CellID->27170],
Cell[6371, 190, 609, 21, 70, "Notes",
 CellID->4766],
Cell[6983, 213, 826, 29, 70, "Notes",
 CellID->29042]
}, Closed]],
Cell[CellGroupData[{
Cell[7846, 247, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->50159349],
Cell[CellGroupData[{
Cell[8230, 261, 147, 5, 70, "ExampleSection",
 CellID->72189360],
Cell[8380, 268, 86, 1, 70, "ExampleText",
 CellID->413363412],
Cell[CellGroupData[{
Cell[8491, 273, 513, 19, 28, "Input",
 CellID->375647984],
Cell[9007, 294, 273, 10, 36, "Output",
 CellID->33898322]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9329, 310, 215, 7, 70, "ExampleSection",
 CellID->4322],
Cell[9547, 319, 76, 1, 70, "ExampleText",
 CellID->73164955],
Cell[CellGroupData[{
Cell[9648, 324, 291, 10, 70, "Input",
 CellID->191097715],
Cell[9942, 336, 204, 7, 36, "Output",
 CellID->131070282]
}, Open  ]],
Cell[10161, 346, 125, 3, 70, "ExampleDelimiter",
 CellID->343619152],
Cell[10289, 351, 79, 1, 70, "ExampleText",
 CellID->206957919],
Cell[CellGroupData[{
Cell[10393, 356, 325, 11, 70, "Input",
 CellID->341104949],
Cell[10721, 369, 180, 6, 36, "Output",
 CellID->968234358]
}, Open  ]],
Cell[10916, 378, 124, 3, 70, "ExampleDelimiter",
 CellID->11097135],
Cell[11043, 383, 80, 1, 70, "ExampleText",
 CellID->164659289],
Cell[CellGroupData[{
Cell[11148, 388, 466, 16, 70, "Input",
 CellID->673771430],
Cell[11617, 406, 197, 7, 36, "Output",
 CellID->32258066]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11863, 419, 239, 7, 70, "ExampleSection",
 CellID->19595],
Cell[12105, 428, 73, 1, 70, "ExampleText",
 CellID->303378762],
Cell[CellGroupData[{
Cell[12203, 433, 752, 28, 70, "Input",
 CellID->765856930],
Cell[12958, 463, 464, 18, 53, "Output",
 CellID->366839041]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13471, 487, 217, 7, 70, "ExampleSection",
 CellID->8911],
Cell[CellGroupData[{
Cell[13713, 498, 226, 7, 70, "ExampleSubsection",
 CellID->21115],
Cell[13942, 507, 118, 3, 70, "ExampleText",
 CellID->253018439],
Cell[CellGroupData[{
Cell[14085, 514, 238, 8, 70, "Input",
 CellID->213770173],
Cell[14326, 524, 158, 5, 36, "Output",
 CellID->748131595]
}, Open  ]],
Cell[14499, 532, 484, 17, 70, "ExampleText",
 CellID->240831450],
Cell[CellGroupData[{
Cell[15008, 553, 293, 9, 70, "Input",
 CellID->14105561],
Cell[15304, 564, 191, 7, 38, "Output",
 CellID->89081880]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15544, 577, 222, 7, 70, "ExampleSubsection",
 CellID->387],
Cell[15769, 586, 85, 1, 70, "ExampleText",
 CellID->63591734],
Cell[CellGroupData[{
Cell[15879, 591, 302, 10, 70, "Input",
 CellID->173502094],
Cell[16184, 603, 226, 8, 36, "Output",
 CellID->3216209]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16459, 617, 221, 7, 70, "ExampleSubsection",
 CellID->31221],
Cell[16683, 626, 261, 8, 70, "ExampleText",
 CellID->411074813],
Cell[CellGroupData[{
Cell[16969, 638, 265, 9, 70, "Input",
 CellID->138321982],
Cell[17237, 649, 158, 5, 36, "Output",
 CellID->521647451]
}, Open  ]],
Cell[17410, 657, 474, 17, 70, "ExampleText",
 CellID->25147952],
Cell[CellGroupData[{
Cell[17909, 678, 311, 10, 70, "Input",
 CellID->212562188],
Cell[18223, 690, 187, 6, 36, "Output",
 CellID->834727124]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[18471, 703, 221, 7, 70, "ExampleSection",
 CellID->237],
Cell[18695, 712, 87, 1, 70, "ExampleText",
 CellID->246298022],
Cell[CellGroupData[{
Cell[18807, 717, 826, 29, 70, "Input",
 CellID->331804822],
Cell[19636, 748, 237, 8, 36, "Output",
 CellID->120521327]
}, Open  ]],
Cell[CellGroupData[{
Cell[19910, 761, 181, 6, 70, "Input",
 CellID->125742410],
Cell[20094, 769, 486, 19, 51, "Output",
 CellID->345075068]
}, Open  ]],
Cell[CellGroupData[{
Cell[20617, 793, 369, 12, 70, "Input",
 CellID->164344023],
Cell[20989, 807, 486, 19, 51, "Output",
 CellID->194745494]
}, Open  ]],
Cell[21490, 829, 125, 3, 70, "ExampleDelimiter",
 CellID->354206521],
Cell[21618, 834, 89, 1, 70, "ExampleText",
 CellID->215414733],
Cell[CellGroupData[{
Cell[21732, 839, 746, 26, 70, "Input",
 CellID->899252202],
Cell[22481, 867, 314, 11, 36, "Output",
 CellID->435458270]
}, Open  ]],
Cell[CellGroupData[{
Cell[22832, 883, 181, 6, 70, "Input",
 CellID->681842579],
Cell[23016, 891, 213, 7, 36, "Output",
 CellID->115275316]
}, Open  ]],
Cell[CellGroupData[{
Cell[23266, 903, 212, 7, 70, "Input",
 CellID->473025481],
Cell[23481, 912, 753, 18, 54, "Output",
 CellID->230036470]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24283, 936, 233, 7, 70, "ExampleSection",
 CellID->22604],
Cell[24519, 945, 266, 10, 70, "ExampleText",
 CellID->18185028],
Cell[CellGroupData[{
Cell[24810, 959, 826, 29, 70, "Input",
 CellID->403915550],
Cell[25639, 990, 237, 8, 36, "Output",
 CellID->139014123]
}, Open  ]],
Cell[CellGroupData[{
Cell[25913, 1003, 181, 6, 70, "Input",
 CellID->997477632],
Cell[26097, 1011, 203, 7, 36, "Output",
 CellID->796055599]
}, Open  ]],
Cell[26315, 1021, 263, 10, 70, "ExampleText",
 CellID->59582222],
Cell[CellGroupData[{
Cell[26603, 1035, 125, 4, 70, "Input",
 CellID->380599883],
Cell[26731, 1041, 366, 13, 56, "Output",
 CellID->1573382]
}, Open  ]],
Cell[27112, 1057, 235, 7, 70, "ExampleText",
 CellID->710239861],
Cell[CellGroupData[{
Cell[27372, 1068, 131, 4, 70, "Input",
 CellID->75288802],
Cell[27506, 1074, 620, 21, 39, "Output",
 CellID->266334633]
}, Open  ]],
Cell[CellGroupData[{
Cell[28163, 1100, 205, 8, 70, "Input",
 CellID->21191702],
Cell[28371, 1110, 158, 5, 36, "Output",
 CellID->178878424]
}, Open  ]],
Cell[28544, 1118, 124, 3, 70, "ExampleDelimiter",
 CellID->36408620],
Cell[28671, 1123, 263, 9, 70, "ExampleText",
 CellID->194711376],
Cell[CellGroupData[{
Cell[28959, 1136, 266, 9, 70, "Input",
 CellID->277174888],
Cell[29228, 1147, 158, 5, 36, "Output",
 CellID->339501817]
}, Open  ]],
Cell[CellGroupData[{
Cell[29423, 1157, 259, 9, 70, "Input",
 CellID->38330313],
Cell[29685, 1168, 180, 6, 36, "Output",
 CellID->359183869]
}, Open  ]],
Cell[CellGroupData[{
Cell[29902, 1179, 287, 10, 70, "Input",
 CellID->93077371],
Cell[30192, 1191, 178, 6, 36, "Output",
 CellID->561424790]
}, Open  ]],
Cell[CellGroupData[{
Cell[30407, 1202, 282, 10, 70, "Input",
 CellID->863364964],
Cell[30692, 1214, 158, 5, 36, "Output",
 CellID->141346879]
}, Open  ]],
Cell[30865, 1222, 124, 3, 70, "ExampleDelimiter",
 CellID->14529322],
Cell[30992, 1227, 564, 21, 70, "ExampleText",
 CellID->407152571],
Cell[31559, 1250, 320, 12, 70, "Input",
 CellID->20002916],
Cell[CellGroupData[{
Cell[31904, 1266, 131, 4, 70, "Input",
 CellID->331405909],
Cell[32038, 1272, 158, 5, 36, "Output",
 CellID->785629128]
}, Open  ]],
Cell[CellGroupData[{
Cell[32233, 1282, 186, 6, 70, "Input",
 CellID->133530601],
Cell[32422, 1290, 198, 7, 36, "Output",
 CellID->105742962]
}, Open  ]],
Cell[CellGroupData[{
Cell[32657, 1302, 131, 4, 70, "Input",
 CellID->560921847],
Cell[32791, 1308, 158, 5, 36, "Output",
 CellID->631944395]
}, Open  ]],
Cell[CellGroupData[{
Cell[32986, 1318, 195, 6, 70, "Input",
 CellID->60471566],
Cell[33184, 1326, 158, 5, 36, "Output",
 CellID->456150182]
}, Open  ]],
Cell[33357, 1334, 263, 8, 70, "ExampleText",
 CellID->662066817],
Cell[CellGroupData[{
Cell[33645, 1346, 181, 6, 70, "Input",
 CellID->368459124],
Cell[33829, 1354, 232, 8, 36, "Output",
 CellID->160172198]
}, Open  ]],
Cell[CellGroupData[{
Cell[34098, 1367, 181, 6, 70, "Input",
 CellID->461326751],
Cell[34282, 1375, 484, 19, 51, "Output",
 CellID->5007817]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34827, 1401, 311, 9, 70, "SeeAlsoSection",
 CellID->19946],
Cell[35141, 1412, 2256, 80, 70, "SeeAlso",
 CellID->16981]
}, Open  ]],
Cell[CellGroupData[{
Cell[37434, 1497, 312, 9, 70, "TutorialsSection",
 CellID->268],
Cell[37749, 1508, 180, 4, 70, "Tutorials",
 CellID->28458],
Cell[37932, 1514, 163, 3, 70, "Tutorials",
 CellID->180770870]
}, Open  ]],
Cell[CellGroupData[{
Cell[38132, 1522, 318, 9, 70, "MoreAboutSection",
 CellID->98390531],
Cell[38453, 1533, 147, 3, 70, "MoreAbout",
 CellID->651030206],
Cell[38603, 1538, 148, 3, 70, "MoreAbout",
 CellID->46971972]
}, Open  ]],
Cell[38766, 1544, 50, 0, 70, "History"],
Cell[38819, 1546, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

