(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30466,       1181]
NotebookOptionsPosition[     24127,        959]
NotebookOutlinePosition[     25591,        998]
CellTagsIndexPosition[     25506,        993]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], "LCM" :> 
          Documentation`HelpLookup["paclet:ref/LCM"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PolynomialGCD\"\>", 
       2->"\<\"LCM\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Division" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialDivision"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Division\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolynomialLCM", "ObjectName",
 CellID->27959],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialLCM",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialLCM"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the least common multiple of the polynomials ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialLCM",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialLCM"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{
         ButtonBox["Modulus",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Modulus"], "->", 
         StyleBox["p", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates the LCM modulo the prime ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17576]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialLCM",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialLCM"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " will by default treat algebraic numbers that appear in the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["poly", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as independent variables. "
}], "Notes",
 CellID->21708],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialLCM",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialLCM"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}]}], "]"}]], "InlineFormula"],
 " extends the coefficient field to include algebraic numbers that appear in \
the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["poly", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->90]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->152214739],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->188552490],

Cell["The least common multiple of polynomials:", "ExampleText",
 CellID->413363412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], 
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"4", "+", "x"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->375647984],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->481376225]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4322],

Cell["The LCM of univariate polynomials:", "ExampleText",
 CellID->73164955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", "4"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191097715],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "4"]}], ")"}]}]], "Output",
 ImageSize->{143, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->716928593]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->343619152],

Cell["The LCM of multivariate polynomials:", "ExampleText",
 CellID->206957919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"2", " ", "x", " ", "y"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"y", "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341104949],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "+", "y"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["y", "3"]}], ")"}]}]], "Output",
 ImageSize->{100, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91826988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11097135],

Cell["The LCM of more than two polynomials:", "ExampleText",
 CellID->164659289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "6"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "7"}], "-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673771430],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"], "+", 
    SuperscriptBox["x", "5"], "+", 
    SuperscriptBox["x", "6"]}], ")"}]}]], "Output",
 ImageSize->{571, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290996464]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26934],

Cell["The LCM of rational functions:", "ExampleText",
 CellID->303378762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "3"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "4"}], ")"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "5"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "3"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "6"}], ")"}]}], ")"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->765856930],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "5"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "3"}], "+", "x"}]]], "Output",
 ImageSize->{160, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->368572131]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8911],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Extension",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21115],

Cell["\<\
By default, algebraic numbers are treated as independent variables:\
\>", "ExampleText",
 CellID->253018439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
   RowBox[{"x", "-", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213770173],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SqrtBox["2"]}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{126, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133988152]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PolynomialLCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialLCM"]], "InlineFormula"],
 " detects algebraically dependent coefficients:"
}], "ExampleText",
 CellID->240831450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
   RowBox[{"x", "-", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14105561],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->182713007]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->387],

Cell["Compute the LCM over the integers modulo 2:", "ExampleText",
 CellID->63591734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "^", "3"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", "x"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173502094],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"x", "+", 
    SuperscriptBox["x", "3"]}], ")"}]}]], "Output",
 ImageSize->{94, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305222989]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31221],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["PolynomialLCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialLCM"]], "InlineFormula"],
 " treats trigonometric functions as independent variables:"
}], "ExampleText",
 CellID->411074813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", "x"}], "]"}], ",", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138321982],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"2", " ", "x"}], "]"}]}]], "Output",
 ImageSize->{141, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221889365]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trig",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trig"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PolynomialLCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialLCM"]], "InlineFormula"],
 " recognizes dependencies between trigonometric functions:"
}], "ExampleText",
 CellID->25147952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", "x"}], "]"}], ",", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->212562188],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"Cos", "[", "x", "]"}], " ", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->231335699]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22604],

Cell[TextData[{
 "The ",
 "LCM",
 " of polynomials is divisible by the polynomials; use ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " to prove it:"
}], "ExampleText",
 CellID->18185028],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "7"}], "-", 
    RowBox[{"2", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"5", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"12", "x"}], "+", "5"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    RowBox[{"x", "^", "7"}], "-", 
    RowBox[{"9", 
     RowBox[{"x", "^", "5"}]}], "+", 
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"17", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"7", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"6", "x"}], "+", "3"}]}], ";"}], "\n", 
 RowBox[{"m", "=", 
  RowBox[{"PolynomialLCM", "[", 
   RowBox[{"f", ",", "g"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->403915550],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"5", "-", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "-", 
    RowBox[{"6", " ", "x"}], "-", 
    RowBox[{"7", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    SuperscriptBox["x", "4"], "-", 
    RowBox[{"9", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    SuperscriptBox["x", "7"]}], ")"}]}]], "Output",
 ImageSize->{296, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67174882]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolynomialMod", "[", 
    RowBox[{"m", ",", "f"}], "]"}], ",", 
   RowBox[{"PolynomialMod", "[", 
    RowBox[{"m", ",", "g"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->997477632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->145475918]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " finds the greatest common divisor of polynomials:"
}], "ExampleText",
 CellID->710239861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{"f", ",", "g"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->75288802],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->957423768]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f", " ", "g"}], ")"}], "/", "%"}]}], " ", "//", 
  "Together"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21191702],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->120519649]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5883],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LCM",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LCM"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26415]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1164],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->10414194],

Cell[TextData[ButtonBox["Polynomial Division",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialDivision"]], "MoreAbout",
 CellID->148569122]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolynomialLCM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 11, 52.3252896}", "context" -> "System`", 
    "keywords" -> {
     "LCM of polynomials", "lowest common multiple", "polynomial LCM", 
      "polynomial least common multiple", "smallest common multiple"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PolynomialLCM[poly_1, poly_2, ...] gives the least common multiple of \
the polynomials poly_i. PolynomialLCM[poly_1, poly_2, ..., Modulus -> p] \
evaluates the LCM modulo the prime p. ", "synonyms" -> {}, "title" -> 
    "PolynomialLCM", "type" -> "Symbol", "uri" -> "ref/PolynomialLCM"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6165, 209, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->152214739]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25363, 986}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1892, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2515, 76, 51, 1, 70, "ObjectName",
 CellID->27959],
Cell[2569, 79, 1608, 51, 70, "Usage",
 CellID->17576]
}, Open  ]],
Cell[CellGroupData[{
Cell[4214, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4692, 152, 610, 21, 70, "Notes",
 CellID->21708],
Cell[5305, 175, 823, 29, 70, "Notes",
 CellID->90]
}, Closed]],
Cell[CellGroupData[{
Cell[6165, 209, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->152214739],
Cell[CellGroupData[{
Cell[6550, 223, 148, 5, 70, "ExampleSection",
 CellID->188552490],
Cell[6701, 230, 84, 1, 70, "ExampleText",
 CellID->413363412],
Cell[CellGroupData[{
Cell[6810, 235, 513, 19, 28, "Input",
 CellID->375647984],
Cell[7326, 256, 415, 15, 36, "Output",
 CellID->481376225]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7790, 277, 215, 7, 70, "ExampleSection",
 CellID->4322],
Cell[8008, 286, 76, 1, 70, "ExampleText",
 CellID->73164955],
Cell[CellGroupData[{
Cell[8109, 291, 291, 10, 70, "Input",
 CellID->191097715],
Cell[8403, 303, 409, 15, 39, "Output",
 CellID->716928593]
}, Open  ]],
Cell[8827, 321, 125, 3, 70, "ExampleDelimiter",
 CellID->343619152],
Cell[8955, 326, 79, 1, 70, "ExampleText",
 CellID->206957919],
Cell[CellGroupData[{
Cell[9059, 331, 325, 11, 70, "Input",
 CellID->341104949],
Cell[9387, 344, 326, 12, 39, "Output",
 CellID->91826988]
}, Open  ]],
Cell[9728, 359, 124, 3, 70, "ExampleDelimiter",
 CellID->11097135],
Cell[9855, 364, 80, 1, 70, "ExampleText",
 CellID->164659289],
Cell[CellGroupData[{
Cell[9960, 369, 466, 16, 70, "Input",
 CellID->673771430],
Cell[10429, 387, 966, 32, 39, "Output",
 CellID->290996464]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11444, 425, 239, 7, 70, "ExampleSection",
 CellID->26934],
Cell[11686, 434, 73, 1, 70, "ExampleText",
 CellID->303378762],
Cell[CellGroupData[{
Cell[11784, 439, 752, 28, 70, "Input",
 CellID->765856930],
Cell[12539, 469, 464, 18, 51, "Output",
 CellID->368572131]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13052, 493, 217, 7, 70, "ExampleSection",
 CellID->8911],
Cell[CellGroupData[{
Cell[13294, 504, 226, 7, 70, "ExampleSubsection",
 CellID->21115],
Cell[13523, 513, 118, 3, 70, "ExampleText",
 CellID->253018439],
Cell[CellGroupData[{
Cell[13666, 520, 238, 8, 70, "Input",
 CellID->213770173],
Cell[13907, 530, 356, 14, 43, "Output",
 CellID->133988152]
}, Open  ]],
Cell[14278, 547, 484, 17, 70, "ExampleText",
 CellID->240831450],
Cell[CellGroupData[{
Cell[14787, 568, 293, 9, 70, "Input",
 CellID->14105561],
Cell[15083, 579, 222, 8, 36, "Output",
 CellID->182713007]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15354, 593, 222, 7, 70, "ExampleSubsection",
 CellID->387],
Cell[15579, 602, 85, 1, 70, "ExampleText",
 CellID->63591734],
Cell[CellGroupData[{
Cell[15689, 607, 302, 10, 70, "Input",
 CellID->173502094],
Cell[15994, 619, 300, 11, 39, "Output",
 CellID->305222989]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16343, 636, 221, 7, 70, "ExampleSubsection",
 CellID->31221],
Cell[16567, 645, 261, 8, 70, "ExampleText",
 CellID->411074813],
Cell[CellGroupData[{
Cell[16853, 657, 265, 9, 70, "Input",
 CellID->138321982],
Cell[17121, 668, 341, 12, 39, "Output",
 CellID->221889365]
}, Open  ]],
Cell[17477, 683, 474, 17, 70, "ExampleText",
 CellID->25147952],
Cell[CellGroupData[{
Cell[17976, 704, 311, 10, 70, "Input",
 CellID->212562188],
Cell[18290, 716, 294, 10, 36, "Output",
 CellID->231335699]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[18645, 733, 233, 7, 70, "ExampleSection",
 CellID->22604],
Cell[18881, 742, 274, 10, 70, "ExampleText",
 CellID->18185028],
Cell[CellGroupData[{
Cell[19180, 756, 826, 29, 70, "Input",
 CellID->403915550],
Cell[20009, 787, 619, 21, 39, "Output",
 CellID->67174882]
}, Open  ]],
Cell[CellGroupData[{
Cell[20665, 813, 247, 8, 70, "Input",
 CellID->997477632],
Cell[20915, 823, 203, 7, 36, "Output",
 CellID->145475918]
}, Open  ]],
Cell[21133, 833, 237, 7, 70, "ExampleText",
 CellID->710239861],
Cell[CellGroupData[{
Cell[21395, 844, 131, 4, 70, "Input",
 CellID->75288802],
Cell[21529, 850, 237, 8, 36, "Output",
 CellID->957423768]
}, Open  ]],
Cell[CellGroupData[{
Cell[21803, 863, 205, 8, 70, "Input",
 CellID->21191702],
Cell[22011, 873, 158, 5, 36, "Output",
 CellID->120519649]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22230, 885, 310, 9, 70, "SeeAlsoSection",
 CellID->5883],
Cell[22543, 896, 451, 17, 70, "SeeAlso",
 CellID->26415]
}, Open  ]],
Cell[CellGroupData[{
Cell[23031, 918, 313, 9, 70, "TutorialsSection",
 CellID->1164],
Cell[23347, 929, 178, 4, 70, "Tutorials",
 CellID->597]
}, Open  ]],
Cell[CellGroupData[{
Cell[23562, 938, 318, 9, 70, "MoreAboutSection",
 CellID->10414194],
Cell[23883, 949, 149, 3, 70, "MoreAbout",
 CellID->148569122]
}, Open  ]],
Cell[24047, 955, 50, 0, 70, "History"],
Cell[24100, 957, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

