(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35116,       1346]
NotebookOptionsPosition[     27344,       1076]
NotebookOutlinePosition[     28696,       1113]
CellTagsIndexPosition[     28610,       1108]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"], 
          "Polynomials Modulo Primes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PolynomialsModuloPrimes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Algebraic Operations on Polynomials\"\>", 
       2->"\<\"Polynomials Modulo Primes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], "Mod" :> 
          Documentation`HelpLookup["paclet:ref/Mod"], "PolynomialRemainder" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialRemainder"], 
          "PolynomialReduce" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialReduce"], 
          "GroebnerBasis" :> 
          Documentation`HelpLookup["paclet:ref/GroebnerBasis"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolynomialGCD\"\>", 
       2->"\<\"Mod\"\>", 3->"\<\"PolynomialRemainder\"\>", 
       4->"\<\"PolynomialReduce\"\>", 
       5->"\<\"GroebnerBasis\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Division" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialDivision"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Polynomial Algebra\"\>", 
       3->"\<\"Polynomial Division\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolynomialMod", "ObjectName",
 CellID->8848],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialMod",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialMod"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the polynomial ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " reduced modulo ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialMod",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialMod"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reduces modulo all of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25926]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialMod"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " for integer ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " gives a polynomial in which all coefficients are reduced modulo ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30567],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a polynomial, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialMod"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " reduces ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " by subtracting polynomial multiples of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", to give a result with minimal degree and leading coefficient. "
}], "Notes",
 CellID->32407],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " gives results according to a definite convention; other conventions could \
yield results differing by multiples of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13977],

Cell[TextData[{
 "Unlike ",
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " never performs divisions in generating its results. "
}], "Notes",
 CellID->15471]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->568036093],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->59988398],

Cell["Reduce a polynomial modulo 2:", "ExampleText",
 CellID->165911493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"2", "x"}], "+", "1"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66656673],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220769184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->251196345],

Cell["Reduce a polynomial modulo another polynomial:", "ExampleText",
 CellID->706391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"2", "x"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->569814292],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", 
  RowBox[{"2", " ", "x"}]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->324874534]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2066],

Cell["Reduce a polynomial modulo an integer:", "ExampleText",
 CellID->162166446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"21", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"7", "x"}], "+", "55"}], ",", "9"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200640660],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"]}]}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143503873]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255029212],

Cell["Reduce a polynomial modulo a polynomial:", "ExampleText",
 CellID->323512125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"21", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"7", "x"}], "+", "55"}], ",", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "-", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1486454],

Cell[BoxData[
 RowBox[{
  FractionBox["257", "2"], "+", 
  FractionBox[
   RowBox[{"7", " ", "x"}], "2"]}]], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180049187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110718152],

Cell["Reduce a polynomial modulo a polynomial and an integer:", "ExampleText",
 CellID->52396928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"21", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"7", "x"}], "+", "55"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", 
       RowBox[{"x", "^", "2"}]}], "-", "7"}], ",", "9"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172636387],

Cell[BoxData[
 RowBox[{"7", "+", 
  RowBox[{"8", " ", "x"}]}]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248058670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186563937],

Cell["Reduce a polynomial modulo two polynomials and an integer:", \
"ExampleText",
 CellID->208489541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"21", 
     RowBox[{"x", "^", "2"}], 
     RowBox[{"y", "^", "2"}]}], "-", 
    RowBox[{"7", "x", " ", 
     RowBox[{"y", "^", "3"}]}], "+", "55"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", 
       RowBox[{"x", "^", "2"}]}], "-", "7"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", "3"}], ",", " ", "9"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317142083],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"7", " ", "x"}], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151002096]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->168265719],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CoefficientDomain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20278],

Cell[TextData[{
 "With the default ",
 Cell[BoxData[
  RowBox[{"CoefficientDomain", "->", 
   ButtonBox["Rationals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationals"]}]], "InlineFormula"],
 ", integer coefficients can be inverted:"
}], "ExampleText",
 CellID->604198005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12612290],

Cell[BoxData[
 FractionBox["1", "4"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->321243895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->309271349],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"CoefficientDomain", "->", 
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " does not invert integer coefficients:"
}], "ExampleText",
 CellID->122497602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "-", "1"}], ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168302093],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211778891]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->27290],

Cell["\<\
Reduce a polynomial modulo a polynomial over the integers modulo 3:\
\>", "ExampleText",
 CellID->416738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "-", "1"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254266626],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137724214]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29440],

Cell["Reduce all coefficients of a polynomial modulo an integer:", \
"ExampleText",
 CellID->277595287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1234", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "y"}], ")"}], "^", "7"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], "^", "5"}]}], ",", "7"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209912713],

Cell[BoxData[
 RowBox[{
  RowBox[{"6", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "4"], " ", "y"}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{"2", " ", "x", " ", 
   SuperscriptBox["y", "4"]}], "+", 
  SuperscriptBox["y", "5"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["y", "7"]}]}]], "Output",
 ImageSize->{314, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37370766]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20017],

Cell[TextData[{
 "For univariate rational polynomials ",
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->55601569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"4", "x"}], "+", "5"}], ",", 
   RowBox[{
    RowBox[{"6", 
     RowBox[{"x", "^", "2"}]}], "-", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210850776],

Cell[BoxData[
 RowBox[{
  FractionBox["17", "2"], "+", 
  FractionBox[
   RowBox[{"19", " ", "x"}], "3"]}]], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36368089]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"4", "x"}], "+", "5"}], ",", 
   RowBox[{
    RowBox[{"6", 
     RowBox[{"x", "^", "2"}]}], "-", "7"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216403314],

Cell[BoxData[
 RowBox[{
  FractionBox["17", "2"], "+", 
  FractionBox[
   RowBox[{"19", " ", "x"}], "3"]}]], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291507221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116149189],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 " considers all polynomials to be univariate in the specified variable:"
}], "ExampleText",
 CellID->861574931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "+", "a"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234466976],

Cell[BoxData[
 SuperscriptBox["a", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305252931]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->574371005],

Cell[TextData[{
 "For multivariate polynomials ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " picks its own variable order:"
}], "ExampleText",
 CellID->133572862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "+", "a"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->966788908],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63859824]
}, Open  ]],

Cell[TextData[{
 "The main variable here is ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->41709567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{"a", "^", "2"}], ",", 
   RowBox[{"x", "+", "a"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->370587824],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->368682956]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->558966844],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 " considers parameters to be invertible:"
}], "ExampleText",
 CellID->36497602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"a", "^", "2"}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "-", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5119588],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SuperscriptBox["a", "2"]], "+", 
  SuperscriptBox["a", "2"]}]], "Output",
 ImageSize->{46, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->382647734]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->534159430],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " does not invert symbolic expressions:"
}], "ExampleText",
 CellID->40329501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"a", "^", "2"}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551969435],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7040826]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13458],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialRemainder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialRemainder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GroebnerBasis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GroebnerBasis"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20759]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27205],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->2030],

Cell[TextData[ButtonBox["Polynomials Modulo Primes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PolynomialsModuloPrimes"]], "Tutorials",
 CellID->180770870]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->395832451],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->198549573],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->827248683],

Cell[TextData[ButtonBox["Polynomial Division",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialDivision"]], "MoreAbout",
 CellID->117324399]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
PolynomialMod"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolynomialMod - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 11, 52.8253024}", "context" -> "System`", 
    "keywords" -> {"modular reduction of polynomials", "polynomial moduli"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PolynomialMod[poly, m] gives the polynomial poly reduced modulo m. \
PolynomialMod[poly, {m_1, m_2, ...}] reduces modulo all of the m_i. ", 
    "synonyms" -> {"polynomial mod"}, "title" -> "PolynomialMod", "type" -> 
    "Symbol", "uri" -> "ref/PolynomialMod"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7282, 236, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->568036093]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28467, 1101}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2779, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3402, 91, 50, 1, 70, "ObjectName",
 CellID->8848],
Cell[3455, 94, 1430, 47, 70, "Usage",
 CellID->25926]
}, Open  ]],
Cell[CellGroupData[{
Cell[4922, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5400, 163, 481, 17, 70, "Notes",
 CellID->30567],
Cell[5884, 182, 607, 21, 70, "Notes",
 CellID->32407],
Cell[6494, 205, 358, 11, 70, "Notes",
 CellID->13977],
Cell[6855, 218, 390, 13, 70, "Notes",
 CellID->15471]
}, Closed]],
Cell[CellGroupData[{
Cell[7282, 236, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->568036093],
Cell[CellGroupData[{
Cell[7667, 250, 147, 5, 70, "ExampleSection",
 CellID->59988398],
Cell[7817, 257, 72, 1, 70, "ExampleText",
 CellID->165911493],
Cell[CellGroupData[{
Cell[7914, 262, 231, 8, 28, "Input",
 CellID->66656673],
Cell[8148, 272, 204, 7, 36, "Output",
 CellID->220769184]
}, Open  ]],
Cell[8367, 282, 125, 3, 70, "ExampleDelimiter",
 CellID->251196345],
Cell[8495, 287, 86, 1, 70, "ExampleText",
 CellID->706391],
Cell[CellGroupData[{
Cell[8606, 292, 281, 10, 70, "Input",
 CellID->569814292],
Cell[8890, 304, 221, 8, 36, "Output",
 CellID->324874534]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9160, 318, 215, 7, 70, "ExampleSection",
 CellID->2066],
Cell[9378, 327, 81, 1, 70, "ExampleText",
 CellID->162166446],
Cell[CellGroupData[{
Cell[9484, 332, 290, 10, 70, "Input",
 CellID->200640660],
Cell[9777, 344, 320, 11, 36, "Output",
 CellID->143503873]
}, Open  ]],
Cell[10112, 358, 125, 3, 70, "ExampleDelimiter",
 CellID->255029212],
Cell[10240, 363, 83, 1, 70, "ExampleText",
 CellID->323512125],
Cell[CellGroupData[{
Cell[10348, 368, 358, 13, 70, "Input",
 CellID->1486454],
Cell[10709, 383, 248, 9, 51, "Output",
 CellID->180049187]
}, Open  ]],
Cell[10972, 395, 125, 3, 70, "ExampleDelimiter",
 CellID->110718152],
Cell[11100, 400, 97, 1, 70, "ExampleText",
 CellID->52396928],
Cell[CellGroupData[{
Cell[11222, 405, 418, 16, 70, "Input",
 CellID->172636387],
Cell[11643, 423, 203, 7, 36, "Output",
 CellID->248058670]
}, Open  ]],
Cell[11861, 433, 125, 3, 70, "ExampleDelimiter",
 CellID->186563937],
Cell[11989, 438, 103, 2, 70, "ExampleText",
 CellID->208489541],
Cell[CellGroupData[{
Cell[12117, 444, 553, 20, 70, "Input",
 CellID->317142083],
Cell[12673, 466, 296, 10, 36, "Output",
 CellID->151002096]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13018, 482, 222, 7, 70, "ExampleSection",
 CellID->168265719],
Cell[CellGroupData[{
Cell[13265, 493, 234, 7, 70, "ExampleSubsection",
 CellID->20278],
Cell[13502, 502, 283, 9, 70, "ExampleText",
 CellID->604198005],
Cell[CellGroupData[{
Cell[13810, 515, 199, 7, 70, "Input",
 CellID->12612290],
Cell[14012, 524, 178, 6, 51, "Output",
 CellID->321243895]
}, Open  ]],
Cell[14205, 533, 125, 3, 70, "ExampleDelimiter",
 CellID->309271349],
Cell[14333, 538, 404, 14, 70, "ExampleText",
 CellID->122497602],
Cell[CellGroupData[{
Cell[14762, 556, 263, 8, 70, "Input",
 CellID->168302093],
Cell[15028, 566, 181, 6, 36, "Output",
 CellID->211778891]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15258, 578, 224, 7, 70, "ExampleSubsection",
 CellID->27290],
Cell[15485, 587, 115, 3, 70, "ExampleText",
 CellID->416738],
Cell[CellGroupData[{
Cell[15625, 594, 246, 8, 70, "Input",
 CellID->254266626],
Cell[15874, 604, 158, 5, 36, "Output",
 CellID->137724214]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[16093, 616, 223, 7, 70, "ExampleSection",
 CellID->29440],
Cell[16319, 625, 103, 2, 70, "ExampleText",
 CellID->277595287],
Cell[CellGroupData[{
Cell[16447, 631, 341, 13, 70, "Input",
 CellID->209912713],
Cell[16791, 646, 690, 23, 36, "Output",
 CellID->37370766]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17530, 675, 233, 7, 70, "ExampleSection",
 CellID->20017],
Cell[17766, 684, 390, 13, 70, "ExampleText",
 CellID->55601569],
Cell[CellGroupData[{
Cell[18181, 701, 358, 13, 70, "Input",
 CellID->210850776],
Cell[18542, 716, 247, 9, 51, "Output",
 CellID->36368089]
}, Open  ]],
Cell[CellGroupData[{
Cell[18826, 730, 374, 13, 70, "Input",
 CellID->216403314],
Cell[19203, 745, 248, 9, 51, "Output",
 CellID->291507221]
}, Open  ]],
Cell[19466, 757, 125, 3, 70, "ExampleDelimiter",
 CellID->116149189],
Cell[19594, 762, 269, 7, 70, "ExampleText",
 CellID->861574931],
Cell[CellGroupData[{
Cell[19888, 773, 196, 6, 70, "Input",
 CellID->234466976],
Cell[20087, 781, 181, 6, 36, "Output",
 CellID->305252931]
}, Open  ]],
Cell[20283, 790, 125, 3, 70, "ExampleDelimiter",
 CellID->574371005],
Cell[20411, 795, 251, 8, 70, "ExampleText",
 CellID->133572862],
Cell[CellGroupData[{
Cell[20687, 807, 180, 6, 70, "Input",
 CellID->966788908],
Cell[20870, 815, 180, 6, 36, "Output",
 CellID->63859824]
}, Open  ]],
Cell[21065, 824, 146, 6, 70, "ExampleText",
 CellID->41709567],
Cell[CellGroupData[{
Cell[21236, 834, 180, 6, 70, "Input",
 CellID->370587824],
Cell[21419, 842, 181, 6, 36, "Output",
 CellID->368682956]
}, Open  ]],
Cell[21615, 851, 125, 3, 70, "ExampleDelimiter",
 CellID->558966844],
Cell[21743, 856, 237, 7, 70, "ExampleText",
 CellID->36497602],
Cell[CellGroupData[{
Cell[22005, 867, 269, 9, 70, "Input",
 CellID->5119588],
Cell[22277, 878, 250, 9, 52, "Output",
 CellID->382647734]
}, Open  ]],
Cell[22542, 890, 125, 3, 70, "ExampleDelimiter",
 CellID->534159430],
Cell[22670, 895, 224, 7, 70, "ExampleText",
 CellID->40329501],
Cell[CellGroupData[{
Cell[22919, 906, 255, 9, 70, "Input",
 CellID->551969435],
Cell[23177, 917, 226, 8, 36, "Output",
 CellID->7040826]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23464, 932, 311, 9, 70, "SeeAlsoSection",
 CellID->13458],
Cell[23778, 943, 1234, 44, 70, "SeeAlso",
 CellID->20759]
}, Open  ]],
Cell[CellGroupData[{
Cell[25049, 992, 314, 9, 70, "TutorialsSection",
 CellID->27205],
Cell[25366, 1003, 179, 4, 70, "Tutorials",
 CellID->2030],
Cell[25548, 1009, 163, 3, 70, "Tutorials",
 CellID->180770870]
}, Open  ]],
Cell[CellGroupData[{
Cell[25748, 1017, 319, 9, 70, "MoreAboutSection",
 CellID->395832451],
Cell[26070, 1028, 164, 3, 70, "MoreAbout",
 CellID->198549573],
Cell[26237, 1033, 147, 3, 70, "MoreAbout",
 CellID->827248683],
Cell[26387, 1038, 149, 3, 70, "MoreAbout",
 CellID->117324399]
}, Open  ]],
Cell[CellGroupData[{
Cell[26573, 1046, 305, 8, 70, "RelatedLinksSection"],
Cell[26881, 1056, 391, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[27287, 1072, 27, 0, 70, "History"],
Cell[27317, 1074, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

