(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37238,       1468]
NotebookOptionsPosition[     28654,       1164]
NotebookOutlinePosition[     30106,       1203]
CellTagsIndexPosition[     30020,       1198]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolynomialRemainder" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialRemainder"], 
          "PolynomialReduce" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialReduce"], 
          "PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], "Apart" :> 
          Documentation`HelpLookup["paclet:ref/Apart"], "Cancel" :> 
          Documentation`HelpLookup["paclet:ref/Cancel"], "Quotient" :> 
          Documentation`HelpLookup["paclet:ref/Quotient"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolynomialRemainder\"\>", 
       2->"\<\"PolynomialReduce\"\>", 3->"\<\"PolynomialGCD\"\>", 
       4->"\<\"Apart\"\>", 5->"\<\"Cancel\"\>", 
       6->"\<\"Quotient\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Division" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialDivision"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Polynomial Algebra\"\>", 
       2->"\<\"Polynomial Division\"\>", 
       3->"\<\"Rational Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolynomialQuotient", "ObjectName",
 CellID->8653],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialQuotient",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialQuotient"], "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["q", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the quotient of ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     ", treated as polynomials in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with any remainder dropped. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11953]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Modulus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Modulus"], "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", the quotient is computed modulo ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->393141159]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->306293762],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->16325600],

Cell[TextData[{
 "The quotient of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "a"}], TraditionalForm]], "InlineMath"],
 ", with the remainder dropped:"
}], "ExampleText",
 CellID->636777077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotient", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "+", "a"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->76283391],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "a"}], "+", "x"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312903125]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"%", " ", 
   RowBox[{"(", 
    RowBox[{"x", "+", "a"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52914296],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["a", "2"]}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116028150]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15002],

Cell["\<\
The resulting polynomial will have coefficients that are rational expressions \
of input coefficients:\
\>", "ExampleText",
 CellID->539034256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437091989],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], "+", 
  FractionBox["x", "2"]}]], "Output",
 ImageSize->{39, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9705162]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", " ", 
    RowBox[{"b", " ", "x"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->132983447],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    SuperscriptBox["a", "2"]]}], "+", 
  FractionBox["b", "a"], "+", 
  FractionBox["x", "a"]}]], "Output",
 ImageSize->{76, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->712075066]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{
    RowBox[{"Pi", " ", "x"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->730441424],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    SuperscriptBox["\[Pi]", "2"]]}], "+", 
  FractionBox["1", "\[Pi]"], "+", 
  FractionBox["x", "\[Pi]"]}]], "Output",
 ImageSize->{79, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->361624048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->606569546],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialQuotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFormula"],
 " also works for rational functions:"
}], "ExampleText",
 CellID->645246260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotient", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", "+", "1"}], 
    RowBox[{"x", "+", "2"}]], ",", 
   FractionBox[
    RowBox[{"x", "+", "1"}], 
    RowBox[{"x", "+", "3"}]], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198260822],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", "+", "x"}], 
  RowBox[{"2", "+", "x"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82189757]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6968],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->74745948],

Cell["Use a prime modulus:", "ExampleText",
 CellID->463780863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", " ", "x"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "+", "1"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3407125],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->582140591]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", " ", "x"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "+", "1"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154342918],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}]}]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->390057047]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7666],

Cell[TextData[{
 "For a polynomial ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "==", 
   RowBox[{
    StyleBox["gq", "TI"], "+", 
    StyleBox["r", "TI"]}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->554893848],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"4", "x"}], "+", "1"}], ",", 
     RowBox[{"x", "+", "2"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183574653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "=", 
  RowBox[{"PolynomialQuotient", "[", 
   RowBox[{"f", ",", "g", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19683135],

Cell[BoxData[
 RowBox[{"2", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->407119956]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"PolynomialRemainder", "[", 
   RowBox[{"f", ",", "g", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->468974377],

Cell[BoxData[
 RowBox[{"-", "3"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->523349171]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " to verify identity:"
}], "ExampleText",
 CellID->229890328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"q", " ", "g"}], "+", "r"}], "]"}], "\[Equal]", "f"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->425153559],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->182894255]
}, Open  ]],

Cell[TextData[{
 "To get both quotient and remainder use ",
 Cell[BoxData[
  ButtonBox["PolynomialQuotientRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotientRemainder"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->657075916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotientRemainder", "[", 
  RowBox[{"f", ",", "g", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->607439311],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", "x"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->31136222]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->457672655],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialReduce"]], "InlineFormula"],
 " generalizes ",
 Cell[BoxData[
  ButtonBox["PolynomialQuotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFormula"],
 " for multivariate polynomials:"
}], "ExampleText",
 CellID->460214986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", "x"}], "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "+", "2"}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200852104],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", "+", "x"}], "}"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374959428]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65879878],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " to find a common divisor:"
}], "ExampleText",
 CellID->194427247],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"3", "x"}], "+", "2"}], ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"5", "x"}], "+", "6"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128259049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{"PolynomialGCD", "[", 
   RowBox[{"f", ",", "g"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->430879306],

Cell[BoxData[
 RowBox[{"2", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200158940]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PolynomialQuotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFormula"],
 " to see the resulting factorization:"
}], "ExampleText",
 CellID->697579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "\[Equal]", 
  RowBox[{
   RowBox[{"PolynomialQuotient", "[", 
    RowBox[{"f", ",", "h", ",", "x"}], "]"}], "h"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28323643],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "+", 
   RowBox[{"3", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], "\[Equal]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}]}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->797333682]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "\[Equal]", 
  RowBox[{
   RowBox[{"PolynomialQuotient", "[", 
    RowBox[{"g", ",", "h", ",", "x"}], "]"}], "h"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22120553],

Cell[BoxData[
 RowBox[{
  RowBox[{"6", "+", 
   RowBox[{"5", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], "\[Equal]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}]}]}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->26070063]
}, Open  ]],

Cell["\<\
For rational functions common divisors are not automatically canceled:\
\>", "ExampleText",
 CellID->399964870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/", "g"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->24839804],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", "+", 
   RowBox[{"3", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], 
  RowBox[{"6", "+", 
   RowBox[{"5", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{70, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->220079324]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " effectively uses ",
 Cell[BoxData[
  ButtonBox["PolynomialQuotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFormula"],
 " to cancel common divisors:"
}], "ExampleText",
 CellID->98015248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->299465445],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "x"}], 
  RowBox[{"3", "+", "x"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->665959056]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->461002],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Cyclotomic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cyclotomic"]], "InlineFormula"],
 " polynomials are defined as quotients:"
}], "ExampleText",
 CellID->100459553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", "1"}], ",", 
   RowBox[{"x", "-", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->424822612],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22022484]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cyclotomic", "[", 
  RowBox[{"5", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->512676588],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2311565]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12360],

Cell["The result depends on what is assumed to be a variable:", "ExampleText",
 CellID->6088599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolynomialQuotient", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"x", "-", "y"}], ",", "x"}], "]"}], ",", 
   RowBox[{"PolynomialQuotient", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"x", "-", "y"}], ",", "y"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40297341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"x", " ", "y"}], "+", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "x"}], "-", "y"}]}], "}"}]], "Output",
 ImageSize->{131, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233952428]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194132],

Cell[TextData[{
 "The result from ",
 Cell[BoxData[
  ButtonBox["PolynomialQuotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFormula"],
 " depends on recognizing zeros:"
}], "ExampleText",
 CellID->223627899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", "x", "+", "1"}], ",", 
   RowBox[{
    RowBox[{"zero", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "x", "+", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->379419714],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    SuperscriptBox["zero", "2"]]}], "+", 
  FractionBox["x", "zero"]}]], "Output",
 ImageSize->{95, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235041903]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", "x", "+", "1"}], ",", 
   RowBox[{"x", "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->447504587],

Cell[BoxData[
 RowBox[{"2", "-", "x", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1821511]
}, Open  ]],

Cell["This is a hidden zero:", "ExampleText",
 CellID->203085524],

Cell[BoxData[
 RowBox[{
  RowBox[{"zero", "=", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "+", 
      RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}], "-", 
    RowBox[{"Sin", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"5", "+", 
       RowBox[{"2", 
        RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}], "]"}]}]}], ";"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->439780337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "zero", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->194194319],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->545513060]
}, Open  ]],

Cell["The result is as if the hidden zero was not zero:", "ExampleText",
 CellID->68350574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolynomialQuotient", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "+", "x", "+", "1"}], ",", 
    RowBox[{
     RowBox[{"zero", " ", 
      RowBox[{"x", "^", "2"}]}], "+", "x", "+", "1"}], ",", "x"}], "]"}], "//",
   "N"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->417569497],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "5.070602400912918`*^30"}], "-", 
  RowBox[{"2.251799813685248`*^15", " ", "x"}]}]], "Output",
 ImageSize->{190, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->749139891]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18771],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialRemainder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialRemainder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cancel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cancel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quotient"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15229],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->4509]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->330822241],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->14265478],

Cell[TextData[ButtonBox["Polynomial Division",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialDivision"]], "MoreAbout",
 CellID->142229493],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->123659004]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolynomialQuotient - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 11, 54.4503440}", "context" -> "System`", 
    "keywords" -> {
     "division", "division of polynomials", "divisor", "polynomial division", 
      "Polynomial quotient", "quot", "quotient", "quotient of polynomials"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PolynomialQuotient[p, q, x] gives the quotient of p and q, treated as \
polynomials in x, with any remainder dropped. ", 
    "synonyms" -> {"polynomial quotient"}, "title" -> "PolynomialQuotient", 
    "type" -> "Symbol", "uri" -> "ref/PolynomialQuotient"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5086, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->306293762]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29877, 1191}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2661, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3284, 89, 55, 1, 70, "ObjectName",
 CellID->8653],
Cell[3342, 92, 858, 27, 70, "Usage",
 CellID->11953]
}, Open  ]],
Cell[CellGroupData[{
Cell[4237, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4715, 141, 334, 13, 70, "Notes",
 CellID->393141159]
}, Closed]],
Cell[CellGroupData[{
Cell[5086, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->306293762],
Cell[CellGroupData[{
Cell[5471, 173, 147, 5, 70, "ExampleSection",
 CellID->16325600],
Cell[5621, 180, 294, 11, 70, "ExampleText",
 CellID->636777077],
Cell[CellGroupData[{
Cell[5940, 195, 194, 6, 28, "Input",
 CellID->76283391],
Cell[6137, 203, 198, 7, 36, "Output",
 CellID->312903125]
}, Open  ]],
Cell[CellGroupData[{
Cell[6372, 215, 173, 6, 28, "Input",
 CellID->52914296],
Cell[6548, 223, 247, 9, 36, "Output",
 CellID->116028150]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6844, 238, 216, 7, 70, "ExampleSection",
 CellID->15002],
Cell[7063, 247, 153, 4, 70, "ExampleText",
 CellID->539034256],
Cell[CellGroupData[{
Cell[7241, 255, 250, 8, 70, "Input",
 CellID->437091989],
Cell[7494, 265, 220, 8, 51, "Output",
 CellID->9705162]
}, Open  ]],
Cell[CellGroupData[{
Cell[7751, 278, 285, 9, 70, "Input",
 CellID->132983447],
Cell[8039, 289, 298, 11, 52, "Output",
 CellID->712075066]
}, Open  ]],
Cell[CellGroupData[{
Cell[8374, 305, 256, 8, 70, "Input",
 CellID->730441424],
Cell[8633, 315, 310, 11, 52, "Output",
 CellID->361624048]
}, Open  ]],
Cell[8958, 329, 125, 3, 70, "ExampleDelimiter",
 CellID->606569546],
Cell[9086, 334, 232, 7, 70, "ExampleText",
 CellID->645246260],
Cell[CellGroupData[{
Cell[9343, 345, 291, 10, 70, "Input",
 CellID->198260822],
Cell[9637, 357, 223, 8, 51, "Output",
 CellID->82189757]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9909, 371, 217, 7, 70, "ExampleSection",
 CellID->6968],
Cell[CellGroupData[{
Cell[10151, 382, 227, 7, 70, "ExampleSubsection",
 CellID->74745948],
Cell[10381, 391, 63, 1, 70, "ExampleText",
 CellID->463780863],
Cell[CellGroupData[{
Cell[10469, 396, 319, 10, 70, "Input",
 CellID->3407125],
Cell[10791, 408, 204, 7, 36, "Output",
 CellID->582140591]
}, Open  ]],
Cell[CellGroupData[{
Cell[11032, 420, 321, 10, 70, "Input",
 CellID->154342918],
Cell[11356, 432, 203, 7, 36, "Output",
 CellID->390057047]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[11620, 446, 232, 7, 70, "ExampleSection",
 CellID->7666],
Cell[11855, 455, 523, 21, 70, "ExampleText",
 CellID->554893848],
Cell[12381, 478, 319, 12, 70, "Input",
 CellID->183574653],
Cell[CellGroupData[{
Cell[12725, 494, 170, 5, 70, "Input",
 CellID->19683135],
Cell[12898, 501, 180, 6, 36, "Output",
 CellID->407119956]
}, Open  ]],
Cell[CellGroupData[{
Cell[13115, 512, 172, 5, 70, "Input",
 CellID->468974377],
Cell[13290, 519, 175, 6, 36, "Output",
 CellID->523349171]
}, Open  ]],
Cell[13480, 528, 202, 8, 70, "ExampleText",
 CellID->229890328],
Cell[CellGroupData[{
Cell[13707, 540, 181, 6, 70, "Input",
 CellID->425153559],
Cell[13891, 548, 161, 5, 36, "Output",
 CellID->182894255]
}, Open  ]],
Cell[14067, 556, 260, 8, 70, "ExampleText",
 CellID->657075916],
Cell[CellGroupData[{
Cell[14352, 568, 156, 4, 70, "Input",
 CellID->607439311],
Cell[14511, 574, 245, 9, 36, "Output",
 CellID->31136222]
}, Open  ]],
Cell[14771, 586, 125, 3, 70, "ExampleDelimiter",
 CellID->457672655],
Cell[14899, 591, 380, 12, 70, "ExampleText",
 CellID->460214986],
Cell[CellGroupData[{
Cell[15304, 607, 297, 10, 70, "Input",
 CellID->200852104],
Cell[15604, 619, 271, 10, 36, "Output",
 CellID->374959428]
}, Open  ]],
Cell[15890, 632, 124, 3, 70, "ExampleDelimiter",
 CellID->65879878],
Cell[16017, 637, 222, 8, 70, "ExampleText",
 CellID->194427247],
Cell[16242, 647, 378, 14, 70, "Input",
 CellID->128259049],
Cell[CellGroupData[{
Cell[16645, 665, 156, 5, 70, "Input",
 CellID->430879306],
Cell[16804, 672, 180, 6, 36, "Output",
 CellID->200158940]
}, Open  ]],
Cell[16999, 681, 239, 8, 70, "ExampleText",
 CellID->697579],
Cell[CellGroupData[{
Cell[17263, 693, 197, 6, 70, "Input",
 CellID->28323643],
Cell[17463, 701, 391, 14, 36, "Output",
 CellID->797333682]
}, Open  ]],
Cell[CellGroupData[{
Cell[17891, 720, 197, 6, 70, "Input",
 CellID->22120553],
Cell[18091, 728, 390, 14, 36, "Output",
 CellID->26070063]
}, Open  ]],
Cell[18496, 745, 121, 3, 70, "ExampleText",
 CellID->399964870],
Cell[CellGroupData[{
Cell[18642, 752, 91, 3, 70, "Input",
 CellID->24839804],
Cell[18736, 757, 342, 12, 56, "Output",
 CellID->220079324]
}, Open  ]],
Cell[19093, 772, 361, 12, 70, "ExampleText",
 CellID->98015248],
Cell[CellGroupData[{
Cell[19479, 788, 102, 3, 70, "Input",
 CellID->299465445],
Cell[19584, 793, 224, 8, 51, "Output",
 CellID->665959056]
}, Open  ]],
Cell[19823, 804, 122, 3, 70, "ExampleDelimiter",
 CellID->461002],
Cell[19948, 809, 228, 8, 70, "ExampleText",
 CellID->100459553],
Cell[CellGroupData[{
Cell[20201, 821, 220, 7, 70, "Input",
 CellID->424822612],
Cell[20424, 830, 282, 9, 36, "Output",
 CellID->22022484]
}, Open  ]],
Cell[CellGroupData[{
Cell[20743, 844, 129, 4, 70, "Input",
 CellID->512676588],
Cell[20875, 850, 281, 9, 36, "Output",
 CellID->2311565]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21205, 865, 226, 7, 70, "ExampleSection",
 CellID->12360],
Cell[21434, 874, 96, 1, 70, "ExampleText",
 CellID->6088599],
Cell[CellGroupData[{
Cell[21555, 879, 488, 16, 70, "Input",
 CellID->40297341],
Cell[22046, 897, 359, 13, 39, "Output",
 CellID->233952428]
}, Open  ]],
Cell[22420, 913, 122, 3, 70, "ExampleDelimiter",
 CellID->194132],
Cell[22545, 918, 248, 8, 70, "ExampleText",
 CellID->223627899],
Cell[CellGroupData[{
Cell[22818, 930, 297, 10, 70, "Input",
 CellID->379419714],
Cell[23118, 942, 273, 10, 52, "Output",
 CellID->235041903]
}, Open  ]],
Cell[CellGroupData[{
Cell[23428, 957, 230, 7, 70, "Input",
 CellID->447504587],
Cell[23661, 966, 212, 7, 36, "Output",
 CellID->1821511]
}, Open  ]],
Cell[23888, 976, 65, 1, 70, "ExampleText",
 CellID->203085524],
Cell[23956, 979, 420, 15, 70, "Input",
 CellID->439780337],
Cell[CellGroupData[{
Cell[24401, 998, 111, 3, 70, "Input",
 CellID->194194319],
Cell[24515, 1003, 158, 5, 36, "Output",
 CellID->545513060]
}, Open  ]],
Cell[24688, 1011, 91, 1, 70, "ExampleText",
 CellID->68350574],
Cell[CellGroupData[{
Cell[24804, 1016, 327, 11, 70, "Input",
 CellID->417569497],
Cell[25134, 1029, 264, 8, 36, "Output",
 CellID->749139891]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25459, 1044, 311, 9, 70, "SeeAlsoSection",
 CellID->18771],
Cell[25773, 1055, 1469, 53, 70, "SeeAlso",
 CellID->13611]
}, Open  ]],
Cell[CellGroupData[{
Cell[27279, 1113, 314, 9, 70, "TutorialsSection",
 CellID->15229],
Cell[27596, 1124, 179, 4, 70, "Tutorials",
 CellID->4509]
}, Open  ]],
Cell[CellGroupData[{
Cell[27812, 1133, 319, 9, 70, "MoreAboutSection",
 CellID->330822241],
Cell[28134, 1144, 146, 3, 70, "MoreAbout",
 CellID->14265478],
Cell[28283, 1149, 149, 3, 70, "MoreAbout",
 CellID->142229493],
Cell[28435, 1154, 147, 3, 70, "MoreAbout",
 CellID->123659004]
}, Open  ]],
Cell[28597, 1160, 27, 0, 70, "History"],
Cell[28627, 1162, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

