(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26838,       1027]
NotebookOptionsPosition[     20765,        815]
NotebookOutlinePosition[     22143,        853]
CellTagsIndexPosition[     22058,        848]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolynomialQuotient" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialQuotient"], 
          "PolynomialRemainder" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialRemainder"], 
          "PolynomialReduce" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialReduce"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolynomialQuotient\"\>", 
       2->"\<\"PolynomialRemainder\"\>", 
       3->"\<\"PolynomialReduce\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Division" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialDivision"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60AlgebraicComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Polynomial Division\"\>", 
       2->"\<\"New in 6.0: Symbolic Computation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PolynomialQuotientRemainder", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialQuotientRemainder",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialQuotientRemainder"], "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["q", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]",
     " gives a list of the quotient and remainder of ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     ", treated as polynomials in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The remainder will always have a degree not greater than ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->157620861],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->400308267],

Cell["\<\
Find the quotient and remainder after dividing one polynomial by another:\
\>", "ExampleText",
 CellID->188944589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotientRemainder", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "+", "a"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36319125],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], "+", "x"}], ",", 
   SuperscriptBox["a", "2"]}], "}"}]], "Output",
 ImageSize->{76, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123648327]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["\<\
The resulting polynomial will have coefficients that are rational expressions \
of input coefficients:\
\>", "ExampleText",
 CellID->539034256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotientRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437091989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], "+", 
    FractionBox["x", "2"]}], ",", 
   FractionBox["3", "4"]}], "}"}]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->653060295]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotientRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", " ", 
    RowBox[{"b", " ", "x"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->132983447],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      SuperscriptBox["a", "2"]]}], "+", 
    FractionBox["b", "a"], "+", 
    FractionBox["x", "a"]}], ",", 
   RowBox[{"1", "+", 
    FractionBox["1", 
     SuperscriptBox["a", "2"]], "-", 
    FractionBox["b", "a"]}]}], "}"}]], "Output",
 ImageSize->{161, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81249293]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotientRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ",", 
   RowBox[{
    RowBox[{"Pi", " ", "x"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->730441424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      SuperscriptBox["\[Pi]", "2"]]}], "+", 
    FractionBox["1", "\[Pi]"], "+", 
    FractionBox["x", "\[Pi]"]}], ",", 
   RowBox[{"1", "+", 
    FractionBox["1", 
     SuperscriptBox["\[Pi]", "2"]], "-", 
    FractionBox["1", "\[Pi]"]}]}], "}"}]], "Output",
 ImageSize->{166, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->144683463]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->606569546],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialQuotientRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotientRemainder"]], "InlineFormula"],
 " also works for rational functions:"
}], "ExampleText",
 CellID->645246260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotientRemainder", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", "+", "1"}], 
    RowBox[{"x", "+", "2"}]], ",", 
   FractionBox[
    RowBox[{"x", "+", "1"}], 
    RowBox[{"x", "+", "3"}]], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198260822],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"3", "+", "x"}], 
    RowBox[{"2", "+", "x"}]], ",", "0"}], "}"}]], "Output",
 ImageSize->{67, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->406184656]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2061341341],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->868897745],

Cell["Use a prime modulus:", "ExampleText",
 CellID->463780863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotientRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", " ", "x"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "+", "1"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3407125],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], ",", "0"}], "}"}]], "Output",
 ImageSize->{69, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287602406]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotientRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", " ", "x"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "x"}], "+", "1"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154342918],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}]}], ",", "0"}], "}"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->911655507]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["\<\
Express the rational function as a polynomial and simple fraction:\
\>", "ExampleText",
 CellID->385221274],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"2", "x"}], "+", "1"}], ",", 
     RowBox[{"x", "+", "2"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88805884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "r"}], "}"}], "=", 
  RowBox[{"PolynomialQuotientRemainder", "[", 
   RowBox[{"f", ",", "g", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48805746],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32690770]
}, Open  ]],

Cell["The transformed rational function:", "ExampleText",
 CellID->42391208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "/", "g"}], "\[Equal]", 
  RowBox[{"q", "+", 
   RowBox[{"r", "/", "g"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->124706894],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"2", "+", "x"}]], "\[Equal]", 
  RowBox[{"x", "+", 
   FractionBox["1", 
    RowBox[{"2", "+", "x"}]]}]}]], "Output",
 ImageSize->{138, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->399475557]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->340352621],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->63058072]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "For a polynomial ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "==", 
   RowBox[{
    RowBox[{
     StyleBox["q", "TI"], " ", 
     StyleBox["g", "TI"]}], "+", 
    StyleBox["r", "TI"]}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->554893848],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"4", "x"}], "+", "1"}], ",", 
     RowBox[{"x", "+", "2"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183574653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "r"}], "}"}], "=", 
  RowBox[{"PolynomialQuotientRemainder", "[", 
   RowBox[{"f", ",", "g", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19683135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", "x"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->533837758]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " to verify identity:"
}], "ExampleText",
 CellID->229890328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"q", " ", "g"}], "+", "r"}], "]"}], "\[Equal]", "f"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->425153559],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->139538316]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialQuotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->12535475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolynomialQuotient", "[", 
    RowBox[{"f", ",", "g", ",", "x"}], "]"}], ",", 
   RowBox[{"PolynomialRemainder", "[", 
    RowBox[{"f", ",", "g", ",", "x"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->588172],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", "x"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->24641816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->457672655],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialReduce"]], "InlineFormula"],
 " generalizes ",
 Cell[BoxData[
  ButtonBox["PolynomialQuotientRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotientRemainder"]], "InlineFormula"],
 " for multivariate polynomials:"
}], "ExampleText",
 CellID->460214986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", "x"}], "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "+", "2"}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200852104],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", "+", "x"}], "}"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->353066668]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotientRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"4", "x"}], "+", "1"}], ",", 
   RowBox[{"x", "+", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->706010737],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", "x"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87772081]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialQuotient",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/PolynomialQuotient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialRemainder",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/PolynomialRemainder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialReduce",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/PolynomialReduce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6266]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->423745746],

Cell[TextData[ButtonBox["Polynomial Division",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialDivision"]], "MoreAbout",
 CellID->451472737],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->648009419]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolynomialQuotientRemainder - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 11, 55.3878680}", "context" -> "System`", 
    "keywords" -> {"remainder in polynomial division"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PolynomialQuotientRemainder[p, q, x] gives a list of the quotient and \
remainder of p and q, treated as polynomials in x. ", 
    "synonyms" -> {"polynomial quotient remainder"}, "title" -> 
    "PolynomialQuotientRemainder", "type" -> "Symbol", "uri" -> 
    "ref/PolynomialQuotientRemainder"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5485, 166, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->157620861]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21915, 841}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1654, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2277, 66, 1592, 37, 70, "ObjectNameGrid"],
Cell[3872, 105, 887, 28, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4796, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5274, 155, 174, 6, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[5485, 166, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->157620861],
Cell[CellGroupData[{
Cell[5870, 180, 148, 5, 70, "ExampleSection",
 CellID->400308267],
Cell[6021, 187, 124, 3, 70, "ExampleText",
 CellID->188944589],
Cell[CellGroupData[{
Cell[6170, 194, 203, 6, 28, "Input",
 CellID->36319125],
Cell[6376, 202, 272, 10, 39, "Output",
 CellID->123648327]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6697, 218, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[6921, 227, 153, 4, 70, "ExampleText",
 CellID->539034256],
Cell[CellGroupData[{
Cell[7099, 235, 259, 8, 70, "Input",
 CellID->437091989],
Cell[7361, 245, 295, 11, 51, "Output",
 CellID->653060295]
}, Open  ]],
Cell[CellGroupData[{
Cell[7693, 261, 294, 9, 70, "Input",
 CellID->132983447],
Cell[7990, 272, 462, 17, 52, "Output",
 CellID->81249293]
}, Open  ]],
Cell[CellGroupData[{
Cell[8489, 294, 265, 8, 70, "Input",
 CellID->730441424],
Cell[8757, 304, 483, 17, 52, "Output",
 CellID->144683463]
}, Open  ]],
Cell[9255, 324, 125, 3, 70, "ExampleDelimiter",
 CellID->606569546],
Cell[9383, 329, 250, 7, 70, "ExampleText",
 CellID->645246260],
Cell[CellGroupData[{
Cell[9658, 340, 300, 10, 70, "Input",
 CellID->198260822],
Cell[9961, 352, 275, 10, 51, "Output",
 CellID->406184656]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10285, 368, 223, 7, 70, "ExampleSection",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[10533, 379, 228, 7, 70, "ExampleSubsection",
 CellID->868897745],
Cell[10764, 388, 63, 1, 70, "ExampleText",
 CellID->463780863],
Cell[CellGroupData[{
Cell[10852, 393, 328, 10, 70, "Input",
 CellID->3407125],
Cell[11183, 405, 253, 9, 39, "Output",
 CellID->287602406]
}, Open  ]],
Cell[CellGroupData[{
Cell[11473, 419, 330, 10, 70, "Input",
 CellID->154342918],
Cell[11806, 431, 252, 9, 36, "Output",
 CellID->911655507]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[12119, 447, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[12349, 456, 117, 3, 70, "ExampleText",
 CellID->385221274],
Cell[12469, 461, 318, 12, 70, "Input",
 CellID->88805884],
Cell[CellGroupData[{
Cell[12812, 477, 226, 7, 70, "Input",
 CellID->48805746],
Cell[13041, 486, 202, 7, 36, "Output",
 CellID->32690770]
}, Open  ]],
Cell[13258, 496, 76, 1, 70, "ExampleText",
 CellID->42391208],
Cell[CellGroupData[{
Cell[13359, 501, 169, 6, 70, "Input",
 CellID->124706894],
Cell[13531, 509, 388, 14, 54, "Output",
 CellID->399475557]
}, Open  ]],
Cell[CellGroupData[{
Cell[13956, 528, 104, 3, 70, "Input",
 CellID->340352621],
Cell[14063, 533, 160, 5, 36, "Output",
 CellID->63058072]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14272, 544, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[14513, 553, 341, 15, 70, "ExampleText",
 CellID->554893848],
Cell[14857, 570, 319, 12, 70, "Input",
 CellID->183574653],
Cell[CellGroupData[{
Cell[15201, 586, 226, 7, 70, "Input",
 CellID->19683135],
Cell[15430, 595, 246, 9, 36, "Output",
 CellID->533837758]
}, Open  ]],
Cell[15691, 607, 202, 8, 70, "ExampleText",
 CellID->229890328],
Cell[CellGroupData[{
Cell[15918, 619, 181, 6, 70, "Input",
 CellID->425153559],
Cell[16102, 627, 161, 5, 36, "Output",
 CellID->139538316]
}, Open  ]],
Cell[16278, 635, 349, 12, 70, "ExampleText",
 CellID->12535475],
Cell[CellGroupData[{
Cell[16652, 651, 275, 8, 70, "Input",
 CellID->588172],
Cell[16930, 661, 245, 9, 36, "Output",
 CellID->24641816]
}, Open  ]],
Cell[17190, 673, 125, 3, 70, "ExampleDelimiter",
 CellID->457672655],
Cell[17318, 678, 398, 12, 70, "ExampleText",
 CellID->460214986],
Cell[CellGroupData[{
Cell[17741, 694, 297, 10, 70, "Input",
 CellID->200852104],
Cell[18041, 706, 271, 10, 36, "Output",
 CellID->353066668]
}, Open  ]],
Cell[CellGroupData[{
Cell[18349, 721, 259, 8, 70, "Input",
 CellID->706010737],
Cell[18611, 731, 245, 9, 36, "Output",
 CellID->87772081]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18917, 747, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19236, 758, 777, 26, 70, "SeeAlso",
 CellID->6266]
}, Open  ]],
Cell[CellGroupData[{
Cell[20050, 789, 319, 9, 70, "MoreAboutSection",
 CellID->423745746],
Cell[20372, 800, 149, 3, 70, "MoreAbout",
 CellID->451472737],
Cell[20524, 805, 169, 3, 70, "MoreAbout",
 CellID->648009419]
}, Open  ]],
Cell[20708, 811, 27, 0, 70, "History"],
Cell[20738, 813, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

