(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     74634,       2804]
NotebookOptionsPosition[     62575,       2380]
NotebookOutlinePosition[     64117,       2421]
CellTagsIndexPosition[     64031,       2416]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GroebnerBasis" :> 
          Documentation`HelpLookup["paclet:ref/GroebnerBasis"], 
          "PolynomialRemainder" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialRemainder"], 
          "PolynomialMod" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialMod"], 
          "PolynomialQuotient" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialQuotient"], 
          "SymmetricReduction" :> 
          Documentation`HelpLookup["paclet:ref/SymmetricReduction"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"GroebnerBasis\"\>", 
       2->"\<\"PolynomialRemainder\"\>", 3->"\<\"PolynomialMod\"\>", 
       4->"\<\"PolynomialQuotient\"\>", 
       5->"\<\"SymmetricReduction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Division" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialDivision"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Polynomial Algebra\"\>", 
       2->"\<\"Polynomial Division\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolynomialReduce", "ObjectName",
 CellID->4112],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PolynomialReduce",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PolynomialReduce"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["poly", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["poly", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a list representing a reduction of ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " in terms of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". The list has the form ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["b", "TI"]}], "}"}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " is minimal and ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], " ", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]]}], "+", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["2", "TR"]], " ", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]]}], "+", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     " ",
     Cell[BoxData[
      RowBox[{"+", 
       StyleBox["b", "TI"]}]], "InlineFormula"],
     " is exactly ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3856]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The polynomial ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " has the property that none of its terms are divisible by leading terms of \
any of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["poly", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23256],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["poly", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " form a Gr\[ODoubleDot]bner basis then this property uniquely determines \
the remainder obtained from ",
 Cell[BoxData[
  ButtonBox["PolynomialReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialReduce"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27730],

Cell[TextData[{
 "The following options can be given, as for ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 ": "
}], "Notes",
 CellID->11231],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "MonomialOrder", "Lexicographic", Cell[
    "the criterion used for ordering monomials ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "CoefficientDomain", 
    ButtonBox["Rationals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Rationals"], Cell[
    "the type of objects assumed to be coefficients ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Modulus",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Modulus"], "0", Cell[
    "the modulus for numerical coefficients ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->23034]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->65741687],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->190090542],

Cell["Reduce a polynomial wrt to a list of polynomials:", "ExampleText",
 CellID->159386967],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}], "-", "1"}], ",", 
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}], "-", "7"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"y", "^", "3"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->24317883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ql", ",", "r"}], "}"}], "=", 
  RowBox[{"PolynomialReduce", "[", 
   RowBox[{"f", ",", "pl", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14933326],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"1", "+", 
      SuperscriptBox["y", "2"]}]}], "}"}], ",", 
   RowBox[{"7", "-", 
    RowBox[{"2", " ", "y"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    SuperscriptBox["y", "3"]}]}], "}"}]], "Output",
 ImageSize->{191, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[2]= ]",
 CellID->294358471]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " is a linear combination of polynomials ",
 Cell[BoxData[
  FormBox["pl", TraditionalForm]], "InlineMath"],
 " and a remainder term ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->325122081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "\[Equal]", 
   RowBox[{
    RowBox[{"ql", ".", "pl"}], "+", "r"}]}], "//", "Expand"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->240837635],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[3]= ]",
 CellID->720472958]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20802],

Cell["\<\
Reduce a polynomial modulo a list of polynomials which is not a Gr\
\[ODoubleDot]bner basis:\
\>", "ExampleText",
 CellID->44513954],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"y", "^", "3"}], "+", 
    RowBox[{"3", "y"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->449177506],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4", "-", 
    SuperscriptBox["y", "2"], "+", 
    SuperscriptBox["y", "4"]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "-", "y", "+", 
    SuperscriptBox["y", "3"]}]}], "}"}]], "Output",
 ImageSize->{149, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281960567]
}, Open  ]],

Cell[TextData[{
 "The remainder is not zero, even though ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " belongs to the ideal generated by ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18802883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"f", ",", "polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->825315471],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "x"}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "y"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "-", "y", "+", 
    SuperscriptBox["y", "3"]}]}], "}"}]], "Output",
 ImageSize->{158, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->904136802]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " belongs to the ideal generated by ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 ", the remainder modulo ",
 Cell[BoxData[
  StyleBox["gb", "TI"]], "InlineFormula"],
 " must be zero:"
}], "ExampleText",
 CellID->53182717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"f", ",", "gb", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->521234442],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["x", "2"]}], "+", "y", "+", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox["y", "2"]}], "2"]}], ",", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"], "+", 
      FractionBox[
       RowBox[{"x", " ", "y"}], "2"], "-", 
      SuperscriptBox["y", "2"], "-", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox["y", "3"]}], "2"]}]}], "}"}], ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{270, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->592279970]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25471],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CoefficientDomain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->13580],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["PolynomialReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialReduce"]], "InlineFormula"],
 " works over the field of rational functions of parameters:"
}], "ExampleText",
 CellID->163472812],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"5", " ", "y"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"x", " ", "y"}], "-", 
      RowBox[{"y", "^", "2"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"poly", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], " ", "x"}], "-", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"y", "^", "2"}], "-", "3"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->400820042],

Cell[TextData[{
 "Compute the Gr\[ODoubleDot]bner basis of ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 " over the field of rational functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "(", "a", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->83196352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb1", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"CoefficientDomain", "\[Rule]", "RationalFunctions"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175051316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4", "-", 
    RowBox[{"16", " ", "y"}], "-", 
    RowBox[{"19", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["y", "3"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{"2", "-", 
    RowBox[{"4", " ", "a", " ", "x"}], "-", 
    RowBox[{"9", " ", "y"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       RowBox[{"2", " ", "a"}]}], ")"}], " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{383, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34801618]
}, Open  ]],

Cell[TextData[{
 "Reduce ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " modulo ",
 Cell[BoxData[
  StyleBox["gb1", "TI"]], "InlineFormula"],
 " over the field of rational functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "(", "a", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->90441890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"poly", ",", "gb1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->493305930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"4", " ", "a"}]]}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["a", "4"]}], "+", 
      FractionBox["y", 
       RowBox[{"4", " ", "a"}]]}]}], "}"}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"2", "-", 
      RowBox[{"6", " ", "a"}], "+", 
      SuperscriptBox["a", "2"]}], 
     RowBox[{"2", " ", "a"}]], "-", 
    FractionBox[
     RowBox[{"9", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        SuperscriptBox["a", "2"]}], ")"}], " ", "y"}], 
     RowBox[{"4", " ", "a"}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "10"}], "+", 
        RowBox[{"4", " ", "a"}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"]}]}], ")"}], " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"4", " ", "a"}]], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "-", 
       SuperscriptBox["a", "2"]}], ")"}], " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{549, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->584606752]
}, Open  ]],

Cell[TextData[{
 "Compute the Gr\[ODoubleDot]bner basis and reduce ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " over the integers:"
}], "ExampleText",
 CellID->307062128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb2", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"CoefficientDomain", "\[Rule]", "Integers"}]}], "]"}]}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->503061077],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4"}], "+", 
    RowBox[{"16", " ", "y"}], "+", 
    RowBox[{"19", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"4", " ", "a", " ", "x"}], "+", 
    RowBox[{"9", " ", "y"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"x", " ", "y"}], "-", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"5", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{566, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->99230210]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"poly", ",", "gb2", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->670660462],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "x"}]}]}], "}"}]], "Output",
 ImageSize->{192, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->27911110]
}, Open  ]],

Cell[TextData[{
 "Compute the Gr\[ODoubleDot]bner basis and reduce ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " over the rationals:"
}], "ExampleText",
 CellID->145215628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb3", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"CoefficientDomain", "\[Rule]", "Rationals"}]}], "]"}]}]], "Input",\

 CellLabel->"In[6]:=",
 CellID->8925530],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4"}], "+", 
    RowBox[{"16", " ", "y"}], "+", 
    RowBox[{"19", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"4", " ", "a", " ", "x"}], "+", 
    RowBox[{"9", " ", "y"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"x", " ", "y"}], "-", 
    SuperscriptBox["y", "2"]}]}], "}"}]], "Output",
 ImageSize->{476, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->181334039]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"poly", ",", "gb3", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", "Rationals"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->62266401],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["a", "4"], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    FractionBox["a", "2"], "+", 
    RowBox[{"2", " ", "x"}], "-", 
    FractionBox[
     RowBox[{"9", " ", "a", " ", "y"}], "4"], "-", 
    FractionBox[
     RowBox[{"5", " ", "a", " ", 
      SuperscriptBox["y", "2"]}], "4"], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["y", "2"]}], "2"], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["y", "3"]}], "4"]}]}], "}"}]], "Output",
 ImageSize->{349, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->233057026]
}, Open  ]],

Cell[TextData[{
 "Compute the Gr\[ODoubleDot]bner basis and reduce ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " using approximate arithmetic:"
}], "ExampleText",
 CellID->7432307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb4", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"CoefficientDomain", "\[Rule]", 
     RowBox[{"InexactNumbers", "[", "20", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->158063160],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4.`18.744727494896694"}], "+", 
    RowBox[{"16.`18.698970004336022", " ", "y"}], "+", 
    RowBox[{"19.`18.816355603053875", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"5.`18.920818753952375", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"1.`18.920818753952375", " ", "a", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`19.096910013008056"}], "+", 
    RowBox[{"1.`19.096910013008056", " ", "a", " ", "x"}], "+", 
    RowBox[{"2.25`19.079181246047625", " ", "y"}], "+", 
    RowBox[{"1.25`19.154901959985743", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"0.5`19.096910013008056", " ", "a", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"0.25`19.154901959985743", " ", "a", " ", 
     SuperscriptBox["y", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"2.`20.", " ", "x"}], "+", 
    RowBox[{"x", " ", "y"}], "-", 
    RowBox[{"1.`20.", " ", 
     SuperscriptBox["y", "2"]}]}]}], "}"}]], "Output",
 ImageSize->{558, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->278541892]
}, Open  ]],

Cell["\<\
The precision used is chosen automatically based on the precision of the Gr\
\[ODoubleDot]bner basis:\
\>", "ExampleText",
 CellID->82310537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"poly", ",", "gb4", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", "InexactNumbers"}]}], 
  "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->389643247],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"1.`18.39794000867204", " ", "a"}], ",", 
     RowBox[{"-", "1.`18.39794000867204"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`18.22184874961636"}], "+", 
    RowBox[{"0.5`18.22184874961636", " ", "a"}], "+", 
    RowBox[{"2.`18.22184874961636", " ", "x"}], "-", 
    RowBox[{"2.25`18.221848749616353", " ", "a", " ", "y"}], "-", 
    RowBox[{"1.25`18.22184874961636", " ", "a", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"0.5`18.22184874961636", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"0.25`18.22184874961636", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{480, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->8297721]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->10925],

Cell["\<\
Compute a Gr\[ODoubleDot]bner basis and reduce a polynomial over the integers \
modulo 7:\
\>", "ExampleText",
 CellID->434358650],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"y", " ", "z"}], "-", 
      RowBox[{"5", " ", "x"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", " ", "x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"x", "-", 
      RowBox[{"3", " ", "y"}], "+", 
      RowBox[{"x", " ", "z"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"z", "^", "2"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"poly", "=", 
   RowBox[{
    RowBox[{"z", "^", "9"}], "-", 
    RowBox[{
     RowBox[{"x", "^", "2"}], " ", 
     RowBox[{"y", "^", "3"}]}], "-", 
    RowBox[{"3", " ", "x", " ", 
     RowBox[{"y", "^", "2"}], " ", "z"}], "+", 
    RowBox[{"11", "y", " ", 
     RowBox[{"z", "^", "2"}]}], "+", 
    RowBox[{
     RowBox[{"x", "^", "2"}], " ", 
     RowBox[{"z", "^", "2"}]}], "-", "5"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"gb", "=", 
   RowBox[{"GroebnerBasis", "[", 
    RowBox[{"polys", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"poly", ",", "gb", ",", 
   RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->802782182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", 
      RowBox[{"4", " ", "z"}], "+", 
      SuperscriptBox["z", "2"]}], ",", "6", ",", "0", ",", "1"}], "}"}], ",", 
   
   RowBox[{"5", "+", 
    RowBox[{"6", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["y", "3"]}], "+", "z", "+", 
    RowBox[{"y", " ", "z"}], "+", 
    RowBox[{"4", " ", "x", " ", 
     SuperscriptBox["y", "2"], " ", "z"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"4", " ", "y", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    SuperscriptBox["z", "3"], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["z", "4"]}]}]}], "}"}]], "Output",
 ImageSize->{527, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44879387]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MonomialOrder",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20380],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["PolynomialReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialReduce"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["Lexicographic"], "InlineFormula"],
 " monomial order:"
}], "ExampleText",
 CellID->20575667],

Cell[BoxData[{
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"x", "^", "2"}]}], "+", "y", " ", "-", 
      RowBox[{"5", " ", "x"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", " ", "x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"poly", "=", 
   RowBox[{
    RowBox[{"x", " ", "y"}], "-", 
    RowBox[{"3", " ", "x", " ", 
     RowBox[{"y", "^", "2"}]}], " ", "+", 
    RowBox[{"11", "y"}], " ", "+", 
    RowBox[{"x", " ", "^", "3"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->547230903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb1", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->556906936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4"}], "-", 
    RowBox[{"8", " ", "y"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{"6", "+", 
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "-", 
    RowBox[{"22", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{337, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->71883101]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"poly", ",", "gb1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->260248053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["169", "144"]}], "-", 
      FractionBox[
       RowBox[{"53", " ", "x"}], "48"], "+", 
      FractionBox[
       RowBox[{"4", " ", "y"}], "3"], "+", 
      FractionBox[
       RowBox[{"5", " ", "x", " ", "y"}], "4"], "+", 
      FractionBox[
       RowBox[{"5", " ", 
        SuperscriptBox["y", "2"]}], "16"], "+", 
      FractionBox[
       RowBox[{"3", " ", "x", " ", 
        SuperscriptBox["y", "2"]}], "16"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["13", "24"]}], "-", 
      FractionBox[
       RowBox[{"3", " ", "x"}], "8"], "+", 
      FractionBox[
       SuperscriptBox["x", "2"], "4"], "-", 
      FractionBox[
       RowBox[{"7", " ", "y"}], "48"], "-", 
      FractionBox[
       RowBox[{"3", " ", "x", " ", "y"}], "16"], "+", 
      FractionBox[
       RowBox[{"37", " ", 
        SuperscriptBox["y", "2"]}], "24"], "+", 
      FractionBox[
       RowBox[{"11", " ", "x", " ", 
        SuperscriptBox["y", "2"]}], "8"], "+", 
      FractionBox[
       RowBox[{"5", " ", 
        SuperscriptBox["y", "3"]}], "16"], "+", 
      FractionBox[
       RowBox[{"3", " ", "x", " ", 
        SuperscriptBox["y", "3"]}], "16"]}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["13", "9"]}], "+", 
    FractionBox[
     RowBox[{"85", " ", "y"}], "9"], "+", 
    FractionBox[
     RowBox[{"58", " ", 
      SuperscriptBox["y", "2"]}], "9"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{549, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->145322197]
}, Open  ]],

Cell[TextData[{
 "Any ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " allowed by ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " can be used:"
}], "ExampleText",
 CellID->62149070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb2", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"MonomialOrder", "\[Rule]", "DegreeReverseLexicographic"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->687101919],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "x", " ", "y"}], "+", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "+", "y"}], ",", 
   RowBox[{
    RowBox[{"-", "6"}], "-", 
    RowBox[{"4", " ", "x"}], "-", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{373, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->679088868]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"poly", ",", "gb2", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "\[Rule]", "DegreeReverseLexicographic"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->333728152],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["8", "9"], "-", "y"}], ",", 
     RowBox[{
      FractionBox["5", "9"], "+", 
      FractionBox["x", "3"]}], ",", 
     FractionBox["1", "3"]}], "}"}], ",", 
   RowBox[{
    FractionBox["23", "9"], "+", 
    FractionBox[
     RowBox[{"8", " ", "x"}], "3"], "+", 
    FractionBox[
     RowBox[{"103", " ", "y"}], "9"], "-", 
    FractionBox[
     RowBox[{"74", " ", 
      SuperscriptBox["y", "2"]}], "9"]}]}], "}"}]], "Output",
 ImageSize->{289, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->506667388]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Tolerance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->137],

Cell["Compute approximate quotients:", "ExampleText",
 CellID->60688897],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{
    RowBox[{"x", "^", "14"}], "+", 
    RowBox[{"3.00001", "*", 
     RowBox[{"x", "^", "10"}]}], "-", 
    RowBox[{"7.99998", "*", 
     RowBox[{"x", "^", "7"}]}], "-", 
    RowBox[{"25.00002", "*", 
     RowBox[{"x", "^", "6"}]}], "+", 
    RowBox[{"3.00001", "*", 
     RowBox[{"x", "^", "13"}]}], "+", 
    RowBox[{"9.00006", "*", 
     RowBox[{"x", "^", "9"}]}], "-", 
    RowBox[{"3.00001", "*", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"2.00001", "*", 
     RowBox[{"x", "^", "8"}]}], "-", 
    RowBox[{"6.00005", "*", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"16.00004", "*", "x"}], "+", "2.00001"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->576947958],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{"-", "2.0001465223696937"}], " ", "+", " ", 
    RowBox[{"3.0002401628321618", "*", 
     RowBox[{"x", "^", "5"}]}], " ", "+", " ", 
    RowBox[{"1.", "*", 
     RowBox[{"x", "^", "6"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->159013302],

Cell[TextData[{
 "With the default zero tolerance ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " does not divide ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->227418151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"p", ",", 
   RowBox[{"{", "d", "}"}], ",", "x", ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", "InexactNumbers"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5502165],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "0.4718714366440864`"}], "-", 
       RowBox[{"8.174934686387566`", " ", "x"}], "+", 
       RowBox[{"0.058160119700057654`", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"0.01933965088834455`", " ", 
        SuperscriptBox["x", "3"]}], "+", 
       RowBox[{"3.0062258890549036`", " ", 
        SuperscriptBox["x", "4"]}], "-", 
       RowBox[{"0.002071797162076516`", " ", 
        SuperscriptBox["x", "5"]}], "+", 
       RowBox[{"0.0006905437730427502`", " ", 
        SuperscriptBox["x", "6"]}], "-", 
       RowBox[{"0.00023016283216170663`", " ", 
        SuperscriptBox["x", "7"]}], "+", 
       RowBox[{"1.`", " ", 
        SuperscriptBox["x", "8"]}]}], ")"}]}], "}"}], ",", 
   RowBox[{"1.0561979869907394`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.3510271835774752`", " ", "x"}], "+", 
    RowBox[{"0.11632876115867542`", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"0.03868213546816631`", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"0.012842257450905947`", " ", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"1.588426261975883`", " ", 
     SuperscriptBox["x", "5"]}]}]}], "}"}]], "Output",
 ImageSize->{483, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->47983059]
}, Open  ]],

Cell["\<\
Increasing the tolerance allows to obtain an approximate quotient and a zero \
remainder:\
\>", "ExampleText",
 CellID->88451196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"p", ",", 
   RowBox[{"{", "d", "}"}], ",", "x", ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", "InexactNumbers"}], ",", 
   RowBox[{"Tolerance", "\[Rule]", "0.01"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->263328039],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "0.998158702145961`"}], "-", 
       RowBox[{"7.99998`", " ", "x"}], "+", 
       RowBox[{"3.00001`", " ", 
        SuperscriptBox["x", "4"]}], "+", 
       RowBox[{"1.`", " ", 
        SuperscriptBox["x", "8"]}]}], ")"}]}], "}"}], ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{336, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->89229771]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25867],

Cell["\<\
Test whether polynomials belong to the ideal generated by a set of \
polynomials:\
\>", "ExampleText",
 CellID->47976508],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "6"}], "-", 
    RowBox[{"14", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"y", "^", "4"}], "+", "49"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", 
    RowBox[{"y", "^", "5"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "3"}], "-", "5"}], ",", 
     RowBox[{
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"x", "^", "3"}], "+", "7"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->388509017],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"76", "-", 
    RowBox[{"14", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"75", " ", 
     SuperscriptBox["y", "3"]}], "-", 
    SuperscriptBox["y", "4"], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["y", "6"]}], "+", 
    SuperscriptBox["y", "9"]}], ",", 
   RowBox[{
    RowBox[{"-", "1260"}], "+", 
    RowBox[{"368", " ", "x"}], "+", 
    RowBox[{"76", " ", "y"}], "+", 
    RowBox[{"170", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"497", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"50", " ", 
     SuperscriptBox["y", "4"]}], "+", 
    RowBox[{"70", " ", 
     SuperscriptBox["y", "5"]}], "-", 
    RowBox[{"49", " ", 
     SuperscriptBox["y", "6"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["y", "7"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["y", "8"]}]}]}], "}"}]], "Output",
 ImageSize->{429, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46679626]
}, Open  ]],

Cell[TextData[{
 "The remainder is zero, hence ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " belongs to the ideal generated by ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->166144144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolynomialReduce", "[", 
   RowBox[{"f", ",", "gb", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->462934585],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110444399]
}, Open  ]],

Cell[TextData[{
 "The remainder is not zero, hence ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " does not belong to the ideal generated by ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16520646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolynomialReduce", "[", 
   RowBox[{"g", ",", "gb", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->77419897],

Cell[BoxData[
 RowBox[{"35", "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"7", " ", 
   SuperscriptBox["y", "3"]}]}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->445349700]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206366485],

Cell["\<\
Replace variables in a polynomial using equations relating old and new \
variables:\
\>", "ExampleText",
 CellID->67137530],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"poly", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "y"}], ")"}], "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "==", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}]}], ",", 
     RowBox[{"b", "==", 
      RowBox[{"x", "  ", "y"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"eqns", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->355983160],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    SuperscriptBox["y", "4"]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "-", 
    RowBox[{"a", " ", "y"}], "+", 
    SuperscriptBox["y", "3"]}], ",", 
   RowBox[{
    RowBox[{"-", "b"}], "+", 
    RowBox[{"x", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"-", "a"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}]}], "}"}]], "Output",
 ImageSize->{306, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306565839]
}, Open  ]],

Cell[TextData[{
 "The remainder gives a representation of ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " in terms of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->36938167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"qs", ",", "r"}], "}"}], "=", 
  RowBox[{"PolynomialReduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "^", "2"}], ",", "gb", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->501321488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "-", 
        RowBox[{"2", " ", "b"}]}], 
       SuperscriptBox["b", "2"]], "+", 
      FractionBox[
       SuperscriptBox["y", "2"], 
       SuperscriptBox["b", "2"]]}], ",", 
     RowBox[{
      FractionBox["x", "b"], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"2", " ", "b"}]}], ")"}], " ", "y"}], 
       SuperscriptBox["b", "2"]], "-", 
      FractionBox[
       SuperscriptBox["y", "3"], 
       SuperscriptBox["b", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"a", "+", 
    RowBox[{"2", " ", "b"}]}]}], "}"}]], "Output",
 ImageSize->{323, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26417098]
}, Open  ]],

Cell["This proves correctness of the representation:", "ExampleText",
 CellID->356366293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"poly", "==", "r"}], "/.", 
   RowBox[{"ToRules", "[", 
    RowBox[{"And", "@@", "eqns"}], "]"}]}], "//", "Expand"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->109900082],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->104292511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->405278834],

Cell[TextData[{
 "Compute representation of a polynomial in an algebra ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SubscriptBox["p", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["p", "n"]}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->355186149],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"x", "  ", "y"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->844105529],

Cell["\<\
Introduce tag variables and order them last in the monomial ordering:\
\>", "ExampleText",
 CellID->302898838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f1", "-", "p1"}], ",", 
      RowBox[{"f2", "-", "p2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4673396],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["f2", "2"], "-", 
    RowBox[{"f1", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    SuperscriptBox["y", "4"]}], ",", 
   RowBox[{
    RowBox[{"f2", " ", "x"}], "-", 
    RowBox[{"f1", " ", "y"}], "+", 
    SuperscriptBox["y", "3"]}], ",", 
   RowBox[{
    RowBox[{"-", "f2"}], "+", 
    RowBox[{"x", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"-", "f1"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}]}], "}"}]], "Output",
 ImageSize->{348, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[2]= ]",
 CellID->167082347]
}, Open  ]],

Cell[TextData[{
 "Since the remainder is in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SubscriptBox["f", "1"], ",", 
     SubscriptBox["f", "2"]}], "]"}], TraditionalForm]], "InlineMath"],
 ", this shows that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "4"], "\[Element]", 
    RowBox[{"\[DoubleStruckCapitalQ]", "[", 
     RowBox[{
      SubscriptBox["p", "1"], ",", 
      SubscriptBox["p", "2"]}], "]"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->306798126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{"PolynomialReduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "^", "4"}], ",", "gb", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->247682360],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f1", "2"], "+", 
  RowBox[{"4", " ", "f1", " ", "f2"}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["f2", "2"]}]}]], "Output",
 ImageSize->{120, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[3]= ]",
 CellID->665790192]
}, Open  ]],

Cell["Check the result:", "ExampleText",
 CellID->100376898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f1", "\[Rule]", "p1"}], ",", 
     RowBox[{"f2", "\[Rule]", "p2"}]}], "}"}]}], "//", "Factor"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->646711224],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"x", "+", "y"}], ")"}], "4"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[4]= ]",
 CellID->46317167]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28728],

Cell["Reduce a polynomial with respect to a list of polynomials:", \
"ExampleText",
 CellID->898145633],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"2", "x", " ", 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"y", "^", "3"}], "+", "7"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}], "-", "3"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", "5"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"qs", ",", "r"}], "}"}], "=", 
  RowBox[{"PolynomialReduce", "[", 
   RowBox[{"f", ",", "polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->68588467],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "y"}]}], "}"}], ",", 
   RowBox[{"10", "-", 
    RowBox[{"10", " ", "y"}], "+", 
    SuperscriptBox["y", "2"], "+", 
    SuperscriptBox["y", "3"]}]}], "}"}]], "Output",
 ImageSize->{187, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23575331]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is equal to the linear combination of ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 " with coefficients ",
 Cell[BoxData[
  StyleBox["qs", "TI"]], "InlineFormula"],
 " plus the remainder ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->274493008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "\[Equal]", 
   RowBox[{
    RowBox[{"qs", ".", "polys"}], "+", "r"}]}], "//", "Expand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99962079],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->325914595]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199725312],

Cell["\<\
A polynomial belongs to the ideal generated by a Gr\[ODoubleDot]bner basis \
iff it reduces to zero:\
\>", "ExampleText",
 CellID->6130188],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}], "-", "1"}], ",", 
     RowBox[{"x", "-", 
      RowBox[{"2", 
       RowBox[{"y", "^", "3"}]}], "-", "3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48081135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}], "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1", ",", "p2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4932523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8", "+", 
    SuperscriptBox["y", "2"], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "6"]}], "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "x", "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{234, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->348284566]
}, Open  ]],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData["p1"], "InlineFormula"],
 " is in the ideal ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->588708258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{"p1", ",", 
   RowBox[{"{", 
    RowBox[{"g1", ",", "g2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->64127991],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"3", "+", "x", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["y", "3"]}]}]}], "}"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{131, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->173755209]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130383643],

Cell[TextData[{
 "Univariate ",
 Cell[BoxData[
  ButtonBox["PolynomialReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialReduce"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["PolynomialQuotientRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotientRemainder"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->82401091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", 
    RowBox[{"3", "x"}], "+", "7"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", 
      RowBox[{"x", "^", "3"}]}], "-", 
     RowBox[{"5", "x"}], "+", "11"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114483272],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["5", "4"], "+", 
     FractionBox[
      SuperscriptBox["x", "2"], "2"]}], "}"}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["27", "4"]}], "+", 
    FractionBox[
     RowBox[{"13", " ", "x"}], "4"], "-", 
    FractionBox[
     RowBox[{"11", " ", 
      SuperscriptBox["x", "2"]}], "2"]}]}], "}"}]], "Output",
 ImageSize->{197, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->278372137]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotientRemainder", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", 
    RowBox[{"3", "x"}], "+", "7"}], ",", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"5", "x"}], "+", "11"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->158558769],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["5", "4"], "+", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["27", "4"]}], "+", 
    FractionBox[
     RowBox[{"13", " ", "x"}], "4"], "-", 
    FractionBox[
     RowBox[{"11", " ", 
      SuperscriptBox["x", "2"]}], "2"]}]}], "}"}]], "Output",
 ImageSize->{183, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->404412977]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13265],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GroebnerBasis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GroebnerBasis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialRemainder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialRemainder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialMod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialQuotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialQuotient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymmetricReduction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SymmetricReduction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27236]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28501],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->24171]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->384137252],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->229071737],

Cell[TextData[ButtonBox["Polynomial Division",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialDivision"]], "MoreAbout",
 CellID->554629136]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
PolynomialReduce"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolynomialReduce - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 2.4974250}", "context" -> "System`", 
    "keywords" -> {
     "generalized division", "generalized polynomial remainder", 
      "normal form", "polynomial interreduction"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PolynomialReduce[poly, {poly_1, poly_2, ...}, {x_1, x_2, ...}] yields a \
list representing a reduction of poly in terms of the poly_i. The list has \
the form {{a_1, a_2, ...}, b}, where b is minimal and a_1 poly_1 + a_2 poly_2 \
+ ... +b is exactly poly. ", "synonyms" -> {"polynomial reduce"}, "title" -> 
    "PolynomialReduce", "type" -> "Symbol", "uri" -> 
    "ref/PolynomialReduce"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8224, 263, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->65741687]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 63889, 2409}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2505, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3128, 87, 53, 1, 70, "ObjectName",
 CellID->4112],
Cell[3184, 90, 2549, 84, 70, "Usage",
 CellID->3856]
}, Open  ]],
Cell[CellGroupData[{
Cell[5770, 179, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6248, 196, 323, 12, 70, "Notes",
 CellID->23256],
Cell[6574, 210, 408, 14, 70, "Notes",
 CellID->27730],
Cell[6985, 226, 227, 8, 70, "Notes",
 CellID->11231],
Cell[7215, 236, 972, 22, 70, "3ColumnTableMod",
 CellID->23034]
}, Closed]],
Cell[CellGroupData[{
Cell[8224, 263, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->65741687],
Cell[CellGroupData[{
Cell[8608, 277, 148, 5, 70, "ExampleSection",
 CellID->190090542],
Cell[8759, 284, 92, 1, 70, "ExampleText",
 CellID->159386967],
Cell[8854, 287, 454, 17, 70, "Input",
 CellID->24317883],
Cell[CellGroupData[{
Cell[9333, 308, 268, 9, 28, "Input",
 CellID->14933326],
Cell[9604, 319, 465, 16, 53, "Output",
 CellID->294358471]
}, Open  ]],
Cell[10084, 338, 324, 11, 70, "ExampleText",
 CellID->325122081],
Cell[CellGroupData[{
Cell[10433, 353, 179, 6, 70, "Input",
 CellID->240837635],
Cell[10615, 361, 172, 5, 50, "Output",
 CellID->720472958]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10836, 372, 216, 7, 70, "ExampleSection",
 CellID->20802],
Cell[11055, 381, 142, 4, 70, "ExampleText",
 CellID->44513954],
Cell[CellGroupData[{
Cell[11222, 389, 637, 23, 70, "Input",
 CellID->449177506],
Cell[11862, 414, 375, 13, 39, "Output",
 CellID->281960567]
}, Open  ]],
Cell[12252, 430, 260, 9, 70, "ExampleText",
 CellID->18802883],
Cell[CellGroupData[{
Cell[12537, 443, 198, 6, 70, "Input",
 CellID->825315471],
Cell[12738, 451, 412, 15, 39, "Output",
 CellID->904136802]
}, Open  ]],
Cell[13165, 469, 325, 12, 70, "ExampleText",
 CellID->53182717],
Cell[CellGroupData[{
Cell[13515, 485, 195, 6, 70, "Input",
 CellID->521234442],
Cell[13713, 493, 671, 24, 54, "Output",
 CellID->592279970]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14433, 523, 218, 7, 70, "ExampleSection",
 CellID->25471],
Cell[CellGroupData[{
Cell[14676, 534, 234, 7, 70, "ExampleSubsection",
 CellID->13580],
Cell[14913, 543, 268, 8, 70, "ExampleText",
 CellID->163472812],
Cell[15184, 553, 599, 21, 70, "Input",
 CellID->400820042],
Cell[15786, 576, 326, 11, 70, "ExampleText",
 CellID->83196352],
Cell[CellGroupData[{
Cell[16137, 591, 290, 9, 70, "Input",
 CellID->175051316],
Cell[16430, 602, 762, 26, 39, "Output",
 CellID->34801618]
}, Open  ]],
Cell[17207, 631, 363, 14, 70, "ExampleText",
 CellID->90441890],
Cell[CellGroupData[{
Cell[17595, 649, 199, 6, 70, "Input",
 CellID->493305930],
Cell[17797, 657, 1351, 48, 57, "Output",
 CellID->584606752]
}, Open  ]],
Cell[19163, 708, 191, 6, 70, "ExampleText",
 CellID->307062128],
Cell[CellGroupData[{
Cell[19379, 718, 279, 9, 70, "Input",
 CellID->503061077],
Cell[19661, 729, 1031, 35, 39, "Output",
 CellID->99230210]
}, Open  ]],
Cell[CellGroupData[{
Cell[20729, 769, 262, 7, 70, "Input",
 CellID->670660462],
Cell[20994, 778, 424, 15, 39, "Output",
 CellID->27911110]
}, Open  ]],
Cell[21433, 796, 192, 6, 70, "ExampleText",
 CellID->145215628],
Cell[CellGroupData[{
Cell[21650, 806, 278, 9, 70, "Input",
 CellID->8925530],
Cell[21931, 817, 891, 30, 39, "Output",
 CellID->181334039]
}, Open  ]],
Cell[CellGroupData[{
Cell[22859, 852, 262, 7, 70, "Input",
 CellID->62266401],
Cell[23124, 861, 806, 28, 54, "Output",
 CellID->233057026]
}, Open  ]],
Cell[23945, 892, 200, 6, 70, "ExampleText",
 CellID->7432307],
Cell[CellGroupData[{
Cell[24170, 902, 315, 9, 70, "Input",
 CellID->158063160],
Cell[24488, 913, 1175, 31, 109, "Output",
 CellID->278541892]
}, Open  ]],
Cell[25678, 947, 151, 4, 70, "ExampleText",
 CellID->82310537],
Cell[CellGroupData[{
Cell[25854, 955, 271, 8, 70, "Input",
 CellID->389643247],
Cell[26128, 965, 907, 24, 92, "Output",
 CellID->8297721]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27084, 995, 224, 7, 70, "ExampleSubsection",
 CellID->10925],
Cell[27311, 1004, 140, 4, 70, "ExampleText",
 CellID->434358650],
Cell[CellGroupData[{
Cell[27476, 1012, 1396, 44, 70, "Input",
 CellID->802782182],
Cell[28875, 1058, 936, 30, 39, "Output",
 CellID->44879387]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29860, 1094, 230, 7, 70, "ExampleSubsection",
 CellID->20380],
Cell[30093, 1103, 290, 10, 70, "ExampleText",
 CellID->20575667],
Cell[30386, 1115, 670, 22, 70, "Input",
 CellID->547230903],
Cell[CellGroupData[{
Cell[31081, 1141, 213, 7, 70, "Input",
 CellID->556906936],
Cell[31297, 1150, 669, 23, 39, "Output",
 CellID->71883101]
}, Open  ]],
Cell[CellGroupData[{
Cell[32003, 1178, 199, 6, 70, "Input",
 CellID->260248053],
Cell[32205, 1186, 1717, 57, 87, "Output",
 CellID->145322197]
}, Open  ]],
Cell[33937, 1246, 275, 10, 70, "ExampleText",
 CellID->62149070],
Cell[CellGroupData[{
Cell[34237, 1260, 295, 9, 70, "Input",
 CellID->687101919],
Cell[34535, 1271, 704, 24, 39, "Output",
 CellID->679088868]
}, Open  ]],
Cell[CellGroupData[{
Cell[35276, 1300, 279, 8, 70, "Input",
 CellID->333728152],
Cell[35558, 1310, 660, 24, 54, "Output",
 CellID->506667388]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36267, 1340, 224, 7, 70, "ExampleSubsection",
 CellID->137],
Cell[36494, 1349, 72, 1, 70, "ExampleText",
 CellID->60688897],
Cell[36569, 1352, 747, 23, 70, "Input",
 CellID->576947958],
Cell[37319, 1377, 321, 10, 70, "Input",
 CellID->159013302],
Cell[37643, 1389, 232, 9, 70, "ExampleText",
 CellID->227418151],
Cell[CellGroupData[{
Cell[37900, 1402, 239, 7, 70, "Input",
 CellID->5502165],
Cell[38142, 1411, 1420, 37, 77, "Output",
 CellID->47983059]
}, Open  ]],
Cell[39577, 1451, 139, 4, 70, "ExampleText",
 CellID->88451196],
Cell[CellGroupData[{
Cell[39741, 1459, 289, 7, 70, "Input",
 CellID->263328039],
Cell[40033, 1468, 530, 18, 39, "Output",
 CellID->89229771]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[40624, 1493, 223, 7, 70, "ExampleSection",
 CellID->25867],
Cell[40850, 1502, 131, 4, 70, "ExampleText",
 CellID->47976508],
Cell[CellGroupData[{
Cell[41006, 1510, 816, 29, 70, "Input",
 CellID->388509017],
Cell[41825, 1541, 1030, 34, 58, "Output",
 CellID->46679626]
}, Open  ]],
Cell[42870, 1578, 251, 9, 70, "ExampleText",
 CellID->166144144],
Cell[CellGroupData[{
Cell[43146, 1591, 249, 8, 70, "Input",
 CellID->462934585],
Cell[43398, 1601, 158, 5, 36, "Output",
 CellID->110444399]
}, Open  ]],
Cell[43571, 1609, 262, 9, 70, "ExampleText",
 CellID->16520646],
Cell[CellGroupData[{
Cell[43858, 1622, 248, 8, 70, "Input",
 CellID->77419897],
Cell[44109, 1632, 287, 10, 36, "Output",
 CellID->445349700]
}, Open  ]],
Cell[44411, 1645, 125, 3, 70, "ExampleDelimiter",
 CellID->206366485],
Cell[44539, 1650, 133, 4, 70, "ExampleText",
 CellID->67137530],
Cell[CellGroupData[{
Cell[44697, 1658, 610, 22, 70, "Input",
 CellID->355983160],
Cell[45310, 1682, 647, 23, 39, "Output",
 CellID->306565839]
}, Open  ]],
Cell[45972, 1708, 305, 12, 70, "ExampleText",
 CellID->36938167],
Cell[CellGroupData[{
Cell[46302, 1724, 347, 12, 70, "Input",
 CellID->501321488],
Cell[46652, 1738, 881, 31, 55, "Output",
 CellID->26417098]
}, Open  ]],
Cell[47548, 1772, 89, 1, 70, "ExampleText",
 CellID->356366293],
Cell[CellGroupData[{
Cell[47662, 1777, 216, 7, 70, "Input",
 CellID->109900082],
Cell[47881, 1786, 161, 5, 36, "Output",
 CellID->104292511]
}, Open  ]],
Cell[48057, 1794, 125, 3, 70, "ExampleDelimiter",
 CellID->405278834],
Cell[48185, 1799, 327, 10, 70, "ExampleText",
 CellID->355186149],
Cell[48515, 1811, 317, 12, 70, "Input",
 CellID->844105529],
Cell[48835, 1825, 120, 3, 70, "ExampleText",
 CellID->302898838],
Cell[CellGroupData[{
Cell[48980, 1832, 315, 11, 70, "Input",
 CellID->4673396],
Cell[49298, 1845, 664, 23, 53, "Output",
 CellID->167082347]
}, Open  ]],
Cell[49977, 1871, 609, 21, 70, "ExampleText",
 CellID->306798126],
Cell[CellGroupData[{
Cell[50611, 1896, 307, 10, 70, "Input",
 CellID->247682360],
Cell[50921, 1908, 311, 10, 50, "Output",
 CellID->665790192]
}, Open  ]],
Cell[51247, 1921, 60, 1, 70, "ExampleText",
 CellID->100376898],
Cell[CellGroupData[{
Cell[51332, 1926, 239, 8, 70, "Input",
 CellID->646711224],
Cell[51574, 1936, 238, 8, 50, "Output",
 CellID->46317167]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51861, 1950, 233, 7, 70, "ExampleSection",
 CellID->28728],
Cell[52097, 1959, 103, 2, 70, "ExampleText",
 CellID->898145633],
Cell[CellGroupData[{
Cell[52225, 1965, 721, 25, 70, "Input",
 CellID->68588467],
Cell[52949, 1992, 423, 15, 39, "Output",
 CellID->23575331]
}, Open  ]],
Cell[53387, 2010, 385, 14, 70, "ExampleText",
 CellID->274493008],
Cell[CellGroupData[{
Cell[53797, 2028, 181, 6, 70, "Input",
 CellID->99962079],
Cell[53981, 2036, 161, 5, 36, "Output",
 CellID->325914595]
}, Open  ]],
Cell[54157, 2044, 125, 3, 70, "ExampleDelimiter",
 CellID->199725312],
Cell[54285, 2049, 149, 4, 70, "ExampleText",
 CellID->6130188],
Cell[54437, 2055, 422, 15, 70, "Input",
 CellID->48081135],
Cell[CellGroupData[{
Cell[54884, 2074, 317, 11, 70, "Input",
 CellID->4932523],
Cell[55204, 2087, 521, 18, 39, "Output",
 CellID->348284566]
}, Open  ]],
Cell[55740, 2108, 228, 9, 70, "ExampleText",
 CellID->588708258],
Cell[CellGroupData[{
Cell[55993, 2121, 255, 8, 70, "Input",
 CellID->64127991],
Cell[56251, 2131, 345, 12, 39, "Output",
 CellID->173755209]
}, Open  ]],
Cell[56611, 2146, 125, 3, 70, "ExampleDelimiter",
 CellID->130383643],
Cell[56739, 2151, 389, 13, 70, "ExampleText",
 CellID->82401091],
Cell[CellGroupData[{
Cell[57153, 2168, 353, 12, 70, "Input",
 CellID->114483272],
Cell[57509, 2182, 536, 20, 54, "Output",
 CellID->278372137]
}, Open  ]],
Cell[CellGroupData[{
Cell[58082, 2207, 336, 11, 70, "Input",
 CellID->158558769],
Cell[58421, 2220, 508, 19, 54, "Output",
 CellID->404412977]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58990, 2246, 311, 9, 70, "SeeAlsoSection",
 CellID->13265],
Cell[59304, 2257, 1268, 44, 70, "SeeAlso",
 CellID->27236]
}, Open  ]],
Cell[CellGroupData[{
Cell[60609, 2306, 314, 9, 70, "TutorialsSection",
 CellID->28501],
Cell[60926, 2317, 180, 4, 70, "Tutorials",
 CellID->24171]
}, Open  ]],
Cell[CellGroupData[{
Cell[61143, 2326, 319, 9, 70, "MoreAboutSection",
 CellID->384137252],
Cell[61465, 2337, 147, 3, 70, "MoreAbout",
 CellID->229071737],
Cell[61615, 2342, 149, 3, 70, "MoreAbout",
 CellID->554629136]
}, Open  ]],
Cell[CellGroupData[{
Cell[61801, 2350, 305, 8, 70, "RelatedLinksSection"],
Cell[62109, 2360, 394, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[62518, 2376, 27, 0, 70, "History"],
Cell[62548, 2378, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

