(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    751414,      13750]
NotebookOptionsPosition[    739880,      13363]
NotebookOutlinePosition[    741717,      13408]
CellTagsIndexPosition[    741629,      13403]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetterBar" :> Documentation`HelpLookup["paclet:ref/SetterBar"],
           "RadioButtonBar" :> 
          Documentation`HelpLookup["paclet:ref/RadioButtonBar"], "PopupView" :> 
          Documentation`HelpLookup["paclet:ref/PopupView"], "ActionMenu" :> 
          Documentation`HelpLookup["paclet:ref/ActionMenu"], "ChoiceDialog" :> 
          Documentation`HelpLookup["paclet:ref/ChoiceDialog"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"], "InputField" :> 
          Documentation`HelpLookup["paclet:ref/InputField"], "Setter" :> 
          Documentation`HelpLookup["paclet:ref/Setter"], "Toggler" :> 
          Documentation`HelpLookup["paclet:ref/Toggler"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SetterBar\"\>", 2->"\<\"RadioButtonBar\"\>", 
       3->"\<\"PopupView\"\>", 4->"\<\"ActionMenu\"\>", 
       5->"\<\"ChoiceDialog\"\>", 6->"\<\"Manipulate\"\>", 
       7->"\<\"InputField\"\>", 8->"\<\"Setter\"\>", 
       9->"\<\"Toggler\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], "Generalized Input" :> 
          Documentation`HelpLookup["paclet:guide/GeneralizedInput"], 
          "Interactive Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/InteractiveManipulation"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Toolbars" :> Documentation`HelpLookup["paclet:guide/Toolbars"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Creating Inspectors\"\>", 
       3->"\<\"Dynamic Interactivity Language\"\>", 
       4->"\<\"Generalized Input\"\>", 5->"\<\"Interactive Manipulation\"\>", 
       6->"\<\"Palettes\"\>", 7->"\<\"Toolbars\"\>", 
       8->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PopupMenu", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PopupMenu",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PopupMenu"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a popup menu with setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and possible values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PopupMenu",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PopupMenu"], "[", 
       RowBox[{
        RowBox[{
         ButtonBox["Dynamic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Dynamic"], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being reset every time an item is selected from the menu. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PopupMenu",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PopupMenu"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["2", "TR"]], "->", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a popup menu in which possible value ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is indicated by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PopupMenu",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PopupMenu"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["dlbl", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays the menu item as ",
     Cell[BoxData[
      StyleBox["dlbl", "TI"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is none of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PopupMenu",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PopupMenu"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
        StyleBox["dlbl", "TI"], ",", 
        StyleBox["base", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays as ",
     Cell[BoxData[
      StyleBox["base", "TI"]], "InlineFormula"],
     " when it is not being clicked. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->4788]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " displays with the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as successive entries in the menu. "
}], "Notes",
 CellID->21563],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be strings, boxes, graphics or any other expressions, including \
dynamic expressions. "
}], "Notes",
 CellID->8400],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Delimiter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Delimiter"]], "InlineFormula"],
 " can appear as an element of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ", specifying a horizontal delimiter in the displayed popup menu."
}], "Notes",
 CellID->25541],

Cell["The following options can be given: ", "Notes",
 CellID->19514],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the menu ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the menu", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the menu is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FieldSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FieldSize"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.", ",", "50."}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.", ",", "10."}], "}"}]}], "}"}], Cell[
    "the size of the field for menu items ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameMargins"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "margins to leave inside the menu frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the displayed menu ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "the overall image size of the displayed menu ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->15505],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<Clicked\>\"", "->", 
      SubscriptBox[
       StyleBox["app", "TI"], 
       StyleBox["1", "TR"]]}], ",", " ", 
     RowBox[{"\"\<Unclicked\>\"", "->", 
      SubscriptBox[
       StyleBox["app", "TI"], 
       StyleBox["2", "TR"]]}]}], "}"}]}]], "InlineFormula"],
 " allows different appearances to be specified for the clicked and unclicked \
states of the popup menu."
}], "Notes",
 CellID->130107231],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<PopupMenu\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->179924755],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->547307350],

Cell["Select values from a popup menu:", "ExampleText",
 CellID->451052950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupMenu", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->948643051],

Cell[BoxData[
 PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
  "b", $CellContext`c->"c", $CellContext`d->"d"}]], "Output",
 ImageSize->{42, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153595478]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37081219],

Cell[TextData[{
 "Connect ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 " to a dynamic state:"
}], "ExampleText",
 CellID->538658885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110288598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Dynamic[$CellContext`x], {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{75, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31429843]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->532096031],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PopupMenu Content",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->516615797],

Cell[TextData[{
 "Use graphics as content in ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->148639444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupMenu", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"n", " ", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78661846],

Cell[BoxData[
 PopupMenuBox[Dynamic[$CellContext`x], {Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.9999993680039507, 0.9999995755730018}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.9999993680039507, 0.9999995755730018}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwVmnc8Vf8fx+2yN+EaF6kkyjdK6/NOGkbDTGZ2IaMyihaVHamEQkoRUUoL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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.999999941761652, 0.9999995837354044}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmnc8Vf8fx+2yN+EaF6kkyjdK6/NOGkbDTGZ2IaMyihaVHamEQkoRUUoL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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.999999941761652, 0.9999995837354044}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwU23k8VG8XAHB7shuyMyaFStqkUnoOlSIqQiUplBZLtIekUrKUJVsIKb/I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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.9999996187787015, 0.9999994313041395}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23k8VG8XAHB7shuyMyaFStqkUnoOlSIqQiUplBZLtIekUrKUJVsIKb/I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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.9999996187787015, 0.9999994313041395}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwU23c8ld8fAHB7K5fL5RppShkRTTmflFQkDVoqpLKS0VBpoUGRSArZCl9J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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.9999992328657719, 0.9999997588489247}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23c8ld8fAHB7K5fL5RppShkRTTmflFQkDVoqpLKS0VBpoUGRSArZCl9J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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.9999992328657719, 0.9999997588489247}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwUmnk8lM8fwN33sdaxLAldEkmH+CqfqQilkrNDKiJHhEqSdFBEziRRpFSS
UpJQGUQ5csst9727j/s+fs/vr319XjM7n5nZzzPzfj+vVbS9aGrPwcbGxs7D
xvb/z2d+tjwa50J0/4UsvUyQ/6RbVKdgbKXgBJ4frN3lHMNh5Veev4LCNega
fTXZ55AIz/JDV3Mr3Af/d879C7bpcGH3FdeZ1U8gQfvwkUozDHULjtGjq9/C
i4rehJu0KvD6Lb+F+JQKy4Yc1st+1UB/WF/O3JcG9243p+t61ICtCuIcOZ8O
y5qqjsGmdeCdJpgz3pgBUUJC4zk8jcDb2r2BuToHBu/0rpHZ+A+a8n9cYQzm
QMqfHe9/c3dA6uvYnyOfcqFWxWN1bGcHHPY8fHp433f4olIhuaOkE2L4c2MG
zmPY8CQ1P9OlGzKvHvC8JJ0PeS7qMf9quuHp8E6ZCd98MEg3s+vX7AG3aur5
cf0CMPpy6sXVpR6gPi3hGGsshJMg0TF/vQ8WRLLeuu/6Cc4qJ9e5NfVB7+2X
JqPPf4IL3bswYls/ZJ33SyCciuDk36Y1lX39cGLb9v9YC8Xw2HoX/yPtQdj3
WrHL9cwvkPvnxcYKHgRVGdEgZtEvSJjV/PGnZRCWl4f+MkJ/wwHhGls+ryFI
Kkv0GFldCoVS231mngzDZOwXlY4HpbBWuDcsu3cY9p8v76mdK4WgqtOBUWoj
wOCcscitKwO04p7imzMCUCsk+gGVg/po5fCdxRGIeq5UkvS+HOLZd+uH7WaA
1u7D/90P/AMDi4tLSTkMCBE8N+E7+QdmDSaikyYZ8K/5Wpr72Qpwutr1JVqN
CQFer+SP6VSClSTHM/0nTGjU+9Z4MKUSYuZeFi2UM0FFvCYCJKvgbvpr7ZhF
JlSnL3JsIKqAV2nA3dmKBVTgtxHeXA0XC5eLn91mgc766P8Cz1WDrG1iWMpb
FpwTXk1jj6+G9lcBU4FVLAibfDvhU1MN4vFfjLUnWJDdur16kpesG/RFOFeC
gK5CnOamWwOm+z42824nYHvkX3vbdzWgaxz3j/0CATbeZ/a2ddWAmcMbxdQA
AgJPj8hbSteCfuG2AFo8AR/3ey1UHa6F3Cled8N0AlrU2JuM7tYCxd71qk4B
AZySDzJ/fqsF2zWGFkQ1AaqLUpG7x2tBZkKNafuPAMueJNevynXgYe9z8NEQ
ATfLVA9onK6Di7Qzr+6OE5Dy6ev6d4/qQF1w5ti2OQJqY/dyrvtTB65yhsxn
SwQs3KzoSOCoB/9wC2rxCgFrzx/7Lq1dD3tzFZJSyPjw4Z7YqItk/Cst3pDs
f3WH2xWh1/Xg9GBZ9dUsAc/l5o7ea6uHgvsyb/PGCCjjDNjMJv4XMHPuwaNB
AiaHRQR9jP7CtcIQP5V2AlbVPhmYuPkXTqknGvtVEbA/Z22Ra9Zf2NPYzIrE
BLg/T38+wPgL3aav7jq8JyAu8L8bZ9c0wEwJ/cRSLAE/3YqPtx5vgLOvRtqt
7hDAsDDRtIhoAKqHwburTgRI7W6lVv1qAL8/eQE2hwlAax0Iw6UGyA9bYyGi
QYCT4Fh54bZGuC/ooH5fjIDvzTx3s543gnPunMRQOQv68yPPbmlshMRyO+G6
VywQTZHTTRVughbZgKHIGyyw9do688ynCUYmXJuerGfBg1M/6mifmuBD8iXq
0AwTvugZfowcaIKvnlp+Mr+ZwCdu43TXvBkatO91bTrNhA/p91svbG4Buy2H
Om55MWCYOvzgwNkWyDx51s5fhwEbvA7oKke3wHS4s1jJ8gg83yWY1DPXAqmc
DRwbbpHPT+kDhxPFrUDbQi1NdRuGSlUmTWu2FdTtHR3V1g+DYMShUslNbbDq
Bosm3jYEAZYiqjURbTDJFcxP3zcEXj3hYwbW7cBaPm71dHkAMvaPvlgX3g7p
jzl6v78dAOKtiTlnYTsUiOz9ed5sABzdxb7mbfgHNzPC2z1ekOfJUpTvjol/
8Cd575px9T5IFCz3F9PvhBtTuyp/CHeD7u7r1rdsOqHx5c0ajeQuaHPbtIO4
2gmnm8p0w7W7QLo2pP9PaidcDuLMVjjbCZGxxkZBlC7YduRJbqZhO/ivqxRZ
ae2CZ6conFc5GuA81DxhePZAof+TU4m6ucD2Yjq3NaQHbHtrpX6dyoJYLrm2
suQeOHThhMWT6xlQUuog/7ahBxaVWy/ZOr4CZfPFF/b/9QKtpdsx7PZDPOi4
Ie0fex+4a4m/uDJdgG+VG1dU0PvgtaxP5puen1h6syfr+7Y+EJ0ket9VFWPD
ie9b4u37YJAlzJX1shS/vWH6xaq0D2IuudaYPq3GzlE38qoj+mHjZs1ar+VG
zDH1ogO/7YeJMW7R/t4mHGdVwpZe2A8PpOY9W0ubcZmc+L7QyX4wDG30UQpv
xZvepPw2OjYA6euOmb/j7sCMb3XVhasHwe7nlrzX5d04QH5u7JPWIKRLG+kt
qfdgudvy4klHB6Fk28XwLQ97sPF+J4ub/oOw80j5iqRlL35fvdysMzAIb7hz
OXZV9GG3vo09mR+GIOw7rtjiO4g7bZr5CkqHgKosaX2+dhCbNQVtrugdgnS+
87Hd64ewVvnAtT76MHDdmn0dXjaEOT+9okgFDoPUlfHO9YvD2EvFQlPpxTA8
Mz1S2btvBA++5LLe/GMY1vGd/vXt/giujLF7s39iGPqu3b+eJMrAsb6KuldP
j8DGdZ6UP5xMLDBdbefvMwLxMHejRoeJb1y8dT/80QjIKklU/vFgYlvbjvo3
5SPAlayrEtPIxPWtYfOf+0fA0Oyc3CleFjaw0FXIZ2eARV7JD8EdLKxq+Myl
aScD/Pc4XBYPZuGEAuPIXlMGbMLzcQ6fWFhMZzFr1JUB37NYDx81sHBA5ru2
xSAGNP9U/v1sjoWn1U5y8CczIMlisdCXTmCnNwLKkpgB6hYWu7ZoE7hNIfeQ
YgsD+uldIlkWBD4c53RJbYoBd9K37xZyJ3CBuMwTbQoTjluOjm4JIvD20JI8
/U1M2GnT6aOUQODXPN69R/czIUtT1qzjE4Flbm0QsDnLhKLfcjIOPwn8YK5B
3dmXCa/4Ox5+qSXwsuc9C6/HTAhqJT796SCwB2PH9TsZTDhEC7ifOkzgXvu+
52EVTJDoCjx2eILAlh3Rv+IGmXBDIy3g6xyBS47pMV5zsiD+iUd83xKBdWon
xD7Ls6AXtpg2rRD4w8GXO7E2ea9JrroXTsYKxaanys1ZMLXPeJcg2T9Kl8O/
8SILBmo+Jh2cJTB39qeUnmAWtNySETw6RmBvjbOVBHku7u5WmZIdJPBwKmVy
IZ8FJ15Zcr1vI7D12nwZvjYWHJOv5uKuInDVs4sgMcMCLV6/4bWYwHtpq+0V
qARkXR+qFn5P4MyIymBVNQJOaqgs5McSeIOA30ctQwLYmVV1cIfAcf5qDXp2
BFzfWcoIcSLwTa8HiqeeEPD5UuJIlAaBxwkdA6dMAsx2bcw5SiXwOaeRC1fI
e8XCnx7TN8rC6zava/vFMQp/7l+ZffSGhf8NL7KMKaPQPbcj/utNFo59U89e
t2oUckfTA7MtWFhAMWBDh9YoqAg3yZ5bYOKSXZHqfvqj8OXPtyWbSia+dyxh
5yrTUbCaS9MMTmRijohsg5Mu5PhZWZtu7GLi+WXG+cZno/Bom1bqprMMnE2f
v+iVOgpxT19wr6xjYC9NXm/Jr6MQLJFwW25oBI+7KgaZVY/C0iWFQj3nETzS
ZpFSxTEGNIEHrtnHhnHqrO1HN9ExEJJ9IXOAMowdJdyzheXGIGbqgfn+X0O4
92BwycEdY/B29acHEWpDuC03b/D3+TF4aXC5hxgawH9iN2zM/zMGeRO8nPry
fTg4c7vG6eYx0G+VDKzM68WG1Xu0l/vGYPr9irmkTS8u4rU22rUyBu/Z5c+N
x/bg714RTtka4zDtbHD/IVs3fm8+9/ZjzDiI2j6IHdFux2GUcpWkMxNgWFBS
3N/3B+fsXPXlsNsEuGjyZwxUleFem4uweH0C7kdnFi9/LcE678XNrR5PwPq7
vX58/kV40Mj6hnDlBMx6KrTcEsvG+/yZVdd0JkFro+FJRbVkmJ0SvWIqNQUr
a1OaXU3qYM0q25WVNVNgyp7OG2ReD4f1Mu+/15gCK8NNpZut/sKrqGMJfIem
wFc0xLjJqhFM1ZN+5/lPgfyXEwnP9FrhveNW+qaxKYicM3LUsumCpvCA5Kbl
KTgTY/L4WnUXcH1t2HxPaBrW3nUzubKnG05wX9/XtWEa1EZXafmu7gG+Fz8v
PLaZhjU88hKMsl6wbTXHnH+mIUbX1r28aQAE4rtcPZqn4X7ZyC9/jUHIOOEm
19E/DfXTklJRQYPA2RJ4LZd9BnCuYEmsxhAkN+Vu89g5A7er9u74QN7nxrEG
3f/0ZiC0eAVdySF526o+wth0Btb+C/lszzEC+o1M5gbXGSCa1rd9CBuB/r8K
Kf9ezIC++9uOUxEMCHv03tL44wzQfB/2DZczQNPiP+7cHzMwoGT015ebCYH1
ZraPmmYgxEA1L9GTCVuiOymc/TMgcPf+jo2vmdBk5ordJ2YgQSTmYUojE5Tr
7skZi8zCWIPL/evbWVAdJV6eIztLnibJeSWnWeBt+vzaho2zIMHRKrkSxAIF
qpryI81Z2ENY5ch+ZEFpTU4Dh94szH04PSv7lwWekfvvuh+dhfU/bQ2WyHOB
frRu2z+bWRh0UUE/pAlwrmZE5FybhROreo5WmxFAjbgGGwJnITYj8sRqNwJy
j/CwoqNn4bf/b4bePQJsRR8+5XgxC9L+R07DUwIEq1YfdE+fhfGZNerCHwnI
DEuba/8+CzT5+ytpJE9bH9ZOOVg2Cy+V1sWtqiGAS+SXZU4j2X5DkjhF8nRa
hSn3hr5Z4H3JLulK8rR5aMfn6PFZ2Cy5yegAydOLxhdsOdjm4GuRDzFJ8m+y
0BzFXXgOeqtCoi6QfHzoz13cTp8DvUefez6S/DwdQnU7qDwHs3K83wrIOOFg
olzOjjlIbDxFSyT77xdULV+/bw5+ZByVNyL5nFWWfS3aZA6e3Nkll0/miwnW
V+awmYP8gq0BXMME6B6obbjoMgcPXi8QUh0E9POfvtvuPQc7w3kUZsn1hJeO
bDt4bw52FJ9aSCkkQOu+d3f2wzkojo0JV/lEQKchd+T6pDko/JtH8XtGQBBf
FER/mAPOhwbNyYEEbCmRZ7F/n4M/p5hOzy8S0BT47unF0jloKXzm5GlBwC0D
rYPtDXPA0DzxSk6bAGXe4rkDvXNQfkaakkQnoPrX0ZTsMXK9vxIL2efJ+rj3
z3L9yhyc6Dm3gBrJ+tjvwh0tNA93E8/Kn81ggUdxgO3FDfOw681d18O2LJDv
3c8zvW0eKjnlPkv/x4JyDv5UXzRPenVQgziFBetQ6Nj94/MQfySj63UWE2pt
jjyiOMyDblXcGr1AJty8Iab92HMehm+dmpGzZEJz7qNbySHz0F9etS2UxYB7
zVZrN8XOQ6TtniqVbAZsm5Up+ZQ8D7VqGWcptxgQuiNBFP+YB7lAxcl8AQbs
+fg6oZmYh2CrRU05oRFgVTruPbM4D9V7lbVOlQxDPFOlv59vASgfp9o4/Ydh
SiVdbVJxATjGVn5GTQzB21dfv4uYLwDt+xdVjcJBEIsvadmXvQCubDffhcr0
Q15OsF9Z0QIscjD3HM7rA5cmY6WjNQvwzZeeUXC2D4ola5xshhcg5Z7Tycbk
XrgW0TzrLbcIHHwDqafkeqDr7rDUh1uL4P7my1bFtA745C5kJm20BM/lffYb
7K2BP3Hi195bLoFZ8lND6V3V0F9ET9x7bgk6979/dt+pEugyG0cu3FyCf+Xb
NKf0yyCgQN+/4MsSiE5EipcOFYAl9eZnZ6Vl6HJrUrGrvAnzn8fEfywsw14d
zt5c42os8W9W25R/BbLqi340mNbgzXxsZwakVsCNp/RGrlUttrMWSRPbugLc
DmpWEafq8R+uTXoOjitgIvvk5DWrJpxgce6y6N8VsOP0bPsx2YGzb7rEJXev
wGq9qHO+Fztx3VvPfO3RFYi7tqHAo6cTc91EPBncbOhhG3/Cz99dWKvusGmb
AhuKUQr5s/Z2D0667jK8xYoNcRzyE9/6sR9vyeefDTzFhoLtHj4e5hvA+Vwp
3B12bOg8fbWb9pkB3BnaqxDqzoZcVTJ/BAgMYvnnp6yG7rOh3mLZh3sODeEP
vQvnUAQbinw+/UM2bgjv3hjn+TiGDVHQdYZd3xC2zmgI1X/JhhYkLaY2XR3G
cUVHipK+syH+4dnE1YEjWIWfVTNbyIb810yuZ/0awTmHHnQcKWVDhuZ5wXzc
DNzUUDK/9JcNheeb/hbzZWBH2fN8Fm1sqERKymwuk4FnTnNLpXWzoTkdYSV5
BgNLDe3ROEGwIY0Hq+SpFkz8Wq1T99MUGxJcc6S15R4T7/D0M+ZbZEOVngcW
67KY2Hwh93wWHztaeL634KAYC/fC8SvCouzoTt/vpiIdFr4UMHPnnCQ7ulXp
p2N3joWjhLcnUJXYEdX/Mx/PRxZWMq1956TMjvS04qu461j4U4x7Tv5mdlSj
UxOnOMnCqFXkN20H2a7ia2slTuDq1e/r3XTYUUZG5K5XWwh85tzB7uI97Ijr
1aQ1vzGBiZQhQs6QHTmoREresSewHzNw6dJhdkRff7VB+AaBRbauFyw3Z0ds
P8bV3kUROMGrSFrpJDuy53hZcuw1gdW+2a6/dpYdfS8J85DMJvD3Fbbt1efZ
0Vz0TmrnbwIb6yXu2eDGjrZ/Ts34+pfk96DdR/wus6Nal4hr8V0Edqlotf7r
Q+Y7pp0WPELgeTEfZ9Xb7Oj837cfAkieDraU9vYPZEfmMS8575M8TY/PutsS
yo5Ujr43fkzy8dsO84ca0ezoYIj0gXSSn7XWTjwPimNHYre5W6vJuMQx8kPH
c3Y0u9F+aYHsf+y9+nfNN+xo9NhcxZZ5Ag+MVZSGvmdHbbOmQRcnCZIHLzT2
fmZH++0r72UzCMxzXaBPJ5cdxXaE7hXqIXAMThmPyifzK3qauTQSeB2XAdvw
L3YUJSDm3lBK8rNhn/CeCnaU757qejiXwHqh/rKxdewI88mi+hQC19cobiSa
2dEPz4o5x0cEtpPK19zfyY4s7d+WC98i8J3ExaOTDHb0Qs5XPPQIgU22ZHts
mmBHsq1JfTPbCSxfcCnSdo6sF4V/1SHSBM7tHq6u5uZAbRdLC3a0sHDQpdej
vEIc6Otx+uUj2SxsyWVLASoHCpIOi30SzcLj65qPvJfnQJrfbub9NmDh/Kzo
i71rOVBth6rBR3kWDjMwCZfdxIG0eWkmtRNMrOL0u/L+Tg4UnZgmXRFL+mDa
l0MOJhxIwnZL2XAFA2/Z7eH6zJIDVY3qtY/EMPByhWpovTUHalH6L2i3DQPH
ES//7HXiQBtct8p1Dozg2q1RB1ff4UBeD3+P3x0Yxs9/HnKxDOJAyowPv91e
DmM3c/6Q0DAOVOP56FXxqWEs4HWrbCGOAy3LX2arrBjCe3LcjJo+c6D4awe6
C+IHscgBFSfRXA70SVqL9+HBQdzW0he0P58DbQ+pipiaG8Dei9YlmX84kIHR
jXV3TAfwRzhoENnHgdCqozv1J/qwwq8N+gdonMiK/pohPtuNWZY9526v4kQL
MidVnB524+8DCQHZazjRL3SN/lqtGx/jlypav4UTrZMzVyBsunCEMdc+TiNO
tC9QXrvOuQOz1XWi7z6cyKn930n5i004YCgvyec2J3pJ722audyI+dmecWgH
caKC3UavtlxrwFS140VfHnEi74wjKjw36vG6wBqD9I+ciE2t98WWy9X4gE7h
4Rf9nOhvfcmumDP5+OHLl9ZBplzo+toNcUd1C0A69/aP/ce5UMDNQzH65j/h
afVpee4zXOhgqeCObsdieL0k23nblQtxrhxOvB1aCtlW0XbXg7hQg6B9ukpn
NbQJ3nV2y+NCJ+x4WBYNTXBGya5ctZgL6Z/BZ8Qqm6FPa4/qSDkXqt3dcYGj
qAVY9kvM881c6JHEi817UtuAPf+Kx9lJLkSf2kOoqXfC+ssO3uYq3GgX5cZ6
l3c9oPZfh1niFm70UqT2oJRIL2xnO6Y+rMmN7Pkn94Vc7IW9D4z6b+7jRlzd
QVu/be4Dm2RV83fW3GjLXa2JqGf9YO/8Sn3alhuhJktpxlQ/XNgiL7jHiRt5
n+1f3W08AD7fRQsbrnCjeT69wfDpAYipH1fnCOdGQzZT6ee0huBZnIvgoUfc
iBns8lrqLsn3Z3r7H8dzI8duq+Hd1UOQwfj7TC2FnM9vU6OWs8NQyZUjeLyA
G8XqvkU1HiPwt0xj4OVvbuSS6dzy+dMItEWkFrIquNFbmx6FYWIEhuWeXgto
4UZrr5kX7z3PAO4dNwfSJ7iRHWf2mz17mCC0MFM4P8eNPHf2bba5xARqgXuC
PhsPUqldo/X5JRMUDtlatArxoGfil3UXlpmwQbx1y3pxHlTl+ePr4EYWbG42
E/KQ4UGFk23vOM1YsMte/yfPeh4UEjmrkZ3Ign2b8hKOqvKg9VVPFQ/9ZMGB
MU2fp1t5kLFiugFPHwuOfk23GNDiQQndT+O6uAg4dkNZYyvwoNnYT2rtSgSc
3pckdEOfzJezXWNGlwAHfvrg74M8SOfD3XG14wS4VkX9pJryIHZJzbabHgRc
fiSYeOoYD1Lco+Q1QvLp9ZMBPik2PAgmAu0vkrx/R3HJYuIcD/phLOsqkE7A
/YErGrouPGjDgozrN0xAxHuW0H0PHvQ5ztrudiUBjy+dH6y7Ss7nsIPLyVaS
x7U7f8r78aDfEZ55hv0EvFo5lugUwINsttz+bEiQPlBc45MZzIN2hpzBJ6YJ
+BxywHIlggc1TH657LdA+sjRnxoHHvMgaVOugM/LBBTQdgk/esaDnvR//DZH
8n5Je+Zgx0se1G3Gw3eUjKteqhWppJLzL9txKWeRgAan14lXPpLfd7Fct430
iXb11dfzs3jQSJvtuf+/T++demwp+IMHjVF2RJ8kfeTFnm2X2n/yIFulPeI0
0ldOh1aGp5fxoD+zj6+EVxMg1+yUdruGB+mKSn8qziegZS13qVkTD3pvltqb
+4GAWPfnfes6yP0sVTvmHkeA5Xcdjtk+HuS954zvgD8BEnyN8mUMHnRpS9Gw
ogsBNWaeOk8neFDvE397RRMCwhKFj7nN8yCxVSaNA1sJMB5JuYzYedGr1cjs
qji53jsd73tFeNGcwIzffAUL7lX6lGVJ8qLdQrdXTbwh64cuNRAkx4uu0E++
zLvJgrxPxgpqKrzoSWjDdLMyC3yXBnatbOFFl34HEerzTNA28j9es5MXPXi+
a519KRMyO3OirujzIhmzEsPrZ5ngqWqRbmDMi9x6l2LsVJig7j1aLmPGixy9
nbu1xxiQKrqBO+8ML7qo61ST780Ax5OFihHneVEX134OH20GrHtzStfWjRdJ
hJkd2Do7As91o6/y+PIinoYDFRkXR+CxK/vw4ce8aH3YqKqfwTCY5zzlUUzg
RXu4uJJzZoeAyq21ZiKZF/G1Ga5ZlTIEYU/drB9n8KJoIUW4xD4EAeWtlR0V
vCjYUnQbV+IAuG/M+uzOxYdOvn/VeTakFzZfOVq9V5APbdxwtU5MqRdG8hkM
CSof2rEgNmj2tQccjq1Zn7OaD1VaKHaktXfDqcCIWHYdPtRUn3r0Ab0LDvQ5
34jy4EOKsVc7dLNbYP+NNWl63nxo7VG7lamfzbBXsq1l2o8P9bq1tQ9VNMF/
+oe0Tj7gQ3++gFF5WwOovFKfWPOGD82O+e4yG6wFQftJxy9tfEjm/c/FqyHF
8Kf3hnmTAT+K+2R7/FbSV1ziq+kffJgfeadIXLlY/g0XSRCfdlmQ7eN6xVcn
MP6ud0Y0yZYfhSk23TgmX4TTkveWOd3gRwXhwM60+INDz/GihQx+JDLOFh6n
3oCDF7Hb+xx+9Cf2J4+YSiO+F+397HQ+PxLOCSwfU2rCfkVD8z8r+Mk77sXu
D6It2G3tny8PBvnRGVlFu9117fhwb8QmeXkB9NxWUXGXTzf+s6m33nqtABrp
wFWvO7rxwUs7/eJVBJBV1vjS2L4ebMjxr1p6pwAK8/ESpPL34r0Km7zETQTQ
coqoRkNAH84/77fa1FIAmZ6fS0vq7MOQXlMSYS2ATr1+1r9apx/v0vWWFXES
QDQd01WrGf14h3VxPt8dAVThJ9ISs3sQZ76UdjYIEkBn9VIX7cMG8dYRF/F7
YQJoZfibCG4fxJt9qA6c8QKog39u++LVIawce1pw+bMAojqfGVsTN4xfd2Rk
7soVQOueKZz6+W8Yr9vAY3M9XwDlZrR5lyqOYKWstI+zfwTQA6PF3rkXI1iu
fs5iok8A4bFfy7cjSf6RPbSiwRBAf//u+cgoYWAZu+cp7uMC6ASTPvB8mfSH
8f0LzGUBpMY2oNl8jomjteOSVbkFkULp9/+sHjGx+G3mIRdBQbSPTzyOWsTE
FEr080GaIDoyVeSgKUfymtWA0QZ5QdTe6ffoiT4LCyf+N2G/VhBNJhW/UHdl
YYHNXfo9WwSR/Lgf30gWyYdXthOKOwURVaJ0SbCZhXl+BMae2S2IjvFECVrN
sTCn8eaRdiNBdPMCV7sdyZt3Ht6OljMRRBGlm1YpkTzK1lq/+6SlILpzhPMi
pyPpC0rKA0+syfwmIVY8Nwm86HQ9oslWEDXl63hvjCawz6dKbZqTIJoRkQl3
eUPguVnFHouLgqjvyG+vctIXvNGVB9FXBNHyp/j1hiUEng4s2VF3XRCp7k7L
6CR94XKVbIfYHUHk1dZ+MJr0hQmpi0EmQYJo+OMo2JK+4GlTqBEeJoiK0oLn
jEhfGH0l2VoRLYheeCG2g6QvuDEdA4TiBVHJw6ez50j+Z27/rnYwSRBZNq9N
fkz6wQVf0cb7bwQR21qbrm4yHv5pe6vkvSAStax8t3+ZwKsjm5zDMgWRZl3h
qzOkL5jbHLYw/yaI3vhXPN5N+sL9TUVALxRERqP9RDs5n7xZbZXOEkG0YiOn
t/f/8y1Ol3hdJYh+Hr1r6lJPYOWH61ZcGgSRqZYm+4liAp86Ez+k0S6IdC22
2IhmEjhKTax+pkcQPWo8nPjgOYF/z9/L+zEsSPqZhlJdMLm/vxdT/McE0dvr
Shd6PQms8cjzodGsILL3Xd5YeIzADraDN0RXBNHTk+Jb3HYROF7dxvEvtxB6
tMzmM7yK9MHFOtN4ISF0xfuRivYSC+s8xhs20IWQR/6QsNUXFnY/t4PKVBBC
r679MtwUxsKvNd4tZmwQQj5fNs63kj5K+RNTo7tDCHXOJV/9J8jC+k+EvnPt
EkLpTx38NNuY2MfhzuuyvUJonVWU+9VUJu5lc7tuaSKEznBKqRQiJpap7LGX
sxJCj7tSrer4mPhw/HGT7lNCKE06cVdbJQNn79Bf5+YihJxtE0L6zBn4gbNc
1d17QugqLfa9idEILtgZlXMwVAidfOHJ9YR9BE9z8SWLRQshY+lF56Wvw/hM
4oT3syQhxMP7ca366mG8vb5M6ct3IfSk9UZOZeMgbt99zat3XAjVnjC/rjLT
h6mCxJnUOSHkwKeW2PuwDxs2nTvoziaMGPP3ZeTU+3CGp4nCorAwanW0PLf6
bC++92ZDmfhGYXTvfrLBvsxuvFmsYdW+08LoxWA/3xmdf7g/tP/OI3thJN5V
fTj6ZDt+JjAzMOAijHiTHPSWr7VhIS7pjAfewqj63e0zqZ9a8PD08f0NkcKo
+Go434hwI37V1u7mVCSMTN7KbdMQrsJyKX04fKMIqu/Qa1azPA31a6fXdquL
oPb+Vq11PyMhJIkneLumCLobFLR26PdzmI/bYN68VwT5DW73DzD8CE2hToNK
1iJI7p2I4gB7Pjy8xKRkhYmgwaByj+/3qkAAps62TYggJc5zC2Ge/8B7jzJf
1rwIqkDOdt62HdC/7+SHcHZR1LywtFdMuRMKDQvm94qKoqmY0fv/UbvAxzT0
4VsVUZSVa/LreWM3DJrna/triKITgkenPuj3gKXVRIe1ligKdT3VczKjB7Za
H1el7BdFRgF+056B5P1qv67Y66womt9kGl24uh9OOB5zMXEURWfz096O3+6H
EucQMZWLosijQ2fLve5+SL44dqrdVxQ5s6/j+Z4wANbXfkzvixVFmUJHs1I4
hqDs+ujTVYmiKJy9zlnbagi0/Nbsm3klip6mX3wx93YIJPzvh6d+FkXmUl78
Y0bD8OeBhbJYlSha36enIX9pBP4LD6oc/iuKTAJZUQ+yRyAl8tvlojZR9DZu
smF5YQQCYhQLrg6T85HNbW71ZcB4rPn5o2OiaE2hp83uXAaciQ8U3jQrimJd
1phGTDFAvnpaleCgoFLl9g9z9kywOEphs+ahoNBcV0G+eCY8qN1YV8JPQbS6
2LyZCibM11tfe0GhoKdTejkX1FigYellLCpBQc4XxDeNHGeBY2P4al8aBRHB
0Ya7A1jQ0FxYbCFPQYaqdeEmtSwQPtkWW6hIQZsqryoJTbNAr23KRX0dBUVW
cG6LoJG8fkoUnipTULaC4skWTQIy/ilT+VUpSHnR4NSgGQFDp/f2XVGnII+e
gbXZbgQodJ3M7t5KQT/KQn8ZkLxvZXsl5IgmBVEMeG89ekbyZ0+YzXdtCtpW
dic78RMBxedSNDbupiDdwTQ2+58ELPYVcMUgcj3JZdTeWgK2nW9t5NCjoFtF
1bWynQQ4D06mXjSgILt13ocFRwhIchLxaztAQSOSR358miCgaXjDUaPDFDSa
/vuWyDwBlAt71mYdpaDyrfvWKpJ8b8A8MaNkQUED1vRTQ/9/ny/hX3fzGAXd
DlZOcSPjSZ136W0nKWgtMovLI/n+gF1diPZpCmLbQ7NrniHgefDC+RhbCjrw
a/wYHiVg+tMavQl7CpIOPD3nPkDAoeaDCiZOFOQgWjbIIv0kme3yYtoFClpy
uDeuTfrL/IanTfzuFCTKX8hnlkeAyZGiTIdLFKSudklPJ42A116MiJ9eFHTc
Tr9v4jG5H88kXBV8KKjJ3/+o320CzIp3Gd24QUG/Jpcl2xwJSGWcW9dyi4LW
GUz2iRwmgE0ilH1nAAXlqTLjpDVI/7FtzxkNpqBVduVN2aMs4AjmjjkURtaH
G7XOjOT7Y5/UPFMjKegER210Jcn33Gx+KudiKaghu5JwtWSB9YbXPAXxFBRe
3rw+VoUFGYcru1clUlCrYMyZ94tMsHkmH9/4isxXX/X+VRzJ90X7r25/S/7+
puZ3wx2YIMBwM4tMo6B6G4UBjy1M+PofFjz4mYJS+D6eUs9jAKXptG9ePgXV
vo05tVwwAg4rgcdkiyiI555UjZzfCHxf/3G792/yeaAxAyy0RsDpChtTo5KC
HOuNqBvfDEMhNenUq1YKshlv+zzgNgTS/5Vqc3RQUJRPpaqD3BC4nR2TPN1N
QWv2Zs4rlwyC7Mc9ldJDFLRPn28qij4Ilw916z6YpqBdI6/uvXjXD2WXBWSH
5ijIvzl8lHGwHxSebp3RX6Kgvrwlx/fDfVAxfCd9hVMMpTvNer9b0wfrg9Yo
XBITQy7hAb42AT3QVHiO/YSqGLJMO27MxdsJo3ta6DfUxdC7x7U/W7d1AG/B
ke3Pt5LxPl6lKqt/oIn/O9+vJYb+aHt7Hoxrg+hvlApPfTFkE3Bqm7hgMxzJ
/B4bYiOGfJfiL02/qYFfryS2/IgQQ6OaMmYzz5Lg39pgo86HYggvtFgMhT6E
qZcrtpyPxZBVd92H3Ck3WPti+JHRMzE01/ppxfVmPL6TkL/w960YOsW8Xk8L
ysK6jy/8ZhWKIertn8fNi8rwl6AiG4UpMaQVffbKoU1tOOVAuXTgrBi61BAw
nSjfjuOEamuZC2KoUe62XK/oP3wromP/Nw4qWozdeXyJhHbj2PnNlhQqCmbj
XW9S1IXhBPvQd3Eq4oiXa/y7vRtvleN7uYZGRT+vP3anJndj2nNJ2tgqKqqZ
q+OP9OvB3W+2rIRsoqK9zn97KpT68F+nnTnjm6lodPdlg+1Bfbhkk+6l41up
iPbY1UuS0Yffpx8cWK9NRbr32+RU0/ux91eHqoL9VNSgm0FlKA5il2uu95UP
UNGmn1NxTj6D2Ebn8r7wQ1SU8+TXe9WaQbwP3/5qbU5FHSUJYi7XhrDI76eJ
M2ep6DpLT21d5jBmv//yuI09Fc158oSqLA/jyQOp4sWOVJQ3IMZpuH8EN1d+
DYy6SEUtebnTWdUj+E9E3p45TypS0aJ+WKYycJ5p8cJpLyryv9FEHDBj4OSG
2otqN6iIIjMm3FHBwI9jmzdG36IivqiHe+VJvgk+0dkz709FIWFdGSYk/1z8
x7QqCaaigrfJD26SfGT7fFJMPYyKcrV/eV0m+cncdqH8USQVsX+5lHBIiIX/
6+dDdrFU9O2GrlGiPQurpYjOl8ZTUaZc2w2xcBZWcJbK3JJIRWuMvM1OknxP
VV3l9vgFFXWpDHH6tLIwN2uN8vIrKvK7u3PUeZmFZ9NVus+9paIJWuXzTatJ
3vXQeFqeRkXKO14X5+wmcPs2LcutH6nIPNJDU/wEyYtTupQnn6loEhWM77hM
4J9f9ctWsqjo0cBGJYUHBM66ZhzgkEtFIuL2EtVJBE7RMdOt+EFFqwou7tH7
QvLn0vHZbQVU5CT82uj6LwKH4TMZcUVU5MLdNnWJ5Ptbt89fYC+hIvWkSzvV
ugl8aZ/besdyKpr6d1H5NYPkWe4rnZWVVLSH7a7gP5K36atLGxdqqCjfgGPi
FsnjlVqrqpT/UpFt0Oj0JpLX75h6/LJooqJLT/zb/5E8r3mh+MedVioaypwO
efJ/vr8r8yX9H5lvVRiPNekDCYmuaW1dVNTXHOO+nvQF05yCl/x9VJQeck5o
bpzAPHWS8ZqDVMRpdUinfpjAuQynKLsRKgrsf3kju5P0C568+xEsKiIC0j1f
k3yvpEC9/WOMis4eedGUQK63QdvBe3iSio7dCn3wIovAwWa5F2mzVORTbxac
kUxgXVeR83oLVHScP45RFUHg8Xu2Nh7LVET3/sJY8CHwq+dZFgns4miyPLZ7
px2Bj+UKHCrnEkffG/L07hoRWKjeRm+WVxzJBIin9KmRvsTLu81URByph8Wc
6h9lYWXFkyo3xcTRSsKge3AVC7f9l66YJiGOaiOv8BqlsbCemxWFR1YcPaDK
BMufIesj8B3vNnlxxGdotf6/nSyclrSyfFpRHOVU/X11jaxHib9vmDkbxJH/
3OFxt08k3+vMlrluF0dVFe8j/fsYONbCuDBupzjyCm0xEvnAwMYXn+f8/k8c
HZe4K/33MgNnvjBMUdwjjsrnEzetWxrBAfxP7v49JI6WGtruas0NY601TF+O
o+LoYIhDsBD5vDJ27bmsbi6OIg8klem4DmNz9yHb+yfI+Z5UC/zRMoTXNmqj
3efFUazBdZ3KF4O4aTR0p7OzOOJSWfy4YDKIHwh0b37sKo7ub6xcfrs0gCd3
B68auySORHKV8p6ZDuCi5Jb55FviSDb5seDVkT5s53n9i1CcOIrpzU/ubu/G
mlv/fdn4TBzZ7gkVxd7dWGAcZe1/Lo78ct5+96d2448ePF9vvRZH5qdG5f/t
7cKL7pHZkxniiBb71Z9PvQPHXHzzra1cHGXuNZw7rdqESy/UFaQtiaND6ZfP
2ZwtxE9VNQtL2SRQ9rmdTl2X8rE7I7awn1MCZRnkBzYI/MBSF2x+KghIoCoe
GaqY8Rds6zJUFC0lgYqWopznuB6Tvr3y21ddAg0OGihxWuaA+vlNlcZnJRCH
49ngXb5/4Z/T6ovvz0mgrUZfti5fa4AHF8QpIo4SKPL3A1D3aoQhj4WjVW4S
yNLb0PGJUzO89C3/e9RXApWWvip8+1870KJc2i0fS6AhnWO3A3S64Vf0ab+v
cRJopmS/2MDbbrj82Gy1dIIE8g5nzS9K9UDNU52zzckSaEceZ9RaZg+EvBHs
O5khgXpCZWWig/pg5fs7xpkKCfTMyP1h3ZVB+IATQwuqJRBhl18i/mcQrAsf
blaql0BynGw8cQpDkPP7untPiwRaF3tJ7WzREFyqPThpPyiBVjmEqu6eHgal
v/Do14gEihdsLBHVHYHqxm2aGwgJdEZtpHHRfwTU2mW9B6ckUEyp2QxVgAED
AyMLzpyS6EfIQ7v0ZQbEDHc8LeeRRCsPp+rqNZmgx6zbrSogiUxn3KPGLjAh
afzbTSZFEs18OyXEUccEk6l0hcMSkuhJ9/s0FgcLlmdeFnygSSK2GDP7oi0s
OLkUwukuL4nWLFjflr/HAgG2W8nVipIo28Rv4ul7FmRzXNbXWCeJfp5riZ8l
ed2B27E/UpmMM2M7N5O8LslnHTi+icz3WeHwbpLXiwRMlM3UJdHeG/qPFUle
9xTWK/28lRy/ye1RsynJ5xQtZwlNSXQ+DBvauRJQRVUVvKItiURFtZu+3yVA
19V1KH6XJLJ4/VTrehwBH35/+F0IkmjXXLbokfcEyCuNvhraK4mkrE21d5L8
GuarEUDZL4mcihY/bK0gYLnB03ankSRan7EpCLUQ4KqRiWyMJdFGIzR/uo+A
tpAp+btHJNGBuEfHIlgEGPdrLr0zJfeTHiJRM0XAd+TdWmshidQPhv5QXCBA
NT4nZ+6YJHocJMd+h+T3p1PzjxWsJdF+0drUMZLXBU12eRmclkQL6+2S3cnY
J/WGuZstmf/Gi6llkt+HufDWR/aSyOvdzaKnswScOM0m9t1REgmNcFn8//9A
ZTl7iG4XSWQ3acrPN0zAfxL+FfwXJdF2ofizDR0kX7sVvdviKYm+7KYtfqkj
gF7KHWx1RRKlFbI9elNMwP01Bo5+3pJo5EkAT9oXAmZvBO1/dV0S1RhnGRa9
JMCxqXTtHz9JVNJ7y2MsnPSTrYKcE7clUZRYTOZ2HwIMQ427ZO5KIsvbJ+3C
bQnIHgjFKIgc36WBwWFEwIa9Vc/Oh5Djmzxqj1AjgGfm6IkvkZLo1YUduRxj
LPA6+lCrLVoSyWM20+EqFvS/q5fijJVEvgbvUibSWFB8xqrOJEESHZrXVbl8
lgXbv8V+uppE1iuDfYjQYkGyZEt4QjK5/hhKWIwICwLKrI0ZqZJolfcbhlsm
EybXJqiIf5BEXG+DVr0OYILdzQ6+/z5JIpc06hpxMybs3W5bHPhVEpU9jq+I
G2ZARtjLlx9yJdH18HUl3z4zQGmo9/bfH5Jop7LQ3tXXGcCecF53TZEk4p2+
f/8bFwPyeV2/5lVLIn7DI6IfOUdgi+2HR311kmguZpZ5AA/D8+/EJaFGSYTm
X77cf20Ybnp4bjnRTs5vP0eKx+AQ6LZefTs1JInWcmhwi2cOwrcPd+JVOaVQ
zoGAwGyufuAxtqA/5pFCPm1/Dcue98HRoQ1P2AWkUMDa3syjOn0wsKYipoFC
9o8XjPzn0gviT2hRt+Sl0JxTuU3Bt25w8U8LqteWQkdckbCwzj+QPdZwxddd
CsUM1pV6Rf4Bh6mUyf5LUohOBLdmXC+DT1HXLx29KoVSnuVQhc6VgEGFgsd6
Pyl0W1sh9YN6EVza63KhOkQK+UuEf69y/Qrlqmx2a99IoYTT/H+67F7h6+wq
Jn/apZDWb7743R51uF9PsGl9Fxl3brVTda/HJkGM07d7pVCswGbOTNe/eK1o
+kXNESl0vNfHwPBcI/4jtz38+awUKtW7tiN5dyuW19KtvCxOQ7tXDTzTM+rC
QddXW1ZJ0dCvINeFsJwuPJ7H9m8jnYZOnVfsSFLuxr/1fzL/KdBQhoJHFQdn
D3Y3MxQ22kxDtz8WWHW96cWFbqbGq4xoyODQ8FzHuwGsmrGt/qoxDbmYHNA3
4x7EMVMS1rVHaKhPyv+SwimSv30bXQItacj7+Fafj7xDWCLYOmTMjsw/8T2f
23AY+1XsFjc+T0OfPOuGXz0cxoOU1fGvnWnInd1T+FL7MP7xuCv1pAcNsb2R
krnlMoIdXjmUFfvREOWoyo0OdwauHjQwVbhDQ9qz5vln3jPwf6obW3zu0tAt
vhjq8AADi34eGVJ/QEOXXyZMclkxsc/0H4/gcBpKyZvpCQsheUT7w1xvFA1x
O1NeiOUxcXa+O3/cEzL/jqGqCTkWVuIyjZx8SvbPNfpubMTCDwy2yRx5TkP9
Iqs8Ii+x8HSwRNLblzT07uFTXhzPwmcrp5S53tBQnNaPH7UFLPxHrPGjTSoN
vRk/PV3ax8KaFtlaOe9pyDj1pvYLXgILtPkYumXS0B7NVzkMPZI/r74VDv9K
Q4xeIu6hDYHPUptq03PJ9sB3Qye8CPzgPU9s9Q8a0uI3/W8PydPZhjtOjeXT
UHmGlK7+cwL39tgpUYto6OL6+UL7DAKL3owa2PqbhpTftH1OKiTwf/SCNLMy
GtryKkx6tprk5S+Ex+UKGtKJ6JB0bCdwlIn8zkfVNKTLSmWODhD4x4gxee7R
UGBWz3LkKIEH710vaGigIUw8Kz4wQ2AJpdR7M800VBAh1UpfJDD8aDoo3U5D
0S9zpthJfnY+xium3UlDZqnrh1bIOGZiR8PxHhqK0N/2WoKMC8LOxfv009AO
OcZ/iPw+Y+PDM/FDZD1wRdfeIceXLi5Y951BQ0kXk760kfn3nRkdbiNoiEci
1+jwIMnTC/Ifl8ZpaG97mlgTOf+4mENX5KdpyFzW+b1PDYGLNXz/gzka+jY1
16z5k8Cjf1JXTi/SUKiih4fwZwLLOTYX3VqhIc/WHucVcv8MOfmCkzikkcN6
qxbhUNIvEjSPFHJLo4EjH0e1r5L8r20v0cMnjXDui4WA0wQuq3/YzCkkjTzG
4u1H9Qk8fbEwYa2oNFm/H77cUCGwouCYnT5VGn1R8A7fLExg7z2HWfekpdHg
6tZF9goWTm7z/fxGVholqAfbK6eycNXVd94l8tLoMK2H3ecuC6//wMcpsE4a
WRU/yHyjycJHjXaWqChLI1O1rptBJF/79tqHHtwkjTRyEwafdTJxHf0nLVRD
GrXSVDZ5+DPx8pextvfbpRHfqNOj7aZMrHJU4UXlTmkkMpL0Y+dqJr4VeEOV
oiuNNhsER/BnMvDmyZ17Hh6QRl6mpzh2lo7gE+EOPJmHpFHJw+izZsEj+K7K
o/J6E2kkL7k9u8xoBLedGbeQspJG24qYlc0/h3FwRZrzEztplEP7lzCSPIT7
XitGJ/pKo6J7LLbv8gOYEdA1x3lLGtkkNxCr8vvxuG3SaUd/abRXNKih/3Q/
ZlutuEkjWBpRLs9+KInrw/THCoWFj6VRS3FVbMRyDzYJXD3alyGN1n3a/uBN
QCf+fn6VseqQNFp0reNMvleDf+q3f4pgSKPVa6eP8t+uxmVrntGmCGnECP9W
HjJZiRs75Hp+TEujMPnFe6vqyvC4lZzPES4ZZMQ5s67GpxArG8qmeK6WQWWy
SjrhlvdxtLIMV46FDPLVOvO8aLkKrG3Wv+k5JoNuVO4uU5mshrXR2w6IWMug
qC0b3gwN1EDmyqEIO1sZ1DGQS4j8qYP6hjtyIhdl0O1Gq+sn7jaC+F3Gdrsg
GcQtr7/FJP0ftOTONYaGyCCH+ZUfaQ864MUoz/XsMBnk3uJ9W3h7J2y1ViwQ
fiSD8hSVQ68LdYHpNstD2Ulk+5OENwkfuyGqC9sLfyPHX3nxwju/D07QKvi0
8mSQnoJn1me5flA61PLOtkAGCaw9bR19tR8ysifHvv6WQU2L3Du2bByA2vCN
frb1Muh8QSLWuT4IccWaiqGNMujOzE5vIZKvbRf2FX1tkUEtxkcyjskOwbiD
jYBwlww6QUk+bvJlCMR0H8Z8Zcog+lJW+H8Nw9B06bl296gMshS/XXaOPgLP
375vE5qUQftqeuz7rcn7XbJEyXZeBr1p647oaBuB2QN/ix8syaCY7pCDR+gk
D9zqdvzKRkeXM8/+4LFkgAlj8YMQLx3Jj7rv0y1hgLSSgOlOATrq9dp14ivJ
451WtKmzwnTkfO+XmvM2Jrj/1ND5Kk5HA8WPkPtjJmjN6f7rkqKjC6vLzvz4
xQQ2dePbQnQ6GtVZWNk5yYSIOIffZxXo6NvM/JdUIxZc9bpzyXcNHUldDS5s
cmeBjWnC6sfr6ShT5bLfrhgWqAo0XP2jSkfrit6bPW1lgXj/2JoBdTp699rv
WPQCC+YLhKvZt9FR0tqhnhwZAkqv6Svv1KajbbvvR90zIeCjxdn6o7voKL0m
3VfFiYBYjRu3LgAdpV2/c33qJgE3hZ+oBu6lo4XOvzv7owlwGMpsStKnoxUJ
O6+FNwQcKq4O+G5IR4prWmjbcwjYnsTY0niQjtomx6XDSwiQvcHXPnaYjkwj
faMEGwjgOL72vpApHQlkOeekdBEwtB3t2GBBRztKuv7ZjxBQTbHu2nOMjhRW
7XHfO0HyJ+NqqPVJOlp6smlm9xwBiSUPta/a0FHd2zCZY0sE3EtO74s8S0ff
7795EkHyttut8si0c+R6hnksB8jYwnpg9+/zdMQajDKyJnl9lxbncJczHVUf
Cwwh5glYI7E6ZtGVjqYdLx9JInlfYPS/vTQPOhp/otPnQfrAWLklS+MyHUUL
CuacJX2h6Y1nnPFVOtJVsDLzIH0C+4ftP+9DR+ZetceSSN94fTp1/PYNOorR
Ohc8/n8f0fmV8PQWHf0rliu2/0DAFVr3ga/+dFT4UZljMZ4A64ml6Zp7dNRD
K7TMCiRAr0rmJeM+HR06pjD5yIOATe92HOENpaNKGYcNT48TQA08uqAYQUcp
X0OPlwEBc7aub3Y9JPeX21xUaS0Bnbr3zaxi6EjEU3EomYf0pen8dw+e0tH1
Di2Jbb9Y8Ki2zepNIh3d1i9V3/uSBb4fZjkLX9DR84BMzgA/Fhx02GI9k0JH
Bzacj05RZ8Hg30Qh2y/k+Ef1vbN9mVD16Vu2bzZZX/lvshIPMiErtPHc4290
xLRZ01MhzYQAfdEffwroqOZFloTgBwYofvFz3VlJR1yG8w22RSPAFxknY1pD
R3McReUtd0dg9EJW8YV6OnJTe2iTqT8CeWtZq1600JGVZVFofP4wnIg+VSk0
QEfJ3l5xb18OgdxnAVmXYTqKXW+SoWw6BB01X8+XMuloVS9zqH95EM6JUtnv
TdLR/ExX/06zQXAL/rVthV0W1cqNLNQP9MOdW+pPxuRkEc78FZT0qwf0Etv6
jijIolKb0hAe6x7gzbu/9cMaWfTFnP+UxGg3PFjoKXdWkUWdjqPnDSW6IcYr
drlnpywS/BrAO3SoE95eYD/XYCqLCt/9WiNGb4YLIR8+breURS0nGzgsFJtg
c+rJpajjsuhEk/cq5vpGyBj4EnPkjCxCzav9Tqv9he+2zqUlrrKo9e0RNe2N
NVB9rG7ztyBZ5PAo6Vh7UwHM6r2aS8yTRRRtx+Hxaxj7fkv0LyqQRWZvZe/c
Si/AbFvjhIeKZFG8Pd+L6ec/Me/qcMWt5bJI8s4bba1bv7HUnLdRUaMsUvO1
46hUrcLb3hs/GRyVReJzmdv3UBtx1hqDNcKTsmifJv85ymIj/i9uz3uNGVm0
TVjBw7W3Ce8N1CzwWZJFr24d2P7kYws2OaswJCQgh/rCVwnt2PEPu0lOamms
kUMnNqs7dHl04/EQVqHFejnU43oqT7CpG1/hGDL22SiHApz2GYnv7sG+RPuZ
n/+r2MzjofreOC4k0qKSklnu3CsSKe2LOk+RClEqSQhtlhZkKZQsKaKkhSjb
lxIqiUroCNllSUj2fZmZGxFK+t3fn5/XnDmvz3nOc+b1/sy9ZyULfni9SYkV
68I3S4puHNJkQc+G5dELfbrxHMib745YcE4hQ8q3pRuHvsl+FLWDme+J4VjU
ph4c8d+r1N7dLFjkeuRi+WAPTrwc2XDpEAt0T2g62aI+rDZy3zrKhAVWrRdK
MkL6cKpdCD/vKAt4Kt6S19v68NvD10RmWbMgaQjJJXj040KN88uizrFgh870
SwbRA1g30TYtz5EFf9tdL0HXAK7gnNDsdWaBUbK2x13lQVwrfWTfKg8W0JdO
WOo/G8Sd3Tsu5l1nQcmCMKOocD7eEf05bvlNFuzaYHUnv5aPY0xMK0JvseBq
UNRw8xwBtihzJI/fZ4HYr7bSdk8BzvH7q18WzoKYj5mu+akCzNoW4LbmEQv2
Xtv8MrBDgBtTY8rF/mOB587w6iwkxJvs1Mbsn7CgTcmKx7UX4nDqHa/2GQsE
vrxS03tCPNakpa/5nAVaMfPa7LOE2PhBpWt8Kgt8NV5HGbYJcYbh0dhZ6SyY
vC1mKybG8LJUb5nzWxZ0KCSX+FE0rvGYInZ+YEGXzDToNaexxrpAvecfWZDs
3bi6gOHNEOFC14WfWBCqkeJ66jaN6aexMZeLWSBX+s2iPJ7GBlYryrrLWGAs
NDo98pbGz5dkju6tZMHrdy/WNhf///9ebeJNDQsuH9a+d62exvbBVbqcOhaw
C8GT38nwq46Zi/83FhBxmdLzhDRWEemLFjaxYO6SnMDhURrfyLxQatzGzD9q
YRfyh8a9Tv9GPnSywDA9T3tgisY6aje5yr1MvxWRzf/n+4RuOd3bAyyoaq7l
VjOfi0fHOY8JWCC+R4+0YL5/3EQ9+tgQ048XF1BPmfnz5r0vKRphgWRwdUCK
gOHlsp0jK8dZ8GZyY+85xt9Vv2pO+B8WoMOio8I6GrduNd8j8o8FNxRa7q9g
1rdtrO+CjSgb/iSe+KrKrP9xqnNU1XQ2pOqK9Q389//3i0RKNkqxIce8Z/mZ
WzQ+SgX9jJnFhrn326hXTJ5637SIIyXDhuCjht5ZZjSWf/DfbscFbDA4PCkf
DAyvG6688E2ODfVzJ/nKJI3rJbMeb1/CBoXMAN6taUxey9MpfsZmQ7lSm0Re
ixDf96gZnsdjw8GBubKFmUI8staC7a7IhqrHNb2PQoU47amLk64qG4z9FanP
W4V4ntW0x2nqbJD1fh+kLiPEDkuCi5asZoOLqF/uWYbn1YPjWYMb2aC/bsW6
B+4CHKyzatcBTTZ4mYo899cWYP6/LMcsxAZKzt7sxCwBTnL6UnhTh/Gz0+78
2H0+llI7NvRzDxuectPWZxzmY5vuAQWzvWx4v95y0mERHyuZiDqqHWTDGlWp
5pGQQRy3VUOhwooNy984aL45M4DzDGb6/jnBhlOGqJFQHMAdxzoHVGzYsLvs
o7zwWz+mfO6/9z/HBt96A34e9OP4wokj4MGM/7HMtOlPL04wzAt/fY8NB8ol
W/epdeNCy0iRjjCmPspOT6G8C/c4OtvIRLIh3+XN7V67Lqx0T2nj2Vg29J3S
aHeK78RPGgLrlV6wQfLE+kw1qQ6caHVALqKIqSdXvyxhazMudlK7UlzKBo1f
iZoWpk24z3d6z68KNpDJFYeMXb7jZU/eZhyoZcMujZZV2558w88GFA7NbmeD
tvYjGa/RrzjpQtfdq7/ZIL5vdabu83L8/JrLvNMrOLDDsJDfxAlDfE1zn2ur
ONDTNtIYYfofUhvR/vnfGg5oXZkvF6uYjJKsZb+2beIAJ+RGReqRDJSIXoeb
6nDAjXre9co+D8VP/OAaHOOAmbFXRmVdFepKbQg5Y82BB+05MySKqhFlkzvt
5kkOeJk/VFJ/U4Pi6m53FtlzYN6rlXMV7tSi6NfqT7df5MDiiOuGLRsaUMTZ
M+rr7nCAZHVfFdvaihoVD0YfuMeBVZInC/kz25B80xYZpzAOHBI2/Dru2obC
daWHXzzmQG7oI0tz3XZ0XzkpY1kSB1ySK85WdHeg2pY7Sruec6DNYJXHwJ5O
JPvgUtjJVA5sEy0y60jpRKHiey7FveHAa8p2hd75LhTS3qvJyufArZvttGV3
N6oKr3y+uZADLbvT5qejHjR331vOkRIOPN0zc1ZGeA+69cFf5EElBxq1H15I
1ulFQZFLC+Y2caA2fMf673f6ULnR7HXqrRxQVaqOm93eh6Rnjibod3Agaerh
4Cf1fhR4seB6QB8HnOgrrzM+9aPrh47riY1y4NS9W7fl2gdQnGGT2clxDqCX
5/Xvqgyi7D2HzhX94cDf4o36yx0G0fDWXXduinLh9ekzl++ODaJZG3PjBNO5
MJWzf5PZRj5SXr0p3VCKC8KmnL1qbnxkpqRav0CGC6uGEuWqhXzkRsT3uSzg
gtbn8POPlQUodAn7d70cF45k+ttZWghQ0Zy57EdsLiwL62JnfRKgDskb6lME
F/ZLz4/S+yVAk6LTwFKRC1Ipm/YVKArR6rFha0VVLhzcN37BykOI9g7ZO/ur
c+HvpaQGL4YPbQa7rvVpcCHDYOKQe4kQ+XSbh+mu40Jgd5a2gUCIHrfWJaZs
5MLI522KE3MYXv9m+H6OJhdGvzpEXFSnUc2X4jIHxIWBObOdS/VoJKjY3lyz
gwt+q/Li+adoJFn8XrhWhwsv1hze1czkDSpvjUjYHi50bax4HPGARtuyU+ZN
6HOh4uWVeVQyjUzeLKWO7uMCgbesccmh0YXUqLU5B7jAHTyedZvh71tJi3S4
h7mwZXwywPE7jRLjQw57m3JhtlTRE/leGuVHSdl2mnMBj+7dfv0HjVrCfdx3
WnEh+ftYauYYw9Ohf24+PcEF9y4Zl9RJGskGOz+WsuFCqlbtWnsmT6hfF7yw
t+eCgp0T/v/7Onu8T+VWnONC0jnZWWpMvjjh0Vq90okLwSlNm1Yz+eKKi0nn
HRcuWD/ouj3J5JmH56tHfl7kwucPGy7fZPJOuq2uhLEnM79ceXhrG40qj+cv
eufFBVcrt9iJLzQaMNdUWeLLhQdt7ZcbC2gkbpKx2dOf6Z/1rpq+r2nENVLX
bwngQravwYLRaBpt1n9qDsFceJzFsdQIpNFBHeJ8XAgXbmxkJW5yotF5eHhV
/B5T78COsLkmNArcPD/0VBgXvlw/JJaxhUYJa2/+VxzBhYnIq92qbBrlqotn
LI/iwlyLC5auk0I0Sv6qF8Yz/XpDwf52uhDJsM/370vkwurFMSLHg4Vo+aK+
32nJXHCuWrVZ9oQQWUo3st3SuPBEer2ugrQQuU8/sPJbBtOvv7MPu30XoPv/
ymBLJhcsC6a75TwToNKfOcf/Ycb/sraRhSBA65pin12v4ILdWUewPshHMuo2
4y+ruKA+Y/W8ssV8xPdS39XwhQvN5X4brnwfRPFUVteyRi5I0MWBNUcHkax9
Lbe0hwvzt95Qj9s9gH5kR5wb7ueCZ7xRTdm/flQ+xypniYALwwd9Llpm9CO/
NIGp/U8u8NdbTGtW6Ee/PcX0JEQImLhb9OFpXS/qSzjlFDGNgLj8qqvPvXtR
3eeSh+piBOwz2ia/U7UXpREhfcYSBPyWVxrc5t6D7ApY/k9nEVD/5FX06Ixu
9E16/cfd8gTMLj7DduttR4VrH/Y1LSEgVk6/ftuVdpRuPjnXkUWA3lKzBb8W
tKOQl3kWD7kEHPOOEtmr2YZ2HzCc7F9KQJjZhQPJos3oXYTNhpurCXAems6+
++krCleJfF6hR8Djev2jysmZaOSnToLvXgISeo+NdNhkIMMPw482GRJgZrpq
QG7pKyRxQDcowYiAeX1pJKyNRS6eE3aXjxBwZeL4X7dpsdio8vCyFacJkL13
5m33jk/4xUMxotOGgNy5qpfHzIuw1ImXix7aEbBoTmy1uVsJzh2XmDH9HAGO
oyde3IqvwCvJN91Nzoy/zzNOqw7X4Fkusv8F+RCQtbhj7Bi/Edug3IgdfgTE
eB83yer8jvOlzoSOXyOgrlYlePG3Juwele99IoCA4VP9bqE5Lbi/yMlSM4SA
3nc97tXr2rF2KMdk+A4BlqfDje4ntuMYs1LDxLsElBacWiq3pAObDPGQbBgB
wcIxa/WJDly4pJrNf0zA+LZl8k1PujDZ7bkwLpoAN9OVM5LmdOPLL5fNNokl
4NS4ScEv5268VvvqZH48AZXldYG0Zg+OO7vye2QyAfdX/YsKz+zFUxu+1+x/
TkCPmHb0A9k+fET0eumMl0w9peJ5TWf7sExYS+aFNAI0T8XtVlTox165weF6
mQRs3/jXberYAB5ozr038Z6Axq/b1NWSB7Dxn58hT7MJ+FU/meI7MoDV1psG
iOUSENAu8yPSexCHHQi+9uojASg/ftLo0yAWdcz1PpZPgLFskzUxg48bkpXc
swoJcKqw2sr342OtkiOutsUEiF1OntGRy8cveoKcFpUSwKKVG5p+8/E13k+7
CxUEHCzOy6i2EeAf25RO8yqZeu9duqrgkQCbmR05XllFQKRp8c2UzwK8Ogwf
Va0lIMJ/md5+NSF+nD58+NtXAjablm6ZYSLEkjVLD16vJ2DG117lJ95C7Eyb
7Fv3jQBvzacaqs+EuHVWkH5nIwFebzfH3P0sxLrL8e47TQR46su0NQ0J8Ztd
w9qohYDFhv98xBfQOMjHZGtkOwHhwruj3QY0Hou+uWlPJwEep+0TIm1pbJ3z
Yd1YFwFKOZKXlH1o/LlxSCOhhwCfiBh8PZzGm8YV1Q/0EbBjZrLwfQqN4xea
LJ82QIBI/FQs/kBjmTU3lV4OMv25oD/y3mcae+z7QJoLCKB+a3/a2ETjnrND
HGmaACuV4BXJvTTef1NRIfMHAX9WC2YO/qBxduLhRaeHCRAaGr4fG6PxssLA
BQtHCKiKPI2rJml8tzNnbv4oAfbx2QUuTB6ZEhmSdhwjoFb/eWTP/59HcBQl
uRME3BVz1qSYfPJ1y2Hxit8E/KenXKj6m8ZwJFDEY5KAw+Fvr4iM0DjZNWdy
2RTB5PmBmthBGsvd+zFe94/5fVp+wFimncY+r6hRv2k8aDbcna9fS2PBZ+Oh
1WI8qN5Q//vwJxqb8AMEbeI8CNyfLr4mncYFUjn9tyR48F1MZW5rDI1XKv/o
1pTkwe/vU+fMb9I4QpvqGJDiwRNZm+iXF2g83dq4JVyaByoXu7fXH6Gxg1dA
o85sHuyMVuHUbaVx06PsupE5PFC6NcF7waXxrvd0TZwMD+LTZlpZ/WPyRj1Z
uW8+D0a0W2SHm4SYM3qobGoBD5bMiXhk/Y7JJyuz800X8aCoIOKYwEaIj+2l
saQ8D741Ni2YvU2IS+3I7DdLeBDwJyZ40Twhjkm4kT6fw4P722YemWDy816F
QwmlijzgvykbNmzg4/Au9dyjSjzw9xRNWxHLx13PJb/zlXkQW2CqftCGjz0h
W2auKrP+N77yAUODOOUk5XlAgwcHLir5jNMDeFz974Ou1Tw4Wtq20Zs5n9rj
da9c1vKggWjJcTg5gL8HBvaGbeDBH6MWufu1/Xhm6pBR01Ye1OsZ+p6L6cPG
l8rOnkU8OLm/2jPRsA/H7Ui4MQU8qP1i4nL2by/e9NXkA6HNg+vqyqtSDvZi
m99Y5aQuDyK7B5WDhrtxkfYtEaExD+DKk3n3f3Tg+XNsFLxMeFAqTthPBnZg
i/rt62VMeeCRNUd7l2IH/mU7ar/anAdezoaKMQfasdJts3rX4zz4rGL5j63f
iv2+LX/x7zwPpP+4HlRFDXj7uaKj8wJ4sPJ8TrGocR7+3dCvUxDIg0mfuapH
tuTidK1Zq92CeKD51fLqQpSNleT3SzbfZvz+++u8svQ1nlXQmJ74gAfmFxe+
Mwvxxw3ywtkQz4Ma8z3tsbIYhfrJTAwn8MDOJearRcJHpEev7kp4yuzn5D87
dZyPPhS4vZdO5sEua6PlHsIiFH9+2un6VzzQM6gyqlOoQg6fZHPPYR4oSrfX
T6g0oOWrNiTzPvJAdL+8ZbXiN9QZceRBbR4PKlcbmXSyG5GxQ9SZzYXM/nIP
+TvMbEKaCsvkJSqY/s0Xa9Uva0WSjlucHjfyYHrl4tjMc50o77u5+b4m5ryM
vnYWb+xEHjpXd4u18KCuYOXKfq0uJFT4xLFt58Hgl8qH1gu6UW2hQdnaPh6k
Va8p143pQdEsa8XyUR7sv2erP27fjzavUVW3HuNBiETAeXjXj2r3jGwYH+fB
5jtdq0ZEB5Ckm7+e4iQPhn5Z7A26O4AcqpOcPEVJGFaLTxePHUQz+y54zhcn
YXz7py71NoZnpjT9E6eTYJS2vyKOzUcNqpUPayVJ+NMmUWpyl4/A/2eu2lwS
RiKVvCJsBajxUXZpngwJ0hJfCl5ECJDz62u1JvNJcJN4dn+oRIAS2xb1+S0k
4ee7fUfGSCHaMdY2tGQRCSdM3GrT9YWoaXbSn9TFJJgdKxq87yxE87Zozm1W
IGGQtxMyPwhRyv7p8hfYJPQ0VNC/2oRIx+YzKcUlocvvMmE4jUZtV8LUogkS
thWUfMVcGrnft1y/jiRhT8ZijV2aDE+nqEAZRYLK0RbHTmMavcgb3mO1lISZ
y9+Nhp6n0e5vWQfGlEiwzPTfeNCfRh20n3nwMhJ2R1yrXRpJI08Jg9PUchIu
7bPykXhBIzn2IsdMVRLizujJj36gUeqaNnfDFSTIFs26/YPJA7q6z/y61Umw
/bZwfKyRRl2WTrc8VpEgtz74+swehs/dtoTPW02CItvstjJNo8W3xOOeriHh
5IpNVw1+0SgtviJ56zoSDDRe9f//fq5+1oOML+tJGJJQd3/H8H5P9TFsu5GE
zLg/U7+ZPHC1b1nJv00kPFPTO6HD6CX/hmrubyEBb1ibEcHkifSFWU2qW0m4
uyBdYZzJGwZqfj0ft5GgvDG5zWKIRn079v44DCRwyhvsK/to5HtE7rdgOwnO
O2u1dFtoxHFoFfPTIsFv6fQ5VdVM3vJPnL1kJwl2VeG3rPJpZPTYcVGqDrPe
q66J/9JoxH+9maezm4SbxhrmyTE08i8VU23aw/i/MV5+Muj/9yPK1zrpMf5f
Xlu/ypXJC3OO7Y4yIOFsjWzgby0aCRWXGa3dR8JSa7+Av8o0urFl6GjpfhKm
7px4LjeTRtk2vud/HSRh1/hEQ2ixEBl76V8KMibhmmduz0S8EP24v9CXNGH2
e6JR0ctLiBTznz4wOEpC8tEIP4G6EH1WG49vMiNhxYWn/e/Ehejig92v7SxI
mK555s2HBgEqs+2v9Lci4aV/tZifB9PPXza1yB4ngZe4avoeXQHibA3kx50g
oTjU8fyBRQLkJKMqhU+T0LIrLkY7hY9Y7h6L9toy5+HZzkwNZz761Fm29Lsd
Ceev1TQ7bOajxW/P7Bg7S0JYYKjEz4+DCJu/8FjpzPRfyCaHMzkDyKZoKiDH
hQQra7vPBhcH0HwNw3A9NxJCjo2sjtUYQKfEf6SfdichVcWq7kl0P5qVrCGM
vkpC0v3SGam2fch0PN1SJpiEe8u0lOszu5G49fTzUbdI6I12yW8170Yvyg5d
VgshYdOHQZ8EkW40LfrXw913Segf3+p9ZUcXSty58cvVhyQghxXy0991oNHQ
rJ1DCSRMm/+7S7G1BYWsyFte84GE321HM065V6HEjUelfHJJeK8XbCQ98Blh
rZFejTwSzkknmlPN5Uh4RCnhzifmPI5ldVzIKUZ6/oHc/eUktIs+mvnILhdJ
tBrJVn1j/JsliIdx7LBHSOffihHGL9tu+87WKhwa6dl0+RcJn5pf9s7srMZJ
TxZmrRgnIUe593Rodw1uyN51MfgPCT7HJtdE99Ti9f3Jw/qiFFASD2fhugb8
Y7tzb9lcCiymHAd+rWzDkntnF3rMo2C3xI+0qv/aMNfkSbzqAgqyh475+si1
Y4NzDVY35SjoPzHL0WC8HSdHaDbpsikomO3w8nlKJz71U7y6ZDkF59Rj22bU
9GCLJO3PZmoUeItMPY1S6cXGVn5l9AoK2sQn0j979WKdSrHChRoUTKz1bexW
7sNKyaJZVhso+F6qUX38VD/mWO94N7KRAvuW7ykb0vqxnLxPxvXNFMMjs+5c
nuzHEtenpT7fSkHKzhWhe4MGcLe1SMKEFgUV+cWv/cMHcZM8xAXtpMDaSMXW
qX4Q11Z5RXN3UeCsLOS/kOXjgm3/Hu7UpUDxuHWidCAfZ49uC2vQoyB2zvlC
xTw+Tk+5cs9+LwVJVyWvXh3n4/glU7fu7KNgMRGcOXxMgB9Vbw1SNKLA7ebR
MdE7AnzvxuWAtwco6F7aor8nV4D9fk36NhtT8O3gpoEz8kLs+VzT28GEgunO
ARXaWgyPn/C8ImZKgZ1Z1b9d9kJ8oubPRRVzClZNieDCDCE2C9jimm1BwXM3
9dKtDUJ8EDwuGFpS8FeC4NWPC7H+2HuHDisKli74VRqyiMbaL36fdTlOQfPw
10GbtTTWPLnZXvIkBQZvJD6ZG9J4LcvdJvIUBfErZmWctaGx2pfMk+o2FJQv
z90Q5kVjxcAJ64+2jP9J256GezRmbd9kedCe0VStm0YijWXHL5r3nqFg3RbL
3OhMGs96+c7U/RzjR14+jSyhsfip8cOzHShYuCzfLLOOxpOsjYdiHCmI6hkQ
WHfQeOSLm9GaCxQYJw+lcvg05ge+NSx0pkAQvHgu/yeNO7eP6R9xZfbTP+B2
6QSNG8fX6/LdKBjMsajP/Evjmpeuu7wuUVAnnfgsk+H10lNvtOd7UEAmnust
YXQe+9f2BE8KXki9vT3AjH9fu+7/d/YgY/QqVmD4Pe2mi2aZFwXJHz69Mmf4
PWlHxiYLbwp605xxKuMnbmJk/ZAPBdpZZ48t7GR4O3XtWj8/CmSWuysF1dM4
9LSzxiJ/5jy81ypaWErjQE66etJ1Chry9sx//Z7h/a8/VbcGUPDnXu3oiWc0
dg9ao1IVSMFJud7Lag9o7KR1Qel4EAUrb6jXzvRm8tKrYSLgNgU1a8eWzttP
42IpD+HWOxS4lJo9615D4xXWYtnDoRQMvf1z1keWxuPzZQ+bPWD2I+h6JbtS
iC3sHynOC6fA8bDcUR6T5wryFYc/PaRgwLtYfOyqEN92Xhe88jEFJYWHdiou
Z3i+PMe0K4oCydbxGT5/BNh0qc6yhzEUtEq1og+lAqxUZ5wvGs/sj9qyBW3W
Apy94eLE1yQKZitczl3jzsdkiEhRYAoFVboO94Sb+fh634176AUFe24m4qcT
g9jo4cOVz15RYHR4eqWy4yDu+/3+pOc7Ct5IDAf37x7ABge01mi8p2CeuU4d
8bsfv04uE+nJYuppK+ni9awfXzFrijTEFNBLz+SXiPbjhR/+VpOFFHS0vl+x
JaYXu8v5R9cXUfB1OfHpoFYvbjs352xQCbM+demFRV09OIXLlfxVTkHYtPLm
KrIH7/CGbSVfmPP0/O8ZzaAufE7bN+l8OwW+phaBfUvacXGppG/2JAW3JvXF
LHJr8Bmt9pASRs82lm4JeVeDZbIzo+oY3VLWY5efWoNNntu9/8Ho/T2ukcqx
Nbj3dvmQ4l8KHswPOMr3rsESh0Isgxnts73zwmmtGqzVumibxRQF0nOIfsXC
atxz+IeePaMNZ3vpGHyoxoFVxUcuMlrdeJap25tqXPPxkksoo7dtWRtf/KQa
W8d/TylkdFCzbvHp69X4qm20wsp/zPj/qDPhu6uxYoebiiajF6e93pID1bjY
dN+GPYxWdfLMb99YjWX0px04zuim4s2TKirVOFr9eGAYoy+dnlr4Vqoa73i6
JTye0aK3e5O+TWP8cWWfvGJ00My5E38mqrD6vE8fyxgtMRj5EQ1U4ZqAx5UN
jG4u3KFp1VGFXUVdm7sZPa07ycGnsQov8TAYHGb0i+mjFv/VVOEPP5Um/jHa
vmf7jILSKvw/cU+y8g==
       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.9999999574404889, 0.9999976139198089}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUmnk8lM8fwN33sdaxLAldEkmH+CqfqQilkrNDKiJHhEqSdFBEziRRpFSS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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.9999999574404889, 0.9999976139198089}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}]], "Output",
 ImageSize->{214, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->712966977]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79905442],

Cell["Use any expression as a label:", "ExampleText",
 CellID->137367473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"x", "^", "n"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", 
            RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], "\[Rule]", 
        RowBox[{"Sin", "[", 
         RowBox[{"x", "^", "n"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "5"}], "}"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88531688],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Dynamic[$CellContext`y], {Graphics[{{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Line[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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         "]]}}}, {
     AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
      PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {
        Scaled[0.02], 
        Scaled[0.02]}}]->
    RowBox[{"Sin", "[", "x", "]"}], Graphics[{{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Line[CompressedData["
1:eJwUl3c81f8Xx+1xrbtUxreMQqiEJjlvkoqoZCSjrMgKlSKRBlqiQWmQiBYy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         "]]}}}, {
     AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
      PlotRange -> {{0, 2 Pi}, {-0.9999947785943248, 0.9999998722828333}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {
        Scaled[0.02], 
        Scaled[0.02]}}]->
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "2"], "]"}], Graphics[{{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Line[CompressedData["
1:eJwUV3k81F8XxgwGM7KkUkJKQklZIsu5JKWFklCiUkmU8AsVFUJIEqXIVrJE
ZKfClS1bspZ934352gnxzvvXfO7nzr3nPM+533OeZ5vlbcNrbCwsLDkUFpb/
/5Iwd22/kofmvIX4nR+jsWqSo4VqoiEX4drZLUopBZqaS2l7r7YG3wbqEfUd
A/l2munz0Myf6gKVXnenpQg/zcH11os5wY8g2lco8lF+lGaAcAUt9dtjaJPY
8o+FnKoZv+tCNEvqE8gzSrMiGF80iw5Myp+JeQpislveybwu1WzT9SqOC34O
UfxN507m12ouyVBl3IpfAOF5ZaN/b7Pmk/2/HeO+hcCLpbd5raQuzfUHY77V
Zr2ClTfhHa//9mu+07IhL6a8hs96I+KNjFFNOT3Fk9sSwoANl3SddZvU/HZq
9dWxmLewUeTqlY2vZzWPmlZ0/RcWCYF0t0TFM381my8GS0UGR4PNTSUVxfxV
zXQFOZX+shgoFz6vX2vHBi4HQjpcit/Bb9d18vd72UFTbdGdit+DqehJjt5v
XEAGc8l332JhzmXHhnISL1RpF1cq5X2AhCVDQ+eL/PBCV8quKisOvp+1X376
VxBMjwUIXEyPh+KVyUT2xg0gqj+VM5OSAP3+5/+VMoRh4LSxmW9SIkRp73ub
bLAVks9+WxNJ+AhcXa7BJ93EwfGc+If02CQw134dddBZAlTMvY/qxiSDyh/p
EtrrHbB6aYzeFvEJuiUd6g/07ISyqwYvboelQPB4Yrj0GWkwvCnc9ib4M1zI
/fleKl8OqCqAQ4+kwdlJgWL/NnmY/OLA31uWBqdH3u3/Ybcfcgp+ZzsVp0O4
OFZy7FWCMOCiFKEMiLzmGHb6+wFw+652nhtnwFztabGWb6pwqCxmNepbJvy5
9VUhn6QJO480nhpVzYKNuXF6h6URcFeyxyrkZcH4vaft9he1oK7G5khFVja8
+vp63vvvIcjUjwwTUMgB/hLpESmLwxBa92v8QnoOuMJn6lqDLpg3KQZNpeQC
GR3EBQw9QMbX+9R258GnUK9s89DjsKMlTNEnKQ/4vh/7HGtwEsbaV1s2J3yB
zcKlmnpup+Cn+T7Za5JfIf8ZufPendOQ1n3lwefYr6CfwjOo5GwILv0V23Ri
vsEZGoRTXhvB+WvL/wWK5oOJmY6ra85Z0BzeU94SkQ9vNb/v2d9jDOTxYJtb
YQXwSsfTbvuZc/Bi+kJmaDCGh85f5cXzLeCZULh6Ea0Ith065nVF+hI0pHuL
KRkWgZ2Jlnz48iUwG7swKNpeBPWvDIt3ZltCjM/RihCx76BbevpabsQVGJBQ
TKZc/Q5fubYXxzy9CnZmPA7T9O9QxWEnMfPICjIX5s9c31cMki6mfaHe12Ex
pE+5w6kYRHpnmigh1uBR82WlbLUY9CZPVdWU2cBLDWvfML5SKL6koMoTeBta
W8/Y8p4thYgVkxvJNvYg6gz6j8NKgeaLylMEHCAhdcP6WxJlIDPSOcZm7whf
xcqikWI5qEhJzvhddoLVb2me2XfLIfHdg7OfpZ3hkGnENZmCcpC9d/dr/Lwz
1AT9J7te9wdQD+Ud0o2+C92sErnDJhXAxbXjVP9uN9gRRQu/EFEBZ+spZQpb
H4D1wb9u9T0VEFzZm1At8BCmHeu0v92oBD6+9UocnO5AHnhYG+haBe3DEReU
t3uCnrtNOqmoCjR2+X/TS/eEQBHjl3fJ1bC8yc1DTfsxbDy757zls2oIEVd4
8+emF8iUtw8qRdeAu8ceLTzoA7ctf1Qk9dfAf58uSIc8fQJZqxnJYrt+gpSd
sLi7oi9oHPB34Er/CUl6yX7Fz/3gVKLKv47iWrhRaHEn52YAqJUd49b+rw5s
ZjP9Ll95AXxN8b8OhNTBHdEqxQeVL2Cgj+3Vnsw6+Gj5zkFyXzAEsnwTE56p
g/ajWU+k2EOgT01WadKxHnaTPOwOF70E3wyeS1GODVA5Y9Tm4f0GzL9fl3wZ
3ACbJ/LMqtnDYH9dyZhfRgNkx6jP1z0Jg44JVyen6Qb4p1d6SuRFOOyVpvuf
cGyEPWVHH3N8iYDf0TXZSw5NwJhfeXoxLQaSU3e5Tr5oAt0A6cANazHgXuCF
htKbINByQrNE/x1It6tX1081Af+mA4GkqXfgtiGlJ9GhGepECLKeVixsf/aM
x8ThN3gKffTdKxAPi29H6068+A2bvtjemrKPh5qkw6Ha6b/hRwPdpqguHpwr
/onLTf2G/O/K7k9DEqCKZKfM7vAHvt3iSVuV/Aj29/UvZ9q3wEjo2NeIR5/g
mJ16IiWoBb7WemgkTHyC7ZYyhPnnFtCyJPlXXUiB33ocDyiMFvA8+rPnkmYq
aAgXvjG3bQVR7VTyPc404M7bU8dp1QbasfiE9Uw6DCRv2Wju3QZsW3WJxwoZ
UBjNZZHxoQ1u0R6HKt/JAIcng+MX+tsg4fi/51cWMqDFOJIz41I7jBicvMog
Z0HcHBUumHWADOMIYaKRAw9Hl7zT73eA2v2+2/ue5IBp50gNR3gHbHWrU/1U
nwPUstLz6S0dQOUelPG1zgXHl27OHMadsKNYbWIsMg+QAj0l7VQX7NbrvzMo
9Q1u5V0LZNveAyeeE543LYpATu+0OKtiD5z+YSrLF1wEk63qGWs6PbD7vmX9
1vIiuLMs+HvFqgeySNfu3N37He5rFm9dSOoBLLboochZDD6loinj+3thSVQo
na+6BGLq/lQ3afcBj902B6f4H2B5ucS88UwfrOPS8ZwZ/gHbp1OJ+qt90J7Q
PT4gXQHxgj6Cv3z6gPKn9LPE5wpIMVY0q6zqA6d/NRx8uBK+dgSNFRj2w4qU
21LnbDU0jehxJVgOgIK+yM9PF+qACNt1+LHjAIw8E8MinnXAfZzT46LnAPMd
1P8pSqgDlFK6uPH9ALjuX/KJY34HyQ4w4ts7ALJfLs/0PKsHzyXFHzaXBuHU
6RtLW2saYC9V3FvOYgjcF8o17G83g//eeZaccyMQuPfjeNfxdrjvoic7ZDMC
1SEGZ1Y82uEGjji7wW0Elvp0W07mtcNRg0NJzlEjAKvf059KdgDn7aAzB/pH
YPR+64XrbJ3glSoTn3dzFLq+RY6plXXBwz0Xj397NAbylwTDWpV6wUG24lVR
HB003s4ztnEPwsC1AfeYHDps4fb5lbVrEIxjWG66/6CDdXDCCb0jg3BQSFUb
jdIh2g+K7ngNAtvaRwbePQERH84Gla4OQnDD0yM4cwJo+vxDedNDkHHP4G/B
dwb4fFXdR2kcgR1ZtgORDQy4UNAS7j45AqGMJ78e9DOA1+vp437aKNy/UhSn
wU5AkNXI6WtHR0H75D7DgqME/PCL+wP5o9AoLpic/4uAuD79ze5RY7B0xTa1
024SZO4JvZHSpcMl/pm7+c6T8OL6sNZVczqUFd4/9PbhJHQJyfx0uEOHIGH/
FtPASbB8eDpt+R0dpH4lsjWlTEKDzOKFz0t0MDo4ZFxFnwS/XlH2nHcT8HX4
1raPs5Oweujdd7/sCRB7NTf+ZGUSnoxXyYtWTsAYQfY4TJ2CvSkxXV7EBHjE
bU8ukp0CD+HN22RVGZDKd3ktx2YKGuuGTvUXMmB94UjlK8cpWNmTd0OzlgH3
bO1f3rk/BVaLBReOdjJAp/yR9H7/KTitsyZ1dYkB7a5RZ1I+TkF6pJd1uDwB
SHqnaED6FJifbnM4rkFA/O+UEZsvU7Ac7Nv7To8Ax30FD3ZVTgHfU+PtBy8T
QBluT4gdmYLsZarW/FMC7F5ecfScnILcqthXaa8IaNQaV7+8OAW/V6teckQT
EBWxVC9KmYbFDcdi3dMIIB/zjPi3bhpGDIdU3ucRYLPAdb1j4zQ06qR5ny8i
QMlQeCVMahr+Vj7U868lIHwtpvzu3mnIEj+utdZEAEvKrhcmB6ahXmV8ir2d
AKvzaWbKMA003mubI3sIqOFU2Sl0ZBrGSo7cKxkkYH82npzRn4bE4twalzEC
Xlse+dZgPA0MQdeGPAYBK+t+eadbTEP5GvtR72kCLAuMTwVZTYPx2JOx9jnm
+ZxNAsK3p+HsvCzn7CIBbJ/bGt+5TMNG450eD5cJaEiIeCXjPg0KWqr59/4R
8D7GwiTTdxrefxYSGVhl8hcmLqz+YhoMkuzJ+WsEaAf3tZWGTcNmbuHWNeZa
4OmHiJPvp2E1jraawlz3Pbay+J00DSemQv6UMs9nuO0Sv5g5Da+5Daq0mfd7
Oo31Dn+bhkPqJmo7mfEN7T7F2pdOgy5xOugWMz+J63bX/tZMwwqf/96NzPyn
L8pLeTZPwxs6xX3bFAHFptMj3F3T8O/u51F/OgHBp7OSQoamIWTLqebTw0z8
x5xvihDTkNdT8elOLxP/IRW5uIVpsJQRbZ9qY+JXXyL2sMxAYPOrmh+NTPyK
+ek5lBmY+t3AmK1m4t/z8D/gn4GHBlNpLiVM/DuRUoXwDMgKxz7W/8rEL8a2
cEpiBuxrTrS6MN9DH5/PfUuFGTB31ev5Fs7Ey3VUfVxtBsoViEeNgUy8bNyr
/+nMwJGU248OeDLxzT7z8D47A2ZfyCFdVkx8dINDvBYzcDW7PEHUlIlvkJ/9
tdUM8N9d2xrH/M4t/7zyTXSZAYvbW/QfSTHx1Jkc2+c+A2hUWKxOiImnUpj6
1XcGXDG3+2USM/+vkc+rw2Ygp6n8EOpggGPmxdNG72dAedC2xf8HA7Q/bRPs
TJqBsd9rl/gyGNAXGRfK+DYDgiVJ7eVeDMgIvW7qUjoDmXIjonM3GeD5XHoz
y0/med7URVMjBkh4pETyd82AXuwn7XxxBlhezf6gyDILxeI2bLWfJ2C/uYtV
AWUWuAWcU7xfTACbseouXf5ZWB3v33DDcQLeHylINpGYBftIxZjUfRPQJ1OW
cV9nFrafvn5oQzwdMrY/uUM6OQvUjwx7mgcdPEX0lAPOzkJrrdyilBkdJHh/
fom0moWDTzotS6h0uDLVVFTkOwsunur3XK+Nw6X7QSZ5QbNgGiP/z1p9HC6Q
TjA+v5kF3Rvqj4IExsFYqGRLdOIsPD3ud/xp/hgcVU13flAxC49Yy3ZKcI6B
nMez3Qcpc1BzvX/qgfMIyHDrlezjmwNhn17LFjQCUiHk89Kb5uBWq/jV69wj
IB7n+mTTrjmwsXjfKvF2GAQrb/TNH5mDFmHx3nWZQ7DIp/sm8wlz/6XWg4H8
AZgNY92b/HwOpGUbrV/eH4ApiYKy96/nQO2QyVm3AwMwpqg48yJhDuZqzj6Y
T+2HTlMJffsfc5C2aUds/Ms+KI5ZJe3hnAf+eVPrDLUeCJDPvR3vMw8V2x69
XmD9DVX7/ww5Bc5Daq7GjQnDZqAoLZgfDp2HMAXLhaz3TeCleuDEQNw8RF8x
MK3SbARX7dxdEmXzwEGiDzy9wdS1Rrm9kaQFoJe5idpvKYMjd3PPvHJfgEJT
tJnDNgJ73f9TddV3AbqK9MLv+n7AxW4LWopBC5CeqF7b2JWENT0OyDdGL0D3
Y4n4C1WZWNk/l8qPFyCp9arzoyNFeEdEblnAvwV49vT6Z/3NPzFbUe4Br/uL
gK1RuahqO06iCcT/81wE6tzKOSG+DmxodnO9y9NFEEW5i8JDHTh2XnzqRsQi
lHCpPBF43oV19vgnGRQugkGAoO3z0R7sE35h6xa2v2AskOcryjOA5UZynr7k
/gu+YvmsbrYD+LcS/xJN8C9k3v1FG6wawFL1Zb9ZdvwFDfvxqC8+g7iCc2/Q
0OG/ILbO09tvaghzO7GSMvz+ghan2lxkwCjOKDZzkA3+C9fOHnvV3zqKz/Pl
dH8I/wubal5LZkiO4eRkm/zXyX/hw8GQ+5V5Y/hEX6PTg59/YTLV6e+/6nE8
u1duYL75LzBETSmJVDqOeOBraN/1F0YXfnmGH6fjiU0ae68Qf2FD6X0Z1VI6
DjSIHznKvwS6v/jQ4+gJrBzJYlIsvATXIx9YhNZP4K6x82VqEkvQFRaplcXK
wHt91r2XU1gCzXU6VdNmDNzSeIMvUW0JyheudJF9GNh9W+nDbTpLwCBCQsmp
DFyXf9ds/dkliDZ4W5u2wMB3uRsrn5kvQWzfG1cDYQKLm+5R4bRagvqsfdJF
KgSuiHsS7263BN1Td/avnCWw/Uzv+iXnJdgiNLDunz2BN2mpP/7v0RJ4KoSb
5vsRuCgwdIr+ZAnydJ1KFGIIbN0xedEqaAn+M9PaZZ5FYH6Z47Xdb5YAeQ+6
7y8n8BBnNH9FzBL0/fWOyG0i8NfBaaO0xCVYDFr4K9tL4Oclum/epDHxvznA
/XScwFffhbe75y3Bn6Bws7oZAqs+YojeKFoCemNc+MJfAvOaa1uerliC8wOj
wSv/CNx/MDROtW4Jhk517m1fI3DeprGRbS1LkCWQ9+A5c/1sXmM3d88SVOgb
JAkx/2/Z9OL29PASNFyeYrdZJLByxmBGG7EEyyLaZL8pAvMEqc4XLyyBr/BG
jdsjBO659Uw1eW0JBihGt4Q7CZx1vNcthHMZwgbLXbx+EdhPWqnIdd0yeI2S
rFIwgS04/UhXNy7Dz91aN16kEFhhsEP3hNgyONfta98TRmBKiby/otQyzIb2
aLp7ErgzxuunyN5lsKjx0/K5QeCMhy187AeW4fXFO9809An85MJuownNZQin
VqV9kCfwhYPur5t1l0Hhrp3hFz4Cs89LicYbL8Oe/mbtwUoGbmt0vRxosQzo
tHvb3/cMnJr+64Oz1TIUbppIz7nHwKa3XGSPOC8DNcO1TFKcgfccr7bb+3AZ
Dm/Trv9NTGA2abGMjT7L0EJKKthTMIE/DZSrjLxaBomSC7w/T01gj+LNbnWR
y/Dk7eU+oY0T2DjGDufFLUPsoVUX9nY6ZrmwQdcvexlkz70X6zCj42ZVGz+H
gmV4YBZ2rmwTHSdtLKw5V7YMt686xJ9rHMdnGq+dkWleBrc3ushfaxzvSv8S
KtC5DJlXSF4yc2N4JZDWtjTAvJ//VuWD+DEcfyz7UvXsMrCMWbUfYRvDS9/J
djfXr0CNibLU96gR/CvaNN1IZAWOH+zt1kcj+MODT7PqO1bgRSZpOql7GOur
GrnSFFfAKmmdX8/GYfwuLdY39cwK3HGqTq6zG8RHo7VjJ4NXYObZmSPC+b34
SUVdp+fbFQgjpEM89/fi8imLTUIfVkC+IGywIb4HH9ZxfaaavQKHtdKeJgt0
Y+3RTBfPPyswdl801MauDasrSJ5YL/IPhh/pn5HzqsPyPzjnDsT9A+1ORVf+
1ky4Pflqb1XKP1i9xVfz+NwXSBXeYXMh5x8Yh4TdEWkrhD03Ubf7j3+Q/2PD
DS96Kcjw36usHP0HqofsGuU7f8EOs7FIM7lVONmt55MU3gZXvO62TCivwmOu
q++lh9rhfQqHoDuswliBUfIvuU7YxrLd98OpVZg5KabxK6cbROPMHCccV+HK
rgAspd8HG4ka3Ue5q0Deea3EvXII3rzAl0fxKqjnW3uUHBuGTYoZbmcqVmH4
TvIJpUrm+t7rDKnWVVAcqi7WLxiBN1v8f77oXQUZSc8j1ftHQbjQbWR5dBU2
qD54JR43CptJlqJ1S6sgYWlSxuo+BuFxRqoHSWswX2Nge3VkDLYcPWL0gWcN
hH6a2J48OQ4iz3b73xVZg7JmE+0rTH0QsVcsrm/HGoyq8Z2+YUWHrQ38RSf2
rMHlatH9ifl0EN24MCeuuQZn9DLbfcwnIOrLKN9T3TVgi+tuZ0tk+psLHbJz
+mvQoeS/054xATGrtboXTdbA2aBnrECeAeLvvl+uvLgGRsd217bbMSDmUJab
gjXz/EOtyS+JDNg2FP860n4NVrIHiaNdDHjvG5bBeW8N+PYdIO6tY+pB2YCf
Dh5rUKvM+0ZTnanffj4cafdbAwm9c+J+VwnYbu9A0g1eg6czjvonfAn4IHBV
NC18Dc4p2T9wTSBgR7ax6ubYNXB4ZPWOu5i5b6Jn5JW8Bj2qiccZfwiQXFK7
zchcA63v86lbRpn+KELO3zR/DeQrEmN9mfp6J2yLKy5dgwFyabIsU5/H9woW
7f65BjfXcS0sM/X8Ti+O9tDmNbA+PWk19f/9nX/nWLrWoGkgNJi8QIBU5Tif
7dAaaKiHV8mNE5Bo2yXbzFiDL7a9IjZMvb2Lt14XFtZg37ChaXopcz+t5PLH
tTUg+TrxsSQR8FLarJCLzIJiPy7HGPoT0HS/qVqTwoIaZQ7si79GwPqak63/
UVkQVcwpd1GNAKOtP4YS+VjQriVYOUoj4JUdmu1cz4K41nwiQ1sZ8Bt/YRUU
ZkGMvI/8fTEM2MCvsO7oVhbUftgqafcVBoRmSspkSLIg3RaNsYqWCfhNjj4w
LM2Cih+bh24LmIANxpsOi8ixoHOrIs5PDk7A60XuSz7KLMiqMbUk2JcOLXpe
t74dZEF7i5uddXfRYdPbf/cnNVmQhYwofXvJOLzRmHx1/ggLMrnhP+o5NgYt
gTdinx9nQZ4/khQ3u4zBpp6+tFIDFsTz8r8qjrVRCPNsrpYzZUFHJH3ahFhH
IfzHV1bSDRbUG/Yo8NuvIZjsSbtH3GRBb06eCJnXHoIjS/FT7fYsKFm/mfNV
xiDM7g7pzbrLggYEjuegJwOgH2z73cqXef/cXPd5Sh+wmYt4VCWwoLbc9eWm
iy1g6izwNyeZBQXMXnZQe/gHPj+nOMR+ZkF1zWuCn9aa4ULx7CW3XBYU93C1
eON8A+RI/URyP1iQyvNDpmt2lWA7/YAleIgFsRSKfy86aoeLee7cfTjGgshR
D4S8BKLwJkmbSRsGC3p25W6Gz75PuNzEuOfQPDOf4BbObq1vWLxArmiOnRVd
3aAinfOtCjc96X50TpIVUT9ceH1+cxuWede8cFiauZ5nKdONbcceX6tv79/D
itbO68ZOS3ViuYncizxKrOhkSFd2Mn8P9jUMggIdVtRpKiTPNtGHu2x9cj8e
ZUVRdUlO+hH9WMnbbW/oCVY0wro/7MTRAdyXay1224gVSdpICtS8GsTqW7XW
xK+yIgl/gpfONoKPXmhytLRmRWI36g6NRo9go7fXh2JvsqIzfmLrsg6MYlvh
wJ87nVgRT3jkQR6TMexsuk3L+h4r2npISFG3awx7vs7K+viAFRUF+PN9ujiO
w4Xa3+72YUV6zj4XL52i43gju3V2/qyIc5P3/WuYjjNCWB9/DmRFZ09w9rPt
msCFDS/nJ4NZ0X8jkS0b/CdwJf8um/2vWdHhy3c73AcncNOpb53/vWVF56dq
C7YdZOCe5/qns6NZkctHqfj2JwxMr+0tnY9lRdkKjpLBtQy8SHNSUUlkRfvY
5zVkeAlMPkn5dO8TK4pJ5bX31yUwX8BbsW9prGjPTHpZuAuBRarlQlayWNEz
nW+dOu8ILMVdzKH5hRVZqC3O/1dC4P16Z+8/KmBF4ZFTS+u7CKzpOzJR9J0V
7X5003cDUw8d++F6ma2cFV3giP5nvUJgY451zYeq/l+/9Z6rTH1lefj9Ue9a
VjSvq8ZXvUxgOy+l/PIGVnRr3duHpQSB75dU7KX8YUWv+ZJ8+9oJ7M12IVav
nRU9/aj1R7SIwEFaxIan3azIgCeZ4hRB4Ah3T/+aflZ0zhvl9TH1ZyIWWqWN
sKKA6Sjv6xpM/bWa6GBAZ0XRM5Zb2NmYelRDfTBokhVNpt1SwoUMXOP2y7Rh
lhV9HPsU//Y/pl7+Zlkj+JcVuclZWrxn6p3+pTk4+48V+WwZvNlZNoEZqn6Z
oaxs6NznDs5zVybw0l0RqRZ2NqSROv5s+186FljQ5jXjZUMeln+yRml0LKr8
2yNCgA3p3ZxZpD4bxzJON+Y6N7ChwKVhh1ryONaaed5xSYwNVRY52YV0jeIT
+7efer+dDe20kN1Zh0axqUNOSb8UGzr0ReLe1ogRbE90JFnJs6GG9AzrO5rD
2E3OXjRRkQ11x/z+VOE9hH1vkYJHVdjQSbpgU3H5II4el753U4sN0YOORZ1V
HsC1w85HHA3ZkPOf4Mvb63tw207ub5nGbOjzJ6HUp83dePBapNzceTZEVWYR
PLjWiVf6S4TuXmFDfaknHn860IZle/gGHtxhQzqTlx/EHGvA+sPixc53mfGO
nbPru1yH7RnyMbfd2JDYJ4eKoJEanLVy6sJlLzZkufOredKmMqwu/KJJ5yUb
GtqjQsRkf8AnDPnLeLLYUEvk1IephSqwO7ctlpzHho631se3E7UQdGmfx79v
bIhf/uq/LPt6aLI7rUGUsKFhq0TF18bMfvX0RXZDIxtKHJX//WWgAx4Gvwup
/sPMP+5ow+m8LogJS3cobWdDXenmvzW0e2AgoX5PTj8bchRKEFVh64Obpfzx
YTNsaM5wqe/osUEIrN7mFbzAhrTCaDsU1w1BWsM+y6fLbMhI+ftxq9ohmO05
LfqAREK3+K03pR0cgQ0jl1ecOEnI8uK6/WeGR0CFcGiz4yGh+jd/dYyejYLb
vxehlwRJ6I3vV6fQ0jGIIr+/c24jCaUfjHxkd3YcingyDA23kFDFY4ZnQ9c4
9AkUyx8XIyEWkSXZ4Et0IG9u4NXZTkLrLKP/Pmyjw85tfXR1KRKaN3U7dfPE
BBzdNV2lJEtCN8kVz/bmTIDNXraPcntJqDCmSThmIwMClAWeSCmQUIbs/vuv
7RmQqiFxTfwACe1NuXFlqogBdTr7DwmrkVBVsl7VUwoB08e1twkACXGo5M/q
HmHO3zOGa9yHSOj9sqg/+wMClM9bdpKOkNDzQqHYTx8JML3s+G3lGAkZt/9q
2f6TgPvWnmFz+iT0ZeeXM2eHCYi4HezCMCSh/R2BrXsWCSh0fn922JiEtPfV
t0Uw9UXPgwyFnvPMeIf9H71k6gs272L+VgsSMlO5ksk1zdQ3AQ1EvSUJ2Rqx
7JvtIEA3pO9nlRUJpWhHBugXEmAdPp1cYkNCAff6NDaEEuD/js0/346ENHZM
JB5n6qeURAHrbEcSOjDjuXN6FwFezViL5EJCMQdpAj2dDLjAdmvLaVcSUmwa
9Uh8wgCFvZvnoh6REDV8XZrZTgZwX/hRS39MQitOkTy8Xyeg1/dO4kFfZn1p
6zVbtCcgL3ubp28ACX31WpH7U0QHq3VuSjtekdC7++tkVyLGmbpIep1jGAlZ
yEYcdlgeg/U3fo/gSOb+sLjqF4MxKCmWjzCLJ6E4jRtHA9tGIJzodPqYxMQX
YSQZwD8CjiJPDRZSSUhS7NhxTRgGcedBtpBcEhq1khOsfTQIC++DO3q+kVDQ
8wckjZABqP0FOXJFJHRYqirPM6ofHkiH36iqICEn6V3PuyN7oa1Dv461jYRy
tijffBbSBi8P5UXar5CQ8B7/J/WeBWBrf82lkIWMTML3/qy8lwnakQKnqexk
5CicZnax8j1Mzd8kJ9LISKb6WJ97ZhzWT9pm2y1KRsJdv9tzwyux5J9anT3b
ySi2uWz1Y2gtXiG5ibpKkdEitX2HaGk9Tjb/Xb9BnoxGRLlfz7z7jSn8T1X0
tcjIekh4LXKqG3drqAhEHCaj1992Kz1Z34tzbAbHR/XI6KcWH3+AdB++VgrR
3oZk5NE53OyjMYDVp+h3G43JqNXkfPwTtUG8XjTccJsZGb18UXV1XH4IF7vM
shdcIaOv46lbeVlGcNiHd93c1mQU/OcqidHC7Kf1+l9Mb5JRgdil7f8ljOKj
q8vB8fZk5PVLL0XZdgyLyX68OXuHjE4qtWY3bx/H8ybGutr3yOiKaI/dVN04
rvUiiQc9IKPaDmSx15GO49LT/nZ6kJF3U2qIKucEdusyb5T1IaNonc2dhc8n
8OwRjchr/mT06rbb9lNcDHwzXeR6dCAZme+u1jnkzMADm1fkW4PJiLbrbsu5
3wxs5tW+JPCajByuNwWdlyZww8TX0hNvyWjdJbUr/LeZ89YkPNAnmoxCXaxT
DRIIXFx0z7QolowkP3dY0OsJfFDmnMRSAhldSz7IX8ogmHpDha7wiYz2lj7a
/+UfgWX+bcy5lUZGeYasolmrBH5vtfAoIYuMtvBuUI1lzvPNdb/1evPI6ObU
GarrbwIHq+YIbikgI6We4+eVUwjMHfuq0+g7GZVSUhR+OxHYk+qUEFhGRk2d
XymW8gT+62TkUFFJRgq2rHnDHQxs362gxlZLRgPFiuGurgw8clSQXb2BjAKP
ST9VoTLwpYzpWqffTL4qGwlg8tWypeHN5zYy2qSl9eULeQKf8k63HO0iI8Fa
l6tNN+m4ghG0e3s/GUWJKiyU/hjHed8NikLHyUg/qtBWhKnP5GX3+tcRZGS2
5fhXWsAoTnzJa8Q9y+TDJubTaNYIfn395/CDFTJKS2wZ+9Y/hHnrP6XnsrAj
b238025sEPscDHCdIrOj11uDjnkPDWBn2vF112jsqLQr/erroj7McJZpjeJn
R/KkDp2H0b3YqocrtkWIHTH2/ZuKcurBxpkVyidE2ZH4dhltDcEOrHRO10Jh
Lzs6l6HkpFhUj2c/aKWwnmZHpNMq0SYP0uEm7zYXtbPs6LvzRpmKzHwYcGHR
cjrHjnj37slUmiyBxmO4aeQyO+J33L3Yx/YLMibVV345sqM3QpOKZSptIHNe
pJzLhR2526ocvlHdAe9Llp8fcmVH7IPChM2pbggO/bo99zE7GrlnHsO/oQ8c
1FWOR71kR7/ytRyXPIeAxe7lo+dv2JGU1tsTHxyHITB6MtM9gh3J6TS2spmO
gEj9iRGHGHZ0P6Rb9j3TryexfRS58oEd7TE66SzANgYqiuynjRLZEfWY2smR
sjEov3bZ+/AndtTgQOnPf8CcbxXCDKksdhROGgnp/kEH+yUnCeE8dqRQqKR1
79wErMo2GHPns6PCJELrY+cEBJjLPV3G7Mgsjji83YgBW577Y3oJO+LMdhuL
yWdAUtHQTOcPdrR7k8B47wYCVKa1d/2qZkdl7WUGnywJKN8efaHoFzuKt5AL
q4lm+sezy0Hpjewo6k/8qFAtAX0+JmXv/7CjLNwoazlBgH1e5t+Qdnak1nlU
OZg5j1ZH18l5d7Oj8zEK9GerBARsuWnp3M+Oqp5MnNeZJGDzyYrQ68Ps6MUl
s6bkBqa/fbij2nScHR24ssZeHMecl2nua3oEO+J2iqMG3CCgrLdDQW2GHV3a
Hey1QZSZj6Cq9e4FJh/vRUOdShjQp/MqYusyO+qN+LRaeo4B9s5Tdbxr7Gjr
rh6hXb1MfhJOsrOQONB5a9qvSiZfAa0fVac4OJCIQHVORwkdNvNw2PVxcyDu
n2/p4WJ0ULYr/F0qwIGkpU3NpVLGoDR6M0/OBg4kb6x6+Hn3KBjWO0PCZg50
/Zr1p2byKNgp7k30k+BAqvqlFh7Sw7By7WnH/Z0ciOOh1OIX6SHwfz3Md1OG
A1EOUa+6iA5CwlL0Pf39HCgkW+mxw3AfKO9eSQFlDrTNfzE4J78XSs1N++QP
cqDW9VOlQb490FPEd1xQmwNd+kDgFGoHbHriIdJymomn5s1lKZN6iM/rPFV5
lolHJ5uXbctPUBxT9f56jgPFJUh1vHf+AadOTk9EXOZAemzWareoeeAneAVf
duBAlsG8+0+fyMGbDuMZQycONNbCknWYKMLxzlt26dzjQPs+yq7apZfj4tbG
oJ0eHCgt67o74q7HS9E6luNBHEh57i9L1Fo71lzQCN73igNJ7lsJGWrqwh76
B4pdwjhQ5cDZ+prqHkz5Jy1Bfs+BGj5qOEza9ePjRtsNj8VzoGt82oVE6gAO
TBbxDEriQLUnM5bW9Q1iofPr+kQyOdAt15DMK6Ij2DSdInAllwNZUfLc2XaO
4ggKm/bHbxyoRm7L+vCtY7j74rIDgTnQxvd13U5MfyCRO/tOqZSJ30Fyw3jr
OLbiZdS7VnCgwy96lc5F0vHHa8OsxTUcqM3V7IWM/gSm5/fso9RzoJIvY7+a
xiew/Pq2y/rNHOjD+JEbrU4M/J9t44uXrRxo8z7bzeXjDJxTXPO9rZMDaRm7
nVE6SeAl4fIp8T4OtCJqG1UbRmANB7zt+hAHum1a+U+XOU/cK/JOp4wx8ZG8
Dl2eIXCpWIbHDIMD/ZoRuchg+jtOl+R01RkO5BvJHftznjmfaj/0Plpgvr+3
IywTfwgcKBnFX77MgTrv7lLXiyVwvdtrLSoLJ8puXhBgmBJ4fVOQgyGZEy0n
bDCfX2RgU1n/d28onKg6yEI84DEDv/V8XN9F5USRL4vDRxYncFerG6skPyc6
r/tKy+jcBJbY57zPVogTfb47lr0zjo6v+d6+nC7MiW7WT6aUd4zjxG7rFwtb
OVGKpFTjR5ZxTFe2/K4hwYkkjc+9MuIfw46DRtuqZDhRa+KN/WbLwzhHXf80
315OFJvgEMb5ewj/DTniYazAia4cGqaKxAxid+2DvX1qnEi7NPdmBns/LglT
4JdGnGjM08CH8b4Xc0zt1rqtw4ksT3NycCj04GfRYu+WT3Ait2tHe5wutuHw
FfLl9Rac6PsId6PhQBXuOrMadN6SEzX+x/UAy5TibckLRTFWnKjlkIRAF/6K
E8+Nie+5zYl4m72qzltfg+ycXz2H3TnRUbXX99szqmGRVskX4MWJ4gTr1mUq
1oP6tWLU4MuJzsiMEnpeTVAsmB1j8YITrQVFlx6eb4M6+/BLLu850cjxqIeb
7PtBJohv+U48M75F3GBW9gA8/uzzyjGJEx2RvCg5PDEIHbUre+1TOVGS5mNa
3cZhUGY4Vt3KYObfmhb1Zv8IBNFGr9rmcKJ15B9pjhqjMLb74pr1V07E1Sv4
KuzAGOicaA6zKuREJvtbMw3FxyHS9rji1WJmPavidjDmx2He/3vt5XJOFMXD
rvXjKx1OJR24cbGKE4l5cu47bDsBSZUpJPNaTsTOLePQzskA8uj2qPMNnIgn
dvtp7iAGWFDCVUx/cyJ3dUnbiyQCcqX4Gs+2cSKPE5sFnS8TwHfE59aZLk70
etqtYIHpX2ysVjhP9zHfV56ReQTTX5R6O77XH+JEZYXLeTJ/CdgaN6J+YowZ
b//x7LtMv+JcavFHj8GJOm83h9oSBNT1NzkcmeZE8+xtKosVBMiQjlMPz3Oi
3UtxqtsDmH5D4nu89hInstIXFmFVJaBL64AWWuVE9Df8Fjm/GHDgckq7BhsF
XSx0f+xyigFB7tud1TgoKMpiVcjv2wSMRYfxqXJTkNzZpDfAPwE6eF2yMi8F
XSvWtF87TYeoLu/DigIUJHldBas/HIfFf8vd+zZQUEE6Wdk1dAxOb3W8v3cz
BfHH7vlz8u0okC9YfJaRoKCrxcaeureGwcK1SW/XTgqaOF9wo0NtCHLDjw1I
ylDQepq07eDfAbBpVRbetp+Cavtev/xxpA/qjdc93qhNQc+fTqp5Pm0BGWfv
rUK6FETSnqtnPdsMXq+WcwWOUZDJ93yNGFoDqDQN02mGFKSkpWL4Mrkcok4X
GZMtKYj3vu2fheJYvGivPMVqRUEvuOzZbxbnYsOgT0/XbjDxcWtfn60qxuy/
3hQtOVCQX8VQWfDBOmzB4DVbdKIglsLEfU9eNeI8mvfc3D0KwgEVf9/0/cY3
TzjITHlQkE1wLXfJ0U5cbjtcyvCmIJrDMeKqXA8We2p+ke5HQSlW2e+vf+rF
DZV6L4dfUNAj/tR/7x8N4N2jWG7wFRPvNdugZw1M/UdRruwLo6CenG71zvXD
WPWIxGrnOwpSLO4Q9L4yihVjq3x/xDHz613o67Yew3JrjoLpHykov2rDjN/5
cbzLbEtUeAoFbT51KzHvAJ3Zz0t2eaVT0AhFvvHzGh2LCN7MvJVNQVnSS5eK
0yfwhtvrNU2+UFCbwUXymZMMzFedX4EKKCj3EVtDUz0D80hdOyPznYI8TV40
VGsyJ8VjWpdgGQUJtVD8foYQmKU72/pfBQVpS6bd9Khj9vODFjNDNRR0QkHD
+N0sgWdDOR7W1VGQ5pPo7r/Mfs2YTqV8baKg5Mm5bJtpAo/om4TEtlBQhKNG
51A1gfuS1rY+66Cg67anB+8EELiTIzHRuYeCvKy71+1VJHCL5SmFSwMU1D65
bHWohIEbChcL9EaY53v5SmdUGbhm87ujCnQKisWj5a/eTOByZ71GkUkKYgSk
5gd303FRw5Q5xywFmWskOV9fR8df5cJHiAUKultTzvdh1zjO8tf+r3WZeb9M
TsK47Bj+PDT2r3iNgnal1azOCI/iJO0Q308kLuTpHC3kPTOMP0SpCYZyciHt
Xp+Uu1+G8BvjgF031nEh4bDgnkO8Azg4QzHTUJAL3b517K1EdB8O4O3UUN/I
hXYckc2yF+/FHuV7zqwT40KBrCukLdPt2E3id+eiBBey3raslRLXgp0fPrTu
28mFPvwc0yDrNGMb5V8PsuW4UOKnPFz1ugafibdPNNPkQhtGrqgnFl4BfTZh
hcPaXGh88/v2VcdUOGrxvUBOlwsxCPPK5poCUN8g0Miqz4UyeGy+EkY/QdIn
81+CORdypynLcNzvAPE+M98Xl7nQoIOF59lv3bBZkyzoeo0L9R0QxCcdeoF3
3miX/i0u9Njm15Zl2wGgGP7LOODAhVbacmlmdYPAlhqnsc2JCxmxhM1fkRiG
hWvzhrNuXOhO7rqkT/6jMP09qrPTnQu9Gki7kB41BvStR6x/eHGhqBQR3vG3
4zB0j5hO82XiD3pHtvagQ0/z6wfhAVzIfOppr57+BLTtQxSvIC7ELSXxvJyV
AU3PRoJvveRCiv2bxaTfMqB2NGiryRsuZCD/4k2DMAGVh1UTUQQXarnqlXXw
AQF3fzyUexTDhXaW5nblVxKwS680q+ADF9IRPRGuPEfAnyoutZVELiS/ixp8
jtl/fU4YfD+YwoX21G1iXRpm6uval0fupXMh5ate+9Z9JmDQoO1nbjaTv4K+
35lGBLysFzOa/8KFArxHD+1sZYDOmWttioVc6LPRpfsV6gyYbUq69F8xF7oa
Vb5e3H0CYo0nh9LLudD8ojrX71g6GLYo3ZqsYvK7x/pwTuI4sJ13nZH7xcz3
rtz2z8/HIKO96N6tRub9Oudz6s6NwmVzDpZPf7jQrPW5meOUESi69IIq3cPk
o/qQa/rGQbDv+x18fYALuex7aPLGtR/ErooIx49woQXtjbq/Knvh4fUEye1T
XOjBu6HUBNMOULcr0NzKxo26Newd+EiVQCfYysw4uBH3p/8Cc7OL4K3D0ePh
3Nzoj/MRi6PxabB0p9FkoyA3+hyhoKEgnI5zXUft+Xdwoy9b1Mev/2nCVv/k
Fgx2caN1frrB7b9a8IZHdx4E7uZGrqfWaz5J6cB3PNf8eJS4kQ2n8j1jUh/e
QT7Md0yVGxnYFO4rye/Hjd7+ob4a3CihTSNY/tIg3u8nFMuuy402i8vcPGE+
gvu4zaR1jnGjwOoM4lzmKH4REPPZU58b8fhsa5ehj2HEO6T03ZAbmZu981Dh
oOPJ57L5a8bcaL1v6vOtLBM4ht9BW9OMG2nP2/x93TKBDUJyKtwuciMT79ZS
/0AGXl2/ov/tCjdSZDNPWRMncGqoVvPf69zo373lyF3PCWyx6YmZyk1udFqQ
l+VyC4Fp4TW9zvbc6FG2fIfcCoHztwhYZ9/hRqXn/6s+tETgm5EmjJm73Mjr
D0vugwYCi4hF3tn/gBlvJvbqsBeBq2P6luw9uFFXbnVtHj+B70vs8vjszY0G
3o/pmtxjYJkPtzgZftyImqN3+Wz+BG6TzHy2O5CJbyrho2M7HfslLAraBnOj
9LNI/O2fcawirRn+MZQbPesQfDSUPoZHkh6Lj4RzI1OfsCOvbUfx692V8Tuj
udHt++phwhwjWDeVd8+1WG7UUWFcz/p4CMelh6n2JXOjqTatsfWy/dhm2Uym
5TM3qr5dc2foXi+WPyy6pTaTG6lryHwXt+3G+S3vV75840YpYWPHouf+4Ma1
ZPyimhuxXAx8bpKA8Rs9u7Qnv7jR2ewQzsItqdgiRP7dg0Ymn5nDM320+zC2
M9vzRjs3ip7MP1V+/zuw6hce1hpn1vPqJdXT3S1Q/tpd+QDBjcQVu7Q2pndA
QK+21J4ZbrRp7wD/lv09sMnpB0V4mRvNSD1S7k3th65Cv7+8a8z6BrEcWK8/
CB8oJ8bIJB4k7mrFNdU8BHsj6qonuXnQLVVx4+A3ozA7GJw/xMuDPodRFXnr
xuDr3rMpHQI8yNnVuCF+dBzc722MatjAgzbePnmWNEAH3ZLWwIrNPKigWeY6
vWACqLSIR4WiPOiQemnPSWcGNBhb2GdJ8KCAF5v0VagEvIkRv5y0kwcJJbuf
6HtIgPlY3+kYGWY+EvZFH38SIKEYpx0qx4McD7X3rF8kYOTBdYWA/Txot53H
hsZ/BKT+kN7hqcyDxjN8Uwq6CLjDT19/9yAPiojiNG0JJ+CgWSq7nSYP+i/9
hPvp/QSwxNnPX9HmQck9wzc84xhQztg/fE6XB/HdSRcnZifgqcrcH4NjPOid
hbaS7rYJOOWZW3FYnwcpRQboXpKlw4aae1/UDHnQ7NwDU1g/Dh1C6kn7jHlQ
uEXTAq1zFN5fXA2XOs+Dmmh+sqJPRsD6Y9HTrRY8aOKNk+KI4DDIzXi6CVry
oEp+IREu70H44sNpsXaDB2nM0z44bOmDh3WV+nO3eNARc6HMtzo9oLM5AMYd
eJBwcn7218wOqEvh2/bnHg8SEOYuOhLbBMNNwgOpfjxIRz6lwSUqGT6JdjR9
eMasl77of1nGgdjROqos/AUPuhlGrjC/lo1XlyUSfMJ4UFnc5im+7TVYaPtu
G4uPPKhP6Gx9z5suHBT81PhjCrOeLAo7N1v0Ym62ce3ZdB5kkJwfqWzSj70d
ju2FHB7kYvKbpU5xELP0ftzi/5UHKYcWiayfHcKup7gozYU8yNJW5qdp8Aie
x9azYiU8SH7jBiROG8MOeyt6bH4w78OjpK2WTP8XJfUzu5oHvYkdaFF6TsfX
eZ98YanjQfeyHcAveAL3PRiKO97EgwxzthTY2zCw+cTh4NAWHmS7W6PhsRBT
/1yIe9jbwaw/DIeHBxP4TA3ZdncvD2J7MihU10PgWrWrJi6DzPj+qjQvpt7S
Sy45VDzKg0oqh95eYDD98+bt8jQGD3qF7U4eSSEw+HuKmE4z+REab7ynTuCv
f3spsfM8KM7smKFjBAMr3dCam1jiQeQddSoLPydwWktMr8oaD1rf/DZjQwMd
yx5lqX1MoiLtxJhYyaRxHJ978WstJxW9vbfjQKHJGN4mheOFqVS0e5PfWkHH
CI4IFQ25ykdFj0saEw+pDeONHA8ffV5PRTzmG9Enp0Ec7NRpu7SJiljvhAoE
BfZjX6MInaBtVHSN5ceX+7VdmFS6LN8uSUWCmaOabufb8EMFs607ZagoWc0+
HfKb8R2BzfPf9lORycPMif6DFZjwuNfHcYCKQq6IamWl5mObqZba02pUpLM1
jHTlxjt8qe51wvAhKlIv4pTmMMPQDgsh+49S0TpP8XU/31SC8Wdj9wcnqKgy
YG+Cwed6OBEodE7wLBW5tafqVW5thx//7hy2OEdFOT7XO8TCu0H7VtO+j+bM
tWFW6+fpXijoUBCdvUxFl7vH92iu9IPKiRBusKIi690NLheGBiHz2/S8nw0V
+R2NqWtNYX4vsob9TXZUNGdx6UaewSgkhqf/EvuPii7anW/YXzkG27n5821c
qKhctH62aCPTj92zT8x2paJBoiNbRHUCNo3+esniTkUKbDGqurIMCDHd63Hc
i8nPYb/CJ3QG8FYE3gr1paJMvzHKPVcC/A4wzvUGUJHopu8mbH8IICec1N39
gop6rqt1WKwS8GhDyn6XV0y8pyBVdIqAJW+qWHEYFTGm/6rsYuofpzlbHloU
Fckhoy1fVAiYvFq9YPKeirhcSPesAhlg2yQz8D6eik60NXwRSZ+AoUP+dRNJ
VJQ4nJ4t+p4OlzNH81U+U5ExF+dJ8hVmf5HQ+/g4k4omg4tu5c2Ngklw4qva
XCoSP/rWx/nCCDSwUjyF86ko6e962x9hQ8BICbM4VURFju0zhkVfBoDrvKza
k1IqKli07bPP7QOUoT87W0NFZqVHQ5OZ8yLV8pVVXScVfc65XzRuWQxVvFKH
OPuoaDr/QOe+k2kw+DVPTHOIijb+cDT7vu8F0y91tCQzqMjiXE/x0qdy/LRE
4viTNSrirVsb+VHRheNvZ0kVkmjo4dj5pITIXly8RZc8x0lDvz039zd+6cdd
P/70yFJpSOlM06B69iBe+u9GgSUfDUW1GJ28ETCMN4gvh4Wtp6GZsz8ubFIf
xftqApzrNtFQjHoK6ej3MXzirugZzq00VOFb6H1QmI6td6Tt1dxGQ23l37+5
ak1grzotqpMkDfHMzfYNHmDgaLfGkWRpGnr2HKbilhj4665rZX17aMhus/A1
8CXw76b5d8L7mecjmn2fdxN42t334SllGtL83LutjtkvaHs2mz05SEMFNZe8
w0YIvKs1+UChJg1d0Q6jDoQRWMdbY/2cNg39HIweoKwn8KV9vyZlj9DQc7FK
pWITBnbtvPTT8jgN+Qs9jpGxmsChftMfwwxo6ILQVd58RMcZSl4+dWdoiK/V
6s/J0TFc2yt0hdOUhr53eagLWI7i0WcJoHmBhuRy/qmGpAxj8kFVEadLNLSp
VDI7tXYQiw9VLSZfpaExHUnu4Ip+rB58obnPmoa0twixZEf1YhNNRrrwLRri
r/tjlPixCweG8ts+caKh5hMqAyZ9TXhF17TT0oeGQFlz/OEmG9g0M/olzJ+G
7gksl4mdyQGFaNfQukBm/tFnbge2loHNQpSB5msaOnz3ufv6C83gEyu/2+kt
DRnf/ycjf6kN3hkUUz5F05A+j8mO/5S6oSVh8LtwIg0lLvxK/bNxAGbPuESd
+kRDi8T4ic5tQ7COhcv1SRoNxUkeWntDGgGZT+EmhVk0dFTa/8XNL6Oga7pb
cS6PhnyOUzU4mF3eklzIt7uAhs4r33C8/pIOD9MMJiy/01BhafSm8cwJCL/Q
WxlWxsTzbVzheAQDsin/xddV0hCnwfhw3HEChtw8Jgp/0pB4avWy+1cCNk09
V0ypp6GN9JGKMKbfOXYtyvVtMw2Fm+u4Wa0Q4Nb6qdivlYYqbaqfZtQy9cbJ
b1x3O2lon1xRUvRNAnq+V56y6qUhIwmDffG/GSCg3PLaaJCGkC517iWN6XeS
hrq0R2noUdJSUJDABDiLzknum6AhyZLPIgLD45AYTLolNsWsf+aGM4MBY9DG
IZBFm6Ohi/+dlNnJMQo8ruLLy4s0VJ1L7dY4OwzqhJz22AoNHSezuXS7DYLd
FQ2/FhZedJlyt5Dk3g8Nx89vzKbwovqvG5unjncBucjaIpbKi/7T7Slti24F
ZUWXuBd8vMhHKbsF/WiCcJGXCnabeJH/pJ2fjGUZXJ74aSC1ixeFuq9/VqBe
ioMvd4QK7eZF1mpmfyU9anFp81gnSZ4XbdqgyEPXa8K7Cjlv9hzgRSnHN9QA
0YnP79+QWavGi45opffLavTigPgdS/nAi2r9dGKcr/XjyUAt37AjvGjXf9vb
pAyGsQTp1K8nx3nRHw2+875co9jIxWKDswEvejMSmpn4Zgz7jN80v/o/Cq48
Hqr3C2fJVsw+I8lWlhbZQ195T9qUFrsSEYpESioh7SpJqFApJVQqJESWN1vZ
933fl2FmSiIiv/v7837u3Pue85znec45f8y1kIC/+7p+vp8dx1kO/vHmNhLw
9reatdA6DmY33BmHwxLQubjkuK8yF0sbR2uqOUiAUMrKs6t+cPH+3MSLq5wl
4OSPSw/dr/HwZfWMr8tcJeDjh7XCWl08nBpfJDznLgG/pLV4SYTe+yXr94+e
koCpQ9beJ8Z4mH6v91GztwTIFJ9Vcn/Cwzv5eJ3F5yXASf18jTiNh33PLaz+
5CcBFxStT0hZcnHS2LKTLwMlQGSVSsCXIxzcaS+Vdv8agQfVNdtfewJL1KvM
XgqSAA/T6f69LcQ+tlMXPIIlIMPg1YLf7jHs/WXHLdtQCfjpiOo/3BvB8Rst
q40jJMBvIrtgIHEIN8c5MXQjCTy/jv/0iB7AIqwzdopPJODAFVL70LE+vPnu
5Ve05xIwObX5lJNSN352NkbjR4IEkEIm5vkNGnH1SJJv91sJqKetUsqgVOMl
dtm48oMEiBcxvyWeKcIu25v3vc2QgN9mjDHsFY42MMjuTiUSILgBe8g6NCNa
Ss77hDIJOBdSVXu9pgPNGbvyRqskgFyv/mbbtV7U10/V3FAvAfOnR8N3zPaj
0oB8H69mCdi8cNPOcNcQSmG6f05rl4AwNe3nM8dHUGQqY+53twR4qjz689hi
DF3aU2CgPyABFX8497NExpHLoMflgBEJaFv0+Hj42gQyCZQsxONE/qARKkbs
F5qSxYICPyRAYofHZEMGF61I89q1c4rA8xa7z8qdmPf3rgy+80cCjgcELC1u
5aGRoW+VlfMSkLdKrmVikYeqL3uTyHwk+Mx0ubSlh4cyV8iYWywlgYTQjt3F
53no2aeyh5GiJFgdkFGp8Z2Lbuw719ImToJWOfr11joO8hiRk1pFJUH2WX6R
d9ETyOJqpZ0jkwSCP8079WTG0eaVvrGvpEiwr5eV+/bYGJLPWN0/LEOCuK06
IZ+9R5DIgZo161aTIMlTfSxx9xBqvqaUlLqeBA1nWZdz3XpRnnT9xC81EnBu
35qMvtCB4jMvqelqk0BNmSU+1dmEvNmN6XkGJGi8aXUyW6MYSZhfx+X7SFBX
tufQlGUl/j2+kV/CnAQCAkmHZkmNuPNm+3Yza+I6dnZGpLQNF8kG3XpoSwIV
i4vitB09OClbo7zlCAloF1bLLxj043CLruUrnUnQnbphRPrDIPbl3D5wxJUE
zWEXFfk5w9jhlnbEy5MkKNW4fE99htiX5XsbB71I8KCymxT/jY1Vc+6yVHxI
hD8oZndZT2C6la7tSV8SiOnTvXivOPgvtz8mOYAE0ymNp4KSuLj/dmjPzysk
uBQt6jXlysNlCpsVdG6S4NC+GBPddkKvuUMuvneI/DeZrlkk9BplHf465x4J
it1etKe18nDgDwP2v3AS9OXK9Hi78PCx4NENRpEk+D5yzkgqnov3rnnodfMJ
CarP7eI3fMzBWvkorfQ5CVKuHwpdt3MCSx0cn1r2igS7aV1BPR/YmG8yUvfA
axIonZnLEm0cxaN3jfwi3pFgTcZm57+5w7hGkZvblEICT/6ymjjPQZyJHy9K
phPxF7VaXx7vw88O7TCyyyLBFoETeO3Fbnzj148bsbkkaNIjT+dUt2JzZWMx
pRISaCfHLnkbVYZ5odN0rWYSdKzsFlN5WoomfsgUqraTwHv7q0NLl9Ujtvku
L5Vugm/BHs3n41rQSLqX9Op+EsiP+7aECHehQWZ02aphEmycyvBSZPWhft+v
5yXZxHWFomXUzQHU0z66msYlwTtLpJFQNoQ6DSh14pMk+Kc+NLmxewS1P9cP
FJkm4nuUtPdC/hhqXeK0XmCOBJIJYxMbj4+jJqfg1oUFEjiGNzUE1k2gE05t
RvNLyLDMd2kGZYGD3B54Pp7lJ8Ppe+Um0sNcdLyY78e0IBk6LTNDXIJ56Njv
RzunhMgwenrJy12jPOSitO7ZTxEyRFfNPckn5msnm/xfXDEy+JecaTpK7P9H
b5vvmVhOhoCh5El3Sx5yzB5+MSZBhtJT9d4ZD7noCNtvZphMhvndFp159znI
fiVp/yCVDI/XvfGJ3TWB7Pa+iu+jkyFsi2MwGbOR7SXdv91MMqR5GlrZz46i
Q8kVZp2SZDDr0PM5OjeMDvY4vGmTIoNlSRD9yrdBZE2e+tcsTQajRfnaJ079
yGrrbatGGTLURN5LknjTg8xfpfLXKJBBJCW7wyqmEe1z5bMvXkeG4QLRZ1o4
Ce+NfvSpYAMZ1gomCOXXFuI9ZWvF8EYin/x7DuzSamy83vxztiYZ1mdo6meO
tOOddsPin7XJcMRZKqt7bS/ecc/PJX0Tgd9xlfYPX/rx9nyJnI96ZDihyphR
khvCRrw4SspmMnwual5yy3IEb5XTdXtvQIZey/UJF8zHMJhV5L81JIP18Ztv
pRnj2PCaA+M1kKHLLNxILnoCb/n062S8ERkGGUq78ls42GDwVuHL7WQQrC2T
q67l4s0M6RWxO8kw3RB9pOIKD+vvTPWKMSaDj4ppfecQD+td2P7t8R4yXIk9
q9D+j4d137RKR+0lA6VpAR+o4OFNbR5nH+4nQ1ZFhsZVEx7WFuMrDzclQ8sj
hXcnrnCx1n+P5O6bk8GqUHLsy0kO1vRYeyHEkgzaAv/M2kkTWP1ZXtUdazJY
jNLsOr3YWK3abM2tg2Tglh2EwPujeOPikN8NWzL0v68QlDk7jDeo+9VdtSPi
C6ByUmUH8fqjEiqXj5BBXT7WJetJH1Yp2tR00YkMRfk3BTetbcWrb91S83In
wxvLmrSSqrPIu1k70MmDDPca+W7GtmSjr4r9lVanyKAoyTDyWFWGjhQbuBt4
k8Hmmb/UB7tW9IHGzlLzIfBONmZf+N2F5p2ihFefJ8PbaJOoqVd9yCRtuzXT
lwxa+bIHglYPoid8k/GifmSoaLI9ZnF2GI2Zxv6a9ydDlefYyNt7o0jvxV6j
H5fIsNg0tMrck41u8WbDBi6TYflJw8mn4hOo2fB1T/NVMuSLpWicdOcgxVDL
jeXXyUA6ruxvdIWLfLr4LuXdJMMx/uvFe/fyUNGGlIrUW2Sg50cePFbJQ9QA
O6n4OwTeZoK6MkT/O1oheiLqLhkK1swUFA/wUKrU58/B98iwa2nPWxc/Hlo8
4SIUeJ8MtaXOy8qKuGh/NsXqTDgZ2i7IZvkXcNAzEfzK5QEZRPvkXheem0AT
Nh6TNo/IECNUHPp0gI3+e71iq0kUGe68WpqcITGGgqe/3Td8TAaJN6TaE3+H
UdsOn26Np2RofrzncWryIFJ5JK+q+IwMN0I/a7A29qNvWgHly16SweW4a7yc
ZRtiXF+7YjGO0M/87XgztwbkUt/sOhlPBtXwT5maj8oR/xmNpW1vyLBVepSZ
XB+EzL52W1QmEfiEqQ8LX83EL0ghcfg9GUwepA/XNn7HhsnDKDGVqOfPp5o6
K1rxvYUHoY/TyCBepbOvobsLd+7d2hWSTvDROffn4vs+vD6Gu/5KJlGfhB9p
JoaD2G/8qd/ZLDLkODkUvIoZxmWbd5cd/0KGuuHH29sKRrFk8DTLNpcMl3lp
ZsZv2Ni17dXxfflkEO5z2TmyZwJnqphlwFcyvArx/myZwMFLff8JaBeSwZ4T
Uz7wiYstv78zVy4mQ98nldbEszz8innopdQ3Mjifm9Xy7Sf21WNCP8RLyXCV
k87PR/TDrRmfDPnKyfBf8xrB/FIeDhM8em+qgrhvKbOVH3i4x0Kic6SKiOdZ
UNjMMS7e+CpnXUcNGVZahE3EGHDwpUm3i9V1ZKg/OB1Z+G0cV25llhY0kOH1
+myyoAgbrwwvYmY0EXxY/56HBUexe+/pY29ayCDztO+leOEQzlaTSX/aRuDZ
kqz9cQcxn16u4L/fQSb2NWKLjuzFiauUXpzrIQPV3DP0qHcT7rftaDcaIYPa
bfdjdjWpaPkWm9eOY2SI3fffk20XvyEd2YazgeNkSNcw39m5uh4d4TsAMRwy
7Lx6fTq5oRXdHihf/oVHhnNVbpymTT0orWRnW8tPov+Y7XniHdOPOl8XJvz+
RfjP36C7O5yHkFCwoTdtmsg3pDNvZHgEqXl8MdT4Q4ZQPdGvyrJsdHD/pmUH
5oj7W5ft+CI4ga6pp7V4zJMhznulmEU4B72nbowP/kf4j71b4RfMRc1Tb0+/
WUIB4w2V2X13iXmzRXHLN34KmP+wGuNO8tDa7Jeig4IUmBtU2Gbyi4fMn65q
5hOmQGPVPaG3IcR+eelxnKwoBZpKROaEvnJRogPDa8syCihvGPBJIfpZzdbw
/w6LU2DSIE5da3Ec/VktLnKRRAHr/3aMONDYSEHoTmMkhQK/qHF1mvUjaO+o
4Mt0GgUOtNUofTcaQufKr3jWMyigyl5dAZ7EPB7qKyQhRYHyx2fuLl/XiiZP
T9Wvl6ZAW846StK+OrTS4nTsbhkK5FWT6XqexegUy03vpgIFbleo7VJQ+Yij
ZwcEX62hgOWvvdpBwt9xYYdD3VclCkyLJ4dJPK7HjBc27vPrKFCg+9XH4U8P
0W8aNkmpUkCla27NR7EB7OZyQEBPjQId/y0o72gfwhE7K2qsNCjADWH2mx0d
xbkqu2LOalEg4evRbYpRbDwsVuQWrkMBh3vvRmk+E5jEMdRJ0aVAy/bQooc/
OViv5gtflT4F5DeyVQ6J8bDTx03V7P8oMDOpz3b8wsMhD9KeiBhSQC43Zp0Y
oY+McxtdlYAC0o5CydItPNxtk6S13YgCWbMpXrVGPCyyWWmJ03YKKLh429Vs
42JN6bjKyzspIOsyvUqzawIf/rfq8TNjCgy4HZ+6QBvHN3ofH8vZQwHdKosP
FydGcXIhQ7NtLwU8fB602HgN49b48H/T+wl+yGW5uMQPYL5b4hV0MwoYBBnP
Cj/qxZYmS11MrSjwkpFPbktswIGqV9VP2VDg+lmHh2v7SvEb0sL83UMUENr5
0MdWJx3/bZh69N2eAq9dX6x8mVaE1mSedhpyIPD7L1MlR6UO7Y+e2CjgRIFT
bXP7W7e0Il8/t79yLgR+KlEO8YvdKM5u8LvhcQo4al6Xp7zrR5WGjg/t3Cgw
/P5038FHQ+i3XKejnzsF8ID/sLr2KJIROKga7UGB5uir2TKBbGQ81DCbcYoC
l+OCtpW5T6BL60P9U05ToOtzniutk4PSzhgvvPEm6ntju7rJTy4a/sx/Oc6H
wJNtmticyEMr/+UuiTlPxHdtXmTrHA+Zbr9w7ZEvBW6Mrtyxnc1DN4I1BO/7
UaB+fV51NbF/ZdeO37wdQIFV+T+/Ln3JRVxmovC1QEIPejytbSc5aLW94x3/
KxSwv2ReQm4bRwdfSS07d40CrnI7bWV4YyhkrDHk1A0KlAWbq+l8GkEFavcl
3IKI+NPvWSlvGELT53aHHb1NgdjUB6U5R/vRulwB6uFgChhdFXizMbsbPTT2
ZewPJfTWcWxDe1gdKgvVjNoVRgHRNvVl/+mVoH+NE5JbIyjwSfbmFze598j1
6FFp7UgKDH3Xu3DkQgmOeb3yuWo0BTTb2zZVZ9ThWk6TrPIT4veupI4s31a8
2W/PaqnnFACavIDG1X7s9VUwgfaCAj1RP48rmQ7heCGsJB5HASl+0aM/20dw
696Lb4Tiifelhjxev4KNxR9orVuSSAH+rTrn7AUmsFEb593sawrUzf6qZj3g
4POyb1R/vaVA/K6OW2JFXPzumFPKxDsKqEvhp6z7PNz7Tlpj+ANR7/7As05T
PMyYbE7rSaHA8nXn9A////9keuHabR8p8LZoYcm3m8R+FWiSWf+JAo/XGMbm
pXHxp+KlepUZFIhYrymf5sfBo2Jfs0s+E/xGu9qc+saxtJnffzibqPcyW/HG
8TFsFqWdl5VDgdxld+zgxQgO6uIapuVRwJtbzS8kNIRzVr/9+g5TYOpq8MYw
xX7844SzUUIBBa5pxlhcJHfjQ9MtO6JLCD0p20jMXKnFG0gFewOrCD/bXhQy
t7QMHbXyr75QQ4EKxSdSfDENKPKpjumZOgocMpd1ifZpR+V9vDr3Bgr8CcmM
K/DrRYvKSRYuTUQ9vYU2GN8YQNqnXJrsWwj8PKTzffYOI7d0GRubNgokfd5s
kVw2ip7NtbaadlBg5cl3jQd+sVE9PLDd00Xk1/1T4HvBBBK+ta9zWw/hD0m2
MykbucigSvjIlj4C/xzvogltHjpNK+zZNECB/Qtj01m1PJRwKOCo+hAF5sUK
n2YR81h77KaBtSMUyMz77zJ/AQ9JDP9wWT1GgQ994eGKDB7atuHdsPQ44S+S
fGjtPw7y9T7mxuQQfrw1Jf325Ql024TruplHARPdSgnnM2wUteaC65GfBD9e
G2rAzAhKXFg8fu0XBZbpbyKxpYZQZvPt44m/KWDnL6D3faQPlaRQjpfPUODk
Muc8+6ZO1Hj7yTHuLFH/hl4tT+cm9Gvze5dN/yhwy/jqbVGTTMRP13GxXUKF
Ry9T1Wxs4zGVk+ccyE8FMdZW2p2tJVj+207nOEEqlJHvKeuF1GP12Bqnb0JU
yDKdx9kb2jH4HnRii1CBWuT2ftPHXnzArO+oxDIqnDmS8CFIeBAfWed+VFOc
CiGFH7J0lo3gUwK/HK1JVHiW5drpkzKGL3X6O/pRqHChcGLV79FxHJIh6Pic
RoWdAS8dVyRzcEzoPYdCBhVKn1dGy88Q/HdlOgyzqDBQOndlfz4Pf4HYI2JS
VLArLFReIPpD+QqVIxulqTDjt6Qym+gfbZOp9uYyVDgm0f1iN4+LRyv07c/L
UeHWwjm9dy84+E98od0TBSpUnhnzIwiOhQNN7PLXUCEY1+jmhY1hpk3j4X4l
KsgHbb0t2juMldTtDwutpUJFXImDbNUA1hEdtl23ngqvIp3qOl168fb+U7b7
VanQHoSP659sw84PrxyK1KDC37sv3tkIFWFvT9FDX7So4IKOFHm3PsDXdkYc
7NahgnLhpOyTLbkoXHblQX49KvDfmMsNulyNXvx5ZaO0mQp1As0CwuotKLVu
g80eAyr8pLXefJTXjXBShvUpQypoLJ79+G6gH1VfN7SOACqAaqiMEmsYddt9
t8o0osJ75apasfFRxNExtWrfTgW9haLPOebjaF6izfLfTir4jwqUHtvGQctH
j1oq7KaCPR2f1krnopUFbIudJlQIj3iaff45D617ctbCfR8V9t8H/fIFHtp8
dt489AAVHFI3/adC6GH33pvmaWZUyDbf/GiG4PtBRQnzZguiPq5ereL1HOT2
L9JszooK908bZyeKTqALLbJmMgepYKj0LMu0eAwFpb4xNbKlwtxYmHHNshEU
eUfD9LgdFa4fTWmZHB9ACU5fDgQfoULkDZ3Drt69KP2/bQeSHamgqMtnMGXX
hho4lvunXaiQpuhgLKFaiPq/de2TcqVCfHy1uin1BpqMPb7P8AQVbOa2nnjn
hjHfRd5ep5NUsHidF3lSqxaTzX33BnlSYSM2cLLa0Yrl1vPtTfKiAum03QHF
8R6sJhhsUn2G4H+eqvnElQFs2EU1mTxLBXaN3h3X9GG8P/PpHuZ5Kngg5xSN
q2PY7ZfTIsOXCgpTepZbMsfxdfV16Qw/Kqx96JNhfImDn3v+dGMEUOGzxy7F
X9VcnJWUtYoRSAWV4+ZZbxN4uH7kcj39CnFef6Hd1wUe5qzZdYt+jQp7rhQF
XG8i5h0nCQP6DSqc8nZq2KrKwwqxTT9oQVRw/vdSf78wFxt0xiTQbhPvM91j
Nus6gW1WuNjSgqmwPqiMdt2Kjb2t15NoIVSQ+OvjIdg6Qsxbk0XUUCqk8w4o
mc0O4sTabF9qGBVy8sMe1Rf34QLxq6rUCCrc3NQn/Dm0E0/fIkVRIqmQ/PxP
QkpSOSaXNJtQoqngKZnFb22egdfzP19CeULke9byWN6qROQYsMGd/JwKD21P
x9lm1iO/7F8y5BfE+4/Jp0/vb0ePpr80kOKo4LdEXNQ+vxelal27TYqnwqdw
W9xJHkTlp3dvISVSQbvxYiOJMoIGP5AnJd5QQabgbK9Z2hhaZLckSiRR4bvH
2g3+Y+NISiX2sMR7KlwqszxE+cBB2seOkyWSifOuuJw485vYh+NUS8RTqbD5
QKHzZC4PneiZuiieRoXz1dw///8+2w3p3I3i6VRIWFUYuyGPh54fuj6wPJMK
VvkRlZuJ57Mi90QvzyL4IugvtOodBzU0UPYt/0LEG9tdPDEwjrjkNr7luVRI
dKcotSaOIZH9LzKX5VPBS+V3ptDCMFK463py2VcqKLmNvj33cwBtKd0ot6yQ
CifNa5ZUhvUib6O8O2LfqOB0MLWriFaPQi7fMBQrpcKsx59j+8SL0etck1+i
5VR4++Cj1pW6GNS5qd1OtJoKH7wzHZYYVuHpsy8porVU4O6wbdS424wpH92+
idQTfpUxtNJCshtv4Kr5izQSfAhR/NYa0Y93rp9RE2mmwm27OJkD5UPY0S1/
ULiVCqZPH8X7xY9i/4Sbj4XbqbBXT+xFFX0cR/bv3S/cSeh56ZjmBTIHp8rS
BYS7qZDHlm57GMrF5XYdn4V6CT/I/953+DYPDz2O8xDqpwJly9yKzbM8vKTl
hLzQIIH39eylnG4elqJrNC8dJvwn59P6+/o8rG32J3jpKBV6+/QVni7j4gOh
GC1lU0HIW0dv8NAEdq8ImhKcoIL1doXCG+vZ+IbI/reCXCp0oAYovDOCn+9g
HBH8Qfh17LqSkcuDOPtaJ1VwkuDvn7VyrJV9mDvvHiAwTQXfzD2Mydl6fOig
ydrZGSpMro4/ETRSgos/rW/mzlJBGj1WHh9LwI/dJ9TaF6hgrLucsfNEBRL8
VtlZs0iFOKP9mg/eNqFT8h/ulPDRYN+mHXu1tnWhtoB7m3IEaGAUVmBrqt6P
trd6DqQupcFren/7+TNDKEVrf1iiMA2uDtoONlqPIqn7G7fEiNJghn8HObWB
jW6yJdjhy2iQsCWUtrRrAv3YwYu8JU6DybSHf7JPcNHhlzXbLpFosCvaxbXU
m4e+zaf88KbQoNDIUdOB2FfVD4Y9c6PRYGSP/NW5UR56+un0niMMGnzoT5Hy
tuAhIZLZjAWLBnv/yfstaHPRaXeN+N0raGDrFHtDNWICdZRQzNBKGqyx4A12
EPPITvnJBe1VNKiOtTIkd42gjwH1SetkabAys/lRR/cgkm5Ns5GTp0HPL61L
6270ocnQsx+XKdLg7AXnPfzsBmTPtjjCp0wDs1uOsT5B31HpDu1lMyrE9Sp/
+WM679Cz+SmX/g00uHLn+EhZfjkWOdhEad1IA/8z5XbGgU3Y+1NGfpU6DUL5
bTvnDbtwl0TkySJNGlxT3mRiifqxsft5yWxtGhRvvZ6/K3QIfyqxLkneRIOx
0IRQy0ujWEZe1ztejwYrTiskMxbZ+HYAS/bJZhoIiRVWCohw8K+WmYr7BjRY
p6o1+Y7g7xGtVt+bhjRo3+ywousuD5eGZin6A/E8r3KsYo6HtdjR9aeNaJA+
x21e38Yj+Hbx8vHtNNB9c3XlFmUeFn15aIPdThr4Cjnr1YxwsM+8fpuZMVH/
28V1unITxP4qFbRrDw2cKg7MbWkdw7s/zWlu2UuDweIJ9bkVIzhdoqNHcz8N
lLItgt/9HMAy7jkhKqY08KPdTLvm2Yun5AKGaZY0Yj94sM5QsQ47BNg9ELWm
wWoLy7cPAgtweYsBLNrQ4LpmWkF9qiuODV14zD5MAwE0bhhVW4vE2F07e+1p
oHrkSo/AZCvy2ZH/q8mBuO7nnio27UU9L56/qDhKgxhGtl9M1wDaMx+4r8CZ
Br01ay51SYygDBuHucxjNCh6quHm0zSG5D6h1+9dafBwpGOP+poJdFdCzjLu
BA2ax2/F8P/goOkTS/iiTxLn86QWddR56GhJ74d7njQwVAw5+qSbhyrlCmyv
e9GAd7TpacIMD20KeCl88QwNbP6urLvlx0MvW66mnzpLg9qwb9JaBP+HS9R7
Qs/RYIovtyjx+QTakN4jmnKBBnJvIlC5NhudiQvVrrlIg0CbrTfi9EZQZtgW
B54/oZdXTxS8vwyg+cCJO6RAGkStWd/47UkP2ur5NF3tClGv67//2ybRgip3
z4qevkGD8IGR4W3+aYiq90Y7LIgG20+V5wX7fMI2SjYOqbdpIP17Td2Ny5U4
hi4UXBtMgzfJB1Qoli24nz8j/UcIDZ48k/sWMdyDVX4695DvE/knlvbrDQxg
zx6qmEY4DawOCa7f6zyC06oKtM0e0ODOxSn6YQc2/pNz2uHMIxocmo4IZ36b
wIZJssHhUTQ4zWG99brDxdejq9M/PqZBZjJf2sRzgp9Bl3rqntJgj8iqD2xi
HpY4t0Fs8hkNAMnJlb3lYQvnDm3qCxroL55Gi8+4ONos2EEzjgYP/MQ/r+gn
+Ij0g83jacAwuTPy4jIbr944mu6dSIPxhx9/jVwfwW7SUT0Rbwh8NFOvlSwO
4GSxnWKfkmjgPGbzXFe4F//6M6Xd8J4Ggsc2Ko4dbcF6I68cfiXTYHGo+Ol7
m0oc2GQeTPtI+MNLtYevb6bhoiK+DK1PhF8eOtBDlkxH+184iPl8Jvhc/nnK
sqIFPQyV0HmYTYOMiYDnkVt6CT/Nc0jPocEzYbk9W3QHkcxJj+DGPBo8l+ht
Fs0ZQS6HVmZMYRossfZ/LpDORm93lffQC4l6ODjd20fmIK7ORTGdYhpYr5k7
8LCAi7TXqOhYfaPBscslLm5Ef79IbXE4V0oDhdbTVVeJ+TZ/SVDwo3IanGCd
ixq/zEOCPO2MjErivKXTi4xdXLS7a6CnqZoG5F0RwdWHJlBoRYTYdC0N+B5/
mV9VNIYas7fqMBsIPivvq1geMYxWvPnhsKmJBi1W/xQOtPWjI5GxwdYthP/+
LXyQbt+F4m/szzjfRoPyc/ImFdaNiO290BPZQYOGCd1yt9clSO3oe7HPXTRQ
2SJ54lxzGPI5cFinpYcGjv5flsdfK8Bftog5zvTRICwzY6WBfT1eXJ8dzBqk
geWp1sekkA68XcotQ3eY8Ot7wepcsX4cLMLqtRmlwdGrcEp9YAjXTJeI+bJp
oDXsWaSkO4bpQz460RM0SMzQtt00OY5tG1Y7ZnFpUIrWv7EQ4OLYgvrg1h80
iH1muehlz8ODKVcz/kzSgP+Fz5WaGR5e91y9V/I3oe9afeUd1TzsFdIjpj9D
+FnAwFaLPi5O9wvVOTRL4GN+1URtEwfPuW1xvPiXBttc26veNLPxnpx1cG6B
BuLHVg04io7ip+KScmcWCX6ZKgqQvwziCYelSzz56BBKScrZPteLDdIme9wE
6GDwb/fEQk4bDhHsxS5L6bCW8nll6HQt7rKuinUUpoPVRCS1bB/GgX9fOxxc
RgeP1YHWmsElqHrfI2QpTocbfYHLTjU1INkX12RNSXS4orlfzcG/E52e9Fo0
odBhgWn39fO2fvR1u33PLhod9rXuuPV8eAhRovbgbQw6HLdVtjGgjiGnMd1Y
xKLD3T49/8H0cZT2n+Ll/1bQIVuEUlCGOUgglOqgu5IO55/4/7FQ5iHL3kVD
rVV0yKlbfdBlgIfiNTkyarJ0MNZ+qHyLx0O/b7T/WydPh/B/Gd4UEx7a2fK9
W2k1HeSEEqbXznJQ5NqMfAVFOlAKVo3lLplAI/5xz2WU6bDRKibV1mMM6VXf
D5RaS4f89l+S/HuG0W25S0eY6+kgrrdGsCWpH7V6uxtSVelgf3NEPHRHF1pb
YiMjoUbguy3mwX9hjaj8hGb3Ui06PNxm8mXsVSySypXN59OhQ8xap9D1c3n4
pIT484VNdBjj2goI19TiXMe5S7N6dDianfAjobANL/80Yv97M4HPb9f1B2l9
2G5p05afBnQ4zbI0TR8axB9sCldxDOkgXdiQHGo0iv+9TVkYBTq0RWXuecAc
x/vnY7oGjehgdKF3lYsZsT/tD87r3U78/nIDzA1xMe/FhWedO+nwUU4wY6qc
h+GXy6VWYzoEdFmN1BP9OmyHuX3jHjr01ludXuHDw71RaEvtXjpcNysgO+pz
sQZ7w6rK/UQ9Di47YWw2ga8ZSC18N6XDUqcVXvbfxnB9qHBXkTkdfke7re9M
HMYKfVO52JIOtUzdiuOCA/isVn9MjjUdVkqZrNs10oXprbl2n2wJPGmnVPyj
v2OXdUkGKXbE9RlxR/fmlzgjIEr63RE6uBnkGCY9ykNCNTfmEx3pUHZqNvxu
Zy2ylvfujHOiw5bqvgWvX20o8axD7nMXOmju/O/R+c19aKZkb8yT43S4EB62
I4g1hIwlNwdEutFB30eeLOU3iqLdle0i3OkQxX32ceX+cTSaSzcI9aDDc+p3
6YRrHKRP4pcOPkXUL8RZ3E2Mh4KP8v7ePE0HjtiVDXydPNT+qbPjqjcdcv3F
UrUneWi9UHnOJR86kA+86KHu5aGAg5+fXjxPh76aZWcFOBxUmRTvf86XDpdI
B80+d46jVQvhh8/40cGx3rh6ifIYMu7flx0VQIenN7m1VaFDyOe7KCs/kA4T
Ml5Tlxz6UOz7Ep/BK3S4tfslu/tkGyoPv1ovdp2on3hkRVtZNfp9fou6xk1C
z/1uB+bwJyRnN3vP5hYd/rQw/VivM/F5pTO74+/SIcU9TC9DoR2/XKb6uvwe
oR9Dk96orD5c+WNU8Od9Qi9Dbf7hhN/9aYp3YkXQgXHo8pKLPmN4dY7j1y0P
6bC+6eDFBKL++19Iy7hE0qFnfqHywHEu9rvZ6h8cTQfM3INVX/FwgvvDttQn
dKA93zw1/I+Haw+Y6rbE0GG/l+FBx/M8/Fd7+aOF53T40XvNu2M5FytJlU6u
fkmHLs9Dh0crxrHZ4nXTPa/ooMI1tVhXNIoDBlHy6QQ6GOasNfwhPIRfl/1d
FvWaDsvTDYJepffi+uTPJ/Le0uFVhA4o1LbgtRfVFMWS6TCtP7vM+mcitjwy
fk09lQ4+v1OPUu5jdGXb617rNDrI7LCM+niqHr1TcTa8lE74wZMQqYFznahZ
XDbmVSYduo9wpIRb+xHfr/bZsiw6sAw9vLInhtGG1kibH1/oIPvxxc4xWzay
yTPPYObR4eyczsQKUQ66FidB24Lp8Ktlf6bmABd9uFV+2rmADkpnFyylOnio
1SOo+k4RHdoVX6soj/GQgLnRhtQSOpxxOcJ3dDkPbdT9d6f5Ox20y6Nnwvdw
0CHpLyPzZXQ4vEvdWzGVjW7wnd+xupLw3z7TzqYDIyh1WOPV7mo6fOo3W1hn
NIA6KjhLTtfSgSeU9CB6dxcS+vj2SGQ9HfjrEt/baDUgzchjubmNdPB/cZ+B
JAvQbceuC6JtdJDMr8496lmOP+143KTWQYcXuh+elqW04O51VlrWXXQo7/q0
pjK3F4uSKeEBPXQYMk2rkVUcwtq/K7lxfYQeawbuneWNYof223vLBgh/8DXa
2v1vHAfj7Um8IYLPdMfA9v+4OCN+iQhzlA66HWS+JY8Iv7mTe8yATfD52rB6
GDGfLfPyLXKaoIO1fYli3QUe3mSpLX+HS/Sff79EtPm42En/R2DKDzqMz3nq
7kgcx/dk3nc2TRJ8D3+7+rjvKM4ScNs8P0Xo5duxB+b3B/Hg6OpohRk63LZU
9PQR6cWk6p7fxrNE/zlTFs1Y3ow3f3pq4fWXDid7urveZn3Dx6JtPj5aoAM1
uuzRzRofHHaJRspdJPxlRceG9edKUI5TjUc/HwOO1Z2ooPg2oeFdd8tFBBlA
uvO8dVNED3IycZRTFGJAclWOguHuQdS1X+f8VhEGnBBr/SeiNYoOmotV2osx
wLkskjbmNo4arXrk/ZYzwDqWL9GrnoNMD6VfiJRgwK8TdwPI9jxUYXenKo3M
AFWvNOuMeaK/OR5ZXUNlwPjyzlb59zxU6Kx1cZzOgAWhWxFrPLnI0FWkRpjF
AMWwYIMHxhMo271rzZoVRLyPj7RQ9o8h7VNpfrCSActGuP0JD4ZQ6plbtXar
GCAydvK8pE4fWn/OTumiLAOY2tLT1omtKNFXI+CRPAOElqzMeL6nEj273KFc
rciA493sk2omGEteT73EVmbAG5eFvoS4evww6GaD0DoGtNxQfasx3IlJwbZr
V29gQIjt9cfblAdw8D21y2gjA16+1Lp/ZfcIFgoXbDqszoDe+GMF2dlsfPVh
2zpfTQYMbFlWQrXn4Pmo5CsPtRlwN43Nj2V42Pfp9ebUTQQeQQrpST94eOr5
wQ1Vegy40FxN+VlBzFNxqtfGNjPgPO9d+sqPXMxO4G9duoUBe/Qrv6q8mcDH
37aoKiAGVDCU1G2+juH+9++vG25lgPzl+gNfSMPYPvVqm+02Bozq5W+NSuvD
rZ+s1S7sYMCLqm0CCo/asOXn9Tcf7GJAhkTL+KvpKlz7ZUlHym4GbNu8WeqL
WQo2yW9SrzRhQGWAVfSkTB76VpAUNLqPeF4hdf6rUT0yKrncKWhKnJ8oJHQ8
tRPll1pqypszYOjxTLOs7ADSr1x7e4slA5q27Xu82XQEpdf86zpkzYDlS05l
kMvZSL2hQev8QQakodu6Wac56H3zmzsRtgwY7uZLTN/IQ8rtl3qS7RiwZKDT
Pek3D8V1metUHGGAxPId1e35PCTTp3x3xJEBbcLjqi53uejJ4HyvgDMDav+U
cre5TCDGaN0muWME/7SORKywHUNh44khBq4MeDa/f//7G0NoOc+//+AJBqQK
LD2/ib8P3Z401Tt3kgHeeTeKZiZakMC0Ymi4JwOe6u5tK1UqR3PzNfrlZxjg
M6LWqypRhM8vSbg/fJYBNjYa+ssiGvFPAb8h/vMMOBhu8Y7zpxt7CB/4T9aX
Abmzt5SitAbxqNia8P/8CD6srxwa3DWKXSRmh20CGBCQmpTQHzWOeyjVBj6B
DKhXbri0UYSLbRmvIsKuMCBCNyzwxA0ebpb0HX1/jQGGuwRvjBD+Yia9z7Ds
BgN+9AVbyBP9qFJW4eFQEAOcZGxbBtkcbLx6ZozvDgMeJ188stV9HBcpVSKZ
uwyIV732Q01kFO8J7dnDvMcAAa+LGgKqg7j296SVxH0G3L9ZUqx/tQfb2Asd
FQon6icf1lBf3IS7i1d4/ItgQL6o0ey9xm/YZYPqhemHDLiTMXHq6YVbePwB
XONGEnwT13UVmSpC3n8t7g1HM6BUoqnry4lG9MfJNbr7CQNozKvP23Z1o8By
v1fNMUQ9R6r7rBIH0FLN0OTq5wxw83IT1Xg6gkIev8z+9oIB3/nPLfgPsRGV
L6M4P44BdfpFMT89OCjarbQmM54BW8NjXnyV4SHZ2o725EQGXKYtZq3k8lCi
Lm8o8Q0DXHWmXj9v5KENsfw/nycxINBzu8LNei5KE2LOR74n9O06HfSRO4H0
T60Vvp/MgLNWPzuubWKjr00G1FupDIgaZPf75Q2jnVtMV11OI+43WAVkxvSj
qnhnlQvpDFizKF16YbADWS6/oOWVSdxn8ynt+lqHjnY82+3whQH0JsMvYZCM
R40+WtrkMuDJy+HzeVJV+FRSscOBfAL/kkSbr6Ot+Del1X3XV8Jv95U53N/Z
hwMujp9DhQS/QGHnpsdDmL/v3xXdYgZsNJCc7zcZw3eMqSFq34h6fa3sSzaa
wORUxSjlUoK/rjc/0F25OJKlHydbTviLTOaz2Dc8LH157wdWJXF+Fj58aoGH
Xw07ZJGqGXCoXOHoTSdin9t/tki4luDby0gat4ODUzOCqhfrGBC7OLXrpc84
1l31pG2mgcD7z8FjWwxHcf6ND4O8JgZo3P3MuWM6iLdPfOWNtDBgbqrDNSq8
B1dYNM71tBH+tf8kuzO8CZvnjCxt7WDAbD3LTbm9BLcq/CXXdjHAK2PZveEO
Y+QQLCFd2sOA7QVLs5aTvqHhn/LKX/sYwH/zHjUvtQl5HNLRzBpgwNc1q6n5
mT3o11fjLalDDCCXR5q7HB9Efip2xm9GGHDqqN/Ly9ajaEmYl8WLMQZkH5U3
3HZvHAXNXDsSPc4AF8OhdR9/cpC4Q+SJMA4DzM5UxfKd4aGH39763OYR99ky
5P8WeUhqY97lKz8Z0GHCqoyM4qGXj2qDfX8R/e5bXV2yARepLAw8Ov2bAeaH
Li96/xlHyS4zL9xmGKC3IiZ4qGMU6VSKvXecZQCYfbZ+8W8Q5WrJfD74lwFh
qy6fUwrsRUZPNQpNF4j4W9Jdxeeakan7wVbgY8Ktd1IqpV8jUHPdyQE9ASZs
at47asYpwvb6l7nqS5mQWoLc31c14sEXEbMqwkyIMdoQtkmwB7uLJArKizLh
hMPdYHHFQVzBf/vetmVMqL/HHcm/OIo3LJxgHhdnwqsn21AxZxyHzpjE3iYx
wffzln35jsR+9VNV5R2FCZE/f5iez+Fh0wnSxyoaE9ZOnThcQPSntOGf+j8Y
TGjLi1oQ/sfFtL6GQqokEywO5cZ7jE9gn44MEx0pJlxQtDoTWjGGm5qiGm2k
meBe3MAd+zKEN9VetPeTYYKVxN6kzu5eHFV+eDhGjgmNK/213pQ24z/FW7yw
AhNWjlFqq/6U4ENY9k/fGiYYWd+4vDrsAfqSzXdVUJkJLmtkqkLKy5F0+oCo
8lomnFPZwVvCbEOXkksidq9nQk2q84gPtw91v3m90kOVCQ+FFE7+fjuM4NWd
+FA1Jqy4a4ouhLHRy2cnVT9qMMFjhD3yMoCD+KP3ZTZoMWFREVT/M+ch5wg1
NK3DBJHnhSRE8KE4hFIqqccEmwdXYqIDeEjx1i/T/zYzoai7f/ZsNQcFXW1q
szdgQstlKFEUHCf2889OVwyZMBw3Xv5adwQZn388HgdMEB44L5MS0o+STvv7
lBgx4Zrxwq9vR9rRspP2CyPbmaCR8DpZ3KQKeRxDQWK7mNDF0tyzdSIOVTvI
k1R3M2GAU6omIlyM1WwFog+YMOHO67ajd4WacZjlkJz3Pibc6FdrK3vai3/u
//724QGiPj/Y2aRHQ9h891vNz2ZMWBf0ffub/DGcvu1uTpsFEwKGxydreROY
Yei5fd6KCVW/SRaiojx8Xu9AlcxBJrBPnHAw+83DrZoa1lttCf7wvS8TeMfD
+qq0Hmc7JghNz0ht28DFT5R/uwYdYcLoy8XoqaBx/Fe+5ccbRyaUxppoGjeO
YDvp7IsVTky4WFnOqtMdwPnMp/xcFyY8UmnkeOZ2YFnKpbtkVyYUTuE9atwa
fGWZA13rBBPCbs9+PProPe5fuvWZ1UkmmKkla17kFqBtS1Yr+Xoy4WfBdZLS
+iYUPyeY8sSLCYdOqYTqGveipb+HdfPOMEEgaN3JRdshdJxX+rXnLBNafy1V
s3k6hkrHknbzn2fCpdmi0ZfdE2jtYEj9Gl8i//BoDluA2Je7Tx3e5Ufgl5Ps
vZmYPyZaTQdPBDDBdXb5VOAbHtrXoOkZEkjwZ/PkKT45Lkquok8nX2FC3Ffm
zyPu44hUOh1Yd40Jnyal84TiRtDpwlbhqRvE7yXdJbdO9KO63C9hzFtMiE6L
k7nPa0ean2NW6N9hAlfD+A1vvAo9+BgYd/guEyK0S+R+SL9CU+8c1wfeY4K5
5x8p04hibJ1olP7iPhOmzzXoXwtrxp9frNlSFM6Ed+dE3ch/e/Gaxe3+BQ+Y
EGSe9Zv9aQiH2R/Lxo+I+Gu2var9MIbnc27O5EUxQWZqdptqyQR2k0rUyX3M
hMCQ3D9rurm40ffb2S9PCX48+DH3cIiHt7YMf8x6RvjJByHv0joeTtYR/pEZ
ywQlat+59jgulnqovDHjJRE/3wWtAqcJHDS5y+PTK+J9neXKfIpjeNLULelj
AhPWixmfExMawkdSbo+mvGbCvqzX9jvW9eIK8bdKyW+Jeh2Pinx3sQnreZS5
vH/HBD8Ove1qVhGOLx+LS/pA+NUs2Uay+wUKuLVO9vVHJmwwtqf1eLah0aE9
9gmfmHC8Y4nMl7k+ZLX95NNXGUxYJvLCTfjZMCqMu9v28jMTjgRRtaLPstFG
vvesF9lMyP5wcHDLYQ564lBp9TyH8Kdr/ocV9HlIKH/iQUweE/L1ZGZL/vKQ
t7R4/RPMhK9d9luTnvJQj58q+XEBcZ7S0NG4lVy0t23f/qgiJgj63SF9uz2O
snRPhTwqYcLL8dlAobkRtCYytPzBdyZ0HpCJcrs/gMKmkkUiyoj8fyoENfV1
onnzmp1hFUzQb3qYh57UoRMfeTdCqwg/ets+fzg3ExmdUue7W8cEA6UC36e2
9Ti50hTdaWDCVNXmP0lPu/DK9Wcu3WpigmzTdpGk4QF8+054zs0WAh+bjDfH
jEfx1MjH2etthH9HrnskWT6OHXfW617rYEJvbJ975R4uroyfPHeliwn9Fud/
4TQe1hOgpQf2MEHe5I/+gSkeTjiqNRnQx4SCt60dgct5mPrVQt1/gAmaCTa1
awQ4OFDG59TFIcKfhT55vGePYXbAw/cXRpig5y7OuNAzhK070tnnxpgwVNGa
0i3Uhwv1m1R8xpmQJeTcX7yyBatF/z7uzWGCI1/1RuXn37CI1aaBUz+ZQFLw
mPumV458PlnLe/5iQuKq58tPN7WiPsoFh5O/mcDv+XF+RUMf2n866tmJGSb8
frjfTPDhMPpS/bnDdZYJ1nHD+cpX2EhJtXXF8b+EP8zsec85w0ERd//YuCww
wcRMVG147/+/ZykZ6bTIBIXKEbO+fzx00li/0ZGPBW/1tW6/ucJDrYmHqA4C
LNBPupNi2sxB25f6mdovZcFth62VcqRxlOr8JPSwMAtGpAISxHeMIOnCL5WH
RFnwy7DNtfppP7ot1yF2cBkLUoJPpq+53I5+B/41thZnQawSace9e1Wo+j+D
EnMKC1qjlyxEfi/CwVnn/u6ksYCpq39gfXIT3qWTovEfgwU/3yedqT3YiwXT
Rl3VWCxwKq0sq9g2hL9uVHi+egULtDIbC8Tcx/Cld4cbWStZYK5ewx8WP4E3
qzwSW76KBfequ23rGrl4Or4alsiyQN7KN7Gb0PcneZELU3IseFbLKlSv4uHT
z7d+GFVgwdaXSqaSd7l4w0r/gc41LFDdtjPi+7oJPBaVvqJOiQXf2qmG0wWj
OJHOPVCiwoKx4N6f8qcHsVO4clD2OhYkMBZ0Br50Y1mJo7kfNrBA+MNrrbve
DThauFElUp0FvV2BzvzOn5DVDXGHYE0WeImKbC+criXm/V2PArVZcGNp+Qc4
34mqL12p8N7EgnceD2DeZwDdncvmc9VjQVeAae3KGaK/Xvile3gzC2RZ44P7
IseR4NSGUwcMWOBtBCveq3FRwenj8dsMWbBl0Er451seCuTEtusCC57Mp6f4
TPPQZvc28gYjIp6q6MliCg/NDFN3yW1ngb3OypQGAQ5Kd957ib6TBdHT/aJZ
PWPodO/NTyLGLBAsIXkIFg0hVXs8Nr+bBVe/3GrKbOxF7LY/sj9NWCDT2/Tn
8a1m5NxwMqTtABGv2kIFJ+wZljNNKKwyY0F86MF9tbaVuLOy+0+BBQs+anqq
Vc614ce7JdUyrVjAUhGVc3Ltx9bfzI4l2bCA3d586rfsCKZuu/v0+SEWdGyy
CJ37w8Y1uLgu4jALtm1KtHlZycEhBv+Eb9kT+Us/CR8N5GHjbF1DfwcW/OAo
b/ryj4eXbjrj43WUBekvmV3Pd/JwYVpSkrMzwSebvI9L7Ak9qw322hxjwWyX
ROScBRv/934Va68rC04HVQakGw/jPyo2++AEC85iM09zpz6cnhB2XfskC1bT
BIsWX7TgjbECP6S9WGC4+faCcvk9xF65RYlyhgVq2fHSsXXl6HX0ebulZ1nw
faojV/xoG3JhpEbM+rBA1Dz2y3b1fiQXMVbKOc+Cdcou1xfmh1GXxOrFPl8W
fNqecKJqmI2e3LXTafZjQVPHg8iz3zjIWiTyZHkAoQ8FK9n/f6+GdrPmZX4g
C/6c+97mTui5lk+0Ne0KC2juxa8DEA+FBBpJvL7GgrKaM8vHjDlo91//7U9v
sAAd+nAxWZWNhHwz/O4HseA8v/k94+VE/5jipl6/zYIgudsoRLwPXT6jMnIh
mAWJW0f0dL41oz/uTy0cQ1kgdm7Xvdm+F/i+3yvhy2Es4Hx5ez71Yg1WCn6X
8yyC0MMZ5GKd0InzH3/yyn3IgqqUs+coMoPY6m3O6o5IFpjaO+Qe+zuKJ7KK
WmajWeDRFRNnlDqBb5RW3JV8ygI73s0dnSQeXtnagHSfsUApVoylQuxzaSMd
v6xiWUA+nlVm4sHDu2cGXvu8ZAGFLyofnDm4V2ji8INXLOiZ8syJmx3Dvswp
UloCoSc0+ijJZgiTlOaLal8T8Zj+/pHv1oMTdQR9eW+J/LcM/FRMrMeGO5Zv
kHjPgrqy2GBl/nTs4SL90CSVBQ7hv6y3ODQjAZ81xu5pLLj/Ueq6rGsfenJ9
w/ztdBasqPTKr64cRpoPtFNfZ7JgXOfC6RyZcVQWZ+DyLYvwpzi+zDplLnJM
2y459IXQS3hxz+lCHvpTsLdSII8F/FvXHtvdzkP36yyvKGAWCDz1P+HuyUVK
fXbaWwtYMHfwjO3pkHGU98Nl1KGIBXG/Sz/XHhpBlks8YwJLWHAtgT62W6Qf
TZDOmT77zoJdq6uMKR9b0HXZS4K5ZSxws/y44eLBYiSldjOrvYIFw4r+sv8V
JOM0w3ses1UsyHjz+tWLlDq8e/8jOclagj9WVhE7U7pxr/2zxk31LFgjLKXH
v3IIX/BMuG3VyIII188Juu1jWOLSBwOfZhYcfnWsaPgQByeGZPyIaGXBAzFG
8F9PHt4Skxf/sZ0F77HBnb6/PNz4ruRgbScLKoQ0PQb/crFHTtVyXjcLPohL
uL2+OIEFKpq+ivexoISfO/PuwSh+0t7ls2GABdq9EwvjFwewBntIxWSIBZn3
/GdUW9px6Syn88QIC3KolhrateXYUXQ67PYYC/qsxMvm1YPQjOS/7a/HWXCz
TVm+/k4VClURmi3hEP6VeGUNR64TKelJEAs+0Q9uJYiekRhEebuYRwUmWfBi
IfuRJ3kMWdrIMBSmCH56CVXGNU+g8eNKZTDNAvE+TYckdR66dn7jJYc/LLDY
I+Y6+/99OmiTRuAc0d+2PZm+SMxXHx8ZDsXMs8D5xfFZteEJZJyw83HOPxac
M6ja3aMwhnrT9+9rXyIJXjMtdzNkBtGFYmu+WX5JKDwUPiCu2YkkGo9ksJZK
As+9WHHQtwolDBw/sUlYEtTUFoYPL7mKDH6dWmUlKgludxzJzicrcCP/hbqz
yyRBMnz4rdDODnySevlmhLgkUH2d7XXyBjC/wi39jyRJEBkMko5qJ/DVuM+p
oUhChtL0n6KsCayxNeollyYJuT+7/9NU5OFS01grcaYkvC86e6hhkYfdi4fy
hSUl4U2MQXSSNQ+L621Q4ZeShEO+MsL9Jhyc+s47fH6lJAwc3/Ko6/cYNpfN
npteJQmCaryxjItDeCpi0fmnrCQkRfZRE0R7caTQzqpxeUlQtZjp+1zSgDs4
9bG9ipLwfeLu873PclDg0RWiHcqS4BASo/+D1Yjkmhy8m9ZKwmTlJsFWzV5U
aJzYUbNeEuRdC791vxxCLrkT28tVJcHzHH3zMynC39S1kovViPcNLCGfPcFB
b19dZGENSbBKOP+G7cpDe1lfr2RrEXg4J+6+SvgnN1iI/UlHEr4i8n/fFHko
7N9ei2RdSbjfHfK+kKiflveD/zVc5/FQb28cwHELeYkKOaMkKlEkLVKW82TL
KCFp0WJLRCSyVLjcSCTJVZRUln5yRfghxXSSLNmSmbHHYDBNzUyRpdJ1v3++
X+ev85zP85xzqp/sRJDoeSYo1/kT7hztWZdjhMBxg496UT4Xhx1dfTPTBIGH
5RRbuGwAq7Senk3DCHi2R0vVgz9gBhS6pexGUNrcT9PSLcYSWru2xVki8OwR
O1jM6CS5GVGZ0XsQjLVISo4EDpE98g2S4XQExV5HDWaqxwj/r8UBIXsRmNsV
ZdPm+SRx2rEnwBbBgCCYrSElJJt87pn52iHoLzmktLxERNo/cgo8HRCIV+6F
Tp6IBDqsV3J1pOrvb2WzpkBIlOr8Ip2dEPQxVl1mLvxCKg3Lxg8eRnBRR9bP
QplHnJ/+tLc7ikBCdcGM9OIRMqe2+yX9GIKqB3yPt+a95MHfcWssTiA4UtLI
8z7bRECqLdHUBcH6Ue7Xe/YReOSS4rShG4KZsFUbxYxa8FWhs8tWD0T9Ny45
Sqv3YS33rEZdTwTTxU10RuAIbmKP62t5IVhXR6e5nuNhP/qmDI0zCJLce5tb
bb7gJYwLC1R9EZyVFcbkdgpx6eYqP2U/aj+aXjbTkyJ8MFe8a+k5BEHLsHRz
KvW+UbYG2fMIhDSTU73V1P/nelK+ZBB1PjqSDkHRfGw8z1omHozAa6JX7pb0
GB4IXBH+K4Ran+FqrI/j4Ogxt9GpMARpRT8z/CNYuL5V+JwfjqDsIo4cy6si
3ru3q49GIvgwuLg1KZRFZMovJwxGITjZELvoyDUOear1ZrLnLwT/di8zDpYb
I3b3pU+wYhAs0jR4uPA6n0zI29W3XUXw2a5s3LJBQFKv3NZ7dw3Bu+NsGf8M
ETGY6UuvTUAgWOKSkPtVRLp9NCReJSJoPzkxqflGSC4NePtWJlF531W1PF31
C1E98IxVmoyA9jinzF+DR17XTZkUpiCosVeUTxAbIe47jfPyUql+kzWzmP3c
QwaxQ1LLHQSxaaUn1w3Vk+NWp4O/pVP5qyvKYycW4p59l48vz6Dy7nPmAs7q
wIcck82NMhG07i/f97c5BzOPPt7g+hCB8c2WHB3bMWzv+nJpbBYCsaQN9Fql
z7j19PvZ/BwEvi5jCrGHhdjGjzvY9hiByhvtmchhEW4I+lE/mYdgg1k/1/+h
CFtckitC/yCYr90evvWWANdErblt8hRB/aaSXzWsT9g0zjDcvQjBI5XuHY8e
cnHVDVuPuGIEDr+Npz5f7MeGqe42T0sRSFVavghd14K3ZCWi6QoErMItT1i2
7eRZXta8ygtq3va5bspPGCA6RRVjuApBjmkfYceMkvyy5tZTDATWCSh9fTyf
aFZxyuIJgkwPHXkm1V85NVMZRTUICopC8c0WEVndKHOFWYtg7X73PpdqEcls
U/OZrUNwSONxjFmXgKiwtzmoNlL5YonC7Qz5JK2PbmjWhIDBL+mxVhwlisMn
1bxaqP2YfbBw8vtIbvGCJBPbqDxMbMtNmWolcqJrguJ2BAr3AhO8zULw9alM
FrsDgY8Utzrp4HssPVda9ZOFIGWHVGyI4gCOlWjMVutCkLdz12m+yyiWWPQx
3qKHmncx9R1ioXz8p/xEwJk+qt6P2jUeSQjxnJLUkaSPVL/y3Wo6WkT44sqV
+P+DCArX6nV+eCHC0xr6mt1DCJp9VgTXvxPgIG2rxb9HqPmupVXLQ3z8Ve/Y
d/Ux6r7pPLB29iMX+xkE9FnxEGQVrxqCtn7MN45948tHkFpq+Q/HqQV7md/L
T/6CgB8huMtWvE249GfJ5UJqfif6bdKrbidu9m9De78i2PND0q1g4yAZONRz
cn4CgT5tPFk4NEqOnRBarp1CEGPbb6I4zCfdHn/o0mcQPCxjW5+hC4mTD1L0
/4Eg7O4iTd0REekI0P2V8gtBaOdm3fnbImIXajb8/DeCE9YaRVc8BaQl4vC7
/nkE0Tija3/gJ0KPOVssLkEDpO0WpDA7QuoTotM0F9BgNLTW/HhqLzG/dSdy
ryQNKqwF1XO7GsjrtALPAGkaVK6XZ6gbFWOTB6/33ZahQdQWps3KP5n4ZS57
60tZGjyIU+aFDXPwjgK+yqAcDXguoacixMdxWcm8+IKlNHCy1/nDjvEZ61cq
ftJSoEF7xRyT2SzERa+0222VaGAeuTC4ek6EN9aZPg9UpoHeDd7kLWMRftLs
+CCNRoO7BrPbpO58wes6vGOrV9DgVYXR0hB9Hs7ujjg7pEqti215kXhgGOtc
/cn8Rjn665xT+ephXLE11EhiFQ1+35+/e184hJuTAmTWULaO1+Xmxw/h7xYe
T05RlmNM7GVWc7BViTV3nPKhzRybhZsHMD9e4bhQjQYGHMVvS/Z34Qs7kmv/
pXyvP9tguL8T/8uV3Si/mgbPHpmXu/p2YgWQ/KlH2Znl8NI3jo2Np2fTzlNm
hKY8Hati4iT3AeZ3yo2LzGR6ldsxWnLMaKE6DWrNl0hFWbzH2YyubCXK0gqm
9N4jbfg5+nDegPJkV8i0VVQL5rTVyodRFhHtkRNNjdgnHEKvUfY0D97+o68B
f9dmDKRTDlfbHWQiqMfSsRWFLyg7ZyiptMnV4ZQtW5WaKPutTd+lrvYWr+Q8
C++l7F0XUr5Brxb/74YOl0/53L6DnwSmb7C+Uf7eX5SDL4xt999fg/8D6/On
nA==
         "]]}}}, {
     AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
      PlotRange -> {{0, 2 Pi}, {-0.9999995908016838, 0.9999999868363847}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {
        Scaled[0.02], 
        Scaled[0.02]}}]->
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "3"], "]"}], Graphics[{{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Line[CompressedData["
1:eJwUV3k81F8XHjNjZlASElIkbRRKtpJz04ZElpCtVFqQkOhX1ookCaGIRFmi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         "]]}}}, {
     AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
      PlotRange -> {{0, 2 Pi}, {-0.9999999022006923, 0.9999999993056546}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {
        Scaled[0.02], 
        Scaled[0.02]}}]->
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "4"], "]"}], Graphics[{{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Line[CompressedData["
1:eJwUV3c81d8bv8s1moqGJGkoCcks7nOiVPKtRMjKaEpWoUilhJCQFCkjK5IZ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         "]]}}}, {
     AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
      PlotRange -> {{0, 2 Pi}, {-0.9999975121947636, 0.9999994480120109}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {
        Scaled[0.02], 
        Scaled[0.02]}}]->
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "5"], "]"}]}], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{180., {51., 56.}}]}], "}"}]], "Output",
 ImageSize->{274, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258196642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145808829],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " to indicate a blank label:"
}], "ExampleText",
 CellID->447491828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "Null"}], ",", 
       RowBox[{"b", "\[Rule]", "\"\<Some text\>\""}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->705204461],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Dynamic[$CellContext`x], {$CellContext`a->
    "", $CellContext`b->"\<\"Some text\"\>"}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{180., {51., 55.}}]}], "}"}]], "Output",
 ImageSize->{289, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384747978]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->231863114],

Cell[TextData[{
 "By default, a ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 " leaves enough space to display without ever resizing:"
}], "ExampleText",
 CellID->337727588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "20", ",", "50", ",", "10"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->487054656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->20], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->30], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->40], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->50]}], "}"}]], "Output",
 ImageSize->{192, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->545092846]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}], ",", "d"}], "]"}], 
   ",", 
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", "d"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137908413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Graphics[
     Circle[{0, 0}], ImageSize -> 20], {Graphics[
     Circle[{0, 0}], ImageSize -> 20]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->20], Graphics[
     Circle[{0, 0}], ImageSize -> 30]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30], Graphics[
     Circle[{0, 0}], ImageSize -> 40]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->40], Graphics[
     Circle[{0, 0}], ImageSize -> 50]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->50]}], ",", 
   PopupMenuBox[Graphics[
     Circle[{0, 0}], ImageSize -> 50], {Graphics[
     Circle[{0, 0}], ImageSize -> 20]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->20], Graphics[
     Circle[{0, 0}], ImageSize -> 30]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30], Graphics[
     Circle[{0, 0}], ImageSize -> 40]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->40], Graphics[
     Circle[{0, 0}], ImageSize -> 50]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->50]}]}], "}"}]], "Output",
 ImageSize->{190, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->417402414]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], " ", "\[Rule]", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 " resizes for each pane:"
}], "ExampleText",
 CellID->235270846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}], ",", "d", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Automatic"}]}], "]"}], ",", 
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", "d", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Automatic"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->908772701],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Graphics[
     Circle[{0, 0}], ImageSize -> 20], {Graphics[
     Circle[{0, 0}], ImageSize -> 20]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->20], Graphics[
     Circle[{0, 0}], ImageSize -> 30]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30], Graphics[
     Circle[{0, 0}], ImageSize -> 40]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->40], Graphics[
     Circle[{0, 0}], ImageSize -> 50]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->50]},
    ImageSize->Automatic], ",", 
   PopupMenuBox[Graphics[
     Circle[{0, 0}], ImageSize -> 50], {Graphics[
     Circle[{0, 0}], ImageSize -> 20]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->20], Graphics[
     Circle[{0, 0}], ImageSize -> 30]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30], Graphics[
     Circle[{0, 0}], ImageSize -> 40]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->40], Graphics[
     Circle[{0, 0}], ImageSize -> 50]->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->50]},
    ImageSize->Automatic]}], "}"}]], "Output",
 ImageSize->{160, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->89761096]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PopupMenu Control",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->598862877],

Cell[TextData[{
 "Start with value ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " selected:"
}], "ExampleText",
 CellID->354085967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupMenu", "[", 
  RowBox[{"c", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11064820],

Cell[BoxData[
 PopupMenuBox[$CellContext`c, {$CellContext`a->"a", $CellContext`b->
  "b", $CellContext`c->"c", $CellContext`d->"d"}]], "Output",
 ImageSize->{42, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41657385]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83132508],

Cell["The setting is based on value, regardless of labels:", "ExampleText",
 CellID->17308452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117265673],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Dynamic[$CellContext`x], {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c"}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{75, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53478144]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "\"\<one\>\""}], ",", 
       RowBox[{"b", "\[Rule]", "\"\<two\>\""}], ",", 
       RowBox[{"c", "\[Rule]", "\"\<three\>\""}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->181962849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[
    Dynamic[$CellContext`y], {$CellContext`a->"\<\"one\"\>", \
$CellContext`b->"\<\"two\"\>", $CellContext`c->"\<\"three\"\>"}], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{93, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106764166]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203215577],

Cell[TextData[{
 "Connect a ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 " to a slider:"
}], "ExampleText",
 CellID->779885379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}], ",", 
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "}"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->573400473],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Dynamic[$CellContext`i], {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"}], ",", 
   SliderBox[
    Dynamic[$CellContext`i], {{$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d}}]}], "}"}]], "Output",
 ImageSize->{268, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22751486]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->362161008],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->118135415],

Cell["Specify an alignment within the menu:", "ExampleText",
 CellID->77798792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PopupMenu", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"60", ",", "30"}], "}"}]}], ",", 
      RowBox[{"Alignment", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], "]"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140556802],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      Alignment->{Left, Top},
      ImageSize->{60, 30}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      Alignment->{Center, Top},
      ImageSize->{60, 30}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      Alignment->{Right, Top},
      ImageSize->{60, 30}]},
    {
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      Alignment->{Left, Center},
      ImageSize->{60, 30}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      Alignment->{Center, Center},
      ImageSize->{60, 30}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      Alignment->{Right, Center},
      ImageSize->{60, 30}]},
    {
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      Alignment->{Left, Bottom},
      ImageSize->{60, 30}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      Alignment->{Center, Bottom},
      ImageSize->{60, 30}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      Alignment->{Right, Bottom},
      ImageSize->{60, 30}]}
   }],
  "Grid"]], "Output",
 ImageSize->{200, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->727638515]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->879409058],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 " does not open until you click on it:"
}], "ExampleText",
 CellID->582237448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupMenu", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"BesselJ", "[", 
        RowBox[{"n", ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24121998],

Cell[BoxData[
 PopupMenuBox[Dynamic[$CellContext`x], {Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwd1Xk41O/XB3BLZGmxzCCKGWQPlZRU5yglSxERQlJZIlsibfpG1oQSomix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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.3461261180190739, 0.581865061766651}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Xk41O/XB3BLZGmxzCCKGWQPlZRU5yglSxERQlJZIlsibfpG1oQSomix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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.3461261180190739, 0.581865061766651}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwV13c81P8fAHDb2SMZdyfjlBJKi0perxTJqkglFAppqJQRUSFkK6RJRWnQ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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.31353019895394485`, 0.48649847604027}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c81P8fAHDb2SMZdyfjlBJKi0perxTJqkglFAppqJQRUSFkK6RJRWnQ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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.31353019895394485`, 0.48649847604027}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwV13k8VN8bB3B7hZhBUTEziqzxTSLUPKdEtkQlWVIke5uyJFuUkl3KlsgS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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.2911612749174886, 0.4343944236404684}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3B7hZhBUTEziqzxTSLUPKdEtkQlWVIke5uyJFuUkl3KlsgS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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.2911612749174886, 0.4343944236404684}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwV13k8VN8bB3BLFLLP2BJmpixZkooi8xyJUhIVpUSokLKVSLYsiciSypYt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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.2743815636982917, 0.3996519085643727}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3BLFLLP2BJmpixZkooi8xyJUhIVpUSokLKVSLYsiciSypYt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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.2743815636982917, 0.3996519085643727}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwV13c8ld8fAHAjIzMU7rVHyYiMUPJ8jtCQUFkVyviSilJ2iqLsjBAyIlkl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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.2340615072537411, 0.37409273587771136`}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8ld8fAHAjIzMU7rVHyYiMUPJ8jtCQUFkVyviSilJ2iqLsjBAyIlkl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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.2340615072537411, 0.37409273587771136`}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}]], "Output",
 ImageSize->{214, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151084190]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53180305],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 " opens as the mouse moves over it:"
}], "ExampleText",
 CellID->306328665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupMenu", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"BesselJ", "[", 
        RowBox[{"n", ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->469113643],

Cell[BoxData[
 PopupMenuBox[Dynamic[$CellContext`x], {Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwd1Xk41O/XB3BLZGmxzCCKGWQPlZRU5yglSxERQlJZIlsibfpG1oQSomix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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.3461261180190739, 0.581865061766651}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Xk41O/XB3BLZGmxzCCKGWQPlZRU5yglSxERQlJZIlsibfpG1oQSomix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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.3461261180190739, 0.581865061766651}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwV13c81P8fAHDb2SMZdyfjlBJKi0perxTJqkglFAppqJQRUSFkK6RJRWnQ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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.31353019895394485`, 0.48649847604027}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c81P8fAHDb2SMZdyfjlBJKi0perxTJqkglFAppqJQRUSFkK6RJRWnQ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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.31353019895394485`, 0.48649847604027}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwV13k8VN8bB3B7hZhBUTEziqzxTSLUPKdEtkQlWVIke5uyJFuUkl3KlsgS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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.2911612749174886, 0.4343944236404684}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3B7hZhBUTEziqzxTSLUPKdEtkQlWVIke5uyJFuUkl3KlsgS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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.2911612749174886, 0.4343944236404684}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwV13k8VN8bB3BLFLLP2BJmpixZkooi8xyJUhIVpUSokLKVSLYsiciSypYt
hKhsfREukn2ZsQ9Ksi/ZFVF+9/fPzOv9unfuPfc8n+ecOyQrx7PXWZiYmGzx
j/9/v/K2Yt937QmVp0Te++t49+GaDin9C1J2YOAknj6kZqi5WVvhLyV1HziH
a4vOqkVo8kR9/MDZ6weidyz7vgQWar6qDJNkkwoGOVUuJnY1mqbC3LWnmzbh
INXIIUBoGtb8ypP4b6MnCkYfdYvfD1zW3JXBofpn/Tkk+S9znWJhpd7SdL39
WzIWHP5wZzaq8lELOr+nLWsngP6ktPCHVVHqH3v9gQWbJHhYotP4uZFCTWYe
CP6tkwJFvKtlsn8UqMdaInf/6kkFt8Jfq0KBB6gTMcerlu3SIOevlbOh9hFq
6LW/Zkvr6bClseXIV2ZtqrJywepC2Bt4+plUorxdj9qxbhs9L5kFc4ElW01V
Dan36iSU5/KywUNFoutI1nmq2LPOpp/aObBzI9y287cptcI8xGamKxfkK1LN
L0lcpVrtQazTNu+h8EPqo/UGayrLukfbsucHMBsvvJzAbUvt/G68c1knDy4b
/otsWb1FzahVtl/iyYcGufXJ+dPOVPccrpLFnnzo/5PB+OV/l3oyaox9MbkA
ttVGNlvLuFPF3avOL9gVgsyjqj5/LU/q7JWE1HmVIuCuCl1ndvClVmq7zc+t
F8HVyP1L7kz+1Ci5s9S5mo9QG825w/xrIPUar2LobNh/IP3mqKgoZzBVdWVr
30+TYkjY/XhWKzSUurX/h8xPyRJ4KmzvTjsQQe2tLHedmSiBnkgea+HzUdTs
jJjP03ml8F3FfC/nm2iqZ+gd/mmPTzD4YdytS/kl1cDFwGJKuwy2z2f8Kl+O
pUpdlMud3F4OI+2bD6V+JVAXNbesT3SVwxyDtuWweDL1BUfpi3EbDC5/79kh
XPeaWuh20uWOSCUYml4J9+pMpyZMqYkueVbC07saFeUcmdTAK7srXYYqYZI5
W7fVNpvqQBOwWdSpArd3ug15SznUC9pMPC7ZVfCp4ND4vZz3VPTxZ+ECTzUk
5e+SSjiZRxVIqGdZ6KmGma1K2976FFLXeT5mOR35DJzqSj2RRz9SRx6+NpxP
/gxK9NyJcVIx9aONd+KcXQ2M8PBWR6uXUZP67HUcW2tgnF1m7ty9Curj06Yz
sypfoJvi/izLrpJ6af8B9dn1L4DoGtsF1qup2hmkodtXayHz7adFXYsaqoIo
7+OfNbXAopU6X9D9hfrv32TXTFgdMAJ9fs8yN1DHnXs8by3WwQXXkRap/xqp
tJEayoxJPZRt0TY+69dMTWlMcp6WbAD+sXfnWpVo1OWYoj2DoQ3wp1ox1sGA
TtW1aRpuX2uAabtynhrPduoM62/j0o5G8O1L6A/a2kWF9u2871ATHD6euvD7
Wjc1Kplcn5LbBDkbnIVSHT3UQ5oG6sFBzcArwcz3cbiP+oTr2pLncjMU5g+m
HggaoH5j3M9xsmyB6nOxHeGa36gB99IlLmq0wky7isSTxe9U2vsNFpm5Nrj1
ID+pSHiUKgAc5txKNNg1UW0ycmSMqiEdrR50jQZd4ir5XbfHqU+Xs5Y86DQI
+ecTprk8SS3uP0Bb3kqHoTFMxvjkNHWoGstxoNKh3sA5zjl3hnogsuu61Vs6
FAjRlNkT5qjm7lePDgzRQd7mS55g9Dw1yGJawkSkHdzjtteesVyg9iky9+oF
tkORyp/BVf4lqk+jwsl9Fh1winlwdY72i5qZ95/02+cd4MuWz6/e9ZvaHnOU
dXdzB2zu2uki+mOVusvmYpnI4U7oTv4IJkLrVAOD4Zgox054fQfbFKRuUN0O
Orhuz8DNlZMj4/iX2sgaoMQk2AWrTimNQrOb1OUpHi4PvS74PEs4JJ/IBDvb
Y8eXfLrg/eCzg5dOMoNT8vvk8ZkuWFl0DtXPZwEhzX6BttpuWDBdFb/6mQ3Q
rhtzJ/52w0t/o21dz9nBjmuhqXp/D1y8dIhP0WErlDHYAz8m94Cc5eLKsjIH
WN1T+f3Koxc07Ct7fzFzQ+iV8g7hvF5Qp/0sf87OA0XHTnyIHO+F63o2P/7w
88I2QXO7wPMMEDOZ/l2byAfv3gf331Lqg1NH02XDVwRgSmAq9KRlH3yRdGQs
BAuCzL2TVNnoPjA8wVDIIxEg+QhXyvBaH5h/mC93v0yEqIbQG5e+9MO9cmO3
52vC0KrwU/jQaj/46sQ81c0WAa6I0w1E+QHIyt3+tMxcFAJMeBToEQOQEW3M
pdghBveGwxeOm30F1Ti9va+md0K+7nzq7vCvsNt3c+fiJwmYyzI8z1r9Fe7E
zn68HyEJtk78/1XIfIPbu0fzFF5LwaW/UZ4Hl75B1PNBC9c7ZEjiavLn1/kO
uQVSa9wB0kDVfGDma/4dnjcNCe3nl4EBB/mDc27fQSBnv9F4sgyItD8Za87+
DpZG0es76mUhMkZf7zHfEBhGhD+KUJUH5cYN0m+5IXAbTUraxpCH1vWcP9e1
h0DE1i7JwFsBOC24c7TvDQGvjtz9a3RF8N/dyrPZPwQPi/xsT59WBvIF7/Hb
K0Mw+e1CiEq2MlQ+Vqoc4PkBMhWux5O27YON6afOpVo/YPxGpo5U4z5wzT/T
6frmB9yaCzuqenU/2AA9dsZlGCJZTNKcB1SBKfVXaf+TYbCW1gy/Y6QGMVvE
BxrThoHnET9BuV4N6htuSGR1D4P2ZnHtZOkhkD2/kXpdfQTKD/wq7y5Shwlb
mZxvzKPAXvNWy4wNwLdJv6VFbBT+as5rccYAiCi5zJbtHwXnQ+yiZkIITiyV
KcdfH4Wmr3PDAu8QZHmdLbrQMArkvq4/Pya14GaUVwUtYgzOaHiab39+DFhW
UgexrDFw7Hd0uzN3DOIu1DO9rx7D88mkvnlSBxrFBbXDlsdAPl5Q4SmbLsi/
yazTuzgOA6m1ms2Pj8PMpw5ateQELJsarvxoOAkBEmsLeYcm4FzSVEqB2ikQ
fyghmGI0Abcc9j9tyzgF+rp2xj7+ExBbQ+JceqwPubR/DI3xCRhp+6CkdMUA
HEblhgvfTQKXdPrXDooRfDdnbKtqmITS0bvP9OyN4FzvY6WWkUnItLjEEVdg
BIeaxu+Pik3Bs31WjXTds8Cal84nFDQFuU2hC41u5yDGk0R1s5gG24MyDFM2
E+D8RbP295iGtOTLSPuyCXg5+gaHP58GzjUdNXK+CVhZDXa+acJ9VTinzuoC
KJx4Zd+rNgOX9UzavrddhCpB0djDfD9hy6IxB63vMhwIq6/Qkf8JWuVQMITM
IIPdfcRI9ydYmiuWbsk0g9C17r03PfHzY6QWA+9fAZPB6Nq4iZ8waB+MZchZ
wFQ23/J65SyksSeKrFlYAicpQGbw0DzYhnUrvrO9DvVHIvd668wD6nc2Gsi6
Do8uJqrtPDsPYq1tFXHT14Elovj4Zft5sBjc6tXkdAP+/Jux6Xk1D7IR3hi/
nw1MDxhntrEswGkNoY7+SjvIXrX64MC7AO6285V2XDfBluBUzC2+AOfZju2J
NrkJI6dC6k8dXIDrR0v8qmZvwkBpxUSdzQJQfvoOPJO+Bc0xMnKVzQuQ+n2H
QU2hA4QUHthnwVgAp2i3Z/c4HOEETevwv9EFYCOSi+jmjlCz1UzvyOYC6Lbc
6qpmc4KyexF2xfsWQXrwtZjXRyfIPb+W9eHFIrS9nLlpJesCT/ma9qRcXQJP
TJrpvaErlKjtLDJwWIKRvszwvhBXGMGvufFgCUYNt/K7f3EFjVzB8xdeLgGf
cvw055F7MKFn5sXdugTOY3/4EpXcQNv/Z9t9jWUQdZrKmZK7D6srvK5nhVYg
IdPCI8XTCyg7rTY3KStQoTZ1e0utFxgcKwzO3YcfL+qynuT1hvSoi4nbTq+A
1eqsiUa6N5zdm1JX4b8C36WxC9zdPpBrqyImv7ACQgMXy27JPgSr/vMYa/Mv
cBBbbNTp8QfO+KHbzoxfwL0cFlPBGgD5lxzEB8d+QdnJAx+8lAOAtS/ofinz
b3j3bH92W0gApPWW7ndW+w1rQ86aDUcDYaxLKvNb6m9oTRXR1618BDdpMxEl
91dBHI14bS4Gg0DEfZAJWgUrca2WfNkQKD3DPhsdvQqL/XveFJiHAFeb5Cmn
96vQEbM0kNgUAjktZ9lkRlchS/KnBynrCcw2Ft+PNlyDGT0v7213wsD5S4CV
o8wfyEv/MjaXEgESI7rsv/b/gaTfmyV5WAQ0sXBke6I/oDm9qR3zNQJ2o7CF
YNM/wHtGtr1DNBIYpc990578AUve3YpboyNB60NGImPuD7ywplo5h0cBf3x9
n3bxOsg42vOMpkZDRUmId2PNOmzZUNS/8SUa7Hv1yUb0dYgR6+3kmYiGL0S6
nfnUOoRaexC7FZ/D/QjGqrv4Bti9jbgHn57DUOCU0DvfDeh+9enF068vIM9p
+zkRvb+gui+qJgXFQnOc4P1ck7/QPBjpHGwfC2M1YklHr/0F96Z1vtQXsSAm
Kjd9y+cv1C0x+d74GQsBVTr+VUV/oXT9dRD1VRyYCPgU3CT/AybXy/JU9gT4
U7AgWL7+DzChHb7c/xIh5YH9lPIFJuQsmPU5tCYVlCs5VoOuMCHJs8YeUd9S
oXJLJtugNRNqZXod9n41Fb6HjUiFOTGh6l+jQ3sVX4NE8pULk8FMaJeP94je
y9cQV3OmJqWMCQ0l/9CacEyDKO4DiQJkZrTtepfgkkoG+CVtGC3PMCPdB1cS
DjFng6FysbP8EjMy3bokFyeVDRJVdyKt1piRbWXQXkGUDaU/pmg0NhZ0+Ln/
21M+2bC4m3EmV4IF/WhzTOn+lw1WOUWnbxiyoPTfjD0mLDmgVeKg11vAgh5S
5r+x7XgHTB3fUZkHK1JguzT1Wi8PpO/ecD+/hw3RLtYx9PD/LSMrL024ytkR
Pb7shVJyGZwcvekV5bwN1eafJ4v0V4HBSIS8hAQn2hv3VoCe9gWmPlv51udy
oaoZhhmTZQMo8Xfv1LbgRhrfcr5xhLUAJ6xYDizxoFC2mSZaCQ2O/7z0m2zM
h0q9rjqX17ZDb/U15ksK/IiHHOoe8KYTih7XmEut8KPsYDF2t0PdkHmySSRo
lR95bnlp/IXaDXHb29t/rvOj4YErErw63eAbMaj7iUUABXzh5nhu1A36MX+U
TPgE0N4Nnkq7m93w443y5hN5ASQsZpOiEt8NPHUJSb8tBVDDNeavpLVuYA5+
bWp+XQDZuNhe6v7XDcsnswW/2AqgVsOC8sAtPcBo/S8oylEADYtOUrp4eyCt
u91R0UsAefoNzh+U7gH1sW3IOkYAvSwuS1036oEbbK7fW1sF0KBbmqN7eg+I
STb0rNMFUGpYRrl8dg+0HtrZJtslgAYSrkr0vesB1Vtfyv368fsHbOOULe4B
9g5ivOqEALL4TpN93NgD6ckfjROZBZGgwn/eJrM9MKKx2nj7gCCyej5dKKjS
CzHG+tVxaoLIL3eyiKzaC/qOySV16oKoa0b4ioJ6LxSmnsgkaQmig9rjEXuP
9kIAR2xg12lBdMRnQmXFqBd29RxGmjaCKIPvxBMPp16wdnlQtD1OED1P9ztx
IasXVFW+Fcm9EkSdzcXrr3N6gXMRfdRNFkTOwjvkpt/3wgdn9v98MwTRxN3l
MduPvbDhFFm8nC+I8sZMk0ife+GF45tPA02C6CrntdDA/l6w28tZttYqiLiZ
TMPdv/XCkblbZULtgijqc/Lg9aFeGHZQKTfsFUQeC4eu7MXfm5UdyitqRgRR
5lVnX6/FXmi41VGV8xefj0Nc3Fu2MSBBQbW6gYmATpZcT4njZIDTTEz1GCsB
ndp9/KI8NwOEbpl/luIkoA1/VYqGAAOs7CdrooUI+HzajgqKM2DDbrPOcy8B
HZwxG3yjxIA2Oav6WBUCGl/3th1UZkDqZE39x4MEJFQfNM23nwF6diEN8xoE
ZGRyt8tSjQEvbIlN104QkKix3nIpMGCvjXyrviUBHS5gPnriDAO+2Uk65l4j
IFYm5u86RgwIvSXIx2NLQPciKg4fOceASed1ozYHAsKYXhMELzDgtWdTl5En
AZ1v5heyM2fAWR/sXr4PATkUz4DCVQYw+RUIC/rj5wur80xYMuBKULxpZzAB
WT6oDdW7zgDhKPuvJi8JaOnuq+oCewbURlt4/xdHQGoD05Uatxlw9+U5SZFE
AtodrH66zIEB9AQNS0YaAV0+N7TljTMDnrzhGr2cT0BWq+fTyG4MUM/eDCwr
IqA3kWG1Du4MmMhZkt5ZQkDFSyqWBfcZoJPfb/sNI6Dn/poruz0ZsFn2duZq
CwH1yN0688GXAe+wpLAqGgFJhG6fwR4ywKz6mRK5k4BS+uxm6vwYUFL3wGm4
D6/f7HGeqgAG2DY68h/7htdDrn5PfiBevxbr/LQhAopDW1LiHzHgTvup5esT
BBSp0RNx4TEDyF3wvHaagL7OhrDtCWYArWe/qswcAaWTDzQu41b8usN9YoWA
RK40HL7zhAEDg7yiemsE9K1nblA6lAEhP1hLszYIiL3St7kd9/j49PpNViLa
6PFxFHyK13dqMKGJnYj67XRJmbiP/ezQVOAkovp9snwHwxmwOFf3LZSbiExb
+g6X4k5Z/OTzk4+IxF8LJ6hFMMBw5b2UAYGIlkfiD+Ti/vf7ddU7YSJCUbLM
OyIZcPnvE1YnCSJ6o+miOIibk8k3jUYiol9GNY8PRjGgmOWuzr7dRJTGoscb
gPsGm+1YpCwRvb/TWdGIm7jNLGhRnoi6X1OfczxjQA2noey5vUSU62AdgXC7
cB9rKFAhoo6n5HeOuKX4Dt0kqBIRb7LFzAvcbQIKXK6HieguiUXvI27q7duT
8UeIyLfgsWMz7nd17+qqgYgung4q6sctQZ5PnzxKREykc6IjuJ967gvg0yUi
P9NjsaO4/3W7WKnpEVG4+Mf933Hf3leIzPWJqPgJ+3gH7oEnKxKBZ4hoT+2L
vErc+mOqf9+eJaK5ycbIDNxlyL2/3ZiIQoicjwJxK8SXlKxdJKLLdhWhV3An
rPx5KWVGREQO4zQl3FyGR+4dtyAi9Z3UplV8Pjyyvc47WBHRvc6ZzU+4p7Zg
Ks+vE5HE9R7kjvuSBRN/mS0RveRxC1XE3ViiNffDnojaxU4M9ePzr07wb+Fw
JKLowQZNf9zZDjVvlV2IiLXSO5mCW6yBLeSCKxGtK85sLcfrGUw5buvtTkRO
b+NczuBe9Xqsm/6AiAaaiIN9eB5sext2NXsTUezBmVMWuE+E6Q+JBhKR2eiy
1Dk8T8XjYRh6TESLP849qg5jgMzRtlc2T4ioLt5mbA9u9t9Gl4oiiWgCk40c
w/P75eqFDsNEIhJ7KmXPgef7wKeYPLcU/Pf3JHwR3g9pxL7wxDQ8fzKigU5B
DAhoNNOfySYi5asjpp/wfjp6wOpL0H9ElHoqiWsD78f8p69fvysloqMR6l5/
8H4lT4487ConIp6y4c4FHwYwJ9pQKTVE1Bebtq/JiwGVW2//V0HD52fgrq8s
3v/KVu+ej3YQ0X9P/jLP4utFctncne09REQadrqac48BPs4uype+EtGNier3
gnfxfPW7Za1MEtHPQnePUHz9+fTOL16BVQh9eL30dbcV/rz6xmIv2YXQTtPW
G+fx9c5oUiaWmVMIHbvy2cMDXw/HKS0vuvmEkOd6AOReYoBgrHCUr4QQ4tcn
S+SeZYC9f87jzsNC6Jxqhj5RiwEfpXy2gqYQ+vw3ibOMij9PhdGjLCSE3L5N
al86woCXq7/8vY8LoWJMfLcXvp5/vq3lI2sshA4caXpipsiAHRe7XT2dhNBx
mX/HHwrj/beSuTx2RwhFHZCwTCIwIC/qwR0jNyG0NdRmqpCfAcdbpJylvYXQ
2A/DU7Vc+Hp11P4W7YkQutDhd8hvsxeaFJisd70RQtmpElfNR3vhAfMew+av
Quiiy8hAenYvjB3j6pUeEkJNOiL9nzN6wfDxjMXDEfz4wEYEIxXfr3nfO6pO
CyG7K8RdM3G90Cx+IDx5VQilyClM5Yb0gsQhautdQWGkFC8glmbbC9UOZ/V3
6gkjjs3nIlckekEhf3+nm74wotw64Osiiu/PKwSz9jPCqLVQKNuH0Av2nj32
QSb48ST54w85e4EQYvZkwVoYhdUcLiH9wt9v0m80fvEWRpdTRUm9TT3AOeBx
wqFQGF17Gi9IcsbfZ9yyuMP/E0bmkW9HXtj3gKVAb/v7UmGkPeHwmu1GDxSf
OHhloVIYzQes/my5hF+vaM75bosw2mmu3sFxrAeqnl6L9xgTRqqVvE17iT3g
rmUw+0hEBLGSS0OP5HfDaAYpOslTBAWeMClN7+mCmYChNVZfEZR12cvmc1sX
LFqlWNj6i6DPFyIVGXVdwCRJkt8XIoLaZJa4f/7XBWIvpaqrX4ogwfg2q48v
u8AwSHJ+NF8EveeQfEQ37oIym536CpMiKGf94C+N5k6IlhXdUmIsimSbLTn8
UzvAzFz6zfBFUXT0vLqKdWwH7Iref5LHTBRBd+sOzYgOKNw8HWFtJYqIxIwj
37w6oLPbT5zHURSdSNzN3n2xAwQDZw5YPxZFpgQL/UTuDogawq5zfxJFH/2u
/M5waYeIuBt1llJiaPkGXdtAng6Xoq+0bh8XQ07LjmfO9zbD6rH0taSKHUji
8VZNdr1aGB496l4dJI7mm0Tbr/thkKq5b0eL5U504hB78unuD5Ab6MpvoyiB
zDyW787AYwgytj7FuiKBtnt2Fh7zSMMODqRkBbVIImOlvnaO2f+wGLn43JZT
UijBJtdDsacKW17STfc/LYWSp8vX9eeqsDMViwmHz0ih1/d7/1lsrcbYz50M
TT8rhXJlTE2vqlVjrp5rN71MpdC2FsUtDS+qsbNtF2QVbaSQ53CG/d5zn7Ht
roTXoX5SSETrv6L1qhrMpzIs5lSJFBqVSeVlda3Dpr5WRq+V4tePbJbRCa7D
TNaXIt6U4fd/KHvT/VUdpqB6KZi1UgopKCCd/C91WO9baY9PtVIofkZB04VY
j6m8xC7Ld0ohra0+4WL59djY7QUJrjkp5F+zR6NhsAEzerJrR8m8FNJjSync
udiAlWVeELZZlEKSCZ93W21pxJ4Nl/N+XpFC6zt+NJbKNmLINITpwYYUuh+g
uDvbqRGLO0b5McVBQu4HTC7f/9uInd5hnN64i4QWJkeSX3E2YzEjSpWXpUnI
II6F3CDajI3kbuufkSGh23551aOyzZgnKuPjlSehr+MrJxZ1m7Gc6xTPc/tI
6JMwy8cLfs0Y54eFswOaJCRYeSXC4FczVnfsKdOsCQmFhci/rWpvwQR4bHf4
XCQhlpZZCtv3Fsy8R0uV7xIJrV47v37oZwv2y27FXuUKCXWINr933tqKSYeb
9dyzJqHUNafn0hqtWABjz7tNRxKSNNmMj01qxbQc6i7zB5OQlnGHla9ZG/an
d1K3JoSEQtjOLvxn24YVam9XcQslobLmV+YDd9swaVGjbV/DSej9YfGK6dA2
bHtNX2HmCxKaSA6epZS1Yb2is9wojYQ0bkU88+CiYVEBfGuL6ST0MLhjfZ2P
hp2aUxlJf0NCxw7/zLgjRMMqatxKud6S0Bt96icdEg1Lc2S26ckjIdXvWPRd
VRrm9IVQ6YCRUH5d1Pc/5jRsj7LaW1IVfj/Rt3qD1jRsOM70RWc1CQUG+baW
2NIwE6fEW+q1JORjbE42cqFhR3bIirK3kJDZj83CbYE0bJuzhsurPhK6el8g
KzaThiWJW+1qXiEhq6ZQnoMTNEx9v7yS1W8SejGcZRc/TcM69ZbVVldJqNeb
Or86i//e7dGpXRskNJxe4xG7go+Pnu3iyUJGoxm/rJxY6Bh6tFSpwEtGNYSJ
B3fF6FhfQlljNR8ZRe50YTq9k47dLQjsvChARvSYk4niUnQs87vwRACRjE5N
/CKl7KZj/BpHeL/uIKNKRpoSKNOxH3MBV8JkyehcMeVlqzYd82Q3sKHsIaOe
kVRtEV06JrRT2LlEnozGjxasXzxBx06ezAoYVSKjjzyFTzB9Opaf1vJW8yAZ
bT9hI0IypmP6n14UdaiSUb2qHw/lAh0bo1tgdofI6KXHOqe4KR0T21xof65B
RtLPaghLZnTM31Toz08tMhpSbzE7eI2OSTgNsgZok9HuhJ57c9fpWPGjTG4x
HTISFlF4lmxDx2YK1Em6J/D7x/2jjd+kY+d5LE4kGpDRrrFzJpzOdGx2l+zZ
A4ZkFDQa6+bpQsceayxcbjQiI5eLB2NG79CxMlt/x1/nyUip63h3wj06tuvz
mxcGl8lIndBNTXpAx1oVVtMGzMgoeWtR2GdPOub+4kTBTXMyuuc9tH/Qi441
2U22PbIkI41HLwI3fPD57jj8jWBNRh76w8r/fPHxa4bMpF4jowFW9v2/H9Ix
Fz55DsyGjDaf+2u0+dMxcY8HwqftyCiFq0brXQAd+zLctLv/JhkJpaUnBgTS
MZH/bh39fZuM2q7rmAkH0bFqqXLDQEcymojkLO/AfSuE20LQmYzeTXjfDXpM
x7Ar7x7svUtGqYS88c5gOmZb9y+43JWMJi+/fO0QQscE9p2JOeVGRofyvD5u
4i6LS8pguJORzWc/qcdP6NiNLfOFNh5ktO1mw9DWUDrG54A+rzwgo0fv3f94
4y7piaD7e5FRWsunmz9xW2kNDfL7kNEP2WqVc2F0bPvbfbNJvng9TbCzH3B/
JPhtKPqREe+O6cYtT+nYVe92zjJ/PG+2D+MNcXNOkEVPBpLRScvqmme4C4zu
yPQ+IqNCk0XdVtxmnz4fvPGYjI7WmpKZwukY+27CseVgPP/mOhfkcH94eu2s
3xN8/P/YxvRwX1otvMoXRkYsefOtlri3WLE5Jj4lo6155gLOuN81GXspRJCR
n23uBzfcFw9mPCmNJKPLTtRsV9zMSb9iTzwjo/2Rbps3cWdvO57ZHU1GnRXV
Hy7gPu/y8uO1F2S0R+pphQbuf/3jNYsv8fFt05cTxp2pc6jDN5aMGtZcFibx
8Z99/3iIJ56MvqR7CRfiXhdhzCUkkNHBqal4V9xpfnL/9iSSUW2Hpo8SboOZ
+9tLksiImPK36hs+f6vGjWLHU8hopLjo2iPcqZiYXFcqGR0rWLHZjXsl6pPO
QjoZHXh5NUoPr0fiBtd5nzd4v0Zhpa14PU/cMLPiziIjtRge3VO4Ew7/9ZbL
wevXJ/B4D15/3denw/7LxeczeicKw/Mytz0xXuc9Gc2f/XxlHM/T0e/UYst8
vL8qipsf4nmb0QuvnSsgo3/6PpLVj+jYi4LBTq8iMuJ61dq3hud18pHvQmwx
3h+KlKdn8DxHKFbvaa8go5V2g3/P8H7IPHSZw6+SjPaRGuTu4/2CaS+P76sm
I/5uGXTeG+9XU+n0yC9kpDumpjKD99+pRyGSRs1kZJBqf/o13p9WkZR/TK14
HvOzFtRc6ZhHQtnAhzYyCmHkhFTj/ZyZPxvL10FGsSJXk0uc8LwMniXQGGQk
WX3q4V58fdg5Nb3o009GhHeXF+/Y0rEDKwH0vV/x8Rk9tH53g45Zc/33NPw7
GTlyU/TZrOlYpdoOjjPjZHSx4bmVxmU69iBi+G/LMl6vu2nERj06FhXvOeD1
C8+T5LWTjsfxvGQQPymukhGmvTuOU4eO9ZYddw9bx/OnqhRFQXRMdfLtoj4L
Bd3WkRUbPEjH5rXujjfxUlDEQOlJb0k6tu00d+0Dfgpy4A4XfyROxyQvZqTJ
C1KQycpfuQBRPB8OvZZPhCiowPUlk7UgHXsbd2Tg5E4K+jBpPfCWHe/fpS30
hj0UVDbEa34L30/Ms4+1milQ0OEKoQAhfL8xsQxomlOkoOwuwZPFIzRMt421
lriPgqaqzlT8+ErDpN+yfLJUo6CFmLP+HW00bNSKKX1Nm4Kqb5vaSefTsGvt
6+5yVyjobSF/a4oTDTML1rhXZk5BM3nPzhy7RcPOowd3zlyloJby2U/fbGjY
sXd/brtaU5CmT5LFOr6f7gpZs6qyo6DexD7xTn18P9X6rW96j4KGtO2b2GRo
mFXeolRwOAV9LNKzXM9uw+o5HsxqRlKQqV89n0VSG6ZoxVq2iM/k7kn+2A/P
2rBVAcIFsxcUpMqSe26nZxsWfvdg2N5XFLSrZ9lQQr8NK1NzX+vKpqBH2fuf
fploxYgVf+nkWgoK4Mk3GCG0YvWN2/zLNihoyUPLxVy9GbulPRTRgNue58De
0cPNGF9ZSWI37ru//CfscV/MvVk6j1uafMTw/qFmbDy8eWHXXwqa/MC7/Ey1
GWM3jrgahjuz5lxYvUozpj0oTDX/R0FZ9a3se+WbsbEL86fscW+8CD9TtKcZ
C6HVm7rjLmH7EK2Bu73qvmsUbv6/vIQTcs2YVVp/Ti3uwfsG41dlmjFfu6Qd
ezcp6KRb12AkpRnb9cNN7ghuqdyYWWHc9ZcM1fRw30gvW3tFxsevz3zOGreR
mAxbNqkZS1KyDnmJe1z98XyVZDN29I1GTBpuW/dzP47jHpMkZOThLmf3pbVI
NGNK/F+qmnBP2fxNYezExxf8qq0X9zNzg0AL3PdY7n0dxe26wnR9VLwZE3tg
ML2I2/sgUcsed8WS9NombodDT0QXdjRj/wN5nbEg
       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.2743815636982917, 0.3996519085643727}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3BLFLLP2BJmpixZkooi8xyJUhIVpUSokLKVSLYsiciSypYt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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.2743815636982917, 0.3996519085643727}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], Graphics[{{{}, {}, {
      Hue[0.67, 0.6, 0.6], 
      Line[CompressedData["
1:eJwV13c8ld8fAHAjIzMU7rVHyYiMUPJ8jtCQUFkVyviSilJ2iqLsjBAyIlkl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       "]]}}}, {
   AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
    PlotRange -> {{0, 10}, {-0.2340615072537411, 0.37409273587771136`}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {
      Scaled[0.02], 
      Scaled[0.02]}}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8ld8fAHAjIzMU7rVHyYiMUPJ8jtCQUFkVyviSilJ2iqLsjBAyIlkl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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.2340615072537411, 0.37409273587771136`}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]},
  AutoAction->True]], "Output",
 ImageSize->{214, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47649191]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->796028876],

Cell["Align with surrounding text:", "ExampleText",
 CellID->398273790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PopupMenu", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251898344],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"},
    BaselinePosition->Top], "xxx", 
   PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"},
    BaselinePosition->Center], "xxx", 
   PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"},
    BaselinePosition->Bottom]}],
  Row[{
    PopupMenu[$CellContext`a, {$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d}, BaselinePosition -> Top], 
    PopupMenu[$CellContext`a, {$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d}, BaselinePosition -> Center], 
    PopupMenu[$CellContext`a, {$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d}, BaselinePosition -> Bottom]}, 
   "xxx"]]], "Output",
 ImageSize->{172, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72122311]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->49881282],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 " is enabled:"
}], "ExampleText",
 CellID->200884514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupMenu", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166164811],

Cell[BoxData[
 PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
  "b", $CellContext`c->"c", $CellContext`d->"d"}]], "Output",
 ImageSize->{42, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41048127]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["Enabled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Enabled"]], "InlineFormula"],
 " \[Rule] ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 " is disabled, but visible in its current state:"
}], "ExampleText",
 CellID->487543105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupMenu", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->597916526],

Cell[BoxData[
 PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
  "b", $CellContext`c->"c", $CellContext`d->"d"},
  Enabled->False]], "Output",
 ImageSize->{42, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->768204518]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FieldSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->614622900],

Cell["Use a pre-defined sizes:", "ExampleText",
 CellID->440556048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"FieldSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142180884],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"},
    FieldSize->Tiny], ",", 
   PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"},
    FieldSize->Small], ",", 
   PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"},
    FieldSize->Medium], ",", 
   PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"},
    FieldSize->Large]}], "}"}]], "Output",
 ImageSize->{490, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330814917]
}, Open  ]],

Cell["Specify a specific width and height:", "ExampleText",
 CellID->151598704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PopupMenu", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
      RowBox[{"FieldSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4", ",", "10"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->316464102],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      FieldSize->{2, 1}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      FieldSize->{4, 1}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      FieldSize->{10, 1}]},
    {
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      FieldSize->{2, 2}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      FieldSize->{4, 2}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      FieldSize->{10, 2}]},
    {
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      FieldSize->{2, 4}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      FieldSize->{4, 4}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      FieldSize->{10, 4}]}
   }],
  "Grid"]], "Output",
 ImageSize->{238, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83453896]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->253908251],

Cell["Add margins within the view:", "ExampleText",
 CellID->280776096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306973721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"},
    FrameMargins->0], ",", 
   PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"},
    FrameMargins->10], ",", 
   PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"},
    FrameMargins->20]}], "}"}]], "Output",
 ImageSize->{215, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73648099]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->39032990],

Cell["Add margins outside the view:", "ExampleText",
 CellID->10112253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"PopupMenu", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
      RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53301849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
     "b", $CellContext`c->"c", $CellContext`d->"d"},
     ImageMargins->0],
    StripOnInput->False], ",", 
   FrameBox[
    PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
     "b", $CellContext`c->"c", $CellContext`d->"d"},
     ImageMargins->10],
    StripOnInput->False], ",", 
   FrameBox[
    PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
     "b", $CellContext`c->"c", $CellContext`d->"d"},
     ImageMargins->20],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{245, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1653307669]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->119109661],

Cell["Control the overall height and width:", "ExampleText",
 CellID->654831887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PopupMenu", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "40", ",", "60"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "60", ",", "80"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->667361183],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      ImageSize->{40, 20}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      ImageSize->{60, 20}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      ImageSize->{80, 20}]},
    {
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      ImageSize->{40, 40}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      ImageSize->{60, 40}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      ImageSize->{80, 40}]},
    {
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      ImageSize->{40, 60}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      ImageSize->{60, 60}], 
     PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
      "b", $CellContext`c->"c", $CellContext`d->"d"},
      ImageSize->{80, 60}]}
   }],
  "Grid"]], "Output",
 ImageSize->{200, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93238018]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->722615923],

Cell["Dynamically update the base view:", "ExampleText",
 CellID->36485908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupMenu", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "\"\<one\>\""}], ",", 
     RowBox[{"2", "\[Rule]", "\"\<two\>\""}], ",", 
     RowBox[{"3", "\[Rule]", "\"\<three\>\""}]}], "}"}], ",", "1", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Disk", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"2", "i"}], ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "x"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Dynamic", "[", "x", "]"}], "15"}], ",", "15"}], "}"}]}]}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3681850],

Cell[BoxData[
 PopupMenuBox[Dynamic[$CellContext`x], {1->"\<\"one\"\>", 2->"\<\"two\"\>", 
  3->"\<\"three\"\>"}, "1", 
  GraphicsBox[
   DynamicBox[Typeset`ToBoxes[
     Table[
      Disk[{2 $CellContext`i, 0}], {$CellContext`i, $CellContext`x}], 
     StandardForm, Graphics],
    ImageSizeCache->{{0.25, 13.75}, {-9.75, 3.75}}],
   ImageSize->{15 Dynamic[$CellContext`x], 15}]]], "Output",
 ImageSize->{19, 16},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167796513]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->328616047],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ", the setting is associated to the value of the element in the list:"
}], "ExampleText",
 CellID->161714752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupMenu", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190773148],

Cell[BoxData[
 PopupMenuBox[$CellContext`a, {$CellContext`a->"a", $CellContext`b->
  "b", $CellContext`c->"c", $CellContext`d->"d"}]], "Output",
 ImageSize->{42, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74293483]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 ", the setting is associated with the position of the element in the list:"
}], "ExampleText",
 CellID->194066844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->643078198],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 1}, 
   InterpretationBox[
    PopupMenuBox[Dynamic[Typeset`var$$], {1->
     TagBox["a",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["b",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox["c",
      {"ResetImageSizeLevel", 2}], 4->
     TagBox["d",
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{42, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149289994]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8106],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetterBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetterBar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RadioButtonBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadioButtonBar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ActionMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ActionMenu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChoiceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChoiceDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputField"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Setter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Toggler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Toggler"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6258]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30044],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->256591569],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->289701681],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->47865926],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->1993230],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedInput"]], "MoreAbout",
 CellID->129417857],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "MoreAbout",
 CellID->414831790],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->458689429],

Cell[TextData[ButtonBox["Toolbars",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Toolbars"]], "MoreAbout",
 CellID->540953912],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->50340224]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PopupMenu - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 7.2631720}", "context" -> "System`", 
    "keywords" -> {
     "menu", "dropdown menu", "popup menu", "selection list", 
      "popup selection"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PopupMenu[x, {val_1, val_2, ...}] represents a popup menu with setting x \
and possible values val_i. PopupMenu[Dynamic[x], {val_1, ...}] takes the \
setting to be the dynamically updated current value of x, with the value of x \
being reset every time an item is selected from the menu. PopupMenu[x, {val_1 \
-> lbl_1, val_2 -> lbl_2, ...}] represents a popup menu in which possible \
value val_i is indicated by lbl_i. PopupMenu[x, {val_1 -> lbl_1, ...}, dlbl] \
displays the menu item as dlbl if x is none of the val_i. PopupMenu[x, {...}, \
dlbl, base] displays as base when it is not being clicked. ", 
    "synonyms" -> {"popup menu"}, "title" -> "PopupMenu", "type" -> "Symbol", 
    "uri" -> "ref/PopupMenu"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16420, 490, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->179924755]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 741485, 13396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3751, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4374, 104, 1574, 37, 70, "ObjectNameGrid"],
Cell[5951, 143, 4574, 146, 70, "Usage",
 CellID->4788]
}, Open  ]],
Cell[CellGroupData[{
Cell[10562, 294, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11040, 311, 653, 24, 70, "Notes",
 CellID->21563],
Cell[11696, 337, 362, 14, 70, "Notes",
 CellID->8400],
Cell[12061, 353, 563, 20, 70, "Notes",
 CellID->25541],
Cell[12627, 375, 69, 1, 70, "Notes",
 CellID->19514],
Cell[12699, 378, 2737, 74, 70, "3ColumnTableMod",
 CellID->15505],
Cell[15439, 454, 595, 19, 70, "Notes",
 CellID->130107231],
Cell[16037, 475, 346, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[16420, 490, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->179924755],
Cell[CellGroupData[{
Cell[16805, 504, 148, 5, 70, "ExampleSection",
 CellID->547307350],
Cell[16956, 511, 75, 1, 70, "ExampleText",
 CellID->451052950],
Cell[CellGroupData[{
Cell[17056, 516, 197, 6, 28, "Input",
 CellID->948643051],
Cell[17256, 524, 274, 7, 40, "Output",
 CellID->153595478]
}, Open  ]],
Cell[17545, 534, 124, 3, 70, "ExampleDelimiter",
 CellID->37081219],
Cell[17672, 539, 212, 8, 70, "ExampleText",
 CellID->538658885],
Cell[CellGroupData[{
Cell[17909, 551, 322, 10, 70, "Input",
 CellID->110288598],
Cell[18234, 563, 417, 11, 70, "Output",
 CellID->31429843]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18700, 580, 220, 7, 70, "ExampleSection",
 CellID->532096031],
Cell[CellGroupData[{
Cell[18945, 591, 238, 7, 70, "ExampleSubsection",
 CellID->516615797],
Cell[19186, 600, 212, 8, 70, "ExampleText",
 CellID->148639444],
Cell[CellGroupData[{
Cell[19423, 612, 466, 15, 70, "Input",
 CellID->78661846],
Cell[19892, 629, 237301, 3937, 70, "Output",
 CellID->712966977]
}, Open  ]],
Cell[257208, 4569, 124, 3, 70, "ExampleDelimiter",
 CellID->79905442],
Cell[257335, 4574, 73, 1, 70, "ExampleText",
 CellID->137367473],
Cell[CellGroupData[{
Cell[257433, 4579, 709, 22, 70, "Input",
 CellID->88531688],
Cell[258145, 4603, 198726, 3281, 70, "Output",
 CellID->258196642]
}, Open  ]],
Cell[456886, 7887, 125, 3, 70, "ExampleDelimiter",
 CellID->145808829],
Cell[457014, 7892, 205, 8, 70, "ExampleText",
 CellID->447491828],
Cell[CellGroupData[{
Cell[457244, 7904, 389, 12, 70, "Input",
 CellID->705204461],
Cell[457636, 7918, 397, 11, 70, "Output",
 CellID->384747978]
}, Open  ]],
Cell[458048, 7932, 125, 3, 70, "ExampleDelimiter",
 CellID->231863114],
Cell[458176, 7937, 252, 8, 70, "ExampleText",
 CellID->337727588],
Cell[CellGroupData[{
Cell[458453, 7949, 362, 12, 70, "Input",
 CellID->487054656],
Cell[458818, 7963, 424, 15, 73, "Output",
 CellID->545092846]
}, Open  ]],
Cell[CellGroupData[{
Cell[459279, 7983, 528, 18, 70, "Input",
 CellID->137908413],
Cell[459810, 8003, 1180, 35, 70, "Output",
 CellID->417402414]
}, Open  ]],
Cell[461005, 8041, 468, 17, 70, "ExampleText",
 CellID->235270846],
Cell[CellGroupData[{
Cell[461498, 8062, 639, 19, 70, "Input",
 CellID->908772701],
Cell[462140, 8083, 1231, 37, 70, "Output",
 CellID->89761096]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[463420, 8126, 238, 7, 70, "ExampleSubsection",
 CellID->598862877],
Cell[463661, 8135, 154, 6, 70, "ExampleText",
 CellID->354085967],
Cell[CellGroupData[{
Cell[463840, 8145, 196, 6, 70, "Input",
 CellID->11064820],
Cell[464039, 8153, 273, 7, 70, "Output",
 CellID->41657385]
}, Open  ]],
Cell[464327, 8163, 124, 3, 70, "ExampleDelimiter",
 CellID->83132508],
Cell[464454, 8168, 94, 1, 70, "ExampleText",
 CellID->17308452],
Cell[CellGroupData[{
Cell[464573, 8173, 312, 10, 70, "Input",
 CellID->117265673],
Cell[464888, 8185, 396, 11, 70, "Output",
 CellID->53478144]
}, Open  ]],
Cell[CellGroupData[{
Cell[465321, 8201, 446, 13, 70, "Input",
 CellID->181962849],
Cell[465770, 8216, 431, 12, 70, "Output",
 CellID->106764166]
}, Open  ]],
Cell[466216, 8231, 125, 3, 70, "ExampleDelimiter",
 CellID->203215577],
Cell[466344, 8236, 207, 8, 70, "ExampleText",
 CellID->779885379],
Cell[CellGroupData[{
Cell[466576, 8248, 487, 16, 70, "Input",
 CellID->573400473],
Cell[467066, 8266, 442, 12, 70, "Output",
 CellID->22751486]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[467569, 8285, 222, 7, 70, "ExampleSection",
 CellID->362161008],
Cell[CellGroupData[{
Cell[467816, 8296, 230, 7, 70, "ExampleSubsection",
 CellID->118135415],
Cell[468049, 8305, 79, 1, 70, "ExampleText",
 CellID->77798792],
Cell[CellGroupData[{
Cell[468153, 8310, 782, 24, 70, "Input",
 CellID->140556802],
Cell[468938, 8336, 1910, 47, 70, "Output",
 CellID->727638515]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[470897, 8389, 231, 7, 70, "ExampleSubsection",
 CellID->879409058],
Cell[471131, 8398, 232, 8, 70, "ExampleText",
 CellID->582237448],
Cell[CellGroupData[{
Cell[471388, 8410, 470, 15, 70, "Input",
 CellID->24121998],
Cell[471861, 8427, 122177, 2049, 70, "Output",
 CellID->151084190]
}, Open  ]],
Cell[594053, 10479, 124, 3, 70, "ExampleDelimiter",
 CellID->53180305],
Cell[594180, 10484, 359, 13, 70, "ExampleText",
 CellID->306328665],
Cell[CellGroupData[{
Cell[594564, 10501, 523, 16, 70, "Input",
 CellID->469113643],
Cell[595090, 10519, 122196, 2050, 70, "Output",
 CellID->47649191]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[717335, 12575, 237, 7, 70, "ExampleSubsection",
 CellID->796028876],
Cell[717575, 12584, 71, 1, 70, "ExampleText",
 CellID->398273790],
Cell[CellGroupData[{
Cell[717671, 12589, 529, 16, 70, "Input",
 CellID->251898344],
Cell[718203, 12607, 1064, 24, 70, "Output",
 CellID->72122311]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[719316, 12637, 227, 7, 70, "ExampleSubsection",
 CellID->49881282],
Cell[719546, 12646, 208, 8, 70, "ExampleText",
 CellID->200884514],
Cell[CellGroupData[{
Cell[719779, 12658, 197, 6, 70, "Input",
 CellID->166164811],
Cell[719979, 12666, 273, 7, 70, "Output",
 CellID->41048127]
}, Open  ]],
Cell[720267, 12676, 493, 18, 70, "ExampleText",
 CellID->487543105],
Cell[CellGroupData[{
Cell[720785, 12698, 247, 7, 70, "Input",
 CellID->597916526],
Cell[721035, 12707, 292, 8, 70, "Output",
 CellID->768204518]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[721376, 12721, 230, 7, 70, "ExampleSubsection",
 CellID->614622900],
Cell[721609, 12730, 67, 1, 70, "ExampleText",
 CellID->440556048],
Cell[CellGroupData[{
Cell[721701, 12735, 452, 14, 70, "Input",
 CellID->142180884],
Cell[722156, 12751, 792, 19, 70, "Output",
 CellID->330814917]
}, Open  ]],
Cell[722963, 12773, 79, 1, 70, "ExampleText",
 CellID->151598704],
Cell[CellGroupData[{
Cell[723067, 12778, 649, 21, 70, "Input",
 CellID->316464102],
Cell[723719, 12801, 1597, 38, 70, "Output",
 CellID->83453896]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[725365, 12845, 233, 7, 70, "ExampleSubsection",
 CellID->253908251],
Cell[725601, 12854, 71, 1, 70, "ExampleText",
 CellID->280776096],
Cell[CellGroupData[{
Cell[725697, 12859, 426, 13, 70, "Input",
 CellID->306973721],
Cell[726126, 12874, 638, 16, 70, "Output",
 CellID->73648099]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[726813, 12896, 232, 7, 70, "ExampleSubsection",
 CellID->39032990],
Cell[727048, 12905, 71, 1, 70, "ExampleText",
 CellID->10112253],
Cell[CellGroupData[{
Cell[727144, 12910, 464, 14, 70, "Input",
 CellID->53301849],
Cell[727611, 12926, 766, 22, 70, "Output",
 CellID->1653307669]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[728426, 12954, 230, 7, 70, "ExampleSubsection",
 CellID->119109661],
Cell[728659, 12963, 80, 1, 70, "ExampleText",
 CellID->654831887],
Cell[CellGroupData[{
Cell[728764, 12968, 654, 21, 70, "Input",
 CellID->667361183],
Cell[729421, 12991, 1612, 38, 70, "Output",
 CellID->93238018]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[731094, 13036, 227, 7, 70, "ExampleSection",
 CellID->722615923],
Cell[731324, 13045, 75, 1, 70, "ExampleText",
 CellID->36485908],
Cell[CellGroupData[{
Cell[731424, 13050, 881, 27, 70, "Input",
 CellID->3681850],
Cell[732308, 13079, 522, 14, 70, "Output",
 CellID->167796513]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[732879, 13099, 237, 7, 70, "ExampleSection",
 CellID->328616047],
Cell[733119, 13108, 255, 8, 70, "ExampleText",
 CellID->161714752],
Cell[CellGroupData[{
Cell[733399, 13120, 197, 6, 70, "Input",
 CellID->190773148],
Cell[733599, 13128, 273, 7, 70, "Output",
 CellID->74293483]
}, Open  ]],
Cell[733887, 13138, 260, 8, 70, "ExampleText",
 CellID->194066844],
Cell[CellGroupData[{
Cell[734172, 13150, 200, 7, 70, "Input",
 CellID->643078198],
Cell[734375, 13159, 632, 21, 70, "Output",
 CellID->149289994]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[735068, 13187, 310, 9, 70, "SeeAlsoSection",
 CellID->8106],
Cell[735381, 13198, 2195, 80, 70, "SeeAlso",
 CellID->6258]
}, Open  ]],
Cell[CellGroupData[{
Cell[737613, 13283, 314, 9, 70, "TutorialsSection",
 CellID->30044],
Cell[737930, 13294, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[738092, 13299, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[738277, 13307, 319, 9, 70, "MoreAboutSection",
 CellID->256591569],
Cell[738599, 13318, 141, 3, 70, "MoreAbout",
 CellID->289701681],
Cell[738743, 13323, 148, 3, 70, "MoreAbout",
 CellID->47865926],
Cell[738894, 13328, 168, 3, 70, "MoreAbout",
 CellID->1993230],
Cell[739065, 13333, 145, 3, 70, "MoreAbout",
 CellID->129417857],
Cell[739213, 13338, 159, 3, 70, "MoreAbout",
 CellID->414831790],
Cell[739375, 13343, 128, 3, 70, "MoreAbout",
 CellID->458689429],
Cell[739506, 13348, 128, 3, 70, "MoreAbout",
 CellID->540953912],
Cell[739637, 13353, 171, 3, 70, "MoreAbout",
 CellID->50340224]
}, Open  ]],
Cell[739823, 13359, 27, 0, 70, "History"],
Cell[739853, 13361, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

