(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    686529,      12949]
NotebookOptionsPosition[    675872,      12584]
NotebookOutlinePosition[    677318,      12623]
CellTagsIndexPosition[    677230,      12618]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Views" :> Documentation`HelpLookup["paclet:tutorial/Views"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Views\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PopupMenu" :> Documentation`HelpLookup["paclet:ref/PopupMenu"],
           "OpenerView" :> Documentation`HelpLookup["paclet:ref/OpenerView"], 
          "MenuView" :> Documentation`HelpLookup["paclet:ref/MenuView"], 
          "FlipView" :> Documentation`HelpLookup["paclet:ref/FlipView"], 
          "SlideView" :> Documentation`HelpLookup["paclet:ref/SlideView"], 
          "TabView" :> Documentation`HelpLookup["paclet:ref/TabView"], 
          "Mouseover" :> Documentation`HelpLookup["paclet:ref/Mouseover"], 
          "Tooltip" :> Documentation`HelpLookup["paclet:ref/Tooltip"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"PopupMenu\"\>", 
       2->"\<\"OpenerView\"\>", 3->"\<\"MenuView\"\>", 4->"\<\"FlipView\"\>", 
       5->"\<\"SlideView\"\>", 6->"\<\"TabView\"\>", 7->"\<\"Mouseover\"\>", 
       8->"\<\"Tooltip\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Dynamic Visualization\"\>", 
       2->"\<\"Viewers and Annotation\"\>", 
       3->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PopupView", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PopupView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PopupView"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an object which displays as a popup menu \
whose items are the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PopupView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PopupView"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["i", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]makes the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry be the one currently chosen."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PopupView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PopupView"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["i", "TI"], ",", 
        StyleBox["base", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      StyleBox["base", "TI"]], "InlineFormula"],
     " if it is not being clicked."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->21289]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PopupView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupView"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Dynamic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dynamic"], "[", 
     StyleBox["i", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " takes the item chosen to be specified by the dynamically updated current \
value of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ", with the value of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " being reset if a different item is chosen."
}], "Notes",
 CellID->19207],

Cell["The following options can be given: ", "Notes",
 CellID->15355],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Baseline",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Baseline"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the displayed menu", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the menu is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FieldSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FieldSize"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.", ",", "50."}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.", ",", "10."}], "}"}]}], "}"}], Cell[
    "the size of the field for menu items", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameMargins"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "margins inside the menu frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the displayed menu", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "the overall image size of the displayed menu", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->23396],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 " always leaves space for the largest of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to be displayed, so that its overall size does not change."
}], "Notes",
 CellID->29323],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 " leaves space only for the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " currently being displayed. "
}], "Notes",
 CellID->10341],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " can be used to give style specifications that apply throughout a menu \
item. "
}], "Notes",
 CellID->17049],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 " by default displays the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData["\"\<PopupView\>\""], "InlineFormula"],
 " style, which typically uses the system menu font. "
}], "Notes",
 CellID->30634],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BaselinePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaselinePosition"], "->", 
   ButtonBox["Baseline",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Baseline"]}]], "InlineFormula"],
 ", the baseline of the ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 " is taken to be the baseline of the currently displayed item. "
}], "Notes",
 CellID->26784],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<PopupView\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214181473],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->100647878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupView", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", 
    RowBox[{"x", "+", "y"}], ",", "z"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24985],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 3}, 
   InterpretationBox[
    PopupMenuBox[Dynamic[Typeset`var$$], {1->
     TagBox["a",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["b",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox[
      RowBox[{"x", "+", "y"}],
      {"ResetImageSizeLevel", 2}], 4->
     TagBox["z",
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{$CellContext`a, $CellContext`b, $CellContext`x + \
$CellContext`y, $CellContext`z}, 3]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{57, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->334267349]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22608],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 1}, 
   InterpretationBox[
    PopupMenuBox[Dynamic[Typeset`var$$], {1->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Xk8lO/XB3B7lmSbQRQzUtZQiaQ6RylZiogQKpUlsqWkTd/ImiyVtbTY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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.3461261180190739, 0.581865061766651}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 2->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8Vf8fB3DbtUcyrivjKiWUxjct73ekIVRKpRAyIqlkRSSEbIooRUVp
0ECFcpDscbm3rOtSSEaZGZF+5/fPvY/n49z7OZ/xer/Pvar258wdebi4uHTJ
l/+/3w20F9B1iNJ/p3fprInHzLYKporJURUX6E6al84uytP/V1kSoqJyCZ6W
anPvL2Lqiye+eSncFgxL1toNe+h+179bGqPMr3Id8lxDWXJFk/paow6x/5zj
wD+6IfJJy6J+l/i9xYXWRHgXV9yzXlcA1B8J/fdnPglyTmiKZ20QB7ftXmdn
lFMhu+56bnPhEshj9WROGabBbPLKGJkZefhzxoQ97pwO2kO0H3ItyyCDm319
xug+KOg+kXLLUoOdDQnLp1sfgKlfcUb22hXwI2V32ZRLJgzcW7xACGtCtMNf
q8n5LCgNiVueu14HmPOnb44pPwHnjaG2fIXrwbtq2drRV0+BGi7j/9bwP6De
YNX9NHwOr/7xsxi/9cBeE3mHnV9AoJV4yBqGPvDM+zVNXX4JY8Lv7uktILB6
LJSmjF6B1gnHf5RMA/B9LlI40foaprnnV+Xr7ALjxO8CExl5IJg/VhEttQdo
vmWHx13yIZcZeE2SYgylhj5jo/MFkDAgc1NmrRkIdn7T+KlcCF4mKXy/Cw5B
W+kHr5EfhTBe+vPh/O/D8PRRysfhV0Uw2rTJogWOgJmH2ckhw/dQtWZD0cjY
MUgWKkoecCZAOWu05UO1DeT7GHtclC+FKo+Cd8mrbSFtaJPC5OVSGEr8Kp43
YwvuDGnnCaMyiGPds7h1zx6k06p5xlvLIZ7JW/dvhRPMi795cn7bR/hZou1o
utQZ+q4+PDCW8RFe02iG/pTT8MY58N6oSwXI0APOef11gePrN2z5Nf8JFP6E
OrWousP92vQLw8o1cM3ryHDDk4swlVKg2R1dA5c4LOomC0/Y5VzX2zJXA0be
bd4+vF4wwjtjUcSsBbUkzUL/096gt91sy/Xwetis3SkTevgSMF4s8GiMNsEC
xb+Dmn8FpEHIRkyHARaCz+JO7AqCrStubgl3YEBr9KcOyfwgiJ16MunXzAAd
c9azFzeuwoaEz472z5rho8uqXQWnQuBKrZax7kkmRMFR96Rd4ZD96u2KZ0lM
AP7zt3VqwqElxYB3eT0Terx/XV5lGgHqzsfey29mQTBzW7+B5XWo5Q3V4Vry
GbRc+qLmrkaB7PZO6abKLxA6aJASKxwPuS+ud7rpdEBuw6GuDOUkGJIeija2
64ABo/I17eeTQMPbWH/lzQ7I3uvzJKs8CTK2idzvneuAA4Z7DP84J0NiTbTT
8U+doDDFeyC68BZ498aN77bqgicDUrfUfW9DukhdiJRRDyx12ZZQvzYD9Lf7
WwXZ9MC5jf4hXvYZwHZfvXHUpwf215hMOtzMAPmWqO/1T3vgoPhUvexcBiSk
mOyNkPwKR/enDpR/ug8hyxvF/3V+hahWAzUVt4fgDM2pIx69YL3Lopdr5BFw
PZgu6ozqhZS4rf1Llj+GFD4auzazF6KZx6872TyG6hqnZU++9AJXrIVWbfNj
WHl44YHjlj6wmF7NHV6cDT9OazzncPeD64GXYW9vPwXXxIASRvx3qElRXz0e
lgvu/at683MHgfZITFAxPA96bNopZTWD4Od0N0wiNw8OtUXoNPQNQsSuIw/p
n/NAr27gUj91CJRf5xg+pecD76ssSdnwIbiT0SSgU54PKZdV9X1ODsNfTXbw
NN8bKFuikLpZ8icEzK+hlWS8A2HVUI1uvTG4uUrst49mCcRK1mnet50E2xBT
umlRBdh3HiZ466ehc5u4cJV5HVz4FGp/TuMPPJA/M0/7x4BX50UPye/9C079
QZbWEiy4739maO1RLqzZrbTPeE0rBKcvHJwa4ca/dw/8yKtphwNr311YPcmN
9VeWfl7ObIdlZRcT7Oe4sTeya28Cux2Kvg0xGPw8aEfjen14tB0mlrfvz1nG
g4+yheqiZTrA/nmBqdMBHsx6pJ7+3roDdhS6723L48G6w+yA0aEOEDfWdJEo
4kEfd4sjYZMdwO7oj9hVyoOsycLxpQsd4LtgVZ1fz4MFizctlcU64SXs253Q
z4P3dift6dDpBJVKDSNjOV6kD52MGD7fCVzMHnzvx4tfIiyvHhrtJHNdct/v
Ki9+cBI+d3emE4S47vJsjuDF+J9HuDj/OkFa27KiIIkX/baKTxhIsmF5ePPu
Fy95cdjI+OCdtWww3lpu9uA7L8ZMc0SDzrHhxsOHVhHmfLjR9KXqcD8b5Iuu
fthlyYfqQ7vCF0bYkMY4uYzflg/LfDaV8E6x4dFfxZ6rZ/nw04hf+CR3F7w7
evOUfwQfzp0A9lGlLmCLXHN1L+FD5gO3vTrmXbDC08n3sCY/Xnlebj2Y1wXa
W7oPpa/lxxuPrPftLuyCDVzH1gz9x4+aAjVFd0q6wCB67/crhvxY4vFKbGVN
F9hkah1+ZsWPEbT9Io1dXZDMmljDE8ePGhel8vbxc+Du7TMipkn86GRqSkgI
cyDTtu/7rTv82MCzRbhWnAOvRz7f1c7mx5/Dsiaq8hxo5CsUsSzjR7mQDMnj
mhzg33hl4MUkP1ZHPtwwbsIB0fmZ8j9z/Jh/ychC7iAHpMvO3zPiEsANAvXe
6y04oGJqb9EpKoBLeppzTK05sM3R6KPACgEc0+MKEzrLAc8kkXTrYwKYartQ
fieSA/4nQv2ybQTQ5JTsTpVYDgSr/rWYdBBAOXZpzO0EDsTn/BK9fkEAjdo9
z55P4cDzT81++ZECSFl/iOd+Fgf6ft86IvKBvF/b9nzpEg482LH+YtdHAZRJ
kwlZU8aBkzGNcS9qBbAscEwGKzjQoc5fc6hNABPsEj221XKg+ZDH1rRJAbzm
sDHn/mcOxKaLHXP/I4B8Ofmrrdo4YDKc7YncgljZ8H6/cCcHqoO7c/rEBfHw
M/Tb0cOBklcmKtqagkg9UTlDHeLA5b8D2/6tFURcxrfDY4QDm/eGWDZvEsSW
laYyH35xIL+nMNHLSBAXFjr2aU9y4KmEBn+JrSDu003P9JnnwOkT5arxzoKY
5vKu1/UvB5Y/tta3dxfEcxP2Nw7+40CG/k0fgcuC6CG6V2+OpxtuneUeMrsl
iLM0baNXQt1wuDBNQPWeIDZ8OFMAIt0gza9Hn8wUxPnumsAy0W6ITXO3uvVa
EI9Tq6TSJbrB5IfQJZdCQTz/a/jzH8luENqQlbS1VBDfEFt/7JXuhtC6zsbu
BkF031Y+UibTDQZyPsOvWIL4/Fxp+9DSbvhnL00J7RRE7zxfYUG5bvD7s2fH
ykFBZG/h1lZQ6Aa9XX3Wf0YFMUe8U0GC2g2/E6741U8LIr9cMM6SPr/qTd55
PgoemcrSzaR1g47XQYaBCAVz7rjPOCl1w3DpyIiMNAVfK6f9pC3rhmzRCKEB
eQrKaA1KVZJ2OkZfUahMQcsP8vb2yt2gnlliELWCgtfUpjvHSX8btTxprU3B
rMXDAZ4q3ZCx9bf/mg0UDDSW2jlE2jo8PoV7KwUVjkjoHFLtBipzdQFzBwWN
a7dufkG6bVlVc9YeCu5+GnVqkXSyq/0vn/0UpFksPEU1cr/f/BU2PkLBteE3
xLxJS/OkatCsKVh94uT1e6SbTDfs/HWKgofMvGlFpKNTm2xLXSkosG2mopq0
cb9rQOIFCq5yFLpaS3pXAP35Tl8KnotczCBIGyxld0wHkusNmduTTVo/56bQ
k2sU5Mk09wklvcXIVO9ENAXPSLlqHib9Xxe/s9gNCg4Rj23lSK/zKkkiUilI
ePnLN5Lz1xHzqbiQQcHPdVYHfElrZq2ZpD+m4JxOnYAs6RXbf6h+yaHgRI/p
lsfk/qh9zjgQkU/BsLmLg6tJLztreWVLMQVTnVnSmeT+Uvmlc0fKKKg5IVYg
QVr2bi37XjUFHTdXNbqT5yO9MUTkYBMF777NtSkjz1PEcep0AZuC3yMHO5E8
b8rf57ece8n1qZRVnlXsBr4kx0qFIQqedG9SiyXzsVDxhR44Q8Fkw9FVT+S7
YdYqznztIgUduCtaHpJ5m5raffUbnxCWDVj8SJDthhH1Qs4uaSHk2x9rsYfM
64/3F8Tm5IWwQX7TM8kl3dB3WHPbM2UhdL9336VeqhvYoXdSJbSF8NFOOaVl
ZD3U9wUcbtsthLH7iF2aZD1VX/4vJNJMCFO4L9XGCHZDhczoq20WQqhW6fuy
j78b3u+0lbhvL4TE5IMMN7Ien2ca1LoECOGTD9Vc/X84kL1tflYxVAiPWz+4
1jtL9l9WnkZjpBBKL+Dpz9McSONbfm1dihDO7Kcb3ZjgQIwDWauvhdDixI1D
PoMciFwg3HMKye9f8nwvOcCBsJu+d0+WCuGYSlLQ3T4OBFYM/vnYIIRGWoMK
Cd0ccFevL4j+IYTfhvpjelgcMOuLX71smTASJxIDVD5woH51H8tKXRhdLpYL
aRRxYN/FTYF3NIXxo3DELbW3HNjDw2HIbxLGzU1f382+5ICBymrvJQeE8fRs
sKJqJgc2Wn0qpQQLY+58Y6F9BNnPHsq77o4Qxnavc1GFoRxYN3xmSVisMMpM
JzvyX+WAjp+0E+8dYfz//6rLlziwMuWkyGKeML6i5R//7sIBGmvOYrJfGM2c
A2xz9nDgtqLpP90RYRy7+GKJxU4OKJzKyD4/IYxRAcfZ48AB2Yld8z8Xyfml
rnotvIkDkpI3M37IieB/CtYxheoc4DXRGe7aK4JSlM28YotdMPTRPqg6RwRD
zM7o3MzuAuWENtfYfBE8navM7/igCw7bmFkcLhbBBHkVvVVpXVAyu1mzp1oE
jSW43kfFdUGithRrplcEv3R99S/06oKttwgNDaooWgfyLRRCF0S70pquhYni
2MiJLLtaNpRtSizcFyOKLfssZx+Us2Gaj5IpdVMUI0cHFluL2GCbPul7974o
ftIqXq/0jA0bWLVqBe9F8Q2bL1Umig1d2y95902IYu9DD/OiPWzQkfqiZHhS
DM9euaY8X9QJ32O+Byc5iqGNGT/XsdedcFd4ZmDgjBj+qFJIePqkE0T55F9H
+4rhPvGSlrUpnTA0bbnrS4IYtk46biz37IQsdpe7S4UYGrx4kzy/uhNo2f1E
3Cpx9OOmD31L7ABh+G3HnhTHzawoM2fDdvDdsZLy5o846sWeWmG3qR2+G57I
jeOWQHODIIUDq9uhfE/ZHwMJCbR7vcRVbEk7+JnH3HiiKYG3wnntBb61wbDj
8k/edhLYqRW8ZiagDeqjLVZKNUngIldLJXduK+z+eXxGzUISlxbrhW4f+wxt
5Q7cx7Wk0N7t9L0/Si1QEFFho/JbCrWD/W+cPFwPTvxePY2N0kjb1Wk4suYj
nPLwLxC9vQQ/OJY/Cf6UD2ucVzea2MlgYfCoY5llNDRJa4l4bV6KObqot1k0
hyjODb6jxSuLnjUVS4WMSgh/bs0D9V2yyN/iue5BdSXxfadI24qvshiU7b4u
oK+SOBAxcvJqnyy6+D5cNOKqItQlXpz7b1gWNVpmyzI2VRH1tA1xGbOy+KnS
2f5SVhWxTE+/0XOJHDICr2Q8Dagmyt3NTZT2ymF2aPHy58q1hDDbb497vhxK
3LT33qfRQPzn80Qs7q0cxtRy7mdtayDspNtaXhTJoUWe9fKfBxuId3s2Wo+X
kt9f5Sex83ID4VQwesGzQQ41ry+ek2Q0EGWxDnf8vsvhrbtDVxU9GwnfHWa/
wuTl8UJt678POU1EJvty3mNFeYT1xcKvS5uIJp9nvtXL5PHZqmbLRGYTsSKX
wiu8XB5/SrMy5eaaCCb1o1yMrjxWv1UVuq3KIHSmNu24YSyPY8YKVV9cGET/
I9Wb6ZflkbEdct5OMIiR0K9zvEHyaJJYX5c+zyAm7O+fPB0ijyUaGpX+fM0E
l7Lqat1Iedy5LWC7hGwzQb2lUl5+Sx4DLIbKH+o1EwfClcf6X8ujqs3Ewyv+
zcR7ZyUTrUF55NURXPNjppn4aNT1Kn5EHs+kfNHb+a+ZqKXflfs9Ko9rvnA/
viHQQrR203o/TMvj9qnIh6JLW4iJozS//XwKGHposcJJt4VYuUcx20NZAT35
t3MVOrcQN1cq8BVaKGDD6drXZbUthJXNise9xxTQjGnyS43RQqjfXG8sbqWA
0rN9Pb6fW4j8f6bxp+wVsGNcqY+np4VgfQmmiZ9TwDOMIN24qRZiybWRDaci
FHBvYIVHuCKT6Ciaa42JUsDE742H1qswiQdjAv7vYhWQsO9oZqoziXVWqmVi
SQp4w3VP+oQ2kzBff8T03X0FFHunYfkYmETiV8JRrFgBE3pTNEdsmcRxuQaK
XokCXp5y0f/qwCTUTDue2Zcp4Jd31p21p5nE63dT42+rFFBIPv65/3km0RK3
KtCepYAXHV7FH7rCJKT0byS//amArWunUzpvM4m2ixmbv40p4PMdPgz5e0wi
40kOW3RKAdc98Q8xvs8k1i6tVrP/o4CLzKuWUY+ZxIGRhVxRQSq2LREuCM5j
EvG3narsVKh47HZz0e4aJuHjHXzxMp2KF4eMPhN1TMLG/J7yrRVUVKjUbNVq
ZBJawl986rWoGHb3WHx/C5OouWS0ctNmKpa8EGY2dzKJlxZ2rIPbyPFzM+jj
XUwiRTcgyA2o6PDZ/jh/D5NwGsxvu29ExWKfTX6ifUyCx1L9uqg5Ff1d5oKT
hpnE4AbcqGFBxb0X0/msfjIJhqTV1x3HqPhmON1NbpRJpFff2OxjQ0XXXRvH
3CaYRFjmi/4EOyp66SiKCk4xCfeguoTnDlSMif8rnvybSWzT4x366kpFp7Op
tYmzTIIuo5y8cJaKGbotIVx/mITw2BYDuQtUNOUVWH5qntzPxx63TXyoWDuZ
piK4yCS85L4Zvw2h4uH4QIFaHhZhNfl3ujmMiuvqrYW6eVnEziaFhyPXyfGu
Gc/84GMR0uEH51Xjqei93zC5U4BFzNmffbztBhWD9Cz3VAiyiB7964eOJlOx
3Sx+4D6FReROlz6LTqNiv2zB6FZhFpHUwj76OJ2KRW86LGdJX86d5S1/QMV/
JxPynoiwCIdImZfsLCqauYX83S/KIvY5rbWayaZi+rSt3jDpdQYmFOnnVJxp
63bwF2MR1GWn87VeUNHveXEIlziL4P4TYrv7NRWdawqS/Ej/+Jwual9ARdtd
SXcGSTe9Kn53+R0V+6ZXJJtKsIg3Ma0Ot4qp+OjM9rBHpO+6TEq+LqHi+/GX
blOkQ40kPtSXUXFZ4knjTZIs4ozqapeBCirGSmqrnCNt/nfXUp5qKrKHeUbv
kN7Sbl9Gq6Ni8wnG2w+kVQsCz25qpKKjeaQ/izQl4baCeTOZt0urt/aQHnN7
88mNRUX9dfkz/3frnpYL4a1U5E/WfP2FdIn6L6UHHeT5eN4+U0Y6i0u49n0X
FYmDS5ffJx3NXu7d2kPFtNOvu71IX3y3Q22il5zfo9g0IH38pnWj6AAVk3Pq
rRbJ9dDyhBXPDFHxfpUo/Rnp7ua3zjU/qSggfWnBmPSDMYd8jXFyvIw7Q13k
fjlISHOHTVFx5RmB0VOkV+gQpn0zZP73HhLpIvd/0MTttsE8maff9B17SbtH
Vq7/x62IlMnFf3/I81z75GKQNb8i5op4RiPpySqVhmKKIt4JNNh8iTx/X35/
J18JRbR1lJv/SOZli/rKvC/SivjcvWrJFzJPfw0+/9sgq4iGc/TD/89bcNCa
1HEaeb036hBB5nFnOrt/v4oiml66InuPzKtgyfV1uXRFfD87SjlP5jl6vrfO
VVMRVwi4h/78xyTMqAnyNdqK+GvLA6lUMv9Sm/UdNXQVseJhxpdNf5lEsnfK
Yu8mRZznSpfcT9bPsSSjfQZbFZG7kzeyiqwvxfyJWxn6itj1asFw/QzZj8ZN
dK2NFHH0Uk1w3ySTeOLG7fDFXBH3iJ04mzvCJNyicl9uOKKIrcIFWmVDTELn
6Ym/iZaK+MLpKVT9IPvhQEHyfltFTAsOcM0h+8V7e9ea6rOKKJAnQftG9pvA
q3KyGhcUsUjWsjSunUnsyKiwv+apiFKC6xrWtjKJyq5lCzv8yfWr3FttSvYr
xjGmTnGEInK2njAerSL7s0+Qv0K0IoYGDlzV+8QkLJK1q33iFFHWu0fPq5zs
/8xwuw3JiihpJ6db855J9Jltu5nzUBG1g/QyOl8yidmdWXPpJYp4XH9OPyeZ
SVwuTg+pKFNEkQa3ZW43mATXuttigxXk/RZwj0o8kxBUjlNdV6eIG91Nwk5f
ZxKyc757K1rJ+8dMzPv6M4n1OSapP8YU0Wnn+Mk0aybxhr6bLjZFjlf8zOCV
JZPYcntHju4MuZ6Dh9OLLZiEQfh/ZX5/FVElaynzpSnZ3+1UBkWFaUh5tjRQ
aTvZD5dO6enSafh45UgZD5VJTET9KrdYQUPe6wdrzy8l+xvPoInfKhra67+9
ypIk5z/aZftxDQ3/HA0TCRBkElE1VREW22i4U+/iL3Py+ZgdcKftkgUNlbcv
VVpa30L09hv4lofTcFXcdJyYZwthkN74QDOKhj+z/hYUnW0hMo4db0iMpaFH
u7WJFfm8tqm7oHYqiYbCbjbdl4+3EB0vM+p5H9IwZf+JDRuwhWjxX1QxKqHh
hwguuyChFqJcqqimaoqGQUvWOry50Uyo1hlNrZmloWFerfVCVDMRFNq8LGWe
hkdYoYGbQpsJ/ZkfF0/zKOHL6xOmMZ7NRBFbbpmQpBIOXLZueXu4mXj92MvD
eLUSCh6YnRRb0kw82K6r2GCnhBvGziwMhzOIcjPhkHkHJfS6/fnt5SsM4tvJ
3qFVp5XwW0VjHp8Pg6AHJxWFuSvhumae0D+ODCKzcs4S/ZXwyKyXeqAhg8ja
X56Sd1MJR10r21jk769su0Oyt6uUkOdqnhsXs5HIueYl5ay9DEdVsymjFvVE
uMWpfby/l+HU2kJbY2YlsZF9/0l4gzKe3/bsIw+tlEhZdSenYZ8K/uKJN35X
+5q4UhqTsq9QBV/bhHXxtMUSpooWWbXqqlh/MHSL5cYs2OFedULquiq+TaBU
H3Z8C+k0e/X636qoW+l5XGOxDLasX61jP6OKa+HFr6Uy5cDaO7VpdlYVZy1P
f5pZVQ4Un7B96guqWPL4i3CSRTmcb37qcZlHDW/2Tj3d8LwcMGyyVEtCDWn1
KwUWj3yEb6Oh1jEr1XBUzUPW5UEFqH98nGx2Qg2vrBsc2SZeBY1as5lsKzW8
k98Zt1ulCnyT9+S52qih0qOiE4brqqDOZbApzE4N9wj/3it+pAo8JFcLEc5q
mKpxOHQsrQoI61z/NZ5q+GCYlsvRqIbjs/m2kjHk+G4nM5avqwE+e/5z92LV
MO3B8ks7DWogt84iQCteDb2/zbgcMq8B7vTp1D031PArl4znDo8ayDbSYwal
qmFtepiZ9asa+J1YbDSepYarv0TaxGjVQrx2uWZLiRqWV1dN35atg2y9E0LB
pWro5uwY0L28DgjDqQHdcjW0XhqzUXJjHfyyXJGV8Im8ftJA/r9DdbAvLFL5
YL0aWgkRRYmxdSDQbS7DaFfD/gHcHsFdD/7xvX8bptTwduZvG+22eki8c5kd
MK2Gmed1In/01cPTR0uLtWfVcCTn02jseD20vd/tGzOvhg4b2GZ3hRvgv8Fn
EyY8dLz7wvE+sbUBxnZ4DtRJ0HHnnb4RmdsN4DTJ11yjSceny04Vt+5qBJun
OxuttOgYEacgZXCgEY7YhdaNatMxuezUs1TLRtjVxFu5VJeOvjt870q6NcKK
ZzzFdpvo2PPbg6IU3wj99lxZc4Z0VPjyOfM5qxHYCvgg2oiOWvajFwfZjcBi
XElX3k1H7cSSfUv6G6FC/1+qkTEdL3OLU3R+N0ImdTE24QAdJdNaj16RaQKH
lnnfVdbk5zt00mL3N4HV9a3e723o2MRs9Lt9pAkOo//F/bZ0ZKoH6t6wboKd
uX/Oep2i43vXM7R9Z5pAPXLOvsyFjpcm0zNY15qgd8eMiaU3HT8tD99j8rYJ
Omb/Mx7xoePgm+4g9Q9N0PLCe/eVS3Q8bTF8ZrC8CcqVpndkXaajk8BB882N
TfBgbuq/8WA6nhrfpTXe2wT2ryZUrsfRsf1jY303PwOqhfx/bU+gYyTrhJs9
hQHa9rzvJxLpqDE6kNUuzIBZaZmjVsl0NJtr782SYECc58aYNXfpaLPku3eB
PAOm6j8c77tHR8V/U81sKgOOL9+1MjWDjh6WEWWzNAas+HLkI08mHTOFZKzE
VRnwfpPv3OendOxvP3Hh5UoGqMVzVUU+p2Pp70n7y5oMCP8RcRNy6biYGtW/
TYsB5qmpa568oqP0RFTanTUMeDeu+tc6j44tFy4wNusyQMn4aa10ATkfuQM3
69cx4MefIsfL7+joHrmnrmkjA8wOGa7XLaLjr1olfdzEgLxndVzfi+m4RvQU
ZukxINCKfWc/QceJ28KTJlsZsLTkb7NaJR0veCyTWoIM8JMNS2+toqNuWcw/
jR0M6HEXPxtdQ+bPsCVA14ABz5WVKdP1dJQXeqCptpMB0r6PPz9tpKPK0UxL
ISMG+DDWPDzJoOOqCReFftIGV1G/hklHykSwid9uBmS3V4sEfqajXkNU6fo9
DBBbd7B9XSsdnzHKK7+S9ohsfzTQRuZxc/LJ0L0MaPtm55nWQcfR3/5RisYM
0N86tOMgm44Ea9z4MemHNzwkBDh01LcMuKexjwGUkT/som6ynlqfhaWRdt8Z
8vTcV3I+7tJ8AiYMYKWJ+Kr30pFv1FTOgfTm3zeM2vvomMHNW/aG9D1T2pLY
73TM5+dwL5Lme5TZY/CDjte0b3RsNmWA66JW7swgHVce5OxzJc04UuD/fJiO
tctDjsSR/u/F9r12P+m4Vcx0Ppv0HcFKWdlROr7Rldj6ljSXrVlf7RgdUz0z
ZYtIO7378urKBB1v+I3GviJdL3nyyoYpst5SOzLvkl7nMmAy+JuOtmNHLQNJ
p5Sdo96boSPutss5RPqvwuyA+Rwdc9fO3lcibe8RVCA4T8ccznI9Njn/6lpK
yPsFOs6ZzJ+PI+1m+DW+hnTqE8ZsNGnJ94X3vpA+JSkWGEn6WI5r0RhpEYni
oGukB+Lqx9X/0nEj14iTP2kBi3jbGNIHLR6+cSJt2C2nb7NIR2qW16mtpL8f
Hdt3hvQ917UpeqQjGdWWvqQLfc1rN5JuKbvklUhaK7x+xVrS9pmdzytJV0Sm
lKqTDnJJV1zzj44GYwk+YqTVv/ms2kZ6i3N5sPD/13P8wKa9pKONj0cJ/n/+
JtyHTpHOOVJ6k5t0us6pyFukv3Y5Rvwmz9/g8daUTNITw82BE6S/K8s8ekW6
zzfLY5S0jtSnsjrSLIkQ80HSLdfvNrWRZsrF6H8n7c3j3dVP2uXJokYvaaq/
2fAE6QKiVbyHdMnkirl/pKtt5CfZpP8Hfq6ffw==
          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.31353019895394485`, 0.48649847604027}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 3->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3B72WcQKmZGlDVKSqh5zpfIUqKSULJlT6UsyRalZJeyR5ZI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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.291161274917494, 0.4343944236404684}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 4->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c81P8fAHAUhew7K8mdMjKSCt/kXm9JpVQopIxQIWWVjKyM7IwoUjaV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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.2743815636982917, 0.399651908564373}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 5->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8Ve8fAHAjRMjmXntERhRCyfk8ooWQXSHrSypaVpIUGSEjOyMSIqEo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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.2340615072537411, 0.37409273587771125`}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwd1Xk8lO/XB3B7lmSbQRQzUtZQiaQ6RylZiogQKpUlsqWkTd/ImiyVtbTY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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.3461261180190739, 0.581865061766651}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13c8Vf8fB3DbtUcyrivjKiWUxjct73ekIVRKpRAyIqlkRSSEbIooRUVp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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.31353019895394485`, 0.48649847604027}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13k8VN8bB3B72WcQKmZGlDVKSqh5zpfIUqKSULJlT6UsyRalZJeyR5ZI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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.291161274917494, 0.4343944236404684}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13c81P8fAHAUhew7K8mdMjKSCt/kXm9JpVQopIxQIWWVjKyM7IwoUjaV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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.2743815636982917, 0.399651908564373}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13c8Ve8fAHAjRMjmXntERhRCyfk8ooWQXSHrSypaVpIUGSEjOyMSIqEo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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.2340615072537411, 0.37409273587771125`}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}]}, 1]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{214, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->830793578]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->365942603],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PopupView Content",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->58372559],

Cell["Start with the third item shown:", "ExampleText",
 CellID->89777391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15937],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 3}, 
   InterpretationBox[
    PopupMenuBox[Dynamic[Typeset`var$$], {1->
     TagBox["a",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["b",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox["c",
      {"ResetImageSizeLevel", 2}], 4->
     TagBox["d",
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 3]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{42, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15393013]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266341019],

Cell[TextData[{
 "Display a framed ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " to indicate the popup: "
}], "ExampleText",
 CellID->45431489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<item 1\>\"", ",", "\"\<item 2\>\"", ",", "\"\<item 3\>\""}], 
    "}"}], ",", "2", ",", 
   RowBox[{"Framed", "[", "\[Alpha]", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190945832],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 2}, 
   InterpretationBox[
    PopupMenuBox[Dynamic[Typeset`var$$], {1->
     TagBox["\<\"item 1\"\>",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["\<\"item 2\"\>",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox["\<\"item 3\"\>",
      {"ResetImageSizeLevel", 2}]}, "0", 
     FrameBox["\[Alpha]",
      StripOnInput->False]],
    PopupView[{"item 1", "item 2", "item 3"}, 2, 
     Framed[$CellContext`\[Alpha]]]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{21, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->361024598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->368493193],

Cell[TextData[{
 "Use graphics as content in ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->405781175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n", " ", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234501074],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 1}, 
   InterpretationBox[
    PopupMenuBox[Dynamic[Typeset`var$$], {1->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi
I6OhRHjskRSKiGTvc26bY/6e73X9/nFfr+t6Hud9v9c58lbOxhe4ODg4NMg/
/ztf3Lbi3WITqHPx/8+ynwyDk4xLYPBDNecEeS5XFN5nMDxBRGPDZknyfFEU
ROdh+INEa2N9K90fHP5zd5yhR0MjitplTJ4/5+3CR+mpkDp4suG0XCqsbO1S
ZtJzIaJ7y+pnErkQ/zXuyjC9Gk4/j7z1froKMrP8Wx3U/oBXTXWVgHsLXIT6
6BHXbnh6HdZz7u8CjoTpvNbAbmhouZhw1bwLolbItn1N7AaT5cnpP05dUFVt
S0tt6gZB3RyOh5FdoHJiIeGCVg/038r4z3ygCwbslNPbOXuB/3hC2i+/brgc
dquwLqQPLPl01WsLesCpd313duYgjFqI7dvL3Q8dli18xdWDoMuXdXylZD8c
b36oVtszCHoNYj25Kv2wq6bfs1d6CIaVyk4wj/QD97skUUm/IQiJKOZ6FNkP
UV7yOtfPDsNoVhT9hfIAFFPXRGuKMsHpwvixj1qDsD2oqnDfBiZcLG5+aXh4
EF7zevQY7WdCiNqb9t+nB+ERu0n9shcTvjd0Tb7zGgTTf+EVMQNMyOeS3htY
MAhDaaKT80UscCnzsKjaPQQC8j7K/3aNAt8Xz0Sa6jBUaYeq3943ChYr0uod
dw6Dr1nsTjnjUfD+eUEkfe8wcIV8PnDafhQ8j4U/m7IchrmlkYu/X4zCRp03
lPywYRhuM0n5wTUGJZOxt0RmhuFblPL6om9j4BZpHxDzfgQCsrdvOdsyBoYl
QvH5BSNwsE5Xc6l3DDrOnG78VjUCZSstDmkvj8GD/Hs3c9pHIP9ayKXPW8Zh
w9zMcjY/EzJOsFPfPh0Hc42dtMMWTHgsWqMaf24CuDu+JOdMMCF3p9zHo04T
ICX0X+WRRSb0WDrDws0J0Nm/aaGWlwW7M6gnTkZOQLVsUsCjNSwYOGRxa9X3
Cdg953WTU4cFe+4zf3junoRcIR5W2T0WOKWBufKhSdjRcGc/O4AFMfWhPb9M
J8H4QqeB1BMWjNI12Oquk7DlR+Zh0VcsiM2/rdCXMgmneM86TxWzYHZKxN1Y
cgoeJ+xz85tngaKc1fKy4hQkdKusPMGF4ejebP+MLVOgHJI7ys+PISnMLJbv
yBRoTZhkb5HEYKweX1l4fwqyjoKHizqG26YTRg6hU2B0r13LbweG1Fv72tbE
TcFZ2yI1v90YOL4NjrrlTcEf/p9RegcwZNhtld4wNgWZQgHLr89gaA72SWxe
moJxT0YjrzWGFTlNar5C0yDvn5tnaIfBnOfmnk7laRgMCH393BUDX0KpQ6Tl
NFxlN0Up+GLYVi0xs9dhGpyFBX2/BmCwHL3oPe45DbbXttqeDsbwUUfo6ZGI
aRgA6vjOKAxWrScI7m/TULWusb01BYPAs07HKy3TcGIhv+NzOob35k6y//qm
YQ3HbNidtxi4//h55nHOgFHYz8XqHAyJzXnbruycgaMtD14bl2MwiDrQ1b53
BnSkl7q9qjBMnvwVYmA8A16FWoUhNRj2/WYylR1n4IfyBeRej6GvkZHSnjAD
fEsZelvaMDyOyDA1eDsDtncENqW0Y9Aw0eLJK5iB6pqgRL5ODH6/jltFNM/A
y+222317MWwO7xDl7puBN+Ghh171k/k77ki4TMzA2kMhvamDGFR++soaCM+C
4jGr9KtMDHVh1JpcmVlI9Q/4pYExeBi/9FRePwt3+tVvd49iYFA2qURozMLw
9bUpnuMYqutzm7j2zgJS0DdiT2BwDd3/wMVoFpKTwzyspjBIG/3c1m45C39f
Lct+nMZwuW4kJNdzFnI/P2+RZGOghHiCst8s/DpOH103hyHPkJcVHj4Lv+3t
79LmyfyLPHnOlTALvMP1/hwLGAR/0A+7ZM1CafQHwW+ksx+ns//mzwI33ZvH
exGDxVHNlMNfZyGT48s1+hLZH8IVprm/Z2H+1ZhlMun0WmMe5d5ZII6UF6xe
xnAi6N+H8PFZeKfQF3aV9IKBgxUXBxvilMXbc0gnCrFFXVaxIVaXHtdL+si3
B8RfaTZs1OhvXCA9HUhxOqzChn1vTt9bJB17OE42dwcbnJW9EvtJ7xfcWKO0
hw1fxMy0v5Bmff3sGX6M9DthfQ/STwP2qXBZssFO/UctjbSOfkOTsz0beJ80
V2aS8fbxn33w14MNU2Weu1RIB1cPbzvsy4brQWKMQPK+u/w9uj4/YYNbuPCd
32Q+Og7yhCrFs2HdeWyyivRDvjAIz2RD4Sm9pI1kPjdX0Vic+WzgL01y3EHm
u9nvzXPnajbMEZVZymQ97h7YdfhvExs2Gdk6cM+S/bGynK3fw4aLJwwTq8j6
1VUYpXweYwOXzzmz62R9PXzbTZWW2WB8zc9fZJLsj/32POFCc7DwvHhXKNkf
V8p9rJyV5+BYWLaEEdlPtJ79vNPb5kAs9PKOTLLfarj407zQHOyLfVo6M4xh
HQoa8z81B6lEsPqxAQwNloYRorZzIL07RuRsH4Y7t8Q0I13nQDYswsq8B0NL
XsTdxMA52OF+xlayA4Nvy8m1G6LmIGlv5Zrff8l5n11T9S5xDr64WezzacUQ
tCNWhCiYgyW1SoHEJgy6b1/HtuA5WL7n7Mkm54/13U7v3MIcbF58t5pWjeEZ
U7Wvj28eUnf81FavwDClmrVpUn4eqsJZ0lJF5P5KyskXPjEP36nfrRffYzAt
8zwXcW4eng7PWPpmkfuge/cKWcd5CJjNYs2/wXCGUXR4vS/5/8p8fqUnYhB7
VvVnz+d5MIm4wl4XgaEwN+D217J5kNhwuZkaisG+2UDBqH4exmkxlqxHGMol
6i9ZDs1DgXbT5Us+GDxDWmY9ZBcg9UL9t+vkvut8MCSZeXcB9G5vVpvVJ/dF
Ynre9qAF8H19tebdPgy7S50sv0QvwOBbeR0zhCGCYyKp6v0CWGb2v7Un9/Gh
m/Pbu3sWIEegVjWDhuGdi9Dx1YcWQUxwIvAFkwXfYqieGaaLIPlEPC66jwV9
ZdJxejaLcHXwkuOdfyyQXrN+2OHOIqSqax7jq2eBT/G++8UfF6H72ptikQ8s
MKXc+XBZYQnihIwU5lzJ73Ft35Zl9SXQcmq5En6ZBQG2Qcvh/y1BffFU42or
FhB5zw4TZktgznKc/HeMBSrWn7upwUtwoN5O024TC+Y+jFEL5pdg9LBbsG0X
E8TbZzWN+ZdhYXK7SlIzE9T4OM71Sy6DQlK2zvfvTLC2EE4X27oMYfFnODvy
mPBtxYa9tnbLoHc3K5krjAmxJjZuIo3LEF0Qv6ivzYT4m/ZDm09yoLvIUZru
PQKbi/hn/c5wINa/R6+C3UegaEUKzz9rDrTdus2AdWkEOoJ6GEEuHKhR6ajc
NeMRoL08c3LQnwMplZX5vFUYgZgyw7L4fA7UNF4u9JsYhrBV22MpCpxINiNK
U4E5BPfiFowmRzhR9K802mOJQTi2+fOVDROcKLXsZrkk7yDQiq+GWrE50ad/
UUYh0wOQ1zVUV8fDhShh2mD6ewDG17UYZtC4UOnvKg+1qAGwSv94xPYYF1ql
7l65WmoAdHOdDjV/4ELCr7Q/rxHoB46fHSj/BjeankjZIFrZA0puth4nVHlQ
XntW0m63duiZijQVLOBFGhZPK+LaG0C/9/KtsCt8qP/rJWcG7yc42hOygUYT
QCzTFJlFZ4IYKrW6W5UhiD5WeLT95P1FqIk1ye05uwpx12vvqdzYQfQF9d2L
uLAKGa7zGXii10G8EJjp77dfhca07WxNzToIoRWr3z/yWIXUS95/zL/fQQxN
n9rfFLoKpes6KK/600Ektf11ulS2Cq0+lhLxzqeTkE3pJYLXC6MD+DZ+U99F
CMDU+bYJYSRdnnM76kAv4aGrwvdpThhd//YmaKVFL9G353RmMKcIGs1xmbB1
6SVKDhbP6YmIoM9jn/2mo3qJG8ZBT1JVRRB3Qdu2k4O9xPCFdeXXzoug1KHX
5WJ+fcS3RyYqYj9EULla//OVn/oJreCH34caRVCoAbpxoaqfSAn94lbWJoLS
dgb3v/vTT/g8lS++PiSClD65aEsu9xO0uumNmEsUOVuUmAseGCCaWkrKTWii
6Ol9rdFnPweIA0zzGQUTUfRigvvSYvsgESt+/+cdM1Ek8/XclWrWIDG5+01W
22lRtH7D13X3lwaJlwHzF59aiSKDXnNbQm6ImFN+3szvIoqYV65TzE8PEelW
f3NHA0TR3tYv8cI/hwjR5rNehUWiKDvvaNaG7GHCdtnPTKZMFH1/efNtVPEw
ka/0drtHpShKPf2VOv59mLjkzsHc8l0ULe2ltV4aHCZKKPFnklpFEU9f50UH
uRHC7UiXzqNpUfTpQJP3R+8RornEhtN8oxhKUNZvl97NJEZ1/0jfUhdDXE76
2gf3MYmVxYbbX24VQ6udULS1IZPQILQu9u0SQ4t/tHbaWDOJ8C+ita77xFDd
JNXsUQCTMMzOjwq0FEOdA7ozro1Mwnbb1veZ58XQ8Oyc6612JnH7fXJNvY0Y
GtjqGOzezyTS34YtSdmLoVPbroersZmEQIadTeJ1McQj47qzVIZFVCSJby4I
EUNepk0HXc+wiPa1AYc6noihl/cnjE9cYBFTr5atuCPJ55Nb0hQdWcTahKGI
Qy/EkL9m4+YALxZxL7ZovjFVDHW9+yt2LYZF6EQ6VLJKxBCLUbK5vIFFmEp2
dYhViKFiM+1RzxYW4Rhxcm57tRiyeCv8SaaDRTx/orfp5g8xpGJwba8Sk0XM
Ba9+srJNDJmXshdMeTHx8WGZJWNKDOl9DnyouAMTKfo1q/1myfz0hzXK7sZE
jFBDA3NeDO3Vqg1aRpi4G/Jv/xcuCuJj9ap5G2DCIGpOzVSUgnS+Pyhys8IE
mHMO5lMp6JVU2MTni5jYKsv3SlGKgv7ph1zpc8CE1EsJqTE5Ctph5AmL1zDR
lbx5OXAD+XySRuGaAEw0XtqZO65GQVfXR3UnP8ZE1Qadq6e2UhCvePlO+hNM
ZGQd7lfSpKAnI6/PVj/DhEeO7Y/i/RQktXPzScF0TNh7Ovqr6FOQvAj9eVcW
Jix3u+0JPkJBopENMwkfMLGH8M6xOEFB28sLB9rzMCFc+Txu5jwFJT+otdtT
hQlO/1enLC+Qn9ceLGNdg4lJ/TRquR0FnT++vd7+OyZavuf4hTlTkEKTo/au
X5j4FlKoy3aloKDIeuZ8EyYKjcvnz16jIJ7O7OiUFkwkNjU4b7pFQbH3j7bk
t2MiMqplffhdCrqWZ3ZpbScmAsw7uufuk/fdGTDi1o0J53bmyaoACrotUFJe
148Jq5eTYuqPKcg9LH512yAmTljN10SEUtDrCnOzumFMaPXxIesoCtosWRZ1
FWNiU4rIXPUzCpJoa3iqMIYJxmXJ7M1xFKSR5OGVN44JykY5p8gECjL3eXxw
9yQmeFiKKktJFCSMltiJU5iYzVLtskmlINvjJcEz05gYurLleU06BeWzevm2
zWLi77ZdplvfUtCFWR+bk2xM1E3piEZ/oCDDVd/ibeYwUZqz7+vyJwp66T1L
mM9j4pOngY9tHgXpnjcr1Fwg+2v3cZ3aAgo67aL/nHMRE88WT81uK6aghg06
p96Tfkycex9TRkGp1R8mDy+R/eZ90YGzioIsNbWdvpO+usdJya6Ggv5b61mu
uYwJWx73ju/fKSiRKTsXRFqaXv17vp6C/rShT5Wkv++S+6HSSEFFXusOMEnf
M75SYdJMQc30D+lLpDUcygvutVKQ+I/2vnnSQw/WfMxqp6C2Q2lTPaRj4xzT
2zopiJ93bUsuaePc4lf8vRTUq34x9AZp3p8SzzQGyP5Ke0ZTJp03cinMepiC
nFdN3yXIeJ14C/1DWBTEnZrzeQ9pBQbFu2CMgqq81So+kPdt0rT1GJqkIC/j
j6kipAOO5zlLzVKQU+AH65NkvnQchS/unSfnxfjFZACZz3FfK8srSxRk7z1h
kUbmO+nlJ5NYTiqySNnz4iNZD7M8gSM1K6goTUDlUzpZL6FflntnV1IRjjuQ
EjyDCbeVK7cZC1ORVClVZg1ZbxX506p3xKhIoejIC2ICE21aWfLp4lTkVft3
3ojsl71OJ0V5Zago9vlrIy2yv2b93qzcRqMiRfMG/RAmJtLjl5fOylPRVprW
2gayH8Ubk5m5ylTkoq3utWYAEz27Z786bqeiaKuQrk//MBFlYlASs5OK3CTW
Ltv/JfeH88vcSi0qKjrH4F3VionshIMp8rpUVPz+VAuFnCcf/ugHjUeoyP5s
WfEmch53KTK9uIyo6N9hTUs9cl5HtHXd1E9Q0XNfx3G9cnI+XAat/M2pyNMk
i5+PwMTa35rov4tkfAMxGxLeYaJ5NGjn5ctUFHg5u0AyExOPBLrUIh2paHhO
0Ox6Gjnv/wXIjV2lorbFV5kLCZgoS/wzl3iXitQKbiutJvePtevNj0IxVNSV
oX8v3Jnsn63tH9e/oKJIeMLXfRkTAuPo0/6XVNTyJMaXZouJt1d4c+6+pqIV
d267W1hgYsEl9PPkeyq6KWvoOnkAE0+dk7+01VBRCP/FN5EymLikLpDP/k5F
SOSkfI4EJrSxQ75kA/n+0diSUhFMdDttLTjWTEWhW1MjErkxsdmpoLCsh4ro
Txx7fYZYRLXDz+L0RSr6cajjcWk2uf83apRUc4ijA+I593MyWITLSFRJH7c4
UtrT2xX1mkVIOliWMgRIP3wyphjFIqzsB8vCJcXRQ3Gi5vQNFrFwabnSS10c
HYs85ma6m0WoX9zw3eC8OPr9sLsvOotJtF+iO2fYiCMOCa8yjyQm8ciBKips
J47EOlTv6D1jEoNX5o1+OImjvDh2ylNfJvHKq6bRyEscrTIdeqFnwSSkwuz/
mkaKo6V/iXlZ3ExiOf/NyLlacRQUcVBDas8IkUnEBRXXiaNbN5zGz2mMEBYl
T9QUfomjwDdWoU/XjxC5lTdduv+IIx4FneflIiPE1YbDkxcGxNHWnpiBba3D
RH//8PxlbgkUtcok/pTTMPGDslHQXVMCOWZuiRP2HSLny3HwmbYE4jpovmn4
+hCRWZlZWQISKP6Ct0HOpSHisdcWH9H9EqiCKnOedmSIMOjTWHxjLIE0H/S0
qVCHiK+5urjLXgLR96kJ7nw+SJSfO/nzWKwE4o6ReuuZMEB8ybz3bCO3JGrt
e/JfqXcfwWtgIh3JK4m0jemjR5z6CKNB5WhOAUlk2PJ5f5V5H9GvWPu0SVQS
hURIrHm0rY+gRkuF3aVJoo3NfD1GPb2E/f30h780JZGqW1d5l14vIWPW5O7l
IonOCFu98Z7sJm5yqh779lcS8U7tvyi1qZMQaLtx0ClbCn1wOdV77kwT0fta
PjzOazWirLtveTe8jAhXWbMi12QNsin3C+FtS4WQGNvK8wxptJFTjmbs+QPM
w898F+qXRnUSgv6dtq0wuzeJHVcog+xWZxcLXukGry9x98uKZdDro3uWFn26
gWNrzKrBMhnES9+q1hPVDSvpwfJba2SQrC9156OibpBkexwq+y2D/IW+PT0k
0gPbMgyiB0Zl0Br3LdNOaT3gJDG5a4uiLKJovV0l9rsXxgNZJSZKsqjGau/t
y4O94M41aHBjvSx6KLbR7tN8L3jhv+dK1WXRs5G6G+sYfRBYXfnQRFsWmaTs
OX/Wrg9Sbj1r9jSRRTqOurd2TfdBd6+eR4mfLBrjeiG4feUA6MV9T1ANlEXq
p345bFgzAC/NzGvDHssiidc5xmIbBsCy5oqCdYQssrGJ80g5OgB/3r78xv1K
Fql6B5RxRQxAw80lxr5CWcQRUbrHgjYIJWJ51ZWTsuio1rsKA8UhkK/ZN6k+
S8aj+y9kYesQ3PWpp0XNy6Ll6LBT0XpDoDMzcNWOSw55XT2UG31+CPLapGj8
onLoeivyyI4dgvfJ7q76G+QQhXLxxEGJYUj4b4tM7Xk5FMfxxCFuYhhKjgrc
n7eRQ18/r/OaWx6GrrPdQ+vt5FBQW3HjHqERULwXkefrJIf6vQUPxq8dgcQK
9il0Uw4J3l5l7HtiBJIMS6I+hMuhO0Oql8ffjkDFuWccXZFy6NcZ+8dq+SPQ
d8XNTvSZHLrRlfrArHIElMKVdjnGy6HoV8w6978j8Lo54LdSphySt86QauRj
Qsr545IxlXLoH8+iG8OCCVWuG29XfZVDqlGCTzRsmTBwn6dvulYO8bkGrtZy
YYLK65yPx3/JoazCcMTvw4TUIRmTVZ1y6JyXuWllGhPSrvY8uTsnh1atnTxc
MMmEjAfuYhc30dDXZwP2djdYMKJ95t6DzTTUWP86iO3Ngo2TeydebaOh2DqG
ooc/C9KsxBs7NGmoKXFN5H9RLEiBD1Hm+2koqNhIaTCbBYnsUfrRszRULvWK
QQyxoOdtc4iDFQ3Jtci4rRtjgaJdEWfgBRoKvJU74zHDgoSm4O5KexrysRa6
28+NIe6DWrKuBw0F127e2CWDIcbRQW1HKA1ZmSvW6x/E8Gftibjj4TQ0bOXp
eu8IhjVtu0VdI2lIo+ibYLIxhih9wfHMFzR0ZOfUmhwLDBHKaR9V0mioXzTG
cNwZw6/2UKUDGTSUWdF0OtQNg/hTz8gLb2ko5ovRQTlPDGErDnkmfKKhNM/l
T/PeGEI6+7VlS2lIOP/dy4YwDHVRPzK0KmjIyY/XpvkpBpFjObRT1TRUEVYy
/jUGw+NCX46nP2hI+0GX3bUEDI+erSsTaaOh2zTn631vMXwzXrVD7R8NNdw8
ZWKcjUFQYCrJoIuG9p4mRtJyMAR4lPn5D9CQwo4+UCjE4GdifZh7iobiNwfp
rv+KIcGwzeLCLA1J48oRjVoM+YdMnCrnaajruXXzpjoM4/8dCA3koiPTIGO7
340YhHYVJTB56Gh7fxRfQDMG5a2a2Yb8dPTuvFLnulYMFkobflNF6chH9u22
NR0YrjMSB9ypdORSJ5/m0kXmQ1pu7rckHWU+Ljd614OhUlhE7rkcHf27o6vG
GsDQxfdQbYlBR8ZvxM4NDWFY4OJE59bS0X+/uAt+jGDYOjNutXYDHQlnjY2b
jGI4Mmbv5qtGR0KcdtXTYxjshnseDGyho/thU+V3JzDc6z0Tqb+DjvYH3+2f
mMTw4l9TSvouOgrxWt54bBrD5xbDPGFtOsrW9IyImMHQ8LOqxgXoqI2Dh1E2
i4FZq/u3QY+OXl/8WtPKxsBXlcfavp+OSs9yRrXNYVAs2cYReYiO/HaO36+Y
x6CTny7GNqCjSzFTj6MXMJh9Wqd4+hgd3Qp1+2yyiOHq29jtBcfpqOv+wPIc
6cdpUvvpJ+lIdmerjf8ShpTEkJPe5nTk/KOvj2MZQ2ks/6XuM3S0ru7jg/Ok
26Pu3dh3no5qZLh135Bmh80HJtvQkfVk9Op20uJBbi/47egocN5EaI60mh8z
096ejsK2Ksoukz7kbVtU60RHwXOL//u9DTY3/9Wru9KRufhEcBnp2+5m3aHu
5Psv6ZM+pKOd6ycnPOjIkv7OTY109iV9XlMvOop26RUrJuP9YV0q9fkOHVn8
FPimTXrojPZ66ft0NNh751U8eb8VZh+1vHzJ+JI+RGEyH3RjNYN2fzrydFyX
rkRayyD5DAqiI+qsTft+Mn8n9jOcE0LoqNeCsvkYmV9nFH13RTgdLYi2x+uR
+Q/QooTZRtLRgb6H22lkfZK2B76qiqEjbsGegS6ynkVqKz6qxtKROn89ETKF
YUph+jcrkY6S7+5qSR7HICrnPHgshY7yGirlxMh+UZUamHv/ho6OZFL8rTGG
c4J/5K6/pyPve5+bS4cx3OA5rt7ykY4+iL8h6gfJ+V+uQbtz6Sjl/MOGqn4M
XycKrJcJOrrD2+ft2o1hR1t8ql8tHTm5T2zLbiE/T81uNquOnJdeC0LzN4aR
O2oHmn/SkVfyt6tvfmFIVPzSo/KHjup1VC2P/yDrZ/+L/rWPfP7wHbuPpRhG
82OcxgfpqOWYrf3zInLehc8XSDPp6M/E5STnAgw+75nm9hN09I1RWvHnE4Y5
L+7DvBwM1HdYhl2agmEgydY1hpOBqmR5sFAShqbv1dFq3AykUr5rk148hveM
kAFTXgayOr8YeCUaw+UyWd9kIQay8V2/uuchhhZBjeKDaxgoXfNdvrQNhort
0QNt0gzE1xfmuP4s2Q9nFkSuyDKQ5W39sLXm5H7LKrGMpjNQ93T1ng5DDAeP
Gy4MrmMg45aoeEctct5i7HYGbmUg2+Divd2CGF6X1ljStzNQ79Y/ZXk8GMJH
1Hw/7GCge/vujd5eZoGLztSv1l0MdFRF0rx2nAUqXd6uG4F8/+yKvnvNLIha
/yyj9jADuVPEfE+8ZMHkxP6k+0cYaEuKzhZz8vvEsHD8uaYhA30oNPc8FMIC
3uP6j5KMGejSJP9szx0WuHuxL986xUBRLx6aiVqywPjHSZVNFxloZuXzdTqS
LMiM5mZ02zHQu6BHfh1CLOC3yZKKvsxAN/hujDhws6BolncljxMDEbU8rXtG
maCu8Km3zY2BhEY9RIermCDkLv7q0T0GWrfApbPuGhPsoChGz4eB5IvTN9vb
M6GU3yFs9gEDtdZef/7sHBNuxJZ62/gzUE7duuUv+kwYrHQ9px3CQHa+/zXM
yzGhQrpebuQFA0nH+jJvF43AnaKgqMO5DMTIipesmxqGob9F4ew8BlIV6FXN
HhgG0/mJkOR8Bjq/ViLEp3UYNmqY+3MXkfcJ8HIdKhqG5jdKN75UMBCP+Y64
moBh2BpJnN7wi4Hm/v7iHpEehj7HMZogZqAB90na8MYhOCJjkvR1rTzyfCSz
CaQHIKpHrei0kjyKLNponMc/AD0ZfK0jyvKIHeT3SYndD14oX1RkgzyKT/11
4efvfki/oOh1fIs8ElLsuHUrvB8E3o4Zt/0njxzoL1PlBPuhcu9jDpapPKKv
N7VvZvaCrlPlaTF/eSSo8XRjcmA3xMlarf02JY/8p2+U6j5shbWlyU+PnlZA
6e9+6sxr/oCQTSWqDYUKSD3hU4BOchrYTqyor1ZVRDbzK+/d+q+MsHo3zvAP
VkQKzExm9IEmouor3/38BUUUePyAYY52J+GwpzOkmvQniuyBi/91EqL5ubFN
pH9ZULSldDoJs4zLeaOkv8tay12HTqI/+NvY2kVF1C4VVqCh10nwmoScCyIt
YSnk9vFAJ7Hnn5SO5ZIiirNM+vzWuJPoOzl62J70h2rXE+eOdxIBdVWnPEi/
k7JkipzoJBqKPd3DSFv2B0k6m3QSVomt6RWkbRQN928y6yTuXoqTUV9WRHW3
dWRSz3QSa7uur9cmLWPb9tDMspOoMj+28xBplsXTiZVnyfgNOI9bk760wrLI
9lwnEadmHRBJ+jy/5s611p2EXvLuqETSz3ZnB/0k3UcXf/2ONH6i33nPppNQ
EysvriHNq1d1p/MCGZ//ix/NpK+cyfoaYttJXOO69reXtIbqOwq62ElI3zw6
PE5aNbD2JCZdOKHEXiYtb70iJtauk/g/DxDigw==
          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.9999993680039507, 0.9999995755730018}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 2->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmnc8Vf8fx+2yN+EaF6kkyjdK6/NOGkbDTGZ2IaMyihaVHamEQkoRUUoL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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.999999941761652, 0.9999995837354044}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 3->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23k8VG8XAHB7shuyMyaFStqkUnoOlSIqQiUplBZLtIekUrKUJVsIKb/I
VkKUPEh2sm/Zd2Nmri27vPf9y+d8rnvuc85z5s79zkCzuW5yiYONje0LFxvb
/3++8bDh2XbRb/+LzvLidX7v9xc3KBqeUryKGIZx/FtbH6OVkvwnior3kVwx
kVbfEozeFLygciv6IPFZS2Fmczxy0L7tOEt9jb4PsGXENGSghsUrIePUJDQS
8V+0f0kRWvWnT4VJzUX+A0d8/YPrUWvBj9uMkVyU8vLy0ai1DejjfxE/xz5/
Q0IiLX0oowEdu3HsPP1AHkoTOay0v7YRha3+FjZ8GSMsv/ZMDk8LokSXcUy0
FKGI1+541uIPelsR6zJGLUelltGck7960XRE1sZu/3IUk6B6Inl1H9K7XNlf
P1+O/HeH/mMZ9iEG56zZt4YK9MIjJUmovg/t1j6m5eNdhXhKC9k9m/tRbfoS
hwrxG513SA38XjKIKGi1laB6LTp3Rs7clGMI7VUO0fK+WIvql5UjzmkPoZfT
SVOudbXoH/dE0PfPQ0gjqOmSTXIderfOVc391TB6WKFmsO18A3ovo6bYsGcU
JX7+qpwc2oBUd/0JKbUfRfURupzrqxoQ5dYXPYk3o2jd5dN5Unsa0YYXIhd+
LI+iCk4vdTaxJnT6Vb2hyFc6mqYL8bvqN6HHmSXOmf10JF//enjqYRPqKI7Z
nyQ8hpzj0uOGGU1IPXPR2vPSGJLQ/kP5XdKM1vR98i3hZSBYZ0ccWW5Go19m
39ZtYaCr/BOVRTtaUMEjX+Y6cwbKa+N5mh3XgsY9kvbHxTGQzZ3ts29cW5FB
w9E3v9WYyP/cjwbJz63ofngDH8cxJso6eORT0HArkhB8anPbiYl4xayuPjVt
Q8GM/meyqUyUlu7zx0G9Ha2Opn85TmMhOoXub2Ddjjp2xgqnarGQyh2D/aoh
7Ugp6WWg1UkWitvH/7Z/vh05jF9t/P6YhTpi7U0K1f4gZ05RX7vXLCTNWcUZ
e/4PKrxy3cA2nYWCy/3tLH79QXfHty+eaGOhGjWm5O65P4jmobUMTBbiDzQq
X7OpAxU+PLD5ERuBvMyF1OoCO1BG28NL4+sIVJDr1Jn2swPJ3Q+KUdAk0LLc
75f+Mx1of+aly1F6BLrTHzBx2LITHTtxdufDSwTK0BuPXx/Qidjse3wHbxKI
SDphylnUiQzcpkRePyKQmuBn7t7pTmQt+On+65cEuuIs+jVfpQsJTW9yG4ok
0PsGlyvRFl1ogHHv98P/CNSrWS/t+qIL1W7+T+PSZwJZLAe775zqQs327dpi
vwgUdmFqs5hyNyqlr7j8qSZQw8+T3eOnu9HzbYdaWE0EElHJDKzx60bSbIXI
qJNAhr7iuin53egnR8CjmX4CPWfemvKZ6EZaBbV36KMEskm8Vr+D0oPGnNOW
VQkCsbXLJMdv6kHW+NTc5ykCxfJXPhE91IOwC5fR01kC7dd2s/S06kFnlqYH
4xcI1OG0aSdxtweZLt/4zLdMINe4P4JWQeTxt3Vv8/4RSKreb6jqYw8ym3BM
zVkhUDbnPry3uAdpr06v+UfGpjsZ4R87e9DQLh6uADKetIt2lp7tQX9WEcev
kucHRRjqPxfpRYe2ETkvlgi0tWKJNruhF/2+Faa/NE+gmsWUhUsHelH8eQ+R
rBkCOWw+19Bo2Yts5/QVcyYJxHdeMOXAnV60zywhgJtFoMTAH14ZAb1oWebQ
/TcjBNIrcjxHS+pFBwcHFx/2EWhgSl4zsKgXFYcf1Ur9Q6An62uEVv70opgI
OLu+kUBrT3kMO/7tRW1TIT4jleS8PFcv6BDqQ9xX5Kdnighk9a0r4qhqH5o8
m1F9IpdAS2MvXb7p9KGUH+pGM2kEipRHBhvO9qHoCqfU4XcE2n2cWBtxqw8N
FxzbvD6CQLczjjfe/tCHplnmUU89CCQ+sJIyUNCHRt9vlE1yJudtzaenJ9v7
kAfXZKe0DYFY90R2bRPsR3/3XnEb0CXQZVT3mnGjH7FZ5smpLrEQW/zMtz9+
/ejigknJ2lEWiuCS66h434+azjCe32piobJyO4Uk8j631DHMR01hIVXTpfhL
WgOo5SjtQ7QxCxVk04pNTw4gnfA37y33sNBp6cODBxwGkO2bV253FVnoeVeQ
ytqYARR1NqgNM5ho5IpKShf7IEpdcBJLfsBEnpWG1dUyg6hZIvCR8QUmklK/
wcrbMYg+IyX7U7pMdGQqb2vUpUG0+ca+A15cTJT0wCTrVPkg2uLWUHrrEQNd
C36QXxs4hK6eClA2sRpDHH/ju3HSENogsdv54K4xFHmqjC29aAht+36MM568
31XIiR14MT2EmkHTPj6fjjZ9SCzVPz2M8pVyvtauoSPG94baIuoIcp64wvc5
aQR5KcxPfN49gk6HXNMovj+C5B4piL01HkFC3CtxxvojyFDvqtnDJyPI+mDM
5e6hYZRa+69t7/AIivt96MSA7DByGtzQn5k2impTwrJ9nAZRj1Ubb2H5KNri
FRzJuX0QnWx9rl49MIqen23W/Ds9gHZXDt8flKEjzw0DPw7dH0CcnxNEJLzp
KERvW3mpWz+KcKftv3t+DBWwPrrnXO1FhWLSr/eIMNHLZs7tFvQ2xEfzUune
PY4ufqm8k+qbi8r2BW3xODSO+J4Mu0Vv+YqenY7ZJW8yjposvBNXN2YijsCc
w2ftx9F/ExZHX8l+Qgv/GJdb3oyjA0JMxqmoSDTWYZb4m2MCHZ7pmo7zT8RV
ESobCqom0N+te6+dHi3Dvpka2863TSCqrnrAFkoFPlKrs+ff4ARiW/vwyy2t
Sly8ylJ/38oEYtYPiWzxqcZ5dwKv5mybRG/WKxScEq7DqabzSZ/CJpHRgegA
peAm/FKkcuPbC1Mo/cBNEZ5dXTh3l3zWMacpVLE7XOxkaRcesLqOltym0ESe
wYcm8268N1XM9FT4FDpvJWKbvacHj+hbPhCsmUKNQjVu+4178YEnzN/3904j
Hq3bOl7X+rHTR2Shoj+Nvt59t9kzuR9H1gUNNJpPo8Jdb74tjPXjcarm/JYb
0+io0bz0JfsBHJPnsXYocRptvn3Optd2EM/9Fb5tIvEXlcxqnpbUGsZK8jYr
K0p/0cIfky37bwzjYwczfVK3/UVxLxtqK5KGcULw6Rheo7/IIiCsUFhyBJts
eVua/+Qv2mApY0Ojj2AP8yljh6C/KPdN073j8qM46cGhDunYv2jFVsy69fgo
ZqsaHb/17S/aTXTe+5sxilOvbJfZNPEXHRp94LrHhY5bA7zet/77i5atYzJl
YumY62uz+jOBGUR51tRsWEXHFtxuB3pVZtBOO+4dsevGMG/8T4dwqxl0O4wy
1FE1hm3+mGLOqhlUrcRvWrvAwHxRvY4ubTPoSvPZ8lg5Js6wcJLrHppBqe90
PmdrMzFnu/f9b+yz6ErOibCvD5j4feu3HS67ZtHO3weGiGkmNow43Nd1cBY1
7lJmHxRh4elTjYGGJrOI30f8sawaCx9qYTJVHGdRxdciXoMLLDzUpJjYFT+L
9DKP3onCLPwyNNXc8NMsyox/zPRpYmFNMy3ubz9mkfkzVUYmnYW9G0/ahLbO
ol7tZvt8CoG3hvSIcA7NogUBISJqPYFbTzpi56lZlCwi++/LLgKrNjyTMxSa
QyElZfNBZwhcGyxWmSs7h8Q+ZQufukrgeyZx91U2zKHqF9JcZvcIrEjZrBqq
OYc20ofu+j0jcHldbjPHwTnUxsctuvCKwDeC9J46G8+huU1GrnFxBJYxbtjR
ZTWH6FEvbD1SCHytlhGYe38OsZVxv+wuJDAl8D5S8Z5D+vmZh20qCfztOA8r
JGQO9dcb3ZBtJLCN8Ktojvg5JMPp1czXQWD+39SjzulzqOr6at2t/QTOfJky
35k3hwyjA739RglseWxP4tGKOfTqRbWHHEFgLqES89yWOZRbfoerf4rAKdUm
3CqDcyhxl95C1yyBTV90fwmZnENc3fN6IosEXjJ0sOFgm0dGz02b7ywT+L3A
vIiz4DxS1VZ4TVkhsFHVU9wpM496Etc97SfjGT+K01HVecR9Zm/oKBnHHI2V
y905j7S69pavI2M9frVK5QPk+dXcyqFkPlZFzv2QE/MoKtYjS4u8XpjvIVUO
q3lUdDvo2Zo5Au83qG++bj+PYr+qp66fJvDQ6vNPO+/NozdhR3XtyXoCysd2
HH02j85e77UdIuvd7XOvL+fVPErgZ2qEk/3oOcIdpPx2HiUVO3Y+IPv1nDcY
haTNI7unF30jyX5uLVNgsefNo/Op9Y5Mst+t3snR18vJ/A05+XeKCOx5ePfR
zuZ5tHh1Ta5mDjkfq37NGwzMk+8H/W82p5LzUWKcmDMxj6hjkl/OviXn41mX
ufLKPGrkiD9QGELOh549d4jAAmI/djnWypvALr+8bK6rLKB3tzhEda8RWGFA
j2dmxwK6EJQd/+YsgSs5Vn90hwXU/ej5PkNDAq+HFxM+ZxYQB+eurnebCFxv
dTxUxG4B/R7WjDSSIfDDB6J7wm8sIMrl8JKjvARu+xbq+d5vAX0Iucd+uI+F
n7WdWrcpYgE5p6X1Hqxh4R1z0mWf3y+gxszkpohcFn6xM0YY/1hAK8Pfiw++
ZGGdT//FtBELSDHTQf7bFhZm1VzRvbC0gPY8sey5LcHCUcyNQ0O8i+gt/3SK
3xIT/92YvnmatoiMN9+ILy1h4qSEr3lCposoee2UZ9BJJhaNKms/kLOI1gpq
xi8dY+D8XF+PiuJFtLJGOOvdJga2bzVca1y3iAQ0hy+mr2LgX2vqrlrRF9G4
+46c2R9j+H5g29w9uSU0laKWbqM0hnuf0iXSPJdQZPDTmAv1o/jl+5RvGi+W
0GLcjbdZCaN4708nq++vl9DaoiNqD+6N4lC2qYSyDPL88JtFl+VGsb7bokb/
wBLaettppuTcCP7sLHBSSn8ZGSsaGIaXDuGqSLH7qebLyGN3gaHoyyE8VCwT
q3txGeUYRXDOnxzCMtIbxhweLiNeBT03ya5B7FV46Elh1jKqKWpK/TY2gM0p
D79cW/sPuSeKu88w+/DClwmxH4v/kPJIObzb0YnfutnTt55iA//je1Nw3U+8
tWD1nPc5NuC/nlna+74IF3AlcnfbskGC8lbPyLuFuOfFgOILZzaY40qratyV
jxXizp0a9SHjptiIB4WZOLL4ePHbPDZY/s2dkbjWHQcLasRQ1rLDHTOqlJ94
EVprUp98VZUdqj8VmkTr/ESfw5xzC9TZ4XGiWyY4FaNaamqj01526G5Us1Et
KUFC25X5K03ZQShMe+u365XI11zq3hNvdjBZeL9W3KQePY5dMp5msIPqQr25
1/Y/6MTWHJdNU+zgmM1pppP7BykU3gyymWcH/2znnMuoA33ro9fWcnNATrXO
8UH9TjS5vu14qgIH3Nis12p6qhvZpGQZ2Z3ggCHF/9qrEnvRVm0XxzfmHGDJ
eOr+e6gX/atWe9FoyQF8UvNdzuv6UCTxrkr3Kgd0Eg9TfGP6UP324KPUxxzA
JsFlPPOiH+nkOum3fuGAHQq7NUJODyIhg41Xhb9xgPBmWiY9YBB1tA8+1yvg
AC5HpmgV6e97S5ZlmVUcMD+yuXDjjiH0CR09HDTIAWE8Oyd38QwjxRKVQwaS
nPDUkvd4ZMgIYpn3X3wkzwn1emLhUsUjKG84xitHiRMK3R+ZiUyRz32rJYqV
t3JCrW3D3ivHR1GgIdcBTn1O+HE53D2GnY7YGnogz5UT/tv7c8706BjyGs1/
6/qIPJ5z3G/v7TG0mu0Nx57nnDAU0Oh1I2YMUTafKc4K5YRTlwaCq1ljaL13
3eH0T5wgpnjZSs6bgT6+SU90/MoJDLfbRteSGaTLX6xWy+eEL5/q+tl+M9Du
Xv3KxEpOqLyU7s4lzkQGe4uOxQ9xArEY/MYolIlqjOPSLzA5Ydoie7DsCxOd
vOIhQp3mhIgH97Se1TGRZahWfRQ7F6i3ta8p5mOhnmSpHRa8XHDD9qr6AWUW
ulQ080pKmAvE7rvfZddhISciwyxUjguyrUendt9ioUnuoOyTSlxwc09u9yd/
Frord12SspEL3jayO156z0Ke+pvaXu7iAoc9DyiP61jo1bt3ls9NuCBYzWeD
61rSe98e/dA7wwW32O7GlmoQKLr2vAL3BS6oPjr6xIj083/Lsj2PHLkg4aZM
J9tlAm0UXwC4xQXp+3M9N98hUPrG1rf/XLkgJ/zteKAXgXJOhdi6PecCfqvD
FQsxBNrndKN4TwAXnPsq7ceWTKBCrxPr50K5YCXNtmRvNum5KPVn2dFcMPzV
WCOlgEAVnwWGb73jgje7acHGFQQ6VkY/vOMjF9A018ZvaiD93FWWOPGJrLcr
Z5MW6b3Tf/9b/ekrFwRNWi26kx7s4H96zSmfC5aFE/qmSC9eWGtbqfaLC760
7ciJIT05uFtHbaySC/zZqk89IL187Tj1RVI9F7BtMowPIL3MurTMvNzGBeZ5
Hx40kV6+6f7nmHIPF6xzm2g8Rnp5Ljg3fWCICzZKnopYJL3rnhQu8o7JBY9e
rv3xh/Qwe8FtF+tpLpC58U2bIONnzSfrqYvk9VbHS2uSMR9z244udm7QML9v
9onMF8ApEhLNyw2xf5cWzi2SfpRhTVsIc8Phfm5pNEegiK1VZtIS3BAn7fPz
5DSB5A9/zG6R4wYXSrhYNOn/+HPPJcOUuCFY+ayKFJ1Ayrfs7plu5Ia5Kpm1
Zf0E2qzVfTJ2Kzfc8c8wVuskkAbb6S10TW5okvwu0d1EoL0ltXw7tblhVK3j
dU81gXT99YceHuCGGx4Rq7b9IpC+SVFhhT43nMgzDKz9TqATUnvfrDnBDVrP
1K/gz6Sf36uZJltyQwCP96hfFIEuXUvYMmPDDUd5o4SuBZC+36rAr3OVzOcu
7hrxmECuecJFzbe5IZLH+9CwHYEePX7+hubODdZGnxDvaQI9P8J+3+ExN4QI
Rme6HiFQWOPkFo4AbtgYPeJgpkKgN5H2/Eah3CDQ3nwlfw2B3l8YGAqP4oY6
h5gTrpyktxlNbzYncsPWz0c9GB0sVMOVy3+mkBuOxDHPlXizUFPFtuF3pWT9
X3g/1juzUEfgxyJWNTdUJ+jc23mGhehy0fe92rmB2v5fCpsqC3HvfDicPsUN
V9OjfuT9YCKBxdmihXlu+PFAXt//LRNRCp1jDrHxQEx2Y2u2FxMpGtmY/RHg
gY+N73yp+ky079KhnzzKPJCR5PDBuIKBDmzKjzFWI49/XpXMn8RABhOartHb
eeDtuLuMMnm/Of1Addt2xAPn8y12PNRhoFuh/LHnTvOAvseWipa0MeR21ss1
0YoH7KPcgz4+H0OPactmUxd54GjzCb4B6zEUmMoS8HHhAa2z926+pIyhlF91
rpm+PNCxpzqwzYGOBv6Gm/P/4IGv/x4tS/CMonidHTc7f/JArv2Pq4X1I+j8
i5qA9AoeeOgzc708ZgS1r+MuP9nKA/dEbsXMaoygupM39kZP8YB4clrm5BnS
6Z8NFTdvXAUPCiRN470HUbgjO/1Y+CoYSHOciHXvRaa50Ty0mFXAWLdnpn1X
L6Jw71aaer8KQg1WzBIme9DLaCfL8IxVILPLZR9h14O8Kv/UdFevgs+fH2eJ
hXYh5w3ZX5y5eGG8Kfva6L82ZDB47UGwCy9sVRj16bSoRXoPlFIO3uOFYy1T
NyI8fiPdNR3tMx68YKR4d3+6Xg3SOmS0+6w/LyhK9rZ9aKxEGxO2TCl94IVP
B2LPvBkpQfyXpq9kdZD5G2JX17JyUdXAA9PWw6thx40r63hsUnCZu+YT32Or
Yc53aGNixidcLE583me2Gk5us17s3/EF5x28IPzWZjWUBtyM7NHIwSnvdSuu
PlgNIk9DNCMlC/GLi6tgMWM1BPg92fFrsQIfGwjcpKDAB/hn1c9YmRZctWmg
0XIdH1SpZbmt+68FH725yyNqIx9UrKM8UdnWio9wdNVK7eKD1Wypr6MPtWFd
xU13xE7wwd/Pn/aOX/6Dd1r+KuB9zActSb/VMwK6ceY7qWuHn/OBnb5kRBdv
D94+Zi/27CUf3MljbPDX78HqrhQ7zig+8Pq4da6tvAerRpzn//eFDwpK55nS
Jb1YrnHebGqQD17OB9uu/N/jskYr2xh8MLh8WGpgqB9L28YlOk/ygbH7WOJZ
2gCWmNRbZP7jg+/3m8/9CxnAIiIhcSOS/BCTRoki7gxiTkP1sU59ftgelp54
e90wfvzqUYjcCX4YNo1Umz01jNn+NGqfNecHT9vPKXO+w3jpqltgqw0/NJ4+
duguMYxnvMt2NrjxQ7B/I3EwYwTTf9p4lqXyQ7Rsgf4+BTqmBrVee5nJDyOT
7EWdhnRsanXMzPQ7P6x9+yOgyZWO8+f2bOwp44f5B0UvfjbScfBm0cbZfn44
NeOXdd9zDJcuPMv/QeeHwt1XzqUljeGl0qXEJxP8wIceBm6tH8N2NiMPhFf4
4WNTqLc0jYH3hmMVFRkB4LaJ1rXJZmDnizspTEUB0A7USBtuY+D/tiUvZagI
QGqLy0LGEgOLVIXV7d8pAPv6cr9KAhMPsDm5mZ8QgO3NSTYc+UwsXdN/Se6U
ALy63nc89g8TH4s6c6LvnADU39oS6zbHxDk7D613sheAieCNngTpBf9rcr+f
PhOAwn231n4OZeHCXcG5R18IgHETNO1MZeEZLt73oiECIEoTip/+ycIXYqfu
vXkrAPbdeQcUCBYOdbhqa5soAD0NmziecxK4Yk+30YZ0AYh48iN1gySBNRor
1mblCUDA5qJmyj4CX30Lgm4/BSDOQ9LujBHpTafsWagQgJTdFjzN5wjMuzq+
qqpFAA7tM2m67k5g7WbJr8FdAnDmU8x+f1/S5+9evD09KAArf/jVO8MJ3Kl9
/87ApACwn682lP1EepyfuPBxnly/wY/uVd8JfKT14lFnNkFg51ldoPKLwA8S
2ndqrhKEa6IXUlxrCJxx44TikqAgjEtFX2FrIfAwKuErEhcEfteiHzldBJYT
3PfXW1YQZhO4Xd8NEti4/XO30VpBWLQpcS4YI/CzDyoVYhsEARghrsITBP5+
601m2xZBODK+7XbgXwKP64jFxmoKQrVjwIED86QPhX18LmkLwt7rddUqSwS2
6Ph3c9NBQQh/f4x9/z/Sx0m3rCYMBGHwT2DtU9LfxXfoR74aC8LSKbMdK2Q8
f+DCjgenBaGB+4XyRzJWF22WP3BeEPYFWqY8I88fejH0OPSSIJz7dccmj8z/
hm92eNheEI7OhZrsXyCwqfcqI60bgqC7Kc9XYJbAAlxSGf73BOGhQ6ecyhR5
PU9VyW4PQbjk0q3wkkVgt+Xd7tueCoKN7OuPOqTXt7vq9z7xE4RvQ3WdOqTX
6TNn9JqDBEHtgE77S9Lr8TevJatGCMKN5he/VJsIfGbcVcQtRhA+JBqWC1cT
WMTR73b1e0EI0mITO1hM4LLRqHZqsiB0PpVs/PWN9LFdCrrxWRDMhhk6oeR+
avbnvS/+KgjTk8WhGQkETujodLpaLAifK2VGWl4Q2PIMq+F7hSBcl0hy6PEk
sHjzv91CdYIgvuZ0/66bBH78m8r5pVMQrIa4uxrNCKxluPUK9wC5nsObV8nq
EXiiDKpP0QVhqq3I4fNOAl8osg5fmhGER3yrbWopBJZCN5aOLQtCmF5B1hk2
Av/+/tj6LacQxL9lVWswWXg/qWI9ESG4tdyz3FvMwnKJgzhggxCMZwWLrHdg
4cZ1M+v6tgiBZ1kMTd+Uhf3e8vhqaArB9aEN+UV7WXghUsW0TVcIesxrinN4
Wbj1xdWRtZZCEDawxF0QycSBfK5Gt22EIDbF1jzuARMf9vbNKL0iBMv1mSPt
55k42zPZ3eG2EOT4L920XsvEr24yRbJfCkH27wCz0lgGNhhfvs0bKgQv5ddW
+T9gYA5HoT8WUULwYudvpQwL8n5jtyVh5YMQWBz38qGKMfCxMy579AvJ+u6H
3YlyH8N86K91x5QQ5GmfM2vaTsf3dFR5sxfIfFwyt49y0vHQgbNpAezCUH7X
l7mmYRQXHSlc0BUWBouYy4MpzqPY1eTFq6SNwuCz0fY3z/sRPHZp/a871sLA
7199I5xB+t3fTFX0tzDs8br+w064H2sFPK+hNwnDf69NnilW9+HEoO+3ijuE
oXKr7X4r3z7sFUYrvEsXhmOrjK0dOPuwQu2MGsEhAvEcppe4xntwc1vRLzMF
ESjqveF49WonPsy0mF1rJgKuuVKvLCYbcIz4k4aHp0VANs38v7zTDXh6b3J6
x1kR4PD5+fFdfj2O8128HGYjAr1rKtuFferwgkp062pnEdAsWf3k9bYanGLT
mTvuKwL8R4XzPY8VY5HW8+75BSIwGfwtfeeXs9huxfu0bLEIRIa+nMnK9kR5
yp807pWKQOrh4g2ZLsHo6m025rYaESgxX6dpe+wdKqK8PZfwRwSMqQ9/nsn9
gm4Z9e33nyHzm54LEOv9iVqLLrJbqImCatYP2fQfDWhcp13mwRZRyE4QFM8y
bESrCo9rxG0XhYvyISkGfxqRJta6PLRbFMTyHtlLzTahkO8i1TcOicKZKorj
iGorOp6ZF+FnJQrT4m8Wsm50oJIE8a0/AkXhLYKug4f6UNc6X/2eV6LwO1Fr
ofdxH/r7bsWGM1wUzu5vipYq6EPr4umh+m9Ewe9wlprRnn70OKZgsSlJFPRU
Jv6mKQ+g/eEOpawiUThuIzW4mzGIzCX6ekRLRMF62CC9ce0Qcgw9taBRLgqi
QxrE39NDKPqV7ma336Jg16azrvjnEFoIkHq1qkMUHHhn9K6/GkZZz4utFP+K
glSr+UdemVGUaFAp5T0nCru8X5WfMhxFkQL19cxFUVhzUlGfw2MUeQZ2633n
oMAqqegLF7tHkWHEgrq5CAXuDCu804qkI2TBPponRoGlbeVndEvpaLsc7zsl
SQpckuP9HTVFR5JxayQn5CngdtH8LjIYQ30ftq74baLAycvEkU3EGGq6uit3
Up0Cn08qn4+XYKCyTftvntlOgcJw/1QbbQZKTT86rLyHArf2jvB8f85A977a
/S7Uo8AT7+b9nySYyP6+o4+qAQU88tf5mO9mIqu9tw4EGFHAsPh62v4zTHQA
P/pqaUoBG0NDzboIJhIqjY6dtaaA7wdjjlEhFmL3eXfG6hIF3mtzVXhvZKFp
g49iv65QoG196kGbQyzUVvPVO/g6Bf5VjUaX3mOhqsB8nfkbFBiz5VMzDmKh
fJNfi+fvUODEgwN1Ykks9L65/vrmBxR4cy9yTqeZhcIj2jaEeFLA6PVX05Qx
FvK16OlfeEIB/R1TrkZsBLrexTxV5ktef5Apup30k03ctOiWlxRI2R729NYe
ApnaLFaGBlFArm5n+ZgBgbSGeME2ggKZm0f+3bEn/ZgovFAeRa6Hfae8ryuB
FK9JZG6NpUBp1qRt7XMCUdTkncLjKbA/W/uOfhiBuFlKqv8SKLCx5OrSdDzp
5fSNfReTKJC7m+t9fRqB6C7boitTKMDF10ztyyVQ547d5ts/UcCnaVBFqZhA
tX/3i7z+QgHnj/fvh5Ie/fn1UMVKNgWaf0i17G4mUPZ9Qy+7bxSoWfDnFewi
UOLek/urf5Drdx5oFx0kUNTymbkdhRSojbqheHiMQC/xhYzIYgpcCan7lDJO
IM9Hlx3YyyjwQ7j/iu5f0vcHnJSvVFLg+eG6jbzzBLLjvt1TU0Pu33fhrmXS
4zLU8pbFOgoc7Btz4Ca9X7Nb/rdqEwX2NDZ6niI9/9jEpcSslay/1JAyTcaa
Dr9+PP5DAd6QP/L//zyA/lQ6K72LAu3lQu8FyDgm1jGlo5cC1sn3k56T/jfJ
LXy3epACReJZmsfJ6/E0rInSHKFAg8H50xdI/39jXA22HaOA9xdZah7pfyee
fJ9AFgVe3g2OtSHrWatIefRjggLKgs6TJ8l6m/fY3aNPU2BdykWNQLIfvie/
XZeco4BmstIzyW4C7XcUunxwkQKXS2wE6C0EmnxmY+XyjwIdx9qIVbUESojL
NothF4O+A+icSymBTn/jM6rkEgNkZvhUOZ9AAo1WB+dWiUFNTXa0SiaBbq1a
tcNESAxY8tc9hWIIpEo7u/GhqBi8fCdZMR1EoA6tdFqKuBjYb6xdVnlKoINO
p0R4ZMWgOb9F/85Vcj68k1ftUBAD8pFqJciCQClvV/6dp4mBl+1w6yI5j+JN
H5i5KmIQkuJv9X0DgQb2zlU4aoiB6vmd5tNdLBRhZlgUuYvM/3Mi06+ChQyv
x+WWaolBywfGlVtZLJQZfySRpiMGnBN8X/b6sJDX6tdPm4zEQMzuRms66fvd
Skx3DmMxEK54UNNNvl4Z+3RubTEVg3MDVrqXppnI1HnUxsdCDAy7NNlukv5f
17IHtC+Lwd6nl9WTDzNR6/iLXdeuicHjujyTCFUm8ufrUw93JPuRtU24h5eJ
prV95SduikGXX6fS41IGKn7fvvDeUwzSppyOryfvP7Y33LIEIsWglQ68EXxj
SHN7V9aGN2JwK1cvz6KPjvgmIVsvTgy2yXl3+ubS0ScXnq+e/4lBtmb7gKYd
HS05B+VMZ4hBtMsNakvOKAq7/uF7R6UY5LXITfMdHEHlDg2FKctiYFkU/8Bx
fgBFq2kWlbOJQ0TgKlRSMICcGRFFQ5zicKGV70+q9wCScLD6qcgnDiM1Nx6r
iw8gG/vR4hAJcXjkdG+LlGo/Wrq6Uuq+RRy+yn9xT9rXi7Zc3lRjaC0OegFP
xdQOtqOuq9TrqRfFQatbMoDjUxvydxATEboiDhqiabs0ZNvQqMui8W8ncdj5
dNvKV6IFvXOvbDJ2F4f98g9+fwxqQpLB9p3m4eKgvVnyv5C8WrSSl8y4UC0O
ClY37fRVvqPfFDX+23vWQL6B14uYbxV4v6PjaNS+NXDcNtJVq68Sp5WmlRah
NeDAdzpCa3U1fum+zUtEbw3s90j8YGT2GxsOaS4nm6yB//Svtz6drMMVuTpE
n/0aiCuwHU1xasa/LpxqOBGzBuqd/ziPcXRjje8Rn+++XQM5/NUvxp514/dr
2gNi3q8Bf/1GLM/dg70qLA0ZH9fA2X2Pvp737sG6Gja/vL+ugUgZexkv715c
sMrxa37tGhgXCLOTut2Pv6c9jlLjlIANnxw6dywNYR5DM5lwHgkQ6IDbkxrD
2HhU5TU7nwTsa+D4JuU4jIeVqsOaRSTAknwCC/szjMVeSwZ7KkhA5oDs8pbP
I9hKky4yRpMA52M7/LkGR3BSQ16A2XoJ+LpNI3On1ChGQjYvNqpJwM81Cq8S
3Uex/ZOU5417JOD1RoXWFG06zlZ8uAppS0CUyoSlrgMds+cbP0sCCfjx7cON
jZF0HD4388TjsAS4mE/EMqfo+KejzkNVMwn4a5Guqhg7hmVPN992d5YA6qqc
/XoNDGz3N3F66Cb5+9ceBz+aYeDPwW43je9KwMJducp/UuTzcLWii7KHBLwa
U7T7fpaJb+raO9T6SYBhm0/2+lYmzu/WHtMKkAD1uulHp/8y8eoHItcSgsn1
XbufVCLKwrFfsy67vpYAOTUnFZMjLFypxma77oMEdNILsigpLCxRUd/78iOZ
n/fpGkHSv9aXEy7Mp0qAv6m6n3YbC8++NbCqyZSATVZVd/aT/tVF8p27cyTA
00iwTZD074sO4uy77xJA767fILqRwEqSoWfuFUlA8duFxM+kf50yL7f2/SLX
0/uEaWRF4FxjrVNG5RJwcmDQUM6JwFyEQPPXKgko3WB9Xu4BgY/7d5uurSX3
+5hnkZEfgSM3ZDT4N0iAZqCM9KcIAg+WeJnMNkvAGw1z/gOkl9zYN56o6pSA
a5r9D+ZJDw8d5G9V7pUA8yShERbp4RPPGecfDUjANj27E7K/Cfytsnr4z7AE
hBzpdfcgPbxOOP265pgEJC9f3y3VTeCXJoGzgSwJGBdbNhkhPTwX6vJwbEIC
TCqd3rJID9u0mazS+ysBXdyJyxtJD1fJaQTEzUlA324fvTekhzUvrJFcXJSA
B/snzh8iPRz3bibGbEUCXqzK365EepVvuEX5E4ckrFavTtEkPXt7Y24aH48k
4MtLBQ9J7/Y4RmpeWi0JF9s2XP5Hxgaf3fKxgCQIGGhEZ5Bx5rSlnoyIJMxo
LlpHk+cr7N5fc0tMEtJLrfB3Mv9zN6r5bwlJCItHBSKkhyfz2bo2yEhCzluP
21EzpCc5+i55yUsC75Wl6bOTBC499JPZpSgJ080RZ0yYpH993t/es04S7C5u
/+kxTODoqqfLr1QkYbNxgnlvD4F5RC4/ZW2UhDxcoe3aRmDnk0cE9dUlwTn5
7gf9OgK3h20IfbdNEk4VuJUeLyPwwXY++X8akmAtFtfsn0/gNHnG+9O7JUHu
ewKFPZPA0tbVal/2SgKH/sH8lEQCe71PyxREkuCvpEoLjCYwazhg3xVdSYgo
GPdODiBwkZOJoby+JOwYs07xI/2rlrGj8a6hJAzzzcoaXyRw2F9xy/rjkvA5
+dDUcVMC27u32HubS0La8vSNxW0EbsY5U71nJCH1idd0IpXAwBnptu+cJJxu
Xh8YJED62tfSb8JWEroOhS6vGWBhj2ptMcPLZD1vPH5n1LDwiAg16r9rkuDW
l/TdP4eFf4T3fjzrIgkuz4SkFnxY2C7BruKXhyR4J+2wqVRi4dqRwyaKj8n+
Vbtdsib9q6W2od31qST83J5wdQ+DiYW/jI1u8ZeEMp1ynYzPTJxT4Lw68rUk
XJr2r/+zg4nXcpkETUdLwgV18XNhFCb2P7xD+nicJDTF3FyMGGdg65q/qlwf
yOvJXmi8/5GB+TpcjzhlSkJJWnR40RoG1rybJBjwVRIihWS3u06MYWtKa336
N0nYZzXJHlE1hnOO7Dw3USAJdKFJ59WPxrBdFuFyq1oSbvlZvGzvo+PClxej
XIckoQ/Kbed8RzFjw6sLUaOS8Nc+zf/+uVEs9atwfR5DEjzf2che3zKKnRYV
Pi1PkvOXXGrzvW4Ey11pK/ZckYSeA7L8f4VHSF8fYz2TkoJdl7nK2m4O4fcd
7l8+yEpBrXati8L+Ifz7bvK9MgUpuCDU8mlk1RBWTuPl5FsvBaPWbyIpkYO4
Qean5IttUjD8r866M2cAq0/v0nllIAX/TOiS1r19ePA/WkisuxQEZdkmW9Z0
YoZX7zynpxTMaRUpDml34kmbt+evPJGCT3+3GWekdGA2Km3TNl8pKPPQD6c9
/4NlwhWLisKlQH6e87+fmm34hDd1fDBDCpbHjpra3mnEeZflDdVGpUBtuCna
Q+MXDlGV5so1k4ZY/pUymulPZGml/KH/tDTkhB6YuOZZjNaF7DAQspQGe4eA
u5DyC2WuGAXa2kgD7fg9jTscZaix+bGc0HVpCHZV3GiaWIXEnjI0bJ9Lg5EM
9ZQovR4F9+JLgt+lwS2ZiArFf5CFZDXv7nxpoNhaz2sf6UBrjdqTbQqlyddb
bL1ebQfKyJme+FoqDawUoRXHrk5UH7DBw6ZRGvr+5OzBk91IdP+rsK9MMr9A
RpPzUi8KjLQrtVaUgeP2hh6NXwbR3TuPb7oryYBVUQztDH0QWZnEUMOVZWD/
f18W7RSHkBpf890qNRkYouIiab8hVH7/kOquPTLw56vc9jyLYcRxZp2PgIkM
BE6tYrD3jaBRDdipYiYDDWLrrcJERlGtiGWvzmkZmDyx+m/8/lEUW/Zqz10r
GRB3/Ziq+HoU7dvNSe+9JgMfTPWyXh2mo9uSfQZfn8iAEsVA+4XPGLKcWp6p
eyYDVyV+3tmZPoYO/pZ+x/CRAdo+2fjDjWOI4m28SAuUgZ1N3an/yTFQ2kxB
sn+0DCQPfL+q9R8DhdZ3nPoQKwOFuwQZcuTzpXvaHGdRvAxInZO5aTvMQEft
tlrOJsoAW/9Ms7QyE400xQrYZMnA0dsbE6Sjmej35+857jkyEFZYPLg6h4my
X7RcDP8uA5f/7RM908BEXoeEf1QVykCJpnyHKC8L0bI8HHfVyMC+JMPRzqss
xBsUKW1SJwN2abki2Z4sNO6Q/cuhUQa2Eqb9I2GkX9ex5OPbZcDZ/0SKZSEL
WYScqxEYloHt9mKPnYUIJPeFT9aeLgNiFK0RHxqBuuu+Xi5nyoD5lam4jh0E
uihMYX82LQPCH033qpkTSFkdGw3MykBZLaeuqh2BRg0dInUXZWA6+Mzg2duk
j3xLdqywy4JS1cjjK6Q/tibd9DzHLQui36gVQPpkqlSx+juvLLz6sHT4+EfS
k0PV0jICssCf+CL9VRaB7nG72d0TlgW+Z/QcwQLSw+tUvzRTZEHrpSbtRzmB
lnWbVjQkyHxa8R/f1hOowPqx4StpWTj2zUHuezvpQc8tryfkZGGT9aDu6j7S
O7Edg8cVZWEfw4HwGyHQqnyf7WlKssCVdmdOl0Wgig7NhwIqZL5wnz3qUwTy
X+yvvLZRFkoVdF4ZzRLomEyQVPlmWSjkPzYWt0Ag0T37L6lsk4UvsnfVVEk/
Np4a+/xUQxaafF/r9ZM+DbsT8a9/lyzQXZPU60lvng49dFR3ryx825PR9X+f
ymZOhsftl4U1l5vNjpJxV33swD8dWTBfOB7RROaLmzDcdu6QLDipOKe/Ij1q
I7Lw4PsRWbiqFJv0lPToui0fKqQNZeFR2dnIZNKjQ0amkveOy0Ka9N5IbtKj
SQ7sF5tNyPUmDJe8ohPIwS/tk4a5LFArFA+YDxBI/ePZ5eAzsjDemKv5/793
Hy/jNZiwlIUpntc195oIlDGcFXb8giyw387e11ZF+pLHtj/VVhbky2VynH4S
aNd6ka0Cl2VhW3+n+55cAuXZXCsvcyTX27aWcT2eQB6PJCVUXGTBwo6i2hFK
IJ24Ypunt2Qh1HV3rcdzApV0KizpuMnCTuPT+Io9gZ4vVR6J85AFsexJ/Oks
gY7K3g/990gWEvXY4rYeJVDt6Qb178/J+l8nJrapECj4rqebtL8s3ByuyuBc
QyCzsM1ldwNkIbDN5fxldgK1N3hba4TJwuJUxevOFhaKntRIC34tC2djwrdO
kPN/XrRvYTxaFtjMhN0hmYUGju0LSX0nC9pq8vdD3FjoP8fRHv4PsrDCN2ER
acNCV/3DNl/7SK6/o9+46wgLscrHS5Q/k/P5ji6uJMZCcwcT5mPzZaHhdr74
lxgmcv8e+6S4UBZk18bdb3rERGzbIwVHi2VB9euG8ZMXmWgVNYC2vZLcn6Ab
CZdVmEhi/p5+cYssJFzYtryUwECR1282jLTLgty5hHiKFwPJDzmeE+yShfMS
AX98rBloXYONi/kAud8H4vjiZBhoR6rh65FxWZAsdd766OkYylY6rCQ4TdYX
L6WWazWGtCJ1UrfNyoKIybTUmV1jSNdbs9B1WRaCJEM0Gofo6IS14qgAnxzY
W+mo1+6nI6c107u3KcmBrkrQo/SGETTpxyoyU5aDLbHr1ze+G0G3OUYNXTfI
wem47wPXb44gd6Lzws8tcjBirsMSER1BfuWlz832yYGRTp2BpN4wSnwQ1Xrf
TA4mhSS8tkQMov5B3XtF3nIw2r9mL2ugF+nG1sRv9JMDrYzOPHpcL4o7bVEd
/FIORPdfV75l2YusKl3W2obKAd/hknSN+h7U/imuivOdHCjdZr+0z6Ub1bv9
UzyULwfSL5XljAfbUZHot/LSaTmwSbsT4Gdch+K1t8lWW8vDjh9qNRV7PuCi
Y3xPFi/KA7eyJmfXcjLuO99P33BFHvQ3OBGJFz5hpceh3545yYOgyyq/2bVZ
+H3J/Blwk4dyf83PXm/zccLxoogvIfKwebg/+MiPMpxofVIislQe3oR/iPkV
0ITLbqh5lFXIQ+TzwVEjajMeecI9NFMtD5nZLodOpzVj1f++Zp1slIctxzbc
HapowUl0WTPBXnlQOoodA5fb8MebA688F+Thceux4zZ6XTj16W3Ry5sVgFpw
FLup9mPGvnOPn25VgMPMjum9F/ux2vTBqXc7FCDwkItwcGw//mgj3tSzRwG+
MbX7F8QHcCL6EmGhRx5fTBCPXhjA7+fHqcfOK8D44tiywKchPPCpNdDBRgH4
RQ48jxgYwkpXCtj9LinAO5e/Nf9JDeP45oD+UnsF8BUpUzz8cBjHflH/oHNP
AVQ891nc0xvBkY4O6juDFGBT9r2bGd9Hcfs609iTIQoQ/bLUmD48iqU79orc
CFeAYdel6yFidBxhwD+Z9kYBJK3ufNl7lY5DVT5mqX5UgFvb5GbyBMdwY1eQ
8uFUBQjeOn/OcecYFg+7H37pkwLMPmodeG45hoO59O/HZyuA5+PuheXEMRzY
O7xP7qcC+X7Lk1yuxcC1Eb9TtUoUwEao+FTeOQYWPvFV4Uy5Apj5bKsR82Tg
l/nP2MJ+K0BNa80mVhED+0etLxbuUAB81I3Yp8PEVSaCO9W7ybhzRVL3PBPz
8/1NMOwj662R9fnPnYl97xV7+4wogL+P9i/fLCb2NrM9yvlXAe78WBxOp7Jw
/PEOy0tzCjBFH338RYuF8/TNnEoXFcC4f9Zz2pSFJ7UPB/lxUGGrw5FVat4s
LLC7IJ7JTYXiUDCkxbKwyvY9mcdXU4Gvq9LROJuFLZU3tYiJUMFiw62Z830s
fFfx/chtMSqc0CV0tGdZOFhGfqFFggpVpQXbT/KT/hISlo+Wp0Je+1YuFdIn
fbzP1f8pUmGf5JGJfl0CL3Gww4V1VBjSTo1uOUn6bHbSZt0mKrQ+pntYk/4x
mrC/9UydCuN9X+kzjwh8ZWzg6cg2KqyrKvIoJL30ePBcuMFOKkSU6fQVkJ56
092cmLKbCvwPvQunSW/ltB3/JrSPCs+quWosSY/VN5RVOiMq0H4a5M+RXmNW
63TW61Kh8J7AsTLSc7xl31gaelSoK1PcX0l6T6loB1u4PhV6B5+YsrcTeH9e
iui8IRXW1p62vNZL4NPZ65XOnqDCtyT6ep4RAt/8FKPx4yQVRkZTnzWS3nz5
UVKPeoqsz0nnTBPp0cT3gaceWVDhldP1B7yzBP4Zs/pq/zkqVB9Sb3UkPdsV
8dj1kDUVnii/Pcm9TOD54EW/DxepcOO9VHcN6WHxF7ferL5ChVBFsesV///+
2JuZZm9PBQ0x7eVZMtZ/ZFdQ7USFeA2X56fI+KJbd92WG2R/vHLER8l8HrdP
9wfdpsKBrQbJKYsEfn29bnrqHhX6zP0s4udIf1814DF3p8LmVCHNimkC/7b9
KZnzkAo6K6/M140TmH5u3waZJ1QwDlrV/olOYK7TWVruz6ggdP5R//UBAlNN
1A27fKjwZs/BKOvO/39f++EcvKDCw+I89WdNBDbVU7weH0j239iztrOKwNfh
tSdXCBVkXx/NufKTwL5alGC7cCrcPMWupJJL4AQNv3dlkVRILkg0kU4jcIE6
V9bGGCoEtdm/RPEE/rt2poX1ngrPrQMvbHhOYBH566MnEqkQt6k/hnmfwBsl
RxYykqmgu3brnuFrBL7A3y5/N4Ps16Xc1e4GBHblPrmlLYsKAsMfRaT2EDh0
pRL25pLzV7AoPqZM4IqpH7YrmMxPbWTtYiPwzo63Sd7VVJA5WTXumsTCIupX
5tJrqUB5Fq185xULMx6qH25toIJfv+/gL3cWfq/0fUC1nQr/ZK+vXDRiYXH7
RmrFEBX+i1C5/2mIicfzIp0mR6lw2ePMF6tK8vUuZP1DhkmFlMy81kvpTOyV
wbSwn6KCu9EWy0e3mXjBnfMoD5siMGY7TFbmGXgkwe5GJLsiNAnOtj1rY+Dm
mvLX6pyK8EXkXoRDDgNnKAaOmPMowtLMjwSzWwx8rVju2QcBRdCTs1f7MjCG
2/g1C49IK4LDGqGoE4l0XKLxeqRDRhFe6NzfKeNBx5nnloRd5Mj4pDo6fpKO
A9OLrF5TFWHD7nDblcVRfOTk8aXR9Yogn7drIVhvFOdEXtnlt10RBO/o/bta
OIwjNkSlVh9VhLC7xX99zAbw9JRewhMjRbg7+72ha80APp4/Gb3nuCKcSLZ1
SG/qxzwnDfwTTBShp7bTvuJkP77tPn/twRlF0N0yky5h0IdNfp9S3XxZEYa9
b8v7KfZggdvi7/wfK0Lmbe9D6zhb8MOCFxFHcxUB3u03fS2aiOmdBSHz3xQh
xboFV/C+w+aLU4Ef8hRBue94Bs9KFFbTtPDhLFAE2xt3Ph+/8BC3Jiu7fi9R
hNmph2lie+PQ9nB8dlMjud4eMQ32XXloyHFCgZ9QBN/L+oh7ohYZ+62TzR0n
+8HmTzf0r0N5iackL0+S13uXvX29Sj161f9D+OdfRcgWWqNz72wDgjO+bG5L
ikBMur7Uzm9CkQeV+uiraXCmN9xy/ko7MpI1S6hYR4MLu3uF66J7UcSAesFZ
ZRps6vvz8dqfXjSQyvuHoUIDe4WX795K9yF3yBMR3kQDH6U0476QPpRyScn9
5DYanGs1C/F51o/4Pk2YdGjT4B1SLj1mNojM71c6OiIa7MRdYmtfDKJ43YTn
/4AGfUffmnsUD6I9TafzFQ/SYGYyd75q2xC6soA3XDKggefutaNveYZR6cGX
bCxzGrSlJ3SrRYwgitAV2YenabDRYrsoT9kIsmrR0RSxoIHuOxdr89kRNHP1
r/32czTQTPhw9LTpKFIOsGy5Y0sD7h4lp1+r6OjGac3JVZdoEHhs/MPeHXSU
TxMRfG1Hg8xD+zfSrOjILPOn7ver5Hq3F57SzKAjr7aNaSvXaTA5tX6H88kx
VBvPVR7oQoMrkqvuHXYdQ3IOXf20mzQ4T5ubeRY3hr78C5I+eIcGz8f1zuwd
G0N9SvNez93Jfmm/uWh7n4HUmfWx0h400P+3Q8ouioFcs1O+fXxIg48tg2UV
eQxE0b8wXvWYBl8s9h34usxAOk6lZ0V9aHDIsujw6ntMtNA6qlfsSwMREc/K
G+FMlHlAYPtdfxq8YawoyWUzkbK0MW9nAA3Wnfuyd9MEE/U8uTkVEESDoytW
bgGCLPSaFdql+4oGdXElgVs3sJBAcXtmYhgNzK2FbilbsVCJ+nLs2Qhyf8TY
6ffvstDD11Q/oUgaHP6v8+mqQBaadLpofesNDeqvBWXX5LNQqzRLEN7T4P2P
0+VLFNInXiLzkwk0cEnkkhZVJj1DbB9I+EADmcM1imd3Eyi/+O43/mQasK2v
ePzSgvTulsiE/BQa9ET3/btzjUDbIvMCXdLI9XbQ77y6T6D319kvt3ymwbTy
jRY70lNW7Uomvl9osJKjzS9PekvykJ62dhYNorPC6rjTSC+lX1Edz6ZBlo5y
pyLpM18ZP7F3OeR+PqsedCT9dvBp6j+zbzS45vUhkUH6bpn4PcqbR4N7ZXwj
0aT/si0mG7//oEHZvK+9B+lD51/iBU6YBm76CyuBpB83bt2VTCukQWL+tbuN
pC/7I8+ENRbRIOfClqQjpD+jud0feReT84U6XZikT82dYxy0SmjgdcbwSxHp
V5E/BaeYpTTYcj7CtIz0bfmhft24chrQzGi6/0j/Pv7ErX6ykgYGYv6OF0kf
75NVleappoFWfFH1AhnPPDXgyq2hgeydaatCMk4fdyDsa2nw0DtsbQ7p7ytn
A9oV6sl+6ttSu5cItLbk86+6BhrMPbSw1vz//19vbfzk1USDWmbB/I8ZAoVG
zUTtaiH7N0JduT1Jep9H2pveSoOLxQdfWDEJxOuy98abdnLeqfDr7jCBiv6c
O3eigwaP+S9VF/YQyE3vfxXbaThV2x/AccotbrlU6Eaps5dGUxo0KPsnhSgi
FRKOVH/SYNblxo1UGmj4u2kwRBIinQZjC5UMZQqZShwcB+csUxmK7url583a
61n7t158n2fvYJOpn+l9UzSp3tRI2DWZ91Y/b+VA3LKXksIqwopV3qi6tnHg
mHXzjeK3hE0OE8jM59Pzcxt4U5dPWO6AzNeKDnq+QVfqlHiErS02L1/TzYF6
0+w07duEvaLj8VwgpPdH9h856SuENb5zPf5WLwd0Rthzc4IJm+PR4CdB6H2z
tF78hktYr5ZxZ14/Pd/v/vLuloTVMF5gfniQAydZrVvGQNjY+c5q775ywPNz
rlmMCmE3rlbXch7hwJUgHtddhj5/+/C60VEOSBp8KAv/Jmal/cLM1H5woK1J
sC2nQsyerE7xDJzCgG6Wc0i/r5j9vdsrcLYUA5yp1rk7HcVs4uSmsOTfGHDJ
2Cfz04jeD/XK6FppBladfjHLSUHMQthQgYYcA7VOWyrUH4jYpjt5ZUXyDEQ0
BERtCBex3ryztTazGXik1bQizl3EJn+Z2x2qyMDZ2Gbbv7RF7Cy9TXKfVBiY
/3/NGb6P+th2Enrg8jIG5L2ij6682MsGTjM/glYw0Bgbc5Lj0ssqLZjrka3O
gIrFyaN+m3pZU9OHoZ1aDLgVCN/u6e1hnyS+T928lq5fIRv81aCHDbFVGhcZ
MLBUfGIoivav6snWqaGGDKxTa28zpv2bFZYsq7yNgY6C3P3HPLvZPt5GjpEJ
A/kLyo2U5bpZ6z8cTWLMGbCUPTCqvEXAqr16EGW+n4FAvfXu2RGdbIXGaGKL
PQMnYrUzbGw6Wf8oE56bAwMXZ7bWhizqZMtdhZVhXAa6HvMunMnoYD3l1WXw
EQaChcmuhiV8Fh9ID9D2ZkB5T6qWsLONtRt96iR/ma6v4Pix8lkzG6lZtKLm
JQMPFheYDvS8YpPX75c5U8BAk2v7QH5KEYsNhwU6RQwkyhvPmuNWyIptl9y/
+oaBDP2eeFFFPmsWFr7Q8h0DM4uMVGbk8dhprVYKVY0M3JVandSzzxEHRPIn
3g8zUNxpf7Dg8Gt87XZgy9/fGDgU4JEOSW9wSpJiruYoAw13ymx0O4txQ56x
/+XvDNQpOHVyuaVYV5g6uGMKAoebWseaLStwv4G3oFwOQfbZ6TkbptXiw0NS
1aUrEKwUJ15Ttf2EHVK2VthrICjJN/syt/UT3ssNLSeaCF64WsW7uXzGRpVT
ixV1EIh8y/nyx1rxktQpudx1CMp4NlLSuV9wp7PE/TFDBBLXZRx0nrTjlnlw
79I2BHsFn5MtSDuurQqKXWiMICtyP1dKg49f6/+M3maKIDkef1BP5ONE5ckr
V3chWDa4f6d5RAd2qfnuv/wAAjMPVYViiy5sf0HPN88BwbPNnJbMs13YGgK8
LJwQ2DfumrUotwtvTR8/5nMQQWTHftUgNQFWCx9zLnRFYBq86NPSAQHmG4zs
sPVF0HGqgNHyoP08qmva54dg8f3zFrkxQlyT4WscdApBsQQ/IbtciIsWfDO4
H4igpulH029qPfje2LDuwBkEwjZOY+H7HuycObjoQgSCe+TevgmpPlwiEyDe
fBVBr+aR1JUafVjTeWre4DUE1bK63qlWfXh0tsI++ygE8u5+p7zu9uEI77WX
te8iIP/ailatEOHhd/l2HTEITkk5HDxnJsJ2i42WRccheP1cb1jFXYSX1O99
NSWRns/SEsUpqSKct85/rC4FQcgNu/VptIeZSIm34WkIpP9aZNhLe/hc9/kb
bDqCsaoEE5c9YmwVHa39MBPB4xd7r0ueF+OsAc7EAR6CJ+7jl9TixHiBaUrZ
7GcI/rbd0XP6hRh3j+ccCsyi63M3e3zki7H5bsPVOjkIys87+deOijEvtVyi
KxdB+nGDmGmytL/sW25bYASNk9s2Sq8muOOpi6tUIYKqUO8X9VsJNpUV6WYX
IUhqDeQ27CFY8eVENVOMIHZeUYiXD+0VpbDYj2/p+7z8TWNmKMFfjv9x7FIp
gv+ZjbnUXyXY6G3URoNyBHmffaqrYwhOW7hQ+ts7BCpHnRdMphA82/9BXUoF
AtkmyTG75wT7VWknOFYhUO/snNddQHDLsqyTCjV0vif6N94vI3jLP6Bf+gHB
pVk28699oP3aWDLjdB0CrkZiSHozwbKrLBtXfUTgNsLTG28n2DO8MUnQgEBO
MV/BR0hwQzvX+04Tgpl2OztUCe1nvR4DyxYER/hmZ0eGCE647ik37TOCMzLj
HydpD0v3jbfktCKYtXK4cA3t0+NbQ1JOtNF59FylFU37tfbODH81Pp1vbRlZ
Ddq3G75e39bYgaDSfbm16Nf/zzvnz7nShSBifvxkC7VUUuKXLd0I3m9unvmd
9rPbpEb6iBCBamNsqDFdr2rvs4C0XgRDTXM8imh/62Zs3s4V0fMuy2o/Svdz
e3qxkhJBsMbBnRjS/Uo4mXeU9SPY0nvkiamY4MNZ9ZlBgwguPmV3BNP+fyfv
GLRmGMFthfb2jjaCV7kKdgi/IrA4GxXv30TwzcITyjEjCHaF/sjSqyF4Yt6o
wGoMQZz1745apQSXlEmH5P1A0MKP3Z7wlGB3w7bI0h+/5v/5IXNq+bzsmHrq
Z2strcZ4BNs8csvpp7bWULhrTi2IeDegNkHf5/TW0W+ZBE/bE+l0mTrj8Fip
fgbBhq1z9R0mEXhM1telPCS4a1+/2VFqK/UjU3dRh1eV2PpTK2VflPyaTHBN
4Smfa9QNf944oU/tnNicVkytz388uzKJ4GDXWBXtnwgK7a/7CBIIVmv3W76J
WvbPlLQL1CV2u9Ztpz7adOCpOrX8DsndB6lvP4hZe4L2e6zWwfB/qRWabvwc
iqPz9kDvZiK1wZaE3BvUXQsVkjKpNRfuNlkb9+t7+TeF5dSeXtEffGLp/i7c
rWygDpfRqVGk9p3i+6mTWmDpHv+Mzr9ygHnvIPWtFjODPdQvh5aM/aT+saEq
c/guwf8BSPWnVg==
          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.9999996187787015, 0.9999994313041395}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 4->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23c8ld8fAHB7K5fL5RppShkRTTmflFQkDVoqpLKS0VBpoUGRSArZCl9J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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.9999992328657719, 0.9999997588489247}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 5->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUmnk8lM8fwN33sdaxLAldEkmH+CqfqQilkrNDKiJHhEqSdFBEziRRpFSS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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.9999999574404889, 0.9999976139198089}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.9999993680039507, 0.9999995755730018}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwVmnc8Vf8fx+2yN+EaF6kkyjdK6/NOGkbDTGZ2IaMyihaVHamEQkoRUUoL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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.999999941761652, 0.9999995837354044}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwU23k8VG8XAHB7shuyMyaFStqkUnoOlSIqQiUplBZLtIekUrKUJVsIKb/I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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.9999996187787015, 0.9999994313041395}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwU23c8ld8fAHB7K5fL5RppShkRTTmflFQkDVoqpLKS0VBpoUGRSArZCl9J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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.9999992328657719, 0.9999997588489247}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwUmnk8lM8fwN33sdaxLAldEkmH+CqfqQilkrNDKiJHhEqSdFBEziRRpFSS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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.9999999574404889, 0.9999976139198089}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}]}, 1]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{214, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109903107]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->631667934],

Cell[TextData[{
 "By default, a ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 " leaves enough space to display without ever resizing:"
}], "ExampleText",
 CellID->65337598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "20", ",", "50", ",", "10"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47389411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->20], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->30], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->40], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->50]}], "}"}]], "Output",
 ImageSize->{192, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->766596775]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupView", "[", "d", "]"}], ",", 
   RowBox[{"PopupView", "[", 
    RowBox[{"d", ",", "4"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137908413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      PopupMenuBox[Dynamic[Typeset`var$$], {1->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->20],
        {"ResetImageSizeLevel", 2}], 2->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->30],
        {"ResetImageSizeLevel", 2}], 3->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->40],
        {"ResetImageSizeLevel", 2}], 4->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->50],
        {"ResetImageSizeLevel", 2}]}],
      PopupView[{
        Graphics[
         Circle[{0, 0}], ImageSize -> 20], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 30], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 40], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 50]}, 1]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 4}, 
     InterpretationBox[
      PopupMenuBox[Dynamic[Typeset`var$$], {1->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->20],
        {"ResetImageSizeLevel", 2}], 2->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->30],
        {"ResetImageSizeLevel", 2}], 3->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->40],
        {"ResetImageSizeLevel", 2}], 4->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->50],
        {"ResetImageSizeLevel", 2}]}],
      PopupView[{
        Graphics[
         Circle[{0, 0}], ImageSize -> 20], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 30], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 40], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 50]}, 4]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{190, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->172881559]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 " resizes for each pane:"
}], "ExampleText",
 CellID->173577523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupView", "[", 
    RowBox[{"d", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Automatic"}]}], "]"}], ",", 
   RowBox[{"PopupView", "[", 
    RowBox[{"d", ",", "4", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Automatic"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->908772701],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      PopupMenuBox[Dynamic[Typeset`var$$], {1->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->20],
        {"ResetImageSizeLevel", 2}], 2->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->30],
        {"ResetImageSizeLevel", 2}], 3->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->40],
        {"ResetImageSizeLevel", 2}], 4->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->50],
        {"ResetImageSizeLevel", 2}]},
       ImageSize->Automatic],
      PopupView[{
        Graphics[
         Circle[{0, 0}], ImageSize -> 20], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 30], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 40], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 50]}, 1, ImageSize -> Automatic]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 4}, 
     InterpretationBox[
      PopupMenuBox[Dynamic[Typeset`var$$], {1->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->20],
        {"ResetImageSizeLevel", 2}], 2->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->30],
        {"ResetImageSizeLevel", 2}], 3->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->40],
        {"ResetImageSizeLevel", 2}], 4->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->50],
        {"ResetImageSizeLevel", 2}]},
       ImageSize->Automatic],
      PopupView[{
        Graphics[
         Circle[{0, 0}], ImageSize -> 20], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 30], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 40], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 50]}, 4, ImageSize -> Automatic]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{160, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->622589875]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PopupView Control",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11022400],

Cell["Start by displaying the third item:", "ExampleText",
 CellID->670411330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362698449],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 3}, 
   InterpretationBox[
    PopupMenuBox[Dynamic[Typeset`var$$], {1->
     TagBox["a",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["b",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox["c",
      {"ResetImageSizeLevel", 2}], 4->
     TagBox["d",
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 3]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{42, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158370511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46312152],

Cell["The setting is based on position:", "ExampleText",
 CellID->203310167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27573176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    PopupMenuBox[Dynamic[$CellContext`x], {1->
     TagBox["a",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["b",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox["c",
      {"ResetImageSizeLevel", 2}], 4->
     TagBox["d",
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 
     Dynamic[$CellContext`x]]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{75, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143508291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180077237],

Cell[TextData[{
 "Connect a ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 " to a slider:"
}], "ExampleText",
 CellID->223978197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "i", "]"}]}], "]"}], ",", 
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->573400473],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    PopupMenuBox[Dynamic[$CellContext`i], {1->
     TagBox["a",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["b",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox["c",
      {"ResetImageSizeLevel", 2}], 4->
     TagBox["d",
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 
     Dynamic[$CellContext`i]]], ",", 
   SliderBox[Dynamic[$CellContext`i], {1, 4, 1}]}], "}"}]], "Output",
 ImageSize->{268, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33428424]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->322777120],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->110368608],

Cell["By default, no values change until you click the popup area:", \
"ExampleText",
 CellID->214704586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24121998],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 1}, 
   InterpretationBox[
    PopupMenuBox[Dynamic[Typeset`var$$], {1->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Xk41O/XB3BLZGmxzCCKGWQPlZRU5yglSxERQlJZIlsibfpG1oQSomix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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.3461261180190739, 0.581865061766651}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 2->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c81P8fAHDb2SMZdyfjlBJKi0perxTJqkglFAppqJQRUSFkK6RJRWnQ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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.31353019895394485`, 0.48649847604027}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 3->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3B7hZhBUTEziqzxTSLUPKdEtkQlWVIke5uyJFuUkl3KlsgS
iUharNeWfZuxzyBlSUL2tfK7v39mXu/X3Hvuc8/5nOfeEbe5fvoKGwsLixz+
8f/vJF8brv22IVS9vMFbHlVOGjUdFANTiiNUnWRZz8vkoG7UlgdSKHfgaf6o
795MZSpf9Md87t4ACPIli391MaYmVYSROSnBEDP+y67vlS1V/rdt+IZ9BLwr
3Erul71NHeB78e9PTzSkH3Niy3S5R5V4tUVlbf0pmOiNG2u+CaG6HHG7ukyO
h7LZczeiXsVQ33cOpS9oPodc63Avon0Sdc3ZoH/WPhm+/nNzfyibTk1h7Q9e
1noJx1NiktV7sqnHW6Ikl3pSQeDPrwB9l3fU8bgTlQuO6XDp14pq/d6P1FDb
v5bz6xlw+eCu6tDsEup//71fmQ3LBJbE/OlH7JXUjnWHmBnya8gOdGj+kVFD
da8j/ff7XTa0H6Bmk2rqqTufdDZNaebA7WC93vErLdRyq8f2k125wG2XkuKv
S6PayCL2X/Z5cCvnsFKUTCeVbd2rbcE7H4z0/kmxm/ZQO4dMxBa03sFxwRMn
33cxqK9q/3Oe5ysAM9Sv4Pt6kOqZw1M011MAlgpLPBTnb1S96DGuuZT3YPr2
8cOJvGGqqGfl2VnHQsi58cGRV3KMOn3heeqM0geQMil3udU8Tq3Q9Jj5vf4B
hhMVJLZm/aJGy5ym/q75CBdPnV2vLZqm2vLvC50O+wSnR77vqGOdpW5ifpea
IheBnEOBl3faArW3osxtcrwIrL6OEDVSl6jZr+Kqf70rhlv+nn/7Klaohq6G
Fyc0S2Gcc+RqlPVfKuW8TO5P3jLgka5leTa6QZ07wrE+3lUGY7LG915rs8Kz
LcXPfthj8HGQnjomyQGFHnqut0QqYFhUu1+9gBOeT6jumPeugC9ih3zPnd4E
19oF7Oe0KmHUaf+j1jZuMNVk4XPNrgS+kJ38lLe8gD5OFc7yVcHBr4809qTy
gcDzerbZniqQscnkirEjwjrfx9c3DlfDsA9TMiJAAEbupRnNpFSDqNP9fNNs
Qfho7/vit2MNvCO5UrVI2yGZ4ax1vbUGQrKua404CcOjk2aT00pfgE1rsfx4
jQiYH1BWn17/AlAj+urIi12g+Ur829VLtTDRUl1/iiwG8jv4H03V1IKgbHLd
9rck+PfvZ9dkWB1s/uEtzVyjwMvG5Ju/yA2gM+q0PB0vAQtxH2S/hjaAnXH9
pa3ZkqBt3zRMX20ApuLJLLPqvTDJvmxS3NEIK87dudsEZODQEUP14IfNkOFe
8MFQQgFCeGznvReagajq4MIfoAiDfXdybli3QNQa00nE7T+4755BOq/RCqyb
gqnCU/uhPe8Pm9TvNrALv7AthXQQBGCL1VaFduDdmfJNZPUgaOyNUX9o2w4f
haSPm/epQPjC63kvWjtIOYQHB7w5BMpRXVds3tDgRcPgdq+4w2DleelY/zca
ROqXFeukHYGHF3+RzonQQV5p6pt7IRUY+1h7dR/QYUtbgw3JDYFfo7ze/osd
8Jal27WMfgyy3n3a++ZpB3iMjv/IctUEetwxdsnmDtC48I/Jt/04SNifLxVR
64TbBYpXrttrQSP7fQUWwS5QNJ47FnRQBxYm+Hi8dLtA8NTxrbpzOiBGj/8x
79cFHlyFuu0FunAjJS/lx2QX/Peiim4E+rD9CFOgrbYb9nOyeOx8aAhIwu63
zt9uqFy21mC9fAoceWabqg70wOHl8RovcSMo7eN68DGlB0ip/EFPNxmDjbvS
cpJXLxxgibs8PHka3uYFM10UGED6ZlPSSjaFCYGJUD1rBnzWjdPPeGUKUu56
VOkYBsjpB132VTwPKYd5Xg6vMkByk9oj7RNmEN0Qamf+hQmJJlsZ0REW4D4c
MXvCcgC2GfNP7dK8BAXaM6mSEQPAJ8LUuBl7CX6/NjrLXjUAj/K8ZUYmL4HD
DeKncqlBkPQc6pNJtAbzv9HeB+cHwatFWeYK52VI5mkKJGoNQcl5FmMxATug
Hrlr6W81BAvCcc277thB/zW5g789hmDX6oDVmW92IEIPGWvOHoKRv4fu3/5g
D1FxBrqPCN/gptnlmlwXRwiUbOXbYH6D2HduNjdEroI90OInXYfhJ2sBi/Fn
V2BJXSpmhgyDunk1JWTDFeI4RPsb04ch3+J01u0Tt6C+wY70unsY1qYfM873
3QLps39Sr6iPwKMx/r1enG4w7iCVM8g6Co57TjtV+nmAf5NBS8vOUZihZ6Xo
0D1ARMF1uvTAKPw5bV3wWNITdOZL/0u8gv9umLL/WKsnvPY5/cG0YRTeWx5g
j5b2Aqdon/L2yDH4cipB0ZDVB9gWU79ir8fgQcmT8K6LPpBgWs+SVzUGFYcZ
ObsxH2gUFdQMWxiDdVplE8HfF+Qys+p0z/+A/JAjnpmc/jBZ0tFeRR6HlYD4
b7Np9+DaqMxw4dufsOygefCXwgMYsurbXNnwExZ2Wazp3HgAZ3ofKbSM/ART
XaGBvQUP4FDTjzujOydgxNXCw1Y1CNjfZRC2P5wAYeIm3dkTDyHOW5zqcfEX
DLkmSafeC4ZKwR3xaoQpmPoicLjVLByUw+rLteSmgLebPDT4JhxecXmOGGtP
QV3d3QSvf+EQutqt6OQ9BYMGkZFnMyLg3NeY2oTxKaAuPwpr8Y6EiWzCwnrF
NOhl3B42H4wCbvH7Ul8PzQBfGtf7iJ4YqD8cpeirNQNPfDQIalxPIej8C1Wx
0zOQ/4hvbPfBp8AW+fmEhfMMRJpx2Hx+8hTW/k3a9yTNgFDMtOXUmWfwq98k
q41tFpz8JrGYoVhojpOSqWieBceoCLM7conwuFB5/8W+WYiN+R1w0SYRdNqP
qv0bnYUX5Qrzj+IToWaTpe7hjVlY0xqfz9j8HErdIx0/75+Dd5eD73JP4M/9
s6uv85/NgZf3kHBY0QsIJzTJvrw0DzPSIeYL+HO/SFXsg+G1ebA+uMPfxOEl
jFhdhz9354H7HWbw9fFL0MgVPGsaOw8+yn6rLu0vYVzX0mdr6zx8XTvmfPNC
KmgGTrXd0VgA4bx79yT80mBlkd/t9PZFWOEt7TL7lgE2zLMYe/MSCN/pDM0T
fwPcid+u3uxbgj21Wz6HnHwDBebXRL+OLYGAnkxhxJ03wM54eKeYdRk8vE5u
46e/gfTe4gM3VZehntS279f9HBjromQNpi5Dwr/Y1m1zueDUPhlZdGcF/mhE
t3G75cPNL/dtrkutQezvR3lpme/h3Q3eMyK6f+GUQqqBmX0xvLzrPPGfKQsK
NIiq/2tdCQHJf4wXJlkRivdcOZ//BVg6hlCpFzuSSb9UbKLQCHtv23meleVE
sZ9tMhpU2mBkMfYcTxkXqtfyWyAs0EBv1Mkn+uZmxNF+Im/JrhMMRyLlSCRu
FO3U/lk6qRua5UY6LSW4UVbJUulkejfo31L1TZTlRvbOESU5Od2gwzbYLqLK
jdYFg2Iopd1wjCLnLmjEjUKd6+V7GN1w0PJLxeYAbvQ22rDwrnAPiHaumsyP
cqMT2At9/7AemKi28a/P5UHCrdb2V517gRzV6xReyIN+m/HoxLv2wlkrQ5Oz
JTzoXPDUZuxOL5SvqMkO1fMgdRIIrTzsheh9xM7lYR5UIjOQR07vBY1YTEpq
Jy9a3FyzCsxeCHUSbXsQxIv4xz9bJh3vg0rV6CL9MF7keXzo+JpeHyxxbE4n
xvAi2Z0PzIyM++BS8rxn0ktepOcdNffjQh8odzbu/lDKi17dcDKoce+DgSN3
3EfmeJGUzq7f8pl9oEDsFtO8uBUJds/sjGdjwFjYWMDTK1uRiZ/BkcJNDEji
Xv7xw3krsvRMYtbzMoCXQ6Qg1HMr0iim3R3czoCJJTPt7qit6Nq5v73FsgzI
6B+45lizFZU5nAhUNmaAaNYoFiHDh4ZZBgUJ8QzolFiS+K7Ih9iPGHCcSWJA
yEuux8oqfIjFM3s+/CUD1hKkzvYd40MiAxYVs68Z0BvmOL7bkg/VnDmabVPM
gCe3pggfw/lQsV9VxHQfA7hh0bp/ng/JLwZ8eSrIBM+j0ps/rvGhg+W8e9SE
mTCmafE2gpUfJT8JqurYyYQqncq1Y/z8KCTs1sdpcSZ4nQ578lqWH7XMnf9b
rMiEX1ckv7hb8yOUxH7jtS4TzB3OOxs58KP9unv+lhswod4phCh7nR+dy/nz
uOkUE9Kvz14Y8OZH+Rqq8Q0mTLC8U7akGYePp3Ne0MyaCc2hJtLENn70oH5M
tsqdCeoRj1onuvhR1xn3Fa07TMiKKrld08+PlFQdHlfcZcL9Z+KVHhP8SITO
OxXvzwRS+5L8bzYC8qe90R0IZoKJMYHFkouA0kR9ureHMiGULtNRv4WACLcd
eU6EM2Gt0/JOKoGA/IJpF0OimdDdV/XFhERAHvc/nklLYMJWi/64KnEC2qEh
WBX1nAnH+xedFSUJ6IhsRJn7CyYUDEoLbJEnoG0PGw0lUpkQPhxuVapGQK7N
FX5bXzPhi23WfpkjBCS+cflPXjYT/oxWcjxDBHTpgPekTg4TnMYXsq+fICBJ
nuc7rfKYcGLKfHm3CQG9OFZ8ftsHJrwQCuzwO09ADlt2rNh+ZMKCxpu8fgsC
4mMv03/ziQkpj9ftn9kQkO2R9xyixUxYerfn+PwVAtIOuWerXcKEk336FCNH
/Hy5sKv2pfj9Sj3v3XKDgF6mhN4IK2eC0amaQrtbBNR1WfJKNMaEV+6TkdXu
BHTPXGslrIIJZ74c1vXxIaCnp5J+O1QxIXvSVpLhT0AnXdIMdaqZwCIUxqp6
n4DW/jYfJdUwIcdmoGjmMe7PFxm5+HsP22POZyfD8fnwrfCyr2XC+Xf7XLOj
CKhn8UCGcB0T3vaaGG56SkDJy8dMy3FzsvjK2sYRUGXs3XCLejwfUq+4KhMJ
SEb6ps5v3AWGrd/FkgloQb004E4DE6ySSIk9GQS06Nt27WYjEwprtD2UX+Pz
KTu86ytu7slrZ6JyCEjaaBg0m5hwSTBWcTqPgK6OBfQm4f6kjvHovycgzf+8
hqdx89n8+JH5kYCWKoKsVJqZYBvMX8NRTEB7fZ1P3MZdnK+aYl1GQEMvZxKz
cBN6L3qXVxBQe+mwWQduu42H53fVEJD7Z2G/Bdyle/OVPesISKfPdgtvCxME
DHsJXY0E1FmRtbQDt6Mby9T+VgL6db32OAl3xXPphnAaARXovJoVwb29xijj
VycBVRFU1rfgdvnleU+nF6933uHiLD5+lcDLCxlMApoJUBVtwy2i3qDG9pWA
tEqTFdNwX7Oe3XbxOwFd3JQRexV3zaMdcyWjBCSvbnRaAfeu/KOtIj8JyCoh
78Iofv+uPY7ZbpME5Pa1+1M07vp/UUH03wSUo/zVSgU3aW+xjeI8AbFr/DBq
x+f39snv1NAlAjrGIxh6CXfjbe5dP1cJqFY1lO8Hvj6U50rLWn8JKLH1Xvdl
3O7V5h2pLESkbSH9vRtfz5aJgLwNdiLqHi9SRLglBN6EWG4iohh297JkPA9e
ah32RdxEtK3kZfAinp+9j/ZQbhGJaLXPozsQz5d3nv6fNiEiMmatP1OK54/e
fatXXoSIRHQ7Nv/C8+knWRM5RiKitg9pgnJ4fnurbFnN5Yko/gfJ/yCe/5mj
jJ0+ikRUxfo7UKmMCZsqTymnKBGRinrM6l58v6hg6vZjh4jIqDLn4FIRE2JK
CC2uWkTk4SpH24fvzxz1oLGnOkSkJ/pcc+w9E6qL1jc+6xPRFHGa9KyACXOf
xpQ2jIno3M6tvP34/j5VWBoXYkVEBhe401nwfmB3QKngrTURcRxUP3o7iwm+
BZlNNFsien/VEb6+wsfPj/4n7ExEV3r2WiSm4XnOdbBN9yCiDvsPy2/wflSb
IfRfWSQRrenvICiEMWFQ4rHu0BMiUu2JMBMOYcJi2oYNeywRqUv7Ly8/wuc3
deKpbhIRfdivpZB8nwkBLyrWu14T0cuuWPcHeD+lxrrUTVcR0VdR/7V8eyac
2/59iFhLRL6jSTr8V5hw9anpmnIDfj0P/mFbGyY8f3Js3902Iprp811ftMT7
S4TIk039RFTW7P0uz5gJHx7VWFEWiSjdemXZXw3v33pNIg9XiKjGypGXX4UJ
Cbx0+tQ6Ebkl0L9FKzHBP/KrdgmbAMoUkW67K8cEg7g1hXMEAfRe5WYBXZQJ
3zP/2wiRE0AefObpMX8Z0OWoWjSnIIACBZUafPH/XfVy1FtmSgLo/D21fKtF
BuTm6f/YqyaACh///bIxyQDPT3ZtldoCyMG2bkcdkwF8dc+Tl60FUI6jepXT
JwawBqeZWV0RQIbRPmrvChiwoJct+MVBAJk+tPKaymVAX+unh9HXBdCWxjyL
E+kMSO+mX9/nI4BsTvzI949kgPrYZnQ5TgAJ3p2w5LZngB2n21BrK37+t89l
/vj7wE5yQ886TQDF/W3RG+diQOshsTbpLgHU3EDkO8HKABWXL2UBTAFUnTWs
MbHYB1wd2xJVxgXQhZ3T5+oG+yAj5aPJC1ZBVKxCyRl42wcjGiuNV5UFkWnm
9t77On0QZ2JQlaAqiMJSmtu7jvaBwfWUojp1QaSckqtA0uiDwlSdLPGjgvj7
1Fbxp/v64P6W+AddJwXRQYwgKCrQBxI9auiIvSAaE+ejR/T1wmXXux94EwSR
TTDpm6hNL6goDX6QSRJEHjHkkw/Me4F7Dn3UThFEfcUK70dP90L+Ta5P/q8E
Ef/LC+7hmr3w50bU54UCQZT265CIv0QvPLueWdLfJIhOz36mjY70QINLR2XO
X0E0Yc6n1nyxBxTt5VoNrIVQ/bea+4nUbhh0JF/PtRVCrDq8gSeUuyHURZDA
5yCE1h4FD07IdMPPm+vGbdeEUGMYvUx4WzekeTd1GXsLIUVqxBPuX10gHO08
cC5WCN3R179w/mkXbJS+mbzUIoTO7FqIeT/cCW0C8jxuatvQzPNHt285dEDJ
24BEefbtSNMokyFn2g53WWWNmge2ozrVnRyp+g3A3e+lc61QGE2o3ajbHVgJ
o6/EY5K9RVDddbVjl1bfQ4z0Do4ikx1Iin32hpxnKEQm2NVZU3aiB7GVn981
vsLMYy608v7Yib54G3LU6RZhK8czVpPLd6G9piKZWx5WY94lyYE1lbuQJee0
j3RyNcailLD1Z80upOQmWqn+qRrbRI4QV2rahX73brdW+1GNbV/11K3p2YV8
qgZ7k7RrsAO5BvHjM7uQRN2s9hrbF+zatoVD+/eIIt696PKnm7XY8Ogxz6qH
oqjT75Mvt2QDdiy5NVU2RBR1NfvQr2k0YCnnzVuiw0WRvsZ1x0rjBsyq6ebu
y09F0VnR/Ur7fRswRn5KM3uaKGoEzl9q3Q0Y/e4/ila5KHovO7k2GtCIVRGL
G+oWRJGXe0mjeWsTJt6ktaC4Ior6/BoKb35vwvzv00hx66KIO+rQPbelJoy6
PH7LgU0MxVT+jdUkNWPF/cKkLQQxlJ6w/GLFpRkryHRz1ZMTQ7Mmj7XLuFqw
1CP7d7VYiyHLfs4VF7lWrMqQO3DdVgx5pKj2f9doxb5fHJ6QcRBDfCoPtpww
aMX2BDwtDromhownE3YzXFqx9NpVM3RXDInUVQfJ5rZiGaeq4t7HiKEF7fHF
q7JtWJb1me0JdWLIRLlXKounHat3lfetbxRD8K2Eq1KgHRsP5BxbahFD37Ky
k9t3tGPSrz59ONMphp4nP5vvkGrHXk/sMtn6TQwNcSq1O2m2Y9m3Rp74r4kh
Td7c9m7Pdiz3gRvRfh8JcW7aiIzpb8cmD18IePAfCZkHNyZYf2/H5BeOz6cd
IKGBn7N2kuP4+TZCXUNq+PF2x49EzbdjWfA+zlybhAS4w9JWt9Cw9NUZsuFF
EhJZjnflOUjDRvJ7I11sSOhJ+3iipjoN2+NQwRpyhYR8PG5ccQUaltodMVzn
TEK9Zlq097o0LPm9QuZRTxJKK2jq+nKBhiVcdVE4GEVCguysMxL3aRhD4mzy
mRgSmrbrVKt9RMN29GsQXGNJaJOYK5dVGA2L0+OZe5tEQkLIVPzmMxr2VCr7
g3Q2fj2Vr4qSWTQs8tuPw6LVJKQSYWJU3UDD2uPactVrScjylNem5hYaxm/0
iWTWQEL5dhXSTTQaFl4exPKsjYR66hXSc/poWGiiZA1/PwltNdlu9mechj00
uazPvkhCL+5xJrdw0rHUU/2WV1ZISKx9n1nQFjpWqmtyrW6dhG6plxUe2ErH
5o6ciAphIyPXkwl6LkJ0zHKvXI8ggYx8hIOaz+6mYx6U9HE3QTKaLplxKZCk
Y9E7xdZ6tpORMe/9dA4ZOlbHxy/2XIyMDhKDOoMU6ZjS8pyNhBwZ0SliO9gO
07GTs863gxTIqEyh+gwH0DGHXyMPxveTUakwp9j6UTqW9LU7K+cQGeXsjTWt
PUHHNtcXTytr4+Oz8J7tOE3HBuMCvLSsyUi/wbio1o6OrUavh2TakpGfb54X
0ZGOCYXdTtriQEZXFbPLjZzpmO49u4qWa2Q08eFKc851OlboqMd1zpuM5CP/
zTI86Fjb5Wrhz35ktBwqVtJwh45NXDgsszOQjFRKHNlz79Ix8mkFg8FgMuJq
PUMw9qNjj9UFou1iyejIYTch/iA6lqEcklafQEZ8ep1tLx/SsQoFjg+yL8go
bfjVZplgOra4e6lnOp2MCrYZzAmF0jGC2PWfRllkdMWPLe1OGB2TFR5fK3hD
Rk7bF9rp4XTsEg9DzKOAjKS6EtNtouiYF+cZxb4PZNSZ4aIXH03Hnm40IY0i
Mqqdz71a84SONc6XXd7AyCi6mm3fylM6Njql4mZdTUbmtfYNLLF0jGU8L6i6
loxkdIeG/+I+2P/y9cMWMtqrsfakKx6vR8FhJa+djBaeNMy+TKBjk34KJ3o7
yOjxRRc920Q6Vk9beMrSQ0YhTlIvRJ/TsfQ9JSPSDDJSKjw+1Yjb3+3eAeMB
MuK5LnjoehKel7oTAXeGyGiAddx3ywt8PZw7yY1jZBRznI+NkkzHZkoTrs39
JCMtbDc8x93MZ122c4qM8jKq7vCl0LGsS1K8mjP4fFlYFrjjvl8wZe48T0Yv
3S7/7MR9iaPw9ZMlMkosNSLLvKRjh895rZSskhFDOvXsLdwiWejEyB8yqhpl
BL/HvebNrs/FQkGXTwViP3GPZ9i5JrBSUNec9NK2VDrW3doQr8BOQRPhVgqH
cNcsy1dWcVCQGrHUwQh3ASVy/BwXBTHjBzOscKfozvP/2kRBRz0cxmxwh7ue
U/XbQkGp0qxyF3B7JxZZCfLg41uY3D6J26lGNCiTl4JuT2+vPoD7/JRfrgYf
BTlN/hEm4NbePtzZxk9BTyOrb33H61MG7T+XiRT085h8Tzbu3Q6v96wIUNCn
hL/HHHETonj1Q4UoKMmc/bMY7n9F110p2ynoxm0+1Xp8fia/0+MLhSnIlWOx
wgF3H49Kpc4O/H7ORp/bwOe7Vjl+vH8nBVn11a6E4C688If/pigFrRzwzOLD
nRp0UZWTREEExSi7h/j6ReZVWcWTKehuBavyEr6+vr2SQfvEKWh9E0a0wO3C
GpxbuZuCLhlWs3zE86Bz5tSfn5J4/fVp2w3x/Kh4F+zxlaKgz2bhEILnSyJj
m76ADAWZp/X7lOP5Y1lmxqvLU9BM7Sp1Uxwd+5zgoBqiREFhPjlz4jF07FV1
kxVZmYIGv3GN8eN5j5lUCHp/kIJ0YxeX5/H9cYO62Mk8REFFI8HeLyLomPT3
e67yQEEmDQHyPo/p2Hae0fgKREF6AUaHRPH9yKGsU3n2GAUN5MldfYfv16EH
fAQfLfx4jSzT8vt0LE4mMbdFn4LoNOnzNr50bGFeOyPwJAUFT37UCfemY6fK
556rncLruShZ9NaLjnGd0QvNOE1Bwu7PxVvc6Zib96qTjxkFyW3o6/lfo2Pt
2hk2BywoSEGb45aRCx2TJxqb/7TE86OtJb/NiY6NZGTpmlyiIMxZ3cz7Ch07
3WYqvc+egq4q2fVXWtCxt/HslGEHCjIyyKpXMaNjW2zzhOOdKOgXF8M05Rze
b1a4NnFeoyDV6moHY2M6prj742j/bQp6Ua2aIKdNx3jdhNJCAyjo2so936p9
eL+FioRj9ykoQPNRU4AsHave4hK98oCCvHvujqpK4f3mRfU922A8r7cTQvwp
dOxnneulw5EU1GGD5kIE8PzspIlNJlFQvUB7U9gCDds96r0tNZmCVpdoBs9n
aJhPnvTW8y8pyHEquil5koYpH/f/U52Oj5fv2vZgBH+eXlVkJr6hIJ03HIat
HTTMryIsTr+IgkKi5KTO5tOwiYGKmNViCvonw9bQ8IaGnVufj8wspaAqxV72
g5k0TF7FPJi9goKi6H6nJ5NoWO+bvV4ltRSk9Hzj4+BjGqYUi1nIdVKQ78eP
jV02NGzs6iyJ5zcFlW3bWi/FQ8OMQyR2Fc1Q0LYWrypTThpWmmUqbD9HQSKW
2jSfjXbsyXAZf/UiBbF9mj6cg78/ILPHLHf/UJCKfXhNNLMdSzi+5/vEFnHE
qnbE4fHrduzkLpOMRglxZJH9+osmtR2LG1GosNgrjsZcXSc+qbZjI7mbmZNS
4ujvg8jJPfvbMW9USuCXE0erx/rihve0YzlX9nif2Y/7WT8b25Z2jDt/9nT/
EXF0wY3s4JPWhtUdD2eZPieOSN3CytnFrdjRa3UWxGBxNDXlFDlY0oyt9f7U
rnksjiQPnPcJfd2MFWryKnmEiqMb/bLTMrHN2N4dxpsHIsRRoalK+AHXZoy3
hlGY9Uwc7X71Vz5Qqhnr3TG9FaWLo/gPt/eRI5qwG1+EKq5h4sj+sLb9q9ON
WLKojUTzojjSGJALm8mtwySqM58ZWuxGj3c7rYkfqsIi91XJ0st3I53hZx5O
JZ8xu3kOWoPsHpTYEkjornqF2bybowRH7EFamnxn7n+6BfWNmwNL/+xB37tI
CrFiueCi+S2yAbczy02ld5RcIJQWvejGffzqmf+a9uTC+Vyn4hnc7g/rRDZk
cuFHRPOsxN89qKb74nM7lVzgMom8FIb7Z/nkVeVTuaD5VZhq9W8P0vlnpNrk
nwtjpjP6zrj/Zbe6jATmwuP2ejNP3CIWrYl/g3KBXnnHLRp3XIrxmGJYLtik
M3NqcQ9VWeyLic8Ff8fkXYobe9DaoR2BFgW5IPHdQ+Ywbs41P6PbH3Kh3txI
VRd3p4e1cNhnvH4D1jOXce9ZjI4qL8+FZIXLj2Nx39mfpirelAvHMjXi0nET
DDra1Vrx+shCr97hLn/tdfk0LRcUiF8qm3BnL8q7Bfbg9QUntfXinhFRXUhk
5II7m/vAKO6t/h9dCgdyYeddw19zuKMqswebh3KhfH7v6gbut1mCeqPDufA/
jzXZpA==
          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.2911612749174886, 0.4343944236404684}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 4->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3BLFLLP2BJmpixZkooi8xyJUhIVpUSokLKVSLYsiciSypYt
hKhsfREukn2ZsQ9Ksi/ZFVF+9/fPzOv9unfuPfc8n+ecOyQrx7PXWZiYmGzx
j/9/v/K2Yt937QmVp0Te++t49+GaDin9C1J2YOAknj6kZqi5WVvhLyV1HziH
a4vOqkVo8kR9/MDZ6weidyz7vgQWar6qDJNkkwoGOVUuJnY1mqbC3LWnmzbh
INXIIUBoGtb8ypP4b6MnCkYfdYvfD1zW3JXBofpn/Tkk+S9znWJhpd7SdL39
WzIWHP5wZzaq8lELOr+nLWsngP6ktPCHVVHqH3v9gQWbJHhYotP4uZFCTWYe
CP6tkwJFvKtlsn8UqMdaInf/6kkFt8Jfq0KBB6gTMcerlu3SIOevlbOh9hFq
6LW/Zkvr6bClseXIV2ZtqrJywepC2Bt4+plUorxdj9qxbhs9L5kFc4ElW01V
Dan36iSU5/KywUNFoutI1nmq2LPOpp/aObBzI9y287cptcI8xGamKxfkK1LN
L0lcpVrtQazTNu+h8EPqo/UGayrLukfbsucHMBsvvJzAbUvt/G68c1knDy4b
/otsWb1FzahVtl/iyYcGufXJ+dPOVPccrpLFnnzo/5PB+OV/l3oyaox9MbkA
ttVGNlvLuFPF3avOL9gVgsyjqj5/LU/q7JWE1HmVIuCuCl1ndvClVmq7zc+t
F8HVyP1L7kz+1Ci5s9S5mo9QG825w/xrIPUar2LobNh/IP3mqKgoZzBVdWVr
30+TYkjY/XhWKzSUurX/h8xPyRJ4KmzvTjsQQe2tLHedmSiBnkgea+HzUdTs
jJjP03ml8F3FfC/nm2iqZ+gd/mmPTzD4YdytS/kl1cDFwGJKuwy2z2f8Kl+O
pUpdlMud3F4OI+2bD6V+JVAXNbesT3SVwxyDtuWweDL1BUfpi3EbDC5/79kh
XPeaWuh20uWOSCUYml4J9+pMpyZMqYkueVbC07saFeUcmdTAK7srXYYqYZI5
W7fVNpvqQBOwWdSpArd3ug15SznUC9pMPC7ZVfCp4ND4vZz3VPTxZ+ECTzUk
5e+SSjiZRxVIqGdZ6KmGma1K2976FFLXeT5mOR35DJzqSj2RRz9SRx6+NpxP
/gxK9NyJcVIx9aONd+KcXQ2M8PBWR6uXUZP67HUcW2tgnF1m7ty9Curj06Yz
sypfoJvi/izLrpJ6af8B9dn1L4DoGtsF1qup2hmkodtXayHz7adFXYsaqoIo
7+OfNbXAopU6X9D9hfrv32TXTFgdMAJ9fs8yN1DHnXs8by3WwQXXkRap/xqp
tJEayoxJPZRt0TY+69dMTWlMcp6WbAD+sXfnWpVo1OWYoj2DoQ3wp1ox1sGA
TtW1aRpuX2uAabtynhrPduoM62/j0o5G8O1L6A/a2kWF9u2871ATHD6euvD7
Wjc1Kplcn5LbBDkbnIVSHT3UQ5oG6sFBzcArwcz3cbiP+oTr2pLncjMU5g+m
HggaoH5j3M9xsmyB6nOxHeGa36gB99IlLmq0wky7isSTxe9U2vsNFpm5Nrj1
ID+pSHiUKgAc5txKNNg1UW0ycmSMqiEdrR50jQZd4ir5XbfHqU+Xs5Y86DQI
+ecTprk8SS3uP0Bb3kqHoTFMxvjkNHWoGstxoNKh3sA5zjl3hnogsuu61Vs6
FAjRlNkT5qjm7lePDgzRQd7mS55g9Dw1yGJawkSkHdzjtteesVyg9iky9+oF
tkORyp/BVf4lqk+jwsl9Fh1winlwdY72i5qZ95/02+cd4MuWz6/e9ZvaHnOU
dXdzB2zu2uki+mOVusvmYpnI4U7oTv4IJkLrVAOD4Zgox054fQfbFKRuUN0O
Orhuz8DNlZMj4/iX2sgaoMQk2AWrTimNQrOb1OUpHi4PvS74PEs4JJ/IBDvb
Y8eXfLrg/eCzg5dOMoNT8vvk8ZkuWFl0DtXPZwEhzX6BttpuWDBdFb/6mQ3Q
rhtzJ/52w0t/o21dz9nBjmuhqXp/D1y8dIhP0WErlDHYAz8m94Cc5eLKsjIH
WN1T+f3Koxc07Ct7fzFzQ+iV8g7hvF5Qp/0sf87OA0XHTnyIHO+F63o2P/7w
88I2QXO7wPMMEDOZ/l2byAfv3gf331Lqg1NH02XDVwRgSmAq9KRlH3yRdGQs
BAuCzL2TVNnoPjA8wVDIIxEg+QhXyvBaH5h/mC93v0yEqIbQG5e+9MO9cmO3
52vC0KrwU/jQaj/46sQ81c0WAa6I0w1E+QHIyt3+tMxcFAJMeBToEQOQEW3M
pdghBveGwxeOm30F1Ti9va+md0K+7nzq7vCvsNt3c+fiJwmYyzI8z1r9Fe7E
zn68HyEJtk78/1XIfIPbu0fzFF5LwaW/UZ4Hl75B1PNBC9c7ZEjiavLn1/kO
uQVSa9wB0kDVfGDma/4dnjcNCe3nl4EBB/mDc27fQSBnv9F4sgyItD8Za87+
DpZG0es76mUhMkZf7zHfEBhGhD+KUJUH5cYN0m+5IXAbTUraxpCH1vWcP9e1
h0DE1i7JwFsBOC24c7TvDQGvjtz9a3RF8N/dyrPZPwQPi/xsT59WBvIF7/Hb
K0Mw+e1CiEq2MlQ+Vqoc4PkBMhWux5O27YON6afOpVo/YPxGpo5U4z5wzT/T
6frmB9yaCzuqenU/2AA9dsZlGCJZTNKcB1SBKfVXaf+TYbCW1gy/Y6QGMVvE
BxrThoHnET9BuV4N6htuSGR1D4P2ZnHtZOkhkD2/kXpdfQTKD/wq7y5Shwlb
mZxvzKPAXvNWy4wNwLdJv6VFbBT+as5rccYAiCi5zJbtHwXnQ+yiZkIITiyV
KcdfH4Wmr3PDAu8QZHmdLbrQMArkvq4/Pya14GaUVwUtYgzOaHiab39+DFhW
UgexrDFw7Hd0uzN3DOIu1DO9rx7D88mkvnlSBxrFBbXDlsdAPl5Q4SmbLsi/
yazTuzgOA6m1ms2Pj8PMpw5ateQELJsarvxoOAkBEmsLeYcm4FzSVEqB2ikQ
fyghmGI0Abcc9j9tyzgF+rp2xj7+ExBbQ+JceqwPubR/DI3xCRhp+6CkdMUA
HEblhgvfTQKXdPrXDooRfDdnbKtqmITS0bvP9OyN4FzvY6WWkUnItLjEEVdg
BIeaxu+Pik3Bs31WjXTds8Cal84nFDQFuU2hC41u5yDGk0R1s5gG24MyDFM2
E+D8RbP295iGtOTLSPuyCXg5+gaHP58GzjUdNXK+CVhZDXa+acJ9VTinzuoC
KJx4Zd+rNgOX9UzavrddhCpB0djDfD9hy6IxB63vMhwIq6/Qkf8JWuVQMITM
IIPdfcRI9ydYmiuWbsk0g9C17r03PfHzY6QWA+9fAZPB6Nq4iZ8waB+MZchZ
wFQ23/J65SyksSeKrFlYAicpQGbw0DzYhnUrvrO9DvVHIvd668wD6nc2Gsi6
Do8uJqrtPDsPYq1tFXHT14Elovj4Zft5sBjc6tXkdAP+/Jux6Xk1D7IR3hi/
nw1MDxhntrEswGkNoY7+SjvIXrX64MC7AO6285V2XDfBluBUzC2+AOfZju2J
NrkJI6dC6k8dXIDrR0v8qmZvwkBpxUSdzQJQfvoOPJO+Bc0xMnKVzQuQ+n2H
QU2hA4QUHthnwVgAp2i3Z/c4HOEETevwv9EFYCOSi+jmjlCz1UzvyOYC6Lbc
6qpmc4KyexF2xfsWQXrwtZjXRyfIPb+W9eHFIrS9nLlpJesCT/ma9qRcXQJP
TJrpvaErlKjtLDJwWIKRvszwvhBXGMGvufFgCUYNt/K7f3EFjVzB8xdeLgGf
cvw055F7MKFn5sXdugTOY3/4EpXcQNv/Z9t9jWUQdZrKmZK7D6srvK5nhVYg
IdPCI8XTCyg7rTY3KStQoTZ1e0utFxgcKwzO3YcfL+qynuT1hvSoi4nbTq+A
1eqsiUa6N5zdm1JX4b8C36WxC9zdPpBrqyImv7ACQgMXy27JPgSr/vMYa/Mv
cBBbbNTp8QfO+KHbzoxfwL0cFlPBGgD5lxzEB8d+QdnJAx+8lAOAtS/ofinz
b3j3bH92W0gApPWW7ndW+w1rQ86aDUcDYaxLKvNb6m9oTRXR1618BDdpMxEl
91dBHI14bS4Gg0DEfZAJWgUrca2WfNkQKD3DPhsdvQqL/XveFJiHAFeb5Cmn
96vQEbM0kNgUAjktZ9lkRlchS/KnBynrCcw2Ft+PNlyDGT0v7213wsD5S4CV
o8wfyEv/MjaXEgESI7rsv/b/gaTfmyV5WAQ0sXBke6I/oDm9qR3zNQJ2o7CF
YNM/wHtGtr1DNBIYpc990578AUve3YpboyNB60NGImPuD7ywplo5h0cBf3x9
n3bxOsg42vOMpkZDRUmId2PNOmzZUNS/8SUa7Hv1yUb0dYgR6+3kmYiGL0S6
nfnUOoRaexC7FZ/D/QjGqrv4Bti9jbgHn57DUOCU0DvfDeh+9enF068vIM9p
+zkRvb+gui+qJgXFQnOc4P1ck7/QPBjpHGwfC2M1YklHr/0F96Z1vtQXsSAm
Kjd9y+cv1C0x+d74GQsBVTr+VUV/oXT9dRD1VRyYCPgU3CT/AybXy/JU9gT4
U7AgWL7+DzChHb7c/xIh5YH9lPIFJuQsmPU5tCYVlCs5VoOuMCHJs8YeUd9S
oXJLJtugNRNqZXod9n41Fb6HjUiFOTGh6l+jQ3sVX4NE8pULk8FMaJeP94je
y9cQV3OmJqWMCQ0l/9CacEyDKO4DiQJkZrTtepfgkkoG+CVtGC3PMCPdB1cS
DjFng6FysbP8EjMy3bokFyeVDRJVdyKt1piRbWXQXkGUDaU/pmg0NhZ0+Ln/
21M+2bC4m3EmV4IF/WhzTOn+lw1WOUWnbxiyoPTfjD0mLDmgVeKg11vAgh5S
5r+x7XgHTB3fUZkHK1JguzT1Wi8PpO/ecD+/hw3RLtYx9PD/LSMrL024ytkR
Pb7shVJyGZwcvekV5bwN1eafJ4v0V4HBSIS8hAQn2hv3VoCe9gWmPlv51udy
oaoZhhmTZQMo8Xfv1LbgRhrfcr5xhLUAJ6xYDizxoFC2mSZaCQ2O/7z0m2zM
h0q9rjqX17ZDb/U15ksK/IiHHOoe8KYTih7XmEut8KPsYDF2t0PdkHmySSRo
lR95bnlp/IXaDXHb29t/rvOj4YErErw63eAbMaj7iUUABXzh5nhu1A36MX+U
TPgE0N4Nnkq7m93w443y5hN5ASQsZpOiEt8NPHUJSb8tBVDDNeavpLVuYA5+
bWp+XQDZuNhe6v7XDcsnswW/2AqgVsOC8sAtPcBo/S8oylEADYtOUrp4eyCt
u91R0UsAefoNzh+U7gH1sW3IOkYAvSwuS1036oEbbK7fW1sF0KBbmqN7eg+I
STb0rNMFUGpYRrl8dg+0HtrZJtslgAYSrkr0vesB1Vtfyv368fsHbOOULe4B
9g5ivOqEALL4TpN93NgD6ckfjROZBZGgwn/eJrM9MKKx2nj7gCCyej5dKKjS
CzHG+tVxaoLIL3eyiKzaC/qOySV16oKoa0b4ioJ6LxSmnsgkaQmig9rjEXuP
9kIAR2xg12lBdMRnQmXFqBd29RxGmjaCKIPvxBMPp16wdnlQtD1OED1P9ztx
IasXVFW+Fcm9EkSdzcXrr3N6gXMRfdRNFkTOwjvkpt/3wgdn9v98MwTRxN3l
MduPvbDhFFm8nC+I8sZMk0ife+GF45tPA02C6CrntdDA/l6w28tZttYqiLiZ
TMPdv/XCkblbZULtgijqc/Lg9aFeGHZQKTfsFUQeC4eu7MXfm5UdyitqRgRR
5lVnX6/FXmi41VGV8xefj0Nc3Fu2MSBBQbW6gYmATpZcT4njZIDTTEz1GCsB
ndp9/KI8NwOEbpl/luIkoA1/VYqGAAOs7CdrooUI+HzajgqKM2DDbrPOcy8B
HZwxG3yjxIA2Oav6WBUCGl/3th1UZkDqZE39x4MEJFQfNM23nwF6diEN8xoE
ZGRyt8tSjQEvbIlN104QkKix3nIpMGCvjXyrviUBHS5gPnriDAO+2Uk65l4j
IFYm5u86RgwIvSXIx2NLQPciKg4fOceASed1ozYHAsKYXhMELzDgtWdTl5En
AZ1v5heyM2fAWR/sXr4PATkUz4DCVQYw+RUIC/rj5wur80xYMuBKULxpZzAB
WT6oDdW7zgDhKPuvJi8JaOnuq+oCewbURlt4/xdHQGoD05Uatxlw9+U5SZFE
AtodrH66zIEB9AQNS0YaAV0+N7TljTMDnrzhGr2cT0BWq+fTyG4MUM/eDCwr
IqA3kWG1Du4MmMhZkt5ZQkDFSyqWBfcZoJPfb/sNI6Dn/poruz0ZsFn2duZq
CwH1yN0688GXAe+wpLAqGgFJhG6fwR4ywKz6mRK5k4BS+uxm6vwYUFL3wGm4
D6/f7HGeqgAG2DY68h/7htdDrn5PfiBevxbr/LQhAopDW1LiHzHgTvup5esT
BBSp0RNx4TEDyF3wvHaagL7OhrDtCWYArWe/qswcAaWTDzQu41b8usN9YoWA
RK40HL7zhAEDg7yiemsE9K1nblA6lAEhP1hLszYIiL3St7kd9/j49PpNViLa
6PFxFHyK13dqMKGJnYj67XRJmbiP/ezQVOAkovp9snwHwxmwOFf3LZSbiExb
+g6X4k5Z/OTzk4+IxF8LJ6hFMMBw5b2UAYGIlkfiD+Ti/vf7ddU7YSJCUbLM
OyIZcPnvE1YnCSJ6o+miOIibk8k3jUYiol9GNY8PRjGgmOWuzr7dRJTGoscb
gPsGm+1YpCwRvb/TWdGIm7jNLGhRnoi6X1OfczxjQA2noey5vUSU62AdgXC7
cB9rKFAhoo6n5HeOuKX4Dt0kqBIRb7LFzAvcbQIKXK6HieguiUXvI27q7duT
8UeIyLfgsWMz7nd17+qqgYgung4q6sctQZ5PnzxKREykc6IjuJ967gvg0yUi
P9NjsaO4/3W7WKnpEVG4+Mf933Hf3leIzPWJqPgJ+3gH7oEnKxKBZ4hoT+2L
vErc+mOqf9+eJaK5ycbIDNxlyL2/3ZiIQoicjwJxK8SXlKxdJKLLdhWhV3An
rPx5KWVGREQO4zQl3FyGR+4dtyAi9Z3UplV8Pjyyvc47WBHRvc6ZzU+4p7Zg
Ks+vE5HE9R7kjvuSBRN/mS0RveRxC1XE3ViiNffDnojaxU4M9ePzr07wb+Fw
JKLowQZNf9zZDjVvlV2IiLXSO5mCW6yBLeSCKxGtK85sLcfrGUw5buvtTkRO
b+NczuBe9Xqsm/6AiAaaiIN9eB5sext2NXsTUezBmVMWuE+E6Q+JBhKR2eiy
1Dk8T8XjYRh6TESLP849qg5jgMzRtlc2T4ioLt5mbA9u9t9Gl4oiiWgCk40c
w/P75eqFDsNEIhJ7KmXPgef7wKeYPLcU/Pf3JHwR3g9pxL7wxDQ8fzKigU5B
DAhoNNOfySYi5asjpp/wfjp6wOpL0H9ElHoqiWsD78f8p69fvysloqMR6l5/
8H4lT4487ConIp6y4c4FHwYwJ9pQKTVE1Bebtq/JiwGVW2//V0HD52fgrq8s
3v/KVu+ej3YQ0X9P/jLP4utFctncne09REQadrqac48BPs4uype+EtGNier3
gnfxfPW7Za1MEtHPQnePUHz9+fTOL16BVQh9eL30dbcV/rz6xmIv2YXQTtPW
G+fx9c5oUiaWmVMIHbvy2cMDXw/HKS0vuvmEkOd6AOReYoBgrHCUr4QQ4tcn
S+SeZYC9f87jzsNC6Jxqhj5RiwEfpXy2gqYQ+vw3ibOMij9PhdGjLCSE3L5N
al86woCXq7/8vY8LoWJMfLcXvp5/vq3lI2sshA4caXpipsiAHRe7XT2dhNBx
mX/HHwrj/beSuTx2RwhFHZCwTCIwIC/qwR0jNyG0NdRmqpCfAcdbpJylvYXQ
2A/DU7Vc+Hp11P4W7YkQutDhd8hvsxeaFJisd70RQtmpElfNR3vhAfMew+av
Quiiy8hAenYvjB3j6pUeEkJNOiL9nzN6wfDxjMXDEfz4wEYEIxXfr3nfO6pO
CyG7K8RdM3G90Cx+IDx5VQilyClM5Yb0gsQhautdQWGkFC8glmbbC9UOZ/V3
6gkjjs3nIlckekEhf3+nm74wotw64Osiiu/PKwSz9jPCqLVQKNuH0Av2nj32
QSb48ST54w85e4EQYvZkwVoYhdUcLiH9wt9v0m80fvEWRpdTRUm9TT3AOeBx
wqFQGF17Gi9IcsbfZ9yyuMP/E0bmkW9HXtj3gKVAb/v7UmGkPeHwmu1GDxSf
OHhloVIYzQes/my5hF+vaM75bosw2mmu3sFxrAeqnl6L9xgTRqqVvE17iT3g
rmUw+0hEBLGSS0OP5HfDaAYpOslTBAWeMClN7+mCmYChNVZfEZR12cvmc1sX
LFqlWNj6i6DPFyIVGXVdwCRJkt8XIoLaZJa4f/7XBWIvpaqrX4ogwfg2q48v
u8AwSHJ+NF8EveeQfEQ37oIym536CpMiKGf94C+N5k6IlhXdUmIsimSbLTn8
UzvAzFz6zfBFUXT0vLqKdWwH7Iref5LHTBRBd+sOzYgOKNw8HWFtJYqIxIwj
37w6oLPbT5zHURSdSNzN3n2xAwQDZw5YPxZFpgQL/UTuDogawq5zfxJFH/2u
/M5waYeIuBt1llJiaPkGXdtAng6Xoq+0bh8XQ07LjmfO9zbD6rH0taSKHUji
8VZNdr1aGB496l4dJI7mm0Tbr/thkKq5b0eL5U504hB78unuD5Ab6MpvoyiB
zDyW787AYwgytj7FuiKBtnt2Fh7zSMMODqRkBbVIImOlvnaO2f+wGLn43JZT
UijBJtdDsacKW17STfc/LYWSp8vX9eeqsDMViwmHz0ih1/d7/1lsrcbYz50M
TT8rhXJlTE2vqlVjrp5rN71MpdC2FsUtDS+qsbNtF2QVbaSQ53CG/d5zn7Ht
roTXoX5SSETrv6L1qhrMpzIs5lSJFBqVSeVlda3Dpr5WRq+V4tePbJbRCa7D
TNaXIt6U4fd/KHvT/VUdpqB6KZi1UgopKCCd/C91WO9baY9PtVIofkZB04VY
j6m8xC7Ld0ohra0+4WL59djY7QUJrjkp5F+zR6NhsAEzerJrR8m8FNJjSync
udiAlWVeELZZlEKSCZ93W21pxJ4Nl/N+XpFC6zt+NJbKNmLINITpwYYUuh+g
uDvbqRGLO0b5McVBQu4HTC7f/9uInd5hnN64i4QWJkeSX3E2YzEjSpWXpUnI
II6F3CDajI3kbuufkSGh23551aOyzZgnKuPjlSehr+MrJxZ1m7Gc6xTPc/tI
6JMwy8cLfs0Y54eFswOaJCRYeSXC4FczVnfsKdOsCQmFhci/rWpvwQR4bHf4
XCQhlpZZCtv3Fsy8R0uV7xIJrV47v37oZwv2y27FXuUKCXWINr933tqKSYeb
9dyzJqHUNafn0hqtWABjz7tNRxKSNNmMj01qxbQc6i7zB5OQlnGHla9ZG/an
d1K3JoSEQtjOLvxn24YVam9XcQslobLmV+YDd9swaVGjbV/DSej9YfGK6dA2
bHtNX2HmCxKaSA6epZS1Yb2is9wojYQ0bkU88+CiYVEBfGuL6ST0MLhjfZ2P
hp2aUxlJf0NCxw7/zLgjRMMqatxKud6S0Bt96icdEg1Lc2S26ckjIdXvWPRd
VRrm9IVQ6YCRUH5d1Pc/5jRsj7LaW1IVfj/Rt3qD1jRsOM70RWc1CQUG+baW
2NIwE6fEW+q1JORjbE42cqFhR3bIirK3kJDZj83CbYE0bJuzhsurPhK6el8g
KzaThiWJW+1qXiEhq6ZQnoMTNEx9v7yS1W8SejGcZRc/TcM69ZbVVldJqNeb
Or86i//e7dGpXRskNJxe4xG7go+Pnu3iyUJGoxm/rJxY6Bh6tFSpwEtGNYSJ
B3fF6FhfQlljNR8ZRe50YTq9k47dLQjsvChARvSYk4niUnQs87vwRACRjE5N
/CKl7KZj/BpHeL/uIKNKRpoSKNOxH3MBV8JkyehcMeVlqzYd82Q3sKHsIaOe
kVRtEV06JrRT2LlEnozGjxasXzxBx06ezAoYVSKjjzyFTzB9Opaf1vJW8yAZ
bT9hI0IypmP6n14UdaiSUb2qHw/lAh0bo1tgdofI6KXHOqe4KR0T21xof65B
RtLPaghLZnTM31Toz08tMhpSbzE7eI2OSTgNsgZok9HuhJ57c9fpWPGjTG4x
HTISFlF4lmxDx2YK1Em6J/D7x/2jjd+kY+d5LE4kGpDRrrFzJpzOdGx2l+zZ
A4ZkFDQa6+bpQsceayxcbjQiI5eLB2NG79CxMlt/x1/nyUip63h3wj06tuvz
mxcGl8lIndBNTXpAx1oVVtMGzMgoeWtR2GdPOub+4kTBTXMyuuc9tH/Qi441
2U22PbIkI41HLwI3fPD57jj8jWBNRh76w8r/fPHxa4bMpF4jowFW9v2/H9Ix
Fz55DsyGjDaf+2u0+dMxcY8HwqftyCiFq0brXQAd+zLctLv/JhkJpaUnBgTS
MZH/bh39fZuM2q7rmAkH0bFqqXLDQEcymojkLO/AfSuE20LQmYzeTXjfDXpM
x7Ar7x7svUtGqYS88c5gOmZb9y+43JWMJi+/fO0QQscE9p2JOeVGRofyvD5u
4i6LS8pguJORzWc/qcdP6NiNLfOFNh5ktO1mw9DWUDrG54A+rzwgo0fv3f94
4y7piaD7e5FRWsunmz9xW2kNDfL7kNEP2WqVc2F0bPvbfbNJvng9TbCzH3B/
JPhtKPqREe+O6cYtT+nYVe92zjJ/PG+2D+MNcXNOkEVPBpLRScvqmme4C4zu
yPQ+IqNCk0XdVtxmnz4fvPGYjI7WmpKZwukY+27CseVgPP/mOhfkcH94eu2s
3xN8/P/YxvRwX1otvMoXRkYsefOtlri3WLE5Jj4lo6155gLOuN81GXspRJCR
n23uBzfcFw9mPCmNJKPLTtRsV9zMSb9iTzwjo/2Rbps3cWdvO57ZHU1GnRXV
Hy7gPu/y8uO1F2S0R+pphQbuf/3jNYsv8fFt05cTxp2pc6jDN5aMGtZcFibx
8Z99/3iIJ56MvqR7CRfiXhdhzCUkkNHBqal4V9xpfnL/9iSSUW2Hpo8SboOZ
+9tLksiImPK36hs+f6vGjWLHU8hopLjo2iPcqZiYXFcqGR0rWLHZjXsl6pPO
QjoZHXh5NUoPr0fiBtd5nzd4v0Zhpa14PU/cMLPiziIjtRge3VO4Ew7/9ZbL
wevXJ/B4D15/3denw/7LxeczeicKw/Mytz0xXuc9Gc2f/XxlHM/T0e/UYst8
vL8qipsf4nmb0QuvnSsgo3/6PpLVj+jYi4LBTq8iMuJ61dq3hud18pHvQmwx
3h+KlKdn8DxHKFbvaa8go5V2g3/P8H7IPHSZw6+SjPaRGuTu4/2CaS+P76sm
I/5uGXTeG+9XU+n0yC9kpDumpjKD99+pRyGSRs1kZJBqf/o13p9WkZR/TK14
HvOzFtRc6ZhHQtnAhzYyCmHkhFTj/ZyZPxvL10FGsSJXk0uc8LwMniXQGGQk
WX3q4V58fdg5Nb3o009GhHeXF+/Y0rEDKwH0vV/x8Rk9tH53g45Zc/33NPw7
GTlyU/TZrOlYpdoOjjPjZHSx4bmVxmU69iBi+G/LMl6vu2nERj06FhXvOeD1
C8+T5LWTjsfxvGQQPymukhGmvTuOU4eO9ZYddw9bx/OnqhRFQXRMdfLtoj4L
Bd3WkRUbPEjH5rXujjfxUlDEQOlJb0k6tu00d+0Dfgpy4A4XfyROxyQvZqTJ
C1KQycpfuQBRPB8OvZZPhCiowPUlk7UgHXsbd2Tg5E4K+jBpPfCWHe/fpS30
hj0UVDbEa34L30/Ms4+1milQ0OEKoQAhfL8xsQxomlOkoOwuwZPFIzRMt421
lriPgqaqzlT8+ErDpN+yfLJUo6CFmLP+HW00bNSKKX1Nm4Kqb5vaSefTsGvt
6+5yVyjobSF/a4oTDTML1rhXZk5BM3nPzhy7RcPOowd3zlyloJby2U/fbGjY
sXd/brtaU5CmT5LFOr6f7gpZs6qyo6DexD7xTn18P9X6rW96j4KGtO2b2GRo
mFXeolRwOAV9LNKzXM9uw+o5HsxqRlKQqV89n0VSG6ZoxVq2iM/k7kn+2A/P
2rBVAcIFsxcUpMqSe26nZxsWfvdg2N5XFLSrZ9lQQr8NK1NzX+vKpqBH2fuf
fploxYgVf+nkWgoK4Mk3GCG0YvWN2/zLNihoyUPLxVy9GbulPRTRgNue58De
0cPNGF9ZSWI37ru//CfscV/MvVk6j1uafMTw/qFmbDy8eWHXXwqa/MC7/Ey1
GWM3jrgahjuz5lxYvUozpj0oTDX/R0FZ9a3se+WbsbEL86fscW+8CD9TtKcZ
C6HVm7rjLmH7EK2Bu73qvmsUbv6/vIQTcs2YVVp/Ti3uwfsG41dlmjFfu6Qd
ezcp6KRb12AkpRnb9cNN7ghuqdyYWWHc9ZcM1fRw30gvW3tFxsevz3zOGreR
mAxbNqkZS1KyDnmJe1z98XyVZDN29I1GTBpuW/dzP47jHpMkZOThLmf3pbVI
NGNK/F+qmnBP2fxNYezExxf8qq0X9zNzg0AL3PdY7n0dxe26wnR9VLwZE3tg
ML2I2/sgUcsed8WS9NombodDT0QXdjRj/wN5nbEg
          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.2743815636982917, 0.3996519085643727}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 5->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8ld8fAHAjIzMU7rVHyYiMUPJ8jtCQUFkVyviSilJ2iqLsjBAyIlkl
igplhOw97rWy994j6/f8/rn39X7d+3rOec5nnHOELO5f+Y+KgoJCAv/4/3f8
UwtaWatAbI3w78K6GShXtAlqGwnawqeO02sctyJO71UWewsKugHDivoFhZsj
p1nCv+cwdD6H2nOdA4cMOVTjS4MFaAT9wUj11HqxmYKq1LzVqz2bEKCtb2Kb
PKir+pclYXebHA4X1RblywwsVUVT9yv+24qEiDXvVP5RR9V7qk526wIxQGMW
Z2Bv5qOa2z6QsqIeBxwFt0dVroer/rur3btokwgKxMV7tgcTVd9R9vqvayZB
XwjhfB9thqpGQ9jhNXIynNu/eN/WIFd1Ivrc7xXbFIiIMS8X7fqlGmS1Y7K8
9QGu1pkoZY9UqB4/nruxGJwGPjMPJqc9G1Tbtm5HLAhkwCVjIaE503ZV5yr+
4/NfMkFGpIl9+3WPKvF1e92s+ifIj1IXyL02pFpsFmAz05EFPTBMXcc4oWoh
gainbbLh++GOA8Yc86pUW+5NKx458GrzwMnA9mXV9gEDvhXNL6Cyeu9wL82m
amrl8bvLLF/BtC9mkhvtqbp+YixYIn8Fo3f/bjzTp8a0wsdol97lwtDR5IXh
PDqM1/W3/qJtHnyzeT0TQWbC5kzjkhfkvsG94I8Nt++wYaXqLgvzW99ghvX0
Pcvhg1i4+BVsvuI7GE5107SOcGNWrMeC5oJ/wHjACzbyEz5McZWue9YwH1gM
45P1bwphdD1DYrMCBVBLvuanYyKKdZYWOc1MFAChwpGRq0QMy0yNLp/+UgiR
7seu+oRJYh5Bj9im3X/Cm4l90fv7ZDCdhzo3p9R/wSOdC/N/jeQwQWPxrEmm
ItiI6DCW3H8CW1LdtzXRUQRDJpN2gvuVsQqR/vMTCcUQdmMr5LyZCha1vzBq
3KYETuTnufqzApbnovXwEXcp8KdW1rKHq2FxU0qEZY9S6Bh6Jtvfoo69MD1c
+nCwFE6H/LCUvHgWs29mt1nS/A1DdrnfJaguYEbqFCwPM39DXEX/K/Wtixj6
Ppu3yFIGlA+Dgg6o6GLscdVUi+Qy+IAEO/kvX8W2WL5nPDhdDt97hW0XbQ2w
kWfv9RbelYOkYb+CVY4R1rASun6fpgI21/hndcWuY99tnibM21YAnX7QaGaL
CZbYfVfzfmMFLO2qZ/h/vYn5Xbo2Myf3B16cE64OsTbHrssrnJrb+gPx2Xzt
dn1WmHqq0KDdrUp4mnltxLveGpMisPrNVlQCwSWPwaPvNnYoaFvaTrwKtPY6
L6tx3sV2dyc7ZoKrgOVD7WSTkx027kD2uLdUBfW8wg9P7N3HmkcqRGYMq2Hn
G0/y+esOWFJtosO0QA1skTgrKA0dsZXobxL9QTVg9sqvvIXPGTtrUzfculkD
+Txpenv7XLGYE4Nxlda1kHvGzESI2R2boV43KGyrhYx9Lnq9Sh4YtDKxfkZ1
UDH29ezQy6dY+Dvh6qSsOrgwPpW4+cQLU1bVOeXvWw/6CQYvimW8sUBGq2WP
lXpwdEpP60v3wfq63D49MG+AU9lSq3XKLzEf5w/8xiqN8CHcV0AsyR8ja/wk
X0xvhP8E5WLzHgdiEhwtoXCoCUavKHzVcQjGmrO3qcTmm2DTQ0dQoCsUY4f9
ZszSzXBtxF9vcy8MUzkSccrXqhlUraPb8xVfY69WMpbdW5qhc1bgtCMpEsvv
UWheoWsBneeSM6XoDTZYVvLJHmsBiVKelIiiaEwhrOM/i48tQCn9JiR58S1m
5nrrTO9gC6R8po7Sy4zHfG9O8xtyt0KsOtnKzjUR6z5G2XnhRSuoiX0Mov2U
hFEfCsor/9kKJ/sPnYn4loxJbXOGqS61Akv0kTmHuveYZ62UluzNNmBeGOhv
4kvF0r/8OPIxsg2Gr9ZGytxIw1qjz1Afrm+DcPX9xxNS0zFRG+Nf3CfbQUvv
n8Zz24+Yjs5wdPj9dnAqijw+PfgJczlh78SU2g6pdffnL9z5jNVS+0hTcHRA
QeQanzMpB1uZYmF0v9ABGZkatLx5XzC+1pjxZc8OSG5PF/oT+xV78C773fhM
ByQkae0o+eRhnKo97E2VJNCzKM1/1ZSPIVHr+fM7JJAt268lv1OA2TIu1pXJ
k0HaI0z/mOJP7FcX7Yvv78igI7vOZF1XhI2VhpkfJ5NhukLAW+toCcaazotl
MneCp9mPfRPnSzELZ7n1ePdOEHqfL8xc+RsLMi1q4/rSCfQ0upbVr8qwbxrn
c8LGO+HWi9f/XpiVY/QcZrYv9LtgU6zJsYzjD/Y527/nnnQ38BI/f/Dprsam
2KeCtMy7IY8rJmqhsQYTc9bCjkZ0w5Tf/YL62lrs3WnGpOHNbrhz/FvPs656
LLwmyPr6nx448Bl73vuxGWuUmuVS3ugBrzLXRtWzLRhj6KWaQ5K9IF1dVc04
2oL5GLJItYT2ApvUDdA53oY5D4csnjP5C3WpJyVEKEjY17MLyYdD/kLuMlN4
fCkJm8/Q06cu+wsJXqr6Oi/J2O0HbD+KxfpglE5JpVioC7u+E+5xYrkP+l7G
OXW/7cWibi0f4zjSD0bM+yTo/f9ibeVX+xeM+yGipZxe26MP0w44eOZTcT88
cPTxqDw1gCUy1nmzaQ6ATrLaS5EbQxim+tjEy2wARMolH/+cHsJ67SVPzLsM
gOsOour2HMa4WwPH6jMHgM3Oj23m6wgWFq19we/AIHxYbJtROjuOHa/dFloX
H4S2gOJu0so41rj16d9/6oNQ+qlgxjttAmO4yfxJ3XkQtuqk1nUJU5j34UaW
vZ5B0Ng5y519fBYTNno6brc6CNsdmaeKKOewUj/p0l6WIZBmtUmxI89h29Ov
HArVhiCfMzD22fkFzOmrbrtT2hCMrlkceCOwhNlAS8zMw2GIztF4WK+9hlEk
rxX2BA5DERff7tneNSx6H29vbcowDJBut8XZr2PVNdb8GaRhmMtauUsTt4Ed
1d9O/u/UCAS4BTzZIW5hpd+FKvSvjoD9T9pan7ItzJhwblT93gjkK4wdRXbb
mF9fmJhwwggoBro6P6vfwSZui33qoxyFv6wUF39dowCvOu2GBuIoqMTUUqwW
UgC39MO5X/KjQOZXcVrno4Tzy7+Ov/1vFAQrGZwfTlJCxpMr34xqRiHDSLF3
MYoa7oQ/KW4OHYObARfH6y7TAdVqcn9Jxhhc9O9eTW2lg1ijaorssjGo4H3q
+c2AHmp5OdSDV8ZAurPZ3N9iP0impVddMB6Hd4IsPKQ3jFCxv3FC2WEcrteG
GHJKMoHJveX9RwPG4fZ/9GoVpUwQJItp0/4ah0ehfy/7LjPDzM+25jKBCVB5
sPuwVOUA+PBvLn5RnoDCW53Xn4ccAN5n/BxJlyeg5dbT/bEjB0D7rK2Bp/cE
CNWalXaHs0FW826XyvgErPQbmnFQcID9qPhw3udJcBaKDKEX4oQBsy763zWT
wOzv2Xk6khOudvpJN4xMwssnLPJXGblAuW7cbZQ4BcjoL63qDhdQf/lwgNN3
CpjsIqbTNgjgLGGgKJw8BT+7ipRDPIgw8X6fiXTRFHiAxAtfKh5ojLJMO7s8
BTd1d83LD/JCtIcQ5nJzGg5z5nsevMoPDGvNlt7u06D5watRZoIfntz38g+J
nIaom1tVwZ4CYGHR355WNw1X5du/RF4XBKnz8Xc7lWag++7z1MsJQvCbgxBz
8sAsKPlSZhwzFwWF4OpiTclZcKyIlDAtEYVUWteRy2dn4SyH48Aw/2EI2iTJ
3PGYhZMWA2I0Q4fBsD+iMnZiFrKWtAW2XcVgKvPAylbpHGRO5DitzUiAiWgp
gb53Dt5kjwbqWUhCU/x9OLg+Bw/a4h6odklCXmhjgNSxedh9ecC4v04KPJ2D
hExj5kH/e2rN1wppYBDyEetXXoCaVx8esfvIQvXpMJmnmgvwjLCWbF8lCy+N
E5T4rixAyPxMYhSjHFCF5p+7cXcBKMqHt/Wi5ODf7owNOX4B9l5YR7/7Jg/T
vQbpTVSLcOSTpKMqnyJkbljk2LMugq7uylMpe0W4ffBBPjPvIsj5S5zbV6oI
IxcDqi+eWAQx/ddvnayVoLeweKLKZhHqZI1SI4qVoT5aTLy0fhF4VfONnONV
ICBPQfZm1yKwNS8adO6owPlmtZO7o4tQdPeI1pmbp6GCzuTC6b1FsD2/Iad4
WBV+OYfa5ssugWfDGRNyEQZZ+psZOVFL0OFVmzLBpgavDtRJJN1aBqWcFCJ5
QgMKlPi+6dgvg6+Yb7CcrCaMmN2H7cfLsHF2H+myuyaoZHHoG71ZBrbLkY2D
LGdh4oLJE+bGZSheGKdxUDsH6t6zTW4qK9Drnrae0HAB7DPhutiFFYg2oOCY
EdaC2JawkXbDFdgR+GNwyE0LFgQUN2UersA52fU4qqMXIeHXU+Gx9BVQ3D4e
4xiqDRurrE5XOFchds8zgT9YF0T4LPb2RFaB5ZMkmlvQBR2NPP8s2VXgKMtY
7ZLQw881xgn0l1ah744F7cEwPbgik1RV7L0Kzs8eajtYXoas23JEycVV+J7A
fitE8CpY9OiXUNevAeycOuhGZQQMbwftHLrWIOvKrIKChhF8vW7P2z+2BlPb
BYzPXhoBdbevWyHlOnxg+HuzjckYUjoL5R2U1mH8aMl/jwSvwViHYHpf8jpo
HvZUsrW6Aa8iswy1c9bh+elD8ZnZN0DR4BRNYdE6iE87cAVt3QDf9qsWkZ3r
0KxktCkXaQJH217yarNsQNhReTOJZlO40zwTWuC2AT/ke6Kq5W4Be6gbiPlu
gHPvXleS6S0o1KWdi4jYgIiJt5mtfreAsUng4oPsDeiK4x04PXALPjVcoREb
3YBas35BtdfmMFeb7xahtwkHWY4JOTNYgsMfH4v7Yv+A8Yu5HKOaNfCPnKVd
k/8HERH6O9yO1lBHtT/TA/2DPeuwRq80aziMghf9r/2Daa4y2VusNtBVGOmV
EvgPbOgyq2yHbUAtJzWha/4fvHrpoEEXbwtsb6u71fO3wEWvJtX+mh0UFwQ8
ra3Ygl4BgQth0XZwt1Nb+HLLFsxezSvj6bSDP4dabM2mtsDyViDVHWN7cAvt
2nDl3QbFOx4yG6b3YfDFFOdnr21Is7/dllj8AL48YLrKfWEHVu87xLbRPYL6
WA63LMMdaM19cCJC9hGMVRATz1jtgNaI8/3YG4+ASBCfvue5A2EGtAuuOY/A
57em9+9vO7DDWuP40tQRDNk9c+8I74LeZN+dI3+c4F/uIkfR1i4cyT5dFlnv
Cgf7Nk5e2b8Hx/L5dhL2XEGanuLWOOceFHXv81yXcwNLE5ZPbHJ78LnbOPxN
rBvU75PUsL69BwcijkTE2blDgoGVI2vHHrT5pYruCXtA0uO7U8eNKFBmoEvK
lQZPOF66f8PXlAI5KFtoW1B7Qem+dJp+Swrkuc5w+IygFwwEjwgGP6BAd6NS
VpyvewH/O1OjSX8KNF1Ll5Tf7AWxFboVSb8o0BBdSld+xTMIZ1ZIYBemRBzx
aR/D67xB+ErrR9ujlKgp+iWVzaw3fIl6UFAqTYnmk5auWLP6QLNAVru9CiWS
jDppNXbVB1jkjjDW6VOiCk264fk+Hwgw5Hb19qVEe9suhzV3XsDzxO3LKzOU
iGhqptB/ww/0juc7SC5TonSFHzaBz/2A//ejMItNSqTXrNhjleEHhUNTzc00
VOj5YZndxHU/WDrcpZvFT4UiVXZen4ryB4tP3y5Z61EhgTd9yzy9AaBWYH+h
M5cKvWxcuGYdGAwsWhK2rIVU6KD3quDaj2Do7R71O1tKhQ6LF2x/HwkG122T
6rx6KrTT8fNuPfYKcuDiubBRKqRftud8YfUVfo4Q09TiokYv2J9dbTsRChRt
A+iXOzUyfZv88mZJGPhMFie5P6NGHryGApQ9YbCfIp7qpB81Ms+iaf69Fgbs
x65VfIukRvcqlCveSYfDYd+Wc9k51KjgTTAVOTEctFTKdJLHqFHxvVcHT/i9
htfv35v4XdmHnPQ3J5UcIuGIo7WrvgQNOk1mL8XSY+DYqf6ricdp0GMya2hd
TQwoUBjLTCnSoKpnL7VcpmPgTNCFMU91GmT8kjlPUiYWzFKk9D+a0KBSlty6
/fmxENW+JEMVQoOElv54pja9BZoTnuPZyzTILXPW7ydnAoysvjFkLKJFWdda
Bp96J0Gymvyjv+W0SH2S9eLB2CS4GdwYkl1Li1Z3TyQX5SRBtyhNzdVO/PfK
DQXtviRoufpQJW6ZFulJxn+4dioZir9oCx6ToEOHbbRvqqwlwxs7yimdN3RI
g+lvkuaTFNAavfMk3IEeFX3dt5RdkwZnn4h80nClR+fue12ZHUmDM4d6u9ee
0iMOnU8ngSIdTmleUr4RRI/utIZ8FFRKB4kPMssiafQot8fLt/tDOjD+t3L7
Wy89Cl6OvnjMNwPqR57od57bjz6zFxywvvYRdEZCJfn5GdBWOa3799PZMFVu
4VWdxYgCnD47emTngjQbiU/9JjMqEGG4z12UDwywat67zIIis4paDemK4dzs
9XVhgwOoR/nxhJZ4GXSWWVFel2JDsy7xmd89/sA3vwozwVU2tP9jg5xHcTVY
0zgNNDayo3zh3WurpvVg+fDxN6ZYDiS/EUM9XdoEMjaSjdrmB1H8gKjBxNMW
aGKXYnQ6eQjJGBdGPxNrg5+fn7+VouZEx1Zqj9wIaQdabQPiG1pONCRnTWKP
bIfLk2IxlAycKNJ8mqIqth3GRRqiSAc4ESe/+A9R/N7JEcMV7sXPiS6u/1H5
9qsd7np/8ms/yYm4JJbUxCbbgceY5OTxgBNJ9adrKkAHWK+mr4w94kTaCU6k
Rxod8CX88aPLLpyIkEtlk43fU881CDocecqJLLuPuhL1O+DRmbv3mgM5EfGs
+ULJ7Q6ok6KwFE3jRAaj6pMaYR3wmFJCr/4vJ7Kbls/j7e+AMQ3GziODnKjr
N99M8XAH6PnN3Hw2womkTcw6TCY6QJQ1+77iNCeaDNrIClzsgHpehZB3G5zo
a5IZ5zdqEvArY42OHFyI7h9DsbwYCcrsr2jzXeBCN6Tvu1TfIYHUV/l2F20u
9KtsQrbbngRRqwdNWnW5UPmTt8fHH5Lgrgf5rq8hF6qjM5tdcifBwQCTwEVL
LnTb0YuuJYAE1h+sa/885UKXS4/2pmSQgKHX/bx9HhfiCiCpRwyTQNElgznk
BxcS1OAZqB8jgTl7Z2t2IRc69UV6H+UUCfLPnzBdLOVC9Tyvu24s4M/7Nu/g
2MCFmBOuPuzZJsHvV1Zv3ce4ULvDlhjFITK4qunMveTmRu+iabUb1ciQ0uuR
m8bDjcz2bjI90iBDk8tH12p+bmT6Io6G4xwZjnymp2Y4zI20DkGMhjYZ2ojl
XMGy3GiubYfK3hC/968oqb3W4kb/Po60kW3JMJoqFJHowY0SiZ1G60FkmPEZ
3KT24kavl74aS4SQYcki6eZtb2509vW6lVEYGSgEhCRlA7jRj8tJEYmRZCC+
ESwre8ONxHmkqSfiyaDnK7Aw+pUb+T+NKDTMIoPRf/0GWt+50R/2p+Li2WQw
U0/8+bmAG/mu2bmu5pDh7h6/r0spNxL27fn4OI8ML134+fc3ciN+QpsA9pMM
v2z4tKUmuZF02LOt6CoylGv+/RI6w41cI/QV6GvIUCsSz7U6z41+JZwUdagl
A7mfd7hojRtd0zUQON6Az9+I1113HwGd6hbFLFrJsHmitz+XjoAmuqumEtrw
9zkYp8nNSEDUvuunOtrJwNzMwzbIRkApNPd+SZPJcPQ8T/pDAQIi3TpPGdlD
BpkjPcxkYQLiP/TXN6GXDIr73j5SOUJALgeEE5P+kkG9lAj7jhGQW8kz54h+
MmgldKfcPo6Pn0Mj5zOAr49HLEODPAGZWTM52Q3i66FMJEWeIiC/7HA/qWEy
/MfZrfJPlYDUbcP0qUbIcG8lJslMjYD6TrIltuB2yyHYiZ0noEM9OakmY2SI
OErYV2BAQGqGHWdEJ8lgYnYkbdiYgGSuaKv8xC0aIa/FYkJAYrGGbtpTZMjb
uxRqaUFAWlfkSkynyeBx4ob8q/8I6FhdSPlf3Bp3b5PybxPQuZRoWuMZMrST
nvOy3Ceg4Du9aiqzZIhjCi1RfkhAJyrzFFNwW52Jt7B0IqAB80eWdHNkkHLN
pHnlSkAb9+9VWuFeyfqRnv+YgEIM10x/4f41XHFx+CkBzefYHmWZJ4MPoXWO
+TkBMV0WEr2OW1u3P0z5BQGlIXfdd7g5XswoWPoR0GJZW/oA7u7CTXJwIAG1
GIRI8yyQIXmB9nH+K3y9cg/06+K+c+Qg/3AYAdW0FuU/xS1nIvSbOZKACqd2
C9Jw/wuTtlKOJqAoB2ywFndZlQqd5VsCChOYlJrAHbBzPjM4gYDK5u3e7uG+
Im94KT8Jj48QJsm2iOe7reXCUAoBrZ5s6ObFPZTw4DVzOgERaMLShXFntj9R
VP6Ix/cN5ev/+yFDYJfFZwIa1omJ/v//T6Foj+AvBFTX3v7jAG4q5w8C+XkE
9Jpffn4XH6/249eyoR8E9Pz+CdVx3OGDJf8x/ySgoms339Xgvs7VQK9cTEDT
JYpcqbiFL3V/tPhNQMok9XceuKeej+sEVxDQlAjbqUu4v+avLP6oIqDHPpLD
XLjd5ygjh2oJiEVcOLYXX88zoqzKzI0ElBDz0vQtbobrvD1KLQRk8H1GUh93
a4j4U4t2AtrOn6Kmwx37R1EomIzH4wRhJBePp8WWesWPbny9+TjqruNesjZj
YB4kII2KgbQoPD8K4+5mKY3g8VJZi5XE/bzVVc9inIByw6+HFOL5xYa9jvox
S0D0z7OcK/H863z07uTQAgEtjC1Yq+N+l5HVy7RCQHaVUlcL8fw9fqha2OIf
AemtXyZG4fm9odXxJ2iHgGr13i/9myBDqdfQ7R8URGSjVPT7Gm69me3PTHRE
dMHkBNCMk4FbmOGKEgMRkWhYpy/j9TNgxLVqzkxEnw+l+0WPkuFBuazKDw4i
Kj4oEcGB11torHWVuSARFb15WFuK16+L8/NHHiJE9G1c134Qr2+zKwkCb44Q
UYukpNJ2H57/DCSXeikiyjLykhfE+0GNm+ZRpZNE9Pp2Wr5QFxlyDMzbL58m
IkVva2uOTjJEyz7xugdEtEiVcXyPRAbrybzOJE0iqhpK5fyD9yOqa6L+TFeI
aNcnhImhmQyTCuiEmAERLc9aPK9vJEPzAZNBNWMi0uxsY/LH+11i9euTLmZE
1NZWdWMB74enlamnBu/g8zl6oNrlDxmcuIa0fngT8X7xkd22AO8XyztrLS+J
SIGN0rr+B17/TYT3M/748+PmSsS/k4Hd9/KWUCgRSaRY+rR+JcPntdKPQXFE
xOS/e7L3IxkmOhKZLL4REQ2v6temOHw/+vIz3yOfiOjkyg+2xZLhezDZ6s1P
IrqVqfmwORqvd03WovrfRFTd9pmnIIIMQt+e2ik1ElGrTirnGXz/uR5h2sg0
TkTkljVxOXcy8OYy8NydIqLjvaOSSS5k6G/5YVMzS0SmbmFM+53w/sPKTvly
hYiQ+web8vtksA+olN+j5EFTdxQdh6zwfPOSiVnk5UEs2Sftay7h75fYO6or
yIMOprIQKrXIQFfsL/dZhAdlGxrE/sT3z6Ct4bo7EjzohWUSfxi+30Y5R+8O
K/GglJ0+kTEFMmTco7QiXeFBt7ZZupWIeH8O/JyjYMiD0ttqyn9z4vtr5o2d
8Gs86JWUqqcGB15/49+idG/xoPjw+DsKTHj/s7hTU23Hg8QunmEt3iFBs3Gb
9E8/HpTPuffYtZ8EGxofNhOLedD8YXHqgHgSePxM9K74zYNE9SyZ3WJIQCEX
yzxZwYPov6d2mkeSgE4gREiujgcx2yjnCgaTgHPT9UIFmQftmed4XvUggXyW
dszEAg96LRGYH3yNBPaHVpRlRXgRzxtM34iVBEuBc2UGR3jR4EcFcU8GEjhR
TWq7i/OiVTOe+nc0+Pjzf2+Vy/CiY/ZcT1u2OiCwpsrP4DQvCuRcfT8x3gHp
T952uhnwooBnHAFzxR0wPHrGtcyXF6Vszs6a4ue9M4mNyRKBvKjjeFDNOYsO
eGd8vSH8FS8aIdG7S5h0gFmdg7BlJC9aqXQz69btgO6cd/XU73nRNL+Q8Yhi
B7Q+3hXULOZFQYfG5JKpO6CMrbCmaoUXsX9Yetz0ph2SVWV5Gsz5kMlHBrlL
H9ugTIfBe8uKDxE4FI123rfB0M3hKfHbfIjzndrbtLg2EHkeWfjSng/tz5H2
nQpug5TKzWvoMR9y4PcSknjQBh90y6JzI/iQdVQPVbh8G6SbX+WMreJDb79U
SrF/b4WsF05sNsf40VjqlvfFzBbwNbC8SL3Kj5+3PaSGSxvhRG9Shm+DABL4
kGGQIV4D0eJvsxouCqKMWG+aCNdy8CwNjr5YIIgqu0d1OfsL4BKPwYdaUSFU
WGu9e1E9A9Tsq26w+QuhGN7MpyrXdSCR10K0flUIRa0ebh2rzCgRLU+L0rkh
jIxV9On+eueXhB4rk2gtFkaSZ5qlaL1/l1gv72upkRBBp2oPhea9qiwxy9Ro
NJESQeoK1h3M7ypLDM196uaPiaCA5tvuN75Ulpxtoq48JCuCIpoIlW1tlSVH
PlL9NFcSQeZ/L79R4q4qGbWg+LCpLoJmIkJq/yRUlVi1brmKm4qguNzR6trk
6hITfxXnX2YiqG/4pEjy1+oSffT4ke4tEWQ/+3LrXll1icbnf3ZOliKoGJNl
/DtYXSIasGnx21YE7bzfnj4sWFMyrLaufc1ZBE0Krczpx9aUWHxZEvQPEUGM
diUb/3xqS6r3P55TDRPB673oqXVEbckxC+pfS+EiyITihEXZ+9qSDfaDRiZR
IsiSe0X4YlltSYjjiWCZeBFkIyfzI3G3tuSXkutmR6YIOrsuk6TjWFdyqHin
RbhSBIWecRoMvVpfUl1L7/1rWwQ96K7jlx5oKLmnPhhag/unSH6dD+4DvwoS
SLhfR39x7MFtnHWncAF3zEhdod9gQ8l4SP2i6I4I8hiO4xoeaiihNQi9FYx7
mjWd481oQ4l6PxdmtiuCHmsIHNqeaigZM1q4eBd3g36C+pXphpKA5uprrrgt
jMXt03G3/nZzCscdKGr5Q3+mocQipedTJe5jCVbErNmGEi/bRB6ZPRHU8z1K
2HShoUR0yEX8NO6yzGa2XNzV1/WULuBW3Dy0Q7+Iz1+b8qol7n2+ZVV5uBOl
LQPe4CZfTD7GtNxQciZNJToFdyuH4o457jGBg6lfcD+ea6/+gVua7c/vOtws
KfL6liv4/Pzjmzr/b7tljgLczlTOf0dxl4sWN7GsNpQQH+tML+H+VPDa1wp3
8fKRzb29/8fXUaUQ9/8AOgOv+w==
          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.2340615072537411, 0.37409273587771136`}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwd1Xk41O/XB3BLZGmxzCCKGWQPlZRU5yglSxERQlJZIlsibfpG1oQSomix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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.3461261180190739, 0.581865061766651}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13c81P8fAHDb2SMZdyfjlBJKi0perxTJqkglFAppqJQRUSFkK6RJRWnQ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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.31353019895394485`, 0.48649847604027}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13k8VN8bB3B7hZhBUTEziqzxTSLUPKdEtkQlWVIke5uyJFuUkl3KlsgS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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.2911612749174886, 0.4343944236404684}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13k8VN8bB3BLFLLP2BJmpixZkooi8xyJUhIVpUSokLKVSLYsiciSypYt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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.2743815636982917, 0.3996519085643727}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13c8ld8fAHAjIzMU7rVHyYiMUPJ8jtCQUFkVyviSilJ2iqLsjBAyIlkl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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.2340615072537411, 0.37409273587771136`}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}]}, 1]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{214, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309805077]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 " opens as the mouse moves over it:"
}], "ExampleText",
 CellID->306328665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupView", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"BesselJ", "[", 
        RowBox[{"n", ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->469113643],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 1}, 
   InterpretationBox[
    PopupMenuBox[Dynamic[Typeset`var$$], {1->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Xk41O/XB3BLZGmxzCCKGWQPlZRU5yglSxERQlJZIlsibfpG1oQSomix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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.3461261180190739, 0.581865061766651}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 2->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c81P8fAHDb2SMZdyfjlBJKi0perxTJqkglFAppqJQRUSFkK6RJRWnQ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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.31353019895394485`, 0.48649847604027}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 3->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3B7hZhBUTEziqzxTSLUPKdEtkQlWVIke5uyJFuUkl3KlsgS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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.2911612749174886, 0.4343944236404684}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 4->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3BLFLLP2BJmpixZkooi8xyJUhIVpUSokLKVSLYsiciSypYt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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.2743815636982917, 0.3996519085643727}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}], 5->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8ld8fAHAjIzMU7rVHyYiMUPJ8jtCQUFkVyviSilJ2iqLsjBAyIlkl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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.2340615072537411, 0.37409273587771136`}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      {"ResetImageSizeLevel", 2}]},
     AutoAction->True],
    PopupView[{
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwd1Xk41O/XB3BLZGmxzCCKGWQPlZRU5yglSxERQlJZIlsibfpG1oQSomix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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.3461261180190739, 0.581865061766651}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13c81P8fAHDb2SMZdyfjlBJKi0perxTJqkglFAppqJQRUSFkK6RJRWnQ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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.31353019895394485`, 0.48649847604027}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13k8VN8bB3B7hZhBUTEziqzxTSLUPKdEtkQlWVIke5uyJFuUkl3KlsgS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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.2911612749174886, 0.4343944236404684}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13k8VN8bB3BLFLLP2BJmpixZkooi8xyJUhIVpUSokLKVSLYsiciSypYt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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.2743815636982917, 0.3996519085643727}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV13c8ld8fAHAjIzMU7rVHyYiMUPJ8jtCQUFkVyviSilJ2iqLsjBAyIlkl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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.2340615072537411, 0.37409273587771136`}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}]}, 1, AutoAction -> True]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{214, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->250625207]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->612488],

Cell["Align with text:", "ExampleText",
 CellID->610561872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PopupView", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251898344],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      PopupMenuBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        {"ResetImageSizeLevel", 2}], 2->
       TagBox["b",
        {"ResetImageSizeLevel", 2}], 3->
       TagBox["c",
        {"ResetImageSizeLevel", 2}], 4->
       TagBox["d",
        {"ResetImageSizeLevel", 2}]},
       BaselinePosition->Top],
      PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, BaselinePosition -> Top]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], "xxx", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      PopupMenuBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        {"ResetImageSizeLevel", 2}], 2->
       TagBox["b",
        {"ResetImageSizeLevel", 2}], 3->
       TagBox["c",
        {"ResetImageSizeLevel", 2}], 4->
       TagBox["d",
        {"ResetImageSizeLevel", 2}]},
       BaselinePosition->Center],
      PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, BaselinePosition -> Center]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], "xxx", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      PopupMenuBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        {"ResetImageSizeLevel", 2}], 2->
       TagBox["b",
        {"ResetImageSizeLevel", 2}], 3->
       TagBox["c",
        {"ResetImageSizeLevel", 2}], 4->
       TagBox["d",
        {"ResetImageSizeLevel", 2}]},
       BaselinePosition->Bottom],
      PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, BaselinePosition -> Bottom]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}],
  Row[{
    PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, BaselinePosition -> Top], 
    PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, BaselinePosition -> Center], 
    PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, BaselinePosition -> Bottom]}, "xxx"]]], "Output",
 ImageSize->{172, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->700463319]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->451729360],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 " is enabled:"
}], "ExampleText",
 CellID->200884514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupView", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166164811],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 1}, 
   InterpretationBox[
    PopupMenuBox[Dynamic[Typeset`var$$], {1->
     TagBox["x",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["y",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox["z",
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{42, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150476476]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38837232],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 " is disabled, but visible in its current state:"
}], "ExampleText",
 CellID->487543105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->597916526],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 1}, 
   InterpretationBox[
    PopupMenuBox[Dynamic[Typeset`var$$], {1->
     TagBox["x",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["y",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox["z",
      {"ResetImageSizeLevel", 2}]},
     Enabled->False],
    PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, Enabled -> 
     False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{42, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->378868437]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FieldSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->706794073],

Cell["Use a predefined size:", "ExampleText",
 CellID->39144163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PopupView", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
      RowBox[{"FieldSize", "\[Rule]", "s"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", 
      RowBox[{"{", 
       RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
     "}"}]}], "]"}], "//", "Column"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142180884],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->Tiny],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> Tiny]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->Small],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> Small]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->Medium],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> Medium]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->Large],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> Large]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{274, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15188461]
}, Open  ]],

Cell["Specify a specific width and height:", "ExampleText",
 CellID->151011121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PopupView", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
      RowBox[{"FieldSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4", ",", "10"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->316464102],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->{2, 1}],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> {2, 1}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->{4, 1}],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> {4, 1}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->{10, 1}],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> {10, 1}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->{2, 2}],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> {2, 2}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->{4, 2}],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> {4, 2}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->{10, 2}],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> {10, 2}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->{2, 4}],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> {2, 4}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->{4, 4}],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> {4, 4}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["b",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["c",
          {"ResetImageSizeLevel", 2}], 4->
         TagBox["d",
          {"ResetImageSizeLevel", 2}]},
         FieldSize->{10, 4}],
        PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, FieldSize -> {10, 4}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]}
   }],
  "Grid"]], "Output",
 ImageSize->{238, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->382394835]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->280855548],

Cell["Add margins within the view:", "ExampleText",
 CellID->80486826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PopupView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306973721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      PopupMenuBox[Dynamic[Typeset`var$$], {1->
       TagBox["x",
        {"ResetImageSizeLevel", 2}], 2->
       TagBox["y",
        {"ResetImageSizeLevel", 2}], 3->
       TagBox["z",
        {"ResetImageSizeLevel", 2}]},
       FrameMargins->0],
      PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
       FrameMargins -> 0]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      PopupMenuBox[Dynamic[Typeset`var$$], {1->
       TagBox["x",
        {"ResetImageSizeLevel", 2}], 2->
       TagBox["y",
        {"ResetImageSizeLevel", 2}], 3->
       TagBox["z",
        {"ResetImageSizeLevel", 2}]},
       FrameMargins->10],
      PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
       FrameMargins -> 10]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      PopupMenuBox[Dynamic[Typeset`var$$], {1->
       TagBox["x",
        {"ResetImageSizeLevel", 2}], 2->
       TagBox["y",
        {"ResetImageSizeLevel", 2}], 3->
       TagBox["z",
        {"ResetImageSizeLevel", 2}]},
       FrameMargins->20],
      PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
       FrameMargins -> 20]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{215, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122691376]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->139844393],

Cell["Add margins outside the view:", "ExampleText",
 CellID->77065691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"PopupView", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53301849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    TagBox[
     DynamicModuleBox[{Typeset`var$$ = 1}, 
      InterpretationBox[
       PopupMenuBox[Dynamic[Typeset`var$$], {1->
        TagBox["x",
         {"ResetImageSizeLevel", 2}], 2->
        TagBox["y",
         {"ResetImageSizeLevel", 2}], 3->
        TagBox["z",
         {"ResetImageSizeLevel", 2}]},
        ImageMargins->0],
       PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
        ImageMargins -> 0]],
      DynamicModuleValues:>{}],
     Setting[#, {0}]& ],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     DynamicModuleBox[{Typeset`var$$ = 1}, 
      InterpretationBox[
       PopupMenuBox[Dynamic[Typeset`var$$], {1->
        TagBox["x",
         {"ResetImageSizeLevel", 2}], 2->
        TagBox["y",
         {"ResetImageSizeLevel", 2}], 3->
        TagBox["z",
         {"ResetImageSizeLevel", 2}]},
        ImageMargins->10],
       PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
        ImageMargins -> 10]],
      DynamicModuleValues:>{}],
     Setting[#, {0}]& ],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     DynamicModuleBox[{Typeset`var$$ = 1}, 
      InterpretationBox[
       PopupMenuBox[Dynamic[Typeset`var$$], {1->
        TagBox["x",
         {"ResetImageSizeLevel", 2}], 2->
        TagBox["y",
         {"ResetImageSizeLevel", 2}], 3->
        TagBox["z",
         {"ResetImageSizeLevel", 2}]},
        ImageMargins->20],
       PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
        ImageMargins -> 20]],
      DynamicModuleValues:>{}],
     Setting[#, {0}]& ],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{245, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121000144]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->85512672],

Cell["Control the overall height and width:", "ExampleText",
 CellID->654831887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PopupView", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "40", ",", "60"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "70", ",", "90"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->667361183],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["x",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["y",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["z",
          {"ResetImageSizeLevel", 2}]},
         ImageSize->{50, 20}],
        PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
         ImageSize -> {50, 20}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["x",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["y",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["z",
          {"ResetImageSizeLevel", 2}]},
         ImageSize->{70, 20}],
        PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
         ImageSize -> {70, 20}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["x",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["y",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["z",
          {"ResetImageSizeLevel", 2}]},
         ImageSize->{90, 20}],
        PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
         ImageSize -> {90, 20}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["x",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["y",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["z",
          {"ResetImageSizeLevel", 2}]},
         ImageSize->{50, 40}],
        PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
         ImageSize -> {50, 40}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["x",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["y",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["z",
          {"ResetImageSizeLevel", 2}]},
         ImageSize->{70, 40}],
        PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
         ImageSize -> {70, 40}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["x",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["y",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["z",
          {"ResetImageSizeLevel", 2}]},
         ImageSize->{90, 40}],
        PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
         ImageSize -> {90, 40}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["x",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["y",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["z",
          {"ResetImageSizeLevel", 2}]},
         ImageSize->{50, 60}],
        PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
         ImageSize -> {50, 60}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["x",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["y",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["z",
          {"ResetImageSizeLevel", 2}]},
         ImageSize->{70, 60}],
        PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
         ImageSize -> {70, 60}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        PopupMenuBox[Dynamic[Typeset`var$$], {1->
         TagBox["x",
          {"ResetImageSizeLevel", 2}], 2->
         TagBox["y",
          {"ResetImageSizeLevel", 2}], 3->
         TagBox["z",
          {"ResetImageSizeLevel", 2}]},
         ImageSize->{90, 60}],
        PopupView[{$CellContext`x, $CellContext`y, $CellContext`z}, 1, 
         ImageSize -> {90, 60}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{230, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1643892670]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->89896536],

Cell["Use a label list and a content list: ", "ExampleText",
 CellID->161045007],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ll", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Red\>\"", ",", "\"\<Green\>\"", ",", "\"\<Blue\>\"", ",", 
     "\"\<Yellow\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cl", "=", 
   RowBox[{"{", 
    RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->36863068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupView", "[", 
    RowBox[{"ll", ",", 
     RowBox[{"Dynamic", "[", "n", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "@", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"cl", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145687099],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    PopupMenuBox[Dynamic[$CellContext`n], {1->
     TagBox["\<\"Red\"\>",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["\<\"Green\"\>",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox["\<\"Blue\"\>",
      {"ResetImageSizeLevel", 2}], 4->
     TagBox["\<\"Yellow\"\>",
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{"Red", "Green", "Blue", "Yellow"}, 
     Dynamic[$CellContext`n]]], ",", 
   DynamicBox[ToBoxes[
     Graphics[{
       Part[$CellContext`cl, $CellContext`n], 
       Disk[]}, ImageSize -> Tiny], StandardForm],
    ImageSizeCache->{100., {48., 52.}}]}], "}"}]], "Output",
 ImageSize->{191, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->123899229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58920845],

Cell["Use a function that enumerates by integer position:", "ExampleText",
 CellID->173090382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupView", "[", 
    RowBox[{
     RowBox[{"Range", "[", "5", "]"}], ",", 
     RowBox[{"Dynamic", "[", "n", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "@", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"ChebyshevT", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170239375],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    PopupMenuBox[Dynamic[$CellContext`n], {1->
     TagBox["1",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["2",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox["3",
      {"ResetImageSizeLevel", 2}], 4->
     TagBox["4",
      {"ResetImageSizeLevel", 2}], 5->
     TagBox["5",
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{1, 2, 3, 4, 5}, 
     Dynamic[$CellContext`n]]], ",", 
   DynamicBox[ToBoxes[
     Plot[
      ChebyshevT[$CellContext`n, $CellContext`x], {$CellContext`x, -2, 2}, 
      PlotRange -> 5], StandardForm],
    ImageSizeCache->{180., {53., 57.}}]}], "}"}]], "Output",
 ImageSize->{248, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33213943]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->113431088],

Cell[TextData[{
 "The setting in ",
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 " is based on position: "
}], "ExampleText",
 CellID->64735459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6868927],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    PopupMenuBox[Dynamic[$CellContext`x], {1->
     TagBox["a",
      {"ResetImageSizeLevel", 2}], 2->
     TagBox["b",
      {"ResetImageSizeLevel", 2}], 3->
     TagBox["c",
      {"ResetImageSizeLevel", 2}], 4->
     TagBox["d",
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 
     Dynamic[$CellContext`x]]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{75, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123731698]
}, Open  ]],

Cell[TextData[{
 "The setting in ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 " is based on the list value:"
}], "ExampleText",
 CellID->216220607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385170144],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Dynamic[$CellContext`y], {$CellContext`a->"a", $CellContext`b->
    "b", $CellContext`c->"c", $CellContext`d->"d"}], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{75, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31637295]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->869],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenerView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenerView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MenuView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MenuView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FlipView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FlipView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SlideView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlideView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TabView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TabView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mouseover",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mouseover"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8258]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21426],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Views",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Views"]], "Tutorials",
 CellID->14681]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->197102451],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->65598649],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->6564759],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->415634546]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PopupView - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 12.6070588}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PopupView[{expr_1, expr_2, ...}] represents an object which displays as \
a popup menu whose items are the expr_i. PopupView[{expr_1, expr_2, ...}, i] \
makes the i\\[Null]^th entry be the one currently chosen. PopupView[{expr_1, \
expr_2, ...}, i, base] displays as base if it is not being clicked.", 
    "synonyms" -> {"popup view"}, "title" -> "PopupView", "type" -> "Symbol", 
    "uri" -> "ref/PopupView"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14003, 430, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->214181473]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 677086, 12611}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2890, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3513, 89, 1574, 37, 70, "ObjectNameGrid"],
Cell[5090, 128, 2415, 77, 70, "Usage",
 CellID->21289]
}, Open  ]],
Cell[CellGroupData[{
Cell[7542, 210, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8020, 227, 660, 22, 70, "Notes",
 CellID->19207],
Cell[8683, 251, 69, 1, 70, "Notes",
 CellID->15355],
Cell[8755, 254, 2431, 66, 70, "3ColumnTableMod",
 CellID->23396],
Cell[11189, 322, 646, 22, 70, "Notes",
 CellID->29323],
Cell[11838, 346, 583, 22, 70, "Notes",
 CellID->10341],
Cell[12424, 370, 238, 8, 70, "Notes",
 CellID->17049],
Cell[12665, 380, 415, 14, 70, "Notes",
 CellID->30634],
Cell[13083, 396, 534, 17, 70, "Notes",
 CellID->26784],
Cell[13620, 415, 346, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[14003, 430, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->214181473],
Cell[CellGroupData[{
Cell[14388, 444, 148, 5, 70, "ExampleSection",
 CellID->100647878],
Cell[CellGroupData[{
Cell[14561, 453, 193, 6, 28, "Input",
 CellID->24985],
Cell[14757, 461, 676, 22, 40, "Output",
 CellID->334267349]
}, Open  ]],
Cell[15448, 486, 121, 3, 70, "ExampleDelimiter",
 CellID->32362],
Cell[CellGroupData[{
Cell[15594, 493, 399, 13, 28, "Input",
 CellID->22608],
Cell[15996, 508, 122949, 2070, 129, "Output",
 CellID->830793578]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[138994, 2584, 220, 7, 70, "ExampleSection",
 CellID->365942603],
Cell[CellGroupData[{
Cell[139239, 2595, 237, 7, 70, "ExampleSubsection",
 CellID->58372559],
Cell[139479, 2604, 74, 1, 70, "ExampleText",
 CellID->89777391],
Cell[CellGroupData[{
Cell[139578, 2609, 196, 7, 70, "Input",
 CellID->15937],
Cell[139777, 2618, 631, 21, 70, "Output",
 CellID->15393013]
}, Open  ]],
Cell[140423, 2642, 125, 3, 70, "ExampleDelimiter",
 CellID->266341019],
Cell[140551, 2647, 167, 6, 70, "ExampleText",
 CellID->45431489],
Cell[CellGroupData[{
Cell[140743, 2657, 282, 8, 70, "Input",
 CellID->190945832],
Cell[141028, 2667, 676, 21, 70, "Output",
 CellID->361024598]
}, Open  ]],
Cell[141719, 2691, 125, 3, 70, "ExampleDelimiter",
 CellID->368493193],
Cell[141847, 2696, 212, 8, 70, "ExampleText",
 CellID->405781175],
Cell[CellGroupData[{
Cell[142084, 2708, 399, 13, 70, "Input",
 CellID->234501074],
Cell[142486, 2723, 238117, 3958, 70, "Output",
 CellID->109903107]
}, Open  ]],
Cell[380618, 6684, 125, 3, 70, "ExampleDelimiter",
 CellID->631667934],
Cell[380746, 6689, 251, 8, 70, "ExampleText",
 CellID->65337598],
Cell[CellGroupData[{
Cell[381022, 6701, 361, 12, 70, "Input",
 CellID->47389411],
Cell[381386, 6715, 424, 15, 73, "Output",
 CellID->766596775]
}, Open  ]],
Cell[CellGroupData[{
Cell[381847, 6735, 214, 7, 70, "Input",
 CellID->137908413],
Cell[382064, 6744, 2056, 69, 70, "Output",
 CellID->172881559]
}, Open  ]],
Cell[384135, 6816, 453, 17, 70, "ExampleText",
 CellID->173577523],
Cell[CellGroupData[{
Cell[384613, 6837, 347, 11, 70, "Input",
 CellID->908772701],
Cell[384963, 6850, 2162, 71, 70, "Output",
 CellID->622589875]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[387174, 6927, 237, 7, 70, "ExampleSubsection",
 CellID->11022400],
Cell[387414, 6936, 78, 1, 70, "ExampleText",
 CellID->670411330],
Cell[CellGroupData[{
Cell[387517, 6941, 200, 7, 70, "Input",
 CellID->362698449],
Cell[387720, 6950, 632, 21, 70, "Output",
 CellID->158370511]
}, Open  ]],
Cell[388367, 6974, 124, 3, 70, "ExampleDelimiter",
 CellID->46312152],
Cell[388494, 6979, 76, 1, 70, "ExampleText",
 CellID->203310167],
Cell[CellGroupData[{
Cell[388595, 6984, 321, 10, 70, "Input",
 CellID->27573176],
Cell[388919, 6996, 691, 22, 70, "Output",
 CellID->143508291]
}, Open  ]],
Cell[389625, 7021, 125, 3, 70, "ExampleDelimiter",
 CellID->180077237],
Cell[389753, 7026, 207, 8, 70, "ExampleText",
 CellID->223978197],
Cell[CellGroupData[{
Cell[389985, 7038, 446, 14, 70, "Input",
 CellID->573400473],
Cell[390434, 7054, 651, 21, 70, "Output",
 CellID->33428424]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[391146, 7082, 222, 7, 70, "ExampleSection",
 CellID->322777120],
Cell[CellGroupData[{
Cell[391393, 7093, 231, 7, 70, "ExampleSubsection",
 CellID->110368608],
Cell[391627, 7102, 105, 2, 70, "ExampleText",
 CellID->214704586],
Cell[CellGroupData[{
Cell[391757, 7108, 402, 13, 70, "Input",
 CellID->24121998],
Cell[392162, 7123, 122993, 2070, 70, "Output",
 CellID->309805077]
}, Open  ]],
Cell[515170, 9196, 359, 13, 70, "ExampleText",
 CellID->306328665],
Cell[CellGroupData[{
Cell[515554, 9213, 478, 15, 70, "Input",
 CellID->469113643],
Cell[516035, 9230, 123036, 2071, 70, "Output",
 CellID->250625207]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[639120, 11307, 234, 7, 70, "ExampleSubsection",
 CellID->612488],
Cell[639357, 11316, 59, 1, 70, "ExampleText",
 CellID->610561872],
Cell[CellGroupData[{
Cell[639441, 11321, 519, 16, 70, "Input",
 CellID->251898344],
Cell[639963, 11339, 2255, 65, 70, "Output",
 CellID->700463319]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[642267, 11410, 228, 7, 70, "ExampleSubsection",
 CellID->451729360],
Cell[642498, 11419, 208, 8, 70, "ExampleText",
 CellID->200884514],
Cell[CellGroupData[{
Cell[642731, 11431, 162, 5, 70, "Input",
 CellID->166164811],
Cell[642896, 11438, 558, 18, 70, "Output",
 CellID->150476476]
}, Open  ]],
Cell[643469, 11459, 124, 3, 70, "ExampleDelimiter",
 CellID->38837232],
Cell[643596, 11464, 471, 17, 70, "ExampleText",
 CellID->487543105],
Cell[CellGroupData[{
Cell[644092, 11485, 227, 7, 70, "Input",
 CellID->597916526],
Cell[644322, 11494, 603, 20, 70, "Output",
 CellID->378868437]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[644974, 11520, 230, 7, 70, "ExampleSubsection",
 CellID->706794073],
Cell[645207, 11529, 64, 1, 70, "ExampleText",
 CellID->39144163],
Cell[CellGroupData[{
Cell[645296, 11534, 482, 15, 70, "Input",
 CellID->142180884],
Cell[645781, 11551, 2606, 81, 70, "Output",
 CellID->15188461]
}, Open  ]],
Cell[648402, 11635, 79, 1, 70, "ExampleText",
 CellID->151011121],
Cell[CellGroupData[{
Cell[648506, 11640, 639, 21, 70, "Input",
 CellID->316464102],
Cell[649148, 11663, 5507, 164, 70, "Output",
 CellID->382394835]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[654704, 11833, 233, 7, 70, "ExampleSubsection",
 CellID->280855548],
Cell[654940, 11842, 70, 1, 70, "ExampleText",
 CellID->80486826],
Cell[CellGroupData[{
Cell[655035, 11847, 406, 13, 70, "Input",
 CellID->306973721],
Cell[655444, 11862, 1649, 52, 70, "Output",
 CellID->122691376]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[657142, 11920, 233, 7, 70, "ExampleSubsection",
 CellID->139844393],
Cell[657378, 11929, 71, 1, 70, "ExampleText",
 CellID->77065691],
Cell[CellGroupData[{
Cell[657474, 11934, 444, 14, 70, "Input",
 CellID->53301849],
Cell[657921, 11950, 1811, 58, 70, "Output",
 CellID->121000144]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[659781, 12014, 229, 7, 70, "ExampleSubsection",
 CellID->85512672],
Cell[660013, 12023, 80, 1, 70, "ExampleText",
 CellID->654831887],
Cell[CellGroupData[{
Cell[660118, 12028, 634, 21, 70, "Input",
 CellID->667361183],
Cell[660755, 12051, 5010, 149, 70, "Output",
 CellID->1643892670]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[665826, 12207, 226, 7, 70, "ExampleSection",
 CellID->89896536],
Cell[666055, 12216, 80, 1, 70, "ExampleText",
 CellID->161045007],
Cell[666138, 12219, 393, 13, 70, "Input",
 CellID->36863068],
Cell[CellGroupData[{
Cell[666556, 12236, 504, 16, 70, "Input",
 CellID->145687099],
Cell[667063, 12254, 795, 24, 70, "Output",
 CellID->123899229]
}, Open  ]],
Cell[667873, 12281, 124, 3, 70, "ExampleDelimiter",
 CellID->58920845],
Cell[668000, 12286, 94, 1, 70, "ExampleText",
 CellID->173090382],
Cell[CellGroupData[{
Cell[668119, 12291, 547, 17, 70, "Input",
 CellID->170239375],
Cell[668669, 12310, 796, 26, 70, "Output",
 CellID->33213943]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[669514, 12342, 237, 7, 70, "ExampleSection",
 CellID->113431088],
Cell[669754, 12351, 221, 8, 70, "ExampleText",
 CellID->64735459],
Cell[CellGroupData[{
Cell[670000, 12363, 320, 10, 70, "Input",
 CellID->6868927],
Cell[670323, 12375, 691, 22, 70, "Output",
 CellID->123731698]
}, Open  ]],
Cell[671029, 12400, 227, 8, 70, "ExampleText",
 CellID->216220607],
Cell[CellGroupData[{
Cell[671281, 12412, 322, 10, 70, "Input",
 CellID->385170144],
Cell[671606, 12424, 417, 11, 70, "Output",
 CellID->31637295]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[672084, 12442, 309, 9, 70, "SeeAlsoSection",
 CellID->869],
Cell[672396, 12453, 1926, 71, 70, "SeeAlso",
 CellID->8258]
}, Open  ]],
Cell[CellGroupData[{
Cell[674359, 12529, 314, 9, 70, "TutorialsSection",
 CellID->21426],
Cell[674676, 12540, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[674838, 12545, 121, 3, 70, "Tutorials",
 CellID->14681]
}, Open  ]],
Cell[CellGroupData[{
Cell[674996, 12553, 319, 9, 70, "MoreAboutSection",
 CellID->197102451],
Cell[675318, 12564, 152, 3, 70, "MoreAbout",
 CellID->65598649],
Cell[675473, 12569, 152, 3, 70, "MoreAbout",
 CellID->6564759],
Cell[675628, 12574, 172, 3, 70, "MoreAbout",
 CellID->415634546]
}, Open  ]],
Cell[675815, 12580, 27, 0, 70, "History"],
Cell[675845, 12582, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

