(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39381,       1453]
NotebookOptionsPosition[     32302,       1206]
NotebookOutlinePosition[     33777,       1245]
CellTagsIndexPosition[     33691,       1240]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Testing and Searching List Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TestingAndSearchingListElements"], 
          "Levels in Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/LevelsInExpressions"], 
          "Applying Functions to Parts of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"], 
          "Finding Expressions That Match a Pattern" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingExpressionsThatMatchAPattern"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Testing and Searching List Elements\"\>", 
       2->"\<\"Levels in Expressions\"\>", 
       3->"\<\"Applying Functions to Parts of Expressions\"\>", 
       4->"\<\"Finding Expressions That Match a Pattern\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cases" :> Documentation`HelpLookup["paclet:ref/Cases"], 
          "Count" :> Documentation`HelpLookup["paclet:ref/Count"], 
          "StringPosition" :> 
          Documentation`HelpLookup["paclet:ref/StringPosition"], 
          "LengthWhile" :> Documentation`HelpLookup["paclet:ref/LengthWhile"],
           "Ordering" :> Documentation`HelpLookup["paclet:ref/Ordering"], 
          "SparseArray" :> Documentation`HelpLookup["paclet:ref/SparseArray"],
           "ReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceList"], "Insert" :> 
          Documentation`HelpLookup["paclet:ref/Insert"], "Delete" :> 
          Documentation`HelpLookup["paclet:ref/Delete"], "ArrayRules" :> 
          Documentation`HelpLookup["paclet:ref/ArrayRules"], "Extract" :> 
          Documentation`HelpLookup["paclet:ref/Extract"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cases\"\>", 2->"\<\"Count\"\>", 
       3->"\<\"StringPosition\"\>", 4->"\<\"LengthWhile\"\>", 
       5->"\<\"Ordering\"\>", 6->"\<\"SparseArray\"\>", 
       7->"\<\"ReplaceList\"\>", 8->"\<\"Insert\"\>", 9->"\<\"Delete\"\>", 
       10->"\<\"ArrayRules\"\>", 11->"\<\"Extract\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], 
          "Pattern Matching Functions" :> 
          Documentation`HelpLookup["paclet:guide/PatternMatchingFunctions"], 
          "Rules & Patterns" :> 
          Documentation`HelpLookup["paclet:guide/RulesAndPatterns"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Discrete & Integer Data\"\>", 
       2->"\<\"Elements of Lists\"\>", 3->"\<\"Expressions\"\>", 
       4->"\<\"Handling Arrays of Data\"\>", 5->"\<\"Language Overview\"\>", 
       6->"\<\"List Manipulation\"\>", 7->"\<\"Parts of Expressions\"\>", 
       8->"\<\"Parts of Matrices\"\>", 
       9->"\<\"Pattern Matching Functions\"\>", 
       10->"\<\"Rules & Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Position", "ObjectName",
 CellID->13627],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Position",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Position"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["pattern", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the positions at which objects matching \
",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"],
     " appear in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Position",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Position"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["pattern", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds only objects that appear on levels specified by ",
     
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Position",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Position"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["pattern", "TI"], ",", 
        StyleBox["levelspec", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the positions of the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " objects found. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->8984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["pattern", "TI"]}], "]"}]], "InlineFormula"],
 " tests all the subparts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " in turn to try and find ones that match ",
 Cell[BoxData[
  StyleBox["pattern", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22755],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 " returns a list of positions in a form suitable for use in ",
 Cell[BoxData[
  ButtonBox["Extract",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extract"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 ". The form is different from the one used in ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30095],

Cell[TextData[{
 "The default level specification for ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"]}], "}"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28885],

Cell[TextData[{
 "A part specification ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " returned by ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 " represents the whole of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10449],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["pattern", "TI"], ",", 
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{
     ButtonBox["Heads",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Heads"], "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}]}], "]"}]], "InlineFormula"],
 " finds positions only of objects that appear as complete elements of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27238],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->29755],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->2415],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->5741],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7056],

Cell[TextData[{
 "Level ",
 Cell[BoxData["0"], "InlineFormula"],
 " corresponds to the whole expression."
}], "Notes",
 CellID->4609],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 " includes heads of expressions, and their parts. "
}], "Notes",
 CellID->16019],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 " traverses expressions in depth\[Hyphen]first order, yielding lists of \
indices in lexicographic order."
}], "Notes",
 CellID->25827]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->624880677],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->151498486],

Cell[TextData[{
 "Find the positions at which ",
 Cell[BoxData["b"], "InlineFormula"],
 " occurs:"
}], "ExampleText",
 CellID->13991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "a", ",", "a", ",", "b", ",", "c", ",", "b"}],
     "}"}], ",", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28301],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", "7", "}"}]}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12413]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "a"}], "}"}]}], "}"}], ",", "b"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17781],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28451]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3469],

Cell[TextData[{
 "Find all positions at which ",
 Cell[BoxData["x"], "InlineFormula"],
 " to any power appears:"
}], "ExampleText",
 CellID->8286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"x", "^", "2"}]}], ",", "5", ",", 
     RowBox[{"x", "^", "4"}], ",", 
     RowBox[{"a", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], "}"}], ",", 
   RowBox[{"x", "^", "_"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "1", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20142]
}, Open  ]],

Cell["Find only those down to level 2:", "ExampleText",
 CellID->14541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"x", "^", "2"}]}], ",", "5", ",", 
     RowBox[{"x", "^", "4"}], ",", 
     RowBox[{"a", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], "}"}], ",", 
   RowBox[{"x", "^", "_"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26435]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14799],

Cell[TextData[{
 "Find the positions of the first 2 ",
 Cell[BoxData["b"], "InlineFormula"],
 "'s that appear on level 1:"
}], "ExampleText",
 CellID->15961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "a", ",", "a", ",", "b", ",", "c", ",", "b", ",", "a",
      ",", "b"}], "}"}], ",", "b", ",", "1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8380],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "5", "}"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21374]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28584],

Cell["Depth-first traversal gives longer lists of indices first:", \
"ExampleText",
 CellID->30538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"g", "[", 
     RowBox[{"h", "[", "x", "]"}], "]"}], "]"}], ",", "_", ",", "Infinity"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8113],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11656]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24593],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 " works with any head, not just ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->426787265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "b", ",", "a"}], "]"}], ",", "b"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343641540],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->298636645]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8373],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Heads",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", "Power"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7253]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", "Power", ",", 
   RowBox[{"Heads", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14399],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12623]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20036],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Extract",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extract"]], "InlineFormula"],
 " to extract parts based on results from ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20600],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ",", "5", ",", 
     SuperscriptBox["x", "4"], ",", 
     RowBox[{"a", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}], ")"}], "2"]}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->28366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"u", ",", 
   RowBox[{"x", "^", "_"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "1", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7546]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{"u", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6164],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   SuperscriptBox["x", "4"], ",", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7303]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "0.05"}], "]"}], ",", "0.1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23952],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25809]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5096],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Count",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Count"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LengthWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LengthWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Insert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Insert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Delete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Delete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayRules"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Extract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extract"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30498]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6862],

Cell[TextData[ButtonBox["Testing and Searching List Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TestingAndSearchingListElements"]], "Tutorials",\

 CellID->14248],

Cell[TextData[ButtonBox["Levels in Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LevelsInExpressions"]], "Tutorials",
 CellID->14779],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "Tutorials",
 CellID->11343],

Cell[TextData[ButtonBox["Finding Expressions That Match a Pattern",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FindingExpressionsThatMatchAPattern"]], "Tutorials",
 CellID->8731]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->132679413],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->292180252],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->41196023],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->252769054],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->420233436],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->32235619],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->102235399],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->64633750],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->310589521],

Cell[TextData[ButtonBox["Pattern Matching Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PatternMatchingFunctions"]], "MoreAbout",
 CellID->22291304],

Cell[TextData[ButtonBox["Rules & Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "MoreAbout",
 CellID->775849861]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Position",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Position"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Position"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Position - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 19.7322412}", "context" -> "System`", 
    "keywords" -> {"indices", "levels", "parts", "search", "where"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Position[expr, pattern] gives a list of the positions at which objects \
matching pattern appear in expr. Position[expr, pattern, levelspec] finds \
only objects that appear on levels specified by levelspec. Position[expr, \
pattern, levelspec, n] gives the positions of the first n objects found. ", 
    "synonyms" -> {}, "title" -> "Position", "type" -> "Symbol", "uri" -> 
    "ref/Position"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13976, 452, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->624880677]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33547, 1233}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4730, 96, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5353, 123, 46, 1, 70, "ObjectName",
 CellID->13627],
Cell[5402, 126, 1762, 56, 70, "Usage",
 CellID->8984]
}, Open  ]],
Cell[CellGroupData[{
Cell[7201, 187, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7679, 204, 476, 17, 70, "Notes",
 CellID->22755],
Cell[8158, 223, 766, 27, 70, "Notes",
 CellID->30095],
Cell[8927, 252, 619, 24, 70, "Notes",
 CellID->28885],
Cell[9549, 278, 359, 14, 70, "Notes",
 CellID->10449],
Cell[9911, 294, 648, 22, 70, "Notes",
 CellID->27238],
Cell[10562, 318, 203, 7, 70, "Notes",
 CellID->29755],
Cell[10768, 327, 1663, 55, 70, "2ColumnTableMod",
 CellID->2415],
Cell[12434, 384, 302, 12, 70, "Notes",
 CellID->5741],
Cell[12739, 398, 311, 13, 70, "Notes",
 CellID->7056],
Cell[13053, 413, 133, 5, 70, "Notes",
 CellID->4609],
Cell[13189, 420, 476, 17, 70, "Notes",
 CellID->16019],
Cell[13668, 439, 271, 8, 70, "Notes",
 CellID->25827]
}, Closed]],
Cell[CellGroupData[{
Cell[13976, 452, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->624880677],
Cell[CellGroupData[{
Cell[14361, 466, 148, 5, 70, "ExampleSection",
 CellID->151498486],
Cell[14512, 473, 133, 5, 70, "ExampleText",
 CellID->13991],
Cell[CellGroupData[{
Cell[14670, 482, 227, 7, 28, "Input",
 CellID->28301],
Cell[14900, 491, 282, 10, 36, "Output",
 CellID->12413]
}, Open  ]],
Cell[CellGroupData[{
Cell[15219, 506, 374, 13, 28, "Input",
 CellID->17781],
Cell[15596, 521, 357, 13, 36, "Output",
 CellID->28451]
}, Open  ]],
Cell[15968, 537, 120, 3, 70, "ExampleDelimiter",
 CellID->3469],
Cell[16091, 542, 146, 5, 70, "ExampleText",
 CellID->8286],
Cell[CellGroupData[{
Cell[16262, 551, 434, 15, 70, "Input",
 CellID->7277],
Cell[16699, 568, 352, 12, 36, "Output",
 CellID->20142]
}, Open  ]],
Cell[17066, 583, 71, 1, 70, "ExampleText",
 CellID->14541],
Cell[CellGroupData[{
Cell[17162, 588, 445, 15, 70, "Input",
 CellID->23355],
Cell[17610, 605, 272, 10, 36, "Output",
 CellID->26435]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17931, 621, 216, 7, 70, "ExampleSection",
 CellID->14799],
Cell[18150, 630, 157, 5, 70, "ExampleText",
 CellID->15961],
Cell[CellGroupData[{
Cell[18332, 639, 272, 8, 70, "Input",
 CellID->8380],
Cell[18607, 649, 247, 9, 36, "Output",
 CellID->21374]
}, Open  ]],
Cell[18869, 661, 121, 3, 70, "ExampleDelimiter",
 CellID->28584],
Cell[18993, 666, 99, 2, 70, "ExampleText",
 CellID->30538],
Cell[CellGroupData[{
Cell[19117, 672, 232, 8, 70, "Input",
 CellID->8113],
Cell[19352, 682, 504, 17, 36, "Output",
 CellID->11656]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19905, 705, 239, 7, 70, "ExampleSection",
 CellID->24593],
Cell[20147, 714, 325, 12, 70, "ExampleText",
 CellID->426787265],
Cell[CellGroupData[{
Cell[20497, 730, 204, 7, 70, "Input",
 CellID->343641540],
Cell[20704, 739, 251, 9, 36, "Output",
 CellID->298636645]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21004, 754, 217, 7, 70, "ExampleSection",
 CellID->8373],
Cell[CellGroupData[{
Cell[21246, 765, 222, 7, 70, "ExampleSubsection",
 CellID->20671],
Cell[CellGroupData[{
Cell[21493, 776, 201, 7, 70, "Input",
 CellID->24252],
Cell[21697, 785, 297, 11, 36, "Output",
 CellID->7253]
}, Open  ]],
Cell[CellGroupData[{
Cell[22031, 801, 244, 8, 70, "Input",
 CellID->14399],
Cell[22278, 811, 171, 6, 36, "Output",
 CellID->12623]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[22510, 824, 233, 7, 70, "ExampleSection",
 CellID->20036],
Cell[22746, 833, 345, 13, 70, "ExampleText",
 CellID->20600],
Cell[23094, 848, 400, 15, 70, "Input",
 CellID->28366],
Cell[CellGroupData[{
Cell[23519, 867, 147, 5, 70, "Input",
 CellID->17192],
Cell[23669, 874, 351, 12, 36, "Output",
 CellID->7546]
}, Open  ]],
Cell[CellGroupData[{
Cell[24057, 891, 121, 4, 70, "Input",
 CellID->6164],
Cell[24181, 897, 283, 10, 39, "Output",
 CellID->7303]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24513, 913, 226, 7, 70, "ExampleSection",
 CellID->16281],
Cell[CellGroupData[{
Cell[24764, 924, 220, 8, 70, "Input",
 CellID->23952],
Cell[24987, 934, 171, 6, 36, "Output",
 CellID->25809]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25219, 947, 310, 9, 70, "SeeAlsoSection",
 CellID->5096],
Cell[25532, 958, 2668, 98, 70, "SeeAlso",
 CellID->30498]
}, Open  ]],
Cell[CellGroupData[{
Cell[28237, 1061, 313, 9, 70, "TutorialsSection",
 CellID->6862],
Cell[28553, 1072, 179, 4, 70, "Tutorials",
 CellID->14248],
Cell[28735, 1078, 151, 3, 70, "Tutorials",
 CellID->14779],
Cell[28889, 1083, 193, 4, 70, "Tutorials",
 CellID->11343],
Cell[29085, 1089, 188, 4, 70, "Tutorials",
 CellID->8731]
}, Open  ]],
Cell[CellGroupData[{
Cell[29310, 1098, 319, 9, 70, "MoreAboutSection",
 CellID->132679413],
Cell[29632, 1109, 157, 3, 70, "MoreAbout",
 CellID->292180252],
Cell[29792, 1114, 143, 3, 70, "MoreAbout",
 CellID->41196023],
Cell[29938, 1119, 134, 3, 70, "MoreAbout",
 CellID->252769054],
Cell[30075, 1124, 155, 3, 70, "MoreAbout",
 CellID->420233436],
Cell[30233, 1129, 144, 3, 70, "MoreAbout",
 CellID->32235619],
Cell[30380, 1134, 145, 3, 70, "MoreAbout",
 CellID->102235399],
Cell[30528, 1139, 149, 3, 70, "MoreAbout",
 CellID->64633750],
Cell[30680, 1144, 144, 3, 70, "MoreAbout",
 CellID->310589521],
Cell[30827, 1149, 161, 3, 70, "MoreAbout",
 CellID->22291304],
Cell[30991, 1154, 144, 3, 70, "MoreAbout",
 CellID->775849861]
}, Open  ]],
Cell[CellGroupData[{
Cell[31172, 1162, 305, 8, 70, "RelatedLinksSection"],
Cell[31480, 1172, 361, 12, 70, "RelatedLinks"],
Cell[31844, 1186, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[32245, 1202, 27, 0, 70, "History"],
Cell[32275, 1204, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

