(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11001,        395]
NotebookOptionsPosition[      8467,        310]
NotebookOutlinePosition[      9656,        345]
CellTagsIndexPosition[      9572,        340]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Negative" :> Documentation`HelpLookup["paclet:ref/Negative"], 
          "NonNegative" :> Documentation`HelpLookup["paclet:ref/NonNegative"],
           "Sign" :> Documentation`HelpLookup["paclet:ref/Sign"], "Greater" :> 
          Documentation`HelpLookup["paclet:ref/Greater"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/Assumptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Negative\"\>", 
       2->"\<\"NonNegative\"\>", 3->"\<\"Sign\"\>", 4->"\<\"Greater\"\>", 
       5->"\<\"Simplify\"\>", 6->"\<\"Assumptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Positive", "ObjectName",
 CellID->12716],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Positive",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Positive"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is a positive number. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->838]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Positive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Positive"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is manifestly a negative numerical quantity, a complex numerical quantity, \
or zero. Otherwise, it remains unevaluated. "
}], "Notes",
 CellID->20998]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->329909054],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->105922236],

Cell["Evaluate different types of numbers:", "ExampleText",
 CellID->115213883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Positive", "[", 
  RowBox[{"{", 
   RowBox[{"1.6", ",", 
    RowBox[{"3", "/", "4"}], ",", "Pi", ",", "0", ",", 
    RowBox[{"-", "5"}], ",", 
    RowBox[{"1", "+", "I"}], ",", 
    RowBox[{"Sin", "[", 
     RowBox[{"10", "^", "5"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187009233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "False", ",", "False", ",", "False", 
   ",", "True"}], "}"}]], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->723958118]
}, Open  ]],

Cell[TextData[{
 "Quantities that are not ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " remain unevaluated:"
}], "ExampleText",
 CellID->236549865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Positive", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"Sin", "[", "y", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->238276832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Positive", "[", "x", "]"}], ",", 
   RowBox[{"Positive", "[", 
    RowBox[{"Sin", "[", "y", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22157889]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31468],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Negative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Negative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonNegative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonNegative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Greater",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Greater"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17629]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->39938962]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Positive - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 22.2010544}", "context" -> "System`", 
    "keywords" -> {"positive number"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Positive[x] gives True if x is a positive number. ", "synonyms" -> {}, 
    "title" -> "Positive", "type" -> "Symbol", "uri" -> "ref/Positive"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4080, 134, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->329909054]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9429, 333}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1642, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2265, 63, 46, 1, 70, "ObjectName",
 CellID->12716],
Cell[2314, 66, 683, 23, 70, "Usage",
 CellID->838]
}, Open  ]],
Cell[CellGroupData[{
Cell[3034, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3512, 111, 531, 18, 70, "Notes",
 CellID->20998]
}, Closed]],
Cell[CellGroupData[{
Cell[4080, 134, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->329909054],
Cell[CellGroupData[{
Cell[4465, 148, 148, 5, 70, "ExampleSection",
 CellID->105922236],
Cell[4616, 155, 79, 1, 70, "ExampleText",
 CellID->115213883],
Cell[CellGroupData[{
Cell[4720, 160, 333, 10, 28, "Input",
 CellID->187009233],
Cell[5056, 172, 285, 9, 36, "Output",
 CellID->723958118]
}, Open  ]],
Cell[5356, 184, 226, 8, 70, "ExampleText",
 CellID->236549865],
Cell[CellGroupData[{
Cell[5607, 196, 183, 6, 28, "Input",
 CellID->238276832],
Cell[5793, 204, 307, 10, 36, "Output",
 CellID->22157889]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6161, 221, 311, 9, 70, "SeeAlsoSection",
 CellID->31468],
Cell[6475, 232, 1433, 53, 70, "SeeAlso",
 CellID->17629]
}, Open  ]],
Cell[CellGroupData[{
Cell[7945, 290, 299, 8, 70, "MoreAboutSection"],
Cell[8247, 300, 148, 3, 70, "MoreAbout",
 CellID->39938962]
}, Open  ]],
Cell[8410, 306, 27, 0, 70, "History"],
Cell[8440, 308, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

