(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64567,       2126]
NotebookOptionsPosition[     54100,       1757]
NotebookOutlinePosition[     55577,       1799]
CellTagsIndexPosition[     55491,       1794]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HermitianMatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/HermitianMatrixQ"], 
          "Eigenvalues" :> Documentation`HelpLookup["paclet:ref/Eigenvalues"],
           "MatrixQ" :> Documentation`HelpLookup["paclet:ref/MatrixQ"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"HermitianMatrixQ\"\>", 
       2->"\<\"Eigenvalues\"\>", 3->"\<\"MatrixQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "New in 6.0: Matrix & Linear Algebra Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"New in 6.0: Matrix & Linear Algebra Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PositiveDefiniteMatrixQ", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PositiveDefiniteMatrixQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PositiveDefiniteMatrixQ"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]tests whether ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " is a positive definite matrix."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PositiveDefiniteMatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PositiveDefiniteMatrixQ"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is explicitly positive definite, and gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if it is a matrix that is not positive definite. "
}], "Notes",
 CellID->237854512],

Cell[TextData[{
 "A Hermitian matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is considered positive definite if and only if all its eigenvalues are \
positive."
}], "Notes",
 CellID->713779358],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PositiveDefiniteMatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PositiveDefiniteMatrixQ"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects."
}], "Notes",
 CellID->78903241],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PositiveDefiniteMatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PositiveDefiniteMatrixQ"]], "InlineFormula"],
 " works for symbolic as well as numerical matrices."
}], "Notes",
 CellID->162284008]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->198804769],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->58406821],

Cell["Test if a matrix is explicitly positive definite:", "ExampleText",
 CellID->16203226],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170908600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->285981040],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->773327986]
}, Open  ]],

Cell[TextData[{
 "This means that the quadratic form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", ".", "A", ".", "x"}], ">", "0"}], TraditionalForm]], 
  "InlineMath"],
 "for all vectors ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[NotEqual]", "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->506309372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"]}], "}"}], ".", "m", ".", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "2"], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->34561757],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->48490208]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Test a matrix of machine numbers:", "ExampleText",
 CellID->203013878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.", ",", "2."}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3.", ",", "4."}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563010078],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75322780]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->48664461],

Cell["Test a matrix of complex numbers:", "ExampleText",
 CellID->25205222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"2", "I"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "I"}], ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157202116],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274613748]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2905990],

Cell["Test a matrix of arbitrary-precision numbers:", "ExampleText",
 CellID->289725939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", " ", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pi", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "E"}], "}"}]}], "}"}], ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121734627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.14159265358979323846264338358607339165`20.", ",", "1.`20."}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`20."}], ",", 
     "2.71828182845904523536028747135266249776`20."}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{345, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21922976]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11287139],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->65522332]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114577149],

Cell["Test a matrix of exact numeric quantities:", "ExampleText",
 CellID->315609875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Pi", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "E"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44838534],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380787608]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88221870],

Cell["Test a sparse matrix:", "ExampleText",
 CellID->610540136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "2."}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       RowBox[{"-", "1."}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1000", ",", " ", "1000"}], "}"}], ",", "0."}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->150539512],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2998", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2998, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1000", ",", "1000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182269728]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20730237],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->239189300]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell["Test a matrix with symbolic entries:", "ExampleText",
 CellID->682441741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Conjugate", "[", "a", "]"}]}], ",", "1"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->558705710],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18451619]
}, Open  ]],

Cell["\<\
In general, the test will be inconclusive with symbolic entries:\
\>", "ExampleText",
 CellID->145816961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "=", 
  RowBox[{"PositiveDefiniteMatrixQ", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "a"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387407636],

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "a"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7578986]
}, Open  ]],

Cell[TextData[{
 "Depending on the value of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ", either ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " is possible:"
}], "ExampleText",
 CellID->2899607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", " ", "/.", " ", 
  RowBox[{"a", "\[Rule]", "1"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->49600401],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->35680167]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", " ", "/.", " ", 
  RowBox[{"a", "\[Rule]", 
   RowBox[{"-", "1"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->311398035],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->60159529]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["\<\
A Hermitian matrix is positive definite if and only if its eigenvalues are \
all positive:\
\>", "ExampleText",
 CellID->773502778],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "I"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "I"}], ",", "2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19131699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermitianMatrixQ", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->611526703],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->137635431]
}, Open  ]],

Cell[TextData[{
 "The eigenvalues of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " are all positive:"
}], "ExampleText",
 CellID->388812697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "m", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->64030269],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      SqrtBox["5"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "-", 
      SqrtBox["5"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{173, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->47333124]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Positive", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14523312],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->518859684]
}, Open  ]],

Cell[TextData[{
 "So ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " must be positive definite:"
}], "ExampleText",
 CellID->216962502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", "m", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->640458354],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->4872810]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100889476],

Cell[TextData[{
 "A matrix ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is positive definite if and only if its Hermitian part, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", 
      SuperscriptBox["m", "\[ConjugateTranspose]"]}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 ", is positive definite:"
}], "ExampleText",
 CellID->802181500],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"2", "I"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "I"}], ",", 
       RowBox[{"4", " ", "+", " ", "I"}]}], "}"}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->44867690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mh", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"m", "+", 
     RowBox[{"ConjugateTranspose", "[", "m", "]"}]}], ")"}], "/", 
   "2"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->321965365],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox[
      RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], ",", "4"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{146, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126596720]
}, Open  ]],

Cell["\<\
The Hermitian part has positive eigenvalues so is positive definite:\
\>", "ExampleText",
 CellID->46798861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Eigenvalues", "[", "mh", "]"}], ",", 
   RowBox[{"Map", "[", 
    RowBox[{"Positive", ",", 
     RowBox[{"Eigenvalues", "[", "mh", "]"}]}], "]"}], ",", 
   RowBox[{"PositiveDefiniteMatrixQ", "[", "mh", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->292154976],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"3", " ", 
         SqrtBox["2"]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "-", 
        RowBox[{"3", " ", 
         SqrtBox["2"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", "True"}], "}"}]], "Output",
 ImageSize->{338, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->86581234]
}, Open  ]],

Cell[TextData[{
 "Therefore, ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " must be positive definite:"
}], "ExampleText",
 CellID->789812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->551609085],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->195728498]
}, Open  ]],

Cell[TextData[{
 "Note, this does not mean that the eigenvalues of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " are necessarily positive:"
}], "ExampleText",
 CellID->296316979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Eigenvalues", "[", "m", "]"}], ",", 
   RowBox[{"Map", "[", 
    RowBox[{"Positive", ",", 
     RowBox[{"Eigenvalues", "[", "m", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->26929173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", "\[ImaginaryI]"}], ")"}], "+", 
        SqrtBox[
         RowBox[{"16", "+", 
          RowBox[{"6", " ", "\[ImaginaryI]"}]}]]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", "\[ImaginaryI]"}], ")"}], "-", 
        SqrtBox[
         RowBox[{"16", "+", 
          RowBox[{"6", " ", "\[ImaginaryI]"}]}]]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}]}], "}"}]], "Output",
 ImageSize->{438, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->375159370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->264087203],

Cell[TextData[{
 "A positive definite Hermitian matrix has a square root given by the ",
 Cell[BoxData[
  ButtonBox["CholeskyDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CholeskyDecomposition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->400449538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38531204],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16768376]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PositiveDefiniteMatrixQ", "[", "m", "]"}], " ", "&&", " ", 
  RowBox[{"HermitianMatrixQ", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->752609812],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->205398496]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"CholeskyDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->823835415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     SqrtBox["3"], ",", 
     FractionBox["1", 
      SqrtBox["3"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     SqrtBox[
      FractionBox["5", "3"]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{275, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->260343420]
}, Open  ]],

Cell[TextData[{
 "A square root of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is a matrix ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "\[ConjugateTranspose]"], ".", "b"}], "=", "m"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->51101318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConjugateTranspose", "[", "b", "]"}], ".", "b"}], "\[Equal]", 
  "m"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->85519303],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->332712562]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->707469610],

Cell["\<\
A sufficient condition for a minimum is a zero gradient and positive definite \
Hessian:\
\>", "ExampleText",
 CellID->137195614],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"v_", "?", "VectorQ"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"v1", "=", 
        RowBox[{"Take", "[", 
         RowBox[{"v", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"v2", "=", 
        RowBox[{"Take", "[", 
         RowBox[{"v", ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", 
            RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]}], ",", "n"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "v2", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"v2", "=", 
       RowBox[{"(", 
        RowBox[{"v2", "-", 
         RowBox[{
          RowBox[{"PadRight", "[", 
           RowBox[{"v1", ",", "n", ",", "v1"}], "]"}], "^", "2"}]}], ")"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"v1", "-=", 
       RowBox[{"Range", "[", 
        RowBox[{"Length", "[", "v1", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"v1", ".", "v1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Range", "[", "n", "]"}], "v2"}], ")"}], ".", "v2"}]}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->716291897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "#"], "&"}], ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->670770423],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SubscriptBox["x", "1"]}], ")"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubsuperscriptBox["x", "1", "2"]}], "+", 
     SubscriptBox["x", "2"]}], ")"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     SubscriptBox["x", "3"]}], ")"}], "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SubsuperscriptBox["x", "3", "2"]}], "+", 
      SubscriptBox["x", "4"]}], ")"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     SubscriptBox["x", "5"]}], ")"}], "2"]}]], "Output",
 ImageSize->{373, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->365159955]
}, Open  ]],

Cell["Check the conditions for up to five variables: ", "ExampleText",
 CellID->250682599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"v", "=", 
       RowBox[{"Array", "[", 
        RowBox[{
         RowBox[{
          SubscriptBox["x", "#"], "&"}], ",", "n"}], "]"}]}], ";", 
      RowBox[{"g", "=", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"f", "[", "v", "]"}], ",", 
         RowBox[{"{", "v", "}"}]}], "]"}]}], ";", 
      RowBox[{"h", "=", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"f", "[", "v", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"v", ",", "2"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"min", ",", "minp"}], "}"}], "=", 
       RowBox[{"Quiet", "[", 
        RowBox[{"FindMinimum", "[", 
         RowBox[{
          RowBox[{"f", "[", "v", "]"}], ",", 
          RowBox[{"Evaluate", "[", 
           RowBox[{"Transpose", "[", 
            RowBox[{"{", 
             RowBox[{"v", ",", 
              RowBox[{"RandomReal", "[", 
               RowBox[{"1", ",", "n"}], "]"}]}], "}"}], "]"}], "]"}]}], "]"}],
         "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"min", ",", "minp", ",", 
        RowBox[{"Norm", "[", 
         RowBox[{"g", "/.", "minp"}], "]"}], ",", 
        RowBox[{"PositiveDefiniteMatrixQ", "[", 
         RowBox[{"h", "/.", "minp"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<min\>\"", ",", "\"\<minimizer\>\"", ",", 
        "\"\<\[LeftDoubleBracketingBar]\[Del]f\[RightDoubleBracketingBar]\>\"\
", ",", "\"\<Positive definite Hessian\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->439366542],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW3tP1EAQ712vvIk8EsM7JCaKwQRBAT+BqIiJ+o9ojLkQE/hDQOQbqPFz
+HH0S9VOu3ud/na63faOx0kvuXYfs7OzM7Ozvx2Ovfb54ecv7fOjg/byzln7
9PDo4Nvy05OzqMlveF7ju+d5f2a8qBxGpfhLnx/RNykmpff09HVvGL/uxT37
rMdTBCtx+XX0bEYtTfVuAY9hqAfRw1d0TdU8FnN6Q89WSul5vqIZBx5+zKhT
VzL5Bse3OTKRDMNRdUhY7y1jJBGMAeVg7khzFZNAO8DknBJ1OJ/L/VhcOb3j
WbwTJW/KO2td3ZdY9YMwz11RInrTokYEPfiMrsia3IdEnbb42mRrBuw9rGw0
oCgnMpQDMANKL/tRqs1iWwYGRToadTgL608pT3N7vjItTII991nf/ZL29EO7
ZkingbinlsLs/l01NBBU0rqe6SHwP1Z1HyRK2CQf7Z27cdOilf+D0IwJHvMm
lH7Tyu1EWpulrm3A2/YsUq+Hqa/zMaNQx/7HIrdzF2mNUWXkJevZdwxGzkc9
ljQo8IO10B5rN5zl6XiRrDGj1SbVS7HVzYp6JYkwngoguNt9PUuOBHuKRvZ3
ikNZu6JXfAx5dPil3mfRezB6fwp1xNJDVjotGLFkXFE9YplRHPFA0W5yQxY8
iuDJQ4/JzMiyOzrl4IYw5LG2MylLeZrbc8K0MR23UCk5k94pK1BLgjHyMWV/
WBgpibObhfUJhui1Py1bvlTjzRpvXsTe7g5fmvZ1RYL0mMqMvMgYLt0wJ0Td
5t8WEavviJrZDC8WcT8LbcjispD0T7H14hHxtlr9bo/nL8K528DJff5e4lpE
22XjwJqT1L1BwObdpSqKkKUui6E3Qnt8wtNG7+Ms5q7xZo03+9GyrqUalfQb
Kukmh301GYTinGfV/X/V2U7c33LGqc52Vs12uun38rKdGKXd5eklKnxVSYre
5TmJdkvs7U2es0YlNx2VpKU6590/dxA8558D5WVkSvJj0/+eKdlSWnzR4/mL
zsgnwMl9/jpTopuuR6bE9ZSyZ0pu5ol1NZil/29Wrj53PW5Wrr5d36jqG9V1
ulERYbl49pvNQnJMQf1vCapZJQuPFUSUbBv90UPLURtUrB4I/dpHqbnF6gsg
Oe5oPo7TLSh969/lar46TupfwDZZHT1Z/6U+8NIY2mT1wHn1LZBiSNWZh8Ic
Lc+Umd5DwL0RP+eYj6Y6wDXJ+2++i7E2qrK8cP+gpRcLPAFjId7nFiV6xxgl
eYd86uVJJPWPVtKDtAMcJR4EKkU77iRHmZhewuJGayN+95dHF+EatBlFJ47S
cIw0R1xvpf3Z2NjhYKwIkQXatUjWa+fFlrqbLPj/EaLNb5D3SqPwTKUiRmCM
sDa+1E/j9SkoR099Ypfxz3zrUOOwtbcabxevdJubYwNp3RoNdO9n0s1qtqvR
tl1S4Lfm7xlzb5BLbLxnpS48+0203s3pX8kjzVb8P7JmLqXLrC52crszklxB
ST11iwW09I2Of5OHcjytx+sogpmO+ZL0PuvLG8ezPHl88JZiv4fjiWp6J48N
OgZwWZoot3GPoNbR0EQZfCRyytMOamBEXB3K7IPs+ibWFGaKfcK4tVLroODR
xbt7BkbcgToiAMx2TIorjLN4Bq9VqGMmD+vrIP0YswDeYGlR0wX85pQ+R5n+
bfS3RZ9BjSW/aaFiknfwGv8AeCb1bg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{387, 201},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->18837215]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "If positive definiteness is not certain at the matrix precision, the test \
returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17037122],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"HilbertMatrix", "[", "16", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300684153],

Cell["Hilbert matrices are positive definite:", "ExampleText",
 CellID->491588740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->589481889],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38616940]
}, Open  ]],

Cell["\<\
The smallest eigenvalue is too small to be certainly positive at machine \
precision:\
\>", "ExampleText",
 CellID->254959747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev", " ", "=", " ", 
  RowBox[{"N", "[", 
   RowBox[{"Eigenvalues", "[", "m", "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->633557144],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.8600364427433271`", ",", "0.44013143636233815`", ",", 
   "0.06111426291630709`", ",", "0.006297815269922938`", ",", 
   "0.0005146753583779355`", ",", "0.00003412756971658616`", ",", 
   "1.8529753628386086`*^-6", ",", "8.253135278123955`*^-8", ",", 
   "3.0045761593828615`*^-9", ",", "8.86170884436706`*^-11", ",", 
   "2.085937152775827`*^-12", ",", "3.827669089575262`*^-14", ",", 
   "5.277456405490515`*^-16", ",", "5.14339953206079`*^-18", ",", 
   "3.159250701855795`*^-20", ",", "9.197419820651453`*^-23"}], 
  "}"}]], "Output",
 ImageSize->{505, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->4012138]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"ev", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "+", 
    RowBox[{"ev", "[", 
     RowBox[{"[", 
      RowBox[{"-", "1"}], "]"}], "]"}]}], ")"}], "-", 
  RowBox[{"ev", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->374172896],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->46240765]
}, Open  ]],

Cell["\<\
At machine precision, the matrix does not test positive definite:\
\>", "ExampleText",
 CellID->68650035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1291344],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->268347280]
}, Open  ]],

Cell["\<\
Using precision high enough to resolve positiveness will work:\
\>", "ExampleText",
 CellID->69267872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveDefiniteMatrixQ", "[", 
  RowBox[{"N", "[", 
   RowBox[{"m", ",", "24"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->256285316],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->14441378]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HermitianMatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HermitianMatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->147105853],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "MoreAbout",
 CellID->680199230]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PositiveDefiniteMatrixQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 21.1072764}", "context" -> "System`", 
    "keywords" -> {
     "pd", "positive definite matrix", "positive definite quadratic form", 
      "positive eigenvalues"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PositiveDefiniteMatrixQ[m] tests whether m is a positive definite \
matrix.", 
    "synonyms" -> {
     "positive definite matrix q", "positive-definite matrix", 
      "positive definite matrix", "PositiveDefiniteQ"}, "title" -> 
    "PositiveDefiniteMatrixQ", "type" -> "Symbol", "uri" -> 
    "ref/PositiveDefiniteMatrixQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6473, 202, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->198804769]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55348, 1787}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1631, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2254, 64, 1588, 37, 70, "ObjectNameGrid"],
Cell[3845, 103, 596, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4478, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4956, 143, 653, 22, 70, "Notes",
 CellID->237854512],
Cell[5612, 167, 216, 7, 70, "Notes",
 CellID->713779358],
Cell[5831, 176, 351, 12, 70, "Notes",
 CellID->78903241],
Cell[6185, 190, 251, 7, 70, "Notes",
 CellID->162284008]
}, Closed]],
Cell[CellGroupData[{
Cell[6473, 202, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->198804769],
Cell[CellGroupData[{
Cell[6858, 216, 147, 5, 70, "ExampleSection",
 CellID->58406821],
Cell[7008, 223, 91, 1, 70, "ExampleText",
 CellID->16203226],
Cell[7102, 226, 275, 10, 70, "Input",
 CellID->170908600],
Cell[CellGroupData[{
Cell[7402, 240, 119, 3, 28, "Input",
 CellID->285981040],
Cell[7524, 245, 161, 5, 36, "Output",
 CellID->773327986]
}, Open  ]],
Cell[7700, 253, 344, 13, 70, "ExampleText",
 CellID->506309372],
Cell[CellGroupData[{
Cell[8069, 270, 584, 21, 28, "Input",
 CellID->34561757],
Cell[8656, 293, 14791, 247, 162, "Output",
 Evaluatable->False,
 CellID->48490208]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23496, 546, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[23720, 555, 76, 1, 70, "ExampleText",
 CellID->203013878],
Cell[CellGroupData[{
Cell[23821, 560, 272, 9, 70, "Input",
 CellID->563010078],
Cell[24096, 571, 161, 5, 36, "Output",
 CellID->75322780]
}, Open  ]],
Cell[24272, 579, 124, 3, 70, "ExampleDelimiter",
 CellID->48664461],
Cell[24399, 584, 75, 1, 70, "ExampleText",
 CellID->25205222],
Cell[CellGroupData[{
Cell[24499, 589, 312, 11, 70, "Input",
 CellID->157202116],
Cell[24814, 602, 161, 5, 36, "Output",
 CellID->274613748]
}, Open  ]],
Cell[24990, 610, 123, 3, 70, "ExampleDelimiter",
 CellID->2905990],
Cell[25116, 615, 88, 1, 70, "ExampleText",
 CellID->289725939],
Cell[CellGroupData[{
Cell[25229, 620, 340, 13, 70, "Input",
 CellID->121734627],
Cell[25572, 635, 432, 15, 54, "Output",
 CellID->21922976]
}, Open  ]],
Cell[CellGroupData[{
Cell[26041, 655, 118, 3, 70, "Input",
 CellID->11287139],
Cell[26162, 660, 160, 5, 36, "Output",
 CellID->65522332]
}, Open  ]],
Cell[26337, 668, 125, 3, 70, "ExampleDelimiter",
 CellID->114577149],
Cell[26465, 673, 85, 1, 70, "ExampleText",
 CellID->315609875],
Cell[CellGroupData[{
Cell[26575, 678, 290, 10, 70, "Input",
 CellID->44838534],
Cell[26868, 690, 161, 5, 36, "Output",
 CellID->380787608]
}, Open  ]],
Cell[27044, 698, 124, 3, 70, "ExampleDelimiter",
 CellID->88221870],
Cell[27171, 703, 64, 1, 70, "ExampleText",
 CellID->610540136],
Cell[CellGroupData[{
Cell[27260, 708, 624, 21, 70, "Input",
 CellID->150539512],
Cell[27887, 731, 491, 17, 36, "Output",
 CellID->182269728]
}, Open  ]],
Cell[CellGroupData[{
Cell[28415, 753, 118, 3, 70, "Input",
 CellID->20730237],
Cell[28536, 758, 161, 5, 36, "Output",
 CellID->239189300]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28746, 769, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[28993, 778, 79, 1, 70, "ExampleText",
 CellID->682441741],
Cell[CellGroupData[{
Cell[29097, 783, 334, 12, 70, "Input",
 CellID->558705710],
Cell[29434, 797, 160, 5, 36, "Output",
 CellID->18451619]
}, Open  ]],
Cell[29609, 805, 115, 3, 70, "ExampleText",
 CellID->145816961],
Cell[CellGroupData[{
Cell[29749, 812, 300, 10, 70, "Input",
 CellID->387407636],
Cell[30052, 824, 355, 12, 36, "Output",
 CellID->7578986]
}, Open  ]],
Cell[30422, 839, 404, 16, 70, "ExampleText",
 CellID->2899607],
Cell[CellGroupData[{
Cell[30851, 859, 134, 4, 70, "Input",
 CellID->49600401],
Cell[30988, 865, 160, 5, 36, "Output",
 CellID->35680167]
}, Open  ]],
Cell[CellGroupData[{
Cell[31185, 875, 154, 5, 70, "Input",
 CellID->311398035],
Cell[31342, 882, 161, 5, 36, "Output",
 CellID->60159529]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31552, 893, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[31793, 902, 141, 4, 70, "ExampleText",
 CellID->773502778],
Cell[31937, 908, 287, 11, 70, "Input",
 CellID->19131699],
Cell[CellGroupData[{
Cell[32249, 923, 112, 3, 70, "Input",
 CellID->611526703],
Cell[32364, 928, 161, 5, 36, "Output",
 CellID->137635431]
}, Open  ]],
Cell[32540, 936, 164, 6, 70, "ExampleText",
 CellID->388812697],
Cell[CellGroupData[{
Cell[32729, 946, 106, 3, 70, "Input",
 CellID->64030269],
Cell[32838, 951, 431, 17, 51, "Output",
 CellID->47333124]
}, Open  ]],
Cell[CellGroupData[{
Cell[33306, 973, 128, 4, 70, "Input",
 CellID->14523312],
Cell[33437, 979, 209, 7, 36, "Output",
 CellID->518859684]
}, Open  ]],
Cell[33661, 989, 157, 6, 70, "ExampleText",
 CellID->216962502],
Cell[CellGroupData[{
Cell[33843, 999, 119, 3, 70, "Input",
 CellID->640458354],
Cell[33965, 1004, 159, 5, 36, "Output",
 CellID->4872810]
}, Open  ]],
Cell[34139, 1012, 125, 3, 70, "ExampleDelimiter",
 CellID->100889476],
Cell[34267, 1017, 435, 15, 70, "ExampleText",
 CellID->802181500],
Cell[34705, 1034, 360, 14, 70, "Input",
 CellID->44867690],
Cell[CellGroupData[{
Cell[35090, 1052, 217, 8, 70, "Input",
 CellID->321965365],
Cell[35310, 1062, 454, 17, 51, "Output",
 CellID->126596720]
}, Open  ]],
Cell[35779, 1082, 118, 3, 70, "ExampleText",
 CellID->46798861],
Cell[CellGroupData[{
Cell[35922, 1089, 322, 9, 70, "Input",
 CellID->292154976],
Cell[36247, 1100, 628, 23, 51, "Output",
 CellID->86581234]
}, Open  ]],
Cell[36890, 1126, 162, 6, 70, "ExampleText",
 CellID->789812],
Cell[CellGroupData[{
Cell[37077, 1136, 119, 3, 70, "Input",
 CellID->551609085],
Cell[37199, 1141, 161, 5, 36, "Output",
 CellID->195728498]
}, Open  ]],
Cell[37375, 1149, 202, 6, 70, "ExampleText",
 CellID->296316979],
Cell[CellGroupData[{
Cell[37602, 1159, 257, 8, 70, "Input",
 CellID->26929173],
Cell[37862, 1169, 848, 29, 51, "Output",
 CellID->375159370]
}, Open  ]],
Cell[38725, 1201, 125, 3, 70, "ExampleDelimiter",
 CellID->264087203],
Cell[38853, 1206, 277, 8, 70, "ExampleText",
 CellID->400449538],
Cell[CellGroupData[{
Cell[39155, 1218, 341, 11, 70, "Input",
 CellID->38531204],
Cell[39499, 1231, 390, 13, 36, "Output",
 CellID->16768376]
}, Open  ]],
Cell[CellGroupData[{
Cell[39926, 1249, 196, 5, 70, "Input",
 CellID->752609812],
Cell[40125, 1256, 161, 5, 36, "Output",
 CellID->205398496]
}, Open  ]],
Cell[CellGroupData[{
Cell[40323, 1266, 140, 4, 70, "Input",
 CellID->823835415],
Cell[40466, 1272, 486, 18, 62, "Output",
 CellID->260343420]
}, Open  ]],
Cell[40967, 1293, 406, 16, 70, "ExampleText",
 CellID->51101318],
Cell[CellGroupData[{
Cell[41398, 1313, 170, 6, 70, "Input",
 CellID->85519303],
Cell[41571, 1321, 161, 5, 36, "Output",
 CellID->332712562]
}, Open  ]],
Cell[41747, 1329, 125, 3, 70, "ExampleDelimiter",
 CellID->707469610],
Cell[41875, 1334, 139, 4, 70, "ExampleText",
 CellID->137195614],
Cell[42017, 1340, 1408, 44, 70, "Input",
 CellID->716291897],
Cell[CellGroupData[{
Cell[43450, 1388, 198, 7, 70, "Input",
 CellID->670770423],
Cell[43651, 1397, 907, 34, 41, "Output",
 CellID->365159955]
}, Open  ]],
Cell[44573, 1434, 90, 1, 70, "ExampleText",
 CellID->250682599],
Cell[CellGroupData[{
Cell[44688, 1439, 1931, 56, 70, "Input",
 CellID->439366542],
Cell[46622, 1497, 1963, 36, 70, "Output",
 Evaluatable->False,
 CellID->18837215]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48634, 1539, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[48868, 1548, 260, 9, 70, "ExampleText",
 CellID->17037122],
Cell[49131, 1559, 162, 5, 70, "Input",
 CellID->300684153],
Cell[49296, 1566, 82, 1, 70, "ExampleText",
 CellID->491588740],
Cell[CellGroupData[{
Cell[49403, 1571, 119, 3, 70, "Input",
 CellID->589481889],
Cell[49525, 1576, 160, 5, 36, "Output",
 CellID->38616940]
}, Open  ]],
Cell[49700, 1584, 136, 4, 70, "ExampleText",
 CellID->254959747],
Cell[CellGroupData[{
Cell[49861, 1592, 170, 5, 70, "Input",
 CellID->633557144],
Cell[50034, 1599, 712, 16, 75, "Output",
 CellID->4012138]
}, Open  ]],
Cell[CellGroupData[{
Cell[50783, 1620, 328, 12, 70, "Input",
 CellID->374172896],
Cell[51114, 1634, 159, 5, 36, "Output",
 CellID->46240765]
}, Open  ]],
Cell[51288, 1642, 115, 3, 70, "ExampleText",
 CellID->68650035],
Cell[CellGroupData[{
Cell[51428, 1649, 145, 4, 70, "Input",
 CellID->1291344],
Cell[51576, 1655, 162, 5, 36, "Output",
 CellID->268347280]
}, Open  ]],
Cell[51753, 1663, 112, 3, 70, "ExampleText",
 CellID->69267872],
Cell[CellGroupData[{
Cell[51890, 1670, 172, 5, 70, "Input",
 CellID->256285316],
Cell[52065, 1677, 160, 5, 36, "Output",
 CellID->14441378]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52286, 1689, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[52605, 1700, 720, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[53362, 1731, 299, 8, 70, "MoreAboutSection"],
Cell[53664, 1741, 163, 3, 70, "MoreAbout",
 CellID->147105853],
Cell[53830, 1746, 198, 4, 70, "MoreAbout",
 CellID->680199230]
}, Open  ]],
Cell[54043, 1753, 27, 0, 70, "History"],
Cell[54073, 1755, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

