(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11704,        421]
NotebookOptionsPosition[      8779,        325]
NotebookOutlinePosition[     10071,        361]
CellTagsIndexPosition[      9987,        356]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DefiningOutputFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Defining Output Formats\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Infix" :> Documentation`HelpLookup["paclet:ref/Infix"], 
          "Prefix" :> Documentation`HelpLookup["paclet:ref/Prefix"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Infix\"\>", 
       2->"\<\"Prefix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Notational Forms" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicNotationalForms"], 
          "Mathematica Syntax" :> 
          Documentation`HelpLookup["paclet:guide/Syntax"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Symbolic Notational Forms\"\>", 
       2->"\<\"Mathematica Syntax\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Postfix", "ObjectName",
 CellID->13365],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Postfix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Postfix"], "[", 
       RowBox[{
        StyleBox["f", "TI"], "[", 
        StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " given in default postfix form: ",
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "//", 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Postfix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Postfix"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["f", "TI"], "[", 
         StyleBox["expr", "TI"], "]"}], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as ",
     Cell[BoxData[
      StyleBox["exprh", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11397]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Postfix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Postfix"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["precedence", "TI"], ",", 
    StyleBox["grouping", "TI"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " can be used to specify how the output form should be parenthesized. "
}], "Notes",
 CellID->15868]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->48091421],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->6125487],

Cell[TextData[{
 "Display ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 " in postfix form:"
}], "ExampleText",
 CellID->64949714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Postfix", "[", 
  RowBox[{"f", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123621129],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "//", "f"}],
  Postfix[
   $CellContext`f[$CellContext`x]],
  Editable->False]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332942366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->560380136],

Cell["Use a special character as a postfix operator:", "ExampleText",
 CellID->350845310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Postfix", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "\"\<\[Section]\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->695511997],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "\<\"\[Section]\"\>"}],
  Postfix[
   $CellContext`f[$CellContext`x], "\[Section]"],
  Editable->False]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101607838]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13163],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Infix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prefix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prefix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10879]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17616],

Cell[TextData[ButtonBox["Defining Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningOutputFormats"]], "Tutorials",
 CellID->16218]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Notational Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicNotationalForms"]], "MoreAbout",
 CellID->106048729],

Cell[TextData[ButtonBox["Mathematica Syntax",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Syntax"]], "MoreAbout",
 CellID->334269934]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Postfix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 24.7948708}", "context" -> "System`", 
    "keywords" -> {"postfix notation", "reverse polish notation", "rpn"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Postfix[f[expr]] prints with f[expr] given in default postfix form: expr \
// f. Postfix[f[expr], h] prints as exprh. ", "synonyms" -> {"//"}, "title" -> 
    "Postfix", "type" -> "Symbol", "uri" -> "ref/Postfix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4902, 163, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->48091421]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9845, 349}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1967, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2590, 76, 45, 1, 70, "ObjectName",
 CellID->13365],
Cell[2638, 79, 1276, 43, 70, "Usage",
 CellID->11397]
}, Open  ]],
Cell[CellGroupData[{
Cell[3951, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4429, 144, 436, 14, 70, "Notes",
 CellID->15868]
}, Closed]],
Cell[CellGroupData[{
Cell[4902, 163, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->48091421],
Cell[CellGroupData[{
Cell[5286, 177, 146, 5, 70, "ExampleSection",
 CellID->6125487],
Cell[5435, 184, 153, 6, 70, "ExampleText",
 CellID->64949714],
Cell[CellGroupData[{
Cell[5613, 194, 131, 4, 28, "Input",
 CellID->123621129],
Cell[5747, 200, 269, 10, 36, "Output",
 CellID->332942366]
}, Open  ]],
Cell[6031, 213, 125, 3, 70, "ExampleDelimiter",
 CellID->560380136],
Cell[6159, 218, 89, 1, 70, "ExampleText",
 CellID->350845310],
Cell[CellGroupData[{
Cell[6273, 223, 174, 6, 70, "Input",
 CellID->695511997],
Cell[6450, 231, 294, 10, 36, "Output",
 CellID->101607838]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6805, 248, 311, 9, 70, "SeeAlsoSection",
 CellID->13163],
Cell[7119, 259, 441, 17, 70, "SeeAlso",
 CellID->10879]
}, Open  ]],
Cell[CellGroupData[{
Cell[7597, 281, 314, 9, 70, "TutorialsSection",
 CellID->17616],
Cell[7914, 292, 155, 3, 70, "Tutorials",
 CellID->16218]
}, Open  ]],
Cell[CellGroupData[{
Cell[8106, 300, 299, 8, 70, "MoreAboutSection"],
Cell[8408, 310, 160, 3, 70, "MoreAbout",
 CellID->106048729],
Cell[8571, 315, 136, 3, 70, "MoreAbout",
 CellID->334269934]
}, Open  ]],
Cell[8722, 321, 27, 0, 70, "History"],
Cell[8752, 323, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

