(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     67612,       2505]
NotebookOptionsPosition[     54730,       2053]
NotebookOutlinePosition[     56276,       2094]
CellTagsIndexPosition[     56190,       2089]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Structural Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Expressions into Different Forms\"\>", 
       2->"\<\"Structural Operations on Polynomials\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expand" :> Documentation`HelpLookup["paclet:ref/Expand"], 
          "Power" :> Documentation`HelpLookup["paclet:ref/Power"], "Sqrt" :> 
          Documentation`HelpLookup["paclet:ref/Sqrt"], "Distribute" :> 
          Documentation`HelpLookup["paclet:ref/Distribute"], "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"], 
          "FunctionExpand" :> 
          Documentation`HelpLookup["paclet:ref/FunctionExpand"], "Refine" :> 
          Documentation`HelpLookup["paclet:ref/Refine"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Expand\"\>", 2->"\<\"Power\"\>", 
       3->"\<\"Sqrt\"\>", 4->"\<\"Distribute\"\>", 5->"\<\"ComplexExpand\"\>",
        6->"\<\"Simplify\"\>", 7->"\<\"FullSimplify\"\>", 
       8->"\<\"FunctionExpand\"\>", 9->"\<\"Refine\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Formula Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PowerExpand", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PowerExpand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PowerExpand"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]expands all powers of products and powers. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PowerExpand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PowerExpand"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]expands only with respect to the variables ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30148]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " converts ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", " ", "b"}], ")"}], "^", "c"}], TraditionalForm]], 
  "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", "^", "c"}], 
    RowBox[{"b", "^", "c"}]}], TraditionalForm]], "InlineMath"],
 ", whatever the form of ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " is. "
}], "Notes",
 CellID->25070],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " also converts ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "^", "b"}], ")"}], "^", "c"}], TraditionalForm]], 
  "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "^", 
    RowBox[{"(", 
     RowBox[{"b", " ", "c"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", whatever the form of ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " is. "
}], "Notes",
 CellID->1496],

Cell[TextData[{
 "The transformations made by ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " are correct in general only if ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " is an integer or ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " are positive real numbers. "
}], "Notes",
 CellID->6693],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " converts ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   RowBox[{
    StyleBox["a", "TI"], "^", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["b", "TI"], 
   RowBox[{
    ButtonBox["Log",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Log"], "[", 
    StyleBox["a", "TI"], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18703],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " in general disregards all issues of branches of multivalued functions, so \
may not preserve the numerical values of expressions."
}], "Notes",
 CellID->674115380],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " automatically threads over lists, as well as equations, inequalities and \
logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " has the option ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 ", specifying assumptions to use."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23692],

Cell[TextData[{
 "You can specify default assumptions for ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->20363]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->54362084],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->56567838],

Cell["\<\
Expand a square root, implicitly assuming positive real values:\
\>", "ExampleText",
 CellID->60343711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"x", " ", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->266114012],

Cell[BoxData[
 RowBox[{
  SqrtBox["x"], " ", 
  SqrtBox["y"]}]], "Output",
 ImageSize->{55, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->420432473]
}, Open  ]],

Cell[TextData[{
 "Without ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 ", no expansion is done:"
}], "ExampleText",
 CellID->599153328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"x", " ", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->737233742],

Cell[BoxData[
 SqrtBox[
  RowBox[{"x", " ", "y"}]]], "Output",
 ImageSize->{38, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12407167]
}, Open  ]],

Cell["The expansion is only correct for positive real variables:", \
"ExampleText",
 CellID->277360666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    SqrtBox[
     RowBox[{"x", " ", "y"}]], ",", 
    RowBox[{
     SqrtBox["x"], 
     SqrtBox["y"]}]}], "}"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "3"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->122276137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["6"], ",", 
   RowBox[{"-", 
    SqrtBox["6"]}]}], "}"}]], "Output",
 ImageSize->{85, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->77276]
}, Open  ]],

Cell["This gives a completely correct result:", "ExampleText",
 CellID->59662838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->470035547],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
    RowBox[{"Floor", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "x", "]"}], 
       RowBox[{"2", " ", "\[Pi]"}]], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "y", "]"}], 
       RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]], " ", 
  SqrtBox["x"], " ", 
  SqrtBox["y"]}]], "Output",
 ImageSize->{200, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->27166956]
}, Open  ]],

Cell["This gives a result correct under the specified assumptions:", \
"ExampleText",
 CellID->613697788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"Pi", "/", "2"}], "<", 
      RowBox[{"Arg", "[", "x", "]"}], "<", "Pi"}], "&&", 
     RowBox[{
      RowBox[{"Pi", "/", "2"}], "<", 
      RowBox[{"Arg", "[", "y", "]"}], "<", "Pi"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->574175268],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox["x"]}], " ", 
  SqrtBox["y"]}]], "Output",
 ImageSize->{63, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->324047055]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1667],

Cell["\<\
Expand a power of a product; the result may not be correct everywhere:\
\>", "ExampleText",
 CellID->589416271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", " ", "y"}], ")"}], "^", "a"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146254729],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "a"], " ", 
  SuperscriptBox["y", "a"]}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->425842857]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24315080],

Cell["The general formula for expanding a power of a product:", "ExampleText",
 CellID->408429242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", " ", "y"}], ")"}], "^", "a"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141565159],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "a", " ", "\[Pi]", " ", 
    RowBox[{"Floor", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "x", "]"}], 
       RowBox[{"2", " ", "\[Pi]"}]], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "y", "]"}], 
       RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]], " ", 
  SuperscriptBox["x", "a"], " ", 
  SuperscriptBox["y", "a"]}]], "Output",
 ImageSize->{191, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192883677]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->398623554],

Cell["\<\
Expand nested powers; the results may not be correct everywhere:\
\>", "ExampleText",
 CellID->118276975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"z", "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->856157745],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306739477]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "^", "x"}], ")"}], "^", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->181187712],

Cell[BoxData[
 SuperscriptBox["a", 
  RowBox[{"x", " ", "y"}]]], "Output",
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110968928]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->278267171],

Cell["General formulas for expanding a nested power:", "ExampleText",
 CellID->2549192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"z", "^", "2"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44081980],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
    RowBox[{"Floor", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "z", "]"}], "\[Pi]"]}], "]"}]}]], " ", 
  "z"}]], "Output",
 ImageSize->{118, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308239932]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "^", "x"}], ")"}], "^", "y"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->340495029],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", 
   RowBox[{"x", " ", "y"}]], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "y", " ", 
    RowBox[{"Floor", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       RowBox[{"Im", "[", 
        RowBox[{"x", " ", 
         RowBox[{"Log", "[", "a", "]"}]}], "]"}], 
       RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]]}]], "Output",
 ImageSize->{171, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104112971]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120434263],

Cell["\<\
Expand the logarithm of a power; the result may not be correct everywhere:\
\>", "ExampleText",
 CellID->18049444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "/", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94756105],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25660398]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"z", "^", "a"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113356047],

Cell[BoxData[
 RowBox[{"a", " ", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->500352673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12133134],

Cell["The general formulas for expanding logarithms of powers:", "ExampleText",
 CellID->30134189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "/", "z"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368314563],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "+", 
     FractionBox[
      RowBox[{"Arg", "[", "z", "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "-", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{210, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87859265]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"z", "^", "a"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->119226759],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      RowBox[{"Im", "[", 
       RowBox[{"a", " ", 
        RowBox[{"Log", "[", "z", "]"}]}], "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "+", 
  RowBox[{"a", " ", 
   RowBox[{"Log", "[", "z", "]"}]}]}]], "Output",
 ImageSize->{258, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->236975212]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->233931506],

Cell["\<\
Expand the logarithm of a product; the result may not be correct everywhere:\
\>", "ExampleText",
 CellID->355244445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"x", " ", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->611488183],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", "x", "]"}], "+", 
  RowBox[{"Log", "[", "y", "]"}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19146642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31081062],

Cell["\<\
The general formula for expanding the logarithm of a product:\
\>", "ExampleText",
 CellID->144466150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37930650],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      RowBox[{"Arg", "[", "x", "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]], "-", 
     FractionBox[
      RowBox[{"Arg", "[", "y", "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "+", 
  RowBox[{"Log", "[", "x", "]"}], "+", 
  RowBox[{"Log", "[", "y", "]"}]}]], "Output",
 ImageSize->{323, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36668294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->205200572],

Cell["\<\
Expand compositions of inverse trigonometric and trigonometric functions:\
\>", "ExampleText",
 CellID->600954242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"ArcTan", "[", 
   RowBox[{"Tan", "[", "x", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33415287],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71873400]
}, Open  ]],

Cell["This gives the universally correct formula:", "ExampleText",
 CellID->107705325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->670622526],

Cell[BoxData[
 RowBox[{"x", "-", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "+", 
     FractionBox[
      RowBox[{"Re", "[", "x", "]"}], "\[Pi]"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Floor", "[", 
          RowBox[{
           FractionBox["1", "2"], "-", 
           FractionBox[
            RowBox[{"Re", "[", "x", "]"}], "\[Pi]"]}], "]"}], "+", 
         RowBox[{"Floor", "[", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "2"]}], "+", 
           FractionBox[
            RowBox[{"Re", "[", "x", "]"}], "\[Pi]"]}], "]"}]}], ")"}]}]]}], 
    ")"}], " ", "\[Pi]", " ", 
   RowBox[{"UnitStep", "[", 
    RowBox[{"Im", "[", "x", "]"}], "]"}]}]}]], "Output",
 ImageSize->{521, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50228112]
}, Open  ]],

Cell["Compute an expansion valid under the specified assumptions:", \
"ExampleText",
 CellID->42804783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"Cot", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"0", "<", "x", "<", "Pi"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20127987],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "-", "x"}]], "Output",
 ImageSize->{36, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->983623145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310803813],

Cell["Expand the argument of a product:", "ExampleText",
 CellID->80042935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Arg", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->311009832],

Cell[BoxData[
 RowBox[{
  RowBox[{"Arg", "[", "x", "]"}], "+", 
  RowBox[{"Arg", "[", "y", "]"}], "+", 
  RowBox[{"2", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      RowBox[{"Arg", "[", "x", "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]], "-", 
     FractionBox[
      RowBox[{"Arg", "[", "y", "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]}]], "Output",
 ImageSize->{312, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->572980772]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29772],

Cell[TextData[{
 "Expand only with respect to ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->133452789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a", " ", "b"}], "]"}], "+", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"c", " ", "d"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251112213],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["a"], " ", 
   SqrtBox["b"]}], "+", 
  SqrtBox[
   RowBox[{"c", " ", "d"}]]}]], "Output",
 ImageSize->{102, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20793092]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->41504786],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->185520762],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"], " ", "\[Rule]", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " the expansions are not always correct:"
}], "ExampleText",
 CellID->150485188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"z", "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270690176],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->382554095]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"z", "^", "2"}], "]"}], ",", "z"}], "}"}], "/.", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{"-", "1"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->120356315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11975485]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34033169],

Cell["\<\
When the assumptions are specified the result is correct under the given \
assumptions:\
\>", "ExampleText",
 CellID->744001761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"z", "^", "2"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"z", "<", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->630949011],

Cell[BoxData[
 RowBox[{"-", "z"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220593257]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->802104141],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " gives a universally correct expansion formula:"
}], "ExampleText",
 CellID->39780376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"z", "^", "2"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399309604],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
    RowBox[{"Floor", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "z", "]"}], "\[Pi]"]}], "]"}]}]], " ", 
  "z"}]], "Output",
 ImageSize->{118, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7549008]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->107209393],

Cell["Find universally correct expansion rules:", "ExampleText",
 CellID->477769941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"E", "^", "x"}], ")"}], "^", "y"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112719979],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"x", " ", "y"}], "+", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "y", " ", 
    RowBox[{"Floor", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       RowBox[{"Im", "[", "x", "]"}], 
       RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]}]]], "Output",
 ImageSize->{134, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->302918029]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", " ", "b", " ", "c"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197088621],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", 
   RowBox[{"1", "/", "3"}]], " ", 
  SuperscriptBox["b", 
   RowBox[{"1", "/", "3"}]], " ", 
  SuperscriptBox["c", 
   RowBox[{"1", "/", "3"}]], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    RowBox[{"Floor", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "a", "]"}], 
       RowBox[{"2", " ", "\[Pi]"}]], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "b", "]"}], 
       RowBox[{"2", " ", "\[Pi]"}]], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "c", "]"}], 
       RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]]}]], "Output",
 ImageSize->{270, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->336426144]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2932358],

Cell["Expand under specified assumptions:", "ExampleText",
 CellID->645373889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"E", "^", "x"}], ")"}], "^", "y"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"4", "<", 
     RowBox[{"Im", "[", "x", "]"}], "<", "5"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220403285],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "y"}], "+", 
   RowBox[{"x", " ", "y"}]}]]], "Output",
 ImageSize->{61, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->721596395]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", " ", "b"}], ")"}], "^", "c"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"3", "<", "a", "<", "5"}], "&&", 
     RowBox[{
      RowBox[{"-", "2"}], "<", "b", "<", 
      RowBox[{"-", "1"}]}], "&&", 
     RowBox[{"7", "<", "c", "<", "9"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->256026203],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "8"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
  RowBox[{"c", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", "a", "]"}], "+", 
     RowBox[{"Log", "[", "b", "]"}]}], ")"}]}]}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92701269]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->405446677],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " performs expansions valid under the given assumptions:"
}], "ExampleText",
 CellID->223835316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"z", "^", "p"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "p"}], ")"}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"0", "<", "p", "<", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->468257446],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222160313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->611877321],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " gives general expansion formulas:"
}], "ExampleText",
 CellID->980707248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"z", "^", "p"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "p"}], ")"}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453259937],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   FractionBox[
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
     RowBox[{"Floor", "[", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       FractionBox[
        RowBox[{"Im", "[", 
         RowBox[{"p", " ", 
          RowBox[{"Log", "[", "z", "]"}]}], "]"}], 
        RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "p"]], " ", "z"}]], "Output",\

 ImageSize->{155, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17496958]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->290630403],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " perform expansions valid under the given assumptions:"
}], "ExampleText",
 CellID->98361846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"z", "^", "p"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "p"}], ")"}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"0", "<", "p", "<", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20818060],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->849690221]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"z", "^", "p"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "p"}], ")"}]}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"1", "/", "p"}], ",", "Integers"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->182547457],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235879196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->986618949],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to get a different representation of ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SuperscriptBox["z", "2"]], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->9892211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"z", "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62271282],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], " ", 
  SqrtBox[
   RowBox[{"\[ImaginaryI]", " ", "z"}]]}]], "Output",
 ImageSize->{85, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323444761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37343190],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " to represent the result as a piecewise function:"
}], "ExampleText",
 CellID->14722005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"PowerExpand", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"z", "^", "2"}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "Pi"}], "<", 
     RowBox[{"Arg", "[", "z", "]"}], "\[LessEqual]", "Pi"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13019640],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1V81OAjEQLuwuKFFJEPEHVDDBHxIx0RfwJCcvPoAJMSZ4MBIkyo2r8cKR
R+AmJ88+Ao/BY9S227pldmqrgSZL2+nM983MttPlutlt3T82uw93zXKj02y3
Hu6ey1dPHSbyEoSQT/ZUtwgbUzYSzyelrPf4r9/r9b5Em06nH5Hc6/f7VDQy
RqUp9hMwsA3WeyRcD2SfJHJAwpZkQ5/1L0Ykwk2patymILR+pNLKPE9KHl3W
Q/nSQGvThSnmnxvXEtByigrlCn7Pnx9hEDQinh/fHElMauYKkLeTlAwhhWhS
olY4Ejd4RXH3YjHA/L4Z7dJM6R1dxXfuYqWh38PhcDQa8eEpkil9vivzcmjR
q0q9QGOJuOux/JWB/VFM4xho6MjtdnswGPDhmabFX2sFw9XWT8C6j+aqvhBU
nmu+O/eB9ZGUQ9QARbkBXMsYtza/dPLt1oLSQK1WpefnQBuecIhWk3ZbRtT4
ib+g4Um1YdfBvIByqEoBK1xWzNl9I++Gorgr2Fyz416kgZ4H9AKLlykLT6Dx
RH6a+RJolFnA6prDmtQrmt/PzFkt0qiKKq95D+8XG2/OgJOR/bbRH56jUswv
eDZyUtN2ZvJWpAyYKx/w01Wm2P2jvks8dZ9EjDT8IoFVNg/mtjhSc+ItYTxo
lK73N+BVLmrVbx6xL84bt4xUtGy7sOrViCDVCeZgZ8747lHB3Khd8/+9vDMX
VLcIDoDWCpjDb/B1Gp6j3T/aqbqYirzwx+NxX7TJZKLqwhqdrXcXBnlV4IT/
j0jiG03vAAk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{181, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309464817]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"PowerExpand", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "Pi"}], "<", 
      RowBox[{"Arg", "[", "x", "]"}], "\[LessEqual]", "Pi"}], "&&", 
     RowBox[{
      RowBox[{"-", "Pi"}], "<", 
      RowBox[{"Arg", "[", "y", "]"}], "\[LessEqual]", "Pi"}]}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->140272374],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     RowBox[{
      RowBox[{"-", 
       SqrtBox["x"]}], " ", 
      SqrtBox["y"]}], 
     RowBox[{
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"Arg", "[", "x", "]"}], "\[Pi]"], "+", 
        FractionBox[
         RowBox[{"Arg", "[", "y", "]"}], "\[Pi]"]}], ">", "1"}], "||", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"Arg", "[", "x", "]"}], "\[Pi]"], "+", 
        FractionBox[
         RowBox[{"Arg", "[", "y", "]"}], "\[Pi]"]}], "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]},
    {
     RowBox[{
      SqrtBox["x"], " ", 
      SqrtBox["y"]}], 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{317, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->330657842]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->657013885],

Cell[TextData[{
 "The result given by ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " may be incorrect:"
}], "ExampleText",
 CellID->347645142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], "^", "2"}], "]"}], "+", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "-", "x"}], ")"}], "^", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153568431],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50219957]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], "^", "2"}], "]"}], "+", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "-", "x"}], ")"}], "^", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->315353587],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "y"}], ")"}], "2"]]}]], "Output",
 ImageSize->{79, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->206111089]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12415],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Distribute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Distribute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Refine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refine"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23714]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29967],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->4683],

Cell[TextData[ButtonBox["Structural Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnPolynomials"]], "Tutorials",
 CellID->13460]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->57170817],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->330045911],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->660488818]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PowerExpand - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 25.8886488}", "context" -> "System`", 
    "keywords" -> {
     "arc trig expansion", "distribution", "expansion", "exponent law", 
      "exponents", "index law", "logarithm expansion", "logarithms", 
      "polynomial power", "radicals", "roots of polynomial", "simplification",
       "square roots", "surd"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PowerExpand[expr] expands all powers of products and powers. \
PowerExpand[expr, {x_1, x_2, ...}] expands only with respect to the variables \
x_i.", "synonyms" -> {"power expand"}, "title" -> "PowerExpand", "type" -> 
    "Symbol", "uri" -> "ref/PowerExpand"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13534, 396, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->54362084]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 56047, 2082}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3006, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3629, 93, 4195, 83, 70, "ObjectNameGrid"],
Cell[7827, 178, 1237, 39, 70, "Usage",
 CellID->30148]
}, Open  ]],
Cell[CellGroupData[{
Cell[9101, 222, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9579, 239, 569, 23, 70, "Notes",
 CellID->25070],
Cell[10151, 264, 579, 23, 70, "Notes",
 CellID->1496],
Cell[10733, 289, 474, 17, 70, "Notes",
 CellID->6693],
Cell[11210, 308, 608, 25, 70, "Notes",
 CellID->18703],
Cell[11821, 335, 307, 8, 70, "Notes",
 CellID->674115380],
Cell[12131, 345, 398, 11, 70, "Notes",
 CellID->82730543],
Cell[12532, 358, 481, 15, 70, "Notes",
 CellID->23692],
Cell[13016, 375, 481, 16, 70, "Notes",
 CellID->20363]
}, Closed]],
Cell[CellGroupData[{
Cell[13534, 396, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->54362084],
Cell[CellGroupData[{
Cell[13918, 410, 147, 5, 70, "ExampleSection",
 CellID->56567838],
Cell[14068, 417, 113, 3, 70, "ExampleText",
 CellID->60343711],
Cell[CellGroupData[{
Cell[14206, 424, 162, 5, 28, "Input",
 CellID->266114012],
Cell[14371, 431, 204, 8, 38, "Output",
 CellID->420432473]
}, Open  ]],
Cell[14590, 442, 219, 8, 70, "ExampleText",
 CellID->599153328],
Cell[CellGroupData[{
Cell[14834, 454, 123, 4, 28, "Input",
 CellID->737233742],
Cell[14960, 460, 191, 7, 38, "Output",
 CellID->12407167]
}, Open  ]],
Cell[15166, 470, 103, 2, 70, "ExampleText",
 CellID->277360666],
Cell[CellGroupData[{
Cell[15294, 476, 381, 16, 70, "Input",
 CellID->122276137],
Cell[15678, 494, 245, 10, 43, "Output",
 CellID->77276]
}, Open  ]],
Cell[15938, 507, 81, 1, 70, "ExampleText",
 CellID->59662838],
Cell[CellGroupData[{
Cell[16044, 512, 230, 7, 70, "Input",
 CellID->470035547],
Cell[16277, 521, 581, 19, 45, "Output",
 CellID->27166956]
}, Open  ]],
Cell[16873, 543, 105, 2, 70, "ExampleText",
 CellID->613697788],
Cell[CellGroupData[{
Cell[17003, 549, 451, 14, 70, "Input",
 CellID->574175268],
Cell[17457, 565, 223, 9, 38, "Output",
 CellID->324047055]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17729, 580, 216, 7, 70, "ExampleSection",
 CellID->1667],
Cell[17948, 589, 121, 3, 70, "ExampleText",
 CellID->589416271],
Cell[CellGroupData[{
Cell[18094, 596, 179, 6, 70, "Input",
 CellID->146254729],
Cell[18276, 604, 228, 8, 36, "Output",
 CellID->425842857]
}, Open  ]],
Cell[18519, 615, 124, 3, 70, "ExampleDelimiter",
 CellID->24315080],
Cell[18646, 620, 98, 1, 70, "ExampleText",
 CellID->408429242],
Cell[CellGroupData[{
Cell[18769, 625, 248, 8, 70, "Input",
 CellID->141565159],
Cell[19020, 635, 626, 19, 45, "Output",
 CellID->192883677]
}, Open  ]],
Cell[19661, 657, 125, 3, 70, "ExampleDelimiter",
 CellID->398623554],
Cell[19789, 662, 115, 3, 70, "ExampleText",
 CellID->118276975],
Cell[CellGroupData[{
Cell[19929, 669, 162, 5, 70, "Input",
 CellID->856157745],
Cell[20094, 676, 158, 5, 36, "Output",
 CellID->306739477]
}, Open  ]],
Cell[CellGroupData[{
Cell[20289, 686, 179, 6, 70, "Input",
 CellID->181187712],
Cell[20471, 694, 204, 7, 36, "Output",
 CellID->110968928]
}, Open  ]],
Cell[20690, 704, 125, 3, 70, "ExampleDelimiter",
 CellID->278267171],
Cell[20818, 709, 87, 1, 70, "ExampleText",
 CellID->2549192],
Cell[CellGroupData[{
Cell[20930, 714, 229, 7, 70, "Input",
 CellID->44081980],
Cell[21162, 723, 421, 14, 44, "Output",
 CellID->308239932]
}, Open  ]],
Cell[CellGroupData[{
Cell[21620, 742, 248, 8, 70, "Input",
 CellID->340495029],
Cell[21871, 752, 579, 18, 45, "Output",
 CellID->104112971]
}, Open  ]],
Cell[22465, 773, 125, 3, 70, "ExampleDelimiter",
 CellID->120434263],
Cell[22593, 778, 124, 3, 70, "ExampleText",
 CellID->18049444],
Cell[CellGroupData[{
Cell[22742, 785, 160, 5, 70, "Input",
 CellID->94756105],
Cell[22905, 792, 204, 7, 36, "Output",
 CellID->25660398]
}, Open  ]],
Cell[CellGroupData[{
Cell[23146, 804, 161, 5, 70, "Input",
 CellID->113356047],
Cell[23310, 811, 210, 7, 36, "Output",
 CellID->500352673]
}, Open  ]],
Cell[23535, 821, 124, 3, 70, "ExampleDelimiter",
 CellID->12133134],
Cell[23662, 826, 98, 1, 70, "ExampleText",
 CellID->30134189],
Cell[CellGroupData[{
Cell[23785, 831, 229, 7, 70, "Input",
 CellID->368314563],
Cell[24017, 840, 440, 14, 52, "Output",
 CellID->87859265]
}, Open  ]],
Cell[CellGroupData[{
Cell[24494, 859, 229, 7, 70, "Input",
 CellID->119226759],
Cell[24726, 868, 528, 17, 52, "Output",
 CellID->236975212]
}, Open  ]],
Cell[25269, 888, 125, 3, 70, "ExampleDelimiter",
 CellID->233931506],
Cell[25397, 893, 127, 3, 70, "ExampleText",
 CellID->355244445],
Cell[CellGroupData[{
Cell[25549, 900, 161, 5, 70, "Input",
 CellID->611488183],
Cell[25713, 907, 240, 8, 36, "Output",
 CellID->19146642]
}, Open  ]],
Cell[25968, 918, 124, 3, 70, "ExampleDelimiter",
 CellID->31081062],
Cell[26095, 923, 112, 3, 70, "ExampleText",
 CellID->144466150],
Cell[CellGroupData[{
Cell[26232, 930, 228, 7, 70, "Input",
 CellID->37930650],
Cell[26463, 939, 579, 18, 52, "Output",
 CellID->36668294]
}, Open  ]],
Cell[27057, 960, 125, 3, 70, "ExampleDelimiter",
 CellID->205200572],
Cell[27185, 965, 124, 3, 70, "ExampleText",
 CellID->600954242],
Cell[CellGroupData[{
Cell[27334, 972, 170, 5, 70, "Input",
 CellID->33415287],
Cell[27507, 979, 157, 5, 36, "Output",
 CellID->71873400]
}, Open  ]],
Cell[27679, 987, 86, 1, 70, "ExampleText",
 CellID->107705325],
Cell[CellGroupData[{
Cell[27790, 992, 239, 7, 70, "Input",
 CellID->670622526],
Cell[28032, 1001, 1075, 34, 60, "Output",
 CellID->50228112]
}, Open  ]],
Cell[29122, 1038, 103, 2, 70, "ExampleText",
 CellID->42804783],
Cell[CellGroupData[{
Cell[29250, 1044, 271, 8, 70, "Input",
 CellID->20127987],
Cell[29524, 1054, 205, 7, 49, "Output",
 CellID->983623145]
}, Open  ]],
Cell[29744, 1064, 125, 3, 70, "ExampleDelimiter",
 CellID->310803813],
Cell[29872, 1069, 75, 1, 70, "ExampleText",
 CellID->80042935],
Cell[CellGroupData[{
Cell[29972, 1074, 229, 7, 70, "Input",
 CellID->311009832],
Cell[30204, 1083, 558, 18, 52, "Output",
 CellID->572980772]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30811, 1107, 239, 7, 70, "ExampleSection",
 CellID->29772],
Cell[31053, 1116, 178, 7, 70, "ExampleText",
 CellID->133452789],
Cell[CellGroupData[{
Cell[31256, 1127, 321, 11, 70, "Input",
 CellID->251112213],
Cell[31580, 1140, 265, 11, 38, "Output",
 CellID->20793092]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31894, 1157, 221, 7, 70, "ExampleSection",
 CellID->41504786],
Cell[CellGroupData[{
Cell[32140, 1168, 232, 7, 70, "ExampleSubsection",
 CellID->185520762],
Cell[32375, 1177, 380, 12, 70, "ExampleText",
 CellID->150485188],
Cell[CellGroupData[{
Cell[32780, 1193, 162, 5, 70, "Input",
 CellID->270690176],
Cell[32945, 1200, 158, 5, 36, "Output",
 CellID->382554095]
}, Open  ]],
Cell[CellGroupData[{
Cell[33140, 1210, 247, 9, 70, "Input",
 CellID->120356315],
Cell[33390, 1221, 221, 8, 36, "Output",
 CellID->11975485]
}, Open  ]],
Cell[33626, 1232, 124, 3, 70, "ExampleDelimiter",
 CellID->34033169],
Cell[33753, 1237, 138, 4, 70, "ExampleText",
 CellID->744001761],
Cell[CellGroupData[{
Cell[33916, 1245, 252, 8, 70, "Input",
 CellID->630949011],
Cell[34171, 1255, 175, 6, 36, "Output",
 CellID->220593257]
}, Open  ]],
Cell[34361, 1264, 125, 3, 70, "ExampleDelimiter",
 CellID->802104141],
Cell[34489, 1269, 474, 17, 70, "ExampleText",
 CellID->39780376],
Cell[CellGroupData[{
Cell[34988, 1290, 230, 7, 70, "Input",
 CellID->399309604],
Cell[35221, 1299, 419, 14, 44, "Output",
 CellID->7549008]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[35701, 1320, 227, 7, 70, "ExampleSection",
 CellID->107209393],
Cell[35931, 1329, 84, 1, 70, "ExampleText",
 CellID->477769941],
Cell[CellGroupData[{
Cell[36040, 1334, 248, 8, 70, "Input",
 CellID->112719979],
Cell[36291, 1344, 489, 15, 45, "Output",
 CellID->302918029]
}, Open  ]],
Cell[CellGroupData[{
Cell[36817, 1364, 309, 10, 70, "Input",
 CellID->197088621],
Cell[37129, 1376, 847, 27, 45, "Output",
 CellID->336426144]
}, Open  ]],
Cell[37991, 1406, 123, 3, 70, "ExampleDelimiter",
 CellID->2932358],
Cell[38117, 1411, 78, 1, 70, "ExampleText",
 CellID->645373889],
Cell[CellGroupData[{
Cell[38220, 1416, 312, 10, 70, "Input",
 CellID->220403285],
Cell[38535, 1428, 322, 10, 38, "Output",
 CellID->721596395]
}, Open  ]],
Cell[CellGroupData[{
Cell[38894, 1443, 468, 15, 70, "Input",
 CellID->256026203],
Cell[39365, 1460, 386, 13, 36, "Output",
 CellID->92701269]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39800, 1479, 237, 7, 70, "ExampleSection",
 CellID->405446677],
Cell[40040, 1488, 238, 7, 70, "ExampleText",
 CellID->223835316],
Cell[CellGroupData[{
Cell[40303, 1499, 331, 11, 70, "Input",
 CellID->468257446],
Cell[40637, 1512, 158, 5, 36, "Output",
 CellID->222160313]
}, Open  ]],
Cell[40810, 1520, 125, 3, 70, "ExampleDelimiter",
 CellID->611877321],
Cell[40938, 1525, 462, 17, 70, "ExampleText",
 CellID->980707248],
Cell[CellGroupData[{
Cell[41425, 1546, 299, 10, 70, "Input",
 CellID->453259937],
Cell[41727, 1558, 553, 18, 56, "Output",
 CellID->17496958]
}, Open  ]],
Cell[42295, 1579, 125, 3, 70, "ExampleDelimiter",
 CellID->290630403],
Cell[42423, 1584, 355, 12, 70, "ExampleText",
 CellID->98361846],
Cell[CellGroupData[{
Cell[42803, 1600, 325, 11, 70, "Input",
 CellID->20818060],
Cell[43131, 1613, 158, 5, 36, "Output",
 CellID->849690221]
}, Open  ]],
Cell[CellGroupData[{
Cell[43326, 1623, 346, 12, 70, "Input",
 CellID->182547457],
Cell[43675, 1637, 158, 5, 36, "Output",
 CellID->235879196]
}, Open  ]],
Cell[43848, 1645, 125, 3, 70, "ExampleDelimiter",
 CellID->986618949],
Cell[43976, 1650, 343, 13, 70, "ExampleText",
 CellID->9892211],
Cell[CellGroupData[{
Cell[44344, 1667, 164, 5, 70, "Input",
 CellID->62271282],
Cell[44511, 1674, 296, 11, 38, "Output",
 CellID->323444761]
}, Open  ]],
Cell[44822, 1688, 124, 3, 70, "ExampleDelimiter",
 CellID->37343190],
Cell[44949, 1693, 248, 8, 70, "ExampleText",
 CellID->14722005],
Cell[CellGroupData[{
Cell[45222, 1705, 448, 14, 70, "Input",
 CellID->13019640],
Cell[45673, 1721, 1017, 21, 70, "Output",
 Evaluatable->False,
 CellID->309464817]
}, Open  ]],
Cell[CellGroupData[{
Cell[46727, 1747, 583, 18, 70, "Input",
 CellID->140272374],
Cell[47313, 1767, 1420, 47, 64, "Output",
 CellID->330657842]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48782, 1820, 230, 7, 70, "ExampleSection",
 CellID->657013885],
Cell[49015, 1829, 475, 17, 70, "ExampleText",
 CellID->347645142],
Cell[CellGroupData[{
Cell[49515, 1850, 350, 12, 70, "Input",
 CellID->153568431],
Cell[49868, 1864, 157, 5, 36, "Output",
 CellID->50219957]
}, Open  ]],
Cell[CellGroupData[{
Cell[50062, 1874, 347, 12, 70, "Input",
 CellID->315353587],
Cell[50412, 1888, 268, 10, 45, "Output",
 CellID->206111089]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50741, 1905, 311, 9, 70, "SeeAlsoSection",
 CellID->12415],
Cell[51055, 1916, 2178, 80, 70, "SeeAlso",
 CellID->23714]
}, Open  ]],
Cell[CellGroupData[{
Cell[53270, 2001, 314, 9, 70, "TutorialsSection",
 CellID->29967],
Cell[53587, 2012, 189, 4, 70, "Tutorials",
 CellID->4683],
Cell[53779, 2018, 183, 4, 70, "Tutorials",
 CellID->13460]
}, Open  ]],
Cell[CellGroupData[{
Cell[53999, 2027, 318, 9, 70, "MoreAboutSection",
 CellID->57170817],
Cell[54320, 2038, 161, 3, 70, "MoreAbout",
 CellID->330045911],
Cell[54484, 2043, 151, 3, 70, "MoreAbout",
 CellID->660488818]
}, Open  ]],
Cell[54650, 2049, 50, 0, 70, "History"],
Cell[54703, 2051, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

