(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22021,        803]
NotebookOptionsPosition[     17277,        640]
NotebookOutlinePosition[     18688,        679]
CellTagsIndexPosition[     18603,        674]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mod" :> Documentation`HelpLookup["paclet:ref/Mod"], "Power" :> 
          Documentation`HelpLookup["paclet:ref/Power"], "PowerModList" :> 
          Documentation`HelpLookup["paclet:ref/PowerModList"], "ExtendedGCD" :> 
          Documentation`HelpLookup["paclet:ref/ExtendedGCD"], 
          "MultiplicativeOrder" :> 
          Documentation`HelpLookup["paclet:ref/MultiplicativeOrder"], 
          "EulerPhi" :> Documentation`HelpLookup["paclet:ref/EulerPhi"], 
          "PrimitiveRoot" :> 
          Documentation`HelpLookup["paclet:ref/PrimitiveRoot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mod\"\>", 2->"\<\"Power\"\>", 
       3->"\<\"PowerModList\"\>", 4->"\<\"ExtendedGCD\"\>", 
       5->"\<\"MultiplicativeOrder\"\>", 6->"\<\"EulerPhi\"\>", 
       7->"\<\"PrimitiveRoot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Diophantine Equations" :> 
          Documentation`HelpLookup["paclet:guide/DiophantineEquations"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Diophantine Equations\"\>", 3->"\<\"Integer Functions\"\>", 
       4->"\<\"Number Theoretic Functions\"\>", 
       5->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PowerMod", "ObjectName",
 CellID->21756],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PowerMod",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PowerMod"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      RowBox[{
       SuperscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["b", "TI"]], " ", "mod", " ", 
       StyleBox["m", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PowerMod",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PowerMod"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        RowBox[{"-", "1"}], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the modular inverse of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " modulo ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PowerMod",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PowerMod"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        RowBox[{"1", "/", 
         StyleBox["r", "TI"]}], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the smallest modular root of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->15635]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 "For positive ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PowerMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerMod"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " gives the same result as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["a", "TI"], "^", 
     StyleBox["b", "TI"]}], ",", " ", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " but is much more efficient. "
}], "Notes",
 CellID->2199],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PowerMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerMod"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 "allows negative and rational values of ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ". It returns unevaluated if the corresponding modular inverse or root does \
not exist."
}], "Notes",
 CellID->107907454],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerMod"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->78335997]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14336565],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->73325231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"2", ",", "10", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4410],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10263]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"2", "^", "10"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31074],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22092]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14881],

Cell["Compute the multiplicative inverse of 3 modulo 7:", "ExampleText",
 CellID->12948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", 
   RowBox[{"-", "1"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12040],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18424]
}, Open  ]],

Cell["Check the result:", "ExampleText",
 CellID->21301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"3", " ", "5"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27781],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30293],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerMod"]], "InlineFormula"],
 " works with numbers of any size, and does not need to compute the explicit \
power:"
}], "ExampleText",
 CellID->25896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"2", ",", 
   RowBox[{"10", "^", "9"}], ",", "18"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14020],

Cell[BoxData["16"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18455],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerMod"]], "InlineFormula"],
 " automatically threads itself over lists:"
}], "ExampleText",
 CellID->20979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11", ",", "12", ",", "13", ",", "14"}], "}"}], ",", 
   "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25978],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "3", ",", "1", ",", "2", ",", "4"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22014]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"2", ",", 
   RowBox[{"1", "/", "2"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30111],

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerMod", "::", "\<\"root\"\>"}], ":", 
  " ", "\<\"The equation x^\\!\\(2\\) = \\!\\(2\\) (mod \\!\\(5\\)) has no \
integer solutions.\"\>"}]], "Message", "MSG",
 CellID->344917119],

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"2", ",", 
   FractionBox["1", "2"], ",", "5"}], "]"}]], "Output",
 ImageSize->{122, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299349603]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21562],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerModList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerModList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExtendedGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExtendedGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultiplicativeOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiplicativeOrder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerPhi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimitiveRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimitiveRoot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9354]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27213],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->11508]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->118955937],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->447519944],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "MoreAbout",
 CellID->491591027],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->227830393],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->765767070],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->28195439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with PowerMod",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=PowerMod"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
PowerMod"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PowerMod - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 27.5449412}", "context" -> "System`", 
    "keywords" -> {
     "finite fields", "inverses in finite fields", "modular inverses", 
      "modular powers", "powers in finite fields"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PowerMod[a, b, m] gives a^b mod m. PowerMod[a, -1, m] finds the modular \
inverse of a modulo m. PowerMod[a, 1/r, m] finds the smallest modular root of \
a.", "synonyms" -> {"power mod"}, "title" -> "PowerMod", "type" -> "Symbol", 
    "uri" -> "ref/PowerMod"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7583, 243, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->14336565]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18461, 667}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3081, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3704, 94, 46, 1, 70, "ObjectName",
 CellID->21756],
Cell[3753, 97, 1751, 59, 70, "Usage",
 CellID->15635]
}, Open  ]],
Cell[CellGroupData[{
Cell[5541, 161, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6019, 178, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[6154, 184, 695, 27, 70, "Notes",
 CellID->2199],
Cell[6852, 213, 487, 16, 70, "Notes",
 CellID->107907454],
Cell[7342, 231, 204, 7, 70, "Notes",
 CellID->78335997]
}, Closed]],
Cell[CellGroupData[{
Cell[7583, 243, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14336565],
Cell[CellGroupData[{
Cell[7967, 257, 147, 5, 70, "ExampleSection",
 CellID->73325231],
Cell[CellGroupData[{
Cell[8139, 266, 133, 4, 28, "Input",
 CellID->4410],
Cell[8275, 272, 154, 5, 36, "Output",
 CellID->10263]
}, Open  ]],
Cell[CellGroupData[{
Cell[8466, 282, 143, 5, 28, "Input",
 CellID->31074],
Cell[8612, 289, 154, 5, 36, "Output",
 CellID->22092]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8815, 300, 216, 7, 70, "ExampleSection",
 CellID->14881],
Cell[9034, 309, 88, 1, 70, "ExampleText",
 CellID->12948],
Cell[CellGroupData[{
Cell[9147, 314, 152, 5, 70, "Input",
 CellID->12040],
Cell[9302, 321, 154, 5, 36, "Output",
 CellID->18424]
}, Open  ]],
Cell[9471, 329, 56, 1, 70, "ExampleText",
 CellID->21301],
Cell[CellGroupData[{
Cell[9552, 334, 142, 5, 70, "Input",
 CellID->27781],
Cell[9697, 341, 154, 5, 36, "Output",
 CellID->30702]
}, Open  ]],
Cell[9866, 349, 121, 3, 70, "ExampleDelimiter",
 CellID->30293],
Cell[9990, 354, 256, 8, 70, "ExampleText",
 CellID->25896],
Cell[CellGroupData[{
Cell[10271, 366, 159, 5, 70, "Input",
 CellID->14020],
Cell[10433, 373, 154, 5, 36, "Output",
 CellID->4901]
}, Open  ]],
Cell[10602, 381, 121, 3, 70, "ExampleDelimiter",
 CellID->18455],
Cell[10726, 386, 214, 7, 70, "ExampleText",
 CellID->20979],
Cell[CellGroupData[{
Cell[10965, 397, 221, 7, 70, "Input",
 CellID->25978],
Cell[11189, 406, 229, 7, 36, "Output",
 CellID->22014]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11467, 419, 226, 7, 70, "ExampleSection",
 CellID->27629],
Cell[CellGroupData[{
Cell[11718, 430, 157, 5, 70, "Input",
 CellID->30111],
Cell[11878, 437, 218, 5, 70, "Message",
 CellID->344917119],
Cell[12099, 444, 248, 8, 51, "Output",
 CellID->299349603]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12408, 459, 311, 9, 70, "SeeAlsoSection",
 CellID->21562],
Cell[12722, 470, 1705, 62, 70, "SeeAlso",
 CellID->9354]
}, Open  ]],
Cell[CellGroupData[{
Cell[14464, 537, 314, 9, 70, "TutorialsSection",
 CellID->27213],
Cell[14781, 548, 198, 4, 70, "Tutorials",
 CellID->11508]
}, Open  ]],
Cell[CellGroupData[{
Cell[15016, 557, 319, 9, 70, "MoreAboutSection",
 CellID->118955937],
Cell[15338, 568, 164, 3, 70, "MoreAbout",
 CellID->447519944],
Cell[15505, 573, 153, 3, 70, "MoreAbout",
 CellID->491591027],
Cell[15661, 578, 145, 3, 70, "MoreAbout",
 CellID->227830393],
Cell[15809, 583, 162, 3, 70, "MoreAbout",
 CellID->765767070],
Cell[15974, 588, 136, 3, 70, "MoreAbout",
 CellID->28195439]
}, Open  ]],
Cell[CellGroupData[{
Cell[16147, 596, 305, 8, 70, "RelatedLinksSection"],
Cell[16455, 606, 361, 12, 70, "RelatedLinks"],
Cell[16819, 620, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[17220, 636, 27, 0, 70, "History"],
Cell[17250, 638, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

