(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21719,        873]
NotebookOptionsPosition[     15807,        664]
NotebookOutlinePosition[     17069,        700]
CellTagsIndexPosition[     16984,        695]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Forms of Assignment" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialFormsOfAssignment"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Special Forms of Assignment\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Decrement" :> Documentation`HelpLookup["paclet:ref/Decrement"],
           "SubtractFrom" :> 
          Documentation`HelpLookup["paclet:ref/SubtractFrom"], "PreIncrement" :> 
          Documentation`HelpLookup["paclet:ref/PreIncrement"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Decrement\"\>", 2->"\<\"SubtractFrom\"\>", 
       3->"\<\"PreIncrement\"\>", 4->"\<\"Set\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "PreDecrement ",
 StyleBox["(--)", "OperatorCharacter"]
}], "ObjectName",
 CellID->558],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"--", 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]decreases the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " by 1, returning the new value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6914]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PreDecrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreDecrement"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23130],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"--", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   RowBox[{
    StyleBox["x", "TI"], "-", "1"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9479]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->315229323],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->102286366],

Cell["Decrement the value by one and return the new value:", "ExampleText",
 CellID->124849650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", "1"}], ";", 
  RowBox[{"--", "k"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74484254],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->363715042]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["k"], "Input",
 CellLabel->"In[2]:=",
 CellID->253454867],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->269664056]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21660],

Cell["Decrement a numerical value:", "ExampleText",
 CellID->1113876286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "1.5"}], ";", " ", 
  RowBox[{"--", "x"}], ";", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1774324750],

Cell[BoxData["0.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->544631502]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206580424],

Cell["Decrement a symbolic value:", "ExampleText",
 CellID->838884225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", "a"}], ";", 
  RowBox[{"--", "v"}], ";", "v"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1698859122],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "a"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59422171]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2063940682],

Cell["Decrement all values in a list:", "ExampleText",
 CellID->822015323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2332824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221750363]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"--", "x"}], ";", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1729906436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->423285328]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4282],

Cell["\<\
Find the first integer below one million with a certain property:\
\>", "ExampleText",
 CellID->2078680352],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{"10", "^", "6"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"PrimeQ", "[", 
      RowBox[{"--", "i"}], "]"}]}], ",", "Null"}], "]"}], 
  ";"}], "\n", "i"}], "Input",
 CellLabel->"In[1]:=",
 CellID->84768696],

Cell[BoxData["999983"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->365358590]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17065],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Decrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decrement"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PreDecrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreDecrement"]], "InlineFormula"],
 " differ in the return value of the operation:"
}], "ExampleText",
 CellID->440092738],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->550656451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "--"}], ",", 
   RowBox[{"--", "b"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->532828009],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->527133511]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->195309579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->54206364]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->300188328],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PreDecrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreDecrement"]], "InlineFormula"],
 " is a short form of this assignment:"
}], "ExampleText",
 CellID->2065810971],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "=", 
  RowBox[{"k", "-", "1"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1887499219],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124022163]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->607562233],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PreDecrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreDecrement"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["SubtractFrom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubtractFrom"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1728269985],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "-=", "1"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->683214900],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->389865531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->224632663],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Increment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Increment"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PreIncrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreIncrement"]], "InlineFormula"],
 " are closely related operations:"
}], "ExampleText",
 CellID->73150939],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634282679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "++"}], ",", 
   RowBox[{"++", "b"}], ",", 
   RowBox[{"c", "--"}], ",", 
   RowBox[{"--", "d"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->463191000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->237026731]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->95912239],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->267265754]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29881],

Cell["A variable to be decremented must have an initial value:", "ExampleText",
 CellID->992262862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"--", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1397421414],

Cell[BoxData[
 RowBox[{
  RowBox[{"PreDecrement", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\(x\\) is not a variable with a value, so its value cannot be \
changed.\"\>"}]], "Message", "MSG",
 CellID->41340597],

Cell[BoxData[
 RowBox[{"--", "x"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->796724619]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15651],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decrement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Decrement"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubtractFrom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubtractFrom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PreIncrement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreIncrement"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17554]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30803],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "Tutorials",
 CellID->15399]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PreDecrement (--) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 43.8422334}", "context" -> "System`", 
    "keywords" -> {"--", "pre-decrement", "predecrement"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "--x decreases the value of x by 1, returning the new value of x. ", 
    "synonyms" -> {"pre decrement"}, "title" -> "PreDecrement", "type" -> 
    "Symbol", "uri" -> "ref/PreDecrement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3915, 139, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->315229323]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16841, 688}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1494, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2117, 62, 104, 4, 70, "ObjectName",
 CellID->558],
Cell[2224, 68, 543, 18, 70, "Usage",
 CellID->6914]
}, Open  ]],
Cell[CellGroupData[{
Cell[2804, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3282, 108, 318, 12, 70, "Notes",
 CellID->23130],
Cell[3603, 122, 275, 12, 70, "Notes",
 CellID->9479]
}, Closed]],
Cell[CellGroupData[{
Cell[3915, 139, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->315229323],
Cell[CellGroupData[{
Cell[4300, 153, 148, 5, 70, "ExampleSection",
 CellID->102286366],
Cell[4451, 160, 95, 1, 70, "ExampleText",
 CellID->124849650],
Cell[CellGroupData[{
Cell[4571, 165, 133, 5, 28, "Input",
 CellID->74484254],
Cell[4707, 172, 158, 5, 36, "Output",
 CellID->363715042]
}, Open  ]],
Cell[CellGroupData[{
Cell[4902, 182, 70, 2, 28, "Input",
 CellID->253454867],
Cell[4975, 186, 158, 5, 36, "Output",
 CellID->269664056]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5182, 197, 216, 7, 70, "ExampleSection",
 CellID->21660],
Cell[5401, 206, 72, 1, 70, "ExampleText",
 CellID->1113876286],
Cell[CellGroupData[{
Cell[5498, 211, 152, 5, 70, "Input",
 CellID->1774324750],
Cell[5653, 218, 161, 5, 36, "Output",
 CellID->544631502]
}, Open  ]],
Cell[5829, 226, 125, 3, 70, "ExampleDelimiter",
 CellID->206580424],
Cell[5957, 231, 70, 1, 70, "ExampleText",
 CellID->838884225],
Cell[CellGroupData[{
Cell[6052, 236, 145, 5, 70, "Input",
 CellID->1698859122],
Cell[6200, 243, 197, 7, 36, "Output",
 CellID->59422171]
}, Open  ]],
Cell[6412, 253, 126, 3, 70, "ExampleDelimiter",
 CellID->2063940682],
Cell[6541, 258, 74, 1, 70, "ExampleText",
 CellID->822015323],
Cell[CellGroupData[{
Cell[6640, 263, 147, 5, 70, "Input",
 CellID->2332824],
Cell[6790, 270, 213, 7, 36, "Output",
 CellID->221750363]
}, Open  ]],
Cell[CellGroupData[{
Cell[7040, 282, 112, 4, 70, "Input",
 CellID->1729906436],
Cell[7155, 288, 213, 7, 36, "Output",
 CellID->423285328]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7417, 301, 222, 7, 70, "ExampleSection",
 CellID->4282],
Cell[7642, 310, 117, 3, 70, "ExampleText",
 CellID->2078680352],
Cell[CellGroupData[{
Cell[7784, 317, 316, 12, 70, "Input",
 CellID->84768696],
Cell[8103, 331, 163, 5, 36, "Output",
 CellID->365358590]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8315, 342, 233, 7, 70, "ExampleSection",
 CellID->17065],
Cell[8551, 351, 361, 12, 70, "ExampleText",
 CellID->440092738],
Cell[8915, 365, 208, 8, 70, "Input",
 CellID->550656451],
Cell[CellGroupData[{
Cell[9148, 377, 155, 6, 70, "Input",
 CellID->532828009],
Cell[9306, 385, 203, 7, 36, "Output",
 CellID->527133511]
}, Open  ]],
Cell[CellGroupData[{
Cell[9546, 397, 115, 4, 70, "Input",
 CellID->195309579],
Cell[9664, 403, 202, 7, 36, "Output",
 CellID->54206364]
}, Open  ]],
Cell[9881, 413, 125, 3, 70, "ExampleDelimiter",
 CellID->300188328],
Cell[10009, 418, 222, 7, 70, "ExampleText",
 CellID->2065810971],
Cell[CellGroupData[{
Cell[10256, 429, 169, 6, 70, "Input",
 CellID->1887499219],
Cell[10428, 437, 158, 5, 36, "Output",
 CellID->124022163]
}, Open  ]],
Cell[10601, 445, 125, 3, 70, "ExampleDelimiter",
 CellID->607562233],
Cell[10729, 450, 341, 12, 70, "ExampleText",
 CellID->1728269985],
Cell[CellGroupData[{
Cell[11095, 466, 146, 5, 70, "Input",
 CellID->683214900],
Cell[11244, 473, 158, 5, 36, "Output",
 CellID->389865531]
}, Open  ]],
Cell[11417, 481, 125, 3, 70, "ExampleDelimiter",
 CellID->224632663],
Cell[11545, 486, 347, 12, 70, "ExampleText",
 CellID->73150939],
Cell[11895, 500, 248, 8, 70, "Input",
 CellID->634282679],
Cell[CellGroupData[{
Cell[12168, 512, 215, 8, 70, "Input",
 CellID->463191000],
Cell[12386, 522, 223, 7, 36, "Output",
 CellID->237026731]
}, Open  ]],
Cell[CellGroupData[{
Cell[12646, 534, 134, 4, 70, "Input",
 CellID->95912239],
Cell[12783, 540, 223, 7, 36, "Output",
 CellID->267265754]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13055, 553, 226, 7, 70, "ExampleSection",
 CellID->29881],
Cell[13284, 562, 99, 1, 70, "ExampleText",
 CellID->992262862],
Cell[CellGroupData[{
Cell[13408, 567, 89, 3, 70, "Input",
 CellID->1397421414],
Cell[13500, 572, 216, 5, 70, "Message",
 CellID->41340597],
Cell[13719, 579, 176, 6, 36, "Output",
 CellID->796724619]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13956, 592, 311, 9, 70, "SeeAlsoSection",
 CellID->15651],
Cell[14270, 603, 949, 35, 70, "SeeAlso",
 CellID->17554]
}, Open  ]],
Cell[CellGroupData[{
Cell[15256, 643, 314, 9, 70, "TutorialsSection",
 CellID->30803],
Cell[15573, 654, 162, 3, 70, "Tutorials",
 CellID->15399]
}, Open  ]],
Cell[15750, 660, 27, 0, 70, "History"],
Cell[15780, 662, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

